/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



#ifdef GLATTER_GLU
#if defined(__glu_h__)
#if defined(__GLU_H__)
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluBeginCurve, (nobj), (GLUnurbs *nobj))
GLATTER_INLINE_OR_NOT void glatter_gluBeginCurve_debug(GLUnurbs *nobj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluBeginCurve, "(%p)", (void*)nobj)
    glatter_gluBeginCurve(nobj);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluBeginCurve_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluBeginPolygon, (tess), (GLUtesselator *tess))
GLATTER_INLINE_OR_NOT void glatter_gluBeginPolygon_debug(GLUtesselator *tess, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluBeginPolygon, "(%p)", (void*)tess)
    glatter_gluBeginPolygon(tess);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluBeginPolygon_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluBeginSurface, (nobj), (GLUnurbs *nobj))
GLATTER_INLINE_OR_NOT void glatter_gluBeginSurface_debug(GLUnurbs *nobj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluBeginSurface, "(%p)", (void*)nobj)
    glatter_gluBeginSurface(nobj);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluBeginSurface_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluBeginTrim, (nobj), (GLUnurbs *nobj))
GLATTER_INLINE_OR_NOT void glatter_gluBeginTrim_debug(GLUnurbs *nobj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluBeginTrim, "(%p)", (void*)nobj)
    glatter_gluBeginTrim(nobj);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluBeginTrim_defined
GLATTER_FBLOCK(return, GLU, , int, APIENTRY, gluBuild1DMipmaps, (target, components, width, format, type, data), (GLenum target, GLint components, GLint width, GLenum format, GLenum type, const void *data))
GLATTER_INLINE_OR_NOT int glatter_gluBuild1DMipmaps_debug(GLenum target, GLint components, GLint width, GLenum format, GLenum type, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluBuild1DMipmaps, "(%s, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)components, (int)width, enum_to_string_GL(format), enum_to_string_GL(type), (void*)data)
    int rval = glatter_gluBuild1DMipmaps(target, components, width, format, type, data);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluBuild1DMipmaps_defined
GLATTER_FBLOCK(return, GLU, , int, APIENTRY, gluBuild2DMipmaps, (target, components, width, height, format, type, data), (GLenum target, GLint components, GLint width, GLint height, GLenum format, GLenum type, const void *data))
GLATTER_INLINE_OR_NOT int glatter_gluBuild2DMipmaps_debug(GLenum target, GLint components, GLint width, GLint height, GLenum format, GLenum type, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluBuild2DMipmaps, "(%s, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)components, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)data)
    int rval = glatter_gluBuild2DMipmaps(target, components, width, height, format, type, data);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluBuild2DMipmaps_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluCylinder, (qobj, baseRadius, topRadius, height, slices, stacks), (GLUquadric *qobj, GLdouble baseRadius, GLdouble topRadius, GLdouble height, GLint slices, GLint stacks))
GLATTER_INLINE_OR_NOT void glatter_gluCylinder_debug(GLUquadric *qobj, GLdouble baseRadius, GLdouble topRadius, GLdouble height, GLint slices, GLint stacks, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluCylinder, "(%p, %f, %f, %f, %d, %d)", (void*)qobj, (double)baseRadius, (double)topRadius, (double)height, (int)slices, (int)stacks)
    glatter_gluCylinder(qobj, baseRadius, topRadius, height, slices, stacks);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluCylinder_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluDeleteNurbsRenderer, (nobj), (GLUnurbs *nobj))
GLATTER_INLINE_OR_NOT void glatter_gluDeleteNurbsRenderer_debug(GLUnurbs *nobj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluDeleteNurbsRenderer, "(%p)", (void*)nobj)
    glatter_gluDeleteNurbsRenderer(nobj);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluDeleteNurbsRenderer_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluDeleteQuadric, (state), (GLUquadric *state))
GLATTER_INLINE_OR_NOT void glatter_gluDeleteQuadric_debug(GLUquadric *state, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluDeleteQuadric, "(%p)", (void*)state)
    glatter_gluDeleteQuadric(state);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluDeleteQuadric_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluDeleteTess, (tess), (GLUtesselator *tess))
GLATTER_INLINE_OR_NOT void glatter_gluDeleteTess_debug(GLUtesselator *tess, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluDeleteTess, "(%p)", (void*)tess)
    glatter_gluDeleteTess(tess);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluDeleteTess_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluDisk, (qobj, innerRadius, outerRadius, slices, loops), (GLUquadric *qobj, GLdouble innerRadius, GLdouble outerRadius, GLint slices, GLint loops))
GLATTER_INLINE_OR_NOT void glatter_gluDisk_debug(GLUquadric *qobj, GLdouble innerRadius, GLdouble outerRadius, GLint slices, GLint loops, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluDisk, "(%p, %f, %f, %d, %d)", (void*)qobj, (double)innerRadius, (double)outerRadius, (int)slices, (int)loops)
    glatter_gluDisk(qobj, innerRadius, outerRadius, slices, loops);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluDisk_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluEndCurve, (nobj), (GLUnurbs *nobj))
GLATTER_INLINE_OR_NOT void glatter_gluEndCurve_debug(GLUnurbs *nobj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluEndCurve, "(%p)", (void*)nobj)
    glatter_gluEndCurve(nobj);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluEndCurve_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluEndPolygon, (tess), (GLUtesselator *tess))
GLATTER_INLINE_OR_NOT void glatter_gluEndPolygon_debug(GLUtesselator *tess, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluEndPolygon, "(%p)", (void*)tess)
    glatter_gluEndPolygon(tess);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluEndPolygon_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluEndSurface, (nobj), (GLUnurbs *nobj))
GLATTER_INLINE_OR_NOT void glatter_gluEndSurface_debug(GLUnurbs *nobj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluEndSurface, "(%p)", (void*)nobj)
    glatter_gluEndSurface(nobj);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluEndSurface_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluEndTrim, (nobj), (GLUnurbs *nobj))
GLATTER_INLINE_OR_NOT void glatter_gluEndTrim_debug(GLUnurbs *nobj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluEndTrim, "(%p)", (void*)nobj)
    glatter_gluEndTrim(nobj);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluEndTrim_defined
GLATTER_FBLOCK(return, GLU, , const GLubyte*, APIENTRY, gluErrorString, (errCode), (GLenum errCode))
GLATTER_INLINE_OR_NOT const GLubyte* glatter_gluErrorString_debug(GLenum errCode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluErrorString, "(%s)", enum_to_string_GL(errCode))
    const GLubyte* rval = glatter_gluErrorString(errCode);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluErrorString_defined
GLATTER_FBLOCK(return, GLU, , const wchar_t*, APIENTRY, gluErrorUnicodeStringEXT, (errCode), (GLenum errCode))
GLATTER_INLINE_OR_NOT const wchar_t* glatter_gluErrorUnicodeStringEXT_debug(GLenum errCode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluErrorUnicodeStringEXT, "(%s)", enum_to_string_GL(errCode))
    const wchar_t* rval = glatter_gluErrorUnicodeStringEXT(errCode);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluErrorUnicodeStringEXT_defined
GLATTER_FBLOCK(return, GLU, , const GLubyte*, APIENTRY, gluGetString, (name), (GLenum name))
GLATTER_INLINE_OR_NOT const GLubyte* glatter_gluGetString_debug(GLenum name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluGetString, "(%s)", enum_to_string_GL(name))
    const GLubyte* rval = glatter_gluGetString(name);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluGetString_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluGetTessProperty, (tess, which, value), (GLUtesselator *tess, GLenum which, GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_gluGetTessProperty_debug(GLUtesselator *tess, GLenum which, GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluGetTessProperty, "(%p, %s, %p)", (void*)tess, enum_to_string_GL(which), (void*)value)
    glatter_gluGetTessProperty(tess, which, value);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluGetTessProperty_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluLookAt, (eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz), (GLdouble eyex, GLdouble eyey, GLdouble eyez, GLdouble centerx, GLdouble centery, GLdouble centerz, GLdouble upx, GLdouble upy, GLdouble upz))
GLATTER_INLINE_OR_NOT void glatter_gluLookAt_debug(GLdouble eyex, GLdouble eyey, GLdouble eyez, GLdouble centerx, GLdouble centery, GLdouble centerz, GLdouble upx, GLdouble upy, GLdouble upz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluLookAt, "(%f, %f, %f, %f, %f, %f, %f, %f, %f)", (double)eyex, (double)eyey, (double)eyez, (double)centerx, (double)centery, (double)centerz, (double)upx, (double)upy, (double)upz)
    glatter_gluLookAt(eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluLookAt_defined
GLATTER_FBLOCK(return, GLU, , GLUnurbs*, APIENTRY, gluNewNurbsRenderer, (), (void))
GLATTER_INLINE_OR_NOT GLUnurbs* glatter_gluNewNurbsRenderer_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluNewNurbsRenderer, "()")
    GLUnurbs* rval = glatter_gluNewNurbsRenderer();
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluNewNurbsRenderer_defined
GLATTER_FBLOCK(return, GLU, , GLUquadric*, APIENTRY, gluNewQuadric, (), (void))
GLATTER_INLINE_OR_NOT GLUquadric* glatter_gluNewQuadric_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluNewQuadric, "()")
    GLUquadric* rval = glatter_gluNewQuadric();
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluNewQuadric_defined
GLATTER_FBLOCK(return, GLU, , GLUtesselator*, APIENTRY, gluNewTess, (), (void))
GLATTER_INLINE_OR_NOT GLUtesselator* glatter_gluNewTess_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluNewTess, "()")
    GLUtesselator* rval = glatter_gluNewTess();
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluNewTess_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluNextContour, (tess, type), (GLUtesselator *tess, GLenum type))
GLATTER_INLINE_OR_NOT void glatter_gluNextContour_debug(GLUtesselator *tess, GLenum type, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluNextContour, "(%p, %s)", (void*)tess, enum_to_string_GL(type))
    glatter_gluNextContour(tess, type);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluNextContour_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluNurbsCurve, (nobj, nknots, knot, stride, ctlarray, order, type), (GLUnurbs *nobj, GLint nknots, GLfloat *knot, GLint stride, GLfloat *ctlarray, GLint order, GLenum type))
GLATTER_INLINE_OR_NOT void glatter_gluNurbsCurve_debug(GLUnurbs *nobj, GLint nknots, GLfloat *knot, GLint stride, GLfloat *ctlarray, GLint order, GLenum type, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluNurbsCurve, "(%p, %d, %p, %d, %p, %d, %s)", (void*)nobj, (int)nknots, (void*)knot, (int)stride, (void*)ctlarray, (int)order, enum_to_string_GL(type))
    glatter_gluNurbsCurve(nobj, nknots, knot, stride, ctlarray, order, type);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluNurbsCurve_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluOrtho2D, (left, right, bottom, top), (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top))
GLATTER_INLINE_OR_NOT void glatter_gluOrtho2D_debug(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluOrtho2D, "(%f, %f, %f, %f)", (double)left, (double)right, (double)bottom, (double)top)
    glatter_gluOrtho2D(left, right, bottom, top);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluOrtho2D_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluPartialDisk, (qobj, innerRadius, outerRadius, slices, loops, startAngle, sweepAngle), (GLUquadric *qobj, GLdouble innerRadius, GLdouble outerRadius, GLint slices, GLint loops, GLdouble startAngle, GLdouble sweepAngle))
GLATTER_INLINE_OR_NOT void glatter_gluPartialDisk_debug(GLUquadric *qobj, GLdouble innerRadius, GLdouble outerRadius, GLint slices, GLint loops, GLdouble startAngle, GLdouble sweepAngle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluPartialDisk, "(%p, %f, %f, %d, %d, %f, %f)", (void*)qobj, (double)innerRadius, (double)outerRadius, (int)slices, (int)loops, (double)startAngle, (double)sweepAngle)
    glatter_gluPartialDisk(qobj, innerRadius, outerRadius, slices, loops, startAngle, sweepAngle);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluPartialDisk_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluPerspective, (fovy, aspect, zNear, zFar), (GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar))
GLATTER_INLINE_OR_NOT void glatter_gluPerspective_debug(GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluPerspective, "(%f, %f, %f, %f)", (double)fovy, (double)aspect, (double)zNear, (double)zFar)
    glatter_gluPerspective(fovy, aspect, zNear, zFar);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluPerspective_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluPickMatrix, (x, y, width, height, viewport), (GLdouble x, GLdouble y, GLdouble width, GLdouble height, GLint viewport[4]))
GLATTER_INLINE_OR_NOT void glatter_gluPickMatrix_debug(GLdouble x, GLdouble y, GLdouble width, GLdouble height, GLint viewport[4], const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluPickMatrix, "(%f, %f, %f, %f, %s)", (double)x, (double)y, (double)width, (double)height, GET_PRS(viewport))
    glatter_gluPickMatrix(x, y, width, height, viewport);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluPickMatrix_defined
GLATTER_FBLOCK(return, GLU, , int, APIENTRY, gluProject, (objx, objy, objz, modelMatrix, projMatrix, viewport, winx, winy, winz), (GLdouble objx, GLdouble objy, GLdouble objz, const GLdouble modelMatrix[16], const GLdouble projMatrix[16], const GLint viewport[4], GLdouble *winx, GLdouble *winy, GLdouble *winz))
GLATTER_INLINE_OR_NOT int glatter_gluProject_debug(GLdouble objx, GLdouble objy, GLdouble objz, const GLdouble modelMatrix[16], const GLdouble projMatrix[16], const GLint viewport[4], GLdouble *winx, GLdouble *winy, GLdouble *winz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluProject, "(%f, %f, %f, %s, %s, %s, %p, %p, %p)", (double)objx, (double)objy, (double)objz, GET_PRS(modelMatrix), GET_PRS(projMatrix), GET_PRS(viewport), (void*)winx, (void*)winy, (void*)winz)
    int rval = glatter_gluProject(objx, objy, objz, modelMatrix, projMatrix, viewport, winx, winy, winz);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluProject_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluPwlCurve, (nobj, count, array, stride, type), (GLUnurbs *nobj, GLint count, GLfloat *array, GLint stride, GLenum type))
GLATTER_INLINE_OR_NOT void glatter_gluPwlCurve_debug(GLUnurbs *nobj, GLint count, GLfloat *array, GLint stride, GLenum type, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluPwlCurve, "(%p, %d, %p, %d, %s)", (void*)nobj, (int)count, (void*)array, (int)stride, enum_to_string_GL(type))
    glatter_gluPwlCurve(nobj, count, array, stride, type);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluPwlCurve_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluQuadricCallback, (qobj, which, fn), (GLUquadric *qobj, GLenum which, void (CALLBACK* fn)()))
GLATTER_INLINE_OR_NOT void glatter_gluQuadricCallback_debug(GLUquadric *qobj, GLenum which, void (CALLBACK* fn)(), const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluQuadricCallback, "(%p, %s, %p)", (void*)qobj, enum_to_string_GL(which), (void*)fn)
    glatter_gluQuadricCallback(qobj, which, fn);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluQuadricCallback_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluQuadricDrawStyle, (quadObject, drawStyle), (GLUquadric *quadObject, GLenum drawStyle))
GLATTER_INLINE_OR_NOT void glatter_gluQuadricDrawStyle_debug(GLUquadric *quadObject, GLenum drawStyle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluQuadricDrawStyle, "(%p, %s)", (void*)quadObject, enum_to_string_GL(drawStyle))
    glatter_gluQuadricDrawStyle(quadObject, drawStyle);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluQuadricDrawStyle_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluQuadricNormals, (quadObject, normals), (GLUquadric *quadObject, GLenum normals))
GLATTER_INLINE_OR_NOT void glatter_gluQuadricNormals_debug(GLUquadric *quadObject, GLenum normals, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluQuadricNormals, "(%p, %s)", (void*)quadObject, enum_to_string_GL(normals))
    glatter_gluQuadricNormals(quadObject, normals);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluQuadricNormals_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluQuadricOrientation, (quadObject, orientation), (GLUquadric *quadObject, GLenum orientation))
GLATTER_INLINE_OR_NOT void glatter_gluQuadricOrientation_debug(GLUquadric *quadObject, GLenum orientation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluQuadricOrientation, "(%p, %s)", (void*)quadObject, enum_to_string_GL(orientation))
    glatter_gluQuadricOrientation(quadObject, orientation);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluQuadricOrientation_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluQuadricTexture, (quadObject, textureCoords), (GLUquadric *quadObject, GLboolean textureCoords))
GLATTER_INLINE_OR_NOT void glatter_gluQuadricTexture_debug(GLUquadric *quadObject, GLboolean textureCoords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluQuadricTexture, "(%p, %u)", (void*)quadObject, (unsigned char)textureCoords)
    glatter_gluQuadricTexture(quadObject, textureCoords);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluQuadricTexture_defined
GLATTER_FBLOCK(return, GLU, , int, APIENTRY, gluScaleImage, (format, widthin, heightin, typein, datain, widthout, heightout, typeout, dataout), (GLenum format, GLint widthin, GLint heightin, GLenum typein, const void *datain, GLint widthout, GLint heightout, GLenum typeout, void *dataout))
GLATTER_INLINE_OR_NOT int glatter_gluScaleImage_debug(GLenum format, GLint widthin, GLint heightin, GLenum typein, const void *datain, GLint widthout, GLint heightout, GLenum typeout, void *dataout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluScaleImage, "(%s, %d, %d, %s, %p, %d, %d, %s, %p)", enum_to_string_GL(format), (int)widthin, (int)heightin, enum_to_string_GL(typein), (void*)datain, (int)widthout, (int)heightout, enum_to_string_GL(typeout), (void*)dataout)
    int rval = glatter_gluScaleImage(format, widthin, heightin, typein, datain, widthout, heightout, typeout, dataout);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluScaleImage_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluSphere, (qobj, radius, slices, stacks), (GLUquadric *qobj, GLdouble radius, GLint slices, GLint stacks))
GLATTER_INLINE_OR_NOT void glatter_gluSphere_debug(GLUquadric *qobj, GLdouble radius, GLint slices, GLint stacks, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluSphere, "(%p, %f, %d, %d)", (void*)qobj, (double)radius, (int)slices, (int)stacks)
    glatter_gluSphere(qobj, radius, slices, stacks);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluSphere_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluTessBeginContour, (tess), (GLUtesselator *tess))
GLATTER_INLINE_OR_NOT void glatter_gluTessBeginContour_debug(GLUtesselator *tess, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluTessBeginContour, "(%p)", (void*)tess)
    glatter_gluTessBeginContour(tess);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluTessBeginContour_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluTessBeginPolygon, (tess, polygon_data), (GLUtesselator *tess, void *polygon_data))
GLATTER_INLINE_OR_NOT void glatter_gluTessBeginPolygon_debug(GLUtesselator *tess, void *polygon_data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluTessBeginPolygon, "(%p, %p)", (void*)tess, (void*)polygon_data)
    glatter_gluTessBeginPolygon(tess, polygon_data);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluTessBeginPolygon_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluTessCallback, (tess, which, fn), (GLUtesselator *tess, GLenum which, void (CALLBACK *fn)()))
GLATTER_INLINE_OR_NOT void glatter_gluTessCallback_debug(GLUtesselator *tess, GLenum which, void (CALLBACK *fn)(), const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluTessCallback, "(%p, %s, %p)", (void*)tess, enum_to_string_GL(which), (void*)fn)
    glatter_gluTessCallback(tess, which, fn);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluTessCallback_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluTessEndContour, (tess), (GLUtesselator *tess))
GLATTER_INLINE_OR_NOT void glatter_gluTessEndContour_debug(GLUtesselator *tess, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluTessEndContour, "(%p)", (void*)tess)
    glatter_gluTessEndContour(tess);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluTessEndContour_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluTessEndPolygon, (tess), (GLUtesselator *tess))
GLATTER_INLINE_OR_NOT void glatter_gluTessEndPolygon_debug(GLUtesselator *tess, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluTessEndPolygon, "(%p)", (void*)tess)
    glatter_gluTessEndPolygon(tess);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluTessEndPolygon_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluTessNormal, (tess, x, y, z), (GLUtesselator *tess, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_gluTessNormal_debug(GLUtesselator *tess, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluTessNormal, "(%p, %f, %f, %f)", (void*)tess, (double)x, (double)y, (double)z)
    glatter_gluTessNormal(tess, x, y, z);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluTessNormal_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluTessProperty, (tess, which, value), (GLUtesselator *tess, GLenum which, GLdouble value))
GLATTER_INLINE_OR_NOT void glatter_gluTessProperty_debug(GLUtesselator *tess, GLenum which, GLdouble value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluTessProperty, "(%p, %s, %f)", (void*)tess, enum_to_string_GL(which), (double)value)
    glatter_gluTessProperty(tess, which, value);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluTessProperty_defined
GLATTER_FBLOCK(, GLU, , void, APIENTRY, gluTessVertex, (tess, coords, data), (GLUtesselator *tess, GLdouble coords[3], void *data))
GLATTER_INLINE_OR_NOT void glatter_gluTessVertex_debug(GLUtesselator *tess, GLdouble coords[3], void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluTessVertex, "(%p, %s, %p)", (void*)tess, GET_PRS(coords), (void*)data)
    glatter_gluTessVertex(tess, coords, data);
    GLATTER_CHECK_ERROR(GLU, file, line)
}
#define gluTessVertex_defined
GLATTER_FBLOCK(return, GLU, , int, APIENTRY, gluUnProject, (winx, winy, winz, modelMatrix, projMatrix, viewport, objx, objy, objz), (GLdouble winx, GLdouble winy, GLdouble winz, const GLdouble modelMatrix[16], const GLdouble projMatrix[16], const GLint viewport[4], GLdouble *objx, GLdouble *objy, GLdouble *objz))
GLATTER_INLINE_OR_NOT int glatter_gluUnProject_debug(GLdouble winx, GLdouble winy, GLdouble winz, const GLdouble modelMatrix[16], const GLdouble projMatrix[16], const GLint viewport[4], GLdouble *objx, GLdouble *objy, GLdouble *objz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, gluUnProject, "(%f, %f, %f, %s, %s, %s, %p, %p, %p)", (double)winx, (double)winy, (double)winz, GET_PRS(modelMatrix), GET_PRS(projMatrix), GET_PRS(viewport), (void*)objx, (void*)objy, (void*)objz)
    int rval = glatter_gluUnProject(winx, winy, winz, modelMatrix, projMatrix, viewport, objx, objy, objz);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GLU, file, line)
    return rval;
}
#define gluUnProject_defined
#endif // defined(__glu_h__)
#endif // defined(__GLU_H__)
#endif // GLATTER_GLU

