/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



#ifdef GLATTER_GL
#if defined(__GL_H__)
#if !defined(GL_VERSION_ES_CM_1_0)
#if defined(__gl_h_)
#ifndef glAccum
#define glAccum(op, value) glatter_glAccum_debug((op), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAccum_debug(GLenum op, GLfloat value, const char* file, int line);
#ifndef glAlphaFunc
#define glAlphaFunc(func, ref) glatter_glAlphaFunc_debug((func), (ref), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAlphaFunc_debug(GLenum func, GLclampf ref, const char* file, int line);
#ifndef glAreTexturesResident
#define glAreTexturesResident(n, textures, residences) glatter_glAreTexturesResident_debug((n), (textures), (residences), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glAreTexturesResident_debug(GLsizei n, const GLuint *textures, GLboolean *residences, const char* file, int line);
#ifndef glArrayElement
#define glArrayElement(i) glatter_glArrayElement_debug((i), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glArrayElement_debug(GLint i, const char* file, int line);
#ifndef glBegin
#define glBegin(mode) glatter_glBegin_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBegin_debug(GLenum mode, const char* file, int line);
#ifndef glBindTexture
#define glBindTexture(target, texture) glatter_glBindTexture_debug((target), (texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindTexture_debug(GLenum target, GLuint texture, const char* file, int line);
#ifndef glBitmap
#define glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap) glatter_glBitmap_debug((width), (height), (xorig), (yorig), (xmove), (ymove), (bitmap), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBitmap_debug(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap, const char* file, int line);
#ifndef glBlendFunc
#define glBlendFunc(sfactor, dfactor) glatter_glBlendFunc_debug((sfactor), (dfactor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFunc_debug(GLenum sfactor, GLenum dfactor, const char* file, int line);
#ifndef glCallList
#define glCallList(list) glatter_glCallList_debug((list), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCallList_debug(GLuint list, const char* file, int line);
#ifndef glCallLists
#define glCallLists(n, type, lists) glatter_glCallLists_debug((n), (type), (lists), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCallLists_debug(GLsizei n, GLenum type, const GLvoid *lists, const char* file, int line);
#ifndef glClear
#define glClear(mask) glatter_glClear_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClear_debug(GLbitfield mask, const char* file, int line);
#ifndef glClearAccum
#define glClearAccum(red, green, blue, alpha) glatter_glClearAccum_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearAccum_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line);
#ifndef glClearColor
#define glClearColor(red, green, blue, alpha) glatter_glClearColor_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearColor_debug(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha, const char* file, int line);
#ifndef glClearDepth
#define glClearDepth(depth) glatter_glClearDepth_debug((depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearDepth_debug(GLclampd depth, const char* file, int line);
#ifndef glClearIndex
#define glClearIndex(c) glatter_glClearIndex_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearIndex_debug(GLfloat c, const char* file, int line);
#ifndef glClearStencil
#define glClearStencil(s) glatter_glClearStencil_debug((s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearStencil_debug(GLint s, const char* file, int line);
#ifndef glClipPlane
#define glClipPlane(plane, equation) glatter_glClipPlane_debug((plane), (equation), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClipPlane_debug(GLenum plane, const GLdouble *equation, const char* file, int line);
#ifndef glColor3b
#define glColor3b(red, green, blue) glatter_glColor3b_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3b_debug(GLbyte red, GLbyte green, GLbyte blue, const char* file, int line);
#ifndef glColor3bv
#define glColor3bv(v) glatter_glColor3bv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3bv_debug(const GLbyte *v, const char* file, int line);
#ifndef glColor3d
#define glColor3d(red, green, blue) glatter_glColor3d_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3d_debug(GLdouble red, GLdouble green, GLdouble blue, const char* file, int line);
#ifndef glColor3dv
#define glColor3dv(v) glatter_glColor3dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glColor3f
#define glColor3f(red, green, blue) glatter_glColor3f_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3f_debug(GLfloat red, GLfloat green, GLfloat blue, const char* file, int line);
#ifndef glColor3fv
#define glColor3fv(v) glatter_glColor3fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glColor3i
#define glColor3i(red, green, blue) glatter_glColor3i_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3i_debug(GLint red, GLint green, GLint blue, const char* file, int line);
#ifndef glColor3iv
#define glColor3iv(v) glatter_glColor3iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3iv_debug(const GLint *v, const char* file, int line);
#ifndef glColor3s
#define glColor3s(red, green, blue) glatter_glColor3s_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3s_debug(GLshort red, GLshort green, GLshort blue, const char* file, int line);
#ifndef glColor3sv
#define glColor3sv(v) glatter_glColor3sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3sv_debug(const GLshort *v, const char* file, int line);
#ifndef glColor3ub
#define glColor3ub(red, green, blue) glatter_glColor3ub_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3ub_debug(GLubyte red, GLubyte green, GLubyte blue, const char* file, int line);
#ifndef glColor3ubv
#define glColor3ubv(v) glatter_glColor3ubv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3ubv_debug(const GLubyte *v, const char* file, int line);
#ifndef glColor3ui
#define glColor3ui(red, green, blue) glatter_glColor3ui_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3ui_debug(GLuint red, GLuint green, GLuint blue, const char* file, int line);
#ifndef glColor3uiv
#define glColor3uiv(v) glatter_glColor3uiv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3uiv_debug(const GLuint *v, const char* file, int line);
#ifndef glColor3us
#define glColor3us(red, green, blue) glatter_glColor3us_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3us_debug(GLushort red, GLushort green, GLushort blue, const char* file, int line);
#ifndef glColor3usv
#define glColor3usv(v) glatter_glColor3usv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3usv_debug(const GLushort *v, const char* file, int line);
#ifndef glColor4b
#define glColor4b(red, green, blue, alpha) glatter_glColor4b_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4b_debug(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha, const char* file, int line);
#ifndef glColor4bv
#define glColor4bv(v) glatter_glColor4bv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4bv_debug(const GLbyte *v, const char* file, int line);
#ifndef glColor4d
#define glColor4d(red, green, blue, alpha) glatter_glColor4d_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4d_debug(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha, const char* file, int line);
#ifndef glColor4dv
#define glColor4dv(v) glatter_glColor4dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glColor4f
#define glColor4f(red, green, blue, alpha) glatter_glColor4f_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4f_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line);
#ifndef glColor4fv
#define glColor4fv(v) glatter_glColor4fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glColor4i
#define glColor4i(red, green, blue, alpha) glatter_glColor4i_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4i_debug(GLint red, GLint green, GLint blue, GLint alpha, const char* file, int line);
#ifndef glColor4iv
#define glColor4iv(v) glatter_glColor4iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4iv_debug(const GLint *v, const char* file, int line);
#ifndef glColor4s
#define glColor4s(red, green, blue, alpha) glatter_glColor4s_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4s_debug(GLshort red, GLshort green, GLshort blue, GLshort alpha, const char* file, int line);
#ifndef glColor4sv
#define glColor4sv(v) glatter_glColor4sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4sv_debug(const GLshort *v, const char* file, int line);
#ifndef glColor4ub
#define glColor4ub(red, green, blue, alpha) glatter_glColor4ub_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4ub_debug(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha, const char* file, int line);
#ifndef glColor4ubv
#define glColor4ubv(v) glatter_glColor4ubv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4ubv_debug(const GLubyte *v, const char* file, int line);
#ifndef glColor4ui
#define glColor4ui(red, green, blue, alpha) glatter_glColor4ui_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4ui_debug(GLuint red, GLuint green, GLuint blue, GLuint alpha, const char* file, int line);
#ifndef glColor4uiv
#define glColor4uiv(v) glatter_glColor4uiv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4uiv_debug(const GLuint *v, const char* file, int line);
#ifndef glColor4us
#define glColor4us(red, green, blue, alpha) glatter_glColor4us_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4us_debug(GLushort red, GLushort green, GLushort blue, GLushort alpha, const char* file, int line);
#ifndef glColor4usv
#define glColor4usv(v) glatter_glColor4usv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4usv_debug(const GLushort *v, const char* file, int line);
#ifndef glColorMask
#define glColorMask(red, green, blue, alpha) glatter_glColorMask_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorMask_debug(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha, const char* file, int line);
#ifndef glColorMaterial
#define glColorMaterial(face, mode) glatter_glColorMaterial_debug((face), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorMaterial_debug(GLenum face, GLenum mode, const char* file, int line);
#ifndef glColorPointer
#define glColorPointer(size, type, stride, pointer) glatter_glColorPointer_debug((size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorPointer_debug(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line);
#ifndef glCopyPixels
#define glCopyPixels(x, y, width, height, type) glatter_glCopyPixels_debug((x), (y), (width), (height), (type), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyPixels_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type, const char* file, int line);
#ifndef glCopyTexImage1D
#define glCopyTexImage1D(target, level, internalFormat, x, y, width, border) glatter_glCopyTexImage1D_debug((target), (level), (internalFormat), (x), (y), (width), (border), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage1D_debug(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border, const char* file, int line);
#ifndef glCopyTexImage2D
#define glCopyTexImage2D(target, level, internalFormat, x, y, width, height, border) glatter_glCopyTexImage2D_debug((target), (level), (internalFormat), (x), (y), (width), (height), (border), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage2D_debug(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line);
#ifndef glCopyTexSubImage1D
#define glCopyTexSubImage1D(target, level, xoffset, x, y, width) glatter_glCopyTexSubImage1D_debug((target), (level), (xoffset), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage1D_debug(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glCopyTexSubImage2D
#define glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height) glatter_glCopyTexSubImage2D_debug((target), (level), (xoffset), (yoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glCullFace
#define glCullFace(mode) glatter_glCullFace_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCullFace_debug(GLenum mode, const char* file, int line);
#ifndef glDeleteLists
#define glDeleteLists(list, range) glatter_glDeleteLists_debug((list), (range), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteLists_debug(GLuint list, GLsizei range, const char* file, int line);
#ifndef glDeleteTextures
#define glDeleteTextures(n, textures) glatter_glDeleteTextures_debug((n), (textures), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteTextures_debug(GLsizei n, const GLuint *textures, const char* file, int line);
#ifndef glDepthFunc
#define glDepthFunc(func) glatter_glDepthFunc_debug((func), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthFunc_debug(GLenum func, const char* file, int line);
#ifndef glDepthMask
#define glDepthMask(flag) glatter_glDepthMask_debug((flag), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthMask_debug(GLboolean flag, const char* file, int line);
#ifndef glDepthRange
#define glDepthRange(zNear, zFar) glatter_glDepthRange_debug((zNear), (zFar), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthRange_debug(GLclampd zNear, GLclampd zFar, const char* file, int line);
#ifndef glDisable
#define glDisable(cap) glatter_glDisable_debug((cap), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisable_debug(GLenum cap, const char* file, int line);
#ifndef glDisableClientState
#define glDisableClientState(array) glatter_glDisableClientState_debug((array), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableClientState_debug(GLenum array, const char* file, int line);
#ifndef glDrawArrays
#define glDrawArrays(mode, first, count) glatter_glDrawArrays_debug((mode), (first), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawArrays_debug(GLenum mode, GLint first, GLsizei count, const char* file, int line);
#ifndef glDrawBuffer
#define glDrawBuffer(mode) glatter_glDrawBuffer_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffer_debug(GLenum mode, const char* file, int line);
#ifndef glDrawElements
#define glDrawElements(mode, count, type, indices) glatter_glDrawElements_debug((mode), (count), (type), (indices), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElements_debug(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, const char* file, int line);
#ifndef glDrawPixels
#define glDrawPixels(width, height, format, type, pixels) glatter_glDrawPixels_debug((width), (height), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawPixels_debug(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line);
#ifndef glEdgeFlag
#define glEdgeFlag(flag) glatter_glEdgeFlag_debug((flag), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlag_debug(GLboolean flag, const char* file, int line);
#ifndef glEdgeFlagPointer
#define glEdgeFlagPointer(stride, pointer) glatter_glEdgeFlagPointer_debug((stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlagPointer_debug(GLsizei stride, const GLvoid *pointer, const char* file, int line);
#ifndef glEdgeFlagv
#define glEdgeFlagv(flag) glatter_glEdgeFlagv_debug((flag), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlagv_debug(const GLboolean *flag, const char* file, int line);
#ifndef glEnable
#define glEnable(cap) glatter_glEnable_debug((cap), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnable_debug(GLenum cap, const char* file, int line);
#ifndef glEnableClientState
#define glEnableClientState(array) glatter_glEnableClientState_debug((array), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableClientState_debug(GLenum array, const char* file, int line);
#ifndef glEnd
#define glEnd() glatter_glEnd_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnd_debug(const char* file, int line);
#ifndef glEndList
#define glEndList() glatter_glEndList_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndList_debug(const char* file, int line);
#ifndef glEvalCoord1d
#define glEvalCoord1d(u) glatter_glEvalCoord1d_debug((u), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1d_debug(GLdouble u, const char* file, int line);
#ifndef glEvalCoord1dv
#define glEvalCoord1dv(u) glatter_glEvalCoord1dv_debug((u), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1dv_debug(const GLdouble *u, const char* file, int line);
#ifndef glEvalCoord1f
#define glEvalCoord1f(u) glatter_glEvalCoord1f_debug((u), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1f_debug(GLfloat u, const char* file, int line);
#ifndef glEvalCoord1fv
#define glEvalCoord1fv(u) glatter_glEvalCoord1fv_debug((u), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1fv_debug(const GLfloat *u, const char* file, int line);
#ifndef glEvalCoord2d
#define glEvalCoord2d(u, v) glatter_glEvalCoord2d_debug((u), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2d_debug(GLdouble u, GLdouble v, const char* file, int line);
#ifndef glEvalCoord2dv
#define glEvalCoord2dv(u) glatter_glEvalCoord2dv_debug((u), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2dv_debug(const GLdouble *u, const char* file, int line);
#ifndef glEvalCoord2f
#define glEvalCoord2f(u, v) glatter_glEvalCoord2f_debug((u), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2f_debug(GLfloat u, GLfloat v, const char* file, int line);
#ifndef glEvalCoord2fv
#define glEvalCoord2fv(u) glatter_glEvalCoord2fv_debug((u), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2fv_debug(const GLfloat *u, const char* file, int line);
#ifndef glEvalMesh1
#define glEvalMesh1(mode, i1, i2) glatter_glEvalMesh1_debug((mode), (i1), (i2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalMesh1_debug(GLenum mode, GLint i1, GLint i2, const char* file, int line);
#ifndef glEvalMesh2
#define glEvalMesh2(mode, i1, i2, j1, j2) glatter_glEvalMesh2_debug((mode), (i1), (i2), (j1), (j2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalMesh2_debug(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2, const char* file, int line);
#ifndef glEvalPoint1
#define glEvalPoint1(i) glatter_glEvalPoint1_debug((i), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalPoint1_debug(GLint i, const char* file, int line);
#ifndef glEvalPoint2
#define glEvalPoint2(i, j) glatter_glEvalPoint2_debug((i), (j), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalPoint2_debug(GLint i, GLint j, const char* file, int line);
#ifndef glFeedbackBuffer
#define glFeedbackBuffer(size, type, buffer) glatter_glFeedbackBuffer_debug((size), (type), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFeedbackBuffer_debug(GLsizei size, GLenum type, GLfloat *buffer, const char* file, int line);
#ifndef glFinish
#define glFinish() glatter_glFinish_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFinish_debug(const char* file, int line);
#ifndef glFlush
#define glFlush() glatter_glFlush_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlush_debug(const char* file, int line);
#ifndef glFogf
#define glFogf(pname, param) glatter_glFogf_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogf_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glFogfv
#define glFogfv(pname, params) glatter_glFogfv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogfv_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glFogi
#define glFogi(pname, param) glatter_glFogi_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogi_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glFogiv
#define glFogiv(pname, params) glatter_glFogiv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogiv_debug(GLenum pname, const GLint *params, const char* file, int line);
#ifndef glFrontFace
#define glFrontFace(mode) glatter_glFrontFace_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFrontFace_debug(GLenum mode, const char* file, int line);
#ifndef glFrustum
#define glFrustum(left, right, bottom, top, zNear, zFar) glatter_glFrustum_debug((left), (right), (bottom), (top), (zNear), (zFar), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFrustum_debug(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line);
#ifndef glGenLists
#define glGenLists(range) glatter_glGenLists_debug((range), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGenLists_debug(GLsizei range, const char* file, int line);
#ifndef glGenTextures
#define glGenTextures(n, textures) glatter_glGenTextures_debug((n), (textures), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenTextures_debug(GLsizei n, GLuint *textures, const char* file, int line);
#ifndef glGetBooleanv
#define glGetBooleanv(pname, params) glatter_glGetBooleanv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBooleanv_debug(GLenum pname, GLboolean *params, const char* file, int line);
#ifndef glGetClipPlane
#define glGetClipPlane(plane, equation) glatter_glGetClipPlane_debug((plane), (equation), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetClipPlane_debug(GLenum plane, GLdouble *equation, const char* file, int line);
#ifndef glGetDoublev
#define glGetDoublev(pname, params) glatter_glGetDoublev_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetDoublev_debug(GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glGetError
#define glGetError() glatter_glGetError_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glGetError_debug(const char* file, int line);
#ifndef glGetFloatv
#define glGetFloatv(pname, params) glatter_glGetFloatv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFloatv_debug(GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetIntegerv
#define glGetIntegerv(pname, params) glatter_glGetIntegerv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetIntegerv_debug(GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetLightfv
#define glGetLightfv(light, pname, params) glatter_glGetLightfv_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetLightfv_debug(GLenum light, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetLightiv
#define glGetLightiv(light, pname, params) glatter_glGetLightiv_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetLightiv_debug(GLenum light, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetMapdv
#define glGetMapdv(target, query, v) glatter_glGetMapdv_debug((target), (query), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMapdv_debug(GLenum target, GLenum query, GLdouble *v, const char* file, int line);
#ifndef glGetMapfv
#define glGetMapfv(target, query, v) glatter_glGetMapfv_debug((target), (query), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMapfv_debug(GLenum target, GLenum query, GLfloat *v, const char* file, int line);
#ifndef glGetMapiv
#define glGetMapiv(target, query, v) glatter_glGetMapiv_debug((target), (query), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMapiv_debug(GLenum target, GLenum query, GLint *v, const char* file, int line);
#ifndef glGetMaterialfv
#define glGetMaterialfv(face, pname, params) glatter_glGetMaterialfv_debug((face), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMaterialfv_debug(GLenum face, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetMaterialiv
#define glGetMaterialiv(face, pname, params) glatter_glGetMaterialiv_debug((face), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMaterialiv_debug(GLenum face, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetPixelMapfv
#define glGetPixelMapfv(map, values) glatter_glGetPixelMapfv_debug((map), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPixelMapfv_debug(GLenum map, GLfloat *values, const char* file, int line);
#ifndef glGetPixelMapuiv
#define glGetPixelMapuiv(map, values) glatter_glGetPixelMapuiv_debug((map), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPixelMapuiv_debug(GLenum map, GLuint *values, const char* file, int line);
#ifndef glGetPixelMapusv
#define glGetPixelMapusv(map, values) glatter_glGetPixelMapusv_debug((map), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPixelMapusv_debug(GLenum map, GLushort *values, const char* file, int line);
#ifndef glGetPointerv
#define glGetPointerv(pname, params) glatter_glGetPointerv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPointerv_debug(GLenum pname, GLvoid* *params, const char* file, int line);
#ifndef glGetPolygonStipple
#define glGetPolygonStipple(mask) glatter_glGetPolygonStipple_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPolygonStipple_debug(GLubyte *mask, const char* file, int line);
#ifndef glGetString
#define glGetString(name) glatter_glGetString_debug((name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT const GLubyte * glatter_glGetString_debug(GLenum name, const char* file, int line);
#ifndef glGetTexEnvfv
#define glGetTexEnvfv(target, pname, params) glatter_glGetTexEnvfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexEnvfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetTexEnviv
#define glGetTexEnviv(target, pname, params) glatter_glGetTexEnviv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexEnviv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTexGendv
#define glGetTexGendv(coord, pname, params) glatter_glGetTexGendv_debug((coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexGendv_debug(GLenum coord, GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glGetTexGenfv
#define glGetTexGenfv(coord, pname, params) glatter_glGetTexGenfv_debug((coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexGenfv_debug(GLenum coord, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetTexGeniv
#define glGetTexGeniv(coord, pname, params) glatter_glGetTexGeniv_debug((coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexGeniv_debug(GLenum coord, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTexImage
#define glGetTexImage(target, level, format, type, pixels) glatter_glGetTexImage_debug((target), (level), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexImage_debug(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels, const char* file, int line);
#ifndef glGetTexLevelParameterfv
#define glGetTexLevelParameterfv(target, level, pname, params) glatter_glGetTexLevelParameterfv_debug((target), (level), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexLevelParameterfv_debug(GLenum target, GLint level, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetTexLevelParameteriv
#define glGetTexLevelParameteriv(target, level, pname, params) glatter_glGetTexLevelParameteriv_debug((target), (level), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexLevelParameteriv_debug(GLenum target, GLint level, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTexParameterfv
#define glGetTexParameterfv(target, pname, params) glatter_glGetTexParameterfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetTexParameteriv
#define glGetTexParameteriv(target, pname, params) glatter_glGetTexParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glHint
#define glHint(target, mode) glatter_glHint_debug((target), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glHint_debug(GLenum target, GLenum mode, const char* file, int line);
#ifndef glIndexMask
#define glIndexMask(mask) glatter_glIndexMask_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexMask_debug(GLuint mask, const char* file, int line);
#ifndef glIndexPointer
#define glIndexPointer(type, stride, pointer) glatter_glIndexPointer_debug((type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexPointer_debug(GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line);
#ifndef glIndexd
#define glIndexd(c) glatter_glIndexd_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexd_debug(GLdouble c, const char* file, int line);
#ifndef glIndexdv
#define glIndexdv(c) glatter_glIndexdv_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexdv_debug(const GLdouble *c, const char* file, int line);
#ifndef glIndexf
#define glIndexf(c) glatter_glIndexf_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexf_debug(GLfloat c, const char* file, int line);
#ifndef glIndexfv
#define glIndexfv(c) glatter_glIndexfv_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexfv_debug(const GLfloat *c, const char* file, int line);
#ifndef glIndexi
#define glIndexi(c) glatter_glIndexi_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexi_debug(GLint c, const char* file, int line);
#ifndef glIndexiv
#define glIndexiv(c) glatter_glIndexiv_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexiv_debug(const GLint *c, const char* file, int line);
#ifndef glIndexs
#define glIndexs(c) glatter_glIndexs_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexs_debug(GLshort c, const char* file, int line);
#ifndef glIndexsv
#define glIndexsv(c) glatter_glIndexsv_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexsv_debug(const GLshort *c, const char* file, int line);
#ifndef glIndexub
#define glIndexub(c) glatter_glIndexub_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexub_debug(GLubyte c, const char* file, int line);
#ifndef glIndexubv
#define glIndexubv(c) glatter_glIndexubv_debug((c), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexubv_debug(const GLubyte *c, const char* file, int line);
#ifndef glInitNames
#define glInitNames() glatter_glInitNames_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInitNames_debug(const char* file, int line);
#ifndef glInterleavedArrays
#define glInterleavedArrays(format, stride, pointer) glatter_glInterleavedArrays_debug((format), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInterleavedArrays_debug(GLenum format, GLsizei stride, const GLvoid *pointer, const char* file, int line);
#ifndef glIsEnabled
#define glIsEnabled(cap) glatter_glIsEnabled_debug((cap), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnabled_debug(GLenum cap, const char* file, int line);
#ifndef glIsList
#define glIsList(list) glatter_glIsList_debug((list), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsList_debug(GLuint list, const char* file, int line);
#ifndef glIsTexture
#define glIsTexture(texture) glatter_glIsTexture_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTexture_debug(GLuint texture, const char* file, int line);
#ifndef glLightModelf
#define glLightModelf(pname, param) glatter_glLightModelf_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightModelf_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glLightModelfv
#define glLightModelfv(pname, params) glatter_glLightModelfv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightModelfv_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glLightModeli
#define glLightModeli(pname, param) glatter_glLightModeli_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightModeli_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glLightModeliv
#define glLightModeliv(pname, params) glatter_glLightModeliv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightModeliv_debug(GLenum pname, const GLint *params, const char* file, int line);
#ifndef glLightf
#define glLightf(light, pname, param) glatter_glLightf_debug((light), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightf_debug(GLenum light, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glLightfv
#define glLightfv(light, pname, params) glatter_glLightfv_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightfv_debug(GLenum light, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glLighti
#define glLighti(light, pname, param) glatter_glLighti_debug((light), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLighti_debug(GLenum light, GLenum pname, GLint param, const char* file, int line);
#ifndef glLightiv
#define glLightiv(light, pname, params) glatter_glLightiv_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightiv_debug(GLenum light, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glLineStipple
#define glLineStipple(factor, pattern) glatter_glLineStipple_debug((factor), (pattern), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLineStipple_debug(GLint factor, GLushort pattern, const char* file, int line);
#ifndef glLineWidth
#define glLineWidth(width) glatter_glLineWidth_debug((width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLineWidth_debug(GLfloat width, const char* file, int line);
#ifndef glListBase
#define glListBase(base) glatter_glListBase_debug((base), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glListBase_debug(GLuint base, const char* file, int line);
#ifndef glLoadIdentity
#define glLoadIdentity() glatter_glLoadIdentity_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadIdentity_debug(const char* file, int line);
#ifndef glLoadMatrixd
#define glLoadMatrixd(m) glatter_glLoadMatrixd_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadMatrixd_debug(const GLdouble *m, const char* file, int line);
#ifndef glLoadMatrixf
#define glLoadMatrixf(m) glatter_glLoadMatrixf_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadMatrixf_debug(const GLfloat *m, const char* file, int line);
#ifndef glLoadName
#define glLoadName(name) glatter_glLoadName_debug((name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadName_debug(GLuint name, const char* file, int line);
#ifndef glLogicOp
#define glLogicOp(opcode) glatter_glLogicOp_debug((opcode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLogicOp_debug(GLenum opcode, const char* file, int line);
#ifndef glMap1d
#define glMap1d(target, u1, u2, stride, order, points) glatter_glMap1d_debug((target), (u1), (u2), (stride), (order), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMap1d_debug(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points, const char* file, int line);
#ifndef glMap1f
#define glMap1f(target, u1, u2, stride, order, points) glatter_glMap1f_debug((target), (u1), (u2), (stride), (order), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMap1f_debug(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points, const char* file, int line);
#ifndef glMap2d
#define glMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points) glatter_glMap2d_debug((target), (u1), (u2), (ustride), (uorder), (v1), (v2), (vstride), (vorder), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMap2d_debug(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points, const char* file, int line);
#ifndef glMap2f
#define glMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points) glatter_glMap2f_debug((target), (u1), (u2), (ustride), (uorder), (v1), (v2), (vstride), (vorder), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMap2f_debug(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points, const char* file, int line);
#ifndef glMapGrid1d
#define glMapGrid1d(un, u1, u2) glatter_glMapGrid1d_debug((un), (u1), (u2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapGrid1d_debug(GLint un, GLdouble u1, GLdouble u2, const char* file, int line);
#ifndef glMapGrid1f
#define glMapGrid1f(un, u1, u2) glatter_glMapGrid1f_debug((un), (u1), (u2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapGrid1f_debug(GLint un, GLfloat u1, GLfloat u2, const char* file, int line);
#ifndef glMapGrid2d
#define glMapGrid2d(un, u1, u2, vn, v1, v2) glatter_glMapGrid2d_debug((un), (u1), (u2), (vn), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapGrid2d_debug(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2, const char* file, int line);
#ifndef glMapGrid2f
#define glMapGrid2f(un, u1, u2, vn, v1, v2) glatter_glMapGrid2f_debug((un), (u1), (u2), (vn), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapGrid2f_debug(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2, const char* file, int line);
#ifndef glMaterialf
#define glMaterialf(face, pname, param) glatter_glMaterialf_debug((face), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMaterialf_debug(GLenum face, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glMaterialfv
#define glMaterialfv(face, pname, params) glatter_glMaterialfv_debug((face), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMaterialfv_debug(GLenum face, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glMateriali
#define glMateriali(face, pname, param) glatter_glMateriali_debug((face), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMateriali_debug(GLenum face, GLenum pname, GLint param, const char* file, int line);
#ifndef glMaterialiv
#define glMaterialiv(face, pname, params) glatter_glMaterialiv_debug((face), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMaterialiv_debug(GLenum face, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glMatrixMode
#define glMatrixMode(mode) glatter_glMatrixMode_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixMode_debug(GLenum mode, const char* file, int line);
#ifndef glMultMatrixd
#define glMultMatrixd(m) glatter_glMultMatrixd_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultMatrixd_debug(const GLdouble *m, const char* file, int line);
#ifndef glMultMatrixf
#define glMultMatrixf(m) glatter_glMultMatrixf_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultMatrixf_debug(const GLfloat *m, const char* file, int line);
#ifndef glNewList
#define glNewList(list, mode) glatter_glNewList_debug((list), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNewList_debug(GLuint list, GLenum mode, const char* file, int line);
#ifndef glNormal3b
#define glNormal3b(nx, ny, nz) glatter_glNormal3b_debug((nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3b_debug(GLbyte nx, GLbyte ny, GLbyte nz, const char* file, int line);
#ifndef glNormal3bv
#define glNormal3bv(v) glatter_glNormal3bv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3bv_debug(const GLbyte *v, const char* file, int line);
#ifndef glNormal3d
#define glNormal3d(nx, ny, nz) glatter_glNormal3d_debug((nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3d_debug(GLdouble nx, GLdouble ny, GLdouble nz, const char* file, int line);
#ifndef glNormal3dv
#define glNormal3dv(v) glatter_glNormal3dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glNormal3f
#define glNormal3f(nx, ny, nz) glatter_glNormal3f_debug((nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3f_debug(GLfloat nx, GLfloat ny, GLfloat nz, const char* file, int line);
#ifndef glNormal3fv
#define glNormal3fv(v) glatter_glNormal3fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glNormal3i
#define glNormal3i(nx, ny, nz) glatter_glNormal3i_debug((nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3i_debug(GLint nx, GLint ny, GLint nz, const char* file, int line);
#ifndef glNormal3iv
#define glNormal3iv(v) glatter_glNormal3iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3iv_debug(const GLint *v, const char* file, int line);
#ifndef glNormal3s
#define glNormal3s(nx, ny, nz) glatter_glNormal3s_debug((nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3s_debug(GLshort nx, GLshort ny, GLshort nz, const char* file, int line);
#ifndef glNormal3sv
#define glNormal3sv(v) glatter_glNormal3sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3sv_debug(const GLshort *v, const char* file, int line);
#ifndef glNormalPointer
#define glNormalPointer(type, stride, pointer) glatter_glNormalPointer_debug((type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalPointer_debug(GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line);
#ifndef glOrtho
#define glOrtho(left, right, bottom, top, zNear, zFar) glatter_glOrtho_debug((left), (right), (bottom), (top), (zNear), (zFar), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glOrtho_debug(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line);
#ifndef glPassThrough
#define glPassThrough(token) glatter_glPassThrough_debug((token), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPassThrough_debug(GLfloat token, const char* file, int line);
#ifndef glPixelMapfv
#define glPixelMapfv(map, mapsize, values) glatter_glPixelMapfv_debug((map), (mapsize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelMapfv_debug(GLenum map, GLsizei mapsize, const GLfloat *values, const char* file, int line);
#ifndef glPixelMapuiv
#define glPixelMapuiv(map, mapsize, values) glatter_glPixelMapuiv_debug((map), (mapsize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelMapuiv_debug(GLenum map, GLsizei mapsize, const GLuint *values, const char* file, int line);
#ifndef glPixelMapusv
#define glPixelMapusv(map, mapsize, values) glatter_glPixelMapusv_debug((map), (mapsize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelMapusv_debug(GLenum map, GLsizei mapsize, const GLushort *values, const char* file, int line);
#ifndef glPixelStoref
#define glPixelStoref(pname, param) glatter_glPixelStoref_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelStoref_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glPixelStorei
#define glPixelStorei(pname, param) glatter_glPixelStorei_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelStorei_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glPixelTransferf
#define glPixelTransferf(pname, param) glatter_glPixelTransferf_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTransferf_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glPixelTransferi
#define glPixelTransferi(pname, param) glatter_glPixelTransferi_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTransferi_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glPixelZoom
#define glPixelZoom(xfactor, yfactor) glatter_glPixelZoom_debug((xfactor), (yfactor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelZoom_debug(GLfloat xfactor, GLfloat yfactor, const char* file, int line);
#ifndef glPointSize
#define glPointSize(size) glatter_glPointSize_debug((size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointSize_debug(GLfloat size, const char* file, int line);
#ifndef glPolygonMode
#define glPolygonMode(face, mode) glatter_glPolygonMode_debug((face), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPolygonMode_debug(GLenum face, GLenum mode, const char* file, int line);
#ifndef glPolygonOffset
#define glPolygonOffset(factor, units) glatter_glPolygonOffset_debug((factor), (units), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffset_debug(GLfloat factor, GLfloat units, const char* file, int line);
#ifndef glPolygonStipple
#define glPolygonStipple(mask) glatter_glPolygonStipple_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPolygonStipple_debug(const GLubyte *mask, const char* file, int line);
#ifndef glPopAttrib
#define glPopAttrib() glatter_glPopAttrib_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPopAttrib_debug(const char* file, int line);
#ifndef glPopClientAttrib
#define glPopClientAttrib() glatter_glPopClientAttrib_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPopClientAttrib_debug(const char* file, int line);
#ifndef glPopMatrix
#define glPopMatrix() glatter_glPopMatrix_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPopMatrix_debug(const char* file, int line);
#ifndef glPopName
#define glPopName() glatter_glPopName_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPopName_debug(const char* file, int line);
#ifndef glPrioritizeTextures
#define glPrioritizeTextures(n, textures, priorities) glatter_glPrioritizeTextures_debug((n), (textures), (priorities), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPrioritizeTextures_debug(GLsizei n, const GLuint *textures, const GLclampf *priorities, const char* file, int line);
#ifndef glPushAttrib
#define glPushAttrib(mask) glatter_glPushAttrib_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPushAttrib_debug(GLbitfield mask, const char* file, int line);
#ifndef glPushClientAttrib
#define glPushClientAttrib(mask) glatter_glPushClientAttrib_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPushClientAttrib_debug(GLbitfield mask, const char* file, int line);
#ifndef glPushMatrix
#define glPushMatrix() glatter_glPushMatrix_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPushMatrix_debug(const char* file, int line);
#ifndef glPushName
#define glPushName(name) glatter_glPushName_debug((name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPushName_debug(GLuint name, const char* file, int line);
#ifndef glRasterPos2d
#define glRasterPos2d(x, y) glatter_glRasterPos2d_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2d_debug(GLdouble x, GLdouble y, const char* file, int line);
#ifndef glRasterPos2dv
#define glRasterPos2dv(v) glatter_glRasterPos2dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glRasterPos2f
#define glRasterPos2f(x, y) glatter_glRasterPos2f_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2f_debug(GLfloat x, GLfloat y, const char* file, int line);
#ifndef glRasterPos2fv
#define glRasterPos2fv(v) glatter_glRasterPos2fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glRasterPos2i
#define glRasterPos2i(x, y) glatter_glRasterPos2i_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2i_debug(GLint x, GLint y, const char* file, int line);
#ifndef glRasterPos2iv
#define glRasterPos2iv(v) glatter_glRasterPos2iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2iv_debug(const GLint *v, const char* file, int line);
#ifndef glRasterPos2s
#define glRasterPos2s(x, y) glatter_glRasterPos2s_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2s_debug(GLshort x, GLshort y, const char* file, int line);
#ifndef glRasterPos2sv
#define glRasterPos2sv(v) glatter_glRasterPos2sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2sv_debug(const GLshort *v, const char* file, int line);
#ifndef glRasterPos3d
#define glRasterPos3d(x, y, z) glatter_glRasterPos3d_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3d_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glRasterPos3dv
#define glRasterPos3dv(v) glatter_glRasterPos3dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glRasterPos3f
#define glRasterPos3f(x, y, z) glatter_glRasterPos3f_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3f_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glRasterPos3fv
#define glRasterPos3fv(v) glatter_glRasterPos3fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glRasterPos3i
#define glRasterPos3i(x, y, z) glatter_glRasterPos3i_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3i_debug(GLint x, GLint y, GLint z, const char* file, int line);
#ifndef glRasterPos3iv
#define glRasterPos3iv(v) glatter_glRasterPos3iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3iv_debug(const GLint *v, const char* file, int line);
#ifndef glRasterPos3s
#define glRasterPos3s(x, y, z) glatter_glRasterPos3s_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3s_debug(GLshort x, GLshort y, GLshort z, const char* file, int line);
#ifndef glRasterPos3sv
#define glRasterPos3sv(v) glatter_glRasterPos3sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3sv_debug(const GLshort *v, const char* file, int line);
#ifndef glRasterPos4d
#define glRasterPos4d(x, y, z, w) glatter_glRasterPos4d_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4d_debug(GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glRasterPos4dv
#define glRasterPos4dv(v) glatter_glRasterPos4dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glRasterPos4f
#define glRasterPos4f(x, y, z, w) glatter_glRasterPos4f_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4f_debug(GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glRasterPos4fv
#define glRasterPos4fv(v) glatter_glRasterPos4fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glRasterPos4i
#define glRasterPos4i(x, y, z, w) glatter_glRasterPos4i_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4i_debug(GLint x, GLint y, GLint z, GLint w, const char* file, int line);
#ifndef glRasterPos4iv
#define glRasterPos4iv(v) glatter_glRasterPos4iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4iv_debug(const GLint *v, const char* file, int line);
#ifndef glRasterPos4s
#define glRasterPos4s(x, y, z, w) glatter_glRasterPos4s_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4s_debug(GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line);
#ifndef glRasterPos4sv
#define glRasterPos4sv(v) glatter_glRasterPos4sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4sv_debug(const GLshort *v, const char* file, int line);
#ifndef glReadBuffer
#define glReadBuffer(mode) glatter_glReadBuffer_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReadBuffer_debug(GLenum mode, const char* file, int line);
#ifndef glReadPixels
#define glReadPixels(x, y, width, height, format, type, pixels) glatter_glReadPixels_debug((x), (y), (width), (height), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReadPixels_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels, const char* file, int line);
#ifndef glRectd
#define glRectd(x1, y1, x2, y2) glatter_glRectd_debug((x1), (y1), (x2), (y2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRectd_debug(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2, const char* file, int line);
#ifndef glRectdv
#define glRectdv(v1, v2) glatter_glRectdv_debug((v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRectdv_debug(const GLdouble *v1, const GLdouble *v2, const char* file, int line);
#ifndef glRectf
#define glRectf(x1, y1, x2, y2) glatter_glRectf_debug((x1), (y1), (x2), (y2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRectf_debug(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2, const char* file, int line);
#ifndef glRectfv
#define glRectfv(v1, v2) glatter_glRectfv_debug((v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRectfv_debug(const GLfloat *v1, const GLfloat *v2, const char* file, int line);
#ifndef glRecti
#define glRecti(x1, y1, x2, y2) glatter_glRecti_debug((x1), (y1), (x2), (y2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRecti_debug(GLint x1, GLint y1, GLint x2, GLint y2, const char* file, int line);
#ifndef glRectiv
#define glRectiv(v1, v2) glatter_glRectiv_debug((v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRectiv_debug(const GLint *v1, const GLint *v2, const char* file, int line);
#ifndef glRects
#define glRects(x1, y1, x2, y2) glatter_glRects_debug((x1), (y1), (x2), (y2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRects_debug(GLshort x1, GLshort y1, GLshort x2, GLshort y2, const char* file, int line);
#ifndef glRectsv
#define glRectsv(v1, v2) glatter_glRectsv_debug((v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRectsv_debug(const GLshort *v1, const GLshort *v2, const char* file, int line);
#ifndef glRenderMode
#define glRenderMode(mode) glatter_glRenderMode_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glRenderMode_debug(GLenum mode, const char* file, int line);
#ifndef glRotated
#define glRotated(angle, x, y, z) glatter_glRotated_debug((angle), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRotated_debug(GLdouble angle, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glRotatef
#define glRotatef(angle, x, y, z) glatter_glRotatef_debug((angle), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRotatef_debug(GLfloat angle, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glScaled
#define glScaled(x, y, z) glatter_glScaled_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glScaled_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glScalef
#define glScalef(x, y, z) glatter_glScalef_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glScalef_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glScissor
#define glScissor(x, y, width, height) glatter_glScissor_debug((x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glScissor_debug(GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glSelectBuffer
#define glSelectBuffer(size, buffer) glatter_glSelectBuffer_debug((size), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSelectBuffer_debug(GLsizei size, GLuint *buffer, const char* file, int line);
#ifndef glShadeModel
#define glShadeModel(mode) glatter_glShadeModel_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glShadeModel_debug(GLenum mode, const char* file, int line);
#ifndef glStencilFunc
#define glStencilFunc(func, ref, mask) glatter_glStencilFunc_debug((func), (ref), (mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilFunc_debug(GLenum func, GLint ref, GLuint mask, const char* file, int line);
#ifndef glStencilMask
#define glStencilMask(mask) glatter_glStencilMask_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilMask_debug(GLuint mask, const char* file, int line);
#ifndef glStencilOp
#define glStencilOp(fail, zfail, zpass) glatter_glStencilOp_debug((fail), (zfail), (zpass), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilOp_debug(GLenum fail, GLenum zfail, GLenum zpass, const char* file, int line);
#ifndef glTexCoord1d
#define glTexCoord1d(s) glatter_glTexCoord1d_debug((s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1d_debug(GLdouble s, const char* file, int line);
#ifndef glTexCoord1dv
#define glTexCoord1dv(v) glatter_glTexCoord1dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glTexCoord1f
#define glTexCoord1f(s) glatter_glTexCoord1f_debug((s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1f_debug(GLfloat s, const char* file, int line);
#ifndef glTexCoord1fv
#define glTexCoord1fv(v) glatter_glTexCoord1fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glTexCoord1i
#define glTexCoord1i(s) glatter_glTexCoord1i_debug((s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1i_debug(GLint s, const char* file, int line);
#ifndef glTexCoord1iv
#define glTexCoord1iv(v) glatter_glTexCoord1iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1iv_debug(const GLint *v, const char* file, int line);
#ifndef glTexCoord1s
#define glTexCoord1s(s) glatter_glTexCoord1s_debug((s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1s_debug(GLshort s, const char* file, int line);
#ifndef glTexCoord1sv
#define glTexCoord1sv(v) glatter_glTexCoord1sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1sv_debug(const GLshort *v, const char* file, int line);
#ifndef glTexCoord2d
#define glTexCoord2d(s, t) glatter_glTexCoord2d_debug((s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2d_debug(GLdouble s, GLdouble t, const char* file, int line);
#ifndef glTexCoord2dv
#define glTexCoord2dv(v) glatter_glTexCoord2dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glTexCoord2f
#define glTexCoord2f(s, t) glatter_glTexCoord2f_debug((s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2f_debug(GLfloat s, GLfloat t, const char* file, int line);
#ifndef glTexCoord2fv
#define glTexCoord2fv(v) glatter_glTexCoord2fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glTexCoord2i
#define glTexCoord2i(s, t) glatter_glTexCoord2i_debug((s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2i_debug(GLint s, GLint t, const char* file, int line);
#ifndef glTexCoord2iv
#define glTexCoord2iv(v) glatter_glTexCoord2iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2iv_debug(const GLint *v, const char* file, int line);
#ifndef glTexCoord2s
#define glTexCoord2s(s, t) glatter_glTexCoord2s_debug((s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2s_debug(GLshort s, GLshort t, const char* file, int line);
#ifndef glTexCoord2sv
#define glTexCoord2sv(v) glatter_glTexCoord2sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2sv_debug(const GLshort *v, const char* file, int line);
#ifndef glTexCoord3d
#define glTexCoord3d(s, t, r) glatter_glTexCoord3d_debug((s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3d_debug(GLdouble s, GLdouble t, GLdouble r, const char* file, int line);
#ifndef glTexCoord3dv
#define glTexCoord3dv(v) glatter_glTexCoord3dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glTexCoord3f
#define glTexCoord3f(s, t, r) glatter_glTexCoord3f_debug((s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3f_debug(GLfloat s, GLfloat t, GLfloat r, const char* file, int line);
#ifndef glTexCoord3fv
#define glTexCoord3fv(v) glatter_glTexCoord3fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glTexCoord3i
#define glTexCoord3i(s, t, r) glatter_glTexCoord3i_debug((s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3i_debug(GLint s, GLint t, GLint r, const char* file, int line);
#ifndef glTexCoord3iv
#define glTexCoord3iv(v) glatter_glTexCoord3iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3iv_debug(const GLint *v, const char* file, int line);
#ifndef glTexCoord3s
#define glTexCoord3s(s, t, r) glatter_glTexCoord3s_debug((s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3s_debug(GLshort s, GLshort t, GLshort r, const char* file, int line);
#ifndef glTexCoord3sv
#define glTexCoord3sv(v) glatter_glTexCoord3sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3sv_debug(const GLshort *v, const char* file, int line);
#ifndef glTexCoord4d
#define glTexCoord4d(s, t, r, q) glatter_glTexCoord4d_debug((s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4d_debug(GLdouble s, GLdouble t, GLdouble r, GLdouble q, const char* file, int line);
#ifndef glTexCoord4dv
#define glTexCoord4dv(v) glatter_glTexCoord4dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glTexCoord4f
#define glTexCoord4f(s, t, r, q) glatter_glTexCoord4f_debug((s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4f_debug(GLfloat s, GLfloat t, GLfloat r, GLfloat q, const char* file, int line);
#ifndef glTexCoord4fv
#define glTexCoord4fv(v) glatter_glTexCoord4fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glTexCoord4i
#define glTexCoord4i(s, t, r, q) glatter_glTexCoord4i_debug((s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4i_debug(GLint s, GLint t, GLint r, GLint q, const char* file, int line);
#ifndef glTexCoord4iv
#define glTexCoord4iv(v) glatter_glTexCoord4iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4iv_debug(const GLint *v, const char* file, int line);
#ifndef glTexCoord4s
#define glTexCoord4s(s, t, r, q) glatter_glTexCoord4s_debug((s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4s_debug(GLshort s, GLshort t, GLshort r, GLshort q, const char* file, int line);
#ifndef glTexCoord4sv
#define glTexCoord4sv(v) glatter_glTexCoord4sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4sv_debug(const GLshort *v, const char* file, int line);
#ifndef glTexCoordPointer
#define glTexCoordPointer(size, type, stride, pointer) glatter_glTexCoordPointer_debug((size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordPointer_debug(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line);
#ifndef glTexEnvf
#define glTexEnvf(target, pname, param) glatter_glTexEnvf_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexEnvf_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glTexEnvfv
#define glTexEnvfv(target, pname, params) glatter_glTexEnvfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexEnvfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glTexEnvi
#define glTexEnvi(target, pname, param) glatter_glTexEnvi_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexEnvi_debug(GLenum target, GLenum pname, GLint param, const char* file, int line);
#ifndef glTexEnviv
#define glTexEnviv(target, pname, params) glatter_glTexEnviv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexEnviv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glTexGend
#define glTexGend(coord, pname, param) glatter_glTexGend_debug((coord), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexGend_debug(GLenum coord, GLenum pname, GLdouble param, const char* file, int line);
#ifndef glTexGendv
#define glTexGendv(coord, pname, params) glatter_glTexGendv_debug((coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexGendv_debug(GLenum coord, GLenum pname, const GLdouble *params, const char* file, int line);
#ifndef glTexGenf
#define glTexGenf(coord, pname, param) glatter_glTexGenf_debug((coord), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexGenf_debug(GLenum coord, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glTexGenfv
#define glTexGenfv(coord, pname, params) glatter_glTexGenfv_debug((coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexGenfv_debug(GLenum coord, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glTexGeni
#define glTexGeni(coord, pname, param) glatter_glTexGeni_debug((coord), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexGeni_debug(GLenum coord, GLenum pname, GLint param, const char* file, int line);
#ifndef glTexGeniv
#define glTexGeniv(coord, pname, params) glatter_glTexGeniv_debug((coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexGeniv_debug(GLenum coord, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glTexImage1D
#define glTexImage1D(target, level, internalformat, width, border, format, type, pixels) glatter_glTexImage1D_debug((target), (level), (internalformat), (width), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexImage1D_debug(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line);
#ifndef glTexImage2D
#define glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels) glatter_glTexImage2D_debug((target), (level), (internalformat), (width), (height), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexImage2D_debug(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line);
#ifndef glTexParameterf
#define glTexParameterf(target, pname, param) glatter_glTexParameterf_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameterf_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glTexParameterfv
#define glTexParameterfv(target, pname, params) glatter_glTexParameterfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameterfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glTexParameteri
#define glTexParameteri(target, pname, param) glatter_glTexParameteri_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameteri_debug(GLenum target, GLenum pname, GLint param, const char* file, int line);
#ifndef glTexParameteriv
#define glTexParameteriv(target, pname, params) glatter_glTexParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameteriv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glTexSubImage1D
#define glTexSubImage1D(target, level, xoffset, width, format, type, pixels) glatter_glTexSubImage1D_debug((target), (level), (xoffset), (width), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage1D_debug(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line);
#ifndef glTexSubImage2D
#define glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels) glatter_glTexSubImage2D_debug((target), (level), (xoffset), (yoffset), (width), (height), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line);
#ifndef glTranslated
#define glTranslated(x, y, z) glatter_glTranslated_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTranslated_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glTranslatef
#define glTranslatef(x, y, z) glatter_glTranslatef_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTranslatef_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glVertex2d
#define glVertex2d(x, y) glatter_glVertex2d_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2d_debug(GLdouble x, GLdouble y, const char* file, int line);
#ifndef glVertex2dv
#define glVertex2dv(v) glatter_glVertex2dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glVertex2f
#define glVertex2f(x, y) glatter_glVertex2f_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2f_debug(GLfloat x, GLfloat y, const char* file, int line);
#ifndef glVertex2fv
#define glVertex2fv(v) glatter_glVertex2fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glVertex2i
#define glVertex2i(x, y) glatter_glVertex2i_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2i_debug(GLint x, GLint y, const char* file, int line);
#ifndef glVertex2iv
#define glVertex2iv(v) glatter_glVertex2iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2iv_debug(const GLint *v, const char* file, int line);
#ifndef glVertex2s
#define glVertex2s(x, y) glatter_glVertex2s_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2s_debug(GLshort x, GLshort y, const char* file, int line);
#ifndef glVertex2sv
#define glVertex2sv(v) glatter_glVertex2sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2sv_debug(const GLshort *v, const char* file, int line);
#ifndef glVertex3d
#define glVertex3d(x, y, z) glatter_glVertex3d_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3d_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glVertex3dv
#define glVertex3dv(v) glatter_glVertex3dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glVertex3f
#define glVertex3f(x, y, z) glatter_glVertex3f_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3f_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glVertex3fv
#define glVertex3fv(v) glatter_glVertex3fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glVertex3i
#define glVertex3i(x, y, z) glatter_glVertex3i_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3i_debug(GLint x, GLint y, GLint z, const char* file, int line);
#ifndef glVertex3iv
#define glVertex3iv(v) glatter_glVertex3iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3iv_debug(const GLint *v, const char* file, int line);
#ifndef glVertex3s
#define glVertex3s(x, y, z) glatter_glVertex3s_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3s_debug(GLshort x, GLshort y, GLshort z, const char* file, int line);
#ifndef glVertex3sv
#define glVertex3sv(v) glatter_glVertex3sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3sv_debug(const GLshort *v, const char* file, int line);
#ifndef glVertex4d
#define glVertex4d(x, y, z, w) glatter_glVertex4d_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4d_debug(GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glVertex4dv
#define glVertex4dv(v) glatter_glVertex4dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glVertex4f
#define glVertex4f(x, y, z, w) glatter_glVertex4f_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4f_debug(GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glVertex4fv
#define glVertex4fv(v) glatter_glVertex4fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glVertex4i
#define glVertex4i(x, y, z, w) glatter_glVertex4i_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4i_debug(GLint x, GLint y, GLint z, GLint w, const char* file, int line);
#ifndef glVertex4iv
#define glVertex4iv(v) glatter_glVertex4iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4iv_debug(const GLint *v, const char* file, int line);
#ifndef glVertex4s
#define glVertex4s(x, y, z, w) glatter_glVertex4s_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4s_debug(GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line);
#ifndef glVertex4sv
#define glVertex4sv(v) glatter_glVertex4sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4sv_debug(const GLshort *v, const char* file, int line);
#ifndef glVertexPointer
#define glVertexPointer(size, type, stride, pointer) glatter_glVertexPointer_debug((size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexPointer_debug(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line);
#ifndef glViewport
#define glViewport(x, y, width, height) glatter_glViewport_debug((x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glViewport_debug(GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#endif // defined(__gl_h_)
#endif // !defined(GL_VERSION_ES_CM_1_0)
#endif // defined(__GL_H__)
#if defined(__gl_glext_h_)
#if defined(GL_3DFX_tbuffer)
#ifndef glTbufferMask3DFX
#define glTbufferMask3DFX(mask) glatter_glTbufferMask3DFX_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTbufferMask3DFX_debug(GLuint mask, const char* file, int line);
#endif // defined(GL_3DFX_tbuffer)
#if defined(GL_AMD_debug_output)
#ifndef glDebugMessageCallbackAMD
#define glDebugMessageCallbackAMD(callback, userParam) glatter_glDebugMessageCallbackAMD_debug((callback), (userParam), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageCallbackAMD_debug(GLDEBUGPROCAMD callback, void *userParam, const char* file, int line);
#ifndef glDebugMessageEnableAMD
#define glDebugMessageEnableAMD(category, severity, count, ids, enabled) glatter_glDebugMessageEnableAMD_debug((category), (severity), (count), (ids), (enabled), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageEnableAMD_debug(GLenum category, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled, const char* file, int line);
#ifndef glDebugMessageInsertAMD
#define glDebugMessageInsertAMD(category, severity, id, length, buf) glatter_glDebugMessageInsertAMD_debug((category), (severity), (id), (length), (buf), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageInsertAMD_debug(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar *buf, const char* file, int line);
#ifndef glGetDebugMessageLogAMD
#define glGetDebugMessageLogAMD(count, bufsize, categories, severities, ids, lengths, message) glatter_glGetDebugMessageLogAMD_debug((count), (bufsize), (categories), (severities), (ids), (lengths), (message), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGetDebugMessageLogAMD_debug(GLuint count, GLsizei bufsize, GLenum *categories, GLuint *severities, GLuint *ids, GLsizei *lengths, GLchar *message, const char* file, int line);
#endif // defined(GL_AMD_debug_output)
#if defined(GL_AMD_draw_buffers_blend)
#ifndef glBlendEquationIndexedAMD
#define glBlendEquationIndexedAMD(buf, mode) glatter_glBlendEquationIndexedAMD_debug((buf), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationIndexedAMD_debug(GLuint buf, GLenum mode, const char* file, int line);
#ifndef glBlendEquationSeparateIndexedAMD
#define glBlendEquationSeparateIndexedAMD(buf, modeRGB, modeAlpha) glatter_glBlendEquationSeparateIndexedAMD_debug((buf), (modeRGB), (modeAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparateIndexedAMD_debug(GLuint buf, GLenum modeRGB, GLenum modeAlpha, const char* file, int line);
#ifndef glBlendFuncIndexedAMD
#define glBlendFuncIndexedAMD(buf, src, dst) glatter_glBlendFuncIndexedAMD_debug((buf), (src), (dst), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncIndexedAMD_debug(GLuint buf, GLenum src, GLenum dst, const char* file, int line);
#ifndef glBlendFuncSeparateIndexedAMD
#define glBlendFuncSeparateIndexedAMD(buf, srcRGB, dstRGB, srcAlpha, dstAlpha) glatter_glBlendFuncSeparateIndexedAMD_debug((buf), (srcRGB), (dstRGB), (srcAlpha), (dstAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateIndexedAMD_debug(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha, const char* file, int line);
#endif // defined(GL_AMD_draw_buffers_blend)
#if defined(GL_AMD_framebuffer_multisample_advanced)
#ifndef glNamedRenderbufferStorageMultisampleAdvancedAMD
#define glNamedRenderbufferStorageMultisampleAdvancedAMD(renderbuffer, samples, storageSamples, internalformat, width, height) glatter_glNamedRenderbufferStorageMultisampleAdvancedAMD_debug((renderbuffer), (samples), (storageSamples), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageMultisampleAdvancedAMD_debug(GLuint renderbuffer, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glRenderbufferStorageMultisampleAdvancedAMD
#define glRenderbufferStorageMultisampleAdvancedAMD(target, samples, storageSamples, internalformat, width, height) glatter_glRenderbufferStorageMultisampleAdvancedAMD_debug((target), (samples), (storageSamples), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleAdvancedAMD_debug(GLenum target, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#endif // defined(GL_AMD_framebuffer_multisample_advanced)
#if defined(GL_AMD_framebuffer_sample_positions)
#ifndef glFramebufferSamplePositionsfvAMD
#define glFramebufferSamplePositionsfvAMD(target, numsamples, pixelindex, values) glatter_glFramebufferSamplePositionsfvAMD_debug((target), (numsamples), (pixelindex), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferSamplePositionsfvAMD_debug(GLenum target, GLuint numsamples, GLuint pixelindex, const GLfloat *values, const char* file, int line);
#ifndef glGetFramebufferParameterfvAMD
#define glGetFramebufferParameterfvAMD(target, pname, numsamples, pixelindex, size, values) glatter_glGetFramebufferParameterfvAMD_debug((target), (pname), (numsamples), (pixelindex), (size), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferParameterfvAMD_debug(GLenum target, GLenum pname, GLuint numsamples, GLuint pixelindex, GLsizei size, GLfloat *values, const char* file, int line);
#ifndef glGetNamedFramebufferParameterfvAMD
#define glGetNamedFramebufferParameterfvAMD(framebuffer, pname, numsamples, pixelindex, size, values) glatter_glGetNamedFramebufferParameterfvAMD_debug((framebuffer), (pname), (numsamples), (pixelindex), (size), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedFramebufferParameterfvAMD_debug(GLuint framebuffer, GLenum pname, GLuint numsamples, GLuint pixelindex, GLsizei size, GLfloat *values, const char* file, int line);
#ifndef glNamedFramebufferSamplePositionsfvAMD
#define glNamedFramebufferSamplePositionsfvAMD(framebuffer, numsamples, pixelindex, values) glatter_glNamedFramebufferSamplePositionsfvAMD_debug((framebuffer), (numsamples), (pixelindex), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferSamplePositionsfvAMD_debug(GLuint framebuffer, GLuint numsamples, GLuint pixelindex, const GLfloat *values, const char* file, int line);
#endif // defined(GL_AMD_framebuffer_sample_positions)
#if defined(GL_AMD_gpu_shader_int64)
#ifndef glGetUniformi64vNV
#define glGetUniformi64vNV(program, location, params) glatter_glGetUniformi64vNV_debug((program), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformi64vNV_debug(GLuint program, GLint location, GLint64EXT *params, const char* file, int line);
#ifndef glGetUniformui64vNV
#define glGetUniformui64vNV(program, location, params) glatter_glGetUniformui64vNV_debug((program), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformui64vNV_debug(GLuint program, GLint location, GLuint64EXT *params, const char* file, int line);
#ifndef glProgramUniform1i64NV
#define glProgramUniform1i64NV(program, location, x) glatter_glProgramUniform1i64NV_debug((program), (location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64NV_debug(GLuint program, GLint location, GLint64EXT x, const char* file, int line);
#ifndef glProgramUniform1i64vNV
#define glProgramUniform1i64vNV(program, location, count, value) glatter_glProgramUniform1i64vNV_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line);
#ifndef glProgramUniform1ui64NV
#define glProgramUniform1ui64NV(program, location, x) glatter_glProgramUniform1ui64NV_debug((program), (location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, const char* file, int line);
#ifndef glProgramUniform1ui64vNV
#define glProgramUniform1ui64vNV(program, location, count, value) glatter_glProgramUniform1ui64vNV_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#ifndef glProgramUniform2i64NV
#define glProgramUniform2i64NV(program, location, x, y) glatter_glProgramUniform2i64NV_debug((program), (location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64NV_debug(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, const char* file, int line);
#ifndef glProgramUniform2i64vNV
#define glProgramUniform2i64vNV(program, location, count, value) glatter_glProgramUniform2i64vNV_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line);
#ifndef glProgramUniform2ui64NV
#define glProgramUniform2ui64NV(program, location, x, y) glatter_glProgramUniform2ui64NV_debug((program), (location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, const char* file, int line);
#ifndef glProgramUniform2ui64vNV
#define glProgramUniform2ui64vNV(program, location, count, value) glatter_glProgramUniform2ui64vNV_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#ifndef glProgramUniform3i64NV
#define glProgramUniform3i64NV(program, location, x, y, z) glatter_glProgramUniform3i64NV_debug((program), (location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64NV_debug(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, const char* file, int line);
#ifndef glProgramUniform3i64vNV
#define glProgramUniform3i64vNV(program, location, count, value) glatter_glProgramUniform3i64vNV_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line);
#ifndef glProgramUniform3ui64NV
#define glProgramUniform3ui64NV(program, location, x, y, z) glatter_glProgramUniform3ui64NV_debug((program), (location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, const char* file, int line);
#ifndef glProgramUniform3ui64vNV
#define glProgramUniform3ui64vNV(program, location, count, value) glatter_glProgramUniform3ui64vNV_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#ifndef glProgramUniform4i64NV
#define glProgramUniform4i64NV(program, location, x, y, z, w) glatter_glProgramUniform4i64NV_debug((program), (location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64NV_debug(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w, const char* file, int line);
#ifndef glProgramUniform4i64vNV
#define glProgramUniform4i64vNV(program, location, count, value) glatter_glProgramUniform4i64vNV_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line);
#ifndef glProgramUniform4ui64NV
#define glProgramUniform4ui64NV(program, location, x, y, z, w) glatter_glProgramUniform4ui64NV_debug((program), (location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w, const char* file, int line);
#ifndef glProgramUniform4ui64vNV
#define glProgramUniform4ui64vNV(program, location, count, value) glatter_glProgramUniform4ui64vNV_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#ifndef glUniform1i64NV
#define glUniform1i64NV(location, x) glatter_glUniform1i64NV_debug((location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64NV_debug(GLint location, GLint64EXT x, const char* file, int line);
#ifndef glUniform1i64vNV
#define glUniform1i64vNV(location, count, value) glatter_glUniform1i64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line);
#ifndef glUniform1ui64NV
#define glUniform1ui64NV(location, x) glatter_glUniform1ui64NV_debug((location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64NV_debug(GLint location, GLuint64EXT x, const char* file, int line);
#ifndef glUniform1ui64vNV
#define glUniform1ui64vNV(location, count, value) glatter_glUniform1ui64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#ifndef glUniform2i64NV
#define glUniform2i64NV(location, x, y) glatter_glUniform2i64NV_debug((location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64NV_debug(GLint location, GLint64EXT x, GLint64EXT y, const char* file, int line);
#ifndef glUniform2i64vNV
#define glUniform2i64vNV(location, count, value) glatter_glUniform2i64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line);
#ifndef glUniform2ui64NV
#define glUniform2ui64NV(location, x, y) glatter_glUniform2ui64NV_debug((location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64NV_debug(GLint location, GLuint64EXT x, GLuint64EXT y, const char* file, int line);
#ifndef glUniform2ui64vNV
#define glUniform2ui64vNV(location, count, value) glatter_glUniform2ui64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#ifndef glUniform3i64NV
#define glUniform3i64NV(location, x, y, z) glatter_glUniform3i64NV_debug((location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64NV_debug(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, const char* file, int line);
#ifndef glUniform3i64vNV
#define glUniform3i64vNV(location, count, value) glatter_glUniform3i64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line);
#ifndef glUniform3ui64NV
#define glUniform3ui64NV(location, x, y, z) glatter_glUniform3ui64NV_debug((location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64NV_debug(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, const char* file, int line);
#ifndef glUniform3ui64vNV
#define glUniform3ui64vNV(location, count, value) glatter_glUniform3ui64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#ifndef glUniform4i64NV
#define glUniform4i64NV(location, x, y, z, w) glatter_glUniform4i64NV_debug((location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64NV_debug(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w, const char* file, int line);
#ifndef glUniform4i64vNV
#define glUniform4i64vNV(location, count, value) glatter_glUniform4i64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line);
#ifndef glUniform4ui64NV
#define glUniform4ui64NV(location, x, y, z, w) glatter_glUniform4ui64NV_debug((location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64NV_debug(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w, const char* file, int line);
#ifndef glUniform4ui64vNV
#define glUniform4ui64vNV(location, count, value) glatter_glUniform4ui64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#endif // defined(GL_AMD_gpu_shader_int64)
#if defined(GL_AMD_interleaved_elements)
#ifndef glVertexAttribParameteriAMD
#define glVertexAttribParameteriAMD(index, pname, param) glatter_glVertexAttribParameteriAMD_debug((index), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribParameteriAMD_debug(GLuint index, GLenum pname, GLint param, const char* file, int line);
#endif // defined(GL_AMD_interleaved_elements)
#if defined(GL_AMD_multi_draw_indirect)
#ifndef glMultiDrawArraysIndirectAMD
#define glMultiDrawArraysIndirectAMD(mode, indirect, primcount, stride) glatter_glMultiDrawArraysIndirectAMD_debug((mode), (indirect), (primcount), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectAMD_debug(GLenum mode, const void *indirect, GLsizei primcount, GLsizei stride, const char* file, int line);
#ifndef glMultiDrawElementsIndirectAMD
#define glMultiDrawElementsIndirectAMD(mode, type, indirect, primcount, stride) glatter_glMultiDrawElementsIndirectAMD_debug((mode), (type), (indirect), (primcount), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectAMD_debug(GLenum mode, GLenum type, const void *indirect, GLsizei primcount, GLsizei stride, const char* file, int line);
#endif // defined(GL_AMD_multi_draw_indirect)
#if defined(GL_AMD_name_gen_delete)
#ifndef glDeleteNamesAMD
#define glDeleteNamesAMD(identifier, num, names) glatter_glDeleteNamesAMD_debug((identifier), (num), (names), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteNamesAMD_debug(GLenum identifier, GLuint num, const GLuint *names, const char* file, int line);
#ifndef glGenNamesAMD
#define glGenNamesAMD(identifier, num, names) glatter_glGenNamesAMD_debug((identifier), (num), (names), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenNamesAMD_debug(GLenum identifier, GLuint num, GLuint *names, const char* file, int line);
#ifndef glIsNameAMD
#define glIsNameAMD(identifier, name) glatter_glIsNameAMD_debug((identifier), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsNameAMD_debug(GLenum identifier, GLuint name, const char* file, int line);
#endif // defined(GL_AMD_name_gen_delete)
#if defined(GL_AMD_occlusion_query_event)
#ifndef glQueryObjectParameteruiAMD
#define glQueryObjectParameteruiAMD(target, id, pname, param) glatter_glQueryObjectParameteruiAMD_debug((target), (id), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glQueryObjectParameteruiAMD_debug(GLenum target, GLuint id, GLenum pname, GLuint param, const char* file, int line);
#endif // defined(GL_AMD_occlusion_query_event)
#if defined(GL_AMD_performance_monitor)
#ifndef glBeginPerfMonitorAMD
#define glBeginPerfMonitorAMD(monitor) glatter_glBeginPerfMonitorAMD_debug((monitor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginPerfMonitorAMD_debug(GLuint monitor, const char* file, int line);
#ifndef glDeletePerfMonitorsAMD
#define glDeletePerfMonitorsAMD(n, monitors) glatter_glDeletePerfMonitorsAMD_debug((n), (monitors), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeletePerfMonitorsAMD_debug(GLsizei n, GLuint *monitors, const char* file, int line);
#ifndef glEndPerfMonitorAMD
#define glEndPerfMonitorAMD(monitor) glatter_glEndPerfMonitorAMD_debug((monitor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndPerfMonitorAMD_debug(GLuint monitor, const char* file, int line);
#ifndef glGenPerfMonitorsAMD
#define glGenPerfMonitorsAMD(n, monitors) glatter_glGenPerfMonitorsAMD_debug((n), (monitors), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenPerfMonitorsAMD_debug(GLsizei n, GLuint *monitors, const char* file, int line);
#ifndef glGetPerfMonitorCounterDataAMD
#define glGetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten) glatter_glGetPerfMonitorCounterDataAMD_debug((monitor), (pname), (dataSize), (data), (bytesWritten), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCounterDataAMD_debug(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten, const char* file, int line);
#ifndef glGetPerfMonitorCounterInfoAMD
#define glGetPerfMonitorCounterInfoAMD(group, counter, pname, data) glatter_glGetPerfMonitorCounterInfoAMD_debug((group), (counter), (pname), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCounterInfoAMD_debug(GLuint group, GLuint counter, GLenum pname, void *data, const char* file, int line);
#ifndef glGetPerfMonitorCounterStringAMD
#define glGetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString) glatter_glGetPerfMonitorCounterStringAMD_debug((group), (counter), (bufSize), (length), (counterString), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCounterStringAMD_debug(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString, const char* file, int line);
#ifndef glGetPerfMonitorCountersAMD
#define glGetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize, counters) glatter_glGetPerfMonitorCountersAMD_debug((group), (numCounters), (maxActiveCounters), (counterSize), (counters), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCountersAMD_debug(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters, const char* file, int line);
#ifndef glGetPerfMonitorGroupStringAMD
#define glGetPerfMonitorGroupStringAMD(group, bufSize, length, groupString) glatter_glGetPerfMonitorGroupStringAMD_debug((group), (bufSize), (length), (groupString), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorGroupStringAMD_debug(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString, const char* file, int line);
#ifndef glGetPerfMonitorGroupsAMD
#define glGetPerfMonitorGroupsAMD(numGroups, groupsSize, groups) glatter_glGetPerfMonitorGroupsAMD_debug((numGroups), (groupsSize), (groups), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorGroupsAMD_debug(GLint *numGroups, GLsizei groupsSize, GLuint *groups, const char* file, int line);
#ifndef glSelectPerfMonitorCountersAMD
#define glSelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, counterList) glatter_glSelectPerfMonitorCountersAMD_debug((monitor), (enable), (group), (numCounters), (counterList), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSelectPerfMonitorCountersAMD_debug(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList, const char* file, int line);
#endif // defined(GL_AMD_performance_monitor)
#if defined(GL_AMD_sample_positions)
#ifndef glSetMultisamplefvAMD
#define glSetMultisamplefvAMD(pname, index, val) glatter_glSetMultisamplefvAMD_debug((pname), (index), (val), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSetMultisamplefvAMD_debug(GLenum pname, GLuint index, const GLfloat *val, const char* file, int line);
#endif // defined(GL_AMD_sample_positions)
#if defined(GL_AMD_sparse_texture)
#ifndef glTexStorageSparseAMD
#define glTexStorageSparseAMD(target, internalFormat, width, height, depth, layers, flags) glatter_glTexStorageSparseAMD_debug((target), (internalFormat), (width), (height), (depth), (layers), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorageSparseAMD_debug(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags, const char* file, int line);
#ifndef glTextureStorageSparseAMD
#define glTextureStorageSparseAMD(texture, target, internalFormat, width, height, depth, layers, flags) glatter_glTextureStorageSparseAMD_debug((texture), (target), (internalFormat), (width), (height), (depth), (layers), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageSparseAMD_debug(GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags, const char* file, int line);
#endif // defined(GL_AMD_sparse_texture)
#if defined(GL_AMD_stencil_operation_extended)
#ifndef glStencilOpValueAMD
#define glStencilOpValueAMD(face, value) glatter_glStencilOpValueAMD_debug((face), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilOpValueAMD_debug(GLenum face, GLuint value, const char* file, int line);
#endif // defined(GL_AMD_stencil_operation_extended)
#if defined(GL_AMD_vertex_shader_tessellator)
#ifndef glTessellationFactorAMD
#define glTessellationFactorAMD(factor) glatter_glTessellationFactorAMD_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTessellationFactorAMD_debug(GLfloat factor, const char* file, int line);
#ifndef glTessellationModeAMD
#define glTessellationModeAMD(mode) glatter_glTessellationModeAMD_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTessellationModeAMD_debug(GLenum mode, const char* file, int line);
#endif // defined(GL_AMD_vertex_shader_tessellator)
#if defined(GL_APPLE_element_array)
#ifndef glDrawElementArrayAPPLE
#define glDrawElementArrayAPPLE(mode, first, count) glatter_glDrawElementArrayAPPLE_debug((mode), (first), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementArrayAPPLE_debug(GLenum mode, GLint first, GLsizei count, const char* file, int line);
#ifndef glDrawRangeElementArrayAPPLE
#define glDrawRangeElementArrayAPPLE(mode, start, end, first, count) glatter_glDrawRangeElementArrayAPPLE_debug((mode), (start), (end), (first), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementArrayAPPLE_debug(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count, const char* file, int line);
#ifndef glElementPointerAPPLE
#define glElementPointerAPPLE(type, pointer) glatter_glElementPointerAPPLE_debug((type), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glElementPointerAPPLE_debug(GLenum type, const void *pointer, const char* file, int line);
#ifndef glMultiDrawElementArrayAPPLE
#define glMultiDrawElementArrayAPPLE(mode, first, count, primcount) glatter_glMultiDrawElementArrayAPPLE_debug((mode), (first), (count), (primcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementArrayAPPLE_debug(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount, const char* file, int line);
#ifndef glMultiDrawRangeElementArrayAPPLE
#define glMultiDrawRangeElementArrayAPPLE(mode, start, end, first, count, primcount) glatter_glMultiDrawRangeElementArrayAPPLE_debug((mode), (start), (end), (first), (count), (primcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawRangeElementArrayAPPLE_debug(GLenum mode, GLuint start, GLuint end, const GLint *first, const GLsizei *count, GLsizei primcount, const char* file, int line);
#endif // defined(GL_APPLE_element_array)
#if defined(GL_APPLE_fence)
#ifndef glDeleteFencesAPPLE
#define glDeleteFencesAPPLE(n, fences) glatter_glDeleteFencesAPPLE_debug((n), (fences), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteFencesAPPLE_debug(GLsizei n, const GLuint *fences, const char* file, int line);
#ifndef glFinishFenceAPPLE
#define glFinishFenceAPPLE(fence) glatter_glFinishFenceAPPLE_debug((fence), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFinishFenceAPPLE_debug(GLuint fence, const char* file, int line);
#ifndef glFinishObjectAPPLE
#define glFinishObjectAPPLE(object, name) glatter_glFinishObjectAPPLE_debug((object), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFinishObjectAPPLE_debug(GLenum object, GLint name, const char* file, int line);
#ifndef glGenFencesAPPLE
#define glGenFencesAPPLE(n, fences) glatter_glGenFencesAPPLE_debug((n), (fences), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenFencesAPPLE_debug(GLsizei n, GLuint *fences, const char* file, int line);
#ifndef glIsFenceAPPLE
#define glIsFenceAPPLE(fence) glatter_glIsFenceAPPLE_debug((fence), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFenceAPPLE_debug(GLuint fence, const char* file, int line);
#ifndef glSetFenceAPPLE
#define glSetFenceAPPLE(fence) glatter_glSetFenceAPPLE_debug((fence), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSetFenceAPPLE_debug(GLuint fence, const char* file, int line);
#ifndef glTestFenceAPPLE
#define glTestFenceAPPLE(fence) glatter_glTestFenceAPPLE_debug((fence), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glTestFenceAPPLE_debug(GLuint fence, const char* file, int line);
#ifndef glTestObjectAPPLE
#define glTestObjectAPPLE(object, name) glatter_glTestObjectAPPLE_debug((object), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glTestObjectAPPLE_debug(GLenum object, GLuint name, const char* file, int line);
#endif // defined(GL_APPLE_fence)
#if defined(GL_APPLE_flush_buffer_range)
#ifndef glBufferParameteriAPPLE
#define glBufferParameteriAPPLE(target, pname, param) glatter_glBufferParameteriAPPLE_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferParameteriAPPLE_debug(GLenum target, GLenum pname, GLint param, const char* file, int line);
#ifndef glFlushMappedBufferRangeAPPLE
#define glFlushMappedBufferRangeAPPLE(target, offset, size) glatter_glFlushMappedBufferRangeAPPLE_debug((target), (offset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlushMappedBufferRangeAPPLE_debug(GLenum target, GLintptr offset, GLsizeiptr size, const char* file, int line);
#endif // defined(GL_APPLE_flush_buffer_range)
#if defined(GL_APPLE_object_purgeable)
#ifndef glGetObjectParameterivAPPLE
#define glGetObjectParameterivAPPLE(objectType, name, pname, params) glatter_glGetObjectParameterivAPPLE_debug((objectType), (name), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetObjectParameterivAPPLE_debug(GLenum objectType, GLuint name, GLenum pname, GLint *params, const char* file, int line);
#ifndef glObjectPurgeableAPPLE
#define glObjectPurgeableAPPLE(objectType, name, option) glatter_glObjectPurgeableAPPLE_debug((objectType), (name), (option), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glObjectPurgeableAPPLE_debug(GLenum objectType, GLuint name, GLenum option, const char* file, int line);
#ifndef glObjectUnpurgeableAPPLE
#define glObjectUnpurgeableAPPLE(objectType, name, option) glatter_glObjectUnpurgeableAPPLE_debug((objectType), (name), (option), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glObjectUnpurgeableAPPLE_debug(GLenum objectType, GLuint name, GLenum option, const char* file, int line);
#endif // defined(GL_APPLE_object_purgeable)
#if defined(GL_APPLE_texture_range)
#ifndef glGetTexParameterPointervAPPLE
#define glGetTexParameterPointervAPPLE(target, pname, params) glatter_glGetTexParameterPointervAPPLE_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterPointervAPPLE_debug(GLenum target, GLenum pname, void **params, const char* file, int line);
#ifndef glTextureRangeAPPLE
#define glTextureRangeAPPLE(target, length, pointer) glatter_glTextureRangeAPPLE_debug((target), (length), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureRangeAPPLE_debug(GLenum target, GLsizei length, const void *pointer, const char* file, int line);
#endif // defined(GL_APPLE_texture_range)
#if defined(GL_APPLE_vertex_array_object)
#ifndef glBindVertexArrayAPPLE
#define glBindVertexArrayAPPLE(array) glatter_glBindVertexArrayAPPLE_debug((array), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindVertexArrayAPPLE_debug(GLuint array, const char* file, int line);
#ifndef glDeleteVertexArraysAPPLE
#define glDeleteVertexArraysAPPLE(n, arrays) glatter_glDeleteVertexArraysAPPLE_debug((n), (arrays), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteVertexArraysAPPLE_debug(GLsizei n, const GLuint *arrays, const char* file, int line);
#ifndef glGenVertexArraysAPPLE
#define glGenVertexArraysAPPLE(n, arrays) glatter_glGenVertexArraysAPPLE_debug((n), (arrays), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenVertexArraysAPPLE_debug(GLsizei n, GLuint *arrays, const char* file, int line);
#ifndef glIsVertexArrayAPPLE
#define glIsVertexArrayAPPLE(array) glatter_glIsVertexArrayAPPLE_debug((array), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVertexArrayAPPLE_debug(GLuint array, const char* file, int line);
#endif // defined(GL_APPLE_vertex_array_object)
#if defined(GL_APPLE_vertex_array_range)
#ifndef glFlushVertexArrayRangeAPPLE
#define glFlushVertexArrayRangeAPPLE(length, pointer) glatter_glFlushVertexArrayRangeAPPLE_debug((length), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlushVertexArrayRangeAPPLE_debug(GLsizei length, void *pointer, const char* file, int line);
#ifndef glVertexArrayParameteriAPPLE
#define glVertexArrayParameteriAPPLE(pname, param) glatter_glVertexArrayParameteriAPPLE_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayParameteriAPPLE_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glVertexArrayRangeAPPLE
#define glVertexArrayRangeAPPLE(length, pointer) glatter_glVertexArrayRangeAPPLE_debug((length), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayRangeAPPLE_debug(GLsizei length, void *pointer, const char* file, int line);
#endif // defined(GL_APPLE_vertex_array_range)
#if defined(GL_APPLE_vertex_program_evaluators)
#ifndef glDisableVertexAttribAPPLE
#define glDisableVertexAttribAPPLE(index, pname) glatter_glDisableVertexAttribAPPLE_debug((index), (pname), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexAttribAPPLE_debug(GLuint index, GLenum pname, const char* file, int line);
#ifndef glEnableVertexAttribAPPLE
#define glEnableVertexAttribAPPLE(index, pname) glatter_glEnableVertexAttribAPPLE_debug((index), (pname), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexAttribAPPLE_debug(GLuint index, GLenum pname, const char* file, int line);
#ifndef glIsVertexAttribEnabledAPPLE
#define glIsVertexAttribEnabledAPPLE(index, pname) glatter_glIsVertexAttribEnabledAPPLE_debug((index), (pname), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVertexAttribEnabledAPPLE_debug(GLuint index, GLenum pname, const char* file, int line);
#ifndef glMapVertexAttrib1dAPPLE
#define glMapVertexAttrib1dAPPLE(index, size, u1, u2, stride, order, points) glatter_glMapVertexAttrib1dAPPLE_debug((index), (size), (u1), (u2), (stride), (order), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapVertexAttrib1dAPPLE_debug(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points, const char* file, int line);
#ifndef glMapVertexAttrib1fAPPLE
#define glMapVertexAttrib1fAPPLE(index, size, u1, u2, stride, order, points) glatter_glMapVertexAttrib1fAPPLE_debug((index), (size), (u1), (u2), (stride), (order), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapVertexAttrib1fAPPLE_debug(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points, const char* file, int line);
#ifndef glMapVertexAttrib2dAPPLE
#define glMapVertexAttrib2dAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points) glatter_glMapVertexAttrib2dAPPLE_debug((index), (size), (u1), (u2), (ustride), (uorder), (v1), (v2), (vstride), (vorder), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapVertexAttrib2dAPPLE_debug(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points, const char* file, int line);
#ifndef glMapVertexAttrib2fAPPLE
#define glMapVertexAttrib2fAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points) glatter_glMapVertexAttrib2fAPPLE_debug((index), (size), (u1), (u2), (ustride), (uorder), (v1), (v2), (vstride), (vorder), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapVertexAttrib2fAPPLE_debug(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points, const char* file, int line);
#endif // defined(GL_APPLE_vertex_program_evaluators)
#if defined(GL_ARB_ES3_2_compatibility)
#ifndef glPrimitiveBoundingBoxARB
#define glPrimitiveBoundingBoxARB(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW) glatter_glPrimitiveBoundingBoxARB_debug((minX), (minY), (minZ), (minW), (maxX), (maxY), (maxZ), (maxW), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveBoundingBoxARB_debug(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW, const char* file, int line);
#endif // defined(GL_ARB_ES3_2_compatibility)
#if defined(GL_ARB_bindless_texture)
#ifndef glGetImageHandleARB
#define glGetImageHandleARB(texture, level, layered, layer, format) glatter_glGetImageHandleARB_debug((texture), (level), (layered), (layer), (format), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetImageHandleARB_debug(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format, const char* file, int line);
#ifndef glGetTextureHandleARB
#define glGetTextureHandleARB(texture) glatter_glGetTextureHandleARB_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureHandleARB_debug(GLuint texture, const char* file, int line);
#ifndef glGetTextureSamplerHandleARB
#define glGetTextureSamplerHandleARB(texture, sampler) glatter_glGetTextureSamplerHandleARB_debug((texture), (sampler), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureSamplerHandleARB_debug(GLuint texture, GLuint sampler, const char* file, int line);
#ifndef glGetVertexAttribLui64vARB
#define glGetVertexAttribLui64vARB(index, pname, params) glatter_glGetVertexAttribLui64vARB_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribLui64vARB_debug(GLuint index, GLenum pname, GLuint64EXT *params, const char* file, int line);
#ifndef glIsImageHandleResidentARB
#define glIsImageHandleResidentARB(handle) glatter_glIsImageHandleResidentARB_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsImageHandleResidentARB_debug(GLuint64 handle, const char* file, int line);
#ifndef glIsTextureHandleResidentARB
#define glIsTextureHandleResidentARB(handle) glatter_glIsTextureHandleResidentARB_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTextureHandleResidentARB_debug(GLuint64 handle, const char* file, int line);
#ifndef glMakeImageHandleNonResidentARB
#define glMakeImageHandleNonResidentARB(handle) glatter_glMakeImageHandleNonResidentARB_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleNonResidentARB_debug(GLuint64 handle, const char* file, int line);
#ifndef glMakeImageHandleResidentARB
#define glMakeImageHandleResidentARB(handle, access) glatter_glMakeImageHandleResidentARB_debug((handle), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleResidentARB_debug(GLuint64 handle, GLenum access, const char* file, int line);
#ifndef glMakeTextureHandleNonResidentARB
#define glMakeTextureHandleNonResidentARB(handle) glatter_glMakeTextureHandleNonResidentARB_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleNonResidentARB_debug(GLuint64 handle, const char* file, int line);
#ifndef glMakeTextureHandleResidentARB
#define glMakeTextureHandleResidentARB(handle) glatter_glMakeTextureHandleResidentARB_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleResidentARB_debug(GLuint64 handle, const char* file, int line);
#ifndef glProgramUniformHandleui64ARB
#define glProgramUniformHandleui64ARB(program, location, value) glatter_glProgramUniformHandleui64ARB_debug((program), (location), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64ARB_debug(GLuint program, GLint location, GLuint64 value, const char* file, int line);
#ifndef glProgramUniformHandleui64vARB
#define glProgramUniformHandleui64vARB(program, location, count, values) glatter_glProgramUniformHandleui64vARB_debug((program), (location), (count), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *values, const char* file, int line);
#ifndef glUniformHandleui64ARB
#define glUniformHandleui64ARB(location, value) glatter_glUniformHandleui64ARB_debug((location), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64ARB_debug(GLint location, GLuint64 value, const char* file, int line);
#ifndef glUniformHandleui64vARB
#define glUniformHandleui64vARB(location, count, value) glatter_glUniformHandleui64vARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#ifndef glVertexAttribL1ui64ARB
#define glVertexAttribL1ui64ARB(index, x) glatter_glVertexAttribL1ui64ARB_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1ui64ARB_debug(GLuint index, GLuint64EXT x, const char* file, int line);
#ifndef glVertexAttribL1ui64vARB
#define glVertexAttribL1ui64vARB(index, v) glatter_glVertexAttribL1ui64vARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1ui64vARB_debug(GLuint index, const GLuint64EXT *v, const char* file, int line);
#endif // defined(GL_ARB_bindless_texture)
#if defined(GL_ARB_cl_event)
#ifndef glCreateSyncFromCLeventARB
#define glCreateSyncFromCLeventARB(context, event, flags) glatter_glCreateSyncFromCLeventARB_debug((context), (event), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLsync glatter_glCreateSyncFromCLeventARB_debug(struct _cl_context *context, struct _cl_event *event, GLbitfield flags, const char* file, int line);
#endif // defined(GL_ARB_cl_event)
#if defined(GL_ARB_color_buffer_float)
#ifndef glClampColorARB
#define glClampColorARB(target, clamp) glatter_glClampColorARB_debug((target), (clamp), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClampColorARB_debug(GLenum target, GLenum clamp, const char* file, int line);
#endif // defined(GL_ARB_color_buffer_float)
#if defined(GL_ARB_compute_variable_group_size)
#ifndef glDispatchComputeGroupSizeARB
#define glDispatchComputeGroupSizeARB(num_groups_x, num_groups_y, num_groups_z, group_size_x, group_size_y, group_size_z) glatter_glDispatchComputeGroupSizeARB_debug((num_groups_x), (num_groups_y), (num_groups_z), (group_size_x), (group_size_y), (group_size_z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDispatchComputeGroupSizeARB_debug(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z, const char* file, int line);
#endif // defined(GL_ARB_compute_variable_group_size)
#if defined(GL_ARB_debug_output)
#ifndef glDebugMessageCallbackARB
#define glDebugMessageCallbackARB(callback, userParam) glatter_glDebugMessageCallbackARB_debug((callback), (userParam), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageCallbackARB_debug(GLDEBUGPROCARB callback, const void *userParam, const char* file, int line);
#ifndef glDebugMessageControlARB
#define glDebugMessageControlARB(source, type, severity, count, ids, enabled) glatter_glDebugMessageControlARB_debug((source), (type), (severity), (count), (ids), (enabled), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageControlARB_debug(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled, const char* file, int line);
#ifndef glDebugMessageInsertARB
#define glDebugMessageInsertARB(source, type, id, severity, length, buf) glatter_glDebugMessageInsertARB_debug((source), (type), (id), (severity), (length), (buf), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageInsertARB_debug(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf, const char* file, int line);
#ifndef glGetDebugMessageLogARB
#define glGetDebugMessageLogARB(count, bufSize, sources, types, ids, severities, lengths, messageLog) glatter_glGetDebugMessageLogARB_debug((count), (bufSize), (sources), (types), (ids), (severities), (lengths), (messageLog), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGetDebugMessageLogARB_debug(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog, const char* file, int line);
#endif // defined(GL_ARB_debug_output)
#if defined(GL_ARB_draw_buffers)
#ifndef glDrawBuffersARB
#define glDrawBuffersARB(n, bufs) glatter_glDrawBuffersARB_debug((n), (bufs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffersARB_debug(GLsizei n, const GLenum *bufs, const char* file, int line);
#endif // defined(GL_ARB_draw_buffers)
#if defined(GL_ARB_draw_buffers_blend)
#ifndef glBlendEquationSeparateiARB
#define glBlendEquationSeparateiARB(buf, modeRGB, modeAlpha) glatter_glBlendEquationSeparateiARB_debug((buf), (modeRGB), (modeAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparateiARB_debug(GLuint buf, GLenum modeRGB, GLenum modeAlpha, const char* file, int line);
#ifndef glBlendEquationiARB
#define glBlendEquationiARB(buf, mode) glatter_glBlendEquationiARB_debug((buf), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationiARB_debug(GLuint buf, GLenum mode, const char* file, int line);
#ifndef glBlendFuncSeparateiARB
#define glBlendFuncSeparateiARB(buf, srcRGB, dstRGB, srcAlpha, dstAlpha) glatter_glBlendFuncSeparateiARB_debug((buf), (srcRGB), (dstRGB), (srcAlpha), (dstAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateiARB_debug(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha, const char* file, int line);
#ifndef glBlendFunciARB
#define glBlendFunciARB(buf, src, dst) glatter_glBlendFunciARB_debug((buf), (src), (dst), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFunciARB_debug(GLuint buf, GLenum src, GLenum dst, const char* file, int line);
#endif // defined(GL_ARB_draw_buffers_blend)
#if defined(GL_ARB_draw_instanced)
#ifndef glDrawArraysInstancedARB
#define glDrawArraysInstancedARB(mode, first, count, primcount) glatter_glDrawArraysInstancedARB_debug((mode), (first), (count), (primcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstancedARB_debug(GLenum mode, GLint first, GLsizei count, GLsizei primcount, const char* file, int line);
#ifndef glDrawElementsInstancedARB
#define glDrawElementsInstancedARB(mode, count, type, indices, primcount) glatter_glDrawElementsInstancedARB_debug((mode), (count), (type), (indices), (primcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedARB_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, const char* file, int line);
#endif // defined(GL_ARB_draw_instanced)
#if defined(GL_ARB_fragment_program)
#ifndef glBindProgramARB
#define glBindProgramARB(target, program) glatter_glBindProgramARB_debug((target), (program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindProgramARB_debug(GLenum target, GLuint program, const char* file, int line);
#ifndef glDeleteProgramsARB
#define glDeleteProgramsARB(n, programs) glatter_glDeleteProgramsARB_debug((n), (programs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteProgramsARB_debug(GLsizei n, const GLuint *programs, const char* file, int line);
#ifndef glGenProgramsARB
#define glGenProgramsARB(n, programs) glatter_glGenProgramsARB_debug((n), (programs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenProgramsARB_debug(GLsizei n, GLuint *programs, const char* file, int line);
#ifndef glGetProgramEnvParameterdvARB
#define glGetProgramEnvParameterdvARB(target, index, params) glatter_glGetProgramEnvParameterdvARB_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramEnvParameterdvARB_debug(GLenum target, GLuint index, GLdouble *params, const char* file, int line);
#ifndef glGetProgramEnvParameterfvARB
#define glGetProgramEnvParameterfvARB(target, index, params) glatter_glGetProgramEnvParameterfvARB_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramEnvParameterfvARB_debug(GLenum target, GLuint index, GLfloat *params, const char* file, int line);
#ifndef glGetProgramLocalParameterdvARB
#define glGetProgramLocalParameterdvARB(target, index, params) glatter_glGetProgramLocalParameterdvARB_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramLocalParameterdvARB_debug(GLenum target, GLuint index, GLdouble *params, const char* file, int line);
#ifndef glGetProgramLocalParameterfvARB
#define glGetProgramLocalParameterfvARB(target, index, params) glatter_glGetProgramLocalParameterfvARB_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramLocalParameterfvARB_debug(GLenum target, GLuint index, GLfloat *params, const char* file, int line);
#ifndef glGetProgramStringARB
#define glGetProgramStringARB(target, pname, string) glatter_glGetProgramStringARB_debug((target), (pname), (string), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramStringARB_debug(GLenum target, GLenum pname, void *string, const char* file, int line);
#ifndef glGetProgramivARB
#define glGetProgramivARB(target, pname, params) glatter_glGetProgramivARB_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramivARB_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsProgramARB
#define glIsProgramARB(program) glatter_glIsProgramARB_debug((program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsProgramARB_debug(GLuint program, const char* file, int line);
#ifndef glProgramEnvParameter4dARB
#define glProgramEnvParameter4dARB(target, index, x, y, z, w) glatter_glProgramEnvParameter4dARB_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameter4dARB_debug(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glProgramEnvParameter4dvARB
#define glProgramEnvParameter4dvARB(target, index, params) glatter_glProgramEnvParameter4dvARB_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameter4dvARB_debug(GLenum target, GLuint index, const GLdouble *params, const char* file, int line);
#ifndef glProgramEnvParameter4fARB
#define glProgramEnvParameter4fARB(target, index, x, y, z, w) glatter_glProgramEnvParameter4fARB_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameter4fARB_debug(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glProgramEnvParameter4fvARB
#define glProgramEnvParameter4fvARB(target, index, params) glatter_glProgramEnvParameter4fvARB_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameter4fvARB_debug(GLenum target, GLuint index, const GLfloat *params, const char* file, int line);
#ifndef glProgramLocalParameter4dARB
#define glProgramLocalParameter4dARB(target, index, x, y, z, w) glatter_glProgramLocalParameter4dARB_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameter4dARB_debug(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glProgramLocalParameter4dvARB
#define glProgramLocalParameter4dvARB(target, index, params) glatter_glProgramLocalParameter4dvARB_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameter4dvARB_debug(GLenum target, GLuint index, const GLdouble *params, const char* file, int line);
#ifndef glProgramLocalParameter4fARB
#define glProgramLocalParameter4fARB(target, index, x, y, z, w) glatter_glProgramLocalParameter4fARB_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameter4fARB_debug(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glProgramLocalParameter4fvARB
#define glProgramLocalParameter4fvARB(target, index, params) glatter_glProgramLocalParameter4fvARB_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameter4fvARB_debug(GLenum target, GLuint index, const GLfloat *params, const char* file, int line);
#ifndef glProgramStringARB
#define glProgramStringARB(target, format, len, string) glatter_glProgramStringARB_debug((target), (format), (len), (string), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramStringARB_debug(GLenum target, GLenum format, GLsizei len, const void *string, const char* file, int line);
#endif // defined(GL_ARB_fragment_program)
#if defined(GL_ARB_geometry_shader4)
#ifndef glFramebufferTextureARB
#define glFramebufferTextureARB(target, attachment, texture, level) glatter_glFramebufferTextureARB_debug((target), (attachment), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureARB_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, const char* file, int line);
#ifndef glFramebufferTextureFaceARB
#define glFramebufferTextureFaceARB(target, attachment, texture, level, face) glatter_glFramebufferTextureFaceARB_debug((target), (attachment), (texture), (level), (face), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureFaceARB_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face, const char* file, int line);
#ifndef glFramebufferTextureLayerARB
#define glFramebufferTextureLayerARB(target, attachment, texture, level, layer) glatter_glFramebufferTextureLayerARB_debug((target), (attachment), (texture), (level), (layer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureLayerARB_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer, const char* file, int line);
#ifndef glProgramParameteriARB
#define glProgramParameteriARB(program, pname, value) glatter_glProgramParameteriARB_debug((program), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramParameteriARB_debug(GLuint program, GLenum pname, GLint value, const char* file, int line);
#endif // defined(GL_ARB_geometry_shader4)
#if defined(GL_ARB_gl_spirv)
#ifndef glSpecializeShaderARB
#define glSpecializeShaderARB(shader, pEntryPoint, numSpecializationConstants, pConstantIndex, pConstantValue) glatter_glSpecializeShaderARB_debug((shader), (pEntryPoint), (numSpecializationConstants), (pConstantIndex), (pConstantValue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSpecializeShaderARB_debug(GLuint shader, const GLchar *pEntryPoint, GLuint numSpecializationConstants, const GLuint *pConstantIndex, const GLuint *pConstantValue, const char* file, int line);
#endif // defined(GL_ARB_gl_spirv)
#if defined(GL_ARB_gpu_shader_int64)
#ifndef glGetUniformi64vARB
#define glGetUniformi64vARB(program, location, params) glatter_glGetUniformi64vARB_debug((program), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformi64vARB_debug(GLuint program, GLint location, GLint64 *params, const char* file, int line);
#ifndef glGetUniformui64vARB
#define glGetUniformui64vARB(program, location, params) glatter_glGetUniformui64vARB_debug((program), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformui64vARB_debug(GLuint program, GLint location, GLuint64 *params, const char* file, int line);
#ifndef glGetnUniformi64vARB
#define glGetnUniformi64vARB(program, location, bufSize, params) glatter_glGetnUniformi64vARB_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformi64vARB_debug(GLuint program, GLint location, GLsizei bufSize, GLint64 *params, const char* file, int line);
#ifndef glGetnUniformui64vARB
#define glGetnUniformui64vARB(program, location, bufSize, params) glatter_glGetnUniformui64vARB_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformui64vARB_debug(GLuint program, GLint location, GLsizei bufSize, GLuint64 *params, const char* file, int line);
#ifndef glProgramUniform1i64ARB
#define glProgramUniform1i64ARB(program, location, x) glatter_glProgramUniform1i64ARB_debug((program), (location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64ARB_debug(GLuint program, GLint location, GLint64 x, const char* file, int line);
#ifndef glProgramUniform1i64vARB
#define glProgramUniform1i64vARB(program, location, count, value) glatter_glProgramUniform1i64vARB_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64vARB_debug(GLuint program, GLint location, GLsizei count, const GLint64 *value, const char* file, int line);
#ifndef glProgramUniform1ui64ARB
#define glProgramUniform1ui64ARB(program, location, x) glatter_glProgramUniform1ui64ARB_debug((program), (location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64ARB_debug(GLuint program, GLint location, GLuint64 x, const char* file, int line);
#ifndef glProgramUniform1ui64vARB
#define glProgramUniform1ui64vARB(program, location, count, value) glatter_glProgramUniform1ui64vARB_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#ifndef glProgramUniform2i64ARB
#define glProgramUniform2i64ARB(program, location, x, y) glatter_glProgramUniform2i64ARB_debug((program), (location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64ARB_debug(GLuint program, GLint location, GLint64 x, GLint64 y, const char* file, int line);
#ifndef glProgramUniform2i64vARB
#define glProgramUniform2i64vARB(program, location, count, value) glatter_glProgramUniform2i64vARB_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64vARB_debug(GLuint program, GLint location, GLsizei count, const GLint64 *value, const char* file, int line);
#ifndef glProgramUniform2ui64ARB
#define glProgramUniform2ui64ARB(program, location, x, y) glatter_glProgramUniform2ui64ARB_debug((program), (location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64ARB_debug(GLuint program, GLint location, GLuint64 x, GLuint64 y, const char* file, int line);
#ifndef glProgramUniform2ui64vARB
#define glProgramUniform2ui64vARB(program, location, count, value) glatter_glProgramUniform2ui64vARB_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#ifndef glProgramUniform3i64ARB
#define glProgramUniform3i64ARB(program, location, x, y, z) glatter_glProgramUniform3i64ARB_debug((program), (location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64ARB_debug(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, const char* file, int line);
#ifndef glProgramUniform3i64vARB
#define glProgramUniform3i64vARB(program, location, count, value) glatter_glProgramUniform3i64vARB_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64vARB_debug(GLuint program, GLint location, GLsizei count, const GLint64 *value, const char* file, int line);
#ifndef glProgramUniform3ui64ARB
#define glProgramUniform3ui64ARB(program, location, x, y, z) glatter_glProgramUniform3ui64ARB_debug((program), (location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64ARB_debug(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, const char* file, int line);
#ifndef glProgramUniform3ui64vARB
#define glProgramUniform3ui64vARB(program, location, count, value) glatter_glProgramUniform3ui64vARB_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#ifndef glProgramUniform4i64ARB
#define glProgramUniform4i64ARB(program, location, x, y, z, w) glatter_glProgramUniform4i64ARB_debug((program), (location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64ARB_debug(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w, const char* file, int line);
#ifndef glProgramUniform4i64vARB
#define glProgramUniform4i64vARB(program, location, count, value) glatter_glProgramUniform4i64vARB_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64vARB_debug(GLuint program, GLint location, GLsizei count, const GLint64 *value, const char* file, int line);
#ifndef glProgramUniform4ui64ARB
#define glProgramUniform4ui64ARB(program, location, x, y, z, w) glatter_glProgramUniform4ui64ARB_debug((program), (location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64ARB_debug(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w, const char* file, int line);
#ifndef glProgramUniform4ui64vARB
#define glProgramUniform4ui64vARB(program, location, count, value) glatter_glProgramUniform4ui64vARB_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#ifndef glUniform1i64ARB
#define glUniform1i64ARB(location, x) glatter_glUniform1i64ARB_debug((location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64ARB_debug(GLint location, GLint64 x, const char* file, int line);
#ifndef glUniform1i64vARB
#define glUniform1i64vARB(location, count, value) glatter_glUniform1i64vARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64vARB_debug(GLint location, GLsizei count, const GLint64 *value, const char* file, int line);
#ifndef glUniform1ui64ARB
#define glUniform1ui64ARB(location, x) glatter_glUniform1ui64ARB_debug((location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64ARB_debug(GLint location, GLuint64 x, const char* file, int line);
#ifndef glUniform1ui64vARB
#define glUniform1ui64vARB(location, count, value) glatter_glUniform1ui64vARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#ifndef glUniform2i64ARB
#define glUniform2i64ARB(location, x, y) glatter_glUniform2i64ARB_debug((location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64ARB_debug(GLint location, GLint64 x, GLint64 y, const char* file, int line);
#ifndef glUniform2i64vARB
#define glUniform2i64vARB(location, count, value) glatter_glUniform2i64vARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64vARB_debug(GLint location, GLsizei count, const GLint64 *value, const char* file, int line);
#ifndef glUniform2ui64ARB
#define glUniform2ui64ARB(location, x, y) glatter_glUniform2ui64ARB_debug((location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64ARB_debug(GLint location, GLuint64 x, GLuint64 y, const char* file, int line);
#ifndef glUniform2ui64vARB
#define glUniform2ui64vARB(location, count, value) glatter_glUniform2ui64vARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#ifndef glUniform3i64ARB
#define glUniform3i64ARB(location, x, y, z) glatter_glUniform3i64ARB_debug((location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64ARB_debug(GLint location, GLint64 x, GLint64 y, GLint64 z, const char* file, int line);
#ifndef glUniform3i64vARB
#define glUniform3i64vARB(location, count, value) glatter_glUniform3i64vARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64vARB_debug(GLint location, GLsizei count, const GLint64 *value, const char* file, int line);
#ifndef glUniform3ui64ARB
#define glUniform3ui64ARB(location, x, y, z) glatter_glUniform3ui64ARB_debug((location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64ARB_debug(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, const char* file, int line);
#ifndef glUniform3ui64vARB
#define glUniform3ui64vARB(location, count, value) glatter_glUniform3ui64vARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#ifndef glUniform4i64ARB
#define glUniform4i64ARB(location, x, y, z, w) glatter_glUniform4i64ARB_debug((location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64ARB_debug(GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w, const char* file, int line);
#ifndef glUniform4i64vARB
#define glUniform4i64vARB(location, count, value) glatter_glUniform4i64vARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64vARB_debug(GLint location, GLsizei count, const GLint64 *value, const char* file, int line);
#ifndef glUniform4ui64ARB
#define glUniform4ui64ARB(location, x, y, z, w) glatter_glUniform4ui64ARB_debug((location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64ARB_debug(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w, const char* file, int line);
#ifndef glUniform4ui64vARB
#define glUniform4ui64vARB(location, count, value) glatter_glUniform4ui64vARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#endif // defined(GL_ARB_gpu_shader_int64)
#if defined(GL_ARB_imaging)
#ifndef glColorSubTable
#define glColorSubTable(target, start, count, format, type, data) glatter_glColorSubTable_debug((target), (start), (count), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorSubTable_debug(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data, const char* file, int line);
#ifndef glColorTable
#define glColorTable(target, internalformat, width, format, type, table) glatter_glColorTable_debug((target), (internalformat), (width), (format), (type), (table), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorTable_debug(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table, const char* file, int line);
#ifndef glColorTableParameterfv
#define glColorTableParameterfv(target, pname, params) glatter_glColorTableParameterfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorTableParameterfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glColorTableParameteriv
#define glColorTableParameteriv(target, pname, params) glatter_glColorTableParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorTableParameteriv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glConvolutionFilter1D
#define glConvolutionFilter1D(target, internalformat, width, format, type, image) glatter_glConvolutionFilter1D_debug((target), (internalformat), (width), (format), (type), (image), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionFilter1D_debug(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image, const char* file, int line);
#ifndef glConvolutionFilter2D
#define glConvolutionFilter2D(target, internalformat, width, height, format, type, image) glatter_glConvolutionFilter2D_debug((target), (internalformat), (width), (height), (format), (type), (image), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionFilter2D_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image, const char* file, int line);
#ifndef glConvolutionParameterf
#define glConvolutionParameterf(target, pname, params) glatter_glConvolutionParameterf_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterf_debug(GLenum target, GLenum pname, GLfloat params, const char* file, int line);
#ifndef glConvolutionParameterfv
#define glConvolutionParameterfv(target, pname, params) glatter_glConvolutionParameterfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glConvolutionParameteri
#define glConvolutionParameteri(target, pname, params) glatter_glConvolutionParameteri_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameteri_debug(GLenum target, GLenum pname, GLint params, const char* file, int line);
#ifndef glConvolutionParameteriv
#define glConvolutionParameteriv(target, pname, params) glatter_glConvolutionParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameteriv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glCopyColorSubTable
#define glCopyColorSubTable(target, start, x, y, width) glatter_glCopyColorSubTable_debug((target), (start), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyColorSubTable_debug(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glCopyColorTable
#define glCopyColorTable(target, internalformat, x, y, width) glatter_glCopyColorTable_debug((target), (internalformat), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyColorTable_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glCopyConvolutionFilter1D
#define glCopyConvolutionFilter1D(target, internalformat, x, y, width) glatter_glCopyConvolutionFilter1D_debug((target), (internalformat), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyConvolutionFilter1D_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glCopyConvolutionFilter2D
#define glCopyConvolutionFilter2D(target, internalformat, x, y, width, height) glatter_glCopyConvolutionFilter2D_debug((target), (internalformat), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyConvolutionFilter2D_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glGetColorTable
#define glGetColorTable(target, format, type, table) glatter_glGetColorTable_debug((target), (format), (type), (table), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetColorTable_debug(GLenum target, GLenum format, GLenum type, void *table, const char* file, int line);
#ifndef glGetColorTableParameterfv
#define glGetColorTableParameterfv(target, pname, params) glatter_glGetColorTableParameterfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetColorTableParameteriv
#define glGetColorTableParameteriv(target, pname, params) glatter_glGetColorTableParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetConvolutionFilter
#define glGetConvolutionFilter(target, format, type, image) glatter_glGetConvolutionFilter_debug((target), (format), (type), (image), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionFilter_debug(GLenum target, GLenum format, GLenum type, void *image, const char* file, int line);
#ifndef glGetConvolutionParameterfv
#define glGetConvolutionParameterfv(target, pname, params) glatter_glGetConvolutionParameterfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetConvolutionParameteriv
#define glGetConvolutionParameteriv(target, pname, params) glatter_glGetConvolutionParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetHistogram
#define glGetHistogram(target, reset, format, type, values) glatter_glGetHistogram_debug((target), (reset), (format), (type), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetHistogram_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, void *values, const char* file, int line);
#ifndef glGetHistogramParameterfv
#define glGetHistogramParameterfv(target, pname, params) glatter_glGetHistogramParameterfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetHistogramParameteriv
#define glGetHistogramParameteriv(target, pname, params) glatter_glGetHistogramParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetMinmax
#define glGetMinmax(target, reset, format, type, values) glatter_glGetMinmax_debug((target), (reset), (format), (type), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMinmax_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, void *values, const char* file, int line);
#ifndef glGetMinmaxParameterfv
#define glGetMinmaxParameterfv(target, pname, params) glatter_glGetMinmaxParameterfv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetMinmaxParameteriv
#define glGetMinmaxParameteriv(target, pname, params) glatter_glGetMinmaxParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetSeparableFilter
#define glGetSeparableFilter(target, format, type, row, column, span) glatter_glGetSeparableFilter_debug((target), (format), (type), (row), (column), (span), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetSeparableFilter_debug(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span, const char* file, int line);
#ifndef glHistogram
#define glHistogram(target, width, internalformat, sink) glatter_glHistogram_debug((target), (width), (internalformat), (sink), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glHistogram_debug(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink, const char* file, int line);
#ifndef glMinmax
#define glMinmax(target, internalformat, sink) glatter_glMinmax_debug((target), (internalformat), (sink), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMinmax_debug(GLenum target, GLenum internalformat, GLboolean sink, const char* file, int line);
#ifndef glResetHistogram
#define glResetHistogram(target) glatter_glResetHistogram_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glResetHistogram_debug(GLenum target, const char* file, int line);
#ifndef glResetMinmax
#define glResetMinmax(target) glatter_glResetMinmax_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glResetMinmax_debug(GLenum target, const char* file, int line);
#ifndef glSeparableFilter2D
#define glSeparableFilter2D(target, internalformat, width, height, format, type, row, column) glatter_glSeparableFilter2D_debug((target), (internalformat), (width), (height), (format), (type), (row), (column), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSeparableFilter2D_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column, const char* file, int line);
#endif // defined(GL_ARB_imaging)
#if defined(GL_ARB_indirect_parameters)
#ifndef glMultiDrawArraysIndirectCountARB
#define glMultiDrawArraysIndirectCountARB(mode, indirect, drawcount, maxdrawcount, stride) glatter_glMultiDrawArraysIndirectCountARB_debug((mode), (indirect), (drawcount), (maxdrawcount), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectCountARB_debug(GLenum mode, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride, const char* file, int line);
#ifndef glMultiDrawElementsIndirectCountARB
#define glMultiDrawElementsIndirectCountARB(mode, type, indirect, drawcount, maxdrawcount, stride) glatter_glMultiDrawElementsIndirectCountARB_debug((mode), (type), (indirect), (drawcount), (maxdrawcount), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectCountARB_debug(GLenum mode, GLenum type, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride, const char* file, int line);
#endif // defined(GL_ARB_indirect_parameters)
#if defined(GL_ARB_instanced_arrays)
#ifndef glVertexAttribDivisorARB
#define glVertexAttribDivisorARB(index, divisor) glatter_glVertexAttribDivisorARB_debug((index), (divisor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribDivisorARB_debug(GLuint index, GLuint divisor, const char* file, int line);
#endif // defined(GL_ARB_instanced_arrays)
#if defined(GL_ARB_matrix_palette)
#ifndef glCurrentPaletteMatrixARB
#define glCurrentPaletteMatrixARB(index) glatter_glCurrentPaletteMatrixARB_debug((index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCurrentPaletteMatrixARB_debug(GLint index, const char* file, int line);
#ifndef glMatrixIndexPointerARB
#define glMatrixIndexPointerARB(size, type, stride, pointer) glatter_glMatrixIndexPointerARB_debug((size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixIndexPointerARB_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glMatrixIndexubvARB
#define glMatrixIndexubvARB(size, indices) glatter_glMatrixIndexubvARB_debug((size), (indices), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixIndexubvARB_debug(GLint size, const GLubyte *indices, const char* file, int line);
#ifndef glMatrixIndexuivARB
#define glMatrixIndexuivARB(size, indices) glatter_glMatrixIndexuivARB_debug((size), (indices), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixIndexuivARB_debug(GLint size, const GLuint *indices, const char* file, int line);
#ifndef glMatrixIndexusvARB
#define glMatrixIndexusvARB(size, indices) glatter_glMatrixIndexusvARB_debug((size), (indices), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixIndexusvARB_debug(GLint size, const GLushort *indices, const char* file, int line);
#endif // defined(GL_ARB_matrix_palette)
#if defined(GL_ARB_multisample)
#ifndef glSampleCoverageARB
#define glSampleCoverageARB(value, invert) glatter_glSampleCoverageARB_debug((value), (invert), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSampleCoverageARB_debug(GLfloat value, GLboolean invert, const char* file, int line);
#endif // defined(GL_ARB_multisample)
#if defined(GL_ARB_multitexture)
#ifndef glActiveTextureARB
#define glActiveTextureARB(texture) glatter_glActiveTextureARB_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glActiveTextureARB_debug(GLenum texture, const char* file, int line);
#ifndef glClientActiveTextureARB
#define glClientActiveTextureARB(texture) glatter_glClientActiveTextureARB_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClientActiveTextureARB_debug(GLenum texture, const char* file, int line);
#ifndef glMultiTexCoord1dARB
#define glMultiTexCoord1dARB(target, s) glatter_glMultiTexCoord1dARB_debug((target), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1dARB_debug(GLenum target, GLdouble s, const char* file, int line);
#ifndef glMultiTexCoord1dvARB
#define glMultiTexCoord1dvARB(target, v) glatter_glMultiTexCoord1dvARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1dvARB_debug(GLenum target, const GLdouble *v, const char* file, int line);
#ifndef glMultiTexCoord1fARB
#define glMultiTexCoord1fARB(target, s) glatter_glMultiTexCoord1fARB_debug((target), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1fARB_debug(GLenum target, GLfloat s, const char* file, int line);
#ifndef glMultiTexCoord1fvARB
#define glMultiTexCoord1fvARB(target, v) glatter_glMultiTexCoord1fvARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1fvARB_debug(GLenum target, const GLfloat *v, const char* file, int line);
#ifndef glMultiTexCoord1iARB
#define glMultiTexCoord1iARB(target, s) glatter_glMultiTexCoord1iARB_debug((target), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1iARB_debug(GLenum target, GLint s, const char* file, int line);
#ifndef glMultiTexCoord1ivARB
#define glMultiTexCoord1ivARB(target, v) glatter_glMultiTexCoord1ivARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1ivARB_debug(GLenum target, const GLint *v, const char* file, int line);
#ifndef glMultiTexCoord1sARB
#define glMultiTexCoord1sARB(target, s) glatter_glMultiTexCoord1sARB_debug((target), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1sARB_debug(GLenum target, GLshort s, const char* file, int line);
#ifndef glMultiTexCoord1svARB
#define glMultiTexCoord1svARB(target, v) glatter_glMultiTexCoord1svARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1svARB_debug(GLenum target, const GLshort *v, const char* file, int line);
#ifndef glMultiTexCoord2dARB
#define glMultiTexCoord2dARB(target, s, t) glatter_glMultiTexCoord2dARB_debug((target), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2dARB_debug(GLenum target, GLdouble s, GLdouble t, const char* file, int line);
#ifndef glMultiTexCoord2dvARB
#define glMultiTexCoord2dvARB(target, v) glatter_glMultiTexCoord2dvARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2dvARB_debug(GLenum target, const GLdouble *v, const char* file, int line);
#ifndef glMultiTexCoord2fARB
#define glMultiTexCoord2fARB(target, s, t) glatter_glMultiTexCoord2fARB_debug((target), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2fARB_debug(GLenum target, GLfloat s, GLfloat t, const char* file, int line);
#ifndef glMultiTexCoord2fvARB
#define glMultiTexCoord2fvARB(target, v) glatter_glMultiTexCoord2fvARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2fvARB_debug(GLenum target, const GLfloat *v, const char* file, int line);
#ifndef glMultiTexCoord2iARB
#define glMultiTexCoord2iARB(target, s, t) glatter_glMultiTexCoord2iARB_debug((target), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2iARB_debug(GLenum target, GLint s, GLint t, const char* file, int line);
#ifndef glMultiTexCoord2ivARB
#define glMultiTexCoord2ivARB(target, v) glatter_glMultiTexCoord2ivARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2ivARB_debug(GLenum target, const GLint *v, const char* file, int line);
#ifndef glMultiTexCoord2sARB
#define glMultiTexCoord2sARB(target, s, t) glatter_glMultiTexCoord2sARB_debug((target), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2sARB_debug(GLenum target, GLshort s, GLshort t, const char* file, int line);
#ifndef glMultiTexCoord2svARB
#define glMultiTexCoord2svARB(target, v) glatter_glMultiTexCoord2svARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2svARB_debug(GLenum target, const GLshort *v, const char* file, int line);
#ifndef glMultiTexCoord3dARB
#define glMultiTexCoord3dARB(target, s, t, r) glatter_glMultiTexCoord3dARB_debug((target), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3dARB_debug(GLenum target, GLdouble s, GLdouble t, GLdouble r, const char* file, int line);
#ifndef glMultiTexCoord3dvARB
#define glMultiTexCoord3dvARB(target, v) glatter_glMultiTexCoord3dvARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3dvARB_debug(GLenum target, const GLdouble *v, const char* file, int line);
#ifndef glMultiTexCoord3fARB
#define glMultiTexCoord3fARB(target, s, t, r) glatter_glMultiTexCoord3fARB_debug((target), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3fARB_debug(GLenum target, GLfloat s, GLfloat t, GLfloat r, const char* file, int line);
#ifndef glMultiTexCoord3fvARB
#define glMultiTexCoord3fvARB(target, v) glatter_glMultiTexCoord3fvARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3fvARB_debug(GLenum target, const GLfloat *v, const char* file, int line);
#ifndef glMultiTexCoord3iARB
#define glMultiTexCoord3iARB(target, s, t, r) glatter_glMultiTexCoord3iARB_debug((target), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3iARB_debug(GLenum target, GLint s, GLint t, GLint r, const char* file, int line);
#ifndef glMultiTexCoord3ivARB
#define glMultiTexCoord3ivARB(target, v) glatter_glMultiTexCoord3ivARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3ivARB_debug(GLenum target, const GLint *v, const char* file, int line);
#ifndef glMultiTexCoord3sARB
#define glMultiTexCoord3sARB(target, s, t, r) glatter_glMultiTexCoord3sARB_debug((target), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3sARB_debug(GLenum target, GLshort s, GLshort t, GLshort r, const char* file, int line);
#ifndef glMultiTexCoord3svARB
#define glMultiTexCoord3svARB(target, v) glatter_glMultiTexCoord3svARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3svARB_debug(GLenum target, const GLshort *v, const char* file, int line);
#ifndef glMultiTexCoord4dARB
#define glMultiTexCoord4dARB(target, s, t, r, q) glatter_glMultiTexCoord4dARB_debug((target), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4dARB_debug(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q, const char* file, int line);
#ifndef glMultiTexCoord4dvARB
#define glMultiTexCoord4dvARB(target, v) glatter_glMultiTexCoord4dvARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4dvARB_debug(GLenum target, const GLdouble *v, const char* file, int line);
#ifndef glMultiTexCoord4fARB
#define glMultiTexCoord4fARB(target, s, t, r, q) glatter_glMultiTexCoord4fARB_debug((target), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4fARB_debug(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q, const char* file, int line);
#ifndef glMultiTexCoord4fvARB
#define glMultiTexCoord4fvARB(target, v) glatter_glMultiTexCoord4fvARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4fvARB_debug(GLenum target, const GLfloat *v, const char* file, int line);
#ifndef glMultiTexCoord4iARB
#define glMultiTexCoord4iARB(target, s, t, r, q) glatter_glMultiTexCoord4iARB_debug((target), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4iARB_debug(GLenum target, GLint s, GLint t, GLint r, GLint q, const char* file, int line);
#ifndef glMultiTexCoord4ivARB
#define glMultiTexCoord4ivARB(target, v) glatter_glMultiTexCoord4ivARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4ivARB_debug(GLenum target, const GLint *v, const char* file, int line);
#ifndef glMultiTexCoord4sARB
#define glMultiTexCoord4sARB(target, s, t, r, q) glatter_glMultiTexCoord4sARB_debug((target), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4sARB_debug(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q, const char* file, int line);
#ifndef glMultiTexCoord4svARB
#define glMultiTexCoord4svARB(target, v) glatter_glMultiTexCoord4svARB_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4svARB_debug(GLenum target, const GLshort *v, const char* file, int line);
#endif // defined(GL_ARB_multitexture)
#if defined(GL_ARB_occlusion_query)
#ifndef glBeginQueryARB
#define glBeginQueryARB(target, id) glatter_glBeginQueryARB_debug((target), (id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginQueryARB_debug(GLenum target, GLuint id, const char* file, int line);
#ifndef glDeleteQueriesARB
#define glDeleteQueriesARB(n, ids) glatter_glDeleteQueriesARB_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteQueriesARB_debug(GLsizei n, const GLuint *ids, const char* file, int line);
#ifndef glEndQueryARB
#define glEndQueryARB(target) glatter_glEndQueryARB_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndQueryARB_debug(GLenum target, const char* file, int line);
#ifndef glGenQueriesARB
#define glGenQueriesARB(n, ids) glatter_glGenQueriesARB_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenQueriesARB_debug(GLsizei n, GLuint *ids, const char* file, int line);
#ifndef glGetQueryObjectivARB
#define glGetQueryObjectivARB(id, pname, params) glatter_glGetQueryObjectivARB_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectivARB_debug(GLuint id, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetQueryObjectuivARB
#define glGetQueryObjectuivARB(id, pname, params) glatter_glGetQueryObjectuivARB_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectuivARB_debug(GLuint id, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glGetQueryivARB
#define glGetQueryivARB(target, pname, params) glatter_glGetQueryivARB_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryivARB_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsQueryARB
#define glIsQueryARB(id) glatter_glIsQueryARB_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsQueryARB_debug(GLuint id, const char* file, int line);
#endif // defined(GL_ARB_occlusion_query)
#if defined(GL_ARB_parallel_shader_compile)
#ifndef glMaxShaderCompilerThreadsARB
#define glMaxShaderCompilerThreadsARB(count) glatter_glMaxShaderCompilerThreadsARB_debug((count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMaxShaderCompilerThreadsARB_debug(GLuint count, const char* file, int line);
#endif // defined(GL_ARB_parallel_shader_compile)
#if defined(GL_ARB_point_parameters)
#ifndef glPointParameterfARB
#define glPointParameterfARB(pname, param) glatter_glPointParameterfARB_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfARB_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glPointParameterfvARB
#define glPointParameterfvARB(pname, params) glatter_glPointParameterfvARB_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfvARB_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#endif // defined(GL_ARB_point_parameters)
#if defined(GL_ARB_robustness)
#ifndef glGetGraphicsResetStatusARB
#define glGetGraphicsResetStatusARB() glatter_glGetGraphicsResetStatusARB_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glGetGraphicsResetStatusARB_debug(const char* file, int line);
#ifndef glGetnColorTableARB
#define glGetnColorTableARB(target, format, type, bufSize, table) glatter_glGetnColorTableARB_debug((target), (format), (type), (bufSize), (table), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnColorTableARB_debug(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table, const char* file, int line);
#ifndef glGetnCompressedTexImageARB
#define glGetnCompressedTexImageARB(target, lod, bufSize, img) glatter_glGetnCompressedTexImageARB_debug((target), (lod), (bufSize), (img), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnCompressedTexImageARB_debug(GLenum target, GLint lod, GLsizei bufSize, void *img, const char* file, int line);
#ifndef glGetnConvolutionFilterARB
#define glGetnConvolutionFilterARB(target, format, type, bufSize, image) glatter_glGetnConvolutionFilterARB_debug((target), (format), (type), (bufSize), (image), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnConvolutionFilterARB_debug(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image, const char* file, int line);
#ifndef glGetnHistogramARB
#define glGetnHistogramARB(target, reset, format, type, bufSize, values) glatter_glGetnHistogramARB_debug((target), (reset), (format), (type), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnHistogramARB_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void *values, const char* file, int line);
#ifndef glGetnMapdvARB
#define glGetnMapdvARB(target, query, bufSize, v) glatter_glGetnMapdvARB_debug((target), (query), (bufSize), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnMapdvARB_debug(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v, const char* file, int line);
#ifndef glGetnMapfvARB
#define glGetnMapfvARB(target, query, bufSize, v) glatter_glGetnMapfvARB_debug((target), (query), (bufSize), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnMapfvARB_debug(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v, const char* file, int line);
#ifndef glGetnMapivARB
#define glGetnMapivARB(target, query, bufSize, v) glatter_glGetnMapivARB_debug((target), (query), (bufSize), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnMapivARB_debug(GLenum target, GLenum query, GLsizei bufSize, GLint *v, const char* file, int line);
#ifndef glGetnMinmaxARB
#define glGetnMinmaxARB(target, reset, format, type, bufSize, values) glatter_glGetnMinmaxARB_debug((target), (reset), (format), (type), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnMinmaxARB_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void *values, const char* file, int line);
#ifndef glGetnPixelMapfvARB
#define glGetnPixelMapfvARB(map, bufSize, values) glatter_glGetnPixelMapfvARB_debug((map), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnPixelMapfvARB_debug(GLenum map, GLsizei bufSize, GLfloat *values, const char* file, int line);
#ifndef glGetnPixelMapuivARB
#define glGetnPixelMapuivARB(map, bufSize, values) glatter_glGetnPixelMapuivARB_debug((map), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnPixelMapuivARB_debug(GLenum map, GLsizei bufSize, GLuint *values, const char* file, int line);
#ifndef glGetnPixelMapusvARB
#define glGetnPixelMapusvARB(map, bufSize, values) glatter_glGetnPixelMapusvARB_debug((map), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnPixelMapusvARB_debug(GLenum map, GLsizei bufSize, GLushort *values, const char* file, int line);
#ifndef glGetnPolygonStippleARB
#define glGetnPolygonStippleARB(bufSize, pattern) glatter_glGetnPolygonStippleARB_debug((bufSize), (pattern), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnPolygonStippleARB_debug(GLsizei bufSize, GLubyte *pattern, const char* file, int line);
#ifndef glGetnSeparableFilterARB
#define glGetnSeparableFilterARB(target, format, type, rowBufSize, row, columnBufSize, column, span) glatter_glGetnSeparableFilterARB_debug((target), (format), (type), (rowBufSize), (row), (columnBufSize), (column), (span), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnSeparableFilterARB_debug(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void *row, GLsizei columnBufSize, void *column, void *span, const char* file, int line);
#ifndef glGetnTexImageARB
#define glGetnTexImageARB(target, level, format, type, bufSize, img) glatter_glGetnTexImageARB_debug((target), (level), (format), (type), (bufSize), (img), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnTexImageARB_debug(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *img, const char* file, int line);
#ifndef glGetnUniformdvARB
#define glGetnUniformdvARB(program, location, bufSize, params) glatter_glGetnUniformdvARB_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformdvARB_debug(GLuint program, GLint location, GLsizei bufSize, GLdouble *params, const char* file, int line);
#ifndef glGetnUniformfvARB
#define glGetnUniformfvARB(program, location, bufSize, params) glatter_glGetnUniformfvARB_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformfvARB_debug(GLuint program, GLint location, GLsizei bufSize, GLfloat *params, const char* file, int line);
#ifndef glGetnUniformivARB
#define glGetnUniformivARB(program, location, bufSize, params) glatter_glGetnUniformivARB_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformivARB_debug(GLuint program, GLint location, GLsizei bufSize, GLint *params, const char* file, int line);
#ifndef glGetnUniformuivARB
#define glGetnUniformuivARB(program, location, bufSize, params) glatter_glGetnUniformuivARB_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformuivARB_debug(GLuint program, GLint location, GLsizei bufSize, GLuint *params, const char* file, int line);
#ifndef glReadnPixelsARB
#define glReadnPixelsARB(x, y, width, height, format, type, bufSize, data) glatter_glReadnPixelsARB_debug((x), (y), (width), (height), (format), (type), (bufSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReadnPixelsARB_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data, const char* file, int line);
#endif // defined(GL_ARB_robustness)
#if defined(GL_ARB_sample_locations)
#ifndef glEvaluateDepthValuesARB
#define glEvaluateDepthValuesARB() glatter_glEvaluateDepthValuesARB_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvaluateDepthValuesARB_debug(const char* file, int line);
#ifndef glFramebufferSampleLocationsfvARB
#define glFramebufferSampleLocationsfvARB(target, start, count, v) glatter_glFramebufferSampleLocationsfvARB_debug((target), (start), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferSampleLocationsfvARB_debug(GLenum target, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glNamedFramebufferSampleLocationsfvARB
#define glNamedFramebufferSampleLocationsfvARB(framebuffer, start, count, v) glatter_glNamedFramebufferSampleLocationsfvARB_debug((framebuffer), (start), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferSampleLocationsfvARB_debug(GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line);
#endif // defined(GL_ARB_sample_locations)
#if defined(GL_ARB_sample_shading)
#ifndef glMinSampleShadingARB
#define glMinSampleShadingARB(value) glatter_glMinSampleShadingARB_debug((value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMinSampleShadingARB_debug(GLfloat value, const char* file, int line);
#endif // defined(GL_ARB_sample_shading)
#if defined(GL_ARB_shader_objects)
#ifndef glAttachObjectARB
#define glAttachObjectARB(containerObj, obj) glatter_glAttachObjectARB_debug((containerObj), (obj), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAttachObjectARB_debug(GLhandleARB containerObj, GLhandleARB obj, const char* file, int line);
#ifndef glCompileShaderARB
#define glCompileShaderARB(shaderObj) glatter_glCompileShaderARB_debug((shaderObj), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompileShaderARB_debug(GLhandleARB shaderObj, const char* file, int line);
#ifndef glCreateProgramObjectARB
#define glCreateProgramObjectARB() glatter_glCreateProgramObjectARB_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLhandleARB glatter_glCreateProgramObjectARB_debug(const char* file, int line);
#ifndef glCreateShaderObjectARB
#define glCreateShaderObjectARB(shaderType) glatter_glCreateShaderObjectARB_debug((shaderType), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLhandleARB glatter_glCreateShaderObjectARB_debug(GLenum shaderType, const char* file, int line);
#ifndef glDeleteObjectARB
#define glDeleteObjectARB(obj) glatter_glDeleteObjectARB_debug((obj), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteObjectARB_debug(GLhandleARB obj, const char* file, int line);
#ifndef glDetachObjectARB
#define glDetachObjectARB(containerObj, attachedObj) glatter_glDetachObjectARB_debug((containerObj), (attachedObj), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDetachObjectARB_debug(GLhandleARB containerObj, GLhandleARB attachedObj, const char* file, int line);
#ifndef glGetActiveUniformARB
#define glGetActiveUniformARB(programObj, index, maxLength, length, size, type, name) glatter_glGetActiveUniformARB_debug((programObj), (index), (maxLength), (length), (size), (type), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniformARB_debug(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name, const char* file, int line);
#ifndef glGetAttachedObjectsARB
#define glGetAttachedObjectsARB(containerObj, maxCount, count, obj) glatter_glGetAttachedObjectsARB_debug((containerObj), (maxCount), (count), (obj), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetAttachedObjectsARB_debug(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj, const char* file, int line);
#ifndef glGetHandleARB
#define glGetHandleARB(pname) glatter_glGetHandleARB_debug((pname), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLhandleARB glatter_glGetHandleARB_debug(GLenum pname, const char* file, int line);
#ifndef glGetInfoLogARB
#define glGetInfoLogARB(obj, maxLength, length, infoLog) glatter_glGetInfoLogARB_debug((obj), (maxLength), (length), (infoLog), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetInfoLogARB_debug(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog, const char* file, int line);
#ifndef glGetObjectParameterfvARB
#define glGetObjectParameterfvARB(obj, pname, params) glatter_glGetObjectParameterfvARB_debug((obj), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetObjectParameterfvARB_debug(GLhandleARB obj, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetObjectParameterivARB
#define glGetObjectParameterivARB(obj, pname, params) glatter_glGetObjectParameterivARB_debug((obj), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetObjectParameterivARB_debug(GLhandleARB obj, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetShaderSourceARB
#define glGetShaderSourceARB(obj, maxLength, length, source) glatter_glGetShaderSourceARB_debug((obj), (maxLength), (length), (source), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetShaderSourceARB_debug(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source, const char* file, int line);
#ifndef glGetUniformLocationARB
#define glGetUniformLocationARB(programObj, name) glatter_glGetUniformLocationARB_debug((programObj), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetUniformLocationARB_debug(GLhandleARB programObj, const GLcharARB *name, const char* file, int line);
#ifndef glGetUniformfvARB
#define glGetUniformfvARB(programObj, location, params) glatter_glGetUniformfvARB_debug((programObj), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformfvARB_debug(GLhandleARB programObj, GLint location, GLfloat *params, const char* file, int line);
#ifndef glGetUniformivARB
#define glGetUniformivARB(programObj, location, params) glatter_glGetUniformivARB_debug((programObj), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformivARB_debug(GLhandleARB programObj, GLint location, GLint *params, const char* file, int line);
#ifndef glLinkProgramARB
#define glLinkProgramARB(programObj) glatter_glLinkProgramARB_debug((programObj), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLinkProgramARB_debug(GLhandleARB programObj, const char* file, int line);
#ifndef glShaderSourceARB
#define glShaderSourceARB(shaderObj, count, string, length) glatter_glShaderSourceARB_debug((shaderObj), (count), (string), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glShaderSourceARB_debug(GLhandleARB shaderObj, GLsizei count, const GLcharARB **string, const GLint *length, const char* file, int line);
#ifndef glUniform1fARB
#define glUniform1fARB(location, v0) glatter_glUniform1fARB_debug((location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1fARB_debug(GLint location, GLfloat v0, const char* file, int line);
#ifndef glUniform1fvARB
#define glUniform1fvARB(location, count, value) glatter_glUniform1fvARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1fvARB_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glUniform1iARB
#define glUniform1iARB(location, v0) glatter_glUniform1iARB_debug((location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1iARB_debug(GLint location, GLint v0, const char* file, int line);
#ifndef glUniform1ivARB
#define glUniform1ivARB(location, count, value) glatter_glUniform1ivARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1ivARB_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glUniform2fARB
#define glUniform2fARB(location, v0, v1) glatter_glUniform2fARB_debug((location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2fARB_debug(GLint location, GLfloat v0, GLfloat v1, const char* file, int line);
#ifndef glUniform2fvARB
#define glUniform2fvARB(location, count, value) glatter_glUniform2fvARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2fvARB_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glUniform2iARB
#define glUniform2iARB(location, v0, v1) glatter_glUniform2iARB_debug((location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2iARB_debug(GLint location, GLint v0, GLint v1, const char* file, int line);
#ifndef glUniform2ivARB
#define glUniform2ivARB(location, count, value) glatter_glUniform2ivARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2ivARB_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glUniform3fARB
#define glUniform3fARB(location, v0, v1, v2) glatter_glUniform3fARB_debug((location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3fARB_debug(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, const char* file, int line);
#ifndef glUniform3fvARB
#define glUniform3fvARB(location, count, value) glatter_glUniform3fvARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3fvARB_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glUniform3iARB
#define glUniform3iARB(location, v0, v1, v2) glatter_glUniform3iARB_debug((location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3iARB_debug(GLint location, GLint v0, GLint v1, GLint v2, const char* file, int line);
#ifndef glUniform3ivARB
#define glUniform3ivARB(location, count, value) glatter_glUniform3ivARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3ivARB_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glUniform4fARB
#define glUniform4fARB(location, v0, v1, v2, v3) glatter_glUniform4fARB_debug((location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4fARB_debug(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3, const char* file, int line);
#ifndef glUniform4fvARB
#define glUniform4fvARB(location, count, value) glatter_glUniform4fvARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4fvARB_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glUniform4iARB
#define glUniform4iARB(location, v0, v1, v2, v3) glatter_glUniform4iARB_debug((location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4iARB_debug(GLint location, GLint v0, GLint v1, GLint v2, GLint v3, const char* file, int line);
#ifndef glUniform4ivARB
#define glUniform4ivARB(location, count, value) glatter_glUniform4ivARB_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4ivARB_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glUniformMatrix2fvARB
#define glUniformMatrix2fvARB(location, count, transpose, value) glatter_glUniformMatrix2fvARB_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2fvARB_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUniformMatrix3fvARB
#define glUniformMatrix3fvARB(location, count, transpose, value) glatter_glUniformMatrix3fvARB_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3fvARB_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUniformMatrix4fvARB
#define glUniformMatrix4fvARB(location, count, transpose, value) glatter_glUniformMatrix4fvARB_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4fvARB_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUseProgramObjectARB
#define glUseProgramObjectARB(programObj) glatter_glUseProgramObjectARB_debug((programObj), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUseProgramObjectARB_debug(GLhandleARB programObj, const char* file, int line);
#ifndef glValidateProgramARB
#define glValidateProgramARB(programObj) glatter_glValidateProgramARB_debug((programObj), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glValidateProgramARB_debug(GLhandleARB programObj, const char* file, int line);
#endif // defined(GL_ARB_shader_objects)
#if defined(GL_ARB_shading_language_include)
#ifndef glCompileShaderIncludeARB
#define glCompileShaderIncludeARB(shader, count, path, length) glatter_glCompileShaderIncludeARB_debug((shader), (count), (path), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompileShaderIncludeARB_debug(GLuint shader, GLsizei count, const GLchar *const*path, const GLint *length, const char* file, int line);
#ifndef glDeleteNamedStringARB
#define glDeleteNamedStringARB(namelen, name) glatter_glDeleteNamedStringARB_debug((namelen), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteNamedStringARB_debug(GLint namelen, const GLchar *name, const char* file, int line);
#ifndef glGetNamedStringARB
#define glGetNamedStringARB(namelen, name, bufSize, stringlen, string) glatter_glGetNamedStringARB_debug((namelen), (name), (bufSize), (stringlen), (string), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedStringARB_debug(GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string, const char* file, int line);
#ifndef glGetNamedStringivARB
#define glGetNamedStringivARB(namelen, name, pname, params) glatter_glGetNamedStringivARB_debug((namelen), (name), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedStringivARB_debug(GLint namelen, const GLchar *name, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsNamedStringARB
#define glIsNamedStringARB(namelen, name) glatter_glIsNamedStringARB_debug((namelen), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsNamedStringARB_debug(GLint namelen, const GLchar *name, const char* file, int line);
#ifndef glNamedStringARB
#define glNamedStringARB(type, namelen, name, stringlen, string) glatter_glNamedStringARB_debug((type), (namelen), (name), (stringlen), (string), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedStringARB_debug(GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string, const char* file, int line);
#endif // defined(GL_ARB_shading_language_include)
#if defined(GL_ARB_sparse_buffer)
#ifndef glBufferPageCommitmentARB
#define glBufferPageCommitmentARB(target, offset, size, commit) glatter_glBufferPageCommitmentARB_debug((target), (offset), (size), (commit), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferPageCommitmentARB_debug(GLenum target, GLintptr offset, GLsizeiptr size, GLboolean commit, const char* file, int line);
#ifndef glNamedBufferPageCommitmentARB
#define glNamedBufferPageCommitmentARB(buffer, offset, size, commit) glatter_glNamedBufferPageCommitmentARB_debug((buffer), (offset), (size), (commit), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferPageCommitmentARB_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean commit, const char* file, int line);
#ifndef glNamedBufferPageCommitmentEXT
#define glNamedBufferPageCommitmentEXT(buffer, offset, size, commit) glatter_glNamedBufferPageCommitmentEXT_debug((buffer), (offset), (size), (commit), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferPageCommitmentEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean commit, const char* file, int line);
#endif // defined(GL_ARB_sparse_buffer)
#if defined(GL_ARB_sparse_texture)
#ifndef glTexPageCommitmentARB
#define glTexPageCommitmentARB(target, level, xoffset, yoffset, zoffset, width, height, depth, commit) glatter_glTexPageCommitmentARB_debug((target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (commit), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexPageCommitmentARB_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit, const char* file, int line);
#endif // defined(GL_ARB_sparse_texture)
#if defined(GL_ARB_texture_buffer_object)
#ifndef glTexBufferARB
#define glTexBufferARB(target, internalformat, buffer) glatter_glTexBufferARB_debug((target), (internalformat), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexBufferARB_debug(GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line);
#endif // defined(GL_ARB_texture_buffer_object)
#if defined(GL_ARB_texture_compression)
#ifndef glCompressedTexImage1DARB
#define glCompressedTexImage1DARB(target, level, internalformat, width, border, imageSize, data) glatter_glCompressedTexImage1DARB_debug((target), (level), (internalformat), (width), (border), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage1DARB_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexImage2DARB
#define glCompressedTexImage2DARB(target, level, internalformat, width, height, border, imageSize, data) glatter_glCompressedTexImage2DARB_debug((target), (level), (internalformat), (width), (height), (border), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage2DARB_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexImage3DARB
#define glCompressedTexImage3DARB(target, level, internalformat, width, height, depth, border, imageSize, data) glatter_glCompressedTexImage3DARB_debug((target), (level), (internalformat), (width), (height), (depth), (border), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage3DARB_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexSubImage1DARB
#define glCompressedTexSubImage1DARB(target, level, xoffset, width, format, imageSize, data) glatter_glCompressedTexSubImage1DARB_debug((target), (level), (xoffset), (width), (format), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage1DARB_debug(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexSubImage2DARB
#define glCompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, data) glatter_glCompressedTexSubImage2DARB_debug((target), (level), (xoffset), (yoffset), (width), (height), (format), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage2DARB_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexSubImage3DARB
#define glCompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data) glatter_glCompressedTexSubImage3DARB_debug((target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage3DARB_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glGetCompressedTexImageARB
#define glGetCompressedTexImageARB(target, level, img) glatter_glGetCompressedTexImageARB_debug((target), (level), (img), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCompressedTexImageARB_debug(GLenum target, GLint level, void *img, const char* file, int line);
#endif // defined(GL_ARB_texture_compression)
#if defined(GL_ARB_transpose_matrix)
#ifndef glLoadTransposeMatrixdARB
#define glLoadTransposeMatrixdARB(m) glatter_glLoadTransposeMatrixdARB_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadTransposeMatrixdARB_debug(const GLdouble *m, const char* file, int line);
#ifndef glLoadTransposeMatrixfARB
#define glLoadTransposeMatrixfARB(m) glatter_glLoadTransposeMatrixfARB_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadTransposeMatrixfARB_debug(const GLfloat *m, const char* file, int line);
#ifndef glMultTransposeMatrixdARB
#define glMultTransposeMatrixdARB(m) glatter_glMultTransposeMatrixdARB_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultTransposeMatrixdARB_debug(const GLdouble *m, const char* file, int line);
#ifndef glMultTransposeMatrixfARB
#define glMultTransposeMatrixfARB(m) glatter_glMultTransposeMatrixfARB_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultTransposeMatrixfARB_debug(const GLfloat *m, const char* file, int line);
#endif // defined(GL_ARB_transpose_matrix)
#if defined(GL_ARB_vertex_blend)
#ifndef glVertexBlendARB
#define glVertexBlendARB(count) glatter_glVertexBlendARB_debug((count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexBlendARB_debug(GLint count, const char* file, int line);
#ifndef glWeightPointerARB
#define glWeightPointerARB(size, type, stride, pointer) glatter_glWeightPointerARB_debug((size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightPointerARB_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glWeightbvARB
#define glWeightbvARB(size, weights) glatter_glWeightbvARB_debug((size), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightbvARB_debug(GLint size, const GLbyte *weights, const char* file, int line);
#ifndef glWeightdvARB
#define glWeightdvARB(size, weights) glatter_glWeightdvARB_debug((size), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightdvARB_debug(GLint size, const GLdouble *weights, const char* file, int line);
#ifndef glWeightfvARB
#define glWeightfvARB(size, weights) glatter_glWeightfvARB_debug((size), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightfvARB_debug(GLint size, const GLfloat *weights, const char* file, int line);
#ifndef glWeightivARB
#define glWeightivARB(size, weights) glatter_glWeightivARB_debug((size), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightivARB_debug(GLint size, const GLint *weights, const char* file, int line);
#ifndef glWeightsvARB
#define glWeightsvARB(size, weights) glatter_glWeightsvARB_debug((size), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightsvARB_debug(GLint size, const GLshort *weights, const char* file, int line);
#ifndef glWeightubvARB
#define glWeightubvARB(size, weights) glatter_glWeightubvARB_debug((size), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightubvARB_debug(GLint size, const GLubyte *weights, const char* file, int line);
#ifndef glWeightuivARB
#define glWeightuivARB(size, weights) glatter_glWeightuivARB_debug((size), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightuivARB_debug(GLint size, const GLuint *weights, const char* file, int line);
#ifndef glWeightusvARB
#define glWeightusvARB(size, weights) glatter_glWeightusvARB_debug((size), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightusvARB_debug(GLint size, const GLushort *weights, const char* file, int line);
#endif // defined(GL_ARB_vertex_blend)
#if defined(GL_ARB_vertex_buffer_object)
#ifndef glBindBufferARB
#define glBindBufferARB(target, buffer) glatter_glBindBufferARB_debug((target), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBufferARB_debug(GLenum target, GLuint buffer, const char* file, int line);
#ifndef glBufferDataARB
#define glBufferDataARB(target, size, data, usage) glatter_glBufferDataARB_debug((target), (size), (data), (usage), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferDataARB_debug(GLenum target, GLsizeiptrARB size, const void *data, GLenum usage, const char* file, int line);
#ifndef glBufferSubDataARB
#define glBufferSubDataARB(target, offset, size, data) glatter_glBufferSubDataARB_debug((target), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferSubDataARB_debug(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const void *data, const char* file, int line);
#ifndef glDeleteBuffersARB
#define glDeleteBuffersARB(n, buffers) glatter_glDeleteBuffersARB_debug((n), (buffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteBuffersARB_debug(GLsizei n, const GLuint *buffers, const char* file, int line);
#ifndef glGenBuffersARB
#define glGenBuffersARB(n, buffers) glatter_glGenBuffersARB_debug((n), (buffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenBuffersARB_debug(GLsizei n, GLuint *buffers, const char* file, int line);
#ifndef glGetBufferParameterivARB
#define glGetBufferParameterivARB(target, pname, params) glatter_glGetBufferParameterivARB_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBufferParameterivARB_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetBufferPointervARB
#define glGetBufferPointervARB(target, pname, params) glatter_glGetBufferPointervARB_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBufferPointervARB_debug(GLenum target, GLenum pname, void **params, const char* file, int line);
#ifndef glGetBufferSubDataARB
#define glGetBufferSubDataARB(target, offset, size, data) glatter_glGetBufferSubDataARB_debug((target), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBufferSubDataARB_debug(GLenum target, GLintptrARB offset, GLsizeiptrARB size, void *data, const char* file, int line);
#ifndef glIsBufferARB
#define glIsBufferARB(buffer) glatter_glIsBufferARB_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsBufferARB_debug(GLuint buffer, const char* file, int line);
#ifndef glMapBufferARB
#define glMapBufferARB(target, access) glatter_glMapBufferARB_debug((target), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void * glatter_glMapBufferARB_debug(GLenum target, GLenum access, const char* file, int line);
#ifndef glUnmapBufferARB
#define glUnmapBufferARB(target) glatter_glUnmapBufferARB_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glUnmapBufferARB_debug(GLenum target, const char* file, int line);
#endif // defined(GL_ARB_vertex_buffer_object)
#if defined(GL_ARB_vertex_program)
#ifndef glDisableVertexAttribArrayARB
#define glDisableVertexAttribArrayARB(index) glatter_glDisableVertexAttribArrayARB_debug((index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexAttribArrayARB_debug(GLuint index, const char* file, int line);
#ifndef glEnableVertexAttribArrayARB
#define glEnableVertexAttribArrayARB(index) glatter_glEnableVertexAttribArrayARB_debug((index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexAttribArrayARB_debug(GLuint index, const char* file, int line);
#ifndef glGetVertexAttribPointervARB
#define glGetVertexAttribPointervARB(index, pname, pointer) glatter_glGetVertexAttribPointervARB_debug((index), (pname), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribPointervARB_debug(GLuint index, GLenum pname, void **pointer, const char* file, int line);
#ifndef glGetVertexAttribdvARB
#define glGetVertexAttribdvARB(index, pname, params) glatter_glGetVertexAttribdvARB_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribdvARB_debug(GLuint index, GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glGetVertexAttribfvARB
#define glGetVertexAttribfvARB(index, pname, params) glatter_glGetVertexAttribfvARB_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribfvARB_debug(GLuint index, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetVertexAttribivARB
#define glGetVertexAttribivARB(index, pname, params) glatter_glGetVertexAttribivARB_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribivARB_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line);
#ifndef glVertexAttrib1dARB
#define glVertexAttrib1dARB(index, x) glatter_glVertexAttrib1dARB_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1dARB_debug(GLuint index, GLdouble x, const char* file, int line);
#ifndef glVertexAttrib1dvARB
#define glVertexAttrib1dvARB(index, v) glatter_glVertexAttrib1dvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1dvARB_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib1fARB
#define glVertexAttrib1fARB(index, x) glatter_glVertexAttrib1fARB_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1fARB_debug(GLuint index, GLfloat x, const char* file, int line);
#ifndef glVertexAttrib1fvARB
#define glVertexAttrib1fvARB(index, v) glatter_glVertexAttrib1fvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1fvARB_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib1sARB
#define glVertexAttrib1sARB(index, x) glatter_glVertexAttrib1sARB_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1sARB_debug(GLuint index, GLshort x, const char* file, int line);
#ifndef glVertexAttrib1svARB
#define glVertexAttrib1svARB(index, v) glatter_glVertexAttrib1svARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1svARB_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib2dARB
#define glVertexAttrib2dARB(index, x, y) glatter_glVertexAttrib2dARB_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2dARB_debug(GLuint index, GLdouble x, GLdouble y, const char* file, int line);
#ifndef glVertexAttrib2dvARB
#define glVertexAttrib2dvARB(index, v) glatter_glVertexAttrib2dvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2dvARB_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib2fARB
#define glVertexAttrib2fARB(index, x, y) glatter_glVertexAttrib2fARB_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2fARB_debug(GLuint index, GLfloat x, GLfloat y, const char* file, int line);
#ifndef glVertexAttrib2fvARB
#define glVertexAttrib2fvARB(index, v) glatter_glVertexAttrib2fvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2fvARB_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib2sARB
#define glVertexAttrib2sARB(index, x, y) glatter_glVertexAttrib2sARB_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2sARB_debug(GLuint index, GLshort x, GLshort y, const char* file, int line);
#ifndef glVertexAttrib2svARB
#define glVertexAttrib2svARB(index, v) glatter_glVertexAttrib2svARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2svARB_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib3dARB
#define glVertexAttrib3dARB(index, x, y, z) glatter_glVertexAttrib3dARB_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3dARB_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glVertexAttrib3dvARB
#define glVertexAttrib3dvARB(index, v) glatter_glVertexAttrib3dvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3dvARB_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib3fARB
#define glVertexAttrib3fARB(index, x, y, z) glatter_glVertexAttrib3fARB_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3fARB_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glVertexAttrib3fvARB
#define glVertexAttrib3fvARB(index, v) glatter_glVertexAttrib3fvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3fvARB_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib3sARB
#define glVertexAttrib3sARB(index, x, y, z) glatter_glVertexAttrib3sARB_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3sARB_debug(GLuint index, GLshort x, GLshort y, GLshort z, const char* file, int line);
#ifndef glVertexAttrib3svARB
#define glVertexAttrib3svARB(index, v) glatter_glVertexAttrib3svARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3svARB_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib4NbvARB
#define glVertexAttrib4NbvARB(index, v) glatter_glVertexAttrib4NbvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NbvARB_debug(GLuint index, const GLbyte *v, const char* file, int line);
#ifndef glVertexAttrib4NivARB
#define glVertexAttrib4NivARB(index, v) glatter_glVertexAttrib4NivARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NivARB_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttrib4NsvARB
#define glVertexAttrib4NsvARB(index, v) glatter_glVertexAttrib4NsvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NsvARB_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib4NubARB
#define glVertexAttrib4NubARB(index, x, y, z, w) glatter_glVertexAttrib4NubARB_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NubARB_debug(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w, const char* file, int line);
#ifndef glVertexAttrib4NubvARB
#define glVertexAttrib4NubvARB(index, v) glatter_glVertexAttrib4NubvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NubvARB_debug(GLuint index, const GLubyte *v, const char* file, int line);
#ifndef glVertexAttrib4NuivARB
#define glVertexAttrib4NuivARB(index, v) glatter_glVertexAttrib4NuivARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NuivARB_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttrib4NusvARB
#define glVertexAttrib4NusvARB(index, v) glatter_glVertexAttrib4NusvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NusvARB_debug(GLuint index, const GLushort *v, const char* file, int line);
#ifndef glVertexAttrib4bvARB
#define glVertexAttrib4bvARB(index, v) glatter_glVertexAttrib4bvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4bvARB_debug(GLuint index, const GLbyte *v, const char* file, int line);
#ifndef glVertexAttrib4dARB
#define glVertexAttrib4dARB(index, x, y, z, w) glatter_glVertexAttrib4dARB_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4dARB_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glVertexAttrib4dvARB
#define glVertexAttrib4dvARB(index, v) glatter_glVertexAttrib4dvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4dvARB_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib4fARB
#define glVertexAttrib4fARB(index, x, y, z, w) glatter_glVertexAttrib4fARB_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4fARB_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glVertexAttrib4fvARB
#define glVertexAttrib4fvARB(index, v) glatter_glVertexAttrib4fvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4fvARB_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib4ivARB
#define glVertexAttrib4ivARB(index, v) glatter_glVertexAttrib4ivARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4ivARB_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttrib4sARB
#define glVertexAttrib4sARB(index, x, y, z, w) glatter_glVertexAttrib4sARB_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4sARB_debug(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line);
#ifndef glVertexAttrib4svARB
#define glVertexAttrib4svARB(index, v) glatter_glVertexAttrib4svARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4svARB_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib4ubvARB
#define glVertexAttrib4ubvARB(index, v) glatter_glVertexAttrib4ubvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4ubvARB_debug(GLuint index, const GLubyte *v, const char* file, int line);
#ifndef glVertexAttrib4uivARB
#define glVertexAttrib4uivARB(index, v) glatter_glVertexAttrib4uivARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4uivARB_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttrib4usvARB
#define glVertexAttrib4usvARB(index, v) glatter_glVertexAttrib4usvARB_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4usvARB_debug(GLuint index, const GLushort *v, const char* file, int line);
#ifndef glVertexAttribPointerARB
#define glVertexAttribPointerARB(index, size, type, normalized, stride, pointer) glatter_glVertexAttribPointerARB_debug((index), (size), (type), (normalized), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribPointerARB_debug(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer, const char* file, int line);
#endif // defined(GL_ARB_vertex_program)
#if defined(GL_ARB_vertex_shader)
#ifndef glBindAttribLocationARB
#define glBindAttribLocationARB(programObj, index, name) glatter_glBindAttribLocationARB_debug((programObj), (index), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindAttribLocationARB_debug(GLhandleARB programObj, GLuint index, const GLcharARB *name, const char* file, int line);
#ifndef glGetActiveAttribARB
#define glGetActiveAttribARB(programObj, index, maxLength, length, size, type, name) glatter_glGetActiveAttribARB_debug((programObj), (index), (maxLength), (length), (size), (type), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveAttribARB_debug(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name, const char* file, int line);
#ifndef glGetAttribLocationARB
#define glGetAttribLocationARB(programObj, name) glatter_glGetAttribLocationARB_debug((programObj), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetAttribLocationARB_debug(GLhandleARB programObj, const GLcharARB *name, const char* file, int line);
#endif // defined(GL_ARB_vertex_shader)
#if defined(GL_ARB_window_pos)
#ifndef glWindowPos2dARB
#define glWindowPos2dARB(x, y) glatter_glWindowPos2dARB_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2dARB_debug(GLdouble x, GLdouble y, const char* file, int line);
#ifndef glWindowPos2dvARB
#define glWindowPos2dvARB(v) glatter_glWindowPos2dvARB_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2dvARB_debug(const GLdouble *v, const char* file, int line);
#ifndef glWindowPos2fARB
#define glWindowPos2fARB(x, y) glatter_glWindowPos2fARB_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2fARB_debug(GLfloat x, GLfloat y, const char* file, int line);
#ifndef glWindowPos2fvARB
#define glWindowPos2fvARB(v) glatter_glWindowPos2fvARB_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2fvARB_debug(const GLfloat *v, const char* file, int line);
#ifndef glWindowPos2iARB
#define glWindowPos2iARB(x, y) glatter_glWindowPos2iARB_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2iARB_debug(GLint x, GLint y, const char* file, int line);
#ifndef glWindowPos2ivARB
#define glWindowPos2ivARB(v) glatter_glWindowPos2ivARB_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2ivARB_debug(const GLint *v, const char* file, int line);
#ifndef glWindowPos2sARB
#define glWindowPos2sARB(x, y) glatter_glWindowPos2sARB_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2sARB_debug(GLshort x, GLshort y, const char* file, int line);
#ifndef glWindowPos2svARB
#define glWindowPos2svARB(v) glatter_glWindowPos2svARB_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2svARB_debug(const GLshort *v, const char* file, int line);
#ifndef glWindowPos3dARB
#define glWindowPos3dARB(x, y, z) glatter_glWindowPos3dARB_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3dARB_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glWindowPos3dvARB
#define glWindowPos3dvARB(v) glatter_glWindowPos3dvARB_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3dvARB_debug(const GLdouble *v, const char* file, int line);
#ifndef glWindowPos3fARB
#define glWindowPos3fARB(x, y, z) glatter_glWindowPos3fARB_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3fARB_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glWindowPos3fvARB
#define glWindowPos3fvARB(v) glatter_glWindowPos3fvARB_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3fvARB_debug(const GLfloat *v, const char* file, int line);
#ifndef glWindowPos3iARB
#define glWindowPos3iARB(x, y, z) glatter_glWindowPos3iARB_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3iARB_debug(GLint x, GLint y, GLint z, const char* file, int line);
#ifndef glWindowPos3ivARB
#define glWindowPos3ivARB(v) glatter_glWindowPos3ivARB_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3ivARB_debug(const GLint *v, const char* file, int line);
#ifndef glWindowPos3sARB
#define glWindowPos3sARB(x, y, z) glatter_glWindowPos3sARB_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3sARB_debug(GLshort x, GLshort y, GLshort z, const char* file, int line);
#ifndef glWindowPos3svARB
#define glWindowPos3svARB(v) glatter_glWindowPos3svARB_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3svARB_debug(const GLshort *v, const char* file, int line);
#endif // defined(GL_ARB_window_pos)
#if defined(GL_ATI_draw_buffers)
#ifndef glDrawBuffersATI
#define glDrawBuffersATI(n, bufs) glatter_glDrawBuffersATI_debug((n), (bufs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffersATI_debug(GLsizei n, const GLenum *bufs, const char* file, int line);
#endif // defined(GL_ATI_draw_buffers)
#if defined(GL_ATI_element_array)
#ifndef glDrawElementArrayATI
#define glDrawElementArrayATI(mode, count) glatter_glDrawElementArrayATI_debug((mode), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementArrayATI_debug(GLenum mode, GLsizei count, const char* file, int line);
#ifndef glDrawRangeElementArrayATI
#define glDrawRangeElementArrayATI(mode, start, end, count) glatter_glDrawRangeElementArrayATI_debug((mode), (start), (end), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementArrayATI_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, const char* file, int line);
#ifndef glElementPointerATI
#define glElementPointerATI(type, pointer) glatter_glElementPointerATI_debug((type), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glElementPointerATI_debug(GLenum type, const void *pointer, const char* file, int line);
#endif // defined(GL_ATI_element_array)
#if defined(GL_ATI_envmap_bumpmap)
#ifndef glGetTexBumpParameterfvATI
#define glGetTexBumpParameterfvATI(pname, param) glatter_glGetTexBumpParameterfvATI_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexBumpParameterfvATI_debug(GLenum pname, GLfloat *param, const char* file, int line);
#ifndef glGetTexBumpParameterivATI
#define glGetTexBumpParameterivATI(pname, param) glatter_glGetTexBumpParameterivATI_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexBumpParameterivATI_debug(GLenum pname, GLint *param, const char* file, int line);
#ifndef glTexBumpParameterfvATI
#define glTexBumpParameterfvATI(pname, param) glatter_glTexBumpParameterfvATI_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexBumpParameterfvATI_debug(GLenum pname, const GLfloat *param, const char* file, int line);
#ifndef glTexBumpParameterivATI
#define glTexBumpParameterivATI(pname, param) glatter_glTexBumpParameterivATI_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexBumpParameterivATI_debug(GLenum pname, const GLint *param, const char* file, int line);
#endif // defined(GL_ATI_envmap_bumpmap)
#if defined(GL_ATI_fragment_shader)
#ifndef glAlphaFragmentOp1ATI
#define glAlphaFragmentOp1ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod) glatter_glAlphaFragmentOp1ATI_debug((op), (dst), (dstMod), (arg1), (arg1Rep), (arg1Mod), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAlphaFragmentOp1ATI_debug(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, const char* file, int line);
#ifndef glAlphaFragmentOp2ATI
#define glAlphaFragmentOp2ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod) glatter_glAlphaFragmentOp2ATI_debug((op), (dst), (dstMod), (arg1), (arg1Rep), (arg1Mod), (arg2), (arg2Rep), (arg2Mod), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAlphaFragmentOp2ATI_debug(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, const char* file, int line);
#ifndef glAlphaFragmentOp3ATI
#define glAlphaFragmentOp3ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod) glatter_glAlphaFragmentOp3ATI_debug((op), (dst), (dstMod), (arg1), (arg1Rep), (arg1Mod), (arg2), (arg2Rep), (arg2Mod), (arg3), (arg3Rep), (arg3Mod), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAlphaFragmentOp3ATI_debug(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod, const char* file, int line);
#ifndef glBeginFragmentShaderATI
#define glBeginFragmentShaderATI() glatter_glBeginFragmentShaderATI_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginFragmentShaderATI_debug(const char* file, int line);
#ifndef glBindFragmentShaderATI
#define glBindFragmentShaderATI(id) glatter_glBindFragmentShaderATI_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindFragmentShaderATI_debug(GLuint id, const char* file, int line);
#ifndef glColorFragmentOp1ATI
#define glColorFragmentOp1ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod) glatter_glColorFragmentOp1ATI_debug((op), (dst), (dstMask), (dstMod), (arg1), (arg1Rep), (arg1Mod), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorFragmentOp1ATI_debug(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, const char* file, int line);
#ifndef glColorFragmentOp2ATI
#define glColorFragmentOp2ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod) glatter_glColorFragmentOp2ATI_debug((op), (dst), (dstMask), (dstMod), (arg1), (arg1Rep), (arg1Mod), (arg2), (arg2Rep), (arg2Mod), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorFragmentOp2ATI_debug(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, const char* file, int line);
#ifndef glColorFragmentOp3ATI
#define glColorFragmentOp3ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod) glatter_glColorFragmentOp3ATI_debug((op), (dst), (dstMask), (dstMod), (arg1), (arg1Rep), (arg1Mod), (arg2), (arg2Rep), (arg2Mod), (arg3), (arg3Rep), (arg3Mod), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorFragmentOp3ATI_debug(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod, const char* file, int line);
#ifndef glDeleteFragmentShaderATI
#define glDeleteFragmentShaderATI(id) glatter_glDeleteFragmentShaderATI_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteFragmentShaderATI_debug(GLuint id, const char* file, int line);
#ifndef glEndFragmentShaderATI
#define glEndFragmentShaderATI() glatter_glEndFragmentShaderATI_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndFragmentShaderATI_debug(const char* file, int line);
#ifndef glGenFragmentShadersATI
#define glGenFragmentShadersATI(range) glatter_glGenFragmentShadersATI_debug((range), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGenFragmentShadersATI_debug(GLuint range, const char* file, int line);
#ifndef glPassTexCoordATI
#define glPassTexCoordATI(dst, coord, swizzle) glatter_glPassTexCoordATI_debug((dst), (coord), (swizzle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPassTexCoordATI_debug(GLuint dst, GLuint coord, GLenum swizzle, const char* file, int line);
#ifndef glSampleMapATI
#define glSampleMapATI(dst, interp, swizzle) glatter_glSampleMapATI_debug((dst), (interp), (swizzle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSampleMapATI_debug(GLuint dst, GLuint interp, GLenum swizzle, const char* file, int line);
#ifndef glSetFragmentShaderConstantATI
#define glSetFragmentShaderConstantATI(dst, value) glatter_glSetFragmentShaderConstantATI_debug((dst), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSetFragmentShaderConstantATI_debug(GLuint dst, const GLfloat *value, const char* file, int line);
#endif // defined(GL_ATI_fragment_shader)
#if defined(GL_ATI_map_object_buffer)
#ifndef glMapObjectBufferATI
#define glMapObjectBufferATI(buffer) glatter_glMapObjectBufferATI_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void * glatter_glMapObjectBufferATI_debug(GLuint buffer, const char* file, int line);
#ifndef glUnmapObjectBufferATI
#define glUnmapObjectBufferATI(buffer) glatter_glUnmapObjectBufferATI_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUnmapObjectBufferATI_debug(GLuint buffer, const char* file, int line);
#endif // defined(GL_ATI_map_object_buffer)
#if defined(GL_ATI_pn_triangles)
#ifndef glPNTrianglesfATI
#define glPNTrianglesfATI(pname, param) glatter_glPNTrianglesfATI_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPNTrianglesfATI_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glPNTrianglesiATI
#define glPNTrianglesiATI(pname, param) glatter_glPNTrianglesiATI_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPNTrianglesiATI_debug(GLenum pname, GLint param, const char* file, int line);
#endif // defined(GL_ATI_pn_triangles)
#if defined(GL_ATI_separate_stencil)
#ifndef glStencilFuncSeparateATI
#define glStencilFuncSeparateATI(frontfunc, backfunc, ref, mask) glatter_glStencilFuncSeparateATI_debug((frontfunc), (backfunc), (ref), (mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilFuncSeparateATI_debug(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask, const char* file, int line);
#ifndef glStencilOpSeparateATI
#define glStencilOpSeparateATI(face, sfail, dpfail, dppass) glatter_glStencilOpSeparateATI_debug((face), (sfail), (dpfail), (dppass), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilOpSeparateATI_debug(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass, const char* file, int line);
#endif // defined(GL_ATI_separate_stencil)
#if defined(GL_ATI_vertex_array_object)
#ifndef glArrayObjectATI
#define glArrayObjectATI(array, size, type, stride, buffer, offset) glatter_glArrayObjectATI_debug((array), (size), (type), (stride), (buffer), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glArrayObjectATI_debug(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset, const char* file, int line);
#ifndef glFreeObjectBufferATI
#define glFreeObjectBufferATI(buffer) glatter_glFreeObjectBufferATI_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFreeObjectBufferATI_debug(GLuint buffer, const char* file, int line);
#ifndef glGetArrayObjectfvATI
#define glGetArrayObjectfvATI(array, pname, params) glatter_glGetArrayObjectfvATI_debug((array), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetArrayObjectfvATI_debug(GLenum array, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetArrayObjectivATI
#define glGetArrayObjectivATI(array, pname, params) glatter_glGetArrayObjectivATI_debug((array), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetArrayObjectivATI_debug(GLenum array, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetObjectBufferfvATI
#define glGetObjectBufferfvATI(buffer, pname, params) glatter_glGetObjectBufferfvATI_debug((buffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetObjectBufferfvATI_debug(GLuint buffer, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetObjectBufferivATI
#define glGetObjectBufferivATI(buffer, pname, params) glatter_glGetObjectBufferivATI_debug((buffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetObjectBufferivATI_debug(GLuint buffer, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetVariantArrayObjectfvATI
#define glGetVariantArrayObjectfvATI(id, pname, params) glatter_glGetVariantArrayObjectfvATI_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVariantArrayObjectfvATI_debug(GLuint id, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetVariantArrayObjectivATI
#define glGetVariantArrayObjectivATI(id, pname, params) glatter_glGetVariantArrayObjectivATI_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVariantArrayObjectivATI_debug(GLuint id, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsObjectBufferATI
#define glIsObjectBufferATI(buffer) glatter_glIsObjectBufferATI_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsObjectBufferATI_debug(GLuint buffer, const char* file, int line);
#ifndef glNewObjectBufferATI
#define glNewObjectBufferATI(size, pointer, usage) glatter_glNewObjectBufferATI_debug((size), (pointer), (usage), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glNewObjectBufferATI_debug(GLsizei size, const void *pointer, GLenum usage, const char* file, int line);
#ifndef glUpdateObjectBufferATI
#define glUpdateObjectBufferATI(buffer, offset, size, pointer, preserve) glatter_glUpdateObjectBufferATI_debug((buffer), (offset), (size), (pointer), (preserve), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUpdateObjectBufferATI_debug(GLuint buffer, GLuint offset, GLsizei size, const void *pointer, GLenum preserve, const char* file, int line);
#ifndef glVariantArrayObjectATI
#define glVariantArrayObjectATI(id, type, stride, buffer, offset) glatter_glVariantArrayObjectATI_debug((id), (type), (stride), (buffer), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantArrayObjectATI_debug(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset, const char* file, int line);
#endif // defined(GL_ATI_vertex_array_object)
#if defined(GL_ATI_vertex_attrib_array_object)
#ifndef glGetVertexAttribArrayObjectfvATI
#define glGetVertexAttribArrayObjectfvATI(index, pname, params) glatter_glGetVertexAttribArrayObjectfvATI_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribArrayObjectfvATI_debug(GLuint index, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetVertexAttribArrayObjectivATI
#define glGetVertexAttribArrayObjectivATI(index, pname, params) glatter_glGetVertexAttribArrayObjectivATI_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribArrayObjectivATI_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line);
#ifndef glVertexAttribArrayObjectATI
#define glVertexAttribArrayObjectATI(index, size, type, normalized, stride, buffer, offset) glatter_glVertexAttribArrayObjectATI_debug((index), (size), (type), (normalized), (stride), (buffer), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribArrayObjectATI_debug(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset, const char* file, int line);
#endif // defined(GL_ATI_vertex_attrib_array_object)
#if defined(GL_ATI_vertex_streams)
#ifndef glClientActiveVertexStreamATI
#define glClientActiveVertexStreamATI(stream) glatter_glClientActiveVertexStreamATI_debug((stream), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClientActiveVertexStreamATI_debug(GLenum stream, const char* file, int line);
#ifndef glNormalStream3bATI
#define glNormalStream3bATI(stream, nx, ny, nz) glatter_glNormalStream3bATI_debug((stream), (nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3bATI_debug(GLenum stream, GLbyte nx, GLbyte ny, GLbyte nz, const char* file, int line);
#ifndef glNormalStream3bvATI
#define glNormalStream3bvATI(stream, coords) glatter_glNormalStream3bvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3bvATI_debug(GLenum stream, const GLbyte *coords, const char* file, int line);
#ifndef glNormalStream3dATI
#define glNormalStream3dATI(stream, nx, ny, nz) glatter_glNormalStream3dATI_debug((stream), (nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3dATI_debug(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz, const char* file, int line);
#ifndef glNormalStream3dvATI
#define glNormalStream3dvATI(stream, coords) glatter_glNormalStream3dvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line);
#ifndef glNormalStream3fATI
#define glNormalStream3fATI(stream, nx, ny, nz) glatter_glNormalStream3fATI_debug((stream), (nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3fATI_debug(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz, const char* file, int line);
#ifndef glNormalStream3fvATI
#define glNormalStream3fvATI(stream, coords) glatter_glNormalStream3fvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line);
#ifndef glNormalStream3iATI
#define glNormalStream3iATI(stream, nx, ny, nz) glatter_glNormalStream3iATI_debug((stream), (nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3iATI_debug(GLenum stream, GLint nx, GLint ny, GLint nz, const char* file, int line);
#ifndef glNormalStream3ivATI
#define glNormalStream3ivATI(stream, coords) glatter_glNormalStream3ivATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line);
#ifndef glNormalStream3sATI
#define glNormalStream3sATI(stream, nx, ny, nz) glatter_glNormalStream3sATI_debug((stream), (nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3sATI_debug(GLenum stream, GLshort nx, GLshort ny, GLshort nz, const char* file, int line);
#ifndef glNormalStream3svATI
#define glNormalStream3svATI(stream, coords) glatter_glNormalStream3svATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line);
#ifndef glVertexBlendEnvfATI
#define glVertexBlendEnvfATI(pname, param) glatter_glVertexBlendEnvfATI_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexBlendEnvfATI_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glVertexBlendEnviATI
#define glVertexBlendEnviATI(pname, param) glatter_glVertexBlendEnviATI_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexBlendEnviATI_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glVertexStream1dATI
#define glVertexStream1dATI(stream, x) glatter_glVertexStream1dATI_debug((stream), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1dATI_debug(GLenum stream, GLdouble x, const char* file, int line);
#ifndef glVertexStream1dvATI
#define glVertexStream1dvATI(stream, coords) glatter_glVertexStream1dvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line);
#ifndef glVertexStream1fATI
#define glVertexStream1fATI(stream, x) glatter_glVertexStream1fATI_debug((stream), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1fATI_debug(GLenum stream, GLfloat x, const char* file, int line);
#ifndef glVertexStream1fvATI
#define glVertexStream1fvATI(stream, coords) glatter_glVertexStream1fvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line);
#ifndef glVertexStream1iATI
#define glVertexStream1iATI(stream, x) glatter_glVertexStream1iATI_debug((stream), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1iATI_debug(GLenum stream, GLint x, const char* file, int line);
#ifndef glVertexStream1ivATI
#define glVertexStream1ivATI(stream, coords) glatter_glVertexStream1ivATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line);
#ifndef glVertexStream1sATI
#define glVertexStream1sATI(stream, x) glatter_glVertexStream1sATI_debug((stream), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1sATI_debug(GLenum stream, GLshort x, const char* file, int line);
#ifndef glVertexStream1svATI
#define glVertexStream1svATI(stream, coords) glatter_glVertexStream1svATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line);
#ifndef glVertexStream2dATI
#define glVertexStream2dATI(stream, x, y) glatter_glVertexStream2dATI_debug((stream), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2dATI_debug(GLenum stream, GLdouble x, GLdouble y, const char* file, int line);
#ifndef glVertexStream2dvATI
#define glVertexStream2dvATI(stream, coords) glatter_glVertexStream2dvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line);
#ifndef glVertexStream2fATI
#define glVertexStream2fATI(stream, x, y) glatter_glVertexStream2fATI_debug((stream), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2fATI_debug(GLenum stream, GLfloat x, GLfloat y, const char* file, int line);
#ifndef glVertexStream2fvATI
#define glVertexStream2fvATI(stream, coords) glatter_glVertexStream2fvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line);
#ifndef glVertexStream2iATI
#define glVertexStream2iATI(stream, x, y) glatter_glVertexStream2iATI_debug((stream), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2iATI_debug(GLenum stream, GLint x, GLint y, const char* file, int line);
#ifndef glVertexStream2ivATI
#define glVertexStream2ivATI(stream, coords) glatter_glVertexStream2ivATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line);
#ifndef glVertexStream2sATI
#define glVertexStream2sATI(stream, x, y) glatter_glVertexStream2sATI_debug((stream), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2sATI_debug(GLenum stream, GLshort x, GLshort y, const char* file, int line);
#ifndef glVertexStream2svATI
#define glVertexStream2svATI(stream, coords) glatter_glVertexStream2svATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line);
#ifndef glVertexStream3dATI
#define glVertexStream3dATI(stream, x, y, z) glatter_glVertexStream3dATI_debug((stream), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3dATI_debug(GLenum stream, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glVertexStream3dvATI
#define glVertexStream3dvATI(stream, coords) glatter_glVertexStream3dvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line);
#ifndef glVertexStream3fATI
#define glVertexStream3fATI(stream, x, y, z) glatter_glVertexStream3fATI_debug((stream), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3fATI_debug(GLenum stream, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glVertexStream3fvATI
#define glVertexStream3fvATI(stream, coords) glatter_glVertexStream3fvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line);
#ifndef glVertexStream3iATI
#define glVertexStream3iATI(stream, x, y, z) glatter_glVertexStream3iATI_debug((stream), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3iATI_debug(GLenum stream, GLint x, GLint y, GLint z, const char* file, int line);
#ifndef glVertexStream3ivATI
#define glVertexStream3ivATI(stream, coords) glatter_glVertexStream3ivATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line);
#ifndef glVertexStream3sATI
#define glVertexStream3sATI(stream, x, y, z) glatter_glVertexStream3sATI_debug((stream), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3sATI_debug(GLenum stream, GLshort x, GLshort y, GLshort z, const char* file, int line);
#ifndef glVertexStream3svATI
#define glVertexStream3svATI(stream, coords) glatter_glVertexStream3svATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line);
#ifndef glVertexStream4dATI
#define glVertexStream4dATI(stream, x, y, z, w) glatter_glVertexStream4dATI_debug((stream), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4dATI_debug(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glVertexStream4dvATI
#define glVertexStream4dvATI(stream, coords) glatter_glVertexStream4dvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line);
#ifndef glVertexStream4fATI
#define glVertexStream4fATI(stream, x, y, z, w) glatter_glVertexStream4fATI_debug((stream), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4fATI_debug(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glVertexStream4fvATI
#define glVertexStream4fvATI(stream, coords) glatter_glVertexStream4fvATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line);
#ifndef glVertexStream4iATI
#define glVertexStream4iATI(stream, x, y, z, w) glatter_glVertexStream4iATI_debug((stream), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4iATI_debug(GLenum stream, GLint x, GLint y, GLint z, GLint w, const char* file, int line);
#ifndef glVertexStream4ivATI
#define glVertexStream4ivATI(stream, coords) glatter_glVertexStream4ivATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line);
#ifndef glVertexStream4sATI
#define glVertexStream4sATI(stream, x, y, z, w) glatter_glVertexStream4sATI_debug((stream), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4sATI_debug(GLenum stream, GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line);
#ifndef glVertexStream4svATI
#define glVertexStream4svATI(stream, coords) glatter_glVertexStream4svATI_debug((stream), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line);
#endif // defined(GL_ATI_vertex_streams)
#if defined(GL_EXT_EGL_image_storage)
#ifndef glEGLImageTargetTexStorageEXT
#define glEGLImageTargetTexStorageEXT(target, image, attrib_list) glatter_glEGLImageTargetTexStorageEXT_debug((target), (image), (attrib_list), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetTexStorageEXT_debug(GLenum target, GLeglImageOES image, const GLint* attrib_list, const char* file, int line);
#ifndef glEGLImageTargetTextureStorageEXT
#define glEGLImageTargetTextureStorageEXT(texture, image, attrib_list) glatter_glEGLImageTargetTextureStorageEXT_debug((texture), (image), (attrib_list), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetTextureStorageEXT_debug(GLuint texture, GLeglImageOES image, const GLint* attrib_list, const char* file, int line);
#endif // defined(GL_EXT_EGL_image_storage)
#if defined(GL_EXT_bindable_uniform)
#ifndef glGetUniformBufferSizeEXT
#define glGetUniformBufferSizeEXT(program, location) glatter_glGetUniformBufferSizeEXT_debug((program), (location), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetUniformBufferSizeEXT_debug(GLuint program, GLint location, const char* file, int line);
#ifndef glGetUniformOffsetEXT
#define glGetUniformOffsetEXT(program, location) glatter_glGetUniformOffsetEXT_debug((program), (location), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLintptr glatter_glGetUniformOffsetEXT_debug(GLuint program, GLint location, const char* file, int line);
#ifndef glUniformBufferEXT
#define glUniformBufferEXT(program, location, buffer) glatter_glUniformBufferEXT_debug((program), (location), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformBufferEXT_debug(GLuint program, GLint location, GLuint buffer, const char* file, int line);
#endif // defined(GL_EXT_bindable_uniform)
#if defined(GL_EXT_blend_color)
#ifndef glBlendColorEXT
#define glBlendColorEXT(red, green, blue, alpha) glatter_glBlendColorEXT_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendColorEXT_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line);
#endif // defined(GL_EXT_blend_color)
#if defined(GL_EXT_blend_equation_separate)
#ifndef glBlendEquationSeparateEXT
#define glBlendEquationSeparateEXT(modeRGB, modeAlpha) glatter_glBlendEquationSeparateEXT_debug((modeRGB), (modeAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparateEXT_debug(GLenum modeRGB, GLenum modeAlpha, const char* file, int line);
#endif // defined(GL_EXT_blend_equation_separate)
#if defined(GL_EXT_blend_func_separate)
#ifndef glBlendFuncSeparateEXT
#define glBlendFuncSeparateEXT(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha) glatter_glBlendFuncSeparateEXT_debug((sfactorRGB), (dfactorRGB), (sfactorAlpha), (dfactorAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateEXT_debug(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha, const char* file, int line);
#endif // defined(GL_EXT_blend_func_separate)
#if defined(GL_EXT_blend_minmax)
#ifndef glBlendEquationEXT
#define glBlendEquationEXT(mode) glatter_glBlendEquationEXT_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationEXT_debug(GLenum mode, const char* file, int line);
#endif // defined(GL_EXT_blend_minmax)
#if defined(GL_EXT_color_subtable)
#ifndef glColorSubTableEXT
#define glColorSubTableEXT(target, start, count, format, type, data) glatter_glColorSubTableEXT_debug((target), (start), (count), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorSubTableEXT_debug(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data, const char* file, int line);
#ifndef glCopyColorSubTableEXT
#define glCopyColorSubTableEXT(target, start, x, y, width) glatter_glCopyColorSubTableEXT_debug((target), (start), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyColorSubTableEXT_debug(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width, const char* file, int line);
#endif // defined(GL_EXT_color_subtable)
#if defined(GL_EXT_compiled_vertex_array)
#ifndef glLockArraysEXT
#define glLockArraysEXT(first, count) glatter_glLockArraysEXT_debug((first), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLockArraysEXT_debug(GLint first, GLsizei count, const char* file, int line);
#ifndef glUnlockArraysEXT
#define glUnlockArraysEXT() glatter_glUnlockArraysEXT_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUnlockArraysEXT_debug(const char* file, int line);
#endif // defined(GL_EXT_compiled_vertex_array)
#if defined(GL_EXT_convolution)
#ifndef glConvolutionFilter1DEXT
#define glConvolutionFilter1DEXT(target, internalformat, width, format, type, image) glatter_glConvolutionFilter1DEXT_debug((target), (internalformat), (width), (format), (type), (image), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionFilter1DEXT_debug(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image, const char* file, int line);
#ifndef glConvolutionFilter2DEXT
#define glConvolutionFilter2DEXT(target, internalformat, width, height, format, type, image) glatter_glConvolutionFilter2DEXT_debug((target), (internalformat), (width), (height), (format), (type), (image), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionFilter2DEXT_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image, const char* file, int line);
#ifndef glConvolutionParameterfEXT
#define glConvolutionParameterfEXT(target, pname, params) glatter_glConvolutionParameterfEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterfEXT_debug(GLenum target, GLenum pname, GLfloat params, const char* file, int line);
#ifndef glConvolutionParameterfvEXT
#define glConvolutionParameterfvEXT(target, pname, params) glatter_glConvolutionParameterfvEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterfvEXT_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glConvolutionParameteriEXT
#define glConvolutionParameteriEXT(target, pname, params) glatter_glConvolutionParameteriEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameteriEXT_debug(GLenum target, GLenum pname, GLint params, const char* file, int line);
#ifndef glConvolutionParameterivEXT
#define glConvolutionParameterivEXT(target, pname, params) glatter_glConvolutionParameterivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterivEXT_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glCopyConvolutionFilter1DEXT
#define glCopyConvolutionFilter1DEXT(target, internalformat, x, y, width) glatter_glCopyConvolutionFilter1DEXT_debug((target), (internalformat), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyConvolutionFilter1DEXT_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glCopyConvolutionFilter2DEXT
#define glCopyConvolutionFilter2DEXT(target, internalformat, x, y, width, height) glatter_glCopyConvolutionFilter2DEXT_debug((target), (internalformat), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyConvolutionFilter2DEXT_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glGetConvolutionFilterEXT
#define glGetConvolutionFilterEXT(target, format, type, image) glatter_glGetConvolutionFilterEXT_debug((target), (format), (type), (image), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionFilterEXT_debug(GLenum target, GLenum format, GLenum type, void *image, const char* file, int line);
#ifndef glGetConvolutionParameterfvEXT
#define glGetConvolutionParameterfvEXT(target, pname, params) glatter_glGetConvolutionParameterfvEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetConvolutionParameterivEXT
#define glGetConvolutionParameterivEXT(target, pname, params) glatter_glGetConvolutionParameterivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetSeparableFilterEXT
#define glGetSeparableFilterEXT(target, format, type, row, column, span) glatter_glGetSeparableFilterEXT_debug((target), (format), (type), (row), (column), (span), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetSeparableFilterEXT_debug(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span, const char* file, int line);
#ifndef glSeparableFilter2DEXT
#define glSeparableFilter2DEXT(target, internalformat, width, height, format, type, row, column) glatter_glSeparableFilter2DEXT_debug((target), (internalformat), (width), (height), (format), (type), (row), (column), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSeparableFilter2DEXT_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column, const char* file, int line);
#endif // defined(GL_EXT_convolution)
#if defined(GL_EXT_coordinate_frame)
#ifndef glBinormal3bEXT
#define glBinormal3bEXT(bx, by, bz) glatter_glBinormal3bEXT_debug((bx), (by), (bz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3bEXT_debug(GLbyte bx, GLbyte by, GLbyte bz, const char* file, int line);
#ifndef glBinormal3bvEXT
#define glBinormal3bvEXT(v) glatter_glBinormal3bvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3bvEXT_debug(const GLbyte *v, const char* file, int line);
#ifndef glBinormal3dEXT
#define glBinormal3dEXT(bx, by, bz) glatter_glBinormal3dEXT_debug((bx), (by), (bz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3dEXT_debug(GLdouble bx, GLdouble by, GLdouble bz, const char* file, int line);
#ifndef glBinormal3dvEXT
#define glBinormal3dvEXT(v) glatter_glBinormal3dvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3dvEXT_debug(const GLdouble *v, const char* file, int line);
#ifndef glBinormal3fEXT
#define glBinormal3fEXT(bx, by, bz) glatter_glBinormal3fEXT_debug((bx), (by), (bz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3fEXT_debug(GLfloat bx, GLfloat by, GLfloat bz, const char* file, int line);
#ifndef glBinormal3fvEXT
#define glBinormal3fvEXT(v) glatter_glBinormal3fvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3fvEXT_debug(const GLfloat *v, const char* file, int line);
#ifndef glBinormal3iEXT
#define glBinormal3iEXT(bx, by, bz) glatter_glBinormal3iEXT_debug((bx), (by), (bz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3iEXT_debug(GLint bx, GLint by, GLint bz, const char* file, int line);
#ifndef glBinormal3ivEXT
#define glBinormal3ivEXT(v) glatter_glBinormal3ivEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3ivEXT_debug(const GLint *v, const char* file, int line);
#ifndef glBinormal3sEXT
#define glBinormal3sEXT(bx, by, bz) glatter_glBinormal3sEXT_debug((bx), (by), (bz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3sEXT_debug(GLshort bx, GLshort by, GLshort bz, const char* file, int line);
#ifndef glBinormal3svEXT
#define glBinormal3svEXT(v) glatter_glBinormal3svEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormal3svEXT_debug(const GLshort *v, const char* file, int line);
#ifndef glBinormalPointerEXT
#define glBinormalPointerEXT(type, stride, pointer) glatter_glBinormalPointerEXT_debug((type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBinormalPointerEXT_debug(GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glTangent3bEXT
#define glTangent3bEXT(tx, ty, tz) glatter_glTangent3bEXT_debug((tx), (ty), (tz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3bEXT_debug(GLbyte tx, GLbyte ty, GLbyte tz, const char* file, int line);
#ifndef glTangent3bvEXT
#define glTangent3bvEXT(v) glatter_glTangent3bvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3bvEXT_debug(const GLbyte *v, const char* file, int line);
#ifndef glTangent3dEXT
#define glTangent3dEXT(tx, ty, tz) glatter_glTangent3dEXT_debug((tx), (ty), (tz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3dEXT_debug(GLdouble tx, GLdouble ty, GLdouble tz, const char* file, int line);
#ifndef glTangent3dvEXT
#define glTangent3dvEXT(v) glatter_glTangent3dvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3dvEXT_debug(const GLdouble *v, const char* file, int line);
#ifndef glTangent3fEXT
#define glTangent3fEXT(tx, ty, tz) glatter_glTangent3fEXT_debug((tx), (ty), (tz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3fEXT_debug(GLfloat tx, GLfloat ty, GLfloat tz, const char* file, int line);
#ifndef glTangent3fvEXT
#define glTangent3fvEXT(v) glatter_glTangent3fvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3fvEXT_debug(const GLfloat *v, const char* file, int line);
#ifndef glTangent3iEXT
#define glTangent3iEXT(tx, ty, tz) glatter_glTangent3iEXT_debug((tx), (ty), (tz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3iEXT_debug(GLint tx, GLint ty, GLint tz, const char* file, int line);
#ifndef glTangent3ivEXT
#define glTangent3ivEXT(v) glatter_glTangent3ivEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3ivEXT_debug(const GLint *v, const char* file, int line);
#ifndef glTangent3sEXT
#define glTangent3sEXT(tx, ty, tz) glatter_glTangent3sEXT_debug((tx), (ty), (tz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3sEXT_debug(GLshort tx, GLshort ty, GLshort tz, const char* file, int line);
#ifndef glTangent3svEXT
#define glTangent3svEXT(v) glatter_glTangent3svEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangent3svEXT_debug(const GLshort *v, const char* file, int line);
#ifndef glTangentPointerEXT
#define glTangentPointerEXT(type, stride, pointer) glatter_glTangentPointerEXT_debug((type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTangentPointerEXT_debug(GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#endif // defined(GL_EXT_coordinate_frame)
#if defined(GL_EXT_copy_texture)
#ifndef glCopyTexImage1DEXT
#define glCopyTexImage1DEXT(target, level, internalformat, x, y, width, border) glatter_glCopyTexImage1DEXT_debug((target), (level), (internalformat), (x), (y), (width), (border), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage1DEXT_debug(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border, const char* file, int line);
#ifndef glCopyTexImage2DEXT
#define glCopyTexImage2DEXT(target, level, internalformat, x, y, width, height, border) glatter_glCopyTexImage2DEXT_debug((target), (level), (internalformat), (x), (y), (width), (height), (border), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage2DEXT_debug(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line);
#ifndef glCopyTexSubImage1DEXT
#define glCopyTexSubImage1DEXT(target, level, xoffset, x, y, width) glatter_glCopyTexSubImage1DEXT_debug((target), (level), (xoffset), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage1DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glCopyTexSubImage2DEXT
#define glCopyTexSubImage2DEXT(target, level, xoffset, yoffset, x, y, width, height) glatter_glCopyTexSubImage2DEXT_debug((target), (level), (xoffset), (yoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage2DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glCopyTexSubImage3DEXT
#define glCopyTexSubImage3DEXT(target, level, xoffset, yoffset, zoffset, x, y, width, height) glatter_glCopyTexSubImage3DEXT_debug((target), (level), (xoffset), (yoffset), (zoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage3DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#endif // defined(GL_EXT_copy_texture)
#if defined(GL_EXT_cull_vertex)
#ifndef glCullParameterdvEXT
#define glCullParameterdvEXT(pname, params) glatter_glCullParameterdvEXT_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCullParameterdvEXT_debug(GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glCullParameterfvEXT
#define glCullParameterfvEXT(pname, params) glatter_glCullParameterfvEXT_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCullParameterfvEXT_debug(GLenum pname, GLfloat *params, const char* file, int line);
#endif // defined(GL_EXT_cull_vertex)
#if defined(GL_EXT_debug_label)
#ifndef glGetObjectLabelEXT
#define glGetObjectLabelEXT(type, object, bufSize, length, label) glatter_glGetObjectLabelEXT_debug((type), (object), (bufSize), (length), (label), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetObjectLabelEXT_debug(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label, const char* file, int line);
#ifndef glLabelObjectEXT
#define glLabelObjectEXT(type, object, length, label) glatter_glLabelObjectEXT_debug((type), (object), (length), (label), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLabelObjectEXT_debug(GLenum type, GLuint object, GLsizei length, const GLchar *label, const char* file, int line);
#endif // defined(GL_EXT_debug_label)
#if defined(GL_EXT_debug_marker)
#ifndef glInsertEventMarkerEXT
#define glInsertEventMarkerEXT(length, marker) glatter_glInsertEventMarkerEXT_debug((length), (marker), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInsertEventMarkerEXT_debug(GLsizei length, const GLchar *marker, const char* file, int line);
#ifndef glPopGroupMarkerEXT
#define glPopGroupMarkerEXT() glatter_glPopGroupMarkerEXT_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPopGroupMarkerEXT_debug(const char* file, int line);
#ifndef glPushGroupMarkerEXT
#define glPushGroupMarkerEXT(length, marker) glatter_glPushGroupMarkerEXT_debug((length), (marker), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPushGroupMarkerEXT_debug(GLsizei length, const GLchar *marker, const char* file, int line);
#endif // defined(GL_EXT_debug_marker)
#if defined(GL_EXT_depth_bounds_test)
#ifndef glDepthBoundsEXT
#define glDepthBoundsEXT(zmin, zmax) glatter_glDepthBoundsEXT_debug((zmin), (zmax), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthBoundsEXT_debug(GLclampd zmin, GLclampd zmax, const char* file, int line);
#endif // defined(GL_EXT_depth_bounds_test)
#if defined(GL_EXT_direct_state_access)
#ifndef glBindMultiTextureEXT
#define glBindMultiTextureEXT(texunit, target, texture) glatter_glBindMultiTextureEXT_debug((texunit), (target), (texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindMultiTextureEXT_debug(GLenum texunit, GLenum target, GLuint texture, const char* file, int line);
#ifndef glCheckNamedFramebufferStatusEXT
#define glCheckNamedFramebufferStatusEXT(framebuffer, target) glatter_glCheckNamedFramebufferStatusEXT_debug((framebuffer), (target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glCheckNamedFramebufferStatusEXT_debug(GLuint framebuffer, GLenum target, const char* file, int line);
#ifndef glClearNamedBufferDataEXT
#define glClearNamedBufferDataEXT(buffer, internalformat, format, type, data) glatter_glClearNamedBufferDataEXT_debug((buffer), (internalformat), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearNamedBufferDataEXT_debug(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data, const char* file, int line);
#ifndef glClearNamedBufferSubDataEXT
#define glClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, data) glatter_glClearNamedBufferSubDataEXT_debug((buffer), (internalformat), (offset), (size), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearNamedBufferSubDataEXT_debug(GLuint buffer, GLenum internalformat, GLsizeiptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data, const char* file, int line);
#ifndef glClientAttribDefaultEXT
#define glClientAttribDefaultEXT(mask) glatter_glClientAttribDefaultEXT_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClientAttribDefaultEXT_debug(GLbitfield mask, const char* file, int line);
#ifndef glCompressedMultiTexImage1DEXT
#define glCompressedMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, imageSize, bits) glatter_glCompressedMultiTexImage1DEXT_debug((texunit), (target), (level), (internalformat), (width), (border), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedMultiTexImage2DEXT
#define glCompressedMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, imageSize, bits) glatter_glCompressedMultiTexImage2DEXT_debug((texunit), (target), (level), (internalformat), (width), (height), (border), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedMultiTexImage3DEXT
#define glCompressedMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, imageSize, bits) glatter_glCompressedMultiTexImage3DEXT_debug((texunit), (target), (level), (internalformat), (width), (height), (depth), (border), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedMultiTexSubImage1DEXT
#define glCompressedMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, imageSize, bits) glatter_glCompressedMultiTexSubImage1DEXT_debug((texunit), (target), (level), (xoffset), (width), (format), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexSubImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedMultiTexSubImage2DEXT
#define glCompressedMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, imageSize, bits) glatter_glCompressedMultiTexSubImage2DEXT_debug((texunit), (target), (level), (xoffset), (yoffset), (width), (height), (format), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexSubImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedMultiTexSubImage3DEXT
#define glCompressedMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits) glatter_glCompressedMultiTexSubImage3DEXT_debug((texunit), (target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexSubImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedTextureImage1DEXT
#define glCompressedTextureImage1DEXT(texture, target, level, internalformat, width, border, imageSize, bits) glatter_glCompressedTextureImage1DEXT_debug((texture), (target), (level), (internalformat), (width), (border), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedTextureImage2DEXT
#define glCompressedTextureImage2DEXT(texture, target, level, internalformat, width, height, border, imageSize, bits) glatter_glCompressedTextureImage2DEXT_debug((texture), (target), (level), (internalformat), (width), (height), (border), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedTextureImage3DEXT
#define glCompressedTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, imageSize, bits) glatter_glCompressedTextureImage3DEXT_debug((texture), (target), (level), (internalformat), (width), (height), (depth), (border), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedTextureSubImage1DEXT
#define glCompressedTextureSubImage1DEXT(texture, target, level, xoffset, width, format, imageSize, bits) glatter_glCompressedTextureSubImage1DEXT_debug((texture), (target), (level), (xoffset), (width), (format), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureSubImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedTextureSubImage2DEXT
#define glCompressedTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, imageSize, bits) glatter_glCompressedTextureSubImage2DEXT_debug((texture), (target), (level), (xoffset), (yoffset), (width), (height), (format), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureSubImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCompressedTextureSubImage3DEXT
#define glCompressedTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits) glatter_glCompressedTextureSubImage3DEXT_debug((texture), (target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (imageSize), (bits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureSubImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line);
#ifndef glCopyMultiTexImage1DEXT
#define glCopyMultiTexImage1DEXT(texunit, target, level, internalformat, x, y, width, border) glatter_glCopyMultiTexImage1DEXT_debug((texunit), (target), (level), (internalformat), (x), (y), (width), (border), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border, const char* file, int line);
#ifndef glCopyMultiTexImage2DEXT
#define glCopyMultiTexImage2DEXT(texunit, target, level, internalformat, x, y, width, height, border) glatter_glCopyMultiTexImage2DEXT_debug((texunit), (target), (level), (internalformat), (x), (y), (width), (height), (border), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line);
#ifndef glCopyMultiTexSubImage1DEXT
#define glCopyMultiTexSubImage1DEXT(texunit, target, level, xoffset, x, y, width) glatter_glCopyMultiTexSubImage1DEXT_debug((texunit), (target), (level), (xoffset), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexSubImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glCopyMultiTexSubImage2DEXT
#define glCopyMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, x, y, width, height) glatter_glCopyMultiTexSubImage2DEXT_debug((texunit), (target), (level), (xoffset), (yoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexSubImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glCopyMultiTexSubImage3DEXT
#define glCopyMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, x, y, width, height) glatter_glCopyMultiTexSubImage3DEXT_debug((texunit), (target), (level), (xoffset), (yoffset), (zoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexSubImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glCopyTextureImage1DEXT
#define glCopyTextureImage1DEXT(texture, target, level, internalformat, x, y, width, border) glatter_glCopyTextureImage1DEXT_debug((texture), (target), (level), (internalformat), (x), (y), (width), (border), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border, const char* file, int line);
#ifndef glCopyTextureImage2DEXT
#define glCopyTextureImage2DEXT(texture, target, level, internalformat, x, y, width, height, border) glatter_glCopyTextureImage2DEXT_debug((texture), (target), (level), (internalformat), (x), (y), (width), (height), (border), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line);
#ifndef glCopyTextureSubImage1DEXT
#define glCopyTextureSubImage1DEXT(texture, target, level, xoffset, x, y, width) glatter_glCopyTextureSubImage1DEXT_debug((texture), (target), (level), (xoffset), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureSubImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glCopyTextureSubImage2DEXT
#define glCopyTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, x, y, width, height) glatter_glCopyTextureSubImage2DEXT_debug((texture), (target), (level), (xoffset), (yoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureSubImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glCopyTextureSubImage3DEXT
#define glCopyTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, x, y, width, height) glatter_glCopyTextureSubImage3DEXT_debug((texture), (target), (level), (xoffset), (yoffset), (zoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureSubImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glDisableClientStateIndexedEXT
#define glDisableClientStateIndexedEXT(array, index) glatter_glDisableClientStateIndexedEXT_debug((array), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableClientStateIndexedEXT_debug(GLenum array, GLuint index, const char* file, int line);
#ifndef glDisableClientStateiEXT
#define glDisableClientStateiEXT(array, index) glatter_glDisableClientStateiEXT_debug((array), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableClientStateiEXT_debug(GLenum array, GLuint index, const char* file, int line);
#ifndef glDisableIndexedEXT
#define glDisableIndexedEXT(target, index) glatter_glDisableIndexedEXT_debug((target), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableIndexedEXT_debug(GLenum target, GLuint index, const char* file, int line);
#ifndef glDisableVertexArrayAttribEXT
#define glDisableVertexArrayAttribEXT(vaobj, index) glatter_glDisableVertexArrayAttribEXT_debug((vaobj), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexArrayAttribEXT_debug(GLuint vaobj, GLuint index, const char* file, int line);
#ifndef glDisableVertexArrayEXT
#define glDisableVertexArrayEXT(vaobj, array) glatter_glDisableVertexArrayEXT_debug((vaobj), (array), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexArrayEXT_debug(GLuint vaobj, GLenum array, const char* file, int line);
#ifndef glEnableClientStateIndexedEXT
#define glEnableClientStateIndexedEXT(array, index) glatter_glEnableClientStateIndexedEXT_debug((array), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableClientStateIndexedEXT_debug(GLenum array, GLuint index, const char* file, int line);
#ifndef glEnableClientStateiEXT
#define glEnableClientStateiEXT(array, index) glatter_glEnableClientStateiEXT_debug((array), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableClientStateiEXT_debug(GLenum array, GLuint index, const char* file, int line);
#ifndef glEnableIndexedEXT
#define glEnableIndexedEXT(target, index) glatter_glEnableIndexedEXT_debug((target), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableIndexedEXT_debug(GLenum target, GLuint index, const char* file, int line);
#ifndef glEnableVertexArrayAttribEXT
#define glEnableVertexArrayAttribEXT(vaobj, index) glatter_glEnableVertexArrayAttribEXT_debug((vaobj), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexArrayAttribEXT_debug(GLuint vaobj, GLuint index, const char* file, int line);
#ifndef glEnableVertexArrayEXT
#define glEnableVertexArrayEXT(vaobj, array) glatter_glEnableVertexArrayEXT_debug((vaobj), (array), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexArrayEXT_debug(GLuint vaobj, GLenum array, const char* file, int line);
#ifndef glFlushMappedNamedBufferRangeEXT
#define glFlushMappedNamedBufferRangeEXT(buffer, offset, length) glatter_glFlushMappedNamedBufferRangeEXT_debug((buffer), (offset), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlushMappedNamedBufferRangeEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr length, const char* file, int line);
#ifndef glFramebufferDrawBufferEXT
#define glFramebufferDrawBufferEXT(framebuffer, mode) glatter_glFramebufferDrawBufferEXT_debug((framebuffer), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferDrawBufferEXT_debug(GLuint framebuffer, GLenum mode, const char* file, int line);
#ifndef glFramebufferDrawBuffersEXT
#define glFramebufferDrawBuffersEXT(framebuffer, n, bufs) glatter_glFramebufferDrawBuffersEXT_debug((framebuffer), (n), (bufs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferDrawBuffersEXT_debug(GLuint framebuffer, GLsizei n, const GLenum *bufs, const char* file, int line);
#ifndef glFramebufferReadBufferEXT
#define glFramebufferReadBufferEXT(framebuffer, mode) glatter_glFramebufferReadBufferEXT_debug((framebuffer), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferReadBufferEXT_debug(GLuint framebuffer, GLenum mode, const char* file, int line);
#ifndef glGenerateMultiTexMipmapEXT
#define glGenerateMultiTexMipmapEXT(texunit, target) glatter_glGenerateMultiTexMipmapEXT_debug((texunit), (target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenerateMultiTexMipmapEXT_debug(GLenum texunit, GLenum target, const char* file, int line);
#ifndef glGenerateTextureMipmapEXT
#define glGenerateTextureMipmapEXT(texture, target) glatter_glGenerateTextureMipmapEXT_debug((texture), (target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenerateTextureMipmapEXT_debug(GLuint texture, GLenum target, const char* file, int line);
#ifndef glGetBooleanIndexedvEXT
#define glGetBooleanIndexedvEXT(target, index, data) glatter_glGetBooleanIndexedvEXT_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBooleanIndexedvEXT_debug(GLenum target, GLuint index, GLboolean *data, const char* file, int line);
#ifndef glGetCompressedMultiTexImageEXT
#define glGetCompressedMultiTexImageEXT(texunit, target, lod, img) glatter_glGetCompressedMultiTexImageEXT_debug((texunit), (target), (lod), (img), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCompressedMultiTexImageEXT_debug(GLenum texunit, GLenum target, GLint lod, void *img, const char* file, int line);
#ifndef glGetCompressedTextureImageEXT
#define glGetCompressedTextureImageEXT(texture, target, lod, img) glatter_glGetCompressedTextureImageEXT_debug((texture), (target), (lod), (img), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCompressedTextureImageEXT_debug(GLuint texture, GLenum target, GLint lod, void *img, const char* file, int line);
#ifndef glGetDoubleIndexedvEXT
#define glGetDoubleIndexedvEXT(target, index, data) glatter_glGetDoubleIndexedvEXT_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetDoubleIndexedvEXT_debug(GLenum target, GLuint index, GLdouble *data, const char* file, int line);
#ifndef glGetDoublei_vEXT
#define glGetDoublei_vEXT(pname, index, params) glatter_glGetDoublei_vEXT_debug((pname), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetDoublei_vEXT_debug(GLenum pname, GLuint index, GLdouble *params, const char* file, int line);
#ifndef glGetFloatIndexedvEXT
#define glGetFloatIndexedvEXT(target, index, data) glatter_glGetFloatIndexedvEXT_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFloatIndexedvEXT_debug(GLenum target, GLuint index, GLfloat *data, const char* file, int line);
#ifndef glGetFloati_vEXT
#define glGetFloati_vEXT(pname, index, params) glatter_glGetFloati_vEXT_debug((pname), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFloati_vEXT_debug(GLenum pname, GLuint index, GLfloat *params, const char* file, int line);
#ifndef glGetFramebufferParameterivEXT
#define glGetFramebufferParameterivEXT(framebuffer, pname, params) glatter_glGetFramebufferParameterivEXT_debug((framebuffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferParameterivEXT_debug(GLuint framebuffer, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetIntegerIndexedvEXT
#define glGetIntegerIndexedvEXT(target, index, data) glatter_glGetIntegerIndexedvEXT_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetIntegerIndexedvEXT_debug(GLenum target, GLuint index, GLint *data, const char* file, int line);
#ifndef glGetMultiTexEnvfvEXT
#define glGetMultiTexEnvfvEXT(texunit, target, pname, params) glatter_glGetMultiTexEnvfvEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexEnvfvEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetMultiTexEnvivEXT
#define glGetMultiTexEnvivEXT(texunit, target, pname, params) glatter_glGetMultiTexEnvivEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexEnvivEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetMultiTexGendvEXT
#define glGetMultiTexGendvEXT(texunit, coord, pname, params) glatter_glGetMultiTexGendvEXT_debug((texunit), (coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexGendvEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glGetMultiTexGenfvEXT
#define glGetMultiTexGenfvEXT(texunit, coord, pname, params) glatter_glGetMultiTexGenfvEXT_debug((texunit), (coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexGenfvEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetMultiTexGenivEXT
#define glGetMultiTexGenivEXT(texunit, coord, pname, params) glatter_glGetMultiTexGenivEXT_debug((texunit), (coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexGenivEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetMultiTexImageEXT
#define glGetMultiTexImageEXT(texunit, target, level, format, type, pixels) glatter_glGetMultiTexImageEXT_debug((texunit), (target), (level), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexImageEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, void *pixels, const char* file, int line);
#ifndef glGetMultiTexLevelParameterfvEXT
#define glGetMultiTexLevelParameterfvEXT(texunit, target, level, pname, params) glatter_glGetMultiTexLevelParameterfvEXT_debug((texunit), (target), (level), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexLevelParameterfvEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetMultiTexLevelParameterivEXT
#define glGetMultiTexLevelParameterivEXT(texunit, target, level, pname, params) glatter_glGetMultiTexLevelParameterivEXT_debug((texunit), (target), (level), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexLevelParameterivEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetMultiTexParameterIivEXT
#define glGetMultiTexParameterIivEXT(texunit, target, pname, params) glatter_glGetMultiTexParameterIivEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexParameterIivEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetMultiTexParameterIuivEXT
#define glGetMultiTexParameterIuivEXT(texunit, target, pname, params) glatter_glGetMultiTexParameterIuivEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexParameterIuivEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glGetMultiTexParameterfvEXT
#define glGetMultiTexParameterfvEXT(texunit, target, pname, params) glatter_glGetMultiTexParameterfvEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexParameterfvEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetMultiTexParameterivEXT
#define glGetMultiTexParameterivEXT(texunit, target, pname, params) glatter_glGetMultiTexParameterivEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexParameterivEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetNamedBufferParameterivEXT
#define glGetNamedBufferParameterivEXT(buffer, pname, params) glatter_glGetNamedBufferParameterivEXT_debug((buffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferParameterivEXT_debug(GLuint buffer, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetNamedBufferPointervEXT
#define glGetNamedBufferPointervEXT(buffer, pname, params) glatter_glGetNamedBufferPointervEXT_debug((buffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferPointervEXT_debug(GLuint buffer, GLenum pname, void **params, const char* file, int line);
#ifndef glGetNamedBufferSubDataEXT
#define glGetNamedBufferSubDataEXT(buffer, offset, size, data) glatter_glGetNamedBufferSubDataEXT_debug((buffer), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferSubDataEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, void *data, const char* file, int line);
#ifndef glGetNamedFramebufferAttachmentParameterivEXT
#define glGetNamedFramebufferAttachmentParameterivEXT(framebuffer, attachment, pname, params) glatter_glGetNamedFramebufferAttachmentParameterivEXT_debug((framebuffer), (attachment), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedFramebufferAttachmentParameterivEXT_debug(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetNamedFramebufferParameterivEXT
#define glGetNamedFramebufferParameterivEXT(framebuffer, pname, params) glatter_glGetNamedFramebufferParameterivEXT_debug((framebuffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedFramebufferParameterivEXT_debug(GLuint framebuffer, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetNamedProgramLocalParameterIivEXT
#define glGetNamedProgramLocalParameterIivEXT(program, target, index, params) glatter_glGetNamedProgramLocalParameterIivEXT_debug((program), (target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramLocalParameterIivEXT_debug(GLuint program, GLenum target, GLuint index, GLint *params, const char* file, int line);
#ifndef glGetNamedProgramLocalParameterIuivEXT
#define glGetNamedProgramLocalParameterIuivEXT(program, target, index, params) glatter_glGetNamedProgramLocalParameterIuivEXT_debug((program), (target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramLocalParameterIuivEXT_debug(GLuint program, GLenum target, GLuint index, GLuint *params, const char* file, int line);
#ifndef glGetNamedProgramLocalParameterdvEXT
#define glGetNamedProgramLocalParameterdvEXT(program, target, index, params) glatter_glGetNamedProgramLocalParameterdvEXT_debug((program), (target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramLocalParameterdvEXT_debug(GLuint program, GLenum target, GLuint index, GLdouble *params, const char* file, int line);
#ifndef glGetNamedProgramLocalParameterfvEXT
#define glGetNamedProgramLocalParameterfvEXT(program, target, index, params) glatter_glGetNamedProgramLocalParameterfvEXT_debug((program), (target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramLocalParameterfvEXT_debug(GLuint program, GLenum target, GLuint index, GLfloat *params, const char* file, int line);
#ifndef glGetNamedProgramStringEXT
#define glGetNamedProgramStringEXT(program, target, pname, string) glatter_glGetNamedProgramStringEXT_debug((program), (target), (pname), (string), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramStringEXT_debug(GLuint program, GLenum target, GLenum pname, void *string, const char* file, int line);
#ifndef glGetNamedProgramivEXT
#define glGetNamedProgramivEXT(program, target, pname, params) glatter_glGetNamedProgramivEXT_debug((program), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramivEXT_debug(GLuint program, GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetNamedRenderbufferParameterivEXT
#define glGetNamedRenderbufferParameterivEXT(renderbuffer, pname, params) glatter_glGetNamedRenderbufferParameterivEXT_debug((renderbuffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedRenderbufferParameterivEXT_debug(GLuint renderbuffer, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetPointerIndexedvEXT
#define glGetPointerIndexedvEXT(target, index, data) glatter_glGetPointerIndexedvEXT_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPointerIndexedvEXT_debug(GLenum target, GLuint index, void **data, const char* file, int line);
#ifndef glGetPointeri_vEXT
#define glGetPointeri_vEXT(pname, index, params) glatter_glGetPointeri_vEXT_debug((pname), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPointeri_vEXT_debug(GLenum pname, GLuint index, void **params, const char* file, int line);
#ifndef glGetTextureImageEXT
#define glGetTextureImageEXT(texture, target, level, format, type, pixels) glatter_glGetTextureImageEXT_debug((texture), (target), (level), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureImageEXT_debug(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, void *pixels, const char* file, int line);
#ifndef glGetTextureLevelParameterfvEXT
#define glGetTextureLevelParameterfvEXT(texture, target, level, pname, params) glatter_glGetTextureLevelParameterfvEXT_debug((texture), (target), (level), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureLevelParameterfvEXT_debug(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetTextureLevelParameterivEXT
#define glGetTextureLevelParameterivEXT(texture, target, level, pname, params) glatter_glGetTextureLevelParameterivEXT_debug((texture), (target), (level), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureLevelParameterivEXT_debug(GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTextureParameterIivEXT
#define glGetTextureParameterIivEXT(texture, target, pname, params) glatter_glGetTextureParameterIivEXT_debug((texture), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterIivEXT_debug(GLuint texture, GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTextureParameterIuivEXT
#define glGetTextureParameterIuivEXT(texture, target, pname, params) glatter_glGetTextureParameterIuivEXT_debug((texture), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterIuivEXT_debug(GLuint texture, GLenum target, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glGetTextureParameterfvEXT
#define glGetTextureParameterfvEXT(texture, target, pname, params) glatter_glGetTextureParameterfvEXT_debug((texture), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterfvEXT_debug(GLuint texture, GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetTextureParameterivEXT
#define glGetTextureParameterivEXT(texture, target, pname, params) glatter_glGetTextureParameterivEXT_debug((texture), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterivEXT_debug(GLuint texture, GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetVertexArrayIntegeri_vEXT
#define glGetVertexArrayIntegeri_vEXT(vaobj, index, pname, param) glatter_glGetVertexArrayIntegeri_vEXT_debug((vaobj), (index), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayIntegeri_vEXT_debug(GLuint vaobj, GLuint index, GLenum pname, GLint *param, const char* file, int line);
#ifndef glGetVertexArrayIntegervEXT
#define glGetVertexArrayIntegervEXT(vaobj, pname, param) glatter_glGetVertexArrayIntegervEXT_debug((vaobj), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayIntegervEXT_debug(GLuint vaobj, GLenum pname, GLint *param, const char* file, int line);
#ifndef glGetVertexArrayPointeri_vEXT
#define glGetVertexArrayPointeri_vEXT(vaobj, index, pname, param) glatter_glGetVertexArrayPointeri_vEXT_debug((vaobj), (index), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayPointeri_vEXT_debug(GLuint vaobj, GLuint index, GLenum pname, void **param, const char* file, int line);
#ifndef glGetVertexArrayPointervEXT
#define glGetVertexArrayPointervEXT(vaobj, pname, param) glatter_glGetVertexArrayPointervEXT_debug((vaobj), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayPointervEXT_debug(GLuint vaobj, GLenum pname, void **param, const char* file, int line);
#ifndef glIsEnabledIndexedEXT
#define glIsEnabledIndexedEXT(target, index) glatter_glIsEnabledIndexedEXT_debug((target), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnabledIndexedEXT_debug(GLenum target, GLuint index, const char* file, int line);
#ifndef glMapNamedBufferEXT
#define glMapNamedBufferEXT(buffer, access) glatter_glMapNamedBufferEXT_debug((buffer), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void * glatter_glMapNamedBufferEXT_debug(GLuint buffer, GLenum access, const char* file, int line);
#ifndef glMapNamedBufferRangeEXT
#define glMapNamedBufferRangeEXT(buffer, offset, length, access) glatter_glMapNamedBufferRangeEXT_debug((buffer), (offset), (length), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void * glatter_glMapNamedBufferRangeEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access, const char* file, int line);
#ifndef glMatrixFrustumEXT
#define glMatrixFrustumEXT(mode, left, right, bottom, top, zNear, zFar) glatter_glMatrixFrustumEXT_debug((mode), (left), (right), (bottom), (top), (zNear), (zFar), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixFrustumEXT_debug(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line);
#ifndef glMatrixLoadIdentityEXT
#define glMatrixLoadIdentityEXT(mode) glatter_glMatrixLoadIdentityEXT_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadIdentityEXT_debug(GLenum mode, const char* file, int line);
#ifndef glMatrixLoadTransposedEXT
#define glMatrixLoadTransposedEXT(mode, m) glatter_glMatrixLoadTransposedEXT_debug((mode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadTransposedEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line);
#ifndef glMatrixLoadTransposefEXT
#define glMatrixLoadTransposefEXT(mode, m) glatter_glMatrixLoadTransposefEXT_debug((mode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadTransposefEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line);
#ifndef glMatrixLoaddEXT
#define glMatrixLoaddEXT(mode, m) glatter_glMatrixLoaddEXT_debug((mode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoaddEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line);
#ifndef glMatrixLoadfEXT
#define glMatrixLoadfEXT(mode, m) glatter_glMatrixLoadfEXT_debug((mode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadfEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line);
#ifndef glMatrixMultTransposedEXT
#define glMatrixMultTransposedEXT(mode, m) glatter_glMatrixMultTransposedEXT_debug((mode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultTransposedEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line);
#ifndef glMatrixMultTransposefEXT
#define glMatrixMultTransposefEXT(mode, m) glatter_glMatrixMultTransposefEXT_debug((mode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultTransposefEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line);
#ifndef glMatrixMultdEXT
#define glMatrixMultdEXT(mode, m) glatter_glMatrixMultdEXT_debug((mode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultdEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line);
#ifndef glMatrixMultfEXT
#define glMatrixMultfEXT(mode, m) glatter_glMatrixMultfEXT_debug((mode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultfEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line);
#ifndef glMatrixOrthoEXT
#define glMatrixOrthoEXT(mode, left, right, bottom, top, zNear, zFar) glatter_glMatrixOrthoEXT_debug((mode), (left), (right), (bottom), (top), (zNear), (zFar), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixOrthoEXT_debug(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line);
#ifndef glMatrixPopEXT
#define glMatrixPopEXT(mode) glatter_glMatrixPopEXT_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixPopEXT_debug(GLenum mode, const char* file, int line);
#ifndef glMatrixPushEXT
#define glMatrixPushEXT(mode) glatter_glMatrixPushEXT_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixPushEXT_debug(GLenum mode, const char* file, int line);
#ifndef glMatrixRotatedEXT
#define glMatrixRotatedEXT(mode, angle, x, y, z) glatter_glMatrixRotatedEXT_debug((mode), (angle), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixRotatedEXT_debug(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glMatrixRotatefEXT
#define glMatrixRotatefEXT(mode, angle, x, y, z) glatter_glMatrixRotatefEXT_debug((mode), (angle), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixRotatefEXT_debug(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glMatrixScaledEXT
#define glMatrixScaledEXT(mode, x, y, z) glatter_glMatrixScaledEXT_debug((mode), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixScaledEXT_debug(GLenum mode, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glMatrixScalefEXT
#define glMatrixScalefEXT(mode, x, y, z) glatter_glMatrixScalefEXT_debug((mode), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixScalefEXT_debug(GLenum mode, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glMatrixTranslatedEXT
#define glMatrixTranslatedEXT(mode, x, y, z) glatter_glMatrixTranslatedEXT_debug((mode), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixTranslatedEXT_debug(GLenum mode, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glMatrixTranslatefEXT
#define glMatrixTranslatefEXT(mode, x, y, z) glatter_glMatrixTranslatefEXT_debug((mode), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixTranslatefEXT_debug(GLenum mode, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glMultiTexBufferEXT
#define glMultiTexBufferEXT(texunit, target, internalformat, buffer) glatter_glMultiTexBufferEXT_debug((texunit), (target), (internalformat), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexBufferEXT_debug(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line);
#ifndef glMultiTexCoordPointerEXT
#define glMultiTexCoordPointerEXT(texunit, size, type, stride, pointer) glatter_glMultiTexCoordPointerEXT_debug((texunit), (size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordPointerEXT_debug(GLenum texunit, GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glMultiTexEnvfEXT
#define glMultiTexEnvfEXT(texunit, target, pname, param) glatter_glMultiTexEnvfEXT_debug((texunit), (target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexEnvfEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glMultiTexEnvfvEXT
#define glMultiTexEnvfvEXT(texunit, target, pname, params) glatter_glMultiTexEnvfvEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexEnvfvEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glMultiTexEnviEXT
#define glMultiTexEnviEXT(texunit, target, pname, param) glatter_glMultiTexEnviEXT_debug((texunit), (target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexEnviEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint param, const char* file, int line);
#ifndef glMultiTexEnvivEXT
#define glMultiTexEnvivEXT(texunit, target, pname, params) glatter_glMultiTexEnvivEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexEnvivEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glMultiTexGendEXT
#define glMultiTexGendEXT(texunit, coord, pname, param) glatter_glMultiTexGendEXT_debug((texunit), (coord), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGendEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLdouble param, const char* file, int line);
#ifndef glMultiTexGendvEXT
#define glMultiTexGendvEXT(texunit, coord, pname, params) glatter_glMultiTexGendvEXT_debug((texunit), (coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGendvEXT_debug(GLenum texunit, GLenum coord, GLenum pname, const GLdouble *params, const char* file, int line);
#ifndef glMultiTexGenfEXT
#define glMultiTexGenfEXT(texunit, coord, pname, param) glatter_glMultiTexGenfEXT_debug((texunit), (coord), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGenfEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glMultiTexGenfvEXT
#define glMultiTexGenfvEXT(texunit, coord, pname, params) glatter_glMultiTexGenfvEXT_debug((texunit), (coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGenfvEXT_debug(GLenum texunit, GLenum coord, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glMultiTexGeniEXT
#define glMultiTexGeniEXT(texunit, coord, pname, param) glatter_glMultiTexGeniEXT_debug((texunit), (coord), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGeniEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLint param, const char* file, int line);
#ifndef glMultiTexGenivEXT
#define glMultiTexGenivEXT(texunit, coord, pname, params) glatter_glMultiTexGenivEXT_debug((texunit), (coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGenivEXT_debug(GLenum texunit, GLenum coord, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glMultiTexImage1DEXT
#define glMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, pixels) glatter_glMultiTexImage1DEXT_debug((texunit), (target), (level), (internalformat), (width), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glMultiTexImage2DEXT
#define glMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, pixels) glatter_glMultiTexImage2DEXT_debug((texunit), (target), (level), (internalformat), (width), (height), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glMultiTexImage3DEXT
#define glMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, pixels) glatter_glMultiTexImage3DEXT_debug((texunit), (target), (level), (internalformat), (width), (height), (depth), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glMultiTexParameterIivEXT
#define glMultiTexParameterIivEXT(texunit, target, pname, params) glatter_glMultiTexParameterIivEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterIivEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glMultiTexParameterIuivEXT
#define glMultiTexParameterIuivEXT(texunit, target, pname, params) glatter_glMultiTexParameterIuivEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterIuivEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLuint *params, const char* file, int line);
#ifndef glMultiTexParameterfEXT
#define glMultiTexParameterfEXT(texunit, target, pname, param) glatter_glMultiTexParameterfEXT_debug((texunit), (target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterfEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glMultiTexParameterfvEXT
#define glMultiTexParameterfvEXT(texunit, target, pname, params) glatter_glMultiTexParameterfvEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterfvEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glMultiTexParameteriEXT
#define glMultiTexParameteriEXT(texunit, target, pname, param) glatter_glMultiTexParameteriEXT_debug((texunit), (target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameteriEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint param, const char* file, int line);
#ifndef glMultiTexParameterivEXT
#define glMultiTexParameterivEXT(texunit, target, pname, params) glatter_glMultiTexParameterivEXT_debug((texunit), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterivEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glMultiTexRenderbufferEXT
#define glMultiTexRenderbufferEXT(texunit, target, renderbuffer) glatter_glMultiTexRenderbufferEXT_debug((texunit), (target), (renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexRenderbufferEXT_debug(GLenum texunit, GLenum target, GLuint renderbuffer, const char* file, int line);
#ifndef glMultiTexSubImage1DEXT
#define glMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, pixels) glatter_glMultiTexSubImage1DEXT_debug((texunit), (target), (level), (xoffset), (width), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexSubImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glMultiTexSubImage2DEXT
#define glMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, pixels) glatter_glMultiTexSubImage2DEXT_debug((texunit), (target), (level), (xoffset), (yoffset), (width), (height), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexSubImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glMultiTexSubImage3DEXT
#define glMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels) glatter_glMultiTexSubImage3DEXT_debug((texunit), (target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexSubImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glNamedBufferDataEXT
#define glNamedBufferDataEXT(buffer, size, data, usage) glatter_glNamedBufferDataEXT_debug((buffer), (size), (data), (usage), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferDataEXT_debug(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage, const char* file, int line);
#ifndef glNamedBufferStorageEXT
#define glNamedBufferStorageEXT(buffer, size, data, flags) glatter_glNamedBufferStorageEXT_debug((buffer), (size), (data), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferStorageEXT_debug(GLuint buffer, GLsizeiptr size, const void *data, GLbitfield flags, const char* file, int line);
#ifndef glNamedBufferSubDataEXT
#define glNamedBufferSubDataEXT(buffer, offset, size, data) glatter_glNamedBufferSubDataEXT_debug((buffer), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferSubDataEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line);
#ifndef glNamedCopyBufferSubDataEXT
#define glNamedCopyBufferSubDataEXT(readBuffer, writeBuffer, readOffset, writeOffset, size) glatter_glNamedCopyBufferSubDataEXT_debug((readBuffer), (writeBuffer), (readOffset), (writeOffset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedCopyBufferSubDataEXT_debug(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size, const char* file, int line);
#ifndef glNamedFramebufferParameteriEXT
#define glNamedFramebufferParameteriEXT(framebuffer, pname, param) glatter_glNamedFramebufferParameteriEXT_debug((framebuffer), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferParameteriEXT_debug(GLuint framebuffer, GLenum pname, GLint param, const char* file, int line);
#ifndef glNamedFramebufferRenderbufferEXT
#define glNamedFramebufferRenderbufferEXT(framebuffer, attachment, renderbuffertarget, renderbuffer) glatter_glNamedFramebufferRenderbufferEXT_debug((framebuffer), (attachment), (renderbuffertarget), (renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferRenderbufferEXT_debug(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer, const char* file, int line);
#ifndef glNamedFramebufferTexture1DEXT
#define glNamedFramebufferTexture1DEXT(framebuffer, attachment, textarget, texture, level) glatter_glNamedFramebufferTexture1DEXT_debug((framebuffer), (attachment), (textarget), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTexture1DEXT_debug(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line);
#ifndef glNamedFramebufferTexture2DEXT
#define glNamedFramebufferTexture2DEXT(framebuffer, attachment, textarget, texture, level) glatter_glNamedFramebufferTexture2DEXT_debug((framebuffer), (attachment), (textarget), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTexture2DEXT_debug(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line);
#ifndef glNamedFramebufferTexture3DEXT
#define glNamedFramebufferTexture3DEXT(framebuffer, attachment, textarget, texture, level, zoffset) glatter_glNamedFramebufferTexture3DEXT_debug((framebuffer), (attachment), (textarget), (texture), (level), (zoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTexture3DEXT_debug(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset, const char* file, int line);
#ifndef glNamedFramebufferTextureEXT
#define glNamedFramebufferTextureEXT(framebuffer, attachment, texture, level) glatter_glNamedFramebufferTextureEXT_debug((framebuffer), (attachment), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTextureEXT_debug(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, const char* file, int line);
#ifndef glNamedFramebufferTextureFaceEXT
#define glNamedFramebufferTextureFaceEXT(framebuffer, attachment, texture, level, face) glatter_glNamedFramebufferTextureFaceEXT_debug((framebuffer), (attachment), (texture), (level), (face), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTextureFaceEXT_debug(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face, const char* file, int line);
#ifndef glNamedFramebufferTextureLayerEXT
#define glNamedFramebufferTextureLayerEXT(framebuffer, attachment, texture, level, layer) glatter_glNamedFramebufferTextureLayerEXT_debug((framebuffer), (attachment), (texture), (level), (layer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTextureLayerEXT_debug(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer, const char* file, int line);
#ifndef glNamedProgramLocalParameter4dEXT
#define glNamedProgramLocalParameter4dEXT(program, target, index, x, y, z, w) glatter_glNamedProgramLocalParameter4dEXT_debug((program), (target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameter4dEXT_debug(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glNamedProgramLocalParameter4dvEXT
#define glNamedProgramLocalParameter4dvEXT(program, target, index, params) glatter_glNamedProgramLocalParameter4dvEXT_debug((program), (target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameter4dvEXT_debug(GLuint program, GLenum target, GLuint index, const GLdouble *params, const char* file, int line);
#ifndef glNamedProgramLocalParameter4fEXT
#define glNamedProgramLocalParameter4fEXT(program, target, index, x, y, z, w) glatter_glNamedProgramLocalParameter4fEXT_debug((program), (target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameter4fEXT_debug(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glNamedProgramLocalParameter4fvEXT
#define glNamedProgramLocalParameter4fvEXT(program, target, index, params) glatter_glNamedProgramLocalParameter4fvEXT_debug((program), (target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameter4fvEXT_debug(GLuint program, GLenum target, GLuint index, const GLfloat *params, const char* file, int line);
#ifndef glNamedProgramLocalParameterI4iEXT
#define glNamedProgramLocalParameterI4iEXT(program, target, index, x, y, z, w) glatter_glNamedProgramLocalParameterI4iEXT_debug((program), (target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameterI4iEXT_debug(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w, const char* file, int line);
#ifndef glNamedProgramLocalParameterI4ivEXT
#define glNamedProgramLocalParameterI4ivEXT(program, target, index, params) glatter_glNamedProgramLocalParameterI4ivEXT_debug((program), (target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameterI4ivEXT_debug(GLuint program, GLenum target, GLuint index, const GLint *params, const char* file, int line);
#ifndef glNamedProgramLocalParameterI4uiEXT
#define glNamedProgramLocalParameterI4uiEXT(program, target, index, x, y, z, w) glatter_glNamedProgramLocalParameterI4uiEXT_debug((program), (target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameterI4uiEXT_debug(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w, const char* file, int line);
#ifndef glNamedProgramLocalParameterI4uivEXT
#define glNamedProgramLocalParameterI4uivEXT(program, target, index, params) glatter_glNamedProgramLocalParameterI4uivEXT_debug((program), (target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameterI4uivEXT_debug(GLuint program, GLenum target, GLuint index, const GLuint *params, const char* file, int line);
#ifndef glNamedProgramLocalParameters4fvEXT
#define glNamedProgramLocalParameters4fvEXT(program, target, index, count, params) glatter_glNamedProgramLocalParameters4fvEXT_debug((program), (target), (index), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameters4fvEXT_debug(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat *params, const char* file, int line);
#ifndef glNamedProgramLocalParametersI4ivEXT
#define glNamedProgramLocalParametersI4ivEXT(program, target, index, count, params) glatter_glNamedProgramLocalParametersI4ivEXT_debug((program), (target), (index), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParametersI4ivEXT_debug(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint *params, const char* file, int line);
#ifndef glNamedProgramLocalParametersI4uivEXT
#define glNamedProgramLocalParametersI4uivEXT(program, target, index, count, params) glatter_glNamedProgramLocalParametersI4uivEXT_debug((program), (target), (index), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParametersI4uivEXT_debug(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint *params, const char* file, int line);
#ifndef glNamedProgramStringEXT
#define glNamedProgramStringEXT(program, target, format, len, string) glatter_glNamedProgramStringEXT_debug((program), (target), (format), (len), (string), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramStringEXT_debug(GLuint program, GLenum target, GLenum format, GLsizei len, const void *string, const char* file, int line);
#ifndef glNamedRenderbufferStorageEXT
#define glNamedRenderbufferStorageEXT(renderbuffer, internalformat, width, height) glatter_glNamedRenderbufferStorageEXT_debug((renderbuffer), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageEXT_debug(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glNamedRenderbufferStorageMultisampleCoverageEXT
#define glNamedRenderbufferStorageMultisampleCoverageEXT(renderbuffer, coverageSamples, colorSamples, internalformat, width, height) glatter_glNamedRenderbufferStorageMultisampleCoverageEXT_debug((renderbuffer), (coverageSamples), (colorSamples), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageMultisampleCoverageEXT_debug(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glNamedRenderbufferStorageMultisampleEXT
#define glNamedRenderbufferStorageMultisampleEXT(renderbuffer, samples, internalformat, width, height) glatter_glNamedRenderbufferStorageMultisampleEXT_debug((renderbuffer), (samples), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageMultisampleEXT_debug(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glProgramUniform1dEXT
#define glProgramUniform1dEXT(program, location, x) glatter_glProgramUniform1dEXT_debug((program), (location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1dEXT_debug(GLuint program, GLint location, GLdouble x, const char* file, int line);
#ifndef glProgramUniform1dvEXT
#define glProgramUniform1dvEXT(program, location, count, value) glatter_glProgramUniform1dvEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1dvEXT_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniform1fEXT
#define glProgramUniform1fEXT(program, location, v0) glatter_glProgramUniform1fEXT_debug((program), (location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1fEXT_debug(GLuint program, GLint location, GLfloat v0, const char* file, int line);
#ifndef glProgramUniform1fvEXT
#define glProgramUniform1fvEXT(program, location, count, value) glatter_glProgramUniform1fvEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniform1iEXT
#define glProgramUniform1iEXT(program, location, v0) glatter_glProgramUniform1iEXT_debug((program), (location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1iEXT_debug(GLuint program, GLint location, GLint v0, const char* file, int line);
#ifndef glProgramUniform1ivEXT
#define glProgramUniform1ivEXT(program, location, count, value) glatter_glProgramUniform1ivEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glProgramUniform1uiEXT
#define glProgramUniform1uiEXT(program, location, v0) glatter_glProgramUniform1uiEXT_debug((program), (location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1uiEXT_debug(GLuint program, GLint location, GLuint v0, const char* file, int line);
#ifndef glProgramUniform1uivEXT
#define glProgramUniform1uivEXT(program, location, count, value) glatter_glProgramUniform1uivEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glProgramUniform2dEXT
#define glProgramUniform2dEXT(program, location, x, y) glatter_glProgramUniform2dEXT_debug((program), (location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2dEXT_debug(GLuint program, GLint location, GLdouble x, GLdouble y, const char* file, int line);
#ifndef glProgramUniform2dvEXT
#define glProgramUniform2dvEXT(program, location, count, value) glatter_glProgramUniform2dvEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2dvEXT_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniform2fEXT
#define glProgramUniform2fEXT(program, location, v0, v1) glatter_glProgramUniform2fEXT_debug((program), (location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2fEXT_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, const char* file, int line);
#ifndef glProgramUniform2fvEXT
#define glProgramUniform2fvEXT(program, location, count, value) glatter_glProgramUniform2fvEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniform2iEXT
#define glProgramUniform2iEXT(program, location, v0, v1) glatter_glProgramUniform2iEXT_debug((program), (location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2iEXT_debug(GLuint program, GLint location, GLint v0, GLint v1, const char* file, int line);
#ifndef glProgramUniform2ivEXT
#define glProgramUniform2ivEXT(program, location, count, value) glatter_glProgramUniform2ivEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glProgramUniform2uiEXT
#define glProgramUniform2uiEXT(program, location, v0, v1) glatter_glProgramUniform2uiEXT_debug((program), (location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2uiEXT_debug(GLuint program, GLint location, GLuint v0, GLuint v1, const char* file, int line);
#ifndef glProgramUniform2uivEXT
#define glProgramUniform2uivEXT(program, location, count, value) glatter_glProgramUniform2uivEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glProgramUniform3dEXT
#define glProgramUniform3dEXT(program, location, x, y, z) glatter_glProgramUniform3dEXT_debug((program), (location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3dEXT_debug(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glProgramUniform3dvEXT
#define glProgramUniform3dvEXT(program, location, count, value) glatter_glProgramUniform3dvEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3dvEXT_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniform3fEXT
#define glProgramUniform3fEXT(program, location, v0, v1, v2) glatter_glProgramUniform3fEXT_debug((program), (location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3fEXT_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, const char* file, int line);
#ifndef glProgramUniform3fvEXT
#define glProgramUniform3fvEXT(program, location, count, value) glatter_glProgramUniform3fvEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniform3iEXT
#define glProgramUniform3iEXT(program, location, v0, v1, v2) glatter_glProgramUniform3iEXT_debug((program), (location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3iEXT_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, const char* file, int line);
#ifndef glProgramUniform3ivEXT
#define glProgramUniform3ivEXT(program, location, count, value) glatter_glProgramUniform3ivEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glProgramUniform3uiEXT
#define glProgramUniform3uiEXT(program, location, v0, v1, v2) glatter_glProgramUniform3uiEXT_debug((program), (location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3uiEXT_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, const char* file, int line);
#ifndef glProgramUniform3uivEXT
#define glProgramUniform3uivEXT(program, location, count, value) glatter_glProgramUniform3uivEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glProgramUniform4dEXT
#define glProgramUniform4dEXT(program, location, x, y, z, w) glatter_glProgramUniform4dEXT_debug((program), (location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4dEXT_debug(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glProgramUniform4dvEXT
#define glProgramUniform4dvEXT(program, location, count, value) glatter_glProgramUniform4dvEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4dvEXT_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniform4fEXT
#define glProgramUniform4fEXT(program, location, v0, v1, v2, v3) glatter_glProgramUniform4fEXT_debug((program), (location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4fEXT_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3, const char* file, int line);
#ifndef glProgramUniform4fvEXT
#define glProgramUniform4fvEXT(program, location, count, value) glatter_glProgramUniform4fvEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniform4iEXT
#define glProgramUniform4iEXT(program, location, v0, v1, v2, v3) glatter_glProgramUniform4iEXT_debug((program), (location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4iEXT_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3, const char* file, int line);
#ifndef glProgramUniform4ivEXT
#define glProgramUniform4ivEXT(program, location, count, value) glatter_glProgramUniform4ivEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glProgramUniform4uiEXT
#define glProgramUniform4uiEXT(program, location, v0, v1, v2, v3) glatter_glProgramUniform4uiEXT_debug((program), (location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4uiEXT_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3, const char* file, int line);
#ifndef glProgramUniform4uivEXT
#define glProgramUniform4uivEXT(program, location, count, value) glatter_glProgramUniform4uivEXT_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glProgramUniformMatrix2dvEXT
#define glProgramUniformMatrix2dvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix2dvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix2fvEXT
#define glProgramUniformMatrix2fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix2fvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix2x3dvEXT
#define glProgramUniformMatrix2x3dvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x3dvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x3dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix2x3fvEXT
#define glProgramUniformMatrix2x3fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x3fvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x3fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix2x4dvEXT
#define glProgramUniformMatrix2x4dvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x4dvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x4dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix2x4fvEXT
#define glProgramUniformMatrix2x4fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x4fvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x4fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix3dvEXT
#define glProgramUniformMatrix3dvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix3dvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix3fvEXT
#define glProgramUniformMatrix3fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix3fvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix3x2dvEXT
#define glProgramUniformMatrix3x2dvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x2dvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x2dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix3x2fvEXT
#define glProgramUniformMatrix3x2fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x2fvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x2fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix3x4dvEXT
#define glProgramUniformMatrix3x4dvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x4dvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x4dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix3x4fvEXT
#define glProgramUniformMatrix3x4fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x4fvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x4fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix4dvEXT
#define glProgramUniformMatrix4dvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix4dvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix4fvEXT
#define glProgramUniformMatrix4fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix4fvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix4x2dvEXT
#define glProgramUniformMatrix4x2dvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x2dvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x2dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix4x2fvEXT
#define glProgramUniformMatrix4x2fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x2fvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x2fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix4x3dvEXT
#define glProgramUniformMatrix4x3dvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x3dvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x3dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix4x3fvEXT
#define glProgramUniformMatrix4x3fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x3fvEXT_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x3fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glPushClientAttribDefaultEXT
#define glPushClientAttribDefaultEXT(mask) glatter_glPushClientAttribDefaultEXT_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPushClientAttribDefaultEXT_debug(GLbitfield mask, const char* file, int line);
#ifndef glTextureBufferEXT
#define glTextureBufferEXT(texture, target, internalformat, buffer) glatter_glTextureBufferEXT_debug((texture), (target), (internalformat), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureBufferEXT_debug(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line);
#ifndef glTextureBufferRangeEXT
#define glTextureBufferRangeEXT(texture, target, internalformat, buffer, offset, size) glatter_glTextureBufferRangeEXT_debug((texture), (target), (internalformat), (buffer), (offset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureBufferRangeEXT_debug(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line);
#ifndef glTextureImage1DEXT
#define glTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, pixels) glatter_glTextureImage1DEXT_debug((texture), (target), (level), (internalformat), (width), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTextureImage2DEXT
#define glTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, pixels) glatter_glTextureImage2DEXT_debug((texture), (target), (level), (internalformat), (width), (height), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTextureImage3DEXT
#define glTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, pixels) glatter_glTextureImage3DEXT_debug((texture), (target), (level), (internalformat), (width), (height), (depth), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTexturePageCommitmentEXT
#define glTexturePageCommitmentEXT(texture, level, xoffset, yoffset, zoffset, width, height, depth, commit) glatter_glTexturePageCommitmentEXT_debug((texture), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (commit), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexturePageCommitmentEXT_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit, const char* file, int line);
#ifndef glTextureParameterIivEXT
#define glTextureParameterIivEXT(texture, target, pname, params) glatter_glTextureParameterIivEXT_debug((texture), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterIivEXT_debug(GLuint texture, GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glTextureParameterIuivEXT
#define glTextureParameterIuivEXT(texture, target, pname, params) glatter_glTextureParameterIuivEXT_debug((texture), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterIuivEXT_debug(GLuint texture, GLenum target, GLenum pname, const GLuint *params, const char* file, int line);
#ifndef glTextureParameterfEXT
#define glTextureParameterfEXT(texture, target, pname, param) glatter_glTextureParameterfEXT_debug((texture), (target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterfEXT_debug(GLuint texture, GLenum target, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glTextureParameterfvEXT
#define glTextureParameterfvEXT(texture, target, pname, params) glatter_glTextureParameterfvEXT_debug((texture), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterfvEXT_debug(GLuint texture, GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glTextureParameteriEXT
#define glTextureParameteriEXT(texture, target, pname, param) glatter_glTextureParameteriEXT_debug((texture), (target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameteriEXT_debug(GLuint texture, GLenum target, GLenum pname, GLint param, const char* file, int line);
#ifndef glTextureParameterivEXT
#define glTextureParameterivEXT(texture, target, pname, params) glatter_glTextureParameterivEXT_debug((texture), (target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterivEXT_debug(GLuint texture, GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glTextureRenderbufferEXT
#define glTextureRenderbufferEXT(texture, target, renderbuffer) glatter_glTextureRenderbufferEXT_debug((texture), (target), (renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureRenderbufferEXT_debug(GLuint texture, GLenum target, GLuint renderbuffer, const char* file, int line);
#ifndef glTextureStorage1DEXT
#define glTextureStorage1DEXT(texture, target, levels, internalformat, width) glatter_glTextureStorage1DEXT_debug((texture), (target), (levels), (internalformat), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage1DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, const char* file, int line);
#ifndef glTextureStorage2DEXT
#define glTextureStorage2DEXT(texture, target, levels, internalformat, width, height) glatter_glTextureStorage2DEXT_debug((texture), (target), (levels), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage2DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glTextureStorage2DMultisampleEXT
#define glTextureStorage2DMultisampleEXT(texture, target, samples, internalformat, width, height, fixedsamplelocations) glatter_glTextureStorage2DMultisampleEXT_debug((texture), (target), (samples), (internalformat), (width), (height), (fixedsamplelocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage2DMultisampleEXT_debug(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations, const char* file, int line);
#ifndef glTextureStorage3DEXT
#define glTextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth) glatter_glTextureStorage3DEXT_debug((texture), (target), (levels), (internalformat), (width), (height), (depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage3DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line);
#ifndef glTextureStorage3DMultisampleEXT
#define glTextureStorage3DMultisampleEXT(texture, target, samples, internalformat, width, height, depth, fixedsamplelocations) glatter_glTextureStorage3DMultisampleEXT_debug((texture), (target), (samples), (internalformat), (width), (height), (depth), (fixedsamplelocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage3DMultisampleEXT_debug(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations, const char* file, int line);
#ifndef glTextureSubImage1DEXT
#define glTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, pixels) glatter_glTextureSubImage1DEXT_debug((texture), (target), (level), (xoffset), (width), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureSubImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTextureSubImage2DEXT
#define glTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, pixels) glatter_glTextureSubImage2DEXT_debug((texture), (target), (level), (xoffset), (yoffset), (width), (height), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureSubImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTextureSubImage3DEXT
#define glTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels) glatter_glTextureSubImage3DEXT_debug((texture), (target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureSubImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glUnmapNamedBufferEXT
#define glUnmapNamedBufferEXT(buffer) glatter_glUnmapNamedBufferEXT_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glUnmapNamedBufferEXT_debug(GLuint buffer, const char* file, int line);
#ifndef glVertexArrayBindVertexBufferEXT
#define glVertexArrayBindVertexBufferEXT(vaobj, bindingindex, buffer, offset, stride) glatter_glVertexArrayBindVertexBufferEXT_debug((vaobj), (bindingindex), (buffer), (offset), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayBindVertexBufferEXT_debug(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride, const char* file, int line);
#ifndef glVertexArrayColorOffsetEXT
#define glVertexArrayColorOffsetEXT(vaobj, buffer, size, type, stride, offset) glatter_glVertexArrayColorOffsetEXT_debug((vaobj), (buffer), (size), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayColorOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayEdgeFlagOffsetEXT
#define glVertexArrayEdgeFlagOffsetEXT(vaobj, buffer, stride, offset) glatter_glVertexArrayEdgeFlagOffsetEXT_debug((vaobj), (buffer), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayEdgeFlagOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayFogCoordOffsetEXT
#define glVertexArrayFogCoordOffsetEXT(vaobj, buffer, type, stride, offset) glatter_glVertexArrayFogCoordOffsetEXT_debug((vaobj), (buffer), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayFogCoordOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayIndexOffsetEXT
#define glVertexArrayIndexOffsetEXT(vaobj, buffer, type, stride, offset) glatter_glVertexArrayIndexOffsetEXT_debug((vaobj), (buffer), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayIndexOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayMultiTexCoordOffsetEXT
#define glVertexArrayMultiTexCoordOffsetEXT(vaobj, buffer, texunit, size, type, stride, offset) glatter_glVertexArrayMultiTexCoordOffsetEXT_debug((vaobj), (buffer), (texunit), (size), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayMultiTexCoordOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayNormalOffsetEXT
#define glVertexArrayNormalOffsetEXT(vaobj, buffer, type, stride, offset) glatter_glVertexArrayNormalOffsetEXT_debug((vaobj), (buffer), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayNormalOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArraySecondaryColorOffsetEXT
#define glVertexArraySecondaryColorOffsetEXT(vaobj, buffer, size, type, stride, offset) glatter_glVertexArraySecondaryColorOffsetEXT_debug((vaobj), (buffer), (size), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArraySecondaryColorOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayTexCoordOffsetEXT
#define glVertexArrayTexCoordOffsetEXT(vaobj, buffer, size, type, stride, offset) glatter_glVertexArrayTexCoordOffsetEXT_debug((vaobj), (buffer), (size), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayTexCoordOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayVertexAttribBindingEXT
#define glVertexArrayVertexAttribBindingEXT(vaobj, attribindex, bindingindex) glatter_glVertexArrayVertexAttribBindingEXT_debug((vaobj), (attribindex), (bindingindex), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribBindingEXT_debug(GLuint vaobj, GLuint attribindex, GLuint bindingindex, const char* file, int line);
#ifndef glVertexArrayVertexAttribDivisorEXT
#define glVertexArrayVertexAttribDivisorEXT(vaobj, index, divisor) glatter_glVertexArrayVertexAttribDivisorEXT_debug((vaobj), (index), (divisor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribDivisorEXT_debug(GLuint vaobj, GLuint index, GLuint divisor, const char* file, int line);
#ifndef glVertexArrayVertexAttribFormatEXT
#define glVertexArrayVertexAttribFormatEXT(vaobj, attribindex, size, type, normalized, relativeoffset) glatter_glVertexArrayVertexAttribFormatEXT_debug((vaobj), (attribindex), (size), (type), (normalized), (relativeoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribFormatEXT_debug(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset, const char* file, int line);
#ifndef glVertexArrayVertexAttribIFormatEXT
#define glVertexArrayVertexAttribIFormatEXT(vaobj, attribindex, size, type, relativeoffset) glatter_glVertexArrayVertexAttribIFormatEXT_debug((vaobj), (attribindex), (size), (type), (relativeoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribIFormatEXT_debug(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset, const char* file, int line);
#ifndef glVertexArrayVertexAttribIOffsetEXT
#define glVertexArrayVertexAttribIOffsetEXT(vaobj, buffer, index, size, type, stride, offset) glatter_glVertexArrayVertexAttribIOffsetEXT_debug((vaobj), (buffer), (index), (size), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribIOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayVertexAttribLFormatEXT
#define glVertexArrayVertexAttribLFormatEXT(vaobj, attribindex, size, type, relativeoffset) glatter_glVertexArrayVertexAttribLFormatEXT_debug((vaobj), (attribindex), (size), (type), (relativeoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribLFormatEXT_debug(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset, const char* file, int line);
#ifndef glVertexArrayVertexAttribLOffsetEXT
#define glVertexArrayVertexAttribLOffsetEXT(vaobj, buffer, index, size, type, stride, offset) glatter_glVertexArrayVertexAttribLOffsetEXT_debug((vaobj), (buffer), (index), (size), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribLOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayVertexAttribOffsetEXT
#define glVertexArrayVertexAttribOffsetEXT(vaobj, buffer, index, size, type, normalized, stride, offset) glatter_glVertexArrayVertexAttribOffsetEXT_debug((vaobj), (buffer), (index), (size), (type), (normalized), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLintptr offset, const char* file, int line);
#ifndef glVertexArrayVertexBindingDivisorEXT
#define glVertexArrayVertexBindingDivisorEXT(vaobj, bindingindex, divisor) glatter_glVertexArrayVertexBindingDivisorEXT_debug((vaobj), (bindingindex), (divisor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexBindingDivisorEXT_debug(GLuint vaobj, GLuint bindingindex, GLuint divisor, const char* file, int line);
#ifndef glVertexArrayVertexOffsetEXT
#define glVertexArrayVertexOffsetEXT(vaobj, buffer, size, type, stride, offset) glatter_glVertexArrayVertexOffsetEXT_debug((vaobj), (buffer), (size), (type), (stride), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line);
#endif // defined(GL_EXT_direct_state_access)
#if defined(GL_EXT_draw_buffers2)
#ifndef glColorMaskIndexedEXT
#define glColorMaskIndexedEXT(index, r, g, b, a) glatter_glColorMaskIndexedEXT_debug((index), (r), (g), (b), (a), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorMaskIndexedEXT_debug(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a, const char* file, int line);
#endif // defined(GL_EXT_draw_buffers2)
#if defined(GL_EXT_draw_instanced)
#ifndef glDrawArraysInstancedEXT
#define glDrawArraysInstancedEXT(mode, start, count, primcount) glatter_glDrawArraysInstancedEXT_debug((mode), (start), (count), (primcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstancedEXT_debug(GLenum mode, GLint start, GLsizei count, GLsizei primcount, const char* file, int line);
#ifndef glDrawElementsInstancedEXT
#define glDrawElementsInstancedEXT(mode, count, type, indices, primcount) glatter_glDrawElementsInstancedEXT_debug((mode), (count), (type), (indices), (primcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedEXT_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, const char* file, int line);
#endif // defined(GL_EXT_draw_instanced)
#if defined(GL_EXT_draw_range_elements)
#ifndef glDrawRangeElementsEXT
#define glDrawRangeElementsEXT(mode, start, end, count, type, indices) glatter_glDrawRangeElementsEXT_debug((mode), (start), (end), (count), (type), (indices), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementsEXT_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, const char* file, int line);
#endif // defined(GL_EXT_draw_range_elements)
#if defined(GL_EXT_external_buffer)
#ifndef glBufferStorageExternalEXT
#define glBufferStorageExternalEXT(target, offset, size, clientBuffer, flags) glatter_glBufferStorageExternalEXT_debug((target), (offset), (size), (clientBuffer), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferStorageExternalEXT_debug(GLenum target, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags, const char* file, int line);
#ifndef glNamedBufferStorageExternalEXT
#define glNamedBufferStorageExternalEXT(buffer, offset, size, clientBuffer, flags) glatter_glNamedBufferStorageExternalEXT_debug((buffer), (offset), (size), (clientBuffer), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferStorageExternalEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags, const char* file, int line);
#endif // defined(GL_EXT_external_buffer)
#if defined(GL_EXT_fog_coord)
#ifndef glFogCoordPointerEXT
#define glFogCoordPointerEXT(type, stride, pointer) glatter_glFogCoordPointerEXT_debug((type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordPointerEXT_debug(GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glFogCoorddEXT
#define glFogCoorddEXT(coord) glatter_glFogCoorddEXT_debug((coord), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoorddEXT_debug(GLdouble coord, const char* file, int line);
#ifndef glFogCoorddvEXT
#define glFogCoorddvEXT(coord) glatter_glFogCoorddvEXT_debug((coord), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoorddvEXT_debug(const GLdouble *coord, const char* file, int line);
#ifndef glFogCoordfEXT
#define glFogCoordfEXT(coord) glatter_glFogCoordfEXT_debug((coord), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordfEXT_debug(GLfloat coord, const char* file, int line);
#ifndef glFogCoordfvEXT
#define glFogCoordfvEXT(coord) glatter_glFogCoordfvEXT_debug((coord), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordfvEXT_debug(const GLfloat *coord, const char* file, int line);
#endif // defined(GL_EXT_fog_coord)
#if defined(GL_EXT_framebuffer_blit)
#ifndef glBlitFramebufferEXT
#define glBlitFramebufferEXT(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter) glatter_glBlitFramebufferEXT_debug((srcX0), (srcY0), (srcX1), (srcY1), (dstX0), (dstY0), (dstX1), (dstY1), (mask), (filter), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlitFramebufferEXT_debug(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter, const char* file, int line);
#endif // defined(GL_EXT_framebuffer_blit)
#if defined(GL_EXT_framebuffer_multisample)
#ifndef glRenderbufferStorageMultisampleEXT
#define glRenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height) glatter_glRenderbufferStorageMultisampleEXT_debug((target), (samples), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#endif // defined(GL_EXT_framebuffer_multisample)
#if defined(GL_EXT_framebuffer_object)
#ifndef glBindFramebufferEXT
#define glBindFramebufferEXT(target, framebuffer) glatter_glBindFramebufferEXT_debug((target), (framebuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindFramebufferEXT_debug(GLenum target, GLuint framebuffer, const char* file, int line);
#ifndef glBindRenderbufferEXT
#define glBindRenderbufferEXT(target, renderbuffer) glatter_glBindRenderbufferEXT_debug((target), (renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindRenderbufferEXT_debug(GLenum target, GLuint renderbuffer, const char* file, int line);
#ifndef glCheckFramebufferStatusEXT
#define glCheckFramebufferStatusEXT(target) glatter_glCheckFramebufferStatusEXT_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glCheckFramebufferStatusEXT_debug(GLenum target, const char* file, int line);
#ifndef glDeleteFramebuffersEXT
#define glDeleteFramebuffersEXT(n, framebuffers) glatter_glDeleteFramebuffersEXT_debug((n), (framebuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteFramebuffersEXT_debug(GLsizei n, const GLuint *framebuffers, const char* file, int line);
#ifndef glDeleteRenderbuffersEXT
#define glDeleteRenderbuffersEXT(n, renderbuffers) glatter_glDeleteRenderbuffersEXT_debug((n), (renderbuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteRenderbuffersEXT_debug(GLsizei n, const GLuint *renderbuffers, const char* file, int line);
#ifndef glFramebufferRenderbufferEXT
#define glFramebufferRenderbufferEXT(target, attachment, renderbuffertarget, renderbuffer) glatter_glFramebufferRenderbufferEXT_debug((target), (attachment), (renderbuffertarget), (renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferRenderbufferEXT_debug(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer, const char* file, int line);
#ifndef glFramebufferTexture1DEXT
#define glFramebufferTexture1DEXT(target, attachment, textarget, texture, level) glatter_glFramebufferTexture1DEXT_debug((target), (attachment), (textarget), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture1DEXT_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line);
#ifndef glFramebufferTexture2DEXT
#define glFramebufferTexture2DEXT(target, attachment, textarget, texture, level) glatter_glFramebufferTexture2DEXT_debug((target), (attachment), (textarget), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2DEXT_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line);
#ifndef glFramebufferTexture3DEXT
#define glFramebufferTexture3DEXT(target, attachment, textarget, texture, level, zoffset) glatter_glFramebufferTexture3DEXT_debug((target), (attachment), (textarget), (texture), (level), (zoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture3DEXT_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset, const char* file, int line);
#ifndef glGenFramebuffersEXT
#define glGenFramebuffersEXT(n, framebuffers) glatter_glGenFramebuffersEXT_debug((n), (framebuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenFramebuffersEXT_debug(GLsizei n, GLuint *framebuffers, const char* file, int line);
#ifndef glGenRenderbuffersEXT
#define glGenRenderbuffersEXT(n, renderbuffers) glatter_glGenRenderbuffersEXT_debug((n), (renderbuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenRenderbuffersEXT_debug(GLsizei n, GLuint *renderbuffers, const char* file, int line);
#ifndef glGenerateMipmapEXT
#define glGenerateMipmapEXT(target) glatter_glGenerateMipmapEXT_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenerateMipmapEXT_debug(GLenum target, const char* file, int line);
#ifndef glGetFramebufferAttachmentParameterivEXT
#define glGetFramebufferAttachmentParameterivEXT(target, attachment, pname, params) glatter_glGetFramebufferAttachmentParameterivEXT_debug((target), (attachment), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferAttachmentParameterivEXT_debug(GLenum target, GLenum attachment, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetRenderbufferParameterivEXT
#define glGetRenderbufferParameterivEXT(target, pname, params) glatter_glGetRenderbufferParameterivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetRenderbufferParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsFramebufferEXT
#define glIsFramebufferEXT(framebuffer) glatter_glIsFramebufferEXT_debug((framebuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFramebufferEXT_debug(GLuint framebuffer, const char* file, int line);
#ifndef glIsRenderbufferEXT
#define glIsRenderbufferEXT(renderbuffer) glatter_glIsRenderbufferEXT_debug((renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsRenderbufferEXT_debug(GLuint renderbuffer, const char* file, int line);
#ifndef glRenderbufferStorageEXT
#define glRenderbufferStorageEXT(target, internalformat, width, height) glatter_glRenderbufferStorageEXT_debug((target), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageEXT_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#endif // defined(GL_EXT_framebuffer_object)
#if defined(GL_EXT_geometry_shader4)
#ifndef glProgramParameteriEXT
#define glProgramParameteriEXT(program, pname, value) glatter_glProgramParameteriEXT_debug((program), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramParameteriEXT_debug(GLuint program, GLenum pname, GLint value, const char* file, int line);
#endif // defined(GL_EXT_geometry_shader4)
#if defined(GL_EXT_gpu_program_parameters)
#ifndef glProgramEnvParameters4fvEXT
#define glProgramEnvParameters4fvEXT(target, index, count, params) glatter_glProgramEnvParameters4fvEXT_debug((target), (index), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameters4fvEXT_debug(GLenum target, GLuint index, GLsizei count, const GLfloat *params, const char* file, int line);
#ifndef glProgramLocalParameters4fvEXT
#define glProgramLocalParameters4fvEXT(target, index, count, params) glatter_glProgramLocalParameters4fvEXT_debug((target), (index), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameters4fvEXT_debug(GLenum target, GLuint index, GLsizei count, const GLfloat *params, const char* file, int line);
#endif // defined(GL_EXT_gpu_program_parameters)
#if defined(GL_EXT_gpu_shader4)
#ifndef glBindFragDataLocationEXT
#define glBindFragDataLocationEXT(program, color, name) glatter_glBindFragDataLocationEXT_debug((program), (color), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindFragDataLocationEXT_debug(GLuint program, GLuint color, const GLchar *name, const char* file, int line);
#ifndef glGetFragDataLocationEXT
#define glGetFragDataLocationEXT(program, name) glatter_glGetFragDataLocationEXT_debug((program), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetFragDataLocationEXT_debug(GLuint program, const GLchar *name, const char* file, int line);
#ifndef glGetUniformuivEXT
#define glGetUniformuivEXT(program, location, params) glatter_glGetUniformuivEXT_debug((program), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformuivEXT_debug(GLuint program, GLint location, GLuint *params, const char* file, int line);
#ifndef glUniform1uiEXT
#define glUniform1uiEXT(location, v0) glatter_glUniform1uiEXT_debug((location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1uiEXT_debug(GLint location, GLuint v0, const char* file, int line);
#ifndef glUniform1uivEXT
#define glUniform1uivEXT(location, count, value) glatter_glUniform1uivEXT_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1uivEXT_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glUniform2uiEXT
#define glUniform2uiEXT(location, v0, v1) glatter_glUniform2uiEXT_debug((location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2uiEXT_debug(GLint location, GLuint v0, GLuint v1, const char* file, int line);
#ifndef glUniform2uivEXT
#define glUniform2uivEXT(location, count, value) glatter_glUniform2uivEXT_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2uivEXT_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glUniform3uiEXT
#define glUniform3uiEXT(location, v0, v1, v2) glatter_glUniform3uiEXT_debug((location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3uiEXT_debug(GLint location, GLuint v0, GLuint v1, GLuint v2, const char* file, int line);
#ifndef glUniform3uivEXT
#define glUniform3uivEXT(location, count, value) glatter_glUniform3uivEXT_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3uivEXT_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glUniform4uiEXT
#define glUniform4uiEXT(location, v0, v1, v2, v3) glatter_glUniform4uiEXT_debug((location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4uiEXT_debug(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3, const char* file, int line);
#ifndef glUniform4uivEXT
#define glUniform4uivEXT(location, count, value) glatter_glUniform4uivEXT_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4uivEXT_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#endif // defined(GL_EXT_gpu_shader4)
#if defined(GL_EXT_histogram)
#ifndef glGetHistogramEXT
#define glGetHistogramEXT(target, reset, format, type, values) glatter_glGetHistogramEXT_debug((target), (reset), (format), (type), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramEXT_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, void *values, const char* file, int line);
#ifndef glGetHistogramParameterfvEXT
#define glGetHistogramParameterfvEXT(target, pname, params) glatter_glGetHistogramParameterfvEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetHistogramParameterivEXT
#define glGetHistogramParameterivEXT(target, pname, params) glatter_glGetHistogramParameterivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetMinmaxEXT
#define glGetMinmaxEXT(target, reset, format, type, values) glatter_glGetMinmaxEXT_debug((target), (reset), (format), (type), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxEXT_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, void *values, const char* file, int line);
#ifndef glGetMinmaxParameterfvEXT
#define glGetMinmaxParameterfvEXT(target, pname, params) glatter_glGetMinmaxParameterfvEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetMinmaxParameterivEXT
#define glGetMinmaxParameterivEXT(target, pname, params) glatter_glGetMinmaxParameterivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glHistogramEXT
#define glHistogramEXT(target, width, internalformat, sink) glatter_glHistogramEXT_debug((target), (width), (internalformat), (sink), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glHistogramEXT_debug(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink, const char* file, int line);
#ifndef glMinmaxEXT
#define glMinmaxEXT(target, internalformat, sink) glatter_glMinmaxEXT_debug((target), (internalformat), (sink), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMinmaxEXT_debug(GLenum target, GLenum internalformat, GLboolean sink, const char* file, int line);
#ifndef glResetHistogramEXT
#define glResetHistogramEXT(target) glatter_glResetHistogramEXT_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glResetHistogramEXT_debug(GLenum target, const char* file, int line);
#ifndef glResetMinmaxEXT
#define glResetMinmaxEXT(target) glatter_glResetMinmaxEXT_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glResetMinmaxEXT_debug(GLenum target, const char* file, int line);
#endif // defined(GL_EXT_histogram)
#if defined(GL_EXT_index_func)
#ifndef glIndexFuncEXT
#define glIndexFuncEXT(func, ref) glatter_glIndexFuncEXT_debug((func), (ref), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexFuncEXT_debug(GLenum func, GLclampf ref, const char* file, int line);
#endif // defined(GL_EXT_index_func)
#if defined(GL_EXT_index_material)
#ifndef glIndexMaterialEXT
#define glIndexMaterialEXT(face, mode) glatter_glIndexMaterialEXT_debug((face), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexMaterialEXT_debug(GLenum face, GLenum mode, const char* file, int line);
#endif // defined(GL_EXT_index_material)
#if defined(GL_EXT_light_texture)
#ifndef glApplyTextureEXT
#define glApplyTextureEXT(mode) glatter_glApplyTextureEXT_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glApplyTextureEXT_debug(GLenum mode, const char* file, int line);
#ifndef glTextureLightEXT
#define glTextureLightEXT(pname) glatter_glTextureLightEXT_debug((pname), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureLightEXT_debug(GLenum pname, const char* file, int line);
#ifndef glTextureMaterialEXT
#define glTextureMaterialEXT(face, mode) glatter_glTextureMaterialEXT_debug((face), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureMaterialEXT_debug(GLenum face, GLenum mode, const char* file, int line);
#endif // defined(GL_EXT_light_texture)
#if defined(GL_EXT_memory_object)
#ifndef glBufferStorageMemEXT
#define glBufferStorageMemEXT(target, size, memory, offset) glatter_glBufferStorageMemEXT_debug((target), (size), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferStorageMemEXT_debug(GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glCreateMemoryObjectsEXT
#define glCreateMemoryObjectsEXT(n, memoryObjects) glatter_glCreateMemoryObjectsEXT_debug((n), (memoryObjects), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateMemoryObjectsEXT_debug(GLsizei n, GLuint *memoryObjects, const char* file, int line);
#ifndef glDeleteMemoryObjectsEXT
#define glDeleteMemoryObjectsEXT(n, memoryObjects) glatter_glDeleteMemoryObjectsEXT_debug((n), (memoryObjects), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteMemoryObjectsEXT_debug(GLsizei n, const GLuint *memoryObjects, const char* file, int line);
#ifndef glGetMemoryObjectParameterivEXT
#define glGetMemoryObjectParameterivEXT(memoryObject, pname, params) glatter_glGetMemoryObjectParameterivEXT_debug((memoryObject), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMemoryObjectParameterivEXT_debug(GLuint memoryObject, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetUnsignedBytei_vEXT
#define glGetUnsignedBytei_vEXT(target, index, data) glatter_glGetUnsignedBytei_vEXT_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUnsignedBytei_vEXT_debug(GLenum target, GLuint index, GLubyte *data, const char* file, int line);
#ifndef glGetUnsignedBytevEXT
#define glGetUnsignedBytevEXT(pname, data) glatter_glGetUnsignedBytevEXT_debug((pname), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUnsignedBytevEXT_debug(GLenum pname, GLubyte *data, const char* file, int line);
#ifndef glIsMemoryObjectEXT
#define glIsMemoryObjectEXT(memoryObject) glatter_glIsMemoryObjectEXT_debug((memoryObject), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsMemoryObjectEXT_debug(GLuint memoryObject, const char* file, int line);
#ifndef glMemoryObjectParameterivEXT
#define glMemoryObjectParameterivEXT(memoryObject, pname, params) glatter_glMemoryObjectParameterivEXT_debug((memoryObject), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMemoryObjectParameterivEXT_debug(GLuint memoryObject, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glNamedBufferStorageMemEXT
#define glNamedBufferStorageMemEXT(buffer, size, memory, offset) glatter_glNamedBufferStorageMemEXT_debug((buffer), (size), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferStorageMemEXT_debug(GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTexStorageMem1DEXT
#define glTexStorageMem1DEXT(target, levels, internalFormat, width, memory, offset) glatter_glTexStorageMem1DEXT_debug((target), (levels), (internalFormat), (width), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem1DEXT_debug(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTexStorageMem2DEXT
#define glTexStorageMem2DEXT(target, levels, internalFormat, width, height, memory, offset) glatter_glTexStorageMem2DEXT_debug((target), (levels), (internalFormat), (width), (height), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem2DEXT_debug(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTexStorageMem2DMultisampleEXT
#define glTexStorageMem2DMultisampleEXT(target, samples, internalFormat, width, height, fixedSampleLocations, memory, offset) glatter_glTexStorageMem2DMultisampleEXT_debug((target), (samples), (internalFormat), (width), (height), (fixedSampleLocations), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem2DMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTexStorageMem3DEXT
#define glTexStorageMem3DEXT(target, levels, internalFormat, width, height, depth, memory, offset) glatter_glTexStorageMem3DEXT_debug((target), (levels), (internalFormat), (width), (height), (depth), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem3DEXT_debug(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTexStorageMem3DMultisampleEXT
#define glTexStorageMem3DMultisampleEXT(target, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset) glatter_glTexStorageMem3DMultisampleEXT_debug((target), (samples), (internalFormat), (width), (height), (depth), (fixedSampleLocations), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem3DMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTextureStorageMem1DEXT
#define glTextureStorageMem1DEXT(texture, levels, internalFormat, width, memory, offset) glatter_glTextureStorageMem1DEXT_debug((texture), (levels), (internalFormat), (width), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem1DEXT_debug(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTextureStorageMem2DEXT
#define glTextureStorageMem2DEXT(texture, levels, internalFormat, width, height, memory, offset) glatter_glTextureStorageMem2DEXT_debug((texture), (levels), (internalFormat), (width), (height), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem2DEXT_debug(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTextureStorageMem2DMultisampleEXT
#define glTextureStorageMem2DMultisampleEXT(texture, samples, internalFormat, width, height, fixedSampleLocations, memory, offset) glatter_glTextureStorageMem2DMultisampleEXT_debug((texture), (samples), (internalFormat), (width), (height), (fixedSampleLocations), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem2DMultisampleEXT_debug(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTextureStorageMem3DEXT
#define glTextureStorageMem3DEXT(texture, levels, internalFormat, width, height, depth, memory, offset) glatter_glTextureStorageMem3DEXT_debug((texture), (levels), (internalFormat), (width), (height), (depth), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem3DEXT_debug(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset, const char* file, int line);
#ifndef glTextureStorageMem3DMultisampleEXT
#define glTextureStorageMem3DMultisampleEXT(texture, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset) glatter_glTextureStorageMem3DMultisampleEXT_debug((texture), (samples), (internalFormat), (width), (height), (depth), (fixedSampleLocations), (memory), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem3DMultisampleEXT_debug(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line);
#endif // defined(GL_EXT_memory_object)
#if defined(GL_EXT_memory_object_fd)
#ifndef glImportMemoryFdEXT
#define glImportMemoryFdEXT(memory, size, handleType, fd) glatter_glImportMemoryFdEXT_debug((memory), (size), (handleType), (fd), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImportMemoryFdEXT_debug(GLuint memory, GLuint64 size, GLenum handleType, GLint fd, const char* file, int line);
#endif // defined(GL_EXT_memory_object_fd)
#if defined(GL_EXT_memory_object_win32)
#ifndef glImportMemoryWin32HandleEXT
#define glImportMemoryWin32HandleEXT(memory, size, handleType, handle) glatter_glImportMemoryWin32HandleEXT_debug((memory), (size), (handleType), (handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImportMemoryWin32HandleEXT_debug(GLuint memory, GLuint64 size, GLenum handleType, void *handle, const char* file, int line);
#ifndef glImportMemoryWin32NameEXT
#define glImportMemoryWin32NameEXT(memory, size, handleType, name) glatter_glImportMemoryWin32NameEXT_debug((memory), (size), (handleType), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImportMemoryWin32NameEXT_debug(GLuint memory, GLuint64 size, GLenum handleType, const void *name, const char* file, int line);
#endif // defined(GL_EXT_memory_object_win32)
#if defined(GL_EXT_multi_draw_arrays)
#ifndef glMultiDrawArraysEXT
#define glMultiDrawArraysEXT(mode, first, count, primcount) glatter_glMultiDrawArraysEXT_debug((mode), (first), (count), (primcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysEXT_debug(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount, const char* file, int line);
#ifndef glMultiDrawElementsEXT
#define glMultiDrawElementsEXT(mode, count, type, indices, primcount) glatter_glMultiDrawElementsEXT_debug((mode), (count), (type), (indices), (primcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsEXT_debug(GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, const char* file, int line);
#endif // defined(GL_EXT_multi_draw_arrays)
#if defined(GL_EXT_multisample)
#ifndef glSampleMaskEXT
#define glSampleMaskEXT(value, invert) glatter_glSampleMaskEXT_debug((value), (invert), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSampleMaskEXT_debug(GLclampf value, GLboolean invert, const char* file, int line);
#ifndef glSamplePatternEXT
#define glSamplePatternEXT(pattern) glatter_glSamplePatternEXT_debug((pattern), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSamplePatternEXT_debug(GLenum pattern, const char* file, int line);
#endif // defined(GL_EXT_multisample)
#if defined(GL_EXT_paletted_texture)
#ifndef glColorTableEXT
#define glColorTableEXT(target, internalFormat, width, format, type, table) glatter_glColorTableEXT_debug((target), (internalFormat), (width), (format), (type), (table), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorTableEXT_debug(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const void *table, const char* file, int line);
#ifndef glGetColorTableEXT
#define glGetColorTableEXT(target, format, type, data) glatter_glGetColorTableEXT_debug((target), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableEXT_debug(GLenum target, GLenum format, GLenum type, void *data, const char* file, int line);
#ifndef glGetColorTableParameterfvEXT
#define glGetColorTableParameterfvEXT(target, pname, params) glatter_glGetColorTableParameterfvEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetColorTableParameterivEXT
#define glGetColorTableParameterivEXT(target, pname, params) glatter_glGetColorTableParameterivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#endif // defined(GL_EXT_paletted_texture)
#if defined(GL_EXT_pixel_transform)
#ifndef glGetPixelTransformParameterfvEXT
#define glGetPixelTransformParameterfvEXT(target, pname, params) glatter_glGetPixelTransformParameterfvEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPixelTransformParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetPixelTransformParameterivEXT
#define glGetPixelTransformParameterivEXT(target, pname, params) glatter_glGetPixelTransformParameterivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPixelTransformParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glPixelTransformParameterfEXT
#define glPixelTransformParameterfEXT(target, pname, param) glatter_glPixelTransformParameterfEXT_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTransformParameterfEXT_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glPixelTransformParameterfvEXT
#define glPixelTransformParameterfvEXT(target, pname, params) glatter_glPixelTransformParameterfvEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTransformParameterfvEXT_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glPixelTransformParameteriEXT
#define glPixelTransformParameteriEXT(target, pname, param) glatter_glPixelTransformParameteriEXT_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTransformParameteriEXT_debug(GLenum target, GLenum pname, GLint param, const char* file, int line);
#ifndef glPixelTransformParameterivEXT
#define glPixelTransformParameterivEXT(target, pname, params) glatter_glPixelTransformParameterivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTransformParameterivEXT_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#endif // defined(GL_EXT_pixel_transform)
#if defined(GL_EXT_point_parameters)
#ifndef glPointParameterfEXT
#define glPointParameterfEXT(pname, param) glatter_glPointParameterfEXT_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfEXT_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glPointParameterfvEXT
#define glPointParameterfvEXT(pname, params) glatter_glPointParameterfvEXT_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfvEXT_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#endif // defined(GL_EXT_point_parameters)
#if defined(GL_EXT_polygon_offset)
#ifndef glPolygonOffsetEXT
#define glPolygonOffsetEXT(factor, bias) glatter_glPolygonOffsetEXT_debug((factor), (bias), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffsetEXT_debug(GLfloat factor, GLfloat bias, const char* file, int line);
#endif // defined(GL_EXT_polygon_offset)
#if defined(GL_EXT_polygon_offset_clamp)
#ifndef glPolygonOffsetClampEXT
#define glPolygonOffsetClampEXT(factor, units, clamp) glatter_glPolygonOffsetClampEXT_debug((factor), (units), (clamp), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffsetClampEXT_debug(GLfloat factor, GLfloat units, GLfloat clamp, const char* file, int line);
#endif // defined(GL_EXT_polygon_offset_clamp)
#if defined(GL_EXT_provoking_vertex)
#ifndef glProvokingVertexEXT
#define glProvokingVertexEXT(mode) glatter_glProvokingVertexEXT_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProvokingVertexEXT_debug(GLenum mode, const char* file, int line);
#endif // defined(GL_EXT_provoking_vertex)
#if defined(GL_EXT_raster_multisample)
#ifndef glRasterSamplesEXT
#define glRasterSamplesEXT(samples, fixedsamplelocations) glatter_glRasterSamplesEXT_debug((samples), (fixedsamplelocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterSamplesEXT_debug(GLuint samples, GLboolean fixedsamplelocations, const char* file, int line);
#endif // defined(GL_EXT_raster_multisample)
#if defined(GL_EXT_secondary_color)
#ifndef glSecondaryColor3bEXT
#define glSecondaryColor3bEXT(red, green, blue) glatter_glSecondaryColor3bEXT_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3bEXT_debug(GLbyte red, GLbyte green, GLbyte blue, const char* file, int line);
#ifndef glSecondaryColor3bvEXT
#define glSecondaryColor3bvEXT(v) glatter_glSecondaryColor3bvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3bvEXT_debug(const GLbyte *v, const char* file, int line);
#ifndef glSecondaryColor3dEXT
#define glSecondaryColor3dEXT(red, green, blue) glatter_glSecondaryColor3dEXT_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3dEXT_debug(GLdouble red, GLdouble green, GLdouble blue, const char* file, int line);
#ifndef glSecondaryColor3dvEXT
#define glSecondaryColor3dvEXT(v) glatter_glSecondaryColor3dvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3dvEXT_debug(const GLdouble *v, const char* file, int line);
#ifndef glSecondaryColor3fEXT
#define glSecondaryColor3fEXT(red, green, blue) glatter_glSecondaryColor3fEXT_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3fEXT_debug(GLfloat red, GLfloat green, GLfloat blue, const char* file, int line);
#ifndef glSecondaryColor3fvEXT
#define glSecondaryColor3fvEXT(v) glatter_glSecondaryColor3fvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3fvEXT_debug(const GLfloat *v, const char* file, int line);
#ifndef glSecondaryColor3iEXT
#define glSecondaryColor3iEXT(red, green, blue) glatter_glSecondaryColor3iEXT_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3iEXT_debug(GLint red, GLint green, GLint blue, const char* file, int line);
#ifndef glSecondaryColor3ivEXT
#define glSecondaryColor3ivEXT(v) glatter_glSecondaryColor3ivEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3ivEXT_debug(const GLint *v, const char* file, int line);
#ifndef glSecondaryColor3sEXT
#define glSecondaryColor3sEXT(red, green, blue) glatter_glSecondaryColor3sEXT_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3sEXT_debug(GLshort red, GLshort green, GLshort blue, const char* file, int line);
#ifndef glSecondaryColor3svEXT
#define glSecondaryColor3svEXT(v) glatter_glSecondaryColor3svEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3svEXT_debug(const GLshort *v, const char* file, int line);
#ifndef glSecondaryColor3ubEXT
#define glSecondaryColor3ubEXT(red, green, blue) glatter_glSecondaryColor3ubEXT_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3ubEXT_debug(GLubyte red, GLubyte green, GLubyte blue, const char* file, int line);
#ifndef glSecondaryColor3ubvEXT
#define glSecondaryColor3ubvEXT(v) glatter_glSecondaryColor3ubvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3ubvEXT_debug(const GLubyte *v, const char* file, int line);
#ifndef glSecondaryColor3uiEXT
#define glSecondaryColor3uiEXT(red, green, blue) glatter_glSecondaryColor3uiEXT_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3uiEXT_debug(GLuint red, GLuint green, GLuint blue, const char* file, int line);
#ifndef glSecondaryColor3uivEXT
#define glSecondaryColor3uivEXT(v) glatter_glSecondaryColor3uivEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3uivEXT_debug(const GLuint *v, const char* file, int line);
#ifndef glSecondaryColor3usEXT
#define glSecondaryColor3usEXT(red, green, blue) glatter_glSecondaryColor3usEXT_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3usEXT_debug(GLushort red, GLushort green, GLushort blue, const char* file, int line);
#ifndef glSecondaryColor3usvEXT
#define glSecondaryColor3usvEXT(v) glatter_glSecondaryColor3usvEXT_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3usvEXT_debug(const GLushort *v, const char* file, int line);
#ifndef glSecondaryColorPointerEXT
#define glSecondaryColorPointerEXT(size, type, stride, pointer) glatter_glSecondaryColorPointerEXT_debug((size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColorPointerEXT_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#endif // defined(GL_EXT_secondary_color)
#if defined(GL_EXT_semaphore)
#ifndef glDeleteSemaphoresEXT
#define glDeleteSemaphoresEXT(n, semaphores) glatter_glDeleteSemaphoresEXT_debug((n), (semaphores), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteSemaphoresEXT_debug(GLsizei n, const GLuint *semaphores, const char* file, int line);
#ifndef glGenSemaphoresEXT
#define glGenSemaphoresEXT(n, semaphores) glatter_glGenSemaphoresEXT_debug((n), (semaphores), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenSemaphoresEXT_debug(GLsizei n, GLuint *semaphores, const char* file, int line);
#ifndef glGetSemaphoreParameterui64vEXT
#define glGetSemaphoreParameterui64vEXT(semaphore, pname, params) glatter_glGetSemaphoreParameterui64vEXT_debug((semaphore), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetSemaphoreParameterui64vEXT_debug(GLuint semaphore, GLenum pname, GLuint64 *params, const char* file, int line);
#ifndef glIsSemaphoreEXT
#define glIsSemaphoreEXT(semaphore) glatter_glIsSemaphoreEXT_debug((semaphore), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsSemaphoreEXT_debug(GLuint semaphore, const char* file, int line);
#ifndef glSemaphoreParameterui64vEXT
#define glSemaphoreParameterui64vEXT(semaphore, pname, params) glatter_glSemaphoreParameterui64vEXT_debug((semaphore), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSemaphoreParameterui64vEXT_debug(GLuint semaphore, GLenum pname, const GLuint64 *params, const char* file, int line);
#ifndef glSignalSemaphoreEXT
#define glSignalSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, dstLayouts) glatter_glSignalSemaphoreEXT_debug((semaphore), (numBufferBarriers), (buffers), (numTextureBarriers), (textures), (dstLayouts), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSignalSemaphoreEXT_debug(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *dstLayouts, const char* file, int line);
#ifndef glWaitSemaphoreEXT
#define glWaitSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, srcLayouts) glatter_glWaitSemaphoreEXT_debug((semaphore), (numBufferBarriers), (buffers), (numTextureBarriers), (textures), (srcLayouts), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWaitSemaphoreEXT_debug(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *srcLayouts, const char* file, int line);
#endif // defined(GL_EXT_semaphore)
#if defined(GL_EXT_semaphore_fd)
#ifndef glImportSemaphoreFdEXT
#define glImportSemaphoreFdEXT(semaphore, handleType, fd) glatter_glImportSemaphoreFdEXT_debug((semaphore), (handleType), (fd), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImportSemaphoreFdEXT_debug(GLuint semaphore, GLenum handleType, GLint fd, const char* file, int line);
#endif // defined(GL_EXT_semaphore_fd)
#if defined(GL_EXT_semaphore_win32)
#ifndef glImportSemaphoreWin32HandleEXT
#define glImportSemaphoreWin32HandleEXT(semaphore, handleType, handle) glatter_glImportSemaphoreWin32HandleEXT_debug((semaphore), (handleType), (handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImportSemaphoreWin32HandleEXT_debug(GLuint semaphore, GLenum handleType, void *handle, const char* file, int line);
#ifndef glImportSemaphoreWin32NameEXT
#define glImportSemaphoreWin32NameEXT(semaphore, handleType, name) glatter_glImportSemaphoreWin32NameEXT_debug((semaphore), (handleType), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImportSemaphoreWin32NameEXT_debug(GLuint semaphore, GLenum handleType, const void *name, const char* file, int line);
#endif // defined(GL_EXT_semaphore_win32)
#if defined(GL_EXT_separate_shader_objects)
#ifndef glActiveProgramEXT
#define glActiveProgramEXT(program) glatter_glActiveProgramEXT_debug((program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glActiveProgramEXT_debug(GLuint program, const char* file, int line);
#ifndef glCreateShaderProgramEXT
#define glCreateShaderProgramEXT(type, string) glatter_glCreateShaderProgramEXT_debug((type), (string), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glCreateShaderProgramEXT_debug(GLenum type, const GLchar *string, const char* file, int line);
#ifndef glUseShaderProgramEXT
#define glUseShaderProgramEXT(type, program) glatter_glUseShaderProgramEXT_debug((type), (program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUseShaderProgramEXT_debug(GLenum type, GLuint program, const char* file, int line);
#endif // defined(GL_EXT_separate_shader_objects)
#if defined(GL_EXT_shader_framebuffer_fetch_non_coherent)
#ifndef glFramebufferFetchBarrierEXT
#define glFramebufferFetchBarrierEXT() glatter_glFramebufferFetchBarrierEXT_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferFetchBarrierEXT_debug(const char* file, int line);
#endif // defined(GL_EXT_shader_framebuffer_fetch_non_coherent)
#if defined(GL_EXT_shader_image_load_store)
#ifndef glBindImageTextureEXT
#define glBindImageTextureEXT(index, texture, level, layered, layer, access, format) glatter_glBindImageTextureEXT_debug((index), (texture), (level), (layered), (layer), (access), (format), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindImageTextureEXT_debug(GLuint index, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLint format, const char* file, int line);
#ifndef glMemoryBarrierEXT
#define glMemoryBarrierEXT(barriers) glatter_glMemoryBarrierEXT_debug((barriers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMemoryBarrierEXT_debug(GLbitfield barriers, const char* file, int line);
#endif // defined(GL_EXT_shader_image_load_store)
#if defined(GL_EXT_stencil_clear_tag)
#ifndef glStencilClearTagEXT
#define glStencilClearTagEXT(stencilTagBits, stencilClearTag) glatter_glStencilClearTagEXT_debug((stencilTagBits), (stencilClearTag), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilClearTagEXT_debug(GLsizei stencilTagBits, GLuint stencilClearTag, const char* file, int line);
#endif // defined(GL_EXT_stencil_clear_tag)
#if defined(GL_EXT_stencil_two_side)
#ifndef glActiveStencilFaceEXT
#define glActiveStencilFaceEXT(face) glatter_glActiveStencilFaceEXT_debug((face), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glActiveStencilFaceEXT_debug(GLenum face, const char* file, int line);
#endif // defined(GL_EXT_stencil_two_side)
#if defined(GL_EXT_subtexture)
#ifndef glTexSubImage1DEXT
#define glTexSubImage1DEXT(target, level, xoffset, width, format, type, pixels) glatter_glTexSubImage1DEXT_debug((target), (level), (xoffset), (width), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage1DEXT_debug(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTexSubImage2DEXT
#define glTexSubImage2DEXT(target, level, xoffset, yoffset, width, height, format, type, pixels) glatter_glTexSubImage2DEXT_debug((target), (level), (xoffset), (yoffset), (width), (height), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage2DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#endif // defined(GL_EXT_subtexture)
#if defined(GL_EXT_texture3D)
#ifndef glTexImage3DEXT
#define glTexImage3DEXT(target, level, internalformat, width, height, depth, border, format, type, pixels) glatter_glTexImage3DEXT_debug((target), (level), (internalformat), (width), (height), (depth), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexImage3DEXT_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTexSubImage3DEXT
#define glTexSubImage3DEXT(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels) glatter_glTexSubImage3DEXT_debug((target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage3DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#endif // defined(GL_EXT_texture3D)
#if defined(GL_EXT_texture_array)
#ifndef glFramebufferTextureLayerEXT
#define glFramebufferTextureLayerEXT(target, attachment, texture, level, layer) glatter_glFramebufferTextureLayerEXT_debug((target), (attachment), (texture), (level), (layer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureLayerEXT_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer, const char* file, int line);
#endif // defined(GL_EXT_texture_array)
#if defined(GL_EXT_texture_buffer_object)
#ifndef glTexBufferEXT
#define glTexBufferEXT(target, internalformat, buffer) glatter_glTexBufferEXT_debug((target), (internalformat), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexBufferEXT_debug(GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line);
#endif // defined(GL_EXT_texture_buffer_object)
#if defined(GL_EXT_texture_integer)
#ifndef glClearColorIiEXT
#define glClearColorIiEXT(red, green, blue, alpha) glatter_glClearColorIiEXT_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearColorIiEXT_debug(GLint red, GLint green, GLint blue, GLint alpha, const char* file, int line);
#ifndef glClearColorIuiEXT
#define glClearColorIuiEXT(red, green, blue, alpha) glatter_glClearColorIuiEXT_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearColorIuiEXT_debug(GLuint red, GLuint green, GLuint blue, GLuint alpha, const char* file, int line);
#ifndef glGetTexParameterIivEXT
#define glGetTexParameterIivEXT(target, pname, params) glatter_glGetTexParameterIivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTexParameterIuivEXT
#define glGetTexParameterIuivEXT(target, pname, params) glatter_glGetTexParameterIuivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIuivEXT_debug(GLenum target, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glTexParameterIivEXT
#define glTexParameterIivEXT(target, pname, params) glatter_glTexParameterIivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIivEXT_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glTexParameterIuivEXT
#define glTexParameterIuivEXT(target, pname, params) glatter_glTexParameterIuivEXT_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIuivEXT_debug(GLenum target, GLenum pname, const GLuint *params, const char* file, int line);
#endif // defined(GL_EXT_texture_integer)
#if defined(GL_EXT_texture_object)
#ifndef glAreTexturesResidentEXT
#define glAreTexturesResidentEXT(n, textures, residences) glatter_glAreTexturesResidentEXT_debug((n), (textures), (residences), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glAreTexturesResidentEXT_debug(GLsizei n, const GLuint *textures, GLboolean *residences, const char* file, int line);
#ifndef glBindTextureEXT
#define glBindTextureEXT(target, texture) glatter_glBindTextureEXT_debug((target), (texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindTextureEXT_debug(GLenum target, GLuint texture, const char* file, int line);
#ifndef glDeleteTexturesEXT
#define glDeleteTexturesEXT(n, textures) glatter_glDeleteTexturesEXT_debug((n), (textures), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteTexturesEXT_debug(GLsizei n, const GLuint *textures, const char* file, int line);
#ifndef glGenTexturesEXT
#define glGenTexturesEXT(n, textures) glatter_glGenTexturesEXT_debug((n), (textures), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenTexturesEXT_debug(GLsizei n, GLuint *textures, const char* file, int line);
#ifndef glIsTextureEXT
#define glIsTextureEXT(texture) glatter_glIsTextureEXT_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTextureEXT_debug(GLuint texture, const char* file, int line);
#ifndef glPrioritizeTexturesEXT
#define glPrioritizeTexturesEXT(n, textures, priorities) glatter_glPrioritizeTexturesEXT_debug((n), (textures), (priorities), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPrioritizeTexturesEXT_debug(GLsizei n, const GLuint *textures, const GLclampf *priorities, const char* file, int line);
#endif // defined(GL_EXT_texture_object)
#if defined(GL_EXT_texture_perturb_normal)
#ifndef glTextureNormalEXT
#define glTextureNormalEXT(mode) glatter_glTextureNormalEXT_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureNormalEXT_debug(GLenum mode, const char* file, int line);
#endif // defined(GL_EXT_texture_perturb_normal)
#if defined(GL_EXT_timer_query)
#ifndef glGetQueryObjecti64vEXT
#define glGetQueryObjecti64vEXT(id, pname, params) glatter_glGetQueryObjecti64vEXT_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjecti64vEXT_debug(GLuint id, GLenum pname, GLint64 *params, const char* file, int line);
#ifndef glGetQueryObjectui64vEXT
#define glGetQueryObjectui64vEXT(id, pname, params) glatter_glGetQueryObjectui64vEXT_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectui64vEXT_debug(GLuint id, GLenum pname, GLuint64 *params, const char* file, int line);
#endif // defined(GL_EXT_timer_query)
#if defined(GL_EXT_transform_feedback)
#ifndef glBeginTransformFeedbackEXT
#define glBeginTransformFeedbackEXT(primitiveMode) glatter_glBeginTransformFeedbackEXT_debug((primitiveMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginTransformFeedbackEXT_debug(GLenum primitiveMode, const char* file, int line);
#ifndef glBindBufferBaseEXT
#define glBindBufferBaseEXT(target, index, buffer) glatter_glBindBufferBaseEXT_debug((target), (index), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBufferBaseEXT_debug(GLenum target, GLuint index, GLuint buffer, const char* file, int line);
#ifndef glBindBufferOffsetEXT
#define glBindBufferOffsetEXT(target, index, buffer, offset) glatter_glBindBufferOffsetEXT_debug((target), (index), (buffer), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBufferOffsetEXT_debug(GLenum target, GLuint index, GLuint buffer, GLintptr offset, const char* file, int line);
#ifndef glBindBufferRangeEXT
#define glBindBufferRangeEXT(target, index, buffer, offset, size) glatter_glBindBufferRangeEXT_debug((target), (index), (buffer), (offset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBufferRangeEXT_debug(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line);
#ifndef glEndTransformFeedbackEXT
#define glEndTransformFeedbackEXT() glatter_glEndTransformFeedbackEXT_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndTransformFeedbackEXT_debug(const char* file, int line);
#ifndef glGetTransformFeedbackVaryingEXT
#define glGetTransformFeedbackVaryingEXT(program, index, bufSize, length, size, type, name) glatter_glGetTransformFeedbackVaryingEXT_debug((program), (index), (bufSize), (length), (size), (type), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTransformFeedbackVaryingEXT_debug(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name, const char* file, int line);
#ifndef glTransformFeedbackVaryingsEXT
#define glTransformFeedbackVaryingsEXT(program, count, varyings, bufferMode) glatter_glTransformFeedbackVaryingsEXT_debug((program), (count), (varyings), (bufferMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTransformFeedbackVaryingsEXT_debug(GLuint program, GLsizei count, const GLchar *const*varyings, GLenum bufferMode, const char* file, int line);
#endif // defined(GL_EXT_transform_feedback)
#if defined(GL_EXT_vertex_array)
#ifndef glArrayElementEXT
#define glArrayElementEXT(i) glatter_glArrayElementEXT_debug((i), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glArrayElementEXT_debug(GLint i, const char* file, int line);
#ifndef glColorPointerEXT
#define glColorPointerEXT(size, type, stride, count, pointer) glatter_glColorPointerEXT_debug((size), (type), (stride), (count), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorPointerEXT_debug(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line);
#ifndef glDrawArraysEXT
#define glDrawArraysEXT(mode, first, count) glatter_glDrawArraysEXT_debug((mode), (first), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysEXT_debug(GLenum mode, GLint first, GLsizei count, const char* file, int line);
#ifndef glEdgeFlagPointerEXT
#define glEdgeFlagPointerEXT(stride, count, pointer) glatter_glEdgeFlagPointerEXT_debug((stride), (count), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlagPointerEXT_debug(GLsizei stride, GLsizei count, const GLboolean *pointer, const char* file, int line);
#ifndef glGetPointervEXT
#define glGetPointervEXT(pname, params) glatter_glGetPointervEXT_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPointervEXT_debug(GLenum pname, void **params, const char* file, int line);
#ifndef glIndexPointerEXT
#define glIndexPointerEXT(type, stride, count, pointer) glatter_glIndexPointerEXT_debug((type), (stride), (count), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexPointerEXT_debug(GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line);
#ifndef glNormalPointerEXT
#define glNormalPointerEXT(type, stride, count, pointer) glatter_glNormalPointerEXT_debug((type), (stride), (count), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalPointerEXT_debug(GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line);
#ifndef glTexCoordPointerEXT
#define glTexCoordPointerEXT(size, type, stride, count, pointer) glatter_glTexCoordPointerEXT_debug((size), (type), (stride), (count), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordPointerEXT_debug(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line);
#ifndef glVertexPointerEXT
#define glVertexPointerEXT(size, type, stride, count, pointer) glatter_glVertexPointerEXT_debug((size), (type), (stride), (count), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexPointerEXT_debug(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line);
#endif // defined(GL_EXT_vertex_array)
#if defined(GL_EXT_vertex_attrib_64bit)
#ifndef glGetVertexAttribLdvEXT
#define glGetVertexAttribLdvEXT(index, pname, params) glatter_glGetVertexAttribLdvEXT_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribLdvEXT_debug(GLuint index, GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glVertexAttribL1dEXT
#define glVertexAttribL1dEXT(index, x) glatter_glVertexAttribL1dEXT_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1dEXT_debug(GLuint index, GLdouble x, const char* file, int line);
#ifndef glVertexAttribL1dvEXT
#define glVertexAttribL1dvEXT(index, v) glatter_glVertexAttribL1dvEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1dvEXT_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribL2dEXT
#define glVertexAttribL2dEXT(index, x, y) glatter_glVertexAttribL2dEXT_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2dEXT_debug(GLuint index, GLdouble x, GLdouble y, const char* file, int line);
#ifndef glVertexAttribL2dvEXT
#define glVertexAttribL2dvEXT(index, v) glatter_glVertexAttribL2dvEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2dvEXT_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribL3dEXT
#define glVertexAttribL3dEXT(index, x, y, z) glatter_glVertexAttribL3dEXT_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3dEXT_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glVertexAttribL3dvEXT
#define glVertexAttribL3dvEXT(index, v) glatter_glVertexAttribL3dvEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3dvEXT_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribL4dEXT
#define glVertexAttribL4dEXT(index, x, y, z, w) glatter_glVertexAttribL4dEXT_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4dEXT_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glVertexAttribL4dvEXT
#define glVertexAttribL4dvEXT(index, v) glatter_glVertexAttribL4dvEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4dvEXT_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribLPointerEXT
#define glVertexAttribLPointerEXT(index, size, type, stride, pointer) glatter_glVertexAttribLPointerEXT_debug((index), (size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribLPointerEXT_debug(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#endif // defined(GL_EXT_vertex_attrib_64bit)
#if defined(GL_EXT_vertex_shader)
#ifndef glBeginVertexShaderEXT
#define glBeginVertexShaderEXT() glatter_glBeginVertexShaderEXT_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginVertexShaderEXT_debug(const char* file, int line);
#ifndef glBindLightParameterEXT
#define glBindLightParameterEXT(light, value) glatter_glBindLightParameterEXT_debug((light), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glBindLightParameterEXT_debug(GLenum light, GLenum value, const char* file, int line);
#ifndef glBindMaterialParameterEXT
#define glBindMaterialParameterEXT(face, value) glatter_glBindMaterialParameterEXT_debug((face), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glBindMaterialParameterEXT_debug(GLenum face, GLenum value, const char* file, int line);
#ifndef glBindParameterEXT
#define glBindParameterEXT(value) glatter_glBindParameterEXT_debug((value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glBindParameterEXT_debug(GLenum value, const char* file, int line);
#ifndef glBindTexGenParameterEXT
#define glBindTexGenParameterEXT(unit, coord, value) glatter_glBindTexGenParameterEXT_debug((unit), (coord), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glBindTexGenParameterEXT_debug(GLenum unit, GLenum coord, GLenum value, const char* file, int line);
#ifndef glBindTextureUnitParameterEXT
#define glBindTextureUnitParameterEXT(unit, value) glatter_glBindTextureUnitParameterEXT_debug((unit), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glBindTextureUnitParameterEXT_debug(GLenum unit, GLenum value, const char* file, int line);
#ifndef glBindVertexShaderEXT
#define glBindVertexShaderEXT(id) glatter_glBindVertexShaderEXT_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindVertexShaderEXT_debug(GLuint id, const char* file, int line);
#ifndef glDeleteVertexShaderEXT
#define glDeleteVertexShaderEXT(id) glatter_glDeleteVertexShaderEXT_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteVertexShaderEXT_debug(GLuint id, const char* file, int line);
#ifndef glDisableVariantClientStateEXT
#define glDisableVariantClientStateEXT(id) glatter_glDisableVariantClientStateEXT_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableVariantClientStateEXT_debug(GLuint id, const char* file, int line);
#ifndef glEnableVariantClientStateEXT
#define glEnableVariantClientStateEXT(id) glatter_glEnableVariantClientStateEXT_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableVariantClientStateEXT_debug(GLuint id, const char* file, int line);
#ifndef glEndVertexShaderEXT
#define glEndVertexShaderEXT() glatter_glEndVertexShaderEXT_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndVertexShaderEXT_debug(const char* file, int line);
#ifndef glExtractComponentEXT
#define glExtractComponentEXT(res, src, num) glatter_glExtractComponentEXT_debug((res), (src), (num), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glExtractComponentEXT_debug(GLuint res, GLuint src, GLuint num, const char* file, int line);
#ifndef glGenSymbolsEXT
#define glGenSymbolsEXT(datatype, storagetype, range, components) glatter_glGenSymbolsEXT_debug((datatype), (storagetype), (range), (components), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGenSymbolsEXT_debug(GLenum datatype, GLenum storagetype, GLenum range, GLuint components, const char* file, int line);
#ifndef glGenVertexShadersEXT
#define glGenVertexShadersEXT(range) glatter_glGenVertexShadersEXT_debug((range), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGenVertexShadersEXT_debug(GLuint range, const char* file, int line);
#ifndef glGetInvariantBooleanvEXT
#define glGetInvariantBooleanvEXT(id, value, data) glatter_glGetInvariantBooleanvEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetInvariantBooleanvEXT_debug(GLuint id, GLenum value, GLboolean *data, const char* file, int line);
#ifndef glGetInvariantFloatvEXT
#define glGetInvariantFloatvEXT(id, value, data) glatter_glGetInvariantFloatvEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetInvariantFloatvEXT_debug(GLuint id, GLenum value, GLfloat *data, const char* file, int line);
#ifndef glGetInvariantIntegervEXT
#define glGetInvariantIntegervEXT(id, value, data) glatter_glGetInvariantIntegervEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetInvariantIntegervEXT_debug(GLuint id, GLenum value, GLint *data, const char* file, int line);
#ifndef glGetLocalConstantBooleanvEXT
#define glGetLocalConstantBooleanvEXT(id, value, data) glatter_glGetLocalConstantBooleanvEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetLocalConstantBooleanvEXT_debug(GLuint id, GLenum value, GLboolean *data, const char* file, int line);
#ifndef glGetLocalConstantFloatvEXT
#define glGetLocalConstantFloatvEXT(id, value, data) glatter_glGetLocalConstantFloatvEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetLocalConstantFloatvEXT_debug(GLuint id, GLenum value, GLfloat *data, const char* file, int line);
#ifndef glGetLocalConstantIntegervEXT
#define glGetLocalConstantIntegervEXT(id, value, data) glatter_glGetLocalConstantIntegervEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetLocalConstantIntegervEXT_debug(GLuint id, GLenum value, GLint *data, const char* file, int line);
#ifndef glGetVariantBooleanvEXT
#define glGetVariantBooleanvEXT(id, value, data) glatter_glGetVariantBooleanvEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVariantBooleanvEXT_debug(GLuint id, GLenum value, GLboolean *data, const char* file, int line);
#ifndef glGetVariantFloatvEXT
#define glGetVariantFloatvEXT(id, value, data) glatter_glGetVariantFloatvEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVariantFloatvEXT_debug(GLuint id, GLenum value, GLfloat *data, const char* file, int line);
#ifndef glGetVariantIntegervEXT
#define glGetVariantIntegervEXT(id, value, data) glatter_glGetVariantIntegervEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVariantIntegervEXT_debug(GLuint id, GLenum value, GLint *data, const char* file, int line);
#ifndef glGetVariantPointervEXT
#define glGetVariantPointervEXT(id, value, data) glatter_glGetVariantPointervEXT_debug((id), (value), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVariantPointervEXT_debug(GLuint id, GLenum value, void **data, const char* file, int line);
#ifndef glInsertComponentEXT
#define glInsertComponentEXT(res, src, num) glatter_glInsertComponentEXT_debug((res), (src), (num), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInsertComponentEXT_debug(GLuint res, GLuint src, GLuint num, const char* file, int line);
#ifndef glIsVariantEnabledEXT
#define glIsVariantEnabledEXT(id, cap) glatter_glIsVariantEnabledEXT_debug((id), (cap), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVariantEnabledEXT_debug(GLuint id, GLenum cap, const char* file, int line);
#ifndef glSetInvariantEXT
#define glSetInvariantEXT(id, type, addr) glatter_glSetInvariantEXT_debug((id), (type), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSetInvariantEXT_debug(GLuint id, GLenum type, const void *addr, const char* file, int line);
#ifndef glSetLocalConstantEXT
#define glSetLocalConstantEXT(id, type, addr) glatter_glSetLocalConstantEXT_debug((id), (type), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSetLocalConstantEXT_debug(GLuint id, GLenum type, const void *addr, const char* file, int line);
#ifndef glShaderOp1EXT
#define glShaderOp1EXT(op, res, arg1) glatter_glShaderOp1EXT_debug((op), (res), (arg1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glShaderOp1EXT_debug(GLenum op, GLuint res, GLuint arg1, const char* file, int line);
#ifndef glShaderOp2EXT
#define glShaderOp2EXT(op, res, arg1, arg2) glatter_glShaderOp2EXT_debug((op), (res), (arg1), (arg2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glShaderOp2EXT_debug(GLenum op, GLuint res, GLuint arg1, GLuint arg2, const char* file, int line);
#ifndef glShaderOp3EXT
#define glShaderOp3EXT(op, res, arg1, arg2, arg3) glatter_glShaderOp3EXT_debug((op), (res), (arg1), (arg2), (arg3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glShaderOp3EXT_debug(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3, const char* file, int line);
#ifndef glSwizzleEXT
#define glSwizzleEXT(res, in, outX, outY, outZ, outW) glatter_glSwizzleEXT_debug((res), (in), (outX), (outY), (outZ), (outW), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSwizzleEXT_debug(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW, const char* file, int line);
#ifndef glVariantPointerEXT
#define glVariantPointerEXT(id, type, stride, addr) glatter_glVariantPointerEXT_debug((id), (type), (stride), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantPointerEXT_debug(GLuint id, GLenum type, GLuint stride, const void *addr, const char* file, int line);
#ifndef glVariantbvEXT
#define glVariantbvEXT(id, addr) glatter_glVariantbvEXT_debug((id), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantbvEXT_debug(GLuint id, const GLbyte *addr, const char* file, int line);
#ifndef glVariantdvEXT
#define glVariantdvEXT(id, addr) glatter_glVariantdvEXT_debug((id), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantdvEXT_debug(GLuint id, const GLdouble *addr, const char* file, int line);
#ifndef glVariantfvEXT
#define glVariantfvEXT(id, addr) glatter_glVariantfvEXT_debug((id), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantfvEXT_debug(GLuint id, const GLfloat *addr, const char* file, int line);
#ifndef glVariantivEXT
#define glVariantivEXT(id, addr) glatter_glVariantivEXT_debug((id), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantivEXT_debug(GLuint id, const GLint *addr, const char* file, int line);
#ifndef glVariantsvEXT
#define glVariantsvEXT(id, addr) glatter_glVariantsvEXT_debug((id), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantsvEXT_debug(GLuint id, const GLshort *addr, const char* file, int line);
#ifndef glVariantubvEXT
#define glVariantubvEXT(id, addr) glatter_glVariantubvEXT_debug((id), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantubvEXT_debug(GLuint id, const GLubyte *addr, const char* file, int line);
#ifndef glVariantuivEXT
#define glVariantuivEXT(id, addr) glatter_glVariantuivEXT_debug((id), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantuivEXT_debug(GLuint id, const GLuint *addr, const char* file, int line);
#ifndef glVariantusvEXT
#define glVariantusvEXT(id, addr) glatter_glVariantusvEXT_debug((id), (addr), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVariantusvEXT_debug(GLuint id, const GLushort *addr, const char* file, int line);
#ifndef glWriteMaskEXT
#define glWriteMaskEXT(res, in, outX, outY, outZ, outW) glatter_glWriteMaskEXT_debug((res), (in), (outX), (outY), (outZ), (outW), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWriteMaskEXT_debug(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW, const char* file, int line);
#endif // defined(GL_EXT_vertex_shader)
#if defined(GL_EXT_vertex_weighting)
#ifndef glVertexWeightPointerEXT
#define glVertexWeightPointerEXT(size, type, stride, pointer) glatter_glVertexWeightPointerEXT_debug((size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexWeightPointerEXT_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glVertexWeightfEXT
#define glVertexWeightfEXT(weight) glatter_glVertexWeightfEXT_debug((weight), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexWeightfEXT_debug(GLfloat weight, const char* file, int line);
#ifndef glVertexWeightfvEXT
#define glVertexWeightfvEXT(weight) glatter_glVertexWeightfvEXT_debug((weight), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexWeightfvEXT_debug(const GLfloat *weight, const char* file, int line);
#endif // defined(GL_EXT_vertex_weighting)
#if defined(GL_EXT_win32_keyed_mutex)
#ifndef glAcquireKeyedMutexWin32EXT
#define glAcquireKeyedMutexWin32EXT(memory, key, timeout) glatter_glAcquireKeyedMutexWin32EXT_debug((memory), (key), (timeout), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glAcquireKeyedMutexWin32EXT_debug(GLuint memory, GLuint64 key, GLuint timeout, const char* file, int line);
#ifndef glReleaseKeyedMutexWin32EXT
#define glReleaseKeyedMutexWin32EXT(memory, key) glatter_glReleaseKeyedMutexWin32EXT_debug((memory), (key), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glReleaseKeyedMutexWin32EXT_debug(GLuint memory, GLuint64 key, const char* file, int line);
#endif // defined(GL_EXT_win32_keyed_mutex)
#if defined(GL_EXT_window_rectangles)
#ifndef glWindowRectanglesEXT
#define glWindowRectanglesEXT(mode, count, box) glatter_glWindowRectanglesEXT_debug((mode), (count), (box), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowRectanglesEXT_debug(GLenum mode, GLsizei count, const GLint *box, const char* file, int line);
#endif // defined(GL_EXT_window_rectangles)
#if defined(GL_EXT_x11_sync_object)
#ifndef glImportSyncEXT
#define glImportSyncEXT(external_sync_type, external_sync, flags) glatter_glImportSyncEXT_debug((external_sync_type), (external_sync), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLsync glatter_glImportSyncEXT_debug(GLenum external_sync_type, GLintptr external_sync, GLbitfield flags, const char* file, int line);
#endif // defined(GL_EXT_x11_sync_object)
#if defined(GL_GREMEDY_frame_terminator)
#ifndef glFrameTerminatorGREMEDY
#define glFrameTerminatorGREMEDY() glatter_glFrameTerminatorGREMEDY_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFrameTerminatorGREMEDY_debug(const char* file, int line);
#endif // defined(GL_GREMEDY_frame_terminator)
#if defined(GL_GREMEDY_string_marker)
#ifndef glStringMarkerGREMEDY
#define glStringMarkerGREMEDY(len, string) glatter_glStringMarkerGREMEDY_debug((len), (string), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStringMarkerGREMEDY_debug(GLsizei len, const void *string, const char* file, int line);
#endif // defined(GL_GREMEDY_string_marker)
#if defined(GL_HP_image_transform)
#ifndef glGetImageTransformParameterfvHP
#define glGetImageTransformParameterfvHP(target, pname, params) glatter_glGetImageTransformParameterfvHP_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetImageTransformParameterfvHP_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetImageTransformParameterivHP
#define glGetImageTransformParameterivHP(target, pname, params) glatter_glGetImageTransformParameterivHP_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetImageTransformParameterivHP_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glImageTransformParameterfHP
#define glImageTransformParameterfHP(target, pname, param) glatter_glImageTransformParameterfHP_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImageTransformParameterfHP_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glImageTransformParameterfvHP
#define glImageTransformParameterfvHP(target, pname, params) glatter_glImageTransformParameterfvHP_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImageTransformParameterfvHP_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glImageTransformParameteriHP
#define glImageTransformParameteriHP(target, pname, param) glatter_glImageTransformParameteriHP_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImageTransformParameteriHP_debug(GLenum target, GLenum pname, GLint param, const char* file, int line);
#ifndef glImageTransformParameterivHP
#define glImageTransformParameterivHP(target, pname, params) glatter_glImageTransformParameterivHP_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glImageTransformParameterivHP_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#endif // defined(GL_HP_image_transform)
#if defined(GL_IBM_multimode_draw_arrays)
#ifndef glMultiModeDrawArraysIBM
#define glMultiModeDrawArraysIBM(mode, first, count, primcount, modestride) glatter_glMultiModeDrawArraysIBM_debug((mode), (first), (count), (primcount), (modestride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiModeDrawArraysIBM_debug(const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride, const char* file, int line);
#ifndef glMultiModeDrawElementsIBM
#define glMultiModeDrawElementsIBM(mode, count, type, indices, primcount, modestride) glatter_glMultiModeDrawElementsIBM_debug((mode), (count), (type), (indices), (primcount), (modestride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiModeDrawElementsIBM_debug(const GLenum *mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, GLint modestride, const char* file, int line);
#endif // defined(GL_IBM_multimode_draw_arrays)
#if defined(GL_IBM_static_data)
#ifndef glFlushStaticDataIBM
#define glFlushStaticDataIBM(target) glatter_glFlushStaticDataIBM_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlushStaticDataIBM_debug(GLenum target, const char* file, int line);
#endif // defined(GL_IBM_static_data)
#if defined(GL_IBM_vertex_array_lists)
#ifndef glColorPointerListIBM
#define glColorPointerListIBM(size, type, stride, pointer, ptrstride) glatter_glColorPointerListIBM_debug((size), (type), (stride), (pointer), (ptrstride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorPointerListIBM_debug(GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line);
#ifndef glEdgeFlagPointerListIBM
#define glEdgeFlagPointerListIBM(stride, pointer, ptrstride) glatter_glEdgeFlagPointerListIBM_debug((stride), (pointer), (ptrstride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlagPointerListIBM_debug(GLint stride, const GLboolean **pointer, GLint ptrstride, const char* file, int line);
#ifndef glFogCoordPointerListIBM
#define glFogCoordPointerListIBM(type, stride, pointer, ptrstride) glatter_glFogCoordPointerListIBM_debug((type), (stride), (pointer), (ptrstride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordPointerListIBM_debug(GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line);
#ifndef glIndexPointerListIBM
#define glIndexPointerListIBM(type, stride, pointer, ptrstride) glatter_glIndexPointerListIBM_debug((type), (stride), (pointer), (ptrstride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexPointerListIBM_debug(GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line);
#ifndef glNormalPointerListIBM
#define glNormalPointerListIBM(type, stride, pointer, ptrstride) glatter_glNormalPointerListIBM_debug((type), (stride), (pointer), (ptrstride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalPointerListIBM_debug(GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line);
#ifndef glSecondaryColorPointerListIBM
#define glSecondaryColorPointerListIBM(size, type, stride, pointer, ptrstride) glatter_glSecondaryColorPointerListIBM_debug((size), (type), (stride), (pointer), (ptrstride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColorPointerListIBM_debug(GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line);
#ifndef glTexCoordPointerListIBM
#define glTexCoordPointerListIBM(size, type, stride, pointer, ptrstride) glatter_glTexCoordPointerListIBM_debug((size), (type), (stride), (pointer), (ptrstride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordPointerListIBM_debug(GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line);
#ifndef glVertexPointerListIBM
#define glVertexPointerListIBM(size, type, stride, pointer, ptrstride) glatter_glVertexPointerListIBM_debug((size), (type), (stride), (pointer), (ptrstride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexPointerListIBM_debug(GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line);
#endif // defined(GL_IBM_vertex_array_lists)
#if defined(GL_INGR_blend_func_separate)
#ifndef glBlendFuncSeparateINGR
#define glBlendFuncSeparateINGR(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha) glatter_glBlendFuncSeparateINGR_debug((sfactorRGB), (dfactorRGB), (sfactorAlpha), (dfactorAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateINGR_debug(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha, const char* file, int line);
#endif // defined(GL_INGR_blend_func_separate)
#if defined(GL_INTEL_framebuffer_CMAA)
#ifndef glApplyFramebufferAttachmentCMAAINTEL
#define glApplyFramebufferAttachmentCMAAINTEL() glatter_glApplyFramebufferAttachmentCMAAINTEL_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glApplyFramebufferAttachmentCMAAINTEL_debug(const char* file, int line);
#endif // defined(GL_INTEL_framebuffer_CMAA)
#if defined(GL_INTEL_map_texture)
#ifndef glMapTexture2DINTEL
#define glMapTexture2DINTEL(texture, level, access, stride, layout) glatter_glMapTexture2DINTEL_debug((texture), (level), (access), (stride), (layout), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void * glatter_glMapTexture2DINTEL_debug(GLuint texture, GLint level, GLbitfield access, GLint *stride, GLenum *layout, const char* file, int line);
#ifndef glSyncTextureINTEL
#define glSyncTextureINTEL(texture) glatter_glSyncTextureINTEL_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSyncTextureINTEL_debug(GLuint texture, const char* file, int line);
#ifndef glUnmapTexture2DINTEL
#define glUnmapTexture2DINTEL(texture, level) glatter_glUnmapTexture2DINTEL_debug((texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUnmapTexture2DINTEL_debug(GLuint texture, GLint level, const char* file, int line);
#endif // defined(GL_INTEL_map_texture)
#if defined(GL_INTEL_parallel_arrays)
#ifndef glColorPointervINTEL
#define glColorPointervINTEL(size, type, pointer) glatter_glColorPointervINTEL_debug((size), (type), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorPointervINTEL_debug(GLint size, GLenum type, const void **pointer, const char* file, int line);
#ifndef glNormalPointervINTEL
#define glNormalPointervINTEL(type, pointer) glatter_glNormalPointervINTEL_debug((type), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalPointervINTEL_debug(GLenum type, const void **pointer, const char* file, int line);
#ifndef glTexCoordPointervINTEL
#define glTexCoordPointervINTEL(size, type, pointer) glatter_glTexCoordPointervINTEL_debug((size), (type), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordPointervINTEL_debug(GLint size, GLenum type, const void **pointer, const char* file, int line);
#ifndef glVertexPointervINTEL
#define glVertexPointervINTEL(size, type, pointer) glatter_glVertexPointervINTEL_debug((size), (type), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexPointervINTEL_debug(GLint size, GLenum type, const void **pointer, const char* file, int line);
#endif // defined(GL_INTEL_parallel_arrays)
#if defined(GL_INTEL_performance_query)
#ifndef glBeginPerfQueryINTEL
#define glBeginPerfQueryINTEL(queryHandle) glatter_glBeginPerfQueryINTEL_debug((queryHandle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginPerfQueryINTEL_debug(GLuint queryHandle, const char* file, int line);
#ifndef glCreatePerfQueryINTEL
#define glCreatePerfQueryINTEL(queryId, queryHandle) glatter_glCreatePerfQueryINTEL_debug((queryId), (queryHandle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreatePerfQueryINTEL_debug(GLuint queryId, GLuint *queryHandle, const char* file, int line);
#ifndef glDeletePerfQueryINTEL
#define glDeletePerfQueryINTEL(queryHandle) glatter_glDeletePerfQueryINTEL_debug((queryHandle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeletePerfQueryINTEL_debug(GLuint queryHandle, const char* file, int line);
#ifndef glEndPerfQueryINTEL
#define glEndPerfQueryINTEL(queryHandle) glatter_glEndPerfQueryINTEL_debug((queryHandle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndPerfQueryINTEL_debug(GLuint queryHandle, const char* file, int line);
#ifndef glGetFirstPerfQueryIdINTEL
#define glGetFirstPerfQueryIdINTEL(queryId) glatter_glGetFirstPerfQueryIdINTEL_debug((queryId), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFirstPerfQueryIdINTEL_debug(GLuint *queryId, const char* file, int line);
#ifndef glGetNextPerfQueryIdINTEL
#define glGetNextPerfQueryIdINTEL(queryId, nextQueryId) glatter_glGetNextPerfQueryIdINTEL_debug((queryId), (nextQueryId), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNextPerfQueryIdINTEL_debug(GLuint queryId, GLuint *nextQueryId, const char* file, int line);
#ifndef glGetPerfCounterInfoINTEL
#define glGetPerfCounterInfoINTEL(queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue) glatter_glGetPerfCounterInfoINTEL_debug((queryId), (counterId), (counterNameLength), (counterName), (counterDescLength), (counterDesc), (counterOffset), (counterDataSize), (counterTypeEnum), (counterDataTypeEnum), (rawCounterMaxValue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfCounterInfoINTEL_debug(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue, const char* file, int line);
#ifndef glGetPerfQueryDataINTEL
#define glGetPerfQueryDataINTEL(queryHandle, flags, dataSize, data, bytesWritten) glatter_glGetPerfQueryDataINTEL_debug((queryHandle), (flags), (dataSize), (data), (bytesWritten), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfQueryDataINTEL_debug(GLuint queryHandle, GLuint flags, GLsizei dataSize, void *data, GLuint *bytesWritten, const char* file, int line);
#ifndef glGetPerfQueryIdByNameINTEL
#define glGetPerfQueryIdByNameINTEL(queryName, queryId) glatter_glGetPerfQueryIdByNameINTEL_debug((queryName), (queryId), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfQueryIdByNameINTEL_debug(GLchar *queryName, GLuint *queryId, const char* file, int line);
#ifndef glGetPerfQueryInfoINTEL
#define glGetPerfQueryInfoINTEL(queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask) glatter_glGetPerfQueryInfoINTEL_debug((queryId), (queryNameLength), (queryName), (dataSize), (noCounters), (noInstances), (capsMask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPerfQueryInfoINTEL_debug(GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask, const char* file, int line);
#endif // defined(GL_INTEL_performance_query)
#if defined(GL_KHR_blend_equation_advanced)
#ifndef glBlendBarrierKHR
#define glBlendBarrierKHR() glatter_glBlendBarrierKHR_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendBarrierKHR_debug(const char* file, int line);
#endif // defined(GL_KHR_blend_equation_advanced)
#if defined(GL_KHR_parallel_shader_compile)
#ifndef glMaxShaderCompilerThreadsKHR
#define glMaxShaderCompilerThreadsKHR(count) glatter_glMaxShaderCompilerThreadsKHR_debug((count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMaxShaderCompilerThreadsKHR_debug(GLuint count, const char* file, int line);
#endif // defined(GL_KHR_parallel_shader_compile)
#if defined(GL_MESA_resize_buffers)
#ifndef glResizeBuffersMESA
#define glResizeBuffersMESA() glatter_glResizeBuffersMESA_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glResizeBuffersMESA_debug(const char* file, int line);
#endif // defined(GL_MESA_resize_buffers)
#if defined(GL_MESA_window_pos)
#ifndef glWindowPos2dMESA
#define glWindowPos2dMESA(x, y) glatter_glWindowPos2dMESA_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2dMESA_debug(GLdouble x, GLdouble y, const char* file, int line);
#ifndef glWindowPos2dvMESA
#define glWindowPos2dvMESA(v) glatter_glWindowPos2dvMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2dvMESA_debug(const GLdouble *v, const char* file, int line);
#ifndef glWindowPos2fMESA
#define glWindowPos2fMESA(x, y) glatter_glWindowPos2fMESA_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2fMESA_debug(GLfloat x, GLfloat y, const char* file, int line);
#ifndef glWindowPos2fvMESA
#define glWindowPos2fvMESA(v) glatter_glWindowPos2fvMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2fvMESA_debug(const GLfloat *v, const char* file, int line);
#ifndef glWindowPos2iMESA
#define glWindowPos2iMESA(x, y) glatter_glWindowPos2iMESA_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2iMESA_debug(GLint x, GLint y, const char* file, int line);
#ifndef glWindowPos2ivMESA
#define glWindowPos2ivMESA(v) glatter_glWindowPos2ivMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2ivMESA_debug(const GLint *v, const char* file, int line);
#ifndef glWindowPos2sMESA
#define glWindowPos2sMESA(x, y) glatter_glWindowPos2sMESA_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2sMESA_debug(GLshort x, GLshort y, const char* file, int line);
#ifndef glWindowPos2svMESA
#define glWindowPos2svMESA(v) glatter_glWindowPos2svMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2svMESA_debug(const GLshort *v, const char* file, int line);
#ifndef glWindowPos3dMESA
#define glWindowPos3dMESA(x, y, z) glatter_glWindowPos3dMESA_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3dMESA_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glWindowPos3dvMESA
#define glWindowPos3dvMESA(v) glatter_glWindowPos3dvMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3dvMESA_debug(const GLdouble *v, const char* file, int line);
#ifndef glWindowPos3fMESA
#define glWindowPos3fMESA(x, y, z) glatter_glWindowPos3fMESA_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3fMESA_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glWindowPos3fvMESA
#define glWindowPos3fvMESA(v) glatter_glWindowPos3fvMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3fvMESA_debug(const GLfloat *v, const char* file, int line);
#ifndef glWindowPos3iMESA
#define glWindowPos3iMESA(x, y, z) glatter_glWindowPos3iMESA_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3iMESA_debug(GLint x, GLint y, GLint z, const char* file, int line);
#ifndef glWindowPos3ivMESA
#define glWindowPos3ivMESA(v) glatter_glWindowPos3ivMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3ivMESA_debug(const GLint *v, const char* file, int line);
#ifndef glWindowPos3sMESA
#define glWindowPos3sMESA(x, y, z) glatter_glWindowPos3sMESA_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3sMESA_debug(GLshort x, GLshort y, GLshort z, const char* file, int line);
#ifndef glWindowPos3svMESA
#define glWindowPos3svMESA(v) glatter_glWindowPos3svMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3svMESA_debug(const GLshort *v, const char* file, int line);
#ifndef glWindowPos4dMESA
#define glWindowPos4dMESA(x, y, z, w) glatter_glWindowPos4dMESA_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4dMESA_debug(GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glWindowPos4dvMESA
#define glWindowPos4dvMESA(v) glatter_glWindowPos4dvMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4dvMESA_debug(const GLdouble *v, const char* file, int line);
#ifndef glWindowPos4fMESA
#define glWindowPos4fMESA(x, y, z, w) glatter_glWindowPos4fMESA_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4fMESA_debug(GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glWindowPos4fvMESA
#define glWindowPos4fvMESA(v) glatter_glWindowPos4fvMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4fvMESA_debug(const GLfloat *v, const char* file, int line);
#ifndef glWindowPos4iMESA
#define glWindowPos4iMESA(x, y, z, w) glatter_glWindowPos4iMESA_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4iMESA_debug(GLint x, GLint y, GLint z, GLint w, const char* file, int line);
#ifndef glWindowPos4ivMESA
#define glWindowPos4ivMESA(v) glatter_glWindowPos4ivMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4ivMESA_debug(const GLint *v, const char* file, int line);
#ifndef glWindowPos4sMESA
#define glWindowPos4sMESA(x, y, z, w) glatter_glWindowPos4sMESA_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4sMESA_debug(GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line);
#ifndef glWindowPos4svMESA
#define glWindowPos4svMESA(v) glatter_glWindowPos4svMESA_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4svMESA_debug(const GLshort *v, const char* file, int line);
#endif // defined(GL_MESA_window_pos)
#if defined(GL_NVX_conditional_render)
#ifndef glBeginConditionalRenderNVX
#define glBeginConditionalRenderNVX(id) glatter_glBeginConditionalRenderNVX_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginConditionalRenderNVX_debug(GLuint id, const char* file, int line);
#ifndef glEndConditionalRenderNVX
#define glEndConditionalRenderNVX() glatter_glEndConditionalRenderNVX_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndConditionalRenderNVX_debug(const char* file, int line);
#endif // defined(GL_NVX_conditional_render)
#if defined(GL_NVX_linked_gpu_multicast)
#ifndef glLGPUCopyImageSubDataNVX
#define glLGPUCopyImageSubDataNVX(sourceGpu, destinationGpuMask, srcName, srcTarget, srcLevel, srcX, srxY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth) glatter_glLGPUCopyImageSubDataNVX_debug((sourceGpu), (destinationGpuMask), (srcName), (srcTarget), (srcLevel), (srcX), (srxY), (srcZ), (dstName), (dstTarget), (dstLevel), (dstX), (dstY), (dstZ), (width), (height), (depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLGPUCopyImageSubDataNVX_debug(GLuint sourceGpu, GLbitfield destinationGpuMask, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srxY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line);
#ifndef glLGPUInterlockNVX
#define glLGPUInterlockNVX() glatter_glLGPUInterlockNVX_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLGPUInterlockNVX_debug(const char* file, int line);
#ifndef glLGPUNamedBufferSubDataNVX
#define glLGPUNamedBufferSubDataNVX(gpuMask, buffer, offset, size, data) glatter_glLGPUNamedBufferSubDataNVX_debug((gpuMask), (buffer), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLGPUNamedBufferSubDataNVX_debug(GLbitfield gpuMask, GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line);
#endif // defined(GL_NVX_linked_gpu_multicast)
#if defined(GL_NV_alpha_to_coverage_dither_control)
#ifndef glAlphaToCoverageDitherControlNV
#define glAlphaToCoverageDitherControlNV(mode) glatter_glAlphaToCoverageDitherControlNV_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAlphaToCoverageDitherControlNV_debug(GLenum mode, const char* file, int line);
#endif // defined(GL_NV_alpha_to_coverage_dither_control)
#if defined(GL_NV_bindless_multi_draw_indirect)
#ifndef glMultiDrawArraysIndirectBindlessNV
#define glMultiDrawArraysIndirectBindlessNV(mode, indirect, drawCount, stride, vertexBufferCount) glatter_glMultiDrawArraysIndirectBindlessNV_debug((mode), (indirect), (drawCount), (stride), (vertexBufferCount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectBindlessNV_debug(GLenum mode, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount, const char* file, int line);
#ifndef glMultiDrawElementsIndirectBindlessNV
#define glMultiDrawElementsIndirectBindlessNV(mode, type, indirect, drawCount, stride, vertexBufferCount) glatter_glMultiDrawElementsIndirectBindlessNV_debug((mode), (type), (indirect), (drawCount), (stride), (vertexBufferCount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectBindlessNV_debug(GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount, const char* file, int line);
#endif // defined(GL_NV_bindless_multi_draw_indirect)
#if defined(GL_NV_bindless_multi_draw_indirect_count)
#ifndef glMultiDrawArraysIndirectBindlessCountNV
#define glMultiDrawArraysIndirectBindlessCountNV(mode, indirect, drawCount, maxDrawCount, stride, vertexBufferCount) glatter_glMultiDrawArraysIndirectBindlessCountNV_debug((mode), (indirect), (drawCount), (maxDrawCount), (stride), (vertexBufferCount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectBindlessCountNV_debug(GLenum mode, const void *indirect, GLsizei drawCount, GLsizei maxDrawCount, GLsizei stride, GLint vertexBufferCount, const char* file, int line);
#ifndef glMultiDrawElementsIndirectBindlessCountNV
#define glMultiDrawElementsIndirectBindlessCountNV(mode, type, indirect, drawCount, maxDrawCount, stride, vertexBufferCount) glatter_glMultiDrawElementsIndirectBindlessCountNV_debug((mode), (type), (indirect), (drawCount), (maxDrawCount), (stride), (vertexBufferCount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectBindlessCountNV_debug(GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei maxDrawCount, GLsizei stride, GLint vertexBufferCount, const char* file, int line);
#endif // defined(GL_NV_bindless_multi_draw_indirect_count)
#if defined(GL_NV_bindless_texture)
#ifndef glGetImageHandleNV
#define glGetImageHandleNV(texture, level, layered, layer, format) glatter_glGetImageHandleNV_debug((texture), (level), (layered), (layer), (format), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetImageHandleNV_debug(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format, const char* file, int line);
#ifndef glGetTextureHandleNV
#define glGetTextureHandleNV(texture) glatter_glGetTextureHandleNV_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureHandleNV_debug(GLuint texture, const char* file, int line);
#ifndef glGetTextureSamplerHandleNV
#define glGetTextureSamplerHandleNV(texture, sampler) glatter_glGetTextureSamplerHandleNV_debug((texture), (sampler), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureSamplerHandleNV_debug(GLuint texture, GLuint sampler, const char* file, int line);
#ifndef glIsImageHandleResidentNV
#define glIsImageHandleResidentNV(handle) glatter_glIsImageHandleResidentNV_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsImageHandleResidentNV_debug(GLuint64 handle, const char* file, int line);
#ifndef glIsTextureHandleResidentNV
#define glIsTextureHandleResidentNV(handle) glatter_glIsTextureHandleResidentNV_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTextureHandleResidentNV_debug(GLuint64 handle, const char* file, int line);
#ifndef glMakeImageHandleNonResidentNV
#define glMakeImageHandleNonResidentNV(handle) glatter_glMakeImageHandleNonResidentNV_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleNonResidentNV_debug(GLuint64 handle, const char* file, int line);
#ifndef glMakeImageHandleResidentNV
#define glMakeImageHandleResidentNV(handle, access) glatter_glMakeImageHandleResidentNV_debug((handle), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleResidentNV_debug(GLuint64 handle, GLenum access, const char* file, int line);
#ifndef glMakeTextureHandleNonResidentNV
#define glMakeTextureHandleNonResidentNV(handle) glatter_glMakeTextureHandleNonResidentNV_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleNonResidentNV_debug(GLuint64 handle, const char* file, int line);
#ifndef glMakeTextureHandleResidentNV
#define glMakeTextureHandleResidentNV(handle) glatter_glMakeTextureHandleResidentNV_debug((handle), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleResidentNV_debug(GLuint64 handle, const char* file, int line);
#ifndef glProgramUniformHandleui64NV
#define glProgramUniformHandleui64NV(program, location, value) glatter_glProgramUniformHandleui64NV_debug((program), (location), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64NV_debug(GLuint program, GLint location, GLuint64 value, const char* file, int line);
#ifndef glProgramUniformHandleui64vNV
#define glProgramUniformHandleui64vNV(program, location, count, values) glatter_glProgramUniformHandleui64vNV_debug((program), (location), (count), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *values, const char* file, int line);
#ifndef glUniformHandleui64NV
#define glUniformHandleui64NV(location, value) glatter_glUniformHandleui64NV_debug((location), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64NV_debug(GLint location, GLuint64 value, const char* file, int line);
#ifndef glUniformHandleui64vNV
#define glUniformHandleui64vNV(location, count, value) glatter_glUniformHandleui64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64vNV_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line);
#endif // defined(GL_NV_bindless_texture)
#if defined(GL_NV_blend_equation_advanced)
#ifndef glBlendBarrierNV
#define glBlendBarrierNV() glatter_glBlendBarrierNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendBarrierNV_debug(const char* file, int line);
#ifndef glBlendParameteriNV
#define glBlendParameteriNV(pname, value) glatter_glBlendParameteriNV_debug((pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendParameteriNV_debug(GLenum pname, GLint value, const char* file, int line);
#endif // defined(GL_NV_blend_equation_advanced)
#if defined(GL_NV_clip_space_w_scaling)
#ifndef glViewportPositionWScaleNV
#define glViewportPositionWScaleNV(index, xcoeff, ycoeff) glatter_glViewportPositionWScaleNV_debug((index), (xcoeff), (ycoeff), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glViewportPositionWScaleNV_debug(GLuint index, GLfloat xcoeff, GLfloat ycoeff, const char* file, int line);
#endif // defined(GL_NV_clip_space_w_scaling)
#if defined(GL_NV_command_list)
#ifndef glCallCommandListNV
#define glCallCommandListNV(list) glatter_glCallCommandListNV_debug((list), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCallCommandListNV_debug(GLuint list, const char* file, int line);
#ifndef glCommandListSegmentsNV
#define glCommandListSegmentsNV(list, segments) glatter_glCommandListSegmentsNV_debug((list), (segments), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCommandListSegmentsNV_debug(GLuint list, GLuint segments, const char* file, int line);
#ifndef glCompileCommandListNV
#define glCompileCommandListNV(list) glatter_glCompileCommandListNV_debug((list), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompileCommandListNV_debug(GLuint list, const char* file, int line);
#ifndef glCreateCommandListsNV
#define glCreateCommandListsNV(n, lists) glatter_glCreateCommandListsNV_debug((n), (lists), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateCommandListsNV_debug(GLsizei n, GLuint *lists, const char* file, int line);
#ifndef glCreateStatesNV
#define glCreateStatesNV(n, states) glatter_glCreateStatesNV_debug((n), (states), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateStatesNV_debug(GLsizei n, GLuint *states, const char* file, int line);
#ifndef glDeleteCommandListsNV
#define glDeleteCommandListsNV(n, lists) glatter_glDeleteCommandListsNV_debug((n), (lists), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteCommandListsNV_debug(GLsizei n, const GLuint *lists, const char* file, int line);
#ifndef glDeleteStatesNV
#define glDeleteStatesNV(n, states) glatter_glDeleteStatesNV_debug((n), (states), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteStatesNV_debug(GLsizei n, const GLuint *states, const char* file, int line);
#ifndef glDrawCommandsAddressNV
#define glDrawCommandsAddressNV(primitiveMode, indirects, sizes, count) glatter_glDrawCommandsAddressNV_debug((primitiveMode), (indirects), (sizes), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawCommandsAddressNV_debug(GLenum primitiveMode, const GLuint64 *indirects, const GLsizei *sizes, GLuint count, const char* file, int line);
#ifndef glDrawCommandsNV
#define glDrawCommandsNV(primitiveMode, buffer, indirects, sizes, count) glatter_glDrawCommandsNV_debug((primitiveMode), (buffer), (indirects), (sizes), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawCommandsNV_debug(GLenum primitiveMode, GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, GLuint count, const char* file, int line);
#ifndef glDrawCommandsStatesAddressNV
#define glDrawCommandsStatesAddressNV(indirects, sizes, states, fbos, count) glatter_glDrawCommandsStatesAddressNV_debug((indirects), (sizes), (states), (fbos), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawCommandsStatesAddressNV_debug(const GLuint64 *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count, const char* file, int line);
#ifndef glDrawCommandsStatesNV
#define glDrawCommandsStatesNV(buffer, indirects, sizes, states, fbos, count) glatter_glDrawCommandsStatesNV_debug((buffer), (indirects), (sizes), (states), (fbos), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawCommandsStatesNV_debug(GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count, const char* file, int line);
#ifndef glGetCommandHeaderNV
#define glGetCommandHeaderNV(tokenID, size) glatter_glGetCommandHeaderNV_debug((tokenID), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGetCommandHeaderNV_debug(GLenum tokenID, GLuint size, const char* file, int line);
#ifndef glGetStageIndexNV
#define glGetStageIndexNV(shadertype) glatter_glGetStageIndexNV_debug((shadertype), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLushort glatter_glGetStageIndexNV_debug(GLenum shadertype, const char* file, int line);
#ifndef glIsCommandListNV
#define glIsCommandListNV(list) glatter_glIsCommandListNV_debug((list), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsCommandListNV_debug(GLuint list, const char* file, int line);
#ifndef glIsStateNV
#define glIsStateNV(state) glatter_glIsStateNV_debug((state), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsStateNV_debug(GLuint state, const char* file, int line);
#ifndef glListDrawCommandsStatesClientNV
#define glListDrawCommandsStatesClientNV(list, segment, indirects, sizes, states, fbos, count) glatter_glListDrawCommandsStatesClientNV_debug((list), (segment), (indirects), (sizes), (states), (fbos), (count), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glListDrawCommandsStatesClientNV_debug(GLuint list, GLuint segment, const void **indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count, const char* file, int line);
#ifndef glStateCaptureNV
#define glStateCaptureNV(state, mode) glatter_glStateCaptureNV_debug((state), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStateCaptureNV_debug(GLuint state, GLenum mode, const char* file, int line);
#endif // defined(GL_NV_command_list)
#if defined(GL_NV_conditional_render)
#ifndef glBeginConditionalRenderNV
#define glBeginConditionalRenderNV(id, mode) glatter_glBeginConditionalRenderNV_debug((id), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginConditionalRenderNV_debug(GLuint id, GLenum mode, const char* file, int line);
#ifndef glEndConditionalRenderNV
#define glEndConditionalRenderNV() glatter_glEndConditionalRenderNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndConditionalRenderNV_debug(const char* file, int line);
#endif // defined(GL_NV_conditional_render)
#if defined(GL_NV_conservative_raster)
#ifndef glSubpixelPrecisionBiasNV
#define glSubpixelPrecisionBiasNV(xbits, ybits) glatter_glSubpixelPrecisionBiasNV_debug((xbits), (ybits), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSubpixelPrecisionBiasNV_debug(GLuint xbits, GLuint ybits, const char* file, int line);
#endif // defined(GL_NV_conservative_raster)
#if defined(GL_NV_conservative_raster_dilate)
#ifndef glConservativeRasterParameterfNV
#define glConservativeRasterParameterfNV(pname, value) glatter_glConservativeRasterParameterfNV_debug((pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConservativeRasterParameterfNV_debug(GLenum pname, GLfloat value, const char* file, int line);
#endif // defined(GL_NV_conservative_raster_dilate)
#if defined(GL_NV_conservative_raster_pre_snap_triangles)
#ifndef glConservativeRasterParameteriNV
#define glConservativeRasterParameteriNV(pname, param) glatter_glConservativeRasterParameteriNV_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConservativeRasterParameteriNV_debug(GLenum pname, GLint param, const char* file, int line);
#endif // defined(GL_NV_conservative_raster_pre_snap_triangles)
#if defined(GL_NV_copy_image)
#ifndef glCopyImageSubDataNV
#define glCopyImageSubDataNV(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth) glatter_glCopyImageSubDataNV_debug((srcName), (srcTarget), (srcLevel), (srcX), (srcY), (srcZ), (dstName), (dstTarget), (dstLevel), (dstX), (dstY), (dstZ), (width), (height), (depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyImageSubDataNV_debug(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line);
#endif // defined(GL_NV_copy_image)
#if defined(GL_NV_depth_buffer_float)
#ifndef glClearDepthdNV
#define glClearDepthdNV(depth) glatter_glClearDepthdNV_debug((depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearDepthdNV_debug(GLdouble depth, const char* file, int line);
#ifndef glDepthBoundsdNV
#define glDepthBoundsdNV(zmin, zmax) glatter_glDepthBoundsdNV_debug((zmin), (zmax), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthBoundsdNV_debug(GLdouble zmin, GLdouble zmax, const char* file, int line);
#ifndef glDepthRangedNV
#define glDepthRangedNV(zNear, zFar) glatter_glDepthRangedNV_debug((zNear), (zFar), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthRangedNV_debug(GLdouble zNear, GLdouble zFar, const char* file, int line);
#endif // defined(GL_NV_depth_buffer_float)
#if defined(GL_NV_draw_texture)
#ifndef glDrawTextureNV
#define glDrawTextureNV(texture, sampler, x0, y0, x1, y1, z, s0, t0, s1, t1) glatter_glDrawTextureNV_debug((texture), (sampler), (x0), (y0), (x1), (y1), (z), (s0), (t0), (s1), (t1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawTextureNV_debug(GLuint texture, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1, const char* file, int line);
#endif // defined(GL_NV_draw_texture)
#if defined(GL_NV_draw_vulkan_image)
#ifndef glDrawVkImageNV
#define glDrawVkImageNV(vkImage, sampler, x0, y0, x1, y1, z, s0, t0, s1, t1) glatter_glDrawVkImageNV_debug((vkImage), (sampler), (x0), (y0), (x1), (y1), (z), (s0), (t0), (s1), (t1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawVkImageNV_debug(GLuint64 vkImage, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1, const char* file, int line);
#ifndef glGetVkProcAddrNV
#define glGetVkProcAddrNV(name) glatter_glGetVkProcAddrNV_debug((name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLVULKANPROCNV glatter_glGetVkProcAddrNV_debug(const GLchar *name, const char* file, int line);
#ifndef glSignalVkFenceNV
#define glSignalVkFenceNV(vkFence) glatter_glSignalVkFenceNV_debug((vkFence), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSignalVkFenceNV_debug(GLuint64 vkFence, const char* file, int line);
#ifndef glSignalVkSemaphoreNV
#define glSignalVkSemaphoreNV(vkSemaphore) glatter_glSignalVkSemaphoreNV_debug((vkSemaphore), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSignalVkSemaphoreNV_debug(GLuint64 vkSemaphore, const char* file, int line);
#ifndef glWaitVkSemaphoreNV
#define glWaitVkSemaphoreNV(vkSemaphore) glatter_glWaitVkSemaphoreNV_debug((vkSemaphore), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWaitVkSemaphoreNV_debug(GLuint64 vkSemaphore, const char* file, int line);
#endif // defined(GL_NV_draw_vulkan_image)
#if defined(GL_NV_evaluators)
#ifndef glEvalMapsNV
#define glEvalMapsNV(target, mode) glatter_glEvalMapsNV_debug((target), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalMapsNV_debug(GLenum target, GLenum mode, const char* file, int line);
#ifndef glGetMapAttribParameterfvNV
#define glGetMapAttribParameterfvNV(target, index, pname, params) glatter_glGetMapAttribParameterfvNV_debug((target), (index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMapAttribParameterfvNV_debug(GLenum target, GLuint index, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetMapAttribParameterivNV
#define glGetMapAttribParameterivNV(target, index, pname, params) glatter_glGetMapAttribParameterivNV_debug((target), (index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMapAttribParameterivNV_debug(GLenum target, GLuint index, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetMapControlPointsNV
#define glGetMapControlPointsNV(target, index, type, ustride, vstride, packed, points) glatter_glGetMapControlPointsNV_debug((target), (index), (type), (ustride), (vstride), (packed), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMapControlPointsNV_debug(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, void *points, const char* file, int line);
#ifndef glGetMapParameterfvNV
#define glGetMapParameterfvNV(target, pname, params) glatter_glGetMapParameterfvNV_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMapParameterfvNV_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetMapParameterivNV
#define glGetMapParameterivNV(target, pname, params) glatter_glGetMapParameterivNV_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMapParameterivNV_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glMapControlPointsNV
#define glMapControlPointsNV(target, index, type, ustride, vstride, uorder, vorder, packed, points) glatter_glMapControlPointsNV_debug((target), (index), (type), (ustride), (vstride), (uorder), (vorder), (packed), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapControlPointsNV_debug(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const void *points, const char* file, int line);
#ifndef glMapParameterfvNV
#define glMapParameterfvNV(target, pname, params) glatter_glMapParameterfvNV_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapParameterfvNV_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glMapParameterivNV
#define glMapParameterivNV(target, pname, params) glatter_glMapParameterivNV_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapParameterivNV_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#endif // defined(GL_NV_evaluators)
#if defined(GL_NV_explicit_multisample)
#ifndef glGetMultisamplefvNV
#define glGetMultisamplefvNV(pname, index, val) glatter_glGetMultisamplefvNV_debug((pname), (index), (val), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultisamplefvNV_debug(GLenum pname, GLuint index, GLfloat *val, const char* file, int line);
#ifndef glSampleMaskIndexedNV
#define glSampleMaskIndexedNV(index, mask) glatter_glSampleMaskIndexedNV_debug((index), (mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSampleMaskIndexedNV_debug(GLuint index, GLbitfield mask, const char* file, int line);
#ifndef glTexRenderbufferNV
#define glTexRenderbufferNV(target, renderbuffer) glatter_glTexRenderbufferNV_debug((target), (renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexRenderbufferNV_debug(GLenum target, GLuint renderbuffer, const char* file, int line);
#endif // defined(GL_NV_explicit_multisample)
#if defined(GL_NV_fence)
#ifndef glDeleteFencesNV
#define glDeleteFencesNV(n, fences) glatter_glDeleteFencesNV_debug((n), (fences), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteFencesNV_debug(GLsizei n, const GLuint *fences, const char* file, int line);
#ifndef glFinishFenceNV
#define glFinishFenceNV(fence) glatter_glFinishFenceNV_debug((fence), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFinishFenceNV_debug(GLuint fence, const char* file, int line);
#ifndef glGenFencesNV
#define glGenFencesNV(n, fences) glatter_glGenFencesNV_debug((n), (fences), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenFencesNV_debug(GLsizei n, GLuint *fences, const char* file, int line);
#ifndef glGetFenceivNV
#define glGetFenceivNV(fence, pname, params) glatter_glGetFenceivNV_debug((fence), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFenceivNV_debug(GLuint fence, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsFenceNV
#define glIsFenceNV(fence) glatter_glIsFenceNV_debug((fence), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFenceNV_debug(GLuint fence, const char* file, int line);
#ifndef glSetFenceNV
#define glSetFenceNV(fence, condition) glatter_glSetFenceNV_debug((fence), (condition), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSetFenceNV_debug(GLuint fence, GLenum condition, const char* file, int line);
#ifndef glTestFenceNV
#define glTestFenceNV(fence) glatter_glTestFenceNV_debug((fence), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glTestFenceNV_debug(GLuint fence, const char* file, int line);
#endif // defined(GL_NV_fence)
#if defined(GL_NV_fragment_coverage_to_color)
#ifndef glFragmentCoverageColorNV
#define glFragmentCoverageColorNV(color) glatter_glFragmentCoverageColorNV_debug((color), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentCoverageColorNV_debug(GLuint color, const char* file, int line);
#endif // defined(GL_NV_fragment_coverage_to_color)
#if defined(GL_NV_fragment_program)
#ifndef glGetProgramNamedParameterdvNV
#define glGetProgramNamedParameterdvNV(id, len, name, params) glatter_glGetProgramNamedParameterdvNV_debug((id), (len), (name), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramNamedParameterdvNV_debug(GLuint id, GLsizei len, const GLubyte *name, GLdouble *params, const char* file, int line);
#ifndef glGetProgramNamedParameterfvNV
#define glGetProgramNamedParameterfvNV(id, len, name, params) glatter_glGetProgramNamedParameterfvNV_debug((id), (len), (name), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramNamedParameterfvNV_debug(GLuint id, GLsizei len, const GLubyte *name, GLfloat *params, const char* file, int line);
#ifndef glProgramNamedParameter4dNV
#define glProgramNamedParameter4dNV(id, len, name, x, y, z, w) glatter_glProgramNamedParameter4dNV_debug((id), (len), (name), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramNamedParameter4dNV_debug(GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glProgramNamedParameter4dvNV
#define glProgramNamedParameter4dvNV(id, len, name, v) glatter_glProgramNamedParameter4dvNV_debug((id), (len), (name), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramNamedParameter4dvNV_debug(GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v, const char* file, int line);
#ifndef glProgramNamedParameter4fNV
#define glProgramNamedParameter4fNV(id, len, name, x, y, z, w) glatter_glProgramNamedParameter4fNV_debug((id), (len), (name), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramNamedParameter4fNV_debug(GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glProgramNamedParameter4fvNV
#define glProgramNamedParameter4fvNV(id, len, name, v) glatter_glProgramNamedParameter4fvNV_debug((id), (len), (name), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramNamedParameter4fvNV_debug(GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v, const char* file, int line);
#endif // defined(GL_NV_fragment_program)
#if defined(GL_NV_framebuffer_mixed_samples)
#ifndef glCoverageModulationNV
#define glCoverageModulationNV(components) glatter_glCoverageModulationNV_debug((components), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCoverageModulationNV_debug(GLenum components, const char* file, int line);
#ifndef glCoverageModulationTableNV
#define glCoverageModulationTableNV(n, v) glatter_glCoverageModulationTableNV_debug((n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCoverageModulationTableNV_debug(GLsizei n, const GLfloat *v, const char* file, int line);
#ifndef glGetCoverageModulationTableNV
#define glGetCoverageModulationTableNV(bufsize, v) glatter_glGetCoverageModulationTableNV_debug((bufsize), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCoverageModulationTableNV_debug(GLsizei bufsize, GLfloat *v, const char* file, int line);
#endif // defined(GL_NV_framebuffer_mixed_samples)
#if defined(GL_NV_framebuffer_multisample_coverage)
#ifndef glRenderbufferStorageMultisampleCoverageNV
#define glRenderbufferStorageMultisampleCoverageNV(target, coverageSamples, colorSamples, internalformat, width, height) glatter_glRenderbufferStorageMultisampleCoverageNV_debug((target), (coverageSamples), (colorSamples), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleCoverageNV_debug(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#endif // defined(GL_NV_framebuffer_multisample_coverage)
#if defined(GL_NV_geometry_program4)
#ifndef glFramebufferTextureEXT
#define glFramebufferTextureEXT(target, attachment, texture, level) glatter_glFramebufferTextureEXT_debug((target), (attachment), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureEXT_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, const char* file, int line);
#ifndef glFramebufferTextureFaceEXT
#define glFramebufferTextureFaceEXT(target, attachment, texture, level, face) glatter_glFramebufferTextureFaceEXT_debug((target), (attachment), (texture), (level), (face), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureFaceEXT_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face, const char* file, int line);
#ifndef glProgramVertexLimitNV
#define glProgramVertexLimitNV(target, limit) glatter_glProgramVertexLimitNV_debug((target), (limit), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramVertexLimitNV_debug(GLenum target, GLint limit, const char* file, int line);
#endif // defined(GL_NV_geometry_program4)
#if defined(GL_NV_gpu_multicast)
#ifndef glMulticastBarrierNV
#define glMulticastBarrierNV() glatter_glMulticastBarrierNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastBarrierNV_debug(const char* file, int line);
#ifndef glMulticastBlitFramebufferNV
#define glMulticastBlitFramebufferNV(srcGpu, dstGpu, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter) glatter_glMulticastBlitFramebufferNV_debug((srcGpu), (dstGpu), (srcX0), (srcY0), (srcX1), (srcY1), (dstX0), (dstY0), (dstX1), (dstY1), (mask), (filter), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastBlitFramebufferNV_debug(GLuint srcGpu, GLuint dstGpu, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter, const char* file, int line);
#ifndef glMulticastBufferSubDataNV
#define glMulticastBufferSubDataNV(gpuMask, buffer, offset, size, data) glatter_glMulticastBufferSubDataNV_debug((gpuMask), (buffer), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastBufferSubDataNV_debug(GLbitfield gpuMask, GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line);
#ifndef glMulticastCopyBufferSubDataNV
#define glMulticastCopyBufferSubDataNV(readGpu, writeGpuMask, readBuffer, writeBuffer, readOffset, writeOffset, size) glatter_glMulticastCopyBufferSubDataNV_debug((readGpu), (writeGpuMask), (readBuffer), (writeBuffer), (readOffset), (writeOffset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastCopyBufferSubDataNV_debug(GLuint readGpu, GLbitfield writeGpuMask, GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size, const char* file, int line);
#ifndef glMulticastCopyImageSubDataNV
#define glMulticastCopyImageSubDataNV(srcGpu, dstGpuMask, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth) glatter_glMulticastCopyImageSubDataNV_debug((srcGpu), (dstGpuMask), (srcName), (srcTarget), (srcLevel), (srcX), (srcY), (srcZ), (dstName), (dstTarget), (dstLevel), (dstX), (dstY), (dstZ), (srcWidth), (srcHeight), (srcDepth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastCopyImageSubDataNV_debug(GLuint srcGpu, GLbitfield dstGpuMask, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth, const char* file, int line);
#ifndef glMulticastFramebufferSampleLocationsfvNV
#define glMulticastFramebufferSampleLocationsfvNV(gpu, framebuffer, start, count, v) glatter_glMulticastFramebufferSampleLocationsfvNV_debug((gpu), (framebuffer), (start), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastFramebufferSampleLocationsfvNV_debug(GLuint gpu, GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glMulticastGetQueryObjecti64vNV
#define glMulticastGetQueryObjecti64vNV(gpu, id, pname, params) glatter_glMulticastGetQueryObjecti64vNV_debug((gpu), (id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastGetQueryObjecti64vNV_debug(GLuint gpu, GLuint id, GLenum pname, GLint64 *params, const char* file, int line);
#ifndef glMulticastGetQueryObjectivNV
#define glMulticastGetQueryObjectivNV(gpu, id, pname, params) glatter_glMulticastGetQueryObjectivNV_debug((gpu), (id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastGetQueryObjectivNV_debug(GLuint gpu, GLuint id, GLenum pname, GLint *params, const char* file, int line);
#ifndef glMulticastGetQueryObjectui64vNV
#define glMulticastGetQueryObjectui64vNV(gpu, id, pname, params) glatter_glMulticastGetQueryObjectui64vNV_debug((gpu), (id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastGetQueryObjectui64vNV_debug(GLuint gpu, GLuint id, GLenum pname, GLuint64 *params, const char* file, int line);
#ifndef glMulticastGetQueryObjectuivNV
#define glMulticastGetQueryObjectuivNV(gpu, id, pname, params) glatter_glMulticastGetQueryObjectuivNV_debug((gpu), (id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastGetQueryObjectuivNV_debug(GLuint gpu, GLuint id, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glMulticastWaitSyncNV
#define glMulticastWaitSyncNV(signalGpu, waitGpuMask) glatter_glMulticastWaitSyncNV_debug((signalGpu), (waitGpuMask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMulticastWaitSyncNV_debug(GLuint signalGpu, GLbitfield waitGpuMask, const char* file, int line);
#ifndef glRenderGpuMaskNV
#define glRenderGpuMaskNV(mask) glatter_glRenderGpuMaskNV_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRenderGpuMaskNV_debug(GLbitfield mask, const char* file, int line);
#endif // defined(GL_NV_gpu_multicast)
#if defined(GL_NV_gpu_program4)
#ifndef glGetProgramEnvParameterIivNV
#define glGetProgramEnvParameterIivNV(target, index, params) glatter_glGetProgramEnvParameterIivNV_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramEnvParameterIivNV_debug(GLenum target, GLuint index, GLint *params, const char* file, int line);
#ifndef glGetProgramEnvParameterIuivNV
#define glGetProgramEnvParameterIuivNV(target, index, params) glatter_glGetProgramEnvParameterIuivNV_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramEnvParameterIuivNV_debug(GLenum target, GLuint index, GLuint *params, const char* file, int line);
#ifndef glGetProgramLocalParameterIivNV
#define glGetProgramLocalParameterIivNV(target, index, params) glatter_glGetProgramLocalParameterIivNV_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramLocalParameterIivNV_debug(GLenum target, GLuint index, GLint *params, const char* file, int line);
#ifndef glGetProgramLocalParameterIuivNV
#define glGetProgramLocalParameterIuivNV(target, index, params) glatter_glGetProgramLocalParameterIuivNV_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramLocalParameterIuivNV_debug(GLenum target, GLuint index, GLuint *params, const char* file, int line);
#ifndef glProgramEnvParameterI4iNV
#define glProgramEnvParameterI4iNV(target, index, x, y, z, w) glatter_glProgramEnvParameterI4iNV_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameterI4iNV_debug(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w, const char* file, int line);
#ifndef glProgramEnvParameterI4ivNV
#define glProgramEnvParameterI4ivNV(target, index, params) glatter_glProgramEnvParameterI4ivNV_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameterI4ivNV_debug(GLenum target, GLuint index, const GLint *params, const char* file, int line);
#ifndef glProgramEnvParameterI4uiNV
#define glProgramEnvParameterI4uiNV(target, index, x, y, z, w) glatter_glProgramEnvParameterI4uiNV_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameterI4uiNV_debug(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w, const char* file, int line);
#ifndef glProgramEnvParameterI4uivNV
#define glProgramEnvParameterI4uivNV(target, index, params) glatter_glProgramEnvParameterI4uivNV_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameterI4uivNV_debug(GLenum target, GLuint index, const GLuint *params, const char* file, int line);
#ifndef glProgramEnvParametersI4ivNV
#define glProgramEnvParametersI4ivNV(target, index, count, params) glatter_glProgramEnvParametersI4ivNV_debug((target), (index), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParametersI4ivNV_debug(GLenum target, GLuint index, GLsizei count, const GLint *params, const char* file, int line);
#ifndef glProgramEnvParametersI4uivNV
#define glProgramEnvParametersI4uivNV(target, index, count, params) glatter_glProgramEnvParametersI4uivNV_debug((target), (index), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParametersI4uivNV_debug(GLenum target, GLuint index, GLsizei count, const GLuint *params, const char* file, int line);
#ifndef glProgramLocalParameterI4iNV
#define glProgramLocalParameterI4iNV(target, index, x, y, z, w) glatter_glProgramLocalParameterI4iNV_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameterI4iNV_debug(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w, const char* file, int line);
#ifndef glProgramLocalParameterI4ivNV
#define glProgramLocalParameterI4ivNV(target, index, params) glatter_glProgramLocalParameterI4ivNV_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameterI4ivNV_debug(GLenum target, GLuint index, const GLint *params, const char* file, int line);
#ifndef glProgramLocalParameterI4uiNV
#define glProgramLocalParameterI4uiNV(target, index, x, y, z, w) glatter_glProgramLocalParameterI4uiNV_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameterI4uiNV_debug(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w, const char* file, int line);
#ifndef glProgramLocalParameterI4uivNV
#define glProgramLocalParameterI4uivNV(target, index, params) glatter_glProgramLocalParameterI4uivNV_debug((target), (index), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameterI4uivNV_debug(GLenum target, GLuint index, const GLuint *params, const char* file, int line);
#ifndef glProgramLocalParametersI4ivNV
#define glProgramLocalParametersI4ivNV(target, index, count, params) glatter_glProgramLocalParametersI4ivNV_debug((target), (index), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParametersI4ivNV_debug(GLenum target, GLuint index, GLsizei count, const GLint *params, const char* file, int line);
#ifndef glProgramLocalParametersI4uivNV
#define glProgramLocalParametersI4uivNV(target, index, count, params) glatter_glProgramLocalParametersI4uivNV_debug((target), (index), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParametersI4uivNV_debug(GLenum target, GLuint index, GLsizei count, const GLuint *params, const char* file, int line);
#endif // defined(GL_NV_gpu_program4)
#if defined(GL_NV_gpu_program5)
#ifndef glGetProgramSubroutineParameteruivNV
#define glGetProgramSubroutineParameteruivNV(target, index, param) glatter_glGetProgramSubroutineParameteruivNV_debug((target), (index), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramSubroutineParameteruivNV_debug(GLenum target, GLuint index, GLuint *param, const char* file, int line);
#ifndef glProgramSubroutineParametersuivNV
#define glProgramSubroutineParametersuivNV(target, count, params) glatter_glProgramSubroutineParametersuivNV_debug((target), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramSubroutineParametersuivNV_debug(GLenum target, GLsizei count, const GLuint *params, const char* file, int line);
#endif // defined(GL_NV_gpu_program5)
#if defined(GL_NV_half_float)
#ifndef glColor3hNV
#define glColor3hNV(red, green, blue) glatter_glColor3hNV_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3hNV_debug(GLhalfNV red, GLhalfNV green, GLhalfNV blue, const char* file, int line);
#ifndef glColor3hvNV
#define glColor3hvNV(v) glatter_glColor3hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glColor4hNV
#define glColor4hNV(red, green, blue, alpha) glatter_glColor4hNV_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4hNV_debug(GLhalfNV red, GLhalfNV green, GLhalfNV blue, GLhalfNV alpha, const char* file, int line);
#ifndef glColor4hvNV
#define glColor4hvNV(v) glatter_glColor4hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glFogCoordhNV
#define glFogCoordhNV(fog) glatter_glFogCoordhNV_debug((fog), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordhNV_debug(GLhalfNV fog, const char* file, int line);
#ifndef glFogCoordhvNV
#define glFogCoordhvNV(fog) glatter_glFogCoordhvNV_debug((fog), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordhvNV_debug(const GLhalfNV *fog, const char* file, int line);
#ifndef glMultiTexCoord1hNV
#define glMultiTexCoord1hNV(target, s) glatter_glMultiTexCoord1hNV_debug((target), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1hNV_debug(GLenum target, GLhalfNV s, const char* file, int line);
#ifndef glMultiTexCoord1hvNV
#define glMultiTexCoord1hvNV(target, v) glatter_glMultiTexCoord1hvNV_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1hvNV_debug(GLenum target, const GLhalfNV *v, const char* file, int line);
#ifndef glMultiTexCoord2hNV
#define glMultiTexCoord2hNV(target, s, t) glatter_glMultiTexCoord2hNV_debug((target), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2hNV_debug(GLenum target, GLhalfNV s, GLhalfNV t, const char* file, int line);
#ifndef glMultiTexCoord2hvNV
#define glMultiTexCoord2hvNV(target, v) glatter_glMultiTexCoord2hvNV_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2hvNV_debug(GLenum target, const GLhalfNV *v, const char* file, int line);
#ifndef glMultiTexCoord3hNV
#define glMultiTexCoord3hNV(target, s, t, r) glatter_glMultiTexCoord3hNV_debug((target), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3hNV_debug(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, const char* file, int line);
#ifndef glMultiTexCoord3hvNV
#define glMultiTexCoord3hvNV(target, v) glatter_glMultiTexCoord3hvNV_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3hvNV_debug(GLenum target, const GLhalfNV *v, const char* file, int line);
#ifndef glMultiTexCoord4hNV
#define glMultiTexCoord4hNV(target, s, t, r, q) glatter_glMultiTexCoord4hNV_debug((target), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4hNV_debug(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q, const char* file, int line);
#ifndef glMultiTexCoord4hvNV
#define glMultiTexCoord4hvNV(target, v) glatter_glMultiTexCoord4hvNV_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4hvNV_debug(GLenum target, const GLhalfNV *v, const char* file, int line);
#ifndef glNormal3hNV
#define glNormal3hNV(nx, ny, nz) glatter_glNormal3hNV_debug((nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3hNV_debug(GLhalfNV nx, GLhalfNV ny, GLhalfNV nz, const char* file, int line);
#ifndef glNormal3hvNV
#define glNormal3hvNV(v) glatter_glNormal3hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glSecondaryColor3hNV
#define glSecondaryColor3hNV(red, green, blue) glatter_glSecondaryColor3hNV_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3hNV_debug(GLhalfNV red, GLhalfNV green, GLhalfNV blue, const char* file, int line);
#ifndef glSecondaryColor3hvNV
#define glSecondaryColor3hvNV(v) glatter_glSecondaryColor3hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glTexCoord1hNV
#define glTexCoord1hNV(s) glatter_glTexCoord1hNV_debug((s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1hNV_debug(GLhalfNV s, const char* file, int line);
#ifndef glTexCoord1hvNV
#define glTexCoord1hvNV(v) glatter_glTexCoord1hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glTexCoord2hNV
#define glTexCoord2hNV(s, t) glatter_glTexCoord2hNV_debug((s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2hNV_debug(GLhalfNV s, GLhalfNV t, const char* file, int line);
#ifndef glTexCoord2hvNV
#define glTexCoord2hvNV(v) glatter_glTexCoord2hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glTexCoord3hNV
#define glTexCoord3hNV(s, t, r) glatter_glTexCoord3hNV_debug((s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3hNV_debug(GLhalfNV s, GLhalfNV t, GLhalfNV r, const char* file, int line);
#ifndef glTexCoord3hvNV
#define glTexCoord3hvNV(v) glatter_glTexCoord3hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glTexCoord4hNV
#define glTexCoord4hNV(s, t, r, q) glatter_glTexCoord4hNV_debug((s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4hNV_debug(GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q, const char* file, int line);
#ifndef glTexCoord4hvNV
#define glTexCoord4hvNV(v) glatter_glTexCoord4hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glVertex2hNV
#define glVertex2hNV(x, y) glatter_glVertex2hNV_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2hNV_debug(GLhalfNV x, GLhalfNV y, const char* file, int line);
#ifndef glVertex2hvNV
#define glVertex2hvNV(v) glatter_glVertex2hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glVertex3hNV
#define glVertex3hNV(x, y, z) glatter_glVertex3hNV_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3hNV_debug(GLhalfNV x, GLhalfNV y, GLhalfNV z, const char* file, int line);
#ifndef glVertex3hvNV
#define glVertex3hvNV(v) glatter_glVertex3hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glVertex4hNV
#define glVertex4hNV(x, y, z, w) glatter_glVertex4hNV_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4hNV_debug(GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w, const char* file, int line);
#ifndef glVertex4hvNV
#define glVertex4hvNV(v) glatter_glVertex4hvNV_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4hvNV_debug(const GLhalfNV *v, const char* file, int line);
#ifndef glVertexAttrib1hNV
#define glVertexAttrib1hNV(index, x) glatter_glVertexAttrib1hNV_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1hNV_debug(GLuint index, GLhalfNV x, const char* file, int line);
#ifndef glVertexAttrib1hvNV
#define glVertexAttrib1hvNV(index, v) glatter_glVertexAttrib1hvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1hvNV_debug(GLuint index, const GLhalfNV *v, const char* file, int line);
#ifndef glVertexAttrib2hNV
#define glVertexAttrib2hNV(index, x, y) glatter_glVertexAttrib2hNV_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2hNV_debug(GLuint index, GLhalfNV x, GLhalfNV y, const char* file, int line);
#ifndef glVertexAttrib2hvNV
#define glVertexAttrib2hvNV(index, v) glatter_glVertexAttrib2hvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2hvNV_debug(GLuint index, const GLhalfNV *v, const char* file, int line);
#ifndef glVertexAttrib3hNV
#define glVertexAttrib3hNV(index, x, y, z) glatter_glVertexAttrib3hNV_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3hNV_debug(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, const char* file, int line);
#ifndef glVertexAttrib3hvNV
#define glVertexAttrib3hvNV(index, v) glatter_glVertexAttrib3hvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3hvNV_debug(GLuint index, const GLhalfNV *v, const char* file, int line);
#ifndef glVertexAttrib4hNV
#define glVertexAttrib4hNV(index, x, y, z, w) glatter_glVertexAttrib4hNV_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4hNV_debug(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w, const char* file, int line);
#ifndef glVertexAttrib4hvNV
#define glVertexAttrib4hvNV(index, v) glatter_glVertexAttrib4hvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4hvNV_debug(GLuint index, const GLhalfNV *v, const char* file, int line);
#ifndef glVertexAttribs1hvNV
#define glVertexAttribs1hvNV(index, n, v) glatter_glVertexAttribs1hvNV_debug((index), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs1hvNV_debug(GLuint index, GLsizei n, const GLhalfNV *v, const char* file, int line);
#ifndef glVertexAttribs2hvNV
#define glVertexAttribs2hvNV(index, n, v) glatter_glVertexAttribs2hvNV_debug((index), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs2hvNV_debug(GLuint index, GLsizei n, const GLhalfNV *v, const char* file, int line);
#ifndef glVertexAttribs3hvNV
#define glVertexAttribs3hvNV(index, n, v) glatter_glVertexAttribs3hvNV_debug((index), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs3hvNV_debug(GLuint index, GLsizei n, const GLhalfNV *v, const char* file, int line);
#ifndef glVertexAttribs4hvNV
#define glVertexAttribs4hvNV(index, n, v) glatter_glVertexAttribs4hvNV_debug((index), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs4hvNV_debug(GLuint index, GLsizei n, const GLhalfNV *v, const char* file, int line);
#ifndef glVertexWeighthNV
#define glVertexWeighthNV(weight) glatter_glVertexWeighthNV_debug((weight), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexWeighthNV_debug(GLhalfNV weight, const char* file, int line);
#ifndef glVertexWeighthvNV
#define glVertexWeighthvNV(weight) glatter_glVertexWeighthvNV_debug((weight), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexWeighthvNV_debug(const GLhalfNV *weight, const char* file, int line);
#endif // defined(GL_NV_half_float)
#if defined(GL_NV_internalformat_sample_query)
#ifndef glGetInternalformatSampleivNV
#define glGetInternalformatSampleivNV(target, internalformat, samples, pname, bufSize, params) glatter_glGetInternalformatSampleivNV_debug((target), (internalformat), (samples), (pname), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetInternalformatSampleivNV_debug(GLenum target, GLenum internalformat, GLsizei samples, GLenum pname, GLsizei bufSize, GLint *params, const char* file, int line);
#endif // defined(GL_NV_internalformat_sample_query)
#if defined(GL_NV_occlusion_query)
#ifndef glBeginOcclusionQueryNV
#define glBeginOcclusionQueryNV(id) glatter_glBeginOcclusionQueryNV_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginOcclusionQueryNV_debug(GLuint id, const char* file, int line);
#ifndef glDeleteOcclusionQueriesNV
#define glDeleteOcclusionQueriesNV(n, ids) glatter_glDeleteOcclusionQueriesNV_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteOcclusionQueriesNV_debug(GLsizei n, const GLuint *ids, const char* file, int line);
#ifndef glEndOcclusionQueryNV
#define glEndOcclusionQueryNV() glatter_glEndOcclusionQueryNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndOcclusionQueryNV_debug(const char* file, int line);
#ifndef glGenOcclusionQueriesNV
#define glGenOcclusionQueriesNV(n, ids) glatter_glGenOcclusionQueriesNV_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenOcclusionQueriesNV_debug(GLsizei n, GLuint *ids, const char* file, int line);
#ifndef glGetOcclusionQueryivNV
#define glGetOcclusionQueryivNV(id, pname, params) glatter_glGetOcclusionQueryivNV_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetOcclusionQueryivNV_debug(GLuint id, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetOcclusionQueryuivNV
#define glGetOcclusionQueryuivNV(id, pname, params) glatter_glGetOcclusionQueryuivNV_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetOcclusionQueryuivNV_debug(GLuint id, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glIsOcclusionQueryNV
#define glIsOcclusionQueryNV(id) glatter_glIsOcclusionQueryNV_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsOcclusionQueryNV_debug(GLuint id, const char* file, int line);
#endif // defined(GL_NV_occlusion_query)
#if defined(GL_NV_parameter_buffer_object)
#ifndef glProgramBufferParametersIivNV
#define glProgramBufferParametersIivNV(target, bindingIndex, wordIndex, count, params) glatter_glProgramBufferParametersIivNV_debug((target), (bindingIndex), (wordIndex), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramBufferParametersIivNV_debug(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLint *params, const char* file, int line);
#ifndef glProgramBufferParametersIuivNV
#define glProgramBufferParametersIuivNV(target, bindingIndex, wordIndex, count, params) glatter_glProgramBufferParametersIuivNV_debug((target), (bindingIndex), (wordIndex), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramBufferParametersIuivNV_debug(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLuint *params, const char* file, int line);
#ifndef glProgramBufferParametersfvNV
#define glProgramBufferParametersfvNV(target, bindingIndex, wordIndex, count, params) glatter_glProgramBufferParametersfvNV_debug((target), (bindingIndex), (wordIndex), (count), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramBufferParametersfvNV_debug(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLfloat *params, const char* file, int line);
#endif // defined(GL_NV_parameter_buffer_object)
#if defined(GL_NV_path_rendering)
#ifndef glCopyPathNV
#define glCopyPathNV(resultPath, srcPath) glatter_glCopyPathNV_debug((resultPath), (srcPath), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyPathNV_debug(GLuint resultPath, GLuint srcPath, const char* file, int line);
#ifndef glCoverFillPathInstancedNV
#define glCoverFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues) glatter_glCoverFillPathInstancedNV_debug((numPaths), (pathNameType), (paths), (pathBase), (coverMode), (transformType), (transformValues), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCoverFillPathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line);
#ifndef glCoverFillPathNV
#define glCoverFillPathNV(path, coverMode) glatter_glCoverFillPathNV_debug((path), (coverMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCoverFillPathNV_debug(GLuint path, GLenum coverMode, const char* file, int line);
#ifndef glCoverStrokePathInstancedNV
#define glCoverStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues) glatter_glCoverStrokePathInstancedNV_debug((numPaths), (pathNameType), (paths), (pathBase), (coverMode), (transformType), (transformValues), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCoverStrokePathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line);
#ifndef glCoverStrokePathNV
#define glCoverStrokePathNV(path, coverMode) glatter_glCoverStrokePathNV_debug((path), (coverMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCoverStrokePathNV_debug(GLuint path, GLenum coverMode, const char* file, int line);
#ifndef glDeletePathsNV
#define glDeletePathsNV(path, range) glatter_glDeletePathsNV_debug((path), (range), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeletePathsNV_debug(GLuint path, GLsizei range, const char* file, int line);
#ifndef glGenPathsNV
#define glGenPathsNV(range) glatter_glGenPathsNV_debug((range), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGenPathsNV_debug(GLsizei range, const char* file, int line);
#ifndef glGetPathColorGenfvNV
#define glGetPathColorGenfvNV(color, pname, value) glatter_glGetPathColorGenfvNV_debug((color), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathColorGenfvNV_debug(GLenum color, GLenum pname, GLfloat *value, const char* file, int line);
#ifndef glGetPathColorGenivNV
#define glGetPathColorGenivNV(color, pname, value) glatter_glGetPathColorGenivNV_debug((color), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathColorGenivNV_debug(GLenum color, GLenum pname, GLint *value, const char* file, int line);
#ifndef glGetPathCommandsNV
#define glGetPathCommandsNV(path, commands) glatter_glGetPathCommandsNV_debug((path), (commands), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathCommandsNV_debug(GLuint path, GLubyte *commands, const char* file, int line);
#ifndef glGetPathCoordsNV
#define glGetPathCoordsNV(path, coords) glatter_glGetPathCoordsNV_debug((path), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathCoordsNV_debug(GLuint path, GLfloat *coords, const char* file, int line);
#ifndef glGetPathDashArrayNV
#define glGetPathDashArrayNV(path, dashArray) glatter_glGetPathDashArrayNV_debug((path), (dashArray), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathDashArrayNV_debug(GLuint path, GLfloat *dashArray, const char* file, int line);
#ifndef glGetPathLengthNV
#define glGetPathLengthNV(path, startSegment, numSegments) glatter_glGetPathLengthNV_debug((path), (startSegment), (numSegments), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLfloat glatter_glGetPathLengthNV_debug(GLuint path, GLsizei startSegment, GLsizei numSegments, const char* file, int line);
#ifndef glGetPathMetricRangeNV
#define glGetPathMetricRangeNV(metricQueryMask, firstPathName, numPaths, stride, metrics) glatter_glGetPathMetricRangeNV_debug((metricQueryMask), (firstPathName), (numPaths), (stride), (metrics), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathMetricRangeNV_debug(GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics, const char* file, int line);
#ifndef glGetPathMetricsNV
#define glGetPathMetricsNV(metricQueryMask, numPaths, pathNameType, paths, pathBase, stride, metrics) glatter_glGetPathMetricsNV_debug((metricQueryMask), (numPaths), (pathNameType), (paths), (pathBase), (stride), (metrics), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathMetricsNV_debug(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics, const char* file, int line);
#ifndef glGetPathParameterfvNV
#define glGetPathParameterfvNV(path, pname, value) glatter_glGetPathParameterfvNV_debug((path), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathParameterfvNV_debug(GLuint path, GLenum pname, GLfloat *value, const char* file, int line);
#ifndef glGetPathParameterivNV
#define glGetPathParameterivNV(path, pname, value) glatter_glGetPathParameterivNV_debug((path), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathParameterivNV_debug(GLuint path, GLenum pname, GLint *value, const char* file, int line);
#ifndef glGetPathSpacingNV
#define glGetPathSpacingNV(pathListMode, numPaths, pathNameType, paths, pathBase, advanceScale, kerningScale, transformType, returnedSpacing) glatter_glGetPathSpacingNV_debug((pathListMode), (numPaths), (pathNameType), (paths), (pathBase), (advanceScale), (kerningScale), (transformType), (returnedSpacing), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathSpacingNV_debug(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing, const char* file, int line);
#ifndef glGetPathTexGenfvNV
#define glGetPathTexGenfvNV(texCoordSet, pname, value) glatter_glGetPathTexGenfvNV_debug((texCoordSet), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathTexGenfvNV_debug(GLenum texCoordSet, GLenum pname, GLfloat *value, const char* file, int line);
#ifndef glGetPathTexGenivNV
#define glGetPathTexGenivNV(texCoordSet, pname, value) glatter_glGetPathTexGenivNV_debug((texCoordSet), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPathTexGenivNV_debug(GLenum texCoordSet, GLenum pname, GLint *value, const char* file, int line);
#ifndef glGetProgramResourcefvNV
#define glGetProgramResourcefvNV(program, programInterface, index, propCount, props, bufSize, length, params) glatter_glGetProgramResourcefvNV_debug((program), (programInterface), (index), (propCount), (props), (bufSize), (length), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramResourcefvNV_debug(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLfloat *params, const char* file, int line);
#ifndef glInterpolatePathsNV
#define glInterpolatePathsNV(resultPath, pathA, pathB, weight) glatter_glInterpolatePathsNV_debug((resultPath), (pathA), (pathB), (weight), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInterpolatePathsNV_debug(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight, const char* file, int line);
#ifndef glIsPathNV
#define glIsPathNV(path) glatter_glIsPathNV_debug((path), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsPathNV_debug(GLuint path, const char* file, int line);
#ifndef glIsPointInFillPathNV
#define glIsPointInFillPathNV(path, mask, x, y) glatter_glIsPointInFillPathNV_debug((path), (mask), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsPointInFillPathNV_debug(GLuint path, GLuint mask, GLfloat x, GLfloat y, const char* file, int line);
#ifndef glIsPointInStrokePathNV
#define glIsPointInStrokePathNV(path, x, y) glatter_glIsPointInStrokePathNV_debug((path), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsPointInStrokePathNV_debug(GLuint path, GLfloat x, GLfloat y, const char* file, int line);
#ifndef glMatrixLoad3x2fNV
#define glMatrixLoad3x2fNV(matrixMode, m) glatter_glMatrixLoad3x2fNV_debug((matrixMode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoad3x2fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line);
#ifndef glMatrixLoad3x3fNV
#define glMatrixLoad3x3fNV(matrixMode, m) glatter_glMatrixLoad3x3fNV_debug((matrixMode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoad3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line);
#ifndef glMatrixLoadTranspose3x3fNV
#define glMatrixLoadTranspose3x3fNV(matrixMode, m) glatter_glMatrixLoadTranspose3x3fNV_debug((matrixMode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadTranspose3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line);
#ifndef glMatrixMult3x2fNV
#define glMatrixMult3x2fNV(matrixMode, m) glatter_glMatrixMult3x2fNV_debug((matrixMode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixMult3x2fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line);
#ifndef glMatrixMult3x3fNV
#define glMatrixMult3x3fNV(matrixMode, m) glatter_glMatrixMult3x3fNV_debug((matrixMode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixMult3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line);
#ifndef glMatrixMultTranspose3x3fNV
#define glMatrixMultTranspose3x3fNV(matrixMode, m) glatter_glMatrixMultTranspose3x3fNV_debug((matrixMode), (m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultTranspose3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line);
#ifndef glPathColorGenNV
#define glPathColorGenNV(color, genMode, colorFormat, coeffs) glatter_glPathColorGenNV_debug((color), (genMode), (colorFormat), (coeffs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathColorGenNV_debug(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat *coeffs, const char* file, int line);
#ifndef glPathCommandsNV
#define glPathCommandsNV(path, numCommands, commands, numCoords, coordType, coords) glatter_glPathCommandsNV_debug((path), (numCommands), (commands), (numCoords), (coordType), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathCommandsNV_debug(GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line);
#ifndef glPathCoordsNV
#define glPathCoordsNV(path, numCoords, coordType, coords) glatter_glPathCoordsNV_debug((path), (numCoords), (coordType), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathCoordsNV_debug(GLuint path, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line);
#ifndef glPathCoverDepthFuncNV
#define glPathCoverDepthFuncNV(func) glatter_glPathCoverDepthFuncNV_debug((func), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathCoverDepthFuncNV_debug(GLenum func, const char* file, int line);
#ifndef glPathDashArrayNV
#define glPathDashArrayNV(path, dashCount, dashArray) glatter_glPathDashArrayNV_debug((path), (dashCount), (dashArray), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathDashArrayNV_debug(GLuint path, GLsizei dashCount, const GLfloat *dashArray, const char* file, int line);
#ifndef glPathFogGenNV
#define glPathFogGenNV(genMode) glatter_glPathFogGenNV_debug((genMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathFogGenNV_debug(GLenum genMode, const char* file, int line);
#ifndef glPathGlyphIndexArrayNV
#define glPathGlyphIndexArrayNV(firstPathName, fontTarget, fontName, fontStyle, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale) glatter_glPathGlyphIndexArrayNV_debug((firstPathName), (fontTarget), (fontName), (fontStyle), (firstGlyphIndex), (numGlyphs), (pathParameterTemplate), (emScale), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glPathGlyphIndexArrayNV_debug(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line);
#ifndef glPathGlyphIndexRangeNV
#define glPathGlyphIndexRangeNV(fontTarget, fontName, fontStyle, pathParameterTemplate, emScale, baseAndCount) glatter_glPathGlyphIndexRangeNV_debug((fontTarget), (fontName), (fontStyle), (pathParameterTemplate), (emScale), (baseAndCount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glPathGlyphIndexRangeNV_debug(GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint pathParameterTemplate, GLfloat emScale, GLuint baseAndCount[2], const char* file, int line);
#ifndef glPathGlyphRangeNV
#define glPathGlyphRangeNV(firstPathName, fontTarget, fontName, fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale) glatter_glPathGlyphRangeNV_debug((firstPathName), (fontTarget), (fontName), (fontStyle), (firstGlyph), (numGlyphs), (handleMissingGlyphs), (pathParameterTemplate), (emScale), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathGlyphRangeNV_debug(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line);
#ifndef glPathGlyphsNV
#define glPathGlyphsNV(firstPathName, fontTarget, fontName, fontStyle, numGlyphs, type, charcodes, handleMissingGlyphs, pathParameterTemplate, emScale) glatter_glPathGlyphsNV_debug((firstPathName), (fontTarget), (fontName), (fontStyle), (numGlyphs), (type), (charcodes), (handleMissingGlyphs), (pathParameterTemplate), (emScale), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathGlyphsNV_debug(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const void *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line);
#ifndef glPathMemoryGlyphIndexArrayNV
#define glPathMemoryGlyphIndexArrayNV(firstPathName, fontTarget, fontSize, fontData, faceIndex, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale) glatter_glPathMemoryGlyphIndexArrayNV_debug((firstPathName), (fontTarget), (fontSize), (fontData), (faceIndex), (firstGlyphIndex), (numGlyphs), (pathParameterTemplate), (emScale), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glPathMemoryGlyphIndexArrayNV_debug(GLuint firstPathName, GLenum fontTarget, GLsizeiptr fontSize, const void *fontData, GLsizei faceIndex, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line);
#ifndef glPathParameterfNV
#define glPathParameterfNV(path, pname, value) glatter_glPathParameterfNV_debug((path), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathParameterfNV_debug(GLuint path, GLenum pname, GLfloat value, const char* file, int line);
#ifndef glPathParameterfvNV
#define glPathParameterfvNV(path, pname, value) glatter_glPathParameterfvNV_debug((path), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathParameterfvNV_debug(GLuint path, GLenum pname, const GLfloat *value, const char* file, int line);
#ifndef glPathParameteriNV
#define glPathParameteriNV(path, pname, value) glatter_glPathParameteriNV_debug((path), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathParameteriNV_debug(GLuint path, GLenum pname, GLint value, const char* file, int line);
#ifndef glPathParameterivNV
#define glPathParameterivNV(path, pname, value) glatter_glPathParameterivNV_debug((path), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathParameterivNV_debug(GLuint path, GLenum pname, const GLint *value, const char* file, int line);
#ifndef glPathStencilDepthOffsetNV
#define glPathStencilDepthOffsetNV(factor, units) glatter_glPathStencilDepthOffsetNV_debug((factor), (units), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathStencilDepthOffsetNV_debug(GLfloat factor, GLfloat units, const char* file, int line);
#ifndef glPathStencilFuncNV
#define glPathStencilFuncNV(func, ref, mask) glatter_glPathStencilFuncNV_debug((func), (ref), (mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathStencilFuncNV_debug(GLenum func, GLint ref, GLuint mask, const char* file, int line);
#ifndef glPathStringNV
#define glPathStringNV(path, format, length, pathString) glatter_glPathStringNV_debug((path), (format), (length), (pathString), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathStringNV_debug(GLuint path, GLenum format, GLsizei length, const void *pathString, const char* file, int line);
#ifndef glPathSubCommandsNV
#define glPathSubCommandsNV(path, commandStart, commandsToDelete, numCommands, commands, numCoords, coordType, coords) glatter_glPathSubCommandsNV_debug((path), (commandStart), (commandsToDelete), (numCommands), (commands), (numCoords), (coordType), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathSubCommandsNV_debug(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line);
#ifndef glPathSubCoordsNV
#define glPathSubCoordsNV(path, coordStart, numCoords, coordType, coords) glatter_glPathSubCoordsNV_debug((path), (coordStart), (numCoords), (coordType), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathSubCoordsNV_debug(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line);
#ifndef glPathTexGenNV
#define glPathTexGenNV(texCoordSet, genMode, components, coeffs) glatter_glPathTexGenNV_debug((texCoordSet), (genMode), (components), (coeffs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPathTexGenNV_debug(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat *coeffs, const char* file, int line);
#ifndef glPointAlongPathNV
#define glPointAlongPathNV(path, startSegment, numSegments, distance, x, y, tangentX, tangentY) glatter_glPointAlongPathNV_debug((path), (startSegment), (numSegments), (distance), (x), (y), (tangentX), (tangentY), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glPointAlongPathNV_debug(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY, const char* file, int line);
#ifndef glProgramPathFragmentInputGenNV
#define glProgramPathFragmentInputGenNV(program, location, genMode, components, coeffs) glatter_glProgramPathFragmentInputGenNV_debug((program), (location), (genMode), (components), (coeffs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramPathFragmentInputGenNV_debug(GLuint program, GLint location, GLenum genMode, GLint components, const GLfloat *coeffs, const char* file, int line);
#ifndef glStencilFillPathInstancedNV
#define glStencilFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, fillMode, mask, transformType, transformValues) glatter_glStencilFillPathInstancedNV_debug((numPaths), (pathNameType), (paths), (pathBase), (fillMode), (mask), (transformType), (transformValues), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilFillPathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues, const char* file, int line);
#ifndef glStencilFillPathNV
#define glStencilFillPathNV(path, fillMode, mask) glatter_glStencilFillPathNV_debug((path), (fillMode), (mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilFillPathNV_debug(GLuint path, GLenum fillMode, GLuint mask, const char* file, int line);
#ifndef glStencilStrokePathInstancedNV
#define glStencilStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, reference, mask, transformType, transformValues) glatter_glStencilStrokePathInstancedNV_debug((numPaths), (pathNameType), (paths), (pathBase), (reference), (mask), (transformType), (transformValues), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilStrokePathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues, const char* file, int line);
#ifndef glStencilStrokePathNV
#define glStencilStrokePathNV(path, reference, mask) glatter_glStencilStrokePathNV_debug((path), (reference), (mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilStrokePathNV_debug(GLuint path, GLint reference, GLuint mask, const char* file, int line);
#ifndef glStencilThenCoverFillPathInstancedNV
#define glStencilThenCoverFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode, transformType, transformValues) glatter_glStencilThenCoverFillPathInstancedNV_debug((numPaths), (pathNameType), (paths), (pathBase), (fillMode), (mask), (coverMode), (transformType), (transformValues), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverFillPathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line);
#ifndef glStencilThenCoverFillPathNV
#define glStencilThenCoverFillPathNV(path, fillMode, mask, coverMode) glatter_glStencilThenCoverFillPathNV_debug((path), (fillMode), (mask), (coverMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverFillPathNV_debug(GLuint path, GLenum fillMode, GLuint mask, GLenum coverMode, const char* file, int line);
#ifndef glStencilThenCoverStrokePathInstancedNV
#define glStencilThenCoverStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, reference, mask, coverMode, transformType, transformValues) glatter_glStencilThenCoverStrokePathInstancedNV_debug((numPaths), (pathNameType), (paths), (pathBase), (reference), (mask), (coverMode), (transformType), (transformValues), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverStrokePathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line);
#ifndef glStencilThenCoverStrokePathNV
#define glStencilThenCoverStrokePathNV(path, reference, mask, coverMode) glatter_glStencilThenCoverStrokePathNV_debug((path), (reference), (mask), (coverMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverStrokePathNV_debug(GLuint path, GLint reference, GLuint mask, GLenum coverMode, const char* file, int line);
#ifndef glTransformPathNV
#define glTransformPathNV(resultPath, srcPath, transformType, transformValues) glatter_glTransformPathNV_debug((resultPath), (srcPath), (transformType), (transformValues), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTransformPathNV_debug(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues, const char* file, int line);
#ifndef glWeightPathsNV
#define glWeightPathsNV(resultPath, numPaths, paths, weights) glatter_glWeightPathsNV_debug((resultPath), (numPaths), (paths), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWeightPathsNV_debug(GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights, const char* file, int line);
#endif // defined(GL_NV_path_rendering)
#if defined(GL_NV_pixel_data_range)
#ifndef glFlushPixelDataRangeNV
#define glFlushPixelDataRangeNV(target) glatter_glFlushPixelDataRangeNV_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlushPixelDataRangeNV_debug(GLenum target, const char* file, int line);
#ifndef glPixelDataRangeNV
#define glPixelDataRangeNV(target, length, pointer) glatter_glPixelDataRangeNV_debug((target), (length), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelDataRangeNV_debug(GLenum target, GLsizei length, const void *pointer, const char* file, int line);
#endif // defined(GL_NV_pixel_data_range)
#if defined(GL_NV_point_sprite)
#ifndef glPointParameteriNV
#define glPointParameteriNV(pname, param) glatter_glPointParameteriNV_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameteriNV_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glPointParameterivNV
#define glPointParameterivNV(pname, params) glatter_glPointParameterivNV_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterivNV_debug(GLenum pname, const GLint *params, const char* file, int line);
#endif // defined(GL_NV_point_sprite)
#if defined(GL_NV_present_video)
#ifndef glGetVideoi64vNV
#define glGetVideoi64vNV(video_slot, pname, params) glatter_glGetVideoi64vNV_debug((video_slot), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVideoi64vNV_debug(GLuint video_slot, GLenum pname, GLint64EXT *params, const char* file, int line);
#ifndef glGetVideoivNV
#define glGetVideoivNV(video_slot, pname, params) glatter_glGetVideoivNV_debug((video_slot), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVideoivNV_debug(GLuint video_slot, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetVideoui64vNV
#define glGetVideoui64vNV(video_slot, pname, params) glatter_glGetVideoui64vNV_debug((video_slot), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVideoui64vNV_debug(GLuint video_slot, GLenum pname, GLuint64EXT *params, const char* file, int line);
#ifndef glGetVideouivNV
#define glGetVideouivNV(video_slot, pname, params) glatter_glGetVideouivNV_debug((video_slot), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVideouivNV_debug(GLuint video_slot, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glPresentFrameDualFillNV
#define glPresentFrameDualFillNV(video_slot, minPresentTime, beginPresentTimeId, presentDurationId, type, target0, fill0, target1, fill1, target2, fill2, target3, fill3) glatter_glPresentFrameDualFillNV_debug((video_slot), (minPresentTime), (beginPresentTimeId), (presentDurationId), (type), (target0), (fill0), (target1), (fill1), (target2), (fill2), (target3), (fill3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPresentFrameDualFillNV_debug(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3, const char* file, int line);
#ifndef glPresentFrameKeyedNV
#define glPresentFrameKeyedNV(video_slot, minPresentTime, beginPresentTimeId, presentDurationId, type, target0, fill0, key0, target1, fill1, key1) glatter_glPresentFrameKeyedNV_debug((video_slot), (minPresentTime), (beginPresentTimeId), (presentDurationId), (type), (target0), (fill0), (key0), (target1), (fill1), (key1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPresentFrameKeyedNV_debug(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1, const char* file, int line);
#endif // defined(GL_NV_present_video)
#if defined(GL_NV_primitive_restart)
#ifndef glPrimitiveRestartIndexNV
#define glPrimitiveRestartIndexNV(index) glatter_glPrimitiveRestartIndexNV_debug((index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveRestartIndexNV_debug(GLuint index, const char* file, int line);
#ifndef glPrimitiveRestartNV
#define glPrimitiveRestartNV() glatter_glPrimitiveRestartNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveRestartNV_debug(const char* file, int line);
#endif // defined(GL_NV_primitive_restart)
#if defined(GL_NV_query_resource)
#ifndef glQueryResourceNV
#define glQueryResourceNV(queryType, tagId, bufSize, buffer) glatter_glQueryResourceNV_debug((queryType), (tagId), (bufSize), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glQueryResourceNV_debug(GLenum queryType, GLint tagId, GLuint bufSize, GLint *buffer, const char* file, int line);
#endif // defined(GL_NV_query_resource)
#if defined(GL_NV_query_resource_tag)
#ifndef glDeleteQueryResourceTagNV
#define glDeleteQueryResourceTagNV(n, tagIds) glatter_glDeleteQueryResourceTagNV_debug((n), (tagIds), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteQueryResourceTagNV_debug(GLsizei n, const GLint *tagIds, const char* file, int line);
#ifndef glGenQueryResourceTagNV
#define glGenQueryResourceTagNV(n, tagIds) glatter_glGenQueryResourceTagNV_debug((n), (tagIds), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenQueryResourceTagNV_debug(GLsizei n, GLint *tagIds, const char* file, int line);
#ifndef glQueryResourceTagNV
#define glQueryResourceTagNV(tagId, tagString) glatter_glQueryResourceTagNV_debug((tagId), (tagString), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glQueryResourceTagNV_debug(GLint tagId, const GLchar *tagString, const char* file, int line);
#endif // defined(GL_NV_query_resource_tag)
#if defined(GL_NV_register_combiners)
#ifndef glCombinerInputNV
#define glCombinerInputNV(stage, portion, variable, input, mapping, componentUsage) glatter_glCombinerInputNV_debug((stage), (portion), (variable), (input), (mapping), (componentUsage), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCombinerInputNV_debug(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage, const char* file, int line);
#ifndef glCombinerOutputNV
#define glCombinerOutputNV(stage, portion, abOutput, cdOutput, sumOutput, scale, bias, abDotProduct, cdDotProduct, muxSum) glatter_glCombinerOutputNV_debug((stage), (portion), (abOutput), (cdOutput), (sumOutput), (scale), (bias), (abDotProduct), (cdDotProduct), (muxSum), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCombinerOutputNV_debug(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum, const char* file, int line);
#ifndef glCombinerParameterfNV
#define glCombinerParameterfNV(pname, param) glatter_glCombinerParameterfNV_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCombinerParameterfNV_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glCombinerParameterfvNV
#define glCombinerParameterfvNV(pname, params) glatter_glCombinerParameterfvNV_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCombinerParameterfvNV_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glCombinerParameteriNV
#define glCombinerParameteriNV(pname, param) glatter_glCombinerParameteriNV_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCombinerParameteriNV_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glCombinerParameterivNV
#define glCombinerParameterivNV(pname, params) glatter_glCombinerParameterivNV_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCombinerParameterivNV_debug(GLenum pname, const GLint *params, const char* file, int line);
#ifndef glFinalCombinerInputNV
#define glFinalCombinerInputNV(variable, input, mapping, componentUsage) glatter_glFinalCombinerInputNV_debug((variable), (input), (mapping), (componentUsage), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFinalCombinerInputNV_debug(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage, const char* file, int line);
#ifndef glGetCombinerInputParameterfvNV
#define glGetCombinerInputParameterfvNV(stage, portion, variable, pname, params) glatter_glGetCombinerInputParameterfvNV_debug((stage), (portion), (variable), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCombinerInputParameterfvNV_debug(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetCombinerInputParameterivNV
#define glGetCombinerInputParameterivNV(stage, portion, variable, pname, params) glatter_glGetCombinerInputParameterivNV_debug((stage), (portion), (variable), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCombinerInputParameterivNV_debug(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetCombinerOutputParameterfvNV
#define glGetCombinerOutputParameterfvNV(stage, portion, pname, params) glatter_glGetCombinerOutputParameterfvNV_debug((stage), (portion), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCombinerOutputParameterfvNV_debug(GLenum stage, GLenum portion, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetCombinerOutputParameterivNV
#define glGetCombinerOutputParameterivNV(stage, portion, pname, params) glatter_glGetCombinerOutputParameterivNV_debug((stage), (portion), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCombinerOutputParameterivNV_debug(GLenum stage, GLenum portion, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetFinalCombinerInputParameterfvNV
#define glGetFinalCombinerInputParameterfvNV(variable, pname, params) glatter_glGetFinalCombinerInputParameterfvNV_debug((variable), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFinalCombinerInputParameterfvNV_debug(GLenum variable, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetFinalCombinerInputParameterivNV
#define glGetFinalCombinerInputParameterivNV(variable, pname, params) glatter_glGetFinalCombinerInputParameterivNV_debug((variable), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFinalCombinerInputParameterivNV_debug(GLenum variable, GLenum pname, GLint *params, const char* file, int line);
#endif // defined(GL_NV_register_combiners)
#if defined(GL_NV_register_combiners2)
#ifndef glCombinerStageParameterfvNV
#define glCombinerStageParameterfvNV(stage, pname, params) glatter_glCombinerStageParameterfvNV_debug((stage), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCombinerStageParameterfvNV_debug(GLenum stage, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glGetCombinerStageParameterfvNV
#define glGetCombinerStageParameterfvNV(stage, pname, params) glatter_glGetCombinerStageParameterfvNV_debug((stage), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCombinerStageParameterfvNV_debug(GLenum stage, GLenum pname, GLfloat *params, const char* file, int line);
#endif // defined(GL_NV_register_combiners2)
#if defined(GL_NV_sample_locations)
#ifndef glFramebufferSampleLocationsfvNV
#define glFramebufferSampleLocationsfvNV(target, start, count, v) glatter_glFramebufferSampleLocationsfvNV_debug((target), (start), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferSampleLocationsfvNV_debug(GLenum target, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glNamedFramebufferSampleLocationsfvNV
#define glNamedFramebufferSampleLocationsfvNV(framebuffer, start, count, v) glatter_glNamedFramebufferSampleLocationsfvNV_debug((framebuffer), (start), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferSampleLocationsfvNV_debug(GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glResolveDepthValuesNV
#define glResolveDepthValuesNV() glatter_glResolveDepthValuesNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glResolveDepthValuesNV_debug(const char* file, int line);
#endif // defined(GL_NV_sample_locations)
#if defined(GL_NV_shader_buffer_load)
#ifndef glGetBufferParameterui64vNV
#define glGetBufferParameterui64vNV(target, pname, params) glatter_glGetBufferParameterui64vNV_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBufferParameterui64vNV_debug(GLenum target, GLenum pname, GLuint64EXT *params, const char* file, int line);
#ifndef glGetIntegerui64vNV
#define glGetIntegerui64vNV(value, result) glatter_glGetIntegerui64vNV_debug((value), (result), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetIntegerui64vNV_debug(GLenum value, GLuint64EXT *result, const char* file, int line);
#ifndef glGetNamedBufferParameterui64vNV
#define glGetNamedBufferParameterui64vNV(buffer, pname, params) glatter_glGetNamedBufferParameterui64vNV_debug((buffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferParameterui64vNV_debug(GLuint buffer, GLenum pname, GLuint64EXT *params, const char* file, int line);
#ifndef glIsBufferResidentNV
#define glIsBufferResidentNV(target) glatter_glIsBufferResidentNV_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsBufferResidentNV_debug(GLenum target, const char* file, int line);
#ifndef glIsNamedBufferResidentNV
#define glIsNamedBufferResidentNV(buffer) glatter_glIsNamedBufferResidentNV_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsNamedBufferResidentNV_debug(GLuint buffer, const char* file, int line);
#ifndef glMakeBufferNonResidentNV
#define glMakeBufferNonResidentNV(target) glatter_glMakeBufferNonResidentNV_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeBufferNonResidentNV_debug(GLenum target, const char* file, int line);
#ifndef glMakeBufferResidentNV
#define glMakeBufferResidentNV(target, access) glatter_glMakeBufferResidentNV_debug((target), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeBufferResidentNV_debug(GLenum target, GLenum access, const char* file, int line);
#ifndef glMakeNamedBufferNonResidentNV
#define glMakeNamedBufferNonResidentNV(buffer) glatter_glMakeNamedBufferNonResidentNV_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeNamedBufferNonResidentNV_debug(GLuint buffer, const char* file, int line);
#ifndef glMakeNamedBufferResidentNV
#define glMakeNamedBufferResidentNV(buffer, access) glatter_glMakeNamedBufferResidentNV_debug((buffer), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMakeNamedBufferResidentNV_debug(GLuint buffer, GLenum access, const char* file, int line);
#ifndef glProgramUniformui64NV
#define glProgramUniformui64NV(program, location, value) glatter_glProgramUniformui64NV_debug((program), (location), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformui64NV_debug(GLuint program, GLint location, GLuint64EXT value, const char* file, int line);
#ifndef glProgramUniformui64vNV
#define glProgramUniformui64vNV(program, location, count, value) glatter_glProgramUniformui64vNV_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#ifndef glUniformui64NV
#define glUniformui64NV(location, value) glatter_glUniformui64NV_debug((location), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformui64NV_debug(GLint location, GLuint64EXT value, const char* file, int line);
#ifndef glUniformui64vNV
#define glUniformui64vNV(location, count, value) glatter_glUniformui64vNV_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line);
#endif // defined(GL_NV_shader_buffer_load)
#if defined(GL_NV_texture_barrier)
#ifndef glTextureBarrierNV
#define glTextureBarrierNV() glatter_glTextureBarrierNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureBarrierNV_debug(const char* file, int line);
#endif // defined(GL_NV_texture_barrier)
#if defined(GL_NV_texture_multisample)
#ifndef glTexImage2DMultisampleCoverageNV
#define glTexImage2DMultisampleCoverageNV(target, coverageSamples, colorSamples, internalFormat, width, height, fixedSampleLocations) glatter_glTexImage2DMultisampleCoverageNV_debug((target), (coverageSamples), (colorSamples), (internalFormat), (width), (height), (fixedSampleLocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexImage2DMultisampleCoverageNV_debug(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, const char* file, int line);
#ifndef glTexImage3DMultisampleCoverageNV
#define glTexImage3DMultisampleCoverageNV(target, coverageSamples, colorSamples, internalFormat, width, height, depth, fixedSampleLocations) glatter_glTexImage3DMultisampleCoverageNV_debug((target), (coverageSamples), (colorSamples), (internalFormat), (width), (height), (depth), (fixedSampleLocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexImage3DMultisampleCoverageNV_debug(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, const char* file, int line);
#ifndef glTextureImage2DMultisampleCoverageNV
#define glTextureImage2DMultisampleCoverageNV(texture, target, coverageSamples, colorSamples, internalFormat, width, height, fixedSampleLocations) glatter_glTextureImage2DMultisampleCoverageNV_debug((texture), (target), (coverageSamples), (colorSamples), (internalFormat), (width), (height), (fixedSampleLocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureImage2DMultisampleCoverageNV_debug(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, const char* file, int line);
#ifndef glTextureImage2DMultisampleNV
#define glTextureImage2DMultisampleNV(texture, target, samples, internalFormat, width, height, fixedSampleLocations) glatter_glTextureImage2DMultisampleNV_debug((texture), (target), (samples), (internalFormat), (width), (height), (fixedSampleLocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureImage2DMultisampleNV_debug(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, const char* file, int line);
#ifndef glTextureImage3DMultisampleCoverageNV
#define glTextureImage3DMultisampleCoverageNV(texture, target, coverageSamples, colorSamples, internalFormat, width, height, depth, fixedSampleLocations) glatter_glTextureImage3DMultisampleCoverageNV_debug((texture), (target), (coverageSamples), (colorSamples), (internalFormat), (width), (height), (depth), (fixedSampleLocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureImage3DMultisampleCoverageNV_debug(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, const char* file, int line);
#ifndef glTextureImage3DMultisampleNV
#define glTextureImage3DMultisampleNV(texture, target, samples, internalFormat, width, height, depth, fixedSampleLocations) glatter_glTextureImage3DMultisampleNV_debug((texture), (target), (samples), (internalFormat), (width), (height), (depth), (fixedSampleLocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureImage3DMultisampleNV_debug(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, const char* file, int line);
#endif // defined(GL_NV_texture_multisample)
#if defined(GL_NV_transform_feedback)
#ifndef glActiveVaryingNV
#define glActiveVaryingNV(program, name) glatter_glActiveVaryingNV_debug((program), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glActiveVaryingNV_debug(GLuint program, const GLchar *name, const char* file, int line);
#ifndef glBeginTransformFeedbackNV
#define glBeginTransformFeedbackNV(primitiveMode) glatter_glBeginTransformFeedbackNV_debug((primitiveMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginTransformFeedbackNV_debug(GLenum primitiveMode, const char* file, int line);
#ifndef glBindBufferBaseNV
#define glBindBufferBaseNV(target, index, buffer) glatter_glBindBufferBaseNV_debug((target), (index), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBufferBaseNV_debug(GLenum target, GLuint index, GLuint buffer, const char* file, int line);
#ifndef glBindBufferOffsetNV
#define glBindBufferOffsetNV(target, index, buffer, offset) glatter_glBindBufferOffsetNV_debug((target), (index), (buffer), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBufferOffsetNV_debug(GLenum target, GLuint index, GLuint buffer, GLintptr offset, const char* file, int line);
#ifndef glBindBufferRangeNV
#define glBindBufferRangeNV(target, index, buffer, offset, size) glatter_glBindBufferRangeNV_debug((target), (index), (buffer), (offset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBufferRangeNV_debug(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line);
#ifndef glEndTransformFeedbackNV
#define glEndTransformFeedbackNV() glatter_glEndTransformFeedbackNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndTransformFeedbackNV_debug(const char* file, int line);
#ifndef glGetActiveVaryingNV
#define glGetActiveVaryingNV(program, index, bufSize, length, size, type, name) glatter_glGetActiveVaryingNV_debug((program), (index), (bufSize), (length), (size), (type), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveVaryingNV_debug(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name, const char* file, int line);
#ifndef glGetTransformFeedbackVaryingNV
#define glGetTransformFeedbackVaryingNV(program, index, location) glatter_glGetTransformFeedbackVaryingNV_debug((program), (index), (location), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTransformFeedbackVaryingNV_debug(GLuint program, GLuint index, GLint *location, const char* file, int line);
#ifndef glGetVaryingLocationNV
#define glGetVaryingLocationNV(program, name) glatter_glGetVaryingLocationNV_debug((program), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetVaryingLocationNV_debug(GLuint program, const GLchar *name, const char* file, int line);
#ifndef glTransformFeedbackAttribsNV
#define glTransformFeedbackAttribsNV(count, attribs, bufferMode) glatter_glTransformFeedbackAttribsNV_debug((count), (attribs), (bufferMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTransformFeedbackAttribsNV_debug(GLsizei count, const GLint *attribs, GLenum bufferMode, const char* file, int line);
#ifndef glTransformFeedbackStreamAttribsNV
#define glTransformFeedbackStreamAttribsNV(count, attribs, nbuffers, bufstreams, bufferMode) glatter_glTransformFeedbackStreamAttribsNV_debug((count), (attribs), (nbuffers), (bufstreams), (bufferMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTransformFeedbackStreamAttribsNV_debug(GLsizei count, const GLint *attribs, GLsizei nbuffers, const GLint *bufstreams, GLenum bufferMode, const char* file, int line);
#ifndef glTransformFeedbackVaryingsNV
#define glTransformFeedbackVaryingsNV(program, count, locations, bufferMode) glatter_glTransformFeedbackVaryingsNV_debug((program), (count), (locations), (bufferMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTransformFeedbackVaryingsNV_debug(GLuint program, GLsizei count, const GLint *locations, GLenum bufferMode, const char* file, int line);
#endif // defined(GL_NV_transform_feedback)
#if defined(GL_NV_transform_feedback2)
#ifndef glBindTransformFeedbackNV
#define glBindTransformFeedbackNV(target, id) glatter_glBindTransformFeedbackNV_debug((target), (id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindTransformFeedbackNV_debug(GLenum target, GLuint id, const char* file, int line);
#ifndef glDeleteTransformFeedbacksNV
#define glDeleteTransformFeedbacksNV(n, ids) glatter_glDeleteTransformFeedbacksNV_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteTransformFeedbacksNV_debug(GLsizei n, const GLuint *ids, const char* file, int line);
#ifndef glDrawTransformFeedbackNV
#define glDrawTransformFeedbackNV(mode, id) glatter_glDrawTransformFeedbackNV_debug((mode), (id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawTransformFeedbackNV_debug(GLenum mode, GLuint id, const char* file, int line);
#ifndef glGenTransformFeedbacksNV
#define glGenTransformFeedbacksNV(n, ids) glatter_glGenTransformFeedbacksNV_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenTransformFeedbacksNV_debug(GLsizei n, GLuint *ids, const char* file, int line);
#ifndef glIsTransformFeedbackNV
#define glIsTransformFeedbackNV(id) glatter_glIsTransformFeedbackNV_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTransformFeedbackNV_debug(GLuint id, const char* file, int line);
#ifndef glPauseTransformFeedbackNV
#define glPauseTransformFeedbackNV() glatter_glPauseTransformFeedbackNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPauseTransformFeedbackNV_debug(const char* file, int line);
#ifndef glResumeTransformFeedbackNV
#define glResumeTransformFeedbackNV() glatter_glResumeTransformFeedbackNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glResumeTransformFeedbackNV_debug(const char* file, int line);
#endif // defined(GL_NV_transform_feedback2)
#if defined(GL_NV_vdpau_interop)
#ifndef glVDPAUFiniNV
#define glVDPAUFiniNV() glatter_glVDPAUFiniNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVDPAUFiniNV_debug(const char* file, int line);
#ifndef glVDPAUGetSurfaceivNV
#define glVDPAUGetSurfaceivNV(surface, pname, bufSize, length, values) glatter_glVDPAUGetSurfaceivNV_debug((surface), (pname), (bufSize), (length), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVDPAUGetSurfaceivNV_debug(GLvdpauSurfaceNV surface, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values, const char* file, int line);
#ifndef glVDPAUInitNV
#define glVDPAUInitNV(vdpDevice, getProcAddress) glatter_glVDPAUInitNV_debug((vdpDevice), (getProcAddress), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVDPAUInitNV_debug(const void *vdpDevice, const void *getProcAddress, const char* file, int line);
#ifndef glVDPAUIsSurfaceNV
#define glVDPAUIsSurfaceNV(surface) glatter_glVDPAUIsSurfaceNV_debug((surface), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glVDPAUIsSurfaceNV_debug(GLvdpauSurfaceNV surface, const char* file, int line);
#ifndef glVDPAUMapSurfacesNV
#define glVDPAUMapSurfacesNV(numSurfaces, surfaces) glatter_glVDPAUMapSurfacesNV_debug((numSurfaces), (surfaces), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVDPAUMapSurfacesNV_debug(GLsizei numSurfaces, const GLvdpauSurfaceNV *surfaces, const char* file, int line);
#ifndef glVDPAURegisterOutputSurfaceNV
#define glVDPAURegisterOutputSurfaceNV(vdpSurface, target, numTextureNames, textureNames) glatter_glVDPAURegisterOutputSurfaceNV_debug((vdpSurface), (target), (numTextureNames), (textureNames), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLvdpauSurfaceNV glatter_glVDPAURegisterOutputSurfaceNV_debug(const void *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames, const char* file, int line);
#ifndef glVDPAURegisterVideoSurfaceNV
#define glVDPAURegisterVideoSurfaceNV(vdpSurface, target, numTextureNames, textureNames) glatter_glVDPAURegisterVideoSurfaceNV_debug((vdpSurface), (target), (numTextureNames), (textureNames), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLvdpauSurfaceNV glatter_glVDPAURegisterVideoSurfaceNV_debug(const void *vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames, const char* file, int line);
#ifndef glVDPAUSurfaceAccessNV
#define glVDPAUSurfaceAccessNV(surface, access) glatter_glVDPAUSurfaceAccessNV_debug((surface), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVDPAUSurfaceAccessNV_debug(GLvdpauSurfaceNV surface, GLenum access, const char* file, int line);
#ifndef glVDPAUUnmapSurfacesNV
#define glVDPAUUnmapSurfacesNV(numSurface, surfaces) glatter_glVDPAUUnmapSurfacesNV_debug((numSurface), (surfaces), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVDPAUUnmapSurfacesNV_debug(GLsizei numSurface, const GLvdpauSurfaceNV *surfaces, const char* file, int line);
#ifndef glVDPAUUnregisterSurfaceNV
#define glVDPAUUnregisterSurfaceNV(surface) glatter_glVDPAUUnregisterSurfaceNV_debug((surface), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVDPAUUnregisterSurfaceNV_debug(GLvdpauSurfaceNV surface, const char* file, int line);
#endif // defined(GL_NV_vdpau_interop)
#if defined(GL_NV_vertex_array_range)
#ifndef glFlushVertexArrayRangeNV
#define glFlushVertexArrayRangeNV() glatter_glFlushVertexArrayRangeNV_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlushVertexArrayRangeNV_debug(const char* file, int line);
#ifndef glVertexArrayRangeNV
#define glVertexArrayRangeNV(length, pointer) glatter_glVertexArrayRangeNV_debug((length), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayRangeNV_debug(GLsizei length, const void *pointer, const char* file, int line);
#endif // defined(GL_NV_vertex_array_range)
#if defined(GL_NV_vertex_attrib_integer_64bit)
#ifndef glGetVertexAttribLi64vNV
#define glGetVertexAttribLi64vNV(index, pname, params) glatter_glGetVertexAttribLi64vNV_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribLi64vNV_debug(GLuint index, GLenum pname, GLint64EXT *params, const char* file, int line);
#ifndef glGetVertexAttribLui64vNV
#define glGetVertexAttribLui64vNV(index, pname, params) glatter_glGetVertexAttribLui64vNV_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribLui64vNV_debug(GLuint index, GLenum pname, GLuint64EXT *params, const char* file, int line);
#ifndef glVertexAttribL1i64NV
#define glVertexAttribL1i64NV(index, x) glatter_glVertexAttribL1i64NV_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1i64NV_debug(GLuint index, GLint64EXT x, const char* file, int line);
#ifndef glVertexAttribL1i64vNV
#define glVertexAttribL1i64vNV(index, v) glatter_glVertexAttribL1i64vNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1i64vNV_debug(GLuint index, const GLint64EXT *v, const char* file, int line);
#ifndef glVertexAttribL1ui64NV
#define glVertexAttribL1ui64NV(index, x) glatter_glVertexAttribL1ui64NV_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1ui64NV_debug(GLuint index, GLuint64EXT x, const char* file, int line);
#ifndef glVertexAttribL1ui64vNV
#define glVertexAttribL1ui64vNV(index, v) glatter_glVertexAttribL1ui64vNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1ui64vNV_debug(GLuint index, const GLuint64EXT *v, const char* file, int line);
#ifndef glVertexAttribL2i64NV
#define glVertexAttribL2i64NV(index, x, y) glatter_glVertexAttribL2i64NV_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2i64NV_debug(GLuint index, GLint64EXT x, GLint64EXT y, const char* file, int line);
#ifndef glVertexAttribL2i64vNV
#define glVertexAttribL2i64vNV(index, v) glatter_glVertexAttribL2i64vNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2i64vNV_debug(GLuint index, const GLint64EXT *v, const char* file, int line);
#ifndef glVertexAttribL2ui64NV
#define glVertexAttribL2ui64NV(index, x, y) glatter_glVertexAttribL2ui64NV_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2ui64NV_debug(GLuint index, GLuint64EXT x, GLuint64EXT y, const char* file, int line);
#ifndef glVertexAttribL2ui64vNV
#define glVertexAttribL2ui64vNV(index, v) glatter_glVertexAttribL2ui64vNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2ui64vNV_debug(GLuint index, const GLuint64EXT *v, const char* file, int line);
#ifndef glVertexAttribL3i64NV
#define glVertexAttribL3i64NV(index, x, y, z) glatter_glVertexAttribL3i64NV_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3i64NV_debug(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, const char* file, int line);
#ifndef glVertexAttribL3i64vNV
#define glVertexAttribL3i64vNV(index, v) glatter_glVertexAttribL3i64vNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3i64vNV_debug(GLuint index, const GLint64EXT *v, const char* file, int line);
#ifndef glVertexAttribL3ui64NV
#define glVertexAttribL3ui64NV(index, x, y, z) glatter_glVertexAttribL3ui64NV_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3ui64NV_debug(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, const char* file, int line);
#ifndef glVertexAttribL3ui64vNV
#define glVertexAttribL3ui64vNV(index, v) glatter_glVertexAttribL3ui64vNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3ui64vNV_debug(GLuint index, const GLuint64EXT *v, const char* file, int line);
#ifndef glVertexAttribL4i64NV
#define glVertexAttribL4i64NV(index, x, y, z, w) glatter_glVertexAttribL4i64NV_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4i64NV_debug(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w, const char* file, int line);
#ifndef glVertexAttribL4i64vNV
#define glVertexAttribL4i64vNV(index, v) glatter_glVertexAttribL4i64vNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4i64vNV_debug(GLuint index, const GLint64EXT *v, const char* file, int line);
#ifndef glVertexAttribL4ui64NV
#define glVertexAttribL4ui64NV(index, x, y, z, w) glatter_glVertexAttribL4ui64NV_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4ui64NV_debug(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w, const char* file, int line);
#ifndef glVertexAttribL4ui64vNV
#define glVertexAttribL4ui64vNV(index, v) glatter_glVertexAttribL4ui64vNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4ui64vNV_debug(GLuint index, const GLuint64EXT *v, const char* file, int line);
#ifndef glVertexAttribLFormatNV
#define glVertexAttribLFormatNV(index, size, type, stride) glatter_glVertexAttribLFormatNV_debug((index), (size), (type), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribLFormatNV_debug(GLuint index, GLint size, GLenum type, GLsizei stride, const char* file, int line);
#endif // defined(GL_NV_vertex_attrib_integer_64bit)
#if defined(GL_NV_vertex_buffer_unified_memory)
#ifndef glBufferAddressRangeNV
#define glBufferAddressRangeNV(pname, index, address, length) glatter_glBufferAddressRangeNV_debug((pname), (index), (address), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferAddressRangeNV_debug(GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length, const char* file, int line);
#ifndef glColorFormatNV
#define glColorFormatNV(size, type, stride) glatter_glColorFormatNV_debug((size), (type), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorFormatNV_debug(GLint size, GLenum type, GLsizei stride, const char* file, int line);
#ifndef glEdgeFlagFormatNV
#define glEdgeFlagFormatNV(stride) glatter_glEdgeFlagFormatNV_debug((stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlagFormatNV_debug(GLsizei stride, const char* file, int line);
#ifndef glFogCoordFormatNV
#define glFogCoordFormatNV(type, stride) glatter_glFogCoordFormatNV_debug((type), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordFormatNV_debug(GLenum type, GLsizei stride, const char* file, int line);
#ifndef glGetIntegerui64i_vNV
#define glGetIntegerui64i_vNV(value, index, result) glatter_glGetIntegerui64i_vNV_debug((value), (index), (result), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetIntegerui64i_vNV_debug(GLenum value, GLuint index, GLuint64EXT *result, const char* file, int line);
#ifndef glIndexFormatNV
#define glIndexFormatNV(type, stride) glatter_glIndexFormatNV_debug((type), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexFormatNV_debug(GLenum type, GLsizei stride, const char* file, int line);
#ifndef glNormalFormatNV
#define glNormalFormatNV(type, stride) glatter_glNormalFormatNV_debug((type), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalFormatNV_debug(GLenum type, GLsizei stride, const char* file, int line);
#ifndef glSecondaryColorFormatNV
#define glSecondaryColorFormatNV(size, type, stride) glatter_glSecondaryColorFormatNV_debug((size), (type), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColorFormatNV_debug(GLint size, GLenum type, GLsizei stride, const char* file, int line);
#ifndef glTexCoordFormatNV
#define glTexCoordFormatNV(size, type, stride) glatter_glTexCoordFormatNV_debug((size), (type), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordFormatNV_debug(GLint size, GLenum type, GLsizei stride, const char* file, int line);
#ifndef glVertexAttribFormatNV
#define glVertexAttribFormatNV(index, size, type, normalized, stride) glatter_glVertexAttribFormatNV_debug((index), (size), (type), (normalized), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribFormatNV_debug(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const char* file, int line);
#ifndef glVertexAttribIFormatNV
#define glVertexAttribIFormatNV(index, size, type, stride) glatter_glVertexAttribIFormatNV_debug((index), (size), (type), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribIFormatNV_debug(GLuint index, GLint size, GLenum type, GLsizei stride, const char* file, int line);
#ifndef glVertexFormatNV
#define glVertexFormatNV(size, type, stride) glatter_glVertexFormatNV_debug((size), (type), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexFormatNV_debug(GLint size, GLenum type, GLsizei stride, const char* file, int line);
#endif // defined(GL_NV_vertex_buffer_unified_memory)
#if defined(GL_NV_vertex_program)
#ifndef glAreProgramsResidentNV
#define glAreProgramsResidentNV(n, programs, residences) glatter_glAreProgramsResidentNV_debug((n), (programs), (residences), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glAreProgramsResidentNV_debug(GLsizei n, const GLuint *programs, GLboolean *residences, const char* file, int line);
#ifndef glBindProgramNV
#define glBindProgramNV(target, id) glatter_glBindProgramNV_debug((target), (id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindProgramNV_debug(GLenum target, GLuint id, const char* file, int line);
#ifndef glDeleteProgramsNV
#define glDeleteProgramsNV(n, programs) glatter_glDeleteProgramsNV_debug((n), (programs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteProgramsNV_debug(GLsizei n, const GLuint *programs, const char* file, int line);
#ifndef glExecuteProgramNV
#define glExecuteProgramNV(target, id, params) glatter_glExecuteProgramNV_debug((target), (id), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glExecuteProgramNV_debug(GLenum target, GLuint id, const GLfloat *params, const char* file, int line);
#ifndef glGenProgramsNV
#define glGenProgramsNV(n, programs) glatter_glGenProgramsNV_debug((n), (programs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenProgramsNV_debug(GLsizei n, GLuint *programs, const char* file, int line);
#ifndef glGetProgramParameterdvNV
#define glGetProgramParameterdvNV(target, index, pname, params) glatter_glGetProgramParameterdvNV_debug((target), (index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramParameterdvNV_debug(GLenum target, GLuint index, GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glGetProgramParameterfvNV
#define glGetProgramParameterfvNV(target, index, pname, params) glatter_glGetProgramParameterfvNV_debug((target), (index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramParameterfvNV_debug(GLenum target, GLuint index, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetProgramStringNV
#define glGetProgramStringNV(id, pname, program) glatter_glGetProgramStringNV_debug((id), (pname), (program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramStringNV_debug(GLuint id, GLenum pname, GLubyte *program, const char* file, int line);
#ifndef glGetProgramivNV
#define glGetProgramivNV(id, pname, params) glatter_glGetProgramivNV_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramivNV_debug(GLuint id, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTrackMatrixivNV
#define glGetTrackMatrixivNV(target, address, pname, params) glatter_glGetTrackMatrixivNV_debug((target), (address), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTrackMatrixivNV_debug(GLenum target, GLuint address, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetVertexAttribPointervNV
#define glGetVertexAttribPointervNV(index, pname, pointer) glatter_glGetVertexAttribPointervNV_debug((index), (pname), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribPointervNV_debug(GLuint index, GLenum pname, void **pointer, const char* file, int line);
#ifndef glGetVertexAttribdvNV
#define glGetVertexAttribdvNV(index, pname, params) glatter_glGetVertexAttribdvNV_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribdvNV_debug(GLuint index, GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glGetVertexAttribfvNV
#define glGetVertexAttribfvNV(index, pname, params) glatter_glGetVertexAttribfvNV_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribfvNV_debug(GLuint index, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetVertexAttribivNV
#define glGetVertexAttribivNV(index, pname, params) glatter_glGetVertexAttribivNV_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribivNV_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsProgramNV
#define glIsProgramNV(id) glatter_glIsProgramNV_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsProgramNV_debug(GLuint id, const char* file, int line);
#ifndef glLoadProgramNV
#define glLoadProgramNV(target, id, len, program) glatter_glLoadProgramNV_debug((target), (id), (len), (program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadProgramNV_debug(GLenum target, GLuint id, GLsizei len, const GLubyte *program, const char* file, int line);
#ifndef glProgramParameter4dNV
#define glProgramParameter4dNV(target, index, x, y, z, w) glatter_glProgramParameter4dNV_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramParameter4dNV_debug(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glProgramParameter4dvNV
#define glProgramParameter4dvNV(target, index, v) glatter_glProgramParameter4dvNV_debug((target), (index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramParameter4dvNV_debug(GLenum target, GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glProgramParameter4fNV
#define glProgramParameter4fNV(target, index, x, y, z, w) glatter_glProgramParameter4fNV_debug((target), (index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramParameter4fNV_debug(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glProgramParameter4fvNV
#define glProgramParameter4fvNV(target, index, v) glatter_glProgramParameter4fvNV_debug((target), (index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramParameter4fvNV_debug(GLenum target, GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glProgramParameters4dvNV
#define glProgramParameters4dvNV(target, index, count, v) glatter_glProgramParameters4dvNV_debug((target), (index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramParameters4dvNV_debug(GLenum target, GLuint index, GLsizei count, const GLdouble *v, const char* file, int line);
#ifndef glProgramParameters4fvNV
#define glProgramParameters4fvNV(target, index, count, v) glatter_glProgramParameters4fvNV_debug((target), (index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramParameters4fvNV_debug(GLenum target, GLuint index, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glRequestResidentProgramsNV
#define glRequestResidentProgramsNV(n, programs) glatter_glRequestResidentProgramsNV_debug((n), (programs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRequestResidentProgramsNV_debug(GLsizei n, const GLuint *programs, const char* file, int line);
#ifndef glTrackMatrixNV
#define glTrackMatrixNV(target, address, matrix, transform) glatter_glTrackMatrixNV_debug((target), (address), (matrix), (transform), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTrackMatrixNV_debug(GLenum target, GLuint address, GLenum matrix, GLenum transform, const char* file, int line);
#ifndef glVertexAttrib1dNV
#define glVertexAttrib1dNV(index, x) glatter_glVertexAttrib1dNV_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1dNV_debug(GLuint index, GLdouble x, const char* file, int line);
#ifndef glVertexAttrib1dvNV
#define glVertexAttrib1dvNV(index, v) glatter_glVertexAttrib1dvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1dvNV_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib1fNV
#define glVertexAttrib1fNV(index, x) glatter_glVertexAttrib1fNV_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1fNV_debug(GLuint index, GLfloat x, const char* file, int line);
#ifndef glVertexAttrib1fvNV
#define glVertexAttrib1fvNV(index, v) glatter_glVertexAttrib1fvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1fvNV_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib1sNV
#define glVertexAttrib1sNV(index, x) glatter_glVertexAttrib1sNV_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1sNV_debug(GLuint index, GLshort x, const char* file, int line);
#ifndef glVertexAttrib1svNV
#define glVertexAttrib1svNV(index, v) glatter_glVertexAttrib1svNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1svNV_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib2dNV
#define glVertexAttrib2dNV(index, x, y) glatter_glVertexAttrib2dNV_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2dNV_debug(GLuint index, GLdouble x, GLdouble y, const char* file, int line);
#ifndef glVertexAttrib2dvNV
#define glVertexAttrib2dvNV(index, v) glatter_glVertexAttrib2dvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2dvNV_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib2fNV
#define glVertexAttrib2fNV(index, x, y) glatter_glVertexAttrib2fNV_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2fNV_debug(GLuint index, GLfloat x, GLfloat y, const char* file, int line);
#ifndef glVertexAttrib2fvNV
#define glVertexAttrib2fvNV(index, v) glatter_glVertexAttrib2fvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2fvNV_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib2sNV
#define glVertexAttrib2sNV(index, x, y) glatter_glVertexAttrib2sNV_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2sNV_debug(GLuint index, GLshort x, GLshort y, const char* file, int line);
#ifndef glVertexAttrib2svNV
#define glVertexAttrib2svNV(index, v) glatter_glVertexAttrib2svNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2svNV_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib3dNV
#define glVertexAttrib3dNV(index, x, y, z) glatter_glVertexAttrib3dNV_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3dNV_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glVertexAttrib3dvNV
#define glVertexAttrib3dvNV(index, v) glatter_glVertexAttrib3dvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3dvNV_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib3fNV
#define glVertexAttrib3fNV(index, x, y, z) glatter_glVertexAttrib3fNV_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3fNV_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glVertexAttrib3fvNV
#define glVertexAttrib3fvNV(index, v) glatter_glVertexAttrib3fvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3fvNV_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib3sNV
#define glVertexAttrib3sNV(index, x, y, z) glatter_glVertexAttrib3sNV_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3sNV_debug(GLuint index, GLshort x, GLshort y, GLshort z, const char* file, int line);
#ifndef glVertexAttrib3svNV
#define glVertexAttrib3svNV(index, v) glatter_glVertexAttrib3svNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3svNV_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib4dNV
#define glVertexAttrib4dNV(index, x, y, z, w) glatter_glVertexAttrib4dNV_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4dNV_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glVertexAttrib4dvNV
#define glVertexAttrib4dvNV(index, v) glatter_glVertexAttrib4dvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4dvNV_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib4fNV
#define glVertexAttrib4fNV(index, x, y, z, w) glatter_glVertexAttrib4fNV_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4fNV_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glVertexAttrib4fvNV
#define glVertexAttrib4fvNV(index, v) glatter_glVertexAttrib4fvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4fvNV_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib4sNV
#define glVertexAttrib4sNV(index, x, y, z, w) glatter_glVertexAttrib4sNV_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4sNV_debug(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line);
#ifndef glVertexAttrib4svNV
#define glVertexAttrib4svNV(index, v) glatter_glVertexAttrib4svNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4svNV_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib4ubNV
#define glVertexAttrib4ubNV(index, x, y, z, w) glatter_glVertexAttrib4ubNV_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4ubNV_debug(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w, const char* file, int line);
#ifndef glVertexAttrib4ubvNV
#define glVertexAttrib4ubvNV(index, v) glatter_glVertexAttrib4ubvNV_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4ubvNV_debug(GLuint index, const GLubyte *v, const char* file, int line);
#ifndef glVertexAttribPointerNV
#define glVertexAttribPointerNV(index, fsize, type, stride, pointer) glatter_glVertexAttribPointerNV_debug((index), (fsize), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribPointerNV_debug(GLuint index, GLint fsize, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glVertexAttribs1dvNV
#define glVertexAttribs1dvNV(index, count, v) glatter_glVertexAttribs1dvNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs1dvNV_debug(GLuint index, GLsizei count, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribs1fvNV
#define glVertexAttribs1fvNV(index, count, v) glatter_glVertexAttribs1fvNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs1fvNV_debug(GLuint index, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttribs1svNV
#define glVertexAttribs1svNV(index, count, v) glatter_glVertexAttribs1svNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs1svNV_debug(GLuint index, GLsizei count, const GLshort *v, const char* file, int line);
#ifndef glVertexAttribs2dvNV
#define glVertexAttribs2dvNV(index, count, v) glatter_glVertexAttribs2dvNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs2dvNV_debug(GLuint index, GLsizei count, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribs2fvNV
#define glVertexAttribs2fvNV(index, count, v) glatter_glVertexAttribs2fvNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs2fvNV_debug(GLuint index, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttribs2svNV
#define glVertexAttribs2svNV(index, count, v) glatter_glVertexAttribs2svNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs2svNV_debug(GLuint index, GLsizei count, const GLshort *v, const char* file, int line);
#ifndef glVertexAttribs3dvNV
#define glVertexAttribs3dvNV(index, count, v) glatter_glVertexAttribs3dvNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs3dvNV_debug(GLuint index, GLsizei count, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribs3fvNV
#define glVertexAttribs3fvNV(index, count, v) glatter_glVertexAttribs3fvNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs3fvNV_debug(GLuint index, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttribs3svNV
#define glVertexAttribs3svNV(index, count, v) glatter_glVertexAttribs3svNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs3svNV_debug(GLuint index, GLsizei count, const GLshort *v, const char* file, int line);
#ifndef glVertexAttribs4dvNV
#define glVertexAttribs4dvNV(index, count, v) glatter_glVertexAttribs4dvNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs4dvNV_debug(GLuint index, GLsizei count, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribs4fvNV
#define glVertexAttribs4fvNV(index, count, v) glatter_glVertexAttribs4fvNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs4fvNV_debug(GLuint index, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttribs4svNV
#define glVertexAttribs4svNV(index, count, v) glatter_glVertexAttribs4svNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs4svNV_debug(GLuint index, GLsizei count, const GLshort *v, const char* file, int line);
#ifndef glVertexAttribs4ubvNV
#define glVertexAttribs4ubvNV(index, count, v) glatter_glVertexAttribs4ubvNV_debug((index), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs4ubvNV_debug(GLuint index, GLsizei count, const GLubyte *v, const char* file, int line);
#endif // defined(GL_NV_vertex_program)
#if defined(GL_NV_vertex_program4)
#ifndef glGetVertexAttribIivEXT
#define glGetVertexAttribIivEXT(index, pname, params) glatter_glGetVertexAttribIivEXT_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribIivEXT_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetVertexAttribIuivEXT
#define glGetVertexAttribIuivEXT(index, pname, params) glatter_glGetVertexAttribIuivEXT_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribIuivEXT_debug(GLuint index, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glVertexAttribI1iEXT
#define glVertexAttribI1iEXT(index, x) glatter_glVertexAttribI1iEXT_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI1iEXT_debug(GLuint index, GLint x, const char* file, int line);
#ifndef glVertexAttribI1ivEXT
#define glVertexAttribI1ivEXT(index, v) glatter_glVertexAttribI1ivEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI1ivEXT_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttribI1uiEXT
#define glVertexAttribI1uiEXT(index, x) glatter_glVertexAttribI1uiEXT_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI1uiEXT_debug(GLuint index, GLuint x, const char* file, int line);
#ifndef glVertexAttribI1uivEXT
#define glVertexAttribI1uivEXT(index, v) glatter_glVertexAttribI1uivEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI1uivEXT_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttribI2iEXT
#define glVertexAttribI2iEXT(index, x, y) glatter_glVertexAttribI2iEXT_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI2iEXT_debug(GLuint index, GLint x, GLint y, const char* file, int line);
#ifndef glVertexAttribI2ivEXT
#define glVertexAttribI2ivEXT(index, v) glatter_glVertexAttribI2ivEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI2ivEXT_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttribI2uiEXT
#define glVertexAttribI2uiEXT(index, x, y) glatter_glVertexAttribI2uiEXT_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI2uiEXT_debug(GLuint index, GLuint x, GLuint y, const char* file, int line);
#ifndef glVertexAttribI2uivEXT
#define glVertexAttribI2uivEXT(index, v) glatter_glVertexAttribI2uivEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI2uivEXT_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttribI3iEXT
#define glVertexAttribI3iEXT(index, x, y, z) glatter_glVertexAttribI3iEXT_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI3iEXT_debug(GLuint index, GLint x, GLint y, GLint z, const char* file, int line);
#ifndef glVertexAttribI3ivEXT
#define glVertexAttribI3ivEXT(index, v) glatter_glVertexAttribI3ivEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI3ivEXT_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttribI3uiEXT
#define glVertexAttribI3uiEXT(index, x, y, z) glatter_glVertexAttribI3uiEXT_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI3uiEXT_debug(GLuint index, GLuint x, GLuint y, GLuint z, const char* file, int line);
#ifndef glVertexAttribI3uivEXT
#define glVertexAttribI3uivEXT(index, v) glatter_glVertexAttribI3uivEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI3uivEXT_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttribI4bvEXT
#define glVertexAttribI4bvEXT(index, v) glatter_glVertexAttribI4bvEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4bvEXT_debug(GLuint index, const GLbyte *v, const char* file, int line);
#ifndef glVertexAttribI4iEXT
#define glVertexAttribI4iEXT(index, x, y, z, w) glatter_glVertexAttribI4iEXT_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4iEXT_debug(GLuint index, GLint x, GLint y, GLint z, GLint w, const char* file, int line);
#ifndef glVertexAttribI4ivEXT
#define glVertexAttribI4ivEXT(index, v) glatter_glVertexAttribI4ivEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4ivEXT_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttribI4svEXT
#define glVertexAttribI4svEXT(index, v) glatter_glVertexAttribI4svEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4svEXT_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttribI4ubvEXT
#define glVertexAttribI4ubvEXT(index, v) glatter_glVertexAttribI4ubvEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4ubvEXT_debug(GLuint index, const GLubyte *v, const char* file, int line);
#ifndef glVertexAttribI4uiEXT
#define glVertexAttribI4uiEXT(index, x, y, z, w) glatter_glVertexAttribI4uiEXT_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4uiEXT_debug(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w, const char* file, int line);
#ifndef glVertexAttribI4uivEXT
#define glVertexAttribI4uivEXT(index, v) glatter_glVertexAttribI4uivEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4uivEXT_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttribI4usvEXT
#define glVertexAttribI4usvEXT(index, v) glatter_glVertexAttribI4usvEXT_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4usvEXT_debug(GLuint index, const GLushort *v, const char* file, int line);
#ifndef glVertexAttribIPointerEXT
#define glVertexAttribIPointerEXT(index, size, type, stride, pointer) glatter_glVertexAttribIPointerEXT_debug((index), (size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribIPointerEXT_debug(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#endif // defined(GL_NV_vertex_program4)
#if defined(GL_NV_video_capture)
#ifndef glBeginVideoCaptureNV
#define glBeginVideoCaptureNV(video_capture_slot) glatter_glBeginVideoCaptureNV_debug((video_capture_slot), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginVideoCaptureNV_debug(GLuint video_capture_slot, const char* file, int line);
#ifndef glBindVideoCaptureStreamBufferNV
#define glBindVideoCaptureStreamBufferNV(video_capture_slot, stream, frame_region, offset) glatter_glBindVideoCaptureStreamBufferNV_debug((video_capture_slot), (stream), (frame_region), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindVideoCaptureStreamBufferNV_debug(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLintptrARB offset, const char* file, int line);
#ifndef glBindVideoCaptureStreamTextureNV
#define glBindVideoCaptureStreamTextureNV(video_capture_slot, stream, frame_region, target, texture) glatter_glBindVideoCaptureStreamTextureNV_debug((video_capture_slot), (stream), (frame_region), (target), (texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindVideoCaptureStreamTextureNV_debug(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLenum target, GLuint texture, const char* file, int line);
#ifndef glEndVideoCaptureNV
#define glEndVideoCaptureNV(video_capture_slot) glatter_glEndVideoCaptureNV_debug((video_capture_slot), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndVideoCaptureNV_debug(GLuint video_capture_slot, const char* file, int line);
#ifndef glGetVideoCaptureStreamdvNV
#define glGetVideoCaptureStreamdvNV(video_capture_slot, stream, pname, params) glatter_glGetVideoCaptureStreamdvNV_debug((video_capture_slot), (stream), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVideoCaptureStreamdvNV_debug(GLuint video_capture_slot, GLuint stream, GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glGetVideoCaptureStreamfvNV
#define glGetVideoCaptureStreamfvNV(video_capture_slot, stream, pname, params) glatter_glGetVideoCaptureStreamfvNV_debug((video_capture_slot), (stream), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVideoCaptureStreamfvNV_debug(GLuint video_capture_slot, GLuint stream, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetVideoCaptureStreamivNV
#define glGetVideoCaptureStreamivNV(video_capture_slot, stream, pname, params) glatter_glGetVideoCaptureStreamivNV_debug((video_capture_slot), (stream), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVideoCaptureStreamivNV_debug(GLuint video_capture_slot, GLuint stream, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetVideoCaptureivNV
#define glGetVideoCaptureivNV(video_capture_slot, pname, params) glatter_glGetVideoCaptureivNV_debug((video_capture_slot), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVideoCaptureivNV_debug(GLuint video_capture_slot, GLenum pname, GLint *params, const char* file, int line);
#ifndef glVideoCaptureNV
#define glVideoCaptureNV(video_capture_slot, sequence_num, capture_time) glatter_glVideoCaptureNV_debug((video_capture_slot), (sequence_num), (capture_time), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glVideoCaptureNV_debug(GLuint video_capture_slot, GLuint *sequence_num, GLuint64EXT *capture_time, const char* file, int line);
#ifndef glVideoCaptureStreamParameterdvNV
#define glVideoCaptureStreamParameterdvNV(video_capture_slot, stream, pname, params) glatter_glVideoCaptureStreamParameterdvNV_debug((video_capture_slot), (stream), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVideoCaptureStreamParameterdvNV_debug(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLdouble *params, const char* file, int line);
#ifndef glVideoCaptureStreamParameterfvNV
#define glVideoCaptureStreamParameterfvNV(video_capture_slot, stream, pname, params) glatter_glVideoCaptureStreamParameterfvNV_debug((video_capture_slot), (stream), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVideoCaptureStreamParameterfvNV_debug(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glVideoCaptureStreamParameterivNV
#define glVideoCaptureStreamParameterivNV(video_capture_slot, stream, pname, params) glatter_glVideoCaptureStreamParameterivNV_debug((video_capture_slot), (stream), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVideoCaptureStreamParameterivNV_debug(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLint *params, const char* file, int line);
#endif // defined(GL_NV_video_capture)
#if defined(GL_NV_viewport_swizzle)
#ifndef glViewportSwizzleNV
#define glViewportSwizzleNV(index, swizzlex, swizzley, swizzlez, swizzlew) glatter_glViewportSwizzleNV_debug((index), (swizzlex), (swizzley), (swizzlez), (swizzlew), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glViewportSwizzleNV_debug(GLuint index, GLenum swizzlex, GLenum swizzley, GLenum swizzlez, GLenum swizzlew, const char* file, int line);
#endif // defined(GL_NV_viewport_swizzle)
#if defined(GL_OES_byte_coordinates)
#ifndef glMultiTexCoord1bOES
#define glMultiTexCoord1bOES(texture, s) glatter_glMultiTexCoord1bOES_debug((texture), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1bOES_debug(GLenum texture, GLbyte s, const char* file, int line);
#ifndef glMultiTexCoord1bvOES
#define glMultiTexCoord1bvOES(texture, coords) glatter_glMultiTexCoord1bvOES_debug((texture), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1bvOES_debug(GLenum texture, const GLbyte *coords, const char* file, int line);
#ifndef glMultiTexCoord2bOES
#define glMultiTexCoord2bOES(texture, s, t) glatter_glMultiTexCoord2bOES_debug((texture), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2bOES_debug(GLenum texture, GLbyte s, GLbyte t, const char* file, int line);
#ifndef glMultiTexCoord2bvOES
#define glMultiTexCoord2bvOES(texture, coords) glatter_glMultiTexCoord2bvOES_debug((texture), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2bvOES_debug(GLenum texture, const GLbyte *coords, const char* file, int line);
#ifndef glMultiTexCoord3bOES
#define glMultiTexCoord3bOES(texture, s, t, r) glatter_glMultiTexCoord3bOES_debug((texture), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3bOES_debug(GLenum texture, GLbyte s, GLbyte t, GLbyte r, const char* file, int line);
#ifndef glMultiTexCoord3bvOES
#define glMultiTexCoord3bvOES(texture, coords) glatter_glMultiTexCoord3bvOES_debug((texture), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3bvOES_debug(GLenum texture, const GLbyte *coords, const char* file, int line);
#ifndef glMultiTexCoord4bOES
#define glMultiTexCoord4bOES(texture, s, t, r, q) glatter_glMultiTexCoord4bOES_debug((texture), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4bOES_debug(GLenum texture, GLbyte s, GLbyte t, GLbyte r, GLbyte q, const char* file, int line);
#ifndef glMultiTexCoord4bvOES
#define glMultiTexCoord4bvOES(texture, coords) glatter_glMultiTexCoord4bvOES_debug((texture), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4bvOES_debug(GLenum texture, const GLbyte *coords, const char* file, int line);
#ifndef glTexCoord1bOES
#define glTexCoord1bOES(s) glatter_glTexCoord1bOES_debug((s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1bOES_debug(GLbyte s, const char* file, int line);
#ifndef glTexCoord1bvOES
#define glTexCoord1bvOES(coords) glatter_glTexCoord1bvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1bvOES_debug(const GLbyte *coords, const char* file, int line);
#ifndef glTexCoord2bOES
#define glTexCoord2bOES(s, t) glatter_glTexCoord2bOES_debug((s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2bOES_debug(GLbyte s, GLbyte t, const char* file, int line);
#ifndef glTexCoord2bvOES
#define glTexCoord2bvOES(coords) glatter_glTexCoord2bvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2bvOES_debug(const GLbyte *coords, const char* file, int line);
#ifndef glTexCoord3bOES
#define glTexCoord3bOES(s, t, r) glatter_glTexCoord3bOES_debug((s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3bOES_debug(GLbyte s, GLbyte t, GLbyte r, const char* file, int line);
#ifndef glTexCoord3bvOES
#define glTexCoord3bvOES(coords) glatter_glTexCoord3bvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3bvOES_debug(const GLbyte *coords, const char* file, int line);
#ifndef glTexCoord4bOES
#define glTexCoord4bOES(s, t, r, q) glatter_glTexCoord4bOES_debug((s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4bOES_debug(GLbyte s, GLbyte t, GLbyte r, GLbyte q, const char* file, int line);
#ifndef glTexCoord4bvOES
#define glTexCoord4bvOES(coords) glatter_glTexCoord4bvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4bvOES_debug(const GLbyte *coords, const char* file, int line);
#ifndef glVertex2bOES
#define glVertex2bOES(x, y) glatter_glVertex2bOES_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2bOES_debug(GLbyte x, GLbyte y, const char* file, int line);
#ifndef glVertex2bvOES
#define glVertex2bvOES(coords) glatter_glVertex2bvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2bvOES_debug(const GLbyte *coords, const char* file, int line);
#ifndef glVertex3bOES
#define glVertex3bOES(x, y, z) glatter_glVertex3bOES_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3bOES_debug(GLbyte x, GLbyte y, GLbyte z, const char* file, int line);
#ifndef glVertex3bvOES
#define glVertex3bvOES(coords) glatter_glVertex3bvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3bvOES_debug(const GLbyte *coords, const char* file, int line);
#ifndef glVertex4bOES
#define glVertex4bOES(x, y, z, w) glatter_glVertex4bOES_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4bOES_debug(GLbyte x, GLbyte y, GLbyte z, GLbyte w, const char* file, int line);
#ifndef glVertex4bvOES
#define glVertex4bvOES(coords) glatter_glVertex4bvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4bvOES_debug(const GLbyte *coords, const char* file, int line);
#endif // defined(GL_OES_byte_coordinates)
#if defined(GL_OES_fixed_point)
#ifndef glAccumxOES
#define glAccumxOES(op, value) glatter_glAccumxOES_debug((op), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAccumxOES_debug(GLenum op, GLfixed value, const char* file, int line);
#ifndef glAlphaFuncxOES
#define glAlphaFuncxOES(func, ref) glatter_glAlphaFuncxOES_debug((func), (ref), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAlphaFuncxOES_debug(GLenum func, GLfixed ref, const char* file, int line);
#ifndef glBitmapxOES
#define glBitmapxOES(width, height, xorig, yorig, xmove, ymove, bitmap) glatter_glBitmapxOES_debug((width), (height), (xorig), (yorig), (xmove), (ymove), (bitmap), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBitmapxOES_debug(GLsizei width, GLsizei height, GLfixed xorig, GLfixed yorig, GLfixed xmove, GLfixed ymove, const GLubyte *bitmap, const char* file, int line);
#ifndef glBlendColorxOES
#define glBlendColorxOES(red, green, blue, alpha) glatter_glBlendColorxOES_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendColorxOES_debug(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha, const char* file, int line);
#ifndef glClearAccumxOES
#define glClearAccumxOES(red, green, blue, alpha) glatter_glClearAccumxOES_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearAccumxOES_debug(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha, const char* file, int line);
#ifndef glClearColorxOES
#define glClearColorxOES(red, green, blue, alpha) glatter_glClearColorxOES_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearColorxOES_debug(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha, const char* file, int line);
#ifndef glClearDepthxOES
#define glClearDepthxOES(depth) glatter_glClearDepthxOES_debug((depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearDepthxOES_debug(GLfixed depth, const char* file, int line);
#ifndef glClipPlanexOES
#define glClipPlanexOES(plane, equation) glatter_glClipPlanexOES_debug((plane), (equation), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClipPlanexOES_debug(GLenum plane, const GLfixed *equation, const char* file, int line);
#ifndef glColor3xOES
#define glColor3xOES(red, green, blue) glatter_glColor3xOES_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3xOES_debug(GLfixed red, GLfixed green, GLfixed blue, const char* file, int line);
#ifndef glColor3xvOES
#define glColor3xvOES(components) glatter_glColor3xvOES_debug((components), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3xvOES_debug(const GLfixed *components, const char* file, int line);
#ifndef glColor4xOES
#define glColor4xOES(red, green, blue, alpha) glatter_glColor4xOES_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4xOES_debug(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha, const char* file, int line);
#ifndef glColor4xvOES
#define glColor4xvOES(components) glatter_glColor4xvOES_debug((components), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4xvOES_debug(const GLfixed *components, const char* file, int line);
#ifndef glConvolutionParameterxOES
#define glConvolutionParameterxOES(target, pname, param) glatter_glConvolutionParameterxOES_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterxOES_debug(GLenum target, GLenum pname, GLfixed param, const char* file, int line);
#ifndef glConvolutionParameterxvOES
#define glConvolutionParameterxvOES(target, pname, params) glatter_glConvolutionParameterxvOES_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterxvOES_debug(GLenum target, GLenum pname, const GLfixed *params, const char* file, int line);
#ifndef glDepthRangexOES
#define glDepthRangexOES(n, f) glatter_glDepthRangexOES_debug((n), (f), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthRangexOES_debug(GLfixed n, GLfixed f, const char* file, int line);
#ifndef glEvalCoord1xOES
#define glEvalCoord1xOES(u) glatter_glEvalCoord1xOES_debug((u), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1xOES_debug(GLfixed u, const char* file, int line);
#ifndef glEvalCoord1xvOES
#define glEvalCoord1xvOES(coords) glatter_glEvalCoord1xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glEvalCoord2xOES
#define glEvalCoord2xOES(u, v) glatter_glEvalCoord2xOES_debug((u), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2xOES_debug(GLfixed u, GLfixed v, const char* file, int line);
#ifndef glEvalCoord2xvOES
#define glEvalCoord2xvOES(coords) glatter_glEvalCoord2xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glFeedbackBufferxOES
#define glFeedbackBufferxOES(n, type, buffer) glatter_glFeedbackBufferxOES_debug((n), (type), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFeedbackBufferxOES_debug(GLsizei n, GLenum type, const GLfixed *buffer, const char* file, int line);
#ifndef glFogxOES
#define glFogxOES(pname, param) glatter_glFogxOES_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogxOES_debug(GLenum pname, GLfixed param, const char* file, int line);
#ifndef glFogxvOES
#define glFogxvOES(pname, param) glatter_glFogxvOES_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogxvOES_debug(GLenum pname, const GLfixed *param, const char* file, int line);
#ifndef glFrustumxOES
#define glFrustumxOES(l, r, b, t, n, f) glatter_glFrustumxOES_debug((l), (r), (b), (t), (n), (f), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFrustumxOES_debug(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f, const char* file, int line);
#ifndef glGetClipPlanexOES
#define glGetClipPlanexOES(plane, equation) glatter_glGetClipPlanexOES_debug((plane), (equation), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetClipPlanexOES_debug(GLenum plane, GLfixed *equation, const char* file, int line);
#ifndef glGetConvolutionParameterxvOES
#define glGetConvolutionParameterxvOES(target, pname, params) glatter_glGetConvolutionParameterxvOES_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionParameterxvOES_debug(GLenum target, GLenum pname, GLfixed *params, const char* file, int line);
#ifndef glGetFixedvOES
#define glGetFixedvOES(pname, params) glatter_glGetFixedvOES_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFixedvOES_debug(GLenum pname, GLfixed *params, const char* file, int line);
#ifndef glGetHistogramParameterxvOES
#define glGetHistogramParameterxvOES(target, pname, params) glatter_glGetHistogramParameterxvOES_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramParameterxvOES_debug(GLenum target, GLenum pname, GLfixed *params, const char* file, int line);
#ifndef glGetLightxOES
#define glGetLightxOES(light, pname, params) glatter_glGetLightxOES_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetLightxOES_debug(GLenum light, GLenum pname, GLfixed *params, const char* file, int line);
#ifndef glGetMapxvOES
#define glGetMapxvOES(target, query, v) glatter_glGetMapxvOES_debug((target), (query), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMapxvOES_debug(GLenum target, GLenum query, GLfixed *v, const char* file, int line);
#ifndef glGetMaterialxOES
#define glGetMaterialxOES(face, pname, param) glatter_glGetMaterialxOES_debug((face), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMaterialxOES_debug(GLenum face, GLenum pname, GLfixed param, const char* file, int line);
#ifndef glGetPixelMapxv
#define glGetPixelMapxv(map, size, values) glatter_glGetPixelMapxv_debug((map), (size), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPixelMapxv_debug(GLenum map, GLint size, GLfixed *values, const char* file, int line);
#ifndef glGetTexEnvxvOES
#define glGetTexEnvxvOES(target, pname, params) glatter_glGetTexEnvxvOES_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexEnvxvOES_debug(GLenum target, GLenum pname, GLfixed *params, const char* file, int line);
#ifndef glGetTexGenxvOES
#define glGetTexGenxvOES(coord, pname, params) glatter_glGetTexGenxvOES_debug((coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexGenxvOES_debug(GLenum coord, GLenum pname, GLfixed *params, const char* file, int line);
#ifndef glGetTexLevelParameterxvOES
#define glGetTexLevelParameterxvOES(target, level, pname, params) glatter_glGetTexLevelParameterxvOES_debug((target), (level), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexLevelParameterxvOES_debug(GLenum target, GLint level, GLenum pname, GLfixed *params, const char* file, int line);
#ifndef glGetTexParameterxvOES
#define glGetTexParameterxvOES(target, pname, params) glatter_glGetTexParameterxvOES_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterxvOES_debug(GLenum target, GLenum pname, GLfixed *params, const char* file, int line);
#ifndef glIndexxOES
#define glIndexxOES(component) glatter_glIndexxOES_debug((component), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexxOES_debug(GLfixed component, const char* file, int line);
#ifndef glIndexxvOES
#define glIndexxvOES(component) glatter_glIndexxvOES_debug((component), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIndexxvOES_debug(const GLfixed *component, const char* file, int line);
#ifndef glLightModelxOES
#define glLightModelxOES(pname, param) glatter_glLightModelxOES_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightModelxOES_debug(GLenum pname, GLfixed param, const char* file, int line);
#ifndef glLightModelxvOES
#define glLightModelxvOES(pname, param) glatter_glLightModelxvOES_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightModelxvOES_debug(GLenum pname, const GLfixed *param, const char* file, int line);
#ifndef glLightxOES
#define glLightxOES(light, pname, param) glatter_glLightxOES_debug((light), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightxOES_debug(GLenum light, GLenum pname, GLfixed param, const char* file, int line);
#ifndef glLightxvOES
#define glLightxvOES(light, pname, params) glatter_glLightxvOES_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightxvOES_debug(GLenum light, GLenum pname, const GLfixed *params, const char* file, int line);
#ifndef glLineWidthxOES
#define glLineWidthxOES(width) glatter_glLineWidthxOES_debug((width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLineWidthxOES_debug(GLfixed width, const char* file, int line);
#ifndef glLoadMatrixxOES
#define glLoadMatrixxOES(m) glatter_glLoadMatrixxOES_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadMatrixxOES_debug(const GLfixed *m, const char* file, int line);
#ifndef glLoadTransposeMatrixxOES
#define glLoadTransposeMatrixxOES(m) glatter_glLoadTransposeMatrixxOES_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadTransposeMatrixxOES_debug(const GLfixed *m, const char* file, int line);
#ifndef glMap1xOES
#define glMap1xOES(target, u1, u2, stride, order, points) glatter_glMap1xOES_debug((target), (u1), (u2), (stride), (order), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMap1xOES_debug(GLenum target, GLfixed u1, GLfixed u2, GLint stride, GLint order, GLfixed points, const char* file, int line);
#ifndef glMap2xOES
#define glMap2xOES(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points) glatter_glMap2xOES_debug((target), (u1), (u2), (ustride), (uorder), (v1), (v2), (vstride), (vorder), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMap2xOES_debug(GLenum target, GLfixed u1, GLfixed u2, GLint ustride, GLint uorder, GLfixed v1, GLfixed v2, GLint vstride, GLint vorder, GLfixed points, const char* file, int line);
#ifndef glMapGrid1xOES
#define glMapGrid1xOES(n, u1, u2) glatter_glMapGrid1xOES_debug((n), (u1), (u2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapGrid1xOES_debug(GLint n, GLfixed u1, GLfixed u2, const char* file, int line);
#ifndef glMapGrid2xOES
#define glMapGrid2xOES(n, u1, u2, v1, v2) glatter_glMapGrid2xOES_debug((n), (u1), (u2), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMapGrid2xOES_debug(GLint n, GLfixed u1, GLfixed u2, GLfixed v1, GLfixed v2, const char* file, int line);
#ifndef glMaterialxOES
#define glMaterialxOES(face, pname, param) glatter_glMaterialxOES_debug((face), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMaterialxOES_debug(GLenum face, GLenum pname, GLfixed param, const char* file, int line);
#ifndef glMaterialxvOES
#define glMaterialxvOES(face, pname, param) glatter_glMaterialxvOES_debug((face), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMaterialxvOES_debug(GLenum face, GLenum pname, const GLfixed *param, const char* file, int line);
#ifndef glMultMatrixxOES
#define glMultMatrixxOES(m) glatter_glMultMatrixxOES_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultMatrixxOES_debug(const GLfixed *m, const char* file, int line);
#ifndef glMultTransposeMatrixxOES
#define glMultTransposeMatrixxOES(m) glatter_glMultTransposeMatrixxOES_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultTransposeMatrixxOES_debug(const GLfixed *m, const char* file, int line);
#ifndef glMultiTexCoord1xOES
#define glMultiTexCoord1xOES(texture, s) glatter_glMultiTexCoord1xOES_debug((texture), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1xOES_debug(GLenum texture, GLfixed s, const char* file, int line);
#ifndef glMultiTexCoord1xvOES
#define glMultiTexCoord1xvOES(texture, coords) glatter_glMultiTexCoord1xvOES_debug((texture), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1xvOES_debug(GLenum texture, const GLfixed *coords, const char* file, int line);
#ifndef glMultiTexCoord2xOES
#define glMultiTexCoord2xOES(texture, s, t) glatter_glMultiTexCoord2xOES_debug((texture), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2xOES_debug(GLenum texture, GLfixed s, GLfixed t, const char* file, int line);
#ifndef glMultiTexCoord2xvOES
#define glMultiTexCoord2xvOES(texture, coords) glatter_glMultiTexCoord2xvOES_debug((texture), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2xvOES_debug(GLenum texture, const GLfixed *coords, const char* file, int line);
#ifndef glMultiTexCoord3xOES
#define glMultiTexCoord3xOES(texture, s, t, r) glatter_glMultiTexCoord3xOES_debug((texture), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3xOES_debug(GLenum texture, GLfixed s, GLfixed t, GLfixed r, const char* file, int line);
#ifndef glMultiTexCoord3xvOES
#define glMultiTexCoord3xvOES(texture, coords) glatter_glMultiTexCoord3xvOES_debug((texture), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3xvOES_debug(GLenum texture, const GLfixed *coords, const char* file, int line);
#ifndef glMultiTexCoord4xOES
#define glMultiTexCoord4xOES(texture, s, t, r, q) glatter_glMultiTexCoord4xOES_debug((texture), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4xOES_debug(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q, const char* file, int line);
#ifndef glMultiTexCoord4xvOES
#define glMultiTexCoord4xvOES(texture, coords) glatter_glMultiTexCoord4xvOES_debug((texture), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4xvOES_debug(GLenum texture, const GLfixed *coords, const char* file, int line);
#ifndef glNormal3xOES
#define glNormal3xOES(nx, ny, nz) glatter_glNormal3xOES_debug((nx), (ny), (nz), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3xOES_debug(GLfixed nx, GLfixed ny, GLfixed nz, const char* file, int line);
#ifndef glNormal3xvOES
#define glNormal3xvOES(coords) glatter_glNormal3xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glOrthoxOES
#define glOrthoxOES(l, r, b, t, n, f) glatter_glOrthoxOES_debug((l), (r), (b), (t), (n), (f), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glOrthoxOES_debug(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f, const char* file, int line);
#ifndef glPassThroughxOES
#define glPassThroughxOES(token) glatter_glPassThroughxOES_debug((token), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPassThroughxOES_debug(GLfixed token, const char* file, int line);
#ifndef glPixelMapx
#define glPixelMapx(map, size, values) glatter_glPixelMapx_debug((map), (size), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelMapx_debug(GLenum map, GLint size, const GLfixed *values, const char* file, int line);
#ifndef glPixelStorex
#define glPixelStorex(pname, param) glatter_glPixelStorex_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelStorex_debug(GLenum pname, GLfixed param, const char* file, int line);
#ifndef glPixelTransferxOES
#define glPixelTransferxOES(pname, param) glatter_glPixelTransferxOES_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTransferxOES_debug(GLenum pname, GLfixed param, const char* file, int line);
#ifndef glPixelZoomxOES
#define glPixelZoomxOES(xfactor, yfactor) glatter_glPixelZoomxOES_debug((xfactor), (yfactor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelZoomxOES_debug(GLfixed xfactor, GLfixed yfactor, const char* file, int line);
#ifndef glPointParameterxvOES
#define glPointParameterxvOES(pname, params) glatter_glPointParameterxvOES_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterxvOES_debug(GLenum pname, const GLfixed *params, const char* file, int line);
#ifndef glPointSizexOES
#define glPointSizexOES(size) glatter_glPointSizexOES_debug((size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointSizexOES_debug(GLfixed size, const char* file, int line);
#ifndef glPolygonOffsetxOES
#define glPolygonOffsetxOES(factor, units) glatter_glPolygonOffsetxOES_debug((factor), (units), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffsetxOES_debug(GLfixed factor, GLfixed units, const char* file, int line);
#ifndef glPrioritizeTexturesxOES
#define glPrioritizeTexturesxOES(n, textures, priorities) glatter_glPrioritizeTexturesxOES_debug((n), (textures), (priorities), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPrioritizeTexturesxOES_debug(GLsizei n, const GLuint *textures, const GLfixed *priorities, const char* file, int line);
#ifndef glRasterPos2xOES
#define glRasterPos2xOES(x, y) glatter_glRasterPos2xOES_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2xOES_debug(GLfixed x, GLfixed y, const char* file, int line);
#ifndef glRasterPos2xvOES
#define glRasterPos2xvOES(coords) glatter_glRasterPos2xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glRasterPos3xOES
#define glRasterPos3xOES(x, y, z) glatter_glRasterPos3xOES_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3xOES_debug(GLfixed x, GLfixed y, GLfixed z, const char* file, int line);
#ifndef glRasterPos3xvOES
#define glRasterPos3xvOES(coords) glatter_glRasterPos3xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glRasterPos4xOES
#define glRasterPos4xOES(x, y, z, w) glatter_glRasterPos4xOES_debug((x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4xOES_debug(GLfixed x, GLfixed y, GLfixed z, GLfixed w, const char* file, int line);
#ifndef glRasterPos4xvOES
#define glRasterPos4xvOES(coords) glatter_glRasterPos4xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glRectxOES
#define glRectxOES(x1, y1, x2, y2) glatter_glRectxOES_debug((x1), (y1), (x2), (y2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRectxOES_debug(GLfixed x1, GLfixed y1, GLfixed x2, GLfixed y2, const char* file, int line);
#ifndef glRectxvOES
#define glRectxvOES(v1, v2) glatter_glRectxvOES_debug((v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRectxvOES_debug(const GLfixed *v1, const GLfixed *v2, const char* file, int line);
#ifndef glRotatexOES
#define glRotatexOES(angle, x, y, z) glatter_glRotatexOES_debug((angle), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRotatexOES_debug(GLfixed angle, GLfixed x, GLfixed y, GLfixed z, const char* file, int line);
#ifndef glScalexOES
#define glScalexOES(x, y, z) glatter_glScalexOES_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glScalexOES_debug(GLfixed x, GLfixed y, GLfixed z, const char* file, int line);
#ifndef glTexCoord1xOES
#define glTexCoord1xOES(s) glatter_glTexCoord1xOES_debug((s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1xOES_debug(GLfixed s, const char* file, int line);
#ifndef glTexCoord1xvOES
#define glTexCoord1xvOES(coords) glatter_glTexCoord1xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glTexCoord2xOES
#define glTexCoord2xOES(s, t) glatter_glTexCoord2xOES_debug((s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2xOES_debug(GLfixed s, GLfixed t, const char* file, int line);
#ifndef glTexCoord2xvOES
#define glTexCoord2xvOES(coords) glatter_glTexCoord2xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glTexCoord3xOES
#define glTexCoord3xOES(s, t, r) glatter_glTexCoord3xOES_debug((s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3xOES_debug(GLfixed s, GLfixed t, GLfixed r, const char* file, int line);
#ifndef glTexCoord3xvOES
#define glTexCoord3xvOES(coords) glatter_glTexCoord3xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glTexCoord4xOES
#define glTexCoord4xOES(s, t, r, q) glatter_glTexCoord4xOES_debug((s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4xOES_debug(GLfixed s, GLfixed t, GLfixed r, GLfixed q, const char* file, int line);
#ifndef glTexCoord4xvOES
#define glTexCoord4xvOES(coords) glatter_glTexCoord4xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glTexEnvxOES
#define glTexEnvxOES(target, pname, param) glatter_glTexEnvxOES_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexEnvxOES_debug(GLenum target, GLenum pname, GLfixed param, const char* file, int line);
#ifndef glTexEnvxvOES
#define glTexEnvxvOES(target, pname, params) glatter_glTexEnvxvOES_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexEnvxvOES_debug(GLenum target, GLenum pname, const GLfixed *params, const char* file, int line);
#ifndef glTexGenxOES
#define glTexGenxOES(coord, pname, param) glatter_glTexGenxOES_debug((coord), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexGenxOES_debug(GLenum coord, GLenum pname, GLfixed param, const char* file, int line);
#ifndef glTexGenxvOES
#define glTexGenxvOES(coord, pname, params) glatter_glTexGenxvOES_debug((coord), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexGenxvOES_debug(GLenum coord, GLenum pname, const GLfixed *params, const char* file, int line);
#ifndef glTexParameterxOES
#define glTexParameterxOES(target, pname, param) glatter_glTexParameterxOES_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameterxOES_debug(GLenum target, GLenum pname, GLfixed param, const char* file, int line);
#ifndef glTexParameterxvOES
#define glTexParameterxvOES(target, pname, params) glatter_glTexParameterxvOES_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameterxvOES_debug(GLenum target, GLenum pname, const GLfixed *params, const char* file, int line);
#ifndef glTranslatexOES
#define glTranslatexOES(x, y, z) glatter_glTranslatexOES_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTranslatexOES_debug(GLfixed x, GLfixed y, GLfixed z, const char* file, int line);
#ifndef glVertex2xOES
#define glVertex2xOES(x) glatter_glVertex2xOES_debug((x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2xOES_debug(GLfixed x, const char* file, int line);
#ifndef glVertex2xvOES
#define glVertex2xvOES(coords) glatter_glVertex2xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex2xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glVertex3xOES
#define glVertex3xOES(x, y) glatter_glVertex3xOES_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3xOES_debug(GLfixed x, GLfixed y, const char* file, int line);
#ifndef glVertex3xvOES
#define glVertex3xvOES(coords) glatter_glVertex3xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex3xvOES_debug(const GLfixed *coords, const char* file, int line);
#ifndef glVertex4xOES
#define glVertex4xOES(x, y, z) glatter_glVertex4xOES_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4xOES_debug(GLfixed x, GLfixed y, GLfixed z, const char* file, int line);
#ifndef glVertex4xvOES
#define glVertex4xvOES(coords) glatter_glVertex4xvOES_debug((coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertex4xvOES_debug(const GLfixed *coords, const char* file, int line);
#endif // defined(GL_OES_fixed_point)
#if defined(GL_OES_query_matrix)
#ifndef glQueryMatrixxOES
#define glQueryMatrixxOES(mantissa, exponent) glatter_glQueryMatrixxOES_debug((mantissa), (exponent), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLbitfield glatter_glQueryMatrixxOES_debug(GLfixed *mantissa, GLint *exponent, const char* file, int line);
#endif // defined(GL_OES_query_matrix)
#if defined(GL_OES_single_precision)
#ifndef glClearDepthfOES
#define glClearDepthfOES(depth) glatter_glClearDepthfOES_debug((depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearDepthfOES_debug(GLclampf depth, const char* file, int line);
#ifndef glClipPlanefOES
#define glClipPlanefOES(plane, equation) glatter_glClipPlanefOES_debug((plane), (equation), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClipPlanefOES_debug(GLenum plane, const GLfloat *equation, const char* file, int line);
#ifndef glDepthRangefOES
#define glDepthRangefOES(n, f) glatter_glDepthRangefOES_debug((n), (f), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthRangefOES_debug(GLclampf n, GLclampf f, const char* file, int line);
#ifndef glFrustumfOES
#define glFrustumfOES(l, r, b, t, n, f) glatter_glFrustumfOES_debug((l), (r), (b), (t), (n), (f), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFrustumfOES_debug(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f, const char* file, int line);
#ifndef glGetClipPlanefOES
#define glGetClipPlanefOES(plane, equation) glatter_glGetClipPlanefOES_debug((plane), (equation), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetClipPlanefOES_debug(GLenum plane, GLfloat *equation, const char* file, int line);
#ifndef glOrthofOES
#define glOrthofOES(l, r, b, t, n, f) glatter_glOrthofOES_debug((l), (r), (b), (t), (n), (f), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glOrthofOES_debug(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f, const char* file, int line);
#endif // defined(GL_OES_single_precision)
#if defined(GL_OVR_multiview)
#ifndef glFramebufferTextureMultiviewOVR
#define glFramebufferTextureMultiviewOVR(target, attachment, texture, level, baseViewIndex, numViews) glatter_glFramebufferTextureMultiviewOVR_debug((target), (attachment), (texture), (level), (baseViewIndex), (numViews), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureMultiviewOVR_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint baseViewIndex, GLsizei numViews, const char* file, int line);
#endif // defined(GL_OVR_multiview)
#if defined(GL_PGI_misc_hints)
#ifndef glHintPGI
#define glHintPGI(target, mode) glatter_glHintPGI_debug((target), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glHintPGI_debug(GLenum target, GLint mode, const char* file, int line);
#endif // defined(GL_PGI_misc_hints)
#if defined(GL_SGIS_detail_texture)
#ifndef glDetailTexFuncSGIS
#define glDetailTexFuncSGIS(target, n, points) glatter_glDetailTexFuncSGIS_debug((target), (n), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDetailTexFuncSGIS_debug(GLenum target, GLsizei n, const GLfloat *points, const char* file, int line);
#ifndef glGetDetailTexFuncSGIS
#define glGetDetailTexFuncSGIS(target, points) glatter_glGetDetailTexFuncSGIS_debug((target), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetDetailTexFuncSGIS_debug(GLenum target, GLfloat *points, const char* file, int line);
#endif // defined(GL_SGIS_detail_texture)
#if defined(GL_SGIS_fog_function)
#ifndef glFogFuncSGIS
#define glFogFuncSGIS(n, points) glatter_glFogFuncSGIS_debug((n), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogFuncSGIS_debug(GLsizei n, const GLfloat *points, const char* file, int line);
#ifndef glGetFogFuncSGIS
#define glGetFogFuncSGIS(points) glatter_glGetFogFuncSGIS_debug((points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFogFuncSGIS_debug(GLfloat *points, const char* file, int line);
#endif // defined(GL_SGIS_fog_function)
#if defined(GL_SGIS_multisample)
#ifndef glSampleMaskSGIS
#define glSampleMaskSGIS(value, invert) glatter_glSampleMaskSGIS_debug((value), (invert), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSampleMaskSGIS_debug(GLclampf value, GLboolean invert, const char* file, int line);
#ifndef glSamplePatternSGIS
#define glSamplePatternSGIS(pattern) glatter_glSamplePatternSGIS_debug((pattern), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSamplePatternSGIS_debug(GLenum pattern, const char* file, int line);
#endif // defined(GL_SGIS_multisample)
#if defined(GL_SGIS_pixel_texture)
#ifndef glGetPixelTexGenParameterfvSGIS
#define glGetPixelTexGenParameterfvSGIS(pname, params) glatter_glGetPixelTexGenParameterfvSGIS_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPixelTexGenParameterfvSGIS_debug(GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetPixelTexGenParameterivSGIS
#define glGetPixelTexGenParameterivSGIS(pname, params) glatter_glGetPixelTexGenParameterivSGIS_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetPixelTexGenParameterivSGIS_debug(GLenum pname, GLint *params, const char* file, int line);
#ifndef glPixelTexGenParameterfSGIS
#define glPixelTexGenParameterfSGIS(pname, param) glatter_glPixelTexGenParameterfSGIS_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTexGenParameterfSGIS_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glPixelTexGenParameterfvSGIS
#define glPixelTexGenParameterfvSGIS(pname, params) glatter_glPixelTexGenParameterfvSGIS_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTexGenParameterfvSGIS_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glPixelTexGenParameteriSGIS
#define glPixelTexGenParameteriSGIS(pname, param) glatter_glPixelTexGenParameteriSGIS_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTexGenParameteriSGIS_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glPixelTexGenParameterivSGIS
#define glPixelTexGenParameterivSGIS(pname, params) glatter_glPixelTexGenParameterivSGIS_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTexGenParameterivSGIS_debug(GLenum pname, const GLint *params, const char* file, int line);
#endif // defined(GL_SGIS_pixel_texture)
#if defined(GL_SGIS_point_parameters)
#ifndef glPointParameterfSGIS
#define glPointParameterfSGIS(pname, param) glatter_glPointParameterfSGIS_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfSGIS_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glPointParameterfvSGIS
#define glPointParameterfvSGIS(pname, params) glatter_glPointParameterfvSGIS_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfvSGIS_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#endif // defined(GL_SGIS_point_parameters)
#if defined(GL_SGIS_sharpen_texture)
#ifndef glGetSharpenTexFuncSGIS
#define glGetSharpenTexFuncSGIS(target, points) glatter_glGetSharpenTexFuncSGIS_debug((target), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetSharpenTexFuncSGIS_debug(GLenum target, GLfloat *points, const char* file, int line);
#ifndef glSharpenTexFuncSGIS
#define glSharpenTexFuncSGIS(target, n, points) glatter_glSharpenTexFuncSGIS_debug((target), (n), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSharpenTexFuncSGIS_debug(GLenum target, GLsizei n, const GLfloat *points, const char* file, int line);
#endif // defined(GL_SGIS_sharpen_texture)
#if defined(GL_SGIS_texture4D)
#ifndef glTexImage4DSGIS
#define glTexImage4DSGIS(target, level, internalformat, width, height, depth, size4d, border, format, type, pixels) glatter_glTexImage4DSGIS_debug((target), (level), (internalformat), (width), (height), (depth), (size4d), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexImage4DSGIS_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTexSubImage4DSGIS
#define glTexSubImage4DSGIS(target, level, xoffset, yoffset, zoffset, woffset, width, height, depth, size4d, format, type, pixels) glatter_glTexSubImage4DSGIS_debug((target), (level), (xoffset), (yoffset), (zoffset), (woffset), (width), (height), (depth), (size4d), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage4DSGIS_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint woffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei size4d, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#endif // defined(GL_SGIS_texture4D)
#if defined(GL_SGIS_texture_color_mask)
#ifndef glTextureColorMaskSGIS
#define glTextureColorMaskSGIS(red, green, blue, alpha) glatter_glTextureColorMaskSGIS_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureColorMaskSGIS_debug(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha, const char* file, int line);
#endif // defined(GL_SGIS_texture_color_mask)
#if defined(GL_SGIS_texture_filter4)
#ifndef glGetTexFilterFuncSGIS
#define glGetTexFilterFuncSGIS(target, filter, weights) glatter_glGetTexFilterFuncSGIS_debug((target), (filter), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexFilterFuncSGIS_debug(GLenum target, GLenum filter, GLfloat *weights, const char* file, int line);
#ifndef glTexFilterFuncSGIS
#define glTexFilterFuncSGIS(target, filter, n, weights) glatter_glTexFilterFuncSGIS_debug((target), (filter), (n), (weights), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexFilterFuncSGIS_debug(GLenum target, GLenum filter, GLsizei n, const GLfloat *weights, const char* file, int line);
#endif // defined(GL_SGIS_texture_filter4)
#if defined(GL_SGIX_async)
#ifndef glAsyncMarkerSGIX
#define glAsyncMarkerSGIX(marker) glatter_glAsyncMarkerSGIX_debug((marker), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAsyncMarkerSGIX_debug(GLuint marker, const char* file, int line);
#ifndef glDeleteAsyncMarkersSGIX
#define glDeleteAsyncMarkersSGIX(marker, range) glatter_glDeleteAsyncMarkersSGIX_debug((marker), (range), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteAsyncMarkersSGIX_debug(GLuint marker, GLsizei range, const char* file, int line);
#ifndef glFinishAsyncSGIX
#define glFinishAsyncSGIX(markerp) glatter_glFinishAsyncSGIX_debug((markerp), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glFinishAsyncSGIX_debug(GLuint *markerp, const char* file, int line);
#ifndef glGenAsyncMarkersSGIX
#define glGenAsyncMarkersSGIX(range) glatter_glGenAsyncMarkersSGIX_debug((range), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGenAsyncMarkersSGIX_debug(GLsizei range, const char* file, int line);
#ifndef glIsAsyncMarkerSGIX
#define glIsAsyncMarkerSGIX(marker) glatter_glIsAsyncMarkerSGIX_debug((marker), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsAsyncMarkerSGIX_debug(GLuint marker, const char* file, int line);
#ifndef glPollAsyncSGIX
#define glPollAsyncSGIX(markerp) glatter_glPollAsyncSGIX_debug((markerp), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glPollAsyncSGIX_debug(GLuint *markerp, const char* file, int line);
#endif // defined(GL_SGIX_async)
#if defined(GL_SGIX_flush_raster)
#ifndef glFlushRasterSGIX
#define glFlushRasterSGIX() glatter_glFlushRasterSGIX_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlushRasterSGIX_debug(const char* file, int line);
#endif // defined(GL_SGIX_flush_raster)
#if defined(GL_SGIX_fragment_lighting)
#ifndef glFragmentColorMaterialSGIX
#define glFragmentColorMaterialSGIX(face, mode) glatter_glFragmentColorMaterialSGIX_debug((face), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentColorMaterialSGIX_debug(GLenum face, GLenum mode, const char* file, int line);
#ifndef glFragmentLightModelfSGIX
#define glFragmentLightModelfSGIX(pname, param) glatter_glFragmentLightModelfSGIX_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentLightModelfSGIX_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glFragmentLightModelfvSGIX
#define glFragmentLightModelfvSGIX(pname, params) glatter_glFragmentLightModelfvSGIX_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentLightModelfvSGIX_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glFragmentLightModeliSGIX
#define glFragmentLightModeliSGIX(pname, param) glatter_glFragmentLightModeliSGIX_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentLightModeliSGIX_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glFragmentLightModelivSGIX
#define glFragmentLightModelivSGIX(pname, params) glatter_glFragmentLightModelivSGIX_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentLightModelivSGIX_debug(GLenum pname, const GLint *params, const char* file, int line);
#ifndef glFragmentLightfSGIX
#define glFragmentLightfSGIX(light, pname, param) glatter_glFragmentLightfSGIX_debug((light), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentLightfSGIX_debug(GLenum light, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glFragmentLightfvSGIX
#define glFragmentLightfvSGIX(light, pname, params) glatter_glFragmentLightfvSGIX_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentLightfvSGIX_debug(GLenum light, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glFragmentLightiSGIX
#define glFragmentLightiSGIX(light, pname, param) glatter_glFragmentLightiSGIX_debug((light), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentLightiSGIX_debug(GLenum light, GLenum pname, GLint param, const char* file, int line);
#ifndef glFragmentLightivSGIX
#define glFragmentLightivSGIX(light, pname, params) glatter_glFragmentLightivSGIX_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentLightivSGIX_debug(GLenum light, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glFragmentMaterialfSGIX
#define glFragmentMaterialfSGIX(face, pname, param) glatter_glFragmentMaterialfSGIX_debug((face), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentMaterialfSGIX_debug(GLenum face, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glFragmentMaterialfvSGIX
#define glFragmentMaterialfvSGIX(face, pname, params) glatter_glFragmentMaterialfvSGIX_debug((face), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentMaterialfvSGIX_debug(GLenum face, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glFragmentMaterialiSGIX
#define glFragmentMaterialiSGIX(face, pname, param) glatter_glFragmentMaterialiSGIX_debug((face), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentMaterialiSGIX_debug(GLenum face, GLenum pname, GLint param, const char* file, int line);
#ifndef glFragmentMaterialivSGIX
#define glFragmentMaterialivSGIX(face, pname, params) glatter_glFragmentMaterialivSGIX_debug((face), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFragmentMaterialivSGIX_debug(GLenum face, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glGetFragmentLightfvSGIX
#define glGetFragmentLightfvSGIX(light, pname, params) glatter_glGetFragmentLightfvSGIX_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFragmentLightfvSGIX_debug(GLenum light, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetFragmentLightivSGIX
#define glGetFragmentLightivSGIX(light, pname, params) glatter_glGetFragmentLightivSGIX_debug((light), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFragmentLightivSGIX_debug(GLenum light, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetFragmentMaterialfvSGIX
#define glGetFragmentMaterialfvSGIX(face, pname, params) glatter_glGetFragmentMaterialfvSGIX_debug((face), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFragmentMaterialfvSGIX_debug(GLenum face, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetFragmentMaterialivSGIX
#define glGetFragmentMaterialivSGIX(face, pname, params) glatter_glGetFragmentMaterialivSGIX_debug((face), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFragmentMaterialivSGIX_debug(GLenum face, GLenum pname, GLint *params, const char* file, int line);
#ifndef glLightEnviSGIX
#define glLightEnviSGIX(pname, param) glatter_glLightEnviSGIX_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLightEnviSGIX_debug(GLenum pname, GLint param, const char* file, int line);
#endif // defined(GL_SGIX_fragment_lighting)
#if defined(GL_SGIX_framezoom)
#ifndef glFrameZoomSGIX
#define glFrameZoomSGIX(factor) glatter_glFrameZoomSGIX_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFrameZoomSGIX_debug(GLint factor, const char* file, int line);
#endif // defined(GL_SGIX_framezoom)
#if defined(GL_SGIX_igloo_interface)
#ifndef glIglooInterfaceSGIX
#define glIglooInterfaceSGIX(pname, params) glatter_glIglooInterfaceSGIX_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glIglooInterfaceSGIX_debug(GLenum pname, const void *params, const char* file, int line);
#endif // defined(GL_SGIX_igloo_interface)
#if defined(GL_SGIX_instruments)
#ifndef glGetInstrumentsSGIX
#define glGetInstrumentsSGIX() glatter_glGetInstrumentsSGIX_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetInstrumentsSGIX_debug(const char* file, int line);
#ifndef glInstrumentsBufferSGIX
#define glInstrumentsBufferSGIX(size, buffer) glatter_glInstrumentsBufferSGIX_debug((size), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInstrumentsBufferSGIX_debug(GLsizei size, GLint *buffer, const char* file, int line);
#ifndef glPollInstrumentsSGIX
#define glPollInstrumentsSGIX(marker_p) glatter_glPollInstrumentsSGIX_debug((marker_p), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glPollInstrumentsSGIX_debug(GLint *marker_p, const char* file, int line);
#ifndef glReadInstrumentsSGIX
#define glReadInstrumentsSGIX(marker) glatter_glReadInstrumentsSGIX_debug((marker), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReadInstrumentsSGIX_debug(GLint marker, const char* file, int line);
#ifndef glStartInstrumentsSGIX
#define glStartInstrumentsSGIX() glatter_glStartInstrumentsSGIX_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStartInstrumentsSGIX_debug(const char* file, int line);
#ifndef glStopInstrumentsSGIX
#define glStopInstrumentsSGIX(marker) glatter_glStopInstrumentsSGIX_debug((marker), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStopInstrumentsSGIX_debug(GLint marker, const char* file, int line);
#endif // defined(GL_SGIX_instruments)
#if defined(GL_SGIX_list_priority)
#ifndef glGetListParameterfvSGIX
#define glGetListParameterfvSGIX(list, pname, params) glatter_glGetListParameterfvSGIX_debug((list), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetListParameterfvSGIX_debug(GLuint list, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetListParameterivSGIX
#define glGetListParameterivSGIX(list, pname, params) glatter_glGetListParameterivSGIX_debug((list), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetListParameterivSGIX_debug(GLuint list, GLenum pname, GLint *params, const char* file, int line);
#ifndef glListParameterfSGIX
#define glListParameterfSGIX(list, pname, param) glatter_glListParameterfSGIX_debug((list), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glListParameterfSGIX_debug(GLuint list, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glListParameterfvSGIX
#define glListParameterfvSGIX(list, pname, params) glatter_glListParameterfvSGIX_debug((list), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glListParameterfvSGIX_debug(GLuint list, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glListParameteriSGIX
#define glListParameteriSGIX(list, pname, param) glatter_glListParameteriSGIX_debug((list), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glListParameteriSGIX_debug(GLuint list, GLenum pname, GLint param, const char* file, int line);
#ifndef glListParameterivSGIX
#define glListParameterivSGIX(list, pname, params) glatter_glListParameterivSGIX_debug((list), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glListParameterivSGIX_debug(GLuint list, GLenum pname, const GLint *params, const char* file, int line);
#endif // defined(GL_SGIX_list_priority)
#if defined(GL_SGIX_pixel_texture)
#ifndef glPixelTexGenSGIX
#define glPixelTexGenSGIX(mode) glatter_glPixelTexGenSGIX_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPixelTexGenSGIX_debug(GLenum mode, const char* file, int line);
#endif // defined(GL_SGIX_pixel_texture)
#if defined(GL_SGIX_polynomial_ffd)
#ifndef glDeformSGIX
#define glDeformSGIX(mask) glatter_glDeformSGIX_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeformSGIX_debug(GLbitfield mask, const char* file, int line);
#ifndef glDeformationMap3dSGIX
#define glDeformationMap3dSGIX(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, w1, w2, wstride, worder, points) glatter_glDeformationMap3dSGIX_debug((target), (u1), (u2), (ustride), (uorder), (v1), (v2), (vstride), (vorder), (w1), (w2), (wstride), (worder), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeformationMap3dSGIX_debug(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, GLdouble w1, GLdouble w2, GLint wstride, GLint worder, const GLdouble *points, const char* file, int line);
#ifndef glDeformationMap3fSGIX
#define glDeformationMap3fSGIX(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, w1, w2, wstride, worder, points) glatter_glDeformationMap3fSGIX_debug((target), (u1), (u2), (ustride), (uorder), (v1), (v2), (vstride), (vorder), (w1), (w2), (wstride), (worder), (points), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeformationMap3fSGIX_debug(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, GLfloat w1, GLfloat w2, GLint wstride, GLint worder, const GLfloat *points, const char* file, int line);
#ifndef glLoadIdentityDeformationMapSGIX
#define glLoadIdentityDeformationMapSGIX(mask) glatter_glLoadIdentityDeformationMapSGIX_debug((mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadIdentityDeformationMapSGIX_debug(GLbitfield mask, const char* file, int line);
#endif // defined(GL_SGIX_polynomial_ffd)
#if defined(GL_SGIX_reference_plane)
#ifndef glReferencePlaneSGIX
#define glReferencePlaneSGIX(equation) glatter_glReferencePlaneSGIX_debug((equation), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReferencePlaneSGIX_debug(const GLdouble *equation, const char* file, int line);
#endif // defined(GL_SGIX_reference_plane)
#if defined(GL_SGIX_sprite)
#ifndef glSpriteParameterfSGIX
#define glSpriteParameterfSGIX(pname, param) glatter_glSpriteParameterfSGIX_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSpriteParameterfSGIX_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glSpriteParameterfvSGIX
#define glSpriteParameterfvSGIX(pname, params) glatter_glSpriteParameterfvSGIX_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSpriteParameterfvSGIX_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glSpriteParameteriSGIX
#define glSpriteParameteriSGIX(pname, param) glatter_glSpriteParameteriSGIX_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSpriteParameteriSGIX_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glSpriteParameterivSGIX
#define glSpriteParameterivSGIX(pname, params) glatter_glSpriteParameterivSGIX_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSpriteParameterivSGIX_debug(GLenum pname, const GLint *params, const char* file, int line);
#endif // defined(GL_SGIX_sprite)
#if defined(GL_SGIX_tag_sample_buffer)
#ifndef glTagSampleBufferSGIX
#define glTagSampleBufferSGIX() glatter_glTagSampleBufferSGIX_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTagSampleBufferSGIX_debug(const char* file, int line);
#endif // defined(GL_SGIX_tag_sample_buffer)
#if defined(GL_SGI_color_table)
#ifndef glColorTableParameterfvSGI
#define glColorTableParameterfvSGI(target, pname, params) glatter_glColorTableParameterfvSGI_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorTableParameterfvSGI_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glColorTableParameterivSGI
#define glColorTableParameterivSGI(target, pname, params) glatter_glColorTableParameterivSGI_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorTableParameterivSGI_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glColorTableSGI
#define glColorTableSGI(target, internalformat, width, format, type, table) glatter_glColorTableSGI_debug((target), (internalformat), (width), (format), (type), (table), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorTableSGI_debug(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table, const char* file, int line);
#ifndef glCopyColorTableSGI
#define glCopyColorTableSGI(target, internalformat, x, y, width) glatter_glCopyColorTableSGI_debug((target), (internalformat), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyColorTableSGI_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glGetColorTableParameterfvSGI
#define glGetColorTableParameterfvSGI(target, pname, params) glatter_glGetColorTableParameterfvSGI_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameterfvSGI_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetColorTableParameterivSGI
#define glGetColorTableParameterivSGI(target, pname, params) glatter_glGetColorTableParameterivSGI_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameterivSGI_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetColorTableSGI
#define glGetColorTableSGI(target, format, type, table) glatter_glGetColorTableSGI_debug((target), (format), (type), (table), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableSGI_debug(GLenum target, GLenum format, GLenum type, void *table, const char* file, int line);
#endif // defined(GL_SGI_color_table)
#if defined(GL_SUNX_constant_data)
#ifndef glFinishTextureSUNX
#define glFinishTextureSUNX() glatter_glFinishTextureSUNX_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFinishTextureSUNX_debug(const char* file, int line);
#endif // defined(GL_SUNX_constant_data)
#if defined(GL_SUN_global_alpha)
#ifndef glGlobalAlphaFactorbSUN
#define glGlobalAlphaFactorbSUN(factor) glatter_glGlobalAlphaFactorbSUN_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGlobalAlphaFactorbSUN_debug(GLbyte factor, const char* file, int line);
#ifndef glGlobalAlphaFactordSUN
#define glGlobalAlphaFactordSUN(factor) glatter_glGlobalAlphaFactordSUN_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGlobalAlphaFactordSUN_debug(GLdouble factor, const char* file, int line);
#ifndef glGlobalAlphaFactorfSUN
#define glGlobalAlphaFactorfSUN(factor) glatter_glGlobalAlphaFactorfSUN_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGlobalAlphaFactorfSUN_debug(GLfloat factor, const char* file, int line);
#ifndef glGlobalAlphaFactoriSUN
#define glGlobalAlphaFactoriSUN(factor) glatter_glGlobalAlphaFactoriSUN_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGlobalAlphaFactoriSUN_debug(GLint factor, const char* file, int line);
#ifndef glGlobalAlphaFactorsSUN
#define glGlobalAlphaFactorsSUN(factor) glatter_glGlobalAlphaFactorsSUN_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGlobalAlphaFactorsSUN_debug(GLshort factor, const char* file, int line);
#ifndef glGlobalAlphaFactorubSUN
#define glGlobalAlphaFactorubSUN(factor) glatter_glGlobalAlphaFactorubSUN_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGlobalAlphaFactorubSUN_debug(GLubyte factor, const char* file, int line);
#ifndef glGlobalAlphaFactoruiSUN
#define glGlobalAlphaFactoruiSUN(factor) glatter_glGlobalAlphaFactoruiSUN_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGlobalAlphaFactoruiSUN_debug(GLuint factor, const char* file, int line);
#ifndef glGlobalAlphaFactorusSUN
#define glGlobalAlphaFactorusSUN(factor) glatter_glGlobalAlphaFactorusSUN_debug((factor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGlobalAlphaFactorusSUN_debug(GLushort factor, const char* file, int line);
#endif // defined(GL_SUN_global_alpha)
#if defined(GL_SUN_mesh_array)
#ifndef glDrawMeshArraysSUN
#define glDrawMeshArraysSUN(mode, first, count, width) glatter_glDrawMeshArraysSUN_debug((mode), (first), (count), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawMeshArraysSUN_debug(GLenum mode, GLint first, GLsizei count, GLsizei width, const char* file, int line);
#endif // defined(GL_SUN_mesh_array)
#if defined(GL_SUN_triangle_list)
#ifndef glReplacementCodePointerSUN
#define glReplacementCodePointerSUN(type, stride, pointer) glatter_glReplacementCodePointerSUN_debug((type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodePointerSUN_debug(GLenum type, GLsizei stride, const void **pointer, const char* file, int line);
#ifndef glReplacementCodeubSUN
#define glReplacementCodeubSUN(code) glatter_glReplacementCodeubSUN_debug((code), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeubSUN_debug(GLubyte code, const char* file, int line);
#ifndef glReplacementCodeubvSUN
#define glReplacementCodeubvSUN(code) glatter_glReplacementCodeubvSUN_debug((code), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeubvSUN_debug(const GLubyte *code, const char* file, int line);
#ifndef glReplacementCodeuiSUN
#define glReplacementCodeuiSUN(code) glatter_glReplacementCodeuiSUN_debug((code), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiSUN_debug(GLuint code, const char* file, int line);
#ifndef glReplacementCodeuivSUN
#define glReplacementCodeuivSUN(code) glatter_glReplacementCodeuivSUN_debug((code), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuivSUN_debug(const GLuint *code, const char* file, int line);
#ifndef glReplacementCodeusSUN
#define glReplacementCodeusSUN(code) glatter_glReplacementCodeusSUN_debug((code), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeusSUN_debug(GLushort code, const char* file, int line);
#ifndef glReplacementCodeusvSUN
#define glReplacementCodeusvSUN(code) glatter_glReplacementCodeusvSUN_debug((code), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeusvSUN_debug(const GLushort *code, const char* file, int line);
#endif // defined(GL_SUN_triangle_list)
#if defined(GL_SUN_vertex)
#ifndef glColor3fVertex3fSUN
#define glColor3fVertex3fSUN(r, g, b, x, y, z) glatter_glColor3fVertex3fSUN_debug((r), (g), (b), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3fVertex3fSUN_debug(GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glColor3fVertex3fvSUN
#define glColor3fVertex3fvSUN(c, v) glatter_glColor3fVertex3fvSUN_debug((c), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor3fVertex3fvSUN_debug(const GLfloat *c, const GLfloat *v, const char* file, int line);
#ifndef glColor4fNormal3fVertex3fSUN
#define glColor4fNormal3fVertex3fSUN(r, g, b, a, nx, ny, nz, x, y, z) glatter_glColor4fNormal3fVertex3fSUN_debug((r), (g), (b), (a), (nx), (ny), (nz), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4fNormal3fVertex3fSUN_debug(GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glColor4fNormal3fVertex3fvSUN
#define glColor4fNormal3fVertex3fvSUN(c, n, v) glatter_glColor4fNormal3fVertex3fvSUN_debug((c), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4fNormal3fVertex3fvSUN_debug(const GLfloat *c, const GLfloat *n, const GLfloat *v, const char* file, int line);
#ifndef glColor4ubVertex2fSUN
#define glColor4ubVertex2fSUN(r, g, b, a, x, y) glatter_glColor4ubVertex2fSUN_debug((r), (g), (b), (a), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4ubVertex2fSUN_debug(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, const char* file, int line);
#ifndef glColor4ubVertex2fvSUN
#define glColor4ubVertex2fvSUN(c, v) glatter_glColor4ubVertex2fvSUN_debug((c), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4ubVertex2fvSUN_debug(const GLubyte *c, const GLfloat *v, const char* file, int line);
#ifndef glColor4ubVertex3fSUN
#define glColor4ubVertex3fSUN(r, g, b, a, x, y, z) glatter_glColor4ubVertex3fSUN_debug((r), (g), (b), (a), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4ubVertex3fSUN_debug(GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glColor4ubVertex3fvSUN
#define glColor4ubVertex3fvSUN(c, v) glatter_glColor4ubVertex3fvSUN_debug((c), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColor4ubVertex3fvSUN_debug(const GLubyte *c, const GLfloat *v, const char* file, int line);
#ifndef glNormal3fVertex3fSUN
#define glNormal3fVertex3fSUN(nx, ny, nz, x, y, z) glatter_glNormal3fVertex3fSUN_debug((nx), (ny), (nz), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3fVertex3fSUN_debug(GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glNormal3fVertex3fvSUN
#define glNormal3fVertex3fvSUN(n, v) glatter_glNormal3fVertex3fvSUN_debug((n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormal3fVertex3fvSUN_debug(const GLfloat *n, const GLfloat *v, const char* file, int line);
#ifndef glReplacementCodeuiColor3fVertex3fSUN
#define glReplacementCodeuiColor3fVertex3fSUN(rc, r, g, b, x, y, z) glatter_glReplacementCodeuiColor3fVertex3fSUN_debug((rc), (r), (g), (b), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiColor3fVertex3fSUN_debug(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glReplacementCodeuiColor3fVertex3fvSUN
#define glReplacementCodeuiColor3fVertex3fvSUN(rc, c, v) glatter_glReplacementCodeuiColor3fVertex3fvSUN_debug((rc), (c), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiColor3fVertex3fvSUN_debug(const GLuint *rc, const GLfloat *c, const GLfloat *v, const char* file, int line);
#ifndef glReplacementCodeuiColor4fNormal3fVertex3fSUN
#define glReplacementCodeuiColor4fNormal3fVertex3fSUN(rc, r, g, b, a, nx, ny, nz, x, y, z) glatter_glReplacementCodeuiColor4fNormal3fVertex3fSUN_debug((rc), (r), (g), (b), (a), (nx), (ny), (nz), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiColor4fNormal3fVertex3fSUN_debug(GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glReplacementCodeuiColor4fNormal3fVertex3fvSUN
#define glReplacementCodeuiColor4fNormal3fVertex3fvSUN(rc, c, n, v) glatter_glReplacementCodeuiColor4fNormal3fVertex3fvSUN_debug((rc), (c), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiColor4fNormal3fVertex3fvSUN_debug(const GLuint *rc, const GLfloat *c, const GLfloat *n, const GLfloat *v, const char* file, int line);
#ifndef glReplacementCodeuiColor4ubVertex3fSUN
#define glReplacementCodeuiColor4ubVertex3fSUN(rc, r, g, b, a, x, y, z) glatter_glReplacementCodeuiColor4ubVertex3fSUN_debug((rc), (r), (g), (b), (a), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiColor4ubVertex3fSUN_debug(GLuint rc, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glReplacementCodeuiColor4ubVertex3fvSUN
#define glReplacementCodeuiColor4ubVertex3fvSUN(rc, c, v) glatter_glReplacementCodeuiColor4ubVertex3fvSUN_debug((rc), (c), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiColor4ubVertex3fvSUN_debug(const GLuint *rc, const GLubyte *c, const GLfloat *v, const char* file, int line);
#ifndef glReplacementCodeuiNormal3fVertex3fSUN
#define glReplacementCodeuiNormal3fVertex3fSUN(rc, nx, ny, nz, x, y, z) glatter_glReplacementCodeuiNormal3fVertex3fSUN_debug((rc), (nx), (ny), (nz), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiNormal3fVertex3fSUN_debug(GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glReplacementCodeuiNormal3fVertex3fvSUN
#define glReplacementCodeuiNormal3fVertex3fvSUN(rc, n, v) glatter_glReplacementCodeuiNormal3fVertex3fvSUN_debug((rc), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiNormal3fVertex3fvSUN_debug(const GLuint *rc, const GLfloat *n, const GLfloat *v, const char* file, int line);
#ifndef glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN
#define glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(rc, s, t, r, g, b, a, nx, ny, nz, x, y, z) glatter_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN_debug((rc), (s), (t), (r), (g), (b), (a), (nx), (ny), (nz), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN_debug(GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN
#define glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(rc, tc, c, n, v) glatter_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN_debug((rc), (tc), (c), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN_debug(const GLuint *rc, const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v, const char* file, int line);
#ifndef glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN
#define glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(rc, s, t, nx, ny, nz, x, y, z) glatter_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN_debug((rc), (s), (t), (nx), (ny), (nz), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN_debug(GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN
#define glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(rc, tc, n, v) glatter_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN_debug((rc), (tc), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN_debug(const GLuint *rc, const GLfloat *tc, const GLfloat *n, const GLfloat *v, const char* file, int line);
#ifndef glReplacementCodeuiTexCoord2fVertex3fSUN
#define glReplacementCodeuiTexCoord2fVertex3fSUN(rc, s, t, x, y, z) glatter_glReplacementCodeuiTexCoord2fVertex3fSUN_debug((rc), (s), (t), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiTexCoord2fVertex3fSUN_debug(GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glReplacementCodeuiTexCoord2fVertex3fvSUN
#define glReplacementCodeuiTexCoord2fVertex3fvSUN(rc, tc, v) glatter_glReplacementCodeuiTexCoord2fVertex3fvSUN_debug((rc), (tc), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiTexCoord2fVertex3fvSUN_debug(const GLuint *rc, const GLfloat *tc, const GLfloat *v, const char* file, int line);
#ifndef glReplacementCodeuiVertex3fSUN
#define glReplacementCodeuiVertex3fSUN(rc, x, y, z) glatter_glReplacementCodeuiVertex3fSUN_debug((rc), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiVertex3fSUN_debug(GLuint rc, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glReplacementCodeuiVertex3fvSUN
#define glReplacementCodeuiVertex3fvSUN(rc, v) glatter_glReplacementCodeuiVertex3fvSUN_debug((rc), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReplacementCodeuiVertex3fvSUN_debug(const GLuint *rc, const GLfloat *v, const char* file, int line);
#ifndef glTexCoord2fColor3fVertex3fSUN
#define glTexCoord2fColor3fVertex3fSUN(s, t, r, g, b, x, y, z) glatter_glTexCoord2fColor3fVertex3fSUN_debug((s), (t), (r), (g), (b), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fColor3fVertex3fSUN_debug(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glTexCoord2fColor3fVertex3fvSUN
#define glTexCoord2fColor3fVertex3fvSUN(tc, c, v) glatter_glTexCoord2fColor3fVertex3fvSUN_debug((tc), (c), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fColor3fVertex3fvSUN_debug(const GLfloat *tc, const GLfloat *c, const GLfloat *v, const char* file, int line);
#ifndef glTexCoord2fColor4fNormal3fVertex3fSUN
#define glTexCoord2fColor4fNormal3fVertex3fSUN(s, t, r, g, b, a, nx, ny, nz, x, y, z) glatter_glTexCoord2fColor4fNormal3fVertex3fSUN_debug((s), (t), (r), (g), (b), (a), (nx), (ny), (nz), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fColor4fNormal3fVertex3fSUN_debug(GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glTexCoord2fColor4fNormal3fVertex3fvSUN
#define glTexCoord2fColor4fNormal3fVertex3fvSUN(tc, c, n, v) glatter_glTexCoord2fColor4fNormal3fVertex3fvSUN_debug((tc), (c), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fColor4fNormal3fVertex3fvSUN_debug(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v, const char* file, int line);
#ifndef glTexCoord2fColor4ubVertex3fSUN
#define glTexCoord2fColor4ubVertex3fSUN(s, t, r, g, b, a, x, y, z) glatter_glTexCoord2fColor4ubVertex3fSUN_debug((s), (t), (r), (g), (b), (a), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fColor4ubVertex3fSUN_debug(GLfloat s, GLfloat t, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glTexCoord2fColor4ubVertex3fvSUN
#define glTexCoord2fColor4ubVertex3fvSUN(tc, c, v) glatter_glTexCoord2fColor4ubVertex3fvSUN_debug((tc), (c), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fColor4ubVertex3fvSUN_debug(const GLfloat *tc, const GLubyte *c, const GLfloat *v, const char* file, int line);
#ifndef glTexCoord2fNormal3fVertex3fSUN
#define glTexCoord2fNormal3fVertex3fSUN(s, t, nx, ny, nz, x, y, z) glatter_glTexCoord2fNormal3fVertex3fSUN_debug((s), (t), (nx), (ny), (nz), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fNormal3fVertex3fSUN_debug(GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glTexCoord2fNormal3fVertex3fvSUN
#define glTexCoord2fNormal3fVertex3fvSUN(tc, n, v) glatter_glTexCoord2fNormal3fVertex3fvSUN_debug((tc), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fNormal3fVertex3fvSUN_debug(const GLfloat *tc, const GLfloat *n, const GLfloat *v, const char* file, int line);
#ifndef glTexCoord2fVertex3fSUN
#define glTexCoord2fVertex3fSUN(s, t, x, y, z) glatter_glTexCoord2fVertex3fSUN_debug((s), (t), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fVertex3fSUN_debug(GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glTexCoord2fVertex3fvSUN
#define glTexCoord2fVertex3fvSUN(tc, v) glatter_glTexCoord2fVertex3fvSUN_debug((tc), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fVertex3fvSUN_debug(const GLfloat *tc, const GLfloat *v, const char* file, int line);
#ifndef glTexCoord4fColor4fNormal3fVertex4fSUN
#define glTexCoord4fColor4fNormal3fVertex4fSUN(s, t, p, q, r, g, b, a, nx, ny, nz, x, y, z, w) glatter_glTexCoord4fColor4fNormal3fVertex4fSUN_debug((s), (t), (p), (q), (r), (g), (b), (a), (nx), (ny), (nz), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4fColor4fNormal3fVertex4fSUN_debug(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glTexCoord4fColor4fNormal3fVertex4fvSUN
#define glTexCoord4fColor4fNormal3fVertex4fvSUN(tc, c, n, v) glatter_glTexCoord4fColor4fNormal3fVertex4fvSUN_debug((tc), (c), (n), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4fColor4fNormal3fVertex4fvSUN_debug(const GLfloat *tc, const GLfloat *c, const GLfloat *n, const GLfloat *v, const char* file, int line);
#ifndef glTexCoord4fVertex4fSUN
#define glTexCoord4fVertex4fSUN(s, t, p, q, x, y, z, w) glatter_glTexCoord4fVertex4fSUN_debug((s), (t), (p), (q), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4fVertex4fSUN_debug(GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glTexCoord4fVertex4fvSUN
#define glTexCoord4fVertex4fvSUN(tc, v) glatter_glTexCoord4fVertex4fvSUN_debug((tc), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4fVertex4fvSUN_debug(const GLfloat *tc, const GLfloat *v, const char* file, int line);
#endif // defined(GL_SUN_vertex)
#if defined(GL_VERSION_1_2)
#ifndef glCopyTexSubImage3D
#define glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height) glatter_glCopyTexSubImage3D_debug((target), (level), (xoffset), (yoffset), (zoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage3D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glDrawRangeElements
#define glDrawRangeElements(mode, start, end, count, type, indices) glatter_glDrawRangeElements_debug((mode), (start), (end), (count), (type), (indices), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElements_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, const char* file, int line);
#ifndef glTexImage3D
#define glTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels) glatter_glTexImage3D_debug((target), (level), (internalformat), (width), (height), (depth), (border), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexImage3D_debug(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTexSubImage3D
#define glTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels) glatter_glTexSubImage3D_debug((target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage3D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#endif // defined(GL_VERSION_1_2)
#if defined(GL_VERSION_1_3)
#ifndef glActiveTexture
#define glActiveTexture(texture) glatter_glActiveTexture_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glActiveTexture_debug(GLenum texture, const char* file, int line);
#ifndef glClientActiveTexture
#define glClientActiveTexture(texture) glatter_glClientActiveTexture_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClientActiveTexture_debug(GLenum texture, const char* file, int line);
#ifndef glCompressedTexImage1D
#define glCompressedTexImage1D(target, level, internalformat, width, border, imageSize, data) glatter_glCompressedTexImage1D_debug((target), (level), (internalformat), (width), (border), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage1D_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexImage2D
#define glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data) glatter_glCompressedTexImage2D_debug((target), (level), (internalformat), (width), (height), (border), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage2D_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexImage3D
#define glCompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data) glatter_glCompressedTexImage3D_debug((target), (level), (internalformat), (width), (height), (depth), (border), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage3D_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexSubImage1D
#define glCompressedTexSubImage1D(target, level, xoffset, width, format, imageSize, data) glatter_glCompressedTexSubImage1D_debug((target), (level), (xoffset), (width), (format), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage1D_debug(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexSubImage2D
#define glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data) glatter_glCompressedTexSubImage2D_debug((target), (level), (xoffset), (yoffset), (width), (height), (format), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTexSubImage3D
#define glCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data) glatter_glCompressedTexSubImage3D_debug((target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage3D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glGetCompressedTexImage
#define glGetCompressedTexImage(target, level, img) glatter_glGetCompressedTexImage_debug((target), (level), (img), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCompressedTexImage_debug(GLenum target, GLint level, void *img, const char* file, int line);
#ifndef glLoadTransposeMatrixd
#define glLoadTransposeMatrixd(m) glatter_glLoadTransposeMatrixd_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadTransposeMatrixd_debug(const GLdouble *m, const char* file, int line);
#ifndef glLoadTransposeMatrixf
#define glLoadTransposeMatrixf(m) glatter_glLoadTransposeMatrixf_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLoadTransposeMatrixf_debug(const GLfloat *m, const char* file, int line);
#ifndef glMultTransposeMatrixd
#define glMultTransposeMatrixd(m) glatter_glMultTransposeMatrixd_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultTransposeMatrixd_debug(const GLdouble *m, const char* file, int line);
#ifndef glMultTransposeMatrixf
#define glMultTransposeMatrixf(m) glatter_glMultTransposeMatrixf_debug((m), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultTransposeMatrixf_debug(const GLfloat *m, const char* file, int line);
#ifndef glMultiTexCoord1d
#define glMultiTexCoord1d(target, s) glatter_glMultiTexCoord1d_debug((target), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1d_debug(GLenum target, GLdouble s, const char* file, int line);
#ifndef glMultiTexCoord1dv
#define glMultiTexCoord1dv(target, v) glatter_glMultiTexCoord1dv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1dv_debug(GLenum target, const GLdouble *v, const char* file, int line);
#ifndef glMultiTexCoord1f
#define glMultiTexCoord1f(target, s) glatter_glMultiTexCoord1f_debug((target), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1f_debug(GLenum target, GLfloat s, const char* file, int line);
#ifndef glMultiTexCoord1fv
#define glMultiTexCoord1fv(target, v) glatter_glMultiTexCoord1fv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1fv_debug(GLenum target, const GLfloat *v, const char* file, int line);
#ifndef glMultiTexCoord1i
#define glMultiTexCoord1i(target, s) glatter_glMultiTexCoord1i_debug((target), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1i_debug(GLenum target, GLint s, const char* file, int line);
#ifndef glMultiTexCoord1iv
#define glMultiTexCoord1iv(target, v) glatter_glMultiTexCoord1iv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1iv_debug(GLenum target, const GLint *v, const char* file, int line);
#ifndef glMultiTexCoord1s
#define glMultiTexCoord1s(target, s) glatter_glMultiTexCoord1s_debug((target), (s), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1s_debug(GLenum target, GLshort s, const char* file, int line);
#ifndef glMultiTexCoord1sv
#define glMultiTexCoord1sv(target, v) glatter_glMultiTexCoord1sv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1sv_debug(GLenum target, const GLshort *v, const char* file, int line);
#ifndef glMultiTexCoord2d
#define glMultiTexCoord2d(target, s, t) glatter_glMultiTexCoord2d_debug((target), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2d_debug(GLenum target, GLdouble s, GLdouble t, const char* file, int line);
#ifndef glMultiTexCoord2dv
#define glMultiTexCoord2dv(target, v) glatter_glMultiTexCoord2dv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2dv_debug(GLenum target, const GLdouble *v, const char* file, int line);
#ifndef glMultiTexCoord2f
#define glMultiTexCoord2f(target, s, t) glatter_glMultiTexCoord2f_debug((target), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2f_debug(GLenum target, GLfloat s, GLfloat t, const char* file, int line);
#ifndef glMultiTexCoord2fv
#define glMultiTexCoord2fv(target, v) glatter_glMultiTexCoord2fv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2fv_debug(GLenum target, const GLfloat *v, const char* file, int line);
#ifndef glMultiTexCoord2i
#define glMultiTexCoord2i(target, s, t) glatter_glMultiTexCoord2i_debug((target), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2i_debug(GLenum target, GLint s, GLint t, const char* file, int line);
#ifndef glMultiTexCoord2iv
#define glMultiTexCoord2iv(target, v) glatter_glMultiTexCoord2iv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2iv_debug(GLenum target, const GLint *v, const char* file, int line);
#ifndef glMultiTexCoord2s
#define glMultiTexCoord2s(target, s, t) glatter_glMultiTexCoord2s_debug((target), (s), (t), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2s_debug(GLenum target, GLshort s, GLshort t, const char* file, int line);
#ifndef glMultiTexCoord2sv
#define glMultiTexCoord2sv(target, v) glatter_glMultiTexCoord2sv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2sv_debug(GLenum target, const GLshort *v, const char* file, int line);
#ifndef glMultiTexCoord3d
#define glMultiTexCoord3d(target, s, t, r) glatter_glMultiTexCoord3d_debug((target), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3d_debug(GLenum target, GLdouble s, GLdouble t, GLdouble r, const char* file, int line);
#ifndef glMultiTexCoord3dv
#define glMultiTexCoord3dv(target, v) glatter_glMultiTexCoord3dv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3dv_debug(GLenum target, const GLdouble *v, const char* file, int line);
#ifndef glMultiTexCoord3f
#define glMultiTexCoord3f(target, s, t, r) glatter_glMultiTexCoord3f_debug((target), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3f_debug(GLenum target, GLfloat s, GLfloat t, GLfloat r, const char* file, int line);
#ifndef glMultiTexCoord3fv
#define glMultiTexCoord3fv(target, v) glatter_glMultiTexCoord3fv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3fv_debug(GLenum target, const GLfloat *v, const char* file, int line);
#ifndef glMultiTexCoord3i
#define glMultiTexCoord3i(target, s, t, r) glatter_glMultiTexCoord3i_debug((target), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3i_debug(GLenum target, GLint s, GLint t, GLint r, const char* file, int line);
#ifndef glMultiTexCoord3iv
#define glMultiTexCoord3iv(target, v) glatter_glMultiTexCoord3iv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3iv_debug(GLenum target, const GLint *v, const char* file, int line);
#ifndef glMultiTexCoord3s
#define glMultiTexCoord3s(target, s, t, r) glatter_glMultiTexCoord3s_debug((target), (s), (t), (r), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3s_debug(GLenum target, GLshort s, GLshort t, GLshort r, const char* file, int line);
#ifndef glMultiTexCoord3sv
#define glMultiTexCoord3sv(target, v) glatter_glMultiTexCoord3sv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3sv_debug(GLenum target, const GLshort *v, const char* file, int line);
#ifndef glMultiTexCoord4d
#define glMultiTexCoord4d(target, s, t, r, q) glatter_glMultiTexCoord4d_debug((target), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4d_debug(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q, const char* file, int line);
#ifndef glMultiTexCoord4dv
#define glMultiTexCoord4dv(target, v) glatter_glMultiTexCoord4dv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4dv_debug(GLenum target, const GLdouble *v, const char* file, int line);
#ifndef glMultiTexCoord4f
#define glMultiTexCoord4f(target, s, t, r, q) glatter_glMultiTexCoord4f_debug((target), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4f_debug(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q, const char* file, int line);
#ifndef glMultiTexCoord4fv
#define glMultiTexCoord4fv(target, v) glatter_glMultiTexCoord4fv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4fv_debug(GLenum target, const GLfloat *v, const char* file, int line);
#ifndef glMultiTexCoord4i
#define glMultiTexCoord4i(target, s, t, r, q) glatter_glMultiTexCoord4i_debug((target), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4i_debug(GLenum target, GLint s, GLint t, GLint r, GLint q, const char* file, int line);
#ifndef glMultiTexCoord4iv
#define glMultiTexCoord4iv(target, v) glatter_glMultiTexCoord4iv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4iv_debug(GLenum target, const GLint *v, const char* file, int line);
#ifndef glMultiTexCoord4s
#define glMultiTexCoord4s(target, s, t, r, q) glatter_glMultiTexCoord4s_debug((target), (s), (t), (r), (q), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4s_debug(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q, const char* file, int line);
#ifndef glMultiTexCoord4sv
#define glMultiTexCoord4sv(target, v) glatter_glMultiTexCoord4sv_debug((target), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4sv_debug(GLenum target, const GLshort *v, const char* file, int line);
#ifndef glSampleCoverage
#define glSampleCoverage(value, invert) glatter_glSampleCoverage_debug((value), (invert), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSampleCoverage_debug(GLfloat value, GLboolean invert, const char* file, int line);
#endif // defined(GL_VERSION_1_3)
#if defined(GL_VERSION_1_4)
#ifndef glBlendColor
#define glBlendColor(red, green, blue, alpha) glatter_glBlendColor_debug((red), (green), (blue), (alpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendColor_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line);
#ifndef glBlendEquation
#define glBlendEquation(mode) glatter_glBlendEquation_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquation_debug(GLenum mode, const char* file, int line);
#ifndef glBlendFuncSeparate
#define glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha) glatter_glBlendFuncSeparate_debug((sfactorRGB), (dfactorRGB), (sfactorAlpha), (dfactorAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparate_debug(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha, const char* file, int line);
#ifndef glFogCoordPointer
#define glFogCoordPointer(type, stride, pointer) glatter_glFogCoordPointer_debug((type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordPointer_debug(GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glFogCoordd
#define glFogCoordd(coord) glatter_glFogCoordd_debug((coord), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordd_debug(GLdouble coord, const char* file, int line);
#ifndef glFogCoorddv
#define glFogCoorddv(coord) glatter_glFogCoorddv_debug((coord), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoorddv_debug(const GLdouble *coord, const char* file, int line);
#ifndef glFogCoordf
#define glFogCoordf(coord) glatter_glFogCoordf_debug((coord), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordf_debug(GLfloat coord, const char* file, int line);
#ifndef glFogCoordfv
#define glFogCoordfv(coord) glatter_glFogCoordfv_debug((coord), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFogCoordfv_debug(const GLfloat *coord, const char* file, int line);
#ifndef glMultiDrawArrays
#define glMultiDrawArrays(mode, first, count, drawcount) glatter_glMultiDrawArrays_debug((mode), (first), (count), (drawcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArrays_debug(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount, const char* file, int line);
#ifndef glMultiDrawElements
#define glMultiDrawElements(mode, count, type, indices, drawcount) glatter_glMultiDrawElements_debug((mode), (count), (type), (indices), (drawcount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElements_debug(GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei drawcount, const char* file, int line);
#ifndef glPointParameterf
#define glPointParameterf(pname, param) glatter_glPointParameterf_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterf_debug(GLenum pname, GLfloat param, const char* file, int line);
#ifndef glPointParameterfv
#define glPointParameterfv(pname, params) glatter_glPointParameterfv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfv_debug(GLenum pname, const GLfloat *params, const char* file, int line);
#ifndef glPointParameteri
#define glPointParameteri(pname, param) glatter_glPointParameteri_debug((pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameteri_debug(GLenum pname, GLint param, const char* file, int line);
#ifndef glPointParameteriv
#define glPointParameteriv(pname, params) glatter_glPointParameteriv_debug((pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPointParameteriv_debug(GLenum pname, const GLint *params, const char* file, int line);
#ifndef glSecondaryColor3b
#define glSecondaryColor3b(red, green, blue) glatter_glSecondaryColor3b_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3b_debug(GLbyte red, GLbyte green, GLbyte blue, const char* file, int line);
#ifndef glSecondaryColor3bv
#define glSecondaryColor3bv(v) glatter_glSecondaryColor3bv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3bv_debug(const GLbyte *v, const char* file, int line);
#ifndef glSecondaryColor3d
#define glSecondaryColor3d(red, green, blue) glatter_glSecondaryColor3d_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3d_debug(GLdouble red, GLdouble green, GLdouble blue, const char* file, int line);
#ifndef glSecondaryColor3dv
#define glSecondaryColor3dv(v) glatter_glSecondaryColor3dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glSecondaryColor3f
#define glSecondaryColor3f(red, green, blue) glatter_glSecondaryColor3f_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3f_debug(GLfloat red, GLfloat green, GLfloat blue, const char* file, int line);
#ifndef glSecondaryColor3fv
#define glSecondaryColor3fv(v) glatter_glSecondaryColor3fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glSecondaryColor3i
#define glSecondaryColor3i(red, green, blue) glatter_glSecondaryColor3i_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3i_debug(GLint red, GLint green, GLint blue, const char* file, int line);
#ifndef glSecondaryColor3iv
#define glSecondaryColor3iv(v) glatter_glSecondaryColor3iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3iv_debug(const GLint *v, const char* file, int line);
#ifndef glSecondaryColor3s
#define glSecondaryColor3s(red, green, blue) glatter_glSecondaryColor3s_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3s_debug(GLshort red, GLshort green, GLshort blue, const char* file, int line);
#ifndef glSecondaryColor3sv
#define glSecondaryColor3sv(v) glatter_glSecondaryColor3sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3sv_debug(const GLshort *v, const char* file, int line);
#ifndef glSecondaryColor3ub
#define glSecondaryColor3ub(red, green, blue) glatter_glSecondaryColor3ub_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3ub_debug(GLubyte red, GLubyte green, GLubyte blue, const char* file, int line);
#ifndef glSecondaryColor3ubv
#define glSecondaryColor3ubv(v) glatter_glSecondaryColor3ubv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3ubv_debug(const GLubyte *v, const char* file, int line);
#ifndef glSecondaryColor3ui
#define glSecondaryColor3ui(red, green, blue) glatter_glSecondaryColor3ui_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3ui_debug(GLuint red, GLuint green, GLuint blue, const char* file, int line);
#ifndef glSecondaryColor3uiv
#define glSecondaryColor3uiv(v) glatter_glSecondaryColor3uiv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3uiv_debug(const GLuint *v, const char* file, int line);
#ifndef glSecondaryColor3us
#define glSecondaryColor3us(red, green, blue) glatter_glSecondaryColor3us_debug((red), (green), (blue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3us_debug(GLushort red, GLushort green, GLushort blue, const char* file, int line);
#ifndef glSecondaryColor3usv
#define glSecondaryColor3usv(v) glatter_glSecondaryColor3usv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3usv_debug(const GLushort *v, const char* file, int line);
#ifndef glSecondaryColorPointer
#define glSecondaryColorPointer(size, type, stride, pointer) glatter_glSecondaryColorPointer_debug((size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColorPointer_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glWindowPos2d
#define glWindowPos2d(x, y) glatter_glWindowPos2d_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2d_debug(GLdouble x, GLdouble y, const char* file, int line);
#ifndef glWindowPos2dv
#define glWindowPos2dv(v) glatter_glWindowPos2dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glWindowPos2f
#define glWindowPos2f(x, y) glatter_glWindowPos2f_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2f_debug(GLfloat x, GLfloat y, const char* file, int line);
#ifndef glWindowPos2fv
#define glWindowPos2fv(v) glatter_glWindowPos2fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glWindowPos2i
#define glWindowPos2i(x, y) glatter_glWindowPos2i_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2i_debug(GLint x, GLint y, const char* file, int line);
#ifndef glWindowPos2iv
#define glWindowPos2iv(v) glatter_glWindowPos2iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2iv_debug(const GLint *v, const char* file, int line);
#ifndef glWindowPos2s
#define glWindowPos2s(x, y) glatter_glWindowPos2s_debug((x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2s_debug(GLshort x, GLshort y, const char* file, int line);
#ifndef glWindowPos2sv
#define glWindowPos2sv(v) glatter_glWindowPos2sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2sv_debug(const GLshort *v, const char* file, int line);
#ifndef glWindowPos3d
#define glWindowPos3d(x, y, z) glatter_glWindowPos3d_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3d_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glWindowPos3dv
#define glWindowPos3dv(v) glatter_glWindowPos3dv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3dv_debug(const GLdouble *v, const char* file, int line);
#ifndef glWindowPos3f
#define glWindowPos3f(x, y, z) glatter_glWindowPos3f_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3f_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glWindowPos3fv
#define glWindowPos3fv(v) glatter_glWindowPos3fv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3fv_debug(const GLfloat *v, const char* file, int line);
#ifndef glWindowPos3i
#define glWindowPos3i(x, y, z) glatter_glWindowPos3i_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3i_debug(GLint x, GLint y, GLint z, const char* file, int line);
#ifndef glWindowPos3iv
#define glWindowPos3iv(v) glatter_glWindowPos3iv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3iv_debug(const GLint *v, const char* file, int line);
#ifndef glWindowPos3s
#define glWindowPos3s(x, y, z) glatter_glWindowPos3s_debug((x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3s_debug(GLshort x, GLshort y, GLshort z, const char* file, int line);
#ifndef glWindowPos3sv
#define glWindowPos3sv(v) glatter_glWindowPos3sv_debug((v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3sv_debug(const GLshort *v, const char* file, int line);
#endif // defined(GL_VERSION_1_4)
#if defined(GL_VERSION_1_5)
#ifndef glBeginQuery
#define glBeginQuery(target, id) glatter_glBeginQuery_debug((target), (id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginQuery_debug(GLenum target, GLuint id, const char* file, int line);
#ifndef glBindBuffer
#define glBindBuffer(target, buffer) glatter_glBindBuffer_debug((target), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBuffer_debug(GLenum target, GLuint buffer, const char* file, int line);
#ifndef glBufferData
#define glBufferData(target, size, data, usage) glatter_glBufferData_debug((target), (size), (data), (usage), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferData_debug(GLenum target, GLsizeiptr size, const void *data, GLenum usage, const char* file, int line);
#ifndef glBufferSubData
#define glBufferSubData(target, offset, size, data) glatter_glBufferSubData_debug((target), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferSubData_debug(GLenum target, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line);
#ifndef glDeleteBuffers
#define glDeleteBuffers(n, buffers) glatter_glDeleteBuffers_debug((n), (buffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteBuffers_debug(GLsizei n, const GLuint *buffers, const char* file, int line);
#ifndef glDeleteQueries
#define glDeleteQueries(n, ids) glatter_glDeleteQueries_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteQueries_debug(GLsizei n, const GLuint *ids, const char* file, int line);
#ifndef glEndQuery
#define glEndQuery(target) glatter_glEndQuery_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndQuery_debug(GLenum target, const char* file, int line);
#ifndef glGenBuffers
#define glGenBuffers(n, buffers) glatter_glGenBuffers_debug((n), (buffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenBuffers_debug(GLsizei n, GLuint *buffers, const char* file, int line);
#ifndef glGenQueries
#define glGenQueries(n, ids) glatter_glGenQueries_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenQueries_debug(GLsizei n, GLuint *ids, const char* file, int line);
#ifndef glGetBufferParameteriv
#define glGetBufferParameteriv(target, pname, params) glatter_glGetBufferParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBufferParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetBufferPointerv
#define glGetBufferPointerv(target, pname, params) glatter_glGetBufferPointerv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBufferPointerv_debug(GLenum target, GLenum pname, void **params, const char* file, int line);
#ifndef glGetBufferSubData
#define glGetBufferSubData(target, offset, size, data) glatter_glGetBufferSubData_debug((target), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBufferSubData_debug(GLenum target, GLintptr offset, GLsizeiptr size, void *data, const char* file, int line);
#ifndef glGetQueryObjectiv
#define glGetQueryObjectiv(id, pname, params) glatter_glGetQueryObjectiv_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectiv_debug(GLuint id, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetQueryObjectuiv
#define glGetQueryObjectuiv(id, pname, params) glatter_glGetQueryObjectuiv_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectuiv_debug(GLuint id, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glGetQueryiv
#define glGetQueryiv(target, pname, params) glatter_glGetQueryiv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryiv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsBuffer
#define glIsBuffer(buffer) glatter_glIsBuffer_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsBuffer_debug(GLuint buffer, const char* file, int line);
#ifndef glIsQuery
#define glIsQuery(id) glatter_glIsQuery_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsQuery_debug(GLuint id, const char* file, int line);
#ifndef glMapBuffer
#define glMapBuffer(target, access) glatter_glMapBuffer_debug((target), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void * glatter_glMapBuffer_debug(GLenum target, GLenum access, const char* file, int line);
#ifndef glUnmapBuffer
#define glUnmapBuffer(target) glatter_glUnmapBuffer_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glUnmapBuffer_debug(GLenum target, const char* file, int line);
#endif // defined(GL_VERSION_1_5)
#if defined(GL_VERSION_2_0)
#ifndef glAttachShader
#define glAttachShader(program, shader) glatter_glAttachShader_debug((program), (shader), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glAttachShader_debug(GLuint program, GLuint shader, const char* file, int line);
#ifndef glBindAttribLocation
#define glBindAttribLocation(program, index, name) glatter_glBindAttribLocation_debug((program), (index), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindAttribLocation_debug(GLuint program, GLuint index, const GLchar *name, const char* file, int line);
#ifndef glBlendEquationSeparate
#define glBlendEquationSeparate(modeRGB, modeAlpha) glatter_glBlendEquationSeparate_debug((modeRGB), (modeAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparate_debug(GLenum modeRGB, GLenum modeAlpha, const char* file, int line);
#ifndef glCompileShader
#define glCompileShader(shader) glatter_glCompileShader_debug((shader), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompileShader_debug(GLuint shader, const char* file, int line);
#ifndef glCreateProgram
#define glCreateProgram() glatter_glCreateProgram_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glCreateProgram_debug(const char* file, int line);
#ifndef glCreateShader
#define glCreateShader(type) glatter_glCreateShader_debug((type), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glCreateShader_debug(GLenum type, const char* file, int line);
#ifndef glDeleteProgram
#define glDeleteProgram(program) glatter_glDeleteProgram_debug((program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteProgram_debug(GLuint program, const char* file, int line);
#ifndef glDeleteShader
#define glDeleteShader(shader) glatter_glDeleteShader_debug((shader), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteShader_debug(GLuint shader, const char* file, int line);
#ifndef glDetachShader
#define glDetachShader(program, shader) glatter_glDetachShader_debug((program), (shader), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDetachShader_debug(GLuint program, GLuint shader, const char* file, int line);
#ifndef glDisableVertexAttribArray
#define glDisableVertexAttribArray(index) glatter_glDisableVertexAttribArray_debug((index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexAttribArray_debug(GLuint index, const char* file, int line);
#ifndef glDrawBuffers
#define glDrawBuffers(n, bufs) glatter_glDrawBuffers_debug((n), (bufs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffers_debug(GLsizei n, const GLenum *bufs, const char* file, int line);
#ifndef glEnableVertexAttribArray
#define glEnableVertexAttribArray(index) glatter_glEnableVertexAttribArray_debug((index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexAttribArray_debug(GLuint index, const char* file, int line);
#ifndef glGetActiveAttrib
#define glGetActiveAttrib(program, index, bufSize, length, size, type, name) glatter_glGetActiveAttrib_debug((program), (index), (bufSize), (length), (size), (type), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveAttrib_debug(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name, const char* file, int line);
#ifndef glGetActiveUniform
#define glGetActiveUniform(program, index, bufSize, length, size, type, name) glatter_glGetActiveUniform_debug((program), (index), (bufSize), (length), (size), (type), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniform_debug(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name, const char* file, int line);
#ifndef glGetAttachedShaders
#define glGetAttachedShaders(program, maxCount, count, shaders) glatter_glGetAttachedShaders_debug((program), (maxCount), (count), (shaders), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetAttachedShaders_debug(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders, const char* file, int line);
#ifndef glGetAttribLocation
#define glGetAttribLocation(program, name) glatter_glGetAttribLocation_debug((program), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetAttribLocation_debug(GLuint program, const GLchar *name, const char* file, int line);
#ifndef glGetProgramInfoLog
#define glGetProgramInfoLog(program, bufSize, length, infoLog) glatter_glGetProgramInfoLog_debug((program), (bufSize), (length), (infoLog), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramInfoLog_debug(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog, const char* file, int line);
#ifndef glGetProgramiv
#define glGetProgramiv(program, pname, params) glatter_glGetProgramiv_debug((program), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramiv_debug(GLuint program, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetShaderInfoLog
#define glGetShaderInfoLog(shader, bufSize, length, infoLog) glatter_glGetShaderInfoLog_debug((shader), (bufSize), (length), (infoLog), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetShaderInfoLog_debug(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog, const char* file, int line);
#ifndef glGetShaderSource
#define glGetShaderSource(shader, bufSize, length, source) glatter_glGetShaderSource_debug((shader), (bufSize), (length), (source), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetShaderSource_debug(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source, const char* file, int line);
#ifndef glGetShaderiv
#define glGetShaderiv(shader, pname, params) glatter_glGetShaderiv_debug((shader), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetShaderiv_debug(GLuint shader, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetUniformLocation
#define glGetUniformLocation(program, name) glatter_glGetUniformLocation_debug((program), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetUniformLocation_debug(GLuint program, const GLchar *name, const char* file, int line);
#ifndef glGetUniformfv
#define glGetUniformfv(program, location, params) glatter_glGetUniformfv_debug((program), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformfv_debug(GLuint program, GLint location, GLfloat *params, const char* file, int line);
#ifndef glGetUniformiv
#define glGetUniformiv(program, location, params) glatter_glGetUniformiv_debug((program), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformiv_debug(GLuint program, GLint location, GLint *params, const char* file, int line);
#ifndef glGetVertexAttribPointerv
#define glGetVertexAttribPointerv(index, pname, pointer) glatter_glGetVertexAttribPointerv_debug((index), (pname), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribPointerv_debug(GLuint index, GLenum pname, void **pointer, const char* file, int line);
#ifndef glGetVertexAttribdv
#define glGetVertexAttribdv(index, pname, params) glatter_glGetVertexAttribdv_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribdv_debug(GLuint index, GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glGetVertexAttribfv
#define glGetVertexAttribfv(index, pname, params) glatter_glGetVertexAttribfv_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribfv_debug(GLuint index, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetVertexAttribiv
#define glGetVertexAttribiv(index, pname, params) glatter_glGetVertexAttribiv_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribiv_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsProgram
#define glIsProgram(program) glatter_glIsProgram_debug((program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsProgram_debug(GLuint program, const char* file, int line);
#ifndef glIsShader
#define glIsShader(shader) glatter_glIsShader_debug((shader), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsShader_debug(GLuint shader, const char* file, int line);
#ifndef glLinkProgram
#define glLinkProgram(program) glatter_glLinkProgram_debug((program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glLinkProgram_debug(GLuint program, const char* file, int line);
#ifndef glShaderSource
#define glShaderSource(shader, count, string, length) glatter_glShaderSource_debug((shader), (count), (string), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glShaderSource_debug(GLuint shader, GLsizei count, const GLchar *const*string, const GLint *length, const char* file, int line);
#ifndef glStencilFuncSeparate
#define glStencilFuncSeparate(face, func, ref, mask) glatter_glStencilFuncSeparate_debug((face), (func), (ref), (mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilFuncSeparate_debug(GLenum face, GLenum func, GLint ref, GLuint mask, const char* file, int line);
#ifndef glStencilMaskSeparate
#define glStencilMaskSeparate(face, mask) glatter_glStencilMaskSeparate_debug((face), (mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilMaskSeparate_debug(GLenum face, GLuint mask, const char* file, int line);
#ifndef glStencilOpSeparate
#define glStencilOpSeparate(face, sfail, dpfail, dppass) glatter_glStencilOpSeparate_debug((face), (sfail), (dpfail), (dppass), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glStencilOpSeparate_debug(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass, const char* file, int line);
#ifndef glUniform1f
#define glUniform1f(location, v0) glatter_glUniform1f_debug((location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1f_debug(GLint location, GLfloat v0, const char* file, int line);
#ifndef glUniform1fv
#define glUniform1fv(location, count, value) glatter_glUniform1fv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1fv_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glUniform1i
#define glUniform1i(location, v0) glatter_glUniform1i_debug((location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1i_debug(GLint location, GLint v0, const char* file, int line);
#ifndef glUniform1iv
#define glUniform1iv(location, count, value) glatter_glUniform1iv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1iv_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glUniform2f
#define glUniform2f(location, v0, v1) glatter_glUniform2f_debug((location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2f_debug(GLint location, GLfloat v0, GLfloat v1, const char* file, int line);
#ifndef glUniform2fv
#define glUniform2fv(location, count, value) glatter_glUniform2fv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2fv_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glUniform2i
#define glUniform2i(location, v0, v1) glatter_glUniform2i_debug((location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2i_debug(GLint location, GLint v0, GLint v1, const char* file, int line);
#ifndef glUniform2iv
#define glUniform2iv(location, count, value) glatter_glUniform2iv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2iv_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glUniform3f
#define glUniform3f(location, v0, v1, v2) glatter_glUniform3f_debug((location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3f_debug(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, const char* file, int line);
#ifndef glUniform3fv
#define glUniform3fv(location, count, value) glatter_glUniform3fv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3fv_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glUniform3i
#define glUniform3i(location, v0, v1, v2) glatter_glUniform3i_debug((location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3i_debug(GLint location, GLint v0, GLint v1, GLint v2, const char* file, int line);
#ifndef glUniform3iv
#define glUniform3iv(location, count, value) glatter_glUniform3iv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3iv_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glUniform4f
#define glUniform4f(location, v0, v1, v2, v3) glatter_glUniform4f_debug((location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4f_debug(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3, const char* file, int line);
#ifndef glUniform4fv
#define glUniform4fv(location, count, value) glatter_glUniform4fv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4fv_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glUniform4i
#define glUniform4i(location, v0, v1, v2, v3) glatter_glUniform4i_debug((location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4i_debug(GLint location, GLint v0, GLint v1, GLint v2, GLint v3, const char* file, int line);
#ifndef glUniform4iv
#define glUniform4iv(location, count, value) glatter_glUniform4iv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4iv_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glUniformMatrix2fv
#define glUniformMatrix2fv(location, count, transpose, value) glatter_glUniformMatrix2fv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUniformMatrix3fv
#define glUniformMatrix3fv(location, count, transpose, value) glatter_glUniformMatrix3fv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUniformMatrix4fv
#define glUniformMatrix4fv(location, count, transpose, value) glatter_glUniformMatrix4fv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUseProgram
#define glUseProgram(program) glatter_glUseProgram_debug((program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUseProgram_debug(GLuint program, const char* file, int line);
#ifndef glValidateProgram
#define glValidateProgram(program) glatter_glValidateProgram_debug((program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glValidateProgram_debug(GLuint program, const char* file, int line);
#ifndef glVertexAttrib1d
#define glVertexAttrib1d(index, x) glatter_glVertexAttrib1d_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1d_debug(GLuint index, GLdouble x, const char* file, int line);
#ifndef glVertexAttrib1dv
#define glVertexAttrib1dv(index, v) glatter_glVertexAttrib1dv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1dv_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib1f
#define glVertexAttrib1f(index, x) glatter_glVertexAttrib1f_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1f_debug(GLuint index, GLfloat x, const char* file, int line);
#ifndef glVertexAttrib1fv
#define glVertexAttrib1fv(index, v) glatter_glVertexAttrib1fv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1fv_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib1s
#define glVertexAttrib1s(index, x) glatter_glVertexAttrib1s_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1s_debug(GLuint index, GLshort x, const char* file, int line);
#ifndef glVertexAttrib1sv
#define glVertexAttrib1sv(index, v) glatter_glVertexAttrib1sv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1sv_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib2d
#define glVertexAttrib2d(index, x, y) glatter_glVertexAttrib2d_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2d_debug(GLuint index, GLdouble x, GLdouble y, const char* file, int line);
#ifndef glVertexAttrib2dv
#define glVertexAttrib2dv(index, v) glatter_glVertexAttrib2dv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2dv_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib2f
#define glVertexAttrib2f(index, x, y) glatter_glVertexAttrib2f_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2f_debug(GLuint index, GLfloat x, GLfloat y, const char* file, int line);
#ifndef glVertexAttrib2fv
#define glVertexAttrib2fv(index, v) glatter_glVertexAttrib2fv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2fv_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib2s
#define glVertexAttrib2s(index, x, y) glatter_glVertexAttrib2s_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2s_debug(GLuint index, GLshort x, GLshort y, const char* file, int line);
#ifndef glVertexAttrib2sv
#define glVertexAttrib2sv(index, v) glatter_glVertexAttrib2sv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2sv_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib3d
#define glVertexAttrib3d(index, x, y, z) glatter_glVertexAttrib3d_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3d_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glVertexAttrib3dv
#define glVertexAttrib3dv(index, v) glatter_glVertexAttrib3dv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3dv_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib3f
#define glVertexAttrib3f(index, x, y, z) glatter_glVertexAttrib3f_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3f_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, const char* file, int line);
#ifndef glVertexAttrib3fv
#define glVertexAttrib3fv(index, v) glatter_glVertexAttrib3fv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3fv_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib3s
#define glVertexAttrib3s(index, x, y, z) glatter_glVertexAttrib3s_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3s_debug(GLuint index, GLshort x, GLshort y, GLshort z, const char* file, int line);
#ifndef glVertexAttrib3sv
#define glVertexAttrib3sv(index, v) glatter_glVertexAttrib3sv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3sv_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib4Nbv
#define glVertexAttrib4Nbv(index, v) glatter_glVertexAttrib4Nbv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4Nbv_debug(GLuint index, const GLbyte *v, const char* file, int line);
#ifndef glVertexAttrib4Niv
#define glVertexAttrib4Niv(index, v) glatter_glVertexAttrib4Niv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4Niv_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttrib4Nsv
#define glVertexAttrib4Nsv(index, v) glatter_glVertexAttrib4Nsv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4Nsv_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib4Nub
#define glVertexAttrib4Nub(index, x, y, z, w) glatter_glVertexAttrib4Nub_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4Nub_debug(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w, const char* file, int line);
#ifndef glVertexAttrib4Nubv
#define glVertexAttrib4Nubv(index, v) glatter_glVertexAttrib4Nubv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4Nubv_debug(GLuint index, const GLubyte *v, const char* file, int line);
#ifndef glVertexAttrib4Nuiv
#define glVertexAttrib4Nuiv(index, v) glatter_glVertexAttrib4Nuiv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4Nuiv_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttrib4Nusv
#define glVertexAttrib4Nusv(index, v) glatter_glVertexAttrib4Nusv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4Nusv_debug(GLuint index, const GLushort *v, const char* file, int line);
#ifndef glVertexAttrib4bv
#define glVertexAttrib4bv(index, v) glatter_glVertexAttrib4bv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4bv_debug(GLuint index, const GLbyte *v, const char* file, int line);
#ifndef glVertexAttrib4d
#define glVertexAttrib4d(index, x, y, z, w) glatter_glVertexAttrib4d_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4d_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glVertexAttrib4dv
#define glVertexAttrib4dv(index, v) glatter_glVertexAttrib4dv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4dv_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttrib4f
#define glVertexAttrib4f(index, x, y, z, w) glatter_glVertexAttrib4f_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4f_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line);
#ifndef glVertexAttrib4fv
#define glVertexAttrib4fv(index, v) glatter_glVertexAttrib4fv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4fv_debug(GLuint index, const GLfloat *v, const char* file, int line);
#ifndef glVertexAttrib4iv
#define glVertexAttrib4iv(index, v) glatter_glVertexAttrib4iv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4iv_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttrib4s
#define glVertexAttrib4s(index, x, y, z, w) glatter_glVertexAttrib4s_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4s_debug(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line);
#ifndef glVertexAttrib4sv
#define glVertexAttrib4sv(index, v) glatter_glVertexAttrib4sv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4sv_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttrib4ubv
#define glVertexAttrib4ubv(index, v) glatter_glVertexAttrib4ubv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4ubv_debug(GLuint index, const GLubyte *v, const char* file, int line);
#ifndef glVertexAttrib4uiv
#define glVertexAttrib4uiv(index, v) glatter_glVertexAttrib4uiv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4uiv_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttrib4usv
#define glVertexAttrib4usv(index, v) glatter_glVertexAttrib4usv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4usv_debug(GLuint index, const GLushort *v, const char* file, int line);
#ifndef glVertexAttribPointer
#define glVertexAttribPointer(index, size, type, normalized, stride, pointer) glatter_glVertexAttribPointer_debug((index), (size), (type), (normalized), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribPointer_debug(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer, const char* file, int line);
#endif // defined(GL_VERSION_2_0)
#if defined(GL_VERSION_2_1)
#ifndef glUniformMatrix2x3fv
#define glUniformMatrix2x3fv(location, count, transpose, value) glatter_glUniformMatrix2x3fv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2x3fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUniformMatrix2x4fv
#define glUniformMatrix2x4fv(location, count, transpose, value) glatter_glUniformMatrix2x4fv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2x4fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUniformMatrix3x2fv
#define glUniformMatrix3x2fv(location, count, transpose, value) glatter_glUniformMatrix3x2fv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3x2fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUniformMatrix3x4fv
#define glUniformMatrix3x4fv(location, count, transpose, value) glatter_glUniformMatrix3x4fv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3x4fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUniformMatrix4x2fv
#define glUniformMatrix4x2fv(location, count, transpose, value) glatter_glUniformMatrix4x2fv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4x2fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glUniformMatrix4x3fv
#define glUniformMatrix4x3fv(location, count, transpose, value) glatter_glUniformMatrix4x3fv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4x3fv_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#endif // defined(GL_VERSION_2_1)
#if defined(GL_VERSION_3_0)
#ifndef glBeginConditionalRender
#define glBeginConditionalRender(id, mode) glatter_glBeginConditionalRender_debug((id), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginConditionalRender_debug(GLuint id, GLenum mode, const char* file, int line);
#ifndef glBeginTransformFeedback
#define glBeginTransformFeedback(primitiveMode) glatter_glBeginTransformFeedback_debug((primitiveMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginTransformFeedback_debug(GLenum primitiveMode, const char* file, int line);
#ifndef glBindBufferBase
#define glBindBufferBase(target, index, buffer) glatter_glBindBufferBase_debug((target), (index), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBufferBase_debug(GLenum target, GLuint index, GLuint buffer, const char* file, int line);
#ifndef glBindBufferRange
#define glBindBufferRange(target, index, buffer, offset, size) glatter_glBindBufferRange_debug((target), (index), (buffer), (offset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBufferRange_debug(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line);
#ifndef glBindFragDataLocation
#define glBindFragDataLocation(program, color, name) glatter_glBindFragDataLocation_debug((program), (color), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindFragDataLocation_debug(GLuint program, GLuint color, const GLchar *name, const char* file, int line);
#ifndef glBindFramebuffer
#define glBindFramebuffer(target, framebuffer) glatter_glBindFramebuffer_debug((target), (framebuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindFramebuffer_debug(GLenum target, GLuint framebuffer, const char* file, int line);
#ifndef glBindRenderbuffer
#define glBindRenderbuffer(target, renderbuffer) glatter_glBindRenderbuffer_debug((target), (renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindRenderbuffer_debug(GLenum target, GLuint renderbuffer, const char* file, int line);
#ifndef glBindVertexArray
#define glBindVertexArray(array) glatter_glBindVertexArray_debug((array), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindVertexArray_debug(GLuint array, const char* file, int line);
#ifndef glBlitFramebuffer
#define glBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter) glatter_glBlitFramebuffer_debug((srcX0), (srcY0), (srcX1), (srcY1), (dstX0), (dstY0), (dstX1), (dstY1), (mask), (filter), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlitFramebuffer_debug(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter, const char* file, int line);
#ifndef glCheckFramebufferStatus
#define glCheckFramebufferStatus(target) glatter_glCheckFramebufferStatus_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glCheckFramebufferStatus_debug(GLenum target, const char* file, int line);
#ifndef glClampColor
#define glClampColor(target, clamp) glatter_glClampColor_debug((target), (clamp), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClampColor_debug(GLenum target, GLenum clamp, const char* file, int line);
#ifndef glClearBufferfi
#define glClearBufferfi(buffer, drawbuffer, depth, stencil) glatter_glClearBufferfi_debug((buffer), (drawbuffer), (depth), (stencil), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearBufferfi_debug(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil, const char* file, int line);
#ifndef glClearBufferfv
#define glClearBufferfv(buffer, drawbuffer, value) glatter_glClearBufferfv_debug((buffer), (drawbuffer), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearBufferfv_debug(GLenum buffer, GLint drawbuffer, const GLfloat *value, const char* file, int line);
#ifndef glClearBufferiv
#define glClearBufferiv(buffer, drawbuffer, value) glatter_glClearBufferiv_debug((buffer), (drawbuffer), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearBufferiv_debug(GLenum buffer, GLint drawbuffer, const GLint *value, const char* file, int line);
#ifndef glClearBufferuiv
#define glClearBufferuiv(buffer, drawbuffer, value) glatter_glClearBufferuiv_debug((buffer), (drawbuffer), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearBufferuiv_debug(GLenum buffer, GLint drawbuffer, const GLuint *value, const char* file, int line);
#ifndef glColorMaski
#define glColorMaski(index, r, g, b, a) glatter_glColorMaski_debug((index), (r), (g), (b), (a), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorMaski_debug(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a, const char* file, int line);
#ifndef glDeleteFramebuffers
#define glDeleteFramebuffers(n, framebuffers) glatter_glDeleteFramebuffers_debug((n), (framebuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteFramebuffers_debug(GLsizei n, const GLuint *framebuffers, const char* file, int line);
#ifndef glDeleteRenderbuffers
#define glDeleteRenderbuffers(n, renderbuffers) glatter_glDeleteRenderbuffers_debug((n), (renderbuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteRenderbuffers_debug(GLsizei n, const GLuint *renderbuffers, const char* file, int line);
#ifndef glDeleteVertexArrays
#define glDeleteVertexArrays(n, arrays) glatter_glDeleteVertexArrays_debug((n), (arrays), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteVertexArrays_debug(GLsizei n, const GLuint *arrays, const char* file, int line);
#ifndef glDisablei
#define glDisablei(target, index) glatter_glDisablei_debug((target), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisablei_debug(GLenum target, GLuint index, const char* file, int line);
#ifndef glEnablei
#define glEnablei(target, index) glatter_glEnablei_debug((target), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnablei_debug(GLenum target, GLuint index, const char* file, int line);
#ifndef glEndConditionalRender
#define glEndConditionalRender() glatter_glEndConditionalRender_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndConditionalRender_debug(const char* file, int line);
#ifndef glEndTransformFeedback
#define glEndTransformFeedback() glatter_glEndTransformFeedback_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndTransformFeedback_debug(const char* file, int line);
#ifndef glFlushMappedBufferRange
#define glFlushMappedBufferRange(target, offset, length) glatter_glFlushMappedBufferRange_debug((target), (offset), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlushMappedBufferRange_debug(GLenum target, GLintptr offset, GLsizeiptr length, const char* file, int line);
#ifndef glFramebufferRenderbuffer
#define glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer) glatter_glFramebufferRenderbuffer_debug((target), (attachment), (renderbuffertarget), (renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferRenderbuffer_debug(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer, const char* file, int line);
#ifndef glFramebufferTexture1D
#define glFramebufferTexture1D(target, attachment, textarget, texture, level) glatter_glFramebufferTexture1D_debug((target), (attachment), (textarget), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture1D_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line);
#ifndef glFramebufferTexture2D
#define glFramebufferTexture2D(target, attachment, textarget, texture, level) glatter_glFramebufferTexture2D_debug((target), (attachment), (textarget), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2D_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line);
#ifndef glFramebufferTexture3D
#define glFramebufferTexture3D(target, attachment, textarget, texture, level, zoffset) glatter_glFramebufferTexture3D_debug((target), (attachment), (textarget), (texture), (level), (zoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture3D_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset, const char* file, int line);
#ifndef glFramebufferTextureLayer
#define glFramebufferTextureLayer(target, attachment, texture, level, layer) glatter_glFramebufferTextureLayer_debug((target), (attachment), (texture), (level), (layer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureLayer_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer, const char* file, int line);
#ifndef glGenFramebuffers
#define glGenFramebuffers(n, framebuffers) glatter_glGenFramebuffers_debug((n), (framebuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenFramebuffers_debug(GLsizei n, GLuint *framebuffers, const char* file, int line);
#ifndef glGenRenderbuffers
#define glGenRenderbuffers(n, renderbuffers) glatter_glGenRenderbuffers_debug((n), (renderbuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenRenderbuffers_debug(GLsizei n, GLuint *renderbuffers, const char* file, int line);
#ifndef glGenVertexArrays
#define glGenVertexArrays(n, arrays) glatter_glGenVertexArrays_debug((n), (arrays), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenVertexArrays_debug(GLsizei n, GLuint *arrays, const char* file, int line);
#ifndef glGenerateMipmap
#define glGenerateMipmap(target) glatter_glGenerateMipmap_debug((target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenerateMipmap_debug(GLenum target, const char* file, int line);
#ifndef glGetBooleani_v
#define glGetBooleani_v(target, index, data) glatter_glGetBooleani_v_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBooleani_v_debug(GLenum target, GLuint index, GLboolean *data, const char* file, int line);
#ifndef glGetFragDataLocation
#define glGetFragDataLocation(program, name) glatter_glGetFragDataLocation_debug((program), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetFragDataLocation_debug(GLuint program, const GLchar *name, const char* file, int line);
#ifndef glGetFramebufferAttachmentParameteriv
#define glGetFramebufferAttachmentParameteriv(target, attachment, pname, params) glatter_glGetFramebufferAttachmentParameteriv_debug((target), (attachment), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferAttachmentParameteriv_debug(GLenum target, GLenum attachment, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetIntegeri_v
#define glGetIntegeri_v(target, index, data) glatter_glGetIntegeri_v_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetIntegeri_v_debug(GLenum target, GLuint index, GLint *data, const char* file, int line);
#ifndef glGetRenderbufferParameteriv
#define glGetRenderbufferParameteriv(target, pname, params) glatter_glGetRenderbufferParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetRenderbufferParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetStringi
#define glGetStringi(name, index) glatter_glGetStringi_debug((name), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT const GLubyte * glatter_glGetStringi_debug(GLenum name, GLuint index, const char* file, int line);
#ifndef glGetTexParameterIiv
#define glGetTexParameterIiv(target, pname, params) glatter_glGetTexParameterIiv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIiv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTexParameterIuiv
#define glGetTexParameterIuiv(target, pname, params) glatter_glGetTexParameterIuiv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIuiv_debug(GLenum target, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glGetTransformFeedbackVarying
#define glGetTransformFeedbackVarying(program, index, bufSize, length, size, type, name) glatter_glGetTransformFeedbackVarying_debug((program), (index), (bufSize), (length), (size), (type), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTransformFeedbackVarying_debug(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name, const char* file, int line);
#ifndef glGetUniformuiv
#define glGetUniformuiv(program, location, params) glatter_glGetUniformuiv_debug((program), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformuiv_debug(GLuint program, GLint location, GLuint *params, const char* file, int line);
#ifndef glGetVertexAttribIiv
#define glGetVertexAttribIiv(index, pname, params) glatter_glGetVertexAttribIiv_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribIiv_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetVertexAttribIuiv
#define glGetVertexAttribIuiv(index, pname, params) glatter_glGetVertexAttribIuiv_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribIuiv_debug(GLuint index, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glIsEnabledi
#define glIsEnabledi(target, index) glatter_glIsEnabledi_debug((target), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnabledi_debug(GLenum target, GLuint index, const char* file, int line);
#ifndef glIsFramebuffer
#define glIsFramebuffer(framebuffer) glatter_glIsFramebuffer_debug((framebuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFramebuffer_debug(GLuint framebuffer, const char* file, int line);
#ifndef glIsRenderbuffer
#define glIsRenderbuffer(renderbuffer) glatter_glIsRenderbuffer_debug((renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsRenderbuffer_debug(GLuint renderbuffer, const char* file, int line);
#ifndef glIsVertexArray
#define glIsVertexArray(array) glatter_glIsVertexArray_debug((array), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVertexArray_debug(GLuint array, const char* file, int line);
#ifndef glMapBufferRange
#define glMapBufferRange(target, offset, length, access) glatter_glMapBufferRange_debug((target), (offset), (length), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void * glatter_glMapBufferRange_debug(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access, const char* file, int line);
#ifndef glRenderbufferStorage
#define glRenderbufferStorage(target, internalformat, width, height) glatter_glRenderbufferStorage_debug((target), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorage_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glRenderbufferStorageMultisample
#define glRenderbufferStorageMultisample(target, samples, internalformat, width, height) glatter_glRenderbufferStorageMultisample_debug((target), (samples), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisample_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glTexParameterIiv
#define glTexParameterIiv(target, pname, params) glatter_glTexParameterIiv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIiv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glTexParameterIuiv
#define glTexParameterIuiv(target, pname, params) glatter_glTexParameterIuiv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIuiv_debug(GLenum target, GLenum pname, const GLuint *params, const char* file, int line);
#ifndef glTransformFeedbackVaryings
#define glTransformFeedbackVaryings(program, count, varyings, bufferMode) glatter_glTransformFeedbackVaryings_debug((program), (count), (varyings), (bufferMode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTransformFeedbackVaryings_debug(GLuint program, GLsizei count, const GLchar *const*varyings, GLenum bufferMode, const char* file, int line);
#ifndef glUniform1ui
#define glUniform1ui(location, v0) glatter_glUniform1ui_debug((location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui_debug(GLint location, GLuint v0, const char* file, int line);
#ifndef glUniform1uiv
#define glUniform1uiv(location, count, value) glatter_glUniform1uiv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1uiv_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glUniform2ui
#define glUniform2ui(location, v0, v1) glatter_glUniform2ui_debug((location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui_debug(GLint location, GLuint v0, GLuint v1, const char* file, int line);
#ifndef glUniform2uiv
#define glUniform2uiv(location, count, value) glatter_glUniform2uiv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2uiv_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glUniform3ui
#define glUniform3ui(location, v0, v1, v2) glatter_glUniform3ui_debug((location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui_debug(GLint location, GLuint v0, GLuint v1, GLuint v2, const char* file, int line);
#ifndef glUniform3uiv
#define glUniform3uiv(location, count, value) glatter_glUniform3uiv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3uiv_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glUniform4ui
#define glUniform4ui(location, v0, v1, v2, v3) glatter_glUniform4ui_debug((location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui_debug(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3, const char* file, int line);
#ifndef glUniform4uiv
#define glUniform4uiv(location, count, value) glatter_glUniform4uiv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4uiv_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glVertexAttribI1i
#define glVertexAttribI1i(index, x) glatter_glVertexAttribI1i_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI1i_debug(GLuint index, GLint x, const char* file, int line);
#ifndef glVertexAttribI1iv
#define glVertexAttribI1iv(index, v) glatter_glVertexAttribI1iv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI1iv_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttribI1ui
#define glVertexAttribI1ui(index, x) glatter_glVertexAttribI1ui_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI1ui_debug(GLuint index, GLuint x, const char* file, int line);
#ifndef glVertexAttribI1uiv
#define glVertexAttribI1uiv(index, v) glatter_glVertexAttribI1uiv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI1uiv_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttribI2i
#define glVertexAttribI2i(index, x, y) glatter_glVertexAttribI2i_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI2i_debug(GLuint index, GLint x, GLint y, const char* file, int line);
#ifndef glVertexAttribI2iv
#define glVertexAttribI2iv(index, v) glatter_glVertexAttribI2iv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI2iv_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttribI2ui
#define glVertexAttribI2ui(index, x, y) glatter_glVertexAttribI2ui_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI2ui_debug(GLuint index, GLuint x, GLuint y, const char* file, int line);
#ifndef glVertexAttribI2uiv
#define glVertexAttribI2uiv(index, v) glatter_glVertexAttribI2uiv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI2uiv_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttribI3i
#define glVertexAttribI3i(index, x, y, z) glatter_glVertexAttribI3i_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI3i_debug(GLuint index, GLint x, GLint y, GLint z, const char* file, int line);
#ifndef glVertexAttribI3iv
#define glVertexAttribI3iv(index, v) glatter_glVertexAttribI3iv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI3iv_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttribI3ui
#define glVertexAttribI3ui(index, x, y, z) glatter_glVertexAttribI3ui_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI3ui_debug(GLuint index, GLuint x, GLuint y, GLuint z, const char* file, int line);
#ifndef glVertexAttribI3uiv
#define glVertexAttribI3uiv(index, v) glatter_glVertexAttribI3uiv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI3uiv_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttribI4bv
#define glVertexAttribI4bv(index, v) glatter_glVertexAttribI4bv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4bv_debug(GLuint index, const GLbyte *v, const char* file, int line);
#ifndef glVertexAttribI4i
#define glVertexAttribI4i(index, x, y, z, w) glatter_glVertexAttribI4i_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4i_debug(GLuint index, GLint x, GLint y, GLint z, GLint w, const char* file, int line);
#ifndef glVertexAttribI4iv
#define glVertexAttribI4iv(index, v) glatter_glVertexAttribI4iv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4iv_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glVertexAttribI4sv
#define glVertexAttribI4sv(index, v) glatter_glVertexAttribI4sv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4sv_debug(GLuint index, const GLshort *v, const char* file, int line);
#ifndef glVertexAttribI4ubv
#define glVertexAttribI4ubv(index, v) glatter_glVertexAttribI4ubv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4ubv_debug(GLuint index, const GLubyte *v, const char* file, int line);
#ifndef glVertexAttribI4ui
#define glVertexAttribI4ui(index, x, y, z, w) glatter_glVertexAttribI4ui_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4ui_debug(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w, const char* file, int line);
#ifndef glVertexAttribI4uiv
#define glVertexAttribI4uiv(index, v) glatter_glVertexAttribI4uiv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4uiv_debug(GLuint index, const GLuint *v, const char* file, int line);
#ifndef glVertexAttribI4usv
#define glVertexAttribI4usv(index, v) glatter_glVertexAttribI4usv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribI4usv_debug(GLuint index, const GLushort *v, const char* file, int line);
#ifndef glVertexAttribIPointer
#define glVertexAttribIPointer(index, size, type, stride, pointer) glatter_glVertexAttribIPointer_debug((index), (size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribIPointer_debug(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#endif // defined(GL_VERSION_3_0)
#if defined(GL_VERSION_3_1)
#ifndef glCopyBufferSubData
#define glCopyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size) glatter_glCopyBufferSubData_debug((readTarget), (writeTarget), (readOffset), (writeOffset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyBufferSubData_debug(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size, const char* file, int line);
#ifndef glDrawArraysInstanced
#define glDrawArraysInstanced(mode, first, count, instancecount) glatter_glDrawArraysInstanced_debug((mode), (first), (count), (instancecount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstanced_debug(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, const char* file, int line);
#ifndef glDrawElementsInstanced
#define glDrawElementsInstanced(mode, count, type, indices, instancecount) glatter_glDrawElementsInstanced_debug((mode), (count), (type), (indices), (instancecount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstanced_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, const char* file, int line);
#ifndef glGetActiveUniformBlockName
#define glGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, length, uniformBlockName) glatter_glGetActiveUniformBlockName_debug((program), (uniformBlockIndex), (bufSize), (length), (uniformBlockName), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniformBlockName_debug(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName, const char* file, int line);
#ifndef glGetActiveUniformBlockiv
#define glGetActiveUniformBlockiv(program, uniformBlockIndex, pname, params) glatter_glGetActiveUniformBlockiv_debug((program), (uniformBlockIndex), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniformBlockiv_debug(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetActiveUniformName
#define glGetActiveUniformName(program, uniformIndex, bufSize, length, uniformName) glatter_glGetActiveUniformName_debug((program), (uniformIndex), (bufSize), (length), (uniformName), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniformName_debug(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName, const char* file, int line);
#ifndef glGetActiveUniformsiv
#define glGetActiveUniformsiv(program, uniformCount, uniformIndices, pname, params) glatter_glGetActiveUniformsiv_debug((program), (uniformCount), (uniformIndices), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniformsiv_debug(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetUniformBlockIndex
#define glGetUniformBlockIndex(program, uniformBlockName) glatter_glGetUniformBlockIndex_debug((program), (uniformBlockName), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGetUniformBlockIndex_debug(GLuint program, const GLchar *uniformBlockName, const char* file, int line);
#ifndef glGetUniformIndices
#define glGetUniformIndices(program, uniformCount, uniformNames, uniformIndices) glatter_glGetUniformIndices_debug((program), (uniformCount), (uniformNames), (uniformIndices), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformIndices_debug(GLuint program, GLsizei uniformCount, const GLchar *const*uniformNames, GLuint *uniformIndices, const char* file, int line);
#ifndef glPrimitiveRestartIndex
#define glPrimitiveRestartIndex(index) glatter_glPrimitiveRestartIndex_debug((index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveRestartIndex_debug(GLuint index, const char* file, int line);
#ifndef glTexBuffer
#define glTexBuffer(target, internalformat, buffer) glatter_glTexBuffer_debug((target), (internalformat), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexBuffer_debug(GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line);
#ifndef glUniformBlockBinding
#define glUniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding) glatter_glUniformBlockBinding_debug((program), (uniformBlockIndex), (uniformBlockBinding), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformBlockBinding_debug(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding, const char* file, int line);
#endif // defined(GL_VERSION_3_1)
#if defined(GL_VERSION_3_2)
#ifndef glClientWaitSync
#define glClientWaitSync(sync, flags, timeout) glatter_glClientWaitSync_debug((sync), (flags), (timeout), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glClientWaitSync_debug(GLsync sync, GLbitfield flags, GLuint64 timeout, const char* file, int line);
#ifndef glDeleteSync
#define glDeleteSync(sync) glatter_glDeleteSync_debug((sync), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteSync_debug(GLsync sync, const char* file, int line);
#ifndef glDrawElementsBaseVertex
#define glDrawElementsBaseVertex(mode, count, type, indices, basevertex) glatter_glDrawElementsBaseVertex_debug((mode), (count), (type), (indices), (basevertex), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsBaseVertex_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex, const char* file, int line);
#ifndef glDrawElementsInstancedBaseVertex
#define glDrawElementsInstancedBaseVertex(mode, count, type, indices, instancecount, basevertex) glatter_glDrawElementsInstancedBaseVertex_debug((mode), (count), (type), (indices), (instancecount), (basevertex), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedBaseVertex_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, const char* file, int line);
#ifndef glDrawRangeElementsBaseVertex
#define glDrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex) glatter_glDrawRangeElementsBaseVertex_debug((mode), (start), (end), (count), (type), (indices), (basevertex), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementsBaseVertex_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex, const char* file, int line);
#ifndef glFenceSync
#define glFenceSync(condition, flags) glatter_glFenceSync_debug((condition), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLsync glatter_glFenceSync_debug(GLenum condition, GLbitfield flags, const char* file, int line);
#ifndef glFramebufferTexture
#define glFramebufferTexture(target, attachment, texture, level) glatter_glFramebufferTexture_debug((target), (attachment), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, const char* file, int line);
#ifndef glGetBufferParameteri64v
#define glGetBufferParameteri64v(target, pname, params) glatter_glGetBufferParameteri64v_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetBufferParameteri64v_debug(GLenum target, GLenum pname, GLint64 *params, const char* file, int line);
#ifndef glGetInteger64i_v
#define glGetInteger64i_v(target, index, data) glatter_glGetInteger64i_v_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetInteger64i_v_debug(GLenum target, GLuint index, GLint64 *data, const char* file, int line);
#ifndef glGetInteger64v
#define glGetInteger64v(pname, data) glatter_glGetInteger64v_debug((pname), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetInteger64v_debug(GLenum pname, GLint64 *data, const char* file, int line);
#ifndef glGetMultisamplefv
#define glGetMultisamplefv(pname, index, val) glatter_glGetMultisamplefv_debug((pname), (index), (val), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetMultisamplefv_debug(GLenum pname, GLuint index, GLfloat *val, const char* file, int line);
#ifndef glGetSynciv
#define glGetSynciv(sync, pname, bufSize, length, values) glatter_glGetSynciv_debug((sync), (pname), (bufSize), (length), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetSynciv_debug(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values, const char* file, int line);
#ifndef glIsSync
#define glIsSync(sync) glatter_glIsSync_debug((sync), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsSync_debug(GLsync sync, const char* file, int line);
#ifndef glMultiDrawElementsBaseVertex
#define glMultiDrawElementsBaseVertex(mode, count, type, indices, drawcount, basevertex) glatter_glMultiDrawElementsBaseVertex_debug((mode), (count), (type), (indices), (drawcount), (basevertex), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsBaseVertex_debug(GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei drawcount, const GLint *basevertex, const char* file, int line);
#ifndef glProvokingVertex
#define glProvokingVertex(mode) glatter_glProvokingVertex_debug((mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProvokingVertex_debug(GLenum mode, const char* file, int line);
#ifndef glSampleMaski
#define glSampleMaski(maskNumber, mask) glatter_glSampleMaski_debug((maskNumber), (mask), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSampleMaski_debug(GLuint maskNumber, GLbitfield mask, const char* file, int line);
#ifndef glTexImage2DMultisample
#define glTexImage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations) glatter_glTexImage2DMultisample_debug((target), (samples), (internalformat), (width), (height), (fixedsamplelocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexImage2DMultisample_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations, const char* file, int line);
#ifndef glTexImage3DMultisample
#define glTexImage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations) glatter_glTexImage3DMultisample_debug((target), (samples), (internalformat), (width), (height), (depth), (fixedsamplelocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexImage3DMultisample_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations, const char* file, int line);
#ifndef glWaitSync
#define glWaitSync(sync, flags, timeout) glatter_glWaitSync_debug((sync), (flags), (timeout), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glWaitSync_debug(GLsync sync, GLbitfield flags, GLuint64 timeout, const char* file, int line);
#endif // defined(GL_VERSION_3_2)
#if defined(GL_VERSION_3_3)
#ifndef glBindFragDataLocationIndexed
#define glBindFragDataLocationIndexed(program, colorNumber, index, name) glatter_glBindFragDataLocationIndexed_debug((program), (colorNumber), (index), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindFragDataLocationIndexed_debug(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name, const char* file, int line);
#ifndef glBindSampler
#define glBindSampler(unit, sampler) glatter_glBindSampler_debug((unit), (sampler), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindSampler_debug(GLuint unit, GLuint sampler, const char* file, int line);
#ifndef glColorP3ui
#define glColorP3ui(type, color) glatter_glColorP3ui_debug((type), (color), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorP3ui_debug(GLenum type, GLuint color, const char* file, int line);
#ifndef glColorP3uiv
#define glColorP3uiv(type, color) glatter_glColorP3uiv_debug((type), (color), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorP3uiv_debug(GLenum type, const GLuint *color, const char* file, int line);
#ifndef glColorP4ui
#define glColorP4ui(type, color) glatter_glColorP4ui_debug((type), (color), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorP4ui_debug(GLenum type, GLuint color, const char* file, int line);
#ifndef glColorP4uiv
#define glColorP4uiv(type, color) glatter_glColorP4uiv_debug((type), (color), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glColorP4uiv_debug(GLenum type, const GLuint *color, const char* file, int line);
#ifndef glDeleteSamplers
#define glDeleteSamplers(count, samplers) glatter_glDeleteSamplers_debug((count), (samplers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteSamplers_debug(GLsizei count, const GLuint *samplers, const char* file, int line);
#ifndef glGenSamplers
#define glGenSamplers(count, samplers) glatter_glGenSamplers_debug((count), (samplers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenSamplers_debug(GLsizei count, GLuint *samplers, const char* file, int line);
#ifndef glGetFragDataIndex
#define glGetFragDataIndex(program, name) glatter_glGetFragDataIndex_debug((program), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetFragDataIndex_debug(GLuint program, const GLchar *name, const char* file, int line);
#ifndef glGetQueryObjecti64v
#define glGetQueryObjecti64v(id, pname, params) glatter_glGetQueryObjecti64v_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjecti64v_debug(GLuint id, GLenum pname, GLint64 *params, const char* file, int line);
#ifndef glGetQueryObjectui64v
#define glGetQueryObjectui64v(id, pname, params) glatter_glGetQueryObjectui64v_debug((id), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectui64v_debug(GLuint id, GLenum pname, GLuint64 *params, const char* file, int line);
#ifndef glGetSamplerParameterIiv
#define glGetSamplerParameterIiv(sampler, pname, params) glatter_glGetSamplerParameterIiv_debug((sampler), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterIiv_debug(GLuint sampler, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetSamplerParameterIuiv
#define glGetSamplerParameterIuiv(sampler, pname, params) glatter_glGetSamplerParameterIuiv_debug((sampler), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterIuiv_debug(GLuint sampler, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glGetSamplerParameterfv
#define glGetSamplerParameterfv(sampler, pname, params) glatter_glGetSamplerParameterfv_debug((sampler), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameterfv_debug(GLuint sampler, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetSamplerParameteriv
#define glGetSamplerParameteriv(sampler, pname, params) glatter_glGetSamplerParameteriv_debug((sampler), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetSamplerParameteriv_debug(GLuint sampler, GLenum pname, GLint *params, const char* file, int line);
#ifndef glIsSampler
#define glIsSampler(sampler) glatter_glIsSampler_debug((sampler), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsSampler_debug(GLuint sampler, const char* file, int line);
#ifndef glMultiTexCoordP1ui
#define glMultiTexCoordP1ui(texture, type, coords) glatter_glMultiTexCoordP1ui_debug((texture), (type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordP1ui_debug(GLenum texture, GLenum type, GLuint coords, const char* file, int line);
#ifndef glMultiTexCoordP1uiv
#define glMultiTexCoordP1uiv(texture, type, coords) glatter_glMultiTexCoordP1uiv_debug((texture), (type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordP1uiv_debug(GLenum texture, GLenum type, const GLuint *coords, const char* file, int line);
#ifndef glMultiTexCoordP2ui
#define glMultiTexCoordP2ui(texture, type, coords) glatter_glMultiTexCoordP2ui_debug((texture), (type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordP2ui_debug(GLenum texture, GLenum type, GLuint coords, const char* file, int line);
#ifndef glMultiTexCoordP2uiv
#define glMultiTexCoordP2uiv(texture, type, coords) glatter_glMultiTexCoordP2uiv_debug((texture), (type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordP2uiv_debug(GLenum texture, GLenum type, const GLuint *coords, const char* file, int line);
#ifndef glMultiTexCoordP3ui
#define glMultiTexCoordP3ui(texture, type, coords) glatter_glMultiTexCoordP3ui_debug((texture), (type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordP3ui_debug(GLenum texture, GLenum type, GLuint coords, const char* file, int line);
#ifndef glMultiTexCoordP3uiv
#define glMultiTexCoordP3uiv(texture, type, coords) glatter_glMultiTexCoordP3uiv_debug((texture), (type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordP3uiv_debug(GLenum texture, GLenum type, const GLuint *coords, const char* file, int line);
#ifndef glMultiTexCoordP4ui
#define glMultiTexCoordP4ui(texture, type, coords) glatter_glMultiTexCoordP4ui_debug((texture), (type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordP4ui_debug(GLenum texture, GLenum type, GLuint coords, const char* file, int line);
#ifndef glMultiTexCoordP4uiv
#define glMultiTexCoordP4uiv(texture, type, coords) glatter_glMultiTexCoordP4uiv_debug((texture), (type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordP4uiv_debug(GLenum texture, GLenum type, const GLuint *coords, const char* file, int line);
#ifndef glNormalP3ui
#define glNormalP3ui(type, coords) glatter_glNormalP3ui_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalP3ui_debug(GLenum type, GLuint coords, const char* file, int line);
#ifndef glNormalP3uiv
#define glNormalP3uiv(type, coords) glatter_glNormalP3uiv_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNormalP3uiv_debug(GLenum type, const GLuint *coords, const char* file, int line);
#ifndef glQueryCounter
#define glQueryCounter(id, target) glatter_glQueryCounter_debug((id), (target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glQueryCounter_debug(GLuint id, GLenum target, const char* file, int line);
#ifndef glSamplerParameterIiv
#define glSamplerParameterIiv(sampler, pname, param) glatter_glSamplerParameterIiv_debug((sampler), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterIiv_debug(GLuint sampler, GLenum pname, const GLint *param, const char* file, int line);
#ifndef glSamplerParameterIuiv
#define glSamplerParameterIuiv(sampler, pname, param) glatter_glSamplerParameterIuiv_debug((sampler), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterIuiv_debug(GLuint sampler, GLenum pname, const GLuint *param, const char* file, int line);
#ifndef glSamplerParameterf
#define glSamplerParameterf(sampler, pname, param) glatter_glSamplerParameterf_debug((sampler), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterf_debug(GLuint sampler, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glSamplerParameterfv
#define glSamplerParameterfv(sampler, pname, param) glatter_glSamplerParameterfv_debug((sampler), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameterfv_debug(GLuint sampler, GLenum pname, const GLfloat *param, const char* file, int line);
#ifndef glSamplerParameteri
#define glSamplerParameteri(sampler, pname, param) glatter_glSamplerParameteri_debug((sampler), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameteri_debug(GLuint sampler, GLenum pname, GLint param, const char* file, int line);
#ifndef glSamplerParameteriv
#define glSamplerParameteriv(sampler, pname, param) glatter_glSamplerParameteriv_debug((sampler), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSamplerParameteriv_debug(GLuint sampler, GLenum pname, const GLint *param, const char* file, int line);
#ifndef glSecondaryColorP3ui
#define glSecondaryColorP3ui(type, color) glatter_glSecondaryColorP3ui_debug((type), (color), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColorP3ui_debug(GLenum type, GLuint color, const char* file, int line);
#ifndef glSecondaryColorP3uiv
#define glSecondaryColorP3uiv(type, color) glatter_glSecondaryColorP3uiv_debug((type), (color), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColorP3uiv_debug(GLenum type, const GLuint *color, const char* file, int line);
#ifndef glTexCoordP1ui
#define glTexCoordP1ui(type, coords) glatter_glTexCoordP1ui_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordP1ui_debug(GLenum type, GLuint coords, const char* file, int line);
#ifndef glTexCoordP1uiv
#define glTexCoordP1uiv(type, coords) glatter_glTexCoordP1uiv_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordP1uiv_debug(GLenum type, const GLuint *coords, const char* file, int line);
#ifndef glTexCoordP2ui
#define glTexCoordP2ui(type, coords) glatter_glTexCoordP2ui_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordP2ui_debug(GLenum type, GLuint coords, const char* file, int line);
#ifndef glTexCoordP2uiv
#define glTexCoordP2uiv(type, coords) glatter_glTexCoordP2uiv_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordP2uiv_debug(GLenum type, const GLuint *coords, const char* file, int line);
#ifndef glTexCoordP3ui
#define glTexCoordP3ui(type, coords) glatter_glTexCoordP3ui_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordP3ui_debug(GLenum type, GLuint coords, const char* file, int line);
#ifndef glTexCoordP3uiv
#define glTexCoordP3uiv(type, coords) glatter_glTexCoordP3uiv_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordP3uiv_debug(GLenum type, const GLuint *coords, const char* file, int line);
#ifndef glTexCoordP4ui
#define glTexCoordP4ui(type, coords) glatter_glTexCoordP4ui_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordP4ui_debug(GLenum type, GLuint coords, const char* file, int line);
#ifndef glTexCoordP4uiv
#define glTexCoordP4uiv(type, coords) glatter_glTexCoordP4uiv_debug((type), (coords), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexCoordP4uiv_debug(GLenum type, const GLuint *coords, const char* file, int line);
#ifndef glVertexAttribDivisor
#define glVertexAttribDivisor(index, divisor) glatter_glVertexAttribDivisor_debug((index), (divisor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribDivisor_debug(GLuint index, GLuint divisor, const char* file, int line);
#ifndef glVertexAttribP1ui
#define glVertexAttribP1ui(index, type, normalized, value) glatter_glVertexAttribP1ui_debug((index), (type), (normalized), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribP1ui_debug(GLuint index, GLenum type, GLboolean normalized, GLuint value, const char* file, int line);
#ifndef glVertexAttribP1uiv
#define glVertexAttribP1uiv(index, type, normalized, value) glatter_glVertexAttribP1uiv_debug((index), (type), (normalized), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribP1uiv_debug(GLuint index, GLenum type, GLboolean normalized, const GLuint *value, const char* file, int line);
#ifndef glVertexAttribP2ui
#define glVertexAttribP2ui(index, type, normalized, value) glatter_glVertexAttribP2ui_debug((index), (type), (normalized), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribP2ui_debug(GLuint index, GLenum type, GLboolean normalized, GLuint value, const char* file, int line);
#ifndef glVertexAttribP2uiv
#define glVertexAttribP2uiv(index, type, normalized, value) glatter_glVertexAttribP2uiv_debug((index), (type), (normalized), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribP2uiv_debug(GLuint index, GLenum type, GLboolean normalized, const GLuint *value, const char* file, int line);
#ifndef glVertexAttribP3ui
#define glVertexAttribP3ui(index, type, normalized, value) glatter_glVertexAttribP3ui_debug((index), (type), (normalized), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribP3ui_debug(GLuint index, GLenum type, GLboolean normalized, GLuint value, const char* file, int line);
#ifndef glVertexAttribP3uiv
#define glVertexAttribP3uiv(index, type, normalized, value) glatter_glVertexAttribP3uiv_debug((index), (type), (normalized), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribP3uiv_debug(GLuint index, GLenum type, GLboolean normalized, const GLuint *value, const char* file, int line);
#ifndef glVertexAttribP4ui
#define glVertexAttribP4ui(index, type, normalized, value) glatter_glVertexAttribP4ui_debug((index), (type), (normalized), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribP4ui_debug(GLuint index, GLenum type, GLboolean normalized, GLuint value, const char* file, int line);
#ifndef glVertexAttribP4uiv
#define glVertexAttribP4uiv(index, type, normalized, value) glatter_glVertexAttribP4uiv_debug((index), (type), (normalized), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribP4uiv_debug(GLuint index, GLenum type, GLboolean normalized, const GLuint *value, const char* file, int line);
#ifndef glVertexP2ui
#define glVertexP2ui(type, value) glatter_glVertexP2ui_debug((type), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexP2ui_debug(GLenum type, GLuint value, const char* file, int line);
#ifndef glVertexP2uiv
#define glVertexP2uiv(type, value) glatter_glVertexP2uiv_debug((type), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexP2uiv_debug(GLenum type, const GLuint *value, const char* file, int line);
#ifndef glVertexP3ui
#define glVertexP3ui(type, value) glatter_glVertexP3ui_debug((type), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexP3ui_debug(GLenum type, GLuint value, const char* file, int line);
#ifndef glVertexP3uiv
#define glVertexP3uiv(type, value) glatter_glVertexP3uiv_debug((type), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexP3uiv_debug(GLenum type, const GLuint *value, const char* file, int line);
#ifndef glVertexP4ui
#define glVertexP4ui(type, value) glatter_glVertexP4ui_debug((type), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexP4ui_debug(GLenum type, GLuint value, const char* file, int line);
#ifndef glVertexP4uiv
#define glVertexP4uiv(type, value) glatter_glVertexP4uiv_debug((type), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexP4uiv_debug(GLenum type, const GLuint *value, const char* file, int line);
#endif // defined(GL_VERSION_3_3)
#if defined(GL_VERSION_4_0)
#ifndef glBeginQueryIndexed
#define glBeginQueryIndexed(target, index, id) glatter_glBeginQueryIndexed_debug((target), (index), (id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBeginQueryIndexed_debug(GLenum target, GLuint index, GLuint id, const char* file, int line);
#ifndef glBindTransformFeedback
#define glBindTransformFeedback(target, id) glatter_glBindTransformFeedback_debug((target), (id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindTransformFeedback_debug(GLenum target, GLuint id, const char* file, int line);
#ifndef glBlendEquationSeparatei
#define glBlendEquationSeparatei(buf, modeRGB, modeAlpha) glatter_glBlendEquationSeparatei_debug((buf), (modeRGB), (modeAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparatei_debug(GLuint buf, GLenum modeRGB, GLenum modeAlpha, const char* file, int line);
#ifndef glBlendEquationi
#define glBlendEquationi(buf, mode) glatter_glBlendEquationi_debug((buf), (mode), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationi_debug(GLuint buf, GLenum mode, const char* file, int line);
#ifndef glBlendFuncSeparatei
#define glBlendFuncSeparatei(buf, srcRGB, dstRGB, srcAlpha, dstAlpha) glatter_glBlendFuncSeparatei_debug((buf), (srcRGB), (dstRGB), (srcAlpha), (dstAlpha), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparatei_debug(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha, const char* file, int line);
#ifndef glBlendFunci
#define glBlendFunci(buf, src, dst) glatter_glBlendFunci_debug((buf), (src), (dst), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlendFunci_debug(GLuint buf, GLenum src, GLenum dst, const char* file, int line);
#ifndef glDeleteTransformFeedbacks
#define glDeleteTransformFeedbacks(n, ids) glatter_glDeleteTransformFeedbacks_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteTransformFeedbacks_debug(GLsizei n, const GLuint *ids, const char* file, int line);
#ifndef glDrawArraysIndirect
#define glDrawArraysIndirect(mode, indirect) glatter_glDrawArraysIndirect_debug((mode), (indirect), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysIndirect_debug(GLenum mode, const void *indirect, const char* file, int line);
#ifndef glDrawElementsIndirect
#define glDrawElementsIndirect(mode, type, indirect) glatter_glDrawElementsIndirect_debug((mode), (type), (indirect), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsIndirect_debug(GLenum mode, GLenum type, const void *indirect, const char* file, int line);
#ifndef glDrawTransformFeedback
#define glDrawTransformFeedback(mode, id) glatter_glDrawTransformFeedback_debug((mode), (id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawTransformFeedback_debug(GLenum mode, GLuint id, const char* file, int line);
#ifndef glDrawTransformFeedbackStream
#define glDrawTransformFeedbackStream(mode, id, stream) glatter_glDrawTransformFeedbackStream_debug((mode), (id), (stream), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawTransformFeedbackStream_debug(GLenum mode, GLuint id, GLuint stream, const char* file, int line);
#ifndef glEndQueryIndexed
#define glEndQueryIndexed(target, index) glatter_glEndQueryIndexed_debug((target), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEndQueryIndexed_debug(GLenum target, GLuint index, const char* file, int line);
#ifndef glGenTransformFeedbacks
#define glGenTransformFeedbacks(n, ids) glatter_glGenTransformFeedbacks_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenTransformFeedbacks_debug(GLsizei n, GLuint *ids, const char* file, int line);
#ifndef glGetActiveSubroutineName
#define glGetActiveSubroutineName(program, shadertype, index, bufsize, length, name) glatter_glGetActiveSubroutineName_debug((program), (shadertype), (index), (bufsize), (length), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveSubroutineName_debug(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name, const char* file, int line);
#ifndef glGetActiveSubroutineUniformName
#define glGetActiveSubroutineUniformName(program, shadertype, index, bufsize, length, name) glatter_glGetActiveSubroutineUniformName_debug((program), (shadertype), (index), (bufsize), (length), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveSubroutineUniformName_debug(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei *length, GLchar *name, const char* file, int line);
#ifndef glGetActiveSubroutineUniformiv
#define glGetActiveSubroutineUniformiv(program, shadertype, index, pname, values) glatter_glGetActiveSubroutineUniformiv_debug((program), (shadertype), (index), (pname), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveSubroutineUniformiv_debug(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint *values, const char* file, int line);
#ifndef glGetProgramStageiv
#define glGetProgramStageiv(program, shadertype, pname, values) glatter_glGetProgramStageiv_debug((program), (shadertype), (pname), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramStageiv_debug(GLuint program, GLenum shadertype, GLenum pname, GLint *values, const char* file, int line);
#ifndef glGetQueryIndexediv
#define glGetQueryIndexediv(target, index, pname, params) glatter_glGetQueryIndexediv_debug((target), (index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryIndexediv_debug(GLenum target, GLuint index, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetSubroutineIndex
#define glGetSubroutineIndex(program, shadertype, name) glatter_glGetSubroutineIndex_debug((program), (shadertype), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGetSubroutineIndex_debug(GLuint program, GLenum shadertype, const GLchar *name, const char* file, int line);
#ifndef glGetSubroutineUniformLocation
#define glGetSubroutineUniformLocation(program, shadertype, name) glatter_glGetSubroutineUniformLocation_debug((program), (shadertype), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetSubroutineUniformLocation_debug(GLuint program, GLenum shadertype, const GLchar *name, const char* file, int line);
#ifndef glGetUniformSubroutineuiv
#define glGetUniformSubroutineuiv(shadertype, location, params) glatter_glGetUniformSubroutineuiv_debug((shadertype), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformSubroutineuiv_debug(GLenum shadertype, GLint location, GLuint *params, const char* file, int line);
#ifndef glGetUniformdv
#define glGetUniformdv(program, location, params) glatter_glGetUniformdv_debug((program), (location), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetUniformdv_debug(GLuint program, GLint location, GLdouble *params, const char* file, int line);
#ifndef glIsTransformFeedback
#define glIsTransformFeedback(id) glatter_glIsTransformFeedback_debug((id), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTransformFeedback_debug(GLuint id, const char* file, int line);
#ifndef glMinSampleShading
#define glMinSampleShading(value) glatter_glMinSampleShading_debug((value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMinSampleShading_debug(GLfloat value, const char* file, int line);
#ifndef glPatchParameterfv
#define glPatchParameterfv(pname, values) glatter_glPatchParameterfv_debug((pname), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPatchParameterfv_debug(GLenum pname, const GLfloat *values, const char* file, int line);
#ifndef glPatchParameteri
#define glPatchParameteri(pname, value) glatter_glPatchParameteri_debug((pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPatchParameteri_debug(GLenum pname, GLint value, const char* file, int line);
#ifndef glPauseTransformFeedback
#define glPauseTransformFeedback() glatter_glPauseTransformFeedback_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPauseTransformFeedback_debug(const char* file, int line);
#ifndef glResumeTransformFeedback
#define glResumeTransformFeedback() glatter_glResumeTransformFeedback_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glResumeTransformFeedback_debug(const char* file, int line);
#ifndef glUniform1d
#define glUniform1d(location, x) glatter_glUniform1d_debug((location), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1d_debug(GLint location, GLdouble x, const char* file, int line);
#ifndef glUniform1dv
#define glUniform1dv(location, count, value) glatter_glUniform1dv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform1dv_debug(GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glUniform2d
#define glUniform2d(location, x, y) glatter_glUniform2d_debug((location), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2d_debug(GLint location, GLdouble x, GLdouble y, const char* file, int line);
#ifndef glUniform2dv
#define glUniform2dv(location, count, value) glatter_glUniform2dv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform2dv_debug(GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glUniform3d
#define glUniform3d(location, x, y, z) glatter_glUniform3d_debug((location), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3d_debug(GLint location, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glUniform3dv
#define glUniform3dv(location, count, value) glatter_glUniform3dv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform3dv_debug(GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glUniform4d
#define glUniform4d(location, x, y, z, w) glatter_glUniform4d_debug((location), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4d_debug(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glUniform4dv
#define glUniform4dv(location, count, value) glatter_glUniform4dv_debug((location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniform4dv_debug(GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glUniformMatrix2dv
#define glUniformMatrix2dv(location, count, transpose, value) glatter_glUniformMatrix2dv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2dv_debug(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glUniformMatrix2x3dv
#define glUniformMatrix2x3dv(location, count, transpose, value) glatter_glUniformMatrix2x3dv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2x3dv_debug(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glUniformMatrix2x4dv
#define glUniformMatrix2x4dv(location, count, transpose, value) glatter_glUniformMatrix2x4dv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2x4dv_debug(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glUniformMatrix3dv
#define glUniformMatrix3dv(location, count, transpose, value) glatter_glUniformMatrix3dv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3dv_debug(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glUniformMatrix3x2dv
#define glUniformMatrix3x2dv(location, count, transpose, value) glatter_glUniformMatrix3x2dv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3x2dv_debug(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glUniformMatrix3x4dv
#define glUniformMatrix3x4dv(location, count, transpose, value) glatter_glUniformMatrix3x4dv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3x4dv_debug(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glUniformMatrix4dv
#define glUniformMatrix4dv(location, count, transpose, value) glatter_glUniformMatrix4dv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4dv_debug(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glUniformMatrix4x2dv
#define glUniformMatrix4x2dv(location, count, transpose, value) glatter_glUniformMatrix4x2dv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4x2dv_debug(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glUniformMatrix4x3dv
#define glUniformMatrix4x3dv(location, count, transpose, value) glatter_glUniformMatrix4x3dv_debug((location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4x3dv_debug(GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glUniformSubroutinesuiv
#define glUniformSubroutinesuiv(shadertype, count, indices) glatter_glUniformSubroutinesuiv_debug((shadertype), (count), (indices), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUniformSubroutinesuiv_debug(GLenum shadertype, GLsizei count, const GLuint *indices, const char* file, int line);
#endif // defined(GL_VERSION_4_0)
#if defined(GL_VERSION_4_1)
#ifndef glActiveShaderProgram
#define glActiveShaderProgram(pipeline, program) glatter_glActiveShaderProgram_debug((pipeline), (program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glActiveShaderProgram_debug(GLuint pipeline, GLuint program, const char* file, int line);
#ifndef glBindProgramPipeline
#define glBindProgramPipeline(pipeline) glatter_glBindProgramPipeline_debug((pipeline), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindProgramPipeline_debug(GLuint pipeline, const char* file, int line);
#ifndef glClearDepthf
#define glClearDepthf(d) glatter_glClearDepthf_debug((d), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearDepthf_debug(GLfloat d, const char* file, int line);
#ifndef glCreateShaderProgramv
#define glCreateShaderProgramv(type, count, strings) glatter_glCreateShaderProgramv_debug((type), (count), (strings), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glCreateShaderProgramv_debug(GLenum type, GLsizei count, const GLchar *const*strings, const char* file, int line);
#ifndef glDeleteProgramPipelines
#define glDeleteProgramPipelines(n, pipelines) glatter_glDeleteProgramPipelines_debug((n), (pipelines), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDeleteProgramPipelines_debug(GLsizei n, const GLuint *pipelines, const char* file, int line);
#ifndef glDepthRangeArrayv
#define glDepthRangeArrayv(first, count, v) glatter_glDepthRangeArrayv_debug((first), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthRangeArrayv_debug(GLuint first, GLsizei count, const GLdouble *v, const char* file, int line);
#ifndef glDepthRangeIndexed
#define glDepthRangeIndexed(index, n, f) glatter_glDepthRangeIndexed_debug((index), (n), (f), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthRangeIndexed_debug(GLuint index, GLdouble n, GLdouble f, const char* file, int line);
#ifndef glDepthRangef
#define glDepthRangef(n, f) glatter_glDepthRangef_debug((n), (f), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDepthRangef_debug(GLfloat n, GLfloat f, const char* file, int line);
#ifndef glGenProgramPipelines
#define glGenProgramPipelines(n, pipelines) glatter_glGenProgramPipelines_debug((n), (pipelines), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenProgramPipelines_debug(GLsizei n, GLuint *pipelines, const char* file, int line);
#ifndef glGetDoublei_v
#define glGetDoublei_v(target, index, data) glatter_glGetDoublei_v_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetDoublei_v_debug(GLenum target, GLuint index, GLdouble *data, const char* file, int line);
#ifndef glGetFloati_v
#define glGetFloati_v(target, index, data) glatter_glGetFloati_v_debug((target), (index), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFloati_v_debug(GLenum target, GLuint index, GLfloat *data, const char* file, int line);
#ifndef glGetProgramBinary
#define glGetProgramBinary(program, bufSize, length, binaryFormat, binary) glatter_glGetProgramBinary_debug((program), (bufSize), (length), (binaryFormat), (binary), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramBinary_debug(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary, const char* file, int line);
#ifndef glGetProgramPipelineInfoLog
#define glGetProgramPipelineInfoLog(pipeline, bufSize, length, infoLog) glatter_glGetProgramPipelineInfoLog_debug((pipeline), (bufSize), (length), (infoLog), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramPipelineInfoLog_debug(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog, const char* file, int line);
#ifndef glGetProgramPipelineiv
#define glGetProgramPipelineiv(pipeline, pname, params) glatter_glGetProgramPipelineiv_debug((pipeline), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramPipelineiv_debug(GLuint pipeline, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetShaderPrecisionFormat
#define glGetShaderPrecisionFormat(shadertype, precisiontype, range, precision) glatter_glGetShaderPrecisionFormat_debug((shadertype), (precisiontype), (range), (precision), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetShaderPrecisionFormat_debug(GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision, const char* file, int line);
#ifndef glGetVertexAttribLdv
#define glGetVertexAttribLdv(index, pname, params) glatter_glGetVertexAttribLdv_debug((index), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribLdv_debug(GLuint index, GLenum pname, GLdouble *params, const char* file, int line);
#ifndef glIsProgramPipeline
#define glIsProgramPipeline(pipeline) glatter_glIsProgramPipeline_debug((pipeline), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsProgramPipeline_debug(GLuint pipeline, const char* file, int line);
#ifndef glProgramBinary
#define glProgramBinary(program, binaryFormat, binary, length) glatter_glProgramBinary_debug((program), (binaryFormat), (binary), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramBinary_debug(GLuint program, GLenum binaryFormat, const void *binary, GLsizei length, const char* file, int line);
#ifndef glProgramParameteri
#define glProgramParameteri(program, pname, value) glatter_glProgramParameteri_debug((program), (pname), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramParameteri_debug(GLuint program, GLenum pname, GLint value, const char* file, int line);
#ifndef glProgramUniform1d
#define glProgramUniform1d(program, location, v0) glatter_glProgramUniform1d_debug((program), (location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1d_debug(GLuint program, GLint location, GLdouble v0, const char* file, int line);
#ifndef glProgramUniform1dv
#define glProgramUniform1dv(program, location, count, value) glatter_glProgramUniform1dv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1dv_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniform1f
#define glProgramUniform1f(program, location, v0) glatter_glProgramUniform1f_debug((program), (location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1f_debug(GLuint program, GLint location, GLfloat v0, const char* file, int line);
#ifndef glProgramUniform1fv
#define glProgramUniform1fv(program, location, count, value) glatter_glProgramUniform1fv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1fv_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniform1i
#define glProgramUniform1i(program, location, v0) glatter_glProgramUniform1i_debug((program), (location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i_debug(GLuint program, GLint location, GLint v0, const char* file, int line);
#ifndef glProgramUniform1iv
#define glProgramUniform1iv(program, location, count, value) glatter_glProgramUniform1iv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1iv_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glProgramUniform1ui
#define glProgramUniform1ui(program, location, v0) glatter_glProgramUniform1ui_debug((program), (location), (v0), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui_debug(GLuint program, GLint location, GLuint v0, const char* file, int line);
#ifndef glProgramUniform1uiv
#define glProgramUniform1uiv(program, location, count, value) glatter_glProgramUniform1uiv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1uiv_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glProgramUniform2d
#define glProgramUniform2d(program, location, v0, v1) glatter_glProgramUniform2d_debug((program), (location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2d_debug(GLuint program, GLint location, GLdouble v0, GLdouble v1, const char* file, int line);
#ifndef glProgramUniform2dv
#define glProgramUniform2dv(program, location, count, value) glatter_glProgramUniform2dv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2dv_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniform2f
#define glProgramUniform2f(program, location, v0, v1) glatter_glProgramUniform2f_debug((program), (location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2f_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, const char* file, int line);
#ifndef glProgramUniform2fv
#define glProgramUniform2fv(program, location, count, value) glatter_glProgramUniform2fv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2fv_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniform2i
#define glProgramUniform2i(program, location, v0, v1) glatter_glProgramUniform2i_debug((program), (location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i_debug(GLuint program, GLint location, GLint v0, GLint v1, const char* file, int line);
#ifndef glProgramUniform2iv
#define glProgramUniform2iv(program, location, count, value) glatter_glProgramUniform2iv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2iv_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glProgramUniform2ui
#define glProgramUniform2ui(program, location, v0, v1) glatter_glProgramUniform2ui_debug((program), (location), (v0), (v1), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui_debug(GLuint program, GLint location, GLuint v0, GLuint v1, const char* file, int line);
#ifndef glProgramUniform2uiv
#define glProgramUniform2uiv(program, location, count, value) glatter_glProgramUniform2uiv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2uiv_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glProgramUniform3d
#define glProgramUniform3d(program, location, v0, v1, v2) glatter_glProgramUniform3d_debug((program), (location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3d_debug(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, const char* file, int line);
#ifndef glProgramUniform3dv
#define glProgramUniform3dv(program, location, count, value) glatter_glProgramUniform3dv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3dv_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniform3f
#define glProgramUniform3f(program, location, v0, v1, v2) glatter_glProgramUniform3f_debug((program), (location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3f_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, const char* file, int line);
#ifndef glProgramUniform3fv
#define glProgramUniform3fv(program, location, count, value) glatter_glProgramUniform3fv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3fv_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniform3i
#define glProgramUniform3i(program, location, v0, v1, v2) glatter_glProgramUniform3i_debug((program), (location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, const char* file, int line);
#ifndef glProgramUniform3iv
#define glProgramUniform3iv(program, location, count, value) glatter_glProgramUniform3iv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3iv_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glProgramUniform3ui
#define glProgramUniform3ui(program, location, v0, v1, v2) glatter_glProgramUniform3ui_debug((program), (location), (v0), (v1), (v2), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, const char* file, int line);
#ifndef glProgramUniform3uiv
#define glProgramUniform3uiv(program, location, count, value) glatter_glProgramUniform3uiv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3uiv_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glProgramUniform4d
#define glProgramUniform4d(program, location, v0, v1, v2, v3) glatter_glProgramUniform4d_debug((program), (location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4d_debug(GLuint program, GLint location, GLdouble v0, GLdouble v1, GLdouble v2, GLdouble v3, const char* file, int line);
#ifndef glProgramUniform4dv
#define glProgramUniform4dv(program, location, count, value) glatter_glProgramUniform4dv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4dv_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniform4f
#define glProgramUniform4f(program, location, v0, v1, v2, v3) glatter_glProgramUniform4f_debug((program), (location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4f_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3, const char* file, int line);
#ifndef glProgramUniform4fv
#define glProgramUniform4fv(program, location, count, value) glatter_glProgramUniform4fv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4fv_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniform4i
#define glProgramUniform4i(program, location, v0, v1, v2, v3) glatter_glProgramUniform4i_debug((program), (location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3, const char* file, int line);
#ifndef glProgramUniform4iv
#define glProgramUniform4iv(program, location, count, value) glatter_glProgramUniform4iv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4iv_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line);
#ifndef glProgramUniform4ui
#define glProgramUniform4ui(program, location, v0, v1, v2, v3) glatter_glProgramUniform4ui_debug((program), (location), (v0), (v1), (v2), (v3), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3, const char* file, int line);
#ifndef glProgramUniform4uiv
#define glProgramUniform4uiv(program, location, count, value) glatter_glProgramUniform4uiv_debug((program), (location), (count), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4uiv_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line);
#ifndef glProgramUniformMatrix2dv
#define glProgramUniformMatrix2dv(program, location, count, transpose, value) glatter_glProgramUniformMatrix2dv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2dv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix2fv
#define glProgramUniformMatrix2fv(program, location, count, transpose, value) glatter_glProgramUniformMatrix2fv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix2x3dv
#define glProgramUniformMatrix2x3dv(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x3dv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x3dv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix2x3fv
#define glProgramUniformMatrix2x3fv(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x3fv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x3fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix2x4dv
#define glProgramUniformMatrix2x4dv(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x4dv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x4dv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix2x4fv
#define glProgramUniformMatrix2x4fv(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x4fv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x4fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix3dv
#define glProgramUniformMatrix3dv(program, location, count, transpose, value) glatter_glProgramUniformMatrix3dv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3dv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix3fv
#define glProgramUniformMatrix3fv(program, location, count, transpose, value) glatter_glProgramUniformMatrix3fv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix3x2dv
#define glProgramUniformMatrix3x2dv(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x2dv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x2dv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix3x2fv
#define glProgramUniformMatrix3x2fv(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x2fv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x2fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix3x4dv
#define glProgramUniformMatrix3x4dv(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x4dv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x4dv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix3x4fv
#define glProgramUniformMatrix3x4fv(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x4fv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x4fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix4dv
#define glProgramUniformMatrix4dv(program, location, count, transpose, value) glatter_glProgramUniformMatrix4dv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4dv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix4fv
#define glProgramUniformMatrix4fv(program, location, count, transpose, value) glatter_glProgramUniformMatrix4fv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix4x2dv
#define glProgramUniformMatrix4x2dv(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x2dv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x2dv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix4x2fv
#define glProgramUniformMatrix4x2fv(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x2fv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x2fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glProgramUniformMatrix4x3dv
#define glProgramUniformMatrix4x3dv(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x3dv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x3dv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line);
#ifndef glProgramUniformMatrix4x3fv
#define glProgramUniformMatrix4x3fv(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x3fv_debug((program), (location), (count), (transpose), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x3fv_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line);
#ifndef glReleaseShaderCompiler
#define glReleaseShaderCompiler() glatter_glReleaseShaderCompiler_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReleaseShaderCompiler_debug(const char* file, int line);
#ifndef glScissorArrayv
#define glScissorArrayv(first, count, v) glatter_glScissorArrayv_debug((first), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glScissorArrayv_debug(GLuint first, GLsizei count, const GLint *v, const char* file, int line);
#ifndef glScissorIndexed
#define glScissorIndexed(index, left, bottom, width, height) glatter_glScissorIndexed_debug((index), (left), (bottom), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glScissorIndexed_debug(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glScissorIndexedv
#define glScissorIndexedv(index, v) glatter_glScissorIndexedv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glScissorIndexedv_debug(GLuint index, const GLint *v, const char* file, int line);
#ifndef glShaderBinary
#define glShaderBinary(count, shaders, binaryformat, binary, length) glatter_glShaderBinary_debug((count), (shaders), (binaryformat), (binary), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glShaderBinary_debug(GLsizei count, const GLuint *shaders, GLenum binaryformat, const void *binary, GLsizei length, const char* file, int line);
#ifndef glUseProgramStages
#define glUseProgramStages(pipeline, stages, program) glatter_glUseProgramStages_debug((pipeline), (stages), (program), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glUseProgramStages_debug(GLuint pipeline, GLbitfield stages, GLuint program, const char* file, int line);
#ifndef glValidateProgramPipeline
#define glValidateProgramPipeline(pipeline) glatter_glValidateProgramPipeline_debug((pipeline), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glValidateProgramPipeline_debug(GLuint pipeline, const char* file, int line);
#ifndef glVertexAttribL1d
#define glVertexAttribL1d(index, x) glatter_glVertexAttribL1d_debug((index), (x), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1d_debug(GLuint index, GLdouble x, const char* file, int line);
#ifndef glVertexAttribL1dv
#define glVertexAttribL1dv(index, v) glatter_glVertexAttribL1dv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1dv_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribL2d
#define glVertexAttribL2d(index, x, y) glatter_glVertexAttribL2d_debug((index), (x), (y), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2d_debug(GLuint index, GLdouble x, GLdouble y, const char* file, int line);
#ifndef glVertexAttribL2dv
#define glVertexAttribL2dv(index, v) glatter_glVertexAttribL2dv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2dv_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribL3d
#define glVertexAttribL3d(index, x, y, z) glatter_glVertexAttribL3d_debug((index), (x), (y), (z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3d_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, const char* file, int line);
#ifndef glVertexAttribL3dv
#define glVertexAttribL3dv(index, v) glatter_glVertexAttribL3dv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3dv_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribL4d
#define glVertexAttribL4d(index, x, y, z, w) glatter_glVertexAttribL4d_debug((index), (x), (y), (z), (w), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4d_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line);
#ifndef glVertexAttribL4dv
#define glVertexAttribL4dv(index, v) glatter_glVertexAttribL4dv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4dv_debug(GLuint index, const GLdouble *v, const char* file, int line);
#ifndef glVertexAttribLPointer
#define glVertexAttribLPointer(index, size, type, stride, pointer) glatter_glVertexAttribLPointer_debug((index), (size), (type), (stride), (pointer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribLPointer_debug(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line);
#ifndef glViewportArrayv
#define glViewportArrayv(first, count, v) glatter_glViewportArrayv_debug((first), (count), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glViewportArrayv_debug(GLuint first, GLsizei count, const GLfloat *v, const char* file, int line);
#ifndef glViewportIndexedf
#define glViewportIndexedf(index, x, y, w, h) glatter_glViewportIndexedf_debug((index), (x), (y), (w), (h), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glViewportIndexedf_debug(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h, const char* file, int line);
#ifndef glViewportIndexedfv
#define glViewportIndexedfv(index, v) glatter_glViewportIndexedfv_debug((index), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glViewportIndexedfv_debug(GLuint index, const GLfloat *v, const char* file, int line);
#endif // defined(GL_VERSION_4_1)
#if defined(GL_VERSION_4_2)
#ifndef glBindImageTexture
#define glBindImageTexture(unit, texture, level, layered, layer, access, format) glatter_glBindImageTexture_debug((unit), (texture), (level), (layered), (layer), (access), (format), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindImageTexture_debug(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format, const char* file, int line);
#ifndef glDrawArraysInstancedBaseInstance
#define glDrawArraysInstancedBaseInstance(mode, first, count, instancecount, baseinstance) glatter_glDrawArraysInstancedBaseInstance_debug((mode), (first), (count), (instancecount), (baseinstance), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstancedBaseInstance_debug(GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance, const char* file, int line);
#ifndef glDrawElementsInstancedBaseInstance
#define glDrawElementsInstancedBaseInstance(mode, count, type, indices, instancecount, baseinstance) glatter_glDrawElementsInstancedBaseInstance_debug((mode), (count), (type), (indices), (instancecount), (baseinstance), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedBaseInstance_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance, const char* file, int line);
#ifndef glDrawElementsInstancedBaseVertexBaseInstance
#define glDrawElementsInstancedBaseVertexBaseInstance(mode, count, type, indices, instancecount, basevertex, baseinstance) glatter_glDrawElementsInstancedBaseVertexBaseInstance_debug((mode), (count), (type), (indices), (instancecount), (basevertex), (baseinstance), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedBaseVertexBaseInstance_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance, const char* file, int line);
#ifndef glDrawTransformFeedbackInstanced
#define glDrawTransformFeedbackInstanced(mode, id, instancecount) glatter_glDrawTransformFeedbackInstanced_debug((mode), (id), (instancecount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawTransformFeedbackInstanced_debug(GLenum mode, GLuint id, GLsizei instancecount, const char* file, int line);
#ifndef glDrawTransformFeedbackStreamInstanced
#define glDrawTransformFeedbackStreamInstanced(mode, id, stream, instancecount) glatter_glDrawTransformFeedbackStreamInstanced_debug((mode), (id), (stream), (instancecount), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDrawTransformFeedbackStreamInstanced_debug(GLenum mode, GLuint id, GLuint stream, GLsizei instancecount, const char* file, int line);
#ifndef glGetActiveAtomicCounterBufferiv
#define glGetActiveAtomicCounterBufferiv(program, bufferIndex, pname, params) glatter_glGetActiveAtomicCounterBufferiv_debug((program), (bufferIndex), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetActiveAtomicCounterBufferiv_debug(GLuint program, GLuint bufferIndex, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetInternalformativ
#define glGetInternalformativ(target, internalformat, pname, bufSize, params) glatter_glGetInternalformativ_debug((target), (internalformat), (pname), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetInternalformativ_debug(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint *params, const char* file, int line);
#ifndef glMemoryBarrier
#define glMemoryBarrier(barriers) glatter_glMemoryBarrier_debug((barriers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMemoryBarrier_debug(GLbitfield barriers, const char* file, int line);
#ifndef glTexStorage1D
#define glTexStorage1D(target, levels, internalformat, width) glatter_glTexStorage1D_debug((target), (levels), (internalformat), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorage1D_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, const char* file, int line);
#ifndef glTexStorage2D
#define glTexStorage2D(target, levels, internalformat, width, height) glatter_glTexStorage2D_debug((target), (levels), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorage2D_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glTexStorage3D
#define glTexStorage3D(target, levels, internalformat, width, height, depth) glatter_glTexStorage3D_debug((target), (levels), (internalformat), (width), (height), (depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorage3D_debug(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line);
#endif // defined(GL_VERSION_4_2)
#if defined(GL_VERSION_4_3)
#ifndef glBindVertexBuffer
#define glBindVertexBuffer(bindingindex, buffer, offset, stride) glatter_glBindVertexBuffer_debug((bindingindex), (buffer), (offset), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindVertexBuffer_debug(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride, const char* file, int line);
#ifndef glClearBufferData
#define glClearBufferData(target, internalformat, format, type, data) glatter_glClearBufferData_debug((target), (internalformat), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearBufferData_debug(GLenum target, GLenum internalformat, GLenum format, GLenum type, const void *data, const char* file, int line);
#ifndef glClearBufferSubData
#define glClearBufferSubData(target, internalformat, offset, size, format, type, data) glatter_glClearBufferSubData_debug((target), (internalformat), (offset), (size), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearBufferSubData_debug(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data, const char* file, int line);
#ifndef glCopyImageSubData
#define glCopyImageSubData(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth) glatter_glCopyImageSubData_debug((srcName), (srcTarget), (srcLevel), (srcX), (srcY), (srcZ), (dstName), (dstTarget), (dstLevel), (dstX), (dstY), (dstZ), (srcWidth), (srcHeight), (srcDepth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyImageSubData_debug(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth, const char* file, int line);
#ifndef glDebugMessageCallback
#define glDebugMessageCallback(callback, userParam) glatter_glDebugMessageCallback_debug((callback), (userParam), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageCallback_debug(GLDEBUGPROC callback, const void *userParam, const char* file, int line);
#ifndef glDebugMessageControl
#define glDebugMessageControl(source, type, severity, count, ids, enabled) glatter_glDebugMessageControl_debug((source), (type), (severity), (count), (ids), (enabled), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageControl_debug(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled, const char* file, int line);
#ifndef glDebugMessageInsert
#define glDebugMessageInsert(source, type, id, severity, length, buf) glatter_glDebugMessageInsert_debug((source), (type), (id), (severity), (length), (buf), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageInsert_debug(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf, const char* file, int line);
#ifndef glDispatchCompute
#define glDispatchCompute(num_groups_x, num_groups_y, num_groups_z) glatter_glDispatchCompute_debug((num_groups_x), (num_groups_y), (num_groups_z), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDispatchCompute_debug(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, const char* file, int line);
#ifndef glDispatchComputeIndirect
#define glDispatchComputeIndirect(indirect) glatter_glDispatchComputeIndirect_debug((indirect), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDispatchComputeIndirect_debug(GLintptr indirect, const char* file, int line);
#ifndef glFramebufferParameteri
#define glFramebufferParameteri(target, pname, param) glatter_glFramebufferParameteri_debug((target), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFramebufferParameteri_debug(GLenum target, GLenum pname, GLint param, const char* file, int line);
#ifndef glGetDebugMessageLog
#define glGetDebugMessageLog(count, bufSize, sources, types, ids, severities, lengths, messageLog) glatter_glGetDebugMessageLog_debug((count), (bufSize), (sources), (types), (ids), (severities), (lengths), (messageLog), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGetDebugMessageLog_debug(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog, const char* file, int line);
#ifndef glGetFramebufferParameteriv
#define glGetFramebufferParameteriv(target, pname, params) glatter_glGetFramebufferParameteriv_debug((target), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetInternalformati64v
#define glGetInternalformati64v(target, internalformat, pname, bufSize, params) glatter_glGetInternalformati64v_debug((target), (internalformat), (pname), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetInternalformati64v_debug(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 *params, const char* file, int line);
#ifndef glGetObjectLabel
#define glGetObjectLabel(identifier, name, bufSize, length, label) glatter_glGetObjectLabel_debug((identifier), (name), (bufSize), (length), (label), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetObjectLabel_debug(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label, const char* file, int line);
#ifndef glGetObjectPtrLabel
#define glGetObjectPtrLabel(ptr, bufSize, length, label) glatter_glGetObjectPtrLabel_debug((ptr), (bufSize), (length), (label), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetObjectPtrLabel_debug(const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label, const char* file, int line);
#ifndef glGetProgramInterfaceiv
#define glGetProgramInterfaceiv(program, programInterface, pname, params) glatter_glGetProgramInterfaceiv_debug((program), (programInterface), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramInterfaceiv_debug(GLuint program, GLenum programInterface, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetProgramResourceIndex
#define glGetProgramResourceIndex(program, programInterface, name) glatter_glGetProgramResourceIndex_debug((program), (programInterface), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLuint glatter_glGetProgramResourceIndex_debug(GLuint program, GLenum programInterface, const GLchar *name, const char* file, int line);
#ifndef glGetProgramResourceLocation
#define glGetProgramResourceLocation(program, programInterface, name) glatter_glGetProgramResourceLocation_debug((program), (programInterface), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetProgramResourceLocation_debug(GLuint program, GLenum programInterface, const GLchar *name, const char* file, int line);
#ifndef glGetProgramResourceLocationIndex
#define glGetProgramResourceLocationIndex(program, programInterface, name) glatter_glGetProgramResourceLocationIndex_debug((program), (programInterface), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLint glatter_glGetProgramResourceLocationIndex_debug(GLuint program, GLenum programInterface, const GLchar *name, const char* file, int line);
#ifndef glGetProgramResourceName
#define glGetProgramResourceName(program, programInterface, index, bufSize, length, name) glatter_glGetProgramResourceName_debug((program), (programInterface), (index), (bufSize), (length), (name), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramResourceName_debug(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei *length, GLchar *name, const char* file, int line);
#ifndef glGetProgramResourceiv
#define glGetProgramResourceiv(program, programInterface, index, propCount, props, bufSize, length, params) glatter_glGetProgramResourceiv_debug((program), (programInterface), (index), (propCount), (props), (bufSize), (length), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetProgramResourceiv_debug(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLint *params, const char* file, int line);
#ifndef glInvalidateBufferData
#define glInvalidateBufferData(buffer) glatter_glInvalidateBufferData_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInvalidateBufferData_debug(GLuint buffer, const char* file, int line);
#ifndef glInvalidateBufferSubData
#define glInvalidateBufferSubData(buffer, offset, length) glatter_glInvalidateBufferSubData_debug((buffer), (offset), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInvalidateBufferSubData_debug(GLuint buffer, GLintptr offset, GLsizeiptr length, const char* file, int line);
#ifndef glInvalidateFramebuffer
#define glInvalidateFramebuffer(target, numAttachments, attachments) glatter_glInvalidateFramebuffer_debug((target), (numAttachments), (attachments), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInvalidateFramebuffer_debug(GLenum target, GLsizei numAttachments, const GLenum *attachments, const char* file, int line);
#ifndef glInvalidateSubFramebuffer
#define glInvalidateSubFramebuffer(target, numAttachments, attachments, x, y, width, height) glatter_glInvalidateSubFramebuffer_debug((target), (numAttachments), (attachments), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInvalidateSubFramebuffer_debug(GLenum target, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glInvalidateTexImage
#define glInvalidateTexImage(texture, level) glatter_glInvalidateTexImage_debug((texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInvalidateTexImage_debug(GLuint texture, GLint level, const char* file, int line);
#ifndef glInvalidateTexSubImage
#define glInvalidateTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth) glatter_glInvalidateTexSubImage_debug((texture), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInvalidateTexSubImage_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line);
#ifndef glMultiDrawArraysIndirect
#define glMultiDrawArraysIndirect(mode, indirect, drawcount, stride) glatter_glMultiDrawArraysIndirect_debug((mode), (indirect), (drawcount), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirect_debug(GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride, const char* file, int line);
#ifndef glMultiDrawElementsIndirect
#define glMultiDrawElementsIndirect(mode, type, indirect, drawcount, stride) glatter_glMultiDrawElementsIndirect_debug((mode), (type), (indirect), (drawcount), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirect_debug(GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride, const char* file, int line);
#ifndef glObjectLabel
#define glObjectLabel(identifier, name, length, label) glatter_glObjectLabel_debug((identifier), (name), (length), (label), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glObjectLabel_debug(GLenum identifier, GLuint name, GLsizei length, const GLchar *label, const char* file, int line);
#ifndef glObjectPtrLabel
#define glObjectPtrLabel(ptr, length, label) glatter_glObjectPtrLabel_debug((ptr), (length), (label), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glObjectPtrLabel_debug(const void *ptr, GLsizei length, const GLchar *label, const char* file, int line);
#ifndef glPopDebugGroup
#define glPopDebugGroup() glatter_glPopDebugGroup_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPopDebugGroup_debug(const char* file, int line);
#ifndef glPushDebugGroup
#define glPushDebugGroup(source, id, length, message) glatter_glPushDebugGroup_debug((source), (id), (length), (message), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPushDebugGroup_debug(GLenum source, GLuint id, GLsizei length, const GLchar *message, const char* file, int line);
#ifndef glShaderStorageBlockBinding
#define glShaderStorageBlockBinding(program, storageBlockIndex, storageBlockBinding) glatter_glShaderStorageBlockBinding_debug((program), (storageBlockIndex), (storageBlockBinding), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glShaderStorageBlockBinding_debug(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding, const char* file, int line);
#ifndef glTexBufferRange
#define glTexBufferRange(target, internalformat, buffer, offset, size) glatter_glTexBufferRange_debug((target), (internalformat), (buffer), (offset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexBufferRange_debug(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line);
#ifndef glTexStorage2DMultisample
#define glTexStorage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations) glatter_glTexStorage2DMultisample_debug((target), (samples), (internalformat), (width), (height), (fixedsamplelocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorage2DMultisample_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations, const char* file, int line);
#ifndef glTexStorage3DMultisample
#define glTexStorage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations) glatter_glTexStorage3DMultisample_debug((target), (samples), (internalformat), (width), (height), (depth), (fixedsamplelocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTexStorage3DMultisample_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations, const char* file, int line);
#ifndef glTextureView
#define glTextureView(texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers) glatter_glTextureView_debug((texture), (target), (origtexture), (internalformat), (minlevel), (numlevels), (minlayer), (numlayers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureView_debug(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers, const char* file, int line);
#ifndef glVertexAttribBinding
#define glVertexAttribBinding(attribindex, bindingindex) glatter_glVertexAttribBinding_debug((attribindex), (bindingindex), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribBinding_debug(GLuint attribindex, GLuint bindingindex, const char* file, int line);
#ifndef glVertexAttribFormat
#define glVertexAttribFormat(attribindex, size, type, normalized, relativeoffset) glatter_glVertexAttribFormat_debug((attribindex), (size), (type), (normalized), (relativeoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribFormat_debug(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset, const char* file, int line);
#ifndef glVertexAttribIFormat
#define glVertexAttribIFormat(attribindex, size, type, relativeoffset) glatter_glVertexAttribIFormat_debug((attribindex), (size), (type), (relativeoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribIFormat_debug(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset, const char* file, int line);
#ifndef glVertexAttribLFormat
#define glVertexAttribLFormat(attribindex, size, type, relativeoffset) glatter_glVertexAttribLFormat_debug((attribindex), (size), (type), (relativeoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribLFormat_debug(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset, const char* file, int line);
#ifndef glVertexBindingDivisor
#define glVertexBindingDivisor(bindingindex, divisor) glatter_glVertexBindingDivisor_debug((bindingindex), (divisor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexBindingDivisor_debug(GLuint bindingindex, GLuint divisor, const char* file, int line);
#endif // defined(GL_VERSION_4_3)
#if defined(GL_VERSION_4_4)
#ifndef glBindBuffersBase
#define glBindBuffersBase(target, first, count, buffers) glatter_glBindBuffersBase_debug((target), (first), (count), (buffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBuffersBase_debug(GLenum target, GLuint first, GLsizei count, const GLuint *buffers, const char* file, int line);
#ifndef glBindBuffersRange
#define glBindBuffersRange(target, first, count, buffers, offsets, sizes) glatter_glBindBuffersRange_debug((target), (first), (count), (buffers), (offsets), (sizes), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindBuffersRange_debug(GLenum target, GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizeiptr *sizes, const char* file, int line);
#ifndef glBindImageTextures
#define glBindImageTextures(first, count, textures) glatter_glBindImageTextures_debug((first), (count), (textures), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindImageTextures_debug(GLuint first, GLsizei count, const GLuint *textures, const char* file, int line);
#ifndef glBindSamplers
#define glBindSamplers(first, count, samplers) glatter_glBindSamplers_debug((first), (count), (samplers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindSamplers_debug(GLuint first, GLsizei count, const GLuint *samplers, const char* file, int line);
#ifndef glBindTextures
#define glBindTextures(first, count, textures) glatter_glBindTextures_debug((first), (count), (textures), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindTextures_debug(GLuint first, GLsizei count, const GLuint *textures, const char* file, int line);
#ifndef glBindVertexBuffers
#define glBindVertexBuffers(first, count, buffers, offsets, strides) glatter_glBindVertexBuffers_debug((first), (count), (buffers), (offsets), (strides), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindVertexBuffers_debug(GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides, const char* file, int line);
#ifndef glBufferStorage
#define glBufferStorage(target, size, data, flags) glatter_glBufferStorage_debug((target), (size), (data), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBufferStorage_debug(GLenum target, GLsizeiptr size, const void *data, GLbitfield flags, const char* file, int line);
#ifndef glClearTexImage
#define glClearTexImage(texture, level, format, type, data) glatter_glClearTexImage_debug((texture), (level), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearTexImage_debug(GLuint texture, GLint level, GLenum format, GLenum type, const void *data, const char* file, int line);
#ifndef glClearTexSubImage
#define glClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data) glatter_glClearTexSubImage_debug((texture), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearTexSubImage_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data, const char* file, int line);
#endif // defined(GL_VERSION_4_4)
#if defined(GL_VERSION_4_5)
#ifndef glBindTextureUnit
#define glBindTextureUnit(unit, texture) glatter_glBindTextureUnit_debug((unit), (texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBindTextureUnit_debug(GLuint unit, GLuint texture, const char* file, int line);
#ifndef glBlitNamedFramebuffer
#define glBlitNamedFramebuffer(readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter) glatter_glBlitNamedFramebuffer_debug((readFramebuffer), (drawFramebuffer), (srcX0), (srcY0), (srcX1), (srcY1), (dstX0), (dstY0), (dstX1), (dstY1), (mask), (filter), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glBlitNamedFramebuffer_debug(GLuint readFramebuffer, GLuint drawFramebuffer, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter, const char* file, int line);
#ifndef glCheckNamedFramebufferStatus
#define glCheckNamedFramebufferStatus(framebuffer, target) glatter_glCheckNamedFramebufferStatus_debug((framebuffer), (target), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glCheckNamedFramebufferStatus_debug(GLuint framebuffer, GLenum target, const char* file, int line);
#ifndef glClearNamedBufferData
#define glClearNamedBufferData(buffer, internalformat, format, type, data) glatter_glClearNamedBufferData_debug((buffer), (internalformat), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearNamedBufferData_debug(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data, const char* file, int line);
#ifndef glClearNamedBufferSubData
#define glClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, data) glatter_glClearNamedBufferSubData_debug((buffer), (internalformat), (offset), (size), (format), (type), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearNamedBufferSubData_debug(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data, const char* file, int line);
#ifndef glClearNamedFramebufferfi
#define glClearNamedFramebufferfi(framebuffer, buffer, drawbuffer, depth, stencil) glatter_glClearNamedFramebufferfi_debug((framebuffer), (buffer), (drawbuffer), (depth), (stencil), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearNamedFramebufferfi_debug(GLuint framebuffer, GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil, const char* file, int line);
#ifndef glClearNamedFramebufferfv
#define glClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, value) glatter_glClearNamedFramebufferfv_debug((framebuffer), (buffer), (drawbuffer), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearNamedFramebufferfv_debug(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLfloat *value, const char* file, int line);
#ifndef glClearNamedFramebufferiv
#define glClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, value) glatter_glClearNamedFramebufferiv_debug((framebuffer), (buffer), (drawbuffer), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearNamedFramebufferiv_debug(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLint *value, const char* file, int line);
#ifndef glClearNamedFramebufferuiv
#define glClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, value) glatter_glClearNamedFramebufferuiv_debug((framebuffer), (buffer), (drawbuffer), (value), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClearNamedFramebufferuiv_debug(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLuint *value, const char* file, int line);
#ifndef glClipControl
#define glClipControl(origin, depth) glatter_glClipControl_debug((origin), (depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glClipControl_debug(GLenum origin, GLenum depth, const char* file, int line);
#ifndef glCompressedTextureSubImage1D
#define glCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, data) glatter_glCompressedTextureSubImage1D_debug((texture), (level), (xoffset), (width), (format), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureSubImage1D_debug(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTextureSubImage2D
#define glCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, data) glatter_glCompressedTextureSubImage2D_debug((texture), (level), (xoffset), (yoffset), (width), (height), (format), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureSubImage2D_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCompressedTextureSubImage3D
#define glCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data) glatter_glCompressedTextureSubImage3D_debug((texture), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (imageSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureSubImage3D_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data, const char* file, int line);
#ifndef glCopyNamedBufferSubData
#define glCopyNamedBufferSubData(readBuffer, writeBuffer, readOffset, writeOffset, size) glatter_glCopyNamedBufferSubData_debug((readBuffer), (writeBuffer), (readOffset), (writeOffset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyNamedBufferSubData_debug(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size, const char* file, int line);
#ifndef glCopyTextureSubImage1D
#define glCopyTextureSubImage1D(texture, level, xoffset, x, y, width) glatter_glCopyTextureSubImage1D_debug((texture), (level), (xoffset), (x), (y), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureSubImage1D_debug(GLuint texture, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width, const char* file, int line);
#ifndef glCopyTextureSubImage2D
#define glCopyTextureSubImage2D(texture, level, xoffset, yoffset, x, y, width, height) glatter_glCopyTextureSubImage2D_debug((texture), (level), (xoffset), (yoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureSubImage2D_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glCopyTextureSubImage3D
#define glCopyTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, x, y, width, height) glatter_glCopyTextureSubImage3D_debug((texture), (level), (xoffset), (yoffset), (zoffset), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureSubImage3D_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glCreateBuffers
#define glCreateBuffers(n, buffers) glatter_glCreateBuffers_debug((n), (buffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateBuffers_debug(GLsizei n, GLuint *buffers, const char* file, int line);
#ifndef glCreateFramebuffers
#define glCreateFramebuffers(n, framebuffers) glatter_glCreateFramebuffers_debug((n), (framebuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateFramebuffers_debug(GLsizei n, GLuint *framebuffers, const char* file, int line);
#ifndef glCreateProgramPipelines
#define glCreateProgramPipelines(n, pipelines) glatter_glCreateProgramPipelines_debug((n), (pipelines), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateProgramPipelines_debug(GLsizei n, GLuint *pipelines, const char* file, int line);
#ifndef glCreateQueries
#define glCreateQueries(target, n, ids) glatter_glCreateQueries_debug((target), (n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateQueries_debug(GLenum target, GLsizei n, GLuint *ids, const char* file, int line);
#ifndef glCreateRenderbuffers
#define glCreateRenderbuffers(n, renderbuffers) glatter_glCreateRenderbuffers_debug((n), (renderbuffers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateRenderbuffers_debug(GLsizei n, GLuint *renderbuffers, const char* file, int line);
#ifndef glCreateSamplers
#define glCreateSamplers(n, samplers) glatter_glCreateSamplers_debug((n), (samplers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateSamplers_debug(GLsizei n, GLuint *samplers, const char* file, int line);
#ifndef glCreateTextures
#define glCreateTextures(target, n, textures) glatter_glCreateTextures_debug((target), (n), (textures), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateTextures_debug(GLenum target, GLsizei n, GLuint *textures, const char* file, int line);
#ifndef glCreateTransformFeedbacks
#define glCreateTransformFeedbacks(n, ids) glatter_glCreateTransformFeedbacks_debug((n), (ids), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateTransformFeedbacks_debug(GLsizei n, GLuint *ids, const char* file, int line);
#ifndef glCreateVertexArrays
#define glCreateVertexArrays(n, arrays) glatter_glCreateVertexArrays_debug((n), (arrays), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glCreateVertexArrays_debug(GLsizei n, GLuint *arrays, const char* file, int line);
#ifndef glDisableVertexArrayAttrib
#define glDisableVertexArrayAttrib(vaobj, index) glatter_glDisableVertexArrayAttrib_debug((vaobj), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexArrayAttrib_debug(GLuint vaobj, GLuint index, const char* file, int line);
#ifndef glEnableVertexArrayAttrib
#define glEnableVertexArrayAttrib(vaobj, index) glatter_glEnableVertexArrayAttrib_debug((vaobj), (index), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexArrayAttrib_debug(GLuint vaobj, GLuint index, const char* file, int line);
#ifndef glFlushMappedNamedBufferRange
#define glFlushMappedNamedBufferRange(buffer, offset, length) glatter_glFlushMappedNamedBufferRange_debug((buffer), (offset), (length), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glFlushMappedNamedBufferRange_debug(GLuint buffer, GLintptr offset, GLsizeiptr length, const char* file, int line);
#ifndef glGenerateTextureMipmap
#define glGenerateTextureMipmap(texture) glatter_glGenerateTextureMipmap_debug((texture), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGenerateTextureMipmap_debug(GLuint texture, const char* file, int line);
#ifndef glGetCompressedTextureImage
#define glGetCompressedTextureImage(texture, level, bufSize, pixels) glatter_glGetCompressedTextureImage_debug((texture), (level), (bufSize), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCompressedTextureImage_debug(GLuint texture, GLint level, GLsizei bufSize, void *pixels, const char* file, int line);
#ifndef glGetCompressedTextureSubImage
#define glGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels) glatter_glGetCompressedTextureSubImage_debug((texture), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (bufSize), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetCompressedTextureSubImage_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei bufSize, void *pixels, const char* file, int line);
#ifndef glGetGraphicsResetStatus
#define glGetGraphicsResetStatus() glatter_glGetGraphicsResetStatus_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLenum glatter_glGetGraphicsResetStatus_debug(const char* file, int line);
#ifndef glGetNamedBufferParameteri64v
#define glGetNamedBufferParameteri64v(buffer, pname, params) glatter_glGetNamedBufferParameteri64v_debug((buffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferParameteri64v_debug(GLuint buffer, GLenum pname, GLint64 *params, const char* file, int line);
#ifndef glGetNamedBufferParameteriv
#define glGetNamedBufferParameteriv(buffer, pname, params) glatter_glGetNamedBufferParameteriv_debug((buffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferParameteriv_debug(GLuint buffer, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetNamedBufferPointerv
#define glGetNamedBufferPointerv(buffer, pname, params) glatter_glGetNamedBufferPointerv_debug((buffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferPointerv_debug(GLuint buffer, GLenum pname, void **params, const char* file, int line);
#ifndef glGetNamedBufferSubData
#define glGetNamedBufferSubData(buffer, offset, size, data) glatter_glGetNamedBufferSubData_debug((buffer), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferSubData_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, void *data, const char* file, int line);
#ifndef glGetNamedFramebufferAttachmentParameteriv
#define glGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, params) glatter_glGetNamedFramebufferAttachmentParameteriv_debug((framebuffer), (attachment), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedFramebufferAttachmentParameteriv_debug(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetNamedFramebufferParameteriv
#define glGetNamedFramebufferParameteriv(framebuffer, pname, param) glatter_glGetNamedFramebufferParameteriv_debug((framebuffer), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedFramebufferParameteriv_debug(GLuint framebuffer, GLenum pname, GLint *param, const char* file, int line);
#ifndef glGetNamedRenderbufferParameteriv
#define glGetNamedRenderbufferParameteriv(renderbuffer, pname, params) glatter_glGetNamedRenderbufferParameteriv_debug((renderbuffer), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetNamedRenderbufferParameteriv_debug(GLuint renderbuffer, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetQueryBufferObjecti64v
#define glGetQueryBufferObjecti64v(id, buffer, pname, offset) glatter_glGetQueryBufferObjecti64v_debug((id), (buffer), (pname), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryBufferObjecti64v_debug(GLuint id, GLuint buffer, GLenum pname, GLintptr offset, const char* file, int line);
#ifndef glGetQueryBufferObjectiv
#define glGetQueryBufferObjectiv(id, buffer, pname, offset) glatter_glGetQueryBufferObjectiv_debug((id), (buffer), (pname), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryBufferObjectiv_debug(GLuint id, GLuint buffer, GLenum pname, GLintptr offset, const char* file, int line);
#ifndef glGetQueryBufferObjectui64v
#define glGetQueryBufferObjectui64v(id, buffer, pname, offset) glatter_glGetQueryBufferObjectui64v_debug((id), (buffer), (pname), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryBufferObjectui64v_debug(GLuint id, GLuint buffer, GLenum pname, GLintptr offset, const char* file, int line);
#ifndef glGetQueryBufferObjectuiv
#define glGetQueryBufferObjectuiv(id, buffer, pname, offset) glatter_glGetQueryBufferObjectuiv_debug((id), (buffer), (pname), (offset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetQueryBufferObjectuiv_debug(GLuint id, GLuint buffer, GLenum pname, GLintptr offset, const char* file, int line);
#ifndef glGetTextureImage
#define glGetTextureImage(texture, level, format, type, bufSize, pixels) glatter_glGetTextureImage_debug((texture), (level), (format), (type), (bufSize), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureImage_debug(GLuint texture, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *pixels, const char* file, int line);
#ifndef glGetTextureLevelParameterfv
#define glGetTextureLevelParameterfv(texture, level, pname, params) glatter_glGetTextureLevelParameterfv_debug((texture), (level), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureLevelParameterfv_debug(GLuint texture, GLint level, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetTextureLevelParameteriv
#define glGetTextureLevelParameteriv(texture, level, pname, params) glatter_glGetTextureLevelParameteriv_debug((texture), (level), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureLevelParameteriv_debug(GLuint texture, GLint level, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTextureParameterIiv
#define glGetTextureParameterIiv(texture, pname, params) glatter_glGetTextureParameterIiv_debug((texture), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterIiv_debug(GLuint texture, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTextureParameterIuiv
#define glGetTextureParameterIuiv(texture, pname, params) glatter_glGetTextureParameterIuiv_debug((texture), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterIuiv_debug(GLuint texture, GLenum pname, GLuint *params, const char* file, int line);
#ifndef glGetTextureParameterfv
#define glGetTextureParameterfv(texture, pname, params) glatter_glGetTextureParameterfv_debug((texture), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterfv_debug(GLuint texture, GLenum pname, GLfloat *params, const char* file, int line);
#ifndef glGetTextureParameteriv
#define glGetTextureParameteriv(texture, pname, params) glatter_glGetTextureParameteriv_debug((texture), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameteriv_debug(GLuint texture, GLenum pname, GLint *params, const char* file, int line);
#ifndef glGetTextureSubImage
#define glGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixels) glatter_glGetTextureSubImage_debug((texture), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (bufSize), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTextureSubImage_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLsizei bufSize, void *pixels, const char* file, int line);
#ifndef glGetTransformFeedbacki64_v
#define glGetTransformFeedbacki64_v(xfb, pname, index, param) glatter_glGetTransformFeedbacki64_v_debug((xfb), (pname), (index), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTransformFeedbacki64_v_debug(GLuint xfb, GLenum pname, GLuint index, GLint64 *param, const char* file, int line);
#ifndef glGetTransformFeedbacki_v
#define glGetTransformFeedbacki_v(xfb, pname, index, param) glatter_glGetTransformFeedbacki_v_debug((xfb), (pname), (index), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTransformFeedbacki_v_debug(GLuint xfb, GLenum pname, GLuint index, GLint *param, const char* file, int line);
#ifndef glGetTransformFeedbackiv
#define glGetTransformFeedbackiv(xfb, pname, param) glatter_glGetTransformFeedbackiv_debug((xfb), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetTransformFeedbackiv_debug(GLuint xfb, GLenum pname, GLint *param, const char* file, int line);
#ifndef glGetVertexArrayIndexed64iv
#define glGetVertexArrayIndexed64iv(vaobj, index, pname, param) glatter_glGetVertexArrayIndexed64iv_debug((vaobj), (index), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayIndexed64iv_debug(GLuint vaobj, GLuint index, GLenum pname, GLint64 *param, const char* file, int line);
#ifndef glGetVertexArrayIndexediv
#define glGetVertexArrayIndexediv(vaobj, index, pname, param) glatter_glGetVertexArrayIndexediv_debug((vaobj), (index), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayIndexediv_debug(GLuint vaobj, GLuint index, GLenum pname, GLint *param, const char* file, int line);
#ifndef glGetVertexArrayiv
#define glGetVertexArrayiv(vaobj, pname, param) glatter_glGetVertexArrayiv_debug((vaobj), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayiv_debug(GLuint vaobj, GLenum pname, GLint *param, const char* file, int line);
#ifndef glGetnColorTable
#define glGetnColorTable(target, format, type, bufSize, table) glatter_glGetnColorTable_debug((target), (format), (type), (bufSize), (table), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnColorTable_debug(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table, const char* file, int line);
#ifndef glGetnCompressedTexImage
#define glGetnCompressedTexImage(target, lod, bufSize, pixels) glatter_glGetnCompressedTexImage_debug((target), (lod), (bufSize), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnCompressedTexImage_debug(GLenum target, GLint lod, GLsizei bufSize, void *pixels, const char* file, int line);
#ifndef glGetnConvolutionFilter
#define glGetnConvolutionFilter(target, format, type, bufSize, image) glatter_glGetnConvolutionFilter_debug((target), (format), (type), (bufSize), (image), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnConvolutionFilter_debug(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image, const char* file, int line);
#ifndef glGetnHistogram
#define glGetnHistogram(target, reset, format, type, bufSize, values) glatter_glGetnHistogram_debug((target), (reset), (format), (type), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnHistogram_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void *values, const char* file, int line);
#ifndef glGetnMapdv
#define glGetnMapdv(target, query, bufSize, v) glatter_glGetnMapdv_debug((target), (query), (bufSize), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnMapdv_debug(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v, const char* file, int line);
#ifndef glGetnMapfv
#define glGetnMapfv(target, query, bufSize, v) glatter_glGetnMapfv_debug((target), (query), (bufSize), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnMapfv_debug(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v, const char* file, int line);
#ifndef glGetnMapiv
#define glGetnMapiv(target, query, bufSize, v) glatter_glGetnMapiv_debug((target), (query), (bufSize), (v), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnMapiv_debug(GLenum target, GLenum query, GLsizei bufSize, GLint *v, const char* file, int line);
#ifndef glGetnMinmax
#define glGetnMinmax(target, reset, format, type, bufSize, values) glatter_glGetnMinmax_debug((target), (reset), (format), (type), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnMinmax_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void *values, const char* file, int line);
#ifndef glGetnPixelMapfv
#define glGetnPixelMapfv(map, bufSize, values) glatter_glGetnPixelMapfv_debug((map), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnPixelMapfv_debug(GLenum map, GLsizei bufSize, GLfloat *values, const char* file, int line);
#ifndef glGetnPixelMapuiv
#define glGetnPixelMapuiv(map, bufSize, values) glatter_glGetnPixelMapuiv_debug((map), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnPixelMapuiv_debug(GLenum map, GLsizei bufSize, GLuint *values, const char* file, int line);
#ifndef glGetnPixelMapusv
#define glGetnPixelMapusv(map, bufSize, values) glatter_glGetnPixelMapusv_debug((map), (bufSize), (values), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnPixelMapusv_debug(GLenum map, GLsizei bufSize, GLushort *values, const char* file, int line);
#ifndef glGetnPolygonStipple
#define glGetnPolygonStipple(bufSize, pattern) glatter_glGetnPolygonStipple_debug((bufSize), (pattern), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnPolygonStipple_debug(GLsizei bufSize, GLubyte *pattern, const char* file, int line);
#ifndef glGetnSeparableFilter
#define glGetnSeparableFilter(target, format, type, rowBufSize, row, columnBufSize, column, span) glatter_glGetnSeparableFilter_debug((target), (format), (type), (rowBufSize), (row), (columnBufSize), (column), (span), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnSeparableFilter_debug(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void *row, GLsizei columnBufSize, void *column, void *span, const char* file, int line);
#ifndef glGetnTexImage
#define glGetnTexImage(target, level, format, type, bufSize, pixels) glatter_glGetnTexImage_debug((target), (level), (format), (type), (bufSize), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnTexImage_debug(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *pixels, const char* file, int line);
#ifndef glGetnUniformdv
#define glGetnUniformdv(program, location, bufSize, params) glatter_glGetnUniformdv_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformdv_debug(GLuint program, GLint location, GLsizei bufSize, GLdouble *params, const char* file, int line);
#ifndef glGetnUniformfv
#define glGetnUniformfv(program, location, bufSize, params) glatter_glGetnUniformfv_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformfv_debug(GLuint program, GLint location, GLsizei bufSize, GLfloat *params, const char* file, int line);
#ifndef glGetnUniformiv
#define glGetnUniformiv(program, location, bufSize, params) glatter_glGetnUniformiv_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformiv_debug(GLuint program, GLint location, GLsizei bufSize, GLint *params, const char* file, int line);
#ifndef glGetnUniformuiv
#define glGetnUniformuiv(program, location, bufSize, params) glatter_glGetnUniformuiv_debug((program), (location), (bufSize), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformuiv_debug(GLuint program, GLint location, GLsizei bufSize, GLuint *params, const char* file, int line);
#ifndef glInvalidateNamedFramebufferData
#define glInvalidateNamedFramebufferData(framebuffer, numAttachments, attachments) glatter_glInvalidateNamedFramebufferData_debug((framebuffer), (numAttachments), (attachments), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInvalidateNamedFramebufferData_debug(GLuint framebuffer, GLsizei numAttachments, const GLenum *attachments, const char* file, int line);
#ifndef glInvalidateNamedFramebufferSubData
#define glInvalidateNamedFramebufferSubData(framebuffer, numAttachments, attachments, x, y, width, height) glatter_glInvalidateNamedFramebufferSubData_debug((framebuffer), (numAttachments), (attachments), (x), (y), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glInvalidateNamedFramebufferSubData_debug(GLuint framebuffer, GLsizei numAttachments, const GLenum *attachments, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glMapNamedBuffer
#define glMapNamedBuffer(buffer, access) glatter_glMapNamedBuffer_debug((buffer), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void * glatter_glMapNamedBuffer_debug(GLuint buffer, GLenum access, const char* file, int line);
#ifndef glMapNamedBufferRange
#define glMapNamedBufferRange(buffer, offset, length, access) glatter_glMapNamedBufferRange_debug((buffer), (offset), (length), (access), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void * glatter_glMapNamedBufferRange_debug(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access, const char* file, int line);
#ifndef glMemoryBarrierByRegion
#define glMemoryBarrierByRegion(barriers) glatter_glMemoryBarrierByRegion_debug((barriers), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMemoryBarrierByRegion_debug(GLbitfield barriers, const char* file, int line);
#ifndef glNamedBufferData
#define glNamedBufferData(buffer, size, data, usage) glatter_glNamedBufferData_debug((buffer), (size), (data), (usage), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferData_debug(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage, const char* file, int line);
#ifndef glNamedBufferStorage
#define glNamedBufferStorage(buffer, size, data, flags) glatter_glNamedBufferStorage_debug((buffer), (size), (data), (flags), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferStorage_debug(GLuint buffer, GLsizeiptr size, const void *data, GLbitfield flags, const char* file, int line);
#ifndef glNamedBufferSubData
#define glNamedBufferSubData(buffer, offset, size, data) glatter_glNamedBufferSubData_debug((buffer), (offset), (size), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferSubData_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line);
#ifndef glNamedFramebufferDrawBuffer
#define glNamedFramebufferDrawBuffer(framebuffer, buf) glatter_glNamedFramebufferDrawBuffer_debug((framebuffer), (buf), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferDrawBuffer_debug(GLuint framebuffer, GLenum buf, const char* file, int line);
#ifndef glNamedFramebufferDrawBuffers
#define glNamedFramebufferDrawBuffers(framebuffer, n, bufs) glatter_glNamedFramebufferDrawBuffers_debug((framebuffer), (n), (bufs), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferDrawBuffers_debug(GLuint framebuffer, GLsizei n, const GLenum *bufs, const char* file, int line);
#ifndef glNamedFramebufferParameteri
#define glNamedFramebufferParameteri(framebuffer, pname, param) glatter_glNamedFramebufferParameteri_debug((framebuffer), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferParameteri_debug(GLuint framebuffer, GLenum pname, GLint param, const char* file, int line);
#ifndef glNamedFramebufferReadBuffer
#define glNamedFramebufferReadBuffer(framebuffer, src) glatter_glNamedFramebufferReadBuffer_debug((framebuffer), (src), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferReadBuffer_debug(GLuint framebuffer, GLenum src, const char* file, int line);
#ifndef glNamedFramebufferRenderbuffer
#define glNamedFramebufferRenderbuffer(framebuffer, attachment, renderbuffertarget, renderbuffer) glatter_glNamedFramebufferRenderbuffer_debug((framebuffer), (attachment), (renderbuffertarget), (renderbuffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferRenderbuffer_debug(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer, const char* file, int line);
#ifndef glNamedFramebufferTexture
#define glNamedFramebufferTexture(framebuffer, attachment, texture, level) glatter_glNamedFramebufferTexture_debug((framebuffer), (attachment), (texture), (level), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTexture_debug(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, const char* file, int line);
#ifndef glNamedFramebufferTextureLayer
#define glNamedFramebufferTextureLayer(framebuffer, attachment, texture, level, layer) glatter_glNamedFramebufferTextureLayer_debug((framebuffer), (attachment), (texture), (level), (layer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTextureLayer_debug(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer, const char* file, int line);
#ifndef glNamedRenderbufferStorage
#define glNamedRenderbufferStorage(renderbuffer, internalformat, width, height) glatter_glNamedRenderbufferStorage_debug((renderbuffer), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorage_debug(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glNamedRenderbufferStorageMultisample
#define glNamedRenderbufferStorageMultisample(renderbuffer, samples, internalformat, width, height) glatter_glNamedRenderbufferStorageMultisample_debug((renderbuffer), (samples), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageMultisample_debug(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glReadnPixels
#define glReadnPixels(x, y, width, height, format, type, bufSize, data) glatter_glReadnPixels_debug((x), (y), (width), (height), (format), (type), (bufSize), (data), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glReadnPixels_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data, const char* file, int line);
#ifndef glTextureBarrier
#define glTextureBarrier() glatter_glTextureBarrier_debug(__FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureBarrier_debug(const char* file, int line);
#ifndef glTextureBuffer
#define glTextureBuffer(texture, internalformat, buffer) glatter_glTextureBuffer_debug((texture), (internalformat), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureBuffer_debug(GLuint texture, GLenum internalformat, GLuint buffer, const char* file, int line);
#ifndef glTextureBufferRange
#define glTextureBufferRange(texture, internalformat, buffer, offset, size) glatter_glTextureBufferRange_debug((texture), (internalformat), (buffer), (offset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureBufferRange_debug(GLuint texture, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line);
#ifndef glTextureParameterIiv
#define glTextureParameterIiv(texture, pname, params) glatter_glTextureParameterIiv_debug((texture), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterIiv_debug(GLuint texture, GLenum pname, const GLint *params, const char* file, int line);
#ifndef glTextureParameterIuiv
#define glTextureParameterIuiv(texture, pname, params) glatter_glTextureParameterIuiv_debug((texture), (pname), (params), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterIuiv_debug(GLuint texture, GLenum pname, const GLuint *params, const char* file, int line);
#ifndef glTextureParameterf
#define glTextureParameterf(texture, pname, param) glatter_glTextureParameterf_debug((texture), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterf_debug(GLuint texture, GLenum pname, GLfloat param, const char* file, int line);
#ifndef glTextureParameterfv
#define glTextureParameterfv(texture, pname, param) glatter_glTextureParameterfv_debug((texture), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterfv_debug(GLuint texture, GLenum pname, const GLfloat *param, const char* file, int line);
#ifndef glTextureParameteri
#define glTextureParameteri(texture, pname, param) glatter_glTextureParameteri_debug((texture), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameteri_debug(GLuint texture, GLenum pname, GLint param, const char* file, int line);
#ifndef glTextureParameteriv
#define glTextureParameteriv(texture, pname, param) glatter_glTextureParameteriv_debug((texture), (pname), (param), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureParameteriv_debug(GLuint texture, GLenum pname, const GLint *param, const char* file, int line);
#ifndef glTextureStorage1D
#define glTextureStorage1D(texture, levels, internalformat, width) glatter_glTextureStorage1D_debug((texture), (levels), (internalformat), (width), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage1D_debug(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, const char* file, int line);
#ifndef glTextureStorage2D
#define glTextureStorage2D(texture, levels, internalformat, width, height) glatter_glTextureStorage2D_debug((texture), (levels), (internalformat), (width), (height), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage2D_debug(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line);
#ifndef glTextureStorage2DMultisample
#define glTextureStorage2DMultisample(texture, samples, internalformat, width, height, fixedsamplelocations) glatter_glTextureStorage2DMultisample_debug((texture), (samples), (internalformat), (width), (height), (fixedsamplelocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage2DMultisample_debug(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations, const char* file, int line);
#ifndef glTextureStorage3D
#define glTextureStorage3D(texture, levels, internalformat, width, height, depth) glatter_glTextureStorage3D_debug((texture), (levels), (internalformat), (width), (height), (depth), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage3D_debug(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line);
#ifndef glTextureStorage3DMultisample
#define glTextureStorage3DMultisample(texture, samples, internalformat, width, height, depth, fixedsamplelocations) glatter_glTextureStorage3DMultisample_debug((texture), (samples), (internalformat), (width), (height), (depth), (fixedsamplelocations), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage3DMultisample_debug(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations, const char* file, int line);
#ifndef glTextureSubImage1D
#define glTextureSubImage1D(texture, level, xoffset, width, format, type, pixels) glatter_glTextureSubImage1D_debug((texture), (level), (xoffset), (width), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureSubImage1D_debug(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTextureSubImage2D
#define glTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, pixels) glatter_glTextureSubImage2D_debug((texture), (level), (xoffset), (yoffset), (width), (height), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureSubImage2D_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTextureSubImage3D
#define glTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels) glatter_glTextureSubImage3D_debug((texture), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (pixels), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTextureSubImage3D_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line);
#ifndef glTransformFeedbackBufferBase
#define glTransformFeedbackBufferBase(xfb, index, buffer) glatter_glTransformFeedbackBufferBase_debug((xfb), (index), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTransformFeedbackBufferBase_debug(GLuint xfb, GLuint index, GLuint buffer, const char* file, int line);
#ifndef glTransformFeedbackBufferRange
#define glTransformFeedbackBufferRange(xfb, index, buffer, offset, size) glatter_glTransformFeedbackBufferRange_debug((xfb), (index), (buffer), (offset), (size), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glTransformFeedbackBufferRange_debug(GLuint xfb, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line);
#ifndef glUnmapNamedBuffer
#define glUnmapNamedBuffer(buffer) glatter_glUnmapNamedBuffer_debug((buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT GLboolean glatter_glUnmapNamedBuffer_debug(GLuint buffer, const char* file, int line);
#ifndef glVertexArrayAttribBinding
#define glVertexArrayAttribBinding(vaobj, attribindex, bindingindex) glatter_glVertexArrayAttribBinding_debug((vaobj), (attribindex), (bindingindex), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayAttribBinding_debug(GLuint vaobj, GLuint attribindex, GLuint bindingindex, const char* file, int line);
#ifndef glVertexArrayAttribFormat
#define glVertexArrayAttribFormat(vaobj, attribindex, size, type, normalized, relativeoffset) glatter_glVertexArrayAttribFormat_debug((vaobj), (attribindex), (size), (type), (normalized), (relativeoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayAttribFormat_debug(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset, const char* file, int line);
#ifndef glVertexArrayAttribIFormat
#define glVertexArrayAttribIFormat(vaobj, attribindex, size, type, relativeoffset) glatter_glVertexArrayAttribIFormat_debug((vaobj), (attribindex), (size), (type), (relativeoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayAttribIFormat_debug(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset, const char* file, int line);
#ifndef glVertexArrayAttribLFormat
#define glVertexArrayAttribLFormat(vaobj, attribindex, size, type, relativeoffset) glatter_glVertexArrayAttribLFormat_debug((vaobj), (attribindex), (size), (type), (relativeoffset), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayAttribLFormat_debug(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset, const char* file, int line);
#ifndef glVertexArrayBindingDivisor
#define glVertexArrayBindingDivisor(vaobj, bindingindex, divisor) glatter_glVertexArrayBindingDivisor_debug((vaobj), (bindingindex), (divisor), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayBindingDivisor_debug(GLuint vaobj, GLuint bindingindex, GLuint divisor, const char* file, int line);
#ifndef glVertexArrayElementBuffer
#define glVertexArrayElementBuffer(vaobj, buffer) glatter_glVertexArrayElementBuffer_debug((vaobj), (buffer), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayElementBuffer_debug(GLuint vaobj, GLuint buffer, const char* file, int line);
#ifndef glVertexArrayVertexBuffer
#define glVertexArrayVertexBuffer(vaobj, bindingindex, buffer, offset, stride) glatter_glVertexArrayVertexBuffer_debug((vaobj), (bindingindex), (buffer), (offset), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexBuffer_debug(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride, const char* file, int line);
#ifndef glVertexArrayVertexBuffers
#define glVertexArrayVertexBuffers(vaobj, first, count, buffers, offsets, strides) glatter_glVertexArrayVertexBuffers_debug((vaobj), (first), (count), (buffers), (offsets), (strides), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexBuffers_debug(GLuint vaobj, GLuint first, GLsizei count, const GLuint *buffers, const GLintptr *offsets, const GLsizei *strides, const char* file, int line);
#endif // defined(GL_VERSION_4_5)
#if defined(GL_VERSION_4_6)
#ifndef glMultiDrawArraysIndirectCount
#define glMultiDrawArraysIndirectCount(mode, indirect, drawcount, maxdrawcount, stride) glatter_glMultiDrawArraysIndirectCount_debug((mode), (indirect), (drawcount), (maxdrawcount), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectCount_debug(GLenum mode, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride, const char* file, int line);
#ifndef glMultiDrawElementsIndirectCount
#define glMultiDrawElementsIndirectCount(mode, type, indirect, drawcount, maxdrawcount, stride) glatter_glMultiDrawElementsIndirectCount_debug((mode), (type), (indirect), (drawcount), (maxdrawcount), (stride), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectCount_debug(GLenum mode, GLenum type, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride, const char* file, int line);
#ifndef glPolygonOffsetClamp
#define glPolygonOffsetClamp(factor, units, clamp) glatter_glPolygonOffsetClamp_debug((factor), (units), (clamp), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffsetClamp_debug(GLfloat factor, GLfloat units, GLfloat clamp, const char* file, int line);
#ifndef glSpecializeShader
#define glSpecializeShader(shader, pEntryPoint, numSpecializationConstants, pConstantIndex, pConstantValue) glatter_glSpecializeShader_debug((shader), (pEntryPoint), (numSpecializationConstants), (pConstantIndex), (pConstantValue), __FILE__, __LINE__)
#endif
GLATTER_INLINE_OR_NOT void glatter_glSpecializeShader_debug(GLuint shader, const GLchar *pEntryPoint, GLuint numSpecializationConstants, const GLuint *pConstantIndex, const GLuint *pConstantValue, const char* file, int line);
#endif // defined(__gl_glext_h_)
#endif // defined(GL_VERSION_4_6)
#endif // GLATTER_GL

