# Oat++ 1.4.0

Previous release - [1.3.0](1.3.0.md)

Feel free to ask questions - [Chat on Gitter!](https://gitter.im/oatpp-framework/Lobby)

Contents:

- [URL Encoder And Decoder](#url-encoder-and-decoder)
- [Introduce async::ConditionVariable](#async-condition-variable)


## URL Encoder And Decoder

```cpp
#include "oatpp/encoding/Url.hpp"

...

oatpp::String data = "Hello URL-Encoder!!!";

oatpp::encoding::Url::Config config;
auto encoded = oatpp::encoding::Url::encode(data, config);
auto decoded = oatpp::encoding::Url::decode(encoded);

OATPP_ASSERT(decoded == data)
```
**Note**: Oat++ does NOT automatically decode URL and its parameters on endpoint hit. 

## Async Condition Variable

```cpp
#include "oatpp/core/async/ConditionVariable.hpp"

  ...
  
  oatpp::async::Lock* m_lock;
  oatpp::async::ConditionVariable* m_cv;
  
  ...
  
  Action act() override {
    return m_cv->waitFor(m_lock, // async::Lock
                         [this]{return m_resource->counter == 100;}, // condition
                         std::chrono::seconds(5)) // timeout
           .next(finish());
  }
  ...
```
