## How to Build     


---

### Using CMake
#### Building for desktop (WebGPU-native) with Google Dawn:
 1. `git clone https://github.com/google/dawn dawn`
 2. `cmake -B build -DIMGUI_DAWN_DIR=dawn`
 3. `cmake --build build`
The resulting binary will be found at one of the following locations:
  * build/Debug/example_sdl3_wgpu[.exe]
  * build/example_sdl3_wgpu[.exe]

#### Building for desktop (WebGPU-Native) with WGPU:
 1. download WGPU-Native autogenerated binary modules for your platform/compiler from: https://github.com/gfx-rs/wgpu-native/releases
 2. unzip the downloaded file in `your_preferred_folder`
 3. `cmake -B build -DIMGUI_WGPU_DIR=your_preferred_folder`  ("full path" or "relative" starting from current directory)
 5. `cmake --build build`
The resulting binary will be found at one of the following locations:
  * build/Debug/example_sdl3_wgpu[.exe]
  * build/example_sdl3_wgpu[.exe]

#### Building for Emscripten:
 1. Install Emscripten SDK following the instructions: https://emscripten.org/docs/getting_started/downloads.html
 2. Install Ninja build system
 3. `emcmake cmake -G Ninja -B build`
    - (optional) `-DIMGUI_EMSCRIPTEN_WEBGPU_FLAG="--use-port=path/to/emdawnwebgpu_package/emdawnwebgpu.port.py"`, see below
 4. `cmake --build build`

#### Sync Emscripten with latest Google Dawn:
If you want to sync Emscripten with latest DAWN release it's necessary to download the `port-emdawnwgpu-package` (released daily by Google) here:
https://github.com/google/dawn/releases
Unpack it in your preferred folder and to replace the step 3 with: 

3. `emcmake cmake -DIMGUI_EMSCRIPTEN_WEBGPU_FLAG="--use-port=path/to/emdawnwebgpu_package/emdawnwebgpu.port.py" -G Ninja -B build`

**N.B.**
For the WASM code produced by Emscripten to work correctly, it will also be necessary to have the "corresponding" (or newer) version of Google Canary (nightly build for developers) that includes the latest changes


---

### CMake by step

#### Generate Dawn Native:

- `cmake -G Ninja -DIMGUI_DAWN_DIR=path_to_sdk_dir -B where_to_build_dir`
   - Using `IMGUI_DAWN_DIR` set `IMGUI_IMPL_WEBGPU_BACKEND_DAWN` compiler define 

#### Generate WGPU Native:

- `cmake -G Ninja -DIMGUI_WGPU_DIR=path_to_sdk_dir -B where_to_build_dir`

   - Using `IMGUI_WGPU_DIR` set `IMGUI_IMPL_WEBGPU_BACKEND_WGPU` compiler define 

#### Generate Emscripten:

- `emcmake cmake -G Ninja -B where_to_build_dir`\
CMake checks the EMSCRIPEN version then:
   - if EMS >= 4.0.10 uses `--use-port=emdawnwebgpu` flag to build  
      - it set `IMGUI_IMPL_WEBGPU_BACKEND_DAWN` compiler define 
   - if EMS < 4.0.10 uses `-sUSE_WEBGPU=1` flag to build
      - it set `IMGUI_IMPL_WEBGPU_BACKEND_WGPU` compiler define 

#### Generate Emscripten forcing `-sUSE_WEBGPU=1` deprecated flag even with EMS >= 4.0.10
- `emcmake cmake -G Ninja -DIMGUI_EMSCRIPTEN_WEBGPU_FLAG="-sUSE_WEBGPU=1" -B where_to_build_dir`
   - it set `IMGUI_IMPL_WEBGPU_BACKEND_WGPU` compiler define 

#### Generate Emscripten using external WebGPU library (emdawnwebgpu_pkg)
- `emcmake cmake -G Ninja -DIMGUI_EMSCRIPTEN_WEBGPU_FLAG="--use-port=path_to_emdawnwebgpu_pkg" -B where_to_build_dir`
   - it set `IMGUI_IMPL_WEBGPU_BACKEND_DAWN` compiler define 
   - *To use external WebGPU library it's necessary to have EMS >= 4.0.10 or the minimum requirements specified by the package:*
      - https://github.com/google/dawn/releases 

#### Build time

Once the procedure for the specific builder is generated, the build command is **always the same**:

- Build using CMake
   - `cmake --build where_to_build_dir`
      - It will use selected builder to build the example.

- Build explicitly:
   - `cd where_to_build_dir`
   - `ninja` 
      - This is the builder chosen during the generation phase  

---

### CMake useful options
#### Generator types (alternative to **ninja** bulder):
- `-G Ninja` to build with __ninja__ builder
- `-G "Unix Makefiles"` to build with __make__ builder
- `-G "Visual Studio 17 2022" -A x64` to create a VS 2022 solution (.sln) file, Windows only 
   - **Native build only**
   - Not **officially** supported to build Google Dawn

Example:
- using **make** instead **ninja**:
   - `cmake -G "Unix Makefiles" -DIMGUI_DAWN_DIR=path_to_sdk_dir -B where_to_build_dir`

**Syntax is case sensitive and the "" are necessary in case of spaces between words*

#### Directories
- The directory path can be absolute or relative (starting from the current directory)
- It's necessary to use different `where_to_build_dir` for different CMake generations


#### Build type
The default build type is **Debug**
It is possible to use a different build type using:
- `-DCMAKE_BUILD_TYPE=Release`
- `-DCMAKE_BUILD_TYPE=MinSizeRel`
- `-DCMAKE_BUILD_TYPE=RelWithDebInfo`

Example:
- building **Release**:
   - `cmake -G ninja -DIMGUI_WGPU_DIR=path_to_sdk_dir -DCMAKE_BUILD_TYPE=Release -B where_to_build_dir ` 

#### GLFW / SDL2 / SDL3 includes, libraries, search paths and package manager

Includes and libraries, by default, are searched in system/compiler paths (environment variables): you can add the path to your development tools to the environment variables without having to modify the `CMakeLists.txt` file.
- e.g. CLang search in path specified from the following environment variables: 
    - include files: CPATH, C_INCLUDE_PATH, CPLUS_INCLUDE_PATH
    - library files: LIBRARY_PATH

If you are using a package manager (**vcpkg** / **conan** / ... ) you need/can to specify it, adding to cmake command:
- `-DCMAKE_TOOLCHAIN_FILE=path/to/package_manager.cmake`
          
Examples:

- using **vcpkg** package manager it's necessary adding:
   - `-DCMAKE_TOOLCHAIN_FILE=<vcpkg_root_dir>/scripts/buildsystems/vcpkg.cmake`

- full cmake command using **vcpkg** package manager:
   - `cmake -G Ninja -DIMGUI_DAWN_DIR=path_to_sdk_dir -DCMAKE_TOOLCHAIN_FILE=<vcpkg_root_dir>/scripts/buildsystems/vcpkg.cmake -B where_to_build_dir`

---


### Using makefile 

- You need to install Emscripten from https://emscripten.org/docs/getting_started/downloads.html, and have the environment variables set, as described in https://emscripten.org/docs/getting_started/downloads.html#installation-instructions

- Depending on your configuration, in Windows you may need to run `emsdk/emsdk_env.bat` in your console to access the Emscripten command-line tools.

- You may also refer to our [Continuous Integration setup](https://github.com/ocornut/imgui/tree/master/.github/workflows) for Emscripten setup.

- Then build using `make -f Makefile.emscripten` while in the `example_glfw_wgpu/` directory.

- Requires recent Emscripten as WGPU is still a work-in-progress API.

---

## How to Run

To run on a local machine:
- Make sure your browse supports WGPU and it is enabled. WGPU is still WIP not enabled by default in most browser.
- `make serve` will use Python3 to spawn a local webserver, you can then browse http://localhost:8000 to access your build.
- Otherwise, generally you will need a local webserver:
  - Quoting [https://emscripten.org/docs/getting_started](https://emscripten.org/docs/getting_started/Tutorial.html#generating-html):<br>
_"Unfortunately several browsers (including Chrome, Safari, and Internet Explorer) do not support file:// [XHR](https://emscripten.org/docs/site/glossary.html#term-xhr) requests, and can’t load extra files needed by the HTML (like a .wasm file, or packaged file data as mentioned lower down). For these browsers you’ll need to serve the files using a [local webserver](https://emscripten.org/docs/getting_started/FAQ.html#faq-local-webserver) and then open http://localhost:8000/hello.html."_
  - Emscripten SDK has a handy `emrun` command: `emrun web/example_glfw_wgpu.html --browser firefox` which will spawn a temporary local webserver (in Firefox). See https://emscripten.org/docs/compiling/Running-html-files-with-emrun.html for details.
  - You may use Python 3 builtin webserver: `python -m http.server -d web` (this is what `make serve` uses).
  - You may use Python 2 builtin webserver: `cd web && python -m SimpleHTTPServer`.
  - If you are accessing the files over a network, certain browsers, such as Firefox, will restrict Gamepad API access to secure contexts only (e.g. https only).
