<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

November 16, 2020

Host: Doug Walker

Rotating Secretary: Carol Payne

Attendees:
  * [x] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [x] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [ ] Michael Dolan (_TSC Chair_) - Epic Games
  * [x] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [x] Carol Payne (_TSC_) - Netflix
  * [x] Mark Titchener (_TSC_) - Foundry
  * [x] Carl Rand (_TSC_) - Weta Digital
  * [x] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [x] Kevin Wheatley (_TSC_) - Framestore
  * [x] Bernard Lefebvre - Autodesk
  * [x] J Schulte - ILM
  * [x] Matthias Scharfenberg - ILM
  * [x] Larry Gritz - SPI
  * [x] Aymee Kennett (Yeh) - Netflix

Apologies:
  Michael Dolan

# **OCIO TSC Meeting Notes**

* Named Color Transforms - Continued discussion
    - Doug: Patrick, Bernard and I have been discussing the feedback and how to respond. We have made it possible to turn off the NamedTransforms - similar to an environment variable. Config author/ dev would be able to control whether or not the feature is visible to the user. Bernard has pushed that commit to the PR so it should be available for viewing.
    - Mark: on/off isn't a true solution - we don't want to fracture the community. The opposition was because we felt that NamedTransforms opposed the way we want OCIO to work.
    - Doug: would be interested to hear alternate proposals.
    - Mark: the solutions already exist - you just have to utilize your working space as your reference space. 
    - Doug: Not everyone is going to be solely using the working space of the config. 
    - Mark: You design your config based on your requirements for your work. Having different in and out colorspaces is not how it's defined to work.
    - Doug: We can't expect everyone to have a separate config per working space. Even a difference between rendering space vs. compositing space. Thinking ahead to the studio config as well, it would be ideal if this workflow was easier to implement. 
    - Mark: But ACES is trying to be the single working space - and should be for the future. 
    - Carl: WETA works in a different compositing colorspace than rendering space, for example.
    - Matthias: verifying that we're talking about NamedTransforms that are basically a transfer funtion or something similar? So you don't get the matrix transform that you would get by using the colorspace which goes through the reference space as well? It sounds like a "trapdoor" in the color management system.
    - Kevin: I didn't see it quite that way. Instead of performing a 2-sided transformation, it's a 1 sided.
    - Matthias: but isn't that not how OCIO is designed? That you need to go through the reference? This becomes like a "transfer function toolbox" for debugging, design, etc. Could be handy but don't see how it ties into the OCIO ecosystem itself. 
    - Kevin: Are we talking about something that a DCC needs access to? Or just a toolbox of options. 
    - Doug: So we wanted to clarify this by not calling it a colorspace - it's a NamedTransform. The ability to define a transform rather than a colorspace. 
    - Mark: will you see these in say, the list of options to load a texture in an application?
    - Kevin: Are we just missing some UI/UX design features? Do we need an OCIOTransform op? Would that accomplish the same thing?
    - Matthias: the concern is that this really offers a trapdoor - an exit from the color managed worflow - what happens when you don't know where you're coming from or where you're going? 
    - Mark: Still don't understand who the end user is here - seems to be config authors, but config authors already know how to do this correctly.
    - Doug: we have received feedback that this feature is a requirement. From multiple users / DCC authors. Not everyone knows how to write a config
    - J: but if we think to the future, and if we can help users move forward to a correct color management workflows, that a lot of these requests would be moot?
    - Doug: a lot of users don't understand/want anything more than a 1d linear/log workflow - but still need to be able to connect into a color managed world.
    - Mark: I don't think you can have it both ways.
    - J: Is the concept of what we're trying to get out of this enabling workflows that go against the "correct" OCIO usage? Does this matter - or are we just providing ways to work to DCCs to use it as they will. 
    - Carol: Is there a middle ground? We want people to graduate to color management, and if this is a feature that's been requested, wouldn't we rather enable them to move forward into OCIO?
    - Mei: what transforms are we talking about that couldn't be expressed via an OCIOFileTransform node in Nuke?
    - J: Worried about introducing this potential for breakage in already complicated pipelines and worflows. 
    - Doug: tools already have this, what's the opposition to having it in OCIO?
    - J: We try to operate solely in fully color managed workflows, and introducing this throws a wrench in those workflows that requires additional support and tracking and awareness. Should OCIO be setting the standard and authority of good practices, or is it solely middleware at this point?
    - Doug: It's a complete color management solution. I feel that if it's going to be complete, it can't only be state of the art, as practiced by the best. We need to make it applicable and achievable to all. There's an expectation that workflows that have existed still exist and there is a broad user base we need to support. We need to be realistic.
    - Carol: there's a huge group of people who have been working the way they are for years, who might not benefit at all from changing their workflows. 
    - Mark: the rest of the line in the documentation is - geared toward the motion picture industry for visual effects and animation.
    - Doug: visual effects is a very big industry - learning the craft through youtube without guidance. A number of these features are indeed broadening the scope of the original OCIO features. I don't think that is uncommon as projects grow, their user base expands, and needs change. Michael and I tried to start this earlier in the year when we updated the mission statement. We feel we've been very clear in our participation in OCIO - which is to suit the needs of a wide range of visual effects and animation artists in every area. We used to have two color management systems - we are trying to have one system to meet all of the needs.
    - J: Thank you, that's very clarifying.
    - Doug: I don't know where this leaves us, we have a few more things to discuss.
    - J: would love to think about this and regroup.
    
* RC1 or beta1 tag:
  - Doug: we are fine with beta1 instead of rc1.
  - Mark: Good with that.

* CUDA implementation followup.
    - Doug: We talked about this last week, but missed the intent of Larry's original question - so he's here this week to help us understand his ask for OSL and other renderers.
    - Larry: Traditionally OCIO functionality has been in 2 directions - using interactive graphics APIs to color correct a display. Makes sense for this to be OpenGL. But there's a 2nd interface callable from c++, which we use in OSL which do arbitrary transforms in shaders that we need at the time, as long as it's in the config. Trick here is renderers that take advantage of that are switching to CUDA based implementations - want to figure out how to continue to access this functionality in the new CUDA world? Or is this not something these libraries will continue to be able to use OCIO for? It's not uncomplicated - there has to be a directly accesible implementation for CUDA. 
    - Mark: So added functionality to the API to get a CUDA callable alternative would this solve the problem? 
    - Larry: CPU based c++ app launching CUDA kernels. Can the CPU app ask for the correct CUDA version to pass for the shader - think this would be fine. Just want something - get a handle to a CUDA callable transform.
    - Mark: only thing we have now is the GLSL "get me a shader". Another API call where you pass in CUDA instead of whatever, that would work? Either texture source or byte code?
    - Larry: either is fine.
    - Mark: Textural source would be much easier. 
    - Doug: Issue with the GPU is how to get the texture onto the GPU.
    - Patrick: Yeah it's a big blob of data - the texture that you have to get onto the GPU. The structure is there to be able to generate the CUDA code. There are two APIs - one that's openGL oriented, the other that just takes what it needs to do.
    - Larry: CUDA has similar texture lookup to what you find in OpenGL.
    - Patrick: Dynamic properties are another functionality to consider.
    - Doug: Yes, how would you do uniforms?
    - Larry: Not sure, will find out - but not critical right now.
    - Mark: Imagine it's there, values you can tweak on your shaders.
    - Larry: There are assumptions it makes - numbers you can't change without regenerating the shader. But it's not the primary concern right now.
    - Mark: should be doable - just need someone to do it. There's not a lot to change, it's just annoying - go through every transform to add the CUDA implementation.
    - Larry: good news is CUDA is basically C++ with decorators. 
    - Patrick: Another thing we have are helper functions - still C++ but soemthing to consider. It's a function in the shader. 
    - Mark: so the hooks in the shader where you're expecting user input?
    - Patrick: No, at the intitial generation. A shader might use another method to call to perform a function - it's a subfunction.
    - Mark: Ah, so it's like a standard library of things you can use in your GLSL.
    - Patrick. Yes, so we're not repeating a bunch of code. 
    - Doug: to summarize, the current API would support CUDA, but it would be a fair amount of work to implement - we have an issue open for it now, looking for volunteers.
    - Doug: thanks everyone, there's a configs meeting tomorrow, make sure you check the times! 
    

