<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

September 28, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [ ] Mark Titchener (_TSC_) - Foundry
  * [X] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [ ] Kevin Wheatley (_TSC_) - Framestore
  * [X] Bernard Lefebvre - Autodesk
  * [X] Nigel Hadley - Foundry
  * [X] Simran Spiller

Apologies:
  * Kevin Wheatley
  * Mark Titchener

# **OCIO TSC Meeting Notes**

* TAC update on GSoC. Focus for next year:
    - Michael: Good feedback on results. Likely that ASWF will participate 
      again next year and are hopful that all projects can get a project. 
      Should start thinking about where to focus. CUDA, Metal renderer impl 
      seems like a good place to try again on.
    - Doug: Good to have volunteer for each project. Is Hacktoberfest 
      happening again this year?
    - Michael: Good question. I believe that was based on a tag search.

* Issue #1117 -- Help Wanted:
    - Doug: Added new label help-wanted. Others use this too. Can start adding 
      this to high priority issues. This issue is to create OFX bindings for 
      OCIO v2. High priority since it would increase test coverage with so many 
      supporting apps. Could get more practitioners and developers to download 
      and test those.
    - Michael: OFX is supported by Nuke; Curious if it would create conflict 
      with existing OCIO v1 binary in that env.

* Open PRs: 
    - 1147 (optimization):
        - Doug: Updates config default version and optimization improvements. 
          When create new config, it is now v2 by default instead of v1. Other 
          thing in PR enhances optimization flags. Now ability to control types 
          of optimization. Two new flags: one simplifies ops down to component 
          parts; CDL without power becomes just matrix if possible, etc. 
          Benefit is that can be combined with another matrix op. Another flag 
          controls whether SSE log and power are used. Does much faster version 
          of these functions but not 32-bit exact - 16-bit half precision. 
          Useful to turn it on and off, and off for unit tests since we’re 
          comparing with higher precision results.
        - Bernard: Fast log is not used for baking.
        - Mark: Why is SSE path not as precise? Because of writing own exponent 
          functions etc?
        - Patrick: Yes, wrote own implementation. Benefit in performance is so 
          important that both approaches are supported.
        - Doug: Uses fewer iterations than needed for full float 32-bit results.
        - Mark: Had similar challenge getting this working in CTL expression 
          code. Finding concise method of operations challenging. Since we 
          already have concept of optimizations sounds fine. Is this default?
        - Doug: Yes, both are turned on by default, in OPTIMIZATION_VERY_GOOD.
        - Patrick: optimization is based on bits, so can disable any of the 
          items. Fine control of optimization.
    - 1157 (file transform interpolation):
        - Doug: Prompted by issue (1121) from Remi. File transform will now use 
          DEFAULT interpolation as default, instead of UNKNOWN, which prevents 
          exceptions being thrown in various places. Also cleaned up some file 
          transform interpolation. If you specify an interpolation that can't 
          be used for file, will log warning. For CLF, where interpolation can 
          be specified in file, if an op doesn't specify interpolation, it will 
          try to use the FileTransform interpolation specified. Will ignore 
          file transform if specified in file. Also addresses issue with 
          caching. If multiple transforms used specify different 
          interpolations, that will now work.
        - Bernard: Also added a function to get the type of a transform (CDL, 
          Matrix, etc.).
        - Mark: Any reason to default interpolation to DEFAULT instead of BEST? 
          Should we change it to BEST?
        - Bernard: For 1D doesn't matter, but for 3D, difference between 
          tetrahedral and trilinear.
        - Mark: Should change to BEST to get tetrahedral.
        - Bernard: If we want to use BEST all the time, change DEFAULT to BEST.
        - Doug: Tetrahedral slower than trilinear, and GPUs do trilinear by 
          default. CPU and GPU will match better and get faster behavior. 
          Defaults usually land on faster. You can request tetrahedral in 
          transform.
        - Mark: Why use trilinear if tetrahedral is available? Now that 
          tetrahedral is available on GPU.
        - Doug: Still uncommon for other apps to use tetrahedral on GPU. 
          Usually use trilinear.
        - Mark: But we're bringing fantastic tetrahedral to the table.
        - Doug: Trilinear would behave like other apps.
        - Mark: Did old code default to DEFAULT or BEST?
        - Doug: Used to be INTERP_UNKNOWN and would throw in evaluation.
        - Mark: FileTransform would work out of the box. I’ve never seen it 
          throw, and usually just give filepath.
        - Doug: Would get through YAML ok, but throw on processor.
        - Bernard: v1 initialized with UNKNOWN, perhaps YAML changes it?
        - Patrick: We will validate if v1 throws if it is UNKNOWN.
        - Michael: Same as Mark, never had to set it explicitly, maybe defaults 
          in YAML parse?
        - Mark: Think it defaults based on file type, 1D LUT, 3D LUT, CDL, etc.
        - Doug: Will comment on this issue to see what happens in v1 to explain 
          why behavior was what it was.
        - Michael: Should we switch DEFAULT behavior?
        - Mark: Seems odd to have DEFAULT and BEST, should just use BEST.
        - Bernard: Same as defaulting to faster exponent in SSL because faster.
        - Mark: In studio would pick tetrahedral every time.
        - Michael: Agree with Mark on quality. 3D LUTs are touchy so will take 
          any precision improvement we can get.
        - Doug: Agree tetrahedral is best. Just a question of whether we want 
          to make it default since its not usually the default.
        - Michael: Have we done extensive benchmarking?
        - Doug: On CPU tetrahedral is faster. On GPU it's a texture lookup. 
          Benchmarking on GPU is involved. Not opposed to tetrahedral default. 
          Do as separate PR. Want to get other eyes on it.
        - **TODO**: Mark will open issue about changing default interpolation 
          of 3D LUTs to tetrahedral (or BEST).
    - 1140 (process):
        - Michael: Doug and I have been working on revisions to this document. 
          Good to get more eyes on it if you have time.

* Open Source Project Management Discussion:
    - Carol: Talking on and off in doc meeting about ASWF/open source. At what 
      point does project get big enough to need project management. PMs help 
      keep organized and on track. There’s a balance between process that 
      creates more work and that that creates less work. Talking to PMs at 
      Netflix. Seeing things that could be useful for us without creating nag 
      structure putting more on our plates. Any thoughts about talking to 
      people about this? Would it be beneficial for our projects? Looking at 
      OCIO, but could be wider across ASWF.
    - Doug: Think its an interesting idea. Surprised this isn't already a 
      thing. Forging new ground, but worth exploring.
    - Mark: I don't think it would be good. Never heard a OSS project at scale 
      doing this. Think it would add democracy to already democratic process. 
      Should ask LF.
    - Carol: Have seen on this TSC that a few people spend a lot of time on 
      project management, but as we move toward releasing v2, the constancy of 
      our time may not be as full time long term. If we had process in place 
      that was not dependent on Patrick tagging issues and following up on PRs. 
      Interesting to here from patrick if that would be helpful.
    - Doug: Comment on Mark’s point about asking LF. We did ask and there isn't 
      a model to copy at this point. A lot in response to Thomas' issue about 
      transparency and a roadmap, etc. That was the why.
    - Carol: Yes, how can we make this easier. What is missing from what we do 
      internally at company. Obvious thing is project management. Not that 
      anyone hasn't done their job well. Realize project management can be boon 
      if done well.
    - Mark: Many OSS projects led by small group of developers rather than 
      committee. In case of OCIO, may not align with everyone's goals from 
      project. Some reason people don't know final goal is when features don't 
      align with what we were expecting. OCIO’s goals are wider now. More 
      needs to fill and goals to solve.
    - Carol: All of that makes the case for project management.
    - Mark: Think less bureaucracy is better. We haven't failed in mission to 
      achieve goals. Can see why when someone sees lots of PRs that don't 
      necessarily follow their world view, they would ask for clarification.
    - Doug: When Thomas wrote the issue, it wasn't opposed to specific feature, 
      just that it was being worked on without an issue having been created to 
      communicate it. If project manager had attended that working group 
      meeting, might have avoided the surprise. Project manager isn't there to 
      set roadmap, just to communicate what is being worked on and what is the 
      status. More of a communication type role.
    - Carol: Agree. Hard to picture what it would look like. Wanted to get 
      others take on it. Ok if the conclusion is that it's not helpful. Have 
      worked with great PMs that have helped achieve goals, which is cool.
    - Mark: Someone not knowing where an idea came from, ok to mention to that 
      person when it was decided. If they weren't at meeting.
    - Carol: Not saying anything is lacking, just looking for help and 
      improvement on what is already great.
    - Doug: Is part of agile development. If AD devs were doing work at AD, 
      would have agile workflow and team with scrum master. That's a 
      significant part of someone's job. Takes a lot of time. For OSS projects 
      it is just developers. No QA, doc, scrum person. Why is that? Because 
      it's developers showing up to work on these things, but when projects get 
      big enough, these roles might be more helpful.
    - Mark: It's different for AD devs since it is full time. For others it's 
      people scratching their own itch and contributing it back. Other projects 
      don't know goals, just hear that something new has been added. Don’t 
      think its necessary. Can be a mess of bureaucracy and fail. If not broken 
      don't fix it.
    - Patrick: Two aspects to consider. Example of grading. We forgot to create 
      issue early and someone outside of development could have commented that 
      we forgot it. Also helpful to know where we stand. Are we close to v2, is 
      documentation close, are Python bindings close? We don't have that. Not a 
      problem, but information isn't somewhere for people checking in on project. 
    - Mark: OSS projects - first thing to do is ask.
    - Carol: Is that the best way to do it? If it could be done without 
      bureaucracy, could it be an improvement? Could be en experiment. See 
      opportunity. Once project grows it becomes a product, which OCIO has. A 
      lot in industry depends on consistency, and project status is a positive.
    - Michael: Curious what a PM opinion would be. No commitment, but just to 
      get opinion.
    - Carol: Would probably want to be a fly on the wall for a while.
    - Michael: Even in consulting role would be helpful.
    - Carol: Yes, keeping accountable. Don't want to add more process.
    - Patrick: With projects and labels in GH we can do some project 
      management. Took time to put labels to help see trends and see what 
      remains to be done. We don't have what is missing, only what is done. 
      Thinking about the missing part; we could find something with low 
      overhead to have first version of project management.
    - Carol: Agree. What would we need to take what we have and make system 
      around it. Just needs a little work.
    - Michael: Added feature development project which could be home to some of 
      this.
    - Mei: Can get Thomas' input next week, to see what he is more concerned 
      with. Would be nice to talk to him about it. Can put on agenda.

* Meeting time change for NZ daylight savings:
    - Carl: Daylight savings, now is 9-10 am in NZ. Thomas and I may not be 
      able to make it. Could move meeting.
    - All: Ok with moving back an hour.
    - **TODO**: Carl will reach out of Thomas to verify time and Michael will 
      move meeting back one hour and update invites if helpful.
