[![Join the chat at https://gitter.im/OpenJPH](https://badges.gitter.im/OpenJPH.svg)](https://gitter.im/OpenJPH?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

# Readme #

Open source implementation of High-throughput JPEG2000 (HTJ2K), also known as JPH, JPEG2000 Part 15, ISO/IEC 15444-15, and ITU-T T.814. Here, we are interested in implementing the HTJ2K only, supporting features that are defined in JPEG2000 Part 1 (for example, for wavelet transform, only reversible 5/3 and irreversible 9/7 are supported).

The interested reader is referred to the [short HTJ2K white paper](http://ds.jpeg.org/whitepapers/jpeg-htj2k-whitepaper.pdf), or the [extended HTJ2K white paper](https://htj2k.com/wp-content/uploads/white-paper.pdf) for more details on HTJ2K. [This](https://kakadusoftware.com/wp-content/uploads/icip2019.pdf) paper explores the attainable performance on CPU, while [this](https://kakadusoftware.com/wp-content/uploads/ICIP2019_GPU.pdf) and [this](https://webapps.unsworks.library.unsw.edu.au/fapi/datastream/unsworks:75139/bin990339e4-8805-4456-ae30-223d85f9b1c1) explores performance on the GPU.

# The standard #

The standard is available free of charge from [ITU website](https://www.itu.int/rec/T-REC-T.814/en). It can also be purchased from the [ISO website](https://www.iso.org/standard/76621.html).

# Tabke of Contents #

* [Status](/docs/status.md)
* [Compiling](./docs/compiling.md)
* [Compiling and Running in Docker](./docs/docker.md)
* [Usage Example](./docs/usage_examples.md)
* [Web-based Demos](./docs/web_demos.md)
* [Doxygen Documentation Style](./docs/doxygen_style.md)