/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/RdGy.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 26, 26, 26, 255, 77, 77, 77, 255, 135, 135, 135, 255, 186, 186, 186, 255, 224, 224, 224, 255, 255, 255, 255, 255, 253, 219, 199, 255, 244, 165, 130, 255, 214, 96, 77, 255, 178, 24, 43, 255, 103, 0, 31, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdGy_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 26, 25, 26, 0, 26, 26, 26, 7, 26, 26, 26, 14, 27, 27, 27, 22, 27, 27, 27, 29, 28, 28, 28, 37, 28, 28, 28, 44, 29, 29, 29, 52, 29, 29, 29, 59, 30, 30, 30, 67, 30, 30, 30, 74, 31, 31, 31, 82, 31, 31, 31, 89, 31, 31, 31, 97, 32, 32, 32, 104, 32, 32, 32, 112, 33, 33, 33, 119, 33, 33, 33, 127, 34, 34, 34, 134, 34, 34, 34, 141, 35, 35, 35, 149, 35, 35, 35, 156, 36, 36, 36, 164, 36, 36, 36, 171, 37, 37, 37, 179, 37, 37, 37, 186, 38, 38, 38, 194, 38, 38, 38, 201, 39, 39, 39, 209, 39, 39, 39, 216, 40, 40, 40, 224, 40, 40, 40, 231, 41, 41, 41, 239, 41, 41, 41, 246, 41, 41, 41, 254, 42, 42, 42, 255, 42, 42, 42, 255, 43, 43, 43, 255, 43, 43, 43, 255, 44, 44, 44, 255, 44, 44, 44, 255, 45, 45, 45, 255, 45, 45, 45, 255, 46, 46, 46, 255, 46, 46, 46, 255, 47, 47, 47, 255, 47, 47, 47, 255, 48, 48, 48, 255, 48, 48, 48, 255, 49, 49, 49, 255, 49, 49, 49, 255, 50, 50, 50, 255, 50, 50, 50, 255, 51, 51, 51, 255, 51, 51, 51, 255, 52, 52, 52, 255, 52, 52, 52, 255, 53, 53, 53, 255, 53, 53, 53, 255, 54, 54, 54, 255, 54, 54, 54, 255, 55, 55, 55, 255, 55, 55, 55, 255, 56, 56, 56, 255, 56, 56, 56, 255, 57, 57, 57, 255, 57, 57, 57, 255, 58, 58, 58, 255, 58, 58, 58, 255, 59, 59, 59, 255, 60, 60, 60, 255, 60, 60, 60, 255, 61, 61, 61, 255, 61, 61, 61, 255, 62, 62, 62, 255, 62, 62, 62, 255, 63, 63, 63, 255, 63, 63, 63, 255, 64, 64, 64, 255, 64, 64, 64, 255, 65, 65, 65, 255, 65, 65, 65, 255, 66, 66, 66, 255, 66, 66, 66, 255, 67, 67, 67, 255, 67, 67, 67, 255, 68, 68, 68, 255, 68, 68, 68, 255, 69, 69, 69, 255, 69, 69, 69, 255, 70, 70, 70, 255, 70, 70, 70, 255, 71, 71, 71, 255, 71, 71, 71, 255, 72, 72, 72, 255, 73, 73, 73, 255, 73, 73, 73, 255, 74, 74, 74, 255, 74, 74, 74, 255, 75, 75, 75, 255, 75, 75, 75, 255, 76, 76, 76, 255, 76, 76, 76, 255, 77, 77, 77, 255, 77, 77, 77, 255, 78, 78, 78, 255, 78, 78, 78, 255, 79, 79, 79, 255, 80, 80, 80, 255, 80, 80, 80, 255, 81, 81, 81, 255, 81, 81, 81, 255, 82, 82, 82, 255, 82, 82, 82, 255, 83, 83, 83, 255, 83, 83, 83, 255, 84, 84, 84, 255, 84, 84, 84, 255, 85, 85, 85, 255, 86, 86, 86, 255, 86, 86, 86, 255, 87, 87, 87, 255, 87, 87, 87, 255, 88, 88, 88, 255, 88, 88, 88, 255, 89, 89, 89, 255, 89, 89, 89, 255, 90, 90, 90, 255, 90, 90, 90, 255, 91, 91, 91, 255, 92, 92, 92, 255, 92, 92, 92, 255, 93, 93, 93, 255, 93, 93, 93, 255, 94, 94, 94, 255, 94, 94, 94, 255, 95, 95, 95, 255, 95, 95, 95, 255, 96, 96, 96, 255, 97, 97, 97, 255, 97, 97, 97, 255, 98, 98, 98, 255, 98, 98, 98, 255, 99, 99, 99, 255, 99, 99, 99, 255, 100, 100, 100, 255, 100, 100, 100, 255, 101, 101, 101, 255, 102, 102, 102, 255, 102, 102, 102, 255, 103, 103, 103, 255, 103, 103, 103, 255, 104, 104, 104, 255, 104, 104, 104, 255, 105, 105, 105, 255, 106, 106, 106, 255, 106, 106, 106, 255, 107, 107, 107, 255, 107, 107, 107, 255, 108, 108, 108, 255, 108, 108, 108, 255, 109, 109, 109, 255, 110, 110, 110, 255, 110, 110, 110, 255, 111, 111, 111, 255, 111, 111, 111, 255, 112, 112, 112, 255, 112, 112, 112, 255, 113, 113, 113, 255, 114, 114, 114, 255, 114, 114, 114, 255, 115, 115, 115, 255, 115, 115, 115, 255, 116, 116, 116, 255, 116, 116, 116, 255, 117, 117, 117, 255, 118, 118, 118, 255, 118, 118, 118, 255, 119, 119, 119, 255, 119, 119, 119, 255, 120, 120, 120, 255, 121, 121, 121, 255, 121, 121, 121, 255, 122, 122, 122, 255, 122, 122, 122, 255, 123, 123, 123, 255, 123, 123, 123, 255, 124, 124, 124, 255, 125, 125, 125, 255, 125, 125, 125, 255, 126, 126, 126, 255, 126, 126, 126, 255, 127, 127, 127, 255, 128, 128, 128, 255, 128, 128, 128, 255, 129, 129, 129, 255, 129, 129, 129, 255, 130, 130, 130, 255, 130, 130, 130, 255, 131, 131, 131, 255, 132, 132, 132, 255, 132, 132, 132, 255, 133, 133, 133, 255, 133, 133, 133, 255, 134, 134, 134, 255, 135, 135, 135, 255, 135, 135, 135, 255, 136, 136, 136, 255, 136, 136, 136, 255, 137, 137, 137, 255, 137, 137, 137, 255, 138, 138, 138, 255, 138, 138, 138, 255, 138, 138, 138, 255, 139, 139, 139, 255, 139, 139, 139, 255, 140, 140, 140, 255, 140, 140, 140, 255, 141, 141, 141, 255, 141, 141, 141, 255, 142, 142, 142, 255, 142, 142, 142, 255, 143, 143, 143, 255, 143, 143, 143, 255, 144, 144, 144, 255, 144, 144, 144, 255, 145, 145, 145, 255, 145, 145, 145, 255, 146, 146, 146, 255, 146, 146, 146, 255, 147, 147, 147, 255, 147, 147, 147, 255, 148, 148, 148, 255, 148, 148, 148, 255, 149, 149, 149, 255, 149, 149, 149, 255, 150, 150, 150, 255, 150, 150, 150, 255, 151, 151, 151, 255, 151, 151, 151, 255, 152, 152, 152, 255, 152, 152, 152, 255, 153, 153, 153, 255, 153, 153, 153, 255, 154, 154, 154, 255, 154, 154, 154, 255, 155, 155, 155, 255, 155, 155, 155, 255, 156, 156, 156, 255, 156, 156, 156, 255, 157, 157, 157, 255, 157, 157, 157, 255, 158, 158, 158, 255, 158, 158, 158, 255, 159, 159, 159, 255, 159, 159, 159, 255, 160, 160, 160, 255, 160, 160, 160, 255, 161, 161, 161, 255, 161, 161, 161, 255, 162, 162, 162, 255, 162, 162, 162, 255, 163, 163, 163, 255, 163, 163, 163, 255, 164, 164, 164, 255, 164, 164, 164, 255, 165, 165, 165, 255, 165, 165, 165, 255, 166, 166, 166, 255, 166, 166, 166, 255, 167, 167, 167, 255, 167, 167, 167, 255, 168, 168, 168, 255, 168, 168, 168, 255, 169, 169, 169, 255, 169, 169, 169, 255, 170, 170, 170, 255, 170, 170, 170, 255, 171, 171, 171, 255, 171, 171, 171, 255, 172, 172, 172, 255, 172, 172, 172, 255, 173, 173, 173, 255, 173, 173, 173, 255, 174, 174, 174, 255, 174, 174, 174, 255, 175, 175, 175, 255, 175, 175, 175, 255, 176, 176, 176, 255, 176, 176, 176, 255, 177, 177, 177, 255, 177, 177, 177, 255, 178, 178, 178, 255, 178, 178, 178, 255, 179, 179, 179, 255, 179, 179, 179, 255, 180, 180, 180, 255, 180, 180, 180, 255, 181, 181, 181, 255, 181, 181, 181, 255, 182, 182, 182, 255, 182, 182, 182, 255, 183, 183, 183, 255, 183, 183, 183, 255, 184, 184, 184, 255, 184, 184, 184, 255, 185, 185, 185, 255, 185, 185, 185, 255, 186, 186, 186, 255, 186, 186, 186, 255, 187, 187, 187, 255, 187, 187, 187, 255, 187, 187, 187, 255, 188, 188, 188, 255, 188, 188, 188, 255, 188, 188, 188, 255, 189, 189, 189, 255, 189, 189, 189, 255, 189, 189, 189, 255, 190, 190, 190, 255, 190, 190, 190, 255, 191, 191, 191, 255, 191, 191, 191, 255, 191, 191, 191, 255, 192, 192, 192, 255, 192, 192, 192, 255, 192, 192, 192, 255, 193, 193, 193, 255, 193, 193, 193, 255, 193, 193, 193, 255, 194, 194, 194, 255, 194, 194, 194, 255, 195, 195, 195, 255, 195, 195, 195, 255, 195, 195, 195, 255, 196, 196, 196, 255, 196, 196, 196, 255, 196, 196, 196, 255, 197, 197, 197, 255, 197, 197, 197, 255, 198, 198, 198, 255, 198, 198, 198, 255, 198, 198, 198, 255, 199, 199, 199, 255, 199, 199, 199, 255, 199, 199, 199, 255, 200, 200, 200, 255, 200, 200, 200, 255, 200, 200, 200, 255, 201, 201, 201, 255, 201, 201, 201, 255, 202, 202, 202, 255, 202, 202, 202, 255, 202, 202, 202, 255, 203, 203, 203, 255, 203, 203, 203, 255, 203, 203, 203, 255, 204, 204, 204, 255, 204, 204, 204, 255, 205, 205, 205, 255, 205, 205, 205, 255, 205, 205, 205, 255, 206, 206, 206, 255, 206, 206, 206, 255, 206, 206, 206, 255, 207, 207, 207, 255, 207, 207, 207, 255, 208, 208, 208, 255, 208, 208, 208, 255, 208, 208, 208, 255, 209, 209, 209, 255, 209, 209, 209, 255, 209, 209, 209, 255, 210, 210, 210, 255, 210, 210, 210, 255, 211, 211, 211, 255, 211, 211, 211, 255, 211, 211, 211, 255, 212, 212, 212, 255, 212, 212, 212, 255, 212, 212, 212, 255, 213, 213, 213, 255, 213, 213, 213, 255, 214, 214, 214, 255, 214, 214, 214, 255, 214, 214, 214, 255, 215, 215, 215, 255, 215, 215, 215, 255, 215, 215, 215, 255, 216, 216, 216, 255, 216, 216, 216, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 218, 218, 218, 255, 218, 218, 218, 255, 218, 218, 218, 255, 219, 219, 219, 255, 219, 219, 219, 255, 220, 220, 220, 255, 220, 220, 220, 255, 220, 220, 220, 255, 221, 221, 221, 255, 221, 221, 221, 255, 221, 221, 221, 255, 222, 222, 222, 255, 222, 222, 222, 255, 223, 223, 223, 255, 223, 223, 223, 255, 223, 223, 223, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 225, 225, 225, 255, 225, 225, 225, 255, 225, 225, 225, 255, 225, 225, 225, 255, 226, 226, 226, 255, 226, 226, 226, 255, 226, 226, 226, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 228, 228, 228, 255, 228, 228, 228, 255, 228, 228, 228, 255, 228, 228, 228, 255, 229, 229, 229, 255, 229, 229, 229, 255, 229, 229, 229, 255, 230, 230, 230, 255, 230, 230, 230, 255, 230, 230, 230, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 232, 232, 232, 255, 232, 232, 232, 255, 232, 232, 232, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 234, 234, 234, 255, 234, 234, 234, 255, 234, 234, 234, 255, 234, 234, 234, 255, 235, 235, 235, 255, 235, 235, 235, 255, 235, 235, 235, 255, 236, 236, 236, 255, 236, 236, 236, 255, 236, 236, 236, 255, 237, 237, 237, 255, 237, 237, 237, 255, 237, 237, 237, 255, 237, 237, 237, 255, 238, 238, 238, 255, 238, 238, 238, 255, 238, 238, 238, 255, 239, 239, 239, 255, 239, 239, 239, 255, 239, 239, 239, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 240, 240, 240, 255, 241, 241, 241, 255, 241, 241, 241, 255, 241, 241, 241, 255, 242, 242, 242, 255, 242, 242, 242, 255, 242, 242, 242, 255, 243, 243, 243, 255, 243, 243, 243, 255, 243, 243, 243, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 245, 245, 245, 255, 245, 245, 245, 255, 245, 245, 245, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 249, 249, 249, 255, 249, 249, 249, 255, 249, 249, 249, 255, 250, 250, 250, 255, 250, 250, 250, 255, 250, 250, 250, 255, 251, 251, 251, 255, 251, 251, 251, 255, 251, 251, 251, 255, 251, 251, 251, 255, 252, 252, 252, 255, 252, 252, 252, 255, 252, 252, 252, 255, 253, 253, 253, 255, 253, 253, 253, 255, 253, 253, 253, 255, 254, 254, 254, 255, 254, 254, 254, 255, 254, 254, 254, 255, 255, 254, 255, 255, 255, 254, 254, 255, 255, 254, 254, 255, 255, 253, 254, 255, 255, 253, 253, 255, 255, 253, 253, 255, 255, 252, 253, 255, 255, 252, 252, 255, 255, 251, 252, 255, 255, 251, 252, 255, 255, 251, 251, 255, 255, 250, 251, 255, 255, 250, 251, 255, 255, 249, 250, 255, 255, 249, 250, 255, 255, 249, 250, 255, 255, 248, 249, 255, 255, 248, 249, 255, 255, 247, 248, 255, 255, 247, 248, 255, 255, 247, 248, 255, 255, 246, 247, 255, 255, 246, 247, 255, 255, 245, 246, 255, 255, 245, 246, 255, 255, 245, 245, 255, 255, 244, 245, 255, 255, 244, 245, 255, 255, 244, 244, 255, 255, 243, 244, 255, 255, 243, 243, 255, 255, 242, 243, 255, 255, 242, 242, 255, 255, 242, 242, 255, 255, 241, 241, 255, 255, 241, 241, 255, 255, 240, 240, 255, 255, 240, 240, 255, 255, 240, 239, 255, 255, 239, 239, 255, 255, 239, 238, 255, 255, 239, 238, 255, 255, 238, 237, 255, 255, 238, 237, 255, 255, 237, 236, 255, 255, 237, 236, 255, 255, 237, 235, 255, 255, 236, 235, 255, 255, 236, 234, 255, 255, 236, 233, 255, 255, 235, 233, 255, 255, 235, 232, 255, 255, 234, 232, 255, 255, 234, 231, 255, 255, 234, 231, 255, 255, 233, 230, 255, 255, 233, 229, 255, 255, 233, 229, 255, 255, 232, 228, 255, 255, 232, 228, 255, 255, 232, 227, 255, 255, 231, 226, 255, 255, 231, 226, 255, 255, 231, 225, 255, 255, 230, 224, 255, 255, 230, 224, 255, 255, 230, 223, 255, 255, 229, 223, 255, 255, 229, 222, 255, 255, 229, 221, 255, 255, 228, 221, 255, 255, 228, 220, 255, 255, 228, 219, 255, 255, 227, 219, 255, 255, 227, 218, 255, 255, 227, 217, 255, 255, 226, 217, 255, 255, 226, 216, 255, 255, 226, 215, 255, 255, 225, 215, 255, 255, 225, 214, 255, 255, 225, 213, 255, 255, 224, 213, 255, 255, 224, 212, 255, 255, 224, 211, 255, 255, 223, 211, 255, 255, 223, 210, 255, 255, 223, 209, 255, 255, 223, 209, 255, 255, 222, 208, 255, 255, 222, 207, 255, 255, 222, 207, 255, 255, 221, 206, 255, 255, 221, 205, 255, 254, 221, 204, 255, 254, 221, 204, 255, 254, 220, 203, 255, 254, 220, 202, 255, 254, 220, 202, 255, 253, 219, 201, 255, 253, 219, 200, 255, 253, 219, 199, 255, 253, 219, 199, 255, 252, 218, 198, 255, 252, 218, 197, 255, 252, 217, 197, 255, 252, 217, 196, 255, 252, 216, 195, 255, 252, 216, 194, 255, 252, 215, 194, 255, 252, 215, 193, 255, 252, 214, 192, 255, 252, 214, 192, 255, 252, 213, 191, 255, 252, 213, 190, 255, 252, 212, 189, 255, 252, 211, 189, 255, 251, 211, 188, 255, 251, 210, 187, 255, 251, 210, 186, 255, 251, 209, 186, 255, 251, 209, 185, 255, 251, 208, 184, 255, 251, 208, 184, 255, 251, 207, 183, 255, 251, 207, 182, 255, 251, 206, 182, 255, 251, 206, 181, 255, 251, 205, 180, 255, 251, 205, 179, 255, 250, 204, 179, 255, 250, 204, 178, 255, 250, 203, 177, 255, 250, 203, 177, 255, 250, 202, 176, 255, 250, 202, 175, 255, 250, 201, 175, 255, 250, 201, 174, 255, 250, 200, 173, 255, 250, 200, 172, 255, 250, 199, 172, 255, 250, 198, 171, 255, 249, 198, 170, 255, 249, 197, 170, 255, 249, 197, 169, 255, 249, 196, 168, 255, 249, 196, 168, 255, 249, 195, 167, 255, 249, 195, 166, 255, 249, 194, 166, 255, 249, 194, 165, 255, 249, 193, 164, 255, 249, 193, 164, 255, 249, 192, 163, 255, 248, 192, 162, 255, 248, 191, 162, 255, 248, 191, 161, 255, 248, 190, 160, 255, 248, 190, 160, 255, 248, 189, 159, 255, 248, 188, 158, 255, 248, 188, 158, 255, 248, 187, 157, 255, 248, 187, 156, 255, 248, 186, 156, 255, 247, 186, 155, 255, 247, 185, 154, 255, 247, 185, 154, 255, 247, 184, 153, 255, 247, 184, 152, 255, 247, 183, 152, 255, 247, 183, 151, 255, 247, 182, 150, 255, 247, 182, 150, 255, 247, 181, 149, 255, 247, 181, 148, 255, 246, 180, 148, 255, 246, 179, 147, 255, 246, 179, 146, 255, 246, 178, 146, 255, 246, 178, 145, 255, 246, 177, 144, 255, 246, 177, 144, 255, 246, 176, 143, 255, 246, 176, 143, 255, 246, 175, 142, 255, 245, 175, 141, 255, 245, 174, 141, 255, 245, 174, 140, 255, 245, 173, 139, 255, 245, 173, 139, 255, 245, 172, 138, 255, 245, 171, 137, 255, 245, 171, 137, 255, 245, 170, 136, 255, 245, 170, 136, 255, 244, 169, 135, 255, 244, 169, 134, 255, 244, 168, 134, 255, 244, 168, 133, 255, 244, 167, 132, 255, 244, 167, 132, 255, 244, 166, 131, 255, 244, 165, 131, 255, 244, 165, 130, 255, 243, 164, 129, 255, 243, 164, 129, 255, 243, 163, 128, 255, 243, 162, 128, 255, 242, 162, 127, 255, 242, 161, 126, 255, 242, 160, 126, 255, 241, 160, 125, 255, 241, 159, 125, 255, 241, 159, 124, 255, 241, 158, 123, 255, 240, 157, 123, 255, 240, 157, 122, 255, 240, 156, 122, 255, 240, 155, 121, 255, 239, 155, 120, 255, 239, 154, 120, 255, 239, 153, 119, 255, 238, 153, 119, 255, 238, 152, 118, 255, 238, 151, 118, 255, 238, 151, 117, 255, 237, 150, 116, 255, 237, 149, 116, 255, 237, 149, 115, 255, 236, 148, 115, 255, 236, 147, 114, 255, 236, 147, 114, 255, 236, 146, 113, 255, 235, 145, 113, 255, 235, 145, 112, 255, 235, 144, 111, 255, 234, 143, 111, 255, 234, 143, 110, 255, 234, 142, 110, 255, 234, 142, 109, 255, 233, 141, 109, 255, 233, 140, 108, 255, 233, 140, 108, 255, 232, 139, 107, 255, 232, 138, 106, 255, 232, 138, 106, 255, 232, 137, 105, 255, 231, 136, 105, 255, 231, 136, 104, 255, 231, 135, 104, 255, 230, 134, 103, 255, 230, 134, 103, 255, 230, 133, 102, 255, 230, 132, 102, 255, 229, 132, 101, 255, 229, 131, 101, 255, 229, 130, 100, 255, 228, 130, 100, 255, 228, 129, 99, 255, 228, 128, 99, 255, 227, 128, 98, 255, 227, 127, 98, 255, 227, 126, 97, 255, 227, 126, 97, 255, 226, 125, 96, 255, 226, 124, 96, 255, 226, 123, 95, 255, 225, 123, 95, 255, 225, 122, 94, 255, 225, 121, 94, 255, 225, 121, 93, 255, 224, 120, 93, 255, 224, 119, 92, 255, 224, 119, 92, 255, 223, 118, 91, 255, 223, 117, 91, 255, 223, 117, 90, 255, 222, 116, 90, 255, 222, 115, 89, 255, 222, 115, 89, 255, 222, 114, 88, 255, 221, 113, 88, 255, 221, 113, 87, 255, 221, 112, 87, 255, 220, 111, 86, 255, 220, 110, 86, 255, 220, 110, 85, 255, 219, 109, 85, 255, 219, 108, 85, 255, 219, 108, 84, 255, 219, 107, 84, 255, 218, 106, 83, 255, 218, 106, 83, 255, 218, 105, 82, 255, 217, 104, 82, 255, 217, 103, 81, 255, 217, 103, 81, 255, 216, 102, 80, 255, 216, 101, 80, 255, 216, 101, 80, 255, 215, 100, 79, 255, 215, 99, 79, 255, 215, 99, 78, 255, 214, 98, 78, 255, 214, 97, 77, 255, 214, 96, 77, 255, 214, 96, 77, 255, 213, 95, 76, 255, 213, 94, 76, 255, 213, 94, 75, 255, 212, 93, 75, 255, 212, 93, 75, 255, 212, 92, 74, 255, 211, 92, 74, 255, 211, 91, 74, 255, 210, 90, 73, 255, 210, 90, 73, 255, 210, 89, 72, 255, 209, 89, 72, 255, 209, 88, 72, 255, 209, 87, 71, 255, 208, 87, 71, 255, 208, 86, 71, 255, 208, 86, 70, 255, 207, 85, 70, 255, 207, 85, 70, 255, 207, 84, 69, 255, 206, 83, 69, 255, 206, 83, 68, 255, 206, 82, 68, 255, 205, 82, 68, 255, 205, 81, 67, 255, 205, 80, 67, 255, 204, 80, 67, 255, 204, 79, 66, 255, 204, 79, 66, 255, 203, 78, 66, 255, 203, 77, 65, 255, 203, 77, 65, 255, 202, 76, 65, 255, 202, 76, 64, 255, 202, 75, 64, 255, 201, 74, 64, 255, 201, 74, 63, 255, 200, 73, 63, 255, 200, 72, 63, 255, 200, 72, 62, 255, 199, 71, 62, 255, 199, 71, 61, 255, 199, 70, 61, 255, 198, 69, 61, 255, 198, 69, 60, 255, 198, 68, 60, 255, 197, 67, 60, 255, 197, 67, 59, 255, 197, 66, 59, 255, 196, 66, 59, 255, 196, 65, 58, 255, 196, 64, 58, 255, 195, 64, 58, 255, 195, 63, 57, 255, 195, 62, 57, 255, 194, 62, 57, 255, 194, 61, 56, 255, 193, 60, 56, 255, 193, 60, 56, 255, 193, 59, 55, 255, 192, 58, 55, 255, 192, 58, 55, 255, 192, 57, 55, 255, 191, 56, 54, 255, 191, 55, 54, 255, 191, 55, 54, 255, 190, 54, 53, 255, 190, 53, 53, 255, 190, 53, 53, 255, 189, 52, 52, 255, 189, 51, 52, 255, 189, 51, 52, 255, 188, 50, 51, 255, 188, 49, 51, 255, 187, 48, 51, 255, 187, 48, 50, 255, 187, 47, 50, 255, 186, 46, 50, 255, 186, 45, 49, 255, 186, 44, 49, 255, 185, 44, 49, 255, 185, 43, 49, 255, 185, 42, 48, 255, 184, 41, 48, 255, 184, 40, 48, 255, 184, 40, 47, 255, 183, 39, 47, 255, 183, 38, 47, 255, 182, 37, 46, 255, 182, 36, 46, 255, 182, 35, 46, 255, 181, 34, 46, 255, 181, 33, 45, 255, 181, 33, 45, 255, 180, 32, 45, 255, 180, 31, 44, 255, 180, 30, 44, 255, 179, 29, 44, 255, 179, 28, 44, 255, 178, 26, 43, 255, 178, 25, 43, 255, 178, 24, 43, 255, 177, 23, 42, 255, 176, 23, 42, 255, 176, 23, 42, 255, 175, 22, 42, 255, 174, 22, 42, 255, 174, 22, 42, 255, 173, 21, 42, 255, 172, 21, 42, 255, 171, 21, 42, 255, 171, 20, 42, 255, 170, 20, 42, 255, 169, 20, 42, 255, 168, 19, 42, 255, 168, 19, 42, 255, 167, 19, 42, 255, 166, 18, 41, 255, 165, 18, 41, 255, 165, 18, 41, 255, 164, 17, 41, 255, 163, 17, 41, 255, 162, 17, 41, 255, 162, 16, 41, 255, 161, 16, 41, 255, 160, 16, 41, 255, 159, 15, 41, 255, 159, 15, 41, 255, 158, 15, 41, 255, 157, 14, 40, 255, 156, 14, 40, 255, 156, 14, 40, 255, 155, 14, 40, 255, 154, 13, 40, 255, 154, 13, 40, 255, 153, 13, 40, 255, 152, 12, 40, 255, 151, 12, 40, 255, 151, 12, 40, 255, 150, 11, 40, 255, 149, 11, 39, 255, 148, 11, 39, 255, 148, 10, 39, 255, 147, 10, 39, 255, 146, 10, 39, 255, 145, 10, 39, 255, 145, 9, 39, 255, 144, 9, 39, 255, 143, 9, 39, 255, 142, 8, 38, 255, 142, 8, 38, 255, 141, 8, 38, 255, 140, 8, 38, 255, 140, 7, 38, 255, 139, 7, 38, 255, 138, 7, 38, 255, 137, 6, 38, 255, 137, 6, 37, 255, 136, 6, 37, 255, 135, 6, 37, 255, 134, 6, 37, 255, 134, 5, 37, 255, 133, 5, 37, 255, 132, 5, 37, 255, 131, 5, 37, 255, 131, 4, 36, 255, 130, 4, 36, 255, 129, 4, 36, 255, 129, 4, 36, 255, 128, 4, 36, 255, 127, 4, 36, 255, 126, 3, 36, 255, 126, 3, 36, 255, 125, 3, 35, 255, 124, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 122, 2, 35, 255, 121, 2, 35, 255, 121, 2, 35, 255, 120, 2, 34, 255, 119, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 117, 1, 34, 255, 116, 1, 34, 255, 115, 1, 33, 255, 115, 1, 33, 255, 114, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 112, 1, 33, 255, 111, 1, 33, 255, 110, 0, 32, 255, 110, 0, 32, 255, 109, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 107, 0, 32, 255, 106, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 104, 0, 31, 255, 103, 0, 31, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdGy_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 26, 25, 26, 0, 26, 26, 26, 7, 26, 26, 26, 14, 27, 27, 27, 22, 27, 27, 27, 29, 27, 27, 27, 37, 28, 28, 28, 44, 28, 28, 28, 52, 28, 28, 28, 59, 29, 29, 29, 67, 29, 29, 29, 74, 30, 30, 30, 82, 30, 30, 30, 89, 30, 30, 30, 97, 31, 31, 31, 104, 31, 31, 31, 112, 31, 31, 31, 119, 32, 32, 32, 127, 32, 32, 32, 134, 33, 33, 33, 141, 33, 33, 33, 149, 33, 33, 33, 156, 34, 34, 34, 164, 34, 34, 34, 171, 34, 34, 34, 179, 35, 35, 35, 186, 35, 35, 35, 194, 36, 36, 36, 201, 36, 36, 36, 209, 36, 36, 36, 216, 37, 37, 37, 224, 37, 37, 37, 231, 38, 38, 38, 239, 38, 38, 38, 246, 38, 38, 38, 254, 39, 39, 39, 255, 39, 39, 39, 255, 39, 39, 39, 255, 40, 40, 40, 255, 40, 40, 40, 255, 41, 41, 41, 255, 41, 41, 41, 255, 41, 41, 41, 255, 42, 42, 42, 255, 42, 42, 42, 255, 43, 43, 43, 255, 43, 43, 43, 255, 43, 43, 43, 255, 44, 44, 44, 255, 44, 44, 44, 255, 45, 45, 45, 255, 45, 45, 45, 255, 56, 56, 56, 255, 56, 56, 56, 255, 56, 56, 56, 255, 57, 57, 57, 255, 57, 57, 57, 255, 58, 58, 58, 255, 58, 58, 58, 255, 58, 58, 58, 255, 59, 59, 59, 255, 59, 59, 59, 255, 60, 60, 60, 255, 60, 60, 60, 255, 60, 60, 60, 255, 61, 61, 61, 255, 61, 61, 61, 255, 62, 62, 62, 255, 62, 62, 62, 255, 62, 62, 62, 255, 63, 63, 63, 255, 63, 63, 63, 255, 64, 64, 64, 255, 64, 64, 64, 255, 65, 65, 65, 255, 65, 65, 65, 255, 65, 65, 65, 255, 66, 66, 66, 255, 66, 66, 66, 255, 67, 67, 67, 255, 67, 67, 67, 255, 67, 67, 67, 255, 68, 68, 68, 255, 68, 68, 68, 255, 69, 69, 69, 255, 69, 69, 69, 255, 70, 70, 70, 255, 70, 70, 70, 255, 70, 70, 70, 255, 71, 71, 71, 255, 71, 71, 71, 255, 72, 72, 72, 255, 72, 72, 72, 255, 72, 72, 72, 255, 73, 73, 73, 255, 73, 73, 73, 255, 74, 74, 74, 255, 74, 74, 74, 255, 75, 75, 75, 255, 75, 75, 75, 255, 75, 75, 75, 255, 76, 76, 76, 255, 76, 76, 76, 255, 77, 77, 77, 255, 77, 77, 77, 255, 78, 78, 78, 255, 78, 78, 78, 255, 78, 78, 78, 255, 79, 79, 79, 255, 79, 79, 79, 255, 80, 80, 80, 255, 80, 80, 80, 255, 81, 81, 81, 255, 81, 81, 81, 255, 82, 82, 82, 255, 82, 82, 82, 255, 82, 82, 82, 255, 83, 83, 83, 255, 83, 83, 83, 255, 84, 84, 84, 255, 84, 84, 84, 255, 85, 85, 85, 255, 85, 85, 85, 255, 85, 85, 85, 255, 86, 86, 86, 255, 86, 86, 86, 255, 87, 87, 87, 255, 87, 87, 87, 255, 88, 88, 88, 255, 88, 88, 88, 255, 89, 89, 89, 255, 89, 89, 89, 255, 89, 89, 89, 255, 90, 90, 90, 255, 90, 90, 90, 255, 91, 91, 91, 255, 91, 91, 91, 255, 92, 92, 92, 255, 92, 92, 92, 255, 93, 93, 93, 255, 93, 93, 93, 255, 93, 93, 93, 255, 94, 94, 94, 255, 94, 94, 94, 255, 95, 95, 95, 255, 95, 95, 95, 255, 96, 96, 96, 255, 96, 96, 96, 255, 97, 97, 97, 255, 97, 97, 97, 255, 98, 98, 98, 255, 98, 98, 98, 255, 98, 98, 98, 255, 99, 99, 99, 255, 111, 111, 111, 255, 111, 111, 111, 255, 112, 112, 112, 255, 112, 112, 112, 255, 113, 113, 113, 255, 113, 113, 113, 255, 114, 114, 114, 255, 114, 114, 114, 255, 115, 115, 115, 255, 115, 115, 115, 255, 115, 115, 115, 255, 116, 116, 116, 255, 116, 116, 116, 255, 117, 117, 117, 255, 117, 117, 117, 255, 118, 118, 118, 255, 118, 118, 118, 255, 119, 119, 119, 255, 119, 119, 119, 255, 120, 120, 120, 255, 120, 120, 120, 255, 121, 121, 121, 255, 121, 121, 121, 255, 121, 121, 121, 255, 122, 122, 122, 255, 122, 122, 122, 255, 123, 123, 123, 255, 123, 123, 123, 255, 124, 124, 124, 255, 124, 124, 124, 255, 125, 125, 125, 255, 125, 125, 125, 255, 126, 126, 126, 255, 126, 126, 126, 255, 127, 127, 127, 255, 127, 127, 127, 255, 128, 128, 128, 255, 128, 128, 128, 255, 128, 128, 128, 255, 129, 129, 129, 255, 129, 129, 129, 255, 130, 130, 130, 255, 130, 130, 130, 255, 131, 131, 131, 255, 131, 131, 131, 255, 132, 132, 132, 255, 132, 132, 132, 255, 133, 133, 133, 255, 133, 133, 133, 255, 134, 134, 134, 255, 134, 134, 134, 255, 135, 135, 135, 255, 135, 135, 135, 255, 135, 135, 135, 255, 136, 136, 136, 255, 136, 136, 136, 255, 137, 137, 137, 255, 137, 137, 137, 255, 137, 137, 137, 255, 138, 138, 138, 255, 138, 138, 138, 255, 138, 138, 138, 255, 139, 139, 139, 255, 139, 139, 139, 255, 140, 140, 140, 255, 140, 140, 140, 255, 140, 140, 140, 255, 141, 141, 141, 255, 141, 141, 141, 255, 142, 142, 142, 255, 142, 142, 142, 255, 142, 142, 142, 255, 143, 143, 143, 255, 143, 143, 143, 255, 144, 144, 144, 255, 144, 144, 144, 255, 144, 144, 144, 255, 145, 145, 145, 255, 145, 145, 145, 255, 145, 145, 145, 255, 146, 146, 146, 255, 146, 146, 146, 255, 147, 147, 147, 255, 147, 147, 147, 255, 147, 147, 147, 255, 148, 148, 148, 255, 148, 148, 148, 255, 149, 149, 149, 255, 149, 149, 149, 255, 149, 149, 149, 255, 150, 150, 150, 255, 150, 150, 150, 255, 151, 151, 151, 255, 151, 151, 151, 255, 151, 151, 151, 255, 152, 152, 152, 255, 152, 152, 152, 255, 153, 153, 153, 255, 153, 153, 153, 255, 153, 153, 153, 255, 154, 154, 154, 255, 154, 154, 154, 255, 165, 165, 165, 255, 165, 165, 165, 255, 166, 166, 166, 255, 166, 166, 166, 255, 166, 166, 166, 255, 167, 167, 167, 255, 167, 167, 167, 255, 168, 168, 168, 255, 168, 168, 168, 255, 168, 168, 168, 255, 169, 169, 169, 255, 169, 169, 169, 255, 170, 170, 170, 255, 170, 170, 170, 255, 170, 170, 170, 255, 171, 171, 171, 255, 171, 171, 171, 255, 172, 172, 172, 255, 172, 172, 172, 255, 172, 172, 172, 255, 173, 173, 173, 255, 173, 173, 173, 255, 174, 174, 174, 255, 174, 174, 174, 255, 174, 174, 174, 255, 175, 175, 175, 255, 175, 175, 175, 255, 176, 176, 176, 255, 176, 176, 176, 255, 176, 176, 176, 255, 177, 177, 177, 255, 177, 177, 177, 255, 178, 178, 178, 255, 178, 178, 178, 255, 178, 178, 178, 255, 179, 179, 179, 255, 179, 179, 179, 255, 180, 180, 180, 255, 180, 180, 180, 255, 181, 181, 181, 255, 181, 181, 181, 255, 181, 181, 181, 255, 182, 182, 182, 255, 182, 182, 182, 255, 183, 183, 183, 255, 183, 183, 183, 255, 183, 183, 183, 255, 184, 184, 184, 255, 184, 184, 184, 255, 185, 185, 185, 255, 185, 185, 185, 255, 185, 185, 185, 255, 186, 186, 186, 255, 186, 186, 186, 255, 186, 186, 186, 255, 187, 187, 187, 255, 187, 187, 187, 255, 187, 187, 187, 255, 187, 187, 187, 255, 188, 188, 188, 255, 188, 188, 188, 255, 188, 188, 188, 255, 189, 189, 189, 255, 189, 189, 189, 255, 189, 189, 189, 255, 190, 190, 190, 255, 190, 190, 190, 255, 190, 190, 190, 255, 190, 190, 190, 255, 191, 191, 191, 255, 191, 191, 191, 255, 191, 191, 191, 255, 192, 192, 192, 255, 192, 192, 192, 255, 192, 192, 192, 255, 192, 192, 192, 255, 193, 193, 193, 255, 193, 193, 193, 255, 193, 193, 193, 255, 194, 194, 194, 255, 194, 194, 194, 255, 194, 194, 194, 255, 195, 195, 195, 255, 195, 195, 195, 255, 195, 195, 195, 255, 195, 195, 195, 255, 196, 196, 196, 255, 196, 196, 196, 255, 196, 196, 196, 255, 197, 197, 197, 255, 197, 197, 197, 255, 197, 197, 197, 255, 197, 197, 197, 255, 198, 198, 198, 255, 198, 198, 198, 255, 198, 198, 198, 255, 199, 199, 199, 255, 199, 199, 199, 255, 199, 199, 199, 255, 200, 200, 200, 255, 200, 200, 200, 255, 200, 200, 200, 255, 200, 200, 200, 255, 208, 208, 208, 255, 209, 209, 209, 255, 209, 209, 209, 255, 209, 209, 209, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 210, 210, 210, 255, 211, 211, 211, 255, 211, 211, 211, 255, 211, 211, 211, 255, 212, 212, 212, 255, 212, 212, 212, 255, 212, 212, 212, 255, 213, 213, 213, 255, 213, 213, 213, 255, 213, 213, 213, 255, 213, 213, 213, 255, 214, 214, 214, 255, 214, 214, 214, 255, 214, 214, 214, 255, 215, 215, 215, 255, 215, 215, 215, 255, 215, 215, 215, 255, 216, 216, 216, 255, 216, 216, 216, 255, 216, 216, 216, 255, 216, 216, 216, 255, 217, 217, 217, 255, 217, 217, 217, 255, 217, 217, 217, 255, 218, 218, 218, 255, 218, 218, 218, 255, 218, 218, 218, 255, 219, 219, 219, 255, 219, 219, 219, 255, 219, 219, 219, 255, 219, 219, 219, 255, 220, 220, 220, 255, 220, 220, 220, 255, 220, 220, 220, 255, 221, 221, 221, 255, 221, 221, 221, 255, 221, 221, 221, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 222, 222, 222, 255, 223, 223, 223, 255, 223, 223, 223, 255, 223, 223, 223, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 224, 224, 224, 255, 225, 225, 225, 255, 225, 225, 225, 255, 225, 225, 225, 255, 225, 225, 225, 255, 226, 226, 226, 255, 226, 226, 226, 255, 226, 226, 226, 255, 226, 226, 226, 255, 226, 226, 226, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 227, 227, 227, 255, 228, 228, 228, 255, 228, 228, 228, 255, 228, 228, 228, 255, 228, 228, 228, 255, 229, 229, 229, 255, 229, 229, 229, 255, 229, 229, 229, 255, 229, 229, 229, 255, 230, 230, 230, 255, 230, 230, 230, 255, 230, 230, 230, 255, 230, 230, 230, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 231, 231, 231, 255, 232, 232, 232, 255, 232, 232, 232, 255, 232, 232, 232, 255, 232, 232, 232, 255, 232, 232, 232, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 233, 233, 233, 255, 234, 234, 234, 255, 234, 234, 234, 255, 234, 234, 234, 255, 234, 234, 234, 255, 235, 235, 235, 255, 235, 235, 235, 255, 235, 235, 235, 255, 235, 235, 235, 255, 236, 236, 236, 255, 242, 242, 242, 255, 242, 242, 242, 255, 243, 243, 243, 255, 243, 243, 243, 255, 243, 243, 243, 255, 243, 243, 243, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 244, 244, 244, 255, 245, 245, 245, 255, 245, 245, 245, 255, 245, 245, 245, 255, 245, 245, 245, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 247, 247, 247, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 248, 248, 248, 255, 249, 249, 249, 255, 249, 249, 249, 255, 249, 249, 249, 255, 249, 249, 249, 255, 250, 250, 250, 255, 250, 250, 250, 255, 250, 250, 250, 255, 250, 250, 250, 255, 251, 251, 251, 255, 251, 251, 251, 255, 251, 251, 251, 255, 251, 251, 251, 255, 252, 252, 252, 255, 252, 252, 252, 255, 252, 252, 252, 255, 252, 252, 252, 255, 253, 253, 253, 255, 253, 253, 253, 255, 253, 253, 253, 255, 253, 253, 253, 255, 254, 254, 254, 255, 254, 254, 254, 255, 254, 254, 254, 255, 254, 254, 254, 255, 255, 254, 255, 255, 255, 254, 254, 255, 255, 254, 254, 255, 255, 254, 254, 255, 255, 253, 254, 255, 255, 253, 253, 255, 255, 253, 253, 255, 255, 252, 253, 255, 255, 252, 253, 255, 255, 252, 252, 255, 255, 251, 252, 255, 255, 251, 252, 255, 255, 251, 251, 255, 255, 250, 251, 255, 255, 250, 251, 255, 255, 250, 251, 255, 255, 249, 250, 255, 255, 249, 250, 255, 255, 249, 250, 255, 255, 249, 249, 255, 255, 248, 249, 255, 255, 248, 249, 255, 255, 248, 248, 255, 255, 247, 248, 255, 255, 247, 248, 255, 255, 247, 247, 255, 255, 246, 247, 255, 255, 246, 247, 255, 255, 246, 246, 255, 255, 245, 246, 255, 255, 245, 245, 255, 255, 245, 245, 255, 255, 244, 245, 255, 255, 244, 244, 255, 255, 244, 244, 255, 255, 244, 244, 255, 255, 243, 243, 255, 255, 243, 243, 255, 255, 243, 242, 255, 255, 242, 242, 255, 255, 242, 242, 255, 255, 242, 241, 255, 255, 241, 241, 255, 255, 241, 240, 255, 255, 241, 240, 255, 255, 241, 239, 255, 255, 240, 239, 255, 255, 240, 239, 255, 255, 240, 238, 255, 255, 239, 238, 255, 255, 239, 237, 255, 255, 239, 237, 255, 254, 231, 225, 255, 254, 231, 225, 255, 254, 231, 224, 255, 254, 230, 224, 255, 254, 230, 223, 255, 254, 230, 223, 255, 254, 230, 222, 255, 254, 229, 222, 255, 254, 229, 221, 255, 254, 229, 221, 255, 254, 228, 220, 255, 254, 228, 220, 255, 254, 228, 219, 255, 254, 228, 219, 255, 254, 227, 218, 255, 254, 227, 218, 255, 254, 227, 217, 255, 254, 227, 217, 255, 254, 226, 216, 255, 254, 226, 216, 255, 254, 226, 215, 255, 254, 225, 215, 255, 254, 225, 214, 255, 254, 225, 214, 255, 254, 225, 213, 255, 254, 224, 213, 255, 254, 224, 212, 255, 254, 224, 211, 255, 254, 224, 211, 255, 254, 223, 210, 255, 254, 223, 210, 255, 254, 223, 209, 255, 254, 223, 209, 255, 254, 222, 208, 255, 254, 222, 208, 255, 254, 222, 207, 255, 254, 222, 207, 255, 254, 221, 206, 255, 254, 221, 205, 255, 254, 221, 205, 255, 254, 221, 204, 255, 254, 221, 204, 255, 254, 220, 203, 255, 254, 220, 203, 255, 254, 220, 202, 255, 253, 220, 202, 255, 253, 219, 201, 255, 253, 219, 200, 255, 253, 219, 200, 255, 253, 219, 199, 255, 253, 219, 199, 255, 252, 218, 198, 255, 252, 218, 198, 255, 252, 217, 197, 255, 252, 217, 196, 255, 252, 217, 196, 255, 252, 216, 195, 255, 252, 216, 195, 255, 252, 215, 194, 255, 252, 215, 193, 255, 252, 215, 193, 255, 252, 214, 192, 255, 252, 214, 192, 255, 252, 213, 191, 255, 252, 213, 191, 255, 252, 212, 190, 255, 252, 212, 189, 255, 252, 212, 189, 255, 251, 211, 188, 255, 251, 211, 188, 255, 251, 210, 187, 255, 251, 210, 187, 255, 251, 210, 186, 255, 251, 209, 185, 255, 251, 209, 185, 255, 251, 208, 184, 255, 251, 208, 184, 255, 251, 207, 183, 255, 251, 207, 183, 255, 251, 207, 182, 255, 251, 206, 182, 255, 251, 206, 181, 255, 251, 205, 180, 255, 251, 205, 180, 255, 250, 205, 179, 255, 250, 204, 179, 255, 250, 204, 178, 255, 250, 203, 178, 255, 250, 203, 177, 255, 250, 202, 177, 255, 250, 202, 176, 255, 250, 202, 175, 255, 250, 201, 175, 255, 250, 201, 174, 255, 250, 200, 174, 255, 250, 200, 173, 255, 250, 200, 173, 255, 250, 199, 172, 255, 250, 199, 172, 255, 249, 198, 171, 255, 249, 198, 171, 255, 249, 197, 170, 255, 247, 186, 156, 255, 247, 186, 155, 255, 247, 185, 155, 255, 247, 185, 154, 255, 247, 185, 154, 255, 247, 184, 153, 255, 247, 184, 152, 255, 247, 183, 152, 255, 247, 183, 151, 255, 247, 182, 151, 255, 247, 182, 150, 255, 247, 182, 150, 255, 247, 181, 149, 255, 247, 181, 149, 255, 246, 180, 148, 255, 246, 180, 148, 255, 246, 179, 147, 255, 246, 179, 147, 255, 246, 179, 146, 255, 246, 178, 146, 255, 246, 178, 145, 255, 246, 177, 145, 255, 246, 177, 144, 255, 246, 176, 144, 255, 246, 176, 143, 255, 246, 176, 142, 255, 246, 175, 142, 255, 245, 175, 141, 255, 245, 174, 141, 255, 245, 174, 140, 255, 245, 173, 140, 255, 245, 173, 139, 255, 245, 173, 139, 255, 245, 172, 138, 255, 245, 172, 138, 255, 245, 171, 137, 255, 245, 171, 137, 255, 245, 170, 136, 255, 245, 170, 136, 255, 244, 170, 135, 255, 244, 169, 135, 255, 244, 169, 134, 255, 244, 168, 134, 255, 244, 168, 133, 255, 244, 167, 133, 255, 244, 167, 132, 255, 244, 167, 132, 255, 244, 166, 131, 255, 244, 166, 131, 255, 244, 165, 130, 255, 244, 165, 130, 255, 243, 164, 129, 255, 243, 164, 129, 255, 243, 163, 128, 255, 243, 163, 128, 255, 243, 162, 127, 255, 242, 162, 127, 255, 242, 161, 127, 255, 242, 161, 126, 255, 242, 160, 126, 255, 241, 160, 125, 255, 241, 159, 125, 255, 241, 159, 124, 255, 241, 158, 124, 255, 241, 158, 123, 255, 240, 157, 123, 255, 240, 157, 122, 255, 240, 156, 122, 255, 240, 156, 121, 255, 239, 155, 121, 255, 239, 155, 120, 255, 239, 154, 120, 255, 239, 153, 120, 255, 239, 153, 119, 255, 238, 152, 119, 255, 238, 152, 118, 255, 238, 151, 118, 255, 238, 151, 117, 255, 237, 150, 117, 255, 237, 150, 116, 255, 237, 149, 116, 255, 237, 149, 115, 255, 236, 148, 115, 255, 236, 148, 115, 255, 236, 147, 114, 255, 236, 147, 114, 255, 236, 146, 113, 255, 235, 146, 113, 255, 235, 145, 112, 255, 235, 145, 112, 255, 235, 144, 112, 255, 234, 143, 111, 255, 234, 143, 111, 255, 234, 142, 110, 255, 234, 142, 110, 255, 233, 141, 109, 255, 233, 141, 109, 255, 233, 140, 109, 255, 233, 140, 108, 255, 233, 139, 108, 255, 232, 139, 107, 255, 232, 138, 107, 255, 226, 124, 96, 255, 226, 123, 95, 255, 225, 123, 95, 255, 225, 122, 95, 255, 225, 122, 94, 255, 225, 121, 94, 255, 224, 121, 93, 255, 224, 120, 93, 255, 224, 120, 93, 255, 224, 119, 92, 255, 224, 118, 92, 255, 223, 118, 91, 255, 223, 117, 91, 255, 223, 117, 91, 255, 223, 116, 90, 255, 222, 116, 90, 255, 222, 115, 89, 255, 222, 115, 89, 255, 222, 114, 89, 255, 221, 114, 88, 255, 221, 113, 88, 255, 221, 112, 87, 255, 221, 112, 87, 255, 220, 111, 87, 255, 220, 111, 86, 255, 220, 110, 86, 255, 220, 110, 86, 255, 219, 109, 85, 255, 219, 109, 85, 255, 219, 108, 84, 255, 219, 107, 84, 255, 218, 107, 84, 255, 218, 106, 83, 255, 218, 106, 83, 255, 218, 105, 83, 255, 218, 105, 82, 255, 217, 104, 82, 255, 217, 104, 81, 255, 217, 103, 81, 255, 217, 102, 81, 255, 216, 102, 80, 255, 216, 101, 80, 255, 216, 101, 80, 255, 216, 100, 79, 255, 215, 100, 79, 255, 215, 99, 79, 255, 215, 98, 78, 255, 215, 98, 78, 255, 214, 97, 78, 255, 214, 97, 77, 255, 214, 96, 77, 255, 214, 96, 77, 255, 213, 95, 76, 255, 213, 95, 76, 255, 213, 94, 76, 255, 212, 94, 75, 255, 212, 93, 75, 255, 212, 93, 75, 255, 212, 92, 74, 255, 211, 92, 74, 255, 211, 91, 74, 255, 211, 91, 74, 255, 211, 91, 73, 255, 210, 90, 73, 255, 210, 90, 73, 255, 210, 89, 72, 255, 209, 89, 72, 255, 209, 88, 72, 255, 209, 88, 72, 255, 209, 87, 71, 255, 208, 87, 71, 255, 208, 86, 71, 255, 208, 86, 70, 255, 208, 85, 70, 255, 207, 85, 70, 255, 207, 84, 70, 255, 207, 84, 69, 255, 206, 83, 69, 255, 206, 83, 69, 255, 206, 82, 68, 255, 206, 82, 68, 255, 205, 81, 68, 255, 205, 81, 68, 255, 205, 81, 67, 255, 204, 80, 67, 255, 204, 80, 67, 255, 204, 79, 66, 255, 204, 79, 66, 255, 203, 78, 66, 255, 203, 78, 66, 255, 203, 77, 65, 255, 203, 77, 65, 255, 202, 76, 65, 255, 202, 76, 64, 255, 202, 75, 64, 255, 201, 75, 64, 255, 201, 74, 64, 255, 201, 74, 63, 255, 201, 73, 63, 255, 200, 73, 63, 255, 200, 72, 63, 255, 200, 72, 62, 255, 199, 71, 62, 255, 192, 56, 55, 255, 192, 56, 55, 255, 191, 55, 54, 255, 191, 54, 54, 255, 191, 54, 54, 255, 191, 53, 54, 255, 190, 53, 53, 255, 190, 52, 53, 255, 190, 52, 53, 255, 189, 51, 53, 255, 189, 51, 52, 255, 189, 50, 52, 255, 189, 50, 52, 255, 188, 49, 52, 255, 188, 49, 51, 255, 188, 48, 51, 255, 187, 47, 51, 255, 187, 47, 51, 255, 187, 46, 50, 255, 187, 46, 50, 255, 186, 45, 50, 255, 186, 45, 50, 255, 186, 44, 49, 255, 185, 43, 49, 255, 185, 43, 49, 255, 185, 42, 49, 255, 185, 42, 48, 255, 184, 41, 48, 255, 184, 40, 48, 255, 184, 40, 48, 255, 183, 39, 47, 255, 183, 38, 47, 255, 183, 38, 47, 255, 183, 37, 47, 255, 182, 36, 46, 255, 182, 36, 46, 255, 182, 35, 46, 255, 181, 34, 46, 255, 181, 34, 45, 255, 181, 33, 45, 255, 181, 32, 45, 255, 180, 31, 45, 255, 180, 31, 44, 255, 180, 30, 44, 255, 179, 29, 44, 255, 179, 28, 44, 255, 179, 28, 44, 255, 179, 27, 43, 255, 178, 26, 43, 255, 178, 25, 43, 255, 178, 24, 43, 255, 177, 23, 42, 255, 177, 23, 42, 255, 176, 23, 42, 255, 175, 23, 42, 255, 175, 22, 42, 255, 174, 22, 42, 255, 174, 22, 42, 255, 173, 21, 42, 255, 173, 21, 42, 255, 172, 21, 42, 255, 171, 21, 42, 255, 171, 20, 42, 255, 170, 20, 42, 255, 170, 20, 42, 255, 169, 20, 42, 255, 168, 19, 42, 255, 168, 19, 42, 255, 167, 19, 42, 255, 167, 19, 42, 255, 166, 18, 41, 255, 165, 18, 41, 255, 165, 18, 41, 255, 164, 18, 41, 255, 164, 17, 41, 255, 163, 17, 41, 255, 162, 17, 41, 255, 162, 17, 41, 255, 161, 16, 41, 255, 161, 16, 41, 255, 160, 16, 41, 255, 160, 16, 41, 255, 159, 15, 41, 255, 158, 15, 41, 255, 158, 15, 40, 255, 157, 15, 40, 255, 157, 14, 40, 255, 156, 14, 40, 255, 155, 14, 40, 255, 155, 14, 40, 255, 154, 13, 40, 255, 154, 13, 40, 255, 153, 13, 40, 255, 152, 13, 40, 255, 152, 12, 40, 255, 151, 12, 40, 255, 151, 12, 39, 255, 150, 12, 39, 255, 149, 11, 39, 255, 149, 11, 39, 255, 148, 11, 39, 255, 148, 11, 39, 255, 132, 6, 36, 255, 132, 5, 36, 255, 131, 5, 36, 255, 130, 5, 36, 255, 130, 5, 36, 255, 129, 5, 36, 255, 129, 5, 36, 255, 128, 4, 36, 255, 127, 4, 36, 255, 127, 4, 36, 255, 126, 4, 35, 255, 126, 4, 35, 255, 125, 3, 35, 255, 125, 3, 35, 255, 124, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 122, 3, 35, 255, 122, 3, 35, 255, 121, 2, 35, 255, 120, 2, 34, 255, 120, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 117, 2, 34, 255, 116, 1, 34, 255, 116, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 114, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 111, 1, 32, 255, 111, 0, 32, 255, 110, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 107, 0, 32, 255, 107, 0, 31, 255, 106, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 103, 0, 31, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdGy_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 26, 25, 26, 0, 29, 29, 29, 24, 33, 33, 33, 49, 37, 37, 37, 74, 40, 40, 40, 99, 44, 44, 44, 124, 58, 58, 58, 149, 62, 62, 62, 174, 66, 66, 66, 199, 70, 70, 70, 224, 74, 74, 74, 249, 78, 78, 78, 255, 81, 81, 81, 255, 85, 85, 85, 255, 89, 89, 89, 255, 93, 93, 93, 255, 97, 97, 97, 255, 113, 113, 113, 255, 117, 117, 117, 255, 120, 120, 120, 255, 124, 124, 124, 255, 128, 128, 128, 255, 132, 132, 132, 255, 136, 136, 136, 255, 139, 139, 139, 255, 142, 142, 142, 255, 145, 145, 145, 255, 148, 148, 148, 255, 151, 151, 151, 255, 154, 154, 154, 255, 168, 168, 168, 255, 171, 171, 171, 255, 174, 174, 174, 255, 177, 177, 177, 255, 180, 180, 180, 255, 183, 183, 183, 255, 186, 186, 186, 255, 188, 188, 188, 255, 190, 190, 190, 255, 192, 192, 192, 255, 194, 194, 194, 255, 196, 196, 196, 255, 198, 198, 198, 255, 200, 200, 200, 255, 210, 210, 210, 255, 212, 212, 212, 255, 214, 214, 214, 255, 216, 216, 216, 255, 218, 218, 218, 255, 220, 220, 220, 255, 222, 222, 222, 255, 224, 224, 224, 255, 225, 225, 225, 255, 227, 227, 227, 255, 228, 228, 228, 255, 229, 229, 229, 255, 231, 231, 231, 255, 232, 232, 232, 255, 234, 234, 234, 255, 235, 235, 235, 255, 243, 243, 243, 255, 244, 244, 244, 255, 246, 246, 246, 255, 247, 247, 247, 255, 248, 248, 248, 255, 250, 250, 250, 255, 251, 251, 251, 255, 252, 252, 252, 255, 254, 254, 254, 255, 255, 254, 254, 255, 255, 252, 253, 255, 255, 250, 251, 255, 255, 249, 250, 255, 255, 247, 248, 255, 255, 246, 246, 255, 255, 244, 244, 255, 255, 243, 242, 255, 255, 241, 240, 255, 255, 240, 238, 255, 254, 231, 225, 255, 254, 230, 222, 255, 254, 228, 220, 255, 254, 227, 217, 255, 254, 226, 215, 255, 254, 224, 213, 255, 254, 223, 210, 255, 254, 222, 208, 255, 254, 221, 205, 255, 254, 220, 203, 255, 253, 219, 200, 255, 252, 218, 198, 255, 252, 216, 195, 255, 252, 214, 193, 255, 252, 213, 190, 255, 251, 211, 188, 255, 251, 209, 185, 255, 251, 207, 183, 255, 251, 206, 181, 255, 250, 204, 178, 255, 250, 202, 176, 255, 250, 201, 174, 255, 250, 199, 172, 255, 249, 197, 170, 255, 247, 185, 154, 255, 247, 183, 152, 255, 247, 182, 150, 255, 246, 180, 148, 255, 246, 178, 146, 255, 246, 177, 144, 255, 246, 175, 142, 255, 245, 174, 140, 255, 245, 172, 138, 255, 245, 171, 137, 255, 244, 169, 135, 255, 244, 168, 133, 255, 244, 166, 131, 255, 244, 165, 130, 255, 243, 163, 128, 255, 242, 161, 127, 255, 241, 160, 125, 255, 241, 158, 123, 255, 240, 156, 122, 255, 239, 155, 120, 255, 238, 153, 119, 255, 238, 151, 118, 255, 237, 150, 116, 255, 236, 148, 115, 255, 236, 146, 113, 255, 235, 145, 112, 255, 234, 143, 111, 255, 234, 142, 110, 255, 233, 140, 108, 255, 232, 138, 107, 255, 226, 123, 95, 255, 225, 122, 94, 255, 224, 120, 93, 255, 224, 119, 92, 255, 223, 117, 91, 255, 222, 116, 90, 255, 222, 114, 89, 255, 221, 113, 88, 255, 220, 111, 87, 255, 220, 110, 86, 255, 219, 108, 85, 255, 218, 107, 84, 255, 218, 106, 83, 255, 217, 104, 82, 255, 217, 103, 81, 255, 216, 101, 80, 255, 215, 100, 79, 255, 215, 99, 78, 255, 214, 97, 77, 255, 214, 96, 77, 255, 213, 95, 76, 255, 212, 94, 75, 255, 212, 93, 75, 255, 211, 91, 74, 255, 211, 90, 73, 255, 210, 89, 73, 255, 209, 88, 72, 255, 209, 87, 71, 255, 208, 86, 71, 255, 208, 85, 70, 255, 207, 84, 69, 255, 206, 83, 69, 255, 206, 82, 68, 255, 205, 81, 68, 255, 205, 80, 67, 255, 204, 79, 67, 255, 204, 78, 66, 255, 203, 77, 65, 255, 202, 76, 65, 255, 202, 75, 64, 255, 201, 75, 64, 255, 201, 74, 63, 255, 200, 73, 63, 255, 200, 72, 62, 255, 192, 56, 55, 255, 192, 55, 55, 255, 191, 54, 54, 255, 191, 54, 54, 255, 190, 53, 53, 255, 190, 52, 53, 255, 189, 51, 52, 255, 189, 50, 52, 255, 188, 49, 52, 255, 188, 48, 51, 255, 187, 47, 51, 255, 187, 46, 50, 255, 186, 45, 50, 255, 186, 44, 49, 255, 185, 43, 49, 255, 185, 42, 49, 255, 185, 41, 48, 255, 184, 40, 48, 255, 184, 40, 48, 255, 183, 39, 47, 255, 183, 38, 47, 255, 182, 37, 46, 255, 182, 36, 46, 255, 182, 35, 46, 255, 181, 34, 45, 255, 181, 33, 45, 255, 180, 32, 45, 255, 180, 31, 44, 255, 180, 30, 44, 255, 179, 29, 44, 255, 179, 28, 44, 255, 178, 26, 43, 255, 178, 25, 43, 255, 178, 24, 43, 255, 177, 23, 42, 255, 176, 23, 42, 255, 176, 23, 42, 255, 175, 22, 42, 255, 174, 22, 42, 255, 174, 22, 42, 255, 173, 21, 42, 255, 172, 21, 42, 255, 172, 21, 42, 255, 171, 20, 42, 255, 170, 20, 42, 255, 170, 20, 42, 255, 169, 20, 42, 255, 168, 19, 42, 255, 168, 19, 42, 255, 167, 19, 42, 255, 166, 18, 41, 255, 166, 18, 41, 255, 165, 18, 41, 255, 165, 18, 41, 255, 164, 17, 41, 255, 163, 17, 41, 255, 163, 17, 41, 255, 162, 17, 41, 255, 162, 16, 41, 255, 161, 16, 41, 255, 160, 16, 41, 255, 160, 16, 41, 255, 159, 15, 41, 255, 159, 15, 41, 255, 158, 15, 41, 255, 158, 15, 40, 255, 157, 15, 40, 255, 157, 14, 40, 255, 156, 14, 40, 255, 156, 14, 40, 255, 155, 14, 40, 255, 155, 14, 40, 255, 154, 13, 40, 255, 154, 13, 40, 255, 153, 13, 40, 255, 153, 13, 40, 255, 152, 13, 40, 255, 152, 12, 40, 255, 151, 12, 40, 255, 151, 12, 39, 255, 151, 12, 39, 255, 150, 12, 39, 255, 150, 11, 39, 255, 149, 11, 39, 255, 149, 11, 39, 255, 148, 11, 39, 255, 148, 11, 39, 255, 148, 11, 39, 255, 147, 11, 39, 255, 132, 6, 36, 255, 131, 5, 36, 255, 131, 5, 36, 255, 131, 5, 36, 255, 130, 5, 36, 255, 130, 5, 36, 255, 130, 5, 36, 255, 129, 5, 36, 255, 129, 5, 36, 255, 129, 4, 36, 255, 128, 4, 36, 255, 128, 4, 36, 255, 128, 4, 36, 255, 127, 4, 36, 255, 127, 4, 36, 255, 127, 4, 36, 255, 126, 4, 35, 255, 126, 4, 35, 255, 126, 4, 35, 255, 125, 4, 35, 255, 125, 3, 35, 255, 125, 3, 35, 255, 124, 3, 35, 255, 124, 3, 35, 255, 124, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 123, 3, 35, 255, 122, 3, 35, 255, 122, 3, 35, 255, 122, 3, 35, 255, 121, 3, 35, 255, 121, 3, 35, 255, 121, 2, 35, 255, 121, 2, 34, 255, 120, 2, 34, 255, 120, 2, 34, 255, 120, 2, 34, 255, 120, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 119, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 118, 2, 34, 255, 117, 2, 34, 255, 117, 2, 34, 255, 117, 2, 34, 255, 117, 2, 34, 255, 117, 2, 34, 255, 116, 1, 34, 255, 116, 1, 34, 255, 116, 1, 34, 255, 116, 1, 33, 255, 116, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 115, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 114, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 113, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 112, 1, 33, 255, 111, 1, 33, 255, 111, 1, 33, 255, 111, 1, 33, 255, 111, 1, 32, 255, 111, 1, 32, 255, 111, 1, 32, 255, 111, 0, 32, 255, 111, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 110, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 109, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 108, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 32, 255, 107, 0, 31, 255, 107, 0, 31, 255, 107, 0, 31, 255, 107, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 106, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 105, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 104, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 31, 255, 103, 0, 30, 255, 103, 0, 30, 255, 103, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255, 102, 0, 30, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdGy_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
