/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/PuBu.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 2, 56, 88, 255, 4, 90, 141, 255, 5, 112, 176, 255, 54, 144, 192, 255, 116, 169, 207, 255, 166, 189, 219, 255, 208, 209, 230, 255, 236, 231, 242, 255, 255, 247, 251, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuBu_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 2, 55, 88, 0, 1, 56, 88, 7, 1, 56, 88, 14, 1, 56, 89, 22, 1, 57, 89, 29, 1, 57, 89, 37, 1, 57, 90, 44, 1, 57, 90, 52, 1, 58, 91, 59, 1, 58, 91, 67, 1, 58, 91, 74, 1, 58, 92, 82, 1, 59, 92, 89, 1, 59, 93, 97, 1, 59, 93, 104, 1, 59, 93, 112, 1, 60, 94, 119, 1, 60, 94, 127, 1, 60, 95, 134, 1, 60, 95, 141, 1, 61, 95, 149, 1, 61, 96, 156, 1, 61, 96, 164, 1, 61, 97, 171, 1, 62, 97, 179, 1, 62, 97, 186, 1, 62, 98, 194, 1, 62, 98, 201, 1, 63, 99, 209, 1, 63, 99, 216, 1, 63, 100, 224, 1, 64, 100, 231, 1, 64, 100, 239, 1, 64, 101, 246, 1, 64, 101, 254, 1, 65, 102, 255, 1, 65, 102, 255, 1, 65, 102, 255, 1, 65, 103, 255, 1, 66, 103, 255, 1, 66, 104, 255, 1, 66, 104, 255, 1, 66, 104, 255, 1, 67, 105, 255, 1, 67, 105, 255, 1, 67, 106, 255, 1, 67, 106, 255, 1, 68, 106, 255, 1, 68, 107, 255, 1, 68, 107, 255, 1, 69, 108, 255, 1, 69, 108, 255, 1, 69, 108, 255, 1, 69, 109, 255, 1, 70, 109, 255, 1, 70, 110, 255, 1, 70, 110, 255, 1, 70, 111, 255, 1, 71, 111, 255, 1, 71, 111, 255, 1, 71, 112, 255, 1, 71, 112, 255, 1, 72, 113, 255, 1, 72, 113, 255, 1, 72, 113, 255, 1, 72, 114, 255, 1, 73, 114, 255, 1, 73, 115, 255, 1, 73, 115, 255, 1, 74, 116, 255, 1, 74, 116, 255, 1, 74, 116, 255, 1, 74, 117, 255, 1, 75, 117, 255, 2, 75, 118, 255, 2, 75, 118, 255, 2, 75, 118, 255, 2, 76, 119, 255, 2, 76, 119, 255, 2, 76, 120, 255, 2, 76, 120, 255, 2, 77, 121, 255, 2, 77, 121, 255, 2, 77, 121, 255, 2, 78, 122, 255, 2, 78, 122, 255, 2, 78, 123, 255, 2, 78, 123, 255, 2, 79, 123, 255, 2, 79, 124, 255, 2, 79, 124, 255, 2, 79, 125, 255, 2, 80, 125, 255, 2, 80, 126, 255, 2, 80, 126, 255, 2, 81, 126, 255, 2, 81, 127, 255, 2, 81, 127, 255, 2, 81, 128, 255, 2, 82, 128, 255, 2, 82, 129, 255, 2, 82, 129, 255, 2, 82, 129, 255, 2, 83, 130, 255, 2, 83, 130, 255, 2, 83, 131, 255, 2, 84, 131, 255, 2, 84, 132, 255, 2, 84, 132, 255, 3, 84, 132, 255, 3, 85, 133, 255, 3, 85, 133, 255, 3, 85, 134, 255, 3, 85, 134, 255, 3, 86, 134, 255, 3, 86, 135, 255, 3, 86, 135, 255, 3, 86, 136, 255, 3, 87, 136, 255, 3, 87, 137, 255, 3, 87, 137, 255, 3, 88, 137, 255, 3, 88, 138, 255, 3, 88, 138, 255, 3, 88, 139, 255, 3, 89, 139, 255, 3, 89, 140, 255, 3, 89, 140, 255, 4, 89, 141, 255, 3, 90, 141, 255, 3, 90, 141, 255, 3, 90, 141, 255, 3, 90, 142, 255, 3, 90, 142, 255, 3, 91, 142, 255, 3, 91, 142, 255, 3, 91, 143, 255, 3, 91, 143, 255, 3, 91, 143, 255, 3, 91, 143, 255, 3, 92, 144, 255, 3, 92, 144, 255, 3, 92, 144, 255, 3, 92, 145, 255, 3, 92, 145, 255, 3, 92, 145, 255, 3, 93, 145, 255, 3, 93, 146, 255, 3, 93, 146, 255, 3, 93, 146, 255, 3, 93, 146, 255, 3, 93, 147, 255, 3, 94, 147, 255, 3, 94, 147, 255, 3, 94, 147, 255, 3, 94, 148, 255, 3, 94, 148, 255, 3, 94, 148, 255, 3, 95, 149, 255, 3, 95, 149, 255, 3, 95, 149, 255, 3, 95, 149, 255, 3, 95, 150, 255, 3, 95, 150, 255, 3, 96, 150, 255, 3, 96, 150, 255, 3, 96, 151, 255, 3, 96, 151, 255, 3, 96, 151, 255, 3, 96, 152, 255, 3, 97, 152, 255, 3, 97, 152, 255, 3, 97, 152, 255, 3, 97, 153, 255, 3, 97, 153, 255, 3, 97, 153, 255, 3, 98, 153, 255, 3, 98, 154, 255, 3, 98, 154, 255, 3, 98, 154, 255, 3, 98, 155, 255, 3, 99, 155, 255, 3, 99, 155, 255, 3, 99, 155, 255, 3, 99, 156, 255, 3, 99, 156, 255, 3, 99, 156, 255, 3, 100, 156, 255, 3, 100, 157, 255, 3, 100, 157, 255, 3, 100, 157, 255, 3, 100, 158, 255, 3, 100, 158, 255, 3, 101, 158, 255, 3, 101, 158, 255, 4, 101, 159, 255, 4, 101, 159, 255, 4, 101, 159, 255, 4, 101, 159, 255, 4, 102, 160, 255, 4, 102, 160, 255, 4, 102, 160, 255, 4, 102, 161, 255, 4, 102, 161, 255, 4, 102, 161, 255, 4, 103, 161, 255, 4, 103, 162, 255, 4, 103, 162, 255, 4, 103, 162, 255, 4, 103, 162, 255, 4, 104, 163, 255, 4, 104, 163, 255, 4, 104, 163, 255, 4, 104, 164, 255, 4, 104, 164, 255, 4, 104, 164, 255, 4, 105, 164, 255, 4, 105, 165, 255, 4, 105, 165, 255, 4, 105, 165, 255, 4, 105, 166, 255, 4, 105, 166, 255, 4, 106, 166, 255, 4, 106, 166, 255, 4, 106, 167, 255, 4, 106, 167, 255, 4, 106, 167, 255, 4, 106, 167, 255, 4, 107, 168, 255, 4, 107, 168, 255, 4, 107, 168, 255, 4, 107, 169, 255, 4, 107, 169, 255, 4, 107, 169, 255, 4, 108, 169, 255, 4, 108, 170, 255, 4, 108, 170, 255, 4, 108, 170, 255, 4, 108, 170, 255, 4, 109, 171, 255, 4, 109, 171, 255, 4, 109, 171, 255, 4, 109, 172, 255, 4, 109, 172, 255, 4, 109, 172, 255, 4, 110, 172, 255, 4, 110, 173, 255, 4, 110, 173, 255, 4, 110, 173, 255, 4, 110, 174, 255, 4, 110, 174, 255, 4, 111, 174, 255, 4, 111, 174, 255, 4, 111, 175, 255, 4, 111, 175, 255, 4, 111, 175, 255, 5, 111, 176, 255, 5, 112, 176, 255, 5, 112, 176, 255, 6, 112, 176, 255, 6, 113, 176, 255, 7, 113, 176, 255, 7, 113, 176, 255, 7, 113, 176, 255, 8, 114, 177, 255, 8, 114, 177, 255, 9, 114, 177, 255, 9, 114, 177, 255, 10, 115, 177, 255, 10, 115, 177, 255, 11, 115, 177, 255, 11, 115, 178, 255, 12, 116, 178, 255, 12, 116, 178, 255, 13, 116, 178, 255, 13, 116, 178, 255, 13, 117, 178, 255, 14, 117, 178, 255, 14, 117, 179, 255, 15, 117, 179, 255, 15, 118, 179, 255, 16, 118, 179, 255, 16, 118, 179, 255, 16, 118, 179, 255, 17, 119, 179, 255, 17, 119, 179, 255, 18, 119, 180, 255, 18, 119, 180, 255, 18, 120, 180, 255, 19, 120, 180, 255, 19, 120, 180, 255, 20, 120, 180, 255, 20, 121, 180, 255, 20, 121, 180, 255, 21, 121, 181, 255, 21, 121, 181, 255, 22, 122, 181, 255, 22, 122, 181, 255, 22, 122, 181, 255, 23, 122, 181, 255, 23, 123, 181, 255, 24, 123, 182, 255, 24, 123, 182, 255, 24, 123, 182, 255, 25, 124, 182, 255, 25, 124, 182, 255, 25, 124, 182, 255, 26, 124, 182, 255, 26, 125, 182, 255, 27, 125, 183, 255, 27, 125, 183, 255, 27, 125, 183, 255, 28, 126, 183, 255, 28, 126, 183, 255, 28, 126, 183, 255, 29, 126, 183, 255, 29, 127, 183, 255, 30, 127, 184, 255, 30, 127, 184, 255, 30, 127, 184, 255, 31, 128, 184, 255, 31, 128, 184, 255, 31, 128, 184, 255, 32, 128, 184, 255, 32, 129, 184, 255, 32, 129, 185, 255, 33, 129, 185, 255, 33, 129, 185, 255, 34, 130, 185, 255, 34, 130, 185, 255, 34, 130, 185, 255, 35, 130, 185, 255, 35, 131, 185, 255, 35, 131, 186, 255, 36, 131, 186, 255, 36, 131, 186, 255, 36, 132, 186, 255, 37, 132, 186, 255, 37, 132, 186, 255, 38, 132, 186, 255, 38, 133, 186, 255, 38, 133, 186, 255, 39, 133, 187, 255, 39, 133, 187, 255, 39, 134, 187, 255, 40, 134, 187, 255, 40, 134, 187, 255, 40, 134, 187, 255, 41, 135, 187, 255, 41, 135, 187, 255, 41, 135, 188, 255, 42, 135, 188, 255, 42, 136, 188, 255, 43, 136, 188, 255, 43, 136, 188, 255, 43, 136, 188, 255, 44, 137, 188, 255, 44, 137, 188, 255, 44, 137, 189, 255, 45, 137, 189, 255, 45, 138, 189, 255, 45, 138, 189, 255, 46, 138, 189, 255, 46, 138, 189, 255, 46, 139, 189, 255, 47, 139, 189, 255, 47, 139, 189, 255, 48, 139, 190, 255, 48, 140, 190, 255, 48, 140, 190, 255, 49, 140, 190, 255, 49, 140, 190, 255, 49, 141, 190, 255, 50, 141, 190, 255, 50, 141, 190, 255, 50, 141, 190, 255, 51, 142, 191, 255, 51, 142, 191, 255, 51, 142, 191, 255, 52, 142, 191, 255, 52, 143, 191, 255, 52, 143, 191, 255, 53, 143, 191, 255, 53, 143, 191, 255, 54, 144, 192, 255, 54, 144, 192, 255, 55, 144, 192, 255, 55, 144, 192, 255, 56, 144, 192, 255, 57, 144, 192, 255, 57, 145, 192, 255, 58, 145, 192, 255, 59, 145, 192, 255, 59, 145, 193, 255, 60, 145, 193, 255, 61, 146, 193, 255, 61, 146, 193, 255, 62, 146, 193, 255, 62, 146, 193, 255, 63, 146, 193, 255, 64, 147, 193, 255, 64, 147, 194, 255, 65, 147, 194, 255, 65, 147, 194, 255, 66, 147, 194, 255, 66, 148, 194, 255, 67, 148, 194, 255, 68, 148, 194, 255, 68, 148, 194, 255, 69, 148, 194, 255, 69, 149, 195, 255, 70, 149, 195, 255, 70, 149, 195, 255, 71, 149, 195, 255, 71, 149, 195, 255, 72, 149, 195, 255, 72, 150, 195, 255, 73, 150, 195, 255, 73, 150, 196, 255, 74, 150, 196, 255, 75, 150, 196, 255, 75, 151, 196, 255, 76, 151, 196, 255, 76, 151, 196, 255, 77, 151, 196, 255, 77, 151, 196, 255, 78, 152, 196, 255, 78, 152, 197, 255, 79, 152, 197, 255, 79, 152, 197, 255, 80, 152, 197, 255, 80, 153, 197, 255, 81, 153, 197, 255, 81, 153, 197, 255, 82, 153, 197, 255, 82, 153, 198, 255, 83, 154, 198, 255, 83, 154, 198, 255, 84, 154, 198, 255, 84, 154, 198, 255, 84, 154, 198, 255, 85, 155, 198, 255, 85, 155, 198, 255, 86, 155, 198, 255, 86, 155, 199, 255, 87, 155, 199, 255, 87, 155, 199, 255, 88, 156, 199, 255, 88, 156, 199, 255, 89, 156, 199, 255, 89, 156, 199, 255, 90, 156, 199, 255, 90, 157, 200, 255, 91, 157, 200, 255, 91, 157, 200, 255, 91, 157, 200, 255, 92, 157, 200, 255, 92, 158, 200, 255, 93, 158, 200, 255, 93, 158, 200, 255, 94, 158, 200, 255, 94, 158, 201, 255, 95, 159, 201, 255, 95, 159, 201, 255, 95, 159, 201, 255, 96, 159, 201, 255, 96, 159, 201, 255, 97, 160, 201, 255, 97, 160, 201, 255, 98, 160, 201, 255, 98, 160, 202, 255, 99, 160, 202, 255, 99, 161, 202, 255, 99, 161, 202, 255, 100, 161, 202, 255, 100, 161, 202, 255, 101, 161, 202, 255, 101, 162, 202, 255, 102, 162, 203, 255, 102, 162, 203, 255, 102, 162, 203, 255, 103, 162, 203, 255, 103, 163, 203, 255, 104, 163, 203, 255, 104, 163, 203, 255, 104, 163, 203, 255, 105, 163, 203, 255, 105, 164, 204, 255, 106, 164, 204, 255, 106, 164, 204, 255, 107, 164, 204, 255, 107, 164, 204, 255, 107, 165, 204, 255, 108, 165, 204, 255, 108, 165, 204, 255, 109, 165, 205, 255, 109, 165, 205, 255, 109, 166, 205, 255, 110, 166, 205, 255, 110, 166, 205, 255, 111, 166, 205, 255, 111, 166, 205, 255, 111, 167, 205, 255, 112, 167, 205, 255, 112, 167, 206, 255, 113, 167, 206, 255, 113, 167, 206, 255, 113, 168, 206, 255, 114, 168, 206, 255, 114, 168, 206, 255, 115, 168, 206, 255, 115, 168, 206, 255, 116, 169, 207, 255, 116, 169, 207, 255, 116, 169, 207, 255, 117, 169, 207, 255, 117, 169, 207, 255, 118, 169, 207, 255, 118, 169, 207, 255, 119, 170, 207, 255, 119, 170, 207, 255, 119, 170, 207, 255, 120, 170, 208, 255, 120, 170, 208, 255, 121, 170, 208, 255, 121, 170, 208, 255, 122, 171, 208, 255, 122, 171, 208, 255, 123, 171, 208, 255, 123, 171, 208, 255, 123, 171, 208, 255, 124, 171, 208, 255, 124, 172, 209, 255, 125, 172, 209, 255, 125, 172, 209, 255, 126, 172, 209, 255, 126, 172, 209, 255, 126, 172, 209, 255, 127, 172, 209, 255, 127, 173, 209, 255, 128, 173, 209, 255, 128, 173, 210, 255, 128, 173, 210, 255, 129, 173, 210, 255, 129, 173, 210, 255, 130, 173, 210, 255, 130, 174, 210, 255, 131, 174, 210, 255, 131, 174, 210, 255, 131, 174, 210, 255, 132, 174, 210, 255, 132, 174, 211, 255, 133, 175, 211, 255, 133, 175, 211, 255, 133, 175, 211, 255, 134, 175, 211, 255, 134, 175, 211, 255, 135, 175, 211, 255, 135, 175, 211, 255, 135, 176, 211, 255, 136, 176, 211, 255, 136, 176, 211, 255, 137, 176, 212, 255, 137, 176, 212, 255, 137, 176, 212, 255, 138, 177, 212, 255, 138, 177, 212, 255, 139, 177, 212, 255, 139, 177, 212, 255, 139, 177, 212, 255, 140, 177, 212, 255, 140, 177, 212, 255, 141, 178, 213, 255, 141, 178, 213, 255, 141, 178, 213, 255, 142, 178, 213, 255, 142, 178, 213, 255, 143, 178, 213, 255, 143, 179, 213, 255, 143, 179, 213, 255, 144, 179, 213, 255, 144, 179, 213, 255, 144, 179, 213, 255, 145, 179, 214, 255, 145, 180, 214, 255, 146, 180, 214, 255, 146, 180, 214, 255, 146, 180, 214, 255, 147, 180, 214, 255, 147, 180, 214, 255, 147, 180, 214, 255, 148, 181, 214, 255, 148, 181, 214, 255, 149, 181, 214, 255, 149, 181, 215, 255, 149, 181, 215, 255, 150, 181, 215, 255, 150, 182, 215, 255, 150, 182, 215, 255, 151, 182, 215, 255, 151, 182, 215, 255, 152, 182, 215, 255, 152, 182, 215, 255, 152, 183, 215, 255, 153, 183, 215, 255, 153, 183, 216, 255, 153, 183, 216, 255, 154, 183, 216, 255, 154, 183, 216, 255, 155, 183, 216, 255, 155, 184, 216, 255, 155, 184, 216, 255, 156, 184, 216, 255, 156, 184, 216, 255, 156, 184, 216, 255, 157, 184, 216, 255, 157, 185, 216, 255, 157, 185, 217, 255, 158, 185, 217, 255, 158, 185, 217, 255, 158, 185, 217, 255, 159, 185, 217, 255, 159, 186, 217, 255, 160, 186, 217, 255, 160, 186, 217, 255, 160, 186, 217, 255, 161, 186, 217, 255, 161, 186, 217, 255, 161, 187, 217, 255, 162, 187, 218, 255, 162, 187, 218, 255, 162, 187, 218, 255, 163, 187, 218, 255, 163, 187, 218, 255, 163, 188, 218, 255, 164, 188, 218, 255, 164, 188, 218, 255, 164, 188, 218, 255, 165, 188, 218, 255, 165, 188, 218, 255, 165, 189, 218, 255, 166, 189, 219, 255, 166, 189, 219, 255, 167, 189, 219, 255, 167, 189, 219, 255, 167, 189, 219, 255, 168, 189, 219, 255, 168, 190, 219, 255, 168, 190, 219, 255, 169, 190, 219, 255, 169, 190, 220, 255, 170, 190, 220, 255, 170, 190, 220, 255, 170, 190, 220, 255, 171, 191, 220, 255, 171, 191, 220, 255, 171, 191, 220, 255, 172, 191, 220, 255, 172, 191, 220, 255, 172, 191, 220, 255, 173, 191, 220, 255, 173, 192, 221, 255, 174, 192, 221, 255, 174, 192, 221, 255, 174, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 177, 193, 222, 255, 177, 193, 222, 255, 177, 193, 222, 255, 178, 193, 222, 255, 178, 194, 222, 255, 179, 194, 222, 255, 179, 194, 222, 255, 179, 194, 222, 255, 180, 194, 222, 255, 180, 194, 222, 255, 180, 195, 222, 255, 181, 195, 223, 255, 181, 195, 223, 255, 181, 195, 223, 255, 182, 195, 223, 255, 182, 195, 223, 255, 182, 195, 223, 255, 183, 196, 223, 255, 183, 196, 223, 255, 183, 196, 223, 255, 184, 196, 223, 255, 184, 196, 223, 255, 184, 196, 223, 255, 185, 197, 224, 255, 185, 197, 224, 255, 185, 197, 224, 255, 186, 197, 224, 255, 186, 197, 224, 255, 186, 197, 224, 255, 187, 197, 224, 255, 187, 198, 224, 255, 187, 198, 224, 255, 188, 198, 224, 255, 188, 198, 224, 255, 188, 198, 224, 255, 189, 198, 225, 255, 189, 199, 225, 255, 189, 199, 225, 255, 190, 199, 225, 255, 190, 199, 225, 255, 190, 199, 225, 255, 191, 199, 225, 255, 191, 199, 225, 255, 191, 200, 225, 255, 192, 200, 225, 255, 192, 200, 225, 255, 192, 200, 225, 255, 193, 200, 226, 255, 193, 200, 226, 255, 193, 201, 226, 255, 193, 201, 226, 255, 194, 201, 226, 255, 194, 201, 226, 255, 194, 201, 226, 255, 195, 201, 226, 255, 195, 202, 226, 255, 195, 202, 226, 255, 196, 202, 226, 255, 196, 202, 226, 255, 196, 202, 227, 255, 197, 202, 227, 255, 197, 203, 227, 255, 197, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 199, 203, 227, 255, 199, 204, 227, 255, 199, 204, 227, 255, 200, 204, 227, 255, 200, 204, 227, 255, 200, 204, 228, 255, 201, 204, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 204, 206, 228, 255, 204, 206, 228, 255, 204, 206, 229, 255, 204, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 206, 207, 229, 255, 206, 207, 229, 255, 206, 208, 229, 255, 206, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 209, 229, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 210, 230, 255, 209, 210, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 210, 210, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 212, 212, 231, 255, 212, 212, 231, 255, 213, 212, 231, 255, 213, 212, 231, 255, 213, 212, 232, 255, 213, 212, 232, 255, 214, 213, 232, 255, 214, 213, 232, 255, 214, 213, 232, 255, 214, 213, 232, 255, 214, 213, 232, 255, 215, 213, 232, 255, 215, 214, 232, 255, 215, 214, 232, 255, 215, 214, 232, 255, 216, 214, 233, 255, 216, 214, 233, 255, 216, 214, 233, 255, 216, 215, 233, 255, 217, 215, 233, 255, 217, 215, 233, 255, 217, 215, 233, 255, 217, 215, 233, 255, 218, 215, 233, 255, 218, 216, 233, 255, 218, 216, 233, 255, 218, 216, 234, 255, 218, 216, 234, 255, 219, 216, 234, 255, 219, 216, 234, 255, 219, 217, 234, 255, 219, 217, 234, 255, 220, 217, 234, 255, 220, 217, 234, 255, 220, 217, 234, 255, 220, 217, 234, 255, 220, 218, 234, 255, 221, 218, 235, 255, 221, 218, 235, 255, 221, 218, 235, 255, 221, 218, 235, 255, 222, 218, 235, 255, 222, 219, 235, 255, 222, 219, 235, 255, 222, 219, 235, 255, 222, 219, 235, 255, 223, 219, 235, 255, 223, 220, 236, 255, 223, 220, 236, 255, 223, 220, 236, 255, 224, 220, 236, 255, 224, 220, 236, 255, 224, 220, 236, 255, 224, 221, 236, 255, 224, 221, 236, 255, 225, 221, 236, 255, 225, 221, 236, 255, 225, 221, 236, 255, 225, 221, 237, 255, 225, 222, 237, 255, 226, 222, 237, 255, 226, 222, 237, 255, 226, 222, 237, 255, 226, 222, 237, 255, 226, 222, 237, 255, 227, 223, 237, 255, 227, 223, 237, 255, 227, 223, 237, 255, 227, 223, 237, 255, 228, 223, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 229, 224, 238, 255, 229, 224, 238, 255, 229, 225, 238, 255, 229, 225, 238, 255, 229, 225, 238, 255, 230, 225, 239, 255, 230, 225, 239, 255, 230, 225, 239, 255, 230, 226, 239, 255, 230, 226, 239, 255, 231, 226, 239, 255, 231, 226, 239, 255, 231, 226, 239, 255, 231, 227, 239, 255, 231, 227, 239, 255, 232, 227, 240, 255, 232, 227, 240, 255, 232, 227, 240, 255, 232, 227, 240, 255, 232, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 229, 240, 255, 234, 229, 240, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 231, 241, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 237, 231, 242, 255, 237, 231, 242, 255, 237, 231, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 243, 255, 238, 232, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 240, 233, 243, 255, 240, 233, 243, 255, 240, 233, 243, 255, 240, 234, 243, 255, 240, 234, 243, 255, 240, 234, 243, 255, 241, 234, 243, 255, 241, 234, 243, 255, 241, 234, 243, 255, 241, 234, 244, 255, 241, 234, 244, 255, 241, 235, 244, 255, 241, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 243, 235, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 245, 255, 244, 236, 245, 255, 244, 236, 245, 255, 244, 236, 245, 255, 244, 237, 245, 255, 244, 237, 245, 255, 244, 237, 245, 255, 244, 237, 245, 255, 245, 237, 245, 255, 245, 237, 245, 255, 245, 237, 245, 255, 245, 237, 245, 255, 245, 238, 245, 255, 245, 238, 245, 255, 246, 238, 245, 255, 246, 238, 246, 255, 246, 238, 246, 255, 246, 238, 246, 255, 246, 238, 246, 255, 246, 238, 246, 255, 246, 239, 246, 255, 247, 239, 246, 255, 247, 239, 246, 255, 247, 239, 246, 255, 247, 239, 246, 255, 247, 239, 246, 255, 247, 239, 246, 255, 247, 239, 246, 255, 248, 240, 246, 255, 248, 240, 246, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 249, 240, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 250, 241, 247, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 251, 242, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 252, 243, 249, 255, 252, 243, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 253, 244, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 254, 245, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuBu_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 2, 55, 88, 0, 1, 56, 88, 7, 1, 56, 88, 14, 1, 56, 88, 22, 1, 56, 89, 29, 1, 57, 89, 37, 1, 57, 89, 44, 1, 57, 90, 52, 1, 57, 90, 59, 1, 57, 90, 67, 1, 58, 91, 74, 1, 58, 91, 82, 1, 58, 91, 89, 1, 58, 92, 97, 1, 58, 92, 104, 1, 59, 92, 112, 1, 59, 93, 119, 1, 59, 93, 127, 1, 59, 93, 134, 1, 59, 94, 141, 1, 60, 94, 149, 1, 60, 94, 156, 1, 60, 95, 164, 1, 60, 95, 171, 1, 60, 95, 179, 1, 61, 95, 186, 1, 61, 96, 194, 1, 61, 96, 201, 1, 61, 96, 209, 1, 61, 97, 216, 1, 62, 97, 224, 1, 62, 97, 231, 1, 62, 98, 239, 1, 62, 98, 246, 1, 63, 98, 254, 1, 63, 99, 255, 1, 63, 99, 255, 1, 63, 99, 255, 1, 63, 100, 255, 1, 64, 100, 255, 1, 64, 100, 255, 1, 64, 101, 255, 1, 64, 101, 255, 1, 64, 101, 255, 1, 65, 102, 255, 1, 65, 102, 255, 1, 65, 102, 255, 1, 65, 103, 255, 1, 65, 103, 255, 1, 66, 103, 255, 1, 66, 104, 255, 1, 66, 104, 255, 1, 66, 104, 255, 1, 67, 105, 255, 1, 67, 105, 255, 1, 67, 105, 255, 1, 67, 106, 255, 1, 67, 106, 255, 1, 68, 106, 255, 1, 68, 107, 255, 1, 68, 107, 255, 1, 68, 107, 255, 1, 68, 108, 255, 1, 69, 108, 255, 2, 76, 119, 255, 2, 76, 119, 255, 2, 76, 120, 255, 2, 76, 120, 255, 2, 77, 120, 255, 2, 77, 121, 255, 2, 77, 121, 255, 2, 77, 121, 255, 2, 77, 122, 255, 2, 78, 122, 255, 2, 78, 122, 255, 2, 78, 123, 255, 2, 78, 123, 255, 2, 78, 123, 255, 2, 79, 124, 255, 2, 79, 124, 255, 2, 79, 124, 255, 2, 79, 125, 255, 2, 80, 125, 255, 2, 80, 125, 255, 2, 80, 126, 255, 2, 80, 126, 255, 2, 80, 126, 255, 2, 81, 127, 255, 2, 81, 127, 255, 2, 81, 127, 255, 2, 81, 128, 255, 2, 81, 128, 255, 2, 82, 128, 255, 2, 82, 129, 255, 2, 82, 129, 255, 2, 82, 129, 255, 2, 83, 130, 255, 2, 83, 130, 255, 2, 83, 130, 255, 2, 83, 131, 255, 2, 83, 131, 255, 2, 84, 131, 255, 2, 84, 132, 255, 3, 84, 132, 255, 3, 84, 132, 255, 3, 84, 133, 255, 3, 85, 133, 255, 3, 85, 133, 255, 3, 85, 134, 255, 3, 85, 134, 255, 3, 86, 134, 255, 3, 86, 135, 255, 3, 86, 135, 255, 3, 86, 135, 255, 3, 86, 136, 255, 3, 87, 136, 255, 3, 87, 136, 255, 3, 87, 137, 255, 3, 87, 137, 255, 3, 88, 137, 255, 3, 88, 138, 255, 3, 88, 138, 255, 3, 88, 138, 255, 3, 88, 139, 255, 3, 89, 139, 255, 3, 89, 139, 255, 3, 89, 140, 255, 3, 89, 140, 255, 4, 89, 141, 255, 3, 90, 141, 255, 3, 90, 141, 255, 3, 90, 141, 255, 3, 90, 141, 255, 3, 90, 142, 255, 3, 90, 142, 255, 3, 90, 142, 255, 3, 91, 142, 255, 3, 91, 142, 255, 3, 91, 143, 255, 3, 91, 143, 255, 3, 91, 143, 255, 3, 91, 143, 255, 3, 91, 144, 255, 3, 92, 144, 255, 3, 92, 144, 255, 3, 92, 144, 255, 3, 92, 144, 255, 3, 92, 145, 255, 3, 92, 145, 255, 3, 92, 145, 255, 3, 92, 145, 255, 3, 93, 145, 255, 3, 93, 146, 255, 3, 93, 146, 255, 3, 93, 146, 255, 3, 93, 146, 255, 3, 93, 147, 255, 3, 93, 147, 255, 3, 94, 147, 255, 3, 94, 147, 255, 3, 94, 147, 255, 3, 94, 148, 255, 3, 94, 148, 255, 3, 94, 148, 255, 3, 94, 148, 255, 3, 95, 148, 255, 3, 95, 149, 255, 3, 95, 149, 255, 3, 95, 149, 255, 3, 95, 149, 255, 3, 95, 150, 255, 3, 95, 150, 255, 3, 95, 150, 255, 3, 96, 150, 255, 3, 96, 150, 255, 3, 96, 151, 255, 3, 96, 151, 255, 3, 96, 151, 255, 3, 96, 151, 255, 3, 96, 152, 255, 3, 97, 152, 255, 3, 97, 152, 255, 3, 97, 152, 255, 3, 97, 152, 255, 3, 97, 153, 255, 3, 97, 153, 255, 3, 97, 153, 255, 3, 98, 153, 255, 3, 98, 153, 255, 3, 98, 154, 255, 3, 98, 154, 255, 3, 98, 154, 255, 4, 103, 161, 255, 4, 103, 162, 255, 4, 103, 162, 255, 4, 103, 162, 255, 4, 103, 162, 255, 4, 103, 162, 255, 4, 103, 163, 255, 4, 104, 163, 255, 4, 104, 163, 255, 4, 104, 163, 255, 4, 104, 164, 255, 4, 104, 164, 255, 4, 104, 164, 255, 4, 104, 164, 255, 4, 105, 164, 255, 4, 105, 165, 255, 4, 105, 165, 255, 4, 105, 165, 255, 4, 105, 165, 255, 4, 105, 166, 255, 4, 105, 166, 255, 4, 106, 166, 255, 4, 106, 166, 255, 4, 106, 166, 255, 4, 106, 167, 255, 4, 106, 167, 255, 4, 106, 167, 255, 4, 106, 167, 255, 4, 106, 168, 255, 4, 107, 168, 255, 4, 107, 168, 255, 4, 107, 168, 255, 4, 107, 168, 255, 4, 107, 169, 255, 4, 107, 169, 255, 4, 107, 169, 255, 4, 108, 169, 255, 4, 108, 169, 255, 4, 108, 170, 255, 4, 108, 170, 255, 4, 108, 170, 255, 4, 108, 170, 255, 4, 108, 171, 255, 4, 109, 171, 255, 4, 109, 171, 255, 4, 109, 171, 255, 4, 109, 171, 255, 4, 109, 172, 255, 4, 109, 172, 255, 4, 109, 172, 255, 4, 110, 172, 255, 4, 110, 173, 255, 4, 110, 173, 255, 4, 110, 173, 255, 4, 110, 173, 255, 4, 110, 173, 255, 4, 110, 174, 255, 4, 111, 174, 255, 4, 111, 174, 255, 4, 111, 174, 255, 4, 111, 175, 255, 4, 111, 175, 255, 4, 111, 175, 255, 4, 111, 175, 255, 5, 111, 176, 255, 5, 112, 176, 255, 5, 112, 176, 255, 5, 112, 176, 255, 6, 112, 176, 255, 6, 113, 176, 255, 7, 113, 176, 255, 7, 113, 176, 255, 7, 113, 176, 255, 8, 113, 176, 255, 8, 114, 177, 255, 8, 114, 177, 255, 9, 114, 177, 255, 9, 114, 177, 255, 9, 114, 177, 255, 10, 115, 177, 255, 10, 115, 177, 255, 11, 115, 177, 255, 11, 115, 177, 255, 11, 115, 178, 255, 12, 116, 178, 255, 12, 116, 178, 255, 12, 116, 178, 255, 13, 116, 178, 255, 13, 116, 178, 255, 13, 117, 178, 255, 14, 117, 178, 255, 14, 117, 178, 255, 14, 117, 179, 255, 15, 117, 179, 255, 15, 118, 179, 255, 15, 118, 179, 255, 16, 118, 179, 255, 16, 118, 179, 255, 16, 118, 179, 255, 17, 119, 179, 255, 17, 119, 179, 255, 17, 119, 179, 255, 18, 119, 180, 255, 18, 119, 180, 255, 18, 120, 180, 255, 19, 120, 180, 255, 19, 120, 180, 255, 19, 120, 180, 255, 19, 120, 180, 255, 20, 121, 180, 255, 20, 121, 180, 255, 20, 121, 181, 255, 21, 121, 181, 255, 21, 121, 181, 255, 21, 122, 181, 255, 22, 122, 181, 255, 22, 122, 181, 255, 22, 122, 181, 255, 22, 122, 181, 255, 23, 123, 181, 255, 23, 123, 181, 255, 23, 123, 182, 255, 24, 123, 182, 255, 24, 123, 182, 255, 24, 124, 182, 255, 25, 124, 182, 255, 25, 124, 182, 255, 25, 124, 182, 255, 35, 131, 185, 255, 36, 131, 186, 255, 36, 131, 186, 255, 36, 131, 186, 255, 36, 132, 186, 255, 37, 132, 186, 255, 37, 132, 186, 255, 37, 132, 186, 255, 38, 132, 186, 255, 38, 133, 186, 255, 38, 133, 186, 255, 38, 133, 187, 255, 39, 133, 187, 255, 39, 133, 187, 255, 39, 134, 187, 255, 40, 134, 187, 255, 40, 134, 187, 255, 40, 134, 187, 255, 40, 134, 187, 255, 41, 135, 187, 255, 41, 135, 187, 255, 41, 135, 187, 255, 42, 135, 188, 255, 42, 135, 188, 255, 42, 136, 188, 255, 42, 136, 188, 255, 43, 136, 188, 255, 43, 136, 188, 255, 43, 136, 188, 255, 44, 137, 188, 255, 44, 137, 188, 255, 44, 137, 188, 255, 44, 137, 189, 255, 45, 137, 189, 255, 45, 138, 189, 255, 45, 138, 189, 255, 46, 138, 189, 255, 46, 138, 189, 255, 46, 138, 189, 255, 46, 139, 189, 255, 47, 139, 189, 255, 47, 139, 189, 255, 47, 139, 189, 255, 48, 139, 190, 255, 48, 140, 190, 255, 48, 140, 190, 255, 48, 140, 190, 255, 49, 140, 190, 255, 49, 140, 190, 255, 49, 141, 190, 255, 50, 141, 190, 255, 50, 141, 190, 255, 50, 141, 190, 255, 50, 141, 190, 255, 51, 142, 191, 255, 51, 142, 191, 255, 51, 142, 191, 255, 52, 142, 191, 255, 52, 142, 191, 255, 52, 143, 191, 255, 52, 143, 191, 255, 53, 143, 191, 255, 53, 143, 191, 255, 53, 143, 191, 255, 54, 144, 192, 255, 54, 144, 192, 255, 55, 144, 192, 255, 55, 144, 192, 255, 56, 144, 192, 255, 56, 144, 192, 255, 57, 144, 192, 255, 57, 145, 192, 255, 58, 145, 192, 255, 58, 145, 192, 255, 59, 145, 192, 255, 59, 145, 193, 255, 60, 145, 193, 255, 60, 145, 193, 255, 61, 146, 193, 255, 61, 146, 193, 255, 62, 146, 193, 255, 62, 146, 193, 255, 62, 146, 193, 255, 63, 146, 193, 255, 63, 147, 193, 255, 64, 147, 193, 255, 64, 147, 194, 255, 65, 147, 194, 255, 65, 147, 194, 255, 66, 147, 194, 255, 66, 148, 194, 255, 66, 148, 194, 255, 67, 148, 194, 255, 67, 148, 194, 255, 68, 148, 194, 255, 68, 148, 194, 255, 69, 148, 195, 255, 69, 149, 195, 255, 69, 149, 195, 255, 70, 149, 195, 255, 70, 149, 195, 255, 71, 149, 195, 255, 71, 149, 195, 255, 72, 150, 195, 255, 72, 150, 195, 255, 72, 150, 195, 255, 73, 150, 195, 255, 73, 150, 196, 255, 74, 150, 196, 255, 74, 150, 196, 255, 74, 151, 196, 255, 75, 151, 196, 255, 75, 151, 196, 255, 76, 151, 196, 255, 76, 151, 196, 255, 76, 151, 196, 255, 77, 152, 196, 255, 77, 152, 196, 255, 78, 152, 197, 255, 78, 152, 197, 255, 78, 152, 197, 255, 79, 152, 197, 255, 79, 152, 197, 255, 79, 153, 197, 255, 80, 153, 197, 255, 80, 153, 197, 255, 81, 153, 197, 255, 81, 153, 197, 255, 94, 158, 201, 255, 94, 159, 201, 255, 94, 159, 201, 255, 95, 159, 201, 255, 95, 159, 201, 255, 96, 159, 201, 255, 96, 159, 201, 255, 96, 160, 201, 255, 97, 160, 201, 255, 97, 160, 201, 255, 97, 160, 201, 255, 98, 160, 202, 255, 98, 160, 202, 255, 98, 160, 202, 255, 99, 161, 202, 255, 99, 161, 202, 255, 99, 161, 202, 255, 100, 161, 202, 255, 100, 161, 202, 255, 101, 161, 202, 255, 101, 162, 202, 255, 101, 162, 202, 255, 102, 162, 203, 255, 102, 162, 203, 255, 102, 162, 203, 255, 103, 162, 203, 255, 103, 162, 203, 255, 103, 163, 203, 255, 104, 163, 203, 255, 104, 163, 203, 255, 104, 163, 203, 255, 105, 163, 203, 255, 105, 163, 204, 255, 105, 164, 204, 255, 106, 164, 204, 255, 106, 164, 204, 255, 106, 164, 204, 255, 107, 164, 204, 255, 107, 164, 204, 255, 107, 165, 204, 255, 108, 165, 204, 255, 108, 165, 204, 255, 108, 165, 204, 255, 109, 165, 205, 255, 109, 165, 205, 255, 109, 165, 205, 255, 110, 166, 205, 255, 110, 166, 205, 255, 110, 166, 205, 255, 111, 166, 205, 255, 111, 166, 205, 255, 111, 166, 205, 255, 112, 167, 205, 255, 112, 167, 205, 255, 112, 167, 206, 255, 113, 167, 206, 255, 113, 167, 206, 255, 113, 167, 206, 255, 114, 168, 206, 255, 114, 168, 206, 255, 114, 168, 206, 255, 115, 168, 206, 255, 115, 168, 206, 255, 115, 168, 206, 255, 116, 169, 207, 255, 116, 169, 207, 255, 116, 169, 207, 255, 117, 169, 207, 255, 117, 169, 207, 255, 117, 169, 207, 255, 118, 169, 207, 255, 118, 169, 207, 255, 118, 169, 207, 255, 119, 170, 207, 255, 119, 170, 207, 255, 119, 170, 207, 255, 120, 170, 208, 255, 120, 170, 208, 255, 120, 170, 208, 255, 121, 170, 208, 255, 121, 170, 208, 255, 121, 171, 208, 255, 122, 171, 208, 255, 122, 171, 208, 255, 122, 171, 208, 255, 123, 171, 208, 255, 123, 171, 208, 255, 124, 171, 208, 255, 124, 171, 209, 255, 124, 172, 209, 255, 125, 172, 209, 255, 125, 172, 209, 255, 125, 172, 209, 255, 126, 172, 209, 255, 126, 172, 209, 255, 126, 172, 209, 255, 127, 172, 209, 255, 127, 172, 209, 255, 127, 173, 209, 255, 128, 173, 209, 255, 128, 173, 209, 255, 128, 173, 210, 255, 129, 173, 210, 255, 129, 173, 210, 255, 129, 173, 210, 255, 129, 173, 210, 255, 130, 174, 210, 255, 130, 174, 210, 255, 130, 174, 210, 255, 131, 174, 210, 255, 131, 174, 210, 255, 131, 174, 210, 255, 132, 174, 210, 255, 132, 174, 210, 255, 132, 175, 211, 255, 133, 175, 211, 255, 133, 175, 211, 255, 133, 175, 211, 255, 134, 175, 211, 255, 134, 175, 211, 255, 134, 175, 211, 255, 135, 175, 211, 255, 135, 176, 211, 255, 135, 176, 211, 255, 136, 176, 211, 255, 136, 176, 211, 255, 136, 176, 211, 255, 136, 176, 212, 255, 147, 180, 214, 255, 147, 180, 214, 255, 147, 181, 214, 255, 148, 181, 214, 255, 148, 181, 214, 255, 148, 181, 214, 255, 149, 181, 214, 255, 149, 181, 215, 255, 149, 181, 215, 255, 150, 181, 215, 255, 150, 182, 215, 255, 150, 182, 215, 255, 150, 182, 215, 255, 151, 182, 215, 255, 151, 182, 215, 255, 151, 182, 215, 255, 152, 182, 215, 255, 152, 182, 215, 255, 152, 183, 215, 255, 153, 183, 215, 255, 153, 183, 215, 255, 153, 183, 216, 255, 153, 183, 216, 255, 154, 183, 216, 255, 154, 183, 216, 255, 154, 183, 216, 255, 155, 184, 216, 255, 155, 184, 216, 255, 155, 184, 216, 255, 156, 184, 216, 255, 156, 184, 216, 255, 156, 184, 216, 255, 156, 184, 216, 255, 157, 184, 216, 255, 157, 185, 216, 255, 157, 185, 217, 255, 158, 185, 217, 255, 158, 185, 217, 255, 158, 185, 217, 255, 158, 185, 217, 255, 159, 185, 217, 255, 159, 186, 217, 255, 159, 186, 217, 255, 160, 186, 217, 255, 160, 186, 217, 255, 160, 186, 217, 255, 160, 186, 217, 255, 161, 186, 217, 255, 161, 186, 217, 255, 161, 187, 217, 255, 162, 187, 218, 255, 162, 187, 218, 255, 162, 187, 218, 255, 162, 187, 218, 255, 163, 187, 218, 255, 163, 187, 218, 255, 163, 187, 218, 255, 164, 188, 218, 255, 164, 188, 218, 255, 164, 188, 218, 255, 164, 188, 218, 255, 165, 188, 218, 255, 165, 188, 218, 255, 165, 188, 218, 255, 165, 189, 218, 255, 166, 189, 219, 255, 166, 189, 219, 255, 166, 189, 219, 255, 167, 189, 219, 255, 167, 189, 219, 255, 167, 189, 219, 255, 168, 189, 219, 255, 168, 189, 219, 255, 168, 190, 219, 255, 168, 190, 219, 255, 169, 190, 219, 255, 169, 190, 219, 255, 169, 190, 220, 255, 170, 190, 220, 255, 170, 190, 220, 255, 170, 190, 220, 255, 171, 190, 220, 255, 171, 191, 220, 255, 171, 191, 220, 255, 171, 191, 220, 255, 172, 191, 220, 255, 172, 191, 220, 255, 172, 191, 220, 255, 173, 191, 220, 255, 173, 191, 220, 255, 173, 192, 221, 255, 173, 192, 221, 255, 174, 192, 221, 255, 174, 192, 221, 255, 174, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 175, 192, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 176, 193, 221, 255, 177, 193, 221, 255, 177, 193, 222, 255, 177, 193, 222, 255, 178, 193, 222, 255, 178, 194, 222, 255, 178, 194, 222, 255, 178, 194, 222, 255, 179, 194, 222, 255, 179, 194, 222, 255, 179, 194, 222, 255, 180, 194, 222, 255, 180, 194, 222, 255, 180, 195, 222, 255, 180, 195, 222, 255, 181, 195, 222, 255, 181, 195, 223, 255, 181, 195, 223, 255, 181, 195, 223, 255, 182, 195, 223, 255, 182, 195, 223, 255, 182, 196, 223, 255, 182, 196, 223, 255, 183, 196, 223, 255, 183, 196, 223, 255, 183, 196, 223, 255, 192, 200, 225, 255, 192, 200, 225, 255, 192, 200, 226, 255, 193, 201, 226, 255, 193, 201, 226, 255, 193, 201, 226, 255, 193, 201, 226, 255, 194, 201, 226, 255, 194, 201, 226, 255, 194, 201, 226, 255, 195, 201, 226, 255, 195, 202, 226, 255, 195, 202, 226, 255, 195, 202, 226, 255, 196, 202, 226, 255, 196, 202, 226, 255, 196, 202, 226, 255, 196, 202, 227, 255, 197, 202, 227, 255, 197, 203, 227, 255, 197, 203, 227, 255, 197, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 199, 203, 227, 255, 199, 204, 227, 255, 199, 204, 227, 255, 199, 204, 227, 255, 200, 204, 227, 255, 200, 204, 227, 255, 200, 204, 228, 255, 200, 204, 228, 255, 201, 204, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 201, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 202, 206, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 203, 206, 228, 255, 204, 206, 228, 255, 204, 206, 229, 255, 204, 206, 229, 255, 204, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 205, 207, 229, 255, 206, 207, 229, 255, 206, 208, 229, 255, 206, 208, 229, 255, 206, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 208, 229, 255, 207, 209, 229, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 209, 209, 230, 255, 209, 209, 230, 255, 209, 210, 230, 255, 209, 210, 230, 255, 209, 210, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 210, 210, 230, 255, 210, 210, 231, 255, 210, 210, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 211, 211, 231, 255, 212, 211, 231, 255, 212, 211, 231, 255, 212, 212, 231, 255, 212, 212, 231, 255, 212, 212, 231, 255, 213, 212, 231, 255, 213, 212, 231, 255, 213, 212, 232, 255, 213, 212, 232, 255, 213, 212, 232, 255, 213, 213, 232, 255, 214, 213, 232, 255, 214, 213, 232, 255, 214, 213, 232, 255, 214, 213, 232, 255, 214, 213, 232, 255, 215, 213, 232, 255, 215, 214, 232, 255, 215, 214, 232, 255, 215, 214, 232, 255, 215, 214, 232, 255, 216, 214, 233, 255, 216, 214, 233, 255, 216, 214, 233, 255, 216, 214, 233, 255, 216, 215, 233, 255, 216, 215, 233, 255, 217, 215, 233, 255, 217, 215, 233, 255, 217, 215, 233, 255, 217, 215, 233, 255, 217, 215, 233, 255, 217, 216, 233, 255, 218, 216, 233, 255, 218, 216, 233, 255, 218, 216, 234, 255, 218, 216, 234, 255, 218, 216, 234, 255, 219, 216, 234, 255, 219, 216, 234, 255, 219, 217, 234, 255, 219, 217, 234, 255, 219, 217, 234, 255, 225, 221, 237, 255, 225, 222, 237, 255, 225, 222, 237, 255, 226, 222, 237, 255, 226, 222, 237, 255, 226, 222, 237, 255, 226, 222, 237, 255, 226, 222, 237, 255, 226, 223, 237, 255, 227, 223, 237, 255, 227, 223, 237, 255, 227, 223, 237, 255, 227, 223, 237, 255, 227, 223, 238, 255, 227, 223, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 229, 224, 238, 255, 229, 225, 238, 255, 229, 225, 238, 255, 229, 225, 238, 255, 229, 225, 238, 255, 229, 225, 239, 255, 230, 225, 239, 255, 230, 225, 239, 255, 230, 225, 239, 255, 230, 226, 239, 255, 230, 226, 239, 255, 230, 226, 239, 255, 231, 226, 239, 255, 231, 226, 239, 255, 231, 226, 239, 255, 231, 226, 239, 255, 231, 227, 239, 255, 231, 227, 239, 255, 232, 227, 240, 255, 232, 227, 240, 255, 232, 227, 240, 255, 232, 227, 240, 255, 232, 227, 240, 255, 232, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 229, 240, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 231, 241, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 237, 231, 242, 255, 237, 231, 242, 255, 237, 231, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 243, 255, 238, 232, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 240, 233, 243, 255, 240, 233, 243, 255, 240, 233, 243, 255, 240, 234, 243, 255, 240, 234, 243, 255, 240, 234, 243, 255, 240, 234, 243, 255, 240, 234, 243, 255, 241, 234, 243, 255, 241, 234, 243, 255, 241, 234, 243, 255, 241, 234, 244, 255, 241, 234, 244, 255, 241, 234, 244, 255, 241, 235, 244, 255, 241, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 245, 255, 243, 236, 245, 255, 244, 236, 245, 255, 244, 236, 245, 255, 244, 237, 245, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 250, 241, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 251, 242, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 249, 255, 251, 243, 249, 255, 252, 243, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 254, 245, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuBu_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 2, 55, 88, 0, 1, 58, 91, 24, 1, 60, 94, 49, 1, 62, 97, 74, 1, 64, 100, 99, 1, 66, 103, 124, 1, 68, 106, 149, 2, 77, 120, 174, 2, 79, 123, 199, 2, 80, 126, 224, 2, 82, 129, 249, 3, 84, 133, 255, 3, 86, 136, 255, 3, 88, 139, 255, 3, 90, 141, 255, 3, 91, 143, 255, 3, 92, 145, 255, 3, 94, 147, 255, 3, 95, 149, 255, 3, 96, 151, 255, 3, 97, 152, 255, 3, 98, 154, 255, 4, 104, 163, 255, 4, 105, 165, 255, 4, 106, 167, 255, 4, 107, 168, 255, 4, 108, 170, 255, 4, 109, 172, 255, 4, 110, 174, 255, 4, 111, 175, 255, 7, 113, 176, 255, 10, 115, 177, 255, 13, 116, 178, 255, 15, 118, 179, 255, 17, 119, 180, 255, 20, 121, 180, 255, 22, 122, 181, 255, 24, 123, 182, 255, 36, 131, 186, 255, 38, 133, 186, 255, 40, 134, 187, 255, 42, 135, 188, 255, 44, 137, 188, 255, 46, 138, 189, 255, 48, 140, 190, 255, 50, 141, 190, 255, 52, 142, 191, 255, 53, 143, 191, 255, 57, 144, 192, 255, 60, 145, 193, 255, 63, 146, 193, 255, 66, 147, 194, 255, 69, 148, 195, 255, 71, 149, 195, 255, 74, 150, 196, 255, 76, 151, 196, 255, 78, 152, 197, 255, 81, 153, 197, 255, 95, 159, 201, 255, 97, 160, 201, 255, 100, 161, 202, 255, 102, 162, 203, 255, 104, 163, 203, 255, 105, 164, 204, 255, 107, 165, 204, 255, 109, 165, 205, 255, 111, 166, 205, 255, 113, 167, 206, 255, 115, 168, 206, 255, 116, 169, 207, 255, 118, 169, 207, 255, 120, 170, 208, 255, 122, 171, 208, 255, 124, 171, 208, 255, 125, 172, 209, 255, 127, 173, 209, 255, 129, 173, 210, 255, 130, 174, 210, 255, 132, 174, 210, 255, 133, 175, 211, 255, 135, 176, 211, 255, 136, 176, 212, 255, 148, 181, 214, 255, 149, 181, 215, 255, 151, 182, 215, 255, 152, 183, 215, 255, 154, 183, 216, 255, 155, 184, 216, 255, 156, 184, 216, 255, 157, 185, 217, 255, 159, 185, 217, 255, 160, 186, 217, 255, 161, 186, 217, 255, 162, 187, 218, 255, 164, 188, 218, 255, 165, 188, 218, 255, 166, 189, 219, 255, 167, 189, 219, 255, 168, 190, 219, 255, 170, 190, 220, 255, 171, 191, 220, 255, 172, 191, 220, 255, 173, 191, 220, 255, 174, 192, 221, 255, 175, 192, 221, 255, 176, 193, 221, 255, 177, 193, 222, 255, 178, 194, 222, 255, 179, 194, 222, 255, 180, 195, 222, 255, 181, 195, 223, 255, 182, 196, 223, 255, 183, 196, 223, 255, 192, 200, 226, 255, 193, 201, 226, 255, 194, 201, 226, 255, 195, 202, 226, 255, 196, 202, 226, 255, 197, 203, 227, 255, 198, 203, 227, 255, 198, 203, 227, 255, 199, 204, 227, 255, 200, 204, 228, 255, 201, 205, 228, 255, 202, 205, 228, 255, 202, 205, 228, 255, 203, 206, 228, 255, 204, 206, 228, 255, 204, 207, 229, 255, 205, 207, 229, 255, 206, 207, 229, 255, 206, 208, 229, 255, 207, 208, 229, 255, 208, 209, 230, 255, 208, 209, 230, 255, 209, 209, 230, 255, 209, 210, 230, 255, 210, 210, 230, 255, 210, 210, 231, 255, 211, 211, 231, 255, 212, 211, 231, 255, 212, 212, 231, 255, 213, 212, 231, 255, 213, 212, 232, 255, 213, 213, 232, 255, 214, 213, 232, 255, 214, 213, 232, 255, 215, 214, 232, 255, 215, 214, 232, 255, 216, 214, 233, 255, 216, 215, 233, 255, 217, 215, 233, 255, 217, 215, 233, 255, 217, 216, 233, 255, 218, 216, 234, 255, 218, 216, 234, 255, 219, 216, 234, 255, 219, 217, 234, 255, 225, 221, 237, 255, 225, 222, 237, 255, 226, 222, 237, 255, 226, 222, 237, 255, 227, 223, 237, 255, 227, 223, 237, 255, 227, 223, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 228, 224, 238, 255, 229, 224, 238, 255, 229, 225, 238, 255, 229, 225, 238, 255, 230, 225, 239, 255, 230, 226, 239, 255, 230, 226, 239, 255, 231, 226, 239, 255, 231, 226, 239, 255, 231, 227, 239, 255, 232, 227, 239, 255, 232, 227, 240, 255, 232, 227, 240, 255, 232, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 229, 240, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 237, 231, 242, 255, 237, 231, 242, 255, 237, 231, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 242, 255, 238, 232, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 239, 233, 243, 255, 240, 233, 243, 255, 240, 233, 243, 255, 240, 234, 243, 255, 240, 234, 243, 255, 240, 234, 243, 255, 240, 234, 243, 255, 241, 234, 243, 255, 241, 234, 243, 255, 241, 234, 243, 255, 241, 234, 244, 255, 241, 234, 244, 255, 241, 235, 244, 255, 241, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 242, 235, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 244, 255, 243, 236, 245, 255, 243, 236, 245, 255, 243, 236, 245, 255, 244, 236, 245, 255, 244, 236, 245, 255, 244, 237, 245, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 248, 240, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 249, 241, 247, 255, 250, 241, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 250, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 242, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 248, 255, 251, 243, 249, 255, 251, 243, 249, 255, 251, 243, 249, 255, 252, 243, 249, 255, 252, 243, 249, 255, 252, 243, 249, 255, 252, 243, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 252, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 244, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 249, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 253, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 245, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 246, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255, 254, 247, 250, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuBu_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
