/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/PuOr.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 45, 0, 75, 255, 84, 39, 136, 255, 128, 115, 172, 255, 178, 171, 210, 255, 216, 218, 235, 255, 247, 247, 247, 255, 254, 224, 182, 255, 253, 184, 99, 255, 224, 130, 20, 255, 179, 88, 6, 255, 127, 59, 8, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuOr_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 44, 0, 75, 0, 45, 0, 75, 7, 45, 0, 76, 14, 46, 0, 76, 22, 46, 0, 77, 29, 46, 1, 77, 37, 47, 1, 78, 44, 47, 1, 78, 52, 48, 2, 79, 59, 48, 2, 80, 67, 48, 2, 80, 74, 49, 2, 81, 82, 49, 3, 81, 89, 49, 3, 82, 97, 50, 3, 82, 104, 50, 4, 83, 112, 51, 4, 84, 119, 51, 4, 84, 127, 51, 5, 85, 134, 52, 5, 85, 141, 52, 5, 86, 149, 53, 6, 86, 156, 53, 6, 87, 164, 53, 7, 88, 171, 54, 7, 88, 179, 54, 7, 89, 186, 54, 8, 89, 194, 55, 8, 90, 201, 55, 9, 90, 209, 56, 9, 91, 216, 56, 10, 92, 224, 56, 10, 92, 231, 57, 10, 93, 239, 57, 11, 93, 246, 58, 11, 94, 254, 58, 12, 94, 255, 58, 12, 95, 255, 59, 13, 96, 255, 59, 13, 96, 255, 59, 13, 97, 255, 60, 14, 97, 255, 60, 14, 98, 255, 61, 15, 99, 255, 61, 15, 99, 255, 61, 15, 100, 255, 62, 16, 100, 255, 62, 16, 101, 255, 62, 17, 102, 255, 63, 17, 102, 255, 63, 18, 103, 255, 64, 18, 103, 255, 64, 18, 104, 255, 64, 19, 105, 255, 65, 19, 105, 255, 65, 20, 106, 255, 66, 20, 106, 255, 66, 20, 107, 255, 66, 21, 108, 255, 67, 21, 108, 255, 67, 22, 109, 255, 67, 22, 109, 255, 68, 22, 110, 255, 68, 23, 111, 255, 69, 23, 111, 255, 69, 23, 112, 255, 69, 24, 112, 255, 70, 24, 113, 255, 70, 25, 114, 255, 70, 25, 114, 255, 71, 25, 115, 255, 71, 26, 115, 255, 72, 26, 116, 255, 72, 27, 117, 255, 72, 27, 117, 255, 73, 27, 118, 255, 73, 28, 118, 255, 74, 28, 119, 255, 74, 29, 120, 255, 74, 29, 120, 255, 75, 29, 121, 255, 75, 30, 122, 255, 75, 30, 122, 255, 76, 31, 123, 255, 76, 31, 123, 255, 77, 31, 124, 255, 77, 32, 125, 255, 77, 32, 125, 255, 78, 32, 126, 255, 78, 33, 126, 255, 78, 33, 127, 255, 79, 34, 128, 255, 79, 34, 128, 255, 80, 34, 129, 255, 80, 35, 130, 255, 80, 35, 130, 255, 81, 36, 131, 255, 81, 36, 131, 255, 81, 36, 132, 255, 82, 37, 133, 255, 82, 37, 133, 255, 83, 38, 134, 255, 83, 38, 135, 255, 83, 38, 135, 255, 84, 39, 136, 255, 84, 40, 136, 255, 84, 41, 137, 255, 85, 42, 137, 255, 85, 42, 137, 255, 86, 43, 138, 255, 86, 44, 138, 255, 86, 45, 139, 255, 87, 46, 139, 255, 87, 47, 139, 255, 88, 47, 140, 255, 88, 48, 140, 255, 88, 49, 141, 255, 89, 50, 141, 255, 89, 51, 141, 255, 89, 51, 142, 255, 90, 52, 142, 255, 90, 53, 143, 255, 91, 54, 143, 255, 91, 54, 143, 255, 91, 55, 144, 255, 92, 56, 144, 255, 92, 57, 144, 255, 93, 57, 145, 255, 93, 58, 145, 255, 93, 59, 146, 255, 94, 60, 146, 255, 94, 61, 146, 255, 95, 61, 147, 255, 95, 62, 147, 255, 95, 63, 147, 255, 96, 64, 148, 255, 96, 64, 148, 255, 97, 65, 149, 255, 97, 66, 149, 255, 97, 67, 149, 255, 98, 67, 150, 255, 98, 68, 150, 255, 99, 69, 150, 255, 99, 69, 151, 255, 99, 70, 151, 255, 100, 71, 152, 255, 100, 72, 152, 255, 101, 72, 152, 255, 101, 73, 153, 255, 102, 74, 153, 255, 102, 75, 153, 255, 102, 75, 154, 255, 103, 76, 154, 255, 103, 77, 154, 255, 104, 78, 155, 255, 104, 78, 155, 255, 105, 79, 155, 255, 105, 80, 156, 255, 105, 80, 156, 255, 106, 81, 156, 255, 106, 82, 157, 255, 107, 83, 157, 255, 107, 83, 157, 255, 108, 84, 158, 255, 108, 85, 158, 255, 108, 85, 159, 255, 109, 86, 159, 255, 109, 87, 159, 255, 110, 88, 160, 255, 110, 88, 160, 255, 111, 89, 160, 255, 111, 90, 161, 255, 112, 90, 161, 255, 112, 91, 161, 255, 112, 92, 162, 255, 113, 93, 162, 255, 113, 93, 162, 255, 114, 94, 163, 255, 114, 95, 163, 255, 115, 95, 163, 255, 115, 96, 163, 255, 116, 97, 164, 255, 116, 98, 164, 255, 117, 98, 164, 255, 117, 99, 165, 255, 117, 100, 165, 255, 118, 100, 165, 255, 118, 101, 166, 255, 119, 102, 166, 255, 119, 103, 166, 255, 120, 103, 167, 255, 120, 104, 167, 255, 121, 105, 167, 255, 121, 105, 168, 255, 122, 106, 168, 255, 122, 107, 168, 255, 123, 108, 169, 255, 123, 108, 169, 255, 124, 109, 169, 255, 124, 110, 169, 255, 125, 110, 170, 255, 125, 111, 170, 255, 126, 112, 170, 255, 126, 113, 171, 255, 127, 113, 171, 255, 127, 114, 171, 255, 128, 115, 172, 255, 128, 115, 172, 255, 129, 116, 172, 255, 129, 116, 173, 255, 129, 117, 173, 255, 130, 117, 173, 255, 130, 118, 174, 255, 131, 118, 174, 255, 131, 119, 175, 255, 132, 119, 175, 255, 132, 120, 175, 255, 133, 120, 176, 255, 133, 121, 176, 255, 134, 122, 176, 255, 134, 122, 177, 255, 135, 123, 177, 255, 135, 123, 178, 255, 136, 124, 178, 255, 136, 124, 178, 255, 137, 125, 179, 255, 137, 125, 179, 255, 138, 126, 179, 255, 138, 126, 180, 255, 139, 127, 180, 255, 139, 127, 181, 255, 139, 128, 181, 255, 140, 129, 181, 255, 140, 129, 182, 255, 141, 130, 182, 255, 141, 130, 182, 255, 142, 131, 183, 255, 142, 131, 183, 255, 143, 132, 183, 255, 143, 132, 184, 255, 144, 133, 184, 255, 144, 133, 185, 255, 145, 134, 185, 255, 145, 135, 185, 255, 146, 135, 186, 255, 146, 136, 186, 255, 147, 136, 186, 255, 147, 137, 187, 255, 148, 137, 187, 255, 148, 138, 188, 255, 149, 138, 188, 255, 149, 139, 188, 255, 150, 139, 189, 255, 150, 140, 189, 255, 151, 141, 189, 255, 151, 141, 190, 255, 152, 142, 190, 255, 152, 142, 191, 255, 153, 143, 191, 255, 153, 143, 191, 255, 154, 144, 192, 255, 154, 144, 192, 255, 155, 145, 192, 255, 155, 145, 193, 255, 155, 146, 193, 255, 156, 147, 194, 255, 156, 147, 194, 255, 157, 148, 194, 255, 157, 148, 195, 255, 158, 149, 195, 255, 158, 149, 195, 255, 159, 150, 196, 255, 159, 150, 196, 255, 160, 151, 196, 255, 160, 151, 197, 255, 161, 152, 197, 255, 161, 153, 198, 255, 162, 153, 198, 255, 162, 154, 198, 255, 163, 154, 199, 255, 163, 155, 199, 255, 164, 155, 199, 255, 164, 156, 200, 255, 165, 156, 200, 255, 165, 157, 201, 255, 166, 158, 201, 255, 166, 158, 201, 255, 167, 159, 202, 255, 167, 159, 202, 255, 168, 160, 202, 255, 168, 160, 203, 255, 169, 161, 203, 255, 169, 161, 204, 255, 170, 162, 204, 255, 170, 163, 204, 255, 171, 163, 205, 255, 171, 164, 205, 255, 172, 164, 205, 255, 172, 165, 206, 255, 173, 165, 206, 255, 173, 166, 206, 255, 174, 166, 207, 255, 174, 167, 207, 255, 175, 168, 208, 255, 175, 168, 208, 255, 176, 169, 208, 255, 176, 169, 209, 255, 177, 170, 209, 255, 177, 170, 209, 255, 178, 171, 210, 255, 178, 171, 210, 255, 178, 172, 210, 255, 179, 172, 211, 255, 179, 173, 211, 255, 179, 173, 211, 255, 180, 174, 211, 255, 180, 174, 212, 255, 180, 175, 212, 255, 181, 175, 212, 255, 181, 176, 212, 255, 181, 176, 213, 255, 182, 176, 213, 255, 182, 177, 213, 255, 182, 177, 213, 255, 183, 178, 214, 255, 183, 178, 214, 255, 183, 179, 214, 255, 184, 179, 214, 255, 184, 180, 215, 255, 184, 180, 215, 255, 185, 181, 215, 255, 185, 181, 215, 255, 185, 182, 216, 255, 186, 182, 216, 255, 186, 182, 216, 255, 186, 183, 217, 255, 187, 183, 217, 255, 187, 184, 217, 255, 187, 184, 217, 255, 188, 185, 218, 255, 188, 185, 218, 255, 188, 186, 218, 255, 189, 186, 218, 255, 189, 187, 219, 255, 189, 187, 219, 255, 190, 188, 219, 255, 190, 188, 219, 255, 190, 188, 220, 255, 191, 189, 220, 255, 191, 189, 220, 255, 192, 190, 220, 255, 192, 190, 221, 255, 192, 191, 221, 255, 193, 191, 221, 255, 193, 192, 221, 255, 193, 192, 222, 255, 194, 193, 222, 255, 194, 193, 222, 255, 194, 194, 222, 255, 195, 194, 222, 255, 195, 194, 223, 255, 196, 195, 223, 255, 196, 195, 223, 255, 196, 196, 223, 255, 197, 196, 224, 255, 197, 197, 224, 255, 197, 197, 224, 255, 198, 198, 224, 255, 198, 198, 225, 255, 199, 199, 225, 255, 199, 199, 225, 255, 199, 199, 225, 255, 200, 200, 226, 255, 200, 200, 226, 255, 200, 201, 226, 255, 201, 201, 226, 255, 201, 202, 227, 255, 202, 202, 227, 255, 202, 203, 227, 255, 202, 203, 227, 255, 203, 204, 228, 255, 203, 204, 228, 255, 204, 204, 228, 255, 204, 205, 228, 255, 204, 205, 228, 255, 205, 206, 229, 255, 205, 206, 229, 255, 206, 207, 229, 255, 206, 207, 229, 255, 206, 208, 230, 255, 207, 208, 230, 255, 207, 209, 230, 255, 208, 209, 230, 255, 208, 210, 231, 255, 208, 210, 231, 255, 209, 210, 231, 255, 209, 211, 231, 255, 210, 211, 231, 255, 210, 212, 232, 255, 211, 212, 232, 255, 211, 213, 232, 255, 211, 213, 232, 255, 212, 214, 233, 255, 212, 214, 233, 255, 213, 215, 233, 255, 213, 215, 233, 255, 214, 215, 233, 255, 214, 216, 234, 255, 214, 216, 234, 255, 215, 217, 234, 255, 215, 217, 234, 255, 236, 213, 219, 255, 236, 213, 219, 255, 236, 214, 220, 255, 236, 214, 220, 255, 236, 214, 221, 255, 236, 215, 221, 255, 236, 215, 222, 255, 236, 215, 222, 255, 236, 216, 223, 255, 236, 216, 223, 255, 236, 216, 223, 255, 236, 217, 224, 255, 236, 217, 224, 255, 236, 217, 225, 255, 236, 218, 225, 255, 236, 218, 226, 255, 236, 218, 226, 255, 236, 219, 226, 255, 236, 219, 227, 255, 236, 219, 227, 255, 236, 220, 228, 255, 236, 220, 228, 255, 236, 220, 228, 255, 236, 221, 229, 255, 236, 221, 229, 255, 236, 221, 229, 255, 236, 222, 230, 255, 236, 222, 230, 255, 236, 223, 231, 255, 236, 223, 231, 255, 236, 223, 231, 255, 236, 224, 232, 255, 236, 224, 232, 255, 236, 224, 232, 255, 236, 225, 233, 255, 236, 225, 233, 255, 236, 225, 233, 255, 236, 226, 234, 255, 236, 226, 234, 255, 236, 226, 234, 255, 237, 227, 235, 255, 237, 227, 235, 255, 237, 227, 235, 255, 237, 228, 235, 255, 237, 228, 236, 255, 237, 228, 236, 255, 237, 229, 236, 255, 237, 229, 237, 255, 237, 229, 237, 255, 237, 230, 237, 255, 237, 230, 237, 255, 237, 230, 238, 255, 237, 231, 238, 255, 237, 231, 238, 255, 237, 231, 238, 255, 238, 232, 239, 255, 238, 232, 239, 255, 238, 232, 239, 255, 238, 233, 239, 255, 238, 233, 240, 255, 238, 233, 240, 255, 238, 234, 240, 255, 238, 234, 240, 255, 238, 234, 240, 255, 238, 235, 241, 255, 239, 235, 241, 255, 239, 235, 241, 255, 239, 236, 241, 255, 239, 236, 241, 255, 239, 236, 242, 255, 239, 237, 242, 255, 239, 237, 242, 255, 240, 237, 242, 255, 240, 238, 242, 255, 240, 238, 243, 255, 240, 238, 243, 255, 240, 239, 243, 255, 240, 239, 243, 255, 241, 239, 243, 255, 241, 240, 243, 255, 241, 240, 244, 255, 241, 240, 244, 255, 241, 241, 244, 255, 242, 241, 244, 255, 242, 241, 244, 255, 242, 241, 244, 255, 242, 242, 244, 255, 243, 242, 245, 255, 243, 242, 245, 255, 243, 243, 245, 255, 243, 243, 245, 255, 243, 243, 245, 255, 244, 244, 245, 255, 244, 244, 245, 255, 244, 244, 246, 255, 245, 244, 246, 255, 245, 245, 246, 255, 245, 245, 246, 255, 245, 245, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 247, 247, 247, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 245, 246, 255, 248, 245, 246, 255, 248, 245, 245, 255, 248, 244, 245, 255, 249, 244, 245, 255, 249, 244, 245, 255, 249, 243, 244, 255, 250, 243, 244, 255, 250, 243, 244, 255, 251, 242, 243, 255, 251, 242, 243, 255, 251, 242, 243, 255, 252, 241, 242, 255, 252, 241, 242, 255, 252, 241, 242, 255, 253, 240, 241, 255, 253, 240, 241, 255, 253, 240, 240, 255, 254, 239, 240, 255, 254, 239, 240, 255, 254, 239, 239, 255, 255, 238, 239, 255, 255, 238, 238, 255, 255, 238, 238, 255, 255, 238, 237, 255, 255, 237, 237, 255, 255, 237, 236, 255, 255, 237, 236, 255, 255, 236, 235, 255, 255, 236, 235, 255, 255, 236, 234, 255, 255, 235, 233, 255, 255, 235, 233, 255, 255, 235, 232, 255, 255, 234, 232, 255, 255, 234, 231, 255, 255, 234, 230, 255, 255, 234, 230, 255, 255, 233, 229, 255, 255, 233, 229, 255, 255, 233, 228, 255, 255, 232, 227, 255, 255, 232, 227, 255, 255, 232, 226, 255, 255, 232, 225, 255, 255, 231, 224, 255, 255, 231, 224, 255, 255, 231, 223, 255, 255, 231, 222, 255, 255, 230, 222, 255, 255, 230, 221, 255, 255, 230, 220, 255, 255, 230, 219, 255, 255, 229, 219, 255, 255, 229, 218, 255, 255, 229, 217, 255, 255, 229, 216, 255, 255, 228, 216, 255, 255, 228, 215, 255, 255, 228, 214, 255, 255, 228, 213, 255, 255, 228, 212, 255, 255, 227, 212, 255, 255, 227, 211, 255, 255, 227, 210, 255, 255, 227, 209, 255, 255, 227, 208, 255, 255, 226, 208, 255, 255, 226, 207, 255, 255, 226, 206, 255, 255, 226, 205, 255, 255, 226, 204, 255, 255, 226, 204, 255, 255, 226, 203, 255, 255, 225, 202, 255, 255, 225, 201, 255, 255, 225, 200, 255, 255, 225, 199, 255, 255, 225, 199, 255, 255, 225, 198, 255, 255, 225, 197, 255, 255, 225, 196, 255, 255, 224, 195, 255, 255, 224, 195, 255, 255, 224, 194, 255, 255, 224, 193, 255, 255, 224, 192, 255, 255, 224, 191, 255, 255, 224, 190, 255, 255, 224, 190, 255, 255, 224, 189, 255, 255, 224, 188, 255, 255, 224, 187, 255, 255, 224, 186, 255, 255, 224, 186, 255, 255, 224, 185, 255, 255, 224, 184, 255, 255, 224, 183, 255, 254, 224, 183, 255, 254, 224, 182, 255, 253, 223, 181, 255, 253, 223, 180, 255, 253, 223, 179, 255, 253, 222, 179, 255, 253, 222, 178, 255, 253, 221, 177, 255, 253, 221, 176, 255, 253, 221, 175, 255, 253, 220, 174, 255, 253, 220, 174, 255, 253, 220, 173, 255, 253, 219, 172, 255, 253, 219, 171, 255, 253, 218, 170, 255, 253, 218, 169, 255, 253, 218, 169, 255, 253, 217, 168, 255, 253, 217, 167, 255, 253, 217, 166, 255, 253, 216, 165, 255, 253, 216, 164, 255, 253, 215, 164, 255, 253, 215, 163, 255, 253, 215, 162, 255, 253, 214, 161, 255, 253, 214, 160, 255, 253, 213, 160, 255, 253, 213, 159, 255, 253, 213, 158, 255, 253, 212, 157, 255, 253, 212, 156, 255, 253, 212, 155, 255, 253, 211, 155, 255, 253, 211, 154, 255, 253, 210, 153, 255, 253, 210, 152, 255, 253, 210, 151, 255, 253, 209, 151, 255, 253, 209, 150, 255, 253, 208, 149, 255, 253, 208, 148, 255, 253, 208, 147, 255, 253, 207, 146, 255, 253, 207, 146, 255, 253, 207, 145, 255, 253, 206, 144, 255, 253, 206, 143, 255, 253, 205, 142, 255, 253, 205, 142, 255, 253, 205, 141, 255, 253, 204, 140, 255, 253, 204, 139, 255, 253, 203, 138, 255, 253, 203, 138, 255, 253, 203, 137, 255, 253, 202, 136, 255, 253, 202, 135, 255, 253, 201, 134, 255, 253, 201, 134, 255, 253, 201, 133, 255, 253, 200, 132, 255, 253, 200, 131, 255, 253, 200, 130, 255, 253, 199, 130, 255, 253, 199, 129, 255, 253, 198, 128, 255, 253, 198, 127, 255, 253, 198, 126, 255, 253, 197, 126, 255, 253, 197, 125, 255, 253, 196, 124, 255, 253, 196, 123, 255, 253, 196, 122, 255, 253, 195, 122, 255, 253, 195, 121, 255, 253, 194, 120, 255, 253, 194, 119, 255, 253, 194, 118, 255, 253, 193, 118, 255, 253, 193, 117, 255, 253, 192, 116, 255, 253, 192, 115, 255, 253, 192, 114, 255, 253, 191, 114, 255, 253, 191, 113, 255, 253, 190, 112, 255, 253, 190, 111, 255, 253, 190, 110, 255, 253, 189, 110, 255, 253, 189, 109, 255, 253, 188, 108, 255, 253, 188, 107, 255, 253, 188, 106, 255, 253, 187, 106, 255, 253, 187, 105, 255, 253, 186, 104, 255, 253, 186, 103, 255, 253, 185, 102, 255, 253, 185, 102, 255, 253, 185, 101, 255, 253, 184, 100, 255, 253, 184, 99, 255, 252, 183, 98, 255, 252, 183, 98, 255, 252, 182, 97, 255, 252, 182, 96, 255, 251, 181, 96, 255, 251, 181, 95, 255, 251, 180, 94, 255, 250, 180, 93, 255, 250, 179, 93, 255, 250, 179, 92, 255, 250, 178, 91, 255, 249, 178, 91, 255, 249, 177, 90, 255, 249, 177, 89, 255, 249, 176, 88, 255, 248, 176, 88, 255, 248, 175, 87, 255, 248, 175, 86, 255, 247, 174, 86, 255, 247, 173, 85, 255, 247, 173, 84, 255, 247, 172, 84, 255, 246, 172, 83, 255, 246, 171, 82, 255, 246, 171, 81, 255, 245, 170, 81, 255, 245, 170, 80, 255, 245, 169, 79, 255, 245, 169, 79, 255, 244, 168, 78, 255, 244, 168, 77, 255, 244, 167, 76, 255, 244, 167, 76, 255, 243, 166, 75, 255, 243, 166, 74, 255, 243, 165, 74, 255, 242, 165, 73, 255, 242, 164, 72, 255, 242, 164, 71, 255, 242, 163, 71, 255, 241, 162, 70, 255, 241, 162, 69, 255, 241, 161, 69, 255, 240, 161, 68, 255, 240, 160, 67, 255, 240, 160, 66, 255, 240, 159, 66, 255, 239, 159, 65, 255, 239, 158, 64, 255, 239, 158, 64, 255, 238, 157, 63, 255, 238, 157, 62, 255, 238, 156, 61, 255, 238, 156, 61, 255, 237, 155, 60, 255, 237, 155, 59, 255, 237, 154, 58, 255, 236, 154, 58, 255, 236, 153, 57, 255, 236, 153, 56, 255, 236, 152, 55, 255, 235, 151, 55, 255, 235, 151, 54, 255, 235, 150, 53, 255, 234, 150, 53, 255, 234, 149, 52, 255, 234, 149, 51, 255, 234, 148, 50, 255, 233, 148, 49, 255, 233, 147, 49, 255, 233, 147, 48, 255, 232, 146, 47, 255, 232, 146, 46, 255, 232, 145, 46, 255, 232, 145, 45, 255, 231, 144, 44, 255, 231, 144, 43, 255, 231, 143, 42, 255, 230, 142, 42, 255, 230, 142, 41, 255, 230, 141, 40, 255, 230, 141, 39, 255, 229, 140, 38, 255, 229, 140, 38, 255, 229, 139, 37, 255, 228, 139, 36, 255, 228, 138, 35, 255, 228, 138, 34, 255, 228, 137, 33, 255, 227, 137, 32, 255, 227, 136, 32, 255, 227, 136, 31, 255, 226, 135, 30, 255, 226, 134, 29, 255, 226, 134, 28, 255, 226, 133, 27, 255, 225, 133, 26, 255, 225, 132, 25, 255, 225, 132, 24, 255, 224, 131, 23, 255, 224, 131, 22, 255, 224, 130, 21, 255, 224, 130, 20, 255, 223, 129, 19, 255, 223, 129, 19, 255, 222, 128, 19, 255, 222, 128, 19, 255, 221, 127, 19, 255, 221, 127, 19, 255, 221, 127, 19, 255, 220, 126, 18, 255, 220, 126, 18, 255, 219, 125, 18, 255, 219, 125, 18, 255, 218, 125, 18, 255, 218, 124, 18, 255, 218, 124, 18, 255, 217, 123, 17, 255, 217, 123, 17, 255, 216, 122, 17, 255, 216, 122, 17, 255, 215, 122, 17, 255, 215, 121, 17, 255, 214, 121, 17, 255, 214, 120, 16, 255, 214, 120, 16, 255, 213, 119, 16, 255, 213, 119, 16, 255, 212, 119, 16, 255, 212, 118, 16, 255, 211, 118, 16, 255, 211, 117, 16, 255, 211, 117, 15, 255, 210, 117, 15, 255, 210, 116, 15, 255, 209, 116, 15, 255, 209, 115, 15, 255, 208, 115, 15, 255, 208, 114, 15, 255, 207, 114, 14, 255, 207, 114, 14, 255, 207, 113, 14, 255, 206, 113, 14, 255, 206, 112, 14, 255, 205, 112, 14, 255, 205, 112, 14, 255, 204, 111, 13, 255, 204, 111, 13, 255, 204, 110, 13, 255, 203, 110, 13, 255, 203, 110, 13, 255, 202, 109, 13, 255, 202, 109, 13, 255, 201, 108, 12, 255, 201, 108, 12, 255, 200, 107, 12, 255, 200, 107, 12, 255, 200, 107, 12, 255, 199, 106, 12, 255, 199, 106, 12, 255, 198, 105, 11, 255, 198, 105, 11, 255, 197, 105, 11, 255, 197, 104, 11, 255, 197, 104, 11, 255, 196, 103, 11, 255, 196, 103, 11, 255, 195, 103, 10, 255, 195, 102, 10, 255, 194, 102, 10, 255, 194, 101, 10, 255, 193, 101, 10, 255, 193, 101, 10, 255, 193, 100, 10, 255, 192, 100, 9, 255, 192, 99, 9, 255, 191, 99, 9, 255, 191, 99, 9, 255, 190, 98, 9, 255, 190, 98, 9, 255, 189, 97, 9, 255, 189, 97, 8, 255, 189, 97, 8, 255, 188, 96, 8, 255, 188, 96, 8, 255, 187, 95, 8, 255, 187, 95, 8, 255, 186, 94, 8, 255, 186, 94, 8, 255, 185, 94, 7, 255, 185, 93, 7, 255, 185, 93, 7, 255, 184, 92, 7, 255, 184, 92, 7, 255, 183, 92, 7, 255, 183, 91, 7, 255, 182, 91, 7, 255, 182, 91, 6, 255, 181, 90, 6, 255, 181, 90, 6, 255, 181, 89, 6, 255, 180, 89, 6, 255, 180, 89, 6, 255, 179, 88, 6, 255, 179, 88, 6, 255, 178, 87, 6, 255, 178, 87, 6, 255, 177, 87, 6, 255, 177, 86, 6, 255, 176, 86, 6, 255, 176, 86, 6, 255, 175, 86, 6, 255, 175, 85, 6, 255, 174, 85, 6, 255, 174, 85, 6, 255, 173, 84, 6, 255, 173, 84, 6, 255, 172, 84, 6, 255, 172, 84, 6, 255, 171, 83, 6, 255, 171, 83, 6, 255, 170, 83, 6, 255, 170, 82, 6, 255, 169, 82, 6, 255, 169, 82, 6, 255, 168, 81, 6, 255, 167, 81, 7, 255, 167, 81, 7, 255, 166, 81, 7, 255, 166, 80, 7, 255, 165, 80, 7, 255, 165, 80, 7, 255, 164, 79, 7, 255, 164, 79, 7, 255, 163, 79, 7, 255, 163, 79, 7, 255, 162, 78, 7, 255, 162, 78, 7, 255, 161, 78, 7, 255, 161, 77, 7, 255, 160, 77, 7, 255, 160, 77, 7, 255, 159, 77, 7, 255, 159, 76, 7, 255, 158, 76, 7, 255, 158, 76, 7, 255, 157, 75, 7, 255, 157, 75, 7, 255, 156, 75, 7, 255, 156, 75, 7, 255, 155, 74, 7, 255, 155, 74, 7, 255, 154, 74, 7, 255, 154, 73, 7, 255, 153, 73, 7, 255, 153, 73, 7, 255, 152, 73, 7, 255, 152, 72, 7, 255, 151, 72, 7, 255, 151, 72, 7, 255, 150, 71, 7, 255, 150, 71, 7, 255, 149, 71, 7, 255, 149, 71, 7, 255, 148, 70, 7, 255, 148, 70, 7, 255, 147, 70, 7, 255, 147, 69, 7, 255, 146, 69, 7, 255, 146, 69, 8, 255, 145, 69, 8, 255, 145, 68, 8, 255, 144, 68, 8, 255, 144, 68, 8, 255, 143, 68, 8, 255, 143, 67, 8, 255, 142, 67, 8, 255, 142, 67, 8, 255, 141, 66, 8, 255, 141, 66, 8, 255, 140, 66, 8, 255, 140, 66, 8, 255, 139, 65, 8, 255, 139, 65, 8, 255, 138, 65, 8, 255, 137, 64, 8, 255, 137, 64, 8, 255, 136, 64, 8, 255, 136, 64, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 134, 63, 8, 255, 134, 63, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 132, 62, 8, 255, 132, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 130, 61, 8, 255, 130, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 128, 60, 8, 255, 128, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuOr_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 44, 0, 75, 0, 45, 0, 75, 7, 45, 0, 75, 14, 45, 0, 76, 22, 46, 0, 76, 29, 46, 1, 77, 37, 46, 1, 77, 44, 47, 1, 78, 52, 47, 1, 78, 59, 47, 1, 79, 67, 48, 2, 79, 74, 48, 2, 79, 82, 48, 2, 80, 89, 48, 2, 80, 97, 49, 3, 81, 104, 49, 3, 81, 112, 49, 3, 82, 119, 50, 3, 82, 127, 50, 4, 83, 134, 50, 4, 83, 141, 51, 4, 84, 149, 51, 5, 84, 156, 51, 5, 84, 164, 52, 5, 85, 171, 52, 6, 85, 179, 52, 6, 86, 186, 52, 6, 86, 194, 53, 7, 87, 201, 53, 7, 87, 209, 53, 7, 88, 216, 54, 8, 88, 224, 54, 8, 89, 231, 54, 8, 89, 239, 55, 9, 90, 246, 55, 9, 90, 254, 55, 9, 90, 255, 56, 10, 91, 255, 56, 10, 91, 255, 56, 10, 92, 255, 56, 11, 92, 255, 57, 11, 93, 255, 57, 11, 93, 255, 57, 12, 94, 255, 58, 12, 94, 255, 58, 12, 95, 255, 58, 13, 95, 255, 59, 13, 96, 255, 59, 13, 96, 255, 59, 14, 97, 255, 60, 14, 97, 255, 60, 14, 98, 255, 60, 15, 98, 255, 68, 23, 111, 255, 69, 23, 111, 255, 69, 23, 112, 255, 69, 24, 112, 255, 69, 24, 113, 255, 70, 24, 113, 255, 70, 25, 114, 255, 70, 25, 114, 255, 71, 25, 115, 255, 71, 26, 115, 255, 71, 26, 116, 255, 72, 26, 116, 255, 72, 26, 116, 255, 72, 27, 117, 255, 72, 27, 117, 255, 73, 27, 118, 255, 73, 28, 118, 255, 73, 28, 119, 255, 74, 28, 119, 255, 74, 29, 120, 255, 74, 29, 120, 255, 75, 29, 121, 255, 75, 30, 121, 255, 75, 30, 122, 255, 76, 30, 122, 255, 76, 31, 123, 255, 76, 31, 123, 255, 76, 31, 124, 255, 77, 32, 124, 255, 77, 32, 125, 255, 77, 32, 125, 255, 78, 32, 126, 255, 78, 33, 126, 255, 78, 33, 127, 255, 79, 33, 127, 255, 79, 34, 128, 255, 79, 34, 128, 255, 79, 34, 129, 255, 80, 35, 129, 255, 80, 35, 130, 255, 80, 35, 130, 255, 81, 36, 131, 255, 81, 36, 131, 255, 81, 36, 132, 255, 82, 36, 132, 255, 82, 37, 133, 255, 82, 37, 133, 255, 82, 37, 134, 255, 83, 38, 134, 255, 83, 38, 135, 255, 83, 38, 135, 255, 84, 39, 136, 255, 84, 40, 136, 255, 84, 40, 136, 255, 85, 41, 137, 255, 85, 42, 137, 255, 85, 42, 137, 255, 85, 43, 138, 255, 86, 44, 138, 255, 86, 44, 138, 255, 86, 45, 139, 255, 87, 46, 139, 255, 87, 46, 139, 255, 87, 47, 140, 255, 88, 47, 140, 255, 88, 48, 140, 255, 88, 49, 140, 255, 89, 49, 141, 255, 89, 50, 141, 255, 89, 51, 141, 255, 89, 51, 142, 255, 90, 52, 142, 255, 90, 52, 142, 255, 90, 53, 143, 255, 91, 54, 143, 255, 91, 54, 143, 255, 91, 55, 144, 255, 92, 56, 144, 255, 92, 56, 144, 255, 92, 57, 144, 255, 93, 57, 145, 255, 93, 58, 145, 255, 93, 59, 145, 255, 94, 59, 146, 255, 94, 60, 146, 255, 94, 60, 146, 255, 95, 61, 147, 255, 95, 62, 147, 255, 95, 62, 147, 255, 96, 63, 147, 255, 96, 63, 148, 255, 96, 64, 148, 255, 97, 64, 148, 255, 97, 65, 149, 255, 97, 66, 149, 255, 98, 66, 149, 255, 98, 67, 149, 255, 98, 67, 150, 255, 99, 68, 150, 255, 99, 69, 150, 255, 99, 69, 151, 255, 100, 70, 151, 255, 109, 86, 158, 255, 109, 86, 159, 255, 109, 87, 159, 255, 110, 87, 159, 255, 110, 88, 159, 255, 110, 88, 160, 255, 111, 89, 160, 255, 111, 90, 160, 255, 112, 90, 161, 255, 112, 91, 161, 255, 112, 91, 161, 255, 113, 92, 161, 255, 113, 92, 162, 255, 113, 93, 162, 255, 114, 94, 162, 255, 114, 94, 162, 255, 114, 95, 163, 255, 115, 95, 163, 255, 115, 96, 163, 255, 115, 96, 164, 255, 116, 97, 164, 255, 116, 98, 164, 255, 117, 98, 164, 255, 117, 99, 165, 255, 117, 99, 165, 255, 118, 100, 165, 255, 118, 100, 165, 255, 118, 101, 166, 255, 119, 102, 166, 255, 119, 102, 166, 255, 119, 103, 166, 255, 120, 103, 167, 255, 120, 104, 167, 255, 121, 104, 167, 255, 121, 105, 167, 255, 121, 106, 168, 255, 122, 106, 168, 255, 122, 107, 168, 255, 123, 107, 168, 255, 123, 108, 169, 255, 123, 108, 169, 255, 124, 109, 169, 255, 124, 110, 169, 255, 124, 110, 170, 255, 125, 111, 170, 255, 125, 111, 170, 255, 126, 112, 170, 255, 126, 112, 171, 255, 126, 113, 171, 255, 127, 113, 171, 255, 127, 114, 171, 255, 128, 115, 172, 255, 128, 115, 172, 255, 128, 115, 172, 255, 129, 116, 172, 255, 129, 116, 173, 255, 129, 117, 173, 255, 130, 117, 173, 255, 130, 118, 174, 255, 131, 118, 174, 255, 131, 118, 174, 255, 131, 119, 175, 255, 132, 119, 175, 255, 132, 120, 175, 255, 133, 120, 175, 255, 133, 121, 176, 255, 133, 121, 176, 255, 134, 121, 176, 255, 134, 122, 177, 255, 134, 122, 177, 255, 135, 123, 177, 255, 135, 123, 178, 255, 136, 124, 178, 255, 136, 124, 178, 255, 136, 124, 178, 255, 137, 125, 179, 255, 137, 125, 179, 255, 137, 126, 179, 255, 138, 126, 180, 255, 138, 127, 180, 255, 139, 127, 180, 255, 139, 127, 180, 255, 139, 128, 181, 255, 140, 128, 181, 255, 140, 129, 181, 255, 141, 129, 182, 255, 141, 130, 182, 255, 141, 130, 182, 255, 142, 131, 183, 255, 142, 131, 183, 255, 142, 131, 183, 255, 143, 132, 183, 255, 143, 132, 184, 255, 144, 133, 184, 255, 144, 133, 184, 255, 144, 134, 185, 255, 145, 134, 185, 255, 145, 134, 185, 255, 146, 135, 186, 255, 146, 135, 186, 255, 146, 136, 186, 255, 147, 136, 186, 255, 157, 148, 194, 255, 158, 148, 195, 255, 158, 149, 195, 255, 158, 149, 195, 255, 159, 150, 196, 255, 159, 150, 196, 255, 159, 150, 196, 255, 160, 151, 196, 255, 160, 151, 197, 255, 161, 152, 197, 255, 161, 152, 197, 255, 161, 153, 198, 255, 162, 153, 198, 255, 162, 154, 198, 255, 163, 154, 198, 255, 163, 154, 199, 255, 163, 155, 199, 255, 164, 155, 199, 255, 164, 156, 200, 255, 165, 156, 200, 255, 165, 157, 200, 255, 165, 157, 201, 255, 166, 157, 201, 255, 166, 158, 201, 255, 167, 158, 201, 255, 167, 159, 202, 255, 167, 159, 202, 255, 168, 160, 202, 255, 168, 160, 203, 255, 169, 161, 203, 255, 169, 161, 203, 255, 169, 161, 204, 255, 170, 162, 204, 255, 170, 162, 204, 255, 171, 163, 204, 255, 171, 163, 205, 255, 171, 164, 205, 255, 172, 164, 205, 255, 172, 165, 206, 255, 173, 165, 206, 255, 173, 165, 206, 255, 173, 166, 206, 255, 174, 166, 207, 255, 174, 167, 207, 255, 175, 167, 207, 255, 175, 168, 208, 255, 175, 168, 208, 255, 176, 169, 208, 255, 176, 169, 209, 255, 177, 170, 209, 255, 177, 170, 209, 255, 177, 170, 209, 255, 178, 171, 210, 255, 178, 171, 210, 255, 178, 172, 210, 255, 178, 172, 210, 255, 179, 172, 211, 255, 179, 173, 211, 255, 179, 173, 211, 255, 179, 173, 211, 255, 180, 174, 211, 255, 180, 174, 212, 255, 180, 175, 212, 255, 181, 175, 212, 255, 181, 175, 212, 255, 181, 176, 212, 255, 181, 176, 213, 255, 182, 176, 213, 255, 182, 177, 213, 255, 182, 177, 213, 255, 182, 177, 213, 255, 183, 178, 214, 255, 183, 178, 214, 255, 183, 179, 214, 255, 183, 179, 214, 255, 184, 179, 215, 255, 184, 180, 215, 255, 184, 180, 215, 255, 184, 180, 215, 255, 185, 181, 215, 255, 185, 181, 216, 255, 185, 182, 216, 255, 186, 182, 216, 255, 186, 182, 216, 255, 186, 183, 216, 255, 186, 183, 217, 255, 187, 183, 217, 255, 187, 184, 217, 255, 187, 184, 217, 255, 188, 184, 217, 255, 188, 185, 218, 255, 188, 185, 218, 255, 188, 186, 218, 255, 189, 186, 218, 255, 189, 186, 218, 255, 189, 187, 219, 255, 190, 187, 219, 255, 190, 187, 219, 255, 190, 188, 219, 255, 190, 188, 219, 255, 191, 189, 220, 255, 191, 189, 220, 255, 191, 189, 220, 255, 199, 199, 225, 255, 200, 199, 225, 255, 200, 200, 225, 255, 200, 200, 226, 255, 200, 201, 226, 255, 201, 201, 226, 255, 201, 201, 226, 255, 201, 202, 226, 255, 202, 202, 227, 255, 202, 202, 227, 255, 202, 203, 227, 255, 203, 203, 227, 255, 203, 203, 227, 255, 203, 204, 228, 255, 203, 204, 228, 255, 204, 205, 228, 255, 204, 205, 228, 255, 204, 205, 228, 255, 205, 206, 229, 255, 205, 206, 229, 255, 205, 206, 229, 255, 206, 207, 229, 255, 206, 207, 229, 255, 206, 207, 229, 255, 207, 208, 230, 255, 207, 208, 230, 255, 207, 209, 230, 255, 208, 209, 230, 255, 208, 209, 230, 255, 208, 210, 231, 255, 209, 210, 231, 255, 209, 210, 231, 255, 209, 211, 231, 255, 210, 211, 231, 255, 210, 211, 232, 255, 210, 212, 232, 255, 211, 212, 232, 255, 211, 213, 232, 255, 211, 213, 232, 255, 212, 213, 232, 255, 212, 214, 233, 255, 212, 214, 233, 255, 213, 214, 233, 255, 213, 215, 233, 255, 213, 215, 233, 255, 214, 215, 233, 255, 214, 216, 234, 255, 214, 216, 234, 255, 215, 217, 234, 255, 215, 217, 234, 255, 215, 217, 234, 255, 232, 214, 222, 255, 232, 214, 222, 255, 232, 214, 223, 255, 232, 215, 223, 255, 232, 215, 223, 255, 232, 215, 224, 255, 232, 215, 224, 255, 232, 216, 225, 255, 232, 216, 225, 255, 232, 216, 225, 255, 232, 217, 226, 255, 232, 217, 226, 255, 232, 217, 226, 255, 232, 217, 227, 255, 232, 218, 227, 255, 232, 218, 227, 255, 232, 218, 228, 255, 232, 218, 228, 255, 232, 219, 228, 255, 232, 219, 229, 255, 232, 219, 229, 255, 232, 220, 229, 255, 232, 220, 230, 255, 232, 220, 230, 255, 232, 220, 230, 255, 232, 221, 230, 255, 232, 221, 231, 255, 232, 221, 231, 255, 232, 222, 231, 255, 232, 222, 232, 255, 232, 222, 232, 255, 232, 222, 232, 255, 232, 223, 232, 255, 232, 223, 233, 255, 232, 223, 233, 255, 232, 223, 233, 255, 232, 224, 234, 255, 232, 224, 234, 255, 232, 224, 234, 255, 232, 225, 234, 255, 232, 225, 235, 255, 232, 225, 235, 255, 232, 225, 235, 255, 232, 226, 235, 255, 232, 226, 235, 255, 233, 226, 236, 255, 233, 226, 236, 255, 233, 227, 236, 255, 233, 227, 236, 255, 233, 227, 237, 255, 233, 228, 237, 255, 239, 234, 239, 255, 239, 234, 240, 255, 239, 234, 240, 255, 239, 234, 240, 255, 239, 235, 240, 255, 239, 235, 240, 255, 239, 235, 241, 255, 240, 236, 241, 255, 240, 236, 241, 255, 240, 236, 241, 255, 240, 236, 241, 255, 240, 237, 241, 255, 240, 237, 242, 255, 240, 237, 242, 255, 240, 237, 242, 255, 240, 238, 242, 255, 240, 238, 242, 255, 241, 238, 242, 255, 241, 238, 243, 255, 241, 239, 243, 255, 241, 239, 243, 255, 241, 239, 243, 255, 241, 239, 243, 255, 241, 240, 243, 255, 241, 240, 243, 255, 242, 240, 244, 255, 242, 240, 244, 255, 242, 241, 244, 255, 242, 241, 244, 255, 242, 241, 244, 255, 242, 241, 244, 255, 242, 242, 244, 255, 243, 242, 244, 255, 243, 242, 245, 255, 243, 242, 245, 255, 243, 243, 245, 255, 243, 243, 245, 255, 243, 243, 245, 255, 244, 243, 245, 255, 244, 244, 245, 255, 244, 244, 245, 255, 244, 244, 246, 255, 244, 244, 246, 255, 245, 245, 246, 255, 245, 245, 246, 255, 245, 245, 246, 255, 245, 245, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 246, 246, 246, 255, 247, 247, 247, 255, 247, 246, 246, 255, 247, 246, 246, 255, 247, 246, 246, 255, 248, 245, 246, 255, 248, 245, 246, 255, 248, 245, 245, 255, 248, 245, 245, 255, 249, 244, 245, 255, 249, 244, 245, 255, 249, 244, 245, 255, 249, 244, 244, 255, 250, 243, 244, 255, 250, 243, 244, 255, 250, 243, 244, 255, 251, 242, 243, 255, 251, 242, 243, 255, 251, 242, 243, 255, 251, 242, 242, 255, 252, 241, 242, 255, 252, 241, 242, 255, 252, 241, 241, 255, 253, 241, 241, 255, 253, 240, 241, 255, 253, 240, 240, 255, 253, 240, 240, 255, 253, 240, 239, 255, 253, 239, 239, 255, 253, 239, 239, 255, 253, 239, 238, 255, 253, 239, 238, 255, 253, 238, 237, 255, 253, 238, 237, 255, 253, 238, 237, 255, 253, 238, 236, 255, 253, 237, 236, 255, 253, 237, 235, 255, 253, 237, 235, 255, 253, 237, 234, 255, 253, 236, 234, 255, 253, 236, 233, 255, 253, 236, 233, 255, 253, 236, 232, 255, 253, 235, 232, 255, 253, 235, 231, 255, 253, 235, 231, 255, 253, 235, 230, 255, 253, 235, 229, 255, 253, 234, 229, 255, 253, 234, 228, 255, 253, 234, 228, 255, 253, 234, 227, 255, 254, 229, 214, 255, 254, 229, 213, 255, 254, 229, 212, 255, 254, 228, 212, 255, 254, 228, 211, 255, 254, 228, 211, 255, 254, 228, 210, 255, 254, 228, 209, 255, 254, 227, 209, 255, 254, 227, 208, 255, 254, 227, 208, 255, 254, 227, 207, 255, 254, 227, 206, 255, 254, 227, 206, 255, 254, 226, 205, 255, 254, 226, 204, 255, 254, 226, 204, 255, 254, 226, 203, 255, 254, 226, 202, 255, 254, 226, 202, 255, 254, 226, 201, 255, 254, 225, 200, 255, 254, 225, 200, 255, 254, 225, 199, 255, 254, 225, 199, 255, 254, 225, 198, 255, 254, 225, 197, 255, 254, 225, 197, 255, 254, 225, 196, 255, 254, 225, 195, 255, 254, 225, 195, 255, 254, 224, 194, 255, 254, 224, 193, 255, 254, 224, 193, 255, 254, 224, 192, 255, 254, 224, 191, 255, 254, 224, 191, 255, 254, 224, 190, 255, 254, 224, 189, 255, 254, 224, 189, 255, 254, 224, 188, 255, 254, 224, 187, 255, 254, 224, 187, 255, 254, 224, 186, 255, 254, 224, 185, 255, 254, 224, 185, 255, 254, 224, 184, 255, 254, 224, 184, 255, 254, 224, 183, 255, 254, 224, 182, 255, 254, 224, 182, 255, 253, 223, 181, 255, 253, 223, 180, 255, 253, 223, 180, 255, 253, 222, 179, 255, 253, 222, 178, 255, 253, 222, 178, 255, 253, 222, 177, 255, 253, 221, 176, 255, 253, 221, 176, 255, 253, 221, 175, 255, 253, 220, 174, 255, 253, 220, 174, 255, 253, 220, 173, 255, 253, 219, 172, 255, 253, 219, 172, 255, 253, 219, 171, 255, 253, 219, 170, 255, 253, 218, 170, 255, 253, 218, 169, 255, 253, 218, 169, 255, 253, 217, 168, 255, 253, 217, 167, 255, 253, 217, 167, 255, 253, 216, 166, 255, 253, 216, 165, 255, 253, 216, 165, 255, 253, 215, 164, 255, 253, 215, 163, 255, 253, 215, 163, 255, 253, 215, 162, 255, 253, 214, 161, 255, 253, 214, 161, 255, 253, 214, 160, 255, 253, 213, 159, 255, 253, 213, 159, 255, 253, 213, 158, 255, 253, 212, 157, 255, 253, 212, 157, 255, 253, 212, 156, 255, 253, 211, 155, 255, 253, 211, 155, 255, 253, 211, 154, 255, 253, 211, 153, 255, 253, 210, 153, 255, 253, 210, 152, 255, 253, 210, 152, 255, 253, 209, 151, 255, 253, 209, 150, 255, 253, 209, 150, 255, 253, 208, 149, 255, 253, 208, 148, 255, 253, 200, 131, 255, 253, 199, 130, 255, 253, 199, 130, 255, 253, 199, 129, 255, 253, 199, 128, 255, 253, 198, 128, 255, 253, 198, 127, 255, 253, 198, 127, 255, 253, 197, 126, 255, 253, 197, 125, 255, 253, 197, 125, 255, 253, 196, 124, 255, 253, 196, 123, 255, 253, 196, 123, 255, 253, 195, 122, 255, 253, 195, 121, 255, 253, 195, 121, 255, 253, 194, 120, 255, 253, 194, 119, 255, 253, 194, 119, 255, 253, 193, 118, 255, 253, 193, 118, 255, 253, 193, 117, 255, 253, 193, 116, 255, 253, 192, 116, 255, 253, 192, 115, 255, 253, 192, 114, 255, 253, 191, 114, 255, 253, 191, 113, 255, 253, 191, 112, 255, 253, 190, 112, 255, 253, 190, 111, 255, 253, 190, 111, 255, 253, 189, 110, 255, 253, 189, 109, 255, 253, 189, 109, 255, 253, 188, 108, 255, 253, 188, 107, 255, 253, 188, 107, 255, 253, 187, 106, 255, 253, 187, 105, 255, 253, 187, 105, 255, 253, 186, 104, 255, 253, 186, 103, 255, 253, 186, 103, 255, 253, 185, 102, 255, 253, 185, 102, 255, 253, 185, 101, 255, 253, 184, 100, 255, 253, 184, 100, 255, 253, 184, 99, 255, 252, 183, 98, 255, 252, 183, 98, 255, 252, 183, 97, 255, 252, 182, 97, 255, 252, 182, 96, 255, 251, 181, 96, 255, 251, 181, 95, 255, 251, 181, 94, 255, 251, 180, 94, 255, 250, 180, 93, 255, 250, 179, 93, 255, 250, 179, 92, 255, 250, 178, 92, 255, 250, 178, 91, 255, 249, 178, 90, 255, 249, 177, 90, 255, 249, 177, 89, 255, 249, 176, 89, 255, 248, 176, 88, 255, 248, 175, 88, 255, 248, 175, 87, 255, 248, 175, 87, 255, 248, 174, 86, 255, 247, 174, 85, 255, 247, 173, 85, 255, 247, 173, 84, 255, 247, 173, 84, 255, 246, 172, 83, 255, 246, 172, 83, 255, 246, 171, 82, 255, 246, 171, 81, 255, 246, 170, 81, 255, 245, 170, 80, 255, 245, 170, 80, 255, 245, 169, 79, 255, 245, 169, 79, 255, 244, 168, 78, 255, 244, 168, 77, 255, 244, 168, 77, 255, 244, 167, 76, 255, 244, 167, 76, 255, 243, 166, 75, 255, 243, 166, 75, 255, 243, 165, 74, 255, 243, 165, 73, 255, 242, 165, 73, 255, 242, 164, 72, 255, 242, 164, 72, 255, 242, 163, 71, 255, 241, 163, 71, 255, 241, 162, 70, 255, 235, 151, 54, 255, 235, 151, 53, 255, 235, 150, 52, 255, 235, 150, 52, 255, 234, 150, 51, 255, 234, 149, 51, 255, 234, 149, 50, 255, 234, 148, 49, 255, 233, 148, 49, 255, 233, 147, 48, 255, 233, 147, 48, 255, 233, 147, 47, 255, 232, 146, 47, 255, 232, 146, 46, 255, 232, 145, 45, 255, 232, 145, 45, 255, 232, 145, 44, 255, 231, 144, 43, 255, 231, 144, 43, 255, 231, 143, 42, 255, 231, 143, 42, 255, 230, 142, 41, 255, 230, 142, 40, 255, 230, 142, 40, 255, 230, 141, 39, 255, 230, 141, 39, 255, 229, 140, 38, 255, 229, 140, 37, 255, 229, 139, 37, 255, 229, 139, 36, 255, 228, 139, 35, 255, 228, 138, 35, 255, 228, 138, 34, 255, 228, 137, 33, 255, 227, 137, 33, 255, 227, 136, 32, 255, 227, 136, 31, 255, 227, 136, 31, 255, 227, 135, 30, 255, 226, 135, 29, 255, 226, 134, 28, 255, 226, 134, 28, 255, 226, 133, 27, 255, 225, 133, 26, 255, 225, 133, 25, 255, 225, 132, 25, 255, 225, 132, 24, 255, 224, 131, 23, 255, 224, 131, 22, 255, 224, 130, 21, 255, 224, 130, 21, 255, 224, 130, 20, 255, 223, 129, 19, 255, 223, 129, 19, 255, 223, 129, 19, 255, 222, 128, 19, 255, 222, 128, 19, 255, 221, 128, 19, 255, 221, 127, 19, 255, 221, 127, 19, 255, 220, 127, 19, 255, 220, 126, 18, 255, 220, 126, 18, 255, 219, 126, 18, 255, 219, 125, 18, 255, 219, 125, 18, 255, 218, 124, 18, 255, 218, 124, 18, 255, 218, 124, 18, 255, 217, 123, 18, 255, 217, 123, 17, 255, 217, 123, 17, 255, 216, 122, 17, 255, 216, 122, 17, 255, 216, 122, 17, 255, 215, 121, 17, 255, 215, 121, 17, 255, 215, 121, 17, 255, 214, 120, 17, 255, 214, 120, 16, 255, 213, 120, 16, 255, 213, 119, 16, 255, 213, 119, 16, 255, 212, 119, 16, 255, 212, 118, 16, 255, 212, 118, 16, 255, 211, 118, 16, 255, 211, 117, 16, 255, 211, 117, 15, 255, 210, 117, 15, 255, 210, 116, 15, 255, 210, 116, 15, 255, 209, 116, 15, 255, 209, 115, 15, 255, 209, 115, 15, 255, 208, 115, 15, 255, 208, 114, 15, 255, 208, 114, 14, 255, 207, 114, 14, 255, 207, 114, 14, 255, 206, 113, 14, 255, 206, 113, 14, 255, 206, 113, 14, 255, 196, 104, 11, 255, 196, 103, 11, 255, 196, 103, 11, 255, 195, 103, 11, 255, 195, 102, 11, 255, 195, 102, 10, 255, 194, 102, 10, 255, 194, 101, 10, 255, 194, 101, 10, 255, 193, 101, 10, 255, 193, 101, 10, 255, 193, 100, 10, 255, 192, 100, 10, 255, 192, 100, 9, 255, 191, 99, 9, 255, 191, 99, 9, 255, 191, 99, 9, 255, 190, 98, 9, 255, 190, 98, 9, 255, 190, 98, 9, 255, 189, 97, 9, 255, 189, 97, 9, 255, 189, 97, 8, 255, 188, 96, 8, 255, 188, 96, 8, 255, 188, 96, 8, 255, 187, 95, 8, 255, 187, 95, 8, 255, 187, 95, 8, 255, 186, 94, 8, 255, 186, 94, 8, 255, 185, 94, 7, 255, 185, 93, 7, 255, 185, 93, 7, 255, 184, 93, 7, 255, 184, 92, 7, 255, 184, 92, 7, 255, 183, 92, 7, 255, 183, 91, 7, 255, 183, 91, 7, 255, 182, 91, 7, 255, 182, 91, 6, 255, 182, 90, 6, 255, 181, 90, 6, 255, 181, 90, 6, 255, 180, 89, 6, 255, 180, 89, 6, 255, 180, 89, 6, 255, 179, 88, 6, 255, 179, 88, 6, 255, 179, 88, 6, 255, 178, 87, 6, 255, 178, 87, 6, 255, 178, 87, 6, 255, 177, 87, 6, 255, 177, 86, 6, 255, 176, 86, 6, 255, 176, 86, 6, 255, 175, 86, 6, 255, 175, 86, 6, 255, 175, 85, 6, 255, 174, 85, 6, 255, 174, 85, 6, 255, 173, 85, 6, 255, 173, 84, 6, 255, 173, 84, 6, 255, 172, 84, 6, 255, 172, 84, 6, 255, 171, 83, 6, 255, 171, 83, 6, 255, 171, 83, 6, 255, 170, 83, 6, 255, 170, 82, 6, 255, 169, 82, 6, 255, 169, 82, 6, 255, 168, 82, 6, 255, 168, 82, 6, 255, 168, 81, 6, 255, 167, 81, 6, 255, 167, 81, 7, 255, 166, 81, 7, 255, 166, 80, 7, 255, 166, 80, 7, 255, 165, 80, 7, 255, 165, 80, 7, 255, 164, 79, 7, 255, 164, 79, 7, 255, 164, 79, 7, 255, 163, 79, 7, 255, 163, 79, 7, 255, 162, 78, 7, 255, 162, 78, 7, 255, 161, 78, 7, 255, 161, 78, 7, 255, 161, 77, 7, 255, 160, 77, 7, 255, 160, 77, 7, 255, 159, 77, 7, 255, 159, 76, 7, 255, 159, 76, 7, 255, 158, 76, 7, 255, 158, 76, 7, 255, 147, 70, 7, 255, 147, 70, 7, 255, 146, 69, 7, 255, 146, 69, 7, 255, 145, 69, 7, 255, 145, 69, 7, 255, 145, 68, 7, 255, 144, 68, 7, 255, 144, 68, 7, 255, 143, 68, 7, 255, 143, 68, 7, 255, 143, 67, 7, 255, 142, 67, 7, 255, 142, 67, 8, 255, 141, 67, 8, 255, 141, 66, 8, 255, 141, 66, 8, 255, 140, 66, 8, 255, 140, 66, 8, 255, 139, 66, 8, 255, 139, 65, 8, 255, 139, 65, 8, 255, 138, 65, 8, 255, 138, 65, 8, 255, 137, 64, 8, 255, 137, 64, 8, 255, 137, 64, 8, 255, 136, 64, 8, 255, 136, 64, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 134, 63, 8, 255, 134, 63, 8, 255, 134, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 132, 62, 8, 255, 132, 62, 8, 255, 132, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 130, 61, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 128, 60, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuOr_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 44, 0, 75, 0, 48, 2, 79, 24, 51, 4, 83, 49, 54, 7, 88, 74, 57, 11, 93, 99, 59, 14, 97, 124, 70, 25, 114, 149, 73, 28, 118, 174, 76, 31, 123, 199, 79, 34, 128, 224, 81, 36, 132, 249, 84, 40, 136, 255, 87, 46, 139, 255, 90, 52, 142, 255, 93, 57, 145, 255, 95, 62, 147, 255, 98, 68, 150, 255, 110, 88, 159, 255, 113, 93, 162, 255, 116, 98, 164, 255, 119, 102, 166, 255, 122, 107, 168, 255, 126, 112, 170, 255, 129, 116, 172, 255, 132, 119, 175, 255, 135, 123, 177, 255, 138, 126, 180, 255, 141, 130, 182, 255, 144, 133, 184, 255, 147, 136, 187, 255, 160, 151, 197, 255, 163, 154, 199, 255, 166, 158, 201, 255, 169, 161, 203, 255, 172, 164, 205, 255, 175, 168, 208, 255, 178, 171, 210, 255, 180, 174, 211, 255, 181, 176, 213, 255, 183, 179, 214, 255, 185, 181, 216, 255, 187, 184, 217, 255, 189, 186, 218, 255, 191, 189, 220, 255, 201, 201, 226, 255, 203, 203, 227, 255, 205, 206, 229, 255, 207, 208, 230, 255, 209, 211, 231, 255, 211, 213, 232, 255, 213, 215, 233, 255, 232, 214, 222, 255, 232, 215, 224, 255, 232, 217, 226, 255, 232, 219, 228, 255, 232, 221, 230, 255, 232, 222, 232, 255, 232, 224, 234, 255, 232, 226, 235, 255, 233, 227, 236, 255, 239, 234, 240, 255, 240, 236, 241, 255, 240, 238, 242, 255, 241, 239, 243, 255, 242, 240, 244, 255, 243, 242, 244, 255, 243, 243, 245, 255, 245, 245, 246, 255, 246, 246, 246, 255, 247, 246, 246, 255, 248, 244, 245, 255, 250, 243, 244, 255, 251, 242, 242, 255, 253, 240, 241, 255, 253, 239, 239, 255, 253, 238, 236, 255, 253, 236, 234, 255, 253, 235, 231, 255, 253, 234, 229, 255, 254, 229, 213, 255, 254, 228, 210, 255, 254, 227, 207, 255, 254, 226, 204, 255, 254, 226, 201, 255, 254, 225, 198, 255, 254, 225, 195, 255, 254, 224, 192, 255, 254, 224, 189, 255, 254, 224, 186, 255, 254, 224, 183, 255, 253, 223, 181, 255, 253, 222, 178, 255, 253, 220, 175, 255, 253, 219, 172, 255, 253, 218, 169, 255, 253, 217, 166, 255, 253, 215, 164, 255, 253, 214, 161, 255, 253, 213, 158, 255, 253, 212, 156, 255, 253, 210, 153, 255, 253, 209, 151, 255, 253, 208, 148, 255, 253, 199, 129, 255, 253, 198, 126, 255, 253, 196, 124, 255, 253, 195, 122, 255, 253, 194, 119, 255, 253, 193, 117, 255, 253, 192, 115, 255, 253, 190, 112, 255, 253, 189, 110, 255, 253, 188, 108, 255, 253, 187, 105, 255, 253, 186, 103, 255, 253, 185, 101, 255, 253, 184, 99, 255, 252, 182, 97, 255, 251, 181, 95, 255, 250, 180, 93, 255, 250, 178, 91, 255, 249, 177, 89, 255, 248, 175, 88, 255, 248, 174, 86, 255, 247, 173, 84, 255, 246, 172, 82, 255, 245, 170, 81, 255, 245, 169, 79, 255, 244, 168, 77, 255, 243, 166, 75, 255, 243, 165, 74, 255, 242, 164, 72, 255, 241, 163, 70, 255, 235, 151, 53, 255, 234, 150, 51, 255, 234, 148, 50, 255, 233, 147, 48, 255, 232, 146, 46, 255, 232, 145, 45, 255, 231, 144, 43, 255, 231, 143, 41, 255, 230, 141, 40, 255, 229, 140, 38, 255, 229, 139, 36, 255, 228, 138, 35, 255, 228, 137, 33, 255, 227, 136, 31, 255, 226, 135, 29, 255, 226, 134, 28, 255, 225, 133, 26, 255, 225, 132, 24, 255, 224, 131, 22, 255, 224, 130, 20, 255, 223, 129, 19, 255, 222, 128, 19, 255, 221, 127, 19, 255, 220, 127, 19, 255, 220, 126, 18, 255, 219, 125, 18, 255, 218, 124, 18, 255, 217, 124, 18, 255, 217, 123, 17, 255, 216, 122, 17, 255, 215, 121, 17, 255, 214, 121, 17, 255, 214, 120, 16, 255, 213, 119, 16, 255, 212, 119, 16, 255, 212, 118, 16, 255, 211, 117, 16, 255, 210, 117, 15, 255, 210, 116, 15, 255, 209, 115, 15, 255, 208, 115, 15, 255, 208, 114, 14, 255, 207, 114, 14, 255, 206, 113, 14, 255, 197, 104, 11, 255, 196, 103, 11, 255, 195, 103, 11, 255, 195, 102, 10, 255, 194, 102, 10, 255, 193, 101, 10, 255, 193, 101, 10, 255, 192, 100, 10, 255, 192, 99, 9, 255, 191, 99, 9, 255, 191, 98, 9, 255, 190, 98, 9, 255, 189, 97, 9, 255, 189, 97, 9, 255, 188, 96, 8, 255, 188, 96, 8, 255, 187, 95, 8, 255, 187, 95, 8, 255, 186, 94, 8, 255, 186, 94, 7, 255, 185, 93, 7, 255, 185, 93, 7, 255, 184, 92, 7, 255, 184, 92, 7, 255, 183, 92, 7, 255, 183, 91, 7, 255, 182, 91, 6, 255, 182, 90, 6, 255, 181, 90, 6, 255, 181, 89, 6, 255, 180, 89, 6, 255, 180, 89, 6, 255, 179, 88, 6, 255, 179, 88, 6, 255, 178, 87, 6, 255, 178, 87, 6, 255, 177, 87, 6, 255, 177, 87, 6, 255, 176, 86, 6, 255, 176, 86, 6, 255, 175, 86, 6, 255, 175, 85, 6, 255, 174, 85, 6, 255, 174, 85, 6, 255, 173, 85, 6, 255, 173, 84, 6, 255, 172, 84, 6, 255, 172, 84, 6, 255, 172, 84, 6, 255, 171, 83, 6, 255, 171, 83, 6, 255, 170, 83, 6, 255, 170, 83, 6, 255, 169, 82, 6, 255, 169, 82, 6, 255, 169, 82, 6, 255, 168, 82, 6, 255, 168, 81, 6, 255, 167, 81, 6, 255, 167, 81, 6, 255, 167, 81, 7, 255, 166, 81, 7, 255, 166, 80, 7, 255, 166, 80, 7, 255, 165, 80, 7, 255, 165, 80, 7, 255, 164, 79, 7, 255, 164, 79, 7, 255, 164, 79, 7, 255, 163, 79, 7, 255, 163, 79, 7, 255, 163, 79, 7, 255, 162, 78, 7, 255, 162, 78, 7, 255, 162, 78, 7, 255, 161, 78, 7, 255, 161, 78, 7, 255, 161, 77, 7, 255, 160, 77, 7, 255, 160, 77, 7, 255, 160, 77, 7, 255, 160, 77, 7, 255, 159, 77, 7, 255, 159, 76, 7, 255, 159, 76, 7, 255, 158, 76, 7, 255, 158, 76, 7, 255, 158, 76, 7, 255, 158, 76, 7, 255, 147, 70, 7, 255, 147, 70, 7, 255, 146, 69, 7, 255, 146, 69, 7, 255, 146, 69, 7, 255, 146, 69, 7, 255, 145, 69, 7, 255, 145, 69, 7, 255, 145, 69, 7, 255, 145, 68, 7, 255, 144, 68, 7, 255, 144, 68, 7, 255, 144, 68, 7, 255, 144, 68, 7, 255, 143, 68, 7, 255, 143, 68, 7, 255, 143, 67, 7, 255, 143, 67, 7, 255, 142, 67, 7, 255, 142, 67, 7, 255, 142, 67, 8, 255, 142, 67, 8, 255, 142, 67, 8, 255, 141, 67, 8, 255, 141, 67, 8, 255, 141, 66, 8, 255, 141, 66, 8, 255, 141, 66, 8, 255, 140, 66, 8, 255, 140, 66, 8, 255, 140, 66, 8, 255, 140, 66, 8, 255, 140, 66, 8, 255, 139, 66, 8, 255, 139, 65, 8, 255, 139, 65, 8, 255, 139, 65, 8, 255, 139, 65, 8, 255, 139, 65, 8, 255, 138, 65, 8, 255, 138, 65, 8, 255, 138, 65, 8, 255, 138, 65, 8, 255, 138, 65, 8, 255, 138, 65, 8, 255, 137, 64, 8, 255, 137, 64, 8, 255, 137, 64, 8, 255, 137, 64, 8, 255, 137, 64, 8, 255, 137, 64, 8, 255, 137, 64, 8, 255, 136, 64, 8, 255, 136, 64, 8, 255, 136, 64, 8, 255, 136, 64, 8, 255, 136, 64, 8, 255, 136, 64, 8, 255, 136, 63, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 135, 63, 8, 255, 134, 63, 8, 255, 134, 63, 8, 255, 134, 63, 8, 255, 134, 63, 8, 255, 134, 63, 8, 255, 134, 62, 8, 255, 134, 62, 8, 255, 134, 62, 8, 255, 134, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 133, 62, 8, 255, 132, 62, 8, 255, 132, 62, 8, 255, 132, 62, 8, 255, 132, 62, 8, 255, 132, 62, 8, 255, 132, 62, 8, 255, 132, 61, 8, 255, 132, 61, 8, 255, 132, 61, 8, 255, 132, 61, 8, 255, 132, 61, 8, 255, 132, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 131, 61, 8, 255, 130, 61, 8, 255, 130, 61, 8, 255, 130, 61, 8, 255, 130, 61, 8, 255, 130, 61, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 130, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 129, 60, 8, 255, 128, 60, 8, 255, 128, 60, 8, 255, 128, 60, 8, 255, 128, 60, 8, 255, 128, 60, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 128, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 8, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 127, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255, 126, 59, 7, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuOr_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
