function(add_linker_warnings theTarget)
    if(APPLE)
       # target_link_libraries(${theTarget} PRIVATE "-Wl,-fatal_warnings")
    endif()
endfunction()

function(add_linker_warnings_external theTarget)
  if(OSSIA_CI)
    if ("${CMAKE_CXX_COMPILER_ID}" STREQUAL "GNU")
      get_target_property(TEMP ${theTarget} LINK_FLAGS)
      if(TEMP STREQUAL "TEMP-NOTFOUND")
        SET(TEMP "") # set to empty string
      endif()
      set_target_properties(${theTarget}
        PROPERTIES LINK_FLAGS
        "${TEMP} -Wl,--unresolved-symbols=ignore-in-object-files")
    endif()
  else()
    if(APPLE)
      target_link_libraries(${theTarget} PRIVATE -Wl,-undefined,dynamic_lookup)
    elseif(UNIX)
      if(LLD_LINKER_SUPPORTED)
        target_link_libraries(${theTarget} PRIVATE -Wl,--unresolved-symbols=ignore-all)
      else()
        target_link_libraries(${theTarget} PRIVATE -Wl,--warn-unresolved-symbols)
      endif()
    endif()
  endif()
endfunction()
