# Write interface, headers, sources and tests file system scan cache files

# Write a file caching the scanned files along with timestamps to check
function(write_cached_scan_file mode path var)
  indented_message(STATUS "Writing filesystem scan cache file ${path} ...")
  set(contents "# DO NOT EDIT, GENERATED BY SCRIPT\nset(${var}\n")
  set(contents2 "# DO NOT EDIT, GENERATED BY SCRIPT\nset(${var}_DIRECTORIES\n")
  set(dirs)
  foreach(arg ${ARGN})
    set(contents "${contents}  \"${arg}\"\n")
    get_filename_component(dir "${arg}" DIRECTORY)
    if(NOT dir STREQUAL prevdir)
      list(APPEND dirs "${dir}")
      set(prevdir "${dir}")
    endif()
  endforeach()
  set(contents "${contents})\n")
  if(dirs)
    list(REMOVE_DUPLICATES dirs)
    foreach(dir ${dirs})
      file(TIMESTAMP "${CMAKE_CURRENT_SOURCE_DIR}/${dir}" dirts)
      set(contents2 "${contents2}  \"${dirts}\" \"${dir}\"\n")
    endforeach()
  endif()
  set(contents2 "${contents2})\n")
  file(${mode} "${path}" "${contents}")
  file(${mode} "${path}.cache" "${contents2}")
endfunction()
# Remove CRs from the file, so git doesn't constantly mark the file as changed
function(de_cr_file path)
  # Reading in a file, string replacing CRLF with LF and writing it out still writes out CRLF on Windows
  # This, however, seems to work very nicely
  configure_file("${path}" "${path}" @ONLY NEWLINE_STYLE LF)
endfunction()

if(NOT EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/cmake/headers.cmake")
  write_cached_scan_file(WRITE "${CMAKE_CURRENT_SOURCE_DIR}/cmake/interface.cmake" "${PROJECT_NAME}_INTERFACE" ${${PROJECT_NAME}_INTERFACE})
  write_cached_scan_file(APPEND "${CMAKE_CURRENT_SOURCE_DIR}/cmake/interface.cmake" "${PROJECT_NAME}_INTERFACE_SOURCE" ${${PROJECT_NAME}_INTERFACE_SOURCE})
  de_cr_file("${CMAKE_CURRENT_SOURCE_DIR}/cmake/interface.cmake")
  write_cached_scan_file(WRITE "${CMAKE_CURRENT_SOURCE_DIR}/cmake/headers.cmake" "${PROJECT_NAME}_HEADERS" ${${PROJECT_NAME}_HEADERS})
  de_cr_file("${CMAKE_CURRENT_SOURCE_DIR}/cmake/headers.cmake")
endif()
if(EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/src")
  if(NOT EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/cmake/sources.cmake")
    write_cached_scan_file(WRITE "${CMAKE_CURRENT_SOURCE_DIR}/cmake/sources.cmake" "${PROJECT_NAME}_SOURCES" ${${PROJECT_NAME}_SOURCES})
    de_cr_file("${CMAKE_CURRENT_SOURCE_DIR}/cmake/sources.cmake")
  endif()
endif()
if(EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/test")
  if(NOT EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/cmake/tests.cmake")
    write_cached_scan_file(WRITE "${CMAKE_CURRENT_SOURCE_DIR}/cmake/tests.cmake" "${PROJECT_NAME}_TESTS" ${${PROJECT_NAME}_TESTS})
    write_cached_scan_file(APPEND "${CMAKE_CURRENT_SOURCE_DIR}/cmake/tests.cmake" "${PROJECT_NAME}_COMPILE_TESTS" ${${PROJECT_NAME}_COMPILE_TESTS})
    write_cached_scan_file(APPEND "${CMAKE_CURRENT_SOURCE_DIR}/cmake/tests.cmake" "${PROJECT_NAME}_COMPILE_FAIL_TESTS" ${${PROJECT_NAME}_COMPILE_FAIL_TESTS})
    de_cr_file("${CMAKE_CURRENT_SOURCE_DIR}/cmake/tests.cmake")
  endif()
endif()
