// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                          avtExtrudedVolWriter.h                           //
// ************************************************************************* //

#ifndef AVT_ExtrudedVol_WRITER_H
#define AVT_ExtrudedVol_WRITER_H

#include <avtDatabaseWriter.h>

#include <string>
#include <vector>

class DBOptionsAttributes;

// ****************************************************************************
//  Class: avtExtrudedVolWriter
//
//  Purpose:
//      A module that writes out ExtrudedVol files.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Fri May 18 17:52:04 PST 2007
//
// ****************************************************************************

class
avtExtrudedVolWriter : public avtDatabaseWriter
{
  public:
                   avtExtrudedVolWriter(DBOptionsAttributes *);
    virtual       ~avtExtrudedVolWriter() {;};

  protected:
    std::string    stem;
    std::vector<std::string> variables;
    int            timestep;
    int            nTimesteps;
    int            numChunks;

    virtual void   OpenFile(const std::string &, int nb);
    virtual void   WriteHeaders(const avtDatabaseMetaData *,
                                const std::vector<std::string> &, 
                                const std::vector<std::string> &,
                                const std::vector<std::string> &);
    virtual void   WriteChunk(vtkDataSet *, int);
    virtual void   CloseFile(void);
};


#endif
