#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ABSMacro,
  ADJCALLSTACKDOWN,
  ADJCALLSTACKUP,
  AND_V_D_PSEUDO,
  AND_V_H_PSEUDO,
  AND_V_W_PSEUDO,
  ATOMIC_CMP_SWAP_I16,
  ATOMIC_CMP_SWAP_I16_POSTRA,
  ATOMIC_CMP_SWAP_I32,
  ATOMIC_CMP_SWAP_I32_POSTRA,
  ATOMIC_CMP_SWAP_I64,
  ATOMIC_CMP_SWAP_I64_POSTRA,
  ATOMIC_CMP_SWAP_I8,
  ATOMIC_CMP_SWAP_I8_POSTRA,
  ATOMIC_LOAD_ADD_I16,
  ATOMIC_LOAD_ADD_I16_POSTRA,
  ATOMIC_LOAD_ADD_I32,
  ATOMIC_LOAD_ADD_I32_POSTRA,
  ATOMIC_LOAD_ADD_I64,
  ATOMIC_LOAD_ADD_I64_POSTRA,
  ATOMIC_LOAD_ADD_I8,
  ATOMIC_LOAD_ADD_I8_POSTRA,
  ATOMIC_LOAD_AND_I16,
  ATOMIC_LOAD_AND_I16_POSTRA,
  ATOMIC_LOAD_AND_I32,
  ATOMIC_LOAD_AND_I32_POSTRA,
  ATOMIC_LOAD_AND_I64,
  ATOMIC_LOAD_AND_I64_POSTRA,
  ATOMIC_LOAD_AND_I8,
  ATOMIC_LOAD_AND_I8_POSTRA,
  ATOMIC_LOAD_MAX_I16,
  ATOMIC_LOAD_MAX_I16_POSTRA,
  ATOMIC_LOAD_MAX_I32,
  ATOMIC_LOAD_MAX_I32_POSTRA,
  ATOMIC_LOAD_MAX_I64,
  ATOMIC_LOAD_MAX_I64_POSTRA,
  ATOMIC_LOAD_MAX_I8,
  ATOMIC_LOAD_MAX_I8_POSTRA,
  ATOMIC_LOAD_MIN_I16,
  ATOMIC_LOAD_MIN_I16_POSTRA,
  ATOMIC_LOAD_MIN_I32,
  ATOMIC_LOAD_MIN_I32_POSTRA,
  ATOMIC_LOAD_MIN_I64,
  ATOMIC_LOAD_MIN_I64_POSTRA,
  ATOMIC_LOAD_MIN_I8,
  ATOMIC_LOAD_MIN_I8_POSTRA,
  ATOMIC_LOAD_NAND_I16,
  ATOMIC_LOAD_NAND_I16_POSTRA,
  ATOMIC_LOAD_NAND_I32,
  ATOMIC_LOAD_NAND_I32_POSTRA,
  ATOMIC_LOAD_NAND_I64,
  ATOMIC_LOAD_NAND_I64_POSTRA,
  ATOMIC_LOAD_NAND_I8,
  ATOMIC_LOAD_NAND_I8_POSTRA,
  ATOMIC_LOAD_OR_I16,
  ATOMIC_LOAD_OR_I16_POSTRA,
  ATOMIC_LOAD_OR_I32,
  ATOMIC_LOAD_OR_I32_POSTRA,
  ATOMIC_LOAD_OR_I64,
  ATOMIC_LOAD_OR_I64_POSTRA,
  ATOMIC_LOAD_OR_I8,
  ATOMIC_LOAD_OR_I8_POSTRA,
  ATOMIC_LOAD_SUB_I16,
  ATOMIC_LOAD_SUB_I16_POSTRA,
  ATOMIC_LOAD_SUB_I32,
  ATOMIC_LOAD_SUB_I32_POSTRA,
  ATOMIC_LOAD_SUB_I64,
  ATOMIC_LOAD_SUB_I64_POSTRA,
  ATOMIC_LOAD_SUB_I8,
  ATOMIC_LOAD_SUB_I8_POSTRA,
  ATOMIC_LOAD_UMAX_I16,
  ATOMIC_LOAD_UMAX_I16_POSTRA,
  ATOMIC_LOAD_UMAX_I32,
  ATOMIC_LOAD_UMAX_I32_POSTRA,
  ATOMIC_LOAD_UMAX_I64,
  ATOMIC_LOAD_UMAX_I64_POSTRA,
  ATOMIC_LOAD_UMAX_I8,
  ATOMIC_LOAD_UMAX_I8_POSTRA,
  ATOMIC_LOAD_UMIN_I16,
  ATOMIC_LOAD_UMIN_I16_POSTRA,
  ATOMIC_LOAD_UMIN_I32,
  ATOMIC_LOAD_UMIN_I32_POSTRA,
  ATOMIC_LOAD_UMIN_I64,
  ATOMIC_LOAD_UMIN_I64_POSTRA,
  ATOMIC_LOAD_UMIN_I8,
  ATOMIC_LOAD_UMIN_I8_POSTRA,
  ATOMIC_LOAD_XOR_I16,
  ATOMIC_LOAD_XOR_I16_POSTRA,
  ATOMIC_LOAD_XOR_I32,
  ATOMIC_LOAD_XOR_I32_POSTRA,
  ATOMIC_LOAD_XOR_I64,
  ATOMIC_LOAD_XOR_I64_POSTRA,
  ATOMIC_LOAD_XOR_I8,
  ATOMIC_LOAD_XOR_I8_POSTRA,
  ATOMIC_SWAP_I16,
  ATOMIC_SWAP_I16_POSTRA,
  ATOMIC_SWAP_I32,
  ATOMIC_SWAP_I32_POSTRA,
  ATOMIC_SWAP_I64,
  ATOMIC_SWAP_I64_POSTRA,
  ATOMIC_SWAP_I8,
  ATOMIC_SWAP_I8_POSTRA,
  B,
  BAL_BR,
  BAL_BR_MM,
  BEQLImmMacro,
  BGE,
  BGEImmMacro,
  BGEL,
  BGELImmMacro,
  BGEU,
  BGEUImmMacro,
  BGEUL,
  BGEULImmMacro,
  BGT,
  BGTImmMacro,
  BGTL,
  BGTLImmMacro,
  BGTU,
  BGTUImmMacro,
  BGTUL,
  BGTULImmMacro,
  BLE,
  BLEImmMacro,
  BLEL,
  BLELImmMacro,
  BLEU,
  BLEUImmMacro,
  BLEUL,
  BLEULImmMacro,
  BLT,
  BLTImmMacro,
  BLTL,
  BLTLImmMacro,
  BLTU,
  BLTUImmMacro,
  BLTUL,
  BLTULImmMacro,
  BNELImmMacro,
  BPOSGE32_PSEUDO,
  BSEL_D_PSEUDO,
  BSEL_FD_PSEUDO,
  BSEL_FW_PSEUDO,
  BSEL_H_PSEUDO,
  BSEL_W_PSEUDO,
  B_MM,
  B_MMR6_Pseudo,
  B_MM_Pseudo,
  BeqImm,
  BneImm,
  BteqzT8CmpX16,
  BteqzT8CmpiX16,
  BteqzT8SltX16,
  BteqzT8SltiX16,
  BteqzT8SltiuX16,
  BteqzT8SltuX16,
  BtnezT8CmpX16,
  BtnezT8CmpiX16,
  BtnezT8SltX16,
  BtnezT8SltiX16,
  BtnezT8SltiuX16,
  BtnezT8SltuX16,
  BuildPairF64,
  BuildPairF64_64,
  CFTC1,
  CONSTPOOL_ENTRY,
  COPY_FD_PSEUDO,
  COPY_FW_PSEUDO,
  CTTC1,
  Constant32,
  DMULImmMacro,
  DMULMacro,
  DMULOMacro,
  DMULOUMacro,
  DROL,
  DROLImm,
  DROR,
  DRORImm,
  DSDivIMacro,
  DSDivMacro,
  DSRemIMacro,
  DSRemMacro,
  DUDivIMacro,
  DUDivMacro,
  DURemIMacro,
  DURemMacro,
  ERet,
  ExtractElementF64,
  ExtractElementF64_64,
  FABS_D,
  FABS_W,
  FEXP2_D_1_PSEUDO,
  FEXP2_W_1_PSEUDO,
  FILL_FD_PSEUDO,
  FILL_FW_PSEUDO,
  GotPrologue16,
  INSERT_B_VIDX64_PSEUDO,
  INSERT_B_VIDX_PSEUDO,
  INSERT_D_VIDX64_PSEUDO,
  INSERT_D_VIDX_PSEUDO,
  INSERT_FD_PSEUDO,
  INSERT_FD_VIDX64_PSEUDO,
  INSERT_FD_VIDX_PSEUDO,
  INSERT_FW_PSEUDO,
  INSERT_FW_VIDX64_PSEUDO,
  INSERT_FW_VIDX_PSEUDO,
  INSERT_H_VIDX64_PSEUDO,
  INSERT_H_VIDX_PSEUDO,
  INSERT_W_VIDX64_PSEUDO,
  INSERT_W_VIDX_PSEUDO,
  JALR64Pseudo,
  JALRHB64Pseudo,
  JALRHBPseudo,
  JALRPseudo,
  JAL_MMR6,
  JalOneReg,
  JalTwoReg,
  LDMacro,
  LDR_D,
  LDR_W,
  LD_F16,
  LOAD_ACC128,
  LOAD_ACC64,
  LOAD_ACC64DSP,
  LOAD_CCOND_DSP,
  LONG_BRANCH_ADDiu,
  LONG_BRANCH_ADDiu2Op,
  LONG_BRANCH_DADDiu,
  LONG_BRANCH_DADDiu2Op,
  LONG_BRANCH_LUi,
  LONG_BRANCH_LUi2Op,
  LONG_BRANCH_LUi2Op_64,
  LWM_MM,
  LoadAddrImm32,
  LoadAddrImm64,
  LoadAddrReg32,
  LoadAddrReg64,
  LoadImm32,
  LoadImm64,
  LoadImmDoubleFGR,
  LoadImmDoubleFGR_32,
  LoadImmDoubleGPR,
  LoadImmSingleFGR,
  LoadImmSingleGPR,
  LwConstant32,
  MFTACX,
  MFTC0,
  MFTC1,
  MFTDSP,
  MFTGPR,
  MFTHC1,
  MFTHI,
  MFTLO,
  MIPSeh_return32,
  MIPSeh_return64,
  MSA_FP_EXTEND_D_PSEUDO,
  MSA_FP_EXTEND_W_PSEUDO,
  MSA_FP_ROUND_D_PSEUDO,
  MSA_FP_ROUND_W_PSEUDO,
  MTTACX,
  MTTC0,
  MTTC1,
  MTTDSP,
  MTTGPR,
  MTTHC1,
  MTTHI,
  MTTLO,
  MULImmMacro,
  MULOMacro,
  MULOUMacro,
  MultRxRy16,
  MultRxRyRz16,
  MultuRxRy16,
  MultuRxRyRz16,
  NOP,
  NORImm,
  NORImm64,
  NOR_V_D_PSEUDO,
  NOR_V_H_PSEUDO,
  NOR_V_W_PSEUDO,
  OR_V_D_PSEUDO,
  OR_V_H_PSEUDO,
  OR_V_W_PSEUDO,
  PseudoCMPU_EQ_QB,
  PseudoCMPU_LE_QB,
  PseudoCMPU_LT_QB,
  PseudoCMP_EQ_PH,
  PseudoCMP_LE_PH,
  PseudoCMP_LT_PH,
  PseudoCVT_D32_W,
  PseudoCVT_D64_L,
  PseudoCVT_D64_W,
  PseudoCVT_S_L,
  PseudoCVT_S_W,
  PseudoDMULT,
  PseudoDMULTu,
  PseudoDSDIV,
  PseudoDUDIV,
  PseudoD_SELECT_I,
  PseudoD_SELECT_I64,
  PseudoIndirectBranch,
  PseudoIndirectBranch64,
  PseudoIndirectBranch64R6,
  PseudoIndirectBranchR6,
  PseudoIndirectBranch_MM,
  PseudoIndirectBranch_MMR6,
  PseudoIndirectHazardBranch,
  PseudoIndirectHazardBranch64,
  PseudoIndrectHazardBranch64R6,
  PseudoIndrectHazardBranchR6,
  PseudoMADD,
  PseudoMADDU,
  PseudoMADDU_MM,
  PseudoMADD_MM,
  PseudoMFHI,
  PseudoMFHI64,
  PseudoMFHI_MM,
  PseudoMFLO,
  PseudoMFLO64,
  PseudoMFLO_MM,
  PseudoMSUB,
  PseudoMSUBU,
  PseudoMSUBU_MM,
  PseudoMSUB_MM,
  PseudoMTLOHI,
  PseudoMTLOHI64,
  PseudoMTLOHI_DSP,
  PseudoMTLOHI_MM,
  PseudoMULT,
  PseudoMULT_MM,
  PseudoMULTu,
  PseudoMULTu_MM,
  PseudoPICK_PH,
  PseudoPICK_QB,
  PseudoReturn,
  PseudoReturn64,
  PseudoSDIV,
  PseudoSELECTFP_F_D32,
  PseudoSELECTFP_F_D64,
  PseudoSELECTFP_F_I,
  PseudoSELECTFP_F_I64,
  PseudoSELECTFP_F_S,
  PseudoSELECTFP_T_D32,
  PseudoSELECTFP_T_D64,
  PseudoSELECTFP_T_I,
  PseudoSELECTFP_T_I64,
  PseudoSELECTFP_T_S,
  PseudoSELECT_D32,
  PseudoSELECT_D64,
  PseudoSELECT_I,
  PseudoSELECT_I64,
  PseudoSELECT_S,
  PseudoTRUNC_W_D,
  PseudoTRUNC_W_D32,
  PseudoTRUNC_W_S,
  PseudoUDIV,
  ROL,
  ROLImm,
  ROR,
  RORImm,
  RetRA,
  RetRA16,
  SDC1_M1,
  SDIV_MM_Pseudo,
  SDMacro,
  SDivIMacro,
  SDivMacro,
  SEQIMacro,
  SEQMacro,
  SGE,
  SGEImm,
  SGEImm64,
  SGEU,
  SGEUImm,
  SGEUImm64,
  SGTImm,
  SGTImm64,
  SGTUImm,
  SGTUImm64,
  SLE,
  SLEImm,
  SLEImm64,
  SLEU,
  SLEUImm,
  SLEUImm64,
  SLTImm64,
  SLTUImm64,
  SNEIMacro,
  SNEMacro,
  SNZ_B_PSEUDO,
  SNZ_D_PSEUDO,
  SNZ_H_PSEUDO,
  SNZ_V_PSEUDO,
  SNZ_W_PSEUDO,
  SRemIMacro,
  SRemMacro,
  STORE_ACC128,
  STORE_ACC64,
  STORE_ACC64DSP,
  STORE_CCOND_DSP,
  STR_D,
  STR_W,
  ST_F16,
  SWM_MM,
  SZ_B_PSEUDO,
  SZ_D_PSEUDO,
  SZ_H_PSEUDO,
  SZ_V_PSEUDO,
  SZ_W_PSEUDO,
  SaaAddr,
  SaadAddr,
  SelBeqZ,
  SelBneZ,
  SelTBteqZCmp,
  SelTBteqZCmpi,
  SelTBteqZSlt,
  SelTBteqZSlti,
  SelTBteqZSltiu,
  SelTBteqZSltu,
  SelTBtneZCmp,
  SelTBtneZCmpi,
  SelTBtneZSlt,
  SelTBtneZSlti,
  SelTBtneZSltiu,
  SelTBtneZSltu,
  SltCCRxRy16,
  SltiCCRxImmX16,
  SltiuCCRxImmX16,
  SltuCCRxRy16,
  SltuRxRyRz16,
  TAILCALL,
  TAILCALL64R6REG,
  TAILCALLHB64R6REG,
  TAILCALLHBR6REG,
  TAILCALLR6REG,
  TAILCALLREG,
  TAILCALLREG64,
  TAILCALLREGHB,
  TAILCALLREGHB64,
  TAILCALLREG_MM,
  TAILCALLREG_MMR6,
  TAILCALL_MM,
  TAILCALL_MMR6,
  TRAP,
  TRAP_MM,
  UDIV_MM_Pseudo,
  UDivIMacro,
  UDivMacro,
  URemIMacro,
  URemMacro,
  Ulh,
  Ulhu,
  Ulw,
  Ush,
  Usw,
  XOR_V_D_PSEUDO,
  XOR_V_H_PSEUDO,
  XOR_V_W_PSEUDO,
  ABSQ_S_PH,
  ABSQ_S_PH_MM,
  ABSQ_S_QB,
  ABSQ_S_QB_MMR2,
  ABSQ_S_W,
  ABSQ_S_W_MM,
  ADD,
  ADDIUPC,
  ADDIUPC_MM,
  ADDIUPC_MMR6,
  ADDIUR1SP_MM,
  ADDIUR2_MM,
  ADDIUS5_MM,
  ADDIUSP_MM,
  ADDIU_MMR6,
  ADDQH_PH,
  ADDQH_PH_MMR2,
  ADDQH_R_PH,
  ADDQH_R_PH_MMR2,
  ADDQH_R_W,
  ADDQH_R_W_MMR2,
  ADDQH_W,
  ADDQH_W_MMR2,
  ADDQ_PH,
  ADDQ_PH_MM,
  ADDQ_S_PH,
  ADDQ_S_PH_MM,
  ADDQ_S_W,
  ADDQ_S_W_MM,
  ADDR_PS64,
  ADDSC,
  ADDSC_MM,
  ADDS_A_B,
  ADDS_A_D,
  ADDS_A_H,
  ADDS_A_W,
  ADDS_S_B,
  ADDS_S_D,
  ADDS_S_H,
  ADDS_S_W,
  ADDS_U_B,
  ADDS_U_D,
  ADDS_U_H,
  ADDS_U_W,
  ADDU16_MM,
  ADDU16_MMR6,
  ADDUH_QB,
  ADDUH_QB_MMR2,
  ADDUH_R_QB,
  ADDUH_R_QB_MMR2,
  ADDU_MMR6,
  ADDU_PH,
  ADDU_PH_MMR2,
  ADDU_QB,
  ADDU_QB_MM,
  ADDU_S_PH,
  ADDU_S_PH_MMR2,
  ADDU_S_QB,
  ADDU_S_QB_MM,
  ADDVI_B,
  ADDVI_D,
  ADDVI_H,
  ADDVI_W,
  ADDV_B,
  ADDV_D,
  ADDV_H,
  ADDV_W,
  ADDWC,
  ADDWC_MM,
  ADD_A_B,
  ADD_A_D,
  ADD_A_H,
  ADD_A_W,
  ADD_MM,
  ADD_MMR6,
  ADDi,
  ADDi_MM,
  ADDiu,
  ADDiu_MM,
  ADDu,
  ADDu_MM,
  ALIGN,
  ALIGN_MMR6,
  ALUIPC,
  ALUIPC_MMR6,
  AND,
  AND16_MM,
  AND16_MMR6,
  AND64,
  ANDI16_MM,
  ANDI16_MMR6,
  ANDI_B,
  ANDI_MMR6,
  AND_MM,
  AND_MMR6,
  AND_V,
  ANDi,
  ANDi64,
  ANDi_MM,
  APPEND,
  APPEND_MMR2,
  ASUB_S_B,
  ASUB_S_D,
  ASUB_S_H,
  ASUB_S_W,
  ASUB_U_B,
  ASUB_U_D,
  ASUB_U_H,
  ASUB_U_W,
  AUI,
  AUIPC,
  AUIPC_MMR6,
  AUI_MMR6,
  AVER_S_B,
  AVER_S_D,
  AVER_S_H,
  AVER_S_W,
  AVER_U_B,
  AVER_U_D,
  AVER_U_H,
  AVER_U_W,
  AVE_S_B,
  AVE_S_D,
  AVE_S_H,
  AVE_S_W,
  AVE_U_B,
  AVE_U_D,
  AVE_U_H,
  AVE_U_W,
  AddiuRxImmX16,
  AddiuRxPcImmX16,
  AddiuRxRxImm16,
  AddiuRxRxImmX16,
  AddiuRxRyOffMemX16,
  AddiuSpImm16,
  AddiuSpImmX16,
  AdduRxRyRz16,
  AndRxRxRy16,
  B16_MM,
  BADDu,
  BAL,
  BALC,
  BALC_MMR6,
  BALIGN,
  BALIGN_MMR2,
  BBIT0,
  BBIT032,
  BBIT1,
  BBIT132,
  BC,
  BC16_MMR6,
  BC1EQZ,
  BC1EQZC_MMR6,
  BC1F,
  BC1FL,
  BC1F_MM,
  BC1NEZ,
  BC1NEZC_MMR6,
  BC1T,
  BC1TL,
  BC1T_MM,
  BC2EQZ,
  BC2EQZC_MMR6,
  BC2NEZ,
  BC2NEZC_MMR6,
  BCLRI_B,
  BCLRI_D,
  BCLRI_H,
  BCLRI_W,
  BCLR_B,
  BCLR_D,
  BCLR_H,
  BCLR_W,
  BC_MMR6,
  BEQ,
  BEQ64,
  BEQC,
  BEQC64,
  BEQC_MMR6,
  BEQL,
  BEQZ16_MM,
  BEQZALC,
  BEQZALC_MMR6,
  BEQZC,
  BEQZC16_MMR6,
  BEQZC64,
  BEQZC_MM,
  BEQZC_MMR6,
  BEQ_MM,
  BGEC,
  BGEC64,
  BGEC_MMR6,
  BGEUC,
  BGEUC64,
  BGEUC_MMR6,
  BGEZ,
  BGEZ64,
  BGEZAL,
  BGEZALC,
  BGEZALC_MMR6,
  BGEZALL,
  BGEZALS_MM,
  BGEZAL_MM,
  BGEZC,
  BGEZC64,
  BGEZC_MMR6,
  BGEZL,
  BGEZ_MM,
  BGTZ,
  BGTZ64,
  BGTZALC,
  BGTZALC_MMR6,
  BGTZC,
  BGTZC64,
  BGTZC_MMR6,
  BGTZL,
  BGTZ_MM,
  BINSLI_B,
  BINSLI_D,
  BINSLI_H,
  BINSLI_W,
  BINSL_B,
  BINSL_D,
  BINSL_H,
  BINSL_W,
  BINSRI_B,
  BINSRI_D,
  BINSRI_H,
  BINSRI_W,
  BINSR_B,
  BINSR_D,
  BINSR_H,
  BINSR_W,
  BITREV,
  BITREV_MM,
  BITSWAP,
  BITSWAP_MMR6,
  BLEZ,
  BLEZ64,
  BLEZALC,
  BLEZALC_MMR6,
  BLEZC,
  BLEZC64,
  BLEZC_MMR6,
  BLEZL,
  BLEZ_MM,
  BLTC,
  BLTC64,
  BLTC_MMR6,
  BLTUC,
  BLTUC64,
  BLTUC_MMR6,
  BLTZ,
  BLTZ64,
  BLTZAL,
  BLTZALC,
  BLTZALC_MMR6,
  BLTZALL,
  BLTZALS_MM,
  BLTZAL_MM,
  BLTZC,
  BLTZC64,
  BLTZC_MMR6,
  BLTZL,
  BLTZ_MM,
  BMNZI_B,
  BMNZ_V,
  BMZI_B,
  BMZ_V,
  BNE,
  BNE64,
  BNEC,
  BNEC64,
  BNEC_MMR6,
  BNEGI_B,
  BNEGI_D,
  BNEGI_H,
  BNEGI_W,
  BNEG_B,
  BNEG_D,
  BNEG_H,
  BNEG_W,
  BNEL,
  BNEZ16_MM,
  BNEZALC,
  BNEZALC_MMR6,
  BNEZC,
  BNEZC16_MMR6,
  BNEZC64,
  BNEZC_MM,
  BNEZC_MMR6,
  BNE_MM,
  BNVC,
  BNVC_MMR6,
  BNZ_B,
  BNZ_D,
  BNZ_H,
  BNZ_V,
  BNZ_W,
  BOVC,
  BOVC_MMR6,
  BPOSGE32,
  BPOSGE32C_MMR3,
  BPOSGE32_MM,
  BREAK,
  BREAK16_MM,
  BREAK16_MMR6,
  BREAK_MM,
  BREAK_MMR6,
  BSELI_B,
  BSEL_V,
  BSETI_B,
  BSETI_D,
  BSETI_H,
  BSETI_W,
  BSET_B,
  BSET_D,
  BSET_H,
  BSET_W,
  BZ_B,
  BZ_D,
  BZ_H,
  BZ_V,
  BZ_W,
  BeqzRxImm16,
  BeqzRxImmX16,
  Bimm16,
  BimmX16,
  BnezRxImm16,
  BnezRxImmX16,
  Break16,
  Bteqz16,
  BteqzX16,
  Btnez16,
  BtnezX16,
  CACHE,
  CACHEE,
  CACHEE_MM,
  CACHE_MM,
  CACHE_MMR6,
  CACHE_R6,
  CEIL_L_D64,
  CEIL_L_D_MMR6,
  CEIL_L_S,
  CEIL_L_S_MMR6,
  CEIL_W_D32,
  CEIL_W_D64,
  CEIL_W_D_MMR6,
  CEIL_W_MM,
  CEIL_W_S,
  CEIL_W_S_MM,
  CEIL_W_S_MMR6,
  CEQI_B,
  CEQI_D,
  CEQI_H,
  CEQI_W,
  CEQ_B,
  CEQ_D,
  CEQ_H,
  CEQ_W,
  CFC1,
  CFC1_MM,
  CFC2_MM,
  CFCMSA,
  CINS,
  CINS32,
  CINS64_32,
  CINS_i32,
  CLASS_D,
  CLASS_D_MMR6,
  CLASS_S,
  CLASS_S_MMR6,
  CLEI_S_B,
  CLEI_S_D,
  CLEI_S_H,
  CLEI_S_W,
  CLEI_U_B,
  CLEI_U_D,
  CLEI_U_H,
  CLEI_U_W,
  CLE_S_B,
  CLE_S_D,
  CLE_S_H,
  CLE_S_W,
  CLE_U_B,
  CLE_U_D,
  CLE_U_H,
  CLE_U_W,
  CLO,
  CLO_MM,
  CLO_MMR6,
  CLO_R6,
  CLTI_S_B,
  CLTI_S_D,
  CLTI_S_H,
  CLTI_S_W,
  CLTI_U_B,
  CLTI_U_D,
  CLTI_U_H,
  CLTI_U_W,
  CLT_S_B,
  CLT_S_D,
  CLT_S_H,
  CLT_S_W,
  CLT_U_B,
  CLT_U_D,
  CLT_U_H,
  CLT_U_W,
  CLZ,
  CLZ_MM,
  CLZ_MMR6,
  CLZ_R6,
  CMPGDU_EQ_QB,
  CMPGDU_EQ_QB_MMR2,
  CMPGDU_LE_QB,
  CMPGDU_LE_QB_MMR2,
  CMPGDU_LT_QB,
  CMPGDU_LT_QB_MMR2,
  CMPGU_EQ_QB,
  CMPGU_EQ_QB_MM,
  CMPGU_LE_QB,
  CMPGU_LE_QB_MM,
  CMPGU_LT_QB,
  CMPGU_LT_QB_MM,
  CMPU_EQ_QB,
  CMPU_EQ_QB_MM,
  CMPU_LE_QB,
  CMPU_LE_QB_MM,
  CMPU_LT_QB,
  CMPU_LT_QB_MM,
  CMP_AF_D_MMR6,
  CMP_AF_S_MMR6,
  CMP_EQ_D,
  CMP_EQ_D_MMR6,
  CMP_EQ_PH,
  CMP_EQ_PH_MM,
  CMP_EQ_S,
  CMP_EQ_S_MMR6,
  CMP_F_D,
  CMP_F_S,
  CMP_LE_D,
  CMP_LE_D_MMR6,
  CMP_LE_PH,
  CMP_LE_PH_MM,
  CMP_LE_S,
  CMP_LE_S_MMR6,
  CMP_LT_D,
  CMP_LT_D_MMR6,
  CMP_LT_PH,
  CMP_LT_PH_MM,
  CMP_LT_S,
  CMP_LT_S_MMR6,
  CMP_SAF_D,
  CMP_SAF_D_MMR6,
  CMP_SAF_S,
  CMP_SAF_S_MMR6,
  CMP_SEQ_D,
  CMP_SEQ_D_MMR6,
  CMP_SEQ_S,
  CMP_SEQ_S_MMR6,
  CMP_SLE_D,
  CMP_SLE_D_MMR6,
  CMP_SLE_S,
  CMP_SLE_S_MMR6,
  CMP_SLT_D,
  CMP_SLT_D_MMR6,
  CMP_SLT_S,
  CMP_SLT_S_MMR6,
  CMP_SUEQ_D,
  CMP_SUEQ_D_MMR6,
  CMP_SUEQ_S,
  CMP_SUEQ_S_MMR6,
  CMP_SULE_D,
  CMP_SULE_D_MMR6,
  CMP_SULE_S,
  CMP_SULE_S_MMR6,
  CMP_SULT_D,
  CMP_SULT_D_MMR6,
  CMP_SULT_S,
  CMP_SULT_S_MMR6,
  CMP_SUN_D,
  CMP_SUN_D_MMR6,
  CMP_SUN_S,
  CMP_SUN_S_MMR6,
  CMP_UEQ_D,
  CMP_UEQ_D_MMR6,
  CMP_UEQ_S,
  CMP_UEQ_S_MMR6,
  CMP_ULE_D,
  CMP_ULE_D_MMR6,
  CMP_ULE_S,
  CMP_ULE_S_MMR6,
  CMP_ULT_D,
  CMP_ULT_D_MMR6,
  CMP_ULT_S,
  CMP_ULT_S_MMR6,
  CMP_UN_D,
  CMP_UN_D_MMR6,
  CMP_UN_S,
  CMP_UN_S_MMR6,
  COPY_S_B,
  COPY_S_D,
  COPY_S_H,
  COPY_S_W,
  COPY_U_B,
  COPY_U_H,
  COPY_U_W,
  CRC32B,
  CRC32CB,
  CRC32CD,
  CRC32CH,
  CRC32CW,
  CRC32D,
  CRC32H,
  CRC32W,
  CTC1,
  CTC1_MM,
  CTC2_MM,
  CTCMSA,
  CVT_D32_S,
  CVT_D32_S_MM,
  CVT_D32_W,
  CVT_D32_W_MM,
  CVT_D64_L,
  CVT_D64_S,
  CVT_D64_S_MM,
  CVT_D64_W,
  CVT_D64_W_MM,
  CVT_D_L_MMR6,
  CVT_L_D64,
  CVT_L_D64_MM,
  CVT_L_D_MMR6,
  CVT_L_S,
  CVT_L_S_MM,
  CVT_L_S_MMR6,
  CVT_PS_PW64,
  CVT_PS_S64,
  CVT_PW_PS64,
  CVT_S_D32,
  CVT_S_D32_MM,
  CVT_S_D64,
  CVT_S_D64_MM,
  CVT_S_L,
  CVT_S_L_MMR6,
  CVT_S_PL64,
  CVT_S_PU64,
  CVT_S_W,
  CVT_S_W_MM,
  CVT_S_W_MMR6,
  CVT_W_D32,
  CVT_W_D32_MM,
  CVT_W_D64,
  CVT_W_D64_MM,
  CVT_W_S,
  CVT_W_S_MM,
  CVT_W_S_MMR6,
  C_EQ_D32,
  C_EQ_D32_MM,
  C_EQ_D64,
  C_EQ_D64_MM,
  C_EQ_S,
  C_EQ_S_MM,
  C_F_D32,
  C_F_D32_MM,
  C_F_D64,
  C_F_D64_MM,
  C_F_S,
  C_F_S_MM,
  C_LE_D32,
  C_LE_D32_MM,
  C_LE_D64,
  C_LE_D64_MM,
  C_LE_S,
  C_LE_S_MM,
  C_LT_D32,
  C_LT_D32_MM,
  C_LT_D64,
  C_LT_D64_MM,
  C_LT_S,
  C_LT_S_MM,
  C_NGE_D32,
  C_NGE_D32_MM,
  C_NGE_D64,
  C_NGE_D64_MM,
  C_NGE_S,
  C_NGE_S_MM,
  C_NGLE_D32,
  C_NGLE_D32_MM,
  C_NGLE_D64,
  C_NGLE_D64_MM,
  C_NGLE_S,
  C_NGLE_S_MM,
  C_NGL_D32,
  C_NGL_D32_MM,
  C_NGL_D64,
  C_NGL_D64_MM,
  C_NGL_S,
  C_NGL_S_MM,
  C_NGT_D32,
  C_NGT_D32_MM,
  C_NGT_D64,
  C_NGT_D64_MM,
  C_NGT_S,
  C_NGT_S_MM,
  C_OLE_D32,
  C_OLE_D32_MM,
  C_OLE_D64,
  C_OLE_D64_MM,
  C_OLE_S,
  C_OLE_S_MM,
  C_OLT_D32,
  C_OLT_D32_MM,
  C_OLT_D64,
  C_OLT_D64_MM,
  C_OLT_S,
  C_OLT_S_MM,
  C_SEQ_D32,
  C_SEQ_D32_MM,
  C_SEQ_D64,
  C_SEQ_D64_MM,
  C_SEQ_S,
  C_SEQ_S_MM,
  C_SF_D32,
  C_SF_D32_MM,
  C_SF_D64,
  C_SF_D64_MM,
  C_SF_S,
  C_SF_S_MM,
  C_UEQ_D32,
  C_UEQ_D32_MM,
  C_UEQ_D64,
  C_UEQ_D64_MM,
  C_UEQ_S,
  C_UEQ_S_MM,
  C_ULE_D32,
  C_ULE_D32_MM,
  C_ULE_D64,
  C_ULE_D64_MM,
  C_ULE_S,
  C_ULE_S_MM,
  C_ULT_D32,
  C_ULT_D32_MM,
  C_ULT_D64,
  C_ULT_D64_MM,
  C_ULT_S,
  C_ULT_S_MM,
  C_UN_D32,
  C_UN_D32_MM,
  C_UN_D64,
  C_UN_D64_MM,
  C_UN_S,
  C_UN_S_MM,
  CmpRxRy16,
  CmpiRxImm16,
  CmpiRxImmX16,
  DADD,
  DADDi,
  DADDiu,
  DADDu,
  DAHI,
  DALIGN,
  DATI,
  DAUI,
  DBITSWAP,
  DCLO,
  DCLO_R6,
  DCLZ,
  DCLZ_R6,
  DDIV,
  DDIVU,
  DERET,
  DERET_MM,
  DERET_MMR6,
  DEXT,
  DEXT64_32,
  DEXTM,
  DEXTU,
  DI,
  DINS,
  DINSM,
  DINSU,
  DIV,
  DIVU,
  DIVU_MMR6,
  DIV_MMR6,
  DIV_S_B,
  DIV_S_D,
  DIV_S_H,
  DIV_S_W,
  DIV_U_B,
  DIV_U_D,
  DIV_U_H,
  DIV_U_W,
  DI_MM,
  DI_MMR6,
  DLSA,
  DLSA_R6,
  DMFC0,
  DMFC1,
  DMFC2,
  DMFC2_OCTEON,
  DMFGC0,
  DMOD,
  DMODU,
  DMT,
  DMTC0,
  DMTC1,
  DMTC2,
  DMTC2_OCTEON,
  DMTGC0,
  DMUH,
  DMUHU,
  DMUL,
  DMULT,
  DMULTu,
  DMULU,
  DMUL_R6,
  DOTP_S_D,
  DOTP_S_H,
  DOTP_S_W,
  DOTP_U_D,
  DOTP_U_H,
  DOTP_U_W,
  DPADD_S_D,
  DPADD_S_H,
  DPADD_S_W,
  DPADD_U_D,
  DPADD_U_H,
  DPADD_U_W,
  DPAQX_SA_W_PH,
  DPAQX_SA_W_PH_MMR2,
  DPAQX_S_W_PH,
  DPAQX_S_W_PH_MMR2,
  DPAQ_SA_L_W,
  DPAQ_SA_L_W_MM,
  DPAQ_S_W_PH,
  DPAQ_S_W_PH_MM,
  DPAU_H_QBL,
  DPAU_H_QBL_MM,
  DPAU_H_QBR,
  DPAU_H_QBR_MM,
  DPAX_W_PH,
  DPAX_W_PH_MMR2,
  DPA_W_PH,
  DPA_W_PH_MMR2,
  DPOP,
  DPSQX_SA_W_PH,
  DPSQX_SA_W_PH_MMR2,
  DPSQX_S_W_PH,
  DPSQX_S_W_PH_MMR2,
  DPSQ_SA_L_W,
  DPSQ_SA_L_W_MM,
  DPSQ_S_W_PH,
  DPSQ_S_W_PH_MM,
  DPSUB_S_D,
  DPSUB_S_H,
  DPSUB_S_W,
  DPSUB_U_D,
  DPSUB_U_H,
  DPSUB_U_W,
  DPSU_H_QBL,
  DPSU_H_QBL_MM,
  DPSU_H_QBR,
  DPSU_H_QBR_MM,
  DPSX_W_PH,
  DPSX_W_PH_MMR2,
  DPS_W_PH,
  DPS_W_PH_MMR2,
  DROTR,
  DROTR32,
  DROTRV,
  DSBH,
  DSDIV,
  DSHD,
  DSLL,
  DSLL32,
  DSLL64_32,
  DSLLV,
  DSRA,
  DSRA32,
  DSRAV,
  DSRL,
  DSRL32,
  DSRLV,
  DSUB,
  DSUBu,
  DUDIV,
  DVP,
  DVPE,
  DVP_MMR6,
  DivRxRy16,
  DivuRxRy16,
  EHB,
  EHB_MM,
  EHB_MMR6,
  EI,
  EI_MM,
  EI_MMR6,
  EMT,
  ERET,
  ERETNC,
  ERETNC_MMR6,
  ERET_MM,
  ERET_MMR6,
  EVP,
  EVPE,
  EVP_MMR6,
  EXT,
  EXTP,
  EXTPDP,
  EXTPDPV,
  EXTPDPV_MM,
  EXTPDP_MM,
  EXTPV,
  EXTPV_MM,
  EXTP_MM,
  EXTRV_RS_W,
  EXTRV_RS_W_MM,
  EXTRV_R_W,
  EXTRV_R_W_MM,
  EXTRV_S_H,
  EXTRV_S_H_MM,
  EXTRV_W,
  EXTRV_W_MM,
  EXTR_RS_W,
  EXTR_RS_W_MM,
  EXTR_R_W,
  EXTR_R_W_MM,
  EXTR_S_H,
  EXTR_S_H_MM,
  EXTR_W,
  EXTR_W_MM,
  EXTS,
  EXTS32,
  EXT_MM,
  EXT_MMR6,
  FABS_D32,
  FABS_D32_MM,
  FABS_D64,
  FABS_D64_MM,
  FABS_S,
  FABS_S_MM,
  FADD_D,
  FADD_D32,
  FADD_D32_MM,
  FADD_D64,
  FADD_D64_MM,
  FADD_PS64,
  FADD_S,
  FADD_S_MM,
  FADD_S_MMR6,
  FADD_W,
  FCAF_D,
  FCAF_W,
  FCEQ_D,
  FCEQ_W,
  FCLASS_D,
  FCLASS_W,
  FCLE_D,
  FCLE_W,
  FCLT_D,
  FCLT_W,
  FCMP_D32,
  FCMP_D32_MM,
  FCMP_D64,
  FCMP_S32,
  FCMP_S32_MM,
  FCNE_D,
  FCNE_W,
  FCOR_D,
  FCOR_W,
  FCUEQ_D,
  FCUEQ_W,
  FCULE_D,
  FCULE_W,
  FCULT_D,
  FCULT_W,
  FCUNE_D,
  FCUNE_W,
  FCUN_D,
  FCUN_W,
  FDIV_D,
  FDIV_D32,
  FDIV_D32_MM,
  FDIV_D64,
  FDIV_D64_MM,
  FDIV_S,
  FDIV_S_MM,
  FDIV_S_MMR6,
  FDIV_W,
  FEXDO_H,
  FEXDO_W,
  FEXP2_D,
  FEXP2_W,
  FEXUPL_D,
  FEXUPL_W,
  FEXUPR_D,
  FEXUPR_W,
  FFINT_S_D,
  FFINT_S_W,
  FFINT_U_D,
  FFINT_U_W,
  FFQL_D,
  FFQL_W,
  FFQR_D,
  FFQR_W,
  FILL_B,
  FILL_D,
  FILL_H,
  FILL_W,
  FLOG2_D,
  FLOG2_W,
  FLOOR_L_D64,
  FLOOR_L_D_MMR6,
  FLOOR_L_S,
  FLOOR_L_S_MMR6,
  FLOOR_W_D32,
  FLOOR_W_D64,
  FLOOR_W_D_MMR6,
  FLOOR_W_MM,
  FLOOR_W_S,
  FLOOR_W_S_MM,
  FLOOR_W_S_MMR6,
  FMADD_D,
  FMADD_W,
  FMAX_A_D,
  FMAX_A_W,
  FMAX_D,
  FMAX_W,
  FMIN_A_D,
  FMIN_A_W,
  FMIN_D,
  FMIN_W,
  FMOV_D32,
  FMOV_D32_MM,
  FMOV_D64,
  FMOV_D64_MM,
  FMOV_D_MMR6,
  FMOV_S,
  FMOV_S_MM,
  FMOV_S_MMR6,
  FMSUB_D,
  FMSUB_W,
  FMUL_D,
  FMUL_D32,
  FMUL_D32_MM,
  FMUL_D64,
  FMUL_D64_MM,
  FMUL_PS64,
  FMUL_S,
  FMUL_S_MM,
  FMUL_S_MMR6,
  FMUL_W,
  FNEG_D32,
  FNEG_D32_MM,
  FNEG_D64,
  FNEG_D64_MM,
  FNEG_S,
  FNEG_S_MM,
  FNEG_S_MMR6,
  FORK,
  FRCP_D,
  FRCP_W,
  FRINT_D,
  FRINT_W,
  FRSQRT_D,
  FRSQRT_W,
  FSAF_D,
  FSAF_W,
  FSEQ_D,
  FSEQ_W,
  FSLE_D,
  FSLE_W,
  FSLT_D,
  FSLT_W,
  FSNE_D,
  FSNE_W,
  FSOR_D,
  FSOR_W,
  FSQRT_D,
  FSQRT_D32,
  FSQRT_D32_MM,
  FSQRT_D64,
  FSQRT_D64_MM,
  FSQRT_S,
  FSQRT_S_MM,
  FSQRT_W,
  FSUB_D,
  FSUB_D32,
  FSUB_D32_MM,
  FSUB_D64,
  FSUB_D64_MM,
  FSUB_PS64,
  FSUB_S,
  FSUB_S_MM,
  FSUB_S_MMR6,
  FSUB_W,
  FSUEQ_D,
  FSUEQ_W,
  FSULE_D,
  FSULE_W,
  FSULT_D,
  FSULT_W,
  FSUNE_D,
  FSUNE_W,
  FSUN_D,
  FSUN_W,
  FTINT_S_D,
  FTINT_S_W,
  FTINT_U_D,
  FTINT_U_W,
  FTQ_H,
  FTQ_W,
  FTRUNC_S_D,
  FTRUNC_S_W,
  FTRUNC_U_D,
  FTRUNC_U_W,
  GINVI,
  GINVI_MMR6,
  GINVT,
  GINVT_MMR6,
  HADD_S_D,
  HADD_S_H,
  HADD_S_W,
  HADD_U_D,
  HADD_U_H,
  HADD_U_W,
  HSUB_S_D,
  HSUB_S_H,
  HSUB_S_W,
  HSUB_U_D,
  HSUB_U_H,
  HSUB_U_W,
  HYPCALL,
  HYPCALL_MM,
  ILVEV_B,
  ILVEV_D,
  ILVEV_H,
  ILVEV_W,
  ILVL_B,
  ILVL_D,
  ILVL_H,
  ILVL_W,
  ILVOD_B,
  ILVOD_D,
  ILVOD_H,
  ILVOD_W,
  ILVR_B,
  ILVR_D,
  ILVR_H,
  ILVR_W,
  INS,
  INSERT_B,
  INSERT_D,
  INSERT_H,
  INSERT_W,
  INSV,
  INSVE_B,
  INSVE_D,
  INSVE_H,
  INSVE_W,
  INSV_MM,
  INS_MM,
  INS_MMR6,
  J,
  JAL,
  JALR,
  JALR16_MM,
  JALR64,
  JALRC16_MMR6,
  JALRC_HB_MMR6,
  JALRC_MMR6,
  JALRS16_MM,
  JALRS_MM,
  JALR_HB,
  JALR_HB64,
  JALR_MM,
  JALS_MM,
  JALX,
  JALX_MM,
  JAL_MM,
  JIALC,
  JIALC64,
  JIALC_MMR6,
  JIC,
  JIC64,
  JIC_MMR6,
  JR,
  JR16_MM,
  JR64,
  JRADDIUSP,
  JRC16_MM,
  JRC16_MMR6,
  JRCADDIUSP_MMR6,
  JR_HB,
  JR_HB64,
  JR_HB64_R6,
  JR_HB_R6,
  JR_MM,
  J_MM,
  Jal16,
  JalB16,
  JrRa16,
  JrcRa16,
  JrcRx16,
  JumpLinkReg16,
  LB,
  LB64,
  LBE,
  LBE_MM,
  LBU16_MM,
  LBUX,
  LBUX_MM,
  LBU_MMR6,
  LB_MM,
  LB_MMR6,
  LBu,
  LBu64,
  LBuE,
  LBuE_MM,
  LBu_MM,
  LD,
  LDC1,
  LDC164,
  LDC1_D64_MMR6,
  LDC1_MM_D32,
  LDC1_MM_D64,
  LDC2,
  LDC2_MMR6,
  LDC2_R6,
  LDC3,
  LDI_B,
  LDI_D,
  LDI_H,
  LDI_W,
  LDL,
  LDPC,
  LDR,
  LDXC1,
  LDXC164,
  LD_B,
  LD_D,
  LD_H,
  LD_W,
  LEA_ADDiu,
  LEA_ADDiu64,
  LEA_ADDiu_MM,
  LH,
  LH64,
  LHE,
  LHE_MM,
  LHU16_MM,
  LHX,
  LHX_MM,
  LH_MM,
  LHu,
  LHu64,
  LHuE,
  LHuE_MM,
  LHu_MM,
  LI16_MM,
  LI16_MMR6,
  LL,
  LL64,
  LL64_R6,
  LLD,
  LLD_R6,
  LLE,
  LLE_MM,
  LL_MM,
  LL_MMR6,
  LL_R6,
  LSA,
  LSA_MMR6,
  LSA_R6,
  LUI_MMR6,
  LUXC1,
  LUXC164,
  LUXC1_MM,
  LUi,
  LUi64,
  LUi_MM,
  LW,
  LW16_MM,
  LW64,
  LWC1,
  LWC1_MM,
  LWC2,
  LWC2_MMR6,
  LWC2_R6,
  LWC3,
  LWDSP,
  LWDSP_MM,
  LWE,
  LWE_MM,
  LWGP_MM,
  LWL,
  LWL64,
  LWLE,
  LWLE_MM,
  LWL_MM,
  LWM16_MM,
  LWM16_MMR6,
  LWM32_MM,
  LWPC,
  LWPC_MMR6,
  LWP_MM,
  LWR,
  LWR64,
  LWRE,
  LWRE_MM,
  LWR_MM,
  LWSP_MM,
  LWUPC,
  LWU_MM,
  LWX,
  LWXC1,
  LWXC1_MM,
  LWXS_MM,
  LWX_MM,
  LW_MM,
  LW_MMR6,
  LWu,
  LbRxRyOffMemX16,
  LbuRxRyOffMemX16,
  LhRxRyOffMemX16,
  LhuRxRyOffMemX16,
  LiRxImm16,
  LiRxImmAlignX16,
  LiRxImmX16,
  LwRxPcTcp16,
  LwRxPcTcpX16,
  LwRxRyOffMemX16,
  LwRxSpImmX16,
  MADD,
  MADDF_D,
  MADDF_D_MMR6,
  MADDF_S,
  MADDF_S_MMR6,
  MADDR_Q_H,
  MADDR_Q_W,
  MADDU,
  MADDU_DSP,
  MADDU_DSP_MM,
  MADDU_MM,
  MADDV_B,
  MADDV_D,
  MADDV_H,
  MADDV_W,
  MADD_D32,
  MADD_D32_MM,
  MADD_D64,
  MADD_DSP,
  MADD_DSP_MM,
  MADD_MM,
  MADD_Q_H,
  MADD_Q_W,
  MADD_S,
  MADD_S_MM,
  MAQ_SA_W_PHL,
  MAQ_SA_W_PHL_MM,
  MAQ_SA_W_PHR,
  MAQ_SA_W_PHR_MM,
  MAQ_S_W_PHL,
  MAQ_S_W_PHL_MM,
  MAQ_S_W_PHR,
  MAQ_S_W_PHR_MM,
  MAXA_D,
  MAXA_D_MMR6,
  MAXA_S,
  MAXA_S_MMR6,
  MAXI_S_B,
  MAXI_S_D,
  MAXI_S_H,
  MAXI_S_W,
  MAXI_U_B,
  MAXI_U_D,
  MAXI_U_H,
  MAXI_U_W,
  MAX_A_B,
  MAX_A_D,
  MAX_A_H,
  MAX_A_W,
  MAX_D,
  MAX_D_MMR6,
  MAX_S,
  MAX_S_B,
  MAX_S_D,
  MAX_S_H,
  MAX_S_MMR6,
  MAX_S_W,
  MAX_U_B,
  MAX_U_D,
  MAX_U_H,
  MAX_U_W,
  MFC0,
  MFC0_MMR6,
  MFC1,
  MFC1_D64,
  MFC1_MM,
  MFC1_MMR6,
  MFC2,
  MFC2_MMR6,
  MFGC0,
  MFGC0_MM,
  MFHC0_MMR6,
  MFHC1_D32,
  MFHC1_D32_MM,
  MFHC1_D64,
  MFHC1_D64_MM,
  MFHC2_MMR6,
  MFHGC0,
  MFHGC0_MM,
  MFHI,
  MFHI16_MM,
  MFHI64,
  MFHI_DSP,
  MFHI_DSP_MM,
  MFHI_MM,
  MFLO,
  MFLO16_MM,
  MFLO64,
  MFLO_DSP,
  MFLO_DSP_MM,
  MFLO_MM,
  MFTR,
  MINA_D,
  MINA_D_MMR6,
  MINA_S,
  MINA_S_MMR6,
  MINI_S_B,
  MINI_S_D,
  MINI_S_H,
  MINI_S_W,
  MINI_U_B,
  MINI_U_D,
  MINI_U_H,
  MINI_U_W,
  MIN_A_B,
  MIN_A_D,
  MIN_A_H,
  MIN_A_W,
  MIN_D,
  MIN_D_MMR6,
  MIN_S,
  MIN_S_B,
  MIN_S_D,
  MIN_S_H,
  MIN_S_MMR6,
  MIN_S_W,
  MIN_U_B,
  MIN_U_D,
  MIN_U_H,
  MIN_U_W,
  MOD,
  MODSUB,
  MODSUB_MM,
  MODU,
  MODU_MMR6,
  MOD_MMR6,
  MOD_S_B,
  MOD_S_D,
  MOD_S_H,
  MOD_S_W,
  MOD_U_B,
  MOD_U_D,
  MOD_U_H,
  MOD_U_W,
  MOVE16_MM,
  MOVE16_MMR6,
  MOVEP_MM,
  MOVEP_MMR6,
  MOVE_V,
  MOVF_D32,
  MOVF_D32_MM,
  MOVF_D64,
  MOVF_I,
  MOVF_I64,
  MOVF_I_MM,
  MOVF_S,
  MOVF_S_MM,
  MOVN_I64_D64,
  MOVN_I64_I,
  MOVN_I64_I64,
  MOVN_I64_S,
  MOVN_I_D32,
  MOVN_I_D32_MM,
  MOVN_I_D64,
  MOVN_I_I,
  MOVN_I_I64,
  MOVN_I_MM,
  MOVN_I_S,
  MOVN_I_S_MM,
  MOVT_D32,
  MOVT_D32_MM,
  MOVT_D64,
  MOVT_I,
  MOVT_I64,
  MOVT_I_MM,
  MOVT_S,
  MOVT_S_MM,
  MOVZ_I64_D64,
  MOVZ_I64_I,
  MOVZ_I64_I64,
  MOVZ_I64_S,
  MOVZ_I_D32,
  MOVZ_I_D32_MM,
  MOVZ_I_D64,
  MOVZ_I_I,
  MOVZ_I_I64,
  MOVZ_I_MM,
  MOVZ_I_S,
  MOVZ_I_S_MM,
  MSUB,
  MSUBF_D,
  MSUBF_D_MMR6,
  MSUBF_S,
  MSUBF_S_MMR6,
  MSUBR_Q_H,
  MSUBR_Q_W,
  MSUBU,
  MSUBU_DSP,
  MSUBU_DSP_MM,
  MSUBU_MM,
  MSUBV_B,
  MSUBV_D,
  MSUBV_H,
  MSUBV_W,
  MSUB_D32,
  MSUB_D32_MM,
  MSUB_D64,
  MSUB_DSP,
  MSUB_DSP_MM,
  MSUB_MM,
  MSUB_Q_H,
  MSUB_Q_W,
  MSUB_S,
  MSUB_S_MM,
  MTC0,
  MTC0_MMR6,
  MTC1,
  MTC1_D64,
  MTC1_D64_MM,
  MTC1_MM,
  MTC1_MMR6,
  MTC2,
  MTC2_MMR6,
  MTGC0,
  MTGC0_MM,
  MTHC0_MMR6,
  MTHC1_D32,
  MTHC1_D32_MM,
  MTHC1_D64,
  MTHC1_D64_MM,
  MTHC2_MMR6,
  MTHGC0,
  MTHGC0_MM,
  MTHI,
  MTHI64,
  MTHI_DSP,
  MTHI_DSP_MM,
  MTHI_MM,
  MTHLIP,
  MTHLIP_MM,
  MTLO,
  MTLO64,
  MTLO_DSP,
  MTLO_DSP_MM,
  MTLO_MM,
  MTM0,
  MTM1,
  MTM2,
  MTP0,
  MTP1,
  MTP2,
  MTTR,
  MUH,
  MUHU,
  MUHU_MMR6,
  MUH_MMR6,
  MUL,
  MULEQ_S_W_PHL,
  MULEQ_S_W_PHL_MM,
  MULEQ_S_W_PHR,
  MULEQ_S_W_PHR_MM,
  MULEU_S_PH_QBL,
  MULEU_S_PH_QBL_MM,
  MULEU_S_PH_QBR,
  MULEU_S_PH_QBR_MM,
  MULQ_RS_PH,
  MULQ_RS_PH_MM,
  MULQ_RS_W,
  MULQ_RS_W_MMR2,
  MULQ_S_PH,
  MULQ_S_PH_MMR2,
  MULQ_S_W,
  MULQ_S_W_MMR2,
  MULR_PS64,
  MULR_Q_H,
  MULR_Q_W,
  MULSAQ_S_W_PH,
  MULSAQ_S_W_PH_MM,
  MULSA_W_PH,
  MULSA_W_PH_MMR2,
  MULT,
  MULTU_DSP,
  MULTU_DSP_MM,
  MULT_DSP,
  MULT_DSP_MM,
  MULT_MM,
  MULTu,
  MULTu_MM,
  MULU,
  MULU_MMR6,
  MULV_B,
  MULV_D,
  MULV_H,
  MULV_W,
  MUL_MM,
  MUL_MMR6,
  MUL_PH,
  MUL_PH_MMR2,
  MUL_Q_H,
  MUL_Q_W,
  MUL_R6,
  MUL_S_PH,
  MUL_S_PH_MMR2,
  Mfhi16,
  Mflo16,
  Move32R16,
  MoveR3216,
  NAL,
  NLOC_B,
  NLOC_D,
  NLOC_H,
  NLOC_W,
  NLZC_B,
  NLZC_D,
  NLZC_H,
  NLZC_W,
  NMADD_D32,
  NMADD_D32_MM,
  NMADD_D64,
  NMADD_S,
  NMADD_S_MM,
  NMSUB_D32,
  NMSUB_D32_MM,
  NMSUB_D64,
  NMSUB_S,
  NMSUB_S_MM,
  NOR,
  NOR64,
  NORI_B,
  NOR_MM,
  NOR_MMR6,
  NOR_V,
  NOT16_MM,
  NOT16_MMR6,
  NegRxRy16,
  NotRxRy16,
  OR,
  OR16_MM,
  OR16_MMR6,
  OR64,
  ORI_B,
  ORI_MMR6,
  OR_MM,
  OR_MMR6,
  OR_V,
  ORi,
  ORi64,
  ORi_MM,
  OrRxRxRy16,
  PACKRL_PH,
  PACKRL_PH_MM,
  PAUSE,
  PAUSE_MM,
  PAUSE_MMR6,
  PCKEV_B,
  PCKEV_D,
  PCKEV_H,
  PCKEV_W,
  PCKOD_B,
  PCKOD_D,
  PCKOD_H,
  PCKOD_W,
  PCNT_B,
  PCNT_D,
  PCNT_H,
  PCNT_W,
  PICK_PH,
  PICK_PH_MM,
  PICK_QB,
  PICK_QB_MM,
  PLL_PS64,
  PLU_PS64,
  POP,
  PRECEQU_PH_QBL,
  PRECEQU_PH_QBLA,
  PRECEQU_PH_QBLA_MM,
  PRECEQU_PH_QBL_MM,
  PRECEQU_PH_QBR,
  PRECEQU_PH_QBRA,
  PRECEQU_PH_QBRA_MM,
  PRECEQU_PH_QBR_MM,
  PRECEQ_W_PHL,
  PRECEQ_W_PHL_MM,
  PRECEQ_W_PHR,
  PRECEQ_W_PHR_MM,
  PRECEU_PH_QBL,
  PRECEU_PH_QBLA,
  PRECEU_PH_QBLA_MM,
  PRECEU_PH_QBL_MM,
  PRECEU_PH_QBR,
  PRECEU_PH_QBRA,
  PRECEU_PH_QBRA_MM,
  PRECEU_PH_QBR_MM,
  PRECRQU_S_QB_PH,
  PRECRQU_S_QB_PH_MM,
  PRECRQ_PH_W,
  PRECRQ_PH_W_MM,
  PRECRQ_QB_PH,
  PRECRQ_QB_PH_MM,
  PRECRQ_RS_PH_W,
  PRECRQ_RS_PH_W_MM,
  PRECR_QB_PH,
  PRECR_QB_PH_MMR2,
  PRECR_SRA_PH_W,
  PRECR_SRA_PH_W_MMR2,
  PRECR_SRA_R_PH_W,
  PRECR_SRA_R_PH_W_MMR2,
  PREF,
  PREFE,
  PREFE_MM,
  PREFX_MM,
  PREF_MM,
  PREF_MMR6,
  PREF_R6,
  PREPEND,
  PREPEND_MMR2,
  PUL_PS64,
  PUU_PS64,
  RADDU_W_QB,
  RADDU_W_QB_MM,
  RDDSP,
  RDDSP_MM,
  RDHWR,
  RDHWR64,
  RDHWR_MM,
  RDHWR_MMR6,
  RDPGPR_MMR6,
  RECIP_D32,
  RECIP_D32_MM,
  RECIP_D64,
  RECIP_D64_MM,
  RECIP_S,
  RECIP_S_MM,
  REPLV_PH,
  REPLV_PH_MM,
  REPLV_QB,
  REPLV_QB_MM,
  REPL_PH,
  REPL_PH_MM,
  REPL_QB,
  REPL_QB_MM,
  RINT_D,
  RINT_D_MMR6,
  RINT_S,
  RINT_S_MMR6,
  ROTR,
  ROTRV,
  ROTRV_MM,
  ROTR_MM,
  ROUND_L_D64,
  ROUND_L_D_MMR6,
  ROUND_L_S,
  ROUND_L_S_MMR6,
  ROUND_W_D32,
  ROUND_W_D64,
  ROUND_W_D_MMR6,
  ROUND_W_MM,
  ROUND_W_S,
  ROUND_W_S_MM,
  ROUND_W_S_MMR6,
  RSQRT_D32,
  RSQRT_D32_MM,
  RSQRT_D64,
  RSQRT_D64_MM,
  RSQRT_S,
  RSQRT_S_MM,
  Restore16,
  RestoreX16,
  SAA,
  SAAD,
  SAT_S_B,
  SAT_S_D,
  SAT_S_H,
  SAT_S_W,
  SAT_U_B,
  SAT_U_D,
  SAT_U_H,
  SAT_U_W,
  SB,
  SB16_MM,
  SB16_MMR6,
  SB64,
  SBE,
  SBE_MM,
  SB_MM,
  SB_MMR6,
  SC,
  SC64,
  SC64_R6,
  SCD,
  SCD_R6,
  SCE,
  SCE_MM,
  SC_MM,
  SC_MMR6,
  SC_R6,
  SD,
  SDBBP,
  SDBBP16_MM,
  SDBBP16_MMR6,
  SDBBP_MM,
  SDBBP_MMR6,
  SDBBP_R6,
  SDC1,
  SDC164,
  SDC1_D64_MMR6,
  SDC1_MM_D32,
  SDC1_MM_D64,
  SDC2,
  SDC2_MMR6,
  SDC2_R6,
  SDC3,
  SDIV,
  SDIV_MM,
  SDL,
  SDR,
  SDXC1,
  SDXC164,
  SEB,
  SEB64,
  SEB_MM,
  SEH,
  SEH64,
  SEH_MM,
  SELEQZ,
  SELEQZ64,
  SELEQZ_D,
  SELEQZ_D_MMR6,
  SELEQZ_MMR6,
  SELEQZ_S,
  SELEQZ_S_MMR6,
  SELNEZ,
  SELNEZ64,
  SELNEZ_D,
  SELNEZ_D_MMR6,
  SELNEZ_MMR6,
  SELNEZ_S,
  SELNEZ_S_MMR6,
  SEL_D,
  SEL_D_MMR6,
  SEL_S,
  SEL_S_MMR6,
  SEQ,
  SEQi,
  SH,
  SH16_MM,
  SH16_MMR6,
  SH64,
  SHE,
  SHE_MM,
  SHF_B,
  SHF_H,
  SHF_W,
  SHILO,
  SHILOV,
  SHILOV_MM,
  SHILO_MM,
  SHLLV_PH,
  SHLLV_PH_MM,
  SHLLV_QB,
  SHLLV_QB_MM,
  SHLLV_S_PH,
  SHLLV_S_PH_MM,
  SHLLV_S_W,
  SHLLV_S_W_MM,
  SHLL_PH,
  SHLL_PH_MM,
  SHLL_QB,
  SHLL_QB_MM,
  SHLL_S_PH,
  SHLL_S_PH_MM,
  SHLL_S_W,
  SHLL_S_W_MM,
  SHRAV_PH,
  SHRAV_PH_MM,
  SHRAV_QB,
  SHRAV_QB_MMR2,
  SHRAV_R_PH,
  SHRAV_R_PH_MM,
  SHRAV_R_QB,
  SHRAV_R_QB_MMR2,
  SHRAV_R_W,
  SHRAV_R_W_MM,
  SHRA_PH,
  SHRA_PH_MM,
  SHRA_QB,
  SHRA_QB_MMR2,
  SHRA_R_PH,
  SHRA_R_PH_MM,
  SHRA_R_QB,
  SHRA_R_QB_MMR2,
  SHRA_R_W,
  SHRA_R_W_MM,
  SHRLV_PH,
  SHRLV_PH_MMR2,
  SHRLV_QB,
  SHRLV_QB_MM,
  SHRL_PH,
  SHRL_PH_MMR2,
  SHRL_QB,
  SHRL_QB_MM,
  SH_MM,
  SH_MMR6,
  SIGRIE,
  SIGRIE_MMR6,
  SLDI_B,
  SLDI_D,
  SLDI_H,
  SLDI_W,
  SLD_B,
  SLD_D,
  SLD_H,
  SLD_W,
  SLL,
  SLL16_MM,
  SLL16_MMR6,
  SLL64_32,
  SLL64_64,
  SLLI_B,
  SLLI_D,
  SLLI_H,
  SLLI_W,
  SLLV,
  SLLV_MM,
  SLL_B,
  SLL_D,
  SLL_H,
  SLL_MM,
  SLL_MMR6,
  SLL_W,
  SLT,
  SLT64,
  SLT_MM,
  SLTi,
  SLTi64,
  SLTi_MM,
  SLTiu,
  SLTiu64,
  SLTiu_MM,
  SLTu,
  SLTu64,
  SLTu_MM,
  SNE,
  SNEi,
  SPLATI_B,
  SPLATI_D,
  SPLATI_H,
  SPLATI_W,
  SPLAT_B,
  SPLAT_D,
  SPLAT_H,
  SPLAT_W,
  SRA,
  SRAI_B,
  SRAI_D,
  SRAI_H,
  SRAI_W,
  SRARI_B,
  SRARI_D,
  SRARI_H,
  SRARI_W,
  SRAR_B,
  SRAR_D,
  SRAR_H,
  SRAR_W,
  SRAV,
  SRAV_MM,
  SRA_B,
  SRA_D,
  SRA_H,
  SRA_MM,
  SRA_W,
  SRL,
  SRL16_MM,
  SRL16_MMR6,
  SRLI_B,
  SRLI_D,
  SRLI_H,
  SRLI_W,
  SRLRI_B,
  SRLRI_D,
  SRLRI_H,
  SRLRI_W,
  SRLR_B,
  SRLR_D,
  SRLR_H,
  SRLR_W,
  SRLV,
  SRLV_MM,
  SRL_B,
  SRL_D,
  SRL_H,
  SRL_MM,
  SRL_W,
  SSNOP,
  SSNOP_MM,
  SSNOP_MMR6,
  ST_B,
  ST_D,
  ST_H,
  ST_W,
  SUB,
  SUBQH_PH,
  SUBQH_PH_MMR2,
  SUBQH_R_PH,
  SUBQH_R_PH_MMR2,
  SUBQH_R_W,
  SUBQH_R_W_MMR2,
  SUBQH_W,
  SUBQH_W_MMR2,
  SUBQ_PH,
  SUBQ_PH_MM,
  SUBQ_S_PH,
  SUBQ_S_PH_MM,
  SUBQ_S_W,
  SUBQ_S_W_MM,
  SUBSUS_U_B,
  SUBSUS_U_D,
  SUBSUS_U_H,
  SUBSUS_U_W,
  SUBSUU_S_B,
  SUBSUU_S_D,
  SUBSUU_S_H,
  SUBSUU_S_W,
  SUBS_S_B,
  SUBS_S_D,
  SUBS_S_H,
  SUBS_S_W,
  SUBS_U_B,
  SUBS_U_D,
  SUBS_U_H,
  SUBS_U_W,
  SUBU16_MM,
  SUBU16_MMR6,
  SUBUH_QB,
  SUBUH_QB_MMR2,
  SUBUH_R_QB,
  SUBUH_R_QB_MMR2,
  SUBU_MMR6,
  SUBU_PH,
  SUBU_PH_MMR2,
  SUBU_QB,
  SUBU_QB_MM,
  SUBU_S_PH,
  SUBU_S_PH_MMR2,
  SUBU_S_QB,
  SUBU_S_QB_MM,
  SUBVI_B,
  SUBVI_D,
  SUBVI_H,
  SUBVI_W,
  SUBV_B,
  SUBV_D,
  SUBV_H,
  SUBV_W,
  SUB_MM,
  SUB_MMR6,
  SUBu,
  SUBu_MM,
  SUXC1,
  SUXC164,
  SUXC1_MM,
  SW,
  SW16_MM,
  SW16_MMR6,
  SW64,
  SWC1,
  SWC1_MM,
  SWC2,
  SWC2_MMR6,
  SWC2_R6,
  SWC3,
  SWDSP,
  SWDSP_MM,
  SWE,
  SWE_MM,
  SWL,
  SWL64,
  SWLE,
  SWLE_MM,
  SWL_MM,
  SWM16_MM,
  SWM16_MMR6,
  SWM32_MM,
  SWP_MM,
  SWR,
  SWR64,
  SWRE,
  SWRE_MM,
  SWR_MM,
  SWSP_MM,
  SWSP_MMR6,
  SWXC1,
  SWXC1_MM,
  SW_MM,
  SW_MMR6,
  SYNC,
  SYNCI,
  SYNCI_MM,
  SYNCI_MMR6,
  SYNC_MM,
  SYNC_MMR6,
  SYSCALL,
  SYSCALL_MM,
  Save16,
  SaveX16,
  SbRxRyOffMemX16,
  SebRx16,
  SehRx16,
  ShRxRyOffMemX16,
  SllX16,
  SllvRxRy16,
  SltRxRy16,
  SltiRxImm16,
  SltiRxImmX16,
  SltiuRxImm16,
  SltiuRxImmX16,
  SltuRxRy16,
  SraX16,
  SravRxRy16,
  SrlX16,
  SrlvRxRy16,
  SubuRxRyRz16,
  SwRxRyOffMemX16,
  SwRxSpImmX16,
  TEQ,
  TEQI,
  TEQI_MM,
  TEQ_MM,
  TGE,
  TGEI,
  TGEIU,
  TGEIU_MM,
  TGEI_MM,
  TGEU,
  TGEU_MM,
  TGE_MM,
  TLBGINV,
  TLBGINVF,
  TLBGINVF_MM,
  TLBGINV_MM,
  TLBGP,
  TLBGP_MM,
  TLBGR,
  TLBGR_MM,
  TLBGWI,
  TLBGWI_MM,
  TLBGWR,
  TLBGWR_MM,
  TLBINV,
  TLBINVF,
  TLBINVF_MMR6,
  TLBINV_MMR6,
  TLBP,
  TLBP_MM,
  TLBR,
  TLBR_MM,
  TLBWI,
  TLBWI_MM,
  TLBWR,
  TLBWR_MM,
  TLT,
  TLTI,
  TLTIU_MM,
  TLTI_MM,
  TLTU,
  TLTU_MM,
  TLT_MM,
  TNE,
  TNEI,
  TNEI_MM,
  TNE_MM,
  TRUNC_L_D64,
  TRUNC_L_D_MMR6,
  TRUNC_L_S,
  TRUNC_L_S_MMR6,
  TRUNC_W_D32,
  TRUNC_W_D64,
  TRUNC_W_D_MMR6,
  TRUNC_W_MM,
  TRUNC_W_S,
  TRUNC_W_S_MM,
  TRUNC_W_S_MMR6,
  TTLTIU,
  UDIV,
  UDIV_MM,
  V3MULU,
  VMM0,
  VMULU,
  VSHF_B,
  VSHF_D,
  VSHF_H,
  VSHF_W,
  WAIT,
  WAIT_MM,
  WAIT_MMR6,
  WRDSP,
  WRDSP_MM,
  WRPGPR_MMR6,
  WSBH,
  WSBH_MM,
  WSBH_MMR6,
  XOR,
  XOR16_MM,
  XOR16_MMR6,
  XOR64,
  XORI_B,
  XORI_MMR6,
  XOR_MM,
  XOR_MMR6,
  XOR_V,
  XORi,
  XORi64,
  XORi_MM,
  XorRxRxRy16,
  YIELD,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::SUBREG_TO_REG,
          12 => Opcode::COPY_TO_REGCLASS,
          13 => Opcode::DBG_VALUE,
          14 => Opcode::DBG_VALUE_LIST,
          15 => Opcode::DBG_INSTR_REF,
          16 => Opcode::DBG_PHI,
          17 => Opcode::DBG_LABEL,
          18 => Opcode::REG_SEQUENCE,
          19 => Opcode::COPY,
          20 => Opcode::BUNDLE,
          21 => Opcode::LIFETIME_START,
          22 => Opcode::LIFETIME_END,
          23 => Opcode::PSEUDO_PROBE,
          24 => Opcode::ARITH_FENCE,
          25 => Opcode::STACKMAP,
          26 => Opcode::FENTRY_CALL,
          27 => Opcode::PATCHPOINT,
          28 => Opcode::LOAD_STACK_GUARD,
          29 => Opcode::PREALLOCATED_SETUP,
          30 => Opcode::PREALLOCATED_ARG,
          31 => Opcode::STATEPOINT,
          32 => Opcode::LOCAL_ESCAPE,
          33 => Opcode::FAULTING_OP,
          34 => Opcode::PATCHABLE_OP,
          35 => Opcode::PATCHABLE_FUNCTION_ENTER,
          36 => Opcode::PATCHABLE_RET,
          37 => Opcode::PATCHABLE_FUNCTION_EXIT,
          38 => Opcode::PATCHABLE_TAIL_CALL,
          39 => Opcode::PATCHABLE_EVENT_CALL,
          40 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          41 => Opcode::ICALL_BRANCH_FUNNEL,
          42 => Opcode::MEMBARRIER,
          43 => Opcode::JUMP_TABLE_DEBUG_INFO,
          44 => Opcode::CONVERGENCECTRL_ENTRY,
          45 => Opcode::CONVERGENCECTRL_ANCHOR,
          46 => Opcode::CONVERGENCECTRL_LOOP,
          47 => Opcode::CONVERGENCECTRL_GLUE,
          48 => Opcode::G_ASSERT_SEXT,
          49 => Opcode::G_ASSERT_ZEXT,
          50 => Opcode::G_ASSERT_ALIGN,
          51 => Opcode::G_ADD,
          52 => Opcode::G_SUB,
          53 => Opcode::G_MUL,
          54 => Opcode::G_SDIV,
          55 => Opcode::G_UDIV,
          56 => Opcode::G_SREM,
          57 => Opcode::G_UREM,
          58 => Opcode::G_SDIVREM,
          59 => Opcode::G_UDIVREM,
          60 => Opcode::G_AND,
          61 => Opcode::G_OR,
          62 => Opcode::G_XOR,
          63 => Opcode::G_IMPLICIT_DEF,
          64 => Opcode::G_PHI,
          65 => Opcode::G_FRAME_INDEX,
          66 => Opcode::G_GLOBAL_VALUE,
          67 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          68 => Opcode::G_CONSTANT_POOL,
          69 => Opcode::G_EXTRACT,
          70 => Opcode::G_UNMERGE_VALUES,
          71 => Opcode::G_INSERT,
          72 => Opcode::G_MERGE_VALUES,
          73 => Opcode::G_BUILD_VECTOR,
          74 => Opcode::G_BUILD_VECTOR_TRUNC,
          75 => Opcode::G_CONCAT_VECTORS,
          76 => Opcode::G_PTRTOINT,
          77 => Opcode::G_INTTOPTR,
          78 => Opcode::G_BITCAST,
          79 => Opcode::G_FREEZE,
          80 => Opcode::G_CONSTANT_FOLD_BARRIER,
          81 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          82 => Opcode::G_INTRINSIC_TRUNC,
          83 => Opcode::G_INTRINSIC_ROUND,
          84 => Opcode::G_INTRINSIC_LRINT,
          85 => Opcode::G_INTRINSIC_LLRINT,
          86 => Opcode::G_INTRINSIC_ROUNDEVEN,
          87 => Opcode::G_READCYCLECOUNTER,
          88 => Opcode::G_READSTEADYCOUNTER,
          89 => Opcode::G_LOAD,
          90 => Opcode::G_SEXTLOAD,
          91 => Opcode::G_ZEXTLOAD,
          92 => Opcode::G_INDEXED_LOAD,
          93 => Opcode::G_INDEXED_SEXTLOAD,
          94 => Opcode::G_INDEXED_ZEXTLOAD,
          95 => Opcode::G_STORE,
          96 => Opcode::G_INDEXED_STORE,
          97 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          98 => Opcode::G_ATOMIC_CMPXCHG,
          99 => Opcode::G_ATOMICRMW_XCHG,
          100 => Opcode::G_ATOMICRMW_ADD,
          101 => Opcode::G_ATOMICRMW_SUB,
          102 => Opcode::G_ATOMICRMW_AND,
          103 => Opcode::G_ATOMICRMW_NAND,
          104 => Opcode::G_ATOMICRMW_OR,
          105 => Opcode::G_ATOMICRMW_XOR,
          106 => Opcode::G_ATOMICRMW_MAX,
          107 => Opcode::G_ATOMICRMW_MIN,
          108 => Opcode::G_ATOMICRMW_UMAX,
          109 => Opcode::G_ATOMICRMW_UMIN,
          110 => Opcode::G_ATOMICRMW_FADD,
          111 => Opcode::G_ATOMICRMW_FSUB,
          112 => Opcode::G_ATOMICRMW_FMAX,
          113 => Opcode::G_ATOMICRMW_FMIN,
          114 => Opcode::G_ATOMICRMW_UINC_WRAP,
          115 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          116 => Opcode::G_FENCE,
          117 => Opcode::G_PREFETCH,
          118 => Opcode::G_BRCOND,
          119 => Opcode::G_BRINDIRECT,
          120 => Opcode::G_INVOKE_REGION_START,
          121 => Opcode::G_INTRINSIC,
          122 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          123 => Opcode::G_INTRINSIC_CONVERGENT,
          124 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          125 => Opcode::G_ANYEXT,
          126 => Opcode::G_TRUNC,
          127 => Opcode::G_CONSTANT,
          128 => Opcode::G_FCONSTANT,
          129 => Opcode::G_VASTART,
          130 => Opcode::G_VAARG,
          131 => Opcode::G_SEXT,
          132 => Opcode::G_SEXT_INREG,
          133 => Opcode::G_ZEXT,
          134 => Opcode::G_SHL,
          135 => Opcode::G_LSHR,
          136 => Opcode::G_ASHR,
          137 => Opcode::G_FSHL,
          138 => Opcode::G_FSHR,
          139 => Opcode::G_ROTR,
          140 => Opcode::G_ROTL,
          141 => Opcode::G_ICMP,
          142 => Opcode::G_FCMP,
          143 => Opcode::G_SCMP,
          144 => Opcode::G_UCMP,
          145 => Opcode::G_SELECT,
          146 => Opcode::G_UADDO,
          147 => Opcode::G_UADDE,
          148 => Opcode::G_USUBO,
          149 => Opcode::G_USUBE,
          150 => Opcode::G_SADDO,
          151 => Opcode::G_SADDE,
          152 => Opcode::G_SSUBO,
          153 => Opcode::G_SSUBE,
          154 => Opcode::G_UMULO,
          155 => Opcode::G_SMULO,
          156 => Opcode::G_UMULH,
          157 => Opcode::G_SMULH,
          158 => Opcode::G_UADDSAT,
          159 => Opcode::G_SADDSAT,
          160 => Opcode::G_USUBSAT,
          161 => Opcode::G_SSUBSAT,
          162 => Opcode::G_USHLSAT,
          163 => Opcode::G_SSHLSAT,
          164 => Opcode::G_SMULFIX,
          165 => Opcode::G_UMULFIX,
          166 => Opcode::G_SMULFIXSAT,
          167 => Opcode::G_UMULFIXSAT,
          168 => Opcode::G_SDIVFIX,
          169 => Opcode::G_UDIVFIX,
          170 => Opcode::G_SDIVFIXSAT,
          171 => Opcode::G_UDIVFIXSAT,
          172 => Opcode::G_FADD,
          173 => Opcode::G_FSUB,
          174 => Opcode::G_FMUL,
          175 => Opcode::G_FMA,
          176 => Opcode::G_FMAD,
          177 => Opcode::G_FDIV,
          178 => Opcode::G_FREM,
          179 => Opcode::G_FPOW,
          180 => Opcode::G_FPOWI,
          181 => Opcode::G_FEXP,
          182 => Opcode::G_FEXP2,
          183 => Opcode::G_FEXP10,
          184 => Opcode::G_FLOG,
          185 => Opcode::G_FLOG2,
          186 => Opcode::G_FLOG10,
          187 => Opcode::G_FLDEXP,
          188 => Opcode::G_FFREXP,
          189 => Opcode::G_FNEG,
          190 => Opcode::G_FPEXT,
          191 => Opcode::G_FPTRUNC,
          192 => Opcode::G_FPTOSI,
          193 => Opcode::G_FPTOUI,
          194 => Opcode::G_SITOFP,
          195 => Opcode::G_UITOFP,
          196 => Opcode::G_FABS,
          197 => Opcode::G_FCOPYSIGN,
          198 => Opcode::G_IS_FPCLASS,
          199 => Opcode::G_FCANONICALIZE,
          200 => Opcode::G_FMINNUM,
          201 => Opcode::G_FMAXNUM,
          202 => Opcode::G_FMINNUM_IEEE,
          203 => Opcode::G_FMAXNUM_IEEE,
          204 => Opcode::G_FMINIMUM,
          205 => Opcode::G_FMAXIMUM,
          206 => Opcode::G_GET_FPENV,
          207 => Opcode::G_SET_FPENV,
          208 => Opcode::G_RESET_FPENV,
          209 => Opcode::G_GET_FPMODE,
          210 => Opcode::G_SET_FPMODE,
          211 => Opcode::G_RESET_FPMODE,
          212 => Opcode::G_PTR_ADD,
          213 => Opcode::G_PTRMASK,
          214 => Opcode::G_SMIN,
          215 => Opcode::G_SMAX,
          216 => Opcode::G_UMIN,
          217 => Opcode::G_UMAX,
          218 => Opcode::G_ABS,
          219 => Opcode::G_LROUND,
          220 => Opcode::G_LLROUND,
          221 => Opcode::G_BR,
          222 => Opcode::G_BRJT,
          223 => Opcode::G_VSCALE,
          224 => Opcode::G_INSERT_SUBVECTOR,
          225 => Opcode::G_EXTRACT_SUBVECTOR,
          226 => Opcode::G_INSERT_VECTOR_ELT,
          227 => Opcode::G_EXTRACT_VECTOR_ELT,
          228 => Opcode::G_SHUFFLE_VECTOR,
          229 => Opcode::G_SPLAT_VECTOR,
          230 => Opcode::G_VECTOR_COMPRESS,
          231 => Opcode::G_CTTZ,
          232 => Opcode::G_CTTZ_ZERO_UNDEF,
          233 => Opcode::G_CTLZ,
          234 => Opcode::G_CTLZ_ZERO_UNDEF,
          235 => Opcode::G_CTPOP,
          236 => Opcode::G_BSWAP,
          237 => Opcode::G_BITREVERSE,
          238 => Opcode::G_FCEIL,
          239 => Opcode::G_FCOS,
          240 => Opcode::G_FSIN,
          241 => Opcode::G_FTAN,
          242 => Opcode::G_FACOS,
          243 => Opcode::G_FASIN,
          244 => Opcode::G_FATAN,
          245 => Opcode::G_FCOSH,
          246 => Opcode::G_FSINH,
          247 => Opcode::G_FTANH,
          248 => Opcode::G_FSQRT,
          249 => Opcode::G_FFLOOR,
          250 => Opcode::G_FRINT,
          251 => Opcode::G_FNEARBYINT,
          252 => Opcode::G_ADDRSPACE_CAST,
          253 => Opcode::G_BLOCK_ADDR,
          254 => Opcode::G_JUMP_TABLE,
          255 => Opcode::G_DYN_STACKALLOC,
          256 => Opcode::G_STACKSAVE,
          257 => Opcode::G_STACKRESTORE,
          258 => Opcode::G_STRICT_FADD,
          259 => Opcode::G_STRICT_FSUB,
          260 => Opcode::G_STRICT_FMUL,
          261 => Opcode::G_STRICT_FDIV,
          262 => Opcode::G_STRICT_FREM,
          263 => Opcode::G_STRICT_FMA,
          264 => Opcode::G_STRICT_FSQRT,
          265 => Opcode::G_STRICT_FLDEXP,
          266 => Opcode::G_READ_REGISTER,
          267 => Opcode::G_WRITE_REGISTER,
          268 => Opcode::G_MEMCPY,
          269 => Opcode::G_MEMCPY_INLINE,
          270 => Opcode::G_MEMMOVE,
          271 => Opcode::G_MEMSET,
          272 => Opcode::G_BZERO,
          273 => Opcode::G_TRAP,
          274 => Opcode::G_DEBUGTRAP,
          275 => Opcode::G_UBSANTRAP,
          276 => Opcode::G_VECREDUCE_SEQ_FADD,
          277 => Opcode::G_VECREDUCE_SEQ_FMUL,
          278 => Opcode::G_VECREDUCE_FADD,
          279 => Opcode::G_VECREDUCE_FMUL,
          280 => Opcode::G_VECREDUCE_FMAX,
          281 => Opcode::G_VECREDUCE_FMIN,
          282 => Opcode::G_VECREDUCE_FMAXIMUM,
          283 => Opcode::G_VECREDUCE_FMINIMUM,
          284 => Opcode::G_VECREDUCE_ADD,
          285 => Opcode::G_VECREDUCE_MUL,
          286 => Opcode::G_VECREDUCE_AND,
          287 => Opcode::G_VECREDUCE_OR,
          288 => Opcode::G_VECREDUCE_XOR,
          289 => Opcode::G_VECREDUCE_SMAX,
          290 => Opcode::G_VECREDUCE_SMIN,
          291 => Opcode::G_VECREDUCE_UMAX,
          292 => Opcode::G_VECREDUCE_UMIN,
          293 => Opcode::G_SBFX,
          294 => Opcode::G_UBFX,
          295 => Opcode::ABSMacro,
          296 => Opcode::ADJCALLSTACKDOWN,
          297 => Opcode::ADJCALLSTACKUP,
          298 => Opcode::AND_V_D_PSEUDO,
          299 => Opcode::AND_V_H_PSEUDO,
          300 => Opcode::AND_V_W_PSEUDO,
          301 => Opcode::ATOMIC_CMP_SWAP_I16,
          302 => Opcode::ATOMIC_CMP_SWAP_I16_POSTRA,
          303 => Opcode::ATOMIC_CMP_SWAP_I32,
          304 => Opcode::ATOMIC_CMP_SWAP_I32_POSTRA,
          305 => Opcode::ATOMIC_CMP_SWAP_I64,
          306 => Opcode::ATOMIC_CMP_SWAP_I64_POSTRA,
          307 => Opcode::ATOMIC_CMP_SWAP_I8,
          308 => Opcode::ATOMIC_CMP_SWAP_I8_POSTRA,
          309 => Opcode::ATOMIC_LOAD_ADD_I16,
          310 => Opcode::ATOMIC_LOAD_ADD_I16_POSTRA,
          311 => Opcode::ATOMIC_LOAD_ADD_I32,
          312 => Opcode::ATOMIC_LOAD_ADD_I32_POSTRA,
          313 => Opcode::ATOMIC_LOAD_ADD_I64,
          314 => Opcode::ATOMIC_LOAD_ADD_I64_POSTRA,
          315 => Opcode::ATOMIC_LOAD_ADD_I8,
          316 => Opcode::ATOMIC_LOAD_ADD_I8_POSTRA,
          317 => Opcode::ATOMIC_LOAD_AND_I16,
          318 => Opcode::ATOMIC_LOAD_AND_I16_POSTRA,
          319 => Opcode::ATOMIC_LOAD_AND_I32,
          320 => Opcode::ATOMIC_LOAD_AND_I32_POSTRA,
          321 => Opcode::ATOMIC_LOAD_AND_I64,
          322 => Opcode::ATOMIC_LOAD_AND_I64_POSTRA,
          323 => Opcode::ATOMIC_LOAD_AND_I8,
          324 => Opcode::ATOMIC_LOAD_AND_I8_POSTRA,
          325 => Opcode::ATOMIC_LOAD_MAX_I16,
          326 => Opcode::ATOMIC_LOAD_MAX_I16_POSTRA,
          327 => Opcode::ATOMIC_LOAD_MAX_I32,
          328 => Opcode::ATOMIC_LOAD_MAX_I32_POSTRA,
          329 => Opcode::ATOMIC_LOAD_MAX_I64,
          330 => Opcode::ATOMIC_LOAD_MAX_I64_POSTRA,
          331 => Opcode::ATOMIC_LOAD_MAX_I8,
          332 => Opcode::ATOMIC_LOAD_MAX_I8_POSTRA,
          333 => Opcode::ATOMIC_LOAD_MIN_I16,
          334 => Opcode::ATOMIC_LOAD_MIN_I16_POSTRA,
          335 => Opcode::ATOMIC_LOAD_MIN_I32,
          336 => Opcode::ATOMIC_LOAD_MIN_I32_POSTRA,
          337 => Opcode::ATOMIC_LOAD_MIN_I64,
          338 => Opcode::ATOMIC_LOAD_MIN_I64_POSTRA,
          339 => Opcode::ATOMIC_LOAD_MIN_I8,
          340 => Opcode::ATOMIC_LOAD_MIN_I8_POSTRA,
          341 => Opcode::ATOMIC_LOAD_NAND_I16,
          342 => Opcode::ATOMIC_LOAD_NAND_I16_POSTRA,
          343 => Opcode::ATOMIC_LOAD_NAND_I32,
          344 => Opcode::ATOMIC_LOAD_NAND_I32_POSTRA,
          345 => Opcode::ATOMIC_LOAD_NAND_I64,
          346 => Opcode::ATOMIC_LOAD_NAND_I64_POSTRA,
          347 => Opcode::ATOMIC_LOAD_NAND_I8,
          348 => Opcode::ATOMIC_LOAD_NAND_I8_POSTRA,
          349 => Opcode::ATOMIC_LOAD_OR_I16,
          350 => Opcode::ATOMIC_LOAD_OR_I16_POSTRA,
          351 => Opcode::ATOMIC_LOAD_OR_I32,
          352 => Opcode::ATOMIC_LOAD_OR_I32_POSTRA,
          353 => Opcode::ATOMIC_LOAD_OR_I64,
          354 => Opcode::ATOMIC_LOAD_OR_I64_POSTRA,
          355 => Opcode::ATOMIC_LOAD_OR_I8,
          356 => Opcode::ATOMIC_LOAD_OR_I8_POSTRA,
          357 => Opcode::ATOMIC_LOAD_SUB_I16,
          358 => Opcode::ATOMIC_LOAD_SUB_I16_POSTRA,
          359 => Opcode::ATOMIC_LOAD_SUB_I32,
          360 => Opcode::ATOMIC_LOAD_SUB_I32_POSTRA,
          361 => Opcode::ATOMIC_LOAD_SUB_I64,
          362 => Opcode::ATOMIC_LOAD_SUB_I64_POSTRA,
          363 => Opcode::ATOMIC_LOAD_SUB_I8,
          364 => Opcode::ATOMIC_LOAD_SUB_I8_POSTRA,
          365 => Opcode::ATOMIC_LOAD_UMAX_I16,
          366 => Opcode::ATOMIC_LOAD_UMAX_I16_POSTRA,
          367 => Opcode::ATOMIC_LOAD_UMAX_I32,
          368 => Opcode::ATOMIC_LOAD_UMAX_I32_POSTRA,
          369 => Opcode::ATOMIC_LOAD_UMAX_I64,
          370 => Opcode::ATOMIC_LOAD_UMAX_I64_POSTRA,
          371 => Opcode::ATOMIC_LOAD_UMAX_I8,
          372 => Opcode::ATOMIC_LOAD_UMAX_I8_POSTRA,
          373 => Opcode::ATOMIC_LOAD_UMIN_I16,
          374 => Opcode::ATOMIC_LOAD_UMIN_I16_POSTRA,
          375 => Opcode::ATOMIC_LOAD_UMIN_I32,
          376 => Opcode::ATOMIC_LOAD_UMIN_I32_POSTRA,
          377 => Opcode::ATOMIC_LOAD_UMIN_I64,
          378 => Opcode::ATOMIC_LOAD_UMIN_I64_POSTRA,
          379 => Opcode::ATOMIC_LOAD_UMIN_I8,
          380 => Opcode::ATOMIC_LOAD_UMIN_I8_POSTRA,
          381 => Opcode::ATOMIC_LOAD_XOR_I16,
          382 => Opcode::ATOMIC_LOAD_XOR_I16_POSTRA,
          383 => Opcode::ATOMIC_LOAD_XOR_I32,
          384 => Opcode::ATOMIC_LOAD_XOR_I32_POSTRA,
          385 => Opcode::ATOMIC_LOAD_XOR_I64,
          386 => Opcode::ATOMIC_LOAD_XOR_I64_POSTRA,
          387 => Opcode::ATOMIC_LOAD_XOR_I8,
          388 => Opcode::ATOMIC_LOAD_XOR_I8_POSTRA,
          389 => Opcode::ATOMIC_SWAP_I16,
          390 => Opcode::ATOMIC_SWAP_I16_POSTRA,
          391 => Opcode::ATOMIC_SWAP_I32,
          392 => Opcode::ATOMIC_SWAP_I32_POSTRA,
          393 => Opcode::ATOMIC_SWAP_I64,
          394 => Opcode::ATOMIC_SWAP_I64_POSTRA,
          395 => Opcode::ATOMIC_SWAP_I8,
          396 => Opcode::ATOMIC_SWAP_I8_POSTRA,
          397 => Opcode::B,
          398 => Opcode::BAL_BR,
          399 => Opcode::BAL_BR_MM,
          400 => Opcode::BEQLImmMacro,
          401 => Opcode::BGE,
          402 => Opcode::BGEImmMacro,
          403 => Opcode::BGEL,
          404 => Opcode::BGELImmMacro,
          405 => Opcode::BGEU,
          406 => Opcode::BGEUImmMacro,
          407 => Opcode::BGEUL,
          408 => Opcode::BGEULImmMacro,
          409 => Opcode::BGT,
          410 => Opcode::BGTImmMacro,
          411 => Opcode::BGTL,
          412 => Opcode::BGTLImmMacro,
          413 => Opcode::BGTU,
          414 => Opcode::BGTUImmMacro,
          415 => Opcode::BGTUL,
          416 => Opcode::BGTULImmMacro,
          417 => Opcode::BLE,
          418 => Opcode::BLEImmMacro,
          419 => Opcode::BLEL,
          420 => Opcode::BLELImmMacro,
          421 => Opcode::BLEU,
          422 => Opcode::BLEUImmMacro,
          423 => Opcode::BLEUL,
          424 => Opcode::BLEULImmMacro,
          425 => Opcode::BLT,
          426 => Opcode::BLTImmMacro,
          427 => Opcode::BLTL,
          428 => Opcode::BLTLImmMacro,
          429 => Opcode::BLTU,
          430 => Opcode::BLTUImmMacro,
          431 => Opcode::BLTUL,
          432 => Opcode::BLTULImmMacro,
          433 => Opcode::BNELImmMacro,
          434 => Opcode::BPOSGE32_PSEUDO,
          435 => Opcode::BSEL_D_PSEUDO,
          436 => Opcode::BSEL_FD_PSEUDO,
          437 => Opcode::BSEL_FW_PSEUDO,
          438 => Opcode::BSEL_H_PSEUDO,
          439 => Opcode::BSEL_W_PSEUDO,
          440 => Opcode::B_MM,
          441 => Opcode::B_MMR6_Pseudo,
          442 => Opcode::B_MM_Pseudo,
          443 => Opcode::BeqImm,
          444 => Opcode::BneImm,
          445 => Opcode::BteqzT8CmpX16,
          446 => Opcode::BteqzT8CmpiX16,
          447 => Opcode::BteqzT8SltX16,
          448 => Opcode::BteqzT8SltiX16,
          449 => Opcode::BteqzT8SltiuX16,
          450 => Opcode::BteqzT8SltuX16,
          451 => Opcode::BtnezT8CmpX16,
          452 => Opcode::BtnezT8CmpiX16,
          453 => Opcode::BtnezT8SltX16,
          454 => Opcode::BtnezT8SltiX16,
          455 => Opcode::BtnezT8SltiuX16,
          456 => Opcode::BtnezT8SltuX16,
          457 => Opcode::BuildPairF64,
          458 => Opcode::BuildPairF64_64,
          459 => Opcode::CFTC1,
          460 => Opcode::CONSTPOOL_ENTRY,
          461 => Opcode::COPY_FD_PSEUDO,
          462 => Opcode::COPY_FW_PSEUDO,
          463 => Opcode::CTTC1,
          464 => Opcode::Constant32,
          465 => Opcode::DMULImmMacro,
          466 => Opcode::DMULMacro,
          467 => Opcode::DMULOMacro,
          468 => Opcode::DMULOUMacro,
          469 => Opcode::DROL,
          470 => Opcode::DROLImm,
          471 => Opcode::DROR,
          472 => Opcode::DRORImm,
          473 => Opcode::DSDivIMacro,
          474 => Opcode::DSDivMacro,
          475 => Opcode::DSRemIMacro,
          476 => Opcode::DSRemMacro,
          477 => Opcode::DUDivIMacro,
          478 => Opcode::DUDivMacro,
          479 => Opcode::DURemIMacro,
          480 => Opcode::DURemMacro,
          481 => Opcode::ERet,
          482 => Opcode::ExtractElementF64,
          483 => Opcode::ExtractElementF64_64,
          484 => Opcode::FABS_D,
          485 => Opcode::FABS_W,
          486 => Opcode::FEXP2_D_1_PSEUDO,
          487 => Opcode::FEXP2_W_1_PSEUDO,
          488 => Opcode::FILL_FD_PSEUDO,
          489 => Opcode::FILL_FW_PSEUDO,
          490 => Opcode::GotPrologue16,
          491 => Opcode::INSERT_B_VIDX64_PSEUDO,
          492 => Opcode::INSERT_B_VIDX_PSEUDO,
          493 => Opcode::INSERT_D_VIDX64_PSEUDO,
          494 => Opcode::INSERT_D_VIDX_PSEUDO,
          495 => Opcode::INSERT_FD_PSEUDO,
          496 => Opcode::INSERT_FD_VIDX64_PSEUDO,
          497 => Opcode::INSERT_FD_VIDX_PSEUDO,
          498 => Opcode::INSERT_FW_PSEUDO,
          499 => Opcode::INSERT_FW_VIDX64_PSEUDO,
          500 => Opcode::INSERT_FW_VIDX_PSEUDO,
          501 => Opcode::INSERT_H_VIDX64_PSEUDO,
          502 => Opcode::INSERT_H_VIDX_PSEUDO,
          503 => Opcode::INSERT_W_VIDX64_PSEUDO,
          504 => Opcode::INSERT_W_VIDX_PSEUDO,
          505 => Opcode::JALR64Pseudo,
          506 => Opcode::JALRHB64Pseudo,
          507 => Opcode::JALRHBPseudo,
          508 => Opcode::JALRPseudo,
          509 => Opcode::JAL_MMR6,
          510 => Opcode::JalOneReg,
          511 => Opcode::JalTwoReg,
          512 => Opcode::LDMacro,
          513 => Opcode::LDR_D,
          514 => Opcode::LDR_W,
          515 => Opcode::LD_F16,
          516 => Opcode::LOAD_ACC128,
          517 => Opcode::LOAD_ACC64,
          518 => Opcode::LOAD_ACC64DSP,
          519 => Opcode::LOAD_CCOND_DSP,
          520 => Opcode::LONG_BRANCH_ADDiu,
          521 => Opcode::LONG_BRANCH_ADDiu2Op,
          522 => Opcode::LONG_BRANCH_DADDiu,
          523 => Opcode::LONG_BRANCH_DADDiu2Op,
          524 => Opcode::LONG_BRANCH_LUi,
          525 => Opcode::LONG_BRANCH_LUi2Op,
          526 => Opcode::LONG_BRANCH_LUi2Op_64,
          527 => Opcode::LWM_MM,
          528 => Opcode::LoadAddrImm32,
          529 => Opcode::LoadAddrImm64,
          530 => Opcode::LoadAddrReg32,
          531 => Opcode::LoadAddrReg64,
          532 => Opcode::LoadImm32,
          533 => Opcode::LoadImm64,
          534 => Opcode::LoadImmDoubleFGR,
          535 => Opcode::LoadImmDoubleFGR_32,
          536 => Opcode::LoadImmDoubleGPR,
          537 => Opcode::LoadImmSingleFGR,
          538 => Opcode::LoadImmSingleGPR,
          539 => Opcode::LwConstant32,
          540 => Opcode::MFTACX,
          541 => Opcode::MFTC0,
          542 => Opcode::MFTC1,
          543 => Opcode::MFTDSP,
          544 => Opcode::MFTGPR,
          545 => Opcode::MFTHC1,
          546 => Opcode::MFTHI,
          547 => Opcode::MFTLO,
          548 => Opcode::MIPSeh_return32,
          549 => Opcode::MIPSeh_return64,
          550 => Opcode::MSA_FP_EXTEND_D_PSEUDO,
          551 => Opcode::MSA_FP_EXTEND_W_PSEUDO,
          552 => Opcode::MSA_FP_ROUND_D_PSEUDO,
          553 => Opcode::MSA_FP_ROUND_W_PSEUDO,
          554 => Opcode::MTTACX,
          555 => Opcode::MTTC0,
          556 => Opcode::MTTC1,
          557 => Opcode::MTTDSP,
          558 => Opcode::MTTGPR,
          559 => Opcode::MTTHC1,
          560 => Opcode::MTTHI,
          561 => Opcode::MTTLO,
          562 => Opcode::MULImmMacro,
          563 => Opcode::MULOMacro,
          564 => Opcode::MULOUMacro,
          565 => Opcode::MultRxRy16,
          566 => Opcode::MultRxRyRz16,
          567 => Opcode::MultuRxRy16,
          568 => Opcode::MultuRxRyRz16,
          569 => Opcode::NOP,
          570 => Opcode::NORImm,
          571 => Opcode::NORImm64,
          572 => Opcode::NOR_V_D_PSEUDO,
          573 => Opcode::NOR_V_H_PSEUDO,
          574 => Opcode::NOR_V_W_PSEUDO,
          575 => Opcode::OR_V_D_PSEUDO,
          576 => Opcode::OR_V_H_PSEUDO,
          577 => Opcode::OR_V_W_PSEUDO,
          578 => Opcode::PseudoCMPU_EQ_QB,
          579 => Opcode::PseudoCMPU_LE_QB,
          580 => Opcode::PseudoCMPU_LT_QB,
          581 => Opcode::PseudoCMP_EQ_PH,
          582 => Opcode::PseudoCMP_LE_PH,
          583 => Opcode::PseudoCMP_LT_PH,
          584 => Opcode::PseudoCVT_D32_W,
          585 => Opcode::PseudoCVT_D64_L,
          586 => Opcode::PseudoCVT_D64_W,
          587 => Opcode::PseudoCVT_S_L,
          588 => Opcode::PseudoCVT_S_W,
          589 => Opcode::PseudoDMULT,
          590 => Opcode::PseudoDMULTu,
          591 => Opcode::PseudoDSDIV,
          592 => Opcode::PseudoDUDIV,
          593 => Opcode::PseudoD_SELECT_I,
          594 => Opcode::PseudoD_SELECT_I64,
          595 => Opcode::PseudoIndirectBranch,
          596 => Opcode::PseudoIndirectBranch64,
          597 => Opcode::PseudoIndirectBranch64R6,
          598 => Opcode::PseudoIndirectBranchR6,
          599 => Opcode::PseudoIndirectBranch_MM,
          600 => Opcode::PseudoIndirectBranch_MMR6,
          601 => Opcode::PseudoIndirectHazardBranch,
          602 => Opcode::PseudoIndirectHazardBranch64,
          603 => Opcode::PseudoIndrectHazardBranch64R6,
          604 => Opcode::PseudoIndrectHazardBranchR6,
          605 => Opcode::PseudoMADD,
          606 => Opcode::PseudoMADDU,
          607 => Opcode::PseudoMADDU_MM,
          608 => Opcode::PseudoMADD_MM,
          609 => Opcode::PseudoMFHI,
          610 => Opcode::PseudoMFHI64,
          611 => Opcode::PseudoMFHI_MM,
          612 => Opcode::PseudoMFLO,
          613 => Opcode::PseudoMFLO64,
          614 => Opcode::PseudoMFLO_MM,
          615 => Opcode::PseudoMSUB,
          616 => Opcode::PseudoMSUBU,
          617 => Opcode::PseudoMSUBU_MM,
          618 => Opcode::PseudoMSUB_MM,
          619 => Opcode::PseudoMTLOHI,
          620 => Opcode::PseudoMTLOHI64,
          621 => Opcode::PseudoMTLOHI_DSP,
          622 => Opcode::PseudoMTLOHI_MM,
          623 => Opcode::PseudoMULT,
          624 => Opcode::PseudoMULT_MM,
          625 => Opcode::PseudoMULTu,
          626 => Opcode::PseudoMULTu_MM,
          627 => Opcode::PseudoPICK_PH,
          628 => Opcode::PseudoPICK_QB,
          629 => Opcode::PseudoReturn,
          630 => Opcode::PseudoReturn64,
          631 => Opcode::PseudoSDIV,
          632 => Opcode::PseudoSELECTFP_F_D32,
          633 => Opcode::PseudoSELECTFP_F_D64,
          634 => Opcode::PseudoSELECTFP_F_I,
          635 => Opcode::PseudoSELECTFP_F_I64,
          636 => Opcode::PseudoSELECTFP_F_S,
          637 => Opcode::PseudoSELECTFP_T_D32,
          638 => Opcode::PseudoSELECTFP_T_D64,
          639 => Opcode::PseudoSELECTFP_T_I,
          640 => Opcode::PseudoSELECTFP_T_I64,
          641 => Opcode::PseudoSELECTFP_T_S,
          642 => Opcode::PseudoSELECT_D32,
          643 => Opcode::PseudoSELECT_D64,
          644 => Opcode::PseudoSELECT_I,
          645 => Opcode::PseudoSELECT_I64,
          646 => Opcode::PseudoSELECT_S,
          647 => Opcode::PseudoTRUNC_W_D,
          648 => Opcode::PseudoTRUNC_W_D32,
          649 => Opcode::PseudoTRUNC_W_S,
          650 => Opcode::PseudoUDIV,
          651 => Opcode::ROL,
          652 => Opcode::ROLImm,
          653 => Opcode::ROR,
          654 => Opcode::RORImm,
          655 => Opcode::RetRA,
          656 => Opcode::RetRA16,
          657 => Opcode::SDC1_M1,
          658 => Opcode::SDIV_MM_Pseudo,
          659 => Opcode::SDMacro,
          660 => Opcode::SDivIMacro,
          661 => Opcode::SDivMacro,
          662 => Opcode::SEQIMacro,
          663 => Opcode::SEQMacro,
          664 => Opcode::SGE,
          665 => Opcode::SGEImm,
          666 => Opcode::SGEImm64,
          667 => Opcode::SGEU,
          668 => Opcode::SGEUImm,
          669 => Opcode::SGEUImm64,
          670 => Opcode::SGTImm,
          671 => Opcode::SGTImm64,
          672 => Opcode::SGTUImm,
          673 => Opcode::SGTUImm64,
          674 => Opcode::SLE,
          675 => Opcode::SLEImm,
          676 => Opcode::SLEImm64,
          677 => Opcode::SLEU,
          678 => Opcode::SLEUImm,
          679 => Opcode::SLEUImm64,
          680 => Opcode::SLTImm64,
          681 => Opcode::SLTUImm64,
          682 => Opcode::SNEIMacro,
          683 => Opcode::SNEMacro,
          684 => Opcode::SNZ_B_PSEUDO,
          685 => Opcode::SNZ_D_PSEUDO,
          686 => Opcode::SNZ_H_PSEUDO,
          687 => Opcode::SNZ_V_PSEUDO,
          688 => Opcode::SNZ_W_PSEUDO,
          689 => Opcode::SRemIMacro,
          690 => Opcode::SRemMacro,
          691 => Opcode::STORE_ACC128,
          692 => Opcode::STORE_ACC64,
          693 => Opcode::STORE_ACC64DSP,
          694 => Opcode::STORE_CCOND_DSP,
          695 => Opcode::STR_D,
          696 => Opcode::STR_W,
          697 => Opcode::ST_F16,
          698 => Opcode::SWM_MM,
          699 => Opcode::SZ_B_PSEUDO,
          700 => Opcode::SZ_D_PSEUDO,
          701 => Opcode::SZ_H_PSEUDO,
          702 => Opcode::SZ_V_PSEUDO,
          703 => Opcode::SZ_W_PSEUDO,
          704 => Opcode::SaaAddr,
          705 => Opcode::SaadAddr,
          706 => Opcode::SelBeqZ,
          707 => Opcode::SelBneZ,
          708 => Opcode::SelTBteqZCmp,
          709 => Opcode::SelTBteqZCmpi,
          710 => Opcode::SelTBteqZSlt,
          711 => Opcode::SelTBteqZSlti,
          712 => Opcode::SelTBteqZSltiu,
          713 => Opcode::SelTBteqZSltu,
          714 => Opcode::SelTBtneZCmp,
          715 => Opcode::SelTBtneZCmpi,
          716 => Opcode::SelTBtneZSlt,
          717 => Opcode::SelTBtneZSlti,
          718 => Opcode::SelTBtneZSltiu,
          719 => Opcode::SelTBtneZSltu,
          720 => Opcode::SltCCRxRy16,
          721 => Opcode::SltiCCRxImmX16,
          722 => Opcode::SltiuCCRxImmX16,
          723 => Opcode::SltuCCRxRy16,
          724 => Opcode::SltuRxRyRz16,
          725 => Opcode::TAILCALL,
          726 => Opcode::TAILCALL64R6REG,
          727 => Opcode::TAILCALLHB64R6REG,
          728 => Opcode::TAILCALLHBR6REG,
          729 => Opcode::TAILCALLR6REG,
          730 => Opcode::TAILCALLREG,
          731 => Opcode::TAILCALLREG64,
          732 => Opcode::TAILCALLREGHB,
          733 => Opcode::TAILCALLREGHB64,
          734 => Opcode::TAILCALLREG_MM,
          735 => Opcode::TAILCALLREG_MMR6,
          736 => Opcode::TAILCALL_MM,
          737 => Opcode::TAILCALL_MMR6,
          738 => Opcode::TRAP,
          739 => Opcode::TRAP_MM,
          740 => Opcode::UDIV_MM_Pseudo,
          741 => Opcode::UDivIMacro,
          742 => Opcode::UDivMacro,
          743 => Opcode::URemIMacro,
          744 => Opcode::URemMacro,
          745 => Opcode::Ulh,
          746 => Opcode::Ulhu,
          747 => Opcode::Ulw,
          748 => Opcode::Ush,
          749 => Opcode::Usw,
          750 => Opcode::XOR_V_D_PSEUDO,
          751 => Opcode::XOR_V_H_PSEUDO,
          752 => Opcode::XOR_V_W_PSEUDO,
          753 => Opcode::ABSQ_S_PH,
          754 => Opcode::ABSQ_S_PH_MM,
          755 => Opcode::ABSQ_S_QB,
          756 => Opcode::ABSQ_S_QB_MMR2,
          757 => Opcode::ABSQ_S_W,
          758 => Opcode::ABSQ_S_W_MM,
          759 => Opcode::ADD,
          760 => Opcode::ADDIUPC,
          761 => Opcode::ADDIUPC_MM,
          762 => Opcode::ADDIUPC_MMR6,
          763 => Opcode::ADDIUR1SP_MM,
          764 => Opcode::ADDIUR2_MM,
          765 => Opcode::ADDIUS5_MM,
          766 => Opcode::ADDIUSP_MM,
          767 => Opcode::ADDIU_MMR6,
          768 => Opcode::ADDQH_PH,
          769 => Opcode::ADDQH_PH_MMR2,
          770 => Opcode::ADDQH_R_PH,
          771 => Opcode::ADDQH_R_PH_MMR2,
          772 => Opcode::ADDQH_R_W,
          773 => Opcode::ADDQH_R_W_MMR2,
          774 => Opcode::ADDQH_W,
          775 => Opcode::ADDQH_W_MMR2,
          776 => Opcode::ADDQ_PH,
          777 => Opcode::ADDQ_PH_MM,
          778 => Opcode::ADDQ_S_PH,
          779 => Opcode::ADDQ_S_PH_MM,
          780 => Opcode::ADDQ_S_W,
          781 => Opcode::ADDQ_S_W_MM,
          782 => Opcode::ADDR_PS64,
          783 => Opcode::ADDSC,
          784 => Opcode::ADDSC_MM,
          785 => Opcode::ADDS_A_B,
          786 => Opcode::ADDS_A_D,
          787 => Opcode::ADDS_A_H,
          788 => Opcode::ADDS_A_W,
          789 => Opcode::ADDS_S_B,
          790 => Opcode::ADDS_S_D,
          791 => Opcode::ADDS_S_H,
          792 => Opcode::ADDS_S_W,
          793 => Opcode::ADDS_U_B,
          794 => Opcode::ADDS_U_D,
          795 => Opcode::ADDS_U_H,
          796 => Opcode::ADDS_U_W,
          797 => Opcode::ADDU16_MM,
          798 => Opcode::ADDU16_MMR6,
          799 => Opcode::ADDUH_QB,
          800 => Opcode::ADDUH_QB_MMR2,
          801 => Opcode::ADDUH_R_QB,
          802 => Opcode::ADDUH_R_QB_MMR2,
          803 => Opcode::ADDU_MMR6,
          804 => Opcode::ADDU_PH,
          805 => Opcode::ADDU_PH_MMR2,
          806 => Opcode::ADDU_QB,
          807 => Opcode::ADDU_QB_MM,
          808 => Opcode::ADDU_S_PH,
          809 => Opcode::ADDU_S_PH_MMR2,
          810 => Opcode::ADDU_S_QB,
          811 => Opcode::ADDU_S_QB_MM,
          812 => Opcode::ADDVI_B,
          813 => Opcode::ADDVI_D,
          814 => Opcode::ADDVI_H,
          815 => Opcode::ADDVI_W,
          816 => Opcode::ADDV_B,
          817 => Opcode::ADDV_D,
          818 => Opcode::ADDV_H,
          819 => Opcode::ADDV_W,
          820 => Opcode::ADDWC,
          821 => Opcode::ADDWC_MM,
          822 => Opcode::ADD_A_B,
          823 => Opcode::ADD_A_D,
          824 => Opcode::ADD_A_H,
          825 => Opcode::ADD_A_W,
          826 => Opcode::ADD_MM,
          827 => Opcode::ADD_MMR6,
          828 => Opcode::ADDi,
          829 => Opcode::ADDi_MM,
          830 => Opcode::ADDiu,
          831 => Opcode::ADDiu_MM,
          832 => Opcode::ADDu,
          833 => Opcode::ADDu_MM,
          834 => Opcode::ALIGN,
          835 => Opcode::ALIGN_MMR6,
          836 => Opcode::ALUIPC,
          837 => Opcode::ALUIPC_MMR6,
          838 => Opcode::AND,
          839 => Opcode::AND16_MM,
          840 => Opcode::AND16_MMR6,
          841 => Opcode::AND64,
          842 => Opcode::ANDI16_MM,
          843 => Opcode::ANDI16_MMR6,
          844 => Opcode::ANDI_B,
          845 => Opcode::ANDI_MMR6,
          846 => Opcode::AND_MM,
          847 => Opcode::AND_MMR6,
          848 => Opcode::AND_V,
          849 => Opcode::ANDi,
          850 => Opcode::ANDi64,
          851 => Opcode::ANDi_MM,
          852 => Opcode::APPEND,
          853 => Opcode::APPEND_MMR2,
          854 => Opcode::ASUB_S_B,
          855 => Opcode::ASUB_S_D,
          856 => Opcode::ASUB_S_H,
          857 => Opcode::ASUB_S_W,
          858 => Opcode::ASUB_U_B,
          859 => Opcode::ASUB_U_D,
          860 => Opcode::ASUB_U_H,
          861 => Opcode::ASUB_U_W,
          862 => Opcode::AUI,
          863 => Opcode::AUIPC,
          864 => Opcode::AUIPC_MMR6,
          865 => Opcode::AUI_MMR6,
          866 => Opcode::AVER_S_B,
          867 => Opcode::AVER_S_D,
          868 => Opcode::AVER_S_H,
          869 => Opcode::AVER_S_W,
          870 => Opcode::AVER_U_B,
          871 => Opcode::AVER_U_D,
          872 => Opcode::AVER_U_H,
          873 => Opcode::AVER_U_W,
          874 => Opcode::AVE_S_B,
          875 => Opcode::AVE_S_D,
          876 => Opcode::AVE_S_H,
          877 => Opcode::AVE_S_W,
          878 => Opcode::AVE_U_B,
          879 => Opcode::AVE_U_D,
          880 => Opcode::AVE_U_H,
          881 => Opcode::AVE_U_W,
          882 => Opcode::AddiuRxImmX16,
          883 => Opcode::AddiuRxPcImmX16,
          884 => Opcode::AddiuRxRxImm16,
          885 => Opcode::AddiuRxRxImmX16,
          886 => Opcode::AddiuRxRyOffMemX16,
          887 => Opcode::AddiuSpImm16,
          888 => Opcode::AddiuSpImmX16,
          889 => Opcode::AdduRxRyRz16,
          890 => Opcode::AndRxRxRy16,
          891 => Opcode::B16_MM,
          892 => Opcode::BADDu,
          893 => Opcode::BAL,
          894 => Opcode::BALC,
          895 => Opcode::BALC_MMR6,
          896 => Opcode::BALIGN,
          897 => Opcode::BALIGN_MMR2,
          898 => Opcode::BBIT0,
          899 => Opcode::BBIT032,
          900 => Opcode::BBIT1,
          901 => Opcode::BBIT132,
          902 => Opcode::BC,
          903 => Opcode::BC16_MMR6,
          904 => Opcode::BC1EQZ,
          905 => Opcode::BC1EQZC_MMR6,
          906 => Opcode::BC1F,
          907 => Opcode::BC1FL,
          908 => Opcode::BC1F_MM,
          909 => Opcode::BC1NEZ,
          910 => Opcode::BC1NEZC_MMR6,
          911 => Opcode::BC1T,
          912 => Opcode::BC1TL,
          913 => Opcode::BC1T_MM,
          914 => Opcode::BC2EQZ,
          915 => Opcode::BC2EQZC_MMR6,
          916 => Opcode::BC2NEZ,
          917 => Opcode::BC2NEZC_MMR6,
          918 => Opcode::BCLRI_B,
          919 => Opcode::BCLRI_D,
          920 => Opcode::BCLRI_H,
          921 => Opcode::BCLRI_W,
          922 => Opcode::BCLR_B,
          923 => Opcode::BCLR_D,
          924 => Opcode::BCLR_H,
          925 => Opcode::BCLR_W,
          926 => Opcode::BC_MMR6,
          927 => Opcode::BEQ,
          928 => Opcode::BEQ64,
          929 => Opcode::BEQC,
          930 => Opcode::BEQC64,
          931 => Opcode::BEQC_MMR6,
          932 => Opcode::BEQL,
          933 => Opcode::BEQZ16_MM,
          934 => Opcode::BEQZALC,
          935 => Opcode::BEQZALC_MMR6,
          936 => Opcode::BEQZC,
          937 => Opcode::BEQZC16_MMR6,
          938 => Opcode::BEQZC64,
          939 => Opcode::BEQZC_MM,
          940 => Opcode::BEQZC_MMR6,
          941 => Opcode::BEQ_MM,
          942 => Opcode::BGEC,
          943 => Opcode::BGEC64,
          944 => Opcode::BGEC_MMR6,
          945 => Opcode::BGEUC,
          946 => Opcode::BGEUC64,
          947 => Opcode::BGEUC_MMR6,
          948 => Opcode::BGEZ,
          949 => Opcode::BGEZ64,
          950 => Opcode::BGEZAL,
          951 => Opcode::BGEZALC,
          952 => Opcode::BGEZALC_MMR6,
          953 => Opcode::BGEZALL,
          954 => Opcode::BGEZALS_MM,
          955 => Opcode::BGEZAL_MM,
          956 => Opcode::BGEZC,
          957 => Opcode::BGEZC64,
          958 => Opcode::BGEZC_MMR6,
          959 => Opcode::BGEZL,
          960 => Opcode::BGEZ_MM,
          961 => Opcode::BGTZ,
          962 => Opcode::BGTZ64,
          963 => Opcode::BGTZALC,
          964 => Opcode::BGTZALC_MMR6,
          965 => Opcode::BGTZC,
          966 => Opcode::BGTZC64,
          967 => Opcode::BGTZC_MMR6,
          968 => Opcode::BGTZL,
          969 => Opcode::BGTZ_MM,
          970 => Opcode::BINSLI_B,
          971 => Opcode::BINSLI_D,
          972 => Opcode::BINSLI_H,
          973 => Opcode::BINSLI_W,
          974 => Opcode::BINSL_B,
          975 => Opcode::BINSL_D,
          976 => Opcode::BINSL_H,
          977 => Opcode::BINSL_W,
          978 => Opcode::BINSRI_B,
          979 => Opcode::BINSRI_D,
          980 => Opcode::BINSRI_H,
          981 => Opcode::BINSRI_W,
          982 => Opcode::BINSR_B,
          983 => Opcode::BINSR_D,
          984 => Opcode::BINSR_H,
          985 => Opcode::BINSR_W,
          986 => Opcode::BITREV,
          987 => Opcode::BITREV_MM,
          988 => Opcode::BITSWAP,
          989 => Opcode::BITSWAP_MMR6,
          990 => Opcode::BLEZ,
          991 => Opcode::BLEZ64,
          992 => Opcode::BLEZALC,
          993 => Opcode::BLEZALC_MMR6,
          994 => Opcode::BLEZC,
          995 => Opcode::BLEZC64,
          996 => Opcode::BLEZC_MMR6,
          997 => Opcode::BLEZL,
          998 => Opcode::BLEZ_MM,
          999 => Opcode::BLTC,
          1000 => Opcode::BLTC64,
          1001 => Opcode::BLTC_MMR6,
          1002 => Opcode::BLTUC,
          1003 => Opcode::BLTUC64,
          1004 => Opcode::BLTUC_MMR6,
          1005 => Opcode::BLTZ,
          1006 => Opcode::BLTZ64,
          1007 => Opcode::BLTZAL,
          1008 => Opcode::BLTZALC,
          1009 => Opcode::BLTZALC_MMR6,
          1010 => Opcode::BLTZALL,
          1011 => Opcode::BLTZALS_MM,
          1012 => Opcode::BLTZAL_MM,
          1013 => Opcode::BLTZC,
          1014 => Opcode::BLTZC64,
          1015 => Opcode::BLTZC_MMR6,
          1016 => Opcode::BLTZL,
          1017 => Opcode::BLTZ_MM,
          1018 => Opcode::BMNZI_B,
          1019 => Opcode::BMNZ_V,
          1020 => Opcode::BMZI_B,
          1021 => Opcode::BMZ_V,
          1022 => Opcode::BNE,
          1023 => Opcode::BNE64,
          1024 => Opcode::BNEC,
          1025 => Opcode::BNEC64,
          1026 => Opcode::BNEC_MMR6,
          1027 => Opcode::BNEGI_B,
          1028 => Opcode::BNEGI_D,
          1029 => Opcode::BNEGI_H,
          1030 => Opcode::BNEGI_W,
          1031 => Opcode::BNEG_B,
          1032 => Opcode::BNEG_D,
          1033 => Opcode::BNEG_H,
          1034 => Opcode::BNEG_W,
          1035 => Opcode::BNEL,
          1036 => Opcode::BNEZ16_MM,
          1037 => Opcode::BNEZALC,
          1038 => Opcode::BNEZALC_MMR6,
          1039 => Opcode::BNEZC,
          1040 => Opcode::BNEZC16_MMR6,
          1041 => Opcode::BNEZC64,
          1042 => Opcode::BNEZC_MM,
          1043 => Opcode::BNEZC_MMR6,
          1044 => Opcode::BNE_MM,
          1045 => Opcode::BNVC,
          1046 => Opcode::BNVC_MMR6,
          1047 => Opcode::BNZ_B,
          1048 => Opcode::BNZ_D,
          1049 => Opcode::BNZ_H,
          1050 => Opcode::BNZ_V,
          1051 => Opcode::BNZ_W,
          1052 => Opcode::BOVC,
          1053 => Opcode::BOVC_MMR6,
          1054 => Opcode::BPOSGE32,
          1055 => Opcode::BPOSGE32C_MMR3,
          1056 => Opcode::BPOSGE32_MM,
          1057 => Opcode::BREAK,
          1058 => Opcode::BREAK16_MM,
          1059 => Opcode::BREAK16_MMR6,
          1060 => Opcode::BREAK_MM,
          1061 => Opcode::BREAK_MMR6,
          1062 => Opcode::BSELI_B,
          1063 => Opcode::BSEL_V,
          1064 => Opcode::BSETI_B,
          1065 => Opcode::BSETI_D,
          1066 => Opcode::BSETI_H,
          1067 => Opcode::BSETI_W,
          1068 => Opcode::BSET_B,
          1069 => Opcode::BSET_D,
          1070 => Opcode::BSET_H,
          1071 => Opcode::BSET_W,
          1072 => Opcode::BZ_B,
          1073 => Opcode::BZ_D,
          1074 => Opcode::BZ_H,
          1075 => Opcode::BZ_V,
          1076 => Opcode::BZ_W,
          1077 => Opcode::BeqzRxImm16,
          1078 => Opcode::BeqzRxImmX16,
          1079 => Opcode::Bimm16,
          1080 => Opcode::BimmX16,
          1081 => Opcode::BnezRxImm16,
          1082 => Opcode::BnezRxImmX16,
          1083 => Opcode::Break16,
          1084 => Opcode::Bteqz16,
          1085 => Opcode::BteqzX16,
          1086 => Opcode::Btnez16,
          1087 => Opcode::BtnezX16,
          1088 => Opcode::CACHE,
          1089 => Opcode::CACHEE,
          1090 => Opcode::CACHEE_MM,
          1091 => Opcode::CACHE_MM,
          1092 => Opcode::CACHE_MMR6,
          1093 => Opcode::CACHE_R6,
          1094 => Opcode::CEIL_L_D64,
          1095 => Opcode::CEIL_L_D_MMR6,
          1096 => Opcode::CEIL_L_S,
          1097 => Opcode::CEIL_L_S_MMR6,
          1098 => Opcode::CEIL_W_D32,
          1099 => Opcode::CEIL_W_D64,
          1100 => Opcode::CEIL_W_D_MMR6,
          1101 => Opcode::CEIL_W_MM,
          1102 => Opcode::CEIL_W_S,
          1103 => Opcode::CEIL_W_S_MM,
          1104 => Opcode::CEIL_W_S_MMR6,
          1105 => Opcode::CEQI_B,
          1106 => Opcode::CEQI_D,
          1107 => Opcode::CEQI_H,
          1108 => Opcode::CEQI_W,
          1109 => Opcode::CEQ_B,
          1110 => Opcode::CEQ_D,
          1111 => Opcode::CEQ_H,
          1112 => Opcode::CEQ_W,
          1113 => Opcode::CFC1,
          1114 => Opcode::CFC1_MM,
          1115 => Opcode::CFC2_MM,
          1116 => Opcode::CFCMSA,
          1117 => Opcode::CINS,
          1118 => Opcode::CINS32,
          1119 => Opcode::CINS64_32,
          1120 => Opcode::CINS_i32,
          1121 => Opcode::CLASS_D,
          1122 => Opcode::CLASS_D_MMR6,
          1123 => Opcode::CLASS_S,
          1124 => Opcode::CLASS_S_MMR6,
          1125 => Opcode::CLEI_S_B,
          1126 => Opcode::CLEI_S_D,
          1127 => Opcode::CLEI_S_H,
          1128 => Opcode::CLEI_S_W,
          1129 => Opcode::CLEI_U_B,
          1130 => Opcode::CLEI_U_D,
          1131 => Opcode::CLEI_U_H,
          1132 => Opcode::CLEI_U_W,
          1133 => Opcode::CLE_S_B,
          1134 => Opcode::CLE_S_D,
          1135 => Opcode::CLE_S_H,
          1136 => Opcode::CLE_S_W,
          1137 => Opcode::CLE_U_B,
          1138 => Opcode::CLE_U_D,
          1139 => Opcode::CLE_U_H,
          1140 => Opcode::CLE_U_W,
          1141 => Opcode::CLO,
          1142 => Opcode::CLO_MM,
          1143 => Opcode::CLO_MMR6,
          1144 => Opcode::CLO_R6,
          1145 => Opcode::CLTI_S_B,
          1146 => Opcode::CLTI_S_D,
          1147 => Opcode::CLTI_S_H,
          1148 => Opcode::CLTI_S_W,
          1149 => Opcode::CLTI_U_B,
          1150 => Opcode::CLTI_U_D,
          1151 => Opcode::CLTI_U_H,
          1152 => Opcode::CLTI_U_W,
          1153 => Opcode::CLT_S_B,
          1154 => Opcode::CLT_S_D,
          1155 => Opcode::CLT_S_H,
          1156 => Opcode::CLT_S_W,
          1157 => Opcode::CLT_U_B,
          1158 => Opcode::CLT_U_D,
          1159 => Opcode::CLT_U_H,
          1160 => Opcode::CLT_U_W,
          1161 => Opcode::CLZ,
          1162 => Opcode::CLZ_MM,
          1163 => Opcode::CLZ_MMR6,
          1164 => Opcode::CLZ_R6,
          1165 => Opcode::CMPGDU_EQ_QB,
          1166 => Opcode::CMPGDU_EQ_QB_MMR2,
          1167 => Opcode::CMPGDU_LE_QB,
          1168 => Opcode::CMPGDU_LE_QB_MMR2,
          1169 => Opcode::CMPGDU_LT_QB,
          1170 => Opcode::CMPGDU_LT_QB_MMR2,
          1171 => Opcode::CMPGU_EQ_QB,
          1172 => Opcode::CMPGU_EQ_QB_MM,
          1173 => Opcode::CMPGU_LE_QB,
          1174 => Opcode::CMPGU_LE_QB_MM,
          1175 => Opcode::CMPGU_LT_QB,
          1176 => Opcode::CMPGU_LT_QB_MM,
          1177 => Opcode::CMPU_EQ_QB,
          1178 => Opcode::CMPU_EQ_QB_MM,
          1179 => Opcode::CMPU_LE_QB,
          1180 => Opcode::CMPU_LE_QB_MM,
          1181 => Opcode::CMPU_LT_QB,
          1182 => Opcode::CMPU_LT_QB_MM,
          1183 => Opcode::CMP_AF_D_MMR6,
          1184 => Opcode::CMP_AF_S_MMR6,
          1185 => Opcode::CMP_EQ_D,
          1186 => Opcode::CMP_EQ_D_MMR6,
          1187 => Opcode::CMP_EQ_PH,
          1188 => Opcode::CMP_EQ_PH_MM,
          1189 => Opcode::CMP_EQ_S,
          1190 => Opcode::CMP_EQ_S_MMR6,
          1191 => Opcode::CMP_F_D,
          1192 => Opcode::CMP_F_S,
          1193 => Opcode::CMP_LE_D,
          1194 => Opcode::CMP_LE_D_MMR6,
          1195 => Opcode::CMP_LE_PH,
          1196 => Opcode::CMP_LE_PH_MM,
          1197 => Opcode::CMP_LE_S,
          1198 => Opcode::CMP_LE_S_MMR6,
          1199 => Opcode::CMP_LT_D,
          1200 => Opcode::CMP_LT_D_MMR6,
          1201 => Opcode::CMP_LT_PH,
          1202 => Opcode::CMP_LT_PH_MM,
          1203 => Opcode::CMP_LT_S,
          1204 => Opcode::CMP_LT_S_MMR6,
          1205 => Opcode::CMP_SAF_D,
          1206 => Opcode::CMP_SAF_D_MMR6,
          1207 => Opcode::CMP_SAF_S,
          1208 => Opcode::CMP_SAF_S_MMR6,
          1209 => Opcode::CMP_SEQ_D,
          1210 => Opcode::CMP_SEQ_D_MMR6,
          1211 => Opcode::CMP_SEQ_S,
          1212 => Opcode::CMP_SEQ_S_MMR6,
          1213 => Opcode::CMP_SLE_D,
          1214 => Opcode::CMP_SLE_D_MMR6,
          1215 => Opcode::CMP_SLE_S,
          1216 => Opcode::CMP_SLE_S_MMR6,
          1217 => Opcode::CMP_SLT_D,
          1218 => Opcode::CMP_SLT_D_MMR6,
          1219 => Opcode::CMP_SLT_S,
          1220 => Opcode::CMP_SLT_S_MMR6,
          1221 => Opcode::CMP_SUEQ_D,
          1222 => Opcode::CMP_SUEQ_D_MMR6,
          1223 => Opcode::CMP_SUEQ_S,
          1224 => Opcode::CMP_SUEQ_S_MMR6,
          1225 => Opcode::CMP_SULE_D,
          1226 => Opcode::CMP_SULE_D_MMR6,
          1227 => Opcode::CMP_SULE_S,
          1228 => Opcode::CMP_SULE_S_MMR6,
          1229 => Opcode::CMP_SULT_D,
          1230 => Opcode::CMP_SULT_D_MMR6,
          1231 => Opcode::CMP_SULT_S,
          1232 => Opcode::CMP_SULT_S_MMR6,
          1233 => Opcode::CMP_SUN_D,
          1234 => Opcode::CMP_SUN_D_MMR6,
          1235 => Opcode::CMP_SUN_S,
          1236 => Opcode::CMP_SUN_S_MMR6,
          1237 => Opcode::CMP_UEQ_D,
          1238 => Opcode::CMP_UEQ_D_MMR6,
          1239 => Opcode::CMP_UEQ_S,
          1240 => Opcode::CMP_UEQ_S_MMR6,
          1241 => Opcode::CMP_ULE_D,
          1242 => Opcode::CMP_ULE_D_MMR6,
          1243 => Opcode::CMP_ULE_S,
          1244 => Opcode::CMP_ULE_S_MMR6,
          1245 => Opcode::CMP_ULT_D,
          1246 => Opcode::CMP_ULT_D_MMR6,
          1247 => Opcode::CMP_ULT_S,
          1248 => Opcode::CMP_ULT_S_MMR6,
          1249 => Opcode::CMP_UN_D,
          1250 => Opcode::CMP_UN_D_MMR6,
          1251 => Opcode::CMP_UN_S,
          1252 => Opcode::CMP_UN_S_MMR6,
          1253 => Opcode::COPY_S_B,
          1254 => Opcode::COPY_S_D,
          1255 => Opcode::COPY_S_H,
          1256 => Opcode::COPY_S_W,
          1257 => Opcode::COPY_U_B,
          1258 => Opcode::COPY_U_H,
          1259 => Opcode::COPY_U_W,
          1260 => Opcode::CRC32B,
          1261 => Opcode::CRC32CB,
          1262 => Opcode::CRC32CD,
          1263 => Opcode::CRC32CH,
          1264 => Opcode::CRC32CW,
          1265 => Opcode::CRC32D,
          1266 => Opcode::CRC32H,
          1267 => Opcode::CRC32W,
          1268 => Opcode::CTC1,
          1269 => Opcode::CTC1_MM,
          1270 => Opcode::CTC2_MM,
          1271 => Opcode::CTCMSA,
          1272 => Opcode::CVT_D32_S,
          1273 => Opcode::CVT_D32_S_MM,
          1274 => Opcode::CVT_D32_W,
          1275 => Opcode::CVT_D32_W_MM,
          1276 => Opcode::CVT_D64_L,
          1277 => Opcode::CVT_D64_S,
          1278 => Opcode::CVT_D64_S_MM,
          1279 => Opcode::CVT_D64_W,
          1280 => Opcode::CVT_D64_W_MM,
          1281 => Opcode::CVT_D_L_MMR6,
          1282 => Opcode::CVT_L_D64,
          1283 => Opcode::CVT_L_D64_MM,
          1284 => Opcode::CVT_L_D_MMR6,
          1285 => Opcode::CVT_L_S,
          1286 => Opcode::CVT_L_S_MM,
          1287 => Opcode::CVT_L_S_MMR6,
          1288 => Opcode::CVT_PS_PW64,
          1289 => Opcode::CVT_PS_S64,
          1290 => Opcode::CVT_PW_PS64,
          1291 => Opcode::CVT_S_D32,
          1292 => Opcode::CVT_S_D32_MM,
          1293 => Opcode::CVT_S_D64,
          1294 => Opcode::CVT_S_D64_MM,
          1295 => Opcode::CVT_S_L,
          1296 => Opcode::CVT_S_L_MMR6,
          1297 => Opcode::CVT_S_PL64,
          1298 => Opcode::CVT_S_PU64,
          1299 => Opcode::CVT_S_W,
          1300 => Opcode::CVT_S_W_MM,
          1301 => Opcode::CVT_S_W_MMR6,
          1302 => Opcode::CVT_W_D32,
          1303 => Opcode::CVT_W_D32_MM,
          1304 => Opcode::CVT_W_D64,
          1305 => Opcode::CVT_W_D64_MM,
          1306 => Opcode::CVT_W_S,
          1307 => Opcode::CVT_W_S_MM,
          1308 => Opcode::CVT_W_S_MMR6,
          1309 => Opcode::C_EQ_D32,
          1310 => Opcode::C_EQ_D32_MM,
          1311 => Opcode::C_EQ_D64,
          1312 => Opcode::C_EQ_D64_MM,
          1313 => Opcode::C_EQ_S,
          1314 => Opcode::C_EQ_S_MM,
          1315 => Opcode::C_F_D32,
          1316 => Opcode::C_F_D32_MM,
          1317 => Opcode::C_F_D64,
          1318 => Opcode::C_F_D64_MM,
          1319 => Opcode::C_F_S,
          1320 => Opcode::C_F_S_MM,
          1321 => Opcode::C_LE_D32,
          1322 => Opcode::C_LE_D32_MM,
          1323 => Opcode::C_LE_D64,
          1324 => Opcode::C_LE_D64_MM,
          1325 => Opcode::C_LE_S,
          1326 => Opcode::C_LE_S_MM,
          1327 => Opcode::C_LT_D32,
          1328 => Opcode::C_LT_D32_MM,
          1329 => Opcode::C_LT_D64,
          1330 => Opcode::C_LT_D64_MM,
          1331 => Opcode::C_LT_S,
          1332 => Opcode::C_LT_S_MM,
          1333 => Opcode::C_NGE_D32,
          1334 => Opcode::C_NGE_D32_MM,
          1335 => Opcode::C_NGE_D64,
          1336 => Opcode::C_NGE_D64_MM,
          1337 => Opcode::C_NGE_S,
          1338 => Opcode::C_NGE_S_MM,
          1339 => Opcode::C_NGLE_D32,
          1340 => Opcode::C_NGLE_D32_MM,
          1341 => Opcode::C_NGLE_D64,
          1342 => Opcode::C_NGLE_D64_MM,
          1343 => Opcode::C_NGLE_S,
          1344 => Opcode::C_NGLE_S_MM,
          1345 => Opcode::C_NGL_D32,
          1346 => Opcode::C_NGL_D32_MM,
          1347 => Opcode::C_NGL_D64,
          1348 => Opcode::C_NGL_D64_MM,
          1349 => Opcode::C_NGL_S,
          1350 => Opcode::C_NGL_S_MM,
          1351 => Opcode::C_NGT_D32,
          1352 => Opcode::C_NGT_D32_MM,
          1353 => Opcode::C_NGT_D64,
          1354 => Opcode::C_NGT_D64_MM,
          1355 => Opcode::C_NGT_S,
          1356 => Opcode::C_NGT_S_MM,
          1357 => Opcode::C_OLE_D32,
          1358 => Opcode::C_OLE_D32_MM,
          1359 => Opcode::C_OLE_D64,
          1360 => Opcode::C_OLE_D64_MM,
          1361 => Opcode::C_OLE_S,
          1362 => Opcode::C_OLE_S_MM,
          1363 => Opcode::C_OLT_D32,
          1364 => Opcode::C_OLT_D32_MM,
          1365 => Opcode::C_OLT_D64,
          1366 => Opcode::C_OLT_D64_MM,
          1367 => Opcode::C_OLT_S,
          1368 => Opcode::C_OLT_S_MM,
          1369 => Opcode::C_SEQ_D32,
          1370 => Opcode::C_SEQ_D32_MM,
          1371 => Opcode::C_SEQ_D64,
          1372 => Opcode::C_SEQ_D64_MM,
          1373 => Opcode::C_SEQ_S,
          1374 => Opcode::C_SEQ_S_MM,
          1375 => Opcode::C_SF_D32,
          1376 => Opcode::C_SF_D32_MM,
          1377 => Opcode::C_SF_D64,
          1378 => Opcode::C_SF_D64_MM,
          1379 => Opcode::C_SF_S,
          1380 => Opcode::C_SF_S_MM,
          1381 => Opcode::C_UEQ_D32,
          1382 => Opcode::C_UEQ_D32_MM,
          1383 => Opcode::C_UEQ_D64,
          1384 => Opcode::C_UEQ_D64_MM,
          1385 => Opcode::C_UEQ_S,
          1386 => Opcode::C_UEQ_S_MM,
          1387 => Opcode::C_ULE_D32,
          1388 => Opcode::C_ULE_D32_MM,
          1389 => Opcode::C_ULE_D64,
          1390 => Opcode::C_ULE_D64_MM,
          1391 => Opcode::C_ULE_S,
          1392 => Opcode::C_ULE_S_MM,
          1393 => Opcode::C_ULT_D32,
          1394 => Opcode::C_ULT_D32_MM,
          1395 => Opcode::C_ULT_D64,
          1396 => Opcode::C_ULT_D64_MM,
          1397 => Opcode::C_ULT_S,
          1398 => Opcode::C_ULT_S_MM,
          1399 => Opcode::C_UN_D32,
          1400 => Opcode::C_UN_D32_MM,
          1401 => Opcode::C_UN_D64,
          1402 => Opcode::C_UN_D64_MM,
          1403 => Opcode::C_UN_S,
          1404 => Opcode::C_UN_S_MM,
          1405 => Opcode::CmpRxRy16,
          1406 => Opcode::CmpiRxImm16,
          1407 => Opcode::CmpiRxImmX16,
          1408 => Opcode::DADD,
          1409 => Opcode::DADDi,
          1410 => Opcode::DADDiu,
          1411 => Opcode::DADDu,
          1412 => Opcode::DAHI,
          1413 => Opcode::DALIGN,
          1414 => Opcode::DATI,
          1415 => Opcode::DAUI,
          1416 => Opcode::DBITSWAP,
          1417 => Opcode::DCLO,
          1418 => Opcode::DCLO_R6,
          1419 => Opcode::DCLZ,
          1420 => Opcode::DCLZ_R6,
          1421 => Opcode::DDIV,
          1422 => Opcode::DDIVU,
          1423 => Opcode::DERET,
          1424 => Opcode::DERET_MM,
          1425 => Opcode::DERET_MMR6,
          1426 => Opcode::DEXT,
          1427 => Opcode::DEXT64_32,
          1428 => Opcode::DEXTM,
          1429 => Opcode::DEXTU,
          1430 => Opcode::DI,
          1431 => Opcode::DINS,
          1432 => Opcode::DINSM,
          1433 => Opcode::DINSU,
          1434 => Opcode::DIV,
          1435 => Opcode::DIVU,
          1436 => Opcode::DIVU_MMR6,
          1437 => Opcode::DIV_MMR6,
          1438 => Opcode::DIV_S_B,
          1439 => Opcode::DIV_S_D,
          1440 => Opcode::DIV_S_H,
          1441 => Opcode::DIV_S_W,
          1442 => Opcode::DIV_U_B,
          1443 => Opcode::DIV_U_D,
          1444 => Opcode::DIV_U_H,
          1445 => Opcode::DIV_U_W,
          1446 => Opcode::DI_MM,
          1447 => Opcode::DI_MMR6,
          1448 => Opcode::DLSA,
          1449 => Opcode::DLSA_R6,
          1450 => Opcode::DMFC0,
          1451 => Opcode::DMFC1,
          1452 => Opcode::DMFC2,
          1453 => Opcode::DMFC2_OCTEON,
          1454 => Opcode::DMFGC0,
          1455 => Opcode::DMOD,
          1456 => Opcode::DMODU,
          1457 => Opcode::DMT,
          1458 => Opcode::DMTC0,
          1459 => Opcode::DMTC1,
          1460 => Opcode::DMTC2,
          1461 => Opcode::DMTC2_OCTEON,
          1462 => Opcode::DMTGC0,
          1463 => Opcode::DMUH,
          1464 => Opcode::DMUHU,
          1465 => Opcode::DMUL,
          1466 => Opcode::DMULT,
          1467 => Opcode::DMULTu,
          1468 => Opcode::DMULU,
          1469 => Opcode::DMUL_R6,
          1470 => Opcode::DOTP_S_D,
          1471 => Opcode::DOTP_S_H,
          1472 => Opcode::DOTP_S_W,
          1473 => Opcode::DOTP_U_D,
          1474 => Opcode::DOTP_U_H,
          1475 => Opcode::DOTP_U_W,
          1476 => Opcode::DPADD_S_D,
          1477 => Opcode::DPADD_S_H,
          1478 => Opcode::DPADD_S_W,
          1479 => Opcode::DPADD_U_D,
          1480 => Opcode::DPADD_U_H,
          1481 => Opcode::DPADD_U_W,
          1482 => Opcode::DPAQX_SA_W_PH,
          1483 => Opcode::DPAQX_SA_W_PH_MMR2,
          1484 => Opcode::DPAQX_S_W_PH,
          1485 => Opcode::DPAQX_S_W_PH_MMR2,
          1486 => Opcode::DPAQ_SA_L_W,
          1487 => Opcode::DPAQ_SA_L_W_MM,
          1488 => Opcode::DPAQ_S_W_PH,
          1489 => Opcode::DPAQ_S_W_PH_MM,
          1490 => Opcode::DPAU_H_QBL,
          1491 => Opcode::DPAU_H_QBL_MM,
          1492 => Opcode::DPAU_H_QBR,
          1493 => Opcode::DPAU_H_QBR_MM,
          1494 => Opcode::DPAX_W_PH,
          1495 => Opcode::DPAX_W_PH_MMR2,
          1496 => Opcode::DPA_W_PH,
          1497 => Opcode::DPA_W_PH_MMR2,
          1498 => Opcode::DPOP,
          1499 => Opcode::DPSQX_SA_W_PH,
          1500 => Opcode::DPSQX_SA_W_PH_MMR2,
          1501 => Opcode::DPSQX_S_W_PH,
          1502 => Opcode::DPSQX_S_W_PH_MMR2,
          1503 => Opcode::DPSQ_SA_L_W,
          1504 => Opcode::DPSQ_SA_L_W_MM,
          1505 => Opcode::DPSQ_S_W_PH,
          1506 => Opcode::DPSQ_S_W_PH_MM,
          1507 => Opcode::DPSUB_S_D,
          1508 => Opcode::DPSUB_S_H,
          1509 => Opcode::DPSUB_S_W,
          1510 => Opcode::DPSUB_U_D,
          1511 => Opcode::DPSUB_U_H,
          1512 => Opcode::DPSUB_U_W,
          1513 => Opcode::DPSU_H_QBL,
          1514 => Opcode::DPSU_H_QBL_MM,
          1515 => Opcode::DPSU_H_QBR,
          1516 => Opcode::DPSU_H_QBR_MM,
          1517 => Opcode::DPSX_W_PH,
          1518 => Opcode::DPSX_W_PH_MMR2,
          1519 => Opcode::DPS_W_PH,
          1520 => Opcode::DPS_W_PH_MMR2,
          1521 => Opcode::DROTR,
          1522 => Opcode::DROTR32,
          1523 => Opcode::DROTRV,
          1524 => Opcode::DSBH,
          1525 => Opcode::DSDIV,
          1526 => Opcode::DSHD,
          1527 => Opcode::DSLL,
          1528 => Opcode::DSLL32,
          1529 => Opcode::DSLL64_32,
          1530 => Opcode::DSLLV,
          1531 => Opcode::DSRA,
          1532 => Opcode::DSRA32,
          1533 => Opcode::DSRAV,
          1534 => Opcode::DSRL,
          1535 => Opcode::DSRL32,
          1536 => Opcode::DSRLV,
          1537 => Opcode::DSUB,
          1538 => Opcode::DSUBu,
          1539 => Opcode::DUDIV,
          1540 => Opcode::DVP,
          1541 => Opcode::DVPE,
          1542 => Opcode::DVP_MMR6,
          1543 => Opcode::DivRxRy16,
          1544 => Opcode::DivuRxRy16,
          1545 => Opcode::EHB,
          1546 => Opcode::EHB_MM,
          1547 => Opcode::EHB_MMR6,
          1548 => Opcode::EI,
          1549 => Opcode::EI_MM,
          1550 => Opcode::EI_MMR6,
          1551 => Opcode::EMT,
          1552 => Opcode::ERET,
          1553 => Opcode::ERETNC,
          1554 => Opcode::ERETNC_MMR6,
          1555 => Opcode::ERET_MM,
          1556 => Opcode::ERET_MMR6,
          1557 => Opcode::EVP,
          1558 => Opcode::EVPE,
          1559 => Opcode::EVP_MMR6,
          1560 => Opcode::EXT,
          1561 => Opcode::EXTP,
          1562 => Opcode::EXTPDP,
          1563 => Opcode::EXTPDPV,
          1564 => Opcode::EXTPDPV_MM,
          1565 => Opcode::EXTPDP_MM,
          1566 => Opcode::EXTPV,
          1567 => Opcode::EXTPV_MM,
          1568 => Opcode::EXTP_MM,
          1569 => Opcode::EXTRV_RS_W,
          1570 => Opcode::EXTRV_RS_W_MM,
          1571 => Opcode::EXTRV_R_W,
          1572 => Opcode::EXTRV_R_W_MM,
          1573 => Opcode::EXTRV_S_H,
          1574 => Opcode::EXTRV_S_H_MM,
          1575 => Opcode::EXTRV_W,
          1576 => Opcode::EXTRV_W_MM,
          1577 => Opcode::EXTR_RS_W,
          1578 => Opcode::EXTR_RS_W_MM,
          1579 => Opcode::EXTR_R_W,
          1580 => Opcode::EXTR_R_W_MM,
          1581 => Opcode::EXTR_S_H,
          1582 => Opcode::EXTR_S_H_MM,
          1583 => Opcode::EXTR_W,
          1584 => Opcode::EXTR_W_MM,
          1585 => Opcode::EXTS,
          1586 => Opcode::EXTS32,
          1587 => Opcode::EXT_MM,
          1588 => Opcode::EXT_MMR6,
          1589 => Opcode::FABS_D32,
          1590 => Opcode::FABS_D32_MM,
          1591 => Opcode::FABS_D64,
          1592 => Opcode::FABS_D64_MM,
          1593 => Opcode::FABS_S,
          1594 => Opcode::FABS_S_MM,
          1595 => Opcode::FADD_D,
          1596 => Opcode::FADD_D32,
          1597 => Opcode::FADD_D32_MM,
          1598 => Opcode::FADD_D64,
          1599 => Opcode::FADD_D64_MM,
          1600 => Opcode::FADD_PS64,
          1601 => Opcode::FADD_S,
          1602 => Opcode::FADD_S_MM,
          1603 => Opcode::FADD_S_MMR6,
          1604 => Opcode::FADD_W,
          1605 => Opcode::FCAF_D,
          1606 => Opcode::FCAF_W,
          1607 => Opcode::FCEQ_D,
          1608 => Opcode::FCEQ_W,
          1609 => Opcode::FCLASS_D,
          1610 => Opcode::FCLASS_W,
          1611 => Opcode::FCLE_D,
          1612 => Opcode::FCLE_W,
          1613 => Opcode::FCLT_D,
          1614 => Opcode::FCLT_W,
          1615 => Opcode::FCMP_D32,
          1616 => Opcode::FCMP_D32_MM,
          1617 => Opcode::FCMP_D64,
          1618 => Opcode::FCMP_S32,
          1619 => Opcode::FCMP_S32_MM,
          1620 => Opcode::FCNE_D,
          1621 => Opcode::FCNE_W,
          1622 => Opcode::FCOR_D,
          1623 => Opcode::FCOR_W,
          1624 => Opcode::FCUEQ_D,
          1625 => Opcode::FCUEQ_W,
          1626 => Opcode::FCULE_D,
          1627 => Opcode::FCULE_W,
          1628 => Opcode::FCULT_D,
          1629 => Opcode::FCULT_W,
          1630 => Opcode::FCUNE_D,
          1631 => Opcode::FCUNE_W,
          1632 => Opcode::FCUN_D,
          1633 => Opcode::FCUN_W,
          1634 => Opcode::FDIV_D,
          1635 => Opcode::FDIV_D32,
          1636 => Opcode::FDIV_D32_MM,
          1637 => Opcode::FDIV_D64,
          1638 => Opcode::FDIV_D64_MM,
          1639 => Opcode::FDIV_S,
          1640 => Opcode::FDIV_S_MM,
          1641 => Opcode::FDIV_S_MMR6,
          1642 => Opcode::FDIV_W,
          1643 => Opcode::FEXDO_H,
          1644 => Opcode::FEXDO_W,
          1645 => Opcode::FEXP2_D,
          1646 => Opcode::FEXP2_W,
          1647 => Opcode::FEXUPL_D,
          1648 => Opcode::FEXUPL_W,
          1649 => Opcode::FEXUPR_D,
          1650 => Opcode::FEXUPR_W,
          1651 => Opcode::FFINT_S_D,
          1652 => Opcode::FFINT_S_W,
          1653 => Opcode::FFINT_U_D,
          1654 => Opcode::FFINT_U_W,
          1655 => Opcode::FFQL_D,
          1656 => Opcode::FFQL_W,
          1657 => Opcode::FFQR_D,
          1658 => Opcode::FFQR_W,
          1659 => Opcode::FILL_B,
          1660 => Opcode::FILL_D,
          1661 => Opcode::FILL_H,
          1662 => Opcode::FILL_W,
          1663 => Opcode::FLOG2_D,
          1664 => Opcode::FLOG2_W,
          1665 => Opcode::FLOOR_L_D64,
          1666 => Opcode::FLOOR_L_D_MMR6,
          1667 => Opcode::FLOOR_L_S,
          1668 => Opcode::FLOOR_L_S_MMR6,
          1669 => Opcode::FLOOR_W_D32,
          1670 => Opcode::FLOOR_W_D64,
          1671 => Opcode::FLOOR_W_D_MMR6,
          1672 => Opcode::FLOOR_W_MM,
          1673 => Opcode::FLOOR_W_S,
          1674 => Opcode::FLOOR_W_S_MM,
          1675 => Opcode::FLOOR_W_S_MMR6,
          1676 => Opcode::FMADD_D,
          1677 => Opcode::FMADD_W,
          1678 => Opcode::FMAX_A_D,
          1679 => Opcode::FMAX_A_W,
          1680 => Opcode::FMAX_D,
          1681 => Opcode::FMAX_W,
          1682 => Opcode::FMIN_A_D,
          1683 => Opcode::FMIN_A_W,
          1684 => Opcode::FMIN_D,
          1685 => Opcode::FMIN_W,
          1686 => Opcode::FMOV_D32,
          1687 => Opcode::FMOV_D32_MM,
          1688 => Opcode::FMOV_D64,
          1689 => Opcode::FMOV_D64_MM,
          1690 => Opcode::FMOV_D_MMR6,
          1691 => Opcode::FMOV_S,
          1692 => Opcode::FMOV_S_MM,
          1693 => Opcode::FMOV_S_MMR6,
          1694 => Opcode::FMSUB_D,
          1695 => Opcode::FMSUB_W,
          1696 => Opcode::FMUL_D,
          1697 => Opcode::FMUL_D32,
          1698 => Opcode::FMUL_D32_MM,
          1699 => Opcode::FMUL_D64,
          1700 => Opcode::FMUL_D64_MM,
          1701 => Opcode::FMUL_PS64,
          1702 => Opcode::FMUL_S,
          1703 => Opcode::FMUL_S_MM,
          1704 => Opcode::FMUL_S_MMR6,
          1705 => Opcode::FMUL_W,
          1706 => Opcode::FNEG_D32,
          1707 => Opcode::FNEG_D32_MM,
          1708 => Opcode::FNEG_D64,
          1709 => Opcode::FNEG_D64_MM,
          1710 => Opcode::FNEG_S,
          1711 => Opcode::FNEG_S_MM,
          1712 => Opcode::FNEG_S_MMR6,
          1713 => Opcode::FORK,
          1714 => Opcode::FRCP_D,
          1715 => Opcode::FRCP_W,
          1716 => Opcode::FRINT_D,
          1717 => Opcode::FRINT_W,
          1718 => Opcode::FRSQRT_D,
          1719 => Opcode::FRSQRT_W,
          1720 => Opcode::FSAF_D,
          1721 => Opcode::FSAF_W,
          1722 => Opcode::FSEQ_D,
          1723 => Opcode::FSEQ_W,
          1724 => Opcode::FSLE_D,
          1725 => Opcode::FSLE_W,
          1726 => Opcode::FSLT_D,
          1727 => Opcode::FSLT_W,
          1728 => Opcode::FSNE_D,
          1729 => Opcode::FSNE_W,
          1730 => Opcode::FSOR_D,
          1731 => Opcode::FSOR_W,
          1732 => Opcode::FSQRT_D,
          1733 => Opcode::FSQRT_D32,
          1734 => Opcode::FSQRT_D32_MM,
          1735 => Opcode::FSQRT_D64,
          1736 => Opcode::FSQRT_D64_MM,
          1737 => Opcode::FSQRT_S,
          1738 => Opcode::FSQRT_S_MM,
          1739 => Opcode::FSQRT_W,
          1740 => Opcode::FSUB_D,
          1741 => Opcode::FSUB_D32,
          1742 => Opcode::FSUB_D32_MM,
          1743 => Opcode::FSUB_D64,
          1744 => Opcode::FSUB_D64_MM,
          1745 => Opcode::FSUB_PS64,
          1746 => Opcode::FSUB_S,
          1747 => Opcode::FSUB_S_MM,
          1748 => Opcode::FSUB_S_MMR6,
          1749 => Opcode::FSUB_W,
          1750 => Opcode::FSUEQ_D,
          1751 => Opcode::FSUEQ_W,
          1752 => Opcode::FSULE_D,
          1753 => Opcode::FSULE_W,
          1754 => Opcode::FSULT_D,
          1755 => Opcode::FSULT_W,
          1756 => Opcode::FSUNE_D,
          1757 => Opcode::FSUNE_W,
          1758 => Opcode::FSUN_D,
          1759 => Opcode::FSUN_W,
          1760 => Opcode::FTINT_S_D,
          1761 => Opcode::FTINT_S_W,
          1762 => Opcode::FTINT_U_D,
          1763 => Opcode::FTINT_U_W,
          1764 => Opcode::FTQ_H,
          1765 => Opcode::FTQ_W,
          1766 => Opcode::FTRUNC_S_D,
          1767 => Opcode::FTRUNC_S_W,
          1768 => Opcode::FTRUNC_U_D,
          1769 => Opcode::FTRUNC_U_W,
          1770 => Opcode::GINVI,
          1771 => Opcode::GINVI_MMR6,
          1772 => Opcode::GINVT,
          1773 => Opcode::GINVT_MMR6,
          1774 => Opcode::HADD_S_D,
          1775 => Opcode::HADD_S_H,
          1776 => Opcode::HADD_S_W,
          1777 => Opcode::HADD_U_D,
          1778 => Opcode::HADD_U_H,
          1779 => Opcode::HADD_U_W,
          1780 => Opcode::HSUB_S_D,
          1781 => Opcode::HSUB_S_H,
          1782 => Opcode::HSUB_S_W,
          1783 => Opcode::HSUB_U_D,
          1784 => Opcode::HSUB_U_H,
          1785 => Opcode::HSUB_U_W,
          1786 => Opcode::HYPCALL,
          1787 => Opcode::HYPCALL_MM,
          1788 => Opcode::ILVEV_B,
          1789 => Opcode::ILVEV_D,
          1790 => Opcode::ILVEV_H,
          1791 => Opcode::ILVEV_W,
          1792 => Opcode::ILVL_B,
          1793 => Opcode::ILVL_D,
          1794 => Opcode::ILVL_H,
          1795 => Opcode::ILVL_W,
          1796 => Opcode::ILVOD_B,
          1797 => Opcode::ILVOD_D,
          1798 => Opcode::ILVOD_H,
          1799 => Opcode::ILVOD_W,
          1800 => Opcode::ILVR_B,
          1801 => Opcode::ILVR_D,
          1802 => Opcode::ILVR_H,
          1803 => Opcode::ILVR_W,
          1804 => Opcode::INS,
          1805 => Opcode::INSERT_B,
          1806 => Opcode::INSERT_D,
          1807 => Opcode::INSERT_H,
          1808 => Opcode::INSERT_W,
          1809 => Opcode::INSV,
          1810 => Opcode::INSVE_B,
          1811 => Opcode::INSVE_D,
          1812 => Opcode::INSVE_H,
          1813 => Opcode::INSVE_W,
          1814 => Opcode::INSV_MM,
          1815 => Opcode::INS_MM,
          1816 => Opcode::INS_MMR6,
          1817 => Opcode::J,
          1818 => Opcode::JAL,
          1819 => Opcode::JALR,
          1820 => Opcode::JALR16_MM,
          1821 => Opcode::JALR64,
          1822 => Opcode::JALRC16_MMR6,
          1823 => Opcode::JALRC_HB_MMR6,
          1824 => Opcode::JALRC_MMR6,
          1825 => Opcode::JALRS16_MM,
          1826 => Opcode::JALRS_MM,
          1827 => Opcode::JALR_HB,
          1828 => Opcode::JALR_HB64,
          1829 => Opcode::JALR_MM,
          1830 => Opcode::JALS_MM,
          1831 => Opcode::JALX,
          1832 => Opcode::JALX_MM,
          1833 => Opcode::JAL_MM,
          1834 => Opcode::JIALC,
          1835 => Opcode::JIALC64,
          1836 => Opcode::JIALC_MMR6,
          1837 => Opcode::JIC,
          1838 => Opcode::JIC64,
          1839 => Opcode::JIC_MMR6,
          1840 => Opcode::JR,
          1841 => Opcode::JR16_MM,
          1842 => Opcode::JR64,
          1843 => Opcode::JRADDIUSP,
          1844 => Opcode::JRC16_MM,
          1845 => Opcode::JRC16_MMR6,
          1846 => Opcode::JRCADDIUSP_MMR6,
          1847 => Opcode::JR_HB,
          1848 => Opcode::JR_HB64,
          1849 => Opcode::JR_HB64_R6,
          1850 => Opcode::JR_HB_R6,
          1851 => Opcode::JR_MM,
          1852 => Opcode::J_MM,
          1853 => Opcode::Jal16,
          1854 => Opcode::JalB16,
          1855 => Opcode::JrRa16,
          1856 => Opcode::JrcRa16,
          1857 => Opcode::JrcRx16,
          1858 => Opcode::JumpLinkReg16,
          1859 => Opcode::LB,
          1860 => Opcode::LB64,
          1861 => Opcode::LBE,
          1862 => Opcode::LBE_MM,
          1863 => Opcode::LBU16_MM,
          1864 => Opcode::LBUX,
          1865 => Opcode::LBUX_MM,
          1866 => Opcode::LBU_MMR6,
          1867 => Opcode::LB_MM,
          1868 => Opcode::LB_MMR6,
          1869 => Opcode::LBu,
          1870 => Opcode::LBu64,
          1871 => Opcode::LBuE,
          1872 => Opcode::LBuE_MM,
          1873 => Opcode::LBu_MM,
          1874 => Opcode::LD,
          1875 => Opcode::LDC1,
          1876 => Opcode::LDC164,
          1877 => Opcode::LDC1_D64_MMR6,
          1878 => Opcode::LDC1_MM_D32,
          1879 => Opcode::LDC1_MM_D64,
          1880 => Opcode::LDC2,
          1881 => Opcode::LDC2_MMR6,
          1882 => Opcode::LDC2_R6,
          1883 => Opcode::LDC3,
          1884 => Opcode::LDI_B,
          1885 => Opcode::LDI_D,
          1886 => Opcode::LDI_H,
          1887 => Opcode::LDI_W,
          1888 => Opcode::LDL,
          1889 => Opcode::LDPC,
          1890 => Opcode::LDR,
          1891 => Opcode::LDXC1,
          1892 => Opcode::LDXC164,
          1893 => Opcode::LD_B,
          1894 => Opcode::LD_D,
          1895 => Opcode::LD_H,
          1896 => Opcode::LD_W,
          1897 => Opcode::LEA_ADDiu,
          1898 => Opcode::LEA_ADDiu64,
          1899 => Opcode::LEA_ADDiu_MM,
          1900 => Opcode::LH,
          1901 => Opcode::LH64,
          1902 => Opcode::LHE,
          1903 => Opcode::LHE_MM,
          1904 => Opcode::LHU16_MM,
          1905 => Opcode::LHX,
          1906 => Opcode::LHX_MM,
          1907 => Opcode::LH_MM,
          1908 => Opcode::LHu,
          1909 => Opcode::LHu64,
          1910 => Opcode::LHuE,
          1911 => Opcode::LHuE_MM,
          1912 => Opcode::LHu_MM,
          1913 => Opcode::LI16_MM,
          1914 => Opcode::LI16_MMR6,
          1915 => Opcode::LL,
          1916 => Opcode::LL64,
          1917 => Opcode::LL64_R6,
          1918 => Opcode::LLD,
          1919 => Opcode::LLD_R6,
          1920 => Opcode::LLE,
          1921 => Opcode::LLE_MM,
          1922 => Opcode::LL_MM,
          1923 => Opcode::LL_MMR6,
          1924 => Opcode::LL_R6,
          1925 => Opcode::LSA,
          1926 => Opcode::LSA_MMR6,
          1927 => Opcode::LSA_R6,
          1928 => Opcode::LUI_MMR6,
          1929 => Opcode::LUXC1,
          1930 => Opcode::LUXC164,
          1931 => Opcode::LUXC1_MM,
          1932 => Opcode::LUi,
          1933 => Opcode::LUi64,
          1934 => Opcode::LUi_MM,
          1935 => Opcode::LW,
          1936 => Opcode::LW16_MM,
          1937 => Opcode::LW64,
          1938 => Opcode::LWC1,
          1939 => Opcode::LWC1_MM,
          1940 => Opcode::LWC2,
          1941 => Opcode::LWC2_MMR6,
          1942 => Opcode::LWC2_R6,
          1943 => Opcode::LWC3,
          1944 => Opcode::LWDSP,
          1945 => Opcode::LWDSP_MM,
          1946 => Opcode::LWE,
          1947 => Opcode::LWE_MM,
          1948 => Opcode::LWGP_MM,
          1949 => Opcode::LWL,
          1950 => Opcode::LWL64,
          1951 => Opcode::LWLE,
          1952 => Opcode::LWLE_MM,
          1953 => Opcode::LWL_MM,
          1954 => Opcode::LWM16_MM,
          1955 => Opcode::LWM16_MMR6,
          1956 => Opcode::LWM32_MM,
          1957 => Opcode::LWPC,
          1958 => Opcode::LWPC_MMR6,
          1959 => Opcode::LWP_MM,
          1960 => Opcode::LWR,
          1961 => Opcode::LWR64,
          1962 => Opcode::LWRE,
          1963 => Opcode::LWRE_MM,
          1964 => Opcode::LWR_MM,
          1965 => Opcode::LWSP_MM,
          1966 => Opcode::LWUPC,
          1967 => Opcode::LWU_MM,
          1968 => Opcode::LWX,
          1969 => Opcode::LWXC1,
          1970 => Opcode::LWXC1_MM,
          1971 => Opcode::LWXS_MM,
          1972 => Opcode::LWX_MM,
          1973 => Opcode::LW_MM,
          1974 => Opcode::LW_MMR6,
          1975 => Opcode::LWu,
          1976 => Opcode::LbRxRyOffMemX16,
          1977 => Opcode::LbuRxRyOffMemX16,
          1978 => Opcode::LhRxRyOffMemX16,
          1979 => Opcode::LhuRxRyOffMemX16,
          1980 => Opcode::LiRxImm16,
          1981 => Opcode::LiRxImmAlignX16,
          1982 => Opcode::LiRxImmX16,
          1983 => Opcode::LwRxPcTcp16,
          1984 => Opcode::LwRxPcTcpX16,
          1985 => Opcode::LwRxRyOffMemX16,
          1986 => Opcode::LwRxSpImmX16,
          1987 => Opcode::MADD,
          1988 => Opcode::MADDF_D,
          1989 => Opcode::MADDF_D_MMR6,
          1990 => Opcode::MADDF_S,
          1991 => Opcode::MADDF_S_MMR6,
          1992 => Opcode::MADDR_Q_H,
          1993 => Opcode::MADDR_Q_W,
          1994 => Opcode::MADDU,
          1995 => Opcode::MADDU_DSP,
          1996 => Opcode::MADDU_DSP_MM,
          1997 => Opcode::MADDU_MM,
          1998 => Opcode::MADDV_B,
          1999 => Opcode::MADDV_D,
          2000 => Opcode::MADDV_H,
          2001 => Opcode::MADDV_W,
          2002 => Opcode::MADD_D32,
          2003 => Opcode::MADD_D32_MM,
          2004 => Opcode::MADD_D64,
          2005 => Opcode::MADD_DSP,
          2006 => Opcode::MADD_DSP_MM,
          2007 => Opcode::MADD_MM,
          2008 => Opcode::MADD_Q_H,
          2009 => Opcode::MADD_Q_W,
          2010 => Opcode::MADD_S,
          2011 => Opcode::MADD_S_MM,
          2012 => Opcode::MAQ_SA_W_PHL,
          2013 => Opcode::MAQ_SA_W_PHL_MM,
          2014 => Opcode::MAQ_SA_W_PHR,
          2015 => Opcode::MAQ_SA_W_PHR_MM,
          2016 => Opcode::MAQ_S_W_PHL,
          2017 => Opcode::MAQ_S_W_PHL_MM,
          2018 => Opcode::MAQ_S_W_PHR,
          2019 => Opcode::MAQ_S_W_PHR_MM,
          2020 => Opcode::MAXA_D,
          2021 => Opcode::MAXA_D_MMR6,
          2022 => Opcode::MAXA_S,
          2023 => Opcode::MAXA_S_MMR6,
          2024 => Opcode::MAXI_S_B,
          2025 => Opcode::MAXI_S_D,
          2026 => Opcode::MAXI_S_H,
          2027 => Opcode::MAXI_S_W,
          2028 => Opcode::MAXI_U_B,
          2029 => Opcode::MAXI_U_D,
          2030 => Opcode::MAXI_U_H,
          2031 => Opcode::MAXI_U_W,
          2032 => Opcode::MAX_A_B,
          2033 => Opcode::MAX_A_D,
          2034 => Opcode::MAX_A_H,
          2035 => Opcode::MAX_A_W,
          2036 => Opcode::MAX_D,
          2037 => Opcode::MAX_D_MMR6,
          2038 => Opcode::MAX_S,
          2039 => Opcode::MAX_S_B,
          2040 => Opcode::MAX_S_D,
          2041 => Opcode::MAX_S_H,
          2042 => Opcode::MAX_S_MMR6,
          2043 => Opcode::MAX_S_W,
          2044 => Opcode::MAX_U_B,
          2045 => Opcode::MAX_U_D,
          2046 => Opcode::MAX_U_H,
          2047 => Opcode::MAX_U_W,
          2048 => Opcode::MFC0,
          2049 => Opcode::MFC0_MMR6,
          2050 => Opcode::MFC1,
          2051 => Opcode::MFC1_D64,
          2052 => Opcode::MFC1_MM,
          2053 => Opcode::MFC1_MMR6,
          2054 => Opcode::MFC2,
          2055 => Opcode::MFC2_MMR6,
          2056 => Opcode::MFGC0,
          2057 => Opcode::MFGC0_MM,
          2058 => Opcode::MFHC0_MMR6,
          2059 => Opcode::MFHC1_D32,
          2060 => Opcode::MFHC1_D32_MM,
          2061 => Opcode::MFHC1_D64,
          2062 => Opcode::MFHC1_D64_MM,
          2063 => Opcode::MFHC2_MMR6,
          2064 => Opcode::MFHGC0,
          2065 => Opcode::MFHGC0_MM,
          2066 => Opcode::MFHI,
          2067 => Opcode::MFHI16_MM,
          2068 => Opcode::MFHI64,
          2069 => Opcode::MFHI_DSP,
          2070 => Opcode::MFHI_DSP_MM,
          2071 => Opcode::MFHI_MM,
          2072 => Opcode::MFLO,
          2073 => Opcode::MFLO16_MM,
          2074 => Opcode::MFLO64,
          2075 => Opcode::MFLO_DSP,
          2076 => Opcode::MFLO_DSP_MM,
          2077 => Opcode::MFLO_MM,
          2078 => Opcode::MFTR,
          2079 => Opcode::MINA_D,
          2080 => Opcode::MINA_D_MMR6,
          2081 => Opcode::MINA_S,
          2082 => Opcode::MINA_S_MMR6,
          2083 => Opcode::MINI_S_B,
          2084 => Opcode::MINI_S_D,
          2085 => Opcode::MINI_S_H,
          2086 => Opcode::MINI_S_W,
          2087 => Opcode::MINI_U_B,
          2088 => Opcode::MINI_U_D,
          2089 => Opcode::MINI_U_H,
          2090 => Opcode::MINI_U_W,
          2091 => Opcode::MIN_A_B,
          2092 => Opcode::MIN_A_D,
          2093 => Opcode::MIN_A_H,
          2094 => Opcode::MIN_A_W,
          2095 => Opcode::MIN_D,
          2096 => Opcode::MIN_D_MMR6,
          2097 => Opcode::MIN_S,
          2098 => Opcode::MIN_S_B,
          2099 => Opcode::MIN_S_D,
          2100 => Opcode::MIN_S_H,
          2101 => Opcode::MIN_S_MMR6,
          2102 => Opcode::MIN_S_W,
          2103 => Opcode::MIN_U_B,
          2104 => Opcode::MIN_U_D,
          2105 => Opcode::MIN_U_H,
          2106 => Opcode::MIN_U_W,
          2107 => Opcode::MOD,
          2108 => Opcode::MODSUB,
          2109 => Opcode::MODSUB_MM,
          2110 => Opcode::MODU,
          2111 => Opcode::MODU_MMR6,
          2112 => Opcode::MOD_MMR6,
          2113 => Opcode::MOD_S_B,
          2114 => Opcode::MOD_S_D,
          2115 => Opcode::MOD_S_H,
          2116 => Opcode::MOD_S_W,
          2117 => Opcode::MOD_U_B,
          2118 => Opcode::MOD_U_D,
          2119 => Opcode::MOD_U_H,
          2120 => Opcode::MOD_U_W,
          2121 => Opcode::MOVE16_MM,
          2122 => Opcode::MOVE16_MMR6,
          2123 => Opcode::MOVEP_MM,
          2124 => Opcode::MOVEP_MMR6,
          2125 => Opcode::MOVE_V,
          2126 => Opcode::MOVF_D32,
          2127 => Opcode::MOVF_D32_MM,
          2128 => Opcode::MOVF_D64,
          2129 => Opcode::MOVF_I,
          2130 => Opcode::MOVF_I64,
          2131 => Opcode::MOVF_I_MM,
          2132 => Opcode::MOVF_S,
          2133 => Opcode::MOVF_S_MM,
          2134 => Opcode::MOVN_I64_D64,
          2135 => Opcode::MOVN_I64_I,
          2136 => Opcode::MOVN_I64_I64,
          2137 => Opcode::MOVN_I64_S,
          2138 => Opcode::MOVN_I_D32,
          2139 => Opcode::MOVN_I_D32_MM,
          2140 => Opcode::MOVN_I_D64,
          2141 => Opcode::MOVN_I_I,
          2142 => Opcode::MOVN_I_I64,
          2143 => Opcode::MOVN_I_MM,
          2144 => Opcode::MOVN_I_S,
          2145 => Opcode::MOVN_I_S_MM,
          2146 => Opcode::MOVT_D32,
          2147 => Opcode::MOVT_D32_MM,
          2148 => Opcode::MOVT_D64,
          2149 => Opcode::MOVT_I,
          2150 => Opcode::MOVT_I64,
          2151 => Opcode::MOVT_I_MM,
          2152 => Opcode::MOVT_S,
          2153 => Opcode::MOVT_S_MM,
          2154 => Opcode::MOVZ_I64_D64,
          2155 => Opcode::MOVZ_I64_I,
          2156 => Opcode::MOVZ_I64_I64,
          2157 => Opcode::MOVZ_I64_S,
          2158 => Opcode::MOVZ_I_D32,
          2159 => Opcode::MOVZ_I_D32_MM,
          2160 => Opcode::MOVZ_I_D64,
          2161 => Opcode::MOVZ_I_I,
          2162 => Opcode::MOVZ_I_I64,
          2163 => Opcode::MOVZ_I_MM,
          2164 => Opcode::MOVZ_I_S,
          2165 => Opcode::MOVZ_I_S_MM,
          2166 => Opcode::MSUB,
          2167 => Opcode::MSUBF_D,
          2168 => Opcode::MSUBF_D_MMR6,
          2169 => Opcode::MSUBF_S,
          2170 => Opcode::MSUBF_S_MMR6,
          2171 => Opcode::MSUBR_Q_H,
          2172 => Opcode::MSUBR_Q_W,
          2173 => Opcode::MSUBU,
          2174 => Opcode::MSUBU_DSP,
          2175 => Opcode::MSUBU_DSP_MM,
          2176 => Opcode::MSUBU_MM,
          2177 => Opcode::MSUBV_B,
          2178 => Opcode::MSUBV_D,
          2179 => Opcode::MSUBV_H,
          2180 => Opcode::MSUBV_W,
          2181 => Opcode::MSUB_D32,
          2182 => Opcode::MSUB_D32_MM,
          2183 => Opcode::MSUB_D64,
          2184 => Opcode::MSUB_DSP,
          2185 => Opcode::MSUB_DSP_MM,
          2186 => Opcode::MSUB_MM,
          2187 => Opcode::MSUB_Q_H,
          2188 => Opcode::MSUB_Q_W,
          2189 => Opcode::MSUB_S,
          2190 => Opcode::MSUB_S_MM,
          2191 => Opcode::MTC0,
          2192 => Opcode::MTC0_MMR6,
          2193 => Opcode::MTC1,
          2194 => Opcode::MTC1_D64,
          2195 => Opcode::MTC1_D64_MM,
          2196 => Opcode::MTC1_MM,
          2197 => Opcode::MTC1_MMR6,
          2198 => Opcode::MTC2,
          2199 => Opcode::MTC2_MMR6,
          2200 => Opcode::MTGC0,
          2201 => Opcode::MTGC0_MM,
          2202 => Opcode::MTHC0_MMR6,
          2203 => Opcode::MTHC1_D32,
          2204 => Opcode::MTHC1_D32_MM,
          2205 => Opcode::MTHC1_D64,
          2206 => Opcode::MTHC1_D64_MM,
          2207 => Opcode::MTHC2_MMR6,
          2208 => Opcode::MTHGC0,
          2209 => Opcode::MTHGC0_MM,
          2210 => Opcode::MTHI,
          2211 => Opcode::MTHI64,
          2212 => Opcode::MTHI_DSP,
          2213 => Opcode::MTHI_DSP_MM,
          2214 => Opcode::MTHI_MM,
          2215 => Opcode::MTHLIP,
          2216 => Opcode::MTHLIP_MM,
          2217 => Opcode::MTLO,
          2218 => Opcode::MTLO64,
          2219 => Opcode::MTLO_DSP,
          2220 => Opcode::MTLO_DSP_MM,
          2221 => Opcode::MTLO_MM,
          2222 => Opcode::MTM0,
          2223 => Opcode::MTM1,
          2224 => Opcode::MTM2,
          2225 => Opcode::MTP0,
          2226 => Opcode::MTP1,
          2227 => Opcode::MTP2,
          2228 => Opcode::MTTR,
          2229 => Opcode::MUH,
          2230 => Opcode::MUHU,
          2231 => Opcode::MUHU_MMR6,
          2232 => Opcode::MUH_MMR6,
          2233 => Opcode::MUL,
          2234 => Opcode::MULEQ_S_W_PHL,
          2235 => Opcode::MULEQ_S_W_PHL_MM,
          2236 => Opcode::MULEQ_S_W_PHR,
          2237 => Opcode::MULEQ_S_W_PHR_MM,
          2238 => Opcode::MULEU_S_PH_QBL,
          2239 => Opcode::MULEU_S_PH_QBL_MM,
          2240 => Opcode::MULEU_S_PH_QBR,
          2241 => Opcode::MULEU_S_PH_QBR_MM,
          2242 => Opcode::MULQ_RS_PH,
          2243 => Opcode::MULQ_RS_PH_MM,
          2244 => Opcode::MULQ_RS_W,
          2245 => Opcode::MULQ_RS_W_MMR2,
          2246 => Opcode::MULQ_S_PH,
          2247 => Opcode::MULQ_S_PH_MMR2,
          2248 => Opcode::MULQ_S_W,
          2249 => Opcode::MULQ_S_W_MMR2,
          2250 => Opcode::MULR_PS64,
          2251 => Opcode::MULR_Q_H,
          2252 => Opcode::MULR_Q_W,
          2253 => Opcode::MULSAQ_S_W_PH,
          2254 => Opcode::MULSAQ_S_W_PH_MM,
          2255 => Opcode::MULSA_W_PH,
          2256 => Opcode::MULSA_W_PH_MMR2,
          2257 => Opcode::MULT,
          2258 => Opcode::MULTU_DSP,
          2259 => Opcode::MULTU_DSP_MM,
          2260 => Opcode::MULT_DSP,
          2261 => Opcode::MULT_DSP_MM,
          2262 => Opcode::MULT_MM,
          2263 => Opcode::MULTu,
          2264 => Opcode::MULTu_MM,
          2265 => Opcode::MULU,
          2266 => Opcode::MULU_MMR6,
          2267 => Opcode::MULV_B,
          2268 => Opcode::MULV_D,
          2269 => Opcode::MULV_H,
          2270 => Opcode::MULV_W,
          2271 => Opcode::MUL_MM,
          2272 => Opcode::MUL_MMR6,
          2273 => Opcode::MUL_PH,
          2274 => Opcode::MUL_PH_MMR2,
          2275 => Opcode::MUL_Q_H,
          2276 => Opcode::MUL_Q_W,
          2277 => Opcode::MUL_R6,
          2278 => Opcode::MUL_S_PH,
          2279 => Opcode::MUL_S_PH_MMR2,
          2280 => Opcode::Mfhi16,
          2281 => Opcode::Mflo16,
          2282 => Opcode::Move32R16,
          2283 => Opcode::MoveR3216,
          2284 => Opcode::NAL,
          2285 => Opcode::NLOC_B,
          2286 => Opcode::NLOC_D,
          2287 => Opcode::NLOC_H,
          2288 => Opcode::NLOC_W,
          2289 => Opcode::NLZC_B,
          2290 => Opcode::NLZC_D,
          2291 => Opcode::NLZC_H,
          2292 => Opcode::NLZC_W,
          2293 => Opcode::NMADD_D32,
          2294 => Opcode::NMADD_D32_MM,
          2295 => Opcode::NMADD_D64,
          2296 => Opcode::NMADD_S,
          2297 => Opcode::NMADD_S_MM,
          2298 => Opcode::NMSUB_D32,
          2299 => Opcode::NMSUB_D32_MM,
          2300 => Opcode::NMSUB_D64,
          2301 => Opcode::NMSUB_S,
          2302 => Opcode::NMSUB_S_MM,
          2303 => Opcode::NOR,
          2304 => Opcode::NOR64,
          2305 => Opcode::NORI_B,
          2306 => Opcode::NOR_MM,
          2307 => Opcode::NOR_MMR6,
          2308 => Opcode::NOR_V,
          2309 => Opcode::NOT16_MM,
          2310 => Opcode::NOT16_MMR6,
          2311 => Opcode::NegRxRy16,
          2312 => Opcode::NotRxRy16,
          2313 => Opcode::OR,
          2314 => Opcode::OR16_MM,
          2315 => Opcode::OR16_MMR6,
          2316 => Opcode::OR64,
          2317 => Opcode::ORI_B,
          2318 => Opcode::ORI_MMR6,
          2319 => Opcode::OR_MM,
          2320 => Opcode::OR_MMR6,
          2321 => Opcode::OR_V,
          2322 => Opcode::ORi,
          2323 => Opcode::ORi64,
          2324 => Opcode::ORi_MM,
          2325 => Opcode::OrRxRxRy16,
          2326 => Opcode::PACKRL_PH,
          2327 => Opcode::PACKRL_PH_MM,
          2328 => Opcode::PAUSE,
          2329 => Opcode::PAUSE_MM,
          2330 => Opcode::PAUSE_MMR6,
          2331 => Opcode::PCKEV_B,
          2332 => Opcode::PCKEV_D,
          2333 => Opcode::PCKEV_H,
          2334 => Opcode::PCKEV_W,
          2335 => Opcode::PCKOD_B,
          2336 => Opcode::PCKOD_D,
          2337 => Opcode::PCKOD_H,
          2338 => Opcode::PCKOD_W,
          2339 => Opcode::PCNT_B,
          2340 => Opcode::PCNT_D,
          2341 => Opcode::PCNT_H,
          2342 => Opcode::PCNT_W,
          2343 => Opcode::PICK_PH,
          2344 => Opcode::PICK_PH_MM,
          2345 => Opcode::PICK_QB,
          2346 => Opcode::PICK_QB_MM,
          2347 => Opcode::PLL_PS64,
          2348 => Opcode::PLU_PS64,
          2349 => Opcode::POP,
          2350 => Opcode::PRECEQU_PH_QBL,
          2351 => Opcode::PRECEQU_PH_QBLA,
          2352 => Opcode::PRECEQU_PH_QBLA_MM,
          2353 => Opcode::PRECEQU_PH_QBL_MM,
          2354 => Opcode::PRECEQU_PH_QBR,
          2355 => Opcode::PRECEQU_PH_QBRA,
          2356 => Opcode::PRECEQU_PH_QBRA_MM,
          2357 => Opcode::PRECEQU_PH_QBR_MM,
          2358 => Opcode::PRECEQ_W_PHL,
          2359 => Opcode::PRECEQ_W_PHL_MM,
          2360 => Opcode::PRECEQ_W_PHR,
          2361 => Opcode::PRECEQ_W_PHR_MM,
          2362 => Opcode::PRECEU_PH_QBL,
          2363 => Opcode::PRECEU_PH_QBLA,
          2364 => Opcode::PRECEU_PH_QBLA_MM,
          2365 => Opcode::PRECEU_PH_QBL_MM,
          2366 => Opcode::PRECEU_PH_QBR,
          2367 => Opcode::PRECEU_PH_QBRA,
          2368 => Opcode::PRECEU_PH_QBRA_MM,
          2369 => Opcode::PRECEU_PH_QBR_MM,
          2370 => Opcode::PRECRQU_S_QB_PH,
          2371 => Opcode::PRECRQU_S_QB_PH_MM,
          2372 => Opcode::PRECRQ_PH_W,
          2373 => Opcode::PRECRQ_PH_W_MM,
          2374 => Opcode::PRECRQ_QB_PH,
          2375 => Opcode::PRECRQ_QB_PH_MM,
          2376 => Opcode::PRECRQ_RS_PH_W,
          2377 => Opcode::PRECRQ_RS_PH_W_MM,
          2378 => Opcode::PRECR_QB_PH,
          2379 => Opcode::PRECR_QB_PH_MMR2,
          2380 => Opcode::PRECR_SRA_PH_W,
          2381 => Opcode::PRECR_SRA_PH_W_MMR2,
          2382 => Opcode::PRECR_SRA_R_PH_W,
          2383 => Opcode::PRECR_SRA_R_PH_W_MMR2,
          2384 => Opcode::PREF,
          2385 => Opcode::PREFE,
          2386 => Opcode::PREFE_MM,
          2387 => Opcode::PREFX_MM,
          2388 => Opcode::PREF_MM,
          2389 => Opcode::PREF_MMR6,
          2390 => Opcode::PREF_R6,
          2391 => Opcode::PREPEND,
          2392 => Opcode::PREPEND_MMR2,
          2393 => Opcode::PUL_PS64,
          2394 => Opcode::PUU_PS64,
          2395 => Opcode::RADDU_W_QB,
          2396 => Opcode::RADDU_W_QB_MM,
          2397 => Opcode::RDDSP,
          2398 => Opcode::RDDSP_MM,
          2399 => Opcode::RDHWR,
          2400 => Opcode::RDHWR64,
          2401 => Opcode::RDHWR_MM,
          2402 => Opcode::RDHWR_MMR6,
          2403 => Opcode::RDPGPR_MMR6,
          2404 => Opcode::RECIP_D32,
          2405 => Opcode::RECIP_D32_MM,
          2406 => Opcode::RECIP_D64,
          2407 => Opcode::RECIP_D64_MM,
          2408 => Opcode::RECIP_S,
          2409 => Opcode::RECIP_S_MM,
          2410 => Opcode::REPLV_PH,
          2411 => Opcode::REPLV_PH_MM,
          2412 => Opcode::REPLV_QB,
          2413 => Opcode::REPLV_QB_MM,
          2414 => Opcode::REPL_PH,
          2415 => Opcode::REPL_PH_MM,
          2416 => Opcode::REPL_QB,
          2417 => Opcode::REPL_QB_MM,
          2418 => Opcode::RINT_D,
          2419 => Opcode::RINT_D_MMR6,
          2420 => Opcode::RINT_S,
          2421 => Opcode::RINT_S_MMR6,
          2422 => Opcode::ROTR,
          2423 => Opcode::ROTRV,
          2424 => Opcode::ROTRV_MM,
          2425 => Opcode::ROTR_MM,
          2426 => Opcode::ROUND_L_D64,
          2427 => Opcode::ROUND_L_D_MMR6,
          2428 => Opcode::ROUND_L_S,
          2429 => Opcode::ROUND_L_S_MMR6,
          2430 => Opcode::ROUND_W_D32,
          2431 => Opcode::ROUND_W_D64,
          2432 => Opcode::ROUND_W_D_MMR6,
          2433 => Opcode::ROUND_W_MM,
          2434 => Opcode::ROUND_W_S,
          2435 => Opcode::ROUND_W_S_MM,
          2436 => Opcode::ROUND_W_S_MMR6,
          2437 => Opcode::RSQRT_D32,
          2438 => Opcode::RSQRT_D32_MM,
          2439 => Opcode::RSQRT_D64,
          2440 => Opcode::RSQRT_D64_MM,
          2441 => Opcode::RSQRT_S,
          2442 => Opcode::RSQRT_S_MM,
          2443 => Opcode::Restore16,
          2444 => Opcode::RestoreX16,
          2445 => Opcode::SAA,
          2446 => Opcode::SAAD,
          2447 => Opcode::SAT_S_B,
          2448 => Opcode::SAT_S_D,
          2449 => Opcode::SAT_S_H,
          2450 => Opcode::SAT_S_W,
          2451 => Opcode::SAT_U_B,
          2452 => Opcode::SAT_U_D,
          2453 => Opcode::SAT_U_H,
          2454 => Opcode::SAT_U_W,
          2455 => Opcode::SB,
          2456 => Opcode::SB16_MM,
          2457 => Opcode::SB16_MMR6,
          2458 => Opcode::SB64,
          2459 => Opcode::SBE,
          2460 => Opcode::SBE_MM,
          2461 => Opcode::SB_MM,
          2462 => Opcode::SB_MMR6,
          2463 => Opcode::SC,
          2464 => Opcode::SC64,
          2465 => Opcode::SC64_R6,
          2466 => Opcode::SCD,
          2467 => Opcode::SCD_R6,
          2468 => Opcode::SCE,
          2469 => Opcode::SCE_MM,
          2470 => Opcode::SC_MM,
          2471 => Opcode::SC_MMR6,
          2472 => Opcode::SC_R6,
          2473 => Opcode::SD,
          2474 => Opcode::SDBBP,
          2475 => Opcode::SDBBP16_MM,
          2476 => Opcode::SDBBP16_MMR6,
          2477 => Opcode::SDBBP_MM,
          2478 => Opcode::SDBBP_MMR6,
          2479 => Opcode::SDBBP_R6,
          2480 => Opcode::SDC1,
          2481 => Opcode::SDC164,
          2482 => Opcode::SDC1_D64_MMR6,
          2483 => Opcode::SDC1_MM_D32,
          2484 => Opcode::SDC1_MM_D64,
          2485 => Opcode::SDC2,
          2486 => Opcode::SDC2_MMR6,
          2487 => Opcode::SDC2_R6,
          2488 => Opcode::SDC3,
          2489 => Opcode::SDIV,
          2490 => Opcode::SDIV_MM,
          2491 => Opcode::SDL,
          2492 => Opcode::SDR,
          2493 => Opcode::SDXC1,
          2494 => Opcode::SDXC164,
          2495 => Opcode::SEB,
          2496 => Opcode::SEB64,
          2497 => Opcode::SEB_MM,
          2498 => Opcode::SEH,
          2499 => Opcode::SEH64,
          2500 => Opcode::SEH_MM,
          2501 => Opcode::SELEQZ,
          2502 => Opcode::SELEQZ64,
          2503 => Opcode::SELEQZ_D,
          2504 => Opcode::SELEQZ_D_MMR6,
          2505 => Opcode::SELEQZ_MMR6,
          2506 => Opcode::SELEQZ_S,
          2507 => Opcode::SELEQZ_S_MMR6,
          2508 => Opcode::SELNEZ,
          2509 => Opcode::SELNEZ64,
          2510 => Opcode::SELNEZ_D,
          2511 => Opcode::SELNEZ_D_MMR6,
          2512 => Opcode::SELNEZ_MMR6,
          2513 => Opcode::SELNEZ_S,
          2514 => Opcode::SELNEZ_S_MMR6,
          2515 => Opcode::SEL_D,
          2516 => Opcode::SEL_D_MMR6,
          2517 => Opcode::SEL_S,
          2518 => Opcode::SEL_S_MMR6,
          2519 => Opcode::SEQ,
          2520 => Opcode::SEQi,
          2521 => Opcode::SH,
          2522 => Opcode::SH16_MM,
          2523 => Opcode::SH16_MMR6,
          2524 => Opcode::SH64,
          2525 => Opcode::SHE,
          2526 => Opcode::SHE_MM,
          2527 => Opcode::SHF_B,
          2528 => Opcode::SHF_H,
          2529 => Opcode::SHF_W,
          2530 => Opcode::SHILO,
          2531 => Opcode::SHILOV,
          2532 => Opcode::SHILOV_MM,
          2533 => Opcode::SHILO_MM,
          2534 => Opcode::SHLLV_PH,
          2535 => Opcode::SHLLV_PH_MM,
          2536 => Opcode::SHLLV_QB,
          2537 => Opcode::SHLLV_QB_MM,
          2538 => Opcode::SHLLV_S_PH,
          2539 => Opcode::SHLLV_S_PH_MM,
          2540 => Opcode::SHLLV_S_W,
          2541 => Opcode::SHLLV_S_W_MM,
          2542 => Opcode::SHLL_PH,
          2543 => Opcode::SHLL_PH_MM,
          2544 => Opcode::SHLL_QB,
          2545 => Opcode::SHLL_QB_MM,
          2546 => Opcode::SHLL_S_PH,
          2547 => Opcode::SHLL_S_PH_MM,
          2548 => Opcode::SHLL_S_W,
          2549 => Opcode::SHLL_S_W_MM,
          2550 => Opcode::SHRAV_PH,
          2551 => Opcode::SHRAV_PH_MM,
          2552 => Opcode::SHRAV_QB,
          2553 => Opcode::SHRAV_QB_MMR2,
          2554 => Opcode::SHRAV_R_PH,
          2555 => Opcode::SHRAV_R_PH_MM,
          2556 => Opcode::SHRAV_R_QB,
          2557 => Opcode::SHRAV_R_QB_MMR2,
          2558 => Opcode::SHRAV_R_W,
          2559 => Opcode::SHRAV_R_W_MM,
          2560 => Opcode::SHRA_PH,
          2561 => Opcode::SHRA_PH_MM,
          2562 => Opcode::SHRA_QB,
          2563 => Opcode::SHRA_QB_MMR2,
          2564 => Opcode::SHRA_R_PH,
          2565 => Opcode::SHRA_R_PH_MM,
          2566 => Opcode::SHRA_R_QB,
          2567 => Opcode::SHRA_R_QB_MMR2,
          2568 => Opcode::SHRA_R_W,
          2569 => Opcode::SHRA_R_W_MM,
          2570 => Opcode::SHRLV_PH,
          2571 => Opcode::SHRLV_PH_MMR2,
          2572 => Opcode::SHRLV_QB,
          2573 => Opcode::SHRLV_QB_MM,
          2574 => Opcode::SHRL_PH,
          2575 => Opcode::SHRL_PH_MMR2,
          2576 => Opcode::SHRL_QB,
          2577 => Opcode::SHRL_QB_MM,
          2578 => Opcode::SH_MM,
          2579 => Opcode::SH_MMR6,
          2580 => Opcode::SIGRIE,
          2581 => Opcode::SIGRIE_MMR6,
          2582 => Opcode::SLDI_B,
          2583 => Opcode::SLDI_D,
          2584 => Opcode::SLDI_H,
          2585 => Opcode::SLDI_W,
          2586 => Opcode::SLD_B,
          2587 => Opcode::SLD_D,
          2588 => Opcode::SLD_H,
          2589 => Opcode::SLD_W,
          2590 => Opcode::SLL,
          2591 => Opcode::SLL16_MM,
          2592 => Opcode::SLL16_MMR6,
          2593 => Opcode::SLL64_32,
          2594 => Opcode::SLL64_64,
          2595 => Opcode::SLLI_B,
          2596 => Opcode::SLLI_D,
          2597 => Opcode::SLLI_H,
          2598 => Opcode::SLLI_W,
          2599 => Opcode::SLLV,
          2600 => Opcode::SLLV_MM,
          2601 => Opcode::SLL_B,
          2602 => Opcode::SLL_D,
          2603 => Opcode::SLL_H,
          2604 => Opcode::SLL_MM,
          2605 => Opcode::SLL_MMR6,
          2606 => Opcode::SLL_W,
          2607 => Opcode::SLT,
          2608 => Opcode::SLT64,
          2609 => Opcode::SLT_MM,
          2610 => Opcode::SLTi,
          2611 => Opcode::SLTi64,
          2612 => Opcode::SLTi_MM,
          2613 => Opcode::SLTiu,
          2614 => Opcode::SLTiu64,
          2615 => Opcode::SLTiu_MM,
          2616 => Opcode::SLTu,
          2617 => Opcode::SLTu64,
          2618 => Opcode::SLTu_MM,
          2619 => Opcode::SNE,
          2620 => Opcode::SNEi,
          2621 => Opcode::SPLATI_B,
          2622 => Opcode::SPLATI_D,
          2623 => Opcode::SPLATI_H,
          2624 => Opcode::SPLATI_W,
          2625 => Opcode::SPLAT_B,
          2626 => Opcode::SPLAT_D,
          2627 => Opcode::SPLAT_H,
          2628 => Opcode::SPLAT_W,
          2629 => Opcode::SRA,
          2630 => Opcode::SRAI_B,
          2631 => Opcode::SRAI_D,
          2632 => Opcode::SRAI_H,
          2633 => Opcode::SRAI_W,
          2634 => Opcode::SRARI_B,
          2635 => Opcode::SRARI_D,
          2636 => Opcode::SRARI_H,
          2637 => Opcode::SRARI_W,
          2638 => Opcode::SRAR_B,
          2639 => Opcode::SRAR_D,
          2640 => Opcode::SRAR_H,
          2641 => Opcode::SRAR_W,
          2642 => Opcode::SRAV,
          2643 => Opcode::SRAV_MM,
          2644 => Opcode::SRA_B,
          2645 => Opcode::SRA_D,
          2646 => Opcode::SRA_H,
          2647 => Opcode::SRA_MM,
          2648 => Opcode::SRA_W,
          2649 => Opcode::SRL,
          2650 => Opcode::SRL16_MM,
          2651 => Opcode::SRL16_MMR6,
          2652 => Opcode::SRLI_B,
          2653 => Opcode::SRLI_D,
          2654 => Opcode::SRLI_H,
          2655 => Opcode::SRLI_W,
          2656 => Opcode::SRLRI_B,
          2657 => Opcode::SRLRI_D,
          2658 => Opcode::SRLRI_H,
          2659 => Opcode::SRLRI_W,
          2660 => Opcode::SRLR_B,
          2661 => Opcode::SRLR_D,
          2662 => Opcode::SRLR_H,
          2663 => Opcode::SRLR_W,
          2664 => Opcode::SRLV,
          2665 => Opcode::SRLV_MM,
          2666 => Opcode::SRL_B,
          2667 => Opcode::SRL_D,
          2668 => Opcode::SRL_H,
          2669 => Opcode::SRL_MM,
          2670 => Opcode::SRL_W,
          2671 => Opcode::SSNOP,
          2672 => Opcode::SSNOP_MM,
          2673 => Opcode::SSNOP_MMR6,
          2674 => Opcode::ST_B,
          2675 => Opcode::ST_D,
          2676 => Opcode::ST_H,
          2677 => Opcode::ST_W,
          2678 => Opcode::SUB,
          2679 => Opcode::SUBQH_PH,
          2680 => Opcode::SUBQH_PH_MMR2,
          2681 => Opcode::SUBQH_R_PH,
          2682 => Opcode::SUBQH_R_PH_MMR2,
          2683 => Opcode::SUBQH_R_W,
          2684 => Opcode::SUBQH_R_W_MMR2,
          2685 => Opcode::SUBQH_W,
          2686 => Opcode::SUBQH_W_MMR2,
          2687 => Opcode::SUBQ_PH,
          2688 => Opcode::SUBQ_PH_MM,
          2689 => Opcode::SUBQ_S_PH,
          2690 => Opcode::SUBQ_S_PH_MM,
          2691 => Opcode::SUBQ_S_W,
          2692 => Opcode::SUBQ_S_W_MM,
          2693 => Opcode::SUBSUS_U_B,
          2694 => Opcode::SUBSUS_U_D,
          2695 => Opcode::SUBSUS_U_H,
          2696 => Opcode::SUBSUS_U_W,
          2697 => Opcode::SUBSUU_S_B,
          2698 => Opcode::SUBSUU_S_D,
          2699 => Opcode::SUBSUU_S_H,
          2700 => Opcode::SUBSUU_S_W,
          2701 => Opcode::SUBS_S_B,
          2702 => Opcode::SUBS_S_D,
          2703 => Opcode::SUBS_S_H,
          2704 => Opcode::SUBS_S_W,
          2705 => Opcode::SUBS_U_B,
          2706 => Opcode::SUBS_U_D,
          2707 => Opcode::SUBS_U_H,
          2708 => Opcode::SUBS_U_W,
          2709 => Opcode::SUBU16_MM,
          2710 => Opcode::SUBU16_MMR6,
          2711 => Opcode::SUBUH_QB,
          2712 => Opcode::SUBUH_QB_MMR2,
          2713 => Opcode::SUBUH_R_QB,
          2714 => Opcode::SUBUH_R_QB_MMR2,
          2715 => Opcode::SUBU_MMR6,
          2716 => Opcode::SUBU_PH,
          2717 => Opcode::SUBU_PH_MMR2,
          2718 => Opcode::SUBU_QB,
          2719 => Opcode::SUBU_QB_MM,
          2720 => Opcode::SUBU_S_PH,
          2721 => Opcode::SUBU_S_PH_MMR2,
          2722 => Opcode::SUBU_S_QB,
          2723 => Opcode::SUBU_S_QB_MM,
          2724 => Opcode::SUBVI_B,
          2725 => Opcode::SUBVI_D,
          2726 => Opcode::SUBVI_H,
          2727 => Opcode::SUBVI_W,
          2728 => Opcode::SUBV_B,
          2729 => Opcode::SUBV_D,
          2730 => Opcode::SUBV_H,
          2731 => Opcode::SUBV_W,
          2732 => Opcode::SUB_MM,
          2733 => Opcode::SUB_MMR6,
          2734 => Opcode::SUBu,
          2735 => Opcode::SUBu_MM,
          2736 => Opcode::SUXC1,
          2737 => Opcode::SUXC164,
          2738 => Opcode::SUXC1_MM,
          2739 => Opcode::SW,
          2740 => Opcode::SW16_MM,
          2741 => Opcode::SW16_MMR6,
          2742 => Opcode::SW64,
          2743 => Opcode::SWC1,
          2744 => Opcode::SWC1_MM,
          2745 => Opcode::SWC2,
          2746 => Opcode::SWC2_MMR6,
          2747 => Opcode::SWC2_R6,
          2748 => Opcode::SWC3,
          2749 => Opcode::SWDSP,
          2750 => Opcode::SWDSP_MM,
          2751 => Opcode::SWE,
          2752 => Opcode::SWE_MM,
          2753 => Opcode::SWL,
          2754 => Opcode::SWL64,
          2755 => Opcode::SWLE,
          2756 => Opcode::SWLE_MM,
          2757 => Opcode::SWL_MM,
          2758 => Opcode::SWM16_MM,
          2759 => Opcode::SWM16_MMR6,
          2760 => Opcode::SWM32_MM,
          2761 => Opcode::SWP_MM,
          2762 => Opcode::SWR,
          2763 => Opcode::SWR64,
          2764 => Opcode::SWRE,
          2765 => Opcode::SWRE_MM,
          2766 => Opcode::SWR_MM,
          2767 => Opcode::SWSP_MM,
          2768 => Opcode::SWSP_MMR6,
          2769 => Opcode::SWXC1,
          2770 => Opcode::SWXC1_MM,
          2771 => Opcode::SW_MM,
          2772 => Opcode::SW_MMR6,
          2773 => Opcode::SYNC,
          2774 => Opcode::SYNCI,
          2775 => Opcode::SYNCI_MM,
          2776 => Opcode::SYNCI_MMR6,
          2777 => Opcode::SYNC_MM,
          2778 => Opcode::SYNC_MMR6,
          2779 => Opcode::SYSCALL,
          2780 => Opcode::SYSCALL_MM,
          2781 => Opcode::Save16,
          2782 => Opcode::SaveX16,
          2783 => Opcode::SbRxRyOffMemX16,
          2784 => Opcode::SebRx16,
          2785 => Opcode::SehRx16,
          2786 => Opcode::ShRxRyOffMemX16,
          2787 => Opcode::SllX16,
          2788 => Opcode::SllvRxRy16,
          2789 => Opcode::SltRxRy16,
          2790 => Opcode::SltiRxImm16,
          2791 => Opcode::SltiRxImmX16,
          2792 => Opcode::SltiuRxImm16,
          2793 => Opcode::SltiuRxImmX16,
          2794 => Opcode::SltuRxRy16,
          2795 => Opcode::SraX16,
          2796 => Opcode::SravRxRy16,
          2797 => Opcode::SrlX16,
          2798 => Opcode::SrlvRxRy16,
          2799 => Opcode::SubuRxRyRz16,
          2800 => Opcode::SwRxRyOffMemX16,
          2801 => Opcode::SwRxSpImmX16,
          2802 => Opcode::TEQ,
          2803 => Opcode::TEQI,
          2804 => Opcode::TEQI_MM,
          2805 => Opcode::TEQ_MM,
          2806 => Opcode::TGE,
          2807 => Opcode::TGEI,
          2808 => Opcode::TGEIU,
          2809 => Opcode::TGEIU_MM,
          2810 => Opcode::TGEI_MM,
          2811 => Opcode::TGEU,
          2812 => Opcode::TGEU_MM,
          2813 => Opcode::TGE_MM,
          2814 => Opcode::TLBGINV,
          2815 => Opcode::TLBGINVF,
          2816 => Opcode::TLBGINVF_MM,
          2817 => Opcode::TLBGINV_MM,
          2818 => Opcode::TLBGP,
          2819 => Opcode::TLBGP_MM,
          2820 => Opcode::TLBGR,
          2821 => Opcode::TLBGR_MM,
          2822 => Opcode::TLBGWI,
          2823 => Opcode::TLBGWI_MM,
          2824 => Opcode::TLBGWR,
          2825 => Opcode::TLBGWR_MM,
          2826 => Opcode::TLBINV,
          2827 => Opcode::TLBINVF,
          2828 => Opcode::TLBINVF_MMR6,
          2829 => Opcode::TLBINV_MMR6,
          2830 => Opcode::TLBP,
          2831 => Opcode::TLBP_MM,
          2832 => Opcode::TLBR,
          2833 => Opcode::TLBR_MM,
          2834 => Opcode::TLBWI,
          2835 => Opcode::TLBWI_MM,
          2836 => Opcode::TLBWR,
          2837 => Opcode::TLBWR_MM,
          2838 => Opcode::TLT,
          2839 => Opcode::TLTI,
          2840 => Opcode::TLTIU_MM,
          2841 => Opcode::TLTI_MM,
          2842 => Opcode::TLTU,
          2843 => Opcode::TLTU_MM,
          2844 => Opcode::TLT_MM,
          2845 => Opcode::TNE,
          2846 => Opcode::TNEI,
          2847 => Opcode::TNEI_MM,
          2848 => Opcode::TNE_MM,
          2849 => Opcode::TRUNC_L_D64,
          2850 => Opcode::TRUNC_L_D_MMR6,
          2851 => Opcode::TRUNC_L_S,
          2852 => Opcode::TRUNC_L_S_MMR6,
          2853 => Opcode::TRUNC_W_D32,
          2854 => Opcode::TRUNC_W_D64,
          2855 => Opcode::TRUNC_W_D_MMR6,
          2856 => Opcode::TRUNC_W_MM,
          2857 => Opcode::TRUNC_W_S,
          2858 => Opcode::TRUNC_W_S_MM,
          2859 => Opcode::TRUNC_W_S_MMR6,
          2860 => Opcode::TTLTIU,
          2861 => Opcode::UDIV,
          2862 => Opcode::UDIV_MM,
          2863 => Opcode::V3MULU,
          2864 => Opcode::VMM0,
          2865 => Opcode::VMULU,
          2866 => Opcode::VSHF_B,
          2867 => Opcode::VSHF_D,
          2868 => Opcode::VSHF_H,
          2869 => Opcode::VSHF_W,
          2870 => Opcode::WAIT,
          2871 => Opcode::WAIT_MM,
          2872 => Opcode::WAIT_MMR6,
          2873 => Opcode::WRDSP,
          2874 => Opcode::WRDSP_MM,
          2875 => Opcode::WRPGPR_MMR6,
          2876 => Opcode::WSBH,
          2877 => Opcode::WSBH_MM,
          2878 => Opcode::WSBH_MMR6,
          2879 => Opcode::XOR,
          2880 => Opcode::XOR16_MM,
          2881 => Opcode::XOR16_MMR6,
          2882 => Opcode::XOR64,
          2883 => Opcode::XORI_B,
          2884 => Opcode::XORI_MMR6,
          2885 => Opcode::XOR_MM,
          2886 => Opcode::XOR_MMR6,
          2887 => Opcode::XOR_V,
          2888 => Opcode::XORi,
          2889 => Opcode::XORi64,
          2890 => Opcode::XORi_MM,
          2891 => Opcode::XorRxRxRy16,
          2892 => Opcode::YIELD,
          2893 => Opcode::INSTRUCTION_LIST_END,
          _ => Opcode::UNKNOWN(value),
        }
    }
}
