"""
This module benchmarks `PathSpec.match_file()` using ~15 patterns.
"""

import pytest
from pytest_benchmark.fixture import (
	BenchmarkFixture)

from pathspec import (
	PathSpec)

GROUP = "PathSpec.match_file(): 15 lines, one file"


# Hyperscan backend.

@pytest.mark.benchmark(group=GROUP)
def bench_hs_v1_end(
	benchmark: BenchmarkFixture,
	flit_file_match_end: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='hyperscan',
	)
	benchmark(run_match, spec, flit_file_match_end)


@pytest.mark.benchmark(group=GROUP)
def bench_hs_v1_middle(
	benchmark: BenchmarkFixture,
	flit_file_match_middle: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='hyperscan',
	)
	benchmark(run_match, spec, flit_file_match_middle)


@pytest.mark.benchmark(group=GROUP)
def bench_hs_v1_none(
	benchmark: BenchmarkFixture,
	flit_file_match_none: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='hyperscan',
	)
	benchmark(run_match, spec, flit_file_match_none)


@pytest.mark.benchmark(group=GROUP)
def bench_hs_v1_start(
	benchmark: BenchmarkFixture,
	flit_file_match_start: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='hyperscan',
	)
	benchmark(run_match, spec, flit_file_match_start)


# Re2 backend.

@pytest.mark.benchmark(group=GROUP)
def bench_re2_v1_end(
	benchmark: BenchmarkFixture,
	flit_file_match_end: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='re2',
	)
	benchmark(run_match, spec, flit_file_match_end)


@pytest.mark.benchmark(group=GROUP)
def bench_re2_v1_middle(
	benchmark: BenchmarkFixture,
	flit_file_match_middle: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='re2',
	)
	benchmark(run_match, spec, flit_file_match_middle)


@pytest.mark.benchmark(group=GROUP)
def bench_re2_v1_none(
	benchmark: BenchmarkFixture,
	flit_file_match_none: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='re2',
	)
	benchmark(run_match, spec, flit_file_match_none)


@pytest.mark.benchmark(group=GROUP)
def bench_re2_v1_start(
	benchmark: BenchmarkFixture,
	flit_file_match_start: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='re2',
	)
	benchmark(run_match, spec, flit_file_match_start)


# Simple backend.

@pytest.mark.benchmark(group=GROUP)
def bench_sm_v1_end(
	benchmark: BenchmarkFixture,
	flit_file_match_end: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='simple',
	)
	benchmark(run_match, spec, flit_file_match_end)


@pytest.mark.benchmark(group=GROUP)
def bench_sm_v1_middle(
	benchmark: BenchmarkFixture,
	flit_file_match_middle: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='simple',
	)
	benchmark(run_match, spec, flit_file_match_middle)


@pytest.mark.benchmark(group=GROUP)
def bench_sm_v1_none(
	benchmark: BenchmarkFixture,
	flit_file_match_none: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='simple',
	)
	benchmark(run_match, spec, flit_file_match_none)


@pytest.mark.benchmark(group=GROUP)
def bench_sm_v1_start(
	benchmark: BenchmarkFixture,
	flit_file_match_start: str,
	flit_gi_lines_all: list[str],
):
	spec = PathSpec.from_lines(
		'gitignore',
		flit_gi_lines_all,
		backend='simple',
	)
	benchmark(run_match, spec, flit_file_match_start)


def run_match(spec: PathSpec, file: str):
	_match = spec.match_file(file)
