DCAMERR = {
	-2147483391: ("DCAMERR_BUSY", "API cannot process in busy state."),
	-2147483389: ("DCAMERR_NOTREADY", "API requires ready state."),
	-2147483388: ("DCAMERR_NOTSTABLE", "API requires stable or unstable state."),
	-2147483387: ("DCAMERR_UNSTABLE", "API does not support in unstable state."),
	-2147483385: ("DCAMERR_NOTBUSY", "API requires busy state."),
	-2147483376: ("DCAMERR_EXCLUDED", "some resource is exclusive and already used"),
	-2147482878: ("DCAMERR_COOLINGTROUBLE", "something happens near cooler"),
	-2147482877: ("DCAMERR_NOTRIGGER", "no trigger when necessary. Some camera supports this error."),
	-2147482876: ("DCAMERR_TEMPERATURE_TROUBLE", "camera warns its temperature"),
	-2147482875: ("DCAMERR_TOOFREQUENTTRIGGER", "input too frequent trigger. Some camera supports this error."),
	-2147483390: ("DCAMERR_ABORT", "abort process"),
	-2147483386: ("DCAMERR_TIMEOUT", "timeout"),
	-2147482879: ("DCAMERR_LOSTFRAME", "frame data is lost"),
	-2147479802: ("DCAMERR_MISSINGFRAME_TROUBLE", "frame is lost but reason is low lever driver's bug"),
	-2147482847: ("DCAMERR_INVALIDIMAGE", "hpk format data is invalid data"),
	-2147483135: ("DCAMERR_NORESOURCE", "not enough resource except memory"),
	-2147483133: ("DCAMERR_NOMEMORY", "not enough memory"),
	-2147483132: ("DCAMERR_NOMODULE", "no sub module"),
	-2147483131: ("DCAMERR_NODRIVER", "no driver"),
	-2147483130: ("DCAMERR_NOCAMERA", "no camera"),
	-2147483129: ("DCAMERR_NOGRABBER", "no grabber"),
	-2147483128: ("DCAMERR_NOCOMBINATION", "no combination on registry"),
	-2147479551: ("DCAMERR_FAILOPEN", "DEPRECATED"),
	-2147483119: ("DCAMERR_INVALIDMODULE", "dcam_init() found invalid module"),
	-2147483118: ("DCAMERR_INVALIDCOMMPORT", "invalid serial port"),
	-2130702335: ("DCAMERR_FAILOPENBUS", "the bus or driver are not available"),
	-2113925119: ("DCAMERR_FAILOPENCAMERA", "camera report error during opening"),
	-2147481594: ("DCAMERR_INVALIDCAMERA", "invalid camera"),
	-2147481593: ("DCAMERR_INVALIDHANDLE", "invalid camera handle"),
	-2147481592: ("DCAMERR_INVALIDPARAM", "invalid parameter"),
	-2147481567: ("DCAMERR_INVALIDVALUE", "invalid property value"),
	-2147481566: ("DCAMERR_OUTOFRANGE", "value is out of range"),
	-2147481565: ("DCAMERR_NOTWRITABLE", "the property is not writable"),
	-2147481564: ("DCAMERR_NOTREADABLE", "the property is not readable"),
	-2147481563: ("DCAMERR_INVALIDPROPERTYID", "the property id is invalid"),
	-2147481562: ("DCAMERR_NEWAPIREQUIRED", "old API cannot present the value because only new API need to be used"),
	-2147481561: ("DCAMERR_WRONGHANDSHAKE", "this error happens DCAM get error code from camera unexpectedly"),
	-2147481560: ("DCAMERR_NOPROPERTY", "there is no altenative or influence id, or no more property id"),
	-2147481559: ("DCAMERR_INVALIDCHANNEL", "the property id specifies channel but channel is invalid"),
	-2147481558: ("DCAMERR_INVALIDVIEW", "the property id specifies channel but channel is invalid"),
	-2147481557: ("DCAMERR_INVALIDSUBARRAY", "the combination of subarray values are invalid. e.g. DCAM_IDPROP_SUBARRAYHPOS + DCAM_IDPROP_SUBARRAYHSIZE is greater than the number of horizontal pixel of sensor."),
	-2147481556: ("DCAMERR_ACCESSDENY", "the property cannot access during this DCAM STATUS"),
	-2147481555: ("DCAMERR_NOVALUETEXT", "the property does not have value text"),
	-2147481554: ("DCAMERR_WRONGPROPERTYVALUE", "at least one property value is wrong"),
	-2147481552: ("DCAMERR_DISHARMONY", "the paired camera does not have same parameter"),
	-2147481550: ("DCAMERR_FRAMEBUNDLESHOULDBEOFF", "framebundle mode should be OFF under current property settings"),
	-2147481549: ("DCAMERR_INVALIDFRAMEINDEX", "the frame index is invalid"),
	-2147481548: ("DCAMERR_INVALIDSESSIONINDEX", "the session index is invalid"),
	-2147481544: ("DCAMERR_NOCORRECTIONDATA", "not take the dark and shading correction data yet."),
	-2147481543: ("DCAMERR_CHANNELDEPENDENTVALUE", "each channel has own property value so can't return overall property value."),
	-2147481542: ("DCAMERR_VIEWDEPENDENTVALUE", "each view has own property value so can't return overall property value."),
	-2147479805: ("DCAMERR_NOTSUPPORT", "camera does not support the function or property with current settings"),
	-2097147902: ("DCAMERR_FAILREADCAMERA", "failed to read data from camera"),
	-2097147901: ("DCAMERR_FAILWRITECAMERA", "failed to write data to the camera"),
	-2097147900: ("DCAMERR_CONFLICTCOMMPORT", "conflict the com port name user set"),
	-2097147899: ("DCAMERR_OPTICS_UNPLUGGED", "Optics part is unplugged so please check it."),
	-2097147898: ("DCAMERR_FAILCALIBRATION", "fail calibration"),
	-2080374525: ("DCAMERR_INVALIDMEMBER_3", "3th member variable is invalid value"),
	-2080374523: ("DCAMERR_INVALIDMEMBER_5", "5th member variable is invalid value"),
	-2080374521: ("DCAMERR_INVALIDMEMBER_7", "7th member variable is invalid value"),
	-2080374520: ("DCAMERR_INVALIDMEMBER_8", "7th member variable is invalid value"),
	-2080374519: ("DCAMERR_INVALIDMEMBER_9", "9th member variable is invalid value"),
	-2080370687: ("DCAMERR_FAILEDOPENRECFILE", "DCAMREC failed to open the file"),
	-2080370686: ("DCAMERR_INVALIDRECHANDLE", "DCAMREC is invalid handle"),
	-2080370685: ("DCAMERR_FAILEDWRITEDATA", "DCAMREC failed to write the data"),
	-2080370684: ("DCAMERR_FAILEDREADDATA", "DCAMREC failed to read the data"),
	-2080370683: ("DCAMERR_NOWRECORDING", "DCAMREC is recording data now"),
	-2080370682: ("DCAMERR_WRITEFULL", "DCAMREC writes full frame of the session"),
	-2080370681: ("DCAMERR_ALREADYOCCUPIED", "DCAMREC handle is already occupied by other HDCAM"),
	-2080370680: ("DCAMERR_TOOLARGEUSERDATASIZE", "DCAMREC is set the large value to user data size"),
	-2080366591: ("DCAMERR_INVALIDWAITHANDLE", "DCAMWAIT is invalid handle"),
	-2080366590: ("DCAMERR_NEWRUNTIMEREQUIRED", "DCAM Module Version is older than the version that the camera requests"),
	-2080366589: ("DCAMERR_VERSIONMISMATCH", "Camre returns the error on setting parameter to limit version"),
	-2080366588: ("DCAMERR_RUNAS_FACTORYMODE", "Camera is running as a factory mode"),
	-2080362495: ("DCAMERR_IMAGE_UNKNOWNSIGNATURE", "sigunature of image header is unknown or corrupted"),
	-2080362494: ("DCAMERR_IMAGE_NEWRUNTIMEREQUIRED", "version of image header is newer than version that used DCAM supports"),
	-2080362493: ("DCAMERR_IMAGE_ERRORSTATUSEXIST", "image header stands error status"),
	-2080358396: ("DCAMERR_IMAGE_HEADERCORRUPTED", "image header value is strange"),
	-2080358395: ("DCAMERR_IMAGE_BROKENCONTENT", "image content is corrupted"),
	-2147481599: ("DCAMERR_UNKNOWNMSGID", "unknown message id"),
	-2147481598: ("DCAMERR_UNKNOWNSTRID", "unknown string id"),
	-2147481597: ("DCAMERR_UNKNOWNPARAMID", "unkown parameter id"),
	-2147481596: ("DCAMERR_UNKNOWNBITSTYPE", "unknown bitmap bits type"),
	-2147481595: ("DCAMERR_UNKNOWNDATATYPE", "unknown frame data type"),
	0: ("DCAMERR_NONE", "no error, nothing to have done"),
	-2147479808: ("DCAMERR_INSTALLATIONINPROGRESS", "installation progress"),
	-2147479807: ("DCAMERR_UNREACH", "internal error"),
	-2147479804: ("DCAMERR_UNLOADED", "calling after process terminated"),
	-2147479803: ("DCAMERR_THRUADAPTER", ""),
	-2147479801: ("DCAMERR_NOCONNECTION", "HDCAM lost connection to camera"),
	-2147479806: ("DCAMERR_NOTIMPLEMENT", "not yet implementation"),
	-1543438333: ("DCAMERR_APIINIT_INITOPTIONBYTES", "'API_INIT has a invalid parameter is initoptionbytes!'"),
	-1543438332: ("DCAMERR_APIINIT_INITOPTION", "'API_INIT has a invalid parameter is initoption!'"),
	-1543389184: ("DCAMERR_INITOPTION_COLLISION_BASE", ""),
	-1543372801: ("DCAMERR_INITOPTION_COLLISION_MAX", ""),
	1: ("DCAMERR_SUCCESS", "no error, general success code, app should check the value is positive"),
}

DCAMBUF_FRAME_OPTION = {
	0: ("DCAMBUF_FRAME_OPTION__VIEW_ALL", ""),
	1048576: ("DCAMBUF_FRAME_OPTION__VIEW_1", ""),
	2097152: ("DCAMBUF_FRAME_OPTION__VIEW_2", ""),
	3145728: ("DCAMBUF_FRAME_OPTION__VIEW_3", ""),
	4194304: ("DCAMBUF_FRAME_OPTION__VIEW_4", ""),
	16: ("DCAMBUF_FRAME_OPTION__PROC_HIGHCONTRAST", ""),
	1048576: ("DCAMBUF_FRAME_OPTION__VIEW__STEP", ""),
	15728640: ("DCAMBUF_FRAME_OPTION__VIEW__MASK", ""),
	4080: ("DCAMBUF_FRAME_OPTION__PROC__MASK", ""),
}

DCAMREC_FRAME_OPTION = {
	0: ("DCAMREC_FRAME_OPTION__VIEW_CURRENT", ""),
	1048576: ("DCAMREC_FRAME_OPTION__VIEW_1", ""),
	2097152: ("DCAMREC_FRAME_OPTION__VIEW_2", ""),
	3145728: ("DCAMREC_FRAME_OPTION__VIEW_3", ""),
	4194304: ("DCAMREC_FRAME_OPTION__VIEW_4", ""),
	16: ("DCAMREC_FRAME_OPTION__PROC_HIGHCONTRAST", ""),
	1048576: ("DCAMREC_FRAME_OPTION__VIEW__STEP", ""),
	15728640: ("DCAMREC_FRAME_OPTION__VIEW__MASK", ""),
	4080: ("DCAMREC_FRAME_OPTION__PROC__MASK", ""),
}

DCAMBUF_METADATAOPTION = {
	0: ("DCAMBUF_METADATAOPTION__VIEW_ALL", ""),
	1048576: ("DCAMBUF_METADATAOPTION__VIEW_1", ""),
	2097152: ("DCAMBUF_METADATAOPTION__VIEW_2", ""),
	3145728: ("DCAMBUF_METADATAOPTION__VIEW_3", ""),
	4194304: ("DCAMBUF_METADATAOPTION__VIEW_4", ""),
	1048576: ("DCAMBUF_METADATAOPTION__VIEW__STEP", ""),
	15728640: ("DCAMBUF_METADATAOPTION__VIEW__MASK", ""),
}

DCAMREC_METADATAOPTION = {
	0: ("DCAMREC_METADATAOPTION__LOCATION_FRAME", ""),
	16777216: ("DCAMREC_METADATAOPTION__LOCATION_FILE", ""),
	33554432: ("DCAMREC_METADATAOPTION__LOCATION_SESSION", ""),
	-16777216: ("DCAMREC_METADATAOPTION__LOCATION__MASK", ""),
}

DCAM_PIXELTYPE = {
	1: ("DCAM_PIXELTYPE_MONO8", ""),
	2: ("DCAM_PIXELTYPE_MONO16", ""),
	3: ("DCAM_PIXELTYPE_MONO12", ""),
	33: ("DCAM_PIXELTYPE_RGB24", ""),
	34: ("DCAM_PIXELTYPE_RGB48", ""),
	41: ("DCAM_PIXELTYPE_BGR24", ""),
	42: ("DCAM_PIXELTYPE_BGR48", ""),
	0: ("DCAM_PIXELTYPE_NONE", ""),
}

DCAMBUF_ATTACHKIND = {
	1: ("DCAMBUF_ATTACHKIND_TIMESTAMP", ""),
	2: ("DCAMBUF_ATTACHKIND_FRAMESTAMP", ""),
	3: ("DCAMBUF_ATTACHKIND_PRIMARY_TIMESTAMP", ""),
	4: ("DCAMBUF_ATTACHKIND_PRIMARY_FRAMESTAMP", ""),
	0: ("DCAMBUF_ATTACHKIND_FRAME", ""),
}

DCAMCAP_TRANSFERKIND = {
	0: ("DCAMCAP_TRANSFERKIND_FRAME", ""),
}

DCAMCAP_STATUS = {
	0: ("DCAMCAP_STATUS_ERROR", ""),
	1: ("DCAMCAP_STATUS_BUSY", ""),
	2: ("DCAMCAP_STATUS_READY", ""),
	3: ("DCAMCAP_STATUS_STABLE", ""),
	4: ("DCAMCAP_STATUS_UNSTABLE", ""),
}

DCAMWAIT_EVENT = {
	1: ("DCAMWAIT_CAPEVENT_TRANSFERRED", ""),
	2: ("DCAMWAIT_CAPEVENT_FRAMEREADY", "all modules support"),
	4: ("DCAMWAIT_CAPEVENT_CYCLEEND", "all modules support"),
	8: ("DCAMWAIT_CAPEVENT_EXPOSUREEND", ""),
	16: ("DCAMWAIT_CAPEVENT_STOPPED", ""),
	256: ("DCAMWAIT_RECEVENT_STOPPED", ""),
	512: ("DCAMWAIT_RECEVENT_WARNING", ""),
	1024: ("DCAMWAIT_RECEVENT_MISSED", ""),
	4096: ("DCAMWAIT_RECEVENT_DISKFULL", ""),
	8192: ("DCAMWAIT_RECEVENT_WRITEFAULT", ""),
	16384: ("DCAMWAIT_RECEVENT_SKIPPED", ""),
}

DCAMCAP_START = {
	-1: ("DCAMCAP_START_SEQUENCE", ""),
	0: ("DCAMCAP_START_SNAP", ""),
}

DCAM_IDSTR = {
	67109121: ("DCAM_IDSTR_BUS", ""),
	67109122: ("DCAM_IDSTR_CAMERAID", ""),
	67109123: ("DCAM_IDSTR_VENDOR", ""),
	67109124: ("DCAM_IDSTR_MODEL", ""),
	67109125: ("DCAM_IDSTR_CAMERAVERSION", ""),
	67109126: ("DCAM_IDSTR_DRIVERVERSION", ""),
	67109127: ("DCAM_IDSTR_MODULEVERSION", ""),
	67109128: ("DCAM_IDSTR_DCAMAPIVERSION", ""),
	67109164: ("DCAM_IDSTR_CAMERA_SERIESNAME", ""),
	67113217: ("DCAM_IDSTR_OPTICALBLOCK_MODEL", ""),
	67113218: ("DCAM_IDSTR_OPTICALBLOCK_ID", ""),
	67113219: ("DCAM_IDSTR_OPTICALBLOCK_DESCRIPTION", ""),
	67113220: ("DCAM_IDSTR_OPTICALBLOCK_CHANNEL_1", ""),
	67113221: ("DCAM_IDSTR_OPTICALBLOCK_CHANNEL_2", ""),
}

DCAMWAIT_TIMEOUT = {
	-2147483648: ("DCAMWAIT_TIMEOUT_INFINITE", ""),
}

DCAMAPI_INITOPTION = {
	1: ("DCAMAPI_INITOPTION_APIVER__LATEST", ""),
	1024: ("DCAMAPI_INITOPTION_APIVER__4_0", ""),
	65538: ("DCAMAPI_INITOPTION_MULTIVIEW__DISABLE", ""),
	0: ("DCAMAPI_INITOPTION_ENDMARK", ""),
}

DCAMBUF_METADATAKIND = {
	65536: ("DCAMBUF_METADATAKIND_TIMESTAMPS", ""),
	131072: ("DCAMBUF_METADATAKIND_FRAMESTAMPS", ""),
}

DCAMREC_METADATAKIND = {
	1: ("DCAMREC_METADATAKIND_USERDATATEXT", ""),
	2: ("DCAMREC_METADATAKIND_USERDATABIN", ""),
	65536: ("DCAMREC_METADATAKIND_TIMESTAMPS", ""),
	131072: ("DCAMREC_METADATAKIND_FRAMESTAMPS", ""),
}

DCAMDATA_OPTION = {
	0: ("DCAMDATA_OPTION__VIEW_ALL", ""),
	1048576: ("DCAMDATA_OPTION__VIEW_1", ""),
	2097152: ("DCAMDATA_OPTION__VIEW_2", ""),
	3145728: ("DCAMDATA_OPTION__VIEW_3", ""),
	4194304: ("DCAMDATA_OPTION__VIEW_4", ""),
	1048576: ("DCAMDATA_OPTION__VIEW__STEP", ""),
	15728640: ("DCAMDATA_OPTION__VIEW__MASK", ""),
}

DCAMDATA_KIND = {
	1: ("DCAMDATA_KIND__REGION", ""),
	2: ("DCAMDATA_KIND__LUT", ""),
	0: ("DCAMDATA_KIND__NONE", ""),
}

DCAMDATA_ATTRIBUTE = {
	16777216: ("DCAMDATA_ATTRIBUTE__ACCESSREADY", "This value can get or set at READY status"),
	33554432: ("DCAMDATA_ATTRIBUTE__ACCESSBUSY", "This value can get or set at BUSY status"),
	268435456: ("DCAMDATA_ATTRIBUTE__HASVIEW", "value can set the value for each views"),
	-16777216: ("DCAMDATA_ATTRIBUTE__MASK", ""),
}

DCAMDATA_REGIONTYPE = {
	1: ("DCAMDATA_REGIONTYPE__BYTEMASK", ""),
	2: ("DCAMDATA_REGIONTYPE__RECT16ARRAY", ""),
	16777216: ("DCAMDATA_REGIONTYPE__ACCESSREADY", "This value can get or set at READY status"),
	33554432: ("DCAMDATA_REGIONTYPE__ACCESSBUSY", "This value can get or set at BUSY status"),
	268435456: ("DCAMDATA_REGIONTYPE__HASVIEW", "value can set the value for each views"),
	16777215: ("DCAMDATA_REGIONTYPE__BODYMASK", ""),
	-16777216: ("DCAMDATA_REGIONTYPE__ATTRIBUTEMASK", ""),
	0: ("DCAMDATA_REGIONTYPE__NONE", ""),
}

DCAMDATA_LUTTYPE = {
	1: ("DCAMDATA_LUTTYPE__SEGMENTED_LINEAR", ""),
	2: ("DCAMDATA_LUTTYPE__MONO16", "reserved"),
	16777216: ("DCAMDATA_LUTTYPE__ACCESSREADY", "This value can get or set at READY status"),
	33554432: ("DCAMDATA_LUTTYPE__ACCESSBUSY", "This value can get or set at BUSY status"),
	16777215: ("DCAMDATA_LUTTYPE__BODYMASK", ""),
	-16777216: ("DCAMDATA_LUTTYPE__ATTRIBUTEMASK", ""),
	0: ("DCAMDATA_LUTTYPE__NONE", ""),
}

DCAMBUF_PROCTYPE = {
	16: ("DCAMBUF_PROCTYPE__HIGHCONTRASTMODE", ""),
	0: ("DCAMBUF_PROCTYPE__NONE", ""),
}

DCAM_CODEPAGE = {
	932: ("DCAM_CODEPAGE__SHIFT_JIS", "Shift JIS"),
	1200: ("DCAM_CODEPAGE__UTF16_LE", "UTF-16 (Little Endian)"),
	1201: ("DCAM_CODEPAGE__UTF16_BE", "UTF-16 (Big Endian)"),
	65000: ("DCAM_CODEPAGE__UTF7", "UTF-7 translation"),
	65001: ("DCAM_CODEPAGE__UTF8", "UTF-8 translation"),
	0: ("DCAM_CODEPAGE__NONE", ""),
}

DCAMDEV_CAPDOMAIN = {
	1: ("DCAMDEV_CAPDOMAIN__DCAMDATA", ""),
	2: ("DCAMDEV_CAPDOMAIN__FRAMEOPTION", ""),
	0: ("DCAMDEV_CAPDOMAIN__FUNCTION", ""),
}

DCAMDEV_CAPFLAG = {
	1: ("DCAMDEV_CAPFLAG_FRAMESTAMP", ""),
	2: ("DCAMDEV_CAPFLAG_TIMESTAMP", ""),
	4: ("DCAMDEV_CAPFLAG_CAMERASTAMP", ""),
	0: ("DCAMDEV_CAPFLAG_NONE", ""),
}

DCAMREC_STATUSFLAG = {
	0: ("DCAMREC_STATUSFLAG_NONE", ""),
	1: ("DCAMREC_STATUSFLAG_RECORDING", ""),
}

DCAMPROPOPTION = {
	-16777216: ("DCAMPROP_OPTION_PRIOR", "prior value"),
	16777216: ("DCAMPROP_OPTION_NEXT", "next value or id"),
	-2147483648: ("DCAMPROP_OPTION_NEAREST", "*/	/* reserved"),
	0: ("DCAMPROP_OPTION_SUPPORT", "default option"),
	1: ("DCAMPROP_OPTION_UPDATED", "UPDATED and VOLATILE can be used at same time"),
	2: ("DCAMPROP_OPTION_VOLATILE", "UPDATED and VOLATILE can be used at same time"),
	4: ("DCAMPROP_OPTION_ARRAYELEMENT", "ARRAYELEMENT"),
	0: ("DCAMPROP_OPTION_NONE", "** no option **"),
}

DCAMPROPATTRIBUTE = {
	-2147483648: ("DCAMPROP_ATTR_HASRANGE", ""),
	1073741824: ("DCAMPROP_ATTR_HASSTEP", ""),
	536870912: ("DCAMPROP_ATTR_HASDEFAULT", ""),
	268435456: ("DCAMPROP_ATTR_HASVALUETEXT", ""),
	134217728: ("DCAMPROP_ATTR_HASCHANNEL", "value can set the value for each channels"),
	8388608: ("DCAMPROP_ATTR_AUTOROUNDING", "The dcam_setproperty() or dcam_setgetproperty() will failure if this bit exists. If this flag does not exist, the value will be round up when it is not supported."),
	4194304: ("DCAMPROP_ATTR_STEPPING_INCONSISTENT", "The valuestep of DCAM_PROPERTYATTR is not consistent across the entire range of values."),
	2097152: ("DCAMPROP_ATTR_DATASTREAM", "value is releated to image attribute"),
	1048576: ("DCAMPROP_ATTR_HASRATIO", "value has ratio control capability"),
	524288: ("DCAMPROP_ATTR_VOLATILE", "value may be changed by user or automatically"),
	131072: ("DCAMPROP_ATTR_WRITABLE", "value can be set when state is manual"),
	65536: ("DCAMPROP_ATTR_READABLE", "value is readable when state is manual"),
	32768: ("DCAMPROP_ATTR_HASVIEW", "value can set the value for each views"),
	16384: ("DCAMPROP_ATTR__SYSTEM", "*/	/* reserved"),
	8192: ("DCAMPROP_ATTR_ACCESSREADY", "This value can get or set at READY status"),
	4096: ("DCAMPROP_ATTR_ACCESSBUSY", "This value can get or set at BUSY status"),
	2048: ("DCAMPROP_ATTR_ADVANCED", "User has to take care to change this value *//* reserved"),
	1024: ("DCAMPROP_ATTR_ACTION", "*/	/* reserved"),
	512: ("DCAMPROP_ATTR_EFFECTIVE", "*/	/* reserved"),
	0: ("DCAMPROP_TYPE_NONE", "undefined"),
	1: ("DCAMPROP_TYPE_MODE", "01:	mode, 32bit integer in case of 32bit OS"),
	2: ("DCAMPROP_TYPE_LONG", "02:	32bit integer in case of 32bit OS"),
	3: ("DCAMPROP_TYPE_REAL", "03:	64bit float"),
	15: ("DCAMPROP_TYPE_MASK", "mask for property value type"),
}

DCAMPROPATTRIBUTE2 = {
	134217728: ("DCAMPROP_ATTR2_ARRAYBASE", ""),
	67108864: ("DCAMPROP_ATTR2_ARRAYELEMENT", ""),
	33554432: ("DCAMPROP_ATTR2_REAL32", ""),
	1: ("DCAMPROP_ATTR2_INITIALIZEIMPROPER", ""),
	1048572: ("DCAMPROP_ATTR2__FUTUREUSE", ""),
}

DCAMPROPUNIT = {
	1: ("DCAMPROP_UNIT_SECOND", "sec"),
	2: ("DCAMPROP_UNIT_CELSIUS", "for sensor temperature"),
	3: ("DCAMPROP_UNIT_KELVIN", "for color temperature"),
	4: ("DCAMPROP_UNIT_METERPERSECOND", "for LINESPEED"),
	5: ("DCAMPROP_UNIT_PERSECOND", "for FRAMERATE and LINERATE"),
	6: ("DCAMPROP_UNIT_DEGREE", "*/	/* reserved"),
	7: ("DCAMPROP_UNIT_MICROMETER", "*/	/* reserved"),
	0: ("DCAMPROP_UNIT_NONE", ""),
}

DCAMPROPMODEVALUE = {
	1: ("DCAMPROP_SENSORMODE__AREA", "'AREA'"),
	2: ("DCAMPROP_SENSORMODE__SLIT", "*/	/* reserved"),
	3: ("DCAMPROP_SENSORMODE__LINE", "'LINE'"),
	4: ("DCAMPROP_SENSORMODE__TDI", "'TDI'"),
	5: ("DCAMPROP_SENSORMODE__FRAMING", "*/	/* reserved"),
	6: ("DCAMPROP_SENSORMODE__PARTIALAREA", "*/	/* reserved"),
	9: ("DCAMPROP_SENSORMODE__SLITLINE", "*/	/* reserved"),
	10: ("DCAMPROP_SENSORMODE__TDI_EXTENDED", "'TDI EXTENDED'"),
	11: ("DCAMPROP_SENSORMODE__PANORAMIC", "*/	/* reserved"),
	12: ("DCAMPROP_SENSORMODE__PROGRESSIVE", "*/	/* reserved"),
	14: ("DCAMPROP_SENSORMODE__SPLITVIEW", "*/	/* reserved"),
	16: ("DCAMPROP_SENSORMODE__DUALLIGHTSHEET", "'DUAL LIGHTSHEET'"),
	1: ("DCAMPROP_READOUTSPEED__SLOWEST", "no text"),
	2147483647: ("DCAMPROP_READOUTSPEED__FASTEST", "no text,w/o"),
	1: ("DCAMPROP_READOUT_DIRECTION__FORWARD", "'FORWARD'"),
	2: ("DCAMPROP_READOUT_DIRECTION__BACKWARD", "'BACKWARD'"),
	3: ("DCAMPROP_READOUT_DIRECTION__BYTRIGGER", "'BY TRIGGER'"),
	5: ("DCAMPROP_READOUT_DIRECTION__DIVERGE", "'DIVERGE'"),
	2: ("DCAMPROP_READOUT_UNIT__FRAME", "'FRAME'"),
	3: ("DCAMPROP_READOUT_UNIT__BUNDLEDLINE", "'BUNDLED LINE'"),
	4: ("DCAMPROP_READOUT_UNIT__BUNDLEDFRAME", "'BUNDLED FRAME'"),
	1: ("DCAMPROP_CCDMODE__NORMALCCD", "'NORMAL CCD'"),
	2: ("DCAMPROP_CCDMODE__EMCCD", "'EM CCD'"),
	1: ("DCAMPROP_CMOSMODE__NORMAL", "'NORMAL'"),
	2: ("DCAMPROP_CMOSMODE__NONDESTRUCTIVE", "'NON DESTRUCTIVE'"),
	1: ("DCAMPROP_OUTPUT_INTENSITY__NORMAL", "'NORMAL'"),
	2: ("DCAMPROP_OUTPUT_INTENSITY__TESTPATTERN", "'TEST PATTERN'"),
	1: ("DCAMPROP_OUTPUTDATA_ORIENTATION__NORMAL", "reserved"),
	2: ("DCAMPROP_OUTPUTDATA_ORIENTATION__MIRROR", "reserved"),
	3: ("DCAMPROP_OUTPUTDATA_ORIENTATION__FLIP", "reserved"),
	1: ("DCAMPROP_OUTPUTDATA_OPERATION__RAW", ""),
	2: ("DCAMPROP_OUTPUTDATA_OPERATION__ALIGNED", ""),
	2: ("DCAMPROP_TESTPATTERN_KIND__FLAT", "'FLAT'"),
	4: ("DCAMPROP_TESTPATTERN_KIND__HORZGRADATION", "'HORZGRADATION'"),
	5: ("DCAMPROP_TESTPATTERN_KIND__IHORZGRADATION", "'INVERT HORZGRADATION'"),
	6: ("DCAMPROP_TESTPATTERN_KIND__VERTGRADATION", "'VERTGRADATION'"),
	7: ("DCAMPROP_TESTPATTERN_KIND__IVERTGRADATION", "'INVERT VERTGRADATION'"),
	8: ("DCAMPROP_TESTPATTERN_KIND__LINE", "'LINE'"),
	10: ("DCAMPROP_TESTPATTERN_KIND__DIAGONAL", "'DIAGONAL'"),
	12: ("DCAMPROP_TESTPATTERN_KIND__FRAMECOUNT", "'FRAMECOUNT'"),
	1: ("DCAMPROP_DIGITALBINNING_METHOD__MINIMUM", "'MINIMUM'"),
	2: ("DCAMPROP_DIGITALBINNING_METHOD__MAXIMUM", "'MAXIMUM'"),
	3: ("DCAMPROP_DIGITALBINNING_METHOD__ODD", "'ODD'"),
	4: ("DCAMPROP_DIGITALBINNING_METHOD__EVEN", "'EVEN'"),
	5: ("DCAMPROP_DIGITALBINNING_METHOD__SUM", "'SUM'"),
	6: ("DCAMPROP_DIGITALBINNING_METHOD__AVERAGE", "'AVERAGE'"),
	1: ("DCAMPROP_TRIGGERSOURCE__INTERNAL", "'INTERNAL'"),
	2: ("DCAMPROP_TRIGGERSOURCE__EXTERNAL", "'EXTERNAL'"),
	3: ("DCAMPROP_TRIGGERSOURCE__SOFTWARE", "'SOFTWARE'"),
	4: ("DCAMPROP_TRIGGERSOURCE__MASTERPULSE", "'MASTER PULSE'"),
	1: ("DCAMPROP_TRIGGERACTIVE__EDGE", "'EDGE'"),
	2: ("DCAMPROP_TRIGGERACTIVE__LEVEL", "'LEVEL'"),
	3: ("DCAMPROP_TRIGGERACTIVE__SYNCREADOUT", "'SYNCREADOUT'"),
	4: ("DCAMPROP_TRIGGERACTIVE__POINT", "'POINT'"),
	1: ("DCAMPROP_BUS_SPEED__SLOWEST", "no text"),
	2147483647: ("DCAMPROP_BUS_SPEED__FASTEST", "no text,w/o"),
	1: ("DCAMPROP_TRIGGER_MODE__NORMAL", "'NORMAL'"),
	3: ("DCAMPROP_TRIGGER_MODE__PIV", "'PIV'"),
	6: ("DCAMPROP_TRIGGER_MODE__START", "'START'"),
	7: ("DCAMPROP_TRIGGER_MODE__MULTIGATE", "*/	/* reserved"),
	8: ("DCAMPROP_TRIGGER_MODE__MULTIFRAME", "*/	/* reserved"),
	1: ("DCAMPROP_TRIGGERPOLARITY__NEGATIVE", "'NEGATIVE'"),
	2: ("DCAMPROP_TRIGGERPOLARITY__POSITIVE", "'POSITIVE'"),
	1: ("DCAMPROP_TRIGGER_CONNECTOR__INTERFACE", "'INTERFACE'"),
	2: ("DCAMPROP_TRIGGER_CONNECTOR__BNC", "'BNC'"),
	3: ("DCAMPROP_TRIGGER_CONNECTOR__MULTI", "'MULTI'"),
	1: ("DCAMPROP_INTERNALTRIGGER_HANDLING__SHORTEREXPOSURETIME", "'SHORTER EXPOSURE TIME'"),
	2: ("DCAMPROP_INTERNALTRIGGER_HANDLING__FASTERFRAMERATE", "'FASTER FRAME RATE'"),
	3: ("DCAMPROP_INTERNALTRIGGER_HANDLING__ABANDONWRONGFRAME", "'ABANDON WRONG FRAME'"),
	4: ("DCAMPROP_INTERNALTRIGGER_HANDLING__BURSTMODE", "'BURST MODE'"),
	7: ("DCAMPROP_INTERNALTRIGGER_HANDLING__INDIVIDUALEXPOSURE", "'INDIVIDUAL EXPOSURE TIME'"),
	1: ("DCAMPROP_SYNCREADOUT_SYSTEMBLANK__STANDARD", "'STANDARD'"),
	2: ("DCAMPROP_SYNCREADOUT_SYSTEMBLANK__MINIMUM", "'MINIMUM'"),
	1: ("DCAMPROP_TRIGGERENABLE_ACTIVE__DENY", "'DENY'"),
	2: ("DCAMPROP_TRIGGERENABLE_ACTIVE__ALWAYS", "'ALWAYS'"),
	3: ("DCAMPROP_TRIGGERENABLE_ACTIVE__LEVEL", "'LEVEL'"),
	4: ("DCAMPROP_TRIGGERENABLE_ACTIVE__START", "'START'"),
	1: ("DCAMPROP_TRIGGERENABLE_POLARITY__NEGATIVE", "'NEGATIVE'"),
	2: ("DCAMPROP_TRIGGERENABLE_POLARITY__POSITIVE", "'POSITIVE'"),
	3: ("DCAMPROP_TRIGGERENABLE_POLARITY__INTERLOCK", "'INTERLOCK'"),
	1: ("DCAMPROP_OUTPUTTRIGGER_CHANNELSYNC__1CHANNEL", "'1 Channel'"),
	2: ("DCAMPROP_OUTPUTTRIGGER_CHANNELSYNC__2CHANNELS", "'2 Channels'"),
	3: ("DCAMPROP_OUTPUTTRIGGER_CHANNELSYNC__3CHANNELS", "'3 Channels'"),
	1: ("DCAMPROP_OUTPUTTRIGGER_PROGRAMABLESTART__FIRSTEXPOSURE", "'FIRST EXPOSURE'"),
	2: ("DCAMPROP_OUTPUTTRIGGER_PROGRAMABLESTART__FIRSTREADOUT", "'FIRST READOUT'"),
	1: ("DCAMPROP_OUTPUTTRIGGER_SOURCE__EXPOSURE", "'EXPOSURE'"),
	2: ("DCAMPROP_OUTPUTTRIGGER_SOURCE__READOUTEND", "'READOUT END'"),
	3: ("DCAMPROP_OUTPUTTRIGGER_SOURCE__VSYNC", "'VSYNC'"),
	4: ("DCAMPROP_OUTPUTTRIGGER_SOURCE__HSYNC", "'HSYNC'"),
	6: ("DCAMPROP_OUTPUTTRIGGER_SOURCE__TRIGGER", "'TRIGGER'"),
	1: ("DCAMPROP_OUTPUTTRIGGER_POLARITY__NEGATIVE", "'NEGATIVE'"),
	2: ("DCAMPROP_OUTPUTTRIGGER_POLARITY__POSITIVE", "'POSITIVE'"),
	1: ("DCAMPROP_OUTPUTTRIGGER_ACTIVE__EDGE", "'EDGE'"),
	2: ("DCAMPROP_OUTPUTTRIGGER_ACTIVE__LEVEL", "'LEVEL'"),
	1: ("DCAMPROP_OUTPUTTRIGGER_KIND__LOW", "'LOW'"),
	2: ("DCAMPROP_OUTPUTTRIGGER_KIND__EXPOSURE", "'EXPOSURE'"),
	3: ("DCAMPROP_OUTPUTTRIGGER_KIND__PROGRAMABLE", "'PROGRAMABLE'"),
	4: ("DCAMPROP_OUTPUTTRIGGER_KIND__TRIGGERREADY", "'TRIGGER READY'"),
	5: ("DCAMPROP_OUTPUTTRIGGER_KIND__HIGH", "'HIGH'"),
	1: ("DCAMPROP_OUTPUTTRIGGER_BASESENSOR__VIEW1", "'VIEW 1'"),
	2: ("DCAMPROP_OUTPUTTRIGGER_BASESENSOR__VIEW2", "'VIEW 2'"),
	15: ("DCAMPROP_OUTPUTTRIGGER_BASESENSOR__ANYVIEW", "'ANY VIEW'"),
	16: ("DCAMPROP_OUTPUTTRIGGER_BASESENSOR__ALLVIEWS", "'ALL VIEWS'"),
	1: ("DCAMPROP_EXPOSURETIME_CONTROL__OFF", "'OFF'"),
	2: ("DCAMPROP_EXPOSURETIME_CONTROL__NORMAL", "'NORMAL'"),
	1: ("DCAMPROP_TRIGGER_FIRSTEXPOSURE__NEW", "'NEW'"),
	2: ("DCAMPROP_TRIGGER_FIRSTEXPOSURE__CURRENT", "'CURRENT'"),
	1: ("DCAMPROP_TRIGGER_GLOBALEXPOSURE__NONE", "'NONE'"),
	2: ("DCAMPROP_TRIGGER_GLOBALEXPOSURE__ALWAYS", "'ALWAYS'"),
	3: ("DCAMPROP_TRIGGER_GLOBALEXPOSURE__DELAYED", "'DELAYED'"),
	4: ("DCAMPROP_TRIGGER_GLOBALEXPOSURE__EMULATE", "'EMULATE'"),
	5: ("DCAMPROP_TRIGGER_GLOBALEXPOSURE__GLOBALRESET", "'GLOBAL RESET'"),
	1: ("DCAMPROP_FIRSTTRIGGER_BEHAVIOR__STARTEXPOSURE", "'START EXPOSURE'"),
	2: ("DCAMPROP_FIRSTTRIGGER_BEHAVIOR__STARTREADOUT", "'START READOUT'"),
	1: ("DCAMPROP_MASTERPULSE_MODE__CONTINUOUS", "'CONTINUOUS'"),
	2: ("DCAMPROP_MASTERPULSE_MODE__START", "'START'"),
	3: ("DCAMPROP_MASTERPULSE_MODE__BURST", "'BURST'"),
	1: ("DCAMPROP_MASTERPULSE_TRIGGERSOURCE__EXTERNAL", "'EXTERNAL'"),
	2: ("DCAMPROP_MASTERPULSE_TRIGGERSOURCE__SOFTWARE", "'SOFTWARE'"),
	1: ("DCAMPROP_MECHANICALSHUTTER__AUTO", "'AUTO'"),
	2: ("DCAMPROP_MECHANICALSHUTTER__CLOSE", "'CLOSE'"),
	3: ("DCAMPROP_MECHANICALSHUTTER__OPEN", "'OPEN'"),
	1: ("DCAMPROP_LIGHTMODE__LOWLIGHT", "'LOW LIGHT'"),
	2: ("DCAMPROP_LIGHTMODE__HIGHLIGHT", "'HIGH LIGHT'"),
	1: ("DCAMPROP_SENSITIVITYMODE__OFF", "'OFF'"),
	2: ("DCAMPROP_SENSITIVITYMODE__ON", "'ON'"),
	3: ("DCAMPROP_SENSITIVITY2_MODE__INTERLOCK", "'INTERLOCK'"),
	1: ("DCAMPROP_EMGAINWARNING_STATUS__NORMAL", "'NORMAL'"),
	2: ("DCAMPROP_EMGAINWARNING_STATUS__WARNING", "'WARNING'"),
	3: ("DCAMPROP_EMGAINWARNING_STATUS__PROTECTED", "'PROTECTED'"),
	0: ("DCAMPROP_PHOTONIMAGINGMODE__0", "'0'"),
	1: ("DCAMPROP_PHOTONIMAGINGMODE__1", "'1'"),
	2: ("DCAMPROP_PHOTONIMAGINGMODE__2", "'2'"),
	3: ("DCAMPROP_PHOTONIMAGINGMODE__3", "'2'"),
	1: ("DCAMPROP_SENSORCOOLER__OFF", "'OFF'"),
	2: ("DCAMPROP_SENSORCOOLER__ON", "'ON'"),
	4: ("DCAMPROP_SENSORCOOLER__MAX", "'MAX'"),
	0: ("DCAMPROP_SENSORTEMPERATURE_STATUS__NORMAL", "'NORMAL'"),
	1: ("DCAMPROP_SENSORTEMPERATURE_STATUS__WARNING", "'WARNING'"),
	2: ("DCAMPROP_SENSORTEMPERATURE_STATUS__PROTECTION", "'PROTECTION'"),
	-4: ("DCAMPROP_SENSORCOOLERSTATUS__ERROR4", "'ERROR4'"),
	-3: ("DCAMPROP_SENSORCOOLERSTATUS__ERROR3", "'ERROR3'"),
	-2: ("DCAMPROP_SENSORCOOLERSTATUS__ERROR2", "'ERROR2'"),
	-1: ("DCAMPROP_SENSORCOOLERSTATUS__ERROR1", "'ERROR1'"),
	0: ("DCAMPROP_SENSORCOOLERSTATUS__NONE", "'NONE'"),
	1: ("DCAMPROP_SENSORCOOLERSTATUS__OFF", "'OFF'"),
	2: ("DCAMPROP_SENSORCOOLERSTATUS__READY", "'READY'"),
	3: ("DCAMPROP_SENSORCOOLERSTATUS__BUSY", "'BUSY'"),
	4: ("DCAMPROP_SENSORCOOLERSTATUS__ALWAYS", "'ALWAYS'"),
	1: ("DCAMPROP_REALTIMEGAINCORRECT_LEVEL__1", "'1'"),
	2: ("DCAMPROP_REALTIMEGAINCORRECT_LEVEL__2", "'2'"),
	3: ("DCAMPROP_REALTIMEGAINCORRECT_LEVEL__3", "'3'"),
	4: ("DCAMPROP_REALTIMEGAINCORRECT_LEVEL__4", "'4'"),
	5: ("DCAMPROP_REALTIMEGAINCORRECT_LEVEL__5", "'5'"),
	1: ("DCAMPROP_WHITEBALANCEMODE__FLAT", "'FLAT'"),
	2: ("DCAMPROP_WHITEBALANCEMODE__AUTO", "'AUTO'"),
	3: ("DCAMPROP_WHITEBALANCEMODE__TEMPERATURE", "'TEMPERATURE'"),
	4: ("DCAMPROP_WHITEBALANCEMODE__USERPRESET", "'USER PRESET'"),
	1: ("DCAMPROP_DARKCALIB_TARGET__ALL", "'ALL'"),
	2: ("DCAMPROP_DARKCALIB_TARGET__ANALOG", "'ANALOG'"),
	1: ("DCAMPROP_SHADINGCALIB_METHOD__AVERAGE", "'AVERAGE'"),
	2: ("DCAMPROP_SHADINGCALIB_METHOD__MAXIMUM", "'MAXIMUM'"),
	3: ("DCAMPROP_SHADINGCALIB_METHOD__USETARGET", "'USE TARGET'"),
	1: ("DCAMPROP_CAPTUREMODE__NORMAL", "'NORMAL'"),
	2: ("DCAMPROP_CAPTUREMODE__DARKCALIB", "'DARK CALIBRATION'"),
	3: ("DCAMPROP_CAPTUREMODE__SHADINGCALIB", "'SHADING CALIBRATION'"),
	4: ("DCAMPROP_CAPTUREMODE__TAPGAINCALIB", "'TAP GAIN CALIBRATION'"),
	5: ("DCAMPROP_CAPTUREMODE__BACKFOCUSCALIB", "'BACK FOCUS CALIBRATION'*/	/* ORCA-D2"),
	1: ("DCAMPROP_INTERFRAMEALU_ENABLE__OFF", "'OFF'"),
	2: ("DCAMPROP_INTERFRAMEALU_ENABLE__TRIGGERSOURCE_ALL", "'TRIGGER SOURCE ALL'"),
	3: ("DCAMPROP_INTERFRAMEALU_ENABLE__TRIGGERSOURCE_INTERNAL", "'TRIGGER SOURCE INTERNAL ONLY'"),
	1: ("DCAMPROP_CALIBDATASTATUS__NONE", "'NONE'"),
	2: ("DCAMPROP_CALIBDATASTATUS__FORWARD", "'FORWARD'"),
	3: ("DCAMPROP_CALIBDATASTATUS__BACKWARD", "'BACKWARD'"),
	4: ("DCAMPROP_CALIBDATASTATUS__BOTH", "'BOTH'"),
	1: ("DCAMPROP_TAPGAINCALIB_METHOD__AVE", "'AVERAGE'"),
	2: ("DCAMPROP_TAPGAINCALIB_METHOD__MAX", "'MAXIMUM'"),
	3: ("DCAMPROP_TAPGAINCALIB_METHOD__MIN", "'MINIMUM'"),
	2: ("DCAMPROP_RECURSIVEFILTERFRAMES__2", "'2 FRAMES'"),
	4: ("DCAMPROP_RECURSIVEFILTERFRAMES__4", "'4 FRAMES'"),
	8: ("DCAMPROP_RECURSIVEFILTERFRAMES__8", "'8 FRAMES'"),
	16: ("DCAMPROP_RECURSIVEFILTERFRAMES__16", "'16 FRAMES'"),
	32: ("DCAMPROP_RECURSIVEFILTERFRAMES__32", "'32 FRAMES'"),
	64: ("DCAMPROP_RECURSIVEFILTERFRAMES__64", "'64 FRAMES'"),
	1: ("DCAMPROP_INTENSITYLUT_MODE__THROUGH", "'THROUGH'"),
	2: ("DCAMPROP_INTENSITYLUT_MODE__PAGE", "'PAGE'"),
	3: ("DCAMPROP_INTENSITYLUT_MODE__CLIP", "'CLIP'"),
	1: ("DCAMPROP_BINNING__1", "'1X1'"),
	2: ("DCAMPROP_BINNING__2", "'2X2'"),
	4: ("DCAMPROP_BINNING__4", "'4X4'"),
	8: ("DCAMPROP_BINNING__8", "'8X8'"),
	16: ("DCAMPROP_BINNING__16", "'16X16'"),
	1: ("DCAMPROP_COLORTYPE__BW", "'BW'"),
	2: ("DCAMPROP_COLORTYPE__RGB", "'RGB'"),
	3: ("DCAMPROP_COLORTYPE__BGR", "'BGR'"),
	8: ("DCAMPROP_BITSPERCHANNEL__8", "'8BIT'"),
	10: ("DCAMPROP_BITSPERCHANNEL__10", "'10BIT'"),
	12: ("DCAMPROP_BITSPERCHANNEL__12", "'12BIT'"),
	14: ("DCAMPROP_BITSPERCHANNEL__14", "'14BIT'"),
	16: ("DCAMPROP_BITSPERCHANNEL__16", "'16BIT'"),
	1: ("DCAMPROP_DEFECTCORRECT_MODE__OFF", "'OFF'"),
	2: ("DCAMPROP_DEFECTCORRECT_MODE__ON", "'ON'"),
	3: ("DCAMPROP_DEFECTCORRECT_METHOD__CEILING", "'CEILING'"),
	4: ("DCAMPROP_DEFECTCORRECT_METHOD__PREVIOUS", "'PREVIOUS'"),
	1: ("DCAMPROP_HOTPIXELCORRECT_LEVEL__STANDARD", "'STANDARD'"),
	2: ("DCAMPROP_HOTPIXELCORRECT_LEVEL__MINIMUM", "'MINIMUM'"),
	3: ("DCAMPROP_HOTPIXELCORRECT_LEVEL__AGGRESSIVE", "'AGGRESSIVE'"),
	1: ("DCAMPROP_SYSTEM_ALIVE__OFFLINE", "'OFFLINE'"),
	2: ("DCAMPROP_SYSTEM_ALIVE__ONLINE", "'ONLINE'"),
	1: ("DCAMPROP_TIMESTAMP_MODE__NONE", "'NONE'"),
	2: ("DCAMPROP_TIMESTAMP_MODE__LINEBEFORELEFT", "'LINE BEFORE LEFT'"),
	3: ("DCAMPROP_TIMESTAMP_MODE__LINEOVERWRITELEFT", "'LINE OVERWRITE LEFT'"),
	4: ("DCAMPROP_TIMESTAMP_MODE__AREABEFORELEFT", "'AREA BEFORE LEFT'"),
	5: ("DCAMPROP_TIMESTAMP_MODE__AREAOVERWRITELEFT", "'AREA OVERWRITE LEFT'"),
	1: ("DCAMPROP_PACECONTROL_MODE__OFF", "'OFF'"),
	2: ("DCAMPROP_PACECONTROL_MODE__INTERVAL", "'INTERVAL'"),
	3: ("DCAMPROP_PACECONTROL_MODE__THINNING", "'THINNING'"),
	1: ("DCAMPROP_TIMING_EXPOSURE__AFTERREADOUT", "'AFTER READOUT'"),
	2: ("DCAMPROP_TIMING_EXPOSURE__OVERLAPREADOUT", "'OVERLAP READOUT'"),
	3: ("DCAMPROP_TIMING_EXPOSURE__ROLLING", "'ROLLING'"),
	4: ("DCAMPROP_TIMING_EXPOSURE__ALWAYS", "'ALWAYS'"),
	5: ("DCAMPROP_TIMING_EXPOSURE__TDI", "'TDI'"),
	1: ("DCAMPROP_TIMESTAMP_PRODUCER__NONE", "'NONE'"),
	2: ("DCAMPROP_TIMESTAMP_PRODUCER__DCAMMODULE", "'DCAM MODULE'"),
	3: ("DCAMPROP_TIMESTAMP_PRODUCER__KERNELDRIVER", "'KERNEL DRIVER'"),
	4: ("DCAMPROP_TIMESTAMP_PRODUCER__CAPTUREDEVICE", "'CAPTURE DEVICE'"),
	5: ("DCAMPROP_TIMESTAMP_PRODUCER__IMAGINGDEVICE", "'IMAGING DEVICE'"),
	1: ("DCAMPROP_FRAMESTAMP_PRODUCER__NONE", "'NONE'"),
	2: ("DCAMPROP_FRAMESTAMP_PRODUCER__DCAMMODULE", "'DCAM MODULE'"),
	3: ("DCAMPROP_FRAMESTAMP_PRODUCER__KERNELDRIVER", "'KERNEL DRIVER'"),
	4: ("DCAMPROP_FRAMESTAMP_PRODUCER__CAPTUREDEVICE", "'CAPTURE DEVICE'"),
	5: ("DCAMPROP_FRAMESTAMP_PRODUCER__IMAGINGDEVICE", "'IMAGING DEVICE'"),
	1: ("DCAMPROP_CAMERASTATUS_INTENSITY__GOOD", "'GOOD'"),
	2: ("DCAMPROP_CAMERASTATUS_INTENSITY__TOODARK", "'TOO DRAK'"),
	3: ("DCAMPROP_CAMERASTATUS_INTENSITY__TOOBRIGHT", "'TOO BRIGHT'"),
	4: ("DCAMPROP_CAMERASTATUS_INTENSITY__UNCARE", "'UNCARE'"),
	5: ("DCAMPROP_CAMERASTATUS_INTENSITY__EMGAIN_PROTECTION", "'EMGAIN PROTECTION'"),
	6: ("DCAMPROP_CAMERASTATUS_INTENSITY__INCONSISTENT_OPTICS", "'INCONSISTENT OPTICS'"),
	7: ("DCAMPROP_CAMERASTATUS_INTENSITY__NODATA", "'NO DATA'"),
	1: ("DCAMPROP_CAMERASTATUS_INPUTTRIGGER__GOOD", "'GOOD'"),
	2: ("DCAMPROP_CAMERASTATUS_INPUTTRIGGER__NONE", "'NONE'"),
	3: ("DCAMPROP_CAMERASTATUS_INPUTTRIGGER__TOOFREQUENT", "'TOO FREQUENT'"),
	1: ("DCAMPROP_CAMERASTATUS_CALIBRATION__DONE", "'DONE'"),
	2: ("DCAMPROP_CAMERASTATUS_CALIBRATION__NOTYET", "'NOT YET'"),
	3: ("DCAMPROP_CAMERASTATUS_CALIBRATION__NOTRIGGER", "'NO TRIGGER'"),
	4: ("DCAMPROP_CAMERASTATUS_CALIBRATION__TOOFREQUENTTRIGGER", "'TOO FREQUENT TRIGGER'"),
	5: ("DCAMPROP_CAMERASTATUS_CALIBRATION__OUTOFADJUSTABLERANGE", "'OUT OF ADJUSTABLE RANGE'"),
	6: ("DCAMPROP_CAMERASTATUS_CALIBRATION__UNSUITABLETABLE", "'UNSUITABLE TABLE'"),
	7: ("DCAMPROP_CAMERASTATUS_CALIBRATION__TOODARK", "'TOO DARK'"),
	8: ("DCAMPROP_CAMERASTATUS_CALIBRATION__TOOBRIGHT", "'TOO BRIGHT'"),
	9: ("DCAMPROP_CAMERASTATUS_CALIBRATION__NOTDETECTOBJECT", "'NOT DETECT OBJECT'"),
	1: ("DCAMPROP_MODE__OFF", "'OFF'"),
	2: ("DCAMPROP_MODE__ON", "'ON'"),
	1: ("DCAMPROP_SCAN_MODE__NORMAL", "'AREA'"),
	2: ("DCAMPROP_SCAN_MODE__SLIT", "*/	/* reserved"),
	1: ("DCAMPROP_SWITCHMODE_OFF", "'OFF'"),
	2: ("DCAMPROP_SWITCHMODE_ON", "'ON'"),
	3: ("DCAMPROP_TRIGGERACTIVE__PULSE", "'SYNCREADOUT'"),
	1: ("DCAMPROP_READOUT_DIRECTION__NORMAL", "'FORWARD'"),
	2: ("DCAMPROP_READOUT_DIRECTION__REVERSE", "'BACKWARD'"),
	2: ("DCAMPROP_TRIGGERSOURCE__EXERNAL", "'EXTERNAL'"),
}

DCAMIDPROP = {
	1048848: ("DCAM_IDPROP_TRIGGERSOURCE", "R/W, mode,	'TRIGGER SOURCE'"),
	1048864: ("DCAM_IDPROP_TRIGGERACTIVE", "R/W, mode,	'TRIGGER ACTIVE'"),
	1049104: ("DCAM_IDPROP_TRIGGER_MODE", "R/W, mode,	'TRIGGER MODE'"),
	1049120: ("DCAM_IDPROP_TRIGGERPOLARITY", "R/W, mode,	'TRIGGER POLARITY'"),
	1049136: ("DCAM_IDPROP_TRIGGER_CONNECTOR", "R/W, mode,	'TRIGGER CONNECTOR'"),
	1049152: ("DCAM_IDPROP_TRIGGERTIMES", "R/W, long,	'TRIGGER TIMES'"),
	1049184: ("DCAM_IDPROP_TRIGGERDELAY", "R/W, sec,	'TRIGGER DELAY'"),
	1049200: ("DCAM_IDPROP_INTERNALTRIGGER_HANDLING", "R/W, mode,	'INTERNAL TRIGGER HANDLING'"),
	1049216: ("DCAM_IDPROP_TRIGGERMULTIFRAME_COUNT", "R/W, long,	'TRIGGER MULTI FRAME COUNT'"),
	1049232: ("DCAM_IDPROP_SYNCREADOUT_SYSTEMBLANK", "R/W, mode,	'SYNC READOUT SYSTEM BLANK'"),
	1049616: ("DCAM_IDPROP_TRIGGERENABLE_ACTIVE", "R/W, mode,	'TRIGGER ENABLE ACTIVE'"),
	1049632: ("DCAM_IDPROP_TRIGGERENABLE_POLARITY", "R/W, mode,	'TRIGGER ENABLE POLARITY'"),
	1050640: ("DCAM_IDPROP_TRIGGERNUMBER_FORFIRSTIMAGE", "R/O, long,	'TRIGGER NUMBER FOR FIRST IMAGE'"),
	1050656: ("DCAM_IDPROP_TRIGGERNUMBER_FORNEXTIMAGE", "R/O, long,	'TRIGGER NUMBER FOR NEXT IMAGE'"),
	1573136: ("DCAM_IDPROP_BUS_SPEED", "R/W, long,	'BUS SPEED'"),
	1835024: ("DCAM_IDPROP_NUMBEROF_OUTPUTTRIGGERCONNECTOR", "R/O, long,	'NUMBER OF OUTPUT TRIGGER CONNECTOR'"),
	1835056: ("DCAM_IDPROP_OUTPUTTRIGGER_CHANNELSYNC", "R/W, mode,	'OUTPUT TRIGGER CHANNEL SYNC'"),
	1835088: ("DCAM_IDPROP_OUTPUTTRIGGER_PROGRAMABLESTART", "R/W, mode,	'OUTPUT TRIGGER PROGRAMABLE START'"),
	1835280: ("DCAM_IDPROP_OUTPUTTRIGGER_SOURCE", "R/W, mode,	'OUTPUT TRIGGER SOURCE'"),
	1835296: ("DCAM_IDPROP_OUTPUTTRIGGER_POLARITY", "R/W, mode,	'OUTPUT TRIGGER POLARITY'"),
	1835312: ("DCAM_IDPROP_OUTPUTTRIGGER_ACTIVE", "R/W, mode,	'OUTPUT TRIGGER ACTIVE'"),
	1835328: ("DCAM_IDPROP_OUTPUTTRIGGER_DELAY", "R/W, sec,	'OUTPUT TRIGGER DELAY'"),
	1835344: ("DCAM_IDPROP_OUTPUTTRIGGER_PERIOD", "R/W, sec,	'OUTPUT TRIGGER PERIOD'"),
	1835360: ("DCAM_IDPROP_OUTPUTTRIGGER_KIND", "R/W, mode,	'OUTPUT TRIGGER KIND'"),
	1835376: ("DCAM_IDPROP_OUTPUTTRIGGER_BASESENSOR", "R/W, mode,	'OUTPUT TRIGGER BASE SENSOR'"),
	1835408: ("DCAM_IDPROP_OUTPUTTRIGGER_PREHSYNCCOUNT", "R/W, mode,	'OUTPUT TRIGGER PRE HSYNC COUNT'"),
	256: ("DCAM_IDPROP__OUTPUTTRIGGER", "the offset of ID for Nth OUTPUT TRIGGER parameter"),
	1966112: ("DCAM_IDPROP_MASTERPULSE_MODE", "R/W, mode,	'MASTER PULSE MODE'"),
	1966128: ("DCAM_IDPROP_MASTERPULSE_TRIGGERSOURCE", "R/W, mode,	'MASTER PULSE TRIGGER SOURCE'"),
	1966144: ("DCAM_IDPROP_MASTERPULSE_INTERVAL", "R/W, sec,	'MASTER PULSE INTERVAL'"),
	1966160: ("DCAM_IDPROP_MASTERPULSE_BURSTTIMES", "R/W, long,	'MASTER PULSE BURST TIMES'"),
	2031888: ("DCAM_IDPROP_EXPOSURETIME", "R/W, sec,	'EXPOSURE TIME'"),
	2031904: ("DCAM_IDPROP_SYNC_MULTIVIEWEXPOSURE", "R/W, mode,	'SYNCHRONOUS MULTI VIEW EXPOSURE'"),
	2031920: ("DCAM_IDPROP_EXPOSURETIME_CONTROL", "R/W, mode,	'EXPOSURE TIME CONTROL'"),
	2032128: ("DCAM_IDPROP_TRIGGER_FIRSTEXPOSURE", "R/W, mode,	'TRIGGER FIRST EXPOSURE'"),
	2032384: ("DCAM_IDPROP_TRIGGER_GLOBALEXPOSURE", "R/W, mode,	'TRIGGER GLOBAL EXPOSURE'"),
	2032400: ("DCAM_IDPROP_FIRSTTRIGGER_BEHAVIOR", "R/W, mode,	'FIRST TRIGGER BEHAVIOR'"),
	2035712: ("DCAM_IDPROP_MULTIFRAME_EXPOSURE", "R/W, sec,	'MULTI FRAME EXPOSURE TIME'"),
	16: ("DCAM_IDPROP__MULTIFRAME", "the offset of ID for Nth MULTIFRAME"),
	2097424: ("DCAM_IDPROP_LIGHTMODE", "R/W, mode,	'LIGHT MODE'"),
	2097680: ("DCAM_IDPROP_SENSITIVITYMODE", "R/W, mode,	'SENSITIVITY MODE'"),
	2097696: ("DCAM_IDPROP_SENSITIVITY", "R/W, long,	'SENSITIVITY'"),
	2097712: ("DCAM_IDPROP_SENSITIVITY2_MODE", "*/	/* reserved"),
	2097728: ("DCAM_IDPROP_SENSITIVITY2", "R/W, long,	'SENSITIVITY2'"),
	2097744: ("DCAM_IDPROP_DIRECTEMGAIN_MODE", "R/W, mode,	'DIRECT EM GAIN MODE'"),
	2097760: ("DCAM_IDPROP_EMGAINWARNING_STATUS", "R/O, mode,	'EM GAIN WARNING STATUS'"),
	2097776: ("DCAM_IDPROP_EMGAINWARNING_LEVEL", "R/W, long,	'EM GAIN WARNING LEVEL'"),
	2097792: ("DCAM_IDPROP_EMGAINWARNING_ALARM", "R/W, mode,	'EM GAIN WARNING ALARM'"),
	2097808: ("DCAM_IDPROP_EMGAINPROTECT_MODE", "R/W, mode,	'EM GAIN PROTECT MODE'"),
	2097824: ("DCAM_IDPROP_EMGAINPROTECT_AFTERFRAMES", "R/W, long,	'EM GAIN PROTECT AFTER FRAMES'"),
	2097840: ("DCAM_IDPROP_MEASURED_SENSITIVITY", "R/O, real,	'MEASURED SENSITIVITY'"),
	2097904: ("DCAM_IDPROP_PHOTONIMAGINGMODE", "R/W, mode,	'PHOTON IMAGING MODE'"),
	2097936: ("DCAM_IDPROP_SENSORTEMPERATURE", "R/O, celsius,'SENSOR TEMPERATURE'"),
	2097952: ("DCAM_IDPROP_SENSORCOOLER", "R/W, mode,	'SENSOR COOLER'"),
	2097968: ("DCAM_IDPROP_SENSORTEMPERATURETARGET", "R/W, celsius,'SENSOR TEMPERATURE TARGET'"),
	2097984: ("DCAM_IDPROP_SENSORCOOLERSTATUS", "R/O, mode,	'SENSOR COOLER STATUS'"),
	2098000: ("DCAM_IDPROP_SENSORCOOLERFAN", "R/W, mode,	'SENSOR COOLER FAN'"),
	2098016: ("DCAM_IDPROP_SENSORTEMPERATURE_AVE", "R/O, celsius,'SENSOR TEMPERATURE AVE'"),
	2098032: ("DCAM_IDPROP_SENSORTEMPERATURE_MIN", "R/O, celsius,'SENSOR TEMPERATURE MIN'"),
	2098048: ("DCAM_IDPROP_SENSORTEMPERATURE_MAX", "R/O, celsius,'SENSOR TEMPERATURE MAX'"),
	2098064: ("DCAM_IDPROP_SENSORTEMPERATURE_STATUS", "R/O, mode,	'SENSOR TEMPERATURE STATUS'"),
	2098176: ("DCAM_IDPROP_SENSORTEMPERATURE_PROTECT", "R/W, mode,	'SENSOR TEMPERATURE MODE'"),
	2098192: ("DCAM_IDPROP_MECHANICALSHUTTER", "R/W, mode,	'MECHANICAL SHUTTER'"),
	3146016: ("DCAM_IDPROP_CONTRASTGAIN", "R/W, long,	'CONTRAST GAIN'"),
	3146032: ("DCAM_IDPROP_CONTRASTOFFSET", "R/W, long,	'CONTRAST OFFSET'"),
	3146064: ("DCAM_IDPROP_HIGHDYNAMICRANGE_MODE", "R/W, mode,	'HIGH DYNAMIC RANGE MODE'"),
	3146080: ("DCAM_IDPROP_DIRECTGAIN_MODE", "R/W, mode,	'DIRECT GAIN MODE'"),
	3146096: ("DCAM_IDPROP_REALTIMEGAINCORRECT_MODE", "R/W,	mode,	'REALTIME GAIN CORRECT MODE'"),
	3146112: ("DCAM_IDPROP_REALTIMEGAINCORRECT_LEVEL", "R/W,	mode,	'REALTIME GAIN CORRECT LEVEL'"),
	3146128: ("DCAM_IDPROP_REALTIMEGAINCORRECT_INTERVAL", "R/W,	mode,	'REALTIME GAIN CORRECT INTERVAL'"),
	3146240: ("DCAM_IDPROP_VIVIDCOLOR", "R/W, mode,	'VIVID COLOR'			*/	/* comment"),
	3146256: ("DCAM_IDPROP_WHITEBALANCEMODE", "R/W, mode,	'WHITEBALANCE MODE'"),
	3146272: ("DCAM_IDPROP_WHITEBALANCETEMPERATURE", "R/W, color-temp., 'WHITEBALANCE TEMPERATURE'"),
	3146288: ("DCAM_IDPROP_WHITEBALANCEUSERPRESET", "R/W, long,	'WHITEBALANCE USER PRESET'"),
	3670032: ("DCAM_IDPROP_INTERFRAMEALU_ENABLE", "R/W, mode,	'INTERFRAME ALU ENABLE'"),
	3670288: ("DCAM_IDPROP_RECURSIVEFILTER", "R/W, mode,	'RECURSIVE FILTER'"),
	3670304: ("DCAM_IDPROP_RECURSIVEFILTERFRAMES", "R/W, long,	'RECURSIVE FILTER FRAMES'"),
	3670320: ("DCAM_IDPROP_SPOTNOISEREDUCER", "R/W, mode,	'SPOT NOISE REDUCER'"),
	3670544: ("DCAM_IDPROP_SUBTRACT", "R/W, mode,	'SUBTRACT'"),
	3670560: ("DCAM_IDPROP_SUBTRACTIMAGEMEMORY", "R/W, mode,	'SUBTRACT IMAGE MEMORY'"),
	3670576: ("DCAM_IDPROP_STORESUBTRACTIMAGETOMEMORY", "W/O, mode,	'STORE SUBTRACT IMAGE TO MEMORY'"),
	3670592: ("DCAM_IDPROP_SUBTRACTOFFSET", "R/W, long	'SUBTRACT OFFSET'"),
	3670608: ("DCAM_IDPROP_DARKCALIB_STABLEMAXINTENSITY", "R/W, long,	'DARKCALIB STABLE MAX INTENSITY'"),
	3670768: ("DCAM_IDPROP_SUBTRACT_DATASTATUS", "R/W	mode,	'SUBTRACT DATA STATUS'"),
	3670784: ("DCAM_IDPROP_SHADINGCALIB_DATASTATUS", "R/W	mode,	'SHADING CALIB DATA STATUS'"),
	3670800: ("DCAM_IDPROP_SHADINGCORRECTION", "R/W, mode,	'SHADING CORRECTION'"),
	3670816: ("DCAM_IDPROP_SHADINGCALIBDATAMEMORY", "R/W, mode,	'SHADING CALIB DATA MEMORY'"),
	3670832: ("DCAM_IDPROP_STORESHADINGCALIBDATATOMEMORY", "W/O, mode,	'STORE SHADING DATA TO MEMORY'"),
	3670848: ("DCAM_IDPROP_SHADINGCALIB_METHOD", "R/W, mode,	'SHADING CALIB METHOD'"),
	3670864: ("DCAM_IDPROP_SHADINGCALIB_TARGET", "R/W, long,	'SHADING CALIB TARGET'"),
	3670880: ("DCAM_IDPROP_SHADINGCALIB_STABLEMININTENSITY", "R/W, long,	'SHADING CALIB STABLE MIN INTENSITY'"),
	3670896: ("DCAM_IDPROP_SHADINGCALIB_SAMPLES", "R/W, long,	'SHADING CALIB SAMPLES'"),
	3670912: ("DCAM_IDPROP_SHADINGCALIB_STABLESAMPLES", "R/W, long,	'SHADING CALIB STABLE SAMPLES'"),
	3670928: ("DCAM_IDPROP_SHADINGCALIB_STABLEMAXERRORPERCENT", "R/W, long,	'SHADING CALIB STABLE MAX ERROR PERCENT'"),
	3670944: ("DCAM_IDPROP_FRAMEAVERAGINGMODE", "R/W, mode,	'FRAME AVERAGING MODE'"),
	3670960: ("DCAM_IDPROP_FRAMEAVERAGINGFRAMES", "R/W, long,	'FRAME AVERAGING FRAMES'"),
	3670976: ("DCAM_IDPROP_DARKCALIB_STABLESAMPLES", "R/W, long,	'DARKCALIB STABLE SAMPLES'"),
	3670992: ("DCAM_IDPROP_DARKCALIB_SAMPLES", "R/W, long,	'DARKCALIB SAMPLES'"),
	3671008: ("DCAM_IDPROP_DARKCALIB_TARGET", "R/W, long,	'DARKCALIB TARGET'"),
	3671056: ("DCAM_IDPROP_CAPTUREMODE", "R/W, mode,	'CAPTURE MODE'"),
	3671312: ("DCAM_IDPROP_INTENSITYLUT_MODE", "R/W, mode,	'INTENSITY LUT MODE'"),
	3671328: ("DCAM_IDPROP_INTENSITYLUT_PAGE", "R/W, long,	'INTENSITY LUT PAGE'"),
	3671344: ("DCAM_IDPROP_INTENSITYLUT_WHITECLIP", "R/W, long,	'INTENSITY LUT WHITE CLIP'"),
	3671360: ("DCAM_IDPROP_INTENSITYLUT_BLACKCLIP", "R/W, long,	'INTENSITY LUT BLACK CLIP'"),
	3671584: ("DCAM_IDPROP_SENSORGAPCORRECT_MODE", "R/W,	long,	'SENSOR GAP CORRECT MODE'"),
	3673872: ("DCAM_IDPROP_TAPGAINCALIB_METHOD", "R/W, mode,	'TAP GAIN CALIB METHOD'"),
	3673888: ("DCAM_IDPROP_TAPCALIB_BASEDATAMEMORY", "R/W, mode,	'TAP CALIB BASE DATA MEMORY'"),
	3673904: ("DCAM_IDPROP_STORETAPCALIBDATATOMEMORY", "W/O, mode,	'STORE TAP CALIB DATA TO MEMORY'"),
	3673920: ("DCAM_IDPROP_TAPCALIBDATAMEMORY", "W/O, mode,	'TAP CALIB DATA MEMORY'"),
	3674096: ("DCAM_IDPROP_NUMBEROF_TAPCALIB", "R/W, long,	'NUMBER OF TAP CALIB'"),
	3674112: ("DCAM_IDPROP_TAPCALIB_GAIN", "R/W, mode,	'TAP CALIB GAIN'"),
	16: ("DCAM_IDPROP__TAPCALIB", "the offset of ID for Nth TAPCALIB"),
	4194576: ("DCAM_IDPROP_READOUTSPEED", "R/W, long,	'READOUT SPEED'"),
	4194608: ("DCAM_IDPROP_READOUT_DIRECTION", "R/W, mode,	'READOUT DIRECTION'"),
	4194624: ("DCAM_IDPROP_READOUT_UNIT", "R/O, mode,	'READOUT UNIT'"),
	4194832: ("DCAM_IDPROP_SENSORMODE", "R/W, mode,	'SENSOR MODE'"),
	4194848: ("DCAM_IDPROP_SENSORMODE_SLITHEIGHT", "*/	/* reserved"),
	4194896: ("DCAM_IDPROP_SENSORMODE_LINEBUNDLEHEIGHT", "R/W, long,	'SENSOR MODE LINE BUNDLEHEIGHT'"),
	4194912: ("DCAM_IDPROP_SENSORMODE_FRAMINGHEIGHT", "*/	/* reserved"),
	4194944: ("DCAM_IDPROP_SENSORMODE_PANORAMICSTARTV", "R/W, long,	'SENSOR MODE PANORAMIC START V'"),
	4195088: ("DCAM_IDPROP_CCDMODE", "R/W, mode,	'CCD MODE'"),
	4195104: ("DCAM_IDPROP_EMCCD_CALIBRATIONMODE", "R/W, mode,	'EM CCD CALIBRATION MODE'"),
	4195152: ("DCAM_IDPROP_CMOSMODE", "R/W, mode,	'CMOS MODE'"),
	4195344: ("DCAM_IDPROP_OUTPUT_INTENSITY", "R/W, mode,	'OUTPUT INTENSITY'"),
	4195360: ("DCAM_IDPROP_OUTPUTDATA_ORIENTATION", "*/	/* reserved"),
	4195376: ("DCAM_IDPROP_OUTPUTDATA_ROTATION", "*/	/* reserved"),
	4195392: ("DCAM_IDPROP_OUTPUTDATA_OPERATION", "R/W, mode,	'OUTPUT DATA OPERATION'"),
	4195600: ("DCAM_IDPROP_TESTPATTERN_KIND", "R/W, mode,	'TEST PATTERN KIND'"),
	4195616: ("DCAM_IDPROP_TESTPATTERN_OPTION", "R/W, long,	'TEST PATTERN OPTION'"),
	4195872: ("DCAM_IDPROP_EXTRACTION_MODE", "R/W	mode,	'EXTRACTION MODE	'"),
	4198672: ("DCAM_IDPROP_BINNING", "R/W, mode,	'BINNING'"),
	4198688: ("DCAM_IDPROP_BINNING_INDEPENDENT", "R/W, mode,	'BINNING INDEPENDENT'"),
	4198704: ("DCAM_IDPROP_BINNING_HORZ", "R/W, long,	'BINNING HORZ'"),
	4198720: ("DCAM_IDPROP_BINNING_VERT", "R/W, long,	'BINNING VERT'"),
	4202768: ("DCAM_IDPROP_SUBARRAYHPOS", "R/W, long,	'SUBARRAY HPOS'"),
	4202784: ("DCAM_IDPROP_SUBARRAYHSIZE", "R/W, long,	'SUBARRAY HSIZE'"),
	4202800: ("DCAM_IDPROP_SUBARRAYVPOS", "R/W, long,	'SUBARRAY VPOS'"),
	4202816: ("DCAM_IDPROP_SUBARRAYVSIZE", "R/W, long,	'SUBARRAY VSIZE'"),
	4202832: ("DCAM_IDPROP_SUBARRAYMODE", "R/W, mode,	'SUBARRAY MODE'"),
	4202848: ("DCAM_IDPROP_DIGITALBINNING_METHOD", "R/W, mode,	'DIGITALBINNING METHOD'"),
	4202864: ("DCAM_IDPROP_DIGITALBINNING_HORZ", "R/W, long,	'DIGITALBINNING HORZ'"),
	4202880: ("DCAM_IDPROP_DIGITALBINNING_VERT", "R/W, long,	'DIGITALBINNING VERT'"),
	4206608: ("DCAM_IDPROP_TIMING_READOUTTIME", "R/O, sec,	'TIMING READOUT TIME'"),
	4206624: ("DCAM_IDPROP_TIMING_CYCLICTRIGGERPERIOD", "R/O, sec,	'TIMING CYCLIC TRIGGER PERIOD'"),
	4206640: ("DCAM_IDPROP_TIMING_MINTRIGGERBLANKING", "R/O, sec,	'TIMING MINIMUM TRIGGER BLANKING'"),
	4206672: ("DCAM_IDPROP_TIMING_MINTRIGGERINTERVAL", "R/O, sec,	'TIMING MINIMUM TRIGGER INTERVAL'"),
	4206688: ("DCAM_IDPROP_TIMING_EXPOSURE", "R/O, mode,	'TIMING EXPOSURE'"),
	4206704: ("DCAM_IDPROP_TIMING_INVALIDEXPOSUREPERIOD", "R/O, sec,	'INVALID EXPOSURE PERIOD'"),
	4206720: ("DCAM_IDPROP_TIMING_FRAMESKIPNUMBER", "R/W, long,	'TIMING FRAME SKIP NUMBER'"),
	4206736: ("DCAM_IDPROP_TIMING_GLOBALEXPOSUREDELAY", "R/O, sec,	'TIMING GLOBAL EXPOSURE DELAY'"),
	4208656: ("DCAM_IDPROP_INTERNALFRAMERATE", "R/W, 1/sec,	'INTERNAL FRAME RATE'"),
	4208672: ("DCAM_IDPROP_INTERNAL_FRAMEINTERVAL", "R/W, sec,	'INTERNAL FRAME INTERVAL'"),
	4208688: ("DCAM_IDPROP_INTERNALLINERATE", "R/W, 1/sec,	'INTERNAL LINE RATE'"),
	4208704: ("DCAM_IDPROP_INTERNALLINESPEED", "R/W, m/sec,	'INTERNAL LINE SPEEED'"),
	4208720: ("DCAM_IDPROP_INTERNAL_LINEINTERVAL", "R/W, sec,	'INTERNAL LINE INTERVAL'"),
	4262416: ("DCAM_IDPROP_TIMESTAMP_PRODUCER", "R/O, mode,	'TIME STAMP PRODUCER'"),
	4262432: ("DCAM_IDPROP_FRAMESTAMP_PRODUCER", "R/O, mode,	'FRAME STAMP PRODUCER'"),
	4325664: ("DCAM_IDPROP_COLORTYPE", "R/W, mode,	'COLORTYPE'"),
	4325680: ("DCAM_IDPROP_BITSPERCHANNEL", "R/W, long,	'BIT PER CHANNEL'"),
	4325760: ("DCAM_IDPROP_NUMBEROF_CHANNEL", "R/O, long,	'NUMBER OF CHANNEL'"),
	4325776: ("DCAM_IDPROP_ACTIVE_CHANNELINDEX", "R/W, mode,	'ACTIVE CHANNEL INDEX'"),
	4325824: ("DCAM_IDPROP_NUMBEROF_VIEW", "R/O, long,	'NUMBER OF VIEW'"),
	4325840: ("DCAM_IDPROP_ACTIVE_VIEWINDEX", "R/W, mode,	'ACTIVE VIEW INDEX'"),
	4325904: ("DCAM_IDPROP_IMAGE_WIDTH", "R/O, long,	'IMAGE WIDTH'"),
	4325920: ("DCAM_IDPROP_IMAGE_HEIGHT", "R/O, long,	'IMAGE HEIGHT'"),
	4325936: ("DCAM_IDPROP_IMAGE_ROWBYTES", "R/O, long,	'IMAGE ROWBYTES'"),
	4325952: ("DCAM_IDPROP_IMAGE_FRAMEBYTES", "R/O, long,	'IMAGE FRAMEBYTES'"),
	4325968: ("DCAM_IDPROP_IMAGE_TOPOFFSETBYTES", "R/O, long,	'IMAGE TOP OFFSET BYTES'*/		/* reserved"),
	4326000: ("DCAM_IDPROP_IMAGE_PIXELTYPE", "R/W, DCAM_PIXELTYPE,	'IMAGE PIXEL TYPE'"),
	4326144: ("DCAM_IDPROP_IMAGE_CAMERASTAMP", "R/W, long,	'IMAGE CAMERA STAMP'"),
	4326192: ("DCAM_IDPROP_BUFFER_ROWBYTES", "R/O, long,	'BUFFER ROWBYTES'"),
	4326208: ("DCAM_IDPROP_BUFFER_FRAMEBYTES", "R/O, long,	'BUFFER FRAME BYTES'"),
	4326224: ("DCAM_IDPROP_BUFFER_TOPOFFSETBYTES", "R/O, long,	'BUFFER TOP OFFSET BYTES'"),
	4326240: ("DCAM_IDPROP_BUFFER_PIXELTYPE", "R/O, DCAM_PIXELTYPE,	'BUFFER PIXEL TYPE'"),
	4326416: ("DCAM_IDPROP_RECORDFIXEDBYTES_PERFILE", "R/O,	long	'RECORD FIXED BYTES PER FILE'"),
	4326432: ("DCAM_IDPROP_RECORDFIXEDBYTES_PERSESSION", "R/O,	long	'RECORD FIXED BYTES PER SESSION'"),
	4326448: ("DCAM_IDPROP_RECORDFIXEDBYTES_PERFRAME", "R/O,	long	'RECORD FIXED BYTES PER FRAME'"),
	4327440: ("DCAM_IDPROP_IMAGEDETECTOR_PIXELWIDTH", "*/	/* reserved"),
	4327456: ("DCAM_IDPROP_IMAGEDETECTOR_PIXELHEIGHT", "*/	/* reserved"),
	4329488: ("DCAM_IDPROP_FRAMEBUNDLE_MODE", "R/W, mode,	'FRAMEBUNDLE MODE'"),
	4329504: ("DCAM_IDPROP_FRAMEBUNDLE_NUMBER", "R/W, long,	'FRAMEBUNDLE NUMBER'"),
	4329520: ("DCAM_IDPROP_FRAMEBUNDLE_ROWBYTES", "R/O,	long,	'FRAMEBUNDLE ROWBYTES'"),
	4329536: ("DCAM_IDPROP_FRAMEBUNDLE_FRAMESTEPBYTES", "R/O, long,	'FRAMEBUNDLE FRAME STEP BYTES'"),
	4390928: ("DCAM_IDPROP_NUMBEROF_PARTIALAREA", "R/W, long,	'NUMBER OF PARTIAL AREA'"),
	4395008: ("DCAM_IDPROP_PARTIALAREA_HPOS", "R/W, long,	'PARTIAL AREA HPOS'"),
	4399104: ("DCAM_IDPROP_PARTIALAREA_HSIZE", "R/W, long,	'PARTIAL AREA HSIZE'"),
	4403200: ("DCAM_IDPROP_PARTIALAREA_VPOS", "R/W, long,	'PARTIAL AREA VPOS'"),
	4407296: ("DCAM_IDPROP_PARTIALAREA_VSIZE", "R/W, long,	'PARTIAL AREA VSIZE'"),
	16: ("DCAM_IDPROP__PARTIALAREA", "the offset of ID for Nth PARTIAL AREA"),
	4517904: ("DCAM_IDPROP_NUMBEROF_MULTILINE", "R/W, long,	'NUMBER OF MULTI LINE'"),
	4521984: ("DCAM_IDPROP_MULTILINE_VPOS", "R/W, long,	'MULTI LINE VPOS'"),
	4587520: ("DCAM_IDPROP_MULTILINE_VSIZE", "R/W, long,	'MULTI LINE VSIZE'"),
	16: ("DCAM_IDPROP__MULTILINE", "the offset of ID for Nth MULTI LINE"),
	4653072: ("DCAM_IDPROP_DEFECTCORRECT_MODE", "R/W, mode,	'DEFECT CORRECT MODE'"),
	4653088: ("DCAM_IDPROP_NUMBEROF_DEFECTCORRECT", "R/W, long,	'NUMBER OF DEFECT CORRECT'"),
	4653104: ("DCAM_IDPROP_HOTPIXELCORRECT_LEVEL", "R/W, mode,	'HOT PIXEL CORRECT LEVEL'"),
	4657152: ("DCAM_IDPROP_DEFECTCORRECT_HPOS", "R/W, long,	'DEFECT CORRECT HPOS'"),
	4665344: ("DCAM_IDPROP_DEFECTCORRECT_METHOD", "R/W, mode,	'DEFECT CORRECT METHOD'"),
	16: ("DCAM_IDPROP__DEFECTCORRECT", "the offset of ID for Nth DEFECT"),
	4849936: ("DCAM_IDPROP_PACECONTROL_MODE", "R/W, mode,	'PACE CONTROL MODE'"),
	4849952: ("DCAM_IDPROP_NUMBEROF_PACECONTROL", "R/W, long,	'NUMBER OF PACE CONTROL'"),
	4853760: ("DCAM_IDPROP_PACECONTROL_COUNT", "R/W, long,	'PACE CONTROL COUNT'"),
	4857856: ("DCAM_IDPROP_PACECONTROL_INTERVAL", "R/W, real,	'PACE CONTROL INTERVAL'"),
	16: ("DCAM_IDPROP__PACECONTROL", "the offset of ID for Nth PACECONTROL"),
	4203536: ("DCAM_IDPROP_CALIBREGION_MODE", "R/W, mode,	'CALIBRATE REGION MODE'"),
	4203552: ("DCAM_IDPROP_NUMBEROF_CALIBREGION", "R/W, long,	'NUMBER OF CALIBRATE REGION'"),
	4915200: ("DCAM_IDPROP_CALIBREGION_HPOS", "R/W, long,	'CALIBRATE REGION HPOS'"),
	4919296: ("DCAM_IDPROP_CALIBREGION_HSIZE", "R/W, long,	'CALIBRATE REGION HSIZE'"),
	16: ("DCAM_IDPROP__CALIBREGION", "the offset of ID for Nth REGION"),
	4203792: ("DCAM_IDPROP_MASKREGION_MODE", "R/W, mode,	'MASK REGION MODE'"),
	4203808: ("DCAM_IDPROP_NUMBEROF_MASKREGION", "R/W, long,	'NUMBER OF MASK REGION'"),
	4980736: ("DCAM_IDPROP_MASKREGION_HPOS", "R/W, long,	'MASK REGION HPOS'"),
	4984832: ("DCAM_IDPROP_MASKREGION_HSIZE", "R/W, long,	'MASK REGION HSIZE'"),
	16: ("DCAM_IDPROP__MASKREGION", "the offset of ID for Nth REGION"),
	5050640: ("DCAM_IDPROP_CAMERASTATUS_INTENSITY", "R/O, mode,	'CAMERASTATUS INTENSITY'"),
	5050656: ("DCAM_IDPROP_CAMERASTATUS_INPUTTRIGGER", "R/O, mode,	'CAMERASTATUS INPUT TRIGGER'"),
	5050672: ("DCAM_IDPROP_CAMERASTATUS_CALIBRATION", "R/O, mode,	'CAMERASTATUS CALIBRATION'"),
	8405008: ("DCAM_IDPROP_BACKFOCUSPOS_TARGET", "R/W, micro-meter,'BACK FOCUS POSITION TARGET'"),
	8405024: ("DCAM_IDPROP_BACKFOCUSPOS_CURRENT", "R/O, micro-meter,'BACK FOCUS POSITION CURRENT'"),
	8405072: ("DCAM_IDPROP_BACKFOCUSPOS_LOADFROMMEMORY", "R/W, long, 'BACK FOCUS POSITION LOAD FROM MEMORY'"),
	8405088: ("DCAM_IDPROP_BACKFOCUSPOS_STORETOMEMORY", "W/O, long, 'BACK FOCUS POSITION STORE TO MEMORY'"),
	16711696: ("DCAM_IDPROP_SYSTEM_ALIVE", "R/O, mode,	'SYSTEM ALIVE'"),
	16769040: ("DCAM_IDPROP_CONVERSIONFACTOR_COEFF", "R/O, double,	'CONVERSION FACTOR COEFF'"),
	16769056: ("DCAM_IDPROP_CONVERSIONFACTOR_OFFSET", "R/O, double,	'CONVERSION FACTOR OFFSET'"),
	-2147483648: ("DCAM_IDPROP__RATIO", ""),
	-2145451760: ("DCAM_IDPROP_EXPOSURETIME_RATIO", "reserved"),
	-2144337632: ("DCAM_IDPROP_CONTRASTGAIN_RATIO", "reserved"),
	1: ("DCAM_IDPROP__CHANNEL", ""),
	16777216: ("DCAM_IDPROP__VIEW", ""),
	15: ("DCAM_IDPROP__MASK_CHANNEL", ""),
	251658240: ("DCAM_IDPROP__MASK_VIEW", ""),
	16777200: ("DCAM_IDPROP__MASK_BODY", ""),
	524288: ("DCAMPROP_ATTR_REMOTE_VALUE", "value may be changed by user or automatically"),
	0: ("DCAMPROP_PHOTONIMAGING_MODE__0", "'0'"),
	1: ("DCAMPROP_PHOTONIMAGING_MODE__1", "'1'"),
	2: ("DCAMPROP_PHOTONIMAGING_MODE__2", "'2'"),
	4194832: ("DCAM_IDPROP_SCAN_MODE", "R/W, mode,	'SENSOR MODE'"),
	4194848: ("DCAM_IDPROP_SLITSCAN_HEIGHT", "*/	/* reserved"),
	4329488: ("DCAM_IDPROP_FRAME_BUNDLEMODE", "R/W, mode,	'FRAMEBUNDLE MODE'"),
	4329504: ("DCAM_IDPROP_FRAME_BUNDLENUMBER", "R/W, long,	'FRAMEBUNDLE NUMBER'"),
	4329520: ("DCAM_IDPROP_FRAME_BUNDLEROWBYTES", "R/O,	long,	'FRAMEBUNDLE ROWBYTES'"),
	4325840: ("DCAM_IDPROP_ACTIVE_VIEW", "R/W, mode,	'ACTIVE VIEW INDEX'"),
	4325840: ("DCAM_IDPROP_ACTIVE_VIEWINDEXES", "R/W, mode,	'ACTIVE VIEW INDEX'"),
	2031904: ("DCAM_IDPROP_SYNCMULTIVIEWREADOUT", "R/W, mode,	'SYNCHRONOUS MULTI VIEW EXPOSURE'"),
	4206640: ("DCAM_IDPROP_SYNC_MINTRIGGERBLANKING", "R/O, sec,	'TIMING MINIMUM TRIGGER BLANKING'"),
	4208672: ("DCAM_IDPROP_SYNC_FRAMEINTERVAL", "R/W, sec,	'INTERNAL FRAME INTERVAL'"),
	2097904: ("DCAM_IDPROP_LOWLIGHTSENSITIVITY", "R/W, mode,	'PHOTON IMAGING MODE'"),
	3670608: ("DCAM_IDPROP_DARKCALIB_MAXIMUMINTENSITY", "R/W, long,	'DARKCALIB STABLE MAX INTENSITY'"),
	3670992: ("DCAM_IDPROP_SUBTRACT_SAMPLINGCOUNT", "R/W, long,	'DARKCALIB SAMPLES'"),
	3670880: ("DCAM_IDPROP_SHADINGCALIB_MINIMUMINTENSITY", "R/W, long,	'SHADING CALIB STABLE MIN INTENSITY'"),
	3670912: ("DCAM_IDPROP_SHADINGCALIB_STABLEFRAMECOUNT", "R/W, long,	'SHADING CALIB STABLE SAMPLES'"),
	3670928: ("DCAM_IDPROP_SHADINGCALIB_INTENSITYMAXIMUMERRORPERCENTAGE", "R/W, long,	'SHADING CALIB STABLE MAX ERROR PERCENT'"),
	3670896: ("DCAM_IDPROP_SHADINGCALIB_AVERAGEFRAMECOUNT", "R/W, long,	'SHADING CALIB SAMPLES'"),
}