'''OpenGL extension NV.primitive_shading_rate

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.primitive_shading_rate to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension builds on top of the NV_shading_rate_image extension to
	provide OpenGL API support for using a per-primitive shading rate value to
	control the computation of the rate used to process each fragment.
	
	In the NV_shading_rate_image extension, the shading rate for each fragment
	produced by a primitive is determined by looking up a texel in the bound
	shading rate image and using that value as an index into a shading rate
	palette.  That extension provides a separate shading rate image lookup
	enable and palette for each viewport.  When a primitive is rasterized, the
	implementation uses the enable and palette associated with the primitive's
	viewport to determine the shading rate.
	
	This extension decouples the shading rate image enables and palettes from
	viewports.  The number of enables/palettes now comes from the
	implementation-dependent constant SHADING_RATE_IMAGE_PALETTE_COUNT_NV.  When
	SHADING_RATE_IMAGE_PER_PRIMITIVE_NV (added here) is enabled, the value of
	the new gl_ShadingRateNV built-in output is used to select an enable and
	palette to determine the shading rate.  Otherwise, the viewport number for
	the primitive is used, as in NV_shading_rate_image.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/primitive_shading_rate.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.primitive_shading_rate import *
from OpenGL.raw.GLES2.NV.primitive_shading_rate import _EXTENSION_NAME

def glInitPrimitiveShadingRateNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION