/* SPDX-License-Identifier: GPL-2.0+
 *
 * Copyright (C) 2016  Nexell Co., Ltd.
 *
 * Author: junghyun, kim <jhkim@nexell.co.kr>
 */

#ifndef _S5PXX18_SOC_HDMI_H_
#define _S5PXX18_SOC_HDMI_H_

#include "s5pxx18_soc_disptop.h"

#define PHY_BASEADDR_HDMI_PHY_MODULE	0xc00f0000
#define PHY_BASEADDR_HDMI_LIST	\
		{ PHY_BASEADDR_HDMI_MODULE }

#define HDMI_LINK_INTC_CON_0		(HDMI_ADDR_OFFSET + 0x00000000)
#define HDMI_LINK_INTC_FLAG_0		(HDMI_ADDR_OFFSET + 0x00000004)
#define HDMI_LINK_AESKEY_VALID		(HDMI_ADDR_OFFSET + 0x00000008)
#define HDMI_LINK_HPD				(HDMI_ADDR_OFFSET + 0x0000000C)
#define HDMI_LINK_INTC_CON_1		(HDMI_ADDR_OFFSET + 0x00000010)
#define HDMI_LINK_INTC_FLAG_1		(HDMI_ADDR_OFFSET + 0x00000014)
#define HDMI_LINK_PHY_STATUS_0		(HDMI_ADDR_OFFSET + 0x00000020)
#define HDMI_LINK_PHY_STATUS_CMU	(HDMI_ADDR_OFFSET + 0x00000024)
#define HDMI_LINK_PHY_STATUS_PLL	(HDMI_ADDR_OFFSET + 0x00000028)
#define HDMI_LINK_PHY_CON_0			(HDMI_ADDR_OFFSET + 0x00000030)
#define HDMI_LINK_HPD_CTRL			(HDMI_ADDR_OFFSET + 0x00000040)
#define HDMI_LINK_HPD_STATUS		(HDMI_ADDR_OFFSET + 0x00000044)
#define HDMI_LINK_HPD_TH_x			(HDMI_ADDR_OFFSET + 0x00000050)

#define HDMI_LINK_HDMI_CON_0		(HDMI_ADDR_OFFSET + 0x00010000)
#define HDMI_LINK_HDMI_CON_1		(HDMI_ADDR_OFFSET + 0x00010004)
#define HDMI_LINK_HDMI_CON_2		(HDMI_ADDR_OFFSET + 0x00010008)
#define HDMI_LINK_STATUS			(HDMI_ADDR_OFFSET + 0x00010010)
#define HDMI_LINK_STATUS_EN			(HDMI_ADDR_OFFSET + 0x00010020)

#define HDMI_LINK_HDCP_SHA1_REN0	(HDMI_ADDR_OFFSET + 0x00010024)
#define HDMI_LINK_HDCP_SHA1_REN1	(HDMI_ADDR_OFFSET + 0x00010028)

#define HDMI_LINK_MODE_SEL			(HDMI_ADDR_OFFSET + 0x00010040)
#define HDMI_LINK_ENC_EN			(HDMI_ADDR_OFFSET + 0x00010044)
#define HDMI_LINK_HDMI_YMAX			(HDMI_ADDR_OFFSET + 0x00010060)
#define HDMI_LINK_HDMI_YMIN			(HDMI_ADDR_OFFSET + 0x00010064)
#define HDMI_LINK_HDMI_CMAX			(HDMI_ADDR_OFFSET + 0x00010068)
#define HDMI_LINK_HDMI_CMIN			(HDMI_ADDR_OFFSET + 0x0001006C)
#define HDMI_LINK_H_BLANK_0			(HDMI_ADDR_OFFSET + 0x000100A0)
#define HDMI_LINK_H_BLANK_1			(HDMI_ADDR_OFFSET + 0x000100A4)
#define HDMI_LINK_V2_BLANK_0		(HDMI_ADDR_OFFSET + 0x000100B0)
#define HDMI_LINK_V2_BLANK_1		(HDMI_ADDR_OFFSET + 0x000100B4)
#define HDMI_LINK_V1_BLANK_0		(HDMI_ADDR_OFFSET + 0x000100B8)
#define HDMI_LINK_V1_BLANK_1		(HDMI_ADDR_OFFSET + 0x000100BC)
#define HDMI_LINK_V_LINE_0			(HDMI_ADDR_OFFSET + 0x000100C0)
#define HDMI_LINK_V_LINE_1			(HDMI_ADDR_OFFSET + 0x000100C4)
#define HDMI_LINK_H_LINE_0			(HDMI_ADDR_OFFSET + 0x000100C8)
#define HDMI_LINK_H_LINE_1			(HDMI_ADDR_OFFSET + 0x000100CC)
#define HDMI_LINK_HSYNC_POL			(HDMI_ADDR_OFFSET + 0x000100E0)
#define HDMI_LINK_VSYNC_POL			(HDMI_ADDR_OFFSET + 0x000100E4)
#define HDMI_LINK_INT_PRO_MODE		(HDMI_ADDR_OFFSET + 0x000100E8)
#define HDMI_LINK_SEND_START_0		(HDMI_ADDR_OFFSET + 0x000100F0)
#define HDMI_LINK_SEND_START_1		(HDMI_ADDR_OFFSET + 0x000100F4)
#define HDMI_LINK_SEND_END_0		(HDMI_ADDR_OFFSET + 0x00010100)
#define HDMI_LINK_SEND_END_1		(HDMI_ADDR_OFFSET + 0x00010104)
#define HDMI_LINK_SEND_END_2		(HDMI_ADDR_OFFSET + 0x00010108)
#define HDMI_LINK_V_BLANK_F0_0		(HDMI_ADDR_OFFSET + 0x00010110)
#define HDMI_LINK_V_BLANK_F0_1		(HDMI_ADDR_OFFSET + 0x00010114)
#define HDMI_LINK_V_BLANK_F1_0		(HDMI_ADDR_OFFSET + 0x00010118)
#define HDMI_LINK_V_BLANK_F1_1		(HDMI_ADDR_OFFSET + 0x0001011C)
#define HDMI_LINK_H_SYNC_START_0	(HDMI_ADDR_OFFSET + 0x00010120)
#define HDMI_LINK_H_SYNC_START_1	(HDMI_ADDR_OFFSET + 0x00010124)
#define HDMI_LINK_H_SYNC_END_0		(HDMI_ADDR_OFFSET + 0x00010128)
#define HDMI_LINK_H_SYNC_END_1		(HDMI_ADDR_OFFSET + 0x0001012C)
#define HDMI_LINK_V_SYNC_LINE_BEF_2_0	(HDMI_ADDR_OFFSET + 0x00010130)
#define HDMI_LINK_V_SYNC_LINE_BEF_2_1	(HDMI_ADDR_OFFSET + 0x00010134)
#define HDMI_LINK_V_SYNC_LINE_BEF_1_0		(HDMI_ADDR_OFFSET + 0x00010138)
#define HDMI_LINK_V_SYNC_LINE_BEF_1_1		(HDMI_ADDR_OFFSET + 0x0001013C)
#define HDMI_LINK_V_SYNC_LINE_AFT_2_0		(HDMI_ADDR_OFFSET + 0x00010140)
#define HDMI_LINK_V_SYNC_LINE_AFT_2_1		(HDMI_ADDR_OFFSET + 0x00010144)
#define HDMI_LINK_V_SYNC_LINE_AFT_1_0		(HDMI_ADDR_OFFSET + 0x00010148)
#define HDMI_LINK_V_SYNC_LINE_AFT_1_1		(HDMI_ADDR_OFFSET + 0x0001014C)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_2_0	(HDMI_ADDR_OFFSET + 0x00010150)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_2_1	(HDMI_ADDR_OFFSET + 0x00010154)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_1_0	(HDMI_ADDR_OFFSET + 0x00010158)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_1_1	(HDMI_ADDR_OFFSET + 0x0001015C)
#define HDMI_LINK_V_BLANK_F2_0		(HDMI_ADDR_OFFSET + 0x00010160)
#define HDMI_LINK_V_BLANK_F2_1		(HDMI_ADDR_OFFSET + 0x00010164)
#define HDMI_LINK_V_BLANK_F3_0		(HDMI_ADDR_OFFSET + 0x00010168)
#define HDMI_LINK_V_BLANK_F3_1		(HDMI_ADDR_OFFSET + 0x0001016C)
#define HDMI_LINK_V_BLANK_F4_0		(HDMI_ADDR_OFFSET + 0x00010170)
#define HDMI_LINK_V_BLANK_F4_1		(HDMI_ADDR_OFFSET + 0x00010174)
#define HDMI_LINK_V_BLANK_F5_0		(HDMI_ADDR_OFFSET + 0x00010178)
#define HDMI_LINK_V_BLANK_F5_1		(HDMI_ADDR_OFFSET + 0x0001017C)
#define HDMI_LINK_V_SYNC_LINE_AFT_3_0		(HDMI_ADDR_OFFSET + 0x00010180)
#define HDMI_LINK_V_SYNC_LINE_AFT_3_1		(HDMI_ADDR_OFFSET + 0x00010184)
#define HDMI_LINK_V_SYNC_LINE_AFT_4_0		(HDMI_ADDR_OFFSET + 0x00010188)
#define HDMI_LINK_V_SYNC_LINE_AFT_4_1		(HDMI_ADDR_OFFSET + 0x0001018C)
#define HDMI_LINK_V_SYNC_LINE_AFT_5_0		(HDMI_ADDR_OFFSET + 0x00010190)
#define HDMI_LINK_V_SYNC_LINE_AFT_5_1		(HDMI_ADDR_OFFSET + 0x00010194)
#define HDMI_LINK_V_SYNC_LINE_AFT_6_0		(HDMI_ADDR_OFFSET + 0x00010198)
#define HDMI_LINK_V_SYNC_LINE_AFT_6_1		(HDMI_ADDR_OFFSET + 0x0001019C)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_3_0	(HDMI_ADDR_OFFSET + 0x000101A0)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_3_1	(HDMI_ADDR_OFFSET + 0x000101A4)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_4_0	(HDMI_ADDR_OFFSET + 0x000101A8)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_4_1	(HDMI_ADDR_OFFSET + 0x000101AC)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_5_0	(HDMI_ADDR_OFFSET + 0x000101B0)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_5_1	(HDMI_ADDR_OFFSET + 0x000101B4)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_6_0	(HDMI_ADDR_OFFSET + 0x000101B8)
#define HDMI_LINK_V_SYNC_LINE_AFT_PXL_6_1	(HDMI_ADDR_OFFSET + 0x000101BC)
#define HDMI_LINK_VACT_SPACE1_0		(HDMI_ADDR_OFFSET + 0x000101C0)
#define HDMI_LINK_VACT_SPACE1_1		(HDMI_ADDR_OFFSET + 0x000101C4)
#define HDMI_LINK_VACT_SPACE2_0		(HDMI_ADDR_OFFSET + 0x000101C8)
#define HDMI_LINK_VACT_SPACE2_1		(HDMI_ADDR_OFFSET + 0x000101CC)
#define HDMI_LINK_VACT_SPACE3_0		(HDMI_ADDR_OFFSET + 0x000101D0)
#define HDMI_LINK_VACT_SPACE3_1		(HDMI_ADDR_OFFSET + 0x000101D4)
#define HDMI_LINK_VACT_SPACE4_0		(HDMI_ADDR_OFFSET + 0x000101D8)
#define HDMI_LINK_VACT_SPACE4_1		(HDMI_ADDR_OFFSET + 0x000101DC)
#define HDMI_LINK_VACT_SPACE5_0		(HDMI_ADDR_OFFSET + 0x000101E0)
#define HDMI_LINK_VACT_SPACE5_1		(HDMI_ADDR_OFFSET + 0x000101E4)
#define HDMI_LINK_VACT_SPACE6_0		(HDMI_ADDR_OFFSET + 0x000101E8)
#define HDMI_LINK_VACT_SPACE6_1		(HDMI_ADDR_OFFSET + 0x000101EC)

#define HDMI_LINK_CSC_MUX		(HDMI_ADDR_OFFSET + 0x000101F0)
#define HDMI_LINK_SYNC_GEN_MUX	(HDMI_ADDR_OFFSET + 0x000101F4)

#define HDMI_LINK_GCP_CON			(HDMI_ADDR_OFFSET + 0x00010200)
#define HDMI_LINK_GCP_BYTE1			(HDMI_ADDR_OFFSET + 0x00010210)
#define HDMI_LINK_GCP_BYTE2			(HDMI_ADDR_OFFSET + 0x00010214)
#define HDMI_LINK_GCP_BYTE3			(HDMI_ADDR_OFFSET + 0x00010218)
#define HDMI_LINK_ASP_CON			(HDMI_ADDR_OFFSET + 0x00010300)
#define HDMI_LINK_ASP_SP_FLAT		(HDMI_ADDR_OFFSET + 0x00010304)
#define HDMI_LINK_ASP_CHCFG0		(HDMI_ADDR_OFFSET + 0x00010310)
#define HDMI_LINK_ASP_CHCFG1		(HDMI_ADDR_OFFSET + 0x00010314)
#define HDMI_LINK_ASP_CHCFG2		(HDMI_ADDR_OFFSET + 0x00010318)
#define HDMI_LINK_ASP_CHCFG3		(HDMI_ADDR_OFFSET + 0x0001031C)
#define HDMI_LINK_ACR_CON			(HDMI_ADDR_OFFSET + 0x00010400)
#define HDMI_LINK_ACR_MCTS0			(HDMI_ADDR_OFFSET + 0x00010410)
#define HDMI_LINK_ACR_MCTS1			(HDMI_ADDR_OFFSET + 0x00010414)
#define HDMI_LINK_ACR_MCTS2			(HDMI_ADDR_OFFSET + 0x00010418)
#define HDMI_LINK_ACR_N0			(HDMI_ADDR_OFFSET + 0x00010430)
#define HDMI_LINK_ACR_N1			(HDMI_ADDR_OFFSET + 0x00010434)
#define HDMI_LINK_ACR_N2			(HDMI_ADDR_OFFSET + 0x00010438)
#define HDMI_LINK_ACP_CON			(HDMI_ADDR_OFFSET + 0x00010500)
#define HDMI_LINK_ACP_TYPE			(HDMI_ADDR_OFFSET + 0x00010514)
#define HDMI_LINK_ACP_DATAX			(HDMI_ADDR_OFFSET + 0x00010520)
#define HDMI_LINK_ISRC_CON			(HDMI_ADDR_OFFSET + 0x00010600)
#define HDMI_LINK_ISRC1_HEADER1		(HDMI_ADDR_OFFSET + 0x00010614)
#define HDMI_LINK_ISRC1_DATAX		(HDMI_ADDR_OFFSET + 0x00010620)
#define HDMI_LINK_ISRC2_DATAX		(HDMI_ADDR_OFFSET + 0x000106A0)
#define HDMI_LINK_AVI_CON			(HDMI_ADDR_OFFSET + 0x00010700)
#define HDMI_LINK_AVI_HEADER0		(HDMI_ADDR_OFFSET + 0x00010710)
#define HDMI_LINK_AVI_HEADER1		(HDMI_ADDR_OFFSET + 0x00010714)
#define HDMI_LINK_AVI_HEADER2		(HDMI_ADDR_OFFSET + 0x00010718)
#define HDMI_LINK_AVI_CHECK_SUM		(HDMI_ADDR_OFFSET + 0x0001071C)
#define HDMI_LINK_AVI_BYTEX			(HDMI_ADDR_OFFSET + 0x00010720)
#define HDMI_LINK_AVI_BYTE00		(HDMI_ADDR_OFFSET + 0x00010720)
#define HDMI_LINK_AVI_BYTE01		(HDMI_ADDR_OFFSET + 0x00010724)
#define HDMI_LINK_AVI_BYTE02		(HDMI_ADDR_OFFSET + 0x00010728)
#define HDMI_LINK_AVI_BYTE03		(HDMI_ADDR_OFFSET + 0x0001073C)
#define HDMI_LINK_AVI_BYTE04		(HDMI_ADDR_OFFSET + 0x00010730)
#define HDMI_LINK_AVI_BYTE05		(HDMI_ADDR_OFFSET + 0x00010734)
#define HDMI_LINK_AVI_BYTE06		(HDMI_ADDR_OFFSET + 0x00010738)
#define HDMI_LINK_AVI_BYTE07		(HDMI_ADDR_OFFSET + 0x0001074C)
#define HDMI_LINK_AVI_BYTE08		(HDMI_ADDR_OFFSET + 0x00010740)
#define HDMI_LINK_AVI_BYTE09		(HDMI_ADDR_OFFSET + 0x00010744)
#define HDMI_LINK_AVI_BYTE10		(HDMI_ADDR_OFFSET + 0x00010748)
#define HDMI_LINK_AVI_BYTE11		(HDMI_ADDR_OFFSET + 0x0001074C)
#define HDMI_LINK_AVI_BYTE12		(HDMI_ADDR_OFFSET + 0x00010750)
#define HDMI_LINK_AUI_CON			(HDMI_ADDR_OFFSET + 0x00010800)
#define HDMI_LINK_AUI_HEADER0		(HDMI_ADDR_OFFSET + 0x00010810)
#define HDMI_LINK_AUI_HEADER1		(HDMI_ADDR_OFFSET + 0x00010814)
#define HDMI_LINK_AUI_HEADER2		(HDMI_ADDR_OFFSET + 0x00010818)
#define HDMI_LINK_AUI_CHECK_SUM		(HDMI_ADDR_OFFSET + 0x0001081C)
#define HDMI_LINK_AUI_BYTEX			(HDMI_ADDR_OFFSET + 0x00010820)
#define HDMI_LINK_MPG_CON			(HDMI_ADDR_OFFSET + 0x00010900)
#define HDMI_LINK_MPG_CHECK_SUM		(HDMI_ADDR_OFFSET + 0x0001091C)
#define HDMI_LINK_MPG_DATAX			(HDMI_ADDR_OFFSET + 0x00010920)
#define HDMI_LINK_SPD_CON			(HDMI_ADDR_OFFSET + 0x00010A00)
#define HDMI_LINK_SPD_HEADER0		(HDMI_ADDR_OFFSET + 0x00010A10)
#define HDMI_LINK_SPD_HEADER1		(HDMI_ADDR_OFFSET + 0x00010A14)
#define HDMI_LINK_SPD_HEADER2		(HDMI_ADDR_OFFSET + 0x00010A18)
#define HDMI_LINK_SPD_DATAX			(HDMI_ADDR_OFFSET + 0x00010A20)
#define HDMI_LINK_GAMUT_CON			(HDMI_ADDR_OFFSET + 0x00010B00)
#define HDMI_LINK_GAMUT_HEADER0		(HDMI_ADDR_OFFSET + 0x00010B10)
#define HDMI_LINK_GAMUT_HEADER1		(HDMI_ADDR_OFFSET + 0x00010B14)
#define HDMI_LINK_GAMUT_HEADER2		(HDMI_ADDR_OFFSET + 0x00010B18)
#define HDMI_LINK_GAMUT_METADATAX	(HDMI_ADDR_OFFSET + 0x00010B20)
#define HDMI_LINK_VSI_CON			(HDMI_ADDR_OFFSET + 0x00010C00)
#define HDMI_LINK_VSI_HEADER0		(HDMI_ADDR_OFFSET + 0x00010C10)
#define HDMI_LINK_VSI_HEADER1		(HDMI_ADDR_OFFSET + 0x00010C14)
#define HDMI_LINK_VSI_HEADER2		(HDMI_ADDR_OFFSET + 0x00010C18)
#define HDMI_LINK_VSI_DATAX			(HDMI_ADDR_OFFSET + 0x00010C20)
#define HDMI_LINK_VSI_DATA00		(HDMI_ADDR_OFFSET + 0x00010C20)
#define HDMI_LINK_VSI_DATA01		(HDMI_ADDR_OFFSET + 0x00010C24)
#define HDMI_LINK_VSI_DATA02		(HDMI_ADDR_OFFSET + 0x00010C28)
#define HDMI_LINK_VSI_DATA03		(HDMI_ADDR_OFFSET + 0x00010C2C)
#define HDMI_LINK_VSI_DATA04		(HDMI_ADDR_OFFSET + 0x00010C30)
#define HDMI_LINK_VSI_DATA05		(HDMI_ADDR_OFFSET + 0x00010C34)
#define HDMI_LINK_VSI_DATA06		(HDMI_ADDR_OFFSET + 0x00010C38)
#define HDMI_LINK_VSI_DATA07		(HDMI_ADDR_OFFSET + 0x00010C3C)
#define HDMI_LINK_VSI_DATA08		(HDMI_ADDR_OFFSET + 0x00010C40)
#define HDMI_LINK_VSI_DATA09		(HDMI_ADDR_OFFSET + 0x00010C44)
#define HDMI_LINK_VSI_DATA10		(HDMI_ADDR_OFFSET + 0x00010C48)
#define HDMI_LINK_VSI_DATA11		(HDMI_ADDR_OFFSET + 0x00010c4c)
#define HDMI_LINK_VSI_DATA12		(HDMI_ADDR_OFFSET + 0x00010C50)
#define HDMI_LINK_VSI_DATA13		(HDMI_ADDR_OFFSET + 0x00010C54)
#define HDMI_LINK_VSI_DATA14		(HDMI_ADDR_OFFSET + 0x00010C58)
#define HDMI_LINK_VSI_DATA15		(HDMI_ADDR_OFFSET + 0x00010C5c)
#define HDMI_LINK_VSI_DATA16		(HDMI_ADDR_OFFSET + 0x00010C60)
#define HDMI_LINK_VSI_DATA17		(HDMI_ADDR_OFFSET + 0x00010C64)
#define HDMI_LINK_VSI_DATA18		(HDMI_ADDR_OFFSET + 0x00010C68)
#define HDMI_LINK_VSI_DATA19		(HDMI_ADDR_OFFSET + 0x00010C6c)
#define HDMI_LINK_VSI_DATA20		(HDMI_ADDR_OFFSET + 0x00010C70)
#define HDMI_LINK_VSI_DATA21		(HDMI_ADDR_OFFSET + 0x00010c74)
#define HDMI_LINK_VSI_DATA22		(HDMI_ADDR_OFFSET + 0x00010C78)
#define HDMI_LINK_VSI_DATA23		(HDMI_ADDR_OFFSET + 0x00010C7c)
#define HDMI_LINK_VSI_DATA24		(HDMI_ADDR_OFFSET + 0x00010C80)
#define HDMI_LINK_VSI_DATA25		(HDMI_ADDR_OFFSET + 0x00010C84)
#define HDMI_LINK_VSI_DATA26		(HDMI_ADDR_OFFSET + 0x00010C88)
#define HDMI_LINK_VSI_DATA27		(HDMI_ADDR_OFFSET + 0x00010C8C)
#define HDMI_LINK_DC_CONTROL		(HDMI_ADDR_OFFSET + 0x00010D00)
#define HDMI_LINK_VIDEO_PATTERN_GEN	(HDMI_ADDR_OFFSET + 0x00010D04)
#define HDMI_LINK_AN_SEED_SEL		(HDMI_ADDR_OFFSET + 0x00010E48)
#define HDMI_LINK_AN_SEED_0			(HDMI_ADDR_OFFSET + 0x00010E58)
#define HDMI_LINK_AN_SEED_1			(HDMI_ADDR_OFFSET + 0x00010E5C)
#define HDMI_LINK_AN_SEED_2			(HDMI_ADDR_OFFSET + 0x00010E60)
#define HDMI_LINK_AN_SEED_3			(HDMI_ADDR_OFFSET + 0x00010E64)
#define HDMI_LINK_HDCP_SHA1_X		(HDMI_ADDR_OFFSET + 0x00017000)

#define HDMI_LINK_HDCP_SHA1_0_0	(HDMI_LINK_HDCP_SHA1_x   + 0x00)
#define HDMI_LINK_HDCP_SHA1_0_1	(HDMI_LINK_HDCP_SHA1_0_0 + 0x04)
#define HDMI_LINK_HDCP_SHA1_0_2	(HDMI_LINK_HDCP_SHA1_0_0 + 0x08)
#define HDMI_LINK_HDCP_SHA1_0_3	(HDMI_LINK_HDCP_SHA1_0_0 + 0x0C)
#define HDMI_LINK_HDCP_SHA1_1_0	(HDMI_LINK_HDCP_SHA1_x   + 0x10)
#define HDMI_LINK_HDCP_SHA1_1_1	(HDMI_LINK_HDCP_SHA1_1_0 + 0x04)
#define HDMI_LINK_HDCP_SHA1_1_2	(HDMI_LINK_HDCP_SHA1_1_0 + 0x08)
#define HDMI_LINK_HDCP_SHA1_1_3	(HDMI_LINK_HDCP_SHA1_1_0 + 0x0C)
#define HDMI_LINK_HDCP_SHA1_2_0	(HDMI_LINK_HDCP_SHA1_x   + 0x20)
#define HDMI_LINK_HDCP_SHA1_2_1	(HDMI_LINK_HDCP_SHA1_2_0 + 0x04)
#define HDMI_LINK_HDCP_SHA1_2_2	(HDMI_LINK_HDCP_SHA1_2_0 + 0x08)
#define HDMI_LINK_HDCP_SHA1_2_3	(HDMI_LINK_HDCP_SHA1_2_0 + 0x0C)
#define HDMI_LINK_HDCP_SHA1_3_0	(HDMI_LINK_HDCP_SHA1_x   + 0x30)
#define HDMI_LINK_HDCP_SHA1_3_1	(HDMI_LINK_HDCP_SHA1_3_0 + 0x04)
#define HDMI_LINK_HDCP_SHA1_3_2	(HDMI_LINK_HDCP_SHA1_3_0 + 0x08)
#define HDMI_LINK_HDCP_SHA1_3_3	(HDMI_LINK_HDCP_SHA1_3_0 + 0x0C)
#define HDMI_LINK_HDCP_SHA1_4_0	(HDMI_LINK_HDCP_SHA1_x   + 0x40)
#define HDMI_LINK_HDCP_SHA1_4_1	(HDMI_LINK_HDCP_SHA1_4_0 + 0x04)
#define HDMI_LINK_HDCP_SHA1_4_2	(HDMI_LINK_HDCP_SHA1_4_0 + 0x08)
#define HDMI_LINK_HDCP_SHA1_4_3	(HDMI_LINK_HDCP_SHA1_4_0 + 0x0C)

#define HDMI_LINK_HDCP_KSV_LIST_X	(HDMI_ADDR_OFFSET + 0x00017050)

#define HDMI_LINK_HDCP_KSV_0_0	(HDMI_LINK_HDCP_KSV_LIST_X + 0x00)
#define HDMI_LINK_HDCP_KSV_0_1	(HDMI_LINK_HDCP_KSV_LIST_X + 0x04)
#define HDMI_LINK_HDCP_KSV_0_2	(HDMI_LINK_HDCP_KSV_LIST_X + 0x08)
#define HDMI_LINK_HDCP_KSV_0_3	(HDMI_LINK_HDCP_KSV_LIST_X + 0x0C)
#define HDMI_LINK_HDCP_KSV_1_0	(HDMI_LINK_HDCP_KSV_LIST_X + 0x10)
#define HDMI_LINK_HDCP_KSV_1_1	(HDMI_LINK_HDCP_KSV_LIST_X + 0x14)

#define HDMI_LINK_HDCP_KSV_LIST_0_0	(HDMI_LINK_HDCP_KSV_LIST_X + 0x00)
#define HDMI_LINK_HDCP_KSV_LIST_0_1	(HDMI_LINK_HDCP_KSV_LIST_X + 0x04)
#define HDMI_LINK_HDCP_KSV_LIST_0_2	(HDMI_LINK_HDCP_KSV_LIST_X + 0x08)
#define HDMI_LINK_HDCP_KSV_LIST_0_3	(HDMI_LINK_HDCP_KSV_LIST_X + 0x0C)
#define HDMI_LINK_HDCP_KSV_LIST_1_0	(HDMI_LINK_HDCP_KSV_LIST_X + 0x10)
#define HDMI_LINK_HDCP_KSV_LIST_1_1	(HDMI_LINK_HDCP_KSV_LIST_X + 0x14)

#define HDMI_LINK_HDCP_KSV_LIST_CON	(HDMI_ADDR_OFFSET + 0x00017064)
#define HDMI_LINK_HDCP_SHA_RESULT	(HDMI_ADDR_OFFSET + 0x00017070)
#define HDMI_LINK_HDCP_CTRL1		(HDMI_ADDR_OFFSET + 0x00017080)
#define HDMI_LINK_HDCP_CTRL2		(HDMI_ADDR_OFFSET + 0x00017084)
#define HDMI_LINK_HDCP_CHECK_RESULT	(HDMI_ADDR_OFFSET + 0x00017090)
#define HDMI_LINK_HDCP_BKSV_X	(HDMI_ADDR_OFFSET + 0x000170A0)

#define HDMI_LINK_HDCP_BKSV0_0	(HDMI_ADDR_OFFSET + 0x000170A0)
#define HDMI_LINK_HDCP_BKSV0_1	(HDMI_ADDR_OFFSET + 0x000170A4)
#define HDMI_LINK_HDCP_BKSV0_2	(HDMI_ADDR_OFFSET + 0x000170A8)
#define HDMI_LINK_HDCP_BKSV0_3	(HDMI_ADDR_OFFSET + 0x000170AC)
#define HDMI_LINK_HDCP_BKSV1	(HDMI_ADDR_OFFSET + 0x000170B0)

#define HDMI_LINK_HDCP_AKSV_X		(HDMI_ADDR_OFFSET + 0x000170C0)
#define HDMI_LINK_HDCP_AN_X			(HDMI_ADDR_OFFSET + 0x000170E0)
#define HDMI_LINK_HDCP_BCAPS		(HDMI_ADDR_OFFSET + 0x00017100)
#define HDMI_LINK_HDCP_BSTATUS_0	(HDMI_ADDR_OFFSET + 0x00017110)
#define HDMI_LINK_HDCP_BSTATUS_1	(HDMI_ADDR_OFFSET + 0x00017114)
#define HDMI_LINK_HDCP_RI_0			(HDMI_ADDR_OFFSET + 0x00017140)
#define HDMI_LINK_HDCP_RI_1			(HDMI_ADDR_OFFSET + 0x00017144)

#define HDMI_LINK_HDCP_OFFSET_TX_0	(HDMI_ADDR_OFFSET + 0x00017160)
#define HDMI_LINK_HDCP_OFFSET_TX_1	(HDMI_ADDR_OFFSET + 0x00017164)
#define HDMI_LINK_HDCP_OFFSET_TX_2	(HDMI_ADDR_OFFSET + 0x00017168)
#define HDMI_LINK_HDCP_OFFSET_TX_3	(HDMI_ADDR_OFFSET + 0x0001716C)
#define HDMI_LINK_HDCP_CYCLE_AA		(HDMI_ADDR_OFFSET + 0x00017170)

#define HDMI_LINK_HDCP_I2C_INT		(HDMI_ADDR_OFFSET + 0x00017180)
#define HDMI_LINK_HDCP_AN_INT		(HDMI_ADDR_OFFSET + 0x00017190)
#define HDMI_LINK_HDCP_WATCHDOG_INT	(HDMI_ADDR_OFFSET + 0x000171A0)
#define HDMI_LINK_HDCP_RI_INT		(HDMI_ADDR_OFFSET + 0x000171B0)
#define HDMI_LINK_HDCP_RI_COMPARE_0	(HDMI_ADDR_OFFSET + 0x000171D0)
#define HDMI_LINK_HDCP_RI_COMPARE_1	(HDMI_ADDR_OFFSET + 0x000171D4)

#define HDMI_LINK_HDCP_RI_INT		(HDMI_ADDR_OFFSET + 0x000171B0)
#define HDMI_LINK_HDCP_RI_COMPARE_0	(HDMI_ADDR_OFFSET + 0x000171D0)
#define HDMI_LINK_HDCP_RI_COMPARE_1	(HDMI_ADDR_OFFSET + 0x000171D4)

#define HDMI_LINK_HDCP_FRAME_COUNT	(HDMI_ADDR_OFFSET + 0x000171E0)
#define HDMI_LINK_RGB_ROUND_EN		(HDMI_ADDR_OFFSET + 0x0001D500)
#define HDMI_LINK_VACT_SPACE_R_0	(HDMI_ADDR_OFFSET + 0x0001D504)
#define HDMI_LINK_VACT_SPACE_R_1	(HDMI_ADDR_OFFSET + 0x0001D508)
#define HDMI_LINK_VACT_SPACE_G_0	(HDMI_ADDR_OFFSET + 0x0001D50C)
#define HDMI_LINK_VACT_SPACE_G_1	(HDMI_ADDR_OFFSET + 0x0001D510)
#define HDMI_LINK_VACT_SPACE_B_0	(HDMI_ADDR_OFFSET + 0x0001D514)
#define HDMI_LINK_VACT_SPACE_B_1	(HDMI_ADDR_OFFSET + 0x0001D518)
#define HDMI_LINK_BLUE_SCREEN_R_0	(HDMI_ADDR_OFFSET + 0x0001D520)
#define HDMI_LINK_BLUE_SCREEN_R_1	(HDMI_ADDR_OFFSET + 0x0001D524)
#define HDMI_LINK_BLUE_SCREEN_G_0	(HDMI_ADDR_OFFSET + 0x0001D528)
#define HDMI_LINK_BLUE_SCREEN_G_1	(HDMI_ADDR_OFFSET + 0x0001D52C)
#define HDMI_LINK_BLUE_SCREEN_B_0	(HDMI_ADDR_OFFSET + 0x0001D530)
#define HDMI_LINK_BLUE_SCREEN_B_1	(HDMI_ADDR_OFFSET + 0x0001D534)
#define HDMI_LINK_AES_START			(HDMI_ADDR_OFFSET +  0x00020000)
#define HDMI_LINK_AES_DATA_SIZE_L	(HDMI_ADDR_OFFSET +  0x00020020)
#define HDMI_LINK_AES_DATA_SIZE_H	(HDMI_ADDR_OFFSET +  0x00020024)
#define HDMI_LINK_AES_DATA			(HDMI_ADDR_OFFSET +  0x00020040)
#define HDMI_LINK_SPDIFIN_CLK_CTRL	(HDMI_ADDR_OFFSET + 0x00030000)
#define HDMI_LINK_SPDIFIN_OP_CTRL          (HDMI_ADDR_OFFSET + 0x00030004)
#define HDMI_LINK_SPDIFIN_IRQ_MASK         (HDMI_ADDR_OFFSET + 0x00030008)
#define HDMI_LINK_SPDIFIN_IRQ_STATUS       (HDMI_ADDR_OFFSET + 0x0003000C)
#define HDMI_LINK_SPDIFIN_CONFIG_1         (HDMI_ADDR_OFFSET + 0x00030010)
#define HDMI_LINK_SPDIFIN_CONFIG_2         (HDMI_ADDR_OFFSET + 0x00030014)
#define HDMI_LINK_SPDIFIN_USER_VALUE_1     (HDMI_ADDR_OFFSET + 0x00030020)
#define HDMI_LINK_SPDIFIN_USER_VALUE_2     (HDMI_ADDR_OFFSET + 0x00030024)
#define HDMI_LINK_SPDIFIN_USER_VALUE_3     (HDMI_ADDR_OFFSET + 0x00030028)
#define HDMI_LINK_SPDIFIN_USER_VALUE_4     (HDMI_ADDR_OFFSET + 0x0003002C)
#define HDMI_LINK_SPDIFIN_CH_STATUS_0_1    (HDMI_ADDR_OFFSET + 0x00030030)
#define HDMI_LINK_SPDIFIN_CH_STATUS_0_2    (HDMI_ADDR_OFFSET + 0x00030034)
#define HDMI_LINK_SPDIFIN_CH_STATUS_0_3    (HDMI_ADDR_OFFSET + 0x00030038)
#define HDMI_LINK_SPDIFIN_CH_STATUS_0_4    (HDMI_ADDR_OFFSET + 0x0003003C)
#define HDMI_LINK_SPDIFIN_CH_STATUS_1      (HDMI_ADDR_OFFSET + 0x00030040)
#define HDMI_LINK_SPDIFIN_FRAME_PERIOD_1   (HDMI_ADDR_OFFSET + 0x00030048)
#define HDMI_LINK_SPDIFIN_FRAME_PERIOD_2   (HDMI_ADDR_OFFSET + 0x0003004C)
#define HDMI_LINK_SPDIFIN_PC_INFO_1        (HDMI_ADDR_OFFSET + 0x00030050)
#define HDMI_LINK_SPDIFIN_PC_INFO_2        (HDMI_ADDR_OFFSET + 0x00030054)
#define HDMI_LINK_SPDIFIN_PD_INFO_1        (HDMI_ADDR_OFFSET + 0x00030058)
#define HDMI_LINK_SPDIFIN_PD_INFO_2        (HDMI_ADDR_OFFSET + 0x0003005C)
#define HDMI_LINK_SPDIFIN_DATA_BUF_0_1     (HDMI_ADDR_OFFSET + 0x00030060)
#define HDMI_LINK_SPDIFIN_DATA_BUF_0_2     (HDMI_ADDR_OFFSET + 0x00030064)
#define HDMI_LINK_SPDIFIN_DATA_BUF_0_3     (HDMI_ADDR_OFFSET + 0x00030068)
#define HDMI_LINK_SPDIFIN_USER_BUF_0       (HDMI_ADDR_OFFSET + 0x0003006C)
#define HDMI_LINK_SPDIFIN_DATA_BUF_1_1     (HDMI_ADDR_OFFSET + 0x00030070)
#define HDMI_LINK_SPDIFIN_DATA_BUF_1_2     (HDMI_ADDR_OFFSET + 0x00030074)
#define HDMI_LINK_SPDIFIN_DATA_BUF_1_3     (HDMI_ADDR_OFFSET + 0x00030078)
#define HDMI_LINK_SPDIFIN_USER_BUF_1       (HDMI_ADDR_OFFSET + 0x0003007C)
#define HDMI_LINK_I2S_CLK_CON         (HDMI_ADDR_OFFSET + 0x00040000)
#define HDMI_LINK_I2S_CON_1           (HDMI_ADDR_OFFSET + 0x00040004)
#define HDMI_LINK_I2S_CON_2           (HDMI_ADDR_OFFSET + 0x00040008)
#define HDMI_LINK_I2S_PIN_SEL_0       (HDMI_ADDR_OFFSET + 0x0004000C)
#define HDMI_LINK_I2S_PIN_SEL_1       (HDMI_ADDR_OFFSET + 0x00040010)
#define HDMI_LINK_I2S_PIN_SEL_2       (HDMI_ADDR_OFFSET + 0x00040014)
#define HDMI_LINK_I2S_PIN_SEL_3       (HDMI_ADDR_OFFSET + 0x00040018)
#define HDMI_LINK_I2S_DSD_CON         (HDMI_ADDR_OFFSET + 0x0004001C)
#define HDMI_LINK_I2S_MUX_CON         (HDMI_ADDR_OFFSET + 0x00040020)
#define HDMI_LINK_I2S_CH_ST_CON       (HDMI_ADDR_OFFSET + 0x00040024)
#define HDMI_LINK_I2S_CH_ST_0         (HDMI_ADDR_OFFSET + 0x00040028)
#define HDMI_LINK_I2S_CH_ST_1         (HDMI_ADDR_OFFSET + 0x0004002C)
#define HDMI_LINK_I2S_CH_ST_2         (HDMI_ADDR_OFFSET + 0x00040030)
#define HDMI_LINK_I2S_CH_ST_3         (HDMI_ADDR_OFFSET + 0x00040034)
#define HDMI_LINK_I2S_CH_ST_4         (HDMI_ADDR_OFFSET + 0x00040038)
#define HDMI_LINK_I2S_CH_ST_SH_0      (HDMI_ADDR_OFFSET + 0x0004003C)
#define HDMI_LINK_I2S_CH_ST_SH_1      (HDMI_ADDR_OFFSET + 0x00040040)
#define HDMI_LINK_I2S_CH_ST_SH_2      (HDMI_ADDR_OFFSET + 0x00040044)
#define HDMI_LINK_I2S_CH_ST_SH_3      (HDMI_ADDR_OFFSET + 0x00040048)
#define HDMI_LINK_I2S_CH_ST_SH_4      (HDMI_ADDR_OFFSET + 0x0004004C)
#define HDMI_LINK_I2S_VD_DATA         (HDMI_ADDR_OFFSET + 0x00040050)
#define HDMI_LINK_I2S_MUX_CH          (HDMI_ADDR_OFFSET + 0x00040054)
#define HDMI_LINK_I2S_MUX_CUV         (HDMI_ADDR_OFFSET + 0x00040058)
#define HDMI_LINK_I2S_CH0_L_0         (HDMI_ADDR_OFFSET + 0x00040064)
#define HDMI_LINK_I2S_CH0_L_1         (HDMI_ADDR_OFFSET + 0x00040068)
#define HDMI_LINK_I2S_CH0_L_2         (HDMI_ADDR_OFFSET + 0x0004006C)
#define HDMI_LINK_I2S_CH0_R_0         (HDMI_ADDR_OFFSET + 0x00040074)
#define HDMI_LINK_I2S_CH0_R_1         (HDMI_ADDR_OFFSET + 0x00040078)
#define HDMI_LINK_I2S_CH0_R_2         (HDMI_ADDR_OFFSET + 0x0004007C)
#define HDMI_LINK_I2S_CH0_R_3         (HDMI_ADDR_OFFSET + 0x00040080)
#define HDMI_LINK_I2S_CH1_L_0         (HDMI_ADDR_OFFSET + 0x00040084)
#define HDMI_LINK_I2S_CH1_L_1         (HDMI_ADDR_OFFSET + 0x00040088)
#define HDMI_LINK_I2S_CH1_L_2         (HDMI_ADDR_OFFSET + 0x0004008C)
#define HDMI_LINK_I2S_CH1_L_3         (HDMI_ADDR_OFFSET + 0x00040090)
#define HDMI_LINK_I2S_CH1_R_0         (HDMI_ADDR_OFFSET + 0x00040094)
#define HDMI_LINK_I2S_CH1_R_1         (HDMI_ADDR_OFFSET + 0x00040098)
#define HDMI_LINK_I2S_CH1_R_2         (HDMI_ADDR_OFFSET + 0x0004009C)
#define HDMI_LINK_I2S_CH1_R_3         (HDMI_ADDR_OFFSET + 0x000400A0)
#define HDMI_LINK_I2S_CH2_L_0         (HDMI_ADDR_OFFSET + 0x000400A4)
#define HDMI_LINK_I2S_CH2_L_1         (HDMI_ADDR_OFFSET + 0x000400A8)
#define HDMI_LINK_I2S_CH2_L_2         (HDMI_ADDR_OFFSET + 0x000400AC)
#define HDMI_LINK_I2S_CH2_L_3         (HDMI_ADDR_OFFSET + 0x000400B0)
#define HDMI_LINK_I2S_CH2_R_0         (HDMI_ADDR_OFFSET + 0x000400B4)
#define HDMI_LINK_I2S_CH2_R_1         (HDMI_ADDR_OFFSET + 0x000400B8)
#define HDMI_LINK_I2S_CH2_R_2         (HDMI_ADDR_OFFSET + 0x000400BC)
#define HDMI_LINK_I2S_CH2_R_3         (HDMI_ADDR_OFFSET + 0x000400C0)
#define HDMI_LINK_I2S_CH3_L_0         (HDMI_ADDR_OFFSET + 0x000400C4)
#define HDMI_LINK_I2S_CH3_L_1         (HDMI_ADDR_OFFSET + 0x000400C8)
#define HDMI_LINK_I2S_CH3_L_2         (HDMI_ADDR_OFFSET + 0x000400CC)
#define HDMI_LINK_I2S_CH3_R_0         (HDMI_ADDR_OFFSET + 0x000400D0)
#define HDMI_LINK_I2S_CH3_R_1         (HDMI_ADDR_OFFSET + 0x000400D4)
#define HDMI_LINK_I2S_CH3_R_2         (HDMI_ADDR_OFFSET + 0x000400D8)
#define HDMI_LINK_I2S_CUV_L_R         (HDMI_ADDR_OFFSET + 0x000400DC)

#define HDMI_CEC_TX_STATUS_0         (OTHER_ADDR_OFFSET + 0x00000000)
#define HDMI_CEC_TX_STATUS_1         (OTHER_ADDR_OFFSET + 0x00000004)
#define HDMI_CEC_RX_STATUS_0         (OTHER_ADDR_OFFSET + 0x00000008)
#define HDMI_CEC_RX_STATUS_1         (OTHER_ADDR_OFFSET + 0x0000000C)
#define HDMI_CEC_INTR_MASK           (OTHER_ADDR_OFFSET + 0x00000010)
#define HDMI_CEC_INTR_CLEAR          (OTHER_ADDR_OFFSET + 0x00000014)
#define HDMI_CEC_LOGIC_ADDR          (OTHER_ADDR_OFFSET + 0x00000020)
#define HDMI_CEC_DIVISOR_0           (OTHER_ADDR_OFFSET + 0x00000030)
#define HDMI_CEC_DIVISOR_1           (OTHER_ADDR_OFFSET + 0x00000034)
#define HDMI_CEC_DIVISOR_2           (OTHER_ADDR_OFFSET + 0x00000038)
#define HDMI_CEC_DIVISOR_3           (OTHER_ADDR_OFFSET + 0x0000003C)
#define HDMI_CEC_TX_CTRL             (OTHER_ADDR_OFFSET + 0x00000040)
#define HDMI_CEC_TX_BYTE_NUM         (OTHER_ADDR_OFFSET + 0x00000044)
#define HDMI_CEC_TX_STATUS_2         (OTHER_ADDR_OFFSET + 0x00000060)
#define HDMI_CEC_TX_STATUS_3         (OTHER_ADDR_OFFSET + 0x00000064)
#define HDMI_CEC_TX_BUFFER_x         (OTHER_ADDR_OFFSET + 0x00000080)
#define HDMI_CEC_TX_BUFFER00         (OTHER_ADDR_OFFSET + 0x00000080)
#define HDMI_CEC_RX_CTRL             (OTHER_ADDR_OFFSET + 0x000000C0)
#define HDMI_CEC_RX_STATUS_2         (OTHER_ADDR_OFFSET + 0x000000E0)
#define HDMI_CEC_RX_STATUS_3         (OTHER_ADDR_OFFSET + 0x000000E4)
#define HDMI_CEC_RX_BUFFER_x         (OTHER_ADDR_OFFSET + 0x00000100)
#define HDMI_CEC_FILTER_CTRL         (OTHER_ADDR_OFFSET + 0x00000180)
#define HDMI_CEC_FILTER_TH           (OTHER_ADDR_OFFSET + 0x00000184)

#ifdef CONFIG_MACH_S5P6818
#define HDMI_PHY_OFFSET             \
	(PHY_BASEADDR_HDMI_PHY_MODULE - PHY_BASEADDR_HDMI_MODULE)
#else
#define HDMI_PHY_OFFSET			0x400
#endif

#define HDMI_PHY_REG00 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000000)
#define HDMI_PHY_REG04 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000004)
#define HDMI_PHY_REG08 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000008)
#define HDMI_PHY_REG0C (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x0000000C)
#define HDMI_PHY_REG10 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000010)
#define HDMI_PHY_REG14 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000014)
#define HDMI_PHY_REG18 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000018)
#define HDMI_PHY_REG1C (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x0000001C)
#define HDMI_PHY_REG20 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000020)
#define HDMI_PHY_REG24 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000024)
#define HDMI_PHY_REG28 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000028)
#define HDMI_PHY_REG2C (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x0000002C)
#define HDMI_PHY_REG30 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000030)
#define HDMI_PHY_REG34 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000034)
#define HDMI_PHY_REG38 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000038)
#define HDMI_PHY_REG3C (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x0000003C)
#define HDMI_PHY_REG40 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000040)
#define HDMI_PHY_REG44 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000044)
#define HDMI_PHY_REG48 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000048)
#define HDMI_PHY_REG4C (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x0000004C)
#define HDMI_PHY_REG50 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000050)
#define HDMI_PHY_REG54 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000054)
#define HDMI_PHY_REG58 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000058)
#define HDMI_PHY_REG5C (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x0000005C)
#define HDMI_PHY_REG60 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000060)
#define HDMI_PHY_REG64 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000064)
#define HDMI_PHY_REG68 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000068)
#define HDMI_PHY_REG6C (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x0000006C)
#define HDMI_PHY_REG70 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000070)
#define HDMI_PHY_REG74 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000074)
#define HDMI_PHY_REG78 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000078)
#define HDMI_PHY_REG7C (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x0000007C)
#define HDMI_PHY_REG80 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000080)
#define HDMI_PHY_REG84 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000084)
#define HDMI_PHY_REG88 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000088)
#define HDMI_PHY_REG8C (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x0000008C)
#define HDMI_PHY_REG90 (OTHER_ADDR_OFFSET + HDMI_PHY_OFFSET + 0x00000090)

enum hdmi_reset {
	i_nRST = 0,
	i_nRST_VIDEO = 1,
	i_nRST_SPDIF = 2,
	i_nRST_TMDS = 3,
	i_nRST_PHY = 4,
};

u32 nx_hdmi_get_reg(u32 module_index, u32 offset);
void nx_hdmi_set_reg(u32 module_index, u32 offset, u32 regvalue);

void nx_hdmi_set_base_address(u32 module_index, void *base_address);
void *nx_hdmi_get_base_address(u32 module_index);
u32 nx_hdmi_get_physical_address(u32 module_index);

#endif
