---
title: "Files.com"
description: "Rclone docs for Files.com"
versionIntroduced: "v1.68"
---

# {{< icon "fa fa-brands fa-files-pinwheel" >}} Files.com

[Files.com](https://www.files.com/) is a cloud storage service that provides a
secure and easy way to store and share files.

The initial setup for filescom involves authenticating with your Files.com
account. You can do this by providing your site subdomain, username, and
password. Alternatively, you can authenticate using an API Key from
[Files.com](https://www.files.com/docs/sdk-and-apis/api-keys/).
`rclone config` walks you through it.

## Configuration

Here is an example of how to make a remote called `remote`.  First run:

    rclone config

This will guide you through an interactive setup process:

    No remotes found, make a new one?
    n) New remote
    s) Set configuration password
    q) Quit config
    n/s/q> n

    Enter name for new remote.
    name> remote

    Option Storage.
    Type of storage to configure.
    Choose a number from below, or type in your own value.
    [snip]
    XX / Files.com
      \ "filescom"
    [snip]
    Storage> filescom

    Option site.
    Your site subdomain (e.g. mysite) or custom domain (e.g. myfiles.customdomain.com)
    Enter a value. Press Enter to leave empty.
    site> mysite

    Option username.
    The username used to authenticate with Files.com.
    Enter a value. Press Enter to leave empty.
    username> user

    Option password.
    The password used to authenticate with Files.com.
    Choose an alternative below. Press Enter for the default (n).
    y) Yes, type in my own password
    g) Generate random password
    n) No, leave this optional password blank (default)
    y/g/n> y
    Enter the password:
    password:
    Confirm the password:
    password:

    Edit advanced config?
    y) Yes
    n) No (default)
    y/n> n

    Configuration complete.
    Options:
    - type: filescom
    - site: mysite
    - username: user
    - password: *** ENCRYPTED ***
    Keep this "remote" remote?
    y) Yes this is OK (default)
    e) Edit this remote
    d) Delete this remote
    y/e/d> y

Once configured you can use rclone.

See all files in the top level:

    rclone lsf remote:

Make a new directory in the root:

    rclone mkdir remote:dir

Recursively List the contents:

    rclone ls remote:

Sync `/home/local/directory` to the remote directory, deleting any
excess files in the directory.

    rclone sync --interactive /home/local/directory remote:dir

### Hashes

In December 2024 `files.com`  started [supporting more checksums](https://www.files.com/blog/2024/11/01/new-modern-checksum-options-now-available-with-opt).

However if you want hashes you **must** enable them in your site by
visiting the "File Integrity" section in "Data Governance" to
configure your settings and select the checksum algorithms that meet
your requirements.

Rclone currently only support CRC32 and MD5 for use in syncing but
selecting more checksums will not affect rclone's operations.

For use with rclone, selecting at least MD5 is recommended so rclone
can do an end to end integrity check.

{{< rem autogenerated options start" - DO NOT EDIT - instead edit fs.RegInfo in backend/filescom/filescom.go then run make backenddocs" >}}
### Standard options

Here are the Standard options specific to filescom (Files.com).

#### --filescom-site

Your site subdomain (e.g. mysite) or custom domain (e.g. myfiles.customdomain.com).

Properties:

- Config:      site
- Env Var:     RCLONE_FILESCOM_SITE
- Type:        string
- Required:    false

#### --filescom-username

The username used to authenticate with Files.com.

Properties:

- Config:      username
- Env Var:     RCLONE_FILESCOM_USERNAME
- Type:        string
- Required:    false

#### --filescom-password

The password used to authenticate with Files.com.

**NB** Input to this must be obscured - see [rclone obscure](/commands/rclone_obscure/).

Properties:

- Config:      password
- Env Var:     RCLONE_FILESCOM_PASSWORD
- Type:        string
- Required:    false

### Advanced options

Here are the Advanced options specific to filescom (Files.com).

#### --filescom-api-key

The API key used to authenticate with Files.com.

Properties:

- Config:      api_key
- Env Var:     RCLONE_FILESCOM_API_KEY
- Type:        string
- Required:    false

#### --filescom-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_FILESCOM_ENCODING
- Type:        Encoding
- Default:     Slash,BackSlash,Del,Ctl,RightSpace,RightCrLfHtVt,InvalidUtf8,Dot

#### --filescom-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_FILESCOM_DESCRIPTION
- Type:        string
- Required:    false

{{< rem autogenerated options stop >}}
