#![allow(
    dead_code,
    non_camel_case_types,
    non_snake_case,
    non_upper_case_globals
)]

// Some manual additions to fix up bindgen output

extern "C" {
    pub static mut mach_task_self_: mach_port_t;
}

/* Code below automatically generated by rust-bindgen 0.66.0 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::core::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::core::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::core::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::core::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::core::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type __int8_t = ::libc::c_schar;
pub type __uint8_t = ::libc::c_uchar;
pub type __int16_t = ::libc::c_short;
pub type __uint16_t = ::libc::c_ushort;
pub type __int32_t = ::libc::c_int;
pub type __uint32_t = ::libc::c_uint;
pub type __int64_t = ::libc::c_longlong;
pub type __uint64_t = ::libc::c_ulonglong;
pub type __darwin_intptr_t = ::libc::c_long;
pub type __darwin_natural_t = ::libc::c_uint;
pub type __darwin_ct_rune_t = ::libc::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::libc::c_char; 128usize],
    pub _mbstateL: ::libc::c_longlong,
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    const UNINIT: ::core::mem::MaybeUninit<__mbstate_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__mbstate_t>(),
        128usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__mbstate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__mbstate8) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__mbstate8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr)._mbstateL) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(_mbstateL)
        )
    );
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::libc::c_long;
pub type __darwin_size_t = ::libc::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::libc::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::libc::c_int;
pub type __darwin_clock_t = ::libc::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::libc::c_long;
pub type __darwin_time_t = ::libc::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::libc::c_uint;
pub type __darwin_fsfilcnt_t = ::libc::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::libc::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::libc::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::core::option::Option<unsafe extern "C" fn(arg1: *mut ::libc::c_void)>,
    pub __arg: *mut ::libc::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[test]
fn bindgen_test_layout___darwin_pthread_handler_rec() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_pthread_handler_rec> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_pthread_handler_rec>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_pthread_handler_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__routine) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__arg) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__next) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__next)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::libc::c_long,
    pub __opaque: [::libc::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_attr_t() {
    const UNINIT: ::core::mem::MaybeUninit<_opaque_pthread_attr_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<_opaque_pthread_attr_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        ::core::mem::align_of::<_opaque_pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::libc::c_long,
    pub __opaque: [::libc::c_char; 40usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_cond_t() {
    const UNINIT: ::core::mem::MaybeUninit<_opaque_pthread_cond_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<_opaque_pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        ::core::mem::align_of::<_opaque_pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::libc::c_long,
    pub __opaque: [::libc::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_condattr_t() {
    const UNINIT: ::core::mem::MaybeUninit<_opaque_pthread_condattr_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<_opaque_pthread_condattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        ::core::mem::align_of::<_opaque_pthread_condattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::libc::c_long,
    pub __opaque: [::libc::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutex_t() {
    const UNINIT: ::core::mem::MaybeUninit<_opaque_pthread_mutex_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<_opaque_pthread_mutex_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        ::core::mem::align_of::<_opaque_pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::libc::c_long,
    pub __opaque: [::libc::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutexattr_t() {
    const UNINIT: ::core::mem::MaybeUninit<_opaque_pthread_mutexattr_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<_opaque_pthread_mutexattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        ::core::mem::align_of::<_opaque_pthread_mutexattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::libc::c_long,
    pub __opaque: [::libc::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_once_t() {
    const UNINIT: ::core::mem::MaybeUninit<_opaque_pthread_once_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<_opaque_pthread_once_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        ::core::mem::align_of::<_opaque_pthread_once_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::libc::c_long,
    pub __opaque: [::libc::c_char; 192usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlock_t() {
    const UNINIT: ::core::mem::MaybeUninit<_opaque_pthread_rwlock_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<_opaque_pthread_rwlock_t>(),
        200usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        ::core::mem::align_of::<_opaque_pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::libc::c_long,
    pub __opaque: [::libc::c_char; 16usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlockattr_t() {
    const UNINIT: ::core::mem::MaybeUninit<_opaque_pthread_rwlockattr_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<_opaque_pthread_rwlockattr_t>(),
        24usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        ::core::mem::align_of::<_opaque_pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::libc::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::libc::c_char; 8176usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_t() {
    const UNINIT: ::core::mem::MaybeUninit<_opaque_pthread_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<_opaque_pthread_t>(),
        8192usize,
        concat!("Size of: ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        ::core::mem::align_of::<_opaque_pthread_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__sig) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__cleanup_stack) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__cleanup_stack)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opaque) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__opaque)
        )
    );
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::libc::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type u_int8_t = ::libc::c_uchar;
pub type u_int16_t = ::libc::c_ushort;
pub type u_int32_t = ::libc::c_uint;
pub type u_int64_t = ::libc::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
pub type boolean_t = ::libc::c_uint;
pub type natural_t = __darwin_natural_t;
pub type integer_t = ::libc::c_int;
pub type vm_offset_t = usize;
pub type vm_size_t = usize;
pub type mach_vm_address_t = u64;
pub type mach_vm_offset_t = u64;
pub type mach_vm_size_t = u64;
pub type vm_map_offset_t = u64;
pub type vm_map_address_t = u64;
pub type vm_map_size_t = u64;
pub type mach_port_context_t = mach_vm_address_t;
pub type mach_port_name_t = natural_t;
pub type mach_port_name_array_t = *mut mach_port_name_t;
pub type mach_port_t = __darwin_mach_port_t;
pub type mach_port_array_t = *mut mach_port_t;
pub type mach_port_right_t = natural_t;
pub type mach_port_type_t = natural_t;
pub type mach_port_type_array_t = *mut mach_port_type_t;
pub type mach_port_urefs_t = natural_t;
pub type mach_port_delta_t = integer_t;
pub type mach_port_seqno_t = natural_t;
pub type mach_port_mscount_t = natural_t;
pub type mach_port_msgcount_t = natural_t;
pub type mach_port_rights_t = natural_t;
pub type mach_port_srights_t = ::libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_status {
    pub mps_pset: mach_port_rights_t,
    pub mps_seqno: mach_port_seqno_t,
    pub mps_mscount: mach_port_mscount_t,
    pub mps_qlimit: mach_port_msgcount_t,
    pub mps_msgcount: mach_port_msgcount_t,
    pub mps_sorights: mach_port_rights_t,
    pub mps_srights: boolean_t,
    pub mps_pdrequest: boolean_t,
    pub mps_nsrequest: boolean_t,
    pub mps_flags: natural_t,
}
#[test]
fn bindgen_test_layout_mach_port_status() {
    const UNINIT: ::core::mem::MaybeUninit<mach_port_status> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_port_status>(),
        40usize,
        concat!("Size of: ", stringify!(mach_port_status))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_port_status>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_port_status))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_pset) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_pset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_seqno) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_seqno)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_mscount) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_mscount)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_qlimit) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_qlimit)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_msgcount) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_msgcount)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_sorights) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_sorights)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_srights) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_srights)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_pdrequest) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_pdrequest)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_nsrequest) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_nsrequest)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mps_flags) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_status),
            "::",
            stringify!(mps_flags)
        )
    );
}
pub type mach_port_status_t = mach_port_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_limits {
    pub mpl_qlimit: mach_port_msgcount_t,
}
#[test]
fn bindgen_test_layout_mach_port_limits() {
    const UNINIT: ::core::mem::MaybeUninit<mach_port_limits> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_port_limits>(),
        4usize,
        concat!("Size of: ", stringify!(mach_port_limits))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_port_limits>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_port_limits))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mpl_qlimit) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_limits),
            "::",
            stringify!(mpl_qlimit)
        )
    );
}
pub type mach_port_limits_t = mach_port_limits;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_info_ext {
    pub mpie_status: mach_port_status_t,
    pub mpie_boost_cnt: mach_port_msgcount_t,
    pub reserved: [u32; 6usize],
}
#[test]
fn bindgen_test_layout_mach_port_info_ext() {
    const UNINIT: ::core::mem::MaybeUninit<mach_port_info_ext> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_port_info_ext>(),
        68usize,
        concat!("Size of: ", stringify!(mach_port_info_ext))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_port_info_ext>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_port_info_ext))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mpie_status) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_info_ext),
            "::",
            stringify!(mpie_status)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mpie_boost_cnt) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_info_ext),
            "::",
            stringify!(mpie_boost_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_info_ext),
            "::",
            stringify!(reserved)
        )
    );
}
pub type mach_port_info_ext_t = mach_port_info_ext;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_guard_info {
    pub mpgi_guard: u64,
}
#[test]
fn bindgen_test_layout_mach_port_guard_info() {
    const UNINIT: ::core::mem::MaybeUninit<mach_port_guard_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_port_guard_info>(),
        8usize,
        concat!("Size of: ", stringify!(mach_port_guard_info))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_port_guard_info>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_port_guard_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mpgi_guard) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_guard_info),
            "::",
            stringify!(mpgi_guard)
        )
    );
}
pub type mach_port_guard_info_t = mach_port_guard_info;
pub type mach_port_info_t = *mut integer_t;
pub type mach_port_flavor_t = ::libc::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_qos {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub len: natural_t,
}
#[test]
fn bindgen_test_layout_mach_port_qos() {
    const UNINIT: ::core::mem::MaybeUninit<mach_port_qos> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_port_qos>(),
        8usize,
        concat!("Size of: ", stringify!(mach_port_qos))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_port_qos>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_port_qos))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_qos),
            "::",
            stringify!(len)
        )
    );
}
impl mach_port_qos {
    #[inline]
    pub fn name(&self) -> ::libc::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_name(&mut self, val: ::libc::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn prealloc(&self) -> ::libc::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_prealloc(&mut self, val: ::libc::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> boolean_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        name: ::libc::c_uint,
        prealloc: ::libc::c_uint,
        pad1: boolean_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let name: u32 = unsafe { ::core::mem::transmute(name) };
            name as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let prealloc: u32 = unsafe { ::core::mem::transmute(prealloc) };
            prealloc as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let pad1: u32 = unsafe { ::core::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type mach_port_qos_t = mach_port_qos;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_service_port_info {
    pub mspi_string_name: [::libc::c_char; 255usize],
    pub mspi_domain_type: u8,
}
#[test]
fn bindgen_test_layout_mach_service_port_info() {
    const UNINIT: ::core::mem::MaybeUninit<mach_service_port_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_service_port_info>(),
        256usize,
        concat!("Size of: ", stringify!(mach_service_port_info))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_service_port_info>(),
        1usize,
        concat!("Alignment of ", stringify!(mach_service_port_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mspi_string_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_service_port_info),
            "::",
            stringify!(mspi_string_name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mspi_domain_type) as usize - ptr as usize },
        255usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_service_port_info),
            "::",
            stringify!(mspi_domain_type)
        )
    );
}
pub type mach_service_port_info_data_t = mach_service_port_info;
pub type mach_service_port_info_t = *mut mach_service_port_info;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mach_port_options {
    pub flags: u32,
    pub mpl: mach_port_limits_t,
    pub __bindgen_anon_1: mach_port_options__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mach_port_options__bindgen_ty_1 {
    pub reserved: [u64; 2usize],
    pub work_interval_port: mach_port_name_t,
    pub service_port_info: mach_service_port_info_t,
    pub service_port_name: mach_port_name_t,
}
#[test]
fn bindgen_test_layout_mach_port_options__bindgen_ty_1() {
    const UNINIT: ::core::mem::MaybeUninit<mach_port_options__bindgen_ty_1> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_port_options__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(mach_port_options__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_port_options__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_port_options__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options__bindgen_ty_1),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).work_interval_port) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options__bindgen_ty_1),
            "::",
            stringify!(work_interval_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).service_port_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options__bindgen_ty_1),
            "::",
            stringify!(service_port_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).service_port_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options__bindgen_ty_1),
            "::",
            stringify!(service_port_name)
        )
    );
}
#[test]
fn bindgen_test_layout_mach_port_options() {
    const UNINIT: ::core::mem::MaybeUninit<mach_port_options> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_port_options>(),
        24usize,
        concat!("Size of: ", stringify!(mach_port_options))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_port_options>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_port_options))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mpl) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_options),
            "::",
            stringify!(mpl)
        )
    );
}
pub type mach_port_options_t = mach_port_options;
pub type mach_port_options_ptr_t = *mut mach_port_options_t;
pub const mach_port_guard_exception_codes_kGUARD_EXC_DESTROY: mach_port_guard_exception_codes = 1;
pub const mach_port_guard_exception_codes_kGUARD_EXC_MOD_REFS: mach_port_guard_exception_codes = 2;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_OPTIONS:
    mach_port_guard_exception_codes = 3;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SET_CONTEXT: mach_port_guard_exception_codes =
    4;
pub const mach_port_guard_exception_codes_kGUARD_EXC_THREAD_SET_STATE:
    mach_port_guard_exception_codes = 5;
pub const mach_port_guard_exception_codes_kGUARD_EXC_UNGUARDED: mach_port_guard_exception_codes = 8;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INCORRECT_GUARD:
    mach_port_guard_exception_codes = 16;
pub const mach_port_guard_exception_codes_kGUARD_EXC_IMMOVABLE: mach_port_guard_exception_codes =
    32;
pub const mach_port_guard_exception_codes_kGUARD_EXC_STRICT_REPLY: mach_port_guard_exception_codes =
    64;
pub const mach_port_guard_exception_codes_kGUARD_EXC_MSG_FILTERED: mach_port_guard_exception_codes =
    128;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_RIGHT:
    mach_port_guard_exception_codes = 256;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_NAME: mach_port_guard_exception_codes =
    512;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_VALUE:
    mach_port_guard_exception_codes = 1024;
pub const mach_port_guard_exception_codes_kGUARD_EXC_INVALID_ARGUMENT:
    mach_port_guard_exception_codes = 2048;
pub const mach_port_guard_exception_codes_kGUARD_EXC_RIGHT_EXISTS: mach_port_guard_exception_codes =
    4096;
pub const mach_port_guard_exception_codes_kGUARD_EXC_KERN_NO_SPACE:
    mach_port_guard_exception_codes = 8192;
pub const mach_port_guard_exception_codes_kGUARD_EXC_KERN_FAILURE: mach_port_guard_exception_codes =
    16384;
pub const mach_port_guard_exception_codes_kGUARD_EXC_KERN_RESOURCE:
    mach_port_guard_exception_codes = 32768;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SEND_INVALID_REPLY:
    mach_port_guard_exception_codes = 65536;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SEND_INVALID_VOUCHER:
    mach_port_guard_exception_codes = 131072;
pub const mach_port_guard_exception_codes_kGUARD_EXC_SEND_INVALID_RIGHT:
    mach_port_guard_exception_codes = 262144;
pub const mach_port_guard_exception_codes_kGUARD_EXC_RCV_INVALID_NAME:
    mach_port_guard_exception_codes = 524288;
pub const mach_port_guard_exception_codes_kGUARD_EXC_RCV_GUARDED_DESC:
    mach_port_guard_exception_codes = 1048576;
pub const mach_port_guard_exception_codes_kGUARD_EXC_MOD_REFS_NON_FATAL:
    mach_port_guard_exception_codes = 2097152;
pub const mach_port_guard_exception_codes_kGUARD_EXC_IMMOVABLE_NON_FATAL:
    mach_port_guard_exception_codes = 4194304;
pub const mach_port_guard_exception_codes_kGUARD_EXC_REQUIRE_REPLY_PORT_SEMANTICS:
    mach_port_guard_exception_codes = 8388608;
pub type mach_port_guard_exception_codes = ::libc::c_uint;
pub type kern_return_t = ::libc::c_int;
pub type mach_msg_timeout_t = natural_t;
pub type mach_msg_bits_t = ::libc::c_uint;
pub type mach_msg_size_t = natural_t;
pub type mach_msg_id_t = integer_t;
pub type mach_msg_priority_t = ::libc::c_uint;
pub type mach_msg_type_name_t = ::libc::c_uint;
pub type mach_msg_copy_options_t = ::libc::c_uint;
pub type mach_msg_guard_flags_t = ::libc::c_uint;
pub type mach_msg_descriptor_type_t = ::libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_type_descriptor_t {
    pub pad1: natural_t,
    pub pad2: mach_msg_size_t,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_mach_msg_type_descriptor_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_type_descriptor_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_type_descriptor_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_type_descriptor_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_type_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_type_descriptor_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_type_descriptor_t),
            "::",
            stringify!(pad1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pad2) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_type_descriptor_t),
            "::",
            stringify!(pad2)
        )
    );
}
impl mach_msg_type_descriptor_t {
    #[inline]
    pub fn pad3(&self) -> ::libc::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_pad3(&mut self, val: ::libc::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pad3: ::libc::c_uint,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let pad3: u32 = unsafe { ::core::mem::transmute(pad3) };
            pad3 as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_port_descriptor_t {
    pub name: mach_port_t,
    pub pad1: mach_msg_size_t,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_mach_msg_port_descriptor_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_port_descriptor_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_port_descriptor_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_port_descriptor_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_port_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_port_descriptor_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_port_descriptor_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pad1) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_port_descriptor_t),
            "::",
            stringify!(pad1)
        )
    );
}
impl mach_msg_port_descriptor_t {
    #[inline]
    pub fn pad2(&self) -> ::libc::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_pad2(&mut self, val: ::libc::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pad2: ::libc::c_uint,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let pad2: u32 = unsafe { ::core::mem::transmute(pad2) };
            pad2 as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::core::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_descriptor32_t {
    pub address: u32,
    pub size: mach_msg_size_t,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_descriptor32_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_ool_descriptor32_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_ool_descriptor32_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_ool_descriptor32_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_ool_descriptor32_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_ool_descriptor32_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor32_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor32_t),
            "::",
            stringify!(size)
        )
    );
}
impl mach_msg_ool_descriptor32_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> ::libc::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: ::libc::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        pad1: ::libc::c_uint,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::core::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::core::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let pad1: u32 = unsafe { ::core::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_descriptor64_t {
    pub address: u64,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub size: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_descriptor64_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_ool_descriptor64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_ool_descriptor64_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_ool_descriptor64_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_ool_descriptor64_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_ool_descriptor64_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor64_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor64_t),
            "::",
            stringify!(size)
        )
    );
}
impl mach_msg_ool_descriptor64_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> ::libc::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: ::libc::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        pad1: ::libc::c_uint,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::core::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::core::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let pad1: u32 = unsafe { ::core::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_descriptor_t {
    pub address: *mut ::libc::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub size: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_descriptor_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_ool_descriptor_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_ool_descriptor_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_ool_descriptor_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_ool_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_ool_descriptor_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_descriptor_t),
            "::",
            stringify!(size)
        )
    );
}
impl mach_msg_ool_descriptor_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn pad1(&self) -> ::libc::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_pad1(&mut self, val: ::libc::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        pad1: ::libc::c_uint,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::core::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::core::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let pad1: u32 = unsafe { ::core::mem::transmute(pad1) };
            pad1 as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_ports_descriptor32_t {
    pub address: u32,
    pub count: mach_msg_size_t,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_ports_descriptor32_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_ool_ports_descriptor32_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_ool_ports_descriptor32_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_ool_ports_descriptor32_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_ool_ports_descriptor32_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_ool_ports_descriptor32_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor32_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor32_t),
            "::",
            stringify!(count)
        )
    );
}
impl mach_msg_ool_ports_descriptor32_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::core::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::core::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::core::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_ports_descriptor64_t {
    pub address: u64,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub count: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_ports_descriptor64_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_ool_ports_descriptor64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_ool_ports_descriptor64_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_ool_ports_descriptor64_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_ool_ports_descriptor64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_ool_ports_descriptor64_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor64_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor64_t),
            "::",
            stringify!(count)
        )
    );
}
impl mach_msg_ool_ports_descriptor64_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::core::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::core::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::core::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_ool_ports_descriptor_t {
    pub address: *mut ::libc::c_void,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub count: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_ool_ports_descriptor_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_ool_ports_descriptor_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_ool_ports_descriptor_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_ool_ports_descriptor_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_ool_ports_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_ool_ports_descriptor_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_ool_ports_descriptor_t),
            "::",
            stringify!(count)
        )
    );
}
impl mach_msg_ool_ports_descriptor_t {
    #[inline]
    pub fn deallocate(&self) -> boolean_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_deallocate(&mut self, val: boolean_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn copy(&self) -> mach_msg_copy_options_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_copy(&mut self, val: mach_msg_copy_options_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        deallocate: boolean_t,
        copy: mach_msg_copy_options_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let deallocate: u32 = unsafe { ::core::mem::transmute(deallocate) };
            deallocate as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let copy: u32 = unsafe { ::core::mem::transmute(copy) };
            copy as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::core::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_guarded_port_descriptor32_t {
    pub context: u32,
    pub name: mach_port_name_t,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_mach_msg_guarded_port_descriptor32_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_guarded_port_descriptor32_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_guarded_port_descriptor32_t>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(mach_msg_guarded_port_descriptor32_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_guarded_port_descriptor32_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_guarded_port_descriptor32_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).context) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor32_t),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor32_t),
            "::",
            stringify!(name)
        )
    );
}
impl mach_msg_guarded_port_descriptor32_t {
    #[inline]
    pub fn flags(&self) -> mach_msg_guard_flags_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: mach_msg_guard_flags_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        flags: mach_msg_guard_flags_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let flags: u32 = unsafe { ::core::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::core::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_guarded_port_descriptor64_t {
    pub context: u64,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub name: mach_port_name_t,
}
#[test]
fn bindgen_test_layout_mach_msg_guarded_port_descriptor64_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_guarded_port_descriptor64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_guarded_port_descriptor64_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(mach_msg_guarded_port_descriptor64_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_guarded_port_descriptor64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_guarded_port_descriptor64_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).context) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor64_t),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor64_t),
            "::",
            stringify!(name)
        )
    );
}
impl mach_msg_guarded_port_descriptor64_t {
    #[inline]
    pub fn flags(&self) -> mach_msg_guard_flags_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: mach_msg_guard_flags_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        flags: mach_msg_guard_flags_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let flags: u32 = unsafe { ::core::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::core::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_guarded_port_descriptor_t {
    pub context: mach_port_context_t,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub name: mach_port_name_t,
}
#[test]
fn bindgen_test_layout_mach_msg_guarded_port_descriptor_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_guarded_port_descriptor_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_guarded_port_descriptor_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_guarded_port_descriptor_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_guarded_port_descriptor_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_msg_guarded_port_descriptor_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).context) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor_t),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_guarded_port_descriptor_t),
            "::",
            stringify!(name)
        )
    );
}
impl mach_msg_guarded_port_descriptor_t {
    #[inline]
    pub fn flags(&self) -> mach_msg_guard_flags_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: mach_msg_guard_flags_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn disposition(&self) -> mach_msg_type_name_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_disposition(&mut self, val: mach_msg_type_name_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn type_(&self) -> mach_msg_descriptor_type_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: mach_msg_descriptor_type_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        flags: mach_msg_guard_flags_t,
        disposition: mach_msg_type_name_t,
        type_: mach_msg_descriptor_type_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let flags: u32 = unsafe { ::core::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let disposition: u32 = unsafe { ::core::mem::transmute(disposition) };
            disposition as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let type_: u32 = unsafe { ::core::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mach_msg_descriptor_t {
    pub port: mach_msg_port_descriptor_t,
    pub out_of_line: mach_msg_ool_descriptor_t,
    pub ool_ports: mach_msg_ool_ports_descriptor_t,
    pub type_: mach_msg_type_descriptor_t,
    pub guarded_port: mach_msg_guarded_port_descriptor_t,
}
#[test]
fn bindgen_test_layout_mach_msg_descriptor_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_descriptor_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_descriptor_t>(),
        16usize,
        concat!("Size of: ", stringify!(mach_msg_descriptor_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_descriptor_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_descriptor_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).out_of_line) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(out_of_line)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ool_ports) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(ool_ports)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).guarded_port) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_descriptor_t),
            "::",
            stringify!(guarded_port)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_body_t {
    pub msgh_descriptor_count: mach_msg_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_body_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_body_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_body_t>(),
        4usize,
        concat!("Size of: ", stringify!(mach_msg_body_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_body_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_body_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_descriptor_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_body_t),
            "::",
            stringify!(msgh_descriptor_count)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_header_t {
    pub msgh_bits: mach_msg_bits_t,
    pub msgh_size: mach_msg_size_t,
    pub msgh_remote_port: mach_port_t,
    pub msgh_local_port: mach_port_t,
    pub msgh_voucher_port: mach_port_name_t,
    pub msgh_id: mach_msg_id_t,
}
#[test]
fn bindgen_test_layout_mach_msg_header_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_header_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_header_t>(),
        24usize,
        concat!("Size of: ", stringify!(mach_msg_header_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_header_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_header_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_bits) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_bits)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_remote_port) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_remote_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_local_port) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_local_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_voucher_port) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_voucher_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_id) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_header_t),
            "::",
            stringify!(msgh_id)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_base_t {
    pub header: mach_msg_header_t,
    pub body: mach_msg_body_t,
}
#[test]
fn bindgen_test_layout_mach_msg_base_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_base_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_base_t>(),
        28usize,
        concat!("Size of: ", stringify!(mach_msg_base_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_base_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_base_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).header) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_base_t),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_base_t),
            "::",
            stringify!(body)
        )
    );
}
pub type mach_msg_trailer_type_t = ::libc::c_uint;
pub type mach_msg_trailer_size_t = ::libc::c_uint;
pub type mach_msg_trailer_info_t = *mut ::libc::c_char;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
}
#[test]
fn bindgen_test_layout_mach_msg_trailer_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_trailer_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_trailer_t>(),
        8usize,
        concat!("Size of: ", stringify!(mach_msg_trailer_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_trailer_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_seqno_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
}
#[test]
fn bindgen_test_layout_mach_msg_seqno_trailer_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_seqno_trailer_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_seqno_trailer_t>(),
        12usize,
        concat!("Size of: ", stringify!(mach_msg_seqno_trailer_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_seqno_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_seqno_trailer_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_seqno_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_seqno_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_seqno) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_seqno_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct security_token_t {
    pub val: [::libc::c_uint; 2usize],
}
#[test]
fn bindgen_test_layout_security_token_t() {
    const UNINIT: ::core::mem::MaybeUninit<security_token_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<security_token_t>(),
        8usize,
        concat!("Size of: ", stringify!(security_token_t))
    );
    assert_eq!(
        ::core::mem::align_of::<security_token_t>(),
        4usize,
        concat!("Alignment of ", stringify!(security_token_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).val) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(security_token_t),
            "::",
            stringify!(val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_security_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
    pub msgh_sender: security_token_t,
}
#[test]
fn bindgen_test_layout_mach_msg_security_trailer_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_security_trailer_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_security_trailer_t>(),
        20usize,
        concat!("Size of: ", stringify!(mach_msg_security_trailer_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_security_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_security_trailer_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_security_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_security_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_seqno) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_security_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_sender) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_security_trailer_t),
            "::",
            stringify!(msgh_sender)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct audit_token_t {
    pub val: [::libc::c_uint; 8usize],
}
#[test]
fn bindgen_test_layout_audit_token_t() {
    const UNINIT: ::core::mem::MaybeUninit<audit_token_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<audit_token_t>(),
        32usize,
        concat!("Size of: ", stringify!(audit_token_t))
    );
    assert_eq!(
        ::core::mem::align_of::<audit_token_t>(),
        4usize,
        concat!("Alignment of ", stringify!(audit_token_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).val) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(audit_token_t),
            "::",
            stringify!(val)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_audit_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
    pub msgh_sender: security_token_t,
    pub msgh_audit: audit_token_t,
}
#[test]
fn bindgen_test_layout_mach_msg_audit_trailer_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_audit_trailer_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_audit_trailer_t>(),
        52usize,
        concat!("Size of: ", stringify!(mach_msg_audit_trailer_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_audit_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_audit_trailer_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_seqno) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_sender) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_sender)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_audit) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_audit_trailer_t),
            "::",
            stringify!(msgh_audit)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_context_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
    pub msgh_sender: security_token_t,
    pub msgh_audit: audit_token_t,
    pub msgh_context: mach_port_context_t,
}
#[test]
fn bindgen_test_layout_mach_msg_context_trailer_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_context_trailer_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_context_trailer_t>(),
        60usize,
        concat!("Size of: ", stringify!(mach_msg_context_trailer_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_context_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_context_trailer_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_seqno) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_sender) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_sender)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_audit) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_audit)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_context) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_context_trailer_t),
            "::",
            stringify!(msgh_context)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct msg_labels_t {
    pub sender: mach_port_name_t,
}
#[test]
fn bindgen_test_layout_msg_labels_t() {
    const UNINIT: ::core::mem::MaybeUninit<msg_labels_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<msg_labels_t>(),
        4usize,
        concat!("Size of: ", stringify!(msg_labels_t))
    );
    assert_eq!(
        ::core::mem::align_of::<msg_labels_t>(),
        4usize,
        concat!("Alignment of ", stringify!(msg_labels_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sender) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(msg_labels_t),
            "::",
            stringify!(sender)
        )
    );
}
pub type mach_msg_filter_id = ::libc::c_int;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_mac_trailer_t {
    pub msgh_trailer_type: mach_msg_trailer_type_t,
    pub msgh_trailer_size: mach_msg_trailer_size_t,
    pub msgh_seqno: mach_port_seqno_t,
    pub msgh_sender: security_token_t,
    pub msgh_audit: audit_token_t,
    pub msgh_context: mach_port_context_t,
    pub msgh_ad: mach_msg_filter_id,
    pub msgh_labels: msg_labels_t,
}
#[test]
fn bindgen_test_layout_mach_msg_mac_trailer_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_mac_trailer_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_mac_trailer_t>(),
        68usize,
        concat!("Size of: ", stringify!(mach_msg_mac_trailer_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_mac_trailer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_mac_trailer_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_trailer_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_trailer_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_trailer_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_seqno) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_seqno)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_sender) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_sender)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_audit) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_audit)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_context) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_context)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_ad) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_ad)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_labels) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_mac_trailer_t),
            "::",
            stringify!(msgh_labels)
        )
    );
}
pub type mach_msg_max_trailer_t = mach_msg_mac_trailer_t;
pub type mach_msg_format_0_trailer_t = mach_msg_security_trailer_t;
pub type mach_msg_options_t = integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_empty_send_t {
    pub header: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout_mach_msg_empty_send_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_empty_send_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_empty_send_t>(),
        24usize,
        concat!("Size of: ", stringify!(mach_msg_empty_send_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_empty_send_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_empty_send_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).header) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_send_t),
            "::",
            stringify!(header)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_msg_empty_rcv_t {
    pub header: mach_msg_header_t,
    pub trailer: mach_msg_trailer_t,
}
#[test]
fn bindgen_test_layout_mach_msg_empty_rcv_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_empty_rcv_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_empty_rcv_t>(),
        32usize,
        concat!("Size of: ", stringify!(mach_msg_empty_rcv_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_empty_rcv_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_empty_rcv_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).header) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_rcv_t),
            "::",
            stringify!(header)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).trailer) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_rcv_t),
            "::",
            stringify!(trailer)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mach_msg_empty_t {
    pub send: mach_msg_empty_send_t,
    pub rcv: mach_msg_empty_rcv_t,
}
#[test]
fn bindgen_test_layout_mach_msg_empty_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_msg_empty_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_msg_empty_t>(),
        32usize,
        concat!("Size of: ", stringify!(mach_msg_empty_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_msg_empty_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_msg_empty_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).send) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_t),
            "::",
            stringify!(send)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).rcv) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_msg_empty_t),
            "::",
            stringify!(rcv)
        )
    );
}
pub type mach_msg_type_size_t = natural_t;
pub type mach_msg_type_number_t = natural_t;
pub type mach_msg_option_t = integer_t;
pub type mach_msg_return_t = kern_return_t;
extern "C" {
    pub fn mach_msg_overwrite(
        msg: *mut mach_msg_header_t,
        option: mach_msg_option_t,
        send_size: mach_msg_size_t,
        rcv_size: mach_msg_size_t,
        rcv_name: mach_port_name_t,
        timeout: mach_msg_timeout_t,
        notify: mach_port_name_t,
        rcv_msg: *mut mach_msg_header_t,
        rcv_limit: mach_msg_size_t,
    ) -> mach_msg_return_t;
}
extern "C" {
    pub fn mach_msg(
        msg: *mut mach_msg_header_t,
        option: mach_msg_option_t,
        send_size: mach_msg_size_t,
        rcv_size: mach_msg_size_t,
        rcv_name: mach_port_name_t,
        timeout: mach_msg_timeout_t,
        notify: mach_port_name_t,
    ) -> mach_msg_return_t;
}
extern "C" {
    pub fn mach_voucher_deallocate(voucher: mach_port_name_t) -> kern_return_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_statistics {
    pub free_count: natural_t,
    pub active_count: natural_t,
    pub inactive_count: natural_t,
    pub wire_count: natural_t,
    pub zero_fill_count: natural_t,
    pub reactivations: natural_t,
    pub pageins: natural_t,
    pub pageouts: natural_t,
    pub faults: natural_t,
    pub cow_faults: natural_t,
    pub lookups: natural_t,
    pub hits: natural_t,
    pub purgeable_count: natural_t,
    pub purges: natural_t,
    pub speculative_count: natural_t,
}
#[test]
fn bindgen_test_layout_vm_statistics() {
    const UNINIT: ::core::mem::MaybeUninit<vm_statistics> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_statistics>(),
        60usize,
        concat!("Size of: ", stringify!(vm_statistics))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_statistics>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_statistics))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).free_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(free_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).active_count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(active_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inactive_count) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(inactive_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).wire_count) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(wire_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zero_fill_count) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(zero_fill_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reactivations) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(reactivations)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pageins) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(pageins)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pageouts) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(pageouts)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).faults) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(faults)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cow_faults) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(cow_faults)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lookups) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(lookups)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).hits) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(hits)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).purgeable_count) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(purgeable_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).purges) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(purges)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).speculative_count) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics),
            "::",
            stringify!(speculative_count)
        )
    );
}
pub type vm_statistics_t = *mut vm_statistics;
pub type vm_statistics_data_t = vm_statistics;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_statistics64 {
    pub free_count: natural_t,
    pub active_count: natural_t,
    pub inactive_count: natural_t,
    pub wire_count: natural_t,
    pub zero_fill_count: u64,
    pub reactivations: u64,
    pub pageins: u64,
    pub pageouts: u64,
    pub faults: u64,
    pub cow_faults: u64,
    pub lookups: u64,
    pub hits: u64,
    pub purges: u64,
    pub purgeable_count: natural_t,
    pub speculative_count: natural_t,
    pub decompressions: u64,
    pub compressions: u64,
    pub swapins: u64,
    pub swapouts: u64,
    pub compressor_page_count: natural_t,
    pub throttled_count: natural_t,
    pub external_page_count: natural_t,
    pub internal_page_count: natural_t,
    pub total_uncompressed_pages_in_compressor: u64,
}
#[test]
fn bindgen_test_layout_vm_statistics64() {
    const UNINIT: ::core::mem::MaybeUninit<vm_statistics64> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_statistics64>(),
        152usize,
        concat!("Size of: ", stringify!(vm_statistics64))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_statistics64>(),
        8usize,
        concat!("Alignment of ", stringify!(vm_statistics64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).free_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(free_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).active_count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(active_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inactive_count) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(inactive_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).wire_count) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(wire_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zero_fill_count) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(zero_fill_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reactivations) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(reactivations)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pageins) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(pageins)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pageouts) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(pageouts)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).faults) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(faults)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cow_faults) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(cow_faults)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lookups) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(lookups)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).hits) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(hits)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).purges) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(purges)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).purgeable_count) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(purgeable_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).speculative_count) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(speculative_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).decompressions) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(decompressions)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).compressions) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(compressions)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).swapins) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(swapins)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).swapouts) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(swapouts)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).compressor_page_count) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(compressor_page_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).throttled_count) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(throttled_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).external_page_count) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(external_page_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).internal_page_count) as usize - ptr as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(internal_page_count)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).total_uncompressed_pages_in_compressor) as usize
                - ptr as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_statistics64),
            "::",
            stringify!(total_uncompressed_pages_in_compressor)
        )
    );
}
pub type vm_statistics64_t = *mut vm_statistics64;
pub type vm_statistics64_data_t = vm_statistics64;
extern "C" {
    pub fn vm_stats(info: *mut ::libc::c_void, count: *mut ::libc::c_uint) -> kern_return_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_extmod_statistics {
    pub task_for_pid_count: i64,
    pub task_for_pid_caller_count: i64,
    pub thread_creation_count: i64,
    pub thread_creation_caller_count: i64,
    pub thread_set_state_count: i64,
    pub thread_set_state_caller_count: i64,
}
#[test]
fn bindgen_test_layout_vm_extmod_statistics() {
    const UNINIT: ::core::mem::MaybeUninit<vm_extmod_statistics> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_extmod_statistics>(),
        48usize,
        concat!("Size of: ", stringify!(vm_extmod_statistics))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_extmod_statistics>(),
        8usize,
        concat!("Alignment of ", stringify!(vm_extmod_statistics))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_for_pid_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_extmod_statistics),
            "::",
            stringify!(task_for_pid_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_for_pid_caller_count) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_extmod_statistics),
            "::",
            stringify!(task_for_pid_caller_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).thread_creation_count) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_extmod_statistics),
            "::",
            stringify!(thread_creation_count)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).thread_creation_caller_count) as usize - ptr as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_extmod_statistics),
            "::",
            stringify!(thread_creation_caller_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).thread_set_state_count) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_extmod_statistics),
            "::",
            stringify!(thread_set_state_count)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).thread_set_state_caller_count) as usize - ptr as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_extmod_statistics),
            "::",
            stringify!(thread_set_state_caller_count)
        )
    );
}
pub type vm_extmod_statistics_t = *mut vm_extmod_statistics;
pub type vm_extmod_statistics_data_t = vm_extmod_statistics;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_purgeable_stat {
    pub count: u64,
    pub size: u64,
}
#[test]
fn bindgen_test_layout_vm_purgeable_stat() {
    const UNINIT: ::core::mem::MaybeUninit<vm_purgeable_stat> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_purgeable_stat>(),
        16usize,
        concat!("Size of: ", stringify!(vm_purgeable_stat))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_purgeable_stat>(),
        8usize,
        concat!("Alignment of ", stringify!(vm_purgeable_stat))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_purgeable_stat),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_purgeable_stat),
            "::",
            stringify!(size)
        )
    );
}
pub type vm_purgeable_stat_t = vm_purgeable_stat;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_purgeable_info {
    pub fifo_data: [vm_purgeable_stat_t; 8usize],
    pub obsolete_data: vm_purgeable_stat_t,
    pub lifo_data: [vm_purgeable_stat_t; 8usize],
}
#[test]
fn bindgen_test_layout_vm_purgeable_info() {
    const UNINIT: ::core::mem::MaybeUninit<vm_purgeable_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_purgeable_info>(),
        272usize,
        concat!("Size of: ", stringify!(vm_purgeable_info))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_purgeable_info>(),
        8usize,
        concat!("Alignment of ", stringify!(vm_purgeable_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fifo_data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_purgeable_info),
            "::",
            stringify!(fifo_data)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).obsolete_data) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_purgeable_info),
            "::",
            stringify!(obsolete_data)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lifo_data) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_purgeable_info),
            "::",
            stringify!(lifo_data)
        )
    );
}
pub type vm_purgeable_info_t = *mut vm_purgeable_info;
pub const virtual_memory_guard_exception_codes_kGUARD_EXC_DEALLOC_GAP:
    virtual_memory_guard_exception_codes = 1;
pub const virtual_memory_guard_exception_codes_kGUARD_EXC_RECLAIM_COPYIO_FAILURE:
    virtual_memory_guard_exception_codes = 2;
pub const virtual_memory_guard_exception_codes_kGUARD_EXC_RECLAIM_INDEX_FAILURE:
    virtual_memory_guard_exception_codes = 4;
pub const virtual_memory_guard_exception_codes_kGUARD_EXC_RECLAIM_DEALLOCATE_FAILURE:
    virtual_memory_guard_exception_codes = 8;
pub type virtual_memory_guard_exception_codes = ::libc::c_uint;
pub type cpu_type_t = integer_t;
pub type cpu_subtype_t = integer_t;
pub type cpu_threadtype_t = integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct time_value {
    pub seconds: integer_t,
    pub microseconds: integer_t,
}
#[test]
fn bindgen_test_layout_time_value() {
    const UNINIT: ::core::mem::MaybeUninit<time_value> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<time_value>(),
        8usize,
        concat!("Size of: ", stringify!(time_value))
    );
    assert_eq!(
        ::core::mem::align_of::<time_value>(),
        4usize,
        concat!("Alignment of ", stringify!(time_value))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).seconds) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(time_value),
            "::",
            stringify!(seconds)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).microseconds) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(time_value),
            "::",
            stringify!(microseconds)
        )
    );
}
pub type time_value_t = time_value;
pub type host_info_t = *mut integer_t;
pub type host_info64_t = *mut integer_t;
pub type host_info_data_t = [integer_t; 1024usize];
pub type kernel_version_t = [::libc::c_char; 512usize];
pub type kernel_boot_info_t = [::libc::c_char; 4096usize];
pub type host_flavor_t = integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct host_can_has_debugger_info {
    pub can_has_debugger: boolean_t,
}
#[test]
fn bindgen_test_layout_host_can_has_debugger_info() {
    const UNINIT: ::core::mem::MaybeUninit<host_can_has_debugger_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<host_can_has_debugger_info>(),
        4usize,
        concat!("Size of: ", stringify!(host_can_has_debugger_info))
    );
    assert_eq!(
        ::core::mem::align_of::<host_can_has_debugger_info>(),
        4usize,
        concat!("Alignment of ", stringify!(host_can_has_debugger_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).can_has_debugger) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(host_can_has_debugger_info),
            "::",
            stringify!(can_has_debugger)
        )
    );
}
pub type host_can_has_debugger_info_data_t = host_can_has_debugger_info;
pub type host_can_has_debugger_info_t = *mut host_can_has_debugger_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct host_basic_info {
    pub max_cpus: integer_t,
    pub avail_cpus: integer_t,
    pub memory_size: natural_t,
    pub cpu_type: cpu_type_t,
    pub cpu_subtype: cpu_subtype_t,
    pub cpu_threadtype: cpu_threadtype_t,
    pub physical_cpu: integer_t,
    pub physical_cpu_max: integer_t,
    pub logical_cpu: integer_t,
    pub logical_cpu_max: integer_t,
    pub max_mem: u64,
}
#[test]
fn bindgen_test_layout_host_basic_info() {
    const UNINIT: ::core::mem::MaybeUninit<host_basic_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<host_basic_info>(),
        48usize,
        concat!("Size of: ", stringify!(host_basic_info))
    );
    assert_eq!(
        ::core::mem::align_of::<host_basic_info>(),
        4usize,
        concat!("Alignment of ", stringify!(host_basic_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_cpus) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(max_cpus)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).avail_cpus) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(avail_cpus)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).memory_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(memory_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_type) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(cpu_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_subtype) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(cpu_subtype)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_threadtype) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(cpu_threadtype)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).physical_cpu) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(physical_cpu)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).physical_cpu_max) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(physical_cpu_max)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).logical_cpu) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(logical_cpu)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).logical_cpu_max) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(logical_cpu_max)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_mem) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(host_basic_info),
            "::",
            stringify!(max_mem)
        )
    );
}
pub type host_basic_info_data_t = host_basic_info;
pub type host_basic_info_t = *mut host_basic_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct host_sched_info {
    pub min_timeout: integer_t,
    pub min_quantum: integer_t,
}
#[test]
fn bindgen_test_layout_host_sched_info() {
    const UNINIT: ::core::mem::MaybeUninit<host_sched_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<host_sched_info>(),
        8usize,
        concat!("Size of: ", stringify!(host_sched_info))
    );
    assert_eq!(
        ::core::mem::align_of::<host_sched_info>(),
        4usize,
        concat!("Alignment of ", stringify!(host_sched_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).min_timeout) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(host_sched_info),
            "::",
            stringify!(min_timeout)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).min_quantum) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(host_sched_info),
            "::",
            stringify!(min_quantum)
        )
    );
}
pub type host_sched_info_data_t = host_sched_info;
pub type host_sched_info_t = *mut host_sched_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kernel_resource_sizes {
    pub task: natural_t,
    pub thread: natural_t,
    pub port: natural_t,
    pub memory_region: natural_t,
    pub memory_object: natural_t,
}
#[test]
fn bindgen_test_layout_kernel_resource_sizes() {
    const UNINIT: ::core::mem::MaybeUninit<kernel_resource_sizes> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<kernel_resource_sizes>(),
        20usize,
        concat!("Size of: ", stringify!(kernel_resource_sizes))
    );
    assert_eq!(
        ::core::mem::align_of::<kernel_resource_sizes>(),
        4usize,
        concat!("Alignment of ", stringify!(kernel_resource_sizes))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kernel_resource_sizes),
            "::",
            stringify!(task)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).thread) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kernel_resource_sizes),
            "::",
            stringify!(thread)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kernel_resource_sizes),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).memory_region) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kernel_resource_sizes),
            "::",
            stringify!(memory_region)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).memory_object) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kernel_resource_sizes),
            "::",
            stringify!(memory_object)
        )
    );
}
pub type kernel_resource_sizes_data_t = kernel_resource_sizes;
pub type kernel_resource_sizes_t = *mut kernel_resource_sizes;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct host_priority_info {
    pub kernel_priority: integer_t,
    pub system_priority: integer_t,
    pub server_priority: integer_t,
    pub user_priority: integer_t,
    pub depress_priority: integer_t,
    pub idle_priority: integer_t,
    pub minimum_priority: integer_t,
    pub maximum_priority: integer_t,
}
#[test]
fn bindgen_test_layout_host_priority_info() {
    const UNINIT: ::core::mem::MaybeUninit<host_priority_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<host_priority_info>(),
        32usize,
        concat!("Size of: ", stringify!(host_priority_info))
    );
    assert_eq!(
        ::core::mem::align_of::<host_priority_info>(),
        4usize,
        concat!("Alignment of ", stringify!(host_priority_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kernel_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(host_priority_info),
            "::",
            stringify!(kernel_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).system_priority) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(host_priority_info),
            "::",
            stringify!(system_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).server_priority) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(host_priority_info),
            "::",
            stringify!(server_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_priority) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(host_priority_info),
            "::",
            stringify!(user_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).depress_priority) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(host_priority_info),
            "::",
            stringify!(depress_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).idle_priority) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(host_priority_info),
            "::",
            stringify!(idle_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).minimum_priority) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(host_priority_info),
            "::",
            stringify!(minimum_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).maximum_priority) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(host_priority_info),
            "::",
            stringify!(maximum_priority)
        )
    );
}
pub type host_priority_info_data_t = host_priority_info;
pub type host_priority_info_t = *mut host_priority_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct host_load_info {
    pub avenrun: [integer_t; 3usize],
    pub mach_factor: [integer_t; 3usize],
}
#[test]
fn bindgen_test_layout_host_load_info() {
    const UNINIT: ::core::mem::MaybeUninit<host_load_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<host_load_info>(),
        24usize,
        concat!("Size of: ", stringify!(host_load_info))
    );
    assert_eq!(
        ::core::mem::align_of::<host_load_info>(),
        4usize,
        concat!("Alignment of ", stringify!(host_load_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).avenrun) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(host_load_info),
            "::",
            stringify!(avenrun)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mach_factor) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(host_load_info),
            "::",
            stringify!(mach_factor)
        )
    );
}
pub type host_load_info_data_t = host_load_info;
pub type host_load_info_t = *mut host_load_info;
pub type host_purgable_info_data_t = vm_purgeable_info;
pub type host_purgable_info_t = *mut vm_purgeable_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct host_cpu_load_info {
    pub cpu_ticks: [natural_t; 4usize],
}
#[test]
fn bindgen_test_layout_host_cpu_load_info() {
    const UNINIT: ::core::mem::MaybeUninit<host_cpu_load_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<host_cpu_load_info>(),
        16usize,
        concat!("Size of: ", stringify!(host_cpu_load_info))
    );
    assert_eq!(
        ::core::mem::align_of::<host_cpu_load_info>(),
        4usize,
        concat!("Alignment of ", stringify!(host_cpu_load_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_ticks) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(host_cpu_load_info),
            "::",
            stringify!(cpu_ticks)
        )
    );
}
pub type host_cpu_load_info_data_t = host_cpu_load_info;
pub type host_cpu_load_info_t = *mut host_cpu_load_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct host_preferred_user_arch {
    pub cpu_type: cpu_type_t,
    pub cpu_subtype: cpu_subtype_t,
}
#[test]
fn bindgen_test_layout_host_preferred_user_arch() {
    const UNINIT: ::core::mem::MaybeUninit<host_preferred_user_arch> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<host_preferred_user_arch>(),
        8usize,
        concat!("Size of: ", stringify!(host_preferred_user_arch))
    );
    assert_eq!(
        ::core::mem::align_of::<host_preferred_user_arch>(),
        4usize,
        concat!("Alignment of ", stringify!(host_preferred_user_arch))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(host_preferred_user_arch),
            "::",
            stringify!(cpu_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_subtype) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(host_preferred_user_arch),
            "::",
            stringify!(cpu_subtype)
        )
    );
}
pub type host_preferred_user_arch_data_t = host_preferred_user_arch;
pub type host_preferred_user_arch_t = *mut host_preferred_user_arch;
pub type vm_prot_t = ::libc::c_int;
pub type vm_sync_t = ::libc::c_uint;
pub type pointer_t = vm_offset_t;
pub type vm_address_t = vm_offset_t;
pub type addr64_t = u64;
pub type reg64_t = u32;
pub type ppnum_t = u32;
pub type vm_map_t = mach_port_t;
pub type vm_map_read_t = mach_port_t;
pub type vm_map_inspect_t = mach_port_t;
pub type vm_object_offset_t = u64;
pub type vm_object_size_t = u64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_vm_range {
    pub min_address: mach_vm_offset_t,
    pub max_address: mach_vm_offset_t,
}
#[test]
fn bindgen_test_layout_mach_vm_range() {
    const UNINIT: ::core::mem::MaybeUninit<mach_vm_range> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_vm_range>(),
        16usize,
        concat!("Size of: ", stringify!(mach_vm_range))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_vm_range>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_vm_range))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).min_address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_range),
            "::",
            stringify!(min_address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_address) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_range),
            "::",
            stringify!(max_address)
        )
    );
}
pub type mach_vm_range_t = *mut mach_vm_range;
pub type upl_t = mach_port_t;
pub type vm_named_entry_t = mach_port_t;
pub type memory_object_offset_t = ::libc::c_ulonglong;
pub type memory_object_size_t = ::libc::c_ulonglong;
pub type memory_object_cluster_size_t = natural_t;
pub type memory_object_fault_info_t = *mut natural_t;
pub type vm_object_id_t = ::libc::c_ulonglong;
pub type memory_object_t = mach_port_t;
pub type memory_object_control_t = mach_port_t;
pub type memory_object_array_t = *mut memory_object_t;
pub type memory_object_name_t = mach_port_t;
pub type memory_object_default_t = mach_port_t;
pub type memory_object_copy_strategy_t = ::libc::c_int;
pub type memory_object_return_t = ::libc::c_int;
pub type memory_object_info_t = *mut ::libc::c_int;
pub type memory_object_flavor_t = ::libc::c_int;
pub type memory_object_info_data_t = [::libc::c_int; 1024usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct memory_object_perf_info {
    pub cluster_size: memory_object_cluster_size_t,
    pub may_cache: boolean_t,
}
#[test]
fn bindgen_test_layout_memory_object_perf_info() {
    const UNINIT: ::core::mem::MaybeUninit<memory_object_perf_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<memory_object_perf_info>(),
        8usize,
        concat!("Size of: ", stringify!(memory_object_perf_info))
    );
    assert_eq!(
        ::core::mem::align_of::<memory_object_perf_info>(),
        4usize,
        concat!("Alignment of ", stringify!(memory_object_perf_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cluster_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_perf_info),
            "::",
            stringify!(cluster_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).may_cache) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_perf_info),
            "::",
            stringify!(may_cache)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct memory_object_attr_info {
    pub copy_strategy: memory_object_copy_strategy_t,
    pub cluster_size: memory_object_cluster_size_t,
    pub may_cache_object: boolean_t,
    pub temporary: boolean_t,
}
#[test]
fn bindgen_test_layout_memory_object_attr_info() {
    const UNINIT: ::core::mem::MaybeUninit<memory_object_attr_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<memory_object_attr_info>(),
        16usize,
        concat!("Size of: ", stringify!(memory_object_attr_info))
    );
    assert_eq!(
        ::core::mem::align_of::<memory_object_attr_info>(),
        4usize,
        concat!("Alignment of ", stringify!(memory_object_attr_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).copy_strategy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_attr_info),
            "::",
            stringify!(copy_strategy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cluster_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_attr_info),
            "::",
            stringify!(cluster_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).may_cache_object) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_attr_info),
            "::",
            stringify!(may_cache_object)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).temporary) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_attr_info),
            "::",
            stringify!(temporary)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct memory_object_behave_info {
    pub copy_strategy: memory_object_copy_strategy_t,
    pub temporary: boolean_t,
    pub invalidate: boolean_t,
    pub silent_overwrite: boolean_t,
    pub advisory_pageout: boolean_t,
}
#[test]
fn bindgen_test_layout_memory_object_behave_info() {
    const UNINIT: ::core::mem::MaybeUninit<memory_object_behave_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<memory_object_behave_info>(),
        20usize,
        concat!("Size of: ", stringify!(memory_object_behave_info))
    );
    assert_eq!(
        ::core::mem::align_of::<memory_object_behave_info>(),
        4usize,
        concat!("Alignment of ", stringify!(memory_object_behave_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).copy_strategy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_behave_info),
            "::",
            stringify!(copy_strategy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).temporary) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_behave_info),
            "::",
            stringify!(temporary)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).invalidate) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_behave_info),
            "::",
            stringify!(invalidate)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).silent_overwrite) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_behave_info),
            "::",
            stringify!(silent_overwrite)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).advisory_pageout) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(memory_object_behave_info),
            "::",
            stringify!(advisory_pageout)
        )
    );
}
pub type memory_object_behave_info_t = *mut memory_object_behave_info;
pub type memory_object_behave_info_data_t = memory_object_behave_info;
pub type memory_object_perf_info_t = *mut memory_object_perf_info;
pub type memory_object_perf_info_data_t = memory_object_perf_info;
pub type memory_object_attr_info_t = *mut memory_object_attr_info;
pub type memory_object_attr_info_data_t = memory_object_attr_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::libc::c_uint,
    pub __ebx: ::libc::c_uint,
    pub __ecx: ::libc::c_uint,
    pub __edx: ::libc::c_uint,
    pub __edi: ::libc::c_uint,
    pub __esi: ::libc::c_uint,
    pub __ebp: ::libc::c_uint,
    pub __esp: ::libc::c_uint,
    pub __ss: ::libc::c_uint,
    pub __eflags: ::libc::c_uint,
    pub __eip: ::libc::c_uint,
    pub __cs: ::libc::c_uint,
    pub __ds: ::libc::c_uint,
    pub __es: ::libc::c_uint,
    pub __fs: ::libc::c_uint,
    pub __gs: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_i386_thread_state() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_i386_thread_state> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_i386_thread_state>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_i386_thread_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__eax) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eax)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ebx) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ecx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ecx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__edx) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__edi) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edi)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__esi) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esi)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ebp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__esp) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__eflags) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eflags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__eip) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eip)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__cs) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ds) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__gs) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_control() {
    assert_eq!(
        ::core::mem::size_of::<__darwin_fp_control>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_control))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_fp_control>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_control))
    );
}
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __pc(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___pc(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn __rc(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___rc(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::libc::c_ushort,
        __denorm: ::libc::c_ushort,
        __zdiv: ::libc::c_ushort,
        __ovrfl: ::libc::c_ushort,
        __undfl: ::libc::c_ushort,
        __precis: ::libc::c_ushort,
        __pc: ::libc::c_ushort,
        __rc: ::libc::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::core::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::core::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::core::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::core::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::core::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::core::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::core::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::core::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_status() {
    assert_eq!(
        ::core::mem::size_of::<__darwin_fp_status>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_status))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_fp_status>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_status))
    );
}
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __stkflt(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___stkflt(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __errsumm(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___errsumm(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c0(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c0(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c1(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c1(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c2(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c2(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tos(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set___tos(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn __c3(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c3(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __busy(&self) -> ::libc::c_ushort {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___busy(&mut self, val: ::libc::c_ushort) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::libc::c_ushort,
        __denorm: ::libc::c_ushort,
        __zdiv: ::libc::c_ushort,
        __ovrfl: ::libc::c_ushort,
        __undfl: ::libc::c_ushort,
        __precis: ::libc::c_ushort,
        __stkflt: ::libc::c_ushort,
        __errsumm: ::libc::c_ushort,
        __c0: ::libc::c_ushort,
        __c1: ::libc::c_ushort,
        __c2: ::libc::c_ushort,
        __tos: ::libc::c_ushort,
        __c3: ::libc::c_ushort,
        __busy: ::libc::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::core::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::core::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::core::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::core::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::core::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::core::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::core::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::core::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::core::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::core::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::core::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::core::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::core::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::core::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::libc::c_char; 10usize],
    pub __mmst_rsrv: [::libc::c_char; 6usize],
}
#[test]
fn bindgen_test_layout___darwin_mmst_reg() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_mmst_reg> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_mmst_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_mmst_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__mmst_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_reg)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__mmst_rsrv) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_rsrv)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::libc::c_char; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_xmm_reg() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_xmm_reg> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_xmm_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_xmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__xmm_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_xmm_reg),
            "::",
            stringify!(__xmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::libc::c_char; 32usize],
}
#[test]
fn bindgen_test_layout___darwin_ymm_reg() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_ymm_reg> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_ymm_reg>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_ymm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ymm_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ymm_reg),
            "::",
            stringify!(__ymm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::libc::c_char; 64usize],
}
#[test]
fn bindgen_test_layout___darwin_zmm_reg() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_zmm_reg> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_zmm_reg>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_zmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__zmm_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_zmm_reg),
            "::",
            stringify!(__zmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::libc::c_char; 8usize],
}
#[test]
fn bindgen_test_layout___darwin_opmask_reg() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_opmask_reg> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_opmask_reg>(),
        8usize,
        concat!("Size of: ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_opmask_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__opmask_reg) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_opmask_reg),
            "::",
            stringify!(__opmask_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::libc::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::libc::c_char; 224usize],
    pub __fpu_reserved1: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___darwin_i386_float_state() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_i386_float_state> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_i386_float_state>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_i386_float_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::libc::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::libc::c_char; 224usize],
    pub __fpu_reserved1: ::libc::c_int,
    pub __avx_reserved1: [::libc::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx_state() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_i386_avx_state> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_i386_avx_state>(),
        716usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_i386_avx_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__avx_reserved1) as usize - ptr as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh0) as usize - ptr as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh1) as usize - ptr as usize },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh2) as usize - ptr as usize },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh3) as usize - ptr as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh4) as usize - ptr as usize },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh5) as usize - ptr as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh6) as usize - ptr as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh7) as usize - ptr as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::libc::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::libc::c_char; 224usize],
    pub __fpu_reserved1: ::libc::c_int,
    pub __avx_reserved1: [::libc::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx512_state() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_i386_avx512_state> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_i386_avx512_state>(),
        1036usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_i386_avx512_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__avx_reserved1) as usize - ptr as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh0) as usize - ptr as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh1) as usize - ptr as usize },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh2) as usize - ptr as usize },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh3) as usize - ptr as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh4) as usize - ptr as usize },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh5) as usize - ptr as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh6) as usize - ptr as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh7) as usize - ptr as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k0) as usize - ptr as usize },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k1) as usize - ptr as usize },
        724usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k2) as usize - ptr as usize },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k3) as usize - ptr as usize },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k4) as usize - ptr as usize },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k5) as usize - ptr as usize },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k6) as usize - ptr as usize },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k7) as usize - ptr as usize },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh0) as usize - ptr as usize },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh1) as usize - ptr as usize },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh2) as usize - ptr as usize },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh3) as usize - ptr as usize },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh4) as usize - ptr as usize },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh5) as usize - ptr as usize },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh6) as usize - ptr as usize },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh7) as usize - ptr as usize },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_i386_exception_state() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_i386_exception_state> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_i386_exception_state>(),
        12usize,
        concat!("Size of: ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_i386_exception_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__trapno) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__cpu) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__err) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__faultvaddr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::libc::c_uint,
    pub __dr1: ::libc::c_uint,
    pub __dr2: ::libc::c_uint,
    pub __dr3: ::libc::c_uint,
    pub __dr4: ::libc::c_uint,
    pub __dr5: ::libc::c_uint,
    pub __dr6: ::libc::c_uint,
    pub __dr7: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state32() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_x86_debug_state32> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_x86_debug_state32>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_x86_debug_state32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr0) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr1) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr2) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr3) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr4) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr5) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr6) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr7) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_instruction_state {
    pub __insn_stream_valid_bytes: ::libc::c_int,
    pub __insn_offset: ::libc::c_int,
    pub __out_of_synch: ::libc::c_int,
    pub __insn_bytes: [__uint8_t; 2380usize],
    pub __insn_cacheline: [__uint8_t; 64usize],
}
#[test]
fn bindgen_test_layout___x86_instruction_state() {
    const UNINIT: ::core::mem::MaybeUninit<__x86_instruction_state> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__x86_instruction_state>(),
        2456usize,
        concat!("Size of: ", stringify!(__x86_instruction_state))
    );
    assert_eq!(
        ::core::mem::align_of::<__x86_instruction_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_instruction_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__insn_stream_valid_bytes) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_stream_valid_bytes)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__insn_offset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__out_of_synch) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__out_of_synch)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__insn_bytes) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_bytes)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__insn_cacheline) as usize - ptr as usize },
        2392usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_cacheline)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __last_branch_record {
    pub __from_ip: __uint64_t,
    pub __to_ip: __uint64_t,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout___last_branch_record() {
    const UNINIT: ::core::mem::MaybeUninit<__last_branch_record> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__last_branch_record>(),
        24usize,
        concat!("Size of: ", stringify!(__last_branch_record))
    );
    assert_eq!(
        ::core::mem::align_of::<__last_branch_record>(),
        8usize,
        concat!("Alignment of ", stringify!(__last_branch_record))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__from_ip) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_record),
            "::",
            stringify!(__from_ip)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__to_ip) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_record),
            "::",
            stringify!(__to_ip)
        )
    );
}
impl __last_branch_record {
    #[inline]
    pub fn __mispredict(&self) -> __uint32_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___mispredict(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tsx_abort(&self) -> __uint32_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___tsx_abort(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __in_tsx(&self) -> __uint32_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___in_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __cycle_count(&self) -> __uint32_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set___cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(19usize, 13u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(19usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __mispredict: __uint32_t,
        __tsx_abort: __uint32_t,
        __in_tsx: __uint32_t,
        __cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __mispredict: u32 = unsafe { ::core::mem::transmute(__mispredict) };
            __mispredict as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __tsx_abort: u32 = unsafe { ::core::mem::transmute(__tsx_abort) };
            __tsx_abort as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __in_tsx: u32 = unsafe { ::core::mem::transmute(__in_tsx) };
            __in_tsx as u64
        });
        __bindgen_bitfield_unit.set(3usize, 16u8, {
            let __cycle_count: u32 = unsafe { ::core::mem::transmute(__cycle_count) };
            __cycle_count as u64
        });
        __bindgen_bitfield_unit.set(19usize, 13u8, {
            let __reserved: u32 = unsafe { ::core::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __last_branch_state {
    pub __lbr_count: ::libc::c_int,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __lbrs: [__last_branch_record; 32usize],
}
#[test]
fn bindgen_test_layout___last_branch_state() {
    const UNINIT: ::core::mem::MaybeUninit<__last_branch_state> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__last_branch_state>(),
        776usize,
        concat!("Size of: ", stringify!(__last_branch_state))
    );
    assert_eq!(
        ::core::mem::align_of::<__last_branch_state>(),
        8usize,
        concat!("Alignment of ", stringify!(__last_branch_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__lbr_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_state),
            "::",
            stringify!(__lbr_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__lbrs) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_state),
            "::",
            stringify!(__lbrs)
        )
    );
}
impl __last_branch_state {
    #[inline]
    pub fn __lbr_supported_tsx(&self) -> __uint32_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __lbr_supported_cycle_count(&self) -> __uint32_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __lbr_supported_tsx: __uint32_t,
        __lbr_supported_cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __lbr_supported_tsx: u32 = unsafe { ::core::mem::transmute(__lbr_supported_tsx) };
            __lbr_supported_tsx as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __lbr_supported_cycle_count: u32 =
                unsafe { ::core::mem::transmute(__lbr_supported_cycle_count) };
            __lbr_supported_cycle_count as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let __reserved: u32 = unsafe { ::core::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___x86_pagein_state() {
    const UNINIT: ::core::mem::MaybeUninit<__x86_pagein_state> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__x86_pagein_state>(),
        4usize,
        concat!("Size of: ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        ::core::mem::align_of::<__x86_pagein_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__pagein_error) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_pagein_state),
            "::",
            stringify!(__pagein_error)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_state64() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_x86_thread_state64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_x86_thread_state64>(),
        168usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_x86_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rax) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rax)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rbx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rcx) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rcx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rdx) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdx)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rdi) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdi)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rsi) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsi)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rbp) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rsp) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__r8) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__r9) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r9)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__r10) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r10)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__r11) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r11)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__r12) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r12)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__r13) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r13)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__r14) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r14)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__r15) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r15)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rip) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rip)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__rflags) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rflags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__cs) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fs) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__gs) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_full_state64() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_x86_thread_full_state64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_x86_thread_full_state64>(),
        200usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_full_state64))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_x86_thread_full_state64>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_x86_thread_full_state64)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ss64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss64)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ds) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__es) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ss) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__gsbase) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__gsbase)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::libc::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::libc::c_char; 96usize],
    pub __fpu_reserved1: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___darwin_x86_float_state64() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_x86_float_state64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_x86_float_state64>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_x86_float_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm8) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm9) as usize - ptr as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm10) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm11) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm12) as usize - ptr as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm13) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm14) as usize - ptr as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm15) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::libc::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::libc::c_char; 96usize],
    pub __fpu_reserved1: ::libc::c_int,
    pub __avx_reserved1: [::libc::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx_state64() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_x86_avx_state64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_x86_avx_state64>(),
        844usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_x86_avx_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm8) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm9) as usize - ptr as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm10) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm11) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm12) as usize - ptr as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm13) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm14) as usize - ptr as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm15) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__avx_reserved1) as usize - ptr as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh0) as usize - ptr as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh1) as usize - ptr as usize },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh2) as usize - ptr as usize },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh3) as usize - ptr as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh4) as usize - ptr as usize },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh5) as usize - ptr as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh6) as usize - ptr as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh7) as usize - ptr as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh8) as usize - ptr as usize },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh9) as usize - ptr as usize },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh10) as usize - ptr as usize },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh11) as usize - ptr as usize },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh12) as usize - ptr as usize },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh13) as usize - ptr as usize },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh14) as usize - ptr as usize },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh15) as usize - ptr as usize },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::libc::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::libc::c_char; 96usize],
    pub __fpu_reserved1: ::libc::c_int,
    pub __avx_reserved1: [::libc::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx512_state64() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_x86_avx512_state64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_x86_avx512_state64>(),
        2444usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_x86_avx512_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fcw) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fsw) as usize - ptr as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ftw) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv1) as usize - ptr as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_fop) as usize - ptr as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ip) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_cs) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv2) as usize - ptr as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_dp) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ds) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv3) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_mxcsrmask) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm0) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm1) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm2) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm3) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm4) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm5) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm6) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_stmm7) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm0) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm1) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm2) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm3) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm4) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm5) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm6) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm7) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm8) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm9) as usize - ptr as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm10) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm11) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm12) as usize - ptr as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm13) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm14) as usize - ptr as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_xmm15) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_rsrv4) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_reserved1) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__avx_reserved1) as usize - ptr as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh0) as usize - ptr as usize },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh1) as usize - ptr as usize },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh2) as usize - ptr as usize },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh3) as usize - ptr as usize },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh4) as usize - ptr as usize },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh5) as usize - ptr as usize },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh6) as usize - ptr as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh7) as usize - ptr as usize },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh8) as usize - ptr as usize },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh9) as usize - ptr as usize },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh10) as usize - ptr as usize },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh11) as usize - ptr as usize },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh12) as usize - ptr as usize },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh13) as usize - ptr as usize },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh14) as usize - ptr as usize },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_ymmh15) as usize - ptr as usize },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k0) as usize - ptr as usize },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k1) as usize - ptr as usize },
        852usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k2) as usize - ptr as usize },
        860usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k3) as usize - ptr as usize },
        868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k4) as usize - ptr as usize },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k5) as usize - ptr as usize },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k6) as usize - ptr as usize },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_k7) as usize - ptr as usize },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh0) as usize - ptr as usize },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh1) as usize - ptr as usize },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh2) as usize - ptr as usize },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh3) as usize - ptr as usize },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh4) as usize - ptr as usize },
        1036usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh5) as usize - ptr as usize },
        1068usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh6) as usize - ptr as usize },
        1100usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh7) as usize - ptr as usize },
        1132usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh8) as usize - ptr as usize },
        1164usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh8)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh9) as usize - ptr as usize },
        1196usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh9)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh10) as usize - ptr as usize },
        1228usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh10)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh11) as usize - ptr as usize },
        1260usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh11)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh12) as usize - ptr as usize },
        1292usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh12)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh13) as usize - ptr as usize },
        1324usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh13)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh14) as usize - ptr as usize },
        1356usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh14)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmmh15) as usize - ptr as usize },
        1388usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh15)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm16) as usize - ptr as usize },
        1420usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm16)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm17) as usize - ptr as usize },
        1484usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm17)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm18) as usize - ptr as usize },
        1548usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm18)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm19) as usize - ptr as usize },
        1612usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm19)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm20) as usize - ptr as usize },
        1676usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm20)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm21) as usize - ptr as usize },
        1740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm21)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm22) as usize - ptr as usize },
        1804usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm22)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm23) as usize - ptr as usize },
        1868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm23)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm24) as usize - ptr as usize },
        1932usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm24)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm25) as usize - ptr as usize },
        1996usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm25)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm26) as usize - ptr as usize },
        2060usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm26)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm27) as usize - ptr as usize },
        2124usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm27)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm28) as usize - ptr as usize },
        2188usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm28)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm29) as usize - ptr as usize },
        2252usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm29)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm30) as usize - ptr as usize },
        2316usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm30)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__fpu_zmm31) as usize - ptr as usize },
        2380usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm31)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_exception_state64() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_x86_exception_state64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_x86_exception_state64>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_x86_exception_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__trapno) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__cpu) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__err) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__faultvaddr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state64() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_x86_debug_state64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_x86_debug_state64>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_x86_debug_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr0) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr1) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr2) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr3) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr4) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr5) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr6) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__dr7) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_x86_cpmu_state64() {
    const UNINIT: ::core::mem::MaybeUninit<__darwin_x86_cpmu_state64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__darwin_x86_cpmu_state64>(),
        128usize,
        concat!("Size of: ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        ::core::mem::align_of::<__darwin_x86_cpmu_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__ctrs) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_cpmu_state64),
            "::",
            stringify!(__ctrs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x86_state_hdr {
    pub flavor: u32,
    pub count: u32,
}
#[test]
fn bindgen_test_layout_x86_state_hdr() {
    const UNINIT: ::core::mem::MaybeUninit<x86_state_hdr> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_state_hdr>(),
        8usize,
        concat!("Size of: ", stringify!(x86_state_hdr))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_state_hdr>(),
        4usize,
        concat!("Alignment of ", stringify!(x86_state_hdr))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_state_hdr),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_state_hdr),
            "::",
            stringify!(count)
        )
    );
}
pub type x86_state_hdr_t = x86_state_hdr;
pub type i386_thread_state_t = __darwin_i386_thread_state;
pub type x86_thread_state32_t = __darwin_i386_thread_state;
pub type i386_float_state_t = __darwin_i386_float_state;
pub type x86_float_state32_t = __darwin_i386_float_state;
pub type x86_avx_state32_t = __darwin_i386_avx_state;
pub type x86_avx512_state32_t = __darwin_i386_avx512_state;
pub type i386_exception_state_t = __darwin_i386_exception_state;
pub type x86_exception_state32_t = __darwin_i386_exception_state;
pub type x86_debug_state32_t = __darwin_x86_debug_state32;
pub type x86_thread_state64_t = __darwin_x86_thread_state64;
pub type x86_thread_full_state64_t = __darwin_x86_thread_full_state64;
pub type x86_float_state64_t = __darwin_x86_float_state64;
pub type x86_avx_state64_t = __darwin_x86_avx_state64;
pub type x86_avx512_state64_t = __darwin_x86_avx512_state64;
pub type x86_exception_state64_t = __darwin_x86_exception_state64;
pub type x86_debug_state64_t = __darwin_x86_debug_state64;
pub type x86_pagein_state_t = __x86_pagein_state;
pub type x86_instruction_state_t = __x86_instruction_state;
pub type last_branch_state_t = __last_branch_state;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct x86_thread_state {
    pub tsh: x86_state_hdr_t,
    pub uts: x86_thread_state__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union x86_thread_state__bindgen_ty_1 {
    pub ts32: x86_thread_state32_t,
    pub ts64: x86_thread_state64_t,
}
#[test]
fn bindgen_test_layout_x86_thread_state__bindgen_ty_1() {
    const UNINIT: ::core::mem::MaybeUninit<x86_thread_state__bindgen_ty_1> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_thread_state__bindgen_ty_1>(),
        168usize,
        concat!("Size of: ", stringify!(x86_thread_state__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_thread_state__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(x86_thread_state__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ts32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_thread_state__bindgen_ty_1),
            "::",
            stringify!(ts32)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ts64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_thread_state__bindgen_ty_1),
            "::",
            stringify!(ts64)
        )
    );
}
#[test]
fn bindgen_test_layout_x86_thread_state() {
    const UNINIT: ::core::mem::MaybeUninit<x86_thread_state> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_thread_state>(),
        176usize,
        concat!("Size of: ", stringify!(x86_thread_state))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_thread_state>(),
        8usize,
        concat!("Alignment of ", stringify!(x86_thread_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tsh) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_thread_state),
            "::",
            stringify!(tsh)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).uts) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_thread_state),
            "::",
            stringify!(uts)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct x86_float_state {
    pub fsh: x86_state_hdr_t,
    pub ufs: x86_float_state__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union x86_float_state__bindgen_ty_1 {
    pub fs32: x86_float_state32_t,
    pub fs64: x86_float_state64_t,
}
#[test]
fn bindgen_test_layout_x86_float_state__bindgen_ty_1() {
    const UNINIT: ::core::mem::MaybeUninit<x86_float_state__bindgen_ty_1> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_float_state__bindgen_ty_1>(),
        524usize,
        concat!("Size of: ", stringify!(x86_float_state__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_float_state__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(x86_float_state__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fs32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_float_state__bindgen_ty_1),
            "::",
            stringify!(fs32)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fs64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_float_state__bindgen_ty_1),
            "::",
            stringify!(fs64)
        )
    );
}
#[test]
fn bindgen_test_layout_x86_float_state() {
    const UNINIT: ::core::mem::MaybeUninit<x86_float_state> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_float_state>(),
        532usize,
        concat!("Size of: ", stringify!(x86_float_state))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_float_state>(),
        4usize,
        concat!("Alignment of ", stringify!(x86_float_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fsh) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_float_state),
            "::",
            stringify!(fsh)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ufs) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_float_state),
            "::",
            stringify!(ufs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct x86_exception_state {
    pub esh: x86_state_hdr_t,
    pub ues: x86_exception_state__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union x86_exception_state__bindgen_ty_1 {
    pub es32: x86_exception_state32_t,
    pub es64: x86_exception_state64_t,
}
#[test]
fn bindgen_test_layout_x86_exception_state__bindgen_ty_1() {
    const UNINIT: ::core::mem::MaybeUninit<x86_exception_state__bindgen_ty_1> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_exception_state__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(x86_exception_state__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_exception_state__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(x86_exception_state__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).es32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_exception_state__bindgen_ty_1),
            "::",
            stringify!(es32)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).es64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_exception_state__bindgen_ty_1),
            "::",
            stringify!(es64)
        )
    );
}
#[test]
fn bindgen_test_layout_x86_exception_state() {
    const UNINIT: ::core::mem::MaybeUninit<x86_exception_state> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_exception_state>(),
        24usize,
        concat!("Size of: ", stringify!(x86_exception_state))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_exception_state>(),
        8usize,
        concat!("Alignment of ", stringify!(x86_exception_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).esh) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_exception_state),
            "::",
            stringify!(esh)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ues) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_exception_state),
            "::",
            stringify!(ues)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct x86_debug_state {
    pub dsh: x86_state_hdr_t,
    pub uds: x86_debug_state__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union x86_debug_state__bindgen_ty_1 {
    pub ds32: x86_debug_state32_t,
    pub ds64: x86_debug_state64_t,
}
#[test]
fn bindgen_test_layout_x86_debug_state__bindgen_ty_1() {
    const UNINIT: ::core::mem::MaybeUninit<x86_debug_state__bindgen_ty_1> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_debug_state__bindgen_ty_1>(),
        64usize,
        concat!("Size of: ", stringify!(x86_debug_state__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_debug_state__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(x86_debug_state__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ds32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_debug_state__bindgen_ty_1),
            "::",
            stringify!(ds32)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ds64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_debug_state__bindgen_ty_1),
            "::",
            stringify!(ds64)
        )
    );
}
#[test]
fn bindgen_test_layout_x86_debug_state() {
    const UNINIT: ::core::mem::MaybeUninit<x86_debug_state> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_debug_state>(),
        72usize,
        concat!("Size of: ", stringify!(x86_debug_state))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_debug_state>(),
        8usize,
        concat!("Alignment of ", stringify!(x86_debug_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dsh) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_debug_state),
            "::",
            stringify!(dsh)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).uds) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_debug_state),
            "::",
            stringify!(uds)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct x86_avx_state {
    pub ash: x86_state_hdr_t,
    pub ufs: x86_avx_state__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union x86_avx_state__bindgen_ty_1 {
    pub as32: x86_avx_state32_t,
    pub as64: x86_avx_state64_t,
}
#[test]
fn bindgen_test_layout_x86_avx_state__bindgen_ty_1() {
    const UNINIT: ::core::mem::MaybeUninit<x86_avx_state__bindgen_ty_1> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_avx_state__bindgen_ty_1>(),
        844usize,
        concat!("Size of: ", stringify!(x86_avx_state__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_avx_state__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(x86_avx_state__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).as32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_avx_state__bindgen_ty_1),
            "::",
            stringify!(as32)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).as64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_avx_state__bindgen_ty_1),
            "::",
            stringify!(as64)
        )
    );
}
#[test]
fn bindgen_test_layout_x86_avx_state() {
    const UNINIT: ::core::mem::MaybeUninit<x86_avx_state> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_avx_state>(),
        852usize,
        concat!("Size of: ", stringify!(x86_avx_state))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_avx_state>(),
        4usize,
        concat!("Alignment of ", stringify!(x86_avx_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ash) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_avx_state),
            "::",
            stringify!(ash)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ufs) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_avx_state),
            "::",
            stringify!(ufs)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct x86_avx512_state {
    pub ash: x86_state_hdr_t,
    pub ufs: x86_avx512_state__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union x86_avx512_state__bindgen_ty_1 {
    pub as32: x86_avx512_state32_t,
    pub as64: x86_avx512_state64_t,
}
#[test]
fn bindgen_test_layout_x86_avx512_state__bindgen_ty_1() {
    const UNINIT: ::core::mem::MaybeUninit<x86_avx512_state__bindgen_ty_1> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_avx512_state__bindgen_ty_1>(),
        2444usize,
        concat!("Size of: ", stringify!(x86_avx512_state__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_avx512_state__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(x86_avx512_state__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).as32) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_avx512_state__bindgen_ty_1),
            "::",
            stringify!(as32)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).as64) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_avx512_state__bindgen_ty_1),
            "::",
            stringify!(as64)
        )
    );
}
#[test]
fn bindgen_test_layout_x86_avx512_state() {
    const UNINIT: ::core::mem::MaybeUninit<x86_avx512_state> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<x86_avx512_state>(),
        2452usize,
        concat!("Size of: ", stringify!(x86_avx512_state))
    );
    assert_eq!(
        ::core::mem::align_of::<x86_avx512_state>(),
        4usize,
        concat!("Alignment of ", stringify!(x86_avx512_state))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ash) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_avx512_state),
            "::",
            stringify!(ash)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ufs) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(x86_avx512_state),
            "::",
            stringify!(ufs)
        )
    );
}
pub type x86_thread_state_t = x86_thread_state;
pub type x86_float_state_t = x86_float_state;
pub type x86_exception_state_t = x86_exception_state;
pub type x86_debug_state_t = x86_debug_state;
pub type x86_avx_state_t = x86_avx_state;
pub type x86_avx512_state_t = x86_avx512_state;
pub type thread_state_t = *mut natural_t;
pub type thread_state_data_t = [natural_t; 1296usize];
pub type thread_state_flavor_t = ::libc::c_int;
pub type thread_state_flavor_array_t = *mut thread_state_flavor_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ipc_info_space {
    pub iis_genno_mask: natural_t,
    pub iis_table_size: natural_t,
    pub iis_table_next: natural_t,
    pub iis_tree_size: natural_t,
    pub iis_tree_small: natural_t,
    pub iis_tree_hash: natural_t,
}
#[test]
fn bindgen_test_layout_ipc_info_space() {
    const UNINIT: ::core::mem::MaybeUninit<ipc_info_space> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<ipc_info_space>(),
        24usize,
        concat!("Size of: ", stringify!(ipc_info_space))
    );
    assert_eq!(
        ::core::mem::align_of::<ipc_info_space>(),
        4usize,
        concat!("Alignment of ", stringify!(ipc_info_space))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iis_genno_mask) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space),
            "::",
            stringify!(iis_genno_mask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iis_table_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space),
            "::",
            stringify!(iis_table_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iis_table_next) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space),
            "::",
            stringify!(iis_table_next)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iis_tree_size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space),
            "::",
            stringify!(iis_tree_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iis_tree_small) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space),
            "::",
            stringify!(iis_tree_small)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iis_tree_hash) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space),
            "::",
            stringify!(iis_tree_hash)
        )
    );
}
pub type ipc_info_space_t = ipc_info_space;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ipc_info_space_basic {
    pub iisb_genno_mask: natural_t,
    pub iisb_table_size: natural_t,
    pub iisb_table_next: natural_t,
    pub iisb_table_inuse: natural_t,
    pub iisb_reserved: [natural_t; 2usize],
}
#[test]
fn bindgen_test_layout_ipc_info_space_basic() {
    const UNINIT: ::core::mem::MaybeUninit<ipc_info_space_basic> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<ipc_info_space_basic>(),
        24usize,
        concat!("Size of: ", stringify!(ipc_info_space_basic))
    );
    assert_eq!(
        ::core::mem::align_of::<ipc_info_space_basic>(),
        4usize,
        concat!("Alignment of ", stringify!(ipc_info_space_basic))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iisb_genno_mask) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space_basic),
            "::",
            stringify!(iisb_genno_mask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iisb_table_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space_basic),
            "::",
            stringify!(iisb_table_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iisb_table_next) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space_basic),
            "::",
            stringify!(iisb_table_next)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iisb_table_inuse) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space_basic),
            "::",
            stringify!(iisb_table_inuse)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iisb_reserved) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_space_basic),
            "::",
            stringify!(iisb_reserved)
        )
    );
}
pub type ipc_info_space_basic_t = ipc_info_space_basic;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ipc_info_name {
    pub iin_name: mach_port_name_t,
    pub iin_collision: integer_t,
    pub iin_type: mach_port_type_t,
    pub iin_urefs: mach_port_urefs_t,
    pub iin_object: natural_t,
    pub iin_next: natural_t,
    pub iin_hash: natural_t,
}
#[test]
fn bindgen_test_layout_ipc_info_name() {
    const UNINIT: ::core::mem::MaybeUninit<ipc_info_name> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<ipc_info_name>(),
        28usize,
        concat!("Size of: ", stringify!(ipc_info_name))
    );
    assert_eq!(
        ::core::mem::align_of::<ipc_info_name>(),
        4usize,
        concat!("Alignment of ", stringify!(ipc_info_name))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iin_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_name),
            "::",
            stringify!(iin_name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iin_collision) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_name),
            "::",
            stringify!(iin_collision)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iin_type) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_name),
            "::",
            stringify!(iin_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iin_urefs) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_name),
            "::",
            stringify!(iin_urefs)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iin_object) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_name),
            "::",
            stringify!(iin_object)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iin_next) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_name),
            "::",
            stringify!(iin_next)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iin_hash) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_name),
            "::",
            stringify!(iin_hash)
        )
    );
}
pub type ipc_info_name_t = ipc_info_name;
pub type ipc_info_name_array_t = *mut ipc_info_name_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ipc_info_tree_name {
    pub iitn_name: ipc_info_name_t,
    pub iitn_lchild: mach_port_name_t,
    pub iitn_rchild: mach_port_name_t,
}
#[test]
fn bindgen_test_layout_ipc_info_tree_name() {
    const UNINIT: ::core::mem::MaybeUninit<ipc_info_tree_name> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<ipc_info_tree_name>(),
        36usize,
        concat!("Size of: ", stringify!(ipc_info_tree_name))
    );
    assert_eq!(
        ::core::mem::align_of::<ipc_info_tree_name>(),
        4usize,
        concat!("Alignment of ", stringify!(ipc_info_tree_name))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iitn_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_tree_name),
            "::",
            stringify!(iitn_name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iitn_lchild) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_tree_name),
            "::",
            stringify!(iitn_lchild)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iitn_rchild) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_tree_name),
            "::",
            stringify!(iitn_rchild)
        )
    );
}
pub type ipc_info_tree_name_t = ipc_info_tree_name;
pub type ipc_info_tree_name_array_t = *mut ipc_info_tree_name_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ipc_info_port {
    pub iip_port_object: natural_t,
    pub iip_receiver_object: natural_t,
}
#[test]
fn bindgen_test_layout_ipc_info_port() {
    const UNINIT: ::core::mem::MaybeUninit<ipc_info_port> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<ipc_info_port>(),
        8usize,
        concat!("Size of: ", stringify!(ipc_info_port))
    );
    assert_eq!(
        ::core::mem::align_of::<ipc_info_port>(),
        4usize,
        concat!("Alignment of ", stringify!(ipc_info_port))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iip_port_object) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_port),
            "::",
            stringify!(iip_port_object)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iip_receiver_object) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ipc_info_port),
            "::",
            stringify!(iip_receiver_object)
        )
    );
}
pub type ipc_info_port_t = ipc_info_port;
pub type exception_handler_info_array_t = *mut ipc_info_port_t;
pub type exception_type_t = ::libc::c_int;
pub type exception_data_type_t = integer_t;
pub type mach_exception_data_type_t = i64;
pub type exception_behavior_t = ::libc::c_int;
pub type exception_data_t = *mut exception_data_type_t;
pub type mach_exception_data_t = *mut mach_exception_data_type_t;
pub type exception_mask_t = ::libc::c_uint;
pub type exception_mask_array_t = *mut exception_mask_t;
pub type exception_behavior_array_t = *mut exception_behavior_t;
pub type exception_flavor_array_t = *mut thread_state_flavor_t;
pub type exception_port_array_t = *mut mach_port_t;
pub type exception_port_info_array_t = *mut ipc_info_port_t;
pub type mach_exception_code_t = mach_exception_data_type_t;
pub type mach_exception_subcode_t = mach_exception_data_type_t;
pub type uuid_t = __darwin_uuid_t;
pub type mach_voucher_t = mach_port_t;
pub type mach_voucher_name_t = mach_port_name_t;
pub type mach_voucher_name_array_t = *mut mach_voucher_name_t;
pub type ipc_voucher_t = mach_voucher_t;
pub type mach_voucher_selector_t = u32;
pub type mach_voucher_attr_key_t = u32;
pub type mach_voucher_attr_key_array_t = *mut mach_voucher_attr_key_t;
pub type mach_voucher_attr_content_t = *mut u8;
pub type mach_voucher_attr_content_size_t = u32;
pub type mach_voucher_attr_command_t = u32;
pub type mach_voucher_attr_recipe_command_t = u32;
pub type mach_voucher_attr_recipe_command_array_t = *mut mach_voucher_attr_recipe_command_t;
#[repr(C, packed)]
pub struct mach_voucher_attr_recipe_data {
    pub key: mach_voucher_attr_key_t,
    pub command: mach_voucher_attr_recipe_command_t,
    pub previous_voucher: mach_voucher_name_t,
    pub content_size: mach_voucher_attr_content_size_t,
    pub content: __IncompleteArrayField<u8>,
}
#[test]
fn bindgen_test_layout_mach_voucher_attr_recipe_data() {
    const UNINIT: ::core::mem::MaybeUninit<mach_voucher_attr_recipe_data> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_voucher_attr_recipe_data>(),
        16usize,
        concat!("Size of: ", stringify!(mach_voucher_attr_recipe_data))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_voucher_attr_recipe_data>(),
        1usize,
        concat!("Alignment of ", stringify!(mach_voucher_attr_recipe_data))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).key) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_voucher_attr_recipe_data),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).command) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_voucher_attr_recipe_data),
            "::",
            stringify!(command)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).previous_voucher) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_voucher_attr_recipe_data),
            "::",
            stringify!(previous_voucher)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).content_size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_voucher_attr_recipe_data),
            "::",
            stringify!(content_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).content) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_voucher_attr_recipe_data),
            "::",
            stringify!(content)
        )
    );
}
pub type mach_voucher_attr_recipe_data_t = mach_voucher_attr_recipe_data;
pub type mach_voucher_attr_recipe_t = *mut mach_voucher_attr_recipe_data_t;
pub type mach_voucher_attr_recipe_size_t = mach_msg_type_number_t;
pub type mach_voucher_attr_raw_recipe_t = *mut u8;
pub type mach_voucher_attr_raw_recipe_array_t = mach_voucher_attr_raw_recipe_t;
pub type mach_voucher_attr_raw_recipe_size_t = mach_msg_type_number_t;
pub type mach_voucher_attr_raw_recipe_array_size_t = mach_msg_type_number_t;
pub type mach_voucher_attr_manager_t = mach_port_t;
pub type mach_voucher_attr_control_t = mach_port_t;
pub type ipc_voucher_attr_manager_t = mach_port_t;
pub type ipc_voucher_attr_control_t = mach_port_t;
pub type mach_voucher_attr_value_handle_t = u64;
pub type mach_voucher_attr_value_handle_array_t = *mut mach_voucher_attr_value_handle_t;
pub type mach_voucher_attr_value_handle_array_size_t = mach_msg_type_number_t;
pub type mach_voucher_attr_value_reference_t = u32;
pub type mach_voucher_attr_value_flags_t = u32;
pub type mach_voucher_attr_control_flags_t = u32;
pub type mach_voucher_attr_importance_refs = u32;
pub type processor_info_t = *mut integer_t;
pub type processor_info_array_t = *mut integer_t;
pub type processor_info_data_t = [integer_t; 1024usize];
pub type processor_set_info_t = *mut integer_t;
pub type processor_set_info_data_t = [integer_t; 1024usize];
pub type processor_flavor_t = ::libc::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct processor_basic_info {
    pub cpu_type: cpu_type_t,
    pub cpu_subtype: cpu_subtype_t,
    pub running: boolean_t,
    pub slot_num: ::libc::c_int,
    pub __bindgen_anon_1: processor_basic_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union processor_basic_info__bindgen_ty_1 {
    pub is_master: boolean_t,
    pub is_main: boolean_t,
}
#[test]
fn bindgen_test_layout_processor_basic_info__bindgen_ty_1() {
    const UNINIT: ::core::mem::MaybeUninit<processor_basic_info__bindgen_ty_1> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<processor_basic_info__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(processor_basic_info__bindgen_ty_1))
    );
    assert_eq!(
        ::core::mem::align_of::<processor_basic_info__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(processor_basic_info__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).is_master) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_basic_info__bindgen_ty_1),
            "::",
            stringify!(is_master)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).is_main) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_basic_info__bindgen_ty_1),
            "::",
            stringify!(is_main)
        )
    );
}
#[test]
fn bindgen_test_layout_processor_basic_info() {
    const UNINIT: ::core::mem::MaybeUninit<processor_basic_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<processor_basic_info>(),
        20usize,
        concat!("Size of: ", stringify!(processor_basic_info))
    );
    assert_eq!(
        ::core::mem::align_of::<processor_basic_info>(),
        4usize,
        concat!("Alignment of ", stringify!(processor_basic_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_type) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_basic_info),
            "::",
            stringify!(cpu_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_subtype) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_basic_info),
            "::",
            stringify!(cpu_subtype)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).running) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_basic_info),
            "::",
            stringify!(running)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).slot_num) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_basic_info),
            "::",
            stringify!(slot_num)
        )
    );
}
pub type processor_basic_info_data_t = processor_basic_info;
pub type processor_basic_info_t = *mut processor_basic_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct processor_cpu_load_info {
    pub cpu_ticks: [::libc::c_uint; 4usize],
}
#[test]
fn bindgen_test_layout_processor_cpu_load_info() {
    const UNINIT: ::core::mem::MaybeUninit<processor_cpu_load_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<processor_cpu_load_info>(),
        16usize,
        concat!("Size of: ", stringify!(processor_cpu_load_info))
    );
    assert_eq!(
        ::core::mem::align_of::<processor_cpu_load_info>(),
        4usize,
        concat!("Alignment of ", stringify!(processor_cpu_load_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_ticks) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_cpu_load_info),
            "::",
            stringify!(cpu_ticks)
        )
    );
}
pub type processor_cpu_load_info_data_t = processor_cpu_load_info;
pub type processor_cpu_load_info_t = *mut processor_cpu_load_info;
pub type processor_set_flavor_t = ::libc::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct processor_set_basic_info {
    pub processor_count: ::libc::c_int,
    pub default_policy: ::libc::c_int,
}
#[test]
fn bindgen_test_layout_processor_set_basic_info() {
    const UNINIT: ::core::mem::MaybeUninit<processor_set_basic_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<processor_set_basic_info>(),
        8usize,
        concat!("Size of: ", stringify!(processor_set_basic_info))
    );
    assert_eq!(
        ::core::mem::align_of::<processor_set_basic_info>(),
        4usize,
        concat!("Alignment of ", stringify!(processor_set_basic_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).processor_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_set_basic_info),
            "::",
            stringify!(processor_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).default_policy) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_set_basic_info),
            "::",
            stringify!(default_policy)
        )
    );
}
pub type processor_set_basic_info_data_t = processor_set_basic_info;
pub type processor_set_basic_info_t = *mut processor_set_basic_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct processor_set_load_info {
    pub task_count: ::libc::c_int,
    pub thread_count: ::libc::c_int,
    pub load_average: integer_t,
    pub mach_factor: integer_t,
}
#[test]
fn bindgen_test_layout_processor_set_load_info() {
    const UNINIT: ::core::mem::MaybeUninit<processor_set_load_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<processor_set_load_info>(),
        16usize,
        concat!("Size of: ", stringify!(processor_set_load_info))
    );
    assert_eq!(
        ::core::mem::align_of::<processor_set_load_info>(),
        4usize,
        concat!("Alignment of ", stringify!(processor_set_load_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_set_load_info),
            "::",
            stringify!(task_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).thread_count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_set_load_info),
            "::",
            stringify!(thread_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).load_average) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_set_load_info),
            "::",
            stringify!(load_average)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mach_factor) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(processor_set_load_info),
            "::",
            stringify!(mach_factor)
        )
    );
}
pub type processor_set_load_info_data_t = processor_set_load_info;
pub type processor_set_load_info_t = *mut processor_set_load_info;
pub type policy_t = ::libc::c_int;
pub type policy_info_t = *mut integer_t;
pub type policy_base_t = *mut integer_t;
pub type policy_limit_t = *mut integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_timeshare_base {
    pub base_priority: integer_t,
}
#[test]
fn bindgen_test_layout_policy_timeshare_base() {
    const UNINIT: ::core::mem::MaybeUninit<policy_timeshare_base> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_timeshare_base>(),
        4usize,
        concat!("Size of: ", stringify!(policy_timeshare_base))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_timeshare_base>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_timeshare_base))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).base_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_timeshare_base),
            "::",
            stringify!(base_priority)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_timeshare_limit {
    pub max_priority: integer_t,
}
#[test]
fn bindgen_test_layout_policy_timeshare_limit() {
    const UNINIT: ::core::mem::MaybeUninit<policy_timeshare_limit> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_timeshare_limit>(),
        4usize,
        concat!("Size of: ", stringify!(policy_timeshare_limit))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_timeshare_limit>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_timeshare_limit))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_timeshare_limit),
            "::",
            stringify!(max_priority)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_timeshare_info {
    pub max_priority: integer_t,
    pub base_priority: integer_t,
    pub cur_priority: integer_t,
    pub depressed: boolean_t,
    pub depress_priority: integer_t,
}
#[test]
fn bindgen_test_layout_policy_timeshare_info() {
    const UNINIT: ::core::mem::MaybeUninit<policy_timeshare_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_timeshare_info>(),
        20usize,
        concat!("Size of: ", stringify!(policy_timeshare_info))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_timeshare_info>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_timeshare_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_timeshare_info),
            "::",
            stringify!(max_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).base_priority) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_timeshare_info),
            "::",
            stringify!(base_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cur_priority) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_timeshare_info),
            "::",
            stringify!(cur_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).depressed) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_timeshare_info),
            "::",
            stringify!(depressed)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).depress_priority) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_timeshare_info),
            "::",
            stringify!(depress_priority)
        )
    );
}
pub type policy_timeshare_base_t = *mut policy_timeshare_base;
pub type policy_timeshare_limit_t = *mut policy_timeshare_limit;
pub type policy_timeshare_info_t = *mut policy_timeshare_info;
pub type policy_timeshare_base_data_t = policy_timeshare_base;
pub type policy_timeshare_limit_data_t = policy_timeshare_limit;
pub type policy_timeshare_info_data_t = policy_timeshare_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_rr_base {
    pub base_priority: integer_t,
    pub quantum: integer_t,
}
#[test]
fn bindgen_test_layout_policy_rr_base() {
    const UNINIT: ::core::mem::MaybeUninit<policy_rr_base> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_rr_base>(),
        8usize,
        concat!("Size of: ", stringify!(policy_rr_base))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_rr_base>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_rr_base))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).base_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_rr_base),
            "::",
            stringify!(base_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).quantum) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_rr_base),
            "::",
            stringify!(quantum)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_rr_limit {
    pub max_priority: integer_t,
}
#[test]
fn bindgen_test_layout_policy_rr_limit() {
    const UNINIT: ::core::mem::MaybeUninit<policy_rr_limit> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_rr_limit>(),
        4usize,
        concat!("Size of: ", stringify!(policy_rr_limit))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_rr_limit>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_rr_limit))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_rr_limit),
            "::",
            stringify!(max_priority)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_rr_info {
    pub max_priority: integer_t,
    pub base_priority: integer_t,
    pub quantum: integer_t,
    pub depressed: boolean_t,
    pub depress_priority: integer_t,
}
#[test]
fn bindgen_test_layout_policy_rr_info() {
    const UNINIT: ::core::mem::MaybeUninit<policy_rr_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_rr_info>(),
        20usize,
        concat!("Size of: ", stringify!(policy_rr_info))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_rr_info>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_rr_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_rr_info),
            "::",
            stringify!(max_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).base_priority) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_rr_info),
            "::",
            stringify!(base_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).quantum) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_rr_info),
            "::",
            stringify!(quantum)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).depressed) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_rr_info),
            "::",
            stringify!(depressed)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).depress_priority) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_rr_info),
            "::",
            stringify!(depress_priority)
        )
    );
}
pub type policy_rr_base_t = *mut policy_rr_base;
pub type policy_rr_limit_t = *mut policy_rr_limit;
pub type policy_rr_info_t = *mut policy_rr_info;
pub type policy_rr_base_data_t = policy_rr_base;
pub type policy_rr_limit_data_t = policy_rr_limit;
pub type policy_rr_info_data_t = policy_rr_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_fifo_base {
    pub base_priority: integer_t,
}
#[test]
fn bindgen_test_layout_policy_fifo_base() {
    const UNINIT: ::core::mem::MaybeUninit<policy_fifo_base> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_fifo_base>(),
        4usize,
        concat!("Size of: ", stringify!(policy_fifo_base))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_fifo_base>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_fifo_base))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).base_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_fifo_base),
            "::",
            stringify!(base_priority)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_fifo_limit {
    pub max_priority: integer_t,
}
#[test]
fn bindgen_test_layout_policy_fifo_limit() {
    const UNINIT: ::core::mem::MaybeUninit<policy_fifo_limit> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_fifo_limit>(),
        4usize,
        concat!("Size of: ", stringify!(policy_fifo_limit))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_fifo_limit>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_fifo_limit))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_fifo_limit),
            "::",
            stringify!(max_priority)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_fifo_info {
    pub max_priority: integer_t,
    pub base_priority: integer_t,
    pub depressed: boolean_t,
    pub depress_priority: integer_t,
}
#[test]
fn bindgen_test_layout_policy_fifo_info() {
    const UNINIT: ::core::mem::MaybeUninit<policy_fifo_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_fifo_info>(),
        16usize,
        concat!("Size of: ", stringify!(policy_fifo_info))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_fifo_info>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_fifo_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_fifo_info),
            "::",
            stringify!(max_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).base_priority) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_fifo_info),
            "::",
            stringify!(base_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).depressed) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_fifo_info),
            "::",
            stringify!(depressed)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).depress_priority) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_fifo_info),
            "::",
            stringify!(depress_priority)
        )
    );
}
pub type policy_fifo_base_t = *mut policy_fifo_base;
pub type policy_fifo_limit_t = *mut policy_fifo_limit;
pub type policy_fifo_info_t = *mut policy_fifo_info;
pub type policy_fifo_base_data_t = policy_fifo_base;
pub type policy_fifo_limit_data_t = policy_fifo_limit;
pub type policy_fifo_info_data_t = policy_fifo_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_bases {
    pub ts: policy_timeshare_base_data_t,
    pub rr: policy_rr_base_data_t,
    pub fifo: policy_fifo_base_data_t,
}
#[test]
fn bindgen_test_layout_policy_bases() {
    const UNINIT: ::core::mem::MaybeUninit<policy_bases> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_bases>(),
        16usize,
        concat!("Size of: ", stringify!(policy_bases))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_bases>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_bases))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ts) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_bases),
            "::",
            stringify!(ts)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).rr) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_bases),
            "::",
            stringify!(rr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fifo) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_bases),
            "::",
            stringify!(fifo)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_limits {
    pub ts: policy_timeshare_limit_data_t,
    pub rr: policy_rr_limit_data_t,
    pub fifo: policy_fifo_limit_data_t,
}
#[test]
fn bindgen_test_layout_policy_limits() {
    const UNINIT: ::core::mem::MaybeUninit<policy_limits> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_limits>(),
        12usize,
        concat!("Size of: ", stringify!(policy_limits))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_limits>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_limits))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ts) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_limits),
            "::",
            stringify!(ts)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).rr) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_limits),
            "::",
            stringify!(rr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fifo) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_limits),
            "::",
            stringify!(fifo)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct policy_infos {
    pub ts: policy_timeshare_info_data_t,
    pub rr: policy_rr_info_data_t,
    pub fifo: policy_fifo_info_data_t,
}
#[test]
fn bindgen_test_layout_policy_infos() {
    const UNINIT: ::core::mem::MaybeUninit<policy_infos> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<policy_infos>(),
        56usize,
        concat!("Size of: ", stringify!(policy_infos))
    );
    assert_eq!(
        ::core::mem::align_of::<policy_infos>(),
        4usize,
        concat!("Alignment of ", stringify!(policy_infos))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ts) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_infos),
            "::",
            stringify!(ts)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).rr) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_infos),
            "::",
            stringify!(rr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fifo) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(policy_infos),
            "::",
            stringify!(fifo)
        )
    );
}
pub type policy_base_data_t = policy_bases;
pub type policy_limit_data_t = policy_limits;
pub type policy_info_data_t = policy_infos;
pub type task_flavor_t = natural_t;
pub type task_info_t = *mut integer_t;
pub type task_info_data_t = [integer_t; 1024usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct task_basic_info_32 {
    pub suspend_count: integer_t,
    pub virtual_size: natural_t,
    pub resident_size: natural_t,
    pub user_time: time_value_t,
    pub system_time: time_value_t,
    pub policy: policy_t,
}
#[test]
fn bindgen_test_layout_task_basic_info_32() {
    const UNINIT: ::core::mem::MaybeUninit<task_basic_info_32> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_basic_info_32>(),
        32usize,
        concat!("Size of: ", stringify!(task_basic_info_32))
    );
    assert_eq!(
        ::core::mem::align_of::<task_basic_info_32>(),
        4usize,
        concat!("Alignment of ", stringify!(task_basic_info_32))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).suspend_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_32),
            "::",
            stringify!(suspend_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).virtual_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_32),
            "::",
            stringify!(virtual_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).resident_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_32),
            "::",
            stringify!(resident_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_time) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_32),
            "::",
            stringify!(user_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).system_time) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_32),
            "::",
            stringify!(system_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_32),
            "::",
            stringify!(policy)
        )
    );
}
pub type task_basic_info_32_data_t = task_basic_info_32;
pub type task_basic_info_32_t = *mut task_basic_info_32;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_basic_info_64 {
    pub suspend_count: integer_t,
    pub virtual_size: mach_vm_size_t,
    pub resident_size: mach_vm_size_t,
    pub user_time: time_value_t,
    pub system_time: time_value_t,
    pub policy: policy_t,
}
#[test]
fn bindgen_test_layout_task_basic_info_64() {
    const UNINIT: ::core::mem::MaybeUninit<task_basic_info_64> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_basic_info_64>(),
        40usize,
        concat!("Size of: ", stringify!(task_basic_info_64))
    );
    assert_eq!(
        ::core::mem::align_of::<task_basic_info_64>(),
        4usize,
        concat!("Alignment of ", stringify!(task_basic_info_64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).suspend_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_64),
            "::",
            stringify!(suspend_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).virtual_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_64),
            "::",
            stringify!(virtual_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).resident_size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_64),
            "::",
            stringify!(resident_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_time) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_64),
            "::",
            stringify!(user_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).system_time) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_64),
            "::",
            stringify!(system_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info_64),
            "::",
            stringify!(policy)
        )
    );
}
pub type task_basic_info_64_data_t = task_basic_info_64;
pub type task_basic_info_64_t = *mut task_basic_info_64;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_basic_info {
    pub suspend_count: integer_t,
    pub virtual_size: vm_size_t,
    pub resident_size: vm_size_t,
    pub user_time: time_value_t,
    pub system_time: time_value_t,
    pub policy: policy_t,
}
#[test]
fn bindgen_test_layout_task_basic_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_basic_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_basic_info>(),
        40usize,
        concat!("Size of: ", stringify!(task_basic_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_basic_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_basic_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).suspend_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info),
            "::",
            stringify!(suspend_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).virtual_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info),
            "::",
            stringify!(virtual_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).resident_size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info),
            "::",
            stringify!(resident_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_time) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info),
            "::",
            stringify!(user_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).system_time) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info),
            "::",
            stringify!(system_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(task_basic_info),
            "::",
            stringify!(policy)
        )
    );
}
pub type task_basic_info_data_t = task_basic_info;
pub type task_basic_info_t = *mut task_basic_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct task_events_info {
    pub faults: integer_t,
    pub pageins: integer_t,
    pub cow_faults: integer_t,
    pub messages_sent: integer_t,
    pub messages_received: integer_t,
    pub syscalls_mach: integer_t,
    pub syscalls_unix: integer_t,
    pub csw: integer_t,
}
#[test]
fn bindgen_test_layout_task_events_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_events_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_events_info>(),
        32usize,
        concat!("Size of: ", stringify!(task_events_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_events_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_events_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).faults) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_events_info),
            "::",
            stringify!(faults)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pageins) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(task_events_info),
            "::",
            stringify!(pageins)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cow_faults) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_events_info),
            "::",
            stringify!(cow_faults)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).messages_sent) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(task_events_info),
            "::",
            stringify!(messages_sent)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).messages_received) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_events_info),
            "::",
            stringify!(messages_received)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).syscalls_mach) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(task_events_info),
            "::",
            stringify!(syscalls_mach)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).syscalls_unix) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(task_events_info),
            "::",
            stringify!(syscalls_unix)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).csw) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(task_events_info),
            "::",
            stringify!(csw)
        )
    );
}
pub type task_events_info_data_t = task_events_info;
pub type task_events_info_t = *mut task_events_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct task_thread_times_info {
    pub user_time: time_value_t,
    pub system_time: time_value_t,
}
#[test]
fn bindgen_test_layout_task_thread_times_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_thread_times_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_thread_times_info>(),
        16usize,
        concat!("Size of: ", stringify!(task_thread_times_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_thread_times_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_thread_times_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_time) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_thread_times_info),
            "::",
            stringify!(user_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).system_time) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_thread_times_info),
            "::",
            stringify!(system_time)
        )
    );
}
pub type task_thread_times_info_data_t = task_thread_times_info;
pub type task_thread_times_info_t = *mut task_thread_times_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_absolutetime_info {
    pub total_user: u64,
    pub total_system: u64,
    pub threads_user: u64,
    pub threads_system: u64,
}
#[test]
fn bindgen_test_layout_task_absolutetime_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_absolutetime_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_absolutetime_info>(),
        32usize,
        concat!("Size of: ", stringify!(task_absolutetime_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_absolutetime_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_absolutetime_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_user) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_absolutetime_info),
            "::",
            stringify!(total_user)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_system) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_absolutetime_info),
            "::",
            stringify!(total_system)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).threads_user) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_absolutetime_info),
            "::",
            stringify!(threads_user)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).threads_system) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(task_absolutetime_info),
            "::",
            stringify!(threads_system)
        )
    );
}
pub type task_absolutetime_info_data_t = task_absolutetime_info;
pub type task_absolutetime_info_t = *mut task_absolutetime_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_kernelmemory_info {
    pub total_palloc: u64,
    pub total_pfree: u64,
    pub total_salloc: u64,
    pub total_sfree: u64,
}
#[test]
fn bindgen_test_layout_task_kernelmemory_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_kernelmemory_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_kernelmemory_info>(),
        32usize,
        concat!("Size of: ", stringify!(task_kernelmemory_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_kernelmemory_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_kernelmemory_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_palloc) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_kernelmemory_info),
            "::",
            stringify!(total_palloc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_pfree) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_kernelmemory_info),
            "::",
            stringify!(total_pfree)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_salloc) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_kernelmemory_info),
            "::",
            stringify!(total_salloc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_sfree) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(task_kernelmemory_info),
            "::",
            stringify!(total_sfree)
        )
    );
}
pub type task_kernelmemory_info_data_t = task_kernelmemory_info;
pub type task_kernelmemory_info_t = *mut task_kernelmemory_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct task_affinity_tag_info {
    pub set_count: integer_t,
    pub min: integer_t,
    pub max: integer_t,
    pub task_count: integer_t,
}
#[test]
fn bindgen_test_layout_task_affinity_tag_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_affinity_tag_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_affinity_tag_info>(),
        16usize,
        concat!("Size of: ", stringify!(task_affinity_tag_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_affinity_tag_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_affinity_tag_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).set_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_affinity_tag_info),
            "::",
            stringify!(set_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).min) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(task_affinity_tag_info),
            "::",
            stringify!(min)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_affinity_tag_info),
            "::",
            stringify!(max)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_count) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(task_affinity_tag_info),
            "::",
            stringify!(task_count)
        )
    );
}
pub type task_affinity_tag_info_data_t = task_affinity_tag_info;
pub type task_affinity_tag_info_t = *mut task_affinity_tag_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_dyld_info {
    pub all_image_info_addr: mach_vm_address_t,
    pub all_image_info_size: mach_vm_size_t,
    pub all_image_info_format: integer_t,
}
#[test]
fn bindgen_test_layout_task_dyld_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_dyld_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_dyld_info>(),
        20usize,
        concat!("Size of: ", stringify!(task_dyld_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_dyld_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_dyld_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).all_image_info_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_dyld_info),
            "::",
            stringify!(all_image_info_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).all_image_info_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_dyld_info),
            "::",
            stringify!(all_image_info_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).all_image_info_format) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_dyld_info),
            "::",
            stringify!(all_image_info_format)
        )
    );
}
pub type task_dyld_info_data_t = task_dyld_info;
pub type task_dyld_info_t = *mut task_dyld_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_extmod_info {
    pub task_uuid: [::libc::c_uchar; 16usize],
    pub extmod_statistics: vm_extmod_statistics_data_t,
}
#[test]
fn bindgen_test_layout_task_extmod_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_extmod_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_extmod_info>(),
        64usize,
        concat!("Size of: ", stringify!(task_extmod_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_extmod_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_extmod_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_uuid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_extmod_info),
            "::",
            stringify!(task_uuid)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).extmod_statistics) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_extmod_info),
            "::",
            stringify!(extmod_statistics)
        )
    );
}
pub type task_extmod_info_data_t = task_extmod_info;
pub type task_extmod_info_t = *mut task_extmod_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_task_basic_info {
    pub virtual_size: mach_vm_size_t,
    pub resident_size: mach_vm_size_t,
    pub resident_size_max: mach_vm_size_t,
    pub user_time: time_value_t,
    pub system_time: time_value_t,
    pub policy: policy_t,
    pub suspend_count: integer_t,
}
#[test]
fn bindgen_test_layout_mach_task_basic_info() {
    const UNINIT: ::core::mem::MaybeUninit<mach_task_basic_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_task_basic_info>(),
        48usize,
        concat!("Size of: ", stringify!(mach_task_basic_info))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_task_basic_info>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_task_basic_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).virtual_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_task_basic_info),
            "::",
            stringify!(virtual_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).resident_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_task_basic_info),
            "::",
            stringify!(resident_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).resident_size_max) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_task_basic_info),
            "::",
            stringify!(resident_size_max)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_time) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_task_basic_info),
            "::",
            stringify!(user_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).system_time) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_task_basic_info),
            "::",
            stringify!(system_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_task_basic_info),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).suspend_count) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_task_basic_info),
            "::",
            stringify!(suspend_count)
        )
    );
}
pub type mach_task_basic_info_data_t = mach_task_basic_info;
pub type mach_task_basic_info_t = *mut mach_task_basic_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_power_info {
    pub total_user: u64,
    pub total_system: u64,
    pub task_interrupt_wakeups: u64,
    pub task_platform_idle_wakeups: u64,
    pub task_timer_wakeups_bin_1: u64,
    pub task_timer_wakeups_bin_2: u64,
}
#[test]
fn bindgen_test_layout_task_power_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_power_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_power_info>(),
        48usize,
        concat!("Size of: ", stringify!(task_power_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_power_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_power_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_user) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info),
            "::",
            stringify!(total_user)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_system) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info),
            "::",
            stringify!(total_system)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_interrupt_wakeups) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info),
            "::",
            stringify!(task_interrupt_wakeups)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_platform_idle_wakeups) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info),
            "::",
            stringify!(task_platform_idle_wakeups)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_timer_wakeups_bin_1) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info),
            "::",
            stringify!(task_timer_wakeups_bin_1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_timer_wakeups_bin_2) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info),
            "::",
            stringify!(task_timer_wakeups_bin_2)
        )
    );
}
pub type task_power_info_data_t = task_power_info;
pub type task_power_info_t = *mut task_power_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_vm_info {
    pub virtual_size: mach_vm_size_t,
    pub region_count: integer_t,
    pub page_size: integer_t,
    pub resident_size: mach_vm_size_t,
    pub resident_size_peak: mach_vm_size_t,
    pub device: mach_vm_size_t,
    pub device_peak: mach_vm_size_t,
    pub internal: mach_vm_size_t,
    pub internal_peak: mach_vm_size_t,
    pub external: mach_vm_size_t,
    pub external_peak: mach_vm_size_t,
    pub reusable: mach_vm_size_t,
    pub reusable_peak: mach_vm_size_t,
    pub purgeable_volatile_pmap: mach_vm_size_t,
    pub purgeable_volatile_resident: mach_vm_size_t,
    pub purgeable_volatile_virtual: mach_vm_size_t,
    pub compressed: mach_vm_size_t,
    pub compressed_peak: mach_vm_size_t,
    pub compressed_lifetime: mach_vm_size_t,
    pub phys_footprint: mach_vm_size_t,
    pub min_address: mach_vm_address_t,
    pub max_address: mach_vm_address_t,
    pub ledger_phys_footprint_peak: i64,
    pub ledger_purgeable_nonvolatile: i64,
    pub ledger_purgeable_novolatile_compressed: i64,
    pub ledger_purgeable_volatile: i64,
    pub ledger_purgeable_volatile_compressed: i64,
    pub ledger_tag_network_nonvolatile: i64,
    pub ledger_tag_network_nonvolatile_compressed: i64,
    pub ledger_tag_network_volatile: i64,
    pub ledger_tag_network_volatile_compressed: i64,
    pub ledger_tag_media_footprint: i64,
    pub ledger_tag_media_footprint_compressed: i64,
    pub ledger_tag_media_nofootprint: i64,
    pub ledger_tag_media_nofootprint_compressed: i64,
    pub ledger_tag_graphics_footprint: i64,
    pub ledger_tag_graphics_footprint_compressed: i64,
    pub ledger_tag_graphics_nofootprint: i64,
    pub ledger_tag_graphics_nofootprint_compressed: i64,
    pub ledger_tag_neural_footprint: i64,
    pub ledger_tag_neural_footprint_compressed: i64,
    pub ledger_tag_neural_nofootprint: i64,
    pub ledger_tag_neural_nofootprint_compressed: i64,
    pub limit_bytes_remaining: u64,
    pub decompressions: integer_t,
    pub ledger_swapins: i64,
}
#[test]
fn bindgen_test_layout_task_vm_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_vm_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_vm_info>(),
        356usize,
        concat!("Size of: ", stringify!(task_vm_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_vm_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_vm_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).virtual_size) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(virtual_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).region_count) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(region_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).page_size) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(page_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).resident_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(resident_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).resident_size_peak) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(resident_size_peak)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).device) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(device)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).device_peak) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(device_peak)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).internal) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(internal)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).internal_peak) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(internal_peak)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).external) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(external)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).external_peak) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(external_peak)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reusable) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(reusable)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reusable_peak) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(reusable_peak)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).purgeable_volatile_pmap) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(purgeable_volatile_pmap)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).purgeable_volatile_resident) as usize - ptr as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(purgeable_volatile_resident)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).purgeable_volatile_virtual) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(purgeable_volatile_virtual)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).compressed) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(compressed)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).compressed_peak) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(compressed_peak)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).compressed_lifetime) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(compressed_lifetime)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).phys_footprint) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(phys_footprint)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).min_address) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(min_address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_address) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(max_address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ledger_phys_footprint_peak) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_phys_footprint_peak)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_purgeable_nonvolatile) as usize - ptr as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_purgeable_nonvolatile)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_purgeable_novolatile_compressed) as usize
                - ptr as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_purgeable_novolatile_compressed)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ledger_purgeable_volatile) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_purgeable_volatile)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_purgeable_volatile_compressed) as usize
                - ptr as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_purgeable_volatile_compressed)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_network_nonvolatile) as usize - ptr as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_network_nonvolatile)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_network_nonvolatile_compressed) as usize
                - ptr as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_network_nonvolatile_compressed)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_network_volatile) as usize - ptr as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_network_volatile)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_network_volatile_compressed) as usize
                - ptr as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_network_volatile_compressed)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ledger_tag_media_footprint) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_media_footprint)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_media_footprint_compressed) as usize
                - ptr as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_media_footprint_compressed)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_media_nofootprint) as usize - ptr as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_media_nofootprint)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_media_nofootprint_compressed) as usize
                - ptr as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_media_nofootprint_compressed)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_graphics_footprint) as usize - ptr as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_graphics_footprint)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_graphics_footprint_compressed) as usize
                - ptr as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_graphics_footprint_compressed)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_graphics_nofootprint) as usize - ptr as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_graphics_nofootprint)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_graphics_nofootprint_compressed) as usize
                - ptr as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_graphics_nofootprint_compressed)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_neural_footprint) as usize - ptr as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_neural_footprint)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_neural_footprint_compressed) as usize
                - ptr as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_neural_footprint_compressed)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_neural_nofootprint) as usize - ptr as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_neural_nofootprint)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).ledger_tag_neural_nofootprint_compressed) as usize
                - ptr as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_tag_neural_nofootprint_compressed)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).limit_bytes_remaining) as usize - ptr as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(limit_bytes_remaining)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).decompressions) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(decompressions)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ledger_swapins) as usize - ptr as usize },
        348usize,
        concat!(
            "Offset of field: ",
            stringify!(task_vm_info),
            "::",
            stringify!(ledger_swapins)
        )
    );
}
pub type task_vm_info_data_t = task_vm_info;
pub type task_vm_info_t = *mut task_vm_info;
pub type task_purgable_info_t = vm_purgeable_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_trace_memory_info {
    pub user_memory_address: u64,
    pub buffer_size: u64,
    pub mailbox_array_size: u64,
}
#[test]
fn bindgen_test_layout_task_trace_memory_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_trace_memory_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_trace_memory_info>(),
        24usize,
        concat!("Size of: ", stringify!(task_trace_memory_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_trace_memory_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_trace_memory_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_memory_address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_trace_memory_info),
            "::",
            stringify!(user_memory_address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).buffer_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_trace_memory_info),
            "::",
            stringify!(buffer_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mailbox_array_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_trace_memory_info),
            "::",
            stringify!(mailbox_array_size)
        )
    );
}
pub type task_trace_memory_info_data_t = task_trace_memory_info;
pub type task_trace_memory_info_t = *mut task_trace_memory_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_wait_state_info {
    pub total_wait_state_time: u64,
    pub total_wait_sfi_state_time: u64,
    pub _reserved: [u32; 4usize],
}
#[test]
fn bindgen_test_layout_task_wait_state_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_wait_state_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_wait_state_info>(),
        32usize,
        concat!("Size of: ", stringify!(task_wait_state_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_wait_state_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_wait_state_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_wait_state_time) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_wait_state_info),
            "::",
            stringify!(total_wait_state_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_wait_sfi_state_time) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_wait_state_info),
            "::",
            stringify!(total_wait_sfi_state_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr)._reserved) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_wait_state_info),
            "::",
            stringify!(_reserved)
        )
    );
}
pub type task_wait_state_info_data_t = task_wait_state_info;
pub type task_wait_state_info_t = *mut task_wait_state_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct gpu_energy_data {
    pub task_gpu_utilisation: u64,
    pub task_gpu_stat_reserved0: u64,
    pub task_gpu_stat_reserved1: u64,
    pub task_gpu_stat_reserved2: u64,
}
#[test]
fn bindgen_test_layout_gpu_energy_data() {
    const UNINIT: ::core::mem::MaybeUninit<gpu_energy_data> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<gpu_energy_data>(),
        32usize,
        concat!("Size of: ", stringify!(gpu_energy_data))
    );
    assert_eq!(
        ::core::mem::align_of::<gpu_energy_data>(),
        4usize,
        concat!("Alignment of ", stringify!(gpu_energy_data))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_gpu_utilisation) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_energy_data),
            "::",
            stringify!(task_gpu_utilisation)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_gpu_stat_reserved0) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_energy_data),
            "::",
            stringify!(task_gpu_stat_reserved0)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_gpu_stat_reserved1) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_energy_data),
            "::",
            stringify!(task_gpu_stat_reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_gpu_stat_reserved2) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(gpu_energy_data),
            "::",
            stringify!(task_gpu_stat_reserved2)
        )
    );
}
pub type gpu_energy_data_t = *mut gpu_energy_data;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct task_power_info_v2 {
    pub cpu_energy: task_power_info_data_t,
    pub gpu_energy: gpu_energy_data,
    pub task_ptime: u64,
    pub task_pset_switches: u64,
}
#[test]
fn bindgen_test_layout_task_power_info_v2() {
    const UNINIT: ::core::mem::MaybeUninit<task_power_info_v2> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_power_info_v2>(),
        96usize,
        concat!("Size of: ", stringify!(task_power_info_v2))
    );
    assert_eq!(
        ::core::mem::align_of::<task_power_info_v2>(),
        4usize,
        concat!("Alignment of ", stringify!(task_power_info_v2))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_energy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info_v2),
            "::",
            stringify!(cpu_energy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).gpu_energy) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info_v2),
            "::",
            stringify!(gpu_energy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_ptime) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info_v2),
            "::",
            stringify!(task_ptime)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_pset_switches) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(task_power_info_v2),
            "::",
            stringify!(task_pset_switches)
        )
    );
}
pub type task_power_info_v2_data_t = task_power_info_v2;
pub type task_power_info_v2_t = *mut task_power_info_v2;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct task_flags_info {
    pub flags: u32,
}
#[test]
fn bindgen_test_layout_task_flags_info() {
    const UNINIT: ::core::mem::MaybeUninit<task_flags_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_flags_info>(),
        4usize,
        concat!("Size of: ", stringify!(task_flags_info))
    );
    assert_eq!(
        ::core::mem::align_of::<task_flags_info>(),
        4usize,
        concat!("Alignment of ", stringify!(task_flags_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_flags_info),
            "::",
            stringify!(flags)
        )
    );
}
pub type task_flags_info_data_t = task_flags_info;
pub type task_flags_info_t = *mut task_flags_info;
pub type task_exc_guard_behavior_t = u32;
pub type task_corpse_forking_behavior_t = u32;
pub type task_inspect_flavor_t = natural_t;
pub const task_inspect_flavor_TASK_INSPECT_BASIC_COUNTS: task_inspect_flavor = 1;
pub type task_inspect_flavor = ::libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct task_inspect_basic_counts {
    pub instructions: u64,
    pub cycles: u64,
}
#[test]
fn bindgen_test_layout_task_inspect_basic_counts() {
    const UNINIT: ::core::mem::MaybeUninit<task_inspect_basic_counts> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_inspect_basic_counts>(),
        16usize,
        concat!("Size of: ", stringify!(task_inspect_basic_counts))
    );
    assert_eq!(
        ::core::mem::align_of::<task_inspect_basic_counts>(),
        8usize,
        concat!("Alignment of ", stringify!(task_inspect_basic_counts))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).instructions) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_inspect_basic_counts),
            "::",
            stringify!(instructions)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cycles) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_inspect_basic_counts),
            "::",
            stringify!(cycles)
        )
    );
}
pub type task_inspect_basic_counts_data_t = task_inspect_basic_counts;
pub type task_inspect_basic_counts_t = *mut task_inspect_basic_counts;
pub type task_inspect_info_t = *mut integer_t;
pub type task_policy_flavor_t = natural_t;
pub type task_policy_t = *mut integer_t;
pub const task_role_TASK_RENICED: task_role = -1;
pub const task_role_TASK_UNSPECIFIED: task_role = 0;
pub const task_role_TASK_FOREGROUND_APPLICATION: task_role = 1;
pub const task_role_TASK_BACKGROUND_APPLICATION: task_role = 2;
pub const task_role_TASK_CONTROL_APPLICATION: task_role = 3;
pub const task_role_TASK_GRAPHICS_SERVER: task_role = 4;
pub const task_role_TASK_THROTTLE_APPLICATION: task_role = 5;
pub const task_role_TASK_NONUI_APPLICATION: task_role = 6;
pub const task_role_TASK_DEFAULT_APPLICATION: task_role = 7;
pub const task_role_TASK_DARWINBG_APPLICATION: task_role = 8;
pub type task_role = ::libc::c_int;
pub use self::task_role as task_role_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct task_category_policy {
    pub role: task_role_t,
}
#[test]
fn bindgen_test_layout_task_category_policy() {
    const UNINIT: ::core::mem::MaybeUninit<task_category_policy> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_category_policy>(),
        4usize,
        concat!("Size of: ", stringify!(task_category_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<task_category_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(task_category_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).role) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_category_policy),
            "::",
            stringify!(role)
        )
    );
}
pub type task_category_policy_data_t = task_category_policy;
pub type task_category_policy_t = *mut task_category_policy;
pub const task_latency_qos_LATENCY_QOS_TIER_UNSPECIFIED: task_latency_qos = 0;
pub const task_latency_qos_LATENCY_QOS_TIER_0: task_latency_qos = 16711681;
pub const task_latency_qos_LATENCY_QOS_TIER_1: task_latency_qos = 16711682;
pub const task_latency_qos_LATENCY_QOS_TIER_2: task_latency_qos = 16711683;
pub const task_latency_qos_LATENCY_QOS_TIER_3: task_latency_qos = 16711684;
pub const task_latency_qos_LATENCY_QOS_TIER_4: task_latency_qos = 16711685;
pub const task_latency_qos_LATENCY_QOS_TIER_5: task_latency_qos = 16711686;
pub type task_latency_qos = ::libc::c_uint;
pub type task_latency_qos_t = integer_t;
pub const task_throughput_qos_THROUGHPUT_QOS_TIER_UNSPECIFIED: task_throughput_qos = 0;
pub const task_throughput_qos_THROUGHPUT_QOS_TIER_0: task_throughput_qos = 16646145;
pub const task_throughput_qos_THROUGHPUT_QOS_TIER_1: task_throughput_qos = 16646146;
pub const task_throughput_qos_THROUGHPUT_QOS_TIER_2: task_throughput_qos = 16646147;
pub const task_throughput_qos_THROUGHPUT_QOS_TIER_3: task_throughput_qos = 16646148;
pub const task_throughput_qos_THROUGHPUT_QOS_TIER_4: task_throughput_qos = 16646149;
pub const task_throughput_qos_THROUGHPUT_QOS_TIER_5: task_throughput_qos = 16646150;
pub type task_throughput_qos = ::libc::c_uint;
pub type task_throughput_qos_t = integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct task_qos_policy {
    pub task_latency_qos_tier: task_latency_qos_t,
    pub task_throughput_qos_tier: task_throughput_qos_t,
}
#[test]
fn bindgen_test_layout_task_qos_policy() {
    const UNINIT: ::core::mem::MaybeUninit<task_qos_policy> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_qos_policy>(),
        8usize,
        concat!("Size of: ", stringify!(task_qos_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<task_qos_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(task_qos_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_latency_qos_tier) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_qos_policy),
            "::",
            stringify!(task_latency_qos_tier)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_throughput_qos_tier) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(task_qos_policy),
            "::",
            stringify!(task_throughput_qos_tier)
        )
    );
}
pub type task_qos_policy_t = *mut task_qos_policy;
pub type task_special_port_t = ::libc::c_int;
pub type thread_flavor_t = natural_t;
pub type thread_info_t = *mut integer_t;
pub type thread_info_data_t = [integer_t; 32usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_basic_info {
    pub user_time: time_value_t,
    pub system_time: time_value_t,
    pub cpu_usage: integer_t,
    pub policy: policy_t,
    pub run_state: integer_t,
    pub flags: integer_t,
    pub suspend_count: integer_t,
    pub sleep_time: integer_t,
}
#[test]
fn bindgen_test_layout_thread_basic_info() {
    const UNINIT: ::core::mem::MaybeUninit<thread_basic_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_basic_info>(),
        40usize,
        concat!("Size of: ", stringify!(thread_basic_info))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_basic_info>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_basic_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_time) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(user_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).system_time) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(system_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cpu_usage) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(cpu_usage)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).run_state) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(run_state)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).suspend_count) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(suspend_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sleep_time) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_basic_info),
            "::",
            stringify!(sleep_time)
        )
    );
}
pub type thread_basic_info_data_t = thread_basic_info;
pub type thread_basic_info_t = *mut thread_basic_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_identifier_info {
    pub thread_id: u64,
    pub thread_handle: u64,
    pub dispatch_qaddr: u64,
}
#[test]
fn bindgen_test_layout_thread_identifier_info() {
    const UNINIT: ::core::mem::MaybeUninit<thread_identifier_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_identifier_info>(),
        24usize,
        concat!("Size of: ", stringify!(thread_identifier_info))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_identifier_info>(),
        8usize,
        concat!("Alignment of ", stringify!(thread_identifier_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).thread_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_identifier_info),
            "::",
            stringify!(thread_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).thread_handle) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_identifier_info),
            "::",
            stringify!(thread_handle)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dispatch_qaddr) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_identifier_info),
            "::",
            stringify!(dispatch_qaddr)
        )
    );
}
pub type thread_identifier_info_data_t = thread_identifier_info;
pub type thread_identifier_info_t = *mut thread_identifier_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_extended_info {
    pub pth_user_time: u64,
    pub pth_system_time: u64,
    pub pth_cpu_usage: i32,
    pub pth_policy: i32,
    pub pth_run_state: i32,
    pub pth_flags: i32,
    pub pth_sleep_time: i32,
    pub pth_curpri: i32,
    pub pth_priority: i32,
    pub pth_maxpriority: i32,
    pub pth_name: [::libc::c_char; 64usize],
}
#[test]
fn bindgen_test_layout_thread_extended_info() {
    const UNINIT: ::core::mem::MaybeUninit<thread_extended_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_extended_info>(),
        112usize,
        concat!("Size of: ", stringify!(thread_extended_info))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_extended_info>(),
        8usize,
        concat!("Alignment of ", stringify!(thread_extended_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_user_time) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_user_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_system_time) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_system_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_cpu_usage) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_cpu_usage)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_policy) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_run_state) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_run_state)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_flags) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_sleep_time) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_sleep_time)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_curpri) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_curpri)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_priority) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_maxpriority) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_maxpriority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pth_name) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_info),
            "::",
            stringify!(pth_name)
        )
    );
}
pub type thread_extended_info_data_t = thread_extended_info;
pub type thread_extended_info_t = *mut thread_extended_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct io_stat_entry {
    pub count: u64,
    pub size: u64,
}
#[test]
fn bindgen_test_layout_io_stat_entry() {
    const UNINIT: ::core::mem::MaybeUninit<io_stat_entry> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<io_stat_entry>(),
        16usize,
        concat!("Size of: ", stringify!(io_stat_entry))
    );
    assert_eq!(
        ::core::mem::align_of::<io_stat_entry>(),
        8usize,
        concat!("Alignment of ", stringify!(io_stat_entry))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(io_stat_entry),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(io_stat_entry),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct io_stat_info {
    pub disk_reads: io_stat_entry,
    pub io_priority: [io_stat_entry; 4usize],
    pub paging: io_stat_entry,
    pub metadata: io_stat_entry,
    pub total_io: io_stat_entry,
}
#[test]
fn bindgen_test_layout_io_stat_info() {
    const UNINIT: ::core::mem::MaybeUninit<io_stat_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<io_stat_info>(),
        128usize,
        concat!("Size of: ", stringify!(io_stat_info))
    );
    assert_eq!(
        ::core::mem::align_of::<io_stat_info>(),
        8usize,
        concat!("Alignment of ", stringify!(io_stat_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).disk_reads) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(io_stat_info),
            "::",
            stringify!(disk_reads)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).io_priority) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(io_stat_info),
            "::",
            stringify!(io_priority)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).paging) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(io_stat_info),
            "::",
            stringify!(paging)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).metadata) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(io_stat_info),
            "::",
            stringify!(metadata)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).total_io) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(io_stat_info),
            "::",
            stringify!(total_io)
        )
    );
}
pub type io_stat_info_t = *mut io_stat_info;
pub type thread_policy_flavor_t = natural_t;
pub type thread_policy_t = *mut integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_standard_policy {
    pub no_data: natural_t,
}
#[test]
fn bindgen_test_layout_thread_standard_policy() {
    const UNINIT: ::core::mem::MaybeUninit<thread_standard_policy> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_standard_policy>(),
        4usize,
        concat!("Size of: ", stringify!(thread_standard_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_standard_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_standard_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).no_data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_standard_policy),
            "::",
            stringify!(no_data)
        )
    );
}
pub type thread_standard_policy_data_t = thread_standard_policy;
pub type thread_standard_policy_t = *mut thread_standard_policy;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_extended_policy {
    pub timeshare: boolean_t,
}
#[test]
fn bindgen_test_layout_thread_extended_policy() {
    const UNINIT: ::core::mem::MaybeUninit<thread_extended_policy> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_extended_policy>(),
        4usize,
        concat!("Size of: ", stringify!(thread_extended_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_extended_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_extended_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).timeshare) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_extended_policy),
            "::",
            stringify!(timeshare)
        )
    );
}
pub type thread_extended_policy_data_t = thread_extended_policy;
pub type thread_extended_policy_t = *mut thread_extended_policy;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_time_constraint_policy {
    pub period: u32,
    pub computation: u32,
    pub constraint: u32,
    pub preemptible: boolean_t,
}
#[test]
fn bindgen_test_layout_thread_time_constraint_policy() {
    const UNINIT: ::core::mem::MaybeUninit<thread_time_constraint_policy> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_time_constraint_policy>(),
        16usize,
        concat!("Size of: ", stringify!(thread_time_constraint_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_time_constraint_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_time_constraint_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).period) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_time_constraint_policy),
            "::",
            stringify!(period)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).computation) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_time_constraint_policy),
            "::",
            stringify!(computation)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).constraint) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_time_constraint_policy),
            "::",
            stringify!(constraint)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).preemptible) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_time_constraint_policy),
            "::",
            stringify!(preemptible)
        )
    );
}
pub type thread_time_constraint_policy_data_t = thread_time_constraint_policy;
pub type thread_time_constraint_policy_t = *mut thread_time_constraint_policy;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_precedence_policy {
    pub importance: integer_t,
}
#[test]
fn bindgen_test_layout_thread_precedence_policy() {
    const UNINIT: ::core::mem::MaybeUninit<thread_precedence_policy> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_precedence_policy>(),
        4usize,
        concat!("Size of: ", stringify!(thread_precedence_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_precedence_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_precedence_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).importance) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_precedence_policy),
            "::",
            stringify!(importance)
        )
    );
}
pub type thread_precedence_policy_data_t = thread_precedence_policy;
pub type thread_precedence_policy_t = *mut thread_precedence_policy;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_affinity_policy {
    pub affinity_tag: integer_t,
}
#[test]
fn bindgen_test_layout_thread_affinity_policy() {
    const UNINIT: ::core::mem::MaybeUninit<thread_affinity_policy> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_affinity_policy>(),
        4usize,
        concat!("Size of: ", stringify!(thread_affinity_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_affinity_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_affinity_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).affinity_tag) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_affinity_policy),
            "::",
            stringify!(affinity_tag)
        )
    );
}
pub type thread_affinity_policy_data_t = thread_affinity_policy;
pub type thread_affinity_policy_t = *mut thread_affinity_policy;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_background_policy {
    pub priority: integer_t,
}
#[test]
fn bindgen_test_layout_thread_background_policy() {
    const UNINIT: ::core::mem::MaybeUninit<thread_background_policy> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_background_policy>(),
        4usize,
        concat!("Size of: ", stringify!(thread_background_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_background_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_background_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).priority) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_background_policy),
            "::",
            stringify!(priority)
        )
    );
}
pub type thread_background_policy_data_t = thread_background_policy;
pub type thread_background_policy_t = *mut thread_background_policy;
pub type thread_latency_qos_t = integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_latency_qos_policy {
    pub thread_latency_qos_tier: thread_latency_qos_t,
}
#[test]
fn bindgen_test_layout_thread_latency_qos_policy() {
    const UNINIT: ::core::mem::MaybeUninit<thread_latency_qos_policy> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_latency_qos_policy>(),
        4usize,
        concat!("Size of: ", stringify!(thread_latency_qos_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_latency_qos_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_latency_qos_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).thread_latency_qos_tier) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_latency_qos_policy),
            "::",
            stringify!(thread_latency_qos_tier)
        )
    );
}
pub type thread_latency_qos_policy_data_t = thread_latency_qos_policy;
pub type thread_latency_qos_policy_t = *mut thread_latency_qos_policy;
pub type thread_throughput_qos_t = integer_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread_throughput_qos_policy {
    pub thread_throughput_qos_tier: thread_throughput_qos_t,
}
#[test]
fn bindgen_test_layout_thread_throughput_qos_policy() {
    const UNINIT: ::core::mem::MaybeUninit<thread_throughput_qos_policy> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<thread_throughput_qos_policy>(),
        4usize,
        concat!("Size of: ", stringify!(thread_throughput_qos_policy))
    );
    assert_eq!(
        ::core::mem::align_of::<thread_throughput_qos_policy>(),
        4usize,
        concat!("Alignment of ", stringify!(thread_throughput_qos_policy))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).thread_throughput_qos_tier) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(thread_throughput_qos_policy),
            "::",
            stringify!(thread_throughput_qos_tier)
        )
    );
}
pub type thread_throughput_qos_policy_data_t = thread_throughput_qos_policy;
pub type thread_throughput_qos_policy_t = *mut thread_throughput_qos_policy;
pub type alarm_type_t = ::libc::c_int;
pub type sleep_type_t = ::libc::c_int;
pub type clock_id_t = ::libc::c_int;
pub type clock_flavor_t = ::libc::c_int;
pub type clock_attr_t = *mut ::libc::c_int;
pub type clock_res_t = ::libc::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_timespec {
    pub tv_sec: ::libc::c_uint,
    pub tv_nsec: clock_res_t,
}
#[test]
fn bindgen_test_layout_mach_timespec() {
    const UNINIT: ::core::mem::MaybeUninit<mach_timespec> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_timespec>(),
        8usize,
        concat!("Size of: ", stringify!(mach_timespec))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_timespec>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_timespec))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tv_sec) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tv_nsec) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
pub type mach_timespec_t = mach_timespec;
pub type vm_machine_attribute_t = ::libc::c_uint;
pub type vm_machine_attribute_val_t = ::libc::c_int;
pub type vm_inherit_t = ::libc::c_uint;
pub type vm_purgable_t = ::libc::c_int;
pub type vm_behavior_t = ::libc::c_int;
pub type vm32_object_id_t = u32;
pub type vm_region_info_t = *mut ::libc::c_int;
pub type vm_region_info_64_t = *mut ::libc::c_int;
pub type vm_region_recurse_info_t = *mut ::libc::c_int;
pub type vm_region_recurse_info_64_t = *mut ::libc::c_int;
pub type vm_region_flavor_t = ::libc::c_int;
pub type vm_region_info_data_t = [::libc::c_int; 1024usize];
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct vm_region_basic_info_64 {
    pub protection: vm_prot_t,
    pub max_protection: vm_prot_t,
    pub inheritance: vm_inherit_t,
    pub shared: boolean_t,
    pub reserved: boolean_t,
    pub offset: memory_object_offset_t,
    pub behavior: vm_behavior_t,
    pub user_wired_count: ::libc::c_ushort,
}
#[test]
fn bindgen_test_layout_vm_region_basic_info_64() {
    const UNINIT: ::core::mem::MaybeUninit<vm_region_basic_info_64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_region_basic_info_64>(),
        36usize,
        concat!("Size of: ", stringify!(vm_region_basic_info_64))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_region_basic_info_64>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_region_basic_info_64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).protection) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info_64),
            "::",
            stringify!(protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_protection) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info_64),
            "::",
            stringify!(max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inheritance) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info_64),
            "::",
            stringify!(inheritance)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).shared) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info_64),
            "::",
            stringify!(shared)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info_64),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info_64),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info_64),
            "::",
            stringify!(behavior)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_wired_count) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info_64),
            "::",
            stringify!(user_wired_count)
        )
    );
}
pub type vm_region_basic_info_64_t = *mut vm_region_basic_info_64;
pub type vm_region_basic_info_data_64_t = vm_region_basic_info_64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_region_basic_info {
    pub protection: vm_prot_t,
    pub max_protection: vm_prot_t,
    pub inheritance: vm_inherit_t,
    pub shared: boolean_t,
    pub reserved: boolean_t,
    pub offset: u32,
    pub behavior: vm_behavior_t,
    pub user_wired_count: ::libc::c_ushort,
}
#[test]
fn bindgen_test_layout_vm_region_basic_info() {
    const UNINIT: ::core::mem::MaybeUninit<vm_region_basic_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_region_basic_info>(),
        32usize,
        concat!("Size of: ", stringify!(vm_region_basic_info))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_region_basic_info>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_region_basic_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).protection) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info),
            "::",
            stringify!(protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_protection) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info),
            "::",
            stringify!(max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inheritance) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info),
            "::",
            stringify!(inheritance)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).shared) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info),
            "::",
            stringify!(shared)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info),
            "::",
            stringify!(behavior)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_wired_count) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_basic_info),
            "::",
            stringify!(user_wired_count)
        )
    );
}
pub type vm_region_basic_info_t = *mut vm_region_basic_info;
pub type vm_region_basic_info_data_t = vm_region_basic_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_region_extended_info {
    pub protection: vm_prot_t,
    pub user_tag: ::libc::c_uint,
    pub pages_resident: ::libc::c_uint,
    pub pages_shared_now_private: ::libc::c_uint,
    pub pages_swapped_out: ::libc::c_uint,
    pub pages_dirtied: ::libc::c_uint,
    pub ref_count: ::libc::c_uint,
    pub shadow_depth: ::libc::c_ushort,
    pub external_pager: ::libc::c_uchar,
    pub share_mode: ::libc::c_uchar,
    pub pages_reusable: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_vm_region_extended_info() {
    const UNINIT: ::core::mem::MaybeUninit<vm_region_extended_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_region_extended_info>(),
        36usize,
        concat!("Size of: ", stringify!(vm_region_extended_info))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_region_extended_info>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_region_extended_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).protection) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_tag) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(user_tag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_resident) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(pages_resident)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_shared_now_private) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(pages_shared_now_private)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_swapped_out) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(pages_swapped_out)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_dirtied) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(pages_dirtied)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ref_count) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).shadow_depth) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(shadow_depth)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).external_pager) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(external_pager)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).share_mode) as usize - ptr as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(share_mode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_reusable) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_extended_info),
            "::",
            stringify!(pages_reusable)
        )
    );
}
pub type vm_region_extended_info_t = *mut vm_region_extended_info;
pub type vm_region_extended_info_data_t = vm_region_extended_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_region_top_info {
    pub obj_id: ::libc::c_uint,
    pub ref_count: ::libc::c_uint,
    pub private_pages_resident: ::libc::c_uint,
    pub shared_pages_resident: ::libc::c_uint,
    pub share_mode: ::libc::c_uchar,
}
#[test]
fn bindgen_test_layout_vm_region_top_info() {
    const UNINIT: ::core::mem::MaybeUninit<vm_region_top_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_region_top_info>(),
        20usize,
        concat!("Size of: ", stringify!(vm_region_top_info))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_region_top_info>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_region_top_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).obj_id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_top_info),
            "::",
            stringify!(obj_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ref_count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_top_info),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).private_pages_resident) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_top_info),
            "::",
            stringify!(private_pages_resident)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).shared_pages_resident) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_top_info),
            "::",
            stringify!(shared_pages_resident)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).share_mode) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_top_info),
            "::",
            stringify!(share_mode)
        )
    );
}
pub type vm_region_top_info_t = *mut vm_region_top_info;
pub type vm_region_top_info_data_t = vm_region_top_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_region_submap_info {
    pub protection: vm_prot_t,
    pub max_protection: vm_prot_t,
    pub inheritance: vm_inherit_t,
    pub offset: u32,
    pub user_tag: ::libc::c_uint,
    pub pages_resident: ::libc::c_uint,
    pub pages_shared_now_private: ::libc::c_uint,
    pub pages_swapped_out: ::libc::c_uint,
    pub pages_dirtied: ::libc::c_uint,
    pub ref_count: ::libc::c_uint,
    pub shadow_depth: ::libc::c_ushort,
    pub external_pager: ::libc::c_uchar,
    pub share_mode: ::libc::c_uchar,
    pub is_submap: boolean_t,
    pub behavior: vm_behavior_t,
    pub object_id: vm32_object_id_t,
    pub user_wired_count: ::libc::c_ushort,
}
#[test]
fn bindgen_test_layout_vm_region_submap_info() {
    const UNINIT: ::core::mem::MaybeUninit<vm_region_submap_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_region_submap_info>(),
        60usize,
        concat!("Size of: ", stringify!(vm_region_submap_info))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_region_submap_info>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_region_submap_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).protection) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_protection) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inheritance) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(inheritance)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_tag) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(user_tag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_resident) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(pages_resident)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_shared_now_private) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(pages_shared_now_private)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_swapped_out) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(pages_swapped_out)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_dirtied) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(pages_dirtied)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ref_count) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).shadow_depth) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(shadow_depth)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).external_pager) as usize - ptr as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(external_pager)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).share_mode) as usize - ptr as usize },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(share_mode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).is_submap) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(is_submap)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(behavior)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).object_id) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(object_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_wired_count) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info),
            "::",
            stringify!(user_wired_count)
        )
    );
}
pub type vm_region_submap_info_t = *mut vm_region_submap_info;
pub type vm_region_submap_info_data_t = vm_region_submap_info;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct vm_region_submap_info_64 {
    pub protection: vm_prot_t,
    pub max_protection: vm_prot_t,
    pub inheritance: vm_inherit_t,
    pub offset: memory_object_offset_t,
    pub user_tag: ::libc::c_uint,
    pub pages_resident: ::libc::c_uint,
    pub pages_shared_now_private: ::libc::c_uint,
    pub pages_swapped_out: ::libc::c_uint,
    pub pages_dirtied: ::libc::c_uint,
    pub ref_count: ::libc::c_uint,
    pub shadow_depth: ::libc::c_ushort,
    pub external_pager: ::libc::c_uchar,
    pub share_mode: ::libc::c_uchar,
    pub is_submap: boolean_t,
    pub behavior: vm_behavior_t,
    pub object_id: vm32_object_id_t,
    pub user_wired_count: ::libc::c_ushort,
    pub pages_reusable: ::libc::c_uint,
    pub object_id_full: vm_object_id_t,
}
#[test]
fn bindgen_test_layout_vm_region_submap_info_64() {
    const UNINIT: ::core::mem::MaybeUninit<vm_region_submap_info_64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_region_submap_info_64>(),
        76usize,
        concat!("Size of: ", stringify!(vm_region_submap_info_64))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_region_submap_info_64>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_region_submap_info_64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).protection) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_protection) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inheritance) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(inheritance)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_tag) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(user_tag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_resident) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(pages_resident)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_shared_now_private) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(pages_shared_now_private)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_swapped_out) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(pages_swapped_out)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_dirtied) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(pages_dirtied)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ref_count) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).shadow_depth) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(shadow_depth)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).external_pager) as usize - ptr as usize },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(external_pager)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).share_mode) as usize - ptr as usize },
        47usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(share_mode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).is_submap) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(is_submap)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(behavior)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).object_id) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(object_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_wired_count) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(user_wired_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pages_reusable) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(pages_reusable)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).object_id_full) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_info_64),
            "::",
            stringify!(object_id_full)
        )
    );
}
pub type vm_region_submap_info_64_t = *mut vm_region_submap_info_64;
pub type vm_region_submap_info_data_64_t = vm_region_submap_info_64;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct vm_region_submap_short_info_64 {
    pub protection: vm_prot_t,
    pub max_protection: vm_prot_t,
    pub inheritance: vm_inherit_t,
    pub offset: memory_object_offset_t,
    pub user_tag: ::libc::c_uint,
    pub ref_count: ::libc::c_uint,
    pub shadow_depth: ::libc::c_ushort,
    pub external_pager: ::libc::c_uchar,
    pub share_mode: ::libc::c_uchar,
    pub is_submap: boolean_t,
    pub behavior: vm_behavior_t,
    pub object_id: vm32_object_id_t,
    pub user_wired_count: ::libc::c_ushort,
}
#[test]
fn bindgen_test_layout_vm_region_submap_short_info_64() {
    const UNINIT: ::core::mem::MaybeUninit<vm_region_submap_short_info_64> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_region_submap_short_info_64>(),
        48usize,
        concat!("Size of: ", stringify!(vm_region_submap_short_info_64))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_region_submap_short_info_64>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_region_submap_short_info_64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).protection) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_protection) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inheritance) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(inheritance)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_tag) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(user_tag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ref_count) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).shadow_depth) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(shadow_depth)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).external_pager) as usize - ptr as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(external_pager)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).share_mode) as usize - ptr as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(share_mode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).is_submap) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(is_submap)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(behavior)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).object_id) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(object_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).user_wired_count) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_region_submap_short_info_64),
            "::",
            stringify!(user_wired_count)
        )
    );
}
pub type vm_region_submap_short_info_64_t = *mut vm_region_submap_short_info_64;
pub type vm_region_submap_short_info_data_64_t = vm_region_submap_short_info_64;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_vm_read_entry {
    pub address: mach_vm_address_t,
    pub size: mach_vm_size_t,
}
#[test]
fn bindgen_test_layout_mach_vm_read_entry() {
    const UNINIT: ::core::mem::MaybeUninit<mach_vm_read_entry> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_vm_read_entry>(),
        16usize,
        concat!("Size of: ", stringify!(mach_vm_read_entry))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_vm_read_entry>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_vm_read_entry))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_read_entry),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_read_entry),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct vm_read_entry {
    pub address: vm_address_t,
    pub size: vm_size_t,
}
#[test]
fn bindgen_test_layout_vm_read_entry() {
    const UNINIT: ::core::mem::MaybeUninit<vm_read_entry> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_read_entry>(),
        16usize,
        concat!("Size of: ", stringify!(vm_read_entry))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_read_entry>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_read_entry))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_read_entry),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_read_entry),
            "::",
            stringify!(size)
        )
    );
}
pub type mach_vm_read_entry_t = [mach_vm_read_entry; 256usize];
pub type vm_read_entry_t = [vm_read_entry; 256usize];
pub type vm_page_info_t = *mut ::libc::c_int;
pub type vm_page_info_data_t = [::libc::c_int; 0usize];
pub type vm_page_info_flavor_t = ::libc::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_page_info_basic {
    pub disposition: ::libc::c_int,
    pub ref_count: ::libc::c_int,
    pub object_id: vm_object_id_t,
    pub offset: memory_object_offset_t,
    pub depth: ::libc::c_int,
    pub __pad: ::libc::c_int,
}
#[test]
fn bindgen_test_layout_vm_page_info_basic() {
    const UNINIT: ::core::mem::MaybeUninit<vm_page_info_basic> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_page_info_basic>(),
        32usize,
        concat!("Size of: ", stringify!(vm_page_info_basic))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_page_info_basic>(),
        8usize,
        concat!("Alignment of ", stringify!(vm_page_info_basic))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).disposition) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_page_info_basic),
            "::",
            stringify!(disposition)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ref_count) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_page_info_basic),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).object_id) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_page_info_basic),
            "::",
            stringify!(object_id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_page_info_basic),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).depth) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_page_info_basic),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).__pad) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_page_info_basic),
            "::",
            stringify!(__pad)
        )
    );
}
pub type vm_page_info_basic_t = *mut vm_page_info_basic;
pub type vm_page_info_basic_data_t = vm_page_info_basic;
pub type kmod_t = ::libc::c_int;
pub type kmod_start_func_t = ::core::option::Option<
    unsafe extern "C" fn(ki: *mut kmod_info, data: *mut ::libc::c_void) -> kern_return_t,
>;
pub type kmod_stop_func_t = ::core::option::Option<
    unsafe extern "C" fn(ki: *mut kmod_info, data: *mut ::libc::c_void) -> kern_return_t,
>;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct kmod_reference {
    pub next: *mut kmod_reference,
    pub info: *mut kmod_info,
}
#[test]
fn bindgen_test_layout_kmod_reference() {
    const UNINIT: ::core::mem::MaybeUninit<kmod_reference> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<kmod_reference>(),
        16usize,
        concat!("Size of: ", stringify!(kmod_reference))
    );
    assert_eq!(
        ::core::mem::align_of::<kmod_reference>(),
        4usize,
        concat!("Alignment of ", stringify!(kmod_reference))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_reference),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_reference),
            "::",
            stringify!(info)
        )
    );
}
pub type kmod_reference_t = kmod_reference;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct kmod_info {
    pub next: *mut kmod_info,
    pub info_version: i32,
    pub id: u32,
    pub name: [::libc::c_char; 64usize],
    pub version: [::libc::c_char; 64usize],
    pub reference_count: i32,
    pub reference_list: *mut kmod_reference_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub hdr_size: vm_size_t,
    pub start: kmod_start_func_t,
    pub stop: kmod_stop_func_t,
}
#[test]
fn bindgen_test_layout_kmod_info() {
    const UNINIT: ::core::mem::MaybeUninit<kmod_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<kmod_info>(),
        196usize,
        concat!("Size of: ", stringify!(kmod_info))
    );
    assert_eq!(
        ::core::mem::align_of::<kmod_info>(),
        4usize,
        concat!("Alignment of ", stringify!(kmod_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).info_version) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(info_version)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reference_count) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(reference_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reference_list) as usize - ptr as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(reference_list)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).hdr_size) as usize - ptr as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(hdr_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).stop) as usize - ptr as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info),
            "::",
            stringify!(stop)
        )
    );
}
pub type kmod_info_t = kmod_info;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kmod_info_32_v1 {
    pub next_addr: u32,
    pub info_version: i32,
    pub id: u32,
    pub name: [u8; 64usize],
    pub version: [u8; 64usize],
    pub reference_count: i32,
    pub reference_list_addr: u32,
    pub address: u32,
    pub size: u32,
    pub hdr_size: u32,
    pub start_addr: u32,
    pub stop_addr: u32,
}
#[test]
fn bindgen_test_layout_kmod_info_32_v1() {
    const UNINIT: ::core::mem::MaybeUninit<kmod_info_32_v1> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<kmod_info_32_v1>(),
        168usize,
        concat!("Size of: ", stringify!(kmod_info_32_v1))
    );
    assert_eq!(
        ::core::mem::align_of::<kmod_info_32_v1>(),
        4usize,
        concat!("Alignment of ", stringify!(kmod_info_32_v1))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).next_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(next_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).info_version) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(info_version)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reference_count) as usize - ptr as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(reference_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reference_list_addr) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(reference_list_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).hdr_size) as usize - ptr as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(hdr_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).start_addr) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(start_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).stop_addr) as usize - ptr as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_32_v1),
            "::",
            stringify!(stop_addr)
        )
    );
}
pub type kmod_info_32_v1_t = kmod_info_32_v1;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct kmod_info_64_v1 {
    pub next_addr: u64,
    pub info_version: i32,
    pub id: u32,
    pub name: [u8; 64usize],
    pub version: [u8; 64usize],
    pub reference_count: i32,
    pub reference_list_addr: u64,
    pub address: u64,
    pub size: u64,
    pub hdr_size: u64,
    pub start_addr: u64,
    pub stop_addr: u64,
}
#[test]
fn bindgen_test_layout_kmod_info_64_v1() {
    const UNINIT: ::core::mem::MaybeUninit<kmod_info_64_v1> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<kmod_info_64_v1>(),
        196usize,
        concat!("Size of: ", stringify!(kmod_info_64_v1))
    );
    assert_eq!(
        ::core::mem::align_of::<kmod_info_64_v1>(),
        4usize,
        concat!("Alignment of ", stringify!(kmod_info_64_v1))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).next_addr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(next_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).info_version) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(info_version)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reference_count) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(reference_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reference_list_addr) as usize - ptr as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(reference_list_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).hdr_size) as usize - ptr as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(hdr_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).start_addr) as usize - ptr as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(start_addr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).stop_addr) as usize - ptr as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(kmod_info_64_v1),
            "::",
            stringify!(stop_addr)
        )
    );
}
pub type kmod_info_64_v1_t = kmod_info_64_v1;
pub type kmod_args_t = *mut ::libc::c_void;
pub type kmod_control_flavor_t = ::libc::c_int;
pub type kmod_info_array_t = *mut kmod_info_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fsid {
    pub val: [i32; 2usize],
}
#[test]
fn bindgen_test_layout_fsid() {
    const UNINIT: ::core::mem::MaybeUninit<fsid> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<fsid>(),
        8usize,
        concat!("Size of: ", stringify!(fsid))
    );
    assert_eq!(
        ::core::mem::align_of::<fsid>(),
        4usize,
        concat!("Alignment of ", stringify!(fsid))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).val) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(fsid), "::", stringify!(val))
    );
}
pub type fsid_t = fsid;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fsobj_id {
    pub fid_objno: u_int32_t,
    pub fid_generation: u_int32_t,
}
#[test]
fn bindgen_test_layout_fsobj_id() {
    const UNINIT: ::core::mem::MaybeUninit<fsobj_id> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<fsobj_id>(),
        8usize,
        concat!("Size of: ", stringify!(fsobj_id))
    );
    assert_eq!(
        ::core::mem::align_of::<fsobj_id>(),
        4usize,
        concat!("Alignment of ", stringify!(fsobj_id))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fid_objno) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fsobj_id),
            "::",
            stringify!(fid_objno)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fid_generation) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(fsobj_id),
            "::",
            stringify!(fid_generation)
        )
    );
}
pub type fsobj_id_t = fsobj_id;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dyld_kernel_image_info {
    pub uuid: uuid_t,
    pub fsobjid: fsobj_id_t,
    pub fsid: fsid_t,
    pub load_addr: u64,
}
#[test]
fn bindgen_test_layout_dyld_kernel_image_info() {
    const UNINIT: ::core::mem::MaybeUninit<dyld_kernel_image_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<dyld_kernel_image_info>(),
        40usize,
        concat!("Size of: ", stringify!(dyld_kernel_image_info))
    );
    assert_eq!(
        ::core::mem::align_of::<dyld_kernel_image_info>(),
        8usize,
        concat!("Alignment of ", stringify!(dyld_kernel_image_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).uuid) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_image_info),
            "::",
            stringify!(uuid)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fsobjid) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_image_info),
            "::",
            stringify!(fsobjid)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).fsid) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_image_info),
            "::",
            stringify!(fsid)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).load_addr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_image_info),
            "::",
            stringify!(load_addr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dyld_kernel_process_info {
    pub cache_image_info: dyld_kernel_image_info,
    pub timestamp: u64,
    pub imageCount: u32,
    pub initialImageCount: u32,
    pub dyldState: u8,
    pub no_cache: boolean_t,
    pub private_cache: boolean_t,
}
#[test]
fn bindgen_test_layout_dyld_kernel_process_info() {
    const UNINIT: ::core::mem::MaybeUninit<dyld_kernel_process_info> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<dyld_kernel_process_info>(),
        72usize,
        concat!("Size of: ", stringify!(dyld_kernel_process_info))
    );
    assert_eq!(
        ::core::mem::align_of::<dyld_kernel_process_info>(),
        8usize,
        concat!("Alignment of ", stringify!(dyld_kernel_process_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cache_image_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_process_info),
            "::",
            stringify!(cache_image_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).timestamp) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_process_info),
            "::",
            stringify!(timestamp)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).imageCount) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_process_info),
            "::",
            stringify!(imageCount)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).initialImageCount) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_process_info),
            "::",
            stringify!(initialImageCount)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyldState) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_process_info),
            "::",
            stringify!(dyldState)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).no_cache) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_process_info),
            "::",
            stringify!(no_cache)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).private_cache) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(dyld_kernel_process_info),
            "::",
            stringify!(private_cache)
        )
    );
}
pub type dyld_kernel_image_info_t = dyld_kernel_image_info;
pub type dyld_kernel_process_info_t = dyld_kernel_process_info;
pub type dyld_kernel_image_info_array_t = *mut dyld_kernel_image_info_t;
pub type task_t = mach_port_t;
pub type task_name_t = mach_port_t;
pub type task_policy_set_t = mach_port_t;
pub type task_policy_get_t = mach_port_t;
pub type task_inspect_t = mach_port_t;
pub type task_read_t = mach_port_t;
pub type task_suspension_token_t = mach_port_t;
pub type thread_t = mach_port_t;
pub type thread_act_t = mach_port_t;
pub type thread_inspect_t = mach_port_t;
pub type thread_read_t = mach_port_t;
pub type ipc_space_t = mach_port_t;
pub type ipc_space_read_t = mach_port_t;
pub type ipc_space_inspect_t = mach_port_t;
pub type coalition_t = mach_port_t;
pub type host_t = mach_port_t;
pub type host_priv_t = mach_port_t;
pub type host_security_t = mach_port_t;
pub type processor_t = mach_port_t;
pub type processor_set_t = mach_port_t;
pub type processor_set_control_t = mach_port_t;
pub type semaphore_t = mach_port_t;
pub type lock_set_t = mach_port_t;
pub type ledger_t = mach_port_t;
pub type alarm_t = mach_port_t;
pub type clock_serv_t = mach_port_t;
pub type clock_ctrl_t = mach_port_t;
pub type arcade_register_t = mach_port_t;
pub type ipc_eventlink_t = mach_port_t;
pub type eventlink_port_pair_t = [mach_port_t; 2usize];
pub type task_id_token_t = mach_port_t;
pub type kcdata_object_t = mach_port_t;
pub type processor_set_name_t = processor_set_t;
pub type clock_reply_t = mach_port_t;
pub type bootstrap_t = mach_port_t;
pub type mem_entry_name_port_t = mach_port_t;
pub type exception_handler_t = mach_port_t;
pub type exception_handler_array_t = *mut exception_handler_t;
pub type vm_task_entry_t = mach_port_t;
pub type io_main_t = mach_port_t;
pub type UNDServerRef = mach_port_t;
pub type mach_eventlink_t = mach_port_t;
pub type exception_handler_info_t = ipc_info_port_t;
pub type task_array_t = *mut task_t;
pub type thread_array_t = *mut thread_t;
pub type processor_set_array_t = *mut processor_set_t;
pub type processor_set_name_array_t = *mut processor_set_t;
pub type processor_array_t = *mut processor_t;
pub type thread_act_array_t = *mut thread_act_t;
pub type ledger_array_t = *mut ledger_t;
pub type task_port_t = task_t;
pub type task_port_array_t = task_array_t;
pub type thread_port_t = thread_t;
pub type thread_port_array_t = thread_array_t;
pub type ipc_space_port_t = ipc_space_t;
pub type host_name_t = host_t;
pub type host_name_port_t = host_t;
pub type processor_set_port_t = processor_set_t;
pub type processor_set_name_port_t = processor_set_t;
pub type processor_set_name_port_array_t = processor_set_array_t;
pub type processor_set_control_port_t = processor_set_t;
pub type processor_port_t = processor_t;
pub type processor_port_array_t = processor_array_t;
pub type thread_act_port_t = thread_act_t;
pub type thread_act_port_array_t = thread_act_array_t;
pub type semaphore_port_t = semaphore_t;
pub type lock_set_port_t = lock_set_t;
pub type ledger_port_t = ledger_t;
pub type ledger_port_array_t = ledger_array_t;
pub type alarm_port_t = alarm_t;
pub type clock_serv_port_t = clock_serv_t;
pub type clock_ctrl_port_t = clock_ctrl_t;
pub type exception_port_t = exception_handler_t;
pub type exception_port_arrary_t = exception_handler_array_t;
pub type vfs_path_t = [::libc::c_char; 4096usize];
pub type nspace_path_t = [::libc::c_char; 8192usize];
pub type nspace_name_t = [::libc::c_char; 8192usize];
pub type mach_task_flavor_t = ::libc::c_uint;
pub type mach_thread_flavor_t = ::libc::c_uint;
pub type ledger_item_t = natural_t;
pub type ledger_amount_t = i64;
pub type emulation_vector_t = *mut mach_vm_offset_t;
pub type user_subsystem_t = *mut ::libc::c_char;
pub type labelstr_t = *mut ::libc::c_char;
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
extern "C" {
    pub fn mach_host_self() -> mach_port_t;
}
extern "C" {
    pub fn mach_thread_self() -> mach_port_t;
}
extern "C" {
    pub fn mach_task_is_self(task: task_name_t) -> boolean_t;
}
extern "C" {
    pub fn host_page_size(arg1: host_t, arg2: *mut vm_size_t) -> kern_return_t;
}
extern "C" {
    pub fn clock_sleep_trap(
        clock_name: mach_port_name_t,
        sleep_type: sleep_type_t,
        sleep_sec: ::libc::c_int,
        sleep_nsec: ::libc::c_int,
        wakeup_time: *mut mach_timespec_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_vm_allocate_trap(
        target: mach_port_name_t,
        addr: *mut mach_vm_offset_t,
        size: mach_vm_size_t,
        flags: ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_vm_deallocate_trap(
        target: mach_port_name_t,
        address: mach_vm_address_t,
        size: mach_vm_size_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_dyld_process_info_notify_get(
        names_addr: mach_port_name_array_t,
        names_count_addr: *mut natural_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_vm_protect_trap(
        target: mach_port_name_t,
        address: mach_vm_address_t,
        size: mach_vm_size_t,
        set_maximum: boolean_t,
        new_protection: vm_prot_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_vm_map_trap(
        target: mach_port_name_t,
        address: *mut mach_vm_offset_t,
        size: mach_vm_size_t,
        mask: mach_vm_offset_t,
        flags: ::libc::c_int,
        cur_protection: vm_prot_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_vm_purgable_control_trap(
        target: mach_port_name_t,
        address: mach_vm_offset_t,
        control: vm_purgable_t,
        state: *mut ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_allocate_trap(
        target: mach_port_name_t,
        right: mach_port_right_t,
        name: *mut mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_deallocate_trap(
        target: mach_port_name_t,
        name: mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_mod_refs_trap(
        target: mach_port_name_t,
        name: mach_port_name_t,
        right: mach_port_right_t,
        delta: mach_port_delta_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_move_member_trap(
        target: mach_port_name_t,
        member: mach_port_name_t,
        after: mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_insert_right_trap(
        target: mach_port_name_t,
        name: mach_port_name_t,
        poly: mach_port_name_t,
        polyPoly: mach_msg_type_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_get_attributes_trap(
        target: mach_port_name_t,
        name: mach_port_name_t,
        flavor: mach_port_flavor_t,
        port_info_out: mach_port_info_t,
        port_info_outCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_insert_member_trap(
        target: mach_port_name_t,
        name: mach_port_name_t,
        pset: mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_extract_member_trap(
        target: mach_port_name_t,
        name: mach_port_name_t,
        pset: mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_construct_trap(
        target: mach_port_name_t,
        options: *mut mach_port_options_t,
        context: u64,
        name: *mut mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_destruct_trap(
        target: mach_port_name_t,
        name: mach_port_name_t,
        srdelta: mach_port_delta_t,
        guard: u64,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_guard_trap(
        target: mach_port_name_t,
        name: mach_port_name_t,
        guard: u64,
        strict: boolean_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_unguard_trap(
        target: mach_port_name_t,
        name: mach_port_name_t,
        guard: u64,
    ) -> kern_return_t;
}
extern "C" {
    pub fn mach_generate_activity_id(
        target: mach_port_name_t,
        count: ::libc::c_int,
        activity_id: *mut u64,
    ) -> kern_return_t;
}
extern "C" {
    pub fn macx_swapon(
        filename: u64,
        flags: ::libc::c_int,
        size: ::libc::c_int,
        priority: ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn macx_swapoff(filename: u64, flags: ::libc::c_int) -> kern_return_t;
}
extern "C" {
    pub fn macx_triggers(
        hi_water: ::libc::c_int,
        low_water: ::libc::c_int,
        flags: ::libc::c_int,
        alert_port: mach_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn macx_backing_store_suspend(suspend: boolean_t) -> kern_return_t;
}
extern "C" {
    pub fn macx_backing_store_recovery(pid: ::libc::c_int) -> kern_return_t;
}
extern "C" {
    pub fn swtch_pri(pri: ::libc::c_int) -> boolean_t;
}
extern "C" {
    pub fn swtch() -> boolean_t;
}
extern "C" {
    pub fn thread_switch(
        thread_name: mach_port_name_t,
        option: ::libc::c_int,
        option_time: mach_msg_timeout_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_self_trap() -> mach_port_name_t;
}
extern "C" {
    pub fn host_create_mach_voucher_trap(
        host: mach_port_name_t,
        recipes: mach_voucher_attr_raw_recipe_array_t,
        recipes_size: ::libc::c_int,
        voucher: *mut mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn mach_voucher_extract_attr_recipe_trap(
        voucher_name: mach_port_name_t,
        key: mach_voucher_attr_key_t,
        recipe: mach_voucher_attr_raw_recipe_t,
        recipe_size: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_type_trap(
        task: ipc_space_t,
        name: mach_port_name_t,
        ptype: *mut mach_port_type_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn _kernelrpc_mach_port_request_notification_trap(
        task: ipc_space_t,
        name: mach_port_name_t,
        msgid: mach_msg_id_t,
        sync: mach_port_mscount_t,
        notify: mach_port_name_t,
        notifyPoly: mach_msg_type_name_t,
        previous: *mut mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_for_pid(
        target_tport: mach_port_name_t,
        pid: ::libc::c_int,
        t: *mut mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_name_for_pid(
        target_tport: mach_port_name_t,
        pid: ::libc::c_int,
        tn: *mut mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn pid_for_task(t: mach_port_name_t, x: *mut ::libc::c_int) -> kern_return_t;
}
extern "C" {
    pub fn debug_control_port_for_pid(
        target_tport: mach_port_name_t,
        pid: ::libc::c_int,
        t: *mut mach_port_name_t,
    ) -> kern_return_t;
}
pub type __darwin_nl_item = ::libc::c_int;
pub type __darwin_wctrans_t = ::libc::c_int;
pub type __darwin_wctype_t = __uint32_t;
extern "C" {
    pub fn memchr(
        __s: *const ::libc::c_void,
        __c: ::libc::c_int,
        __n: ::libc::c_ulong,
    ) -> *mut ::libc::c_void;
}
extern "C" {
    pub fn memcmp(
        __s1: *const ::libc::c_void,
        __s2: *const ::libc::c_void,
        __n: ::libc::c_ulong,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn memcpy(
        __dst: *mut ::libc::c_void,
        __src: *const ::libc::c_void,
        __n: ::libc::c_ulong,
    ) -> *mut ::libc::c_void;
}
extern "C" {
    pub fn memmove(
        __dst: *mut ::libc::c_void,
        __src: *const ::libc::c_void,
        __len: ::libc::c_ulong,
    ) -> *mut ::libc::c_void;
}
extern "C" {
    pub fn memset(
        __b: *mut ::libc::c_void,
        __c: ::libc::c_int,
        __len: ::libc::c_ulong,
    ) -> *mut ::libc::c_void;
}
extern "C" {
    pub fn strcat(__s1: *mut ::libc::c_char, __s2: *const ::libc::c_char) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strchr(__s: *const ::libc::c_char, __c: ::libc::c_int) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strcmp(__s1: *const ::libc::c_char, __s2: *const ::libc::c_char) -> ::libc::c_int;
}
extern "C" {
    pub fn strcoll(__s1: *const ::libc::c_char, __s2: *const ::libc::c_char) -> ::libc::c_int;
}
extern "C" {
    pub fn strcpy(__dst: *mut ::libc::c_char, __src: *const ::libc::c_char) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strcspn(__s: *const ::libc::c_char, __charset: *const ::libc::c_char)
        -> ::libc::c_ulong;
}
extern "C" {
    pub fn strerror(__errnum: ::libc::c_int) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strlen(__s: *const ::libc::c_char) -> ::libc::c_ulong;
}
extern "C" {
    pub fn strncat(
        __s1: *mut ::libc::c_char,
        __s2: *const ::libc::c_char,
        __n: ::libc::c_ulong,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strncmp(
        __s1: *const ::libc::c_char,
        __s2: *const ::libc::c_char,
        __n: ::libc::c_ulong,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn strncpy(
        __dst: *mut ::libc::c_char,
        __src: *const ::libc::c_char,
        __n: ::libc::c_ulong,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strpbrk(
        __s: *const ::libc::c_char,
        __charset: *const ::libc::c_char,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strrchr(__s: *const ::libc::c_char, __c: ::libc::c_int) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strspn(__s: *const ::libc::c_char, __charset: *const ::libc::c_char) -> ::libc::c_ulong;
}
extern "C" {
    pub fn strstr(
        __big: *const ::libc::c_char,
        __little: *const ::libc::c_char,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strtok(__str: *mut ::libc::c_char, __sep: *const ::libc::c_char) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strxfrm(
        __s1: *mut ::libc::c_char,
        __s2: *const ::libc::c_char,
        __n: ::libc::c_ulong,
    ) -> ::libc::c_ulong;
}
extern "C" {
    pub fn strtok_r(
        __str: *mut ::libc::c_char,
        __sep: *const ::libc::c_char,
        __lasts: *mut *mut ::libc::c_char,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strerror_r(
        __errnum: ::libc::c_int,
        __strerrbuf: *mut ::libc::c_char,
        __buflen: usize,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn strdup(__s1: *const ::libc::c_char) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn memccpy(
        __dst: *mut ::libc::c_void,
        __src: *const ::libc::c_void,
        __c: ::libc::c_int,
        __n: ::libc::c_ulong,
    ) -> *mut ::libc::c_void;
}
extern "C" {
    pub fn stpcpy(__dst: *mut ::libc::c_char, __src: *const ::libc::c_char) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn stpncpy(
        __dst: *mut ::libc::c_char,
        __src: *const ::libc::c_char,
        __n: ::libc::c_ulong,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strndup(__s1: *const ::libc::c_char, __n: ::libc::c_ulong) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strnlen(__s1: *const ::libc::c_char, __n: usize) -> usize;
}
extern "C" {
    pub fn strsignal(__sig: ::libc::c_int) -> *mut ::libc::c_char;
}
pub type rsize_t = __darwin_size_t;
pub type errno_t = ::libc::c_int;
extern "C" {
    pub fn memset_s(
        __s: *mut ::libc::c_void,
        __smax: rsize_t,
        __c: ::libc::c_int,
        __n: rsize_t,
    ) -> errno_t;
}
extern "C" {
    pub fn memmem(
        __big: *const ::libc::c_void,
        __big_len: usize,
        __little: *const ::libc::c_void,
        __little_len: usize,
    ) -> *mut ::libc::c_void;
}
extern "C" {
    pub fn memset_pattern4(
        __b: *mut ::libc::c_void,
        __pattern4: *const ::libc::c_void,
        __len: usize,
    );
}
extern "C" {
    pub fn memset_pattern8(
        __b: *mut ::libc::c_void,
        __pattern8: *const ::libc::c_void,
        __len: usize,
    );
}
extern "C" {
    pub fn memset_pattern16(
        __b: *mut ::libc::c_void,
        __pattern16: *const ::libc::c_void,
        __len: usize,
    );
}
extern "C" {
    pub fn strcasestr(
        __big: *const ::libc::c_char,
        __little: *const ::libc::c_char,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strnstr(
        __big: *const ::libc::c_char,
        __little: *const ::libc::c_char,
        __len: usize,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn strlcat(
        __dst: *mut ::libc::c_char,
        __source: *const ::libc::c_char,
        __size: ::libc::c_ulong,
    ) -> ::libc::c_ulong;
}
extern "C" {
    pub fn strlcpy(
        __dst: *mut ::libc::c_char,
        __source: *const ::libc::c_char,
        __size: ::libc::c_ulong,
    ) -> ::libc::c_ulong;
}
extern "C" {
    pub fn strmode(__mode: ::libc::c_int, __bp: *mut ::libc::c_char);
}
extern "C" {
    pub fn strsep(
        __stringp: *mut *mut ::libc::c_char,
        __delim: *const ::libc::c_char,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn swab(arg1: *const ::libc::c_void, arg2: *mut ::libc::c_void, arg3: isize);
}
extern "C" {
    pub fn timingsafe_bcmp(
        __b1: *const ::libc::c_void,
        __b2: *const ::libc::c_void,
        __len: usize,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn strsignal_r(
        __sig: ::libc::c_int,
        __strsignalbuf: *mut ::libc::c_char,
        __buflen: usize,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn bcmp(
        arg1: *const ::libc::c_void,
        arg2: *const ::libc::c_void,
        arg3: ::libc::c_ulong,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn bcopy(arg1: *const ::libc::c_void, arg2: *mut ::libc::c_void, arg3: usize);
}
extern "C" {
    pub fn bzero(arg1: *mut ::libc::c_void, arg2: ::libc::c_ulong);
}
extern "C" {
    pub fn index(arg1: *const ::libc::c_char, arg2: ::libc::c_int) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn rindex(arg1: *const ::libc::c_char, arg2: ::libc::c_int) -> *mut ::libc::c_char;
}
extern "C" {
    pub fn ffs(arg1: ::libc::c_int) -> ::libc::c_int;
}
extern "C" {
    pub fn strcasecmp(arg1: *const ::libc::c_char, arg2: *const ::libc::c_char) -> ::libc::c_int;
}
extern "C" {
    pub fn strncasecmp(
        arg1: *const ::libc::c_char,
        arg2: *const ::libc::c_char,
        arg3: ::libc::c_ulong,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn ffsl(arg1: ::libc::c_long) -> ::libc::c_int;
}
extern "C" {
    pub fn ffsll(arg1: ::libc::c_longlong) -> ::libc::c_int;
}
extern "C" {
    pub fn fls(arg1: ::libc::c_int) -> ::libc::c_int;
}
extern "C" {
    pub fn flsl(arg1: ::libc::c_long) -> ::libc::c_int;
}
extern "C" {
    pub fn flsll(arg1: ::libc::c_longlong) -> ::libc::c_int;
}
pub const OSUnknownByteOrder: _bindgen_ty_1 = 0;
pub const OSLittleEndian: _bindgen_ty_1 = 1;
pub const OSBigEndian: _bindgen_ty_1 = 2;
pub type _bindgen_ty_1 = ::libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NDR_record_t {
    pub mig_vers: ::libc::c_uchar,
    pub if_vers: ::libc::c_uchar,
    pub reserved1: ::libc::c_uchar,
    pub mig_encoding: ::libc::c_uchar,
    pub int_rep: ::libc::c_uchar,
    pub char_rep: ::libc::c_uchar,
    pub float_rep: ::libc::c_uchar,
    pub reserved2: ::libc::c_uchar,
}
#[test]
fn bindgen_test_layout_NDR_record_t() {
    const UNINIT: ::core::mem::MaybeUninit<NDR_record_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<NDR_record_t>(),
        8usize,
        concat!("Size of: ", stringify!(NDR_record_t))
    );
    assert_eq!(
        ::core::mem::align_of::<NDR_record_t>(),
        1usize,
        concat!("Alignment of ", stringify!(NDR_record_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mig_vers) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(NDR_record_t),
            "::",
            stringify!(mig_vers)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).if_vers) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(NDR_record_t),
            "::",
            stringify!(if_vers)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved1) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(NDR_record_t),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mig_encoding) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(NDR_record_t),
            "::",
            stringify!(mig_encoding)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).int_rep) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(NDR_record_t),
            "::",
            stringify!(int_rep)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).char_rep) as usize - ptr as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(NDR_record_t),
            "::",
            stringify!(char_rep)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).float_rep) as usize - ptr as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(NDR_record_t),
            "::",
            stringify!(float_rep)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved2) as usize - ptr as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(NDR_record_t),
            "::",
            stringify!(reserved2)
        )
    );
}
pub type notify_port_t = mach_port_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_deleted_notification_t {
    pub not_header: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub not_port: mach_port_name_t,
    pub trailer: mach_msg_format_0_trailer_t,
}
#[test]
fn bindgen_test_layout_mach_port_deleted_notification_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_port_deleted_notification_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_port_deleted_notification_t>(),
        56usize,
        concat!("Size of: ", stringify!(mach_port_deleted_notification_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_port_deleted_notification_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_port_deleted_notification_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_header) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_deleted_notification_t),
            "::",
            stringify!(not_header)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_deleted_notification_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_port) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_deleted_notification_t),
            "::",
            stringify!(not_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).trailer) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_deleted_notification_t),
            "::",
            stringify!(trailer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_send_possible_notification_t {
    pub not_header: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub not_port: mach_port_name_t,
    pub trailer: mach_msg_format_0_trailer_t,
}
#[test]
fn bindgen_test_layout_mach_send_possible_notification_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_send_possible_notification_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_send_possible_notification_t>(),
        56usize,
        concat!("Size of: ", stringify!(mach_send_possible_notification_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_send_possible_notification_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_send_possible_notification_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_header) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_send_possible_notification_t),
            "::",
            stringify!(not_header)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_send_possible_notification_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_port) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_send_possible_notification_t),
            "::",
            stringify!(not_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).trailer) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_send_possible_notification_t),
            "::",
            stringify!(trailer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_port_destroyed_notification_t {
    pub not_header: mach_msg_header_t,
    pub not_body: mach_msg_body_t,
    pub not_port: mach_msg_port_descriptor_t,
    pub trailer: mach_msg_format_0_trailer_t,
}
#[test]
fn bindgen_test_layout_mach_port_destroyed_notification_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_port_destroyed_notification_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_port_destroyed_notification_t>(),
        60usize,
        concat!("Size of: ", stringify!(mach_port_destroyed_notification_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_port_destroyed_notification_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(mach_port_destroyed_notification_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_header) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_destroyed_notification_t),
            "::",
            stringify!(not_header)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_destroyed_notification_t),
            "::",
            stringify!(not_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_port) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_destroyed_notification_t),
            "::",
            stringify!(not_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).trailer) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_port_destroyed_notification_t),
            "::",
            stringify!(trailer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_no_senders_notification_t {
    pub not_header: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub not_count: mach_msg_type_number_t,
    pub trailer: mach_msg_format_0_trailer_t,
}
#[test]
fn bindgen_test_layout_mach_no_senders_notification_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_no_senders_notification_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_no_senders_notification_t>(),
        56usize,
        concat!("Size of: ", stringify!(mach_no_senders_notification_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_no_senders_notification_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_no_senders_notification_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_header) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_no_senders_notification_t),
            "::",
            stringify!(not_header)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_no_senders_notification_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_count) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_no_senders_notification_t),
            "::",
            stringify!(not_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).trailer) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_no_senders_notification_t),
            "::",
            stringify!(trailer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_send_once_notification_t {
    pub not_header: mach_msg_header_t,
    pub trailer: mach_msg_format_0_trailer_t,
}
#[test]
fn bindgen_test_layout_mach_send_once_notification_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_send_once_notification_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_send_once_notification_t>(),
        44usize,
        concat!("Size of: ", stringify!(mach_send_once_notification_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_send_once_notification_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_send_once_notification_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_header) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_send_once_notification_t),
            "::",
            stringify!(not_header)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).trailer) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_send_once_notification_t),
            "::",
            stringify!(trailer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_dead_name_notification_t {
    pub not_header: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub not_port: mach_port_name_t,
    pub trailer: mach_msg_format_0_trailer_t,
}
#[test]
fn bindgen_test_layout_mach_dead_name_notification_t() {
    const UNINIT: ::core::mem::MaybeUninit<mach_dead_name_notification_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_dead_name_notification_t>(),
        56usize,
        concat!("Size of: ", stringify!(mach_dead_name_notification_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_dead_name_notification_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_dead_name_notification_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_header) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_dead_name_notification_t),
            "::",
            stringify!(not_header)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_dead_name_notification_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).not_port) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_dead_name_notification_t),
            "::",
            stringify!(not_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).trailer) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_dead_name_notification_t),
            "::",
            stringify!(trailer)
        )
    );
}
pub type mig_stub_routine_t = ::core::option::Option<
    unsafe extern "C" fn(InHeadP: *mut mach_msg_header_t, OutHeadP: *mut mach_msg_header_t),
>;
pub type mig_routine_t = mig_stub_routine_t;
pub type mig_server_routine_t =
    ::core::option::Option<unsafe extern "C" fn(InHeadP: *mut mach_msg_header_t) -> mig_routine_t>;
pub type mig_impl_routine_t = ::core::option::Option<unsafe extern "C" fn() -> kern_return_t>;
pub type routine_arg_descriptor = mach_msg_type_descriptor_t;
pub type routine_arg_descriptor_t = *mut mach_msg_type_descriptor_t;
pub type mig_routine_arg_descriptor_t = *mut mach_msg_type_descriptor_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct routine_descriptor {
    pub impl_routine: mig_impl_routine_t,
    pub stub_routine: mig_stub_routine_t,
    pub argc: ::libc::c_uint,
    pub descr_count: ::libc::c_uint,
    pub arg_descr: routine_arg_descriptor_t,
    pub max_reply_msg: ::libc::c_uint,
}
#[test]
fn bindgen_test_layout_routine_descriptor() {
    const UNINIT: ::core::mem::MaybeUninit<routine_descriptor> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<routine_descriptor>(),
        40usize,
        concat!("Size of: ", stringify!(routine_descriptor))
    );
    assert_eq!(
        ::core::mem::align_of::<routine_descriptor>(),
        8usize,
        concat!("Alignment of ", stringify!(routine_descriptor))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).impl_routine) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(routine_descriptor),
            "::",
            stringify!(impl_routine)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).stub_routine) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(routine_descriptor),
            "::",
            stringify!(stub_routine)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).argc) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(routine_descriptor),
            "::",
            stringify!(argc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).descr_count) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(routine_descriptor),
            "::",
            stringify!(descr_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).arg_descr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(routine_descriptor),
            "::",
            stringify!(arg_descr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_reply_msg) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(routine_descriptor),
            "::",
            stringify!(max_reply_msg)
        )
    );
}
pub type routine_descriptor_t = *mut routine_descriptor;
pub type mig_routine_descriptor = routine_descriptor;
pub type mig_routine_descriptor_t = *mut mig_routine_descriptor;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mig_subsystem {
    pub server: mig_server_routine_t,
    pub start: mach_msg_id_t,
    pub end: mach_msg_id_t,
    pub maxsize: mach_msg_size_t,
    pub reserved: vm_address_t,
    pub routine: [mig_routine_descriptor; 1usize],
}
#[test]
fn bindgen_test_layout_mig_subsystem() {
    const UNINIT: ::core::mem::MaybeUninit<mig_subsystem> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mig_subsystem>(),
        72usize,
        concat!("Size of: ", stringify!(mig_subsystem))
    );
    assert_eq!(
        ::core::mem::align_of::<mig_subsystem>(),
        8usize,
        concat!("Alignment of ", stringify!(mig_subsystem))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).server) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_subsystem),
            "::",
            stringify!(server)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).start) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_subsystem),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).end) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_subsystem),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).maxsize) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_subsystem),
            "::",
            stringify!(maxsize)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_subsystem),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).routine) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_subsystem),
            "::",
            stringify!(routine)
        )
    );
}
pub type mig_subsystem_t = *mut mig_subsystem;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mig_symtab {
    pub ms_routine_name: *mut ::libc::c_char,
    pub ms_routine_number: ::libc::c_int,
    pub ms_routine: ::core::option::Option<unsafe extern "C" fn()>,
}
#[test]
fn bindgen_test_layout_mig_symtab() {
    const UNINIT: ::core::mem::MaybeUninit<mig_symtab> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mig_symtab>(),
        24usize,
        concat!("Size of: ", stringify!(mig_symtab))
    );
    assert_eq!(
        ::core::mem::align_of::<mig_symtab>(),
        8usize,
        concat!("Alignment of ", stringify!(mig_symtab))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ms_routine_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_symtab),
            "::",
            stringify!(ms_routine_name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ms_routine_number) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_symtab),
            "::",
            stringify!(ms_routine_number)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ms_routine) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_symtab),
            "::",
            stringify!(ms_routine)
        )
    );
}
pub type mig_symtab_t = mig_symtab;
extern "C" {
    pub fn mig_get_reply_port() -> mach_port_t;
}
extern "C" {
    pub fn mig_dealloc_reply_port(reply_port: mach_port_t);
}
extern "C" {
    pub fn mig_put_reply_port(reply_port: mach_port_t);
}
extern "C" {
    pub fn mig_strncpy(
        dest: *mut ::libc::c_char,
        src: *const ::libc::c_char,
        len: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn mig_strncpy_zerofill(
        dest: *mut ::libc::c_char,
        src: *const ::libc::c_char,
        len: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    pub fn mig_allocate(arg1: *mut vm_address_t, arg2: vm_size_t);
}
extern "C" {
    pub fn mig_deallocate(arg1: vm_address_t, arg2: vm_size_t);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mig_reply_error_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout_mig_reply_error_t() {
    const UNINIT: ::core::mem::MaybeUninit<mig_reply_error_t> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mig_reply_error_t>(),
        36usize,
        concat!("Size of: ", stringify!(mig_reply_error_t))
    );
    assert_eq!(
        ::core::mem::align_of::<mig_reply_error_t>(),
        4usize,
        concat!("Alignment of ", stringify!(mig_reply_error_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_reply_error_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_reply_error_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mig_reply_error_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct mach_vm_info_region {
    pub vir_start: mach_vm_offset_t,
    pub vir_end: mach_vm_offset_t,
    pub vir_object: mach_vm_offset_t,
    pub vir_offset: memory_object_offset_t,
    pub vir_needs_copy: boolean_t,
    pub vir_protection: vm_prot_t,
    pub vir_max_protection: vm_prot_t,
    pub vir_inheritance: vm_inherit_t,
    pub vir_wired_count: natural_t,
    pub vir_user_wired_count: natural_t,
}
#[test]
fn bindgen_test_layout_mach_vm_info_region() {
    const UNINIT: ::core::mem::MaybeUninit<mach_vm_info_region> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_vm_info_region>(),
        56usize,
        concat!("Size of: ", stringify!(mach_vm_info_region))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_vm_info_region>(),
        4usize,
        concat!("Alignment of ", stringify!(mach_vm_info_region))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_start) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_start)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_end) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_end)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_object) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_object)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_offset) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_needs_copy) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_needs_copy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_protection) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_max_protection) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_inheritance) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_inheritance)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_wired_count) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_wired_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_user_wired_count) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_vm_info_region),
            "::",
            stringify!(vir_user_wired_count)
        )
    );
}
pub type mach_vm_info_region_t = mach_vm_info_region;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct vm_info_region_64 {
    pub vir_start: natural_t,
    pub vir_end: natural_t,
    pub vir_object: natural_t,
    pub vir_offset: memory_object_offset_t,
    pub vir_needs_copy: boolean_t,
    pub vir_protection: vm_prot_t,
    pub vir_max_protection: vm_prot_t,
    pub vir_inheritance: vm_inherit_t,
    pub vir_wired_count: natural_t,
    pub vir_user_wired_count: natural_t,
}
#[test]
fn bindgen_test_layout_vm_info_region_64() {
    const UNINIT: ::core::mem::MaybeUninit<vm_info_region_64> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_info_region_64>(),
        44usize,
        concat!("Size of: ", stringify!(vm_info_region_64))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_info_region_64>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_info_region_64))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_start) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_start)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_end) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_end)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_object) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_object)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_offset) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_needs_copy) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_needs_copy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_protection) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_max_protection) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_inheritance) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_inheritance)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_wired_count) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_wired_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_user_wired_count) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region_64),
            "::",
            stringify!(vir_user_wired_count)
        )
    );
}
pub type vm_info_region_64_t = vm_info_region_64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_info_region {
    pub vir_start: natural_t,
    pub vir_end: natural_t,
    pub vir_object: natural_t,
    pub vir_offset: natural_t,
    pub vir_needs_copy: boolean_t,
    pub vir_protection: vm_prot_t,
    pub vir_max_protection: vm_prot_t,
    pub vir_inheritance: vm_inherit_t,
    pub vir_wired_count: natural_t,
    pub vir_user_wired_count: natural_t,
}
#[test]
fn bindgen_test_layout_vm_info_region() {
    const UNINIT: ::core::mem::MaybeUninit<vm_info_region> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_info_region>(),
        40usize,
        concat!("Size of: ", stringify!(vm_info_region))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_info_region>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_info_region))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_start) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_start)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_end) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_end)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_object) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_object)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_offset) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_needs_copy) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_needs_copy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_protection) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_max_protection) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_inheritance) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_inheritance)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_wired_count) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_wired_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vir_user_wired_count) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_region),
            "::",
            stringify!(vir_user_wired_count)
        )
    );
}
pub type vm_info_region_t = vm_info_region;
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct vm_info_object {
    pub vio_object: natural_t,
    pub vio_size: natural_t,
    pub vio_ref_count: ::libc::c_uint,
    pub vio_resident_page_count: ::libc::c_uint,
    pub vio_absent_count: ::libc::c_uint,
    pub vio_copy: natural_t,
    pub vio_shadow: natural_t,
    pub vio_shadow_offset: natural_t,
    pub vio_paging_offset: natural_t,
    pub vio_copy_strategy: memory_object_copy_strategy_t,
    pub vio_last_alloc: vm_offset_t,
    pub vio_paging_in_progress: ::libc::c_uint,
    pub vio_pager_created: boolean_t,
    pub vio_pager_initialized: boolean_t,
    pub vio_pager_ready: boolean_t,
    pub vio_can_persist: boolean_t,
    pub vio_internal: boolean_t,
    pub vio_temporary: boolean_t,
    pub vio_alive: boolean_t,
    pub vio_purgable: boolean_t,
    pub vio_purgable_volatile: boolean_t,
}
#[test]
fn bindgen_test_layout_vm_info_object() {
    const UNINIT: ::core::mem::MaybeUninit<vm_info_object> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<vm_info_object>(),
        88usize,
        concat!("Size of: ", stringify!(vm_info_object))
    );
    assert_eq!(
        ::core::mem::align_of::<vm_info_object>(),
        4usize,
        concat!("Alignment of ", stringify!(vm_info_object))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_object) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_object)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_size) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_ref_count) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_ref_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_resident_page_count) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_resident_page_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_absent_count) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_absent_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_copy) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_copy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_shadow) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_shadow)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_shadow_offset) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_shadow_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_paging_offset) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_paging_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_copy_strategy) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_copy_strategy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_last_alloc) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_last_alloc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_paging_in_progress) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_paging_in_progress)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_pager_created) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_pager_created)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_pager_initialized) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_pager_initialized)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_pager_ready) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_pager_ready)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_can_persist) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_can_persist)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_internal) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_internal)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_temporary) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_temporary)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_alive) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_alive)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_purgable) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_purgable)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vio_purgable_volatile) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(vm_info_object),
            "::",
            stringify!(vio_purgable_volatile)
        )
    );
}
pub type vm_info_object_t = vm_info_object;
pub type vm_info_object_array_t = *mut vm_info_object_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct zone_name {
    pub zn_name: [::libc::c_char; 80usize],
}
#[test]
fn bindgen_test_layout_zone_name() {
    const UNINIT: ::core::mem::MaybeUninit<zone_name> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<zone_name>(),
        80usize,
        concat!("Size of: ", stringify!(zone_name))
    );
    assert_eq!(
        ::core::mem::align_of::<zone_name>(),
        1usize,
        concat!("Alignment of ", stringify!(zone_name))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zn_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_name),
            "::",
            stringify!(zn_name)
        )
    );
}
pub type zone_name_t = zone_name;
pub type zone_name_array_t = *mut zone_name_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct zone_info {
    pub zi_count: integer_t,
    pub zi_cur_size: vm_size_t,
    pub zi_max_size: vm_size_t,
    pub zi_elem_size: vm_size_t,
    pub zi_alloc_size: vm_size_t,
    pub zi_pageable: integer_t,
    pub zi_sleepable: integer_t,
    pub zi_exhaustible: integer_t,
    pub zi_collectable: integer_t,
}
#[test]
fn bindgen_test_layout_zone_info() {
    const UNINIT: ::core::mem::MaybeUninit<zone_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<zone_info>(),
        56usize,
        concat!("Size of: ", stringify!(zone_info))
    );
    assert_eq!(
        ::core::mem::align_of::<zone_info>(),
        8usize,
        concat!("Alignment of ", stringify!(zone_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zi_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_info),
            "::",
            stringify!(zi_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zi_cur_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_info),
            "::",
            stringify!(zi_cur_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zi_max_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_info),
            "::",
            stringify!(zi_max_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zi_elem_size) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_info),
            "::",
            stringify!(zi_elem_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zi_alloc_size) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_info),
            "::",
            stringify!(zi_alloc_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zi_pageable) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_info),
            "::",
            stringify!(zi_pageable)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zi_sleepable) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_info),
            "::",
            stringify!(zi_sleepable)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zi_exhaustible) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_info),
            "::",
            stringify!(zi_exhaustible)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zi_collectable) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_info),
            "::",
            stringify!(zi_collectable)
        )
    );
}
pub type zone_info_t = zone_info;
pub type zone_info_array_t = *mut zone_info_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_zone_name {
    pub mzn_name: [::libc::c_char; 80usize],
}
#[test]
fn bindgen_test_layout_mach_zone_name() {
    const UNINIT: ::core::mem::MaybeUninit<mach_zone_name> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_zone_name>(),
        80usize,
        concat!("Size of: ", stringify!(mach_zone_name))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_zone_name>(),
        1usize,
        concat!("Alignment of ", stringify!(mach_zone_name))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mzn_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_zone_name),
            "::",
            stringify!(mzn_name)
        )
    );
}
pub type mach_zone_name_t = mach_zone_name;
pub type mach_zone_name_array_t = *mut mach_zone_name_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_zone_info_data {
    pub mzi_count: u64,
    pub mzi_cur_size: u64,
    pub mzi_max_size: u64,
    pub mzi_elem_size: u64,
    pub mzi_alloc_size: u64,
    pub mzi_sum_size: u64,
    pub mzi_exhaustible: u64,
    pub mzi_collectable: u64,
}
#[test]
fn bindgen_test_layout_mach_zone_info_data() {
    const UNINIT: ::core::mem::MaybeUninit<mach_zone_info_data> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_zone_info_data>(),
        64usize,
        concat!("Size of: ", stringify!(mach_zone_info_data))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_zone_info_data>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_zone_info_data))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mzi_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_zone_info_data),
            "::",
            stringify!(mzi_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mzi_cur_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_zone_info_data),
            "::",
            stringify!(mzi_cur_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mzi_max_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_zone_info_data),
            "::",
            stringify!(mzi_max_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mzi_elem_size) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_zone_info_data),
            "::",
            stringify!(mzi_elem_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mzi_alloc_size) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_zone_info_data),
            "::",
            stringify!(mzi_alloc_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mzi_sum_size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_zone_info_data),
            "::",
            stringify!(mzi_sum_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mzi_exhaustible) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_zone_info_data),
            "::",
            stringify!(mzi_exhaustible)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mzi_collectable) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_zone_info_data),
            "::",
            stringify!(mzi_collectable)
        )
    );
}
pub type mach_zone_info_t = mach_zone_info_data;
pub type mach_zone_info_array_t = *mut mach_zone_info_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct task_zone_info_data {
    pub tzi_count: u64,
    pub tzi_cur_size: u64,
    pub tzi_max_size: u64,
    pub tzi_elem_size: u64,
    pub tzi_alloc_size: u64,
    pub tzi_sum_size: u64,
    pub tzi_exhaustible: u64,
    pub tzi_collectable: u64,
    pub tzi_caller_acct: u64,
    pub tzi_task_alloc: u64,
    pub tzi_task_free: u64,
}
#[test]
fn bindgen_test_layout_task_zone_info_data() {
    const UNINIT: ::core::mem::MaybeUninit<task_zone_info_data> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<task_zone_info_data>(),
        88usize,
        concat!("Size of: ", stringify!(task_zone_info_data))
    );
    assert_eq!(
        ::core::mem::align_of::<task_zone_info_data>(),
        8usize,
        concat!("Alignment of ", stringify!(task_zone_info_data))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_cur_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_cur_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_max_size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_max_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_elem_size) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_elem_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_alloc_size) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_alloc_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_sum_size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_sum_size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_exhaustible) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_exhaustible)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_collectable) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_collectable)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_caller_acct) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_caller_acct)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_task_alloc) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_task_alloc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tzi_task_free) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(task_zone_info_data),
            "::",
            stringify!(tzi_task_free)
        )
    );
}
pub type task_zone_info_t = task_zone_info_data;
pub type task_zone_info_array_t = *mut task_zone_info_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_memory_info {
    pub flags: u64,
    pub site: u64,
    pub size: u64,
    pub free: u64,
    pub largest: u64,
    pub collectable_bytes: u64,
    pub mapped: u64,
    pub peak: u64,
    pub tag: u16,
    pub zone: u16,
    pub _resvA: [u16; 2usize],
    pub _resv: [u64; 3usize],
    pub name: [::libc::c_char; 80usize],
}
#[test]
fn bindgen_test_layout_mach_memory_info() {
    const UNINIT: ::core::mem::MaybeUninit<mach_memory_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_memory_info>(),
        176usize,
        concat!("Size of: ", stringify!(mach_memory_info))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_memory_info>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_memory_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).site) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(site)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).free) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).largest) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(largest)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).collectable_bytes) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(collectable_bytes)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mapped) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(mapped)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).peak) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(peak)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).tag) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).zone) as usize - ptr as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(zone)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr)._resvA) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(_resvA)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr)._resv) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(_resv)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_memory_info),
            "::",
            stringify!(name)
        )
    );
}
pub type mach_memory_info_t = mach_memory_info;
pub type mach_memory_info_array_t = *mut mach_memory_info_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct zone_btrecord {
    pub ref_count: u32,
    pub operation_type: u32,
    pub bt: [u64; 15usize],
}
#[test]
fn bindgen_test_layout_zone_btrecord() {
    const UNINIT: ::core::mem::MaybeUninit<zone_btrecord> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<zone_btrecord>(),
        128usize,
        concat!("Size of: ", stringify!(zone_btrecord))
    );
    assert_eq!(
        ::core::mem::align_of::<zone_btrecord>(),
        8usize,
        concat!("Alignment of ", stringify!(zone_btrecord))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ref_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_btrecord),
            "::",
            stringify!(ref_count)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).operation_type) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_btrecord),
            "::",
            stringify!(operation_type)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).bt) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(zone_btrecord),
            "::",
            stringify!(bt)
        )
    );
}
pub type zone_btrecord_t = zone_btrecord;
pub type zone_btrecord_array_t = *mut zone_btrecord_t;
pub type page_address_array_t = *mut vm_offset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hash_info_bucket {
    pub hib_count: natural_t,
}
#[test]
fn bindgen_test_layout_hash_info_bucket() {
    const UNINIT: ::core::mem::MaybeUninit<hash_info_bucket> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<hash_info_bucket>(),
        4usize,
        concat!("Size of: ", stringify!(hash_info_bucket))
    );
    assert_eq!(
        ::core::mem::align_of::<hash_info_bucket>(),
        4usize,
        concat!("Alignment of ", stringify!(hash_info_bucket))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).hib_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hash_info_bucket),
            "::",
            stringify!(hib_count)
        )
    );
}
pub type hash_info_bucket_t = hash_info_bucket;
pub type hash_info_bucket_array_t = *mut hash_info_bucket_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lockgroup_info {
    pub lockgroup_name: [::libc::c_char; 64usize],
    pub lockgroup_attr: u64,
    pub lock_spin_cnt: u64,
    pub lock_spin_util_cnt: u64,
    pub lock_spin_held_cnt: u64,
    pub lock_spin_miss_cnt: u64,
    pub lock_spin_held_max: u64,
    pub lock_spin_held_cum: u64,
    pub lock_mtx_cnt: u64,
    pub lock_mtx_util_cnt: u64,
    pub lock_mtx_held_cnt: u64,
    pub lock_mtx_miss_cnt: u64,
    pub lock_mtx_wait_cnt: u64,
    pub lock_mtx_held_max: u64,
    pub lock_mtx_held_cum: u64,
    pub lock_mtx_wait_max: u64,
    pub lock_mtx_wait_cum: u64,
    pub lock_rw_cnt: u64,
    pub lock_rw_util_cnt: u64,
    pub lock_rw_held_cnt: u64,
    pub lock_rw_miss_cnt: u64,
    pub lock_rw_wait_cnt: u64,
    pub lock_rw_held_max: u64,
    pub lock_rw_held_cum: u64,
    pub lock_rw_wait_max: u64,
    pub lock_rw_wait_cum: u64,
}
#[test]
fn bindgen_test_layout_lockgroup_info() {
    const UNINIT: ::core::mem::MaybeUninit<lockgroup_info> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<lockgroup_info>(),
        264usize,
        concat!("Size of: ", stringify!(lockgroup_info))
    );
    assert_eq!(
        ::core::mem::align_of::<lockgroup_info>(),
        8usize,
        concat!("Alignment of ", stringify!(lockgroup_info))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lockgroup_name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lockgroup_name)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lockgroup_attr) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lockgroup_attr)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_spin_cnt) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_spin_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_spin_util_cnt) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_spin_util_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_spin_held_cnt) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_spin_held_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_spin_miss_cnt) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_spin_miss_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_spin_held_max) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_spin_held_max)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_spin_held_cum) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_spin_held_cum)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_mtx_cnt) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_mtx_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_mtx_util_cnt) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_mtx_util_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_mtx_held_cnt) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_mtx_held_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_mtx_miss_cnt) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_mtx_miss_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_mtx_wait_cnt) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_mtx_wait_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_mtx_held_max) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_mtx_held_max)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_mtx_held_cum) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_mtx_held_cum)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_mtx_wait_max) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_mtx_wait_max)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_mtx_wait_cum) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_mtx_wait_cum)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_rw_cnt) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_rw_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_rw_util_cnt) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_rw_util_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_rw_held_cnt) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_rw_held_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_rw_miss_cnt) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_rw_miss_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_rw_wait_cnt) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_rw_wait_cnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_rw_held_max) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_rw_held_max)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_rw_held_cum) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_rw_held_cum)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_rw_wait_max) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_rw_wait_max)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_rw_wait_cum) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(lockgroup_info),
            "::",
            stringify!(lock_rw_wait_cum)
        )
    );
}
pub type lockgroup_info_t = lockgroup_info;
pub type lockgroup_info_array_t = *mut lockgroup_info_t;
pub type symtab_name_t = [::libc::c_char; 32usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_core_details {
    pub gzip_offset: u64,
    pub gzip_length: u64,
    pub core_name: [::libc::c_char; 16usize],
}
#[test]
fn bindgen_test_layout_mach_core_details() {
    const UNINIT: ::core::mem::MaybeUninit<mach_core_details> = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_core_details>(),
        32usize,
        concat!("Size of: ", stringify!(mach_core_details))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_core_details>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_core_details))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).gzip_offset) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_details),
            "::",
            stringify!(gzip_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).gzip_length) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_details),
            "::",
            stringify!(gzip_length)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).core_name) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_details),
            "::",
            stringify!(core_name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_core_fileheader {
    pub signature: u64,
    pub log_offset: u64,
    pub log_length: u64,
    pub num_files: u64,
    pub files: [mach_core_details; 16usize],
}
#[test]
fn bindgen_test_layout_mach_core_fileheader() {
    const UNINIT: ::core::mem::MaybeUninit<mach_core_fileheader> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_core_fileheader>(),
        544usize,
        concat!("Size of: ", stringify!(mach_core_fileheader))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_core_fileheader>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_core_fileheader))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).signature) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader),
            "::",
            stringify!(signature)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).log_offset) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader),
            "::",
            stringify!(log_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).log_length) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader),
            "::",
            stringify!(log_length)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_files) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader),
            "::",
            stringify!(num_files)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).files) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader),
            "::",
            stringify!(files)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_core_details_v2 {
    pub flags: u64,
    pub offset: u64,
    pub length: u64,
    pub core_name: [::libc::c_char; 16usize],
}
#[test]
fn bindgen_test_layout_mach_core_details_v2() {
    const UNINIT: ::core::mem::MaybeUninit<mach_core_details_v2> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_core_details_v2>(),
        40usize,
        concat!("Size of: ", stringify!(mach_core_details_v2))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_core_details_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_core_details_v2))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_details_v2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_details_v2),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).length) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_details_v2),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).core_name) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_details_v2),
            "::",
            stringify!(core_name)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mach_core_fileheader_base {
    pub signature: u64,
    pub version: u32,
}
#[test]
fn bindgen_test_layout_mach_core_fileheader_base() {
    const UNINIT: ::core::mem::MaybeUninit<mach_core_fileheader_base> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_core_fileheader_base>(),
        16usize,
        concat!("Size of: ", stringify!(mach_core_fileheader_base))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_core_fileheader_base>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_core_fileheader_base))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).signature) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_base),
            "::",
            stringify!(signature)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_base),
            "::",
            stringify!(version)
        )
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct mach_core_fileheader_v2 {
    pub signature: u64,
    pub version: u32,
    pub flags: u64,
    pub pub_key_offset: u64,
    pub pub_key_length: u16,
    pub log_offset: u64,
    pub log_length: u64,
    pub num_files: u64,
    pub files: __IncompleteArrayField<mach_core_details_v2>,
}
#[test]
fn bindgen_test_layout_mach_core_fileheader_v2() {
    const UNINIT: ::core::mem::MaybeUninit<mach_core_fileheader_v2> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<mach_core_fileheader_v2>(),
        64usize,
        concat!("Size of: ", stringify!(mach_core_fileheader_v2))
    );
    assert_eq!(
        ::core::mem::align_of::<mach_core_fileheader_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(mach_core_fileheader_v2))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).signature) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_v2),
            "::",
            stringify!(signature)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_v2),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_v2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pub_key_offset) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_v2),
            "::",
            stringify!(pub_key_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pub_key_length) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_v2),
            "::",
            stringify!(pub_key_length)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).log_offset) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_v2),
            "::",
            stringify!(log_offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).log_length) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_v2),
            "::",
            stringify!(log_length)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).num_files) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_v2),
            "::",
            stringify!(num_files)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).files) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(mach_core_fileheader_v2),
            "::",
            stringify!(files)
        )
    );
}
pub type kobject_description_t = [::libc::c_char; 512usize];
extern "C" {
    pub fn task_create(
        target_task: task_t,
        ledgers: ledger_array_t,
        ledgersCnt: mach_msg_type_number_t,
        inherit_memory: boolean_t,
        child_task: *mut task_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_terminate(target_task: task_t) -> kern_return_t;
}
extern "C" {
    pub fn task_threads(
        target_task: task_inspect_t,
        act_list: *mut thread_act_array_t,
        act_listCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn mach_ports_register(
        target_task: task_t,
        init_port_set: mach_port_array_t,
        init_port_setCnt: mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn mach_ports_lookup(
        target_task: task_t,
        init_port_set: *mut mach_port_array_t,
        init_port_setCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_info(
        target_task: task_name_t,
        flavor: task_flavor_t,
        task_info_out: task_info_t,
        task_info_outCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_info(
        target_task: task_t,
        flavor: task_flavor_t,
        task_info_in: task_info_t,
        task_info_inCnt: mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_suspend(target_task: task_read_t) -> kern_return_t;
}
extern "C" {
    pub fn task_resume(target_task: task_read_t) -> kern_return_t;
}
extern "C" {
    pub fn task_get_special_port(
        task: task_inspect_t,
        which_port: ::libc::c_int,
        special_port: *mut mach_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_special_port(
        task: task_t,
        which_port: ::libc::c_int,
        special_port: mach_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn thread_create(parent_task: task_t, child_act: *mut thread_act_t) -> kern_return_t;
}
extern "C" {
    pub fn thread_create_running(
        parent_task: task_t,
        flavor: thread_state_flavor_t,
        new_state: thread_state_t,
        new_stateCnt: mach_msg_type_number_t,
        child_act: *mut thread_act_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_exception_ports(
        task: task_t,
        exception_mask: exception_mask_t,
        new_port: mach_port_t,
        behavior: exception_behavior_t,
        new_flavor: thread_state_flavor_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_get_exception_ports(
        task: task_t,
        exception_mask: exception_mask_t,
        masks: exception_mask_array_t,
        masksCnt: *mut mach_msg_type_number_t,
        old_handlers: exception_handler_array_t,
        old_behaviors: exception_behavior_array_t,
        old_flavors: exception_flavor_array_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_swap_exception_ports(
        task: task_t,
        exception_mask: exception_mask_t,
        new_port: mach_port_t,
        behavior: exception_behavior_t,
        new_flavor: thread_state_flavor_t,
        masks: exception_mask_array_t,
        masksCnt: *mut mach_msg_type_number_t,
        old_handlers: exception_handler_array_t,
        old_behaviors: exception_behavior_array_t,
        old_flavors: exception_flavor_array_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn lock_set_create(
        task: task_t,
        new_lock_set: *mut lock_set_t,
        n_ulocks: ::libc::c_int,
        policy: ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn lock_set_destroy(task: task_t, lock_set: lock_set_t) -> kern_return_t;
}
extern "C" {
    pub fn semaphore_create(
        task: task_t,
        semaphore: *mut semaphore_t,
        policy: ::libc::c_int,
        value: ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn semaphore_destroy(task: task_t, semaphore: semaphore_t) -> kern_return_t;
}
extern "C" {
    pub fn task_policy_set(
        task: task_policy_set_t,
        flavor: task_policy_flavor_t,
        policy_info: task_policy_t,
        policy_infoCnt: mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_policy_get(
        task: task_policy_get_t,
        flavor: task_policy_flavor_t,
        policy_info: task_policy_t,
        policy_infoCnt: *mut mach_msg_type_number_t,
        get_default: *mut boolean_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_sample(task: task_t, reply: mach_port_t) -> kern_return_t;
}
extern "C" {
    pub fn task_policy(
        task: task_t,
        policy: policy_t,
        base: policy_base_t,
        baseCnt: mach_msg_type_number_t,
        set_limit: boolean_t,
        change: boolean_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_emulation(
        target_port: task_t,
        routine_entry_pt: vm_address_t,
        routine_number: ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_get_emulation_vector(
        task: task_t,
        vector_start: *mut ::libc::c_int,
        emulation_vector: *mut emulation_vector_t,
        emulation_vectorCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_emulation_vector(
        task: task_t,
        vector_start: ::libc::c_int,
        emulation_vector: emulation_vector_t,
        emulation_vectorCnt: mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_ras_pc(
        target_task: task_t,
        basepc: vm_address_t,
        boundspc: vm_address_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_zone_info(
        target_task: task_inspect_t,
        names: *mut mach_zone_name_array_t,
        namesCnt: *mut mach_msg_type_number_t,
        info: *mut task_zone_info_array_t,
        infoCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_assign(
        task: task_t,
        new_set: processor_set_t,
        assign_threads: boolean_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_assign_default(task: task_t, assign_threads: boolean_t) -> kern_return_t;
}
extern "C" {
    pub fn task_get_assignment(
        task: task_inspect_t,
        assigned_set: *mut processor_set_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_policy(
        task: task_t,
        pset: processor_set_t,
        policy: policy_t,
        base: policy_base_t,
        baseCnt: mach_msg_type_number_t,
        limit: policy_limit_t,
        limitCnt: mach_msg_type_number_t,
        change: boolean_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_get_state(
        task: task_read_t,
        flavor: thread_state_flavor_t,
        old_state: thread_state_t,
        old_stateCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_state(
        task: task_t,
        flavor: thread_state_flavor_t,
        new_state: thread_state_t,
        new_stateCnt: mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_phys_footprint_limit(
        task: task_t,
        new_limit: ::libc::c_int,
        old_limit: *mut ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_suspend2(
        target_task: task_read_t,
        suspend_token: *mut task_suspension_token_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_resume2(suspend_token: task_suspension_token_t) -> kern_return_t;
}
extern "C" {
    pub fn task_purgable_info(
        task: task_inspect_t,
        stats: *mut task_purgable_info_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_get_mach_voucher(
        task: task_read_t,
        which: mach_voucher_selector_t,
        voucher: *mut ipc_voucher_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_mach_voucher(task: task_t, voucher: ipc_voucher_t) -> kern_return_t;
}
extern "C" {
    pub fn task_swap_mach_voucher(
        task: task_t,
        new_voucher: ipc_voucher_t,
        old_voucher: *mut ipc_voucher_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_generate_corpse(
        task: task_read_t,
        corpse_task_port: *mut mach_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_map_corpse_info(
        task: task_t,
        corspe_task: task_read_t,
        kcd_addr_begin: *mut vm_address_t,
        kcd_size: *mut u32,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_register_dyld_image_infos(
        task: task_t,
        dyld_images: dyld_kernel_image_info_array_t,
        dyld_imagesCnt: mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_unregister_dyld_image_infos(
        task: task_t,
        dyld_images: dyld_kernel_image_info_array_t,
        dyld_imagesCnt: mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_get_dyld_image_infos(
        task: task_read_t,
        dyld_images: *mut dyld_kernel_image_info_array_t,
        dyld_imagesCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_register_dyld_shared_cache_image_info(
        task: task_t,
        dyld_cache_image: dyld_kernel_image_info_t,
        no_cache: boolean_t,
        private_cache: boolean_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_register_dyld_set_dyld_state(task: task_t, dyld_state: u8) -> kern_return_t;
}
extern "C" {
    pub fn task_register_dyld_get_process_state(
        task: task_t,
        dyld_process_state: *mut dyld_kernel_process_info_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_map_corpse_info_64(
        task: task_t,
        corspe_task: task_read_t,
        kcd_addr_begin: *mut mach_vm_address_t,
        kcd_size: *mut mach_vm_size_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_inspect(
        task: task_inspect_t,
        flavor: task_inspect_flavor_t,
        info_out: task_inspect_info_t,
        info_outCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_get_exc_guard_behavior(
        task: task_inspect_t,
        behavior: *mut task_exc_guard_behavior_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_set_exc_guard_behavior(
        task: task_t,
        behavior: task_exc_guard_behavior_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_dyld_process_info_notify_register(
        target_task: task_read_t,
        notify: mach_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_create_identity_token(task: task_t, token: *mut task_id_token_t) -> kern_return_t;
}
extern "C" {
    pub fn task_identity_token_get_task_port(
        token: task_id_token_t,
        flavor: task_flavor_t,
        task_port: *mut mach_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_dyld_process_info_notify_deregister(
        target_task: task_read_t,
        notify: mach_port_name_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_get_exception_ports_info(
        port: mach_port_t,
        exception_mask: exception_mask_t,
        masks: exception_mask_array_t,
        masksCnt: *mut mach_msg_type_number_t,
        old_handlers_info: exception_handler_info_array_t,
        old_behaviors: exception_behavior_array_t,
        old_flavors: exception_flavor_array_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_test_sync_upcall(task: task_t, port: mach_port_t) -> kern_return_t;
}
extern "C" {
    pub fn task_set_corpse_forking_behavior(
        task: task_t,
        behavior: task_corpse_forking_behavior_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_test_async_upcall_propagation(
        task: task_t,
        port: mach_port_t,
        qos: ::libc::c_int,
        iotier: ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_map_kcdata_object_64(
        task: task_t,
        kcdata_object: kcdata_object_t,
        kcd_addr_begin: *mut mach_vm_address_t,
        kcd_size: *mut mach_vm_size_t,
    ) -> kern_return_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_create_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub ledgers: mach_msg_ool_ports_descriptor_t,
    pub NDR: NDR_record_t,
    pub ledgersCnt: mach_msg_type_number_t,
    pub inherit_memory: boolean_t,
}
#[test]
fn bindgen_test_layout___Request__task_create_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_create_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_create_t>(),
        60usize,
        concat!("Size of: ", stringify!(__Request__task_create_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_create_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_create_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_create_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_create_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ledgers) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_create_t),
            "::",
            stringify!(ledgers)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_create_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).ledgersCnt) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_create_t),
            "::",
            stringify!(ledgersCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inherit_memory) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_create_t),
            "::",
            stringify!(inherit_memory)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_terminate_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_terminate_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_terminate_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_terminate_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_terminate_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_terminate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_terminate_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_terminate_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_threads_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_threads_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_threads_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_threads_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_threads_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_threads_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_threads_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_threads_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__mach_ports_register_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub init_port_set: mach_msg_ool_ports_descriptor_t,
    pub NDR: NDR_record_t,
    pub init_port_setCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__mach_ports_register_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__mach_ports_register_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__mach_ports_register_t>(),
        56usize,
        concat!("Size of: ", stringify!(__Request__mach_ports_register_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__mach_ports_register_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__mach_ports_register_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_ports_register_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_ports_register_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).init_port_set) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_ports_register_t),
            "::",
            stringify!(init_port_set)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_ports_register_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).init_port_setCnt) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_ports_register_t),
            "::",
            stringify!(init_port_setCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__mach_ports_lookup_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__mach_ports_lookup_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__mach_ports_lookup_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__mach_ports_lookup_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__mach_ports_lookup_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__mach_ports_lookup_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__mach_ports_lookup_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_ports_lookup_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub flavor: task_flavor_t,
    pub task_info_outCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__task_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_info_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__task_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_info_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_info_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_info_outCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_info_t),
            "::",
            stringify!(task_info_outCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub flavor: task_flavor_t,
    pub task_info_inCnt: mach_msg_type_number_t,
    pub task_info_in: [integer_t; 90usize],
}
#[test]
fn bindgen_test_layout___Request__task_set_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_info_t>(),
        400usize,
        concat!("Size of: ", stringify!(__Request__task_set_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_set_info_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_info_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_info_inCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_info_t),
            "::",
            stringify!(task_info_inCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_info_in) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_info_t),
            "::",
            stringify!(task_info_in)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_suspend_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_suspend_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_suspend_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_suspend_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_suspend_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_suspend_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_suspend_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_suspend_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_resume_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_resume_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_resume_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_resume_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_resume_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_resume_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_resume_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_resume_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_get_special_port_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub which_port: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Request__task_get_special_port_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_get_special_port_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_get_special_port_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Request__task_get_special_port_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_get_special_port_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_get_special_port_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_special_port_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_special_port_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).which_port) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_special_port_t),
            "::",
            stringify!(which_port)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_special_port_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub special_port: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub which_port: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Request__task_set_special_port_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_special_port_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_special_port_t>(),
        52usize,
        concat!("Size of: ", stringify!(__Request__task_set_special_port_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_special_port_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_set_special_port_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_special_port_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_special_port_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).special_port) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_special_port_t),
            "::",
            stringify!(special_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_special_port_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).which_port) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_special_port_t),
            "::",
            stringify!(which_port)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__thread_create_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__thread_create_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__thread_create_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__thread_create_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__thread_create_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__thread_create_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__thread_create_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__thread_create_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__thread_create_running_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub flavor: thread_state_flavor_t,
    pub new_stateCnt: mach_msg_type_number_t,
    pub new_state: [natural_t; 1296usize],
}
#[test]
fn bindgen_test_layout___Request__thread_create_running_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__thread_create_running_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__thread_create_running_t>(),
        5224usize,
        concat!("Size of: ", stringify!(__Request__thread_create_running_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__thread_create_running_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__thread_create_running_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__thread_create_running_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__thread_create_running_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__thread_create_running_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_stateCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__thread_create_running_t),
            "::",
            stringify!(new_stateCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_state) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__thread_create_running_t),
            "::",
            stringify!(new_state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_exception_ports_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub new_port: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub exception_mask: exception_mask_t,
    pub behavior: exception_behavior_t,
    pub new_flavor: thread_state_flavor_t,
}
#[test]
fn bindgen_test_layout___Request__task_set_exception_ports_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_exception_ports_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_exception_ports_t>(),
        60usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_set_exception_ports_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_exception_ports_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_set_exception_ports_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exception_ports_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exception_ports_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_port) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exception_ports_t),
            "::",
            stringify!(new_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exception_ports_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).exception_mask) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exception_ports_t),
            "::",
            stringify!(exception_mask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exception_ports_t),
            "::",
            stringify!(behavior)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_flavor) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exception_ports_t),
            "::",
            stringify!(new_flavor)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_get_exception_ports_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub exception_mask: exception_mask_t,
}
#[test]
fn bindgen_test_layout___Request__task_get_exception_ports_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_get_exception_ports_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_get_exception_ports_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_get_exception_ports_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_get_exception_ports_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_get_exception_ports_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_exception_ports_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_exception_ports_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).exception_mask) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_exception_ports_t),
            "::",
            stringify!(exception_mask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_swap_exception_ports_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub new_port: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub exception_mask: exception_mask_t,
    pub behavior: exception_behavior_t,
    pub new_flavor: thread_state_flavor_t,
}
#[test]
fn bindgen_test_layout___Request__task_swap_exception_ports_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_swap_exception_ports_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_swap_exception_ports_t>(),
        60usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_swap_exception_ports_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_swap_exception_ports_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_swap_exception_ports_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_exception_ports_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_exception_ports_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_port) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_exception_ports_t),
            "::",
            stringify!(new_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_exception_ports_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).exception_mask) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_exception_ports_t),
            "::",
            stringify!(exception_mask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_exception_ports_t),
            "::",
            stringify!(behavior)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_flavor) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_exception_ports_t),
            "::",
            stringify!(new_flavor)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__lock_set_create_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub n_ulocks: ::libc::c_int,
    pub policy: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Request__lock_set_create_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__lock_set_create_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__lock_set_create_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__lock_set_create_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__lock_set_create_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__lock_set_create_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__lock_set_create_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__lock_set_create_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).n_ulocks) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__lock_set_create_t),
            "::",
            stringify!(n_ulocks)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__lock_set_create_t),
            "::",
            stringify!(policy)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__lock_set_destroy_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub lock_set: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__lock_set_destroy_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__lock_set_destroy_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__lock_set_destroy_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__lock_set_destroy_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__lock_set_destroy_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__lock_set_destroy_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__lock_set_destroy_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__lock_set_destroy_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).lock_set) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__lock_set_destroy_t),
            "::",
            stringify!(lock_set)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__semaphore_create_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub policy: ::libc::c_int,
    pub value: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Request__semaphore_create_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__semaphore_create_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__semaphore_create_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__semaphore_create_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__semaphore_create_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__semaphore_create_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__semaphore_create_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__semaphore_create_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__semaphore_create_t),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).value) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__semaphore_create_t),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__semaphore_destroy_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub semaphore: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__semaphore_destroy_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__semaphore_destroy_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__semaphore_destroy_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__semaphore_destroy_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__semaphore_destroy_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__semaphore_destroy_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__semaphore_destroy_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__semaphore_destroy_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).semaphore) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__semaphore_destroy_t),
            "::",
            stringify!(semaphore)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_policy_set_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub flavor: task_policy_flavor_t,
    pub policy_infoCnt: mach_msg_type_number_t,
    pub policy_info: [integer_t; 16usize],
}
#[test]
fn bindgen_test_layout___Request__task_policy_set_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_policy_set_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_policy_set_t>(),
        104usize,
        concat!("Size of: ", stringify!(__Request__task_policy_set_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_policy_set_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_policy_set_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_set_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_set_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_set_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy_infoCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_set_t),
            "::",
            stringify!(policy_infoCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy_info) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_set_t),
            "::",
            stringify!(policy_info)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_policy_get_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub flavor: task_policy_flavor_t,
    pub policy_infoCnt: mach_msg_type_number_t,
    pub get_default: boolean_t,
}
#[test]
fn bindgen_test_layout___Request__task_policy_get_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_policy_get_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_policy_get_t>(),
        44usize,
        concat!("Size of: ", stringify!(__Request__task_policy_get_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_policy_get_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_policy_get_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_get_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_get_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_get_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy_infoCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_get_t),
            "::",
            stringify!(policy_infoCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).get_default) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_get_t),
            "::",
            stringify!(get_default)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_sample_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub reply: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__task_sample_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_sample_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_sample_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__task_sample_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_sample_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_sample_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_sample_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_sample_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).reply) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_sample_t),
            "::",
            stringify!(reply)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_policy_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub policy: policy_t,
    pub baseCnt: mach_msg_type_number_t,
    pub base: [integer_t; 5usize],
    pub set_limit: boolean_t,
    pub change: boolean_t,
}
#[test]
fn bindgen_test_layout___Request__task_policy_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_policy_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_policy_t>(),
        68usize,
        concat!("Size of: ", stringify!(__Request__task_policy_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_policy_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_policy_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_t),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).baseCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_t),
            "::",
            stringify!(baseCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_t),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).set_limit) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_t),
            "::",
            stringify!(set_limit)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).change) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_policy_t),
            "::",
            stringify!(change)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_emulation_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub routine_entry_pt: vm_address_t,
    pub routine_number: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Request__task_set_emulation_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_emulation_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_emulation_t>(),
        44usize,
        concat!("Size of: ", stringify!(__Request__task_set_emulation_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_emulation_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_set_emulation_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).routine_entry_pt) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_t),
            "::",
            stringify!(routine_entry_pt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).routine_number) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_t),
            "::",
            stringify!(routine_number)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_get_emulation_vector_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_get_emulation_vector_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_get_emulation_vector_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_get_emulation_vector_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_get_emulation_vector_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_get_emulation_vector_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_get_emulation_vector_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_emulation_vector_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_emulation_vector_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub emulation_vector: mach_msg_ool_descriptor_t,
    pub NDR: NDR_record_t,
    pub vector_start: ::libc::c_int,
    pub emulation_vectorCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__task_set_emulation_vector_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_emulation_vector_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_emulation_vector_t>(),
        60usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_set_emulation_vector_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_emulation_vector_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_set_emulation_vector_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_vector_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_vector_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).emulation_vector) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_vector_t),
            "::",
            stringify!(emulation_vector)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_vector_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vector_start) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_vector_t),
            "::",
            stringify!(vector_start)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).emulation_vectorCnt) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_emulation_vector_t),
            "::",
            stringify!(emulation_vectorCnt)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_ras_pc_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub basepc: vm_address_t,
    pub boundspc: vm_address_t,
}
#[test]
fn bindgen_test_layout___Request__task_set_ras_pc_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_ras_pc_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_ras_pc_t>(),
        48usize,
        concat!("Size of: ", stringify!(__Request__task_set_ras_pc_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_ras_pc_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_set_ras_pc_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_ras_pc_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_ras_pc_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).basepc) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_ras_pc_t),
            "::",
            stringify!(basepc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).boundspc) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_ras_pc_t),
            "::",
            stringify!(boundspc)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_zone_info_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_zone_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_zone_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_zone_info_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_zone_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_zone_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_zone_info_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_zone_info_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_assign_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub new_set: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub assign_threads: boolean_t,
}
#[test]
fn bindgen_test_layout___Request__task_assign_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_assign_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_assign_t>(),
        52usize,
        concat!("Size of: ", stringify!(__Request__task_assign_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_assign_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_assign_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_assign_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_assign_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_set) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_assign_t),
            "::",
            stringify!(new_set)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_assign_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).assign_threads) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_assign_t),
            "::",
            stringify!(assign_threads)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_assign_default_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub assign_threads: boolean_t,
}
#[test]
fn bindgen_test_layout___Request__task_assign_default_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_assign_default_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_assign_default_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Request__task_assign_default_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_assign_default_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_assign_default_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_assign_default_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_assign_default_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).assign_threads) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_assign_default_t),
            "::",
            stringify!(assign_threads)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_get_assignment_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_get_assignment_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_get_assignment_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_get_assignment_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_get_assignment_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_get_assignment_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_get_assignment_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_assignment_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_policy_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub pset: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub policy: policy_t,
    pub baseCnt: mach_msg_type_number_t,
    pub base: [integer_t; 5usize],
    pub limitCnt: mach_msg_type_number_t,
    pub limit: [integer_t; 1usize],
    pub change: boolean_t,
}
#[test]
fn bindgen_test_layout___Request__task_set_policy_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_policy_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_policy_t>(),
        88usize,
        concat!("Size of: ", stringify!(__Request__task_set_policy_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_policy_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_set_policy_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).pset) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(pset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).baseCnt) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(baseCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(base)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).limitCnt) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(limitCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).limit) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(limit)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).change) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_policy_t),
            "::",
            stringify!(change)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_get_state_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub flavor: thread_state_flavor_t,
    pub old_stateCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__task_get_state_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_get_state_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_get_state_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__task_get_state_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_get_state_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_get_state_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_state_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_state_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_state_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_stateCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_state_t),
            "::",
            stringify!(old_stateCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_state_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub flavor: thread_state_flavor_t,
    pub new_stateCnt: mach_msg_type_number_t,
    pub new_state: [natural_t; 1296usize],
}
#[test]
fn bindgen_test_layout___Request__task_set_state_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_state_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_state_t>(),
        5224usize,
        concat!("Size of: ", stringify!(__Request__task_set_state_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_state_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_set_state_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_state_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_state_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_state_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_stateCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_state_t),
            "::",
            stringify!(new_stateCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_state) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_state_t),
            "::",
            stringify!(new_state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_phys_footprint_limit_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub new_limit: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Request__task_set_phys_footprint_limit_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_phys_footprint_limit_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_phys_footprint_limit_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_set_phys_footprint_limit_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_phys_footprint_limit_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_set_phys_footprint_limit_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_phys_footprint_limit_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_phys_footprint_limit_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_limit) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_phys_footprint_limit_t),
            "::",
            stringify!(new_limit)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_suspend2_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_suspend2_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_suspend2_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_suspend2_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_suspend2_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_suspend2_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_suspend2_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_suspend2_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_resume2_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_resume2_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_resume2_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_resume2_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_resume2_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_resume2_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_resume2_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_resume2_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_purgable_info_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_purgable_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_purgable_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_purgable_info_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_purgable_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_purgable_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_purgable_info_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_purgable_info_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_get_mach_voucher_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub which: mach_voucher_selector_t,
}
#[test]
fn bindgen_test_layout___Request__task_get_mach_voucher_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_get_mach_voucher_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_get_mach_voucher_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Request__task_get_mach_voucher_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_get_mach_voucher_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_get_mach_voucher_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_mach_voucher_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_mach_voucher_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).which) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_mach_voucher_t),
            "::",
            stringify!(which)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_mach_voucher_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub voucher: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__task_set_mach_voucher_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_mach_voucher_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_mach_voucher_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__task_set_mach_voucher_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_mach_voucher_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_set_mach_voucher_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_mach_voucher_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_mach_voucher_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).voucher) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_mach_voucher_t),
            "::",
            stringify!(voucher)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_swap_mach_voucher_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub new_voucher: mach_msg_port_descriptor_t,
    pub old_voucher: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__task_swap_mach_voucher_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_swap_mach_voucher_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_swap_mach_voucher_t>(),
        52usize,
        concat!("Size of: ", stringify!(__Request__task_swap_mach_voucher_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_swap_mach_voucher_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_swap_mach_voucher_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_mach_voucher_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_mach_voucher_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_voucher) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_mach_voucher_t),
            "::",
            stringify!(new_voucher)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_voucher) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_swap_mach_voucher_t),
            "::",
            stringify!(old_voucher)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_generate_corpse_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_generate_corpse_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_generate_corpse_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_generate_corpse_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__task_generate_corpse_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_generate_corpse_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_generate_corpse_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_generate_corpse_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_map_corpse_info_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub corspe_task: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__task_map_corpse_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_map_corpse_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_map_corpse_info_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__task_map_corpse_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_map_corpse_info_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_map_corpse_info_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_map_corpse_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_map_corpse_info_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).corspe_task) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_map_corpse_info_t),
            "::",
            stringify!(corspe_task)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_register_dyld_image_infos_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub dyld_images: mach_msg_ool_descriptor_t,
    pub NDR: NDR_record_t,
    pub dyld_imagesCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__task_register_dyld_image_infos_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_register_dyld_image_infos_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_register_dyld_image_infos_t>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_register_dyld_image_infos_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_register_dyld_image_infos_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_register_dyld_image_infos_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_image_infos_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_image_infos_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_images) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_image_infos_t),
            "::",
            stringify!(dyld_images)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_image_infos_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_imagesCnt) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_image_infos_t),
            "::",
            stringify!(dyld_imagesCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_unregister_dyld_image_infos_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub dyld_images: mach_msg_ool_descriptor_t,
    pub NDR: NDR_record_t,
    pub dyld_imagesCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__task_unregister_dyld_image_infos_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_unregister_dyld_image_infos_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_unregister_dyld_image_infos_t>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_unregister_dyld_image_infos_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_unregister_dyld_image_infos_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_unregister_dyld_image_infos_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_unregister_dyld_image_infos_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_unregister_dyld_image_infos_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_images) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_unregister_dyld_image_infos_t),
            "::",
            stringify!(dyld_images)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_unregister_dyld_image_infos_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_imagesCnt) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_unregister_dyld_image_infos_t),
            "::",
            stringify!(dyld_imagesCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_get_dyld_image_infos_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_get_dyld_image_infos_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_get_dyld_image_infos_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_get_dyld_image_infos_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_get_dyld_image_infos_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_get_dyld_image_infos_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_get_dyld_image_infos_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_dyld_image_infos_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_register_dyld_shared_cache_image_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub dyld_cache_image: dyld_kernel_image_info_t,
    pub no_cache: boolean_t,
    pub private_cache: boolean_t,
}
#[test]
fn bindgen_test_layout___Request__task_register_dyld_shared_cache_image_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<
        __Request__task_register_dyld_shared_cache_image_info_t,
    > = ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_register_dyld_shared_cache_image_info_t>(),
        80usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_register_dyld_shared_cache_image_info_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_register_dyld_shared_cache_image_info_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_register_dyld_shared_cache_image_info_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_shared_cache_image_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_shared_cache_image_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_cache_image) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_shared_cache_image_info_t),
            "::",
            stringify!(dyld_cache_image)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).no_cache) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_shared_cache_image_info_t),
            "::",
            stringify!(no_cache)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).private_cache) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_shared_cache_image_info_t),
            "::",
            stringify!(private_cache)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_register_dyld_set_dyld_state_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub dyld_state: u8,
    pub dyld_statePad: [::libc::c_char; 3usize],
}
#[test]
fn bindgen_test_layout___Request__task_register_dyld_set_dyld_state_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_register_dyld_set_dyld_state_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_register_dyld_set_dyld_state_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_register_dyld_set_dyld_state_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_register_dyld_set_dyld_state_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_register_dyld_set_dyld_state_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_set_dyld_state_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_set_dyld_state_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_state) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_set_dyld_state_t),
            "::",
            stringify!(dyld_state)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_statePad) as usize - ptr as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_set_dyld_state_t),
            "::",
            stringify!(dyld_statePad)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_register_dyld_get_process_state_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_register_dyld_get_process_state_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_register_dyld_get_process_state_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_register_dyld_get_process_state_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_register_dyld_get_process_state_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_register_dyld_get_process_state_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_register_dyld_get_process_state_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_register_dyld_get_process_state_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_map_corpse_info_64_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub corspe_task: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__task_map_corpse_info_64_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_map_corpse_info_64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_map_corpse_info_64_t>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_map_corpse_info_64_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_map_corpse_info_64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_map_corpse_info_64_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_map_corpse_info_64_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_map_corpse_info_64_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).corspe_task) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_map_corpse_info_64_t),
            "::",
            stringify!(corspe_task)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_inspect_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub flavor: task_inspect_flavor_t,
    pub info_outCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__task_inspect_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_inspect_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_inspect_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__task_inspect_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_inspect_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_inspect_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_inspect_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_inspect_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_inspect_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).info_outCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_inspect_t),
            "::",
            stringify!(info_outCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_get_exc_guard_behavior_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_get_exc_guard_behavior_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_get_exc_guard_behavior_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_get_exc_guard_behavior_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_get_exc_guard_behavior_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_get_exc_guard_behavior_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_get_exc_guard_behavior_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_exc_guard_behavior_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_exc_guard_behavior_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub behavior: task_exc_guard_behavior_t,
}
#[test]
fn bindgen_test_layout___Request__task_set_exc_guard_behavior_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_exc_guard_behavior_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_exc_guard_behavior_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_set_exc_guard_behavior_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_exc_guard_behavior_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_set_exc_guard_behavior_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exc_guard_behavior_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exc_guard_behavior_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_exc_guard_behavior_t),
            "::",
            stringify!(behavior)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_dyld_process_info_notify_register_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub notify: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__task_dyld_process_info_notify_register_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_dyld_process_info_notify_register_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_dyld_process_info_notify_register_t>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_dyld_process_info_notify_register_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_dyld_process_info_notify_register_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_dyld_process_info_notify_register_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_dyld_process_info_notify_register_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_dyld_process_info_notify_register_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).notify) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_dyld_process_info_notify_register_t),
            "::",
            stringify!(notify)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_create_identity_token_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__task_create_identity_token_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_create_identity_token_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_create_identity_token_t>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_create_identity_token_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_create_identity_token_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_create_identity_token_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_create_identity_token_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_identity_token_get_task_port_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub flavor: task_flavor_t,
}
#[test]
fn bindgen_test_layout___Request__task_identity_token_get_task_port_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_identity_token_get_task_port_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_identity_token_get_task_port_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_identity_token_get_task_port_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_identity_token_get_task_port_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_identity_token_get_task_port_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_identity_token_get_task_port_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_identity_token_get_task_port_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_identity_token_get_task_port_t),
            "::",
            stringify!(flavor)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_dyld_process_info_notify_deregister_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub notify: mach_port_name_t,
}
#[test]
fn bindgen_test_layout___Request__task_dyld_process_info_notify_deregister_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_dyld_process_info_notify_deregister_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_dyld_process_info_notify_deregister_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_dyld_process_info_notify_deregister_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_dyld_process_info_notify_deregister_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_dyld_process_info_notify_deregister_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_dyld_process_info_notify_deregister_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_dyld_process_info_notify_deregister_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).notify) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_dyld_process_info_notify_deregister_t),
            "::",
            stringify!(notify)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_get_exception_ports_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub exception_mask: exception_mask_t,
}
#[test]
fn bindgen_test_layout___Request__task_get_exception_ports_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_get_exception_ports_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_get_exception_ports_info_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_get_exception_ports_info_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_get_exception_ports_info_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_get_exception_ports_info_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_exception_ports_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_exception_ports_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).exception_mask) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_get_exception_ports_info_t),
            "::",
            stringify!(exception_mask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_test_sync_upcall_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub port: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__task_test_sync_upcall_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_test_sync_upcall_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_test_sync_upcall_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__task_test_sync_upcall_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_test_sync_upcall_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_test_sync_upcall_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_test_sync_upcall_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_test_sync_upcall_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_test_sync_upcall_t),
            "::",
            stringify!(port)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_set_corpse_forking_behavior_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub behavior: task_corpse_forking_behavior_t,
}
#[test]
fn bindgen_test_layout___Request__task_set_corpse_forking_behavior_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_set_corpse_forking_behavior_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_set_corpse_forking_behavior_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_set_corpse_forking_behavior_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_set_corpse_forking_behavior_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_set_corpse_forking_behavior_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_corpse_forking_behavior_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_corpse_forking_behavior_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_set_corpse_forking_behavior_t),
            "::",
            stringify!(behavior)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_test_async_upcall_propagation_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub port: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub qos: ::libc::c_int,
    pub iotier: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Request__task_test_async_upcall_propagation_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_test_async_upcall_propagation_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_test_async_upcall_propagation_t>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_test_async_upcall_propagation_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_test_async_upcall_propagation_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_test_async_upcall_propagation_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_test_async_upcall_propagation_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_test_async_upcall_propagation_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_test_async_upcall_propagation_t),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_test_async_upcall_propagation_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).qos) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_test_async_upcall_propagation_t),
            "::",
            stringify!(qos)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).iotier) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_test_async_upcall_propagation_t),
            "::",
            stringify!(iotier)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_map_kcdata_object_64_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub kcdata_object: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Request__task_map_kcdata_object_64_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_map_kcdata_object_64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_map_kcdata_object_64_t>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(__Request__task_map_kcdata_object_64_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_map_kcdata_object_64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__task_map_kcdata_object_64_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_map_kcdata_object_64_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_map_kcdata_object_64_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kcdata_object) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_map_kcdata_object_64_t),
            "::",
            stringify!(kcdata_object)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __RequestUnion__task_subsystem {
    pub Request_task_create: __Request__task_create_t,
    pub Request_task_terminate: __Request__task_terminate_t,
    pub Request_task_threads: __Request__task_threads_t,
    pub Request_mach_ports_register: __Request__mach_ports_register_t,
    pub Request_mach_ports_lookup: __Request__mach_ports_lookup_t,
    pub Request_task_info: __Request__task_info_t,
    pub Request_task_set_info: __Request__task_set_info_t,
    pub Request_task_suspend: __Request__task_suspend_t,
    pub Request_task_resume: __Request__task_resume_t,
    pub Request_task_get_special_port: __Request__task_get_special_port_t,
    pub Request_task_set_special_port: __Request__task_set_special_port_t,
    pub Request_thread_create: __Request__thread_create_t,
    pub Request_thread_create_running: __Request__thread_create_running_t,
    pub Request_task_set_exception_ports: __Request__task_set_exception_ports_t,
    pub Request_task_get_exception_ports: __Request__task_get_exception_ports_t,
    pub Request_task_swap_exception_ports: __Request__task_swap_exception_ports_t,
    pub Request_lock_set_create: __Request__lock_set_create_t,
    pub Request_lock_set_destroy: __Request__lock_set_destroy_t,
    pub Request_semaphore_create: __Request__semaphore_create_t,
    pub Request_semaphore_destroy: __Request__semaphore_destroy_t,
    pub Request_task_policy_set: __Request__task_policy_set_t,
    pub Request_task_policy_get: __Request__task_policy_get_t,
    pub Request_task_sample: __Request__task_sample_t,
    pub Request_task_policy: __Request__task_policy_t,
    pub Request_task_set_emulation: __Request__task_set_emulation_t,
    pub Request_task_get_emulation_vector: __Request__task_get_emulation_vector_t,
    pub Request_task_set_emulation_vector: __Request__task_set_emulation_vector_t,
    pub Request_task_set_ras_pc: __Request__task_set_ras_pc_t,
    pub Request_task_zone_info: __Request__task_zone_info_t,
    pub Request_task_assign: __Request__task_assign_t,
    pub Request_task_assign_default: __Request__task_assign_default_t,
    pub Request_task_get_assignment: __Request__task_get_assignment_t,
    pub Request_task_set_policy: __Request__task_set_policy_t,
    pub Request_task_get_state: __Request__task_get_state_t,
    pub Request_task_set_state: __Request__task_set_state_t,
    pub Request_task_set_phys_footprint_limit: __Request__task_set_phys_footprint_limit_t,
    pub Request_task_suspend2: __Request__task_suspend2_t,
    pub Request_task_resume2: __Request__task_resume2_t,
    pub Request_task_purgable_info: __Request__task_purgable_info_t,
    pub Request_task_get_mach_voucher: __Request__task_get_mach_voucher_t,
    pub Request_task_set_mach_voucher: __Request__task_set_mach_voucher_t,
    pub Request_task_swap_mach_voucher: __Request__task_swap_mach_voucher_t,
    pub Request_task_generate_corpse: __Request__task_generate_corpse_t,
    pub Request_task_map_corpse_info: __Request__task_map_corpse_info_t,
    pub Request_task_register_dyld_image_infos: __Request__task_register_dyld_image_infos_t,
    pub Request_task_unregister_dyld_image_infos: __Request__task_unregister_dyld_image_infos_t,
    pub Request_task_get_dyld_image_infos: __Request__task_get_dyld_image_infos_t,
    pub Request_task_register_dyld_shared_cache_image_info:
        __Request__task_register_dyld_shared_cache_image_info_t,
    pub Request_task_register_dyld_set_dyld_state: __Request__task_register_dyld_set_dyld_state_t,
    pub Request_task_register_dyld_get_process_state:
        __Request__task_register_dyld_get_process_state_t,
    pub Request_task_map_corpse_info_64: __Request__task_map_corpse_info_64_t,
    pub Request_task_inspect: __Request__task_inspect_t,
    pub Request_task_get_exc_guard_behavior: __Request__task_get_exc_guard_behavior_t,
    pub Request_task_set_exc_guard_behavior: __Request__task_set_exc_guard_behavior_t,
    pub Request_task_dyld_process_info_notify_register:
        __Request__task_dyld_process_info_notify_register_t,
    pub Request_task_create_identity_token: __Request__task_create_identity_token_t,
    pub Request_task_identity_token_get_task_port: __Request__task_identity_token_get_task_port_t,
    pub Request_task_dyld_process_info_notify_deregister:
        __Request__task_dyld_process_info_notify_deregister_t,
    pub Request_task_get_exception_ports_info: __Request__task_get_exception_ports_info_t,
    pub Request_task_test_sync_upcall: __Request__task_test_sync_upcall_t,
    pub Request_task_set_corpse_forking_behavior: __Request__task_set_corpse_forking_behavior_t,
    pub Request_task_test_async_upcall_propagation: __Request__task_test_async_upcall_propagation_t,
    pub Request_task_map_kcdata_object_64: __Request__task_map_kcdata_object_64_t,
}
#[test]
fn bindgen_test_layout___RequestUnion__task_subsystem() {
    const UNINIT: ::core::mem::MaybeUninit<__RequestUnion__task_subsystem> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__RequestUnion__task_subsystem>(),
        5224usize,
        concat!("Size of: ", stringify!(__RequestUnion__task_subsystem))
    );
    assert_eq!(
        ::core::mem::align_of::<__RequestUnion__task_subsystem>(),
        4usize,
        concat!("Alignment of ", stringify!(__RequestUnion__task_subsystem))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_create) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_create)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_terminate) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_terminate)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_threads) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_threads)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_mach_ports_register) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_mach_ports_register)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_mach_ports_lookup) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_mach_ports_lookup)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_set_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_suspend) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_suspend)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_resume) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_resume)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_get_special_port) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_get_special_port)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_set_special_port) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_special_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_thread_create) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_thread_create)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_thread_create_running) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_thread_create_running)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_set_exception_ports) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_exception_ports)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_get_exception_ports) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_get_exception_ports)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_swap_exception_ports) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_swap_exception_ports)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_lock_set_create) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_lock_set_create)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_lock_set_destroy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_lock_set_destroy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_semaphore_create) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_semaphore_create)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_semaphore_destroy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_semaphore_destroy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_policy_set) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_policy_set)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_policy_get) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_policy_get)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_sample) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_sample)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_policy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_set_emulation) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_emulation)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_get_emulation_vector) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_get_emulation_vector)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_set_emulation_vector) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_emulation_vector)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_set_ras_pc) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_ras_pc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_zone_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_zone_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_assign) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_assign)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_assign_default) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_assign_default)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_get_assignment) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_get_assignment)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_set_policy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_get_state) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_get_state)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_set_state) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_state)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_set_phys_footprint_limit) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_phys_footprint_limit)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_suspend2) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_suspend2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_resume2) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_resume2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_purgable_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_purgable_info)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_get_mach_voucher) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_get_mach_voucher)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_set_mach_voucher) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_mach_voucher)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_swap_mach_voucher) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_swap_mach_voucher)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_generate_corpse) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_generate_corpse)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_map_corpse_info) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_map_corpse_info)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_register_dyld_image_infos) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_register_dyld_image_infos)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_unregister_dyld_image_infos) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_unregister_dyld_image_infos)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_get_dyld_image_infos) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_get_dyld_image_infos)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_register_dyld_shared_cache_image_info)
                as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_register_dyld_shared_cache_image_info)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_register_dyld_set_dyld_state) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_register_dyld_set_dyld_state)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_register_dyld_get_process_state) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_register_dyld_get_process_state)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_map_corpse_info_64) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_map_corpse_info_64)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Request_task_inspect) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_inspect)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_get_exc_guard_behavior) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_get_exc_guard_behavior)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_set_exc_guard_behavior) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_exc_guard_behavior)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_dyld_process_info_notify_register) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_dyld_process_info_notify_register)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_create_identity_token) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_create_identity_token)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_identity_token_get_task_port) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_identity_token_get_task_port)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_dyld_process_info_notify_deregister) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_dyld_process_info_notify_deregister)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_get_exception_ports_info) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_get_exception_ports_info)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_test_sync_upcall) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_test_sync_upcall)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_set_corpse_forking_behavior) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_set_corpse_forking_behavior)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_test_async_upcall_propagation) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_test_async_upcall_propagation)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Request_task_map_kcdata_object_64) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__RequestUnion__task_subsystem),
            "::",
            stringify!(Request_task_map_kcdata_object_64)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_create_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub child_task: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__task_create_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_create_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_create_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__task_create_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_create_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_create_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_create_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_create_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).child_task) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_create_t),
            "::",
            stringify!(child_task)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_terminate_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_terminate_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_terminate_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_terminate_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_terminate_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_terminate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_terminate_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_terminate_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_terminate_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_terminate_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_threads_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub act_list: mach_msg_ool_ports_descriptor_t,
    pub NDR: NDR_record_t,
    pub act_listCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Reply__task_threads_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_threads_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_threads_t>(),
        56usize,
        concat!("Size of: ", stringify!(__Reply__task_threads_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_threads_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_threads_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_threads_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_threads_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).act_list) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_threads_t),
            "::",
            stringify!(act_list)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_threads_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).act_listCnt) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_threads_t),
            "::",
            stringify!(act_listCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__mach_ports_register_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__mach_ports_register_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__mach_ports_register_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__mach_ports_register_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__mach_ports_register_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__mach_ports_register_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__mach_ports_register_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__mach_ports_register_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__mach_ports_register_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__mach_ports_register_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__mach_ports_lookup_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub init_port_set: mach_msg_ool_ports_descriptor_t,
    pub NDR: NDR_record_t,
    pub init_port_setCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Reply__mach_ports_lookup_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__mach_ports_lookup_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__mach_ports_lookup_t>(),
        56usize,
        concat!("Size of: ", stringify!(__Reply__mach_ports_lookup_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__mach_ports_lookup_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__mach_ports_lookup_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__mach_ports_lookup_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__mach_ports_lookup_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).init_port_set) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__mach_ports_lookup_t),
            "::",
            stringify!(init_port_set)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__mach_ports_lookup_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).init_port_setCnt) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__mach_ports_lookup_t),
            "::",
            stringify!(init_port_setCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub task_info_outCnt: mach_msg_type_number_t,
    pub task_info_out: [integer_t; 90usize],
}
#[test]
fn bindgen_test_layout___Reply__task_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_info_t>(),
        400usize,
        concat!("Size of: ", stringify!(__Reply__task_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_info_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_info_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_info_outCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_info_t),
            "::",
            stringify!(task_info_outCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_info_out) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_info_t),
            "::",
            stringify!(task_info_out)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_info_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_set_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_set_info_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_info_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_suspend_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_suspend_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_suspend_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_suspend_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_suspend_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_suspend_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_suspend_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_suspend_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_suspend_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_suspend_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_resume_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_resume_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_resume_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_resume_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_resume_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_resume_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_resume_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_resume_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_resume_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_resume_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_get_special_port_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub special_port: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__task_get_special_port_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_get_special_port_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_get_special_port_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__task_get_special_port_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_get_special_port_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_get_special_port_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_special_port_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_special_port_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).special_port) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_special_port_t),
            "::",
            stringify!(special_port)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_special_port_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_special_port_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_special_port_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_special_port_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_set_special_port_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_special_port_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_set_special_port_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_special_port_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_special_port_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_special_port_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__thread_create_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub child_act: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__thread_create_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__thread_create_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__thread_create_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__thread_create_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__thread_create_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__thread_create_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__thread_create_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__thread_create_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).child_act) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__thread_create_t),
            "::",
            stringify!(child_act)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__thread_create_running_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub child_act: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__thread_create_running_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__thread_create_running_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__thread_create_running_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__thread_create_running_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__thread_create_running_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__thread_create_running_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__thread_create_running_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__thread_create_running_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).child_act) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__thread_create_running_t),
            "::",
            stringify!(child_act)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_exception_ports_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_exception_ports_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_exception_ports_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_exception_ports_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_set_exception_ports_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_exception_ports_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_set_exception_ports_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_exception_ports_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_exception_ports_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_exception_ports_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_get_exception_ports_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub old_handlers: [mach_msg_port_descriptor_t; 32usize],
    pub NDR: NDR_record_t,
    pub masksCnt: mach_msg_type_number_t,
    pub masks: [exception_mask_t; 32usize],
    pub old_behaviors: [exception_behavior_t; 32usize],
    pub old_flavors: [thread_state_flavor_t; 32usize],
}
#[test]
fn bindgen_test_layout___Reply__task_get_exception_ports_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_get_exception_ports_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_get_exception_ports_t>(),
        808usize,
        concat!("Size of: ", stringify!(__Reply__task_get_exception_ports_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_get_exception_ports_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_get_exception_ports_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_handlers) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_t),
            "::",
            stringify!(old_handlers)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        412usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).masksCnt) as usize - ptr as usize },
        420usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_t),
            "::",
            stringify!(masksCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).masks) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_t),
            "::",
            stringify!(masks)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_behaviors) as usize - ptr as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_t),
            "::",
            stringify!(old_behaviors)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_flavors) as usize - ptr as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_t),
            "::",
            stringify!(old_flavors)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_swap_exception_ports_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub old_handlers: [mach_msg_port_descriptor_t; 32usize],
    pub NDR: NDR_record_t,
    pub masksCnt: mach_msg_type_number_t,
    pub masks: [exception_mask_t; 32usize],
    pub old_behaviors: [exception_behavior_t; 32usize],
    pub old_flavors: [thread_state_flavor_t; 32usize],
}
#[test]
fn bindgen_test_layout___Reply__task_swap_exception_ports_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_swap_exception_ports_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_swap_exception_ports_t>(),
        808usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_swap_exception_ports_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_swap_exception_ports_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_swap_exception_ports_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_exception_ports_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_exception_ports_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_handlers) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_exception_ports_t),
            "::",
            stringify!(old_handlers)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        412usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_exception_ports_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).masksCnt) as usize - ptr as usize },
        420usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_exception_ports_t),
            "::",
            stringify!(masksCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).masks) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_exception_ports_t),
            "::",
            stringify!(masks)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_behaviors) as usize - ptr as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_exception_ports_t),
            "::",
            stringify!(old_behaviors)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_flavors) as usize - ptr as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_exception_ports_t),
            "::",
            stringify!(old_flavors)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__lock_set_create_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub new_lock_set: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__lock_set_create_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__lock_set_create_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__lock_set_create_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__lock_set_create_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__lock_set_create_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__lock_set_create_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__lock_set_create_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__lock_set_create_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_lock_set) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__lock_set_create_t),
            "::",
            stringify!(new_lock_set)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__lock_set_destroy_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__lock_set_destroy_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__lock_set_destroy_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__lock_set_destroy_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__lock_set_destroy_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__lock_set_destroy_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__lock_set_destroy_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__lock_set_destroy_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__lock_set_destroy_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__lock_set_destroy_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__semaphore_create_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub semaphore: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__semaphore_create_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__semaphore_create_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__semaphore_create_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__semaphore_create_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__semaphore_create_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__semaphore_create_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__semaphore_create_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__semaphore_create_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).semaphore) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__semaphore_create_t),
            "::",
            stringify!(semaphore)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__semaphore_destroy_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__semaphore_destroy_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__semaphore_destroy_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__semaphore_destroy_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__semaphore_destroy_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__semaphore_destroy_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__semaphore_destroy_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__semaphore_destroy_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__semaphore_destroy_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__semaphore_destroy_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_policy_set_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_policy_set_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_policy_set_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_policy_set_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_policy_set_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_policy_set_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_policy_set_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_set_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_set_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_set_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_policy_get_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub policy_infoCnt: mach_msg_type_number_t,
    pub policy_info: [integer_t; 16usize],
    pub get_default: boolean_t,
}
#[test]
fn bindgen_test_layout___Reply__task_policy_get_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_policy_get_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_policy_get_t>(),
        108usize,
        concat!("Size of: ", stringify!(__Reply__task_policy_get_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_policy_get_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_policy_get_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_get_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_get_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_get_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy_infoCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_get_t),
            "::",
            stringify!(policy_infoCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).policy_info) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_get_t),
            "::",
            stringify!(policy_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).get_default) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_get_t),
            "::",
            stringify!(get_default)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_sample_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_sample_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_sample_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_sample_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_sample_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_sample_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_sample_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_sample_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_sample_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_sample_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_policy_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_policy_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_policy_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_policy_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_policy_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_policy_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_policy_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_policy_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_emulation_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_emulation_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_emulation_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_emulation_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_set_emulation_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_emulation_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_set_emulation_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_emulation_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_emulation_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_emulation_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_get_emulation_vector_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub emulation_vector: mach_msg_ool_descriptor_t,
    pub NDR: NDR_record_t,
    pub vector_start: ::libc::c_int,
    pub emulation_vectorCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Reply__task_get_emulation_vector_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_get_emulation_vector_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_get_emulation_vector_t>(),
        60usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_get_emulation_vector_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_get_emulation_vector_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_get_emulation_vector_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_emulation_vector_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_emulation_vector_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).emulation_vector) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_emulation_vector_t),
            "::",
            stringify!(emulation_vector)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_emulation_vector_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).vector_start) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_emulation_vector_t),
            "::",
            stringify!(vector_start)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).emulation_vectorCnt) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_emulation_vector_t),
            "::",
            stringify!(emulation_vectorCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_emulation_vector_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_emulation_vector_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_emulation_vector_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_emulation_vector_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_set_emulation_vector_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_emulation_vector_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_set_emulation_vector_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_emulation_vector_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_emulation_vector_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_emulation_vector_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_ras_pc_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_ras_pc_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_ras_pc_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_ras_pc_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_set_ras_pc_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_ras_pc_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_set_ras_pc_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_ras_pc_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_ras_pc_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_ras_pc_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_zone_info_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub names: mach_msg_ool_descriptor_t,
    pub info: mach_msg_ool_descriptor_t,
    pub NDR: NDR_record_t,
    pub namesCnt: mach_msg_type_number_t,
    pub infoCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Reply__task_zone_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_zone_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_zone_info_t>(),
        76usize,
        concat!("Size of: ", stringify!(__Reply__task_zone_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_zone_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_zone_info_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_zone_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_zone_info_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).names) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_zone_info_t),
            "::",
            stringify!(names)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_zone_info_t),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_zone_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).namesCnt) as usize - ptr as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_zone_info_t),
            "::",
            stringify!(namesCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).infoCnt) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_zone_info_t),
            "::",
            stringify!(infoCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_assign_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_assign_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_assign_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_assign_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_assign_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_assign_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_assign_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_assign_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_assign_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_assign_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_assign_default_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_assign_default_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_assign_default_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_assign_default_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_assign_default_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_assign_default_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_assign_default_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_assign_default_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_assign_default_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_assign_default_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_get_assignment_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub assigned_set: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__task_get_assignment_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_get_assignment_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_get_assignment_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__task_get_assignment_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_get_assignment_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_get_assignment_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_assignment_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_assignment_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).assigned_set) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_assignment_t),
            "::",
            stringify!(assigned_set)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_policy_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_policy_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_policy_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_policy_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_set_policy_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_policy_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_set_policy_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_policy_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_policy_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_policy_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_get_state_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub old_stateCnt: mach_msg_type_number_t,
    pub old_state: [natural_t; 1296usize],
}
#[test]
fn bindgen_test_layout___Reply__task_get_state_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_get_state_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_get_state_t>(),
        5224usize,
        concat!("Size of: ", stringify!(__Reply__task_get_state_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_get_state_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_get_state_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_state_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_state_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_state_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_stateCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_state_t),
            "::",
            stringify!(old_stateCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_state) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_state_t),
            "::",
            stringify!(old_state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_state_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_state_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_state_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_state_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_set_state_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_state_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_set_state_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_state_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_state_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_state_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_phys_footprint_limit_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub old_limit: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Reply__task_set_phys_footprint_limit_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_phys_footprint_limit_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_phys_footprint_limit_t>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_set_phys_footprint_limit_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_phys_footprint_limit_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_set_phys_footprint_limit_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_phys_footprint_limit_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_phys_footprint_limit_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_phys_footprint_limit_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_limit) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_phys_footprint_limit_t),
            "::",
            stringify!(old_limit)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_suspend2_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub suspend_token: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__task_suspend2_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_suspend2_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_suspend2_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__task_suspend2_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_suspend2_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_suspend2_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_suspend2_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_suspend2_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).suspend_token) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_suspend2_t),
            "::",
            stringify!(suspend_token)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_resume2_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_resume2_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_resume2_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_resume2_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_resume2_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_resume2_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_resume2_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_resume2_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_resume2_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_resume2_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_purgable_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub stats: task_purgable_info_t,
}
#[test]
fn bindgen_test_layout___Reply__task_purgable_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_purgable_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_purgable_info_t>(),
        308usize,
        concat!("Size of: ", stringify!(__Reply__task_purgable_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_purgable_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_purgable_info_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_purgable_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_purgable_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_purgable_info_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).stats) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_purgable_info_t),
            "::",
            stringify!(stats)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_get_mach_voucher_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub voucher: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__task_get_mach_voucher_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_get_mach_voucher_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_get_mach_voucher_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__task_get_mach_voucher_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_get_mach_voucher_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_get_mach_voucher_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_mach_voucher_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_mach_voucher_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).voucher) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_mach_voucher_t),
            "::",
            stringify!(voucher)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_mach_voucher_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_mach_voucher_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_mach_voucher_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_mach_voucher_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_set_mach_voucher_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_mach_voucher_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_set_mach_voucher_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_mach_voucher_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_mach_voucher_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_mach_voucher_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_swap_mach_voucher_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub old_voucher: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__task_swap_mach_voucher_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_swap_mach_voucher_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_swap_mach_voucher_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__task_swap_mach_voucher_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_swap_mach_voucher_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_swap_mach_voucher_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_mach_voucher_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_mach_voucher_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_voucher) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_swap_mach_voucher_t),
            "::",
            stringify!(old_voucher)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_generate_corpse_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub corpse_task_port: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__task_generate_corpse_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_generate_corpse_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_generate_corpse_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Reply__task_generate_corpse_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_generate_corpse_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_generate_corpse_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_generate_corpse_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_generate_corpse_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).corpse_task_port) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_generate_corpse_t),
            "::",
            stringify!(corpse_task_port)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_map_corpse_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub kcd_addr_begin: vm_address_t,
    pub kcd_size: u32,
}
#[test]
fn bindgen_test_layout___Reply__task_map_corpse_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_map_corpse_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_map_corpse_info_t>(),
        48usize,
        concat!("Size of: ", stringify!(__Reply__task_map_corpse_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_map_corpse_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_map_corpse_info_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kcd_addr_begin) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_t),
            "::",
            stringify!(kcd_addr_begin)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kcd_size) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_t),
            "::",
            stringify!(kcd_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_register_dyld_image_infos_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_register_dyld_image_infos_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_register_dyld_image_infos_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_register_dyld_image_infos_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_register_dyld_image_infos_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_register_dyld_image_infos_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_register_dyld_image_infos_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_image_infos_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_image_infos_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_image_infos_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_unregister_dyld_image_infos_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_unregister_dyld_image_infos_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_unregister_dyld_image_infos_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_unregister_dyld_image_infos_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_unregister_dyld_image_infos_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_unregister_dyld_image_infos_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_unregister_dyld_image_infos_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_unregister_dyld_image_infos_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_unregister_dyld_image_infos_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_unregister_dyld_image_infos_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_get_dyld_image_infos_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub dyld_images: mach_msg_ool_descriptor_t,
    pub NDR: NDR_record_t,
    pub dyld_imagesCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Reply__task_get_dyld_image_infos_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_get_dyld_image_infos_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_get_dyld_image_infos_t>(),
        56usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_get_dyld_image_infos_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_get_dyld_image_infos_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_get_dyld_image_infos_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_dyld_image_infos_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_dyld_image_infos_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_images) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_dyld_image_infos_t),
            "::",
            stringify!(dyld_images)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_dyld_image_infos_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_imagesCnt) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_dyld_image_infos_t),
            "::",
            stringify!(dyld_imagesCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_register_dyld_shared_cache_image_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_register_dyld_shared_cache_image_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_register_dyld_shared_cache_image_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_register_dyld_shared_cache_image_info_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_register_dyld_shared_cache_image_info_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_register_dyld_shared_cache_image_info_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_register_dyld_shared_cache_image_info_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_shared_cache_image_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_shared_cache_image_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_shared_cache_image_info_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_register_dyld_set_dyld_state_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_register_dyld_set_dyld_state_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_register_dyld_set_dyld_state_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_register_dyld_set_dyld_state_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_register_dyld_set_dyld_state_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_register_dyld_set_dyld_state_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_register_dyld_set_dyld_state_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_set_dyld_state_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_set_dyld_state_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_set_dyld_state_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_register_dyld_get_process_state_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub dyld_process_state: dyld_kernel_process_info_t,
}
#[test]
fn bindgen_test_layout___Reply__task_register_dyld_get_process_state_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_register_dyld_get_process_state_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_register_dyld_get_process_state_t>(),
        108usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_register_dyld_get_process_state_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_register_dyld_get_process_state_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_register_dyld_get_process_state_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_get_process_state_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_get_process_state_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_get_process_state_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dyld_process_state) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_register_dyld_get_process_state_t),
            "::",
            stringify!(dyld_process_state)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_map_corpse_info_64_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub kcd_addr_begin: mach_vm_address_t,
    pub kcd_size: mach_vm_size_t,
}
#[test]
fn bindgen_test_layout___Reply__task_map_corpse_info_64_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_map_corpse_info_64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_map_corpse_info_64_t>(),
        52usize,
        concat!("Size of: ", stringify!(__Reply__task_map_corpse_info_64_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_map_corpse_info_64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_map_corpse_info_64_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_64_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_64_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_64_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kcd_addr_begin) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_64_t),
            "::",
            stringify!(kcd_addr_begin)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kcd_size) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_corpse_info_64_t),
            "::",
            stringify!(kcd_size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_inspect_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub info_outCnt: mach_msg_type_number_t,
    pub info_out: [integer_t; 4usize],
}
#[test]
fn bindgen_test_layout___Reply__task_inspect_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_inspect_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_inspect_t>(),
        56usize,
        concat!("Size of: ", stringify!(__Reply__task_inspect_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_inspect_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Reply__task_inspect_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_inspect_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_inspect_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_inspect_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).info_outCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_inspect_t),
            "::",
            stringify!(info_outCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).info_out) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_inspect_t),
            "::",
            stringify!(info_out)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_get_exc_guard_behavior_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub behavior: task_exc_guard_behavior_t,
}
#[test]
fn bindgen_test_layout___Reply__task_get_exc_guard_behavior_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_get_exc_guard_behavior_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_get_exc_guard_behavior_t>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_get_exc_guard_behavior_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_get_exc_guard_behavior_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_get_exc_guard_behavior_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exc_guard_behavior_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exc_guard_behavior_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exc_guard_behavior_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).behavior) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exc_guard_behavior_t),
            "::",
            stringify!(behavior)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_exc_guard_behavior_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_exc_guard_behavior_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_exc_guard_behavior_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_exc_guard_behavior_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_set_exc_guard_behavior_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_exc_guard_behavior_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_set_exc_guard_behavior_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_exc_guard_behavior_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_exc_guard_behavior_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_exc_guard_behavior_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_dyld_process_info_notify_register_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_dyld_process_info_notify_register_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_dyld_process_info_notify_register_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_dyld_process_info_notify_register_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_dyld_process_info_notify_register_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_dyld_process_info_notify_register_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_dyld_process_info_notify_register_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_dyld_process_info_notify_register_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_dyld_process_info_notify_register_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_dyld_process_info_notify_register_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_create_identity_token_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub token: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__task_create_identity_token_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_create_identity_token_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_create_identity_token_t>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_create_identity_token_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_create_identity_token_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_create_identity_token_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_create_identity_token_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_create_identity_token_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).token) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_create_identity_token_t),
            "::",
            stringify!(token)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_identity_token_get_task_port_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub task_port: mach_msg_port_descriptor_t,
}
#[test]
fn bindgen_test_layout___Reply__task_identity_token_get_task_port_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_identity_token_get_task_port_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_identity_token_get_task_port_t>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_identity_token_get_task_port_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_identity_token_get_task_port_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_identity_token_get_task_port_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_identity_token_get_task_port_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_identity_token_get_task_port_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).task_port) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_identity_token_get_task_port_t),
            "::",
            stringify!(task_port)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_dyld_process_info_notify_deregister_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_dyld_process_info_notify_deregister_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_dyld_process_info_notify_deregister_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_dyld_process_info_notify_deregister_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_dyld_process_info_notify_deregister_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_dyld_process_info_notify_deregister_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_dyld_process_info_notify_deregister_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_dyld_process_info_notify_deregister_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_dyld_process_info_notify_deregister_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_dyld_process_info_notify_deregister_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_get_exception_ports_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub masksCnt: mach_msg_type_number_t,
    pub masks: [exception_mask_t; 32usize],
    pub old_handlers_info: [exception_handler_info_t; 32usize],
    pub old_behaviors: [exception_behavior_t; 32usize],
    pub old_flavors: [thread_state_flavor_t; 32usize],
}
#[test]
fn bindgen_test_layout___Reply__task_get_exception_ports_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_get_exception_ports_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_get_exception_ports_info_t>(),
        680usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_get_exception_ports_info_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_get_exception_ports_info_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_get_exception_ports_info_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_info_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).masksCnt) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_info_t),
            "::",
            stringify!(masksCnt)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).masks) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_info_t),
            "::",
            stringify!(masks)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_handlers_info) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_info_t),
            "::",
            stringify!(old_handlers_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_behaviors) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_info_t),
            "::",
            stringify!(old_behaviors)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).old_flavors) as usize - ptr as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_get_exception_ports_info_t),
            "::",
            stringify!(old_flavors)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_test_sync_upcall_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_test_sync_upcall_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_test_sync_upcall_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_test_sync_upcall_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Reply__task_test_sync_upcall_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_test_sync_upcall_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_test_sync_upcall_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_test_sync_upcall_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_test_sync_upcall_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_test_sync_upcall_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_set_corpse_forking_behavior_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_set_corpse_forking_behavior_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_set_corpse_forking_behavior_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_set_corpse_forking_behavior_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_set_corpse_forking_behavior_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_set_corpse_forking_behavior_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_set_corpse_forking_behavior_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_corpse_forking_behavior_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_corpse_forking_behavior_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_set_corpse_forking_behavior_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_test_async_upcall_propagation_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
}
#[test]
fn bindgen_test_layout___Reply__task_test_async_upcall_propagation_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_test_async_upcall_propagation_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_test_async_upcall_propagation_t>(),
        36usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_test_async_upcall_propagation_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_test_async_upcall_propagation_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_test_async_upcall_propagation_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_test_async_upcall_propagation_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_test_async_upcall_propagation_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_test_async_upcall_propagation_t),
            "::",
            stringify!(RetCode)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Reply__task_map_kcdata_object_64_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub RetCode: kern_return_t,
    pub kcd_addr_begin: mach_vm_address_t,
    pub kcd_size: mach_vm_size_t,
}
#[test]
fn bindgen_test_layout___Reply__task_map_kcdata_object_64_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Reply__task_map_kcdata_object_64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Reply__task_map_kcdata_object_64_t>(),
        52usize,
        concat!(
            "Size of: ",
            stringify!(__Reply__task_map_kcdata_object_64_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Reply__task_map_kcdata_object_64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Reply__task_map_kcdata_object_64_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_kcdata_object_64_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_kcdata_object_64_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).RetCode) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_kcdata_object_64_t),
            "::",
            stringify!(RetCode)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kcd_addr_begin) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_kcdata_object_64_t),
            "::",
            stringify!(kcd_addr_begin)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).kcd_size) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Reply__task_map_kcdata_object_64_t),
            "::",
            stringify!(kcd_size)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __ReplyUnion__task_subsystem {
    pub Reply_task_create: __Reply__task_create_t,
    pub Reply_task_terminate: __Reply__task_terminate_t,
    pub Reply_task_threads: __Reply__task_threads_t,
    pub Reply_mach_ports_register: __Reply__mach_ports_register_t,
    pub Reply_mach_ports_lookup: __Reply__mach_ports_lookup_t,
    pub Reply_task_info: __Reply__task_info_t,
    pub Reply_task_set_info: __Reply__task_set_info_t,
    pub Reply_task_suspend: __Reply__task_suspend_t,
    pub Reply_task_resume: __Reply__task_resume_t,
    pub Reply_task_get_special_port: __Reply__task_get_special_port_t,
    pub Reply_task_set_special_port: __Reply__task_set_special_port_t,
    pub Reply_thread_create: __Reply__thread_create_t,
    pub Reply_thread_create_running: __Reply__thread_create_running_t,
    pub Reply_task_set_exception_ports: __Reply__task_set_exception_ports_t,
    pub Reply_task_get_exception_ports: __Reply__task_get_exception_ports_t,
    pub Reply_task_swap_exception_ports: __Reply__task_swap_exception_ports_t,
    pub Reply_lock_set_create: __Reply__lock_set_create_t,
    pub Reply_lock_set_destroy: __Reply__lock_set_destroy_t,
    pub Reply_semaphore_create: __Reply__semaphore_create_t,
    pub Reply_semaphore_destroy: __Reply__semaphore_destroy_t,
    pub Reply_task_policy_set: __Reply__task_policy_set_t,
    pub Reply_task_policy_get: __Reply__task_policy_get_t,
    pub Reply_task_sample: __Reply__task_sample_t,
    pub Reply_task_policy: __Reply__task_policy_t,
    pub Reply_task_set_emulation: __Reply__task_set_emulation_t,
    pub Reply_task_get_emulation_vector: __Reply__task_get_emulation_vector_t,
    pub Reply_task_set_emulation_vector: __Reply__task_set_emulation_vector_t,
    pub Reply_task_set_ras_pc: __Reply__task_set_ras_pc_t,
    pub Reply_task_zone_info: __Reply__task_zone_info_t,
    pub Reply_task_assign: __Reply__task_assign_t,
    pub Reply_task_assign_default: __Reply__task_assign_default_t,
    pub Reply_task_get_assignment: __Reply__task_get_assignment_t,
    pub Reply_task_set_policy: __Reply__task_set_policy_t,
    pub Reply_task_get_state: __Reply__task_get_state_t,
    pub Reply_task_set_state: __Reply__task_set_state_t,
    pub Reply_task_set_phys_footprint_limit: __Reply__task_set_phys_footprint_limit_t,
    pub Reply_task_suspend2: __Reply__task_suspend2_t,
    pub Reply_task_resume2: __Reply__task_resume2_t,
    pub Reply_task_purgable_info: __Reply__task_purgable_info_t,
    pub Reply_task_get_mach_voucher: __Reply__task_get_mach_voucher_t,
    pub Reply_task_set_mach_voucher: __Reply__task_set_mach_voucher_t,
    pub Reply_task_swap_mach_voucher: __Reply__task_swap_mach_voucher_t,
    pub Reply_task_generate_corpse: __Reply__task_generate_corpse_t,
    pub Reply_task_map_corpse_info: __Reply__task_map_corpse_info_t,
    pub Reply_task_register_dyld_image_infos: __Reply__task_register_dyld_image_infos_t,
    pub Reply_task_unregister_dyld_image_infos: __Reply__task_unregister_dyld_image_infos_t,
    pub Reply_task_get_dyld_image_infos: __Reply__task_get_dyld_image_infos_t,
    pub Reply_task_register_dyld_shared_cache_image_info:
        __Reply__task_register_dyld_shared_cache_image_info_t,
    pub Reply_task_register_dyld_set_dyld_state: __Reply__task_register_dyld_set_dyld_state_t,
    pub Reply_task_register_dyld_get_process_state: __Reply__task_register_dyld_get_process_state_t,
    pub Reply_task_map_corpse_info_64: __Reply__task_map_corpse_info_64_t,
    pub Reply_task_inspect: __Reply__task_inspect_t,
    pub Reply_task_get_exc_guard_behavior: __Reply__task_get_exc_guard_behavior_t,
    pub Reply_task_set_exc_guard_behavior: __Reply__task_set_exc_guard_behavior_t,
    pub Reply_task_dyld_process_info_notify_register:
        __Reply__task_dyld_process_info_notify_register_t,
    pub Reply_task_create_identity_token: __Reply__task_create_identity_token_t,
    pub Reply_task_identity_token_get_task_port: __Reply__task_identity_token_get_task_port_t,
    pub Reply_task_dyld_process_info_notify_deregister:
        __Reply__task_dyld_process_info_notify_deregister_t,
    pub Reply_task_get_exception_ports_info: __Reply__task_get_exception_ports_info_t,
    pub Reply_task_test_sync_upcall: __Reply__task_test_sync_upcall_t,
    pub Reply_task_set_corpse_forking_behavior: __Reply__task_set_corpse_forking_behavior_t,
    pub Reply_task_test_async_upcall_propagation: __Reply__task_test_async_upcall_propagation_t,
    pub Reply_task_map_kcdata_object_64: __Reply__task_map_kcdata_object_64_t,
}
#[test]
fn bindgen_test_layout___ReplyUnion__task_subsystem() {
    const UNINIT: ::core::mem::MaybeUninit<__ReplyUnion__task_subsystem> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__ReplyUnion__task_subsystem>(),
        5224usize,
        concat!("Size of: ", stringify!(__ReplyUnion__task_subsystem))
    );
    assert_eq!(
        ::core::mem::align_of::<__ReplyUnion__task_subsystem>(),
        4usize,
        concat!("Alignment of ", stringify!(__ReplyUnion__task_subsystem))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_create) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_create)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_terminate) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_terminate)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_threads) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_threads)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_mach_ports_register) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_mach_ports_register)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_mach_ports_lookup) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_mach_ports_lookup)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_set_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_suspend) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_suspend)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_resume) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_resume)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_get_special_port) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_get_special_port)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_set_special_port) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_special_port)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_thread_create) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_thread_create)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_thread_create_running) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_thread_create_running)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_set_exception_ports) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_exception_ports)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_get_exception_ports) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_get_exception_ports)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_swap_exception_ports) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_swap_exception_ports)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_lock_set_create) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_lock_set_create)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_lock_set_destroy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_lock_set_destroy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_semaphore_create) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_semaphore_create)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_semaphore_destroy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_semaphore_destroy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_policy_set) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_policy_set)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_policy_get) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_policy_get)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_sample) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_sample)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_policy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_set_emulation) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_emulation)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_get_emulation_vector) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_get_emulation_vector)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_set_emulation_vector) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_emulation_vector)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_set_ras_pc) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_ras_pc)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_zone_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_zone_info)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_assign) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_assign)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_assign_default) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_assign_default)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_get_assignment) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_get_assignment)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_set_policy) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_policy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_get_state) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_get_state)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_set_state) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_state)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_set_phys_footprint_limit) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_phys_footprint_limit)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_suspend2) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_suspend2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_resume2) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_resume2)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_purgable_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_purgable_info)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_get_mach_voucher) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_get_mach_voucher)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_set_mach_voucher) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_mach_voucher)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_swap_mach_voucher) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_swap_mach_voucher)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_generate_corpse) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_generate_corpse)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_map_corpse_info) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_map_corpse_info)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_register_dyld_image_infos) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_register_dyld_image_infos)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_unregister_dyld_image_infos) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_unregister_dyld_image_infos)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_get_dyld_image_infos) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_get_dyld_image_infos)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_register_dyld_shared_cache_image_info) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_register_dyld_shared_cache_image_info)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_register_dyld_set_dyld_state) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_register_dyld_set_dyld_state)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_register_dyld_get_process_state) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_register_dyld_get_process_state)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_map_corpse_info_64) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_map_corpse_info_64)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Reply_task_inspect) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_inspect)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_get_exc_guard_behavior) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_get_exc_guard_behavior)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_set_exc_guard_behavior) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_exc_guard_behavior)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_dyld_process_info_notify_register) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_dyld_process_info_notify_register)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_create_identity_token) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_create_identity_token)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_identity_token_get_task_port) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_identity_token_get_task_port)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_dyld_process_info_notify_deregister) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_dyld_process_info_notify_deregister)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_get_exception_ports_info) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_get_exception_ports_info)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_test_sync_upcall) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_test_sync_upcall)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_set_corpse_forking_behavior) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_set_corpse_forking_behavior)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_test_async_upcall_propagation) as usize
                - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_test_async_upcall_propagation)
        )
    );
    assert_eq!(
        unsafe {
            ::core::ptr::addr_of!((*ptr).Reply_task_map_kcdata_object_64) as usize - ptr as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__ReplyUnion__task_subsystem),
            "::",
            stringify!(Reply_task_map_kcdata_object_64)
        )
    );
}
extern "C" {
    pub fn vm_region(
        target_task: vm_map_read_t,
        address: *mut vm_address_t,
        size: *mut vm_size_t,
        flavor: vm_region_flavor_t,
        info: vm_region_info_t,
        infoCnt: *mut mach_msg_type_number_t,
        object_name: *mut mach_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_allocate(
        target_task: vm_map_t,
        address: *mut vm_address_t,
        size: vm_size_t,
        flags: ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_deallocate(
        target_task: vm_map_t,
        address: vm_address_t,
        size: vm_size_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_protect(
        target_task: vm_map_t,
        address: vm_address_t,
        size: vm_size_t,
        set_maximum: boolean_t,
        new_protection: vm_prot_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_inherit(
        target_task: vm_map_t,
        address: vm_address_t,
        size: vm_size_t,
        new_inheritance: vm_inherit_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_read(
        target_task: vm_map_read_t,
        address: vm_address_t,
        size: vm_size_t,
        data: *mut vm_offset_t,
        dataCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_read_list(
        target_task: vm_map_read_t,
        data_list: *mut vm_read_entry,
        count: natural_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_write(
        target_task: vm_map_t,
        address: vm_address_t,
        data: vm_offset_t,
        dataCnt: mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_copy(
        target_task: vm_map_t,
        source_address: vm_address_t,
        size: vm_size_t,
        dest_address: vm_address_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_read_overwrite(
        target_task: vm_map_read_t,
        address: vm_address_t,
        size: vm_size_t,
        data: vm_address_t,
        outsize: *mut vm_size_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_msync(
        target_task: vm_map_t,
        address: vm_address_t,
        size: vm_size_t,
        sync_flags: vm_sync_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_behavior_set(
        target_task: vm_map_t,
        address: vm_address_t,
        size: vm_size_t,
        new_behavior: vm_behavior_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_map(
        target_task: vm_map_t,
        address: *mut vm_address_t,
        size: vm_size_t,
        mask: vm_address_t,
        flags: ::libc::c_int,
        object: mem_entry_name_port_t,
        offset: vm_offset_t,
        copy: boolean_t,
        cur_protection: vm_prot_t,
        max_protection: vm_prot_t,
        inheritance: vm_inherit_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_machine_attribute(
        target_task: vm_map_t,
        address: vm_address_t,
        size: vm_size_t,
        attribute: vm_machine_attribute_t,
        value: *mut vm_machine_attribute_val_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_remap(
        target_task: vm_map_t,
        target_address: *mut vm_address_t,
        size: vm_size_t,
        mask: vm_address_t,
        flags: ::libc::c_int,
        src_task: vm_map_t,
        src_address: vm_address_t,
        copy: boolean_t,
        cur_protection: *mut vm_prot_t,
        max_protection: *mut vm_prot_t,
        inheritance: vm_inherit_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn task_wire(target_task: vm_map_t, must_wire: boolean_t) -> kern_return_t;
}
extern "C" {
    pub fn mach_make_memory_entry(
        target_task: vm_map_t,
        size: *mut vm_size_t,
        offset: vm_offset_t,
        permission: vm_prot_t,
        object_handle: *mut mem_entry_name_port_t,
        parent_entry: mem_entry_name_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_map_page_query(
        target_map: vm_map_read_t,
        offset: vm_offset_t,
        disposition: *mut integer_t,
        ref_count: *mut integer_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn mach_vm_region_info(
        task: vm_map_read_t,
        address: vm_address_t,
        region: *mut vm_info_region_t,
        objects: *mut vm_info_object_array_t,
        objectsCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_mapped_pages_info(
        task: vm_map_read_t,
        pages: *mut page_address_array_t,
        pagesCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_region_recurse(
        target_task: vm_map_read_t,
        address: *mut vm_address_t,
        size: *mut vm_size_t,
        nesting_depth: *mut natural_t,
        info: vm_region_recurse_info_t,
        infoCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_region_recurse_64(
        target_task: vm_map_read_t,
        address: *mut vm_address_t,
        size: *mut vm_size_t,
        nesting_depth: *mut natural_t,
        info: vm_region_recurse_info_t,
        infoCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn mach_vm_region_info_64(
        task: vm_map_read_t,
        address: vm_address_t,
        region: *mut vm_info_region_64_t,
        objects: *mut vm_info_object_array_t,
        objectsCnt: *mut mach_msg_type_number_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_region_64(
        target_task: vm_map_read_t,
        address: *mut vm_address_t,
        size: *mut vm_size_t,
        flavor: vm_region_flavor_t,
        info: vm_region_info_t,
        infoCnt: *mut mach_msg_type_number_t,
        object_name: *mut mach_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn mach_make_memory_entry_64(
        target_task: vm_map_t,
        size: *mut memory_object_size_t,
        offset: memory_object_offset_t,
        permission: vm_prot_t,
        object_handle: *mut mach_port_t,
        parent_entry: mem_entry_name_port_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_map_64(
        target_task: vm_map_t,
        address: *mut vm_address_t,
        size: vm_size_t,
        mask: vm_address_t,
        flags: ::libc::c_int,
        object: mem_entry_name_port_t,
        offset: memory_object_offset_t,
        copy: boolean_t,
        cur_protection: vm_prot_t,
        max_protection: vm_prot_t,
        inheritance: vm_inherit_t,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_purgable_control(
        target_task: vm_map_t,
        address: vm_address_t,
        control: vm_purgable_t,
        state: *mut ::libc::c_int,
    ) -> kern_return_t;
}
extern "C" {
    pub fn vm_map_exec_lockdown(target_task: vm_map_t) -> kern_return_t;
}
extern "C" {
    pub fn vm_remap_new(
        target_task: vm_map_t,
        target_address: *mut vm_address_t,
        size: vm_size_t,
        mask: vm_address_t,
        flags: ::libc::c_int,
        src_task: vm_map_read_t,
        src_address: vm_address_t,
        copy: boolean_t,
        cur_protection: *mut vm_prot_t,
        max_protection: *mut vm_prot_t,
        inheritance: vm_inherit_t,
    ) -> kern_return_t;
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_region_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub flavor: vm_region_flavor_t,
    pub infoCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__vm_region_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_region_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_region_t>(),
        48usize,
        concat!("Size of: ", stringify!(__Request__vm_region_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_region_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_region_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).infoCnt) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_t),
            "::",
            stringify!(infoCnt)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_allocate_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub flags: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Request__vm_allocate_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_allocate_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_allocate_t>(),
        52usize,
        concat!("Size of: ", stringify!(__Request__vm_allocate_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_allocate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_allocate_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_allocate_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_allocate_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_allocate_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_allocate_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_allocate_t),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_deallocate_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
}
#[test]
fn bindgen_test_layout___Request__vm_deallocate_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_deallocate_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_deallocate_t>(),
        48usize,
        concat!("Size of: ", stringify!(__Request__vm_deallocate_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_deallocate_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_deallocate_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_deallocate_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_deallocate_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_deallocate_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_deallocate_t),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_protect_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub set_maximum: boolean_t,
    pub new_protection: vm_prot_t,
}
#[test]
fn bindgen_test_layout___Request__vm_protect_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_protect_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_protect_t>(),
        56usize,
        concat!("Size of: ", stringify!(__Request__vm_protect_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_protect_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_protect_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_protect_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_protect_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_protect_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_protect_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).set_maximum) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_protect_t),
            "::",
            stringify!(set_maximum)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_protection) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_protect_t),
            "::",
            stringify!(new_protection)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_inherit_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub new_inheritance: vm_inherit_t,
}
#[test]
fn bindgen_test_layout___Request__vm_inherit_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_inherit_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_inherit_t>(),
        52usize,
        concat!("Size of: ", stringify!(__Request__vm_inherit_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_inherit_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_inherit_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_inherit_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_inherit_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_inherit_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_inherit_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_inheritance) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_inherit_t),
            "::",
            stringify!(new_inheritance)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_read_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
}
#[test]
fn bindgen_test_layout___Request__vm_read_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_read_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_read_t>(),
        48usize,
        concat!("Size of: ", stringify!(__Request__vm_read_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_read_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_read_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_t),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_read_list_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub data_list: vm_read_entry_t,
    pub count: natural_t,
}
#[test]
fn bindgen_test_layout___Request__vm_read_list_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_read_list_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_read_list_t>(),
        4132usize,
        concat!("Size of: ", stringify!(__Request__vm_read_list_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_read_list_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_read_list_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_list_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_list_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).data_list) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_list_t),
            "::",
            stringify!(data_list)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).count) as usize - ptr as usize },
        4128usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_list_t),
            "::",
            stringify!(count)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_write_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub data: mach_msg_ool_descriptor_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub dataCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__vm_write_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_write_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_write_t>(),
        64usize,
        concat!("Size of: ", stringify!(__Request__vm_write_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_write_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_write_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_write_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_write_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_write_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_write_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_write_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dataCnt) as usize - ptr as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_write_t),
            "::",
            stringify!(dataCnt)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_copy_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub source_address: vm_address_t,
    pub size: vm_size_t,
    pub dest_address: vm_address_t,
}
#[test]
fn bindgen_test_layout___Request__vm_copy_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_copy_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_copy_t>(),
        56usize,
        concat!("Size of: ", stringify!(__Request__vm_copy_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_copy_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_copy_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_copy_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_copy_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).source_address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_copy_t),
            "::",
            stringify!(source_address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_copy_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).dest_address) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_copy_t),
            "::",
            stringify!(dest_address)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_read_overwrite_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub data: vm_address_t,
}
#[test]
fn bindgen_test_layout___Request__vm_read_overwrite_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_read_overwrite_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_read_overwrite_t>(),
        56usize,
        concat!("Size of: ", stringify!(__Request__vm_read_overwrite_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_read_overwrite_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_read_overwrite_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_overwrite_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_overwrite_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_overwrite_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_overwrite_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_read_overwrite_t),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_msync_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub sync_flags: vm_sync_t,
}
#[test]
fn bindgen_test_layout___Request__vm_msync_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_msync_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_msync_t>(),
        52usize,
        concat!("Size of: ", stringify!(__Request__vm_msync_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_msync_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_msync_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_msync_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_msync_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_msync_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_msync_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).sync_flags) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_msync_t),
            "::",
            stringify!(sync_flags)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_behavior_set_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub new_behavior: vm_behavior_t,
}
#[test]
fn bindgen_test_layout___Request__vm_behavior_set_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_behavior_set_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_behavior_set_t>(),
        52usize,
        concat!("Size of: ", stringify!(__Request__vm_behavior_set_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_behavior_set_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_behavior_set_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_behavior_set_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_behavior_set_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_behavior_set_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_behavior_set_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).new_behavior) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_behavior_set_t),
            "::",
            stringify!(new_behavior)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_map_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub object: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub mask: vm_address_t,
    pub flags: ::libc::c_int,
    pub offset: vm_offset_t,
    pub copy: boolean_t,
    pub cur_protection: vm_prot_t,
    pub max_protection: vm_prot_t,
    pub inheritance: vm_inherit_t,
}
#[test]
fn bindgen_test_layout___Request__vm_map_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_map_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_map_t>(),
        100usize,
        concat!("Size of: ", stringify!(__Request__vm_map_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_map_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_map_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).object) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(object)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mask) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).copy) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(copy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cur_protection) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(cur_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_protection) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inheritance) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_t),
            "::",
            stringify!(inheritance)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_machine_attribute_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub attribute: vm_machine_attribute_t,
    pub value: vm_machine_attribute_val_t,
}
#[test]
fn bindgen_test_layout___Request__vm_machine_attribute_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_machine_attribute_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_machine_attribute_t>(),
        56usize,
        concat!("Size of: ", stringify!(__Request__vm_machine_attribute_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_machine_attribute_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__vm_machine_attribute_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_machine_attribute_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_machine_attribute_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_machine_attribute_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_machine_attribute_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).attribute) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_machine_attribute_t),
            "::",
            stringify!(attribute)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).value) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_machine_attribute_t),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_remap_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub src_task: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub target_address: vm_address_t,
    pub size: vm_size_t,
    pub mask: vm_address_t,
    pub flags: ::libc::c_int,
    pub src_address: vm_address_t,
    pub copy: boolean_t,
    pub inheritance: vm_inherit_t,
}
#[test]
fn bindgen_test_layout___Request__vm_remap_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_remap_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_remap_t>(),
        92usize,
        concat!("Size of: ", stringify!(__Request__vm_remap_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_remap_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_remap_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).src_task) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(src_task)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).target_address) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(target_address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mask) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).src_address) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(src_address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).copy) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(copy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inheritance) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_t),
            "::",
            stringify!(inheritance)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__task_wire_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub must_wire: boolean_t,
}
#[test]
fn bindgen_test_layout___Request__task_wire_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__task_wire_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__task_wire_t>(),
        36usize,
        concat!("Size of: ", stringify!(__Request__task_wire_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__task_wire_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__task_wire_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_wire_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_wire_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).must_wire) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__task_wire_t),
            "::",
            stringify!(must_wire)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__mach_make_memory_entry_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub parent_entry: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub size: vm_size_t,
    pub offset: vm_offset_t,
    pub permission: vm_prot_t,
}
#[test]
fn bindgen_test_layout___Request__mach_make_memory_entry_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__mach_make_memory_entry_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__mach_make_memory_entry_t>(),
        68usize,
        concat!("Size of: ", stringify!(__Request__mach_make_memory_entry_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__mach_make_memory_entry_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__mach_make_memory_entry_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).parent_entry) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_t),
            "::",
            stringify!(parent_entry)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).permission) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_t),
            "::",
            stringify!(permission)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_map_page_query_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub offset: vm_offset_t,
}
#[test]
fn bindgen_test_layout___Request__vm_map_page_query_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_map_page_query_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_map_page_query_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__vm_map_page_query_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_map_page_query_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_map_page_query_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_page_query_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_page_query_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_page_query_t),
            "::",
            stringify!(offset)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__mach_vm_region_info_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
}
#[test]
fn bindgen_test_layout___Request__mach_vm_region_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__mach_vm_region_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__mach_vm_region_info_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__mach_vm_region_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__mach_vm_region_info_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__mach_vm_region_info_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_vm_region_info_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_vm_region_info_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_vm_region_info_t),
            "::",
            stringify!(address)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_mapped_pages_info_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__vm_mapped_pages_info_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_mapped_pages_info_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_mapped_pages_info_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__vm_mapped_pages_info_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_mapped_pages_info_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__vm_mapped_pages_info_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_mapped_pages_info_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_region_recurse_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub nesting_depth: natural_t,
    pub infoCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__vm_region_recurse_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_region_recurse_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_region_recurse_t>(),
        48usize,
        concat!("Size of: ", stringify!(__Request__vm_region_recurse_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_region_recurse_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_region_recurse_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).nesting_depth) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_t),
            "::",
            stringify!(nesting_depth)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).infoCnt) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_t),
            "::",
            stringify!(infoCnt)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_region_recurse_64_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub nesting_depth: natural_t,
    pub infoCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__vm_region_recurse_64_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_region_recurse_64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_region_recurse_64_t>(),
        48usize,
        concat!("Size of: ", stringify!(__Request__vm_region_recurse_64_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_region_recurse_64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__vm_region_recurse_64_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_64_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_64_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_64_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).nesting_depth) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_64_t),
            "::",
            stringify!(nesting_depth)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).infoCnt) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_recurse_64_t),
            "::",
            stringify!(infoCnt)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__mach_vm_region_info_64_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
}
#[test]
fn bindgen_test_layout___Request__mach_vm_region_info_64_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__mach_vm_region_info_64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__mach_vm_region_info_64_t>(),
        40usize,
        concat!("Size of: ", stringify!(__Request__mach_vm_region_info_64_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__mach_vm_region_info_64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__mach_vm_region_info_64_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_vm_region_info_64_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_vm_region_info_64_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_vm_region_info_64_t),
            "::",
            stringify!(address)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_region_64_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub flavor: vm_region_flavor_t,
    pub infoCnt: mach_msg_type_number_t,
}
#[test]
fn bindgen_test_layout___Request__vm_region_64_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_region_64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_region_64_t>(),
        48usize,
        concat!("Size of: ", stringify!(__Request__vm_region_64_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_region_64_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_region_64_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_64_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_64_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_64_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flavor) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_64_t),
            "::",
            stringify!(flavor)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).infoCnt) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_region_64_t),
            "::",
            stringify!(infoCnt)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__mach_make_memory_entry_64_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub parent_entry: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub size: memory_object_size_t,
    pub offset: memory_object_offset_t,
    pub permission: vm_prot_t,
}
#[test]
fn bindgen_test_layout___Request__mach_make_memory_entry_64_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__mach_make_memory_entry_64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__mach_make_memory_entry_64_t>(),
        68usize,
        concat!(
            "Size of: ",
            stringify!(__Request__mach_make_memory_entry_64_t)
        )
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__mach_make_memory_entry_64_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__mach_make_memory_entry_64_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_64_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_64_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).parent_entry) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_64_t),
            "::",
            stringify!(parent_entry)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_64_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_64_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_64_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).permission) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__mach_make_memory_entry_64_t),
            "::",
            stringify!(permission)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_map_64_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub object: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub size: vm_size_t,
    pub mask: vm_address_t,
    pub flags: ::libc::c_int,
    pub offset: memory_object_offset_t,
    pub copy: boolean_t,
    pub cur_protection: vm_prot_t,
    pub max_protection: vm_prot_t,
    pub inheritance: vm_inherit_t,
}
#[test]
fn bindgen_test_layout___Request__vm_map_64_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_map_64_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_map_64_t>(),
        100usize,
        concat!("Size of: ", stringify!(__Request__vm_map_64_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_map_64_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_map_64_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).object) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(object)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).mask) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).copy) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(copy)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).cur_protection) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(cur_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).max_protection) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(max_protection)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).inheritance) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_64_t),
            "::",
            stringify!(inheritance)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_purgable_control_t {
    pub Head: mach_msg_header_t,
    pub NDR: NDR_record_t,
    pub address: vm_address_t,
    pub control: vm_purgable_t,
    pub state: ::libc::c_int,
}
#[test]
fn bindgen_test_layout___Request__vm_purgable_control_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_purgable_control_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_purgable_control_t>(),
        48usize,
        concat!("Size of: ", stringify!(__Request__vm_purgable_control_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_purgable_control_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__vm_purgable_control_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_purgable_control_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_purgable_control_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).address) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_purgable_control_t),
            "::",
            stringify!(address)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).control) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_purgable_control_t),
            "::",
            stringify!(control)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_purgable_control_t),
            "::",
            stringify!(state)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_map_exec_lockdown_t {
    pub Head: mach_msg_header_t,
}
#[test]
fn bindgen_test_layout___Request__vm_map_exec_lockdown_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_map_exec_lockdown_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_map_exec_lockdown_t>(),
        24usize,
        concat!("Size of: ", stringify!(__Request__vm_map_exec_lockdown_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_map_exec_lockdown_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__Request__vm_map_exec_lockdown_t)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_map_exec_lockdown_t),
            "::",
            stringify!(Head)
        )
    );
}
#[repr(C, packed(4))]
#[derive(Debug, Copy, Clone)]
pub struct __Request__vm_remap_new_t {
    pub Head: mach_msg_header_t,
    pub msgh_body: mach_msg_body_t,
    pub src_task: mach_msg_port_descriptor_t,
    pub NDR: NDR_record_t,
    pub target_address: vm_address_t,
    pub size: vm_size_t,
    pub mask: vm_address_t,
    pub flags: ::libc::c_int,
    pub src_address: vm_address_t,
    pub copy: boolean_t,
    pub cur_protection: vm_prot_t,
    pub max_protection: vm_prot_t,
    pub inheritance: vm_inherit_t,
}
#[test]
fn bindgen_test_layout___Request__vm_remap_new_t() {
    const UNINIT: ::core::mem::MaybeUninit<__Request__vm_remap_new_t> =
        ::core::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::core::mem::size_of::<__Request__vm_remap_new_t>(),
        100usize,
        concat!("Size of: ", stringify!(__Request__vm_remap_new_t))
    );
    assert_eq!(
        ::core::mem::align_of::<__Request__vm_remap_new_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__Request__vm_remap_new_t))
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).Head) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_new_t),
            "::",
            stringify!(Head)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).msgh_body) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_new_t),
            "::",
            stringify!(msgh_body)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).src_task) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_new_t),
            "::",
            stringify!(src_task)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).NDR) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__Request__vm_remap_new_t),
            "::",
            stringify!(NDR)
        )
    );
    assert_eq!(
        unsafe { ::core::ptr::addr_of!((*ptr).target_address) as usize - ptr as usize },
        48usize,
  