// ===----------------------------------------------------------------------===//
// Copyright © 2024 Apple Inc. and the Pkl project authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//	https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ===----------------------------------------------------------------------===//
@go.Package { name = "github.com/apple/pkl-go-examples/gen/redisconfig" }
module org.pkl.golang.example.RedisConfig

import "package://pkg.pkl-lang.org/pkl-go/pkl.golang@0.5.0#/go.pkl"

class Auth {
  /// Basic HTTP authorization username
  username: String

  /// Basic HTTP authorization password
  password: String
}

/// Whether Redis connections are enabled or not.
enabled: Boolean

/// The hostname that Redis listens on
host: String

/// The port that Redis listens on
port: UInt16

/// Authorization settings for Redis
auth: Auth?