! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_22

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_22
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_22(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_22
  
  
! [-20kT;22kT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.59867300712422_p
w(1)=10.40132056855476_p
x(2)=-3.761795343086042_p
w(2)=9.598679433227451_p
else if(N==3)then
x(1)=-17.56069623868146_p
w(1)=6.008953533783538_p
x(2)=-9.213296198166935_p
w(2)=9.514824218428961_p
x(3)=-1.155162585223817_p
w(3)=4.476222249569707_p
else if(N==4)then
x(1)=-18.43109937213212_p
w(1)=3.928602972770748_p
x(2)=-12.55785773299107_p
w(2)=7.327551979927760_p
x(3)=-5.008580704177252_p
w(3)=7.006528327861706_p
x(4)=6.703001640079307e-1_p
w(4)=1.737316721221992_p
else if(N==5)then
x(1)=-18.89086843093168_p
w(1)=2.799987169377063_p
x(2)=-14.55268241231039_p
w(2)=5.634844753219318_p
x(3)=-8.251842812339101_p
w(3)=6.590024721584699_p
x(4)=-2.226715490976776_p
w(4)=4.558793453645443_p
x(5)=2.575270232023435_p
w(5)=4.163499039556839e-1_p
else if(N==6)then
x(1)=-19.16412513224337_p
w(1)=2.119942507421528_p
x(2)=-15.8127090753344_p
w(2)=4.449283584328564_p
x(3)=-10.62372745873638_p
w(3)=5.710919730272983_p
x(4)=-4.894957390877646_p
w(4)=5.411424118959731_p
x(5)=-2.100764614791066e-1_p
w(5)=2.254800816877419_p
x(6)=4.859852805863084_p
w(6)=5.362924392198048e-2_p
else if(N==7)then
x(1)=-19.34080687898675_p
w(1)=1.676679734959983_p
x(2)=-16.65675146922602_p
w(2)=3.610936992288977_p
x(3)=-12.33878817490014_p
w(3)=4.889210886684316_p
x(4)=-7.194639165862869_p
w(4)=5.213603189746680_p
x(5)=-2.332065117459068_p
w(5)=3.910707285361774_p
x(6)=1.646820795221146_p
w(6)=6.944353218154120e-1_p
x(7)=7.477021118125944_p
w(7)=4.426590925064911e-3_p
else if(N==8)then
x(1)=-19.46271408350787_p
w(1)=1.369244189438577_p
x(2)=-17.25245379051749_p
w(2)=2.999583336846344_p
x(3)=-13.60675399341347_p
w(3)=4.202361857121139_p
x(4)=-9.058084132452722_p
w(4)=4.773946556227624_p
x(5)=-4.338578476766276_p
w(5)=4.437650446323353_p
x(6)=-3.429595386520899e-1_p
w(6)=2.099765261797026_p
x(7)=3.737499466149230_p
w(7)=1.171587685322120e-1_p
x(8)=10.28032215068516_p
w(8)=2.895854959302483e-4_p
else if(N==9)then
x(1)=-19.55156717945825_p
w(1)=1.144361004515591_p
x(2)=-17.69345723402962_p
w(2)=2.537050135796357_p
x(3)=-14.57501856849313_p
w(3)=3.638385207328377_p
x(4)=-10.56233663144588_p
w(4)=4.303138959906970_p
x(5)=-6.160069889568986_p
w(5)=4.380432587715971_p
x(6)=-2.050731774955150_p
w(6)=3.281567643349413_p
x(7)=1.457002730214176_p
w(7)=7.019750270008707e-1_p
x(8)=6.064791402993847_p
w(8)=1.307101392470141e-2_p
x(9)=13.07095675095404_p
w(9)=1.842224395594695e-5_p
else if(N==10)then
x(1)=-19.61936295257706_p
w(1)=9.723224462075633e-1_p
x(2)=-18.03378811048504_p
w(2)=2.174550524815703_p
x(3)=-15.33898296080261_p
w(3)=3.171508733959779_p
x(4)=-11.79464350485948_p
w(4)=3.857176559312401_p
x(5)=-7.760861367347961_p
w(5)=4.131055079603560_p
x(6)=-3.714936454760956_p
w(6)=3.754039172164878_p
x(7)=-2.232952942485278e-1_p
w(7)=1.796768722132474_p
x(8)=3.363656752439703_p
w(8)=1.412810800221870e-1_p
x(9)=8.435354214985392_p
w(9)=1.296203408022923e-3_p
x(10)=15.56100637667609_p
w(10)=1.480155638128594e-6_p
else if(N==11)then
x(1)=-19.67280247259546_p
w(1)=8.364465979317101e-1_p
x(2)=-18.3043473242147_p
w(2)=1.883066418121753_p
x(3)=-15.95637331989784_p
w(3)=2.781231415925285_p
x(4)=-12.81771866185158_p
w(4)=3.452134340656135_p
x(5)=-9.151804176010371_p
w(5)=3.823125365746579_p
x(6)=-5.300476469084129_p
w(6)=3.782582046585039_p
x(7)=-1.731304408744030_p
w(7)=2.774754986770972_p
x(8)=1.427605204025430_p
w(8)=6.451352160594794e-1_p
x(9)=5.367176561009999_p
w(9)=2.138321493547789e-2_p
x(10)=10.67094618661861_p
w(10)=1.402119111785643e-4_p
x(11)=17.50684858070268_p
w(11)=1.871385976998735e-7_p
else if(N==12)then
x(1)=-19.71580039036293_p
w(1)=7.269545895257291e-1_p
x(2)=-18.52346372050761_p
w(2)=1.644967622668130_p
x(3)=-16.46262114750511_p
w(3)=2.453220542671749_p
x(4)=-13.67351798196781_p
w(4)=3.092158012285488_p
x(5)=-10.35283267167456_p
w(5)=3.507292639899636_p
x(6)=-6.753224388852255_p
w(6)=3.633166596603312_p
x(7)=-3.211333800129561_p
w(7)=3.235966674098642_p
x(8)=-1.002197810829954e-1_p
w(8)=1.547620173281345_p
x(9)=3.118191062399255_p
w(9)=1.555516319931345e-1_p
x(10)=7.344053962640110_p
w(10)=3.082906010231813e-3_p
x(11)=12.66222390433527_p
w(11)=1.857362651827236e-5_p
x(12)=18.8715758046409_p
w(12)=3.911829199300319e-8_p
else if(N==13)then
x(1)=-19.75090177906914_p
w(1)=6.374656563925521e-1_p
x(2)=-18.70324738705103_p
w(2)=1.448313428629719_p
x(3)=-16.88199116057854_p
w(3)=2.176421483415263_p
x(4)=-14.39326505539489_p
w(4)=2.776069165189409_p
x(5)=-11.38658591462191_p
w(5)=3.205471829736660_p
x(6)=-8.053303571610938_p
w(6)=3.420014135834059_p
x(7)=-4.638466499441175_p
w(7)=3.319107617525636_p
x(8)=-1.478095056983193_p
w(8)=2.387485330488885_p
x(9)=1.398253513109884_p
w(9)=5.988516886231768e-1_p
x(10)=4.853106444984806_p
w(10)=3.031652309800674e-2_p
x(11)=9.205100389685290_p
w(11)=4.799529846620930e-4_p
x(12)=14.36118747377784_p
w(12)=3.177453767299808e-6_p
x(13)=19.7771906345257_p
w(13)=1.241040943153845e-8_p
else if(N==14)then
x(1)=-19.7799082424834_p
w(1)=5.634465336751361e-1_p
x(2)=-18.85241032320949_p
w(2)=1.284304287343821_p
x(3)=-17.2325645634171_p
w(3)=1.941706792910054_p
x(4)=-15.00205234853102_p
w(4)=2.500030360861252_p
x(5)=-12.2763943779306_p
w(5)=2.926690296599971_p
x(6)=-9.203308555929105_p
w(6)=3.188785560456777_p
x(7)=-5.967298703279813_p
w(7)=3.234173684391610_p
x(8)=-2.818037008828542_p
w(8)=2.830037326441912_p
x(9)=-5.057649275904692e-3_p
w(9)=1.357633872035807_p
x(10)=2.914242110122037_p
w(10)=1.674170434610417e-1_p
x(11)=6.557701974625922_p
w(11)=5.687745031842424e-3_p
x(12)=10.90036045953338_p
w(12)=8.578357469617837e-5_p
x(13)=15.76373422486819_p
w(13)=7.096836232472925e-7_p
x(14)=20.37261417630114_p
w(14)=5.314663254661571e-9_p
else if(N==15)then
x(1)=-19.80414251941559_p
w(1)=5.015587932940595e-1_p
x(2)=-18.97743513368265_p
w(2)=1.146264227766593_p
x(3)=-17.52818305107089_p
w(3)=1.741550985860308_p
x(4)=-15.52020781345054_p
w(4)=2.259278551229842_p
x(5)=-13.04407661016339_p
w(5)=2.673677135379812_p
x(6)=-10.21565252544636_p
w(6)=2.959432282434733_p
x(7)=-7.177707724153611_p
w(7)=3.084133446544831_p
x(8)=-4.114207778713973_p
w(8)=2.948513109253773_p
x(9)=-1.273624352500067_p
w(9)=2.084194173772767_p
x(10)=1.368181991936445_p
w(10)=5.608545065355984e-1_p
x(11)=4.452040483473267_p
w(11)=3.939654656315118e-2_p
x(12)=8.173768099596760_p
w(12)=1.127910935166661e-3_p
x(13)=12.40615048897685_p
w(13)=1.812593750680518e-5_p
x(14)=16.8947646362273_p
w(14)=2.034811395664841e-7_p
x(15)=20.77090615969408_p
w(15)=2.792926319267180e-9_p
else if(N==16)then
x(1)=-19.8245918836999_p
w(1)=4.493047254415968e-1_p
x(2)=-19.08321141562678_p
w(2)=1.029082550892421_p
x(3)=-17.77951616468243_p
w(3)=1.569841489583614_p
x(4)=-15.9640549413842_p
w(4)=2.049069566580029_p
x(5)=-13.70877335820648_p
w(5)=2.446133646759729_p
x(6)=-11.10580598289985_p
w(6)=2.741045180928615_p
x(7)=-8.267884175408806_p
w(7)=2.911085218368354_p
x(8)=-5.334958818234671_p
w(8)=2.908614418972974_p
x(9)=-2.498916826174212_p
w(9)=2.503134917769671_p
x(10)=7.313386970475168e-2_p
w(10)=1.206929103399413_p
x(11)=2.745795634680888_p
w(11)=1.765494468630752e-1_p
x(12)=5.960638160660376_p
w(12)=8.957772868167440e-3_p
x(13)=9.668053635238358_p
w(13)=2.473196627135160e-4_p
x(14)=13.7177120387453_p
w(14)=4.569470315198525e-6_p
x(15)=17.79423858258137_p
w(15)=7.253455955774043e-8_p
x(16)=21.04492403798857_p
w(16)=1.686959292535598e-9_p
else if(N==17)then
x(1)=-19.84200299728349_p
w(1)=4.047917597456680e-1_p
x(2)=-19.17346797516717_p
w(2)=9.288166764649934e-1_p
x(3)=-17.9948388979783_p
w(3)=1.421652414311490_p
x(4)=-16.34664501096131_p
w(4)=1.865079818013884_p
x(5)=-14.28672433945753_p
w(5)=2.242394705428906_p
x(6)=-11.8892369321609_p
w(6)=2.537527661027209_p
x(7)=-9.244592277109930_p
w(7)=2.733389124746862_p
x(8)=-6.462487531678826_p
w(8)=2.802949682600517_p
x(9)=-3.686193897107301_p
w(9)=2.644850027475223_p
x(10)=-1.102605364974959_p
w(10)=1.840399331318301_p
x(11)=1.341222632853939_p
w(11)=5.278450684401701e-1_p
x(12)=4.131492041498641_p
w(12)=4.811941038249285e-2_p
x(13)=7.398546559894493_p
w(13)=2.121669423149126e-3_p
x(14)=11.02461937265658_p
w(14)=6.125213396371896e-5_p
x(15)=14.84363397678301_p
w(15)=1.368161395601039e-6_p
x(16)=18.5056073038781_p
w(16)=3.098572692807503e-8_p
x(17)=21.23924902841591_p
w(17)=1.122253926847671e-9_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;22kT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.8020138190198_p
w(1)=9.919648056256293_p
x(2)=-3.526768414124466_p
w(2)=9.080351949067557_p
else if(N==3)then
x(1)=-16.66602169807133_p
w(1)=5.749159896543703_p
x(2)=-8.682923736644142_p
w(2)=9.091369862620390_p
x(3)=-9.856474619987809e-1_p
w(3)=4.159470246159757_p
else if(N==4)then
x(1)=-17.49427737410583_p
w(1)=3.770227371700108_p
x(2)=-11.85930784988904_p
w(2)=7.027557839048336_p
x(3)=-4.631466826402962_p
w(3)=6.664637450857845_p
x(4)=8.528718685459646e-1_p
w(4)=1.537577343717560_p
else if(N==5)then
x(1)=-17.9325910773835_p
w(1)=2.694546745033194_p
x(2)=-13.75866990337473_p
w(2)=5.420002685816200_p
x(3)=-7.703229391230561_p
w(3)=6.322841954924367_p
x(4)=-1.942189896714392_p
w(4)=4.225581657852006_p
x(5)=2.819806099825689_p
w(5)=3.370269616980838e-1_p
else if(N==6)then
x(1)=-18.19360656848311_p
w(1)=2.045093380106279_p
x(2)=-14.96112652024358_p
w(2)=4.290434727500916_p
x(3)=-9.960267613953143_p
w(3)=5.499240428740802_p
x(4)=-4.457554075042034_p
w(4)=5.154190385432986_p
x(5)=4.365522363735618e-2_p
w(5)=1.971402093411478_p
x(6)=5.177270832033103_p
w(6)=3.963899013138886e-2_p
else if(N==7)then
x(1)=-18.36272978254815_p
w(1)=1.620861162119023_p
x(2)=-15.76846136265975_p
w(2)=3.489485827355584_p
x(3)=-11.5975703724821_p
w(3)=4.719968007941977_p
x(4)=-6.638484339377109_p
w(4)=5.011791976257763_p
x(5)=-1.983232141775143_p
w(5)=3.604326943099198_p
x(6)=1.938594003012076_p
w(6)=5.504996419463446e-1_p
x(7)=7.851870183083435_p
w(7)=3.066446603960128e-3_p
else if(N==8)then
x(1)=-18.47972609666611_p
w(1)=1.325848308975069_p
x(2)=-16.33982835199989_p
w(2)=2.903625549186688_p
x(3)=-12.81200992578471_p
w(3)=4.064716899514035_p
x(4)=-8.416398550111248_p
w(4)=4.606732221694911_p
x(5)=-3.877114524573452_p
w(5)=4.214271149772408_p
x(6)=-3.704023701103628e-2_p
w(6)=1.800531952721135_p
x(7)=4.092722412569691_p
w(7)=8.408104007493097e-2_p
x(8)=10.69002404224681_p
w(8)=1.928833846727463e-4_p
else if(N==9)then
x(1)=-18.56527782059861_p
w(1)=1.109342443924915_p
x(2)=-16.76425216866711_p
w(2)=2.458775514102588_p
x(3)=-13.74289318285109_p
w(3)=3.523932033155578_p
x(4)=-9.859001271855439_p
w(4)=4.161310799369384_p
x(5)=-5.610126381593249_p
w(5)=4.208304939847591_p
x(6)=-1.674574502969966_p
w(6)=2.986957524568164_p
x(7)=1.785500915245043_p
w(7)=5.424902538377767e-1_p
x(8)=6.460388835249647_p
w(8)=8.874276515854094e-3_p
x(9)=13.47763271073873_p
w(9)=1.222000199985943e-5_p
else if(N==10)then
x(1)=-18.6307485206648_p
w(1)=9.432167883108953e-1_p
x(2)=-17.09279645333847_p
w(2)=2.109003059919476_p
x(3)=-14.47982312813118_p
w(3)=3.074392349898619_p
x(4)=-11.0456900547835_p
w(4)=3.734948542588773_p
x(5)=-7.144486997746439_p
w(5)=3.986796484200475_p
x(6)=-3.253884556729067_p
w(6)=3.541714493741844_p
x(7)=1.094862714573214e-1_p
w(7)=1.509105342115126_p
x(8)=3.734824779097889_p
w(8)=9.995567836156131e-2_p
x(9)=8.838612749054933_p
w(9)=8.662448571704089e-4_p
x(10)=15.91530051549325_p
w(10)=1.021329910208599e-6_p
else if(N==11)then
x(1)=-18.68244469451539_p
w(1)=8.117816813790549e-1_p
x(2)=-17.35445660208509_p
w(2)=1.827214708757361_p
x(3)=-15.07654586376987_p
w(3)=2.697680342734035_p
x(4)=-12.03330352981007_p
w(4)=3.345702497965386_p
x(5)=-8.483315171653471_p
w(5)=3.697796613403596_p
x(6)=-4.766795644912697_p
w(6)=3.624422422963566_p
x(7)=-1.347325166511595_p
w(7)=2.490376753490685_p
x(8)=1.773924976887263_p
w(8)=4.904000376326228e-1_p
x(9)=5.760011286170323_p
w(9)=1.453006068295730e-2_p
x(10)=11.05599337466079_p
w(10)=9.474828359601372e-5_p
x(11)=17.77918419502565_p
w(11)=1.380309885631827e-7_p
else if(N==12)then
x(1)=-18.72407286698791_p
w(1)=7.057830628401747e-1_p
x(2)=-17.56654436233541_p
w(2)=1.596825165344962_p
x(3)=-15.56631722805176_p
w(3)=2.380668637953763_p
x(4)=-12.8604764218247_p
w(4)=2.998841740519441_p
x(5)=-9.641878752918943_p
w(5)=3.396844366396516_p
x(6)=-6.160627304248385_p
w(6)=3.502991405260644_p
x(7)=-2.756453231379138_p
w(7)=3.028531137485156_p
x(8)=2.482323986572879e-1_p
w(8)=1.277910262570362_p
x(9)=3.494309963624048_p
w(9)=1.095138992461381e-1_p
x(10)=7.736618042430163_p
w(10)=2.077391458115597e-3_p
x(11)=13.01247245355854_p
w(11)=1.290539870978925e-5_p
x(12)=19.06540938920356_p
w(12)=3.084986786304186e-8_p
else if(N==13)then
x(1)=-18.75807218292778_p
w(1)=6.191075123356250e-1_p
x(2)=-17.74065016350369_p
w(2)=1.406430481939555_p
x(3)=-15.97228186379951_p
w(3)=2.112933873360410_p
x(4)=-13.55670553550825_p
w(4)=2.693770196009943_p
x(5)=-10.64042813070475_p
w(5)=3.107409138732246_p
x(6)=-7.412191872225701_p
w(6)=3.306969951767799_p
x(7)=-4.118231703081835_p
w(7)=3.168699006289713_p
x(8)=-1.087997093456230_p
w(8)=2.113930008046727_p
x(9)=1.757165522376009_p
w(9)=4.498049908974050e-1_p
x(10)=5.244223191770935_p
w(10)=2.061614396901283e-2_p
x(11)=9.582568851406272_p
w(11)=3.264010418682672e-4_p
x(12)=14.66807448111622_p
w(12)=2.290611872770833e-6_p
x(13)=19.91179618942436_p
w(13)=1.032167427261060e-8_p
else if(N==14)then
x(1)=-18.78617962561564_p
w(1)=5.473851258405282e-1_p
x(2)=-17.88516672753695_p
w(2)=1.247564146323800_p
x(3)=-16.31182349321771_p
w(3)=1.885753260075789_p
x(4)=-14.14598884277772_p
w(4)=2.427032440059091_p
x(5)=-11.50080270429578_p
w(5)=2.839142852314267_p
x(6)=-8.521640139858679_p
w(6)=3.088341128894580_p
x(7)=-5.392562775084929_p
w(7)=3.113618211746108_p
x(8)=-2.366675137291058_p
w(8)=2.625470209695228_p
x(9)=3.568060024292434e-1_p
w(9)=1.104459169117295_p
x(10)=3.295640584445353_p
w(10)=1.173340672112438e-1_p
x(11)=6.947422578436104_p
w(11)=3.839353124441672e-3_p
x(12)=11.25309126749492_p
w(12)=5.950397101285128e-5_p
x(13)=16.02522951707747_p
w(13)=5.323577826024963e-7_p
x(14)=20.46691997566352_p
w(14)=4.592681506904955e-9_p
else if(N==15)then
x(1)=-18.80967210164715_p
w(1)=4.873935990447004e-1_p
x(2)=-18.00634802333183_p
w(2)=1.113791808298731_p
x(3)=-16.59827525972828_p
w(3)=1.691907688748972_p
x(4)=-14.64783599846913_p
w(4)=2.194170536157544_p
x(5)=-12.24369973788391_p
w(5)=2.595135806618895_p
x(6)=-9.499720776112126_p
w(6)=2.869204733697558_p
x(7)=-6.557547684043884_p
w(7)=2.980455870259055_p
x(8)=-3.603728681426592_p
w(8)=2.802127415708036_p
x(9)=-8.770396982118328e-1_p
w(9)=1.821236180183221_p
x(10)=1.738024010945869_p
w(10)=4.170421361799501e-1_p
x(11)=4.844408823952499_p
w(11)=2.675423437073852e-2_p
x(12)=8.550854652253562_p
w(12)=7.669307934339106e-4_p
x(13)=12.72851354953667_p
w(13)=1.290419228621550e-5_p
x(14)=17.11355393805538_p
w(14)=1.585916363507631e-7_p
x(15)=20.83858304884284_p
w(15)=2.479092883783575e-9_p
else if(N==16)then
x(1)=-18.8295028518488_p
w(1)=4.367216166726567e-1_p
x(2)=-18.10891246751508_p
w(2)=1.000185674804283_p
x(3)=-16.84192007125951_p
w(3)=1.525524824664037_p
x(4)=-15.07793472311056_p
w(4)=1.990691699253258_p
x(5)=-12.88737588824366_p
w(5)=2.375351964737867_p
x(6)=-10.36068606088835_p
w(6)=2.659467009901841_p
x(7)=-7.609294886420250_p
w(7)=2.818837554914170_p
x(8)=-4.774016554341045_p
w(8)=2.794339466458851_p
x(9)=-2.049272474327301_p
w(9)=2.300572473325504_p
x(10)=4.466188288827239e-1_p
w(10)=9.688920070719232e-1_p
x(11)=3.132627581767568_p
w(11)=1.232008612719467e-1_p
x(12)=6.350887265204810_p
w(12)=6.040615800423123e-3_p
x(13)=10.02533363012088_p
w(13)=1.708279413898746e-4_p
x(14)=14.0073716991193_p
w(14)=3.348478744626060e-6_p
x(15)=17.97559302376345_p
w(15)=5.850100583441417e-8_p
x(16)=21.09488664000773_p
w(16)=1.525949316468119e-9_p
else if(N==17)then
x(1)=-18.84639298359512_p
w(1)=3.935415770448466e-1_p
x(2)=-18.19645950567125_p
w(2)=9.029425585593411e-1_p
x(3)=-17.05073727353505_p
w(3)=1.381866781516981_p
x(4)=-15.44884187911278_p
w(4)=1.812476826910981_p
x(5)=-13.44737278151497_p
w(5)=2.178333456874720_p
x(6)=-11.11907262899242_p
w(6)=2.463418160974076_p
x(7)=-8.553083041821480_p
w(7)=2.649987816020275_p
x(8)=-5.858977586869746_p
w(8)=2.706210397785685_p
x(9)=-3.183099200689600_p
w(9)=2.500092186740470_p
x(10)=-6.997576843169676e-1_p
w(10)=1.587898189876300_p
x(11)=1.720485782946698_p
w(11)=3.891381745401274e-1_p
x(12)=4.526273386089671_p
w(12)=3.261031150290228e-2_p
x(13)=7.777644283679495_p
w(13)=1.439318997747456e-3_p
x(14)=11.35784169666637_p
w(14)=4.318880071978485e-5_p
x(15)=15.10076991645337_p
w(15)=1.032417549017051e-6_p
x(16)=18.6555903445313_p
w(16)=2.573210859121501e-8_p
x(17)=21.27716744832927_p
w(17)=1.029019440086672e-9_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;22kT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466036734442_p
w(1)=9.439548858195499_p
x(2)=-3.289241411854182_p
w(2)=8.560451156755533_p
else if(N==3)then
x(1)=-15.77082969743196_p
w(1)=5.490612363814233_p
x(2)=-8.150660920242599_p
w(2)=8.668234871066851_p
x(3)=-8.100980803640809e-1_p
w(3)=3.841152780069948_p
else if(N==4)then
x(1)=-16.5571016913409_p
w(1)=3.612720891852920_p
x(2)=-11.15925948061398_p
w(2)=6.728668248752031_p
x(3)=-4.252908438162532_p
w(3)=6.315428754074364_p
x(4)=1.047524475108654_p
w(4)=1.343182120271718_p
else if(N==5)then
x(1)=-16.97407704149457_p
w(1)=2.589693475018141_p
x(2)=-12.96359772353931_p
w(2)=5.206077216967633_p
x(3)=-7.153148441818947_p
w(3)=6.054163894461873_p
x(4)=-1.655064206291376_p
w(4)=3.882597376931514_p
x(5)=3.082095441567611_p
w(5)=2.674680515718733e-1_p
else if(N==6)then
x(1)=-17.22293178727426_p
w(1)=1.970633657187636_p
x(2)=-14.10882634108131_p
w(2)=4.132242624670039_p
x(3)=-9.295624893713793_p
w(3)=5.287446001519961_p
x(4)=-4.020402479860810_p
w(4)=4.886107489185426_p
x(5)=3.079834799546550e-1_p
w(5)=1.694845718375716_p
x(6)=5.513242868035158_p
w(6)=2.872452401225514e-2_p
else if(N==7)then
x(1)=-17.38455602795322_p
w(1)=1.565283889102524_p
x(2)=-14.87972372915814_p
w(2)=3.368450925991285_p
x(3)=-10.85557820244857_p
w(3)=4.550802153634591_p
x(4)=-6.082309488104136_p
w(4)=4.806036147916384_p
x(5)=-1.634220978664264_p
w(5)=3.281685536045585_p
x(6)=2.249479107509790_p
w(6)=4.256542898383536e-1_p
x(7)=8.243727566848923_p
w(7)=2.087072422311295e-3_p
else if(N==8)then
x(1)=-17.4966910735157_p
w(1)=1.282569279160407_p
x(2)=-15.42699038808427_p
w(2)=2.807856652699016_p
x(3)=-12.01692724982418_p
w(3)=3.927055616999027_p
x(4)=-7.774826275494534_p
w(4)=4.437924012582727_p
x(5)=-3.418300948657763_p
w(5)=3.975084367056162_p
x(6)=2.785273764783037e-1_p
w(6)=1.510372985115092_p
x(7)=4.467114245375429_p
w(7)=5.901041234541626e-2_p
x(8)=11.11290407505393_p
w(8)=1.266889931857576e-4_p
else if(N==9)then
x(1)=-17.57897783102183_p
w(1)=1.074349043791793_p
x(2)=-15.83501055705957_p
w(2)=2.380513516529552_p
x(3)=-12.91077956015837_p
w(3)=3.409327604538140_p
x(4)=-9.156080841067043_p
w(4)=4.018572603984309_p
x(5)=-5.062457963063818_p
w(5)=4.028956047407684_p
x(6)=-1.299660145756670_p
w(6)=2.674604065683061_p
x(7)=2.132363030367707_p
w(7)=4.077397067364423e-1_p
x(8)=6.870418574009127_p
w(8)=5.929377995315573e-3_p
x(9)=13.8896639233082_p
w(9)=8.048284735807289e-6_p
else if(N==10)then
x(1)=-17.64213983192936_p
w(1)=9.140951524693522e-1_p
x(2)=-16.1518464377855_p
w(2)=2.043391500531465_p
x(3)=-13.62082504166971_p
w(3)=2.977076018279170_p
x(4)=-10.29725925465582_p
w(4)=3.612088681707932_p
x(5)=-6.529822350460883_p
w(5)=3.839360894505598_p
x(6)=-2.797318728157214_p
w(6)=3.309315483505475_p
x(7)=4.517354613441970e-1_p
w(7)=1.234897255145725_p
x(8)=4.122978252260851_p
w(8)=6.920147679289357e-2_p
x(9)=9.251009284822372_p
w(9)=5.728469276879281e-4_p
x(10)=16.26614457436015_p
w(10)=7.050857351326560e-7_p
else if(N==11)then
x(1)=-17.69209555466039_p
w(1)=7.870937691437139e-1_p
x(2)=-16.40461896054835_p
w(2)=1.771291628315528_p
x(3)=-14.19688785352352_p
w(3)=2.613952932459883_p
x(4)=-11.24934285545_p
w(4)=3.238821421910531_p
x(5)=-7.816052204876457_p
w(5)=3.570867108830692_p
x(6)=-4.236691340780685_p
w(6)=3.455748499341170_p
x(7)=-9.641156116528674e-1_p
w(7)=2.190231834521349_p
x(8)=2.137456141712710_p
w(8)=3.621982403658964e-1_p
x(9)=6.165197490245375_p
w(9)=9.730839688094038e-3_p
x(10)=11.44557819745455_p
w(10)=6.363809512324057e-5_p
x(11)=18.04371595753958_p
w(11)=1.022790524821314e-7_p
else if(N==12)then
x(1)=-17.73235295968079_p
w(1)=6.845913899559574e-1_p
x(2)=-16.60967059442503_p
w(2)=1.548622984959122_p
x(3)=-14.6701530020403_p
w(3)=2.307978109528766_p
x(4)=-12.04778928186504_p
w(4)=2.905202935989852_p
x(5)=-8.931800898446427_p
w(5)=3.285470224743358_p
x(6)=-5.570413938718804_p
w(6)=3.368053329351100_p
x(7)=-2.306189389812679_p
w(7)=2.798416932696679_p
x(8)=6.067180518366824e-1_p
w(8)=1.024807592706660_p
x(9)=3.886229426417672_p
w(9)=7.546151790656686e-2_p
x(10)=8.137565145479270_p
w(10)=1.386029349737077e-3_p
x(11)=13.36366213049875_p
w(11)=8.943311644801864e-6_p
x(12)=19.25159215283278_p
w(12)=2.445158965874159e-8_p
else if(N==13)then
x(1)=-17.76524901883798_p
w(1)=6.007324116168321e-1_p
x(2)=-16.77809089487468_p
w(2)=1.364498552937210_p
x(3)=-15.06268609990558_p
w(3)=2.049336943309048_p
x(4)=-12.7204240867899_p
w(4)=2.611231786587119_p
x(5)=-9.894918640576684_p
w(5)=3.008750139064260_p
x(6)=-6.772690682680703_p
w(6)=3.191612565428370_p
x(7)=-3.602096060916745_p
w(7)=3.004547856887479_p
x(8)=-6.975396126294146e-1_p
w(8)=1.827278823136555_p
x(9)=2.132576130133602_p
w(9)=3.279690382299076e-1_p
x(10)=5.647055872754827_p
w(10)=1.381971540320375e-2_p
x(11)=9.965189040352845_p
w(11)=2.205227990308218e-4_p
x(12)=14.97341004077661_p
w(12)=1.650933885596678e-6_p
x(13)=20.04055333838911_p
w(13)=8.618132970631322e-9_p
else if(N==14)then
x(1)=-17.7924565936634_p
w(1)=5.313090435790624e-1_p
x(2)=-16.91795562906053_p
w(2)=1.210782683983357_p
x(3)=-15.39117739175388_p
w(3)=1.829710937375076_p
x(4)=-13.29015050246376_p
w(4)=2.353849956694320_p
x(5)=-10.72571114684353_p
w(5)=2.751180156274416_p
x(6)=-7.841117694414799_p
w(6)=2.986624760769173_p
x(7)=-4.820717445064241_p
w(7)=2.986388681339190_p
x(8)=-1.919621209826230_p
w(8)=2.396807763481720_p
x(9)=7.291166235038917e-1_p
w(9)=8.702686485184471e-1_p
x(10)=3.692058673324448_p
w(10)=8.046972783965860e-2_p
x(11)=7.345360343283437_p
w(11)=2.566139440771104e-3_p
x(12)=11.60837191109125_p
w(12)=4.111184738458715e-5_p
x(13)=16.28377460290804_p
w(13)=3.998291529441516e-7_p
x(14)=20.55713473535165_p
w(14)=3.979304485945190e-9_p
else if(N==15)then
x(1)=-17.81520663150432_p
w(1)=4.732154447576230e-1_p
x(2)=-17.03528933181051_p
w(2)=1.081283753035456_p
x(3)=-15.66844874671937_p
w(3)=1.642190490565174_p
x(4)=-13.7756512877567_p
w(4)=2.128915858233075_p
x(5)=-11.44372171242575_p
w(5)=2.516288872232187_p
x(6)=-8.784645003919850_p
w(6)=2.778192383035309_p
x(7)=-5.939391736137825_p
w(7)=2.873510420454175_p
x(8)=-3.097689837971726_p
w(8)=2.638959763163655_p
x(9)=-4.790550398953927e-1_p
w(9)=1.548207807989200_p
x(10)=2.123657088456333_p
w(10)=3.007992067196151e-1_p
x(11)=5.248056838040791_p
w(11)=1.790880939759224e-2_p
x(12)=8.933408155623820_p
w(12)=5.179109088219364e-4_p
x(13)=13.05145721782149_p
w(13)=9.168419316202280e-6_p
x(14)=17.32887444986547_p
w(14)=1.238356690260258e-7_p
x(15)=20.90345771623321_p
w(15)=2.204165217534499e-9_p
else if(N==16)then
x(1)=-17.83441824267996_p
w(1)=4.241269531727581e-1_p
x(2)=-17.13463864415234_p
w(2)=9.712576723361279e-1_p
x(3)=-15.90439451024711_p
w(3)=1.481145596734576_p
x(4)=-14.19197278434146_p
w(4)=1.932194558965630_p
x(5)=-12.06630440005238_p
w(5)=2.304336259673816_p
x(6)=-9.616230272339918_p
w(6)=2.577359652914772_p
x(7)=-6.952144800497605_p
w(7)=2.724842090104838_p
x(8)=-4.216426223867233_p
w(8)=2.671215733102654_p
x(9)=-1.603443294033382_p
w(9)=2.073574402629406_p
x(10)=8.307563853716189e-1_p
w(10)=7.516862244840601e-1_p
x(11)=3.533788225352811_p
w(11)=8.410781104809617e-2_p
x(12)=6.749224760464191_p
w(12)=4.033108889513848e-3_p
x(13)=10.38591743266017_p
w(13)=1.174499960654987e-4_p
x(14)=14.29625107680275_p
w(14)=2.452241450272450e-6_p
x(15)=18.15352216824557_p
w(15)=4.727564916226888e-8_p
x(16)=21.14291399528628_p
w(16)=1.381620172692370e-9_p
else if(N==17)then
x(1)=-17.8507869399682_p
w(1)=3.822810445412492e-1_p
x(2)=-17.2194733839228_p
w(2)=8.770410357908347e-1_p
x(3)=-16.10669741201768_p
w(3)=1.342027523045543_p
x(4)=-14.55117438591491_p
w(4)=1.759775070864355_p
x(5)=-12.60829265315371_p
w(5)=2.114087606267150_p
x(6)=-10.34943879056891_p
w(6)=2.388928178601510_p
x(7)=-7.862650770762573_p
w(7)=2.565550092786635_p
x(8)=-5.257860662548736_p
w(8)=2.605002973971686_p
x(9)=-2.684602512644140_p
w(9)=2.335930211944107_p
x(10)=-2.945786090471949e-1_p
w(10)=1.328503617730317_p
x(11)=2.114848439791430_p
w(11)=2.780917904113351e-1_p
x(12)=4.931973515716273_p
w(12)=2.178017338932764e-2_p
x(13)=8.162378998385085_p
w(13)=9.695302403307984e-4_p
x(14)=11.69270165796095_p
w(14)=3.036373793430702e-5_p
x(15)=15.35628792212775_p
w(15)=7.792771790481378e-7_p
x(16)=18.80247336826908_p
w(16)=2.140756185476120e-8_p
x(17)=21.31372272370882_p
w(17)=9.439755037456528e-10_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;22kT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.20653106046293_p
w(1)=8.961195853438390_p
x(2)=-3.048806107876800_p
w(2)=8.038804187682040_p
else if(N==3)then
x(1)=-14.8750770087799_p
w(1)=5.233410132037632_p
x(2)=-7.616419018890787_p
w(2)=8.245051419540861_p
x(3)=-6.275443290502051e-1_p
w(3)=3.521538489541937_p
else if(N==4)then
x(1)=-15.6195527188367_p
w(1)=3.456129019831799_p
x(2)=-10.45766088454077_p
w(2)=6.430828309897813_p
x(3)=-3.872966389938474_p
w(3)=5.957224420008229_p
x(4)=1.255971100353305_p
w(4)=1.155818291382587_p
else if(N==5)then
x(1)=-16.01531904835925_p
w(1)=2.485443704712371_p
x(2)=-12.16745087058299_p
w(2)=4.993042342167682_p
x(3)=-6.601751545159483_p
w(3)=5.783111114043296_p
x(4)=-1.364466315660846_p
w(4)=3.530647733167412_p
x(5)=3.363657956690478_p
w(5)=2.077551470296685e-1_p
else if(N==6)then
x(1)=-16.25210008922302_p
w(1)=1.896563885656765_p
x(2)=-13.25581698993455_p
w(2)=3.974676858010443_p
x(3)=-8.629910462665691_p
w(3)=5.075207540630083_p
x(4)=-3.583884297990994_p
w(4)=4.604357578717516_p
x(5)=5.851596326726618e-1_p
w(5)=1.428804366448077_p
x(6)=5.868680006487847_p
w(6)=2.038981165754600e-2_p
else if(N==7)then
x(1)=-16.40628929718956_p
w(1)=1.509937779267629_p
x(2)=-13.99056454869992_p
w(2)=3.247791820886815_p
x(3)=-10.11292103834731_p
w(3)=4.381534676977703_p
x(4)=-5.526571592449366_p
w(4)=4.594660952422315_p
x(5)=-1.284006941737011_p
w(5)=2.944263127653128_p
x(6)=2.581235813943425_p
w(6)=3.204167533315314e-1_p
x(7)=8.653090306001200_p
w(7)=1.394930581308789e-3_p
else if(N==8)then
x(1)=-16.51361551931297_p
w(1)=1.239390035685091_p
x(2)=-14.51397767685153_p
w(2)=2.712227956438340_p
x(3)=-11.22162244133357_p
w(3)=3.789247465103645_p
x(4)=-7.133723196052206_p
w(4)=4.266786400696838_p
x(5)=-2.962659011586311_p
w(5)=3.716433119805804_p
x(6)=6.065260431954448e-1_p
w(6)=1.235337902002849_p
x(7)=4.861059372338502_p
w(7)=4.049509339344392e-2_p
x(8)=11.54868094710258_p
w(8)=8.206799441879403e-5_p
else if(N==9)then
x(1)=-16.59267338586865_p
w(1)=1.039364730488258_p
x(2)=-14.90576703357384_p
w(2)=2.302221392960879_p
x(3)=-12.07877642413904_p
w(3)=3.294475840438619_p
x(4)=-8.453832850896150_p
w(4)=3.874565686571935_p
x(5)=-4.517757657361316_p
w(5)=3.839645086863284_p
x(6)=-9.243784299113823e-1_p
w(6)=2.348135475099906_p
x(7)=2.499088033677825_p
w(7)=2.976868525664517e-1_p
x(8)=7.294678617720525_p
w(8)=3.899708050259598e-3_p
x(9)=14.3058075659149_p
w(9)=5.268080838220903e-6_p
else if(N==10)then
x(1)=-16.65354092891005_p
w(1)=8.849469916829755e-1_p
x(2)=-15.21096091767942_p
w(2)=1.977687429389904_p
x(3)=-12.76205418540105_p
w(3)=2.879496852907202_p
x(4)=-9.549516929114967_p
w(4)=3.488403928747778_p
x(5)=-5.917337876531148_p
w(5)=3.687462363678916_p
x(6)=-2.345421008412496_p
w(6)=3.053446875177340_p
x(7)=8.064819781670215e-1_p
w(7)=9.812751316090117e-1_p
x(8)=4.528112589608019_p
w(8)=4.690498385910822e-2_p
x(9)=9.672088291331297_p
w(9)=3.749965581855416e-4_p
x(10)=16.61222984585181_p
w(10)=4.875100083172712e-7_p
else if(N==11)then
x(1)=-16.70175767419682_p
w(1)=7.623759982181568e-1_p
x(2)=-15.45484940919266_p
w(2)=1.715278269803903_p
x(3)=-13.31744293498551_p
w(3)=2.530007048184702_p
x(4)=-10.46594623709716_p
w(4)=3.131375945180077_p
x(5)=-7.150314572328757_p
w(5)=3.441743481611187_p
x(6)=-3.710832452062275_p
w(6)=3.272844170344735_p
x(7)=-5.794201837545485e-1_p
w(7)=1.880140674777610_p
x(8)=2.519470228059323_p
w(8)=2.597665720549783e-1_p
x(9)=6.582457685372530_p
w(9)=6.425302230610435e-3_p
x(10)=11.83914705964112_p
w(10)=4.250253857945326e-5_p
x(11)=18.29982103331258_p
w(11)=7.617589116208868e-8_p
else if(N==12)then
x(1)=-16.74064270784162_p
w(1)=6.633742331022154e-1_p
x(2)=-15.65285405969586_p
w(2)=1.500346483731241_p
x(3)=-13.77416195597583_p
w(3)=2.235117399707066_p
x(4)=-11.23553779661141_p
w(4)=2.811164594072364_p
x(5)=-8.222803854791765_p
w(5)=3.172866938223919_p
x(6)=-4.983139126081412_p
w(6)=3.226332762654544_p
x(7)=-1.860265672220290_p
w(7)=2.543249340709916_p
x(8)=9.782702942356483e-1_p
w(8)=7.956941458442208e-1_p
x(9)=4.293837605893004_p
w(9)=5.093201346569576e-2_p
x(10)=8.546550535161945_p
w(10)=9.159261096308052e-4_p
x(11)=13.71524002746604_p
w(11)=6.184019894990534e-6_p
x(12)=19.43002457504013_p
w(12)=1.947972019378155e-8_p
else if(N==13)then
x(1)=-16.77243402990219_p
w(1)=5.823358019196723e-1_p
x(2)=-15.81557943400617_p
w(2)=1.322505437077750_p
x(3)=-14.1532316203871_p
w(3)=1.985605422949555_p
x(4)=-11.88448533466757_p
w(4)=2.528398091194955_p
x(5)=-9.150207773062757_p
w(5)=2.909319999981534_p
x(6)=-6.135191389230006_p
w(6)=3.072963047288018_p
x(7)=-3.090665783037758_p
w(7)=2.822221448798284_p
x(8)=-3.040497523961221e-1_p
w(8)=1.535236710421640_p
x(9)=2.525562797672246_p
w(9)=2.321279329786565e-1_p
x(10)=6.061265118679648_p
w(10)=9.136888321038624e-3_p
x(11)=10.35256976560894_p
w(11)=1.480628863074829e-4_p
x(12)=15.27673027379294_p
w(12)=1.190079597466964e-6_p
x(13)=20.16354726921019_p
w(13)=7.223422278589663e-9_p
else if(N==14)then
x(1)=-16.79874066027089_p
w(1)=5.152143416687592e-1_p
x(2)=-15.95078550771715_p
w(2)=1.173949509453013_p
x(3)=-14.47064971491671_p
w(3)=1.773559082734359_p
x(4)=-12.43459016310865_p
w(4)=2.280440417485816_p
x(5)=-9.951235094803117_p
w(5)=2.662690605287101_p
x(6)=-7.162017423256641_p
w(6)=2.883141893497699_p
x(7)=-4.252403229926325_p
w(7)=2.849624958799299_p
x(8)=-1.476138807224007_p
w(8)=2.143199391016741_p
x(9)=1.114801591962135_p
w(9)=6.623885380033478e-1_p
x(10)=4.103288689158628_p
w(10)=5.406380006249955e-2_p
x(11)=7.751167647403740_p
w(11)=1.698897510175830e-3_p
x(12)=11.96580641817673_p
w(12)=2.830140532524054e-5_p
x(13)=16.53903966562095_p
w(13)=3.007396853028778e-7_p
x(14)=20.64336542640577_p
w(14)=3.456608898554717e-9_p
else if(N==15)then
x(1)=-16.82074742437702_p
w(1)=4.590209072599948e-1_p
x(2)=-16.06426637688379_p
w(2)=1.048731171648032_p
x(3)=-14.73872346819027_p
w(3)=1.592382147657373_p
x(4)=-12.90369749920241_p
w(4)=2.063481150919142_p
x(5)=-10.64423379354478_p
w(5)=2.437059354607615_p
x(6)=-8.070627037058369_p
w(6)=2.686122729982257_p
x(7)=-5.323727053368052_p
w(7)=2.761800770834528_p
x(8)=-2.596542672384746_p
w(8)=2.454284338395525_p
x(9)=-7.670738818625522e-2_p
w(9)=1.274391382089773_p
x(10)=2.525996302337115_p
w(10)=2.105469720910762e-1_p
x(11)=5.662583783356770_p
w(11)=1.182505333034476e-2_p
x(12)=9.321083752165015_p
w(12)=3.474603921002776e-4_p
x(13)=13.37462246330605_p
w(13)=6.503058212331175e-6_p
x(14)=17.54052289534526_p
w(14)=9.689168896905241e-8_p
x(15)=20.96561479518085_p
w(15)=1.962766439428025e-9_p
else if(N==16)then
x(1)=-16.83933920194082_p
w(1)=4.115177569492119e-1_p
x(2)=-16.1603962835617_p
w(2)=9.422908966955483e-1_p
x(3)=-14.96695657018675_p
w(3)=1.436689313283912_p
x(4)=-13.30620589789949_p
w(4)=1.873551316544629_p
x(5)=-11.24563274643002_p
w(5)=2.233030311882307_p
x(6)=-8.872591713075751_p
w(6)=2.494558559911422_p
x(7)=-6.296785464660956_p
w(7)=2.628327136983712_p
x(8)=-3.662862574266368_p
w(8)=2.535557069889507_p
x(9)=-1.160232799214913_p
w(9)=1.823137310539179_p
x(10)=1.228324774266889_p
w(10)=5.623381957947512e-1_p
x(11)=3.949002813020750_p
w(11)=5.625265460352598e-2_p
x(12)=7.155284761431882_p
w(12)=2.667282178422511e-3_p
x(13)=10.74947395755783_p
w(13)=8.040111917003618e-5_p
x(14)=14.58405277759184_p
w(14)=1.795210851311373e-6_p
x(15)=18.327915608723_p
w(15)=3.828225895449644e-8_p
x(16)=21.18906548505541_p
w(16)=1.252022331666200e-9_p
else if(N==17)then
x(1)=-16.85518586854532_p
w(1)=3.710075601802517e-1_p
x(2)=-16.24251512740668_p
w(2)=8.511054898468504e-1_p
x(3)=-15.16273404994227_p
w(3)=1.302122333563637_p
x(4)=-13.65367372769904_p
w(4)=1.706952561779604_p
x(5)=-11.76954484075667_p
w(5)=2.049614314652320_p
x(6)=-9.580455339119101_p
w(6)=2.313949989479743_p
x(7)=-7.173552891090806_p
w(7)=2.479656876546195_p
x(8)=-4.659704432596203_p
w(8)=2.497209539611388_p
x(9)=-2.190916600392832_p
w(9)=2.147833863707465_p
x(10)=1.160770175547545e-1_p
w(10)=1.072695171762833_p
x(11)=2.525093062379280_p
w(11)=1.928321575569631e-1_p
x(12)=5.348144527013235_p
w(12)=1.434960594704649e-2_p
x(13)=8.552420964726350_p
w(13)=6.486790462358343e-4_p
x(14)=12.02889700409664_p
w(14)=2.129026294401730e-5_p
x(15)=15.6099585357648_p
w(15)=5.884686263004940e-7_p
x(16)=18.94620408937858_p
w(16)=1.784202216757394e-8_p
x(17)=21.34895510742874_p
w(17)=8.663038880034231e-10_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;22kT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.40753461035802_p
w(1)=8.484775108868986_p
x(2)=-2.804962861227463_p
w(2)=7.515225003387235_p
else if(N==3)then
x(1)=-13.97871833308583_p
w(1)=4.977654772503709_p
x(2)=-7.080128654699170_p
w(2)=7.821265124993064_p
x(3)=-4.368120781809328e-1_p
w(3)=3.201080214759448_p
else if(N==4)then
x(1)=-14.68161166169274_p
w(1)=3.300494065279834_p
x(2)=-9.754476681298534_p
w(2)=6.133921969739222_p
x(3)=-3.491678778027969_p
w(3)=5.588157384967101_p
x(4)=1.480165914264644_p
w(4)=9.774266922700643e-1_p
else if(N==5)then
x(1)=-15.05631145650779_p
w(1)=2.381809058811210_p
x(2)=-11.3702282082189_p
w(2)=4.780842073416135_p
x(3)=-6.049264755717735_p
w(3)=5.508432456126765_p
x(4)=-1.069185686635385_p
w(4)=3.171236256211099_p
x(5)=3.666047169807393_p
w(5)=1.576802676910132e-1_p
else if(N==6)then
x(1)=-15.28111262459726_p
w(1)=1.822879569720049_p
x(2)=-12.4021193691943_p
w(2)=3.817686533499714_p
x(3)=-7.963291282627353_p
w(3)=4.862035832248886_p
x(4)=-3.148346494972441_p
w(4)=4.305807448411801_p
x(5)=8.777546234027774e-1_p
w(5)=1.177425461407893_p
x(6)=6.244496533222227_p
w(6)=1.416526696787879e-2_p
else if(N==7)then
x(1)=-15.42793522762269_p
w(1)=1.454807502405797_p
x(2)=-13.10102159174383_p
w(2)=3.127451395669676_p
x(3)=-9.369750316017424_p
w(3)=4.211909579866441_p
x(4)=-4.971847189849298_p
w(4)=4.375322708749187_p
x(5)=-9.310075978067757e-1_p
w(5)=2.595155316036125_p
x(6)=2.935495203888884_p
w(6)=2.344384974952966e-1_p
x(7)=9.080404896146124_p
w(7)=9.151120336993471e-4_p
else if(N==8)then
x(1)=-15.53050759106236_p
w(1)=1.196289161420475_p
x(2)=-13.60083759364295_p
w(2)=2.616677996106338_p
x(3)=-10.42624275448795_p
w(3)=3.651118380567218_p
x(4)=-6.493544240179044_p
w(4)=4.092235993370380_p
x(5)=-2.510518870334501_p
w(5)=3.434774482147934_p
x(6)=9.500025080597320e-1_p
w(6)=9.816805737151691e-1_p
x(7)=5.274817352326525_p
w(7)=2.717107696259058e-2_p
x(8)=11.9968911749755_p
w(8)=5.244796611617286e-5_p
else if(N==9)then
x(1)=-15.60637159388287_p
w(1)=1.004370947319364_p
x(2)=-13.97656179792831_p
w(2)=2.223848802889552_p
x(3)=-11.24700073580656_p
w(3)=3.179256180204602_p
x(4)=-7.752574935835341_p
w(4)=3.728770919372928_p
x(5)=-3.976804746057402_p
w(5)=3.636711959619501_p
x(6)=-5.463824753636874e-1_p
w(6)=2.013545537618266_p
x(7)=2.886858455281783_p
w(7)=2.109669938607672e-1_p
x(8)=7.732885704287050_p
w(8)=2.525340558342859e-3_p
x(9)=14.72463332065717_p
w(9)=3.430812898699337e-6_p
else if(N==10)then
x(1)=-15.66495642518329_p
w(1)=8.557602255783735e-1_p
x(2)=-14.27016623610822_p
w(2)=1.911857563259970_p
x(3)=-11.90358769253355_p
w(3)=2.781576872075294_p
x(4)=-8.802666449456389_p
w(4)=3.363621896845221_p
x(5)=-5.307614584737793_p
w(5)=3.529199370155246_p
x(6)=-1.897922958529583_p
w(6)=2.771835789298705_p
x(7)=1.176829421989965_p
w(7)=7.547613263406351e-1_p
x(8)=4.950097306587395_p
w(8)=3.114362884078305e-2_p
x(9)=10.1013308505496_p
w(9)=2.431019197555813e-4_p
x(10)=16.95224213847517_p
w(10)=3.379422400993521e-7_p
else if(N==11)then
x(1)=-15.71143419360522_p
w(1)=7.376201219316121e-1_p
x(2)=-14.505166033984_p
w(2)=1.659151603294113_p
x(3)=-12.4382643749803_p
w(3)=2.445789455011707_p
x(4)=-9.683250888987859_p
w(4)=3.023206311298855_p
x(5)=-6.486486101683988_p
w(5)=3.309520549587359_p
x(6)=-3.189880888178145_p
w(6)=3.071102656352400_p
x(7)=-1.902370025981239e-1_p
w(7)=1.568483657865811_p
x(8)=2.920851152743061_p
w(8)=1.809126934406363e-1_p
x(9)=7.011471816349012_p
w(9)=4.184765816134865e-3_p
x(10)=12.23609715086843_p
w(10)=2.824060608955433e-5_p
x(11)=18.54695368715701_p
w(11)=5.705150388607265e-8_p
else if(N==12)then
x(1)=-15.74894462813731_p
w(1)=6.421249909521439e-1_p
x(2)=-14.69610915889783_p
w(2)=1.451977485146457_p
x(3)=-12.8783857692844_p
w(3)=2.162046325355400_p
x(4)=-10.42382462397914_p
w(4)=2.716621888865097_p
x(5)=-7.515152659828095_p
w(5)=3.058574173139813_p
x(6)=-4.399475667650397_p
w(6)=3.074905242852255_p
x(7)=-1.417746461900162_p
w(7)=2.262873952833575_p
x(8)=1.365811998024205_p
w(8)=5.965709891760436e-1_p
x(9)=4.716889167562183_p
w(9)=3.370108422153948e-2_p
x(10)=8.963189993972506_p
w(10)=5.996954489661448e-4_p
x(11)=14.06662432499126_p
w(11)=4.268665730851784e-6_p
x(12)=19.60065816143026_p
w(12)=1.559919879773465e-8_p
else if(N==13)then
x(1)=-15.77962937173621_p
w(1)=5.639120419494585e-1_p
x(2)=-14.853127986529_p
w(2)=1.280435929602971_p
x(3)=-13.24395296730941_p
w(3)=1.921707281969819_p
x(4)=-11.0489706567_p
w(4)=2.445194592286206_p
x(5)=-8.406489108261962_p
w(5)=2.808859491079603_p
x(6)=-5.500195751026285_p
w(6)=2.949515761321629_p
x(7)=-2.584397439023714_p
w(7)=2.616779403906468_p
x(8)=9.582737936295052e-2_p
w(8)=1.247956073390899_p
x(9)=2.936768934547911_p
w(9)=1.595785441860232e-1_p
x(10)=6.486476007092913_p
w(10)=5.961299601091632e-3_p
x(11)=10.74428593276888_p
w(11)=9.882855472434938e-5_p
x(12)=15.57756436370065_p
w(12)=8.583302070722660e-7_p
x(13)=20.28088269769116_p
w(13)=6.077122461102292e-9_p
else if(N==14)then
x(1)=-15.80503369022823_p
w(1)=4.990961494407520e-1_p
x(2)=-14.98366682888199_p
w(2)=1.137051729513402_p
x(3)=-13.55026953713901_p
w(3)=1.717271575464572_p
x(4)=-11.57937396652659_p
w(4)=2.206748064115863_p
x(5)=-9.177521886866506_p
w(5)=2.573513445892440_p
x(6)=-6.484698122678435_p
w(6)=2.777119339573210_p
x(7)=-3.688347467688430_p
w(7)=2.699353362686718_p
x(8)=-1.034667442830627_p
w(8)=1.867036276263369_p
x(9)=1.516521125257124_p
w(9)=4.860513895690363e-1_p
x(10)=4.528981616668203_p
w(10)=3.562462752556509e-2_p
x(11)=8.164470586627889_p
w(11)=1.114504029309708e-3_p
x(12)=12.32497578180938_p
w(12)=1.941857091695023e-5_p
x(13)=16.7907015134165_p
w(13)=2.266012297046121e-7_p
x(14)=20.72572420871303_p
w(14)=3.009838731897953e-9_p
else if(N==15)then
x(1)=-15.8262960962048_p
w(1)=4.448057722841069e-1_p
x(2)=-15.09328816364576_p
w(2)=1.016123067138140_p
x(3)=-13.80912408052315_p
w(3)=1.542461053573000_p
x(4)=-12.03202923412532_p
w(4)=1.997823182706386_p
x(5)=-9.845351641184338_p
w(5)=2.357339369288248_p
x(6)=-7.357928640110279_p
w(6)=2.592573163781579_p
x(7)=-4.711163498370557_p
w(7)=2.643051704272377_p
x(8)=-2.100409376552240_p
w(8)=2.243594348881643_p
x(9)=3.335334190505717e-1_p
w(9)=1.011099610046358_p
x(10)=2.945493230088085_p
w(10)=1.431851725238207e-1_p
x(11)=6.087560223751776_p
w(11)=7.707326311840018e-3_p
x(12)=9.713513712020037_p
w(12)=2.316576605010534e-4_p
x(13)=13.69763825580808_p
w(13)=4.606064219168943e-6_p
x(14)=17.74830670118209_p
w(14)=7.597367727827302e-8_p
x(15)=21.02513946373044_p
w(15)=1.750326205754258e-9_p
else if(N==16)then
x(1)=-15.8442671347947_p
w(1)=3.988903679088886e-1_p
x(2)=-15.18619317128319_p
w(2)=9.132759082494666e-1_p
x(3)=-14.02962731884853_p
w(3)=1.392137880862286_p
x(4)=-12.42067973435853_p
w(4)=1.814727537954377_p
x(5)=-10.42545397076888_p
w(5)=2.161357134525633_p
x(6)=-8.129967716036997_p
w(6)=2.410813821959309_p
x(7)=-5.643671287023485_p
w(7)=2.528074209492436_p
x(8)=-3.114015981043182_p
w(8)=2.382530145476991_p
x(9)=-7.175186058437208e-1_p
w(9)=1.554300691475912_p
x(10)=1.641705012806672_p
w(10)=4.051774188952047e-1_p
x(11)=4.377849314579634_p
w(11)=3.691077896919650e-2_p
x(12)=7.568685352492063_p
w(12)=1.748053625085002e-3_p
x(13)=11.11565496577154_p
w(13)=5.481662605408067e-5_p
x(14)=14.87047569134868_p
w(14)=1.314035135614868e-6_p
x(15)=18.49867250856254_p
w(15)=3.106479021802907e-8_p
x(16)=21.23339991947806_p
w(16)=1.135456309253781e-9_p
else if(N==17)then
x(1)=-15.8595909970439_p
w(1)=3.597179293105863e-1_p
x(2)=-15.26559150564531_p
w(2)=8.251277622749577e-1_p
x(3)=-14.21886532729819_p
w(3)=1.262135892419852_p
x(4)=-12.756378552314_p
w(4)=1.653981281848733_p
x(5)=-10.93120569202218_p
w(5)=1.984856007043317_p
x(6)=-8.812275771797466_p
w(6)=2.238324180506003_p
x(7)=-6.486124726353355_p
w(7)=2.391640329279174_p
x(8)=-4.065192706200000_p
w(8)=2.379688695546568_p
x(9)=-1.701737200273678_p
w(9)=1.932466534591894_p
x(10)=5.357738994789364e-1_p
w(10)=8.323274638466190e-1_p
x(11)=2.951520947073538_p
w(11)=1.299536739002958e-1_p
x(12)=5.774314496022124_p
w(12)=9.333785097042144e-3_p
x(13)=8.947425438827240_p
w(13)=4.312240393872729e-4_p
x(14)=12.36611445749871_p
w(14)=1.489220345684539e-5_p
x(15)=15.86155348624296_p
w(15)=4.446557230241424e-7_p
x(16)=19.08673717680097_p
w(16)=1.489733596893539e-8_p
x(17)=21.38290419594163_p
w(17)=7.952768905209956e-10_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;22kT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60756998324984_p
w(1)=8.010480008104082_p
x(2)=-2.557094447076085_p
w(2)=6.989520297519245_p
else if(N==3)then
x(1)=-13.0817072731004_p
w(1)=4.723446319944817_p
x(2)=-6.541750139806409_p
w(2)=7.396058843982019_p
x(3)=-2.364731569189653e-1_p
w(3)=2.880495141696491_p
else if(N==4)then
x(1)=-13.74326150497782_p
w(1)=3.145852122306219_p
x(2)=-9.049697099700277_p
w(2)=5.837737228758577_p
x(3)=-3.109019249667924_p
w(3)=5.206264622983498_p
x(4)=1.722316184234050_p
w(4)=8.101463315750325e-1_p
else if(N==5)then
x(1)=-14.09705105067292_p
w(1)=2.278794120633625_p
x(2)=-10.57194863923595_p
w(2)=4.569374781048251_p
x(3)=-5.496006531961573_p
w(3)=5.228358932003987_p
x(4)=-7.675870649456589e-1_p
w(4)=2.806728653010287_p
x(5)=3.990833708214657_p
w(5)=1.167438189271764e-1_p
else if(N==6)then
x(1)=-14.30997305453785_p
w(1)=1.749569300042126_p
x(2)=-11.5477713795386_p
w(2)=3.661191258915241_p
x(3)=-7.296009902996381_p
w(3)=4.647194115153021_p
x(4)=-2.714007148120789_p
w(4)=3.987290010024640_p
x(5)=1.188631340717274_p
w(5)=9.451326627670482e-1_p
x(6)=6.641607145487001_p
w(6)=9.622958721250715e-3_p
else if(N==7)then
x(1)=-14.44950195874797_p
w(1)=1.399871016289273_p
x(2)=-12.21114791545946_p
w(2)=3.007349891997221_p
x(3)=-8.626273597559940_p
w(3)=4.041551276342391_p
x(4)=-4.418838855747211_p
w(4)=4.144802884889026_p
x(5)=-5.729705172574361e-1_p
w(5)=2.239326822577534_p
x(6)=3.313704483043368_p
w(6)=1.665094063446481e-1_p
x(7)=9.526046144400510_p
w(7)=5.890071832332966e-4_p
else if(N==8)then
x(1)=-14.54737742854576_p
w(1)=1.153239952854148_p
x(2)=-12.68762925628963_p
w(2)=2.521128886143157_p
x(3)=-9.630974785266408_p
w(3)=3.512429439531324_p
x(4)=-5.854868639603293_p
w(4)=3.912659899800219_p
x(5)=-2.061824793089072_p
w(5)=3.127439346421620_p
x(6)=1.312132694103444_p
w(6)=7.552428978615499e-1_p
x(7)=5.708524554370785_p
w(7)=1.782679973881050e-2_p
x(8)=12.45685425234144_p
w(8)=3.308327249825171e-5_p
else if(N==9)then
x(1)=-14.62008069172969_p
w(1)=9.693460914870448e-1_p
x(2)=-13.04744191917622_p
w(2)=2.145335542448354_p
x(3)=-10.41559296820926_p
w(3)=3.063511860535653_p
x(4)=-7.052704455161741_p
w(4)=3.580411408742666_p
x(5)=-3.440411024506112_p
w(5)=3.415504580581123_p
x(6)=-1.625453951216431e-1_p
w(6)=1.679175913178378_p
x(7)=3.296504590072704_p
w(7)=1.451019767548916e-1_p
x(8)=8.184671406009082_p
w(8)=1.610706136072945e-3_p
x(9)=15.14452864547992_p
w(9)=2.225759143662164e-6_p
else if(N==10)then
x(1)=-14.67639170126233_p
w(1)=8.265206885896783e-1_p
x(2)=-13.32949344667685_p
w(2)=1.845861838141619_p
x(3)=-11.0455186529109_p
w(3)=2.683215438960033_p
x(4)=-8.056963358848098_p
w(4)=3.237340302723653_p
x(5)=-4.701361114853016_p
w(5)=3.361782922014759_p
x(6)=-1.453854396235907_p
w(6)=2.464484956192530_p
x(7)=1.565747504104067_p
w(7)=5.603685471953680e-1_p
x(8)=5.388699387438765_p
w(8)=2.026923248105895e-2_p
x(9)=10.5381516861183_p
w(9)=1.561442183344376e-4_p
x(10)=17.28488889188833_p
w(10)=2.351062929317670e-7_p
else if(N==11)then
x(1)=-14.7211289523559_p
w(1)=7.128160104499656e-1_p
x(2)=-13.55559107444233_p
w(2)=1.602882886789042_p
x(3)=-11.55941856155522_p
w(3)=2.361230611314290_p
x(4)=-8.901432355794025_p
w(4)=2.914080483439231_p
x(5)=-5.825062018042217_p
w(5)=3.172797565790040_p
x(6)=-2.674354396276153_p
w(6)=2.845346680403558_p
x(7)=2.071146024505566e-1_p
w(7)=1.265719206976736_p
x(8)=3.342093117265236_p
w(8)=1.224187070911985e-1_p
x(9)=7.451876412896606_p
w(9)=2.689432771589447e-3_p
x(10)=12.63577554364146_p
w(10)=1.867761393080993e-5_p
x(11)=18.78465297063581_p
w(11)=4.298374588108209e-8_p
else if(N==12)then
x(1)=-14.75726186175901_p
w(1)=6.208353897174871e-1_p
x(2)=-13.73945392061472_p
w(2)=1.403492980464365_p
x(3)=-11.98287703703505_p
w(3)=2.088712388779207_p
x(4)=-9.612781629581416_p
w(4)=2.621425951997824_p
x(5)=-6.809194540328122_p
w(5)=2.941872012235245_p
x(6)=-3.820200494033506_p
w(6)=2.909666746995824_p
x(7)=-9.767894579357580e-1_p
w(7)=1.960621865699315_p
x(8)=1.771923172358598_p
w(8)=4.310996631282740e-1_p
x(9)=5.155036822879725_p
w(9)=2.188117731649519e-2_p
x(10)=9.387057292380280_p
w(10)=3.891738423773689e-4_p
x(11)=14.41720670465639_p
w(11)=2.942890405356671e-6_p
x(12)=19.76349325633448_p
w(12)=1.255650667650143e-8_p
else if(N==13)then
x(1)=-14.78683773400708_p
w(1)=5.454540639854032e-1_p
x(2)=-13.89075182080577_p
w(2)=1.238270820482345_p
x(3)=-12.33489363206507_p
w(3)=1.857601007036000_p
x(4)=-10.21398401027303_p
w(4)=2.361517916346386_p
x(5)=-7.664015636084858_p
w(5)=2.706968343389869_p
x(6)=-4.868339672779898_p
w(6)=2.818960926988292_p
x(7)=-2.083370272317966_p
w(7)=2.383657934933588_p
x(8)=5.059485226025635e-1_p
w(8)=9.769858998001982e-1_p
x(9)=3.366428806548554_p
w(9)=1.066769486040244e-1_p
x(10)=6.922280927368710_p
w(10)=3.840215919883910e-3_p
x(11)=11.13987805623149_p
w(11)=6.560338111736589e-5_p
x(12)=15.87543805382258_p
w(12)=6.196249169821430e-7_p
x(13)=20.39268159740168_p
w(13)=5.131302081759917e-9_p
else if(N==14)then
x(1)=-14.81133800216756_p
w(1)=4.829483858365564e-1_p
x(2)=-14.01661263676139_p
w(2)=1.100073122116954_p
x(3)=-12.63007331019448_p
w(3)=1.660814827565162_p
x(4)=-10.72458587647773_p
w(4)=2.132697067812516_p
x(5)=-8.404762703703904_p
w(5)=2.483406189989456_p
x(6)=-5.809627931301652_p
w(6)=2.667328383844870_p
x(7)=-3.129293890229039_p
w(7)=2.530371909708390_p
x(8)=-5.926305700289564e-1_p
w(8)=1.575033602551967_p
x(9)=1.936438180470983_p
w(9)=3.435391510644380e-1_p
x(10)=4.968687964903483_p
w(10)=2.304945342354542e-2_p
x(11)=8.584867873297542_p
w(11)=7.247533559824195e-4_p
x(12)=12.68543894159633_p
w(12)=1.328464873647109e-5_p
x(13)=17.03844612363806_p
w(13)=1.710779381815673e-7_p
x(14)=20.80432738931018_p
w(14)=2.626815839919205e-9_p
else if(N==15)then
x(1)=-14.8318546514113_p
w(1)=4.305647906263262e-1_p
x(2)=-14.12236588776283_p
w(2)=9.834456446573775e-1_p
x(3)=-12.87968139992316_p
w(3)=1.492399589883645_p
x(4)=-11.16071547081726_p
w(4)=1.931884067351519_p
x(5)=-9.047224250853516_p
w(5)=2.276970339187061_p
x(6)=-6.646893419771371_p
w(6)=2.496867756348112_p
x(7)=-4.102440286944181_p
w(7)=2.513871625417551_p
x(8)=-1.608785213912431_p
w(8)=2.004069669298016_p
x(9)=7.554817101588428e-1_p
w(9)=7.700454261791722e-1_p
x(10)=3.382185270572768_p
w(10)=9.476260211456253e-2_p
x(11)=6.522534288412645_p
w(11)=4.961933196390526e-3_p
x(12)=10.11030715200705_p
w(12)=1.535412477053888e-4_p
x(13)=14.02012311953521_p
w(13)=3.258845277600886e-6_p
x(14)=17.95204526439879_p
w(14)=5.970765880154663e-8_p
x(15)=21.08211707144976_p
w(15)=1.562951792381778e-9_p
else if(N==16)then
x(1)=-14.84920378172681_p
w(1)=3.862402334244897e-1_p
x(2)=-14.21203897123546_p
w(2)=8.842008895471173e-1_p
x(3)=-13.09243303050616_p
w(3)=1.347468273743427_p
x(4)=-11.53545178130999_p
w(4)=1.755677667741002_p
x(5)=-9.605887190115814_p
w(5)=2.089206288426115_p
x(6)=-7.388616610137534_p
w(6)=2.325729827962518_p
x(7)=-4.993385867066554_p
w(7)=2.422154874262719_p
x(8)=-2.570447327569428_p
w(8)=2.206395515531446_p
x(9)=-2.721571650713821e-1_p
w(9)=1.276763586461171_p
x(10)=2.072673128728947_p
w(10)=2.811954905514077e-1_p
x(11)=4.819807749427480_p
w(11)=2.379369433365097e-2_p
x(12)=7.989028196357608_p
w(12)=1.135741874567595e-3_p
x(13)=11.48409557119792_p
w(13)=3.723354914228578e-5_p
x(14)=15.155216483941_p
w(14)=9.619220160558443e-7_p
x(15)=18.6657020610289_p
w(15)=2.526210041627879e-8_p
x(16)=21.27597542472915_p
w(16)=1.030438148805256e-9_p
else if(N==17)then
x(1)=-14.86400384471858_p
w(1)=3.484081818038264e-1_p
x(2)=-14.28871091200634_p
w(2)=7.990976544543177e-1_p
x(3)=-13.27511383069378_p
w(3)=1.222048769395237_p
x(4)=-11.85933737091153_p
w(4)=1.600824511291322_p
x(5)=-10.09337244566349_p
w(5)=1.919731823735749_p
x(6)=-8.045099902038020_p
w(6)=2.161803219019775_p
x(7)=-5.800805731325125_p
w(7)=2.300416493120111_p
x(8)=-3.475097590279696_p
w(8)=2.247963959520697_p
x(9)=-1.215913253265853_p
w(9)=1.689593631560706_p
x(10)=9.681344478432362e-1_p
w(10)=6.185249367990052e-1_p
x(11)=3.394022722571842_p
w(11)=8.529287669104903e-2_p
x(12)=6.209996947718047_p
w(12)=5.998584425974107e-3_p
x(13)=9.347032375935173_p
w(13)=2.849199028911295e-4_p
x(14)=12.70403059235451_p
w(14)=1.039445864511446e-5_p
x(15)=16.11084683591457_p
w(15)=3.362526018881038e-7_p
x(16)=19.22403435608492_p
w(16)=1.246117310137236e-8_p
x(17)=21.4156089051329_p
w(17)=7.302464589253644e-10_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;22kT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.80652727825151_p
w(1)=7.538498963979146_p
x(2)=-2.304430769664448_p
w(2)=6.461501867270281_p
else if(N==3)then
x(1)=-12.18399801551276_p
w(1)=4.470876413889482_p
x(2)=-6.001285620613543_p
w(2)=6.968250668698754_p
x(3)=-2.478315036095988e-2_p
w(3)=2.560873748661189_p
else if(N==4)then
x(1)=-12.80448845186026_p
w(1)=2.992228337993686_p
x(2)=-8.343351200829201_p
w(2)=5.541910393662788_p
x(3)=-2.724829296196397_p
w(3)=4.809660440538850_p
x(4)=1.984882512404382_p
w(4)=6.562016590541029e-1_p
else if(N==5)then
x(1)=-13.13753816153222_p
w(1)=2.176392996729374_p
x(2)=-9.772659968479999_p
w(2)=4.358467557249730_p
x(3)=-4.942403015682270_p
w(3)=4.940420383589444_p
x(4)=-4.575160452240573e-1_p
w(4)=2.440536328499789_p
x(5)=4.339590372885407_p
w(5)=8.418356518108891e-2_p
else if(N==6)then
x(1)=-13.33868846146602_p
w(1)=1.676612065779279_p
x(2)=-10.69283433968793_p
w(2)=3.505066686465775_p
x(3)=-6.628410537636040_p
w(3)=4.429560652234175_p
x(4)=-2.280806428336769_p
w(4)=3.646116181895403_p
x(5)=1.520878738449330_p
w(5)=7.362584007410244e-1_p
x(6)=7.060922964355299_p
w(6)=6.386844133769635e-3_p
else if(N==7)then
x(1)=-13.47100085635399_p
w(1)=1.345097467695620_p
x(2)=-11.3210166338168_p
w(2)=2.887375657272508_p
x(3)=-7.882774045503691_p
w(3)=3.869893773359352_p
x(4)=-3.868356122092115_p
w(4)=3.898829973956168_p
x(5)=-2.068889150788470e-1_p
w(5)=1.883737664134612_p
x(6)=3.717087141887403_p
w(6)=1.146944653649519e-1_p
x(7)=9.990289975816214_p
w(7)=3.718294662136035e-4_p
else if(N==8)then
x(1)=-13.56423759076924_p
w(1)=1.110209121962151_p
x(2)=-11.77442644752505_p
w(2)=2.425480686018533_p
x(3)=-8.836056573628536_p
w(3)=3.372840192297320_p
x(4)=-5.218426205394972_p
w(4)=3.725652777721483_p
x(5)=-1.615875634828565_p
w(5)=2.793706701158187_p
x(6)=1.696035794924717_p
w(6)=5.606521811265472e-1_p
x(7)=6.162195148315848_p
w(7)=1.143855960944659e-2_p
x(8)=12.92763609009243_p
w(8)=2.061135575763748e-5_p
else if(N==9)then
x(1)=-13.63381033630264_p
w(1)=9.342646269731817e-1_p
x(2)=-12.11846330169391_p
w(2)=2.066607806628316_p
x(3)=-9.584725063300214_p
w(3)=2.947029341905045_p
x(4)=-6.354724867967539_p
w(4)=3.428292628310496_p
x(5)=-2.909298305207541_p
w(5)=3.170578218743836_p
x(6)=2.309951416416209e-1_p
w(6)=1.355326485995110_p
x(7)=3.728505871350059_p
w(7)=9.688802247576943e-2_p
x(8)=8.649578202153803_p
w(8)=1.012259780988981e-3_p
x(9)=15.56371306566438_p
w(9)=1.440436683953192e-6_p
else if(N==10)then
x(1)=-13.68785318998687_p
w(1)=7.972112909332540e-1_p
x(2)=-12.3889801035655_p
w(2)=1.779650364428737_p
x(3)=-10.18796249786356_p
w(3)=2.584276218866085_p
x(4)=-7.312736315711693_p
w(4)=3.108939424424399_p
x(5)=-4.099412942093089_p
w(5)=3.181217612198997_p
x(6)=-1.011276803777003_p
w(6)=2.134904251390051_p
x(7)=1.975850032784249_p
w(7)=4.007630712324645e-1_p
x(8)=5.843602796778179_p
w(8)=1.293901497162599e-2_p
x(9)=10.9818962697091_p
w(9)=9.941848831123016e-5_p
x(10)=17.6089275863851_p
w(10)=1.643155018352552e-7_p
else if(N==11)then
x(1)=-13.73084673833544_p
w(1)=6.879509253471170e-1_p
x(2)=-12.60615243663052_p
w(2)=1.546435236151700_p
x(3)=-10.68099003007585_p
w(3)=2.276235908950343_p
x(4)=-8.120719990543154_p
w(4)=2.803645160520747_p
x(5)=-5.166678663079299_p
w(5)=3.029398682456781_p
x(6)=-2.164387802018589_p
w(6)=2.590713265501049_p
x(7)=6.168038182022775e-1_p
w(7)=9.833382400545587e-1_p
x(8)=3.783337353822745_p
w(8)=8.056481594025858e-2_p
x(9)=7.903262464690469_p
w(9)=1.706261026303179e-3_p
x(10)=13.03747904744751_p
w(10)=1.230271191992384e-5_p
x(11)=19.01254818144773_p
w(11)=3.258864913582581e-8_p
else if(N==12)then
x(1)=-13.76559837828245_p
w(1)=5.994948899535113e-1_p
x(2)=-12.7829112187188_p
w(2)=1.354863223930011_p
x(3)=-11.08770315977444_p
w(3)=2.015044653530101_p
x(4)=-8.802581203397736_p
w(4)=2.525354961193175_p
x(5)=-6.105387881953487_p
w(5)=2.821609232954327_p
x(6)=-3.246128304862017_p
w(6)=2.725171763910252_p
x(7)=-5.344553557928148e-1_p
w(7)=1.644250746259503_p
x(8)=2.198638221681873_p
w(8)=3.000065082483562e-1_p
x(9)=5.607857074183902_p
w(9)=1.395239175243410e-2_p
x(10)=9.817681980462710_p
w(10)=2.504219750453890e-4_p
x(11)=14.76635564803454_p
w(11)=2.027383344809609e-6_p
x(12)=19.91857614041677_p
w(12)=1.015936480802737e-8_p
else if(N==13)then
x(1)=-13.79406250961305_p
w(1)=5.269528811818583e-1_p
x(2)=-12.92847026502165_p
w(2)=1.195985366935581_p
x(3)=-11.42610914087785_p
w(3)=1.793231124491520_p
x(4)=-9.379660429471556_p
w(4)=2.277217702040005_p
x(5)=-6.923122534518777_p
w(5)=2.603005721517124_p
x(6)=-4.240405919780883_p
w(6)=2.677814307037135_p
x(7)=-1.586955426913226_p
w(7)=2.120275164827770_p
x(8)=9.303595787081981e-1_p
w(8)=7.335822104150600e-1_p
x(9)=3.814430318529429_p
w(9)=6.944877340611789e-2_p
x(10)=7.368240631388518_p
w(10)=2.443800760832684e-3_p
x(11)=11.53885229866059_p
w(11)=4.332640840772767e-5_p
x(12)=16.16987756511223_p
w(12)=4.478801844946163e-7_p
x(13)=20.49908093160708_p
w(13)=4.347830999446901e-9_p
else if(N==14)then
x(1)=-13.81765651176767_p
w(1)=4.667633422343191e-1_p
x(2)=-13.04963938823815_p
w(2)=1.062992882716198_p
x(3)=-11.71010737270357_p
w(3)=1.604144383164589_p
x(4)=-9.870334252999276_p
w(4)=2.058179494662151_p
x(5)=-7.633209780479028_p
w(5)=2.391985898506825_p
x(6)=-5.137414961916468_p
w(6)=2.551805249461964_p
x(7)=-2.575839324913002_p
w(7)=2.336537252921131_p
x(8)=-1.463802827495706e-1_p
w(8)=1.278503891702495_p
x(9)=2.376059743739785_p
w(9)=2.339527340452970e-1_p
x(10)=5.421890530157583_p
w(10)=1.465913109438980e-2_p
x(11)=9.011929889766360_p
w(11)=4.673739951597525e-4_p
x(12)=13.04673422403972_p
w(12)=9.065002569536916e-6_p
x(13)=17.28197124413642_p
w(13)=1.294448742840822e-7_p
x(14)=20.87929446331774_p
w(14)=2.297464517598089e-9_p
else if(N==15)then
x(1)=-13.8374256055021_p
w(1)=4.162913208222616e-1_p
x(2)=-13.15151364190494_p
w(2)=9.506812658258655e-1_p
x(3)=-11.95043447934644_p
w(3)=1.442161466095627_p
x(4)=-10.28984477859285_p
w(4)=1.865582875386476_p
x(5)=-8.250047019793936_p
w(5)=2.195706916312272_p
x(6)=-5.937975880748308_p
w(6)=2.397901137255604_p
x(7)=-3.498396055583825_p
w(7)=2.369406768930516_p
x(8)=-1.120176503348121_p
w(8)=1.736653524815235_p
x(9)=1.192841240983362_p
w(9)=5.612049529928683e-1_p
x(10)=3.835779532221997_p
w(10)=6.114979385012448e-2_p
x(11)=6.967035088394656_p
w(11)=3.157253866055025e-3_p
x(12)=10.51105012437348_p
w(12)=1.012028204484255e-4_p
x(13)=14.34168700262817_p
w(13)=2.303842280450411e-6_p
x(14)=18.15157116987315_p
w(14)=4.703647131374264e-8_p
x(15)=21.13663281668663_p
w(15)=1.397320794715298e-9_p
else if(N==16)then
x(1)=-13.85415132432244_p
w(1)=3.735615997422039e-1_p
x(2)=-13.23794582983732_p
w(2)=8.550507622819191e-1_p
x(3)=-12.15540692781208_p
w(3)=1.302650403802726_p
x(4)=-10.65059556309741_p
w(4)=1.696338936116509_p
x(5)=-8.787087688072925_p
w(5)=2.016410672482844_p
x(6)=-6.648881288668836_p
w(6)=2.238657826063664_p
x(7)=-4.346662149755996_p
w(7)=2.307552146807351_p
x(8)=-2.032319038362489_p
w(8)=2.001488830633374_p
x(9)=1.799077972253812e-1_p
w(9)=1.004231607277653_p
x(10)=2.522296168095776_p
w(10)=1.882127017350645e-1_p
x(11)=5.274298876575605_p
w(11)=1.508756221078191e-2_p
x(12)=8.415898045592701_p
w(12)=7.318525266990752e-4_p
x(13)=11.85441507213764_p
w(13)=2.520365254385416e-5_p
x(14)=15.43797127010906_p
w(14)=7.043924318994684e-7_p
x(15)=18.82892391044489_p
w(15)=2.058799113763493e-8_p
x(16)=21.31684935544574_p
w(16)=9.356699322454943e-10_p
else if(N==17)then
x(1)=-13.86842631424716_p
w(1)=3.370733036347496e-1_p
x(2)=-13.3118838845127_p
w(2)=7.730021740393239e-1_p
x(3)=-12.33150807064407_p
w(3)=1.181835685841193_p
x(4)=-10.96261203159177_p
w(4)=1.547432247688888_p
x(5)=-9.256171186630333_p
w(5)=1.854122011145428_p
x(6)=-7.279192268595914_p
w(6)=2.083984966127413_p
x(7)=-5.118170310314560_p
w(7)=2.204213176339577_p
x(8)=-2.890180529780338_p
w(8)=2.096100765856773_p
x(9)=-7.311254282700110e-1_p
w(9)=1.424195431484912_p
x(10)=1.416410006514959_p
w(10)=4.393927921979185e-1_p
x(11)=3.852178630587697_p
w(11)=5.464191445307664e-2_p
x(12)=6.654696268316486_p
w(12)=3.811686513769458e-3_p
x(13)=9.750866424172932_p
w(13)=1.871688664972289e-4_p
x(14)=13.04231296048808_p
w(14)=7.241429816720267e-6_p
x(15)=16.35761622007718_p
w(15)=2.545173449329363e-7_p
x(16)=19.35806450212804_p
w(16)=1.044211075287146e-8_p
x(17)=21.44710745947188_p
w(17)=6.706346947353868e-10_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;22kT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.00429021521115_p
w(1)=7.068991823279026_p
x(2)=-2.046000758973140_p
w(2)=5.931010436768879_p
else if(N==3)then
x(1)=-11.28554812666428_p
w(1)=4.220016312965691_p
x(2)=-5.458791217898791_p
w(2)=6.536163212100749_p
x(3)=2.003945967283993e-1_p
w(3)=2.243822734981465_p
else if(N==4)then
x(1)=-11.86528407328188_p
w(1)=2.839629303479430_p
x(2)=-7.635525535445394_p
w(2)=5.245836177493236_p
x(3)=-2.338714966111902_p
w(3)=4.396814073318817_p
x(4)=2.270562437920756_p
w(4)=5.177227057564237e-1_p
else if(N==5)then
x(1)=-12.17777827847178_p
w(1)=2.074584005108899_p
x(2)=-8.972451763929630_p
w(2)=4.147832975860517_p
x(3)=-4.388991731482317_p
w(3)=4.641243127419938_p
x(4)=-1.362027006208146e-1_p
w(4)=2.077309965622371_p
x(5)=4.713880798849933_p
w(5)=5.903218603618090e-2_p
else if(N==6)then
x(1)=-12.36727063096311_p
w(1)=1.603973208695883_p
x(2)=-9.837402229551463_p
w(2)=3.349120261836871_p
x(3)=-5.960971662235927_p
w(3)=4.207416103941469_p
x(4)=-1.848192673388348_p
w(4)=3.280848742184556_p
x(5)=1.877701687380733_p
w(5)=5.545060343947615e-1_p
x(6)=7.503345691991527_p
w(6)=4.137908994365229e-3_p
else if(N==7)then
x(1)=-12.49244749719549_p
w(1)=1.290444133814553_p
x(2)=-10.43072760193025_p
w(2)=2.767369990039268_p
x(3)=-7.139637229621920_p
w(3)=3.696060847597886_p
x(4)=-3.321243517518323_p
w(4)=3.632053298262249_p
x(5)=1.710283574778997e-1_p
w(5)=1.537268105218172_p
x(6)=4.146622656928463_p
w(6)=7.657571841411183e-2_p
x(7)=10.47327890282753_p
w(7)=2.301667016657722e-4_p
else if(N==8)then
x(1)=-12.58110366120122_p
w(1)=1.067154843702466_p
x(2)=-10.86132178249754_p
w(2)=2.329602040923107_p
x(3)=-8.041795030028323_p
w(3)=3.231844020117476_p
x(4)=-4.585115396942706_p
w(4)=3.527666497990276_p
x(5)=-1.171024014061983_p
w(5)=2.436040337874186_p
x(6)=2.104557772640477_p
w(6)=4.005021567203589e-1_p
x(7)=6.635720631950396_p
w(7)=7.179668203618522e-3_p
x(8)=13.40801286196014_p
w(8)=1.269451641692407e-5_p
else if(N==9)then
x(1)=-12.64757205339635_p
w(1)=8.990956230111922e-1_p
x(2)=-11.18969370913272_p
w(2)=1.987571730895802_p
x(3)=-8.754612557539224_p
w(3)=2.829501129716637_p
x(4)=-5.659278693621522_p
w(4)=3.270546146228702_p
x(5)=-2.383869793292463_p
w(5)=2.896423027429746_p
x(6)=6.386758755490094e-1_p
w(6)=1.053387309458338_p
x(7)=4.183024464153477_p
w(7)=6.284924785878468e-2_p
x(8)=9.127055768876492_p
w(8)=6.271141434757073e-4_p
x(9)=15.98026272440766_p
w(9)=9.313052268100404e-7_p
else if(N==10)then
x(1)=-12.69934879588576_p
w(1)=7.678106965830185e-1_p
x(2)=-11.44867291552607_p
w(2)=1.713158350092534_p
x(3)=-9.331066560268358_p
w(3)=2.484563781766378_p
x(4)=-6.570416314673391_p
w(4)=2.977430767667945_p
x(5)=-3.502685780398730_p
w(5)=2.982036998106377_p
x(6)=-5.670666294672558e-1_p
w(6)=1.791037454118581_p
x(7)=2.409203225276466_p
w(7)=2.757947350586860e-1_p
x(8)=6.314422871971030_p
w(8)=8.106575080875946e-3_p
x(9)=11.43183819028087_p
w(9)=6.278609814959931e-5_p
x(10)=17.92319414255384_p
w(10)=1.154753593672717e-7_p
else if(N==11)then
x(1)=-12.7405936425927_p
w(1)=6.630084092637961e-1_p
x(2)=-11.65688587234449_p
w(2)=1.489759676826363_p
x(3)=-9.803088845469720_p
w(3)=2.190670150889398_p
x(4)=-7.341419292321485_p
w(4)=2.691337906741571_p
x(5)=-4.512137141009611_p
w(5)=2.875977881885156_p
x(6)=-1.659377174590373_p
w(6)=2.304292214461304_p
x(7)=1.043169813800965_p
w(7)=7.322487804217928e-1_p
x(8)=4.244434308410517_p
w(8)=5.163004254369940e-2_p
x(9)=8.365172578157328_p
w(9)=1.069096586140715e-3_p
x(10)=13.44045509921279_p
w(10)=8.075559744814929e-6_p
x(11)=19.23036196572094_p
w(11)=2.486893820297099e-8_p
else if(N==12)then
x(1)=-12.77395926590007_p
w(1)=5.780897755701373e-1_p
x(2)=-11.82651052508887_p
w(2)=1.306048647906453_p
x(3)=-10.19295204958623_p
w(3)=1.940942964789655_p
x(4)=-7.993452893692884_p
w(4)=2.428061272643686_p
x(5)=-5.404337585829595_p
w(5)=2.695923056771637_p
x(6)=-2.677946414522034_p
w(6)=2.514867049149547_p
x(7)=-8.666358811055698e-2_p
w(7)=1.326046162642233_p
x(8)=2.647321150214269_p
w(8)=2.011175215345513e-1_p
x(9)=6.074869156493472_p
w(9)=8.744557474919657e-3_p
x(10)=10.25454773156651_p
w(10)=1.598469287260514e-4_p
x(11)=15.11342072230268_p
w(11)=1.396374812940913e-6_p
x(12)=20.06599556235249_p
w(12)=8.261547570336189e-9_p
else if(N==13)then
x(1)=-12.80130803653154_p
w(1)=5.083968265187978e-1_p
x(2)=-11.96630814605217_p
w(2)=1.153546821316515_p
x(3)=-10.51767158214484_p
w(3)=1.728520371909763_p
x(4)=-8.546178621161955_p
w(4)=2.192063168734634_p
x(5)=-6.184258339298427_p
w(5)=2.495916255001398_p
x(6)=-3.617300759183002_p
w(6)=2.521013781174875_p
x(7)=-1.093418050355670_p
w(7)=1.828224224503544_p
x(8)=1.372886538865155_p
w(8)=5.266509513371131e-1_p
x(9)=4.280396424068700_p
w(9)=4.410398714734536e-2_p
x(10)=7.823884201861856_p
w(10)=1.537063934370078e-3_p
x(11)=11.94068117442657_p
w(11)=2.848049926505129e-5_p
x(12)=16.46041392279379_p
w(12)=3.242739974445189e-7_p
x(13)=20.60023044333461_p
w(13)=3.696288058647623e-9_p
else if(N==14)then
x(1)=-12.8239929366415_p
w(1)=4.505310363586265e-1_p
x(2)=-12.08276815579145_p
w(2)=1.025783599727156_p
x(3)=-10.79043162538386_p
w(3)=1.547199017753207_p
x(4)=-9.016761618241590_p
w(4)=1.983033088163904_p
x(5)=-6.863201120616806_p
w(5)=2.298622559212246_p
x(6)=-4.468833588869404_p
w(6)=2.427437736063272_p
x(7)=-2.028129456655727_p
w(7)=2.111878223983471_p
x(8)=3.086353271234762e-1_p
w(8)=9.923111080590419e-1_p
x(9)=2.836186558557311_p
w(9)=1.537272438537115e-1_p
x(10)=5.888028156358017_p
w(10)=9.173367092362852e-3_p
x(11)=9.445198125373285_p
w(11)=2.990074225765936e-4_p
x(12)=13.40838132614763_p
w(12)=6.172164182479268e-6_p
x(13)=17.52098903839855_p
w(13)=9.818071988204688e-8_p
x(14)=20.95074725077317_p
w(14)=2.013427365307580e-9_p
else if(N==15)then
x(1)=-12.84301216040038_p
w(1)=4.019767748790304e-1_p
x(2)=-12.18074943358326_p
w(2)=9.178067639805644e-1_p
x(3)=-11.02143364242822_p
w(3)=1.391697137867280_p
x(4)=-9.419533055209783_p
w(4)=1.798800192741555_p
x(5)=-7.454080932161180_p
w(5)=2.113150011589681_p
x(6)=-5.231776688311913_p
w(6)=2.293846086257543_p
x(7)=-2.899857794551017_p
w(7)=2.203209157509707_p
x(8)=-6.317720616764647e-1_p
w(8)=1.448131683489183_p
x(9)=1.648779714106885_p
w(9)=3.907792539841055e-1_p
x(10)=4.305747687062147_p
w(10)=3.855048106514473e-2_p
x(11)=7.420574295803569_p
w(11)=1.986690228958630e-3_p
x(12)=10.91530618600046_p
w(12)=6.636014485967880e-5_p
x(13)=14.66193350995156_p
w(13)=1.627913277307839e-6_p
x(14)=18.34673136595969_p
w(14)=3.714642483091497e-8_p
x(15)=21.18877147855846_p
w(15)=1.250591668405607e-9_p
else if(N==16)then
x(1)=-12.85911253647346_p
w(1)=3.608470325547070e-1_p
x(2)=-12.26392924538393_p
w(2)=8.258057670700207e-1_p
x(3)=-11.21859172014457_p
w(3)=1.257643475790780_p
x(4)=-9.766206889070039_p
w(4)=1.636620200844952_p
x(5)=-7.969261887833140_p
w(5)=1.942702914418891_p
x(6)=-5.911221131651059_p
w(6)=2.148506306194125_p
x(7)=-3.704374726966607_p
w(7)=2.179691712692314_p
x(8)=-1.498980903338809_p
w(8)=1.764313972247360_p
x(9)=6.432798338446030e-1_p
w(9)=7.521903125745131e-1_p
x(10)=2.990949757538050_p
w(10)=1.217735804948575e-1_p
x(11)=5.740711564237085_p
w(11)=9.421530577089844e-3_p
x(12)=8.848862451112854_p
w(12)=4.679134297563873e-4_p
x(13)=12.22621818397133_p
w(13)=1.700739837931762e-5_p
x(14)=15.71843749682867_p
w(14)=5.160946865991033e-7_p
x(15)=18.98826855217767_p
w(15)=1.681546011181862e-8_p
x(16)=21.35607823542918_p
w(16)=8.500145458778149e-10_p
else if(N==17)then
x(1)=-12.87286082302653_p
w(1)=3.257068191457764e-1_p
x(2)=-12.33512385456457_p
w(2)=7.468243243933551e-1_p
x(3)=-11.38808462978327_p
w(3)=1.141462556412782_p
x(4)=-10.06628284968478_p
w(4)=1.493732869433749_p
x(5)=-8.419768696491154_p
w(5)=1.787838424617852_p
x(6)=-6.514908354011613_p
w(6)=2.004190957672366_p
x(7)=-4.438955734797270_p
w(7)=2.100153761489694_p
x(8)=-2.310964201300306_p
w(8)=1.917197959203280_p
x(9)=-2.437193747681616e-1_p
w(9)=1.147738167097577_p
x(10)=1.883098346632370_p
w(10)=2.983883332613280e-1_p
x(11)=4.325362121715786_p
w(11)=3.424425693505481e-2_p
x(12)=7.107910408034698_p
w(12)=2.396304055635456e-3_p
x(13)=10.15853731773166_p
w(13)=1.222874374977566e-4_p
x(14)=13.38062152230102_p
w(14)=5.036649645860217e-6_p
x(15)=16.60164420269416_p
w(15)=1.928607236041484e-7_p
x(16)=19.48880373924348_p
w(16)=8.765663095036679e-9_p
x(17)=21.47743739697289_p
w(17)=6.159255488847537e-10_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;22kT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200741251330546_p
w(1)=6.602046551236412_p
x(2)=-1.780566082777624_p
w(2)=5.397959592678119_p
else if(N==3)then
x(1)=-10.38632309621693_p
w(1)=3.970895742061959_p
x(2)=-4.914384486347331_p
w(2)=6.097468644796196_p
x(3)=4.416790303970372e-1_p
w(3)=1.931641757056376_p
else if(N==4)then
x(1)=-10.92564856029218_p
w(1)=2.688030306929073_p
x(2)=-6.926389776696184_p
w(2)=4.948522836885775_p
x(3)=-1.949898025509982_p
w(3)=3.966949288538395_p
x(4)=2.582253787663197_p
w(4)=3.965037115612868e-1_p
else if(N==5)then
x(1)=-11.21778442565885_p
w(1)=1.973321013225217_p
x(2)=-8.171474109625040_p
w(2)=3.936994400597072_p
x(3)=-3.836395909846004_p
w(3)=4.326387691210265_p
x(4)=1.998240581731008e-1_p
w(4)=1.723107687108536_p
x(5)=5.115253189659152_p
w(5)=4.019535177344050e-2_p
else if(N==6)then
x(1)=-11.39573790367432_p
w(1)=1.531597969259446_p
x(2)=-8.981615231277193_p
w(2)=3.193048810182479_p
x(3)=-5.294342284876564_p
w(3)=3.978127159008161_p
x(4)=-1.414845135283861_p
w(4)=2.892296500862133_p
x(5)=2.262270816031371_p
w(5)=4.023210194774388e-1_p
x(6)=7.969759147229371_p
w(6)=2.614685124871953e-3_p
else if(N==7)then
x(1)=-11.51386305180138_p
w(1)=1.235851649140715_p
x(2)=-9.540417046072859_p
w(2)=2.647100830832611_p
x(3)=-6.397387033211888_p
w(3)=3.518663953907140_p
x(4)=-2.778214258354885_p
w(4)=3.338396533473595_p
x(5)=5.652981776485055e-1_p
w(5)=1.210311819511362_p
x(6)=4.603045228411120_p
w(6)=4.954166343507460e-2_p
x(7)=10.97497886671714_p
w(7)=1.396936140332127e-4_p
else if(N==8)then
x(1)=-11.59799513155204_p
w(1)=1.024023555790633_p
x(2)=-9.948432909228668_p
w(2)=2.233313555040323_p
x(3)=-7.248591115062263_p
w(3)=3.088652532898474_p
x(4)=-3.955991255141280_p
w(4)=3.313618062486781_p
x(5)=-7.243883962114739e-1_p
w(5)=2.061177927919835_p
x(6)=2.540064494630920_p
w(6)=2.748030715740417e-1_p
x(7)=7.128867856598065_p
w(7)=4.409699995126096e-3_p
x(8)=13.89643841880251_p
w(8)=7.738209316205156e-6_p
else if(N==9)then
x(1)=-11.66137993763064_p
w(1)=8.638002256872795e-1_p
x(2)=-10.26121748826777_p
w(2)=1.908101675805385_p
x(3)=-7.925533070211818_p
w(3)=2.710457157174639_p
x(4)=-4.967182231463484_p
w(4)=3.104238602969331_p
x(5)=-1.863844954326981_p
w(5)=2.588975439144718_p
x(6)=1.065213268325230_p
w(6)=7.844065117519252e-1_p
x(7)=4.659959445527811_p
w(7)=3.964274264221094e-2_p
x(8)=9.616457739130144_p
w(8)=3.831862418146478e-4_p
x(9)=16.39214583358345_p
w(9)=6.024972271124785e-7_p
else if(N==10)then
x(1)=-11.71088852141153_p
w(1)=7.382911273776415e-1_p
x(2)=-10.5086317472723_p
w(2)=1.646297148826398_p
x(3)=-8.475024512872535_p
w(3)=2.383780201112915_p
x(4)=-5.830575247013288_p
w(4)=2.841199400149032_p
x(5)=-2.912034347003132_p
w(5)=2.757351050716518_p
x(6)=-1.168358948589102e-1_p
w(6)=1.445429152424144_p
x(7)=2.867210265856001_p
w(7)=1.826307323310219e-1_p
x(8)=6.800715629551583_p
w(8)=4.987895140908749e-3_p
x(9)=11.88717709827084_p
w(9)=3.935416543589585e-5_p
x(10)=18.22662992165639_p
w(10)=8.167051487563221e-8_p
else if(N==11)then
x(1)=-11.75037757855406_p
w(1)=6.379664687868837e-1_p
x(2)=-10.70783820707042_p
w(2)=1.432788279620965_p
x(3)=-8.925861671592550_p
w(3)=2.104328753893704_p
x(4)=-6.563943576619360_p
w(4)=2.576229047516556_p
x(5)=-3.862397913432896_p
w(5)=2.707539510781848_p
x(6)=-1.157537107819928_p
w(6)=1.987413019945667_p
x(7)=1.490306420995744_p
w(7)=5.208104677783895e-1_p
x(8)=4.725014932398603_p
w(8)=3.226341419587182e-2_p
x(9)=8.837098021727622_p
w(9)=6.618764729309382e-4_p
x(10)=13.84390402798767_p
w(10)=5.285816762035832e-6_p
x(11)=19.43791107049146_p
w(11)=1.910495425770862e-8_p
else if(N==12)then
x(1)=-11.78235115737244_p
w(1)=5.566016541773454e-1_p
x(2)=-10.87029050910144_p
w(2)=1.256994503355556_p
x(3)=-9.298740706936444_p
w(3)=1.866257944147377_p
x(4)=-7.185707843031952_p
w(4)=2.328973260286376_p
x(5)=-4.706830400202698_p
w(5)=2.561805762343034_p
x(6)=-2.115893108117823_p
w(6)=2.272184152145273_p
x(7)=3.716214122983963e-1_p
w(7)=1.021647450005795_p
x(8)=3.118646458977406_p
w(8)=1.300480808694887e-1_p
x(9)=6.555547729184261_p
w(9)=5.391107181021287e-3_p
x(10)=10.69709151819632_p
w(10)=1.012605967841269e-4_p
x(11)=15.45773795863993_p
w(11)=9.620549600506002e-7_p
x(12)=20.20587887152691_p
w(12)=6.751520677568901e-9_p
else if(N==13)then
x(1)=-11.80857995374399_p
w(1)=4.897702931412033e-1_p
x(2)=-11.00429792639496_p
w(2)=1.110910137640701_p
x(3)=-9.609676419166520_p
w(3)=1.663355196190329_p
x(4)=-7.713779799871131_p
w(4)=2.105679918515594_p
x(5)=-5.448024655139390_p
w(5)=2.383932364303846_p
x(6)=-2.999945559153310_p
w(6)=2.341705714539339_p
x(7)=-5.995610262966994e-1_p
w(7)=1.515377411230753_p
x(8)=1.836715137992625_p
w(8)=3.609325617569947e-1_p
x(9)=4.763766708063711_p
w(9)=2.736767421130459e-2_p
x(10)=8.288708663971983_p
w(10)=9.559913849640602e-4_p
x(11)=12.3448050989022_p
w(11)=1.864259552895692e-5_p
x(12)=16.74658768937089_p
w(12)=2.352516444637930e-7_p
x(13)=20.69629055892579_p
w(13)=3.152329365596839e-9_p
else if(N==14)then
x(1)=-11.83035209793869_p
w(1)=4.342381395382646e-1_p
x(2)=-11.11602641275221_p
w(2)=9.884077430392335e-1_p
x(3)=-9.871125055552914_p
w(3)=1.489889844683047_p
x(4)=-8.164059376521326_p
w(4)=1.906998863385851_p
x(5)=-6.095194904628718_p
w(5)=2.202246306346860_p
x(6)=-3.804823650485310_p
w(6)=2.289432202784138_p
x(7)=-1.485389425782985_p
w(7)=1.852931165071426_p
x(8)=7.774415886331307e-1_p
w(8)=7.323324889407810e-1_p
x(9)=3.316972757622214_p
w(9)=9.768171725666473e-2_p
x(10)=6.366511507398096_p
w(10)=5.653544719115875e-3_p
x(11)=9.884185250602656_p
w(11)=1.898567474532058e-4_p
x(12)=13.76988395876378_p
w(12)=4.194971791725069e-6_p
x(13)=17.75522877854198_p
w(13)=7.466215016604452e-8_p
x(14)=21.01880914430813_p
w(14)=1.767754343442113e-9_p
else if(N==15)then
x(1)=-11.84861846242595_p
w(1)=3.876096956065876e-1_p
x(2)=-11.21009669387936_p
w(2)=8.847905254437698e-1_p
x(3)=-10.09274503581488_p
w(3)=1.340935381212164_p
x(4)=-8.549935225932469_p
w(4)=1.731348516857192_p
x(5)=-6.659680426274601_p
w(5)=2.028621592841859_p
x(6)=-4.529076736299330_p
w(6)=2.181695086541661_p
x(7)=-2.307380427212566_p
w(7)=2.007807261523435_p
x(8)=-1.393125315936257e-1_p
w(8)=1.152064972716444_p
x(9)=2.125588312387388_p
w(9)=2.600633933707385e-1_p
x(10)=4.791412802350697_p
w(10)=2.378828210812352e-2_p
x(11)=7.882646832751022_p
w(11)=1.236950629737092e-3_p
x(12)=11.32261759931469_p
w(12)=4.330443966587000e-5_p
x(13)=14.98046257161296_p
w(13)=1.150091939473273e-6_p
x(14)=18.53738832237981_p
w(14)=2.941088447003195e-8_p
x(15)=21.23861721040564_p
w(15)=1.120329007149671e-9_p
else if(N==16)then
x(1)=-11.86409100675108_p
w(1)=3.480866167851337e-1_p
x(2)=-11.29000935526756_p
w(2)=7.964390045697228e-1_p
x(3)=-10.28204340538159_p
w(3)=1.212389309648967_p
x(4)=-8.882413307466670_p
w(4)=1.576380528961350_p
x(5)=-7.152689588268039_p
w(5)=1.867632100085528_p
x(6)=-5.176251558039021_p
w(6)=2.053415086808097_p
x(7)=-3.067457963980540_p
w(7)=2.032058455210647_p
x(8)=-9.684623081108270e-1_p
w(8)=1.496658592628501_p
x(9)=1.122521941036952_p
w(9)=5.344613479895841e-1_p
x(10)=3.478433699807366_p
w(10)=7.637652330973736e-2_p
x(11)=6.218420430173216_p
w(11)=5.799789819374804e-3_p
x(12)=9.287471953868351_p
w(12)=2.969505931843188e-4_p
x(13)=12.59909678487435_p
w(13)=1.144454443492044e-5_p
x(14)=15.9963160878242_p
w(14)=3.784235158155504e-7_p
x(15)=19.14367774055794_p
w(15)=1.376427896112697e-8_p
x(16)=21.39371773166132_p
w(16)=7.724740462812503e-10_p
else if(N==17)then
x(1)=-11.8773104961911_p
w(1)=3.143000918484487e-1_p
x(2)=-11.35844825445478_p
w(2)=7.205410089737099e-1_p
x(3)=-10.44489137482185_p
w(3)=1.100881087185935_p
x(4)=-9.170456365658698_p
w(4)=1.439617145524046_p
x(5)=-7.584390261654693_p
w(5)=1.720567442408253_p
x(6)=-5.752730361655253_p
w(6)=1.921245758419908_p
x(7)=-3.764065178942635_p
w(7)=1.983696372354000_p
x(8)=-1.737314712557930_p
w(8)=1.705145733720438_p
x(9)=2.511359538513320e-1_p
w(9)=8.773277933637095e-1_p
x(10)=2.369721787768373_p
w(10)=1.940721892295244e-1_p
x(11)=4.812828421799019_p
w(11)=2.103702260472552e-2_p
x(12)=7.569132102562191_p
w(12)=1.491355041407891e-3_p
x(13)=10.56964081103611_p
w(13)=7.949058431827400e-5_p
x(14)=13.71861046812187_p
w(14)=3.498399085446157e-6_p
x(15)=16.84271979005501_p
w(15)=1.463202902330762e-7_p
x(16)=19.61623557415437_p
w(16)=7.371074024378054e-9_p
x(17)=21.50663559423195_p
w(17)=5.656575434457109e-10_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;22kT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395770725689152_p
w(1)=6.137601861121186_p
x(2)=-1.506528868399424_p
w(2)=4.862414840161186_p
else if(N==3)then
x(1)=-9.486303608516359_p
w(1)=3.723464926718758_p
x(2)=-4.368236996650173_p
w(2)=5.649031923937806_p
x(3)=7.022726371704054e-1_p
w(3)=1.627519850625808_p
else if(N==4)then
x(1)=-9.985595710110172_p
w(1)=2.537352984133358_p
x(2)=-6.216230087441329_p
w(2)=4.648361546903528_p
x(3)=-1.557013222297210_p
w(3)=3.520571058830406_p
x(4)=2.922997515281173_p
w(4)=2.937311114150792e-1_p
else if(N==5)then
x(1)=-10.25758074614298_p
w(1)=1.872518454107421_p
x(2)=-7.369964763970667_p
w(2)=3.725154973486316_p
x(3)=-3.285237745811199_p
w(3)=3.990360868886112_p
x(4)=5.547883669497830e-1_p
w(4)=1.385444424709252_p
x(5)=5.545240205626312_p
w(5)=2.653798009327095e-2_p
else if(N==6)then
x(1)=-10.42411792493033_p
w(1)=1.459400485382946_p
x(2)=-8.125679777990223_p
w(2)=3.036361796333316_p
x(3)=-4.629371118158447_p
w(3)=3.737711121448142_p
x(4)=-9.783553258405789e-1_p
w(4)=2.484587907666786_p
x(5)=2.677551844379412_p
w(5)=2.803453526475274e-1_p
x(6)=8.461017280487267_p
w(6)=1.610037803653478e-3_p
else if(N==7)then
x(1)=-10.53527629838167_p
w(1)=1.181235939808347_p
x(2)=-8.650271779969236_p
w(2)=2.526214713066288_p
x(3)=-5.656730463615285_p
w(3)=3.335468366415710_p
x(4)=-2.239538991725111_p
w(4)=3.012109607762544_p
x(5)=9.809775713028918e-1_p
w(5)=9.138468635918068e-1_p
x(6)=5.086857044219744_p
w(6)=3.105807542415360e-2_p
x(7)=11.49512641946065_p
w(7)=8.313521352211321e-5_p
else if(N==8)then
x(1)=-10.61493675405752_p
w(1)=9.807442542368292e-1_p
x(2)=-9.035912046502782_p
w(2)=2.136356578037611_p
x(3)=-6.456975442842913_p
w(3)=2.941988685663413_p
x(4)=-3.332178666707262_p
w(4)=3.076631625653133_p
x(5)=-2.716616315344598e-1_p
w(5)=1.680670537547012_p
x(6)=3.004293872435212_p
w(6)=1.809690693091342e-1_p
x(7)=7.641276257084709_p
w(7)=2.651275641296882e-3_p
x(8)=14.39101959087986_p
w(8)=4.675193942461602e-6_p
else if(N==9)then
x(1)=-10.6752517608227_p
w(1)=8.283270393871186e-1_p
x(2)=-9.333143036440102_p
w(2)=1.828017983930171_p
x(3)=-7.097854127498941_p
w(3)=2.589136694104934_p
x(4)=-4.279445466230934_p
w(4)=2.924830965895037_p
x(5)=-1.347765259930577_p
w(5)=2.247944891205925_p
x(6)=1.515189260823999_p
w(6)=5.571880687303243e-1_p
x(7)=5.159008150118620_p
w(7)=2.433959793577148e-2_p
x(8)=10.11703925964203_p
w(8)=2.310694439878103e-4_p
x(9)=16.79726884184833_p
w(9)=3.906491022078756e-7_p
else if(N==10)then
x(1)=-10.72248542258679_p
w(1)=7.086144678687988e-1_p
x(2)=-9.568935769065190_p
w(2)=1.578937542429919_p
x(3)=-7.620098215813132_p
w(3)=2.281442546486472_p
x(4)=-5.093970781394473_p
w(4)=2.697581191107720_p
x(5)=-2.327946739062605_p
w(5)=2.499686879403829_p
x(6)=3.449200606593084e-1_p
w(6)=1.114225864355172_p
x(7)=3.350598055415915_p
w(7)=1.164878211884084e-1_p
x(8)=7.301982982069493_p
w(8)=3.015831244781791e-3_p
x(9)=12.34703772208287_p
w(9)=2.449902302014117e-5_p
x(10)=18.51830598705102_p
w(10)=5.817424975015478e-8_p
else if(N==11)then
x(1)=-10.76020906593633_p
w(1)=6.127943645511649e-1_p
x(2)=-9.759072257628697_p
w(2)=1.375421398641141_p
x(3)=-8.049508606223897_p
w(3)=2.016882385519152_p
x(4)=-5.788856679769641_p
w(4)=2.456740503143249_p
x(5)=-3.218497046681080_p
w(5)=2.517056828992501_p
x(6)=-6.554786074724327e-1_p
w(6)=1.647930620437915_p
x(7)=1.961632206263598_p
w(7)=3.530958888096832e-1_p
x(8)=5.224557587043724_p
w(8)=1.968616542226641e-2_p
x(9)=9.318476348278997_p
w(9)=4.050786957426215e-4_p
x(10)=14.2469831086436_p
w(10)=3.452293239109634e-6_p
x(11)=19.63510489578518_p
w(11)=1.477631711386979e-8_p
else if(N==12)then
x(1)=-10.79078287515293_p
w(1)=5.350047892576176e-1_p
x(2)=-9.914303006740941_p
w(2)=1.207620875537014_p
x(3)=-8.405228357945095_p
w(3)=1.790752235180577_p
x(4)=-6.379773943396530_p
w(4)=2.227112520449316_p
x(5)=-4.013849411003880_p
w(5)=2.414504685591650_p
x(6)=-1.559241241690967_p
w(6)=1.992965745381460_p
x(7)=8.459312237148280e-1_p
w(7)=7.474410197193379e-1_p
x(8)=3.612678873129031_p
w(8)=8.127864883534372e-2_p
x(9)=7.049330850689695_p
w(9)=3.271818792762733e-3_p
x(10)=11.14470399522558_p
w(10)=6.369362194165492e-5_p
x(11)=15.79863645215121_p
w(11)=6.633714165417977e-7_p
x(12)=20.3383879344436_p
w(12)=5.543934959567591e-9_p
else if(N==13)then
x(1)=-10.81588574123735_p
w(1)=4.710514811465908e-1_p
x(2)=-10.04248297018295_p
w(2)=1.068009963289289_p
x(3)=-8.702252962264030_p
w(3)=1.597557546880472_p
x(4)=-6.882795695538174_p
w(4)=2.017428854004301_p
x(5)=-4.715218520939407_p
w(5)=2.264088882512664_p
x(6)=-2.389004044001511_p
w(6)=2.131746731393701_p
x(7)=-1.005887415295598e-1_p
w(7)=1.196712034526147_p
x(8)=2.324075296378168_p
w(8)=2.362005266768455e-1_p
x(9)=5.263866863245673_p
w(9)=1.662008499783217e-2_p
x(10)=8.762178976931693_p
w(10)=5.882649169815624e-4_p
x(11)=12.75063504203507_p
w(11)=1.215717341650964e-5_p
x(12)=17.02795412930461_p
w(12)=1.710677166178385e-7_p
x(13)=20.78743046306032_p
w(13)=2.696413530520521e-9_p
else if(N==14)then
x(1)=-10.83674037791188_p
w(1)=4.178660501588260e-1_p
x(2)=-10.14945076027984_p
w(2)=9.508111106245652e-1_p
x(3)=-8.952294236858657_p
w(3)=1.432079090267808_p
x(4)=-7.312490093166018_p
w(4)=1.829638373099267_p
x(5)=-5.329813848584378_p
w(5)=2.101006296654239_p
x(6)=-3.146411307249481_p
w(6)=2.130834129694482_p
x(7)=-9.453493116198312e-1_p
w(7)=1.562155256216627_p
x(8)=1.264894281906899_p
w(8)=5.118861795654494e-1_p
x(9)=3.818061974321494_p
w(9)=6.018323284958972e-2_p
x(10)=6.856732911405895_p
w(10)=3.434378706948435e-3_p
x(11)=10.32837615164023_p
w(11)=1.196977753058272e-4_p
x(12)=14.13073332275012_p
w(12)=2.847179590799271e-6_p
x(13)=17.98443962212141_p
w(13)=5.693502251706944e-8_p
x(14)=21.08360448726824_p
w(14)=1.554650568516216e-9_p
else if(N==15)then
x(1)=-10.85424999351805_p
w(1)=3.731740933963150e-1_p
x(2)=-10.23958657999543_p
w(2)=8.515870386977168e-1_p
x(3)=-9.164457631979722_p
w(3)=1.289766866093824_p
x(4)=-7.681263122597229_p
w(4)=1.662913817387571_p
x(5)=-5.867332349153441_p
w(5)=1.940932096114798_p
x(6)=-3.830846304070521_p
w(6)=2.056622683455952_p
x(7)=-1.720765305814770_p
w(7)=1.776724909047873_p
x(8)=3.626676881250057e-1_p
w(8)=8.673528321655333e-1_p
x(9)=2.624527163717884_p
w(9)=1.657582357819600e-1_p
x(10)=5.292017968888990_p
w(10)=1.439271555566754e-2_p
x(11)=8.352731553637113_p
w(11)=7.624423734402147e-4_p
x(12)=11.73250738920169_p
w(12)=2.813424112685006e-5_p
x(13)=15.29687366457758_p
w(13)=8.126192400320969e-7_p
x(14)=18.72342122100772_p
w(14)=2.334691256580186e-8_p
x(15)=21.28625340605754_p
w(15)=1.004441000933503e-9_p
else if(N==16)then
x(1)=-10.86909147550735_p
w(1)=3.352665086364345e-1_p
x(2)=-10.31621289886471_p
w(2)=7.669118388410945e-1_p
x(3)=-9.345837114649527_p
w(3)=1.166799321296754_p
x(4)=-7.999388630352069_p
w(4)=1.515386593920172_p
x(5)=-6.337756396242839_p
w(5)=1.790404115224671_p
x(6)=-4.444782746889043_p
w(6)=1.950226574533434_p
x(7)=-2.436667752709975_p
w(7)=1.856407332514206_p
x(8)=-4.370509800869994e-1_p
w(8)=1.208588918111076_p
x(9)=1.621494552439935_p
w(9)=3.597291247373627e-1_p
x(10)=3.984136262484903_p
w(10)=4.657848239918108e-2_p
x(11)=6.706796409345396_p
w(11)=3.522782661962525e-3_p
x(12)=9.731261085228239_p
w(12)=1.871364362740065e-4_p
x(13)=12.97263234769381_p
w(13)=7.682229181494827e-6_p
x(14)=16.27131393763202_p
w(14)=2.777472012944983e-7_p
x(15)=19.2951049537031_p
w(15)=1.129119563179531e-8_p
x(16)=21.42982267048072_p
w(16)=7.021710697585301e-10_p
else if(N==17)then
x(1)=-10.88177945912765_p
w(1)=3.028410544024362e-1_p
x(2)=-10.38188020500459_p
w(2)=6.941191086546081e-1_p
x(3)=-9.501992390647091_p
w(3)=1.060018245231747_p
x(4)=-8.275277297618958_p
w(4)=1.384906274895965_p
x(5)=-6.750346288287338_p
w(5)=1.651758128917645_p
x(6)=-4.993311170117702_p
w(6)=1.833088749882385_p
x(7)=-3.094494269486051_p
w(7)=1.848087079109840_p
x(8)=-1.167831212787201_p
w(8)=1.458125266762972_p
x(9)=7.588724077412146e-1_p
w(9)=6.321092309994126e-1_p
x(10)=2.876820890328661_p
w(10)=1.212991769897078e-1_p
x(11)=5.313780384637384_p
w(11)=1.269107553510817e-2_p
x(12)=8.037849690621760_p
w(12)=9.193385426923278e-4_p
x(13)=10.98376036065138_p
w(13)=5.142618344261709e-5_p
x(14)=14.05593056613926_p
w(14)=2.427285089610566e-6_p
x(15)=17.08064017604543_p
w(15)=1.111611774935308e-7_p
x(16)=19.74035110261647_p
w(16)=6.208725482027871e-9_p
x(17)=21.53473831879542_p
w(17)=5.194173735505438e-10_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;22kT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589291626734211_p
w(1)=5.675311839692591_p
x(2)=-1.221802136915889_p
w(2)=4.324733558927679_p
else if(N==3)then
x(1)=-8.585496986823140_p
w(1)=3.477525173970648_p
x(2)=-3.820532015161027_p
w(2)=5.186811460301016_p
x(3)=9.860651143356638e-1_p
w(3)=1.335708764348606_p
else if(N==4)then
x(1)=-9.045160646654363_p
w(1)=2.387424340930809_p
x(2)=-5.505487751340281_p
w(2)=4.342770380499458_p
x(3)=-1.157848049637747_p
w(3)=3.060110572599653_p
x(4)=3.295905490805068_p
w(4)=2.097401045903512e-1_p
else if(N==5)then
x(1)=-9.297208021226607_p
w(1)=1.772023846006091_p
x(2)=-6.568287366194782_p
w(2)=3.510967000371581_p
x(3)=-2.735941103870497_p
w(3)=3.627044646112117_p
x(4)=9.336492850169783e-1_p
w(4)=1.073044695169748_p
x(5)=6.005365878253798_p
w(5)=1.696521096073259e-2_p
else if(N==6)then
x(1)=-9.452451833791249_p
w(1)=1.387243725564082_p
x(2)=-7.269898146515167_p
w(2)=2.878239283309456_p
x(3)=-3.967100303295994_p
w(3)=3.480329038907697_p
x(4)=-5.349162638401463e-1_p
w(4)=2.066094861276995_p
x(5)=3.126148222256876_p
w(5)=1.871731548722107e-1_p
x(6)=8.977927650903158_p
w(6)=9.653346898286291e-4_p
else if(N==7)then
x(1)=-9.556726664119619_p
w(1)=1.126473450667387_p
x(2)=-7.760550494702233_p
w(2)=2.404145590099602_p
x(3)=-4.918604225200371_p
w(3)=3.142868332490075_p
x(4)=-1.704551771946904_p
w(4)=2.649790928055110_p
x(5)=1.423325594477804_p
w(5)=6.578484394576761e-1_p
x(6)=5.598349778195492_p
w(6)=1.887012825635055e-2_p
x(7)=12.03316594643307_p
w(7)=4.852959406946361e-5_p
else if(N==8)then
x(1)=-9.631960688281088_p
w(1)=9.372175467288962e-1_p
x(2)=-8.123960937600012_p
w(2)=2.038332175025384_p
x(3)=-5.667655330035247_p
w(3)=2.789722789871295_p
x(4)=-2.714634201388834_p
w(4)=2.808337378747023_p
x(5)=1.928826208617571e-1_p
w(5)=1.310462255853412_p
x(6)=3.498304470724310_p
w(6)=1.144092969545022e-1_p
x(7)=8.172455676865072_p
w(7)=1.561151086950071e-3_p
x(8)=14.88950482990246_p
w(8)=2.804352807656794e-6_p
else if(N==9)then
x(1)=-9.689210752035150_p
w(1)=7.926031972353541e-1_p
x(2)=-8.405614683292301_p
w(2)=1.747043062965154_p
x(3)=-6.272073526752106_p
w(3)=2.464249478195562_p
x(4)=-3.597235111181148_p
w(4)=2.725580459785953_p
x(5)=-8.324563149078917e-1_p
w(5)=1.879467443098309_p
x(6)=1.992586271689195_p
w(6)=3.764022044539972e-1_p
x(7)=5.679724045696291_p
w(7)=1.456169313426695e-2_p
x(8)=10.62795588198448_p
w(8)=1.376054834859612e-4_p
x(9)=17.19353216780321_p
w(9)=2.542681884060020e-7_p
else if(N==10)then
x(1)=-9.734157102462945_p
w(1)=6.787248541789725e-1_p
x(2)=-8.629693069605857_p
w(2)=1.510876875872657_p
x(3)=-6.766650335299645_p
w(3)=2.176724015201893_p
x(4)=-4.361582399368604_p
w(4)=2.542221228421682_p
x(5)=-1.750007658928026_p
w(5)=2.203236576449776_p
x(6)=8.243866352543850e-1_p
w(6)=8.147663975027476e-1_p
x(7)=3.859498921101166_p
w(7)=7.168729846220084e-2_p
x(8)=7.817675546890045_p
w(8)=1.792952115774080e-3_p
x(9)=12.81047072706638_p
w(9)=1.515865484373747e-5_p
x(10)=18.79744348945424_p
w(10)=4.175972405960377e-8_p
else if(N==11)then
x(1)=-9.770102450653765_p
w(1)=5.874464874846721e-1_p
x(2)=-8.810674506208114_p
w(2)=1.317502506437136_p
x(3)=-7.174308811176474_p
w(3)=1.927768049839991_p
x(4)=-5.016923795553501_p
w(4)=2.330162807252717_p
x(5)=-2.581295645883895_p
w(5)=2.295694922611567_p
x(6)=-1.479960435679518e-1_p
w(6)=1.301322647224746_p
x(7)=2.459564639069311_p
w(7)=2.281565253526071e-1_p
x(8)=5.742443042315037_p
w(8)=1.174398349975887e-2_p
x(9)=9.808690457239020_p
w(9)=2.452059854667472e-4_p
x(10)=14.64881293696213_p
w(10)=2.251425842767492e-6_p
x(11)=19.82194213993987_p
w(11)=1.150576537348225e-8_p
else if(N==12)then
x(1)=-9.799266438298476_p
w(1)=5.132609727163527e-1_p
x(2)=-8.958619235163624_p
w(2)=1.157802899981375_p
x(3)=-7.512636739444888_p
w(3)=1.714023118397296_p
x(4)=-5.576243442637177_p
w(4)=2.120758056956199_p
x(5)=-3.326515943721167_p
w(5)=2.246886019155221_p
x(6)=-1.005635782729341_p
w(6)=1.679178980595532_p
x(7)=1.341608342627278_p
w(7)=5.169223639822029e-1_p
x(8)=4.129015740687675_p
w(8)=4.921669691239090e-2_p
x(9)=7.555625304543751_p
w(9)=1.956025952669686e-3_p
x(10)=11.59673163718937_p
w(10)=3.980136564480340e-5_p
x(11)=16.13544637111591_p
w(11)=4.580321338656424e-7_p
x(12)=20.46371503607902_p
w(12)=4.573251495592181e-9_p
else if(N==13)then
x(1)=-9.823235563825998_p
w(1)=4.522080419499808e-1_p
x(2)=-9.080922664246318_p
w(2)=1.024744712593175_p
x(3)=-7.795580670497710_p
w(3)=1.530827981522393_p
x(4)=-6.053688904725901_p
w(4)=1.926174308412465_p
x(5)=-3.986854769706536_p
w(5)=2.131508556832857_p
x(6)=-1.784353463990693_p
w(6)=1.883779123282941_p
x(7)=4.096210170867378e-1_p
w(7)=8.926437545334942e-1_p
x(8)=2.836124564716235_p
w(8)=1.479004527359327e-1_p
x(9)=5.779961367742025_p
w(9)=9.892117258290475e-3_p
x(10)=9.243729234833559_p
w(10)=3.583204845470851e-4_p
x(11)=13.15755667840677_p
w(11)=7.901976950213413e-6_p
x(12)=17.30408889118024_p
w(12)=1.247244401423038e-7_p
x(13)=20.87382641244338_p
w(13)=2.312803803773215e-9_p
else if(N==14)then
x(1)=-9.843166434931209_p
w(1)=4.013871513912413e-1_p
x(2)=-9.183091204081581_p
w(2)=9.129097570356223e-1_p
x(3)=-8.034086620234921_p
w(3)=1.373536979731831_p
x(4)=-6.462420709293337_p
w(4)=1.750170840830207_p
x(5)=-4.567891997453204_p
w(5)=1.991697193197131_p
x(6)=-2.494455875168818_p
w(6)=1.942654098595097_p
x(7)=-4.037715289366387e-1_p
w(7)=1.251116969854349_p
x(8)=1.774990146666082_p
w(8)=3.383850779485096e-1_p
x(9)=4.338751479433151_p
w(9)=3.605239734676177e-2_p
x(10)=7.358072755904751_p
w(10)=2.057992720222287e-3_p
x(11)=10.7772303932961_p
w(11)=7.496457125780642e-5_p
x(12)=14.49041269305433_p
w(12)=1.930485352514620e-6_p
x(13)=18.20839356509784_p
w(13)=4.354341592852520e-8_p
x(14)=21.14525811170373_p
w(14)=1.369271297083250e-9_p
else if(N==15)then
x(1)=-9.859914182466502_p
w(1)=3.586462003862703e-1_p
x(2)=-9.269261585901040_p
w(2)=8.181259915103277e-1_p
x(3)=-8.236694207988155_p
w(3)=1.238010616874062_p
x(4)=-6.813812688598260_p
w(4)=1.592938261668729_p
x(5)=-5.077705323521692_p
w(5)=1.847959613581522_p
x(6)=-3.138170612650728_p
w(6)=1.911329409562443_p
x(7)=-1.138354827003647_p
w(7)=1.508464926624472_p
x(8)=8.801509021040222e-1_p
w(8)=6.140035787407854e-1_p
x(9)=3.145886175777641_p
w(9)=1.015312932452827e-1_p
x(10)=5.806774881230258_p
w(10)=8.551209682551712e-3_p
x(11)=8.830292815279751_p
w(11)=4.654980824402799e-4_p
x(12)=12.14448261090398_p
w(12)=1.820477044474373e-5_p
x(13)=15.61076978647993_p
w(13)=5.744078411338270e-7_p
x(14)=18.90472727457544_p
w(14)=1.858197131124666e-8_p
x(15)=21.33176265865314_p
w(15)=9.011269599920425e-10_p
else if(N==16)then
x(1)=-9.874120361468677_p
w(1)=3.223660968419185e-1_p
x(2)=-9.342576294969682_p
w(2)=7.371646770924419e-1_p
x(3)=-8.410076289529384_p
w(3)=1.120727833634381_p
x(4)=-7.117375318441335_p
w(4)=1.453225989757206_p
x(5)=-5.524998483301216_p
w(5)=1.709579079817328_p
x(6)=-3.717828380038468_p
w(6)=1.833728658515329_p
x(7)=-1.812079135554714_p
w(7)=1.644556796398362_p
x(8)=1.007447474396822e-1_p
w(8)=9.190944310986112e-1_p
x(9)=2.142842180909996_p
w(9)=2.296659680079123e-1_p
x(10)=4.507198305086301_p
w(10)=2.770037747316394e-2_p
x(11)=7.205213170621916_p
w(11)=2.112973881855460e-3_p
x(12)=10.17975061667795_p
w(12)=1.171563814951446e-4_p
x(13)=13.34639933944065_p
w(13)=5.145707807862175e-6_p
x(14)=16.54314691142542_p
w(14)=2.040919181514514e-7_p
x(15)=19.44251599780144_p
w(15)=9.282206689072830e-9_p
x(16)=21.46444711139441_p
w(16)=6.383328073198239e-10_p
else if(N==17)then
x(1)=-9.886273294365120_p
w(1)=2.913117073880294e-1_p
x(2)=-9.405451160892669_p
w(2)=6.675075908869810e-1_p
x(3)=-8.559475734368034_p
w(3)=1.018754601478932_p
x(4)=-7.380947112864793_p
w(4)=1.329286186329004_p
x(5)=-5.918070822084502_p
w(5)=1.580403482633578_p
x(6)=-4.237514242764287_p
w(6)=1.736135185398461_p
x(7)=-2.431081609761570_p
w(7)=1.684399342071875_p
x(8)=-5.992028021414046e-1_p
w(8)=1.183131465427798_p
x(9)=1.284627043616321_p
w(9)=4.278290368309232e-1_p
x(10)=3.404129580041107_p
w(10)=7.316012489557937e-2_p
x(11)=5.827412376563293_p
w(11)=7.530147088188557e-3_p
x(12)=8.513548525490522_p
w(12)=5.616316981394819e-4_p
x(13)=11.40046988370404_p
w(13)=3.312350583870266e-5_p
x(14)=14.39223226316782_p
w(14)=1.682698363137328e-6_p
x(15)=17.31521284913089_p
w(15)=8.457370389370847e-8_p
x(16)=19.8611493563446_p
w(16)=5.238042219381032e-9_p
x(17)=21.56178132132228_p
w(17)=4.768342574639167e-10_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;22kT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781260879617847_p
w(1)=5.214314185363553_p
x(2)=-9.236268829253570e-1_p
w(2)=3.785809216547224_p
else if(N==3)then
x(1)=-7.683954709251573_p
w(1)=3.232599983475973_p
x(2)=-3.271351382767658_p
w(2)=4.705940897242142_p
x(3)=1.297721217897511_p
w(3)=1.061582521192662_p
else if(N==4)then
x(1)=-8.104411773841999_p
w(1)=2.237898689857334_p
x(2)=-4.794791316650739_p
w(2)=4.027679535109755_p
x(3)=-7.490307740701521e-1_p
w(3)=2.590669795010827_p
x(4)=3.704086004341264_p
w(4)=1.438753819328607e-1_p
else if(N==5)then
x(1)=-8.336732271830080_p
w(1)=1.671564751986884_p
x(2)=-5.766981283004879_p
w(2)=3.292131529137875_p
x(3)=-2.188359944062432_p
w(3)=3.230880750200384_p
x(4)=1.341967111049415_p
w(4)=7.950594631949752e-1_p
x(5)=6.497160803053084_p
w(5)=1.048690739065831e-2_p
else if(N==6)then
x(1)=-8.480800765301385_p
w(1)=1.314900591497030_p
x(2)=-6.414710861639160_p
w(2)=2.717266877803969_p
x(3)=-3.308661579684868_p
w(3)=3.197930503469085_p
x(4)=-7.910036076668819e-2_p
w(4)=1.649909801111665_p
x(5)=3.610195377792748_p
w(5)=1.195524948871882e-1_p
x(6)=9.521229350650760_p
w(6)=5.631331418392650e-4_p
else if(N==7)then
x(1)=-8.578268953954540_p
w(1)=1.071372117146816_p
x(2)=-6.871615442253135_p
w(2)=2.279937892860513_p
x(3)=-4.184197039078437_p
w(3)=2.935145742158056_p
x(4)=-1.170992926736861_p
w(4)=2.253298752948492_p
x(5)=1.897332869312858_p
w(5)=4.492264503656405e-1_p
x(6)=6.137629088375494_p
w(6)=1.111464273712263e-2_p
x(7)=12.58817814775987_p
w(7)=2.780369413608798e-5_p
else if(N==8)then
x(1)=-8.649109988070695_p
w(1)=8.932933726624406e-1_p
x(2)=-7.212854257428773_p
w(2)=1.938578726825481_p
x(3)=-4.881566697667615_p
w(3)=2.628260506896185_p
x(4)=-2.103652993016113_p
w(4)=2.500457701261644_p
x(5)=6.760872567677052e-1_p
w(5)=9.691192592790689e-1_p
x(6)=4.022527845397589_p
w(6)=6.951138857617935e-2_p
x(7)=8.721786880743974_p
w(7)=9.007730390404497e-4_p
x(8)=15.389292541859_p
w(8)=1.673370736883857e-6_p
else if(N==9)then
x(1)=-8.703288486296117_p
w(1)=7.565161553926969e-1_p
x(2)=-7.478831518754224_p
w(2)=1.664712106700255_p
x(3)=-5.448873024507485_p
w(3)=2.333538791111228_p
x(4)=-2.921692487813718_p
w(4)=2.497272676017112_p
x(5)=-3.126327131667641e-1_p
w(5)=1.497967796993032_p
x(6)=2.500394949555282_p
w(6)=2.415369840478708e-1_p
x(7)=6.221565805598221_p
w(7)=8.497739229046106e-3_p
x(8)=11.14826478179997_p
w(8)=8.098601920522382e-5_p
x(9)=17.57889337878012_p
w(9)=1.664003301783377e-7_p
else if(N==10)then
x(1)=-8.745928093588621_p
w(1)=6.485336368525662e-1_p
x(2)=-7.691055801748042_p
w(2)=1.441771840726306_p
x(3)=-5.915190883204670_p
w(3)=2.068148854068020_p
x(4)=-3.634593577301664_p
w(4)=2.368255694783736_p
x(5)=-1.176135798133462_p
w(5)=1.867770185667236_p
x(6)=1.327721423502207_p
w(6)=5.619313634504102e-1_p
x(7)=4.393592695342914_p
w(7)=4.265374119471843e-2_p
x(8)=8.347195328378291_p
w(8)=1.048725199178421e-3_p
x(9)=13.27645660152234_p
w(9)=9.329744197500753e-6_p
x(10)=19.0634294006342_p
w(10)=3.022440803726482e-8_p
else if(N==11)then
x(1)=-8.780077850809308_p
w(1)=5.618498557162739e-1_p
x(2)=-7.862767245730069_p
w(2)=1.258766277529099_p
x(3)=-6.300658616982013_p
w(3)=1.835973052291488_p
x(4)=-4.249152451842814_p
w(4)=2.191887468371131_p
x(5)=-1.950941523931632_p
w(5)=2.034600335964368_p
x(6)=3.717200503357447e-1_p
w(6)=9.693008238641855e-1_p
x(7)=2.985399722581115_p
w(7)=1.407394216903137e-1_p
x(8)=6.277996276402769_p
w(8)=6.857800873430734e-3_p
x(9)=10.30707031085837_p
w(9)=1.468894718905669e-4_p
x(10)=15.04848685870496_p
w(10)=1.467119657137170e-6_p
x(11)=19.99850598080328_p
w(11)=9.018939256232540e-9_p
else if(N==12)then
x(1)=-8.807818673261304_p
w(1)=4.913089781815839e-1_p
x(2)=-8.003339680570431_p
w(2)=1.107329624286548_p
x(3)=-6.621281053870146_p
w(3)=1.635345500608314_p
x(4)=-4.775927981460800_p
w(4)=2.006853671238772_p
x(5)=-2.645852970608274_p
w(5)=2.049288750163073_p
x(6)=-4.505005508124913e-1_p
w(6)=1.342614776865896_p
x(7)=1.863064032682311_p
w(7)=3.372589307321156e-1_p
x(8)=4.666947248376769_p
w(8)=2.894541247524971e-2_p
x(9)=8.073811705348586_p
w(9)=1.152714742740325e-3_p
x(10)=12.05248148484127_p
w(10)=2.472199327805832e-5_p
x(11)=16.46750869302574_p
w(11)=3.168342482682457e-7_p
x(12)=20.58207899705017_p
w(12)=3.788957123537648e-9_p
else if(N==13)then
x(1)=-8.830643622633325_p
w(1)=4.331880646939719e-1_p
x(2)=-8.119700590683916_p
w(2)=9.809432418444579e-1_p
x(3)=-6.889914434013281_p
w(3)=1.462628333022030_p
x(4)=-5.227106188081495_p
w(4)=1.829848897253258_p
x(5)=-3.264106736606649_p
w(5)=1.978580193163432_p
x(6)=-1.184274925474376_p
w(6)=1.595580350341125_p
x(7)=9.377535091672573e-1_p
w(7)=6.244522660919519e-1_p
x(8)=3.373047769641853_p
w(8)=8.890292321217615e-2_p
x(9)=6.311290802158060_p
w(9)=5.777758003886353e-3_p
x(10)=9.732766165088282_p
w(10)=2.161592336965098e-4_p
x(11)=13.56493666424215_p
w(11)=5.121860578590925e-6_p
x(12)=17.57459441130404_p
w(12)=9.120142672866939e-8_p
x(13)=20.95566037657442_p
w(13)=1.988785190761903e-9_p
else if(N==14)then
x(1)=-8.849642349140776_p
w(1)=3.847570248591045e-1_p
x(2)=-8.217017991468405_p
w(2)=8.745624959527198e-1_p
x(3)=-7.116711363580892_p
w(3)=1.313851732092073_p
x(4)=-5.614369513856333_p
w(4)=1.667154942698067_p
x(5)=-3.810493851552125_p
w(5)=1.868897911028298_p
x(6)=-1.849088774748251_p
w(6)=1.715740770261868_p
x(7)=1.455812062423446e-1_p
w(7)=9.409897127000409e-1_p
x(8)=2.310366863126579_p
w(8)=2.118506320976257e-1_p
x(9)=4.878144099454263_p
w(9)=2.105283377846189e-2_p
x(10)=7.869905073512572_p
w(10)=1.217345046950217e-3_p
x(11)=11.23018685424913_p
w(11)=4.665865370506621e-5_p
x(12)=14.84840357048887_p
w(12)=1.308132194398828e-6_p
x(13)=18.42688876231845_p
w(13)=3.340211282050143e-8_p
x(14)=21.20389508446111_p
w(14)=1.207554833414087e-9_p
else if(N==15)then
x(1)=-8.865621384540752_p
w(1)=3.439876821382958e-1_p
x(2)=-8.299181321538024_p
w(2)=7.842892247196512e-1_p
x(3)=-7.309628674149206_p
w(3)=1.185343325676997_p
x(4)=-5.948004033910467_p
w(4)=1.520384518632734_p
x(5)=-4.291696936755192_p
w(5)=1.745934960620726_p
x(6)=-2.451973423794162_p
w(6)=1.736011016791964_p
x(7)=-5.562956034744823e-1_p
w(7)=1.211549901478058_p
x(8)=1.418636150509335_p
w(8)=4.073254250603345e-1_p
x(9)=3.689204959819251_p
w(9)=6.000795765927439e-2_p
x(10)=6.334896057044934_p
w(10)=4.995585657931613e-3_p
x(11)=9.314784001016960_p
w(11)=2.816446884196233e-4_p
x(12)=12.55803941875499_p
w(12)=1.173684629296638e-5_p
x(13)=15.9217625294352_p
w(13)=4.063028988474720e-7_p
x(14)=19.08122334446106_p
w(14)=1.482836440126825e-8_p
x(15)=21.37522684677137_p
w(15)=8.088331424471492e-10_p
else if(N==16)then
x(1)=-8.879186605918765_p
w(1)=3.093520361754853e-1_p
x(2)=-8.369150571988387_p
w(2)=7.070973928066322e-1_p
x(3)=-7.474907239600585_p
w(3)=1.073915394684234_p
x(4)=-6.236718298147347_p
w(4)=1.389129364338517_p
x(5)=-4.715155951970360_p
w(5)=1.622518830470070_p
x(6)=-2.996509024705459_p
w(6)=1.695873332097289_p
x(7)=-1.192266975558812_p
w(7)=1.392837612526927_p
x(8)=6.515875091532073e-1_p
w(8)=6.523484334969505e-1_p
x(9)=2.687809875977752_p
w(9)=1.396164937143852e-1_p
x(10)=5.046647220133291_p
w(10)=1.610559414702434e-2_p
x(11)=7.713052252488265_p
w(11)=1.252426241106175e-3_p
x(12)=10.63245174153086_p
w(12)=7.289241299945464e-5_p
x(13)=13.71997006392574_p
w(13)=3.440403976997603e-6_p
x(14)=16.81154362883735_p
w(14)=1.501684423699781e-7_p
x(15)=19.58588989159264_p
w(15)=7.646460897034434e-9_p
x(16)=21.49764450567475_p
w(16)=5.802771267939684e-10_p
else if(N==17)then
x(1)=-8.890799774176767_p
w(1)=2.796828370372275e-1_p
x(2)=-8.429205151520994_p
w(2)=6.406206848303998e-1_p
x(3)=-7.617465779471726_p
w(3)=9.768780413184182e-1_p
x(4)=-6.487752573119021_p
w(4)=1.272170589845038_p
x(5)=-5.088172528485649_p
w(5)=1.504621599662418_p
x(6)=-3.486407831421863_p
w(6)=1.624371995147591_p
x(7)=-1.773941008094826_p
w(7)=1.483428135876690_p
x(8)=-2.592011943990910e-2_p
w(8)=8.986795805101733e-1_p
x(9)=1.832340763178356_p
w(9)=2.721433413248305e-1_p
x(10)=3.950838249518586_p
w(10)=4.276375355096509e-2_p
x(11)=6.352937610983206_p
w(11)=4.400169057608090e-3_p
x(12)=8.995714061501101_p
w(12)=3.401906545557858e-4_p
x(13)=11.81933814458992_p
w(13)=2.124797045881219e-5_p
x(14)=14.72716992602163_p
w(14)=1.165816294993987e-6_p
x(15)=17.54625829158768_p
w(15)=6.444473496314968e-8_p
x(16)=19.97863790244931_p
w(16)=4.425796822109783e-9_p
x(17)=21.58779998915277_p
w(17)=4.375749101409981e-10_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;22kT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971704517860486_p
w(1)=4.752845944426201_p
x(2)=-6.083139142843190e-1_p
w(2)=3.247489461667748_p
else if(N==3)then
x(1)=-6.781797726073385_p
w(1)=2.987694148912402_p
x(2)=-2.720433514631267_p
w(2)=4.201208018605861_p
x(3)=1.642722768345826_p
w(3)=8.114332385756862e-1_p
else if(N==4)then
x(1)=-7.163468878284527_p
w(1)=2.088104902244673_p
x(2)=-4.084947880157560_p
w(2)=3.696886098020137_p
x(3)=-3.256898137315221e-1_p
w(3)=2.120825673799144_p
x(4)=4.150586833914934_p
w(4)=9.451873202999556e-2_p
else if(N==5)then
x(1)=-7.376258073782192_p
w(1)=1.570642430125529_p
x(2)=-4.966814777393815_p
w(2)=3.064732011143098_p
x(3)=-1.641176614423028_p
w(3)=2.799110414845158_p
x(4)=1.785618998818009_p
w(4)=5.595913786777581e-1_p
x(5)=7.022188314265629_p
w(5)=6.259171302406468e-3_p
else if(N==6)then
x(1)=-7.509255969017772_p
w(1)=1.241974896965983_p
x(2)=-5.560752379079188_p
w(2)=2.550947237635494_p
x(3)=-2.654960319065217_p
w(3)=2.880633601479659_p
x(4)=3.961604445022108e-1_p
w(4)=1.253461713607806_p
x(5)=4.131334313280504_p
w(5)=7.299856087768501e-2_p
x(6)=10.091564738158_p
w(6)=3.193955273218174e-4_p
else if(N==7)then
x(1)=-7.599980793243839_p
w(1)=1.015611259119021_p
x(2)=-5.983977402938316_p
w(2)=2.151901940377542_p
x(3)=-3.454878359139089_p
w(3)=2.703664823182310_p
x(4)=-6.343204252033253e-1_p
w(4)=1.832786363980904_p
x(5)=2.407216621891541_p
w(5)=2.900065802818094e-1_p
x(6)=6.704640438540335_p
w(6)=6.348790450066967e-3_p
x(7)=13.15880370933001_p
w(7)=1.564870229604104e-5_p
else if(N==8)then
x(1)=-7.666444286491677_p
w(1)=8.487236933246705e-1_p
x(2)=-6.302974999062419_p
w(2)=1.835924232541491_p
x(3)=-4.099900856953622_p
w(3)=2.451612954818079_p
x(4)=-1.498042189042686_p
w(4)=2.148444868474792_p
x(5)=1.185259693564909_p
w(5)=6.744682756440216e-1_p
x(6)=4.576900523198683_p
w(6)=4.065078229033295e-2_p
x(7)=9.288527792566160_p
w(7)=5.096035272270225e-4_p
x(8)=15.88746587224037_p
w(8)=9.954733359076007e-7_p
else if(N==9)then
x(1)=-7.717529573621086_p
w(1)=7.198749380535138e-1_p
x(2)=-6.553076454987860_p
w(2)=1.580188688202371_p
x(3)=-4.629175011525363_p
w(3)=2.193022223860584_p
x(4)=-2.253456869015183_p
w(4)=2.229238486194528_p
x(5)=2.190971771894646e-1_p
w(5)=1.125776702630003_p
x(6)=3.040424284785896_p
w(6)=1.473454342259897e-1_p
x(7)=6.783937974655360_p
w(7)=4.841680924244365e-3_p
x(8)=11.67693017344496_p
w(8)=4.714235204493790e-5_p
x(9)=17.95143493607667_p
w(9)=1.096506709849275e-7_p
else if(N==10)then
x(1)=-7.757833694667847_p
w(1)=6.178872852400374e-1_p
x(2)=-6.753243752452269_p
w(2)=1.370997611030386_p
x(3)=-5.066436025724913_p
w(3)=1.953021584723155_p
x(4)=-2.914213904997597_p
w(4)=2.165711020060035_p
x(5)=-6.017791761610296e-1_p
w(5)=1.503229793246911_p
x(6)=1.860220998021121_p
w(6)=3.642888303813342e-1_p
x(7)=4.952267394963786_p
w(7)=2.458967449985927e-2_p
x(8)=8.889901363010036_p
w(8)=6.038682910477329e-4_p
x(9)=13.74391440481276_p
w(9)=5.716557544588473e-6_p
x(10)=19.31582733845866_p
w(10)=2.206363802601558e-8_p
else if(N==11)then
x(1)=-7.790164299442319_p
w(1)=5.358772189466170e-1_p
x(2)=-6.915527700600628_p
w(2)=1.198728329394831_p
x(3)=-5.429124056509504_p
w(3)=1.739611273532631_p
x(4)=-3.486765995636966_p
w(4)=2.034388145825639_p
x(5)=-1.325962677365309_p
w(5)=1.729326990212813_p
x(6)=9.113127356992623e-1_p
w(6)=6.752675835625626e-1_p
x(7)=3.539420453175183_p
w(7)=8.312380940561433e-2_p
x(8)=6.830518664069975_p
w(8)=3.923962566215351e-3_p
x(9)=10.81289918988377_p
w(9)=8.712958536694028e-5_p
x(10)=15.44508454088907_p
w(10)=9.559460689660386e-7_p
x(11)=20.16495839978879_p
w(11)=7.115590504159897e-9_p
else if(N==12)then
x(1)=-7.816463823801125_p
w(1)=4.690417066953000e-1_p
x(2)=-7.048609807452063_p
w(2)=1.055815681857915_p
x(3)=-5.731614862290274_p
w(3)=1.553353789805784_p
x(4)=-3.979893614551485_p
w(4)=1.880055165164823_p
x(5)=-1.972202374450737_p
w(5)=1.811124381079569_p
x(6)=1.131003235109714e-1_p
w(6)=1.005908579337897_p
x(7)=2.413234960821613_p
w(7)=2.077787160698117e-1_p
x(8)=5.225601203203818_p
w(8)=1.657184692084281e-2_p
x(9)=8.603252327046759_p
w(9)=6.700444008973065e-4_p
x(10)=12.51122990586143_p
w(10)=1.527194196593338e-5_p
x(11)=16.79418724125323_p
w(11)=2.196671758849328e-7_p
x(12)=20.6937217906683_p
w(12)=3.151966868400116e-9_p
else if(N==13)then
x(1)=-7.838130348888344_p
w(1)=4.139004216082691e-1_p
x(2)=-7.158937590968135_p
w(2)=9.362926623770644e-1_p
x(3)=-5.985622422112576_p
w(3)=1.391938318032666_p
x(4)=-4.403933349168184_p
w(4)=1.724680339369000_p
x(5)=-2.548030414317099_p
w(5)=1.794674102764604_p
x(6)=-5.845590469896965e-1_p
w(6)=1.275859580082547_p
x(7)=1.489946943622274_p
w(7)=4.080440937983879e-1_p
x(8)=3.934306346857837_p
w(8)=5.149798124362739e-2_p
x(9)=6.857099091718655_p
w(9)=3.315314537931756e-3_p
x(10)=10.2286765661921_p
w(10)=1.292114564521870e-4_p
x(11)=13.97213209637674_p
w(11)=3.312210675708503e-6_p
x(12)=17.83910745883687_p
w(12)=6.689867585025809e-8_p
x(13)=21.03311913564856_p
w(13)=1.714048607006149e-9_p
else if(N==14)then
x(1)=-7.856185484467401_p
w(1)=3.678973755800115e-1_p
x(2)=-7.251332589113949_p
w(2)=8.355108877918400e-1_p
x(3)=-6.200471182514652_p
w(3)=1.252239501191720_p
x(4)=-4.769063607669446_p
w(4)=1.577887364801908_p
x(5)=-3.058821581914528_p
w(5)=1.724003590365843_p
x(6)=-1.208762236228185_p
w(6)=1.445746923819438_p
x(7)=7.102401992421170e-1_p
w(7)=6.582007177589005e-1_p
x(8)=2.872171085430437_p
w(8)=1.260967219327813e-1_p
x(9)=5.435268055094483_p
w(9)=1.201125983366179e-2_p
x(10)=8.391605236591120_p
w(10)=7.112759331265712e-4_p
x(11)=11.68667178454617_p
w(11)=2.887412202821098e-5_p
x(12)=15.20419419346521_p
w(12)=8.861949849876851e-7_p
x(13)=18.63975357834985_p
w(13)=2.570161832180454e-8_p
x(14)=21.25964074346097_p
w(14)=1.066085898433591e-9_p
else if(N==15)then
x(1)=-7.871386475305036_p
w(1)=3.291306721354191e-1_p
x(2)=-7.329431823785620_p
w(2)=7.498601027054581e-1_p
x(3)=-6.383512969580743_p
w(3)=1.131147986249667_p
x(4)=-5.084435013812151_p
w(4)=1.443271217359251_p
x(5)=-3.510431638903715_p
w(5)=1.628391638308283_p
x(6)=-1.772361473999798_p
w(6)=1.520458581184900_p
x(7)=3.176829269223171e-2_p
w(7)=9.072755221435216e-1_p
x(8)=1.982192150451910_p
w(8)=2.533897953959985e-1_p
x(9)=4.253552777611266_p
w(9)=3.436030268159210e-2_p
x(10)=6.875617132945091_p
w(10)=2.872792763940730e-3_p
x(11)=9.805654516168190_p
w(11)=1.689527153971817e-4_p
x(12)=12.97267094630393_p
w(12)=7.542199298230972e-6_p
x(13)=16.22947886877788_p
w(13)=2.876613830105912e-7_p
x(14)=19.25284815969622_p
w(14)=1.186362424477736e-8_p
x(15)=21.41672740889739_p
w(15)=7.262153981721648e-10_p
else if(N==16)then
x(1)=-7.884303047390407_p
w(1)=2.961650281036142e-1_p
x(2)=-7.396009332617577_p
w(2)=6.765260645125443e-1_p
x(3)=-6.540541984260845_p
w(3)=1.025866021510973_p
x(4)=-5.357912703531252_p
w(4)=1.321609092272288_p
x(5)=-3.909210352252298_p
w(5)=1.524462686067775_p
x(6)=-2.281694556312589_p
w(6)=1.525854007315843_p
x(7)=-5.733598391581549e-1_p
w(7)=1.108679822730607_p
x(8)=1.222083567893243_p
w(8)=4.299697221977100e-1_p
x(9)=3.256412999613896_p
w(9)=8.124647385150614e-2_p
x(10)=5.601492681866313_p
w(10)=9.174906813693340e-3_p
x(11)=8.229709846066674_p
w(11)=7.340768667825659e-4_p
x(12)=11.08887333175702_p
w(12)=4.508962754363324e-5_p
x(13)=14.09292177038185_p
w(13)=2.296730036201257e-6_p
x(14)=17.07625052747149_p
w(14)=1.106541836531685e-7_p
x(15)=19.72522027277985_p
w(15)=6.311447694210057e-9_p
x(16)=21.529467987234_p
w(16)=5.274004634451123e-10_p
else if(N==17)then
x(1)=-7.895370054519553_p
w(1)=2.679022568030461e-1_p
x(2)=-7.453205647136084_p
w(2)=6.133005031410534e-1_p
x(3)=-6.676142743490784_p
w(3)=9.339825720372673e-1_p
x(4)=-5.596107491410439_p
w(4)=1.212416353890848_p
x(5)=-4.261486603614214_p
w(5)=1.420898116360327_p
x(6)=-2.741106126304937_p
w(6)=1.488539058572566_p
x(7)=-1.121492611821044_p
w(7)=1.241005552636867_p
x(8)=5.591959141374679e-1_p
w(8)=6.318380619965150e-1_p
x(9)=2.404232078076695_p
w(9)=1.633789871948043e-1_p
x(10)=4.515852473427410_p
w(10)=2.432012393416101e-2_p
x(11)=6.889606075140916_p
w(11)=2.534977466732804e-3_p
x(12)=9.483838053508466_p
w(12)=2.044023591245792e-4_p
x(13)=12.23993572425728_p
w(13)=1.357897227046173e-5_p
x(14)=15.06040790020877_p
w(14)=8.073971951973409e-7_p
x(15)=17.77361367933582_p
w(15)=4.918509440214056e-8_p
x(16)=20.09283388727661_p
w(16)=3.744737310218569e-9_p
x(17)=21.61282959887495_p
w(17)=4.013390143150545e-10_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;22kT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160732917165081_p
w(1)=4.287642544366085_p
x(2)=-2.708835299208364e-1_p
w(2)=2.713268921808742_p
else if(N==3)then
x(1)=-5.879248444960059_p
w(1)=2.740847793209440_p
x(2)=-2.166720763626244_p
w(2)=3.668240275799614_p
x(3)=2.027327112240315_p
w(3)=5.918233971657734e-1_p
else if(N==4)then
x(1)=-6.222528677931495_p
w(1)=1.936744491988155_p
x(2)=-3.376811109256233_p
w(2)=3.341515493584475_p
x(3)=1.188600389789844e-1_p
w(3)=1.663352609461020_p
x(4)=4.638380857998394_p
w(4)=5.929887114117752e-2_p
else if(N==5)then
x(1)=-6.415948264613556_p
w(1)=1.468314146238232_p
x(2)=-4.168805944396360_p
w(2)=2.822231463260948_p
x(3)=-1.091072259220236_p
w(3)=2.335028402795784_p
x(4)=2.270378718768931_p
w(4)=3.717356812640676e-1_p
x(5)=7.582087489610073_p
w(5)=3.601772615796369e-3_p
else if(N==6)then
x(1)=-6.537954077704303_p
w(1)=1.167736213744872_p
x(2)=-4.708907414210477_p
w(2)=2.374840787963396_p
x(3)=-2.005982109866394_p
w(3)=2.518908897686079_p
x(4)=8.992564418310002e-1_p
w(4)=8.966460806780575e-1_p
x(5)=4.690771553599257_p
w(5)=4.260346720318354e-2_p
x(6)=10.68944557099887_p
w(6)=1.760188992405516e-4_p
else if(N==7)then
x(1)=-6.621974096986263_p
w(1)=9.586131823226350e-1_p
x(2)=-5.098350763453041_p
w(2)=2.016958275745663_p
x(3)=-2.731882433061763_p
w(3)=2.436673381249745_p
x(4)=-8.725836467896698e-2_p
w(4)=1.408378869800370_p
x(5)=2.956045519994519_p
w(5)=1.767608399478897e-1_p
x(6)=7.299199941239136_p
w(6)=3.518253406181947e-3_p
x(7)=13.74317042894753_p
w(7)=8.663702341391937e-6_p
else if(N==8)then
x(1)=-6.684048820747593_p
w(1)=8.030594615323893e-1_p
x(2)=-5.394862707282106_p
w(2)=1.728191110489538_p
x(3)=-3.324017549280456_p
w(3)=2.250297533730439_p
x(4)=-8.940338024701849e-1_p
w(4)=1.757040191955465_p
x(5)=1.727242068283283_p
w(5)=4.391176041375174e-1_p
x(6)=5.161037431363253_p
w(6)=2.292210434610553e-2_p
x(7)=9.871830072926167_p
w(7)=2.828681923392517e-4_p
x(8)=16.38086035941992_p
w(8)=5.917910349151782e-7_p
else if(N==9)then
x(1)=-6.731999095712355_p
w(1)=6.823252460917327e-1_p
x(2)=-5.628757785146854_p
w(2)=1.491884734749996_p
x(3)=-3.814156908652986_p
w(3)=2.035821254367832_p
x(4)=-1.591723976637556_p
w(4)=1.913183302288027_p
x(5)=7.715986884575686e-1_p
w(5)=7.893247862981229e-1_p
x(6)=3.613374031505236_p
w(6)=8.564933924751189e-2_p
x(7)=7.366228797177264_p
w(7)=2.695565727317236e-3_p
x(8)=12.21283630814183_p
w(8)=2.716455428618639e-5_p
x(9)=18.30943329327286_p
w(9)=7.285000236938443e-8_p
else if(N==10)then
x(1)=-6.769926057346438_p
w(1)=5.864965847815699e-1_p
x(2)=-5.816579034017935_p
w(2)=1.297350928522469_p
x(3)=-4.221357866771493_p
w(3)=1.826430718655067_p
x(4)=-2.201141471432596_p
w(4)=1.922346093551041_p
x(5)=-1.948930176025887e-2_p
w(5)=1.132254441595648_p
x(6)=2.425643038388549_p
w(6)=2.219244873829009e-1_p
x(7)=5.534769245948095_p
w(7)=1.376220721587680e-2_p
x(8)=9.445122809585021_p
w(8)=3.424982650638725e-4_p
x(9)=14.21171823598901_p
w(9)=3.489957601187046e-6_p
x(10)=19.554383883748_p
w(10)=1.624758927584229e-8_p
else if(N==11)then
x(1)=-6.800404759289441_p
w(1)=5.092872201469052e-1_p
x(2)=-5.969216835135639_p
w(2)=1.136448552989130_p
x(3)=-4.560498923978576_p
w(3)=1.635127216831482_p
x(4)=-2.730966623572014_p
w(4)=1.846480624996150_p
x(5)=-7.021349900245226e-1_p
w(5)=1.386615882591379_p
x(6)=1.478032790592267_p
w(6)=4.375229460619440e-1_p
x(7)=4.121168801810251_p
w(7)=4.717512255765356e-2_p
x(8)=7.399317633177189_p
w(8)=2.202066992321876e-3_p
x(9)=11.32542757340069_p
w(9)=5.120412362953896e-5_p
x(10)=15.83769138709393_p
w(10)=6.232352672137914e-7_p
x(11)=20.32153444974746_p
w(11)=5.648965337007671e-9_p
else if(N==12)then
x(1)=-6.825237735468755_p
w(1)=4.462549599492115e-1_p
x(2)=-6.094644132637491_p
w(2)=1.002508952245243_p
x(3)=-4.844286263897939_p
w(3)=1.465414650806917_p
x(4)=-3.189388797893385_p
w(4)=1.731515772728539_p
x(5)=-1.304147952911487_p
w(5)=1.526020287712066_p
x(6)=6.937651553802869e-1_p
w(6)=6.982408983967132e-1_p
x(7)=2.993444712747978_p
w(7)=1.213076278980805e-1_p
x(8)=5.804059648363390_p
w(8)=9.254382112274143e-3_p
x(9)=9.143305629756032_p
w(9)=3.843910708989278e-4_p
x(10)=12.97223772355227_p
w(10)=9.387911358178802e-6_p
x(11)=17.11488405535594_p
w(11)=1.527116138336131e-7_p
x(12)=20.79890603496091_p
w(12)=2.631912586639000e-9_p
else if(N==13)then
x(1)=-6.845725933301066_p
w(1)=3.941704279507678e-1_p
x(2)=-6.198812033897116_p
w(2)=8.901793044409360e-1_p
x(3)=-5.083236951300949_p
w(3)=1.316758911310285_p
x(4)=-3.585302248342360_p
w(4)=1.603986064949290_p
x(5)=-1.838848863776682_p
w(5)=1.568108212813346_p
x(6)=2.194163213586529e-2_p
w(6)=9.477927656871391e-1_p
x(7)=2.070740204534206_p
w(7)=2.491100974349919e-1_p
x(8)=4.518936716218632_p
w(8)=2.885625714726192e-2_p
x(9)=7.416658190768102_p
w(9)=1.870664411298358e-3_p
x(10)=10.73084136647526_p
w(10)=7.657132531337312e-5_p
x(11)=14.37850494097585_p
w(11)=2.137989047483827e-6_p
x(12)=18.09730861143967_p
w(12)=4.923494595751521e-8_p
x(13)=21.10639403777814_p
w(13)=1.480204876991423e-9_p
else if(N==14)then
x(1)=-6.862821492435526_p
w(1)=3.506572869967429e-1_p
x(2)=-6.286184873743164_p
w(2)=7.952457329273309e-1_p
x(3)=-5.285807166517313_p
w(3)=1.187146549396214_p
x(4)=-3.927479959518831_p
w(4)=1.477357599690717_p
x(5)=-2.313824440336397_p
w(5)=1.545118386911485_p
x(6)=-5.691088263763617e-1_p
w(6)=1.140771045763175_p
x(7)=1.297624201002979_p
w(7)=4.257429599035232e-1_p
x(8)=3.460297355310249_p
w(8)=7.173481136074171e-2_p
x(9)=6.009164506444861_p
w(9)=6.707956270882418e-3_p
x(10)=8.922563441692660_p
w(10)=4.107423468514222e-4_p
x(11)=12.14611242469792_p
w(11)=1.777342417901271e-5_p
x(12)=15.55729177739436_p
w(12)=6.004035094392154e-7_p
x(13)=18.84685201652857_p
w(13)=1.983749294789820e-8_p
x(14)=21.3126211628848_p
w(14)=9.419834052120038e-10_p
else if(N==15)then
x(1)=-6.877231427797556_p
w(1)=3.139436327562461e-1_p
x(2)=-6.360140244371406_p
w(2)=7.144099392712782e-1_p
x(3)=-5.458716121716329_p
w(3)=1.074190739877876_p
x(4)=-4.223934468888175_p
w(4)=1.357808354264548_p
x(5)=-2.735080878667119_p
w(5)=1.485162066586373_p
x(6)=-1.097475367210625_p
w(6)=1.260232172558748_p
x(7)=6.340336936599358e-1_p
w(7)=6.258254719385414e-1_p
x(8)=2.572973111247416_p
w(8)=1.484758443286029e-1_p
x(9)=4.837786180168680_p
w(9)=1.912991442936872e-2_p
x(10)=7.428216866948330_p
w(10)=1.627752335674181e-3_p
x(11)=10.30236267750634_p
w(11)=1.005312018043099e-4_p
x(12)=13.38787974035085_p
w(12)=4.832564558403165e-6_p
x(13)=16.53357074264128_p
w(13)=2.038936389967618e-7_p
x(14)=19.41956565721133_p
w(14)=9.515461904243026e-9_p
x(15)=21.45634591089363_p
w(15)=6.521073466542934e-10_p
else if(N==16)then
x(1)=-6.889488649042086_p
w(1)=2.826895172560961e-1_p
x(2)=-6.423261392410642_p
w(2)=6.450852254773065e-1_p
x(3)=-5.607292193300041_p
w(3)=9.755809644445256e-1_p
x(4)=-4.481659135319640_p
w(4)=1.247754224745041_p
x(5)=-3.108324232438315_p
w(5)=1.407286442067732_p
x(6)=-1.573158894294756_p
w(6)=1.313138333377095_p
x(7)=5.142848246042713e-2_p
w(7)=8.150144439029324e-1_p
x(8)=1.817404192861005_p
w(8)=2.632604043733582e-1_p
x(9)=3.847825614006701_p
w(9)=4.551670884954722e-2_p
x(10)=6.170791726541896_p
w(10)=5.130137096902444e-3_p
x(11)=8.754608686306581_p
w(11)=4.257059617598079e-4_p
x(12)=11.54853423621417_p
w(12)=2.773995032698029e-5_p
x(13)=14.46484745430931_p
w(13)=1.531308910074221e-6_p
x(14)=17.33703907505801_p
w(14)=8.166493025552131e-8_p
x(15)=19.86051773752787_p
w(15)=5.219197169808296e-9_p
x(16)=21.55997087718433_p
w(16)=4.791671189927615e-10_p
else if(N==17)then
x(1)=-6.900000612984547_p
w(1)=2.558677306582845e-1_p
x(2)=-6.477546506993114_p
w(2)=5.852320433858359e-1_p
x(3)=-5.735772207099839_p
w(3)=8.892460074552468e-1_p
x(4)=-4.706605534913757_p
w(4)=1.147748607085694_p
x(5)=-3.439077101432417_p
w(5)=1.322892441667007_p
x(6)=-2.002243045780858_p
w(6)=1.316790706467433_p
x(7)=-4.693417592133648e-1_p
w(7)=9.661910267494458e-1_p
x(8)=1.163538551361827_p
w(8)=4.086772816184630e-1_p
x(9)=3.000833718214342_p
w(9)=9.319190605024552e-2_p
x(10)=5.097996669645408_p
w(10)=1.350142639806216e-2_p
x(11)=7.436720568104644_p
w(11)=1.441163708367545e-3_p
x(12)=9.977430095738095_p
w(12)=1.218768209482222e-4_p
x(13)=12.66184623120349_p
w(13)=8.647910665666420e-6_p
x(14)=15.39162956390247_p
w(14)=5.590593283466243e-7_p
x(15)=17.99713829496336_p
w(15)=3.759947008966186e-8_p
x(16)=20.20376585110608_p
w(16)=3.172474534873283e-9_p
x(17)=21.63690573226782_p
w(17)=3.678550506443542e-10_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;22kT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348502613667634_p
w(1)=3.813108100749466_p
x(2)=9.542174444128114e-2_p
w(2)=2.189367584109318_p
else if(N==3)then
x(1)=-4.976656581152687_p
w(1)=2.488343477478332_p
x(2)=-1.607604721603129_p
w(2)=3.105730598775811_p
x(3)=2.458415512130845_p
w(3)=4.084016086046406e-1_p
else if(N==4)then
x(1)=-5.281894096916542_p
w(1)=1.781303992248441_p
x(2)=-2.670858906778902_p
w(2)=2.950327806351759_p
x(3)=5.932928843291934e-1_p
w(3)=1.235409355254609_p
x(4)=5.170422406571715_p
w(4)=3.543453100397530e-2_p
else if(N==5)then
x(1)=-5.456049294221206_p
w(1)=1.362749003051403_p
x(2)=-3.374106714349243_p
w(2)=2.554308129386268_p
x(3)=-5.318011862641409e-1_p
w(3)=1.851522594257997_p
x(4)=2.801466006926441_p
w(4)=2.319010431036317e-1_p
x(5)=8.178644343293495_p
w(5)=1.994915059484034e-3_p
else if(N==6)then
x(1)=-5.567097758835586_p
w(1)=1.090773080954472_p
x(2)=-3.860313004492010_p
w(2)=2.181223045100959_p
x(3)=-1.359584703396861_p
w(3)=2.108727850445587_p
x(4)=1.439145451745225_p
w(4)=5.978878929173118e-1_p
x(5)=5.289415016837913_p
w(5)=2.376961113501512e-2_p
x(6)=11.31521679081126_p
w(6)=9.420430543945816e-5_p
else if(N==7)then
x(1)=-5.644411163918405_p
w(1)=8.992669184105292e-1_p
x(2)=-4.215690801627444_p
w(2)=1.869475877653930_p
x(3)=-2.015490987596247_p
w(3)=2.121380586066702_p
x(4)=4.800599193129868e-1_p
w(4)=1.008664191183052_p
x(5)=3.545647256703160_p
w(5)=1.017912241764859e-1_p
x(6)=7.921040587443997_p
w(6)=1.892161080413479e-3_p
x(7)=14.33883808901214_p
w(7)=4.726287671317246e-6_p
else if(N==8)then
x(1)=-5.702047533599428_p
w(1)=7.554249776845529e-1_p
x(2)=-4.489260792367769_p
w(2)=1.611252432079219_p
x(3)=-2.555037194178533_p
w(3)=2.010982011473078_p
x(4)=-2.843171458258766e-1_p
w(4)=1.345488440007575_p
x(5)=2.307475652271816_p
w(5)=2.666903257194758e-1_p
x(6)=5.774417036115432_p
w(6)=1.248298845012029e-2_p
x(7)=10.47077327135038_p
w(7)=1.541570233565117e-4_p
x(8)=16.86616942847951_p
w(8)=3.524214055414823e-7_p
else if(N==9)then
x(1)=-5.746793508510315_p
w(1)=6.431617146374459e-1_p
x(2)=-4.706456641490202_p
w(2)=1.396701919341052_p
x(3)=-3.005088974361520_p
w(3)=1.850859712714099_p
x(4)=-9.328318038797642e-1_p
w(4)=1.550735752596473_p
x(5)=1.353923090816635_p
w(5)=5.119437343345798e-1_p
x(6)=4.219125069551684_p
w(6)=4.758985024747382e-2_p
x(7)=7.967855533135806_p
w(7)=1.467444338690473e-3_p
x(8)=12.75481377895447_p
w(8)=1.550779775492866e-5_p
x(9)=18.65142632219174_p
w(9)=4.885121549713673e-8_p
else if(N==10)then
x(1)=-5.782283199815130_p
w(1)=5.537784916626086e-1_p
x(2)=-4.881529124301323_p
w(2)=1.218437281888309_p
x(3)=-3.381144180916711_p
w(3)=1.679786320174494_p
x(4)=-1.494413145901901_p
w(4)=1.628264252243293_p
x(5)=5.805997042818724e-1_p
w(5)=7.871296320700149e-1_p
x(6)=3.025964467905772_p
w(6)=1.273959830825169e-1_p
x(7)=6.140334206416083_p
w(7)=7.490144697264318e-3_p
x(8)=10.01218629411295_p
w(8)=1.914423434215051e-4_p
x(9)=14.67872575292117_p
w(9)=2.124627419612158e-6_p
x(10)=19.77903150765924_p
w(10)=1.206944206028052e-8_p
else if(N==11)then
x(1)=-5.810863630710313_p
w(1)=4.815894872038587e-1_p
x(2)=-5.024217116029173_p
w(2)=1.070030133032357_p
x(3)=-3.695820539220807_p
w(3)=1.515957683113150_p
x(4)=-1.982213995950498_p
w(4)=1.614653264328354_p
x(5)=-7.169286511153110e-2_p
w(5)=1.029841227987542_p
x(6)=2.077481850983440_p
w(6)=2.633432499664499e-1_p
x(7)=4.729778697638043_p
w(7)=2.581748717029795e-2_p
x(8)=7.983743803331364_p
w(8)=1.212911278946639e-3_p
x(9)=11.84389965019654_p
w(9)=2.982946148483671e-5_p
x(10)=16.22542642262066_p
w(10)=4.068053183357501e-7_p
x(11)=20.46853747848072_p
w(11)=4.511025142145121e-9_p
else if(N==12)then
x(1)=-5.834194175417826_p
w(1)=4.225310234884642e-1_p
x(2)=-5.141759005296811_p
w(2)=9.458753834624747e-1_p
x(3)=-3.960177324702426_p
w(3)=1.366482230730203_p
x(4)=-2.405452693874143_p
w(4)=1.548348056529832_p
x(5)=-6.370896098030627e-1_p
w(5)=1.200757551998197_p
x(6)=1.300188080634266_p
w(6)=4.457482920182366e-1_p
x(7)=3.603685173481892_p
w(7)=6.746046223314418e-2_p
x(8)=6.401453152256428_p
w(8)=5.049082065010687e-3_p
x(9)=9.693353341520412_p
w(9)=2.177481130041180e-4_p
x(10)=13.43477555123472_p
w(10)=5.745528383868539e-6_p
x(11)=17.42905982611807_p
w(11)=1.064867390274350e-7_p
x(12)=20.89791386059801_p
w(12)=2.205093790232012e-9_p
else if(N==13)then
x(1)=-5.853475693506537_p
w(1)=3.736383776196134e-1_p
x(2)=-5.239588181828886_p
w(2)=8.413400393987579e-1_p
x(3)=-4.183502064648343_p
w(3)=1.233154684330840_p
x(4)=-2.772403259000953_p
w(4)=1.456883294136118_p
x(5)=-1.134608230816459_p
w(5)=1.292925542870523_p
x(6)=6.446401820973715e-1_p
w(6)=6.450537680967829e-1_p
x(7)=2.682552037815198_p
w(7)=1.427016131850781e-1_p
x(8)=5.125822315068469_p
w(8)=1.569319872303612e-2_p
x(9)=7.989299526625062_p
w(9)=1.038745774633009e-3_p
x(10)=11.2386607021037_p
w(10)=4.500502663144014e-5_p
x(11)=14.78344435950585_p
w(11)=1.378057494992209e-6_p
x(12)=18.34893499704365_p
w(12)=3.635887510862522e-8_p
x(13)=21.17568172008418_p
w(13)=1.280399657380309e-9_p
else if(N==14)then
x(1)=-5.869588906747772_p
w(1)=3.327240155859006e-1_p
x(2)=-5.321797695604960_p
w(2)=7.527106081086160e-1_p
x(3)=-4.373347263585125_p
w(3)=1.115451212119765_p
x(4)=-3.090773284059918_p
w(4)=1.356784955678390_p
x(5)=-1.575218312498996_p
w(5)=1.320336392621279_p
x(6)=7.766678096461960e-2_p
w(6)=8.266437198086114e-1_p
x(7)=1.913482904125409_p
w(7)=2.546851980103091e-1_p
x(8)=4.073840397955045_p
w(8)=3.922114906433198e-2_p
x(9)=6.598955429897549_p
w(9)=3.672580866568425e-3_p
x(10)=9.462209214886300_p
w(10)=2.345434952123239e-4_p
x(11)=12.60795974657824_p
w(11)=1.088638659228126e-5_p
x(12)=15.90724074229131_p
w(12)=4.069225828269824e-7_p
x(13)=19.04809159266241_p
w(13)=1.535781732725126e-8_p
x(14)=21.36296426668961_p
w(14)=8.328076924121509e-10_p
else if(N==15)then
x(1)=-5.883189273971498_p
w(1)=2.981523217417346e-1_p
x(2)=-5.391496179285208_p
w(2)=6.770430900767844e-1_p
x(3)=-4.535770412996350_p
w(3)=1.011953101821291_p
x(4)=-3.367552260550971_p
w(4)=1.257005443591531_p
x(5)=-1.966237155329969_p
w(5)=1.303106033562737_p
x(6)=-4.221435286066483e-1_p
w(6)=9.662837383969962e-1_p
x(7)=1.258813018353628_p
w(7)=3.950565033999673e-1_p
x(8)=3.191365035855051_p
w(8)=8.251696260711162e-2_p
x(9)=5.440749297644843_p
w(9)=1.038646323459886e-2_p
x(10)=7.992043463823125_p
w(10)=9.094277457711407e-4_p
x(11)=10.80439845719403_p
w(11)=5.935742975797515e-5_p
x(12)=13.80319765158489_p
w(12)=3.088311332143140e-6_p
x(13)=16.83372921075808_p
w(13)=1.447034617728996e-7_p
x(14)=19.58137028533372_p
w(14)=7.650215593561578e-9_p
x(15)=21.49416507410482_p
w(15)=5.854929589596338e-10_p
else if(N==16)then
x(1)=-5.894771936989415_p
w(1)=2.686831883165105e-1_p
x(2)=-5.451069371950360_p
w(2)=6.120064688219562e-1_p
x(3)=-4.675611759006999_p
w(3)=9.209956843535891e-1_p
x(4)=-3.608885761120740_p
w(4)=1.161991962972350_p
x(5)=-2.313474523673509_p
w(5)=1.258849830569111_p
x(6)=-8.681563691948077e-1_p
w(6)=1.055866169053200_p
x(7)=6.910038089738725e-1_p
w(7)=5.457414377678653e-1_p
x(8)=2.440445071626954_p
w(8)=1.505823014446155e-1_p
x(9)=4.460809448566039_p
w(9)=2.467676436611953e-2_p
x(10)=6.753698376418369_p
w(10)=2.819434839281298e-3_p
x(11)=9.287219799057974_p
w(11)=2.443786635553214e-4_p
x(12)=12.01098392014486_p
w(12)=1.697865631489757e-5_p
x(13)=14.83537272984351_p
w(13)=1.019908862568535e-6_p
x(14)=17.5937165742934_p
w(14)=6.036707652704922e-8_p
x(15)=19.99181377703976_p
w(15)=4.323275985337469e-9_p
x(16)=21.58920753311132_p
w(16)=4.350996104091738e-10_p
else if(N==17)then
x(1)=-5.904716251460029_p
w(1)=2.433636925742724e-1_p
x(2)=-5.502368255490436_p
w(2)=5.557491578822137e-1_p
x(3)=-4.796743747692062_p
w(3)=8.409510413618982e-1_p
x(4)=-3.820057792979598_p
w(4)=1.073688507874430_p
x(5)=-2.622039123370711_p
w(5)=1.200191111764237_p
x(6)=-1.268811576802974_p
w(6)=1.099828091966764_p
x(7)=1.901585131959736e-1_p
w(7)=6.861462988680836e-1_p
x(8)=1.792934099008968_p
w(8)=2.434487567582103e-1_p
x(9)=3.621464789637577_p
w(9)=5.088597593861728e-2_p
x(10)=5.696156914115352_p
w(10)=7.335898005118389e-3_p
x(11)=7.993658783962857_p
w(11)=8.091028020566225e-4_p
x(12)=10.47603811041377_p
w(12)=7.214039071432965e-5_p
x(13)=13.08468454311108_p
w(13)=5.489777093366769e-6_p
x(14)=15.72055134475811_p
w(14)=3.870791484069135e-7_p
x(15)=18.21672183490088_p
w(15)=2.878847095457821e-8_p
x(16)=20.31147684270749_p
w(16)=2.690578646226889e-9_p
x(17)=21.66006495968512_p
w(17)=3.368763258505414e-10_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;22kT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535012845484261_p
w(1)=3.320510891254457_p
x(2)=4.997492076290769e-1_p
w(2)=1.686204456955714_p
else if(N==3)then
x(1)=-4.074469618383635_p
w(1)=2.223443218782443_p
x(2)=-1.037814399114543_p
w(2)=2.518895249700874_p
x(3)=2.943253929936105_p
w(3)=2.643768797268542e-1_p
else if(N==4)then
x(1)=-4.341983928635899_p
w(1)=1.616981589386135_p
x(2)=-1.966211278772083_p
w(2)=2.512437058865010_p
x(3)=1.108126649907888_p
w(3)=8.571822135492966e-1_p
x(4)=5.749805709802128_p
w(4)=2.011448640972967e-2_p
else if(N==5)then
x(1)=-4.496909783261095_p
w(1)=1.250360101792810_p
x(2)=-2.583502496767545_p
w(2)=2.246568863518514_p
x(3)=4.650849606890554e-2_p
w(3)=1.373299757823900_p
x(4)=3.383255492163368_p
w(4)=1.354251877654211e-1_p
x(5)=8.813909935430603_p
w(5)=1.061437309526166e-3_p
else if(N==6)then
x(1)=-4.596974386173962_p
w(1)=1.008287753929116_p
x(2)=-3.016140433805327_p
w(2)=1.957589788589400_p
x(3)=-7.098844360601043e-1_p
w(3)=1.659421637397497_p
x(4)=2.024246281903629_p
w(4)=3.686873575599382e-1_p
x(5)=5.928072494816194_p
w(5)=1.267987015495514e-2_p
x(6)=11.96902474233519_p
w(6)=4.894057926442129e-5_p
else if(N==7)then
x(1)=-4.667520821167368_p
w(1)=8.353495762806201e-1_p
x(2)=-3.337108964055663_p
w(2)=1.699567530521960_p
x(3)=-1.303453288669288_p
w(3)=1.750795351598667_p
x(4)=1.079062034604106_p
w(4)=6.645140444765533e-1_p
x(5)=4.176847269360026_p
w(5)=5.549845078718668e-2_p
x(6)=8.569891072250869_p
w(6)=9.878486905318530e-4_p
x(7)=14.94278144730098_p
w(7)=2.545854652189321e-6_p
else if(N==8)then
x(1)=-4.720617314225503_p
w(1)=7.040354183860967e-1_p
x(2)=-3.587097541875010_p
w(2)=1.477448713536366_p
x(3)=-1.792750088636202_p
w(3)=1.719430638800025_p
x(4)=3.421116842198612e-1_p
w(4)=9.479299521936843e-1_p
x(5)=2.929466912105100_p
w(5)=1.512140107198688e-1_p
x(6)=6.416570379165788_p
w(6)=6.573869112474070e-3_p
x(7)=11.08442693267276_p
w(7)=8.253472607342128e-5_p
x(8)=17.3400891805208_p
w(8)=2.107355830667526e-7_p
else if(N==9)then
x(1)=-4.762053049922434_p
w(1)=6.009205645056804e-1_p
x(2)=-3.786938418186098_p
w(2)=1.288652431373005_p
x(3)=-2.202686781279473_p
w(3)=1.623019026073117_p
x(4)=-2.688636537377945e-1_p
w(4)=1.162084948665510_p
x(5)=1.973731347732800_p
w(5)=3.058910433122101e-1_p
x(6)=4.857142079893430_p
w(6)=2.535700264302962e-2_p
x(7)=8.588331931407566_p
w(7)=7.815205180509316e-4_p
x(8)=13.30168734798909_p
w(8)=8.778030479971435e-6_p
x(9)=18.97627629537284_p
w(9)=3.308908892932765e-8_p
else if(N==10)then
x(1)=-4.795019625033842_p
w(1)=5.185085020791718e-1_p
x(2)=-3.948730756646535_p
w(2)=1.129494341148583_p
x(3)=-2.546842053520665_p
w(3)=1.499640053274033_p
x(4)=-7.896202417294325e-1_p
w(4)=1.286024569164865_p
x(5)=1.209143931878013_p
w(5)=4.997350353987015e-1_p
x(6)=3.661661778216758_p
w(6)=6.923677127837288e-2_p
x(7)=6.768312538065973_p
w(7)=3.969273187837725e-3_p
x(8)=10.59046718821511_p
w(8)=1.055028749617745e-4_p
x(9)=15.14382442517805_p
w(9)=1.290761379320490e-6_p
x(10)=19.98988965331308_p
w(10)=9.042265079296325e-9_p
else if(N==11)then
x(1)=-4.821635848396672_p
w(1)=4.517447553239552e-1_p
x(2)=-4.081060758781871_p
w(2)=9.956192026858075e-1_p
x(3)=-2.836185821315182_p
w(3)=1.370887599470923_p
x(4)=-1.238701405854746_p
w(4)=1.329867748322974_p
x(5)=5.762300253547142e-1_p
w(5)=6.964953034066750e-1_p
x(6)=2.712916133191711_p
w(6)=1.477610247470601e-1_p
x(7)=5.364294310991568_p
w(7)=1.366612445658967e-2_p
x(8)=8.583248395847891_p
w(8)=6.560861010047230e-4_p
x(9)=12.36759969145004_p
w(9)=1.723408930030566e-5_p
x(10)=16.60748208086147_p
w(10)=2.659840466006190e-7_p
x(11)=20.60633637309737_p
w(11)=3.621835245303378e-9_p
else if(N==12)then
x(1)=-4.843412661667751_p
w(1)=3.969774508556088e-1_p
x(2)=-4.190401408284329_p
w(2)=8.827451724840882e-1_p
x(3)=-3.080318294315739_p
w(3)=1.247399986448676_p
x(4)=-1.627826502739110_p
w(4)=1.316694113773214_p
x(5)=3.772181556421764e-2_p
w(5)=8.627427073270191e-1_p
x(6)=1.939315826903602_p
w(6)=2.614081030126902e-1_p
x(7)=4.243148531184749_p
w(7)=3.592779341389801e-2_p
x(8)=7.017050486214716_p
w(8)=2.694594119206453e-3_p
x(9)=10.2528483833689_p
w(9)=1.218480581084986e-4_p
x(10)=13.89816480950992_p
w(10)=3.502369639889866e-6_p
x(11)=17.73626174337769_p
w(11)=7.449509760872334e-8_p
x(12)=20.99104771047477_p
w(12)=1.852924095164306e-9_p
else if(N==13)then
x(1)=-4.861446843593085_p
w(1)=3.515300355506681e-1_p
x(2)=-4.281643773627273_p
w(2)=7.871285821630677e-1_p
x(3)=-3.287342626032770_p
w(3)=1.133667084182530_p
x(4)=-1.965773390520366_p
w(4)=1.268838078702470_p
x(5)=-4.294871253068719e-1_p
w(5)=9.804207875182037e-1_p
x(6)=1.293236644923583_p
w(6)=3.989920302319784e-1_p
x(7)=3.325893336034341_p
w(7)=7.723835864928562e-2_p
x(8)=5.753914738741436_p
w(8)=8.305277266238031e-3_p
x(9)=8.574463413267324_p
w(9)=5.679543402571462e-4_p
x(10)=11.75159648884354_p
w(10)=2.624431696486708e-5_p
x(11)=15.18640108449484_p
w(11)=8.872378569404712e-7_p
x(12)=18.59379812499802_p
w(12)=2.694164301892317e-8_p
x(13)=21.24118616285281_p
w(13)=1.109006919024395e-9_p
else if(N==14)then
x(1)=-4.876545024392153_p
w(1)=3.134197897252204e-1_p
x(2)=-4.358492492058397_p
w(2)=7.056664815049726e-1_p
x(3)=-3.463905630402440_p
w(3)=1.031041031539840_p
x(4)=-2.259832976504886_p
w(4)=1.202810727002771_p
x(5)=-8.397640122085500e-1_p
w(5)=1.047607791341706_p
x(6)=7.418798107000577e-1_p
w(6)=5.416155485369626e-1_p
x(7)=2.561002726779958_p
w(7)=1.417294022494177e-1_p
x(8)=4.711575281404844_p
w(8)=2.071175119515810e-2_p
x(9)=7.203910591318532_p
w(9)=1.973416543437371e-3_p
x(10)=10.01005426944925_p
w(10)=1.324829750342307e-4_p
x(11)=13.07172554186675_p
w(11)=6.636996319088955e-6_p
x(12)=16.25365013491342_p
w(12)=2.759386883723097e-7_p
x(13)=19.24343509839237_p
w(13)=1.192416016121243e-8_p
x(14)=21.4108018695349_p
w(14)=7.364832282057102e-10_p
else if(N==15)then
x(1)=-4.889309238854705_p
w(1)=2.811586428240552e-1_p
x(2)=-4.423775075297931_p
w(2)=6.358423579590955e-1_p
x(3)=-3.615387017338727_p
w(3)=9.393774227901973e-1_p
x(4)=-2.516293403232362_p
w(4)=1.129255266172587_p
x(5)=-1.202497107075118_p
w(5)=1.072354969092932_p
x(6)=2.626137940575468e-1_p
w(6)=6.703122220955554e-1_p
x(7)=1.912509345529696_p
w(7)=2.285409053723920e-1_p
x(8)=3.836581897858792_p
w(8)=4.382346383339730e-2_p
x(9)=6.061423941628700_p
w(9)=5.511946701070782e-3_p
x(10)=8.566557149759568_p
w(10)=5.012865375187507e-4_p
x(11)=11.3113219565572_p
w(11)=3.478642487502118e-5_p
x(12)=14.21821742072718_p
w(12)=1.968884255758327e-6_p
x(13)=17.12970573083046_p
w(13)=1.028327744282123e-7_p
x(14)=19.73829541077748_p
w(14)=6.163981537551549e-9_p
x(15)=21.53027048300834_p
w(15)=5.254825779963718e-10_p
else if(N==16)then
x(1)=-4.900195504037426_p
w(1)=2.536144760781188e-1_p
x(2)=-4.479670909287269_p
w(2)=5.756306894236412e-1_p
x(3)=-3.746120763612879_p
w(3)=8.578798691116234e-1_p
x(4)=-2.740595353907179_p
w(4)=1.054472912703287_p
x(5)=-1.524404425232959_p
w(5)=1.066011458563225_p
x(6)=-1.599985340393792e-1_p
w(6)=7.722324974895334e-1_p
x(7)=1.354206458335357_p
w(7)=3.310092070885473e-1_p
x(8)=3.091903892258861_p
w(8)=8.118846378668967e-2_p
x(9)=5.094072225726968_p
w(9)=1.300122951185318e-2_p
x(10)=7.349515529535252_p
w(10)=1.524560181485759e-3_p
x(11)=9.827100687534061_p
w(11)=1.389159031353836e-4_p
x(12)=12.47583635891017_p
w(12)=1.034101951437468e-5_p
x(13)=15.2041822383211_p
w(13)=6.786747654347932e-7_p
x(14)=17.84614260946567_p
w(14)=4.469357143279251e-8_p
x(15)=20.11916721597368_p
w(15)=3.586410089392351e-9_p
x(16)=21.61723471741454_p
w(16)=3.947697311690372e-10_p
else if(N==17)then
x(1)=-4.909554065381990_p
w(1)=2.299146807945594e-1_p
x(2)=-4.527877229384335_p
w(2)=5.234025200374026e-1_p
x(3)=-3.859598693597900_p
w(3)=7.855206981967385e-1_p
x(4)=-2.937410721315570_p
w(4)=9.819435504334730e-1_p
x(5)=-1.810767135175475_p
w(5)=1.039125387180899_p
x(6)=-5.364486953007144e-1_p
w(6)=8.425741995776540e-1_p
x(7)=8.666522821465629e-1_p
w(7)=4.384345453385618e-1_p
x(8)=2.450557201515864_p
w(8)=1.346150668031367e-1_p
x(9)=4.264847268752267_p
w(9)=2.678102344625538e-2_p
x(10)=6.309384307243811_p
w(10)=3.908685913477955e-3_p
x(11)=8.559910298613335_p
w(11)=4.488237861225239e-4_p
x(12)=10.97928315978724_p
w(12)=4.239975895215202e-5_p
x(13)=13.50812621618796_p
w(13)=3.474275512869626e-6_p
x(14)=16.04694456026841_p
w(14)=2.680004349370928e-7_p
x(15)=18.43229728649007_p
w(15)=2.207496966070488e-8_p
x(16)=20.41602956092821_p
w(16)=2.283843991543392e-9_p
x(17)=21.68234593147588_p
w(17)=3.081770288739720e-10_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;22kT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719496283083511_p
w(1)=2.798301959948370_p
x(2)=9.542776720118943e-1_p
w(2)=1.219847967690493_p
else if(N==3)then
x(1)=-3.173003760553080_p
w(1)=1.934949830256026_p
x(2)=-4.480311562382984e-1_p
w(2)=1.923943025088322_p
x(3)=3.489273020883041_p
w(3)=1.592570722945154e-1_p
else if(N==4)then
x(1)=-3.403239038692211_p
w(1)=1.435060547014277_p
x(2)=-1.258824590643307_p
w(2)=2.024536490838540_p
x(3)=1.675064561795006_p
w(3)=5.477388115654696e-1_p
x(4)=6.380055869687099_p
w(4)=1.081407822057662e-2_p
else if(N==5)then
x(1)=-3.538939453482886_p
w(1)=1.124324804012452_p
x(2)=-1.796086131808199_p
w(2)=1.884094365920775_p
x(3)=6.573120659229728e-1_p
w(3)=9.352677967275039e-1_p
x(4)=4.019330607123720_p
w(4)=7.392174846215695e-2_p
x(5)=9.490384927792993_p
w(5)=5.412125159752065e-4_p
else if(N==6)then
x(1)=-3.627936937775782_p
w(1)=9.148124454271628e-1_p
x(2)=-2.176769069433079_p
w(2)=1.687005823845920_p
x(3)=-4.588794547717936e-2_p
w(3)=1.200455914740834_p
x(4)=2.661385111038299_p
w(4)=2.093849545118298e-1_p
x(5)=6.607706013177192_p
w(5)=6.466118297158208e-3_p
x(6)=12.6507932020597_p
w(6)=2.467081595813235e-5_p
else if(N==7)then
x(1)=-3.691589381739426_p
w(1)=7.624259473453302e-1_p
x(2)=-2.463375780807386_p
w(2)=1.491888531393440_p
x(3)=-5.887914243796138e-1_p
w(3)=1.335798056304668_p
x(4)=1.720888298138525_p
w(4)=3.988165095113964e-1_p
x(5)=4.849960631965462_p
w(5)=2.871888797953899e-2_p
x(6)=9.245604498171641_p
w(6)=5.006378016494293e-4_p
x(7)=15.55142979379406_p
w(7)=1.357302840057725e-6_p
else if(N==8)then
x(1)=-3.739984997647009_p
w(1)=6.452506628645770e-1_p
x(2)=-2.689191900322569_p
w(2)=1.313801293851542_p
x(3)=-1.033524515528639_p
w(3)=1.370620083231195_p
x(4)=9.986146891699267e-1_p
w(4)=6.047501307130509e-1_p
x(5)=3.594932815240369_p
w(5)=8.033384859158638e-2_p
x(6)=7.087283804803854_p
w(6)=3.350351061090172e-3_p
x(7)=11.71194896732524_p
w(7)=4.343052529392765e-5_p
x(8)=17.79949431229782_p
w(8)=1.268005283775580e-7_p
else if(N==9)then
x(1)=-3.777961899656386_p
w(1)=5.525619018241827e-1_p
x(2)=-2.870977804356861_p
w(2)=1.156949807436781_p
x(3)=-1.405496394600524_p
w(3)=1.338937049648858_p
x(4)=4.125912734477955e-1_p
w(4)=7.876854627960469e-1_p
x(5)=2.636172768725249_p
w(5)=1.686132559200131e-1_p
x(6)=5.526894056496528_p
w(6)=1.299024512358434e-2_p
x(7)=9.227371786791602_p
w(7)=4.072525077706575e-4_p
x(8)=13.85235135867693_p
w(8)=4.929733561990444e-6_p
x(9)=19.28322352654862_p
w(9)=2.264806405305564e-8_p
else if(N==10)then
x(1)=-3.808288032718996_p
w(1)=4.781093385982922e-1_p
x(2)=-3.018885042089717_p
w(2)=1.021558381756330_p
x(3)=-1.718221014523960_p
w(3)=1.269963853295631_p
x(4)=-7.727685628972941e-2_p
w(4)=9.220207999782354e-1_p
x(5)=1.875321881000613_p
w(5)=2.885810208651920e-1_p
x(6)=4.332350559939834_p
w(6)=3.580873517950270e-2_p
x(7)=7.418306305388419_p
w(7)=2.049671150241511e-3_p
x(8)=11.17947340495278_p
w(8)=5.733698156882663e-5_p
x(9)=15.60599876325687_p
w(9)=7.830047774799709e-7_p
x(10)=20.18726420363658_p
w(10)=6.829091924702141e-9_p
else if(N==11)then
x(1)=-3.832849371091342_p
w(1)=4.175415534963439e-1_p
x(2)=-3.140367055635235_p
w(2)=9.057192270725430e-1_p
x(3)=-1.981980829584735_p
w(3)=1.184161475923307_p
x(4)=-4.941803960428977e-1_p
w(4)=1.001408232417570_p
x(5)=1.253449910775391_p
w(5)=4.241426204214998e-1_p
x(6)=3.385442897247402_p
w(6)=7.780548233749429e-2_p
x(7)=6.023948965539099_p
w(7)=7.012667773933446e-3_p
x(8)=9.197472608423929_p
w(8)=3.486131614682450e-4_p
x(9)=12.89592424260682_p
w(9)=9.877851515075411e-6_p
x(10)=16.98317729837258_p
w(10)=1.742612531143200e-7_p
x(11)=20.73536494168976_p
w(11)=2.921934996036075e-9_p
else if(N==12)then
x(1)=-3.853001297827038_p
w(1)=3.676769899625094e-1_p
x(2)=-3.241112154900303_p
w(2)=8.067920241422888e-1_p
x(3)=-2.205371794913153_p
w(3)=1.093862187569248_p
x(4)=-8.528854401171645e-1_p
w(4)=1.032921429220269_p
x(5)=7.323778767161530e-1_p
w(5)=5.554227394001747e-1_p
x(6)=2.615231471232878_p
w(6)=1.415869016461449e-1_p
x(7)=4.910801511603696_p
w(7)=1.841038376582568e-2_p
x(8)=7.650363561031353_p
w(8)=1.407723647048719e-3_p
x(9)=10.82139118879794_p
w(9)=6.736737644188715e-5_p
x(10)=14.36183859459532_p
w(10)=2.127061899257590e-6_p
x(11)=18.03615965162906_p
w(11)=5.228626145922197e-8_p
x(12)=21.07863307006867_p
w(12)=1.560751232414125e-9_p
else if(N==13)then
x(1)=-3.869731424495173_p
w(1)=3.261679848984204e-1_p
x(2)=-3.325449300139853_p
w(2)=7.221534741316680e-1_p
x(3)=-2.395519171428933_p
w(3)=1.005743196907032_p
x(4)=-1.163601943266511_p
w(4)=1.028861128847654_p
x(5)=2.869608013350680e-1_p
w(5)=6.663586587912921e-1_p
x(6)=1.975316954303644_p
w(6)=2.244613429723598e-1_p
x(7)=4.000100621994060_p
w(7)=3.979722582393593e-2_p
x(8)=6.402417535328268_p
w(8)=4.285265351140442e-3_p
x(9)=9.171776495863098_p
w(9)=3.058715437780993e-4_p
x(10)=12.26923820014083_p
w(10)=1.518670162699514e-5_p
x(11)=15.58693680807151_p
w(11)=5.706801101576637e-7_p
x(12)=18.83180759423426_p
w(12)=2.002846060444359e-8_p
x(13)=21.30312211083335_p
w(13)=9.613845656574126e-10_p
else if(N==14)then
x(1)=-3.883768792107546_p
w(1)=2.912650616014780e-1_p
x(2)=-3.396678668561371_p
w(2)=6.494737782399157e-1_p
x(3)=-2.558250812025106_p
w(3)=9.230492762969204e-1_p
x(4)=-1.433991711450380_p
w(4)=1.001287525643973_p
x(5)=-9.951002530984533e-2_p
w(5)=7.484807844174726e-1_p
x(6)=1.433762731784423_p
w(6)=3.188156343717247e-1_p
x(7)=3.241003268560064_p
w(7)=7.405388649938642e-2_p
x(8)=5.372359960300945_p
w(8)=1.060427455944541e-2_p
x(9)=7.823531369398366_p
w(9)=1.041443184488242e-3_p
x(10)=10.5657605086093_p
w(10)=7.403765491550362e-5_p
x(11)=13.53703828968989_p
w(11)=4.028011897279646e-6_p
x(12)=16.59623245096106_p
w(12)=1.872234066741669e-7_p
x(13)=19.43291694919823_p
w(13)=9.282604597049740e-9_p
x(14)=21.45627271068716_p
w(14)=6.512340614386197e-10_p
else if(N==15)then
x(1)=-3.895659508172886_p
w(1)=2.616480897895211e-1_p
x(2)=-3.457334004574729_p
w(2)=5.867784288322090e-1_p
x(3)=-2.698299669732197_p
w(3)=8.470880579438882e-1_p
x(4)=-1.670167308789752_p
w(4)=9.597571809055451e-1_p
x(5)=-4.383757840486545e-1_p
w(5)=8.005723158908973e-1_p
x(6)=9.679827047620944e-1_p
w(6)=4.145518826012540e-1_p
x(7)=2.598514573331091_p
w(7)=1.222084941849885e-1_p
x(8)=4.507380266283819_p
w(8)=2.238771466482813e-2_p
x(9)=6.699056071731126_p
w(9)=2.863503214890914e-3_p
x(10)=9.151397793281955_p
w(10)=2.726913897764940e-4_p
x(11)=11.82282299530989_p
w(11)=2.023731951172684e-5_p
x(12)=14.63263944077743_p
w(12)=1.252285140863971e-6_p
x(13)=17.42134228002235_p
w(13)=7.316931214897833e-8_p
x(14)=19.89042542245251_p
w(14)=4.975807811186722e-9_p
x(15)=21.56475304921835_p
w(15)=4.712918478100670e-10_p
else if(N==16)then
x(1)=-3.905818621339153_p
w(1)=2.363079055986265e-1_p
x(2)=-3.509378481502674_p
w(2)=5.324287933496217e-1_p
x(3)=-2.819499860637955_p
w(3)=7.781295169892787e-1_p
x(4)=-1.877175758273365_p
w(4)=9.110196398377720e-1_p
x(5)=-7.376439529167216e-1_p
w(5)=8.261476078951535e-1_p
x(6)=5.618214251214122e-1_p
w(6)=5.021644010657487e-1_p
x(7)=2.047415719663405_p
w(7)=1.827206295441892e-1_p
x(8)=3.771057332399463_p
w(8)=4.165767711005228e-2_p
x(9)=5.746533351966933_p
w(9)=6.677176817240545e-3_p
x(10)=7.957764422572022_p
w(10)=8.116178418584235e-4_p
x(11)=10.37395612355867_p
w(11)=7.820615443399600e-5_p
x(12)=12.94282158768745_p
w(12)=6.267770421924185e-6_p
x(13)=15.57105837621213_p
w(13)=4.511917814924861e-7_p
x(14)=18.09425253720724_p
w(14)=3.313628920985467e-8_p
x(15)=20.24267365624105_p
w(15)=2.978604563123320e-9_p
x(16)=21.644113561289_p
w(16)=3.577902005605005e-10_p
else if(N==17)then
x(1)=-3.914565884338928_p
w(1)=2.144633956779258e-1_p
x(2)=-3.554347940642574_p
w(2)=4.850771203265737e-1_p
x(3)=-2.924958925773189_p
w(3)=7.159190495128446e-1_p
x(4)=-2.059248410014238_p
w(4)=8.595057588153069e-1_p
x(5)=-1.003269660609300_p
w(5)=8.307496305703321e-1_p
x(6)=2.036588644373003e-1_p
w(6)=5.749632776750304e-1_p
x(7)=1.568976017102928_p
w(7)=2.516002527725646e-1_p
x(8)=3.137095081857273_p
w(8)=6.989455827819258e-2_p
x(9)=4.929643387233468_p
w(9)=1.365874938990219e-2_p
x(10)=6.936986982031947_p
w(10)=2.044924746711327e-3_p
x(11)=9.135136247830809_p
w(11)=2.460668845747332e-4_p
x(12)=11.48691362703868_p
w(12)=2.474625391421718e-5_p
x(13)=13.93195169483369_p
w(13)=2.192026385497127e-6_p
x(14)=16.37066735159946_p
w(14)=1.855385777490553e-7_p
x(15)=18.64385953771915_p
w(15)=1.694878653349037e-8_p
x(16)=20.51751395334896_p
w(16)=1.939691567205229e-9_p
x(17)=21.70379094888285_p
w(17)=2.815482699992638e-10_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;22kT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899025578625698_p
w(1)=2.236589373797873_p
x(2)=1.474550119925058_p
w(2)=8.119979774969226e-1_p
else if(N==3)then
x(1)=-2.271687576545261_p
w(1)=1.607691016007282_p
x(2)=1.763303611456050e-1_p
w(2)=1.352271647798606_p
x(3)=4.104008213081759_p
w(3)=8.862468748890731e-2_p
else if(N==4)then
x(1)=-2.465695926399540_p
w(1)=1.221825919019110_p
x(2)=-5.390364147699073e-1_p
w(2)=1.502938614644916_p
x(3)=2.305803534447469_p
w(3)=3.183373556619222e-1_p
x(4)=7.065534227168461_p
w(4)=5.485461968846988e-3_p
else if(N==5)then
x(1)=-2.582346310663084_p
w(1)=9.730409358778739e-1_p
x(2)=-1.006720689730517_p
w(2)=1.463475499339302_p
x(3)=1.316294668463619_p
w(3)=5.741166905678908e-1_p
x(4)=4.712909835580338_p
w(4)=3.769061112654220e-2_p
x(5)=10.2112394969107_p
w(5)=2.636143831866045e-4_p
else if(N==6)then
x(1)=-2.660228526741284_p
w(1)=8.006051091077516e-1_p
x(2)=-1.339759761313998_p
w(2)=1.355751264886143_p
x(3)=6.483795081600410e-1_p
w(3)=7.795507499675056e-1_p
x(4)=3.355355145998572_p
w(4)=1.095186622536872e-1_p
x(5)=7.329705865249189_p
w(5)=3.149502079871726e-3_p
x(6)=13.36016164297925_p
w(6)=1.206299983592253e-5_p
else if(N==7)then
x(1)=-2.716837764961300_p
w(1)=6.723236192510006e-1_p
x(2)=-1.593437684118606_p
w(2)=1.229368059896365_p
x(3)=1.417867596778284e-1_p
w(3)=9.152286606315509e-1_p
x(4)=2.414436427897861_p
w(4)=2.172878972362443e-1_p
x(5)=5.565370566038465_p
w(5)=1.413220305000059e-2_p
x(6)=9.948313801869400_p
w(6)=2.461931763358662e-4_p
x(7)=16.16074197193046_p
w(7)=7.180532976584006e-7_p
else if(N==8)then
x(1)=-2.760339442696320_p
w(1)=5.721699071646467e-1_p
x(2)=-1.795197405103416_p
w(2)=1.103185660220305_p
x(3)=-2.677365280040057e-1_p
w(3)=9.853839589770684e-1_p
x(4)=1.698148779639305_p
w(4)=3.459988125123916e-1_p
x(5)=4.304520018704980_p
w(5)=4.017395655316364e-2_p
x(6)=7.786801176802266_p
w(6)=1.652514555228016e-3_p
x(7)=12.35269396197863_p
w(7)=2.246440561548692e-5_p
x(8)=18.24160615636615_p
w(8)=7.690637674308509e-8_p
else if(N==9)then
x(1)=-2.794683430058207_p
w(1)=4.921921653199885e-1_p
x(2)=-1.958603694310025_p
w(2)=9.857091948384402e-1_p
x(3)=-6.071888075517753e-1_p
w(3)=1.003041971769076_p
x(4)=1.126383296020370_p
w(4)=4.747882794403368e-1_p
x(5)=3.343830349646567_p
w(5)=8.623636994743705e-2_p
x(6)=6.228221855742275_p
w(6)=6.409008927704678e-3_p
x(7)=9.885011030726229_p
w(7)=2.075974968569979e-4_p
x(8)=14.40585078055226_p
w(8)=2.747891160763029e-6_p
x(9)=19.57191233018738_p
w(9)=1.566379373676757e-8_p
else if(N==10)then
x(1)=-2.822230436475953_p
w(1)=4.274956283025638e-1_p
x(2)=-2.092209781024275_p
w(2)=8.803806286366673e-1_p
x(3)=-8.913864910190228e-1_p
w(3)=9.842883822037005e-1_p
x(4)=6.568568205064671e-1_p
w(4)=5.855128242510241e-1_p
x(5)=2.585158252505751_p
w(5)=1.521457424207250e-1_p
x(6)=5.037499791664615_p
w(6)=1.770141737635283e-2_p
x(7)=8.090313118220982_p
w(7)=1.031522095320526e-3_p
x(8)=11.77894352872219_p
w(8)=3.072637015663422e-5_p
x(9)=16.06439981748767_p
w(9)=4.744427018843694e-7_p
x(10)=20.37163733124043_p
w(10)=5.195582545143597e-9_p
else if(N==11)then
x(1)=-2.844627533889166_p
w(1)=3.745523577720086e-1_p
x(2)=-2.202438228758874_p
w(2)=7.877258076199384e-1_p
x(3)=-1.130941014279818_p
w(3)=9.434470281200519e-1_p
x(4)=2.633536979970352e-1_p
w(4)=6.681954327220884e-1_p
x(5)=1.969717353128980_p
w(5)=2.322511365689884e-1_p
x(6)=4.094888258555018_p
w(6)=3.873493652336864e-2_p
x(7)=6.708393987684002_p
w(7)=3.492979602445683e-3_p
x(8)=9.826354624074360_p
w(8)=1.819389006858548e-4_p
x(9)=13.42846366553658_p
w(9)=5.616690591759326e-6_p
x(10)=17.35200903641877_p
w(10)=1.144077670979784e-7_p
x(11)=20.85611840150311_p
w(11)=2.366860689492594e-9_p
else if(N==12)then
x(1)=-2.863067261968876_p
w(1)=3.307433410186171e-1_p
x(2)=-2.294222234647846_p
w(2)=7.069129804771570e-1_p
x(3)=-1.334112510736206_p
w(3)=8.910570533640592e-1_p
x(4)=-7.138271383935786e-2_p
w(4)=7.209056542863453e-1_p
x(5)=1.459242036428018_p
w(5)=3.176043028010165e-1_p
x(6)=3.329353595493005_p
w(6)=7.149792358203325e-2_p
x(7)=5.605858520240358_p
w(7)=9.107899812698338e-3_p
x(8)=8.301262024688947_p
w(8)=7.200749800387816e-4_p
x(9)=11.3988198889023_p
w(9)=3.679580057714477e-5_p
x(10)=14.82540816515677_p
w(10)=1.287042666240495e-6_p
x(11)=18.32857954825667_p
w(11)=3.681261881484813e-8_p
x(12)=21.16101986576801_p
w(12)=1.316967689476357e-9_p
else if(N==13)then
x(1)=-2.878422803536554_p
w(1)=2.941155423741699e-1_p
x(2)=-2.371335809371236_p
w(2)=6.366274425709163e-1_p
x(3)=-1.507451853594471_p
w(3)=8.340459349131208e-1_p
x(4)=-3.591965987347824e-1_p
w(4)=7.469411175867930e-1_p
x(5)=1.027928211979310_p
w(5)=3.990056240773949e-1_p
x(6)=2.695041335767736_p
w(6)=1.158773406406151e-1_p
x(7)=4.704177903782087_p
w(7)=1.964510459652080e-2_p
x(8)=7.070939953549044_p
w(8)=2.157902078941544e-3_p
x(9)=9.781145165924947_p
w(9)=1.622402253755384e-4_p
x(10)=12.79137870008083_p
w(10)=8.719777170509550e-6_p
x(11)=15.98477670174732_p
w(11)=3.666875857003630e-7_p
x(12)=19.06299276678841_p
w(12)=1.493250728447705e-8_p
x(13)=21.36171772715448_p
w(13)=8.336836877616193e-10_p
else if(N==14)then
x(1)=-2.891341828458171_p
w(1)=2.632001501405157e-1_p
x(2)=-2.436673096831295_p
w(2)=5.754777119248199e-1_p
x(3)=-1.656196862617281_p
w(3)=7.766274097177751e-1_p
x(4)=-6.086161681381013e-1_p
w(4)=7.518621175844534e-1_p
x(5)=6.579718691305925e-1_p
w(5)=4.693744259518472e-1_p
x(6)=2.160640386300291_p
w(6)=1.695016250448521e-1_p
x(7)=3.952906705892870_p
w(7)=3.668310563987599e-2_p
x(8)=6.055427557087184_p
w(8)=5.277404272662734e-3_p
x(9)=8.457645919296972_p
w(9)=5.399022887488284e-4_p
x(10)=11.12922108774869_p
w(10)=4.093053654398549e-5_p
x(11)=14.00370625275442_p
w(11)=2.433293903189046e-6_p
x(12)=16.93484419151177_p
w(12)=1.270809526211240e-7_p
x(13)=19.6166583421457_p
w(13)=7.242312267530277e-9_p
x(14)=21.49952504043075_p
w(14)=5.755323049412511e-10_p
else if(N==15)then
x(1)=-2.902311710185485_p
w(1)=2.368798789141062e-1_p
x(2)=-2.492469202162961_p
w(2)=5.221648225376133e-1_p
x(3)=-1.784558494698379_p
w(3)=7.211901772363750e-1_p
x(4)=-8.260779429488121e-1_p
w(4)=7.414593404793467e-1_p
x(5)=3.368291510415657e-1_p
w(5)=5.247492565802221e-1_p
x(6)=1.703940780006342_p
w(6)=2.283270947243019e-1_p
x(7)=3.317583012119778_p
w(7)=6.114455105020117e-2_p
x(8)=5.202645630669550_p
w(8)=1.105581764503285e-2_p
x(9)=7.353268051891717_p
w(9)=1.457487408535885e-3_p
x(10)=9.746467149357610_p
w(10)=1.463882604727362e-4_p
x(11)=12.33879082388587_p
w(11)=1.168537801046252e-5_p
x(12)=15.04632374393874_p
w(12)=7.945211067137879e-7_p
x(13)=17.70860256735984_p
w(13)=5.211474504370255e-8_p
x(14)=20.03790724121993_p
w(14)=4.022500458472327e-9_p
x(15)=21.59771122497216_p
w(15)=4.222246655606352e-10_p
else if(N==16)then
x(1)=-2.911704406681611_p
w(1)=2.142946478476228e-1_p
x(2)=-2.540465395704225_p
w(2)=4.755414713820934e-1_p
x(3)=-1.895936909141252_p
w(3)=6.689700966251020e-1_p
x(4)=-1.016629470348125_p
w(4)=7.207373288733477e-1_p
x(5)=5.545007147252607e-2_p
w(5)=5.640848513263931e-1_p
x(6)=1.308788697284766_p
w(6)=2.876617656013416e-1_p
x(7)=2.773576105454931_p
w(7)=9.296868616726030e-2_p
x(8)=4.476702138421504_p
w(8)=2.050601533157300e-2_p
x(9)=6.417509678017359_p
w(9)=3.349313067201257e-3_p
x(10)=8.578266084636066_p
w(10)=4.254692656771825e-4_p
x(11)=10.92771118445048_p
w(11)=4.359887969650059e-5_p
x(12)=13.41184513106616_p
w(12)=3.779911476738636e-6_p
x(13)=15.93592388741549_p
w(13)=2.996217899944893e-7_p
x(14)=18.33808182337451_p
w(14)=2.459474019950419e-8_p
x(15)=20.36247468451462_p
w(15)=2.475671667817015e-9_p
x(16)=21.66991139785157_p
w(16)=3.238078274752203e-10_p
else if(N==17)then
x(1)=-2.919807554503262_p
w(1)=1.947746832664063e-1_p
x(2)=-2.582030679404757_p
w(2)=4.346217773040889e-1_p
x(3)=-1.993088922082185_p
w(3)=6.205050991845310e-1_p
x(4)=-1.184338493658417_p
w(4)=6.935989220523283e-1_p
x(5)=-1.928793728723318e-1_p
w(5)=5.884151351733639e-1_p
x(6)=9.632350155924541e-1_p
w(6)=3.431950653174328e-1_p
x(7)=2.302687879987643_p
w(7)=1.310298377828346e-1_p
x(8)=3.851775804332123_p
w(8)=3.447047404561079e-2_p
x(9)=5.614829040743569_p
w(9)=6.775971153833349e-3_p
x(10)=7.578617972923032_p
w(10)=1.051196349021876e-3_p
x(11)=9.719242509616729_p
w(11)=1.333279001055426e-4_p
x(12)=11.99886929685603_p
w(12)=1.433989660113310e-5_p
x(13)=14.35609672994963_p
w(13)=1.378531445628096e-6_p
x(14)=16.69169958854258_p
w(14)=1.284074140794446e-7_p
x(15)=18.85148475213013_p
w(15)=1.302529058917738e-8_p
x(16)=20.61605478482386_p
w(16)=1.647691789645793e-9_p
x(17)=21.72444747571256_p
w(17)=2.567947832444077e-10_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;22kT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066219205174240_p
w(1)=1.641101294631656_p
x(2)=2.078599710703264_p
w(2)=4.858267161323701e-1_p
else if(N==3)then
x(1)=-1.367361137436372_p
w(1)=1.231463883399786_p
x(2)=8.549259361352506e-1_p
w(2)=8.501949280402183e-1_p
x(3)=4.795042069189241_p
w(3)=4.526919932402185e-2_p
else if(N==4)then
x(1)=-1.527825357841541_p
w(1)=9.632639112284480e-1_p
x(2)=2.100498139863669e-1_p
w(2)=9.941234736018320e-1_p
x(3)=3.010523213560155_p
w(3)=1.669280876015777e-1_p
x(4)=7.811655744891063_p
w(4)=2.612538332168107e-3_p
else if(N==5)then
x(1)=-1.626317826289184_p
w(1)=7.824708895922269e-1_p
x(2)=-2.030972082334963e-1_p
w(2)=1.012960992092191_p
x(3)=2.038466657109503_p
w(3)=3.134361851409526e-1_p
x(4)=5.467273902271306_p
w(4)=1.793776218514377e-2_p
x(5)=10.9802636781484_p
w(5)=1.221817535114167e-4_p
else if(N==6)then
x(1)=-1.693381560206810_p
w(1)=6.527223689262341e-1_p
x(2)=-4.966811367762326e-1_p
w(2)=9.741750784155908e-1_p
x(3)=1.390968559086081_p
w(3)=4.456519265269674e-1_p
x(4)=4.109160896470163_p
w(4)=5.290996452405376e-2_p
x(5)=8.095925540021231_p
w(5)=1.462951720129390e-3_p
x(6)=14.09611008713829_p
w(6)=5.720651050143639e-6_p
else if(N==7)then
x(1)=-1.742970133303974_p
w(1)=5.534860187298755e-1_p
x(2)=-7.215762054319417e-1_p
w(2)=9.103495187768500e-1_p
x(3)=9.065148675088426e-1_p
w(3)=5.485310723345816e-1_p
x(4)=3.165250165782112_p
w(4)=1.078243911969450e-1_p
x(5)=6.323856197913067_p
w(5)=6.619252245249544e-3_p
x(6)=10.67838745240695_p
w(6)=1.173795010210799e-4_p
x(7)=16.76613262243774_p
w(7)=3.779795029145578e-7_p
else if(N==8)then
x(1)=-1.781486501702488_p
w(1)=4.745600395769999e-1_p
x(2)=-9.012417268168589e-1_p
w(2)=8.370345467126056e-1_p
x(3)=5.208375843344816e-1_p
w(3)=6.179865432219952e-1_p
x(4)=2.450273756133090_p
w(4)=1.775571892400594e-1_p
x(5)=5.058549369493700_p
w(5)=1.898990569988973e-2_p
x(6)=8.515831818825314_p
w(6)=7.883190123384200e-4_p
x(7)=13.00614262591718_p
w(7)=1.142022147794109e-5_p
x(8)=18.66401834378811_p
w(8)=4.707865954304927e-8_p
else if(N==9)then
x(1)=-1.812091146661834_p
w(1)=4.107441092961102e-1_p
x(2)=-1.047190290820200_p
w(2)=7.628838242893610e-1_p
x(3)=2.054961184772678e-1_p
w(3)=6.558497438760890e-1_p
x(4)=1.885721166253121_p
w(4)=2.530693872483288e-1_p
x(5)=4.097498272387550_p
w(5)=4.122888554610402e-2_p
x(6)=6.961463371734666_p
w(6)=3.047079836361780e-3_p
x(7)=10.56157444005384_p
w(7)=1.034491835138019e-4_p
x(8)=14.96132111898916_p
w(8)=1.520546306601843e-6_p
x(9)=19.84232136510728_p
w(9)=1.094185055429246e-8_p
else if(N==10)then
x(1)=-1.836764644194912_p
w(1)=3.586121374844303e-1_p
x(2)=-1.166907780927930_p
w(2)=6.925197735773962e-1_p
x(3)=-5.603445854312325e-2_p
w(3)=6.679345536297797e-1_p
x(4)=1.428097286088240_p
w(4)=3.250242780828591e-1_p
x(5)=3.341309475463540_p
w(5)=7.392642131561117e-2_p
x(6)=5.776866861477145_p
w(6)=8.388602761280804e-3_p
x(7)=8.784719345370247_p
w(7)=5.057224950880616e-4_p
x(8)=12.38881196752619_p
w(8)=1.623026353079414e-5_p
x(9)=16.51830552229169_p
w(9)=2.871759087140964e-7_p
x(10)=20.54360983766717_p
w(10)=3.978140779996083e-9_p
else if(N==11)then
x(1)=-1.856916987449402_p
w(1)=3.155953218833091e-1_p
x(2)=-1.266028336766533_p
w(2)=6.279749376495681e-1_p
x(3)=-2.752747903891645e-1_p
w(3)=6.612392295000740e-1_p
x(4)=1.049513644043244_p
w(4)=3.866204739403443e-1_p
x(5)=2.730679907460112_p
w(5)=1.153641635745545e-1_p
x(6)=4.840677801139134_p
w(6)=1.834788235638032e-2_p
x(7)=7.417742884350462_p
w(7)=1.689541439868473e-3_p
x(8)=10.470111675069_p
w(8)=9.321554331297289e-5_p
x(9)=13.96497182190467_p
w(9)=3.167695911063863e-6_p
x(10)=17.71361994895767_p
w(10)=7.525742366160933e-8_p
x(11)=20.96912323594196_p
w(11)=1.923279279234681e-9_p
else if(N==12)then
x(1)=-1.873576238368923_p
w(1)=2.797466369259200e-1_p
x(2)=-1.348856855346443_p
w(2)=5.698374523265330e-1_p
x(3)=-4.607222345808460e-1_p
w(3)=6.420578642856880e-1_p
x(4)=7.311967939706349e-1_p
w(4)=4.343832263779876e-1_p
x(5)=2.227235388980356_p
w(5)=1.621625936562590e-1_p
x(6)=4.081467489820359_p
w(6)=3.400014444287074e-2_p
x(7)=6.327983488810549_p
w(7)=4.358907963201189e-3_p
x(8)=8.969964840936630_p
w(8)=3.605354527994973e-4_p
x(9)=11.98519161331129_p
w(9)=1.984651024221733e-5_p
x(10)=15.28863704205518_p
w(10)=7.757215048604768e-7_p
x(11)=18.61347445639466_p
w(11)=2.598864471734324e-8_p
x(12)=21.23856702438018_p
w(12)=1.112374743347117e-9_p
else if(N==13)then
x(1)=-1.887499416706016_p
w(1)=2.495908543697593e-1_p
x(2)=-1.418682158978072_p
w(2)=5.179708692511015e-1_p
x(3)=-6.188114043237796e-1_p
w(3)=6.153062879526825e-1_p
x(4)=4.601070282741058e-1_p
w(4)=4.676572454845098e-1_p
x(5)=1.804998745966419_p
w(5)=2.103067269254331e-1_p
x(6)=3.453511986267414_p
w(6)=5.561244870464932e-2_p
x(7)=5.437336440721769_p
w(7)=9.332821285771044e-3_p
x(8)=7.759508197546491_p
w(8)=1.060823024283002e-3_p
x(9)=10.40274404058839_p
w(9)=8.472057395760813e-5_p
x(10)=13.31799625396851_p
w(10)=4.966007317347972e-6_p
x(11)=16.37978667202302_p
w(11)=2.353021226583615e-7_p
x(12)=19.28747841559153_p
w(12)=1.115971961860430e-8_p
x(13)=21.41720595495686_p
w(13)=7.227188585963618e-10_p
else if(N==14)then
x(1)=-1.899251211749650_p
w(1)=2.240032317110690e-1_p
x(2)=-1.478030595740014_p
w(2)=4.719104427382643e-1_p
x(3)=-7.545167112933676e-1_p
w(3)=5.845182089060035e-1_p
x(4)=2.268873629314048e-1_p
w(4)=4.876342498607872e-1_p
x(5)=1.445797105091631_p
w(5)=2.560908450041324e-1_p
x(6)=2.925799405207702_p
w(6)=8.255149618347711e-2_p
x(7)=4.695711177788304_p
w(7)=1.736426322556975e-2_p
x(8)=6.760470717597805_p
w(8)=2.556455760629778e-3_p
x(9)=9.106400664643376_p
w(9)=2.748872643272883e-4_p
x(10)=11.70054891650087_p
w(10)=2.237505100880655e-5_p
x(11)=14.47170066488729_p
w(11)=1.462630068492025e-6_p
x(12)=17.26946572284398_p
w(12)=8.626074768485565e-8_p
x(13)=19.79484844650177_p
w(13)=5.659871764187456e-9_p
x(14)=21.54071134323128_p
w(14)=5.080685236735833e-10_p
else if(N==15)then
x(1)=-1.909258825631622_p
w(1)=2.021180760851986e-1_p
x(2)=-1.528859292992706_p
w(2)=4.310708750320091e-1_p
x(3)=-8.717466654088649e-1_p
w(3)=5.520927047993408e-1_p
x(4)=2.460269891923014e-2_p
w(4)=4.964261054236026e-1_p
x(5)=1.136577294456907_p
w(5)=2.967180488115216e-1_p
x(6)=2.476398120005388_p
w(6)=1.134340969723695e-1_p
x(7)=4.068999399564416_p
w(7)=2.896181609529190e-2_p
x(8)=5.921669298217349_p
w(8)=5.294568477158508e-3_p
x(9)=8.024056557366242_p
w(9)=7.269588969006234e-4_p
x(10)=10.35192069657407_p
w(10)=7.752241639635354e-5_p
x(11)=12.85930272493918_p
w(11)=6.694327212281055e-6_p
x(12)=15.45927448762045_p
w(12)=5.026548081528685e-7_p
x(13)=17.99155455989512_p
w(13)=3.713978587762927e-8_p
x(14)=20.18093638572427_p
w(14)=3.254763046415108e-9_p
x(15)=21.62924756607327_p
w(15)=3.776667567584755e-10_p
else if(N==16)then
x(1)=-1.917849887524612_p
w(1)=1.832621882522921e-1_p
x(2)=-1.572698528397488_p
w(2)=3.948510775581021e-1_p
x(3)=-9.736107367129683e-1_p
w(3)=5.195839350428296e-1_p
x(4)=-1.520403202245550e-1_p
w(4)=4.963955630288844e-1_p
x(5)=8.677458110552848e-1_p
w(5)=3.305081962534300e-1_p
x(6)=2.089314449831300_p
w(6)=1.464313882194316e-1_p
x(7)=3.532927126180296_p
w(7)=4.426696899977693e-2_p
x(8)=5.207778197728388_p
w(8)=9.740101445056944e-3_p
x(9)=7.106745592417956_p
w(9)=1.642461738288600e-3_p
x(10)=9.211133344222649_p
w(10)=2.195845688250063e-4_p
x(11)=11.48850365500397_p
w(11)=2.405912092565528e-5_p
x(12)=13.88297688896624_p
w(12)=2.267250569301159e-6_p
x(13)=16.29882773870773_p
w(13)=1.986683380029301e-7_p
x(14)=18.57775133080388_p
w(14)=1.826663697084894e-8_p
x(15)=20.47874768025306_p
w(15)=2.058135608674550e-9_p
x(16)=21.69469942035021_p
w(16)=2.925028974844763e-10_p
else if(N==17)then
x(1)=-1.925278876656359_p
w(1)=1.669066966261114e-1_p
x(2)=-1.610755974367933_p
w(2)=3.626837443900526e-1_p
x(3)=-1.062607191561378_p
w(3)=4.879516206501023e-1_p
x(4)=-3.071839760164549e-1_p
w(4)=4.897636582136056e-1_p
x(5)=6.320990579695213e-1_p
w(5)=3.568103096599545e-1_p
x(6)=1.752612439217269_p
w(6)=1.796141475570517e-1_p
x(7)=3.069631708211993_p
w(7)=6.301344777151142e-2_p
x(8)=4.593396615153167_p
w(8)=1.629572834522724e-2_p
x(9)=6.319824072903779_p
w(9)=3.277065559568800e-3_p
x(10)=8.234267835373783_p
w(10)=5.310085252864665e-4_p
x(11)=10.31237351561433_p
w(11)=7.137221753796386e-5_p
x(12)=12.51527383653358_p
w(12)=8.247014105921598e-6_p
x(13)=14.78064176201119_p
w(13)=8.637842590514823e-7_p
x(14)=17.01013024278681_p
w(14)=8.880193280243889e-8_p
x(15)=19.0553182936085_p
w(15)=1.001476494236154e-8_p
x(16)=20.71180415823078_p
w(16)=1.399217428703292e-9_p
x(17)=21.74436648908647_p
w(17)=2.337357032907302e-10_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;22kT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078065480902212e-1_p
w(1)=1.057155520911097_p
x(2)=2.782862382128486_p
w(2)=2.561061663281787e-1_p
else if(N==3)then
x(1)=-4.522818732838578e-1_p
w(1)=8.263437789352853e-1_p
x(2)=1.608231336800678_p
w(2)=4.657866089286519e-1_p
x(3)=5.568614877523157_p
w(3)=2.113129937533882e-2_p
else if(N==4)then
x(1)=-5.847709105408605e-1_p
w(1)=6.657912946072209e-1_p
x(2)=1.009727419591064_p
w(2)=5.674346557817829e-1_p
x(3)=3.795701432845083_p
w(3)=7.887299342022143e-2_p
x(4)=8.623650688768148_p
w(4)=1.162743430050866e-3_p
else if(N==5)then
x(1)=-6.675807139518759e-1_p
w(1)=5.524340753412323e-1_p
x(2)=6.337341951526684e-1_p
w(2)=6.009859094153660e-1_p
x(3)=2.833930196459762_p
w(3)=1.518216681871639e-1_p
x(4)=6.284901053463295_p
w(4)=7.966320343133658e-3_p
x(5)=11.80036544707553_p
w(5)=5.371395238015574e-5_p
else if(N==6)then
x(1)=-7.250572622312286e-1_p
w(1)=4.678781039847444e-1_p
x(2)=3.680856838952572e-1_p
w(2)=5.981154497039631e-1_p
x(3)=2.196089073485481_p
w(3)=2.228961973285262e-1_p
x(4)=4.923701071342605_p
w(4)=2.372196215078029e-2_p
x(5)=8.907477615412601_p
w(5)=6.473385238639413e-4_p
x(6)=14.85533882653871_p
w(6)=2.635547398023560e-6_p
else if(N==7)then
x(1)=-7.682432620508820e-1_p
w(1)=4.012071831754908e-1_p
x(2)=1.646670511094400e-1_p
w(2)=5.757561028078473e-1_p
x(3)=1.722435935659864_p
w(3)=2.841447815466742e-1_p
x(4)=3.974935107460979_p
w(4)=4.914588764335277e-2_p
x(5)=7.125735251131401_p
w(5)=2.953282850006698e-3_p
x(6)=11.43534894642656_p
w(6)=5.425048853343636e-5_p
x(7)=17.36167118715591_p
w(7)=1.987273709561597e-7_p
else if(N==8)then
x(1)=-8.020990177409418e-1_p
w(1)=3.470858896602633e-1_p
x(2)=2.451621096339261e-3_p
w(2)=5.431189626049776e-1_p
x(3)=1.350151882063681_p
w(3)=3.316255943478750e-1_p
x(4)=3.259041145982020_p
w(4)=8.254643962963609e-2_p
x(5)=5.856659863139146_p
w(5)=8.515484832803606e-3_p
x(6)=9.274603039003367_p
w(6)=3.635782645592456e-4_p
x(7)=13.67099774066553_p
w(7)=5.708770766970651e-6_p
x(8)=19.06424310811338_p
w(8)=2.912839420349732e-8_p
else if(N==9)then
x(1)=-8.291580991598811e-1_p
w(1)=3.026777628307733e-1_p
x(2)=-1.290945902878425e-1_p
w(2)=5.060287291487172e-1_p
x(3)=1.049830439647494_p
w(3)=3.641884353115071e-1_p
x(4)=2.697945591255020_p
w(4)=1.203540972176485e-1_p
x(5)=4.896413791904988_p
w(5)=1.856471776430877e-2_p
x(6)=7.726640313276631_p
w(6)=1.396719562767353e-3_p
x(7)=11.25684468065416_p
w(7)=5.038187591400230e-5_p
x(8)=15.517297793814_p
w(8)=8.358110202882463e-7_p
x(9)=20.09442083473806_p
w(9)=7.716619499453335e-9_p
else if(N==10)then
x(1)=-8.510820804573805e-1_p
w(1)=2.659589168720244e-1_p
x(2)=-2.369729885356872e-1_p
w(2)=4.680990540976515e-1_p
x(3)=8.034914323662095e-1_p
w(3)=3.830680903670241e-1_p
x(4)=2.246988318770571_p
w(4)=1.585732404702705e-1_p
x(5)=4.143417039034475_p
w(5)=3.349257160400891e-2_p
x(6)=6.549935433340862_p
w(6)=3.819693856094314e-3_p
x(7)=9.501528019820674_p
w(7)=2.414926597949552e-4_p
x(8)=13.00851656949742_p
w(8)=8.450536565405758e-6_p
x(9)=16.96661445245463_p
w(9)=1.737130774491154e-7_p
x(10)=20.70369113002638_p
w(10)=3.062764470462021e-9_p
else if(N==11)then
x(1)=-8.690705850625856e-1_p
w(1)=2.353452092771881e-1_p
x(2)=-3.263743081518446e-1_p
w(2)=4.313696350035228e-1_p
x(3)=5.986848872210867e-1_p
w(3)=3.907073294313967e-1_p
x(4)=1.877233368712957_p
w(4)=1.939178957503928e-1_p
x(5)=3.537393885130838_p
w(5)=5.276767042395462e-2_p
x(6)=5.621730515010356_p
w(6)=8.311358005046329e-3_p
x(7)=8.151858001156047_p
w(7)=7.938906206980679e-4_p
x(8)=11.12857039554267_p
w(8)=4.687544325431288e-5_p
x(9)=14.50480365640817_p
w(9)=1.772116695248030e-6_p
x(10)=18.06742401413591_p
w(10)=4.960070571476595e-8_p
x(11)=21.07481355833541_p
w(11)=1.566421389832540e-9_p
else if(N==12)then
x(1)=-8.840026850054836e-1_p
w(1)=2.096048121072141e-1_p
x(2)=-4.011984248501161e-1_p
w(2)=3.968779324524183e-1_p
x(3)=4.264637138984416e-1_p
w(3)=3.897917645168165e-1_p
x(4)=1.569067102819017_p
w(4)=2.242463960931212e-1_p
x(5)=3.039644146226481_p
w(5)=7.517122466791423e-2_p
x(6)=4.870180310112639_p
w(6)=1.536072181656838e-2_p
x(7)=7.076686596149458_p
w(7)=2.021104680842284e-3_p
x(8)=9.656393642684920_p
w(8)=1.766764802336754e-4_p
x(9)=12.58021248858313_p
w(9)=1.056937050392195e-5_p
x(10)=15.7509896978753_p
w(10)=4.657220719353039e-7_p
x(11)=18.89064536535589_p
w(11)=1.839175403957571e-8_p
x(12)=21.31156553202763_p
w(12)=9.398175250044438e-10_p
else if(N==13)then
x(1)=-8.965289412022369e-1_p
w(1)=1.877849172382111e-1_p
x(2)=-4.643948577299687e-1_p
w(2)=3.650657590786835e-1_p
x(3)=2.802372518161240e-1_p
w(3)=3.827493958367013e-1_p
x(4)=1.308768464295275_p
w(4)=2.485321848554630e-1_p
x(5)=2.624044094187585_p
w(5)=9.915494022648251e-2_p
x(6)=4.249531580401052_p
w(6)=2.513739408490634e-2_p
x(7)=6.198629781796307_p
w(7)=4.281341398409982e-3_p
x(8)=8.467944013486253_p
w(8)=5.092442630045411e-4_p
x(9)=11.03645200370697_p
w(9)=4.354559822044495e-5_p
x(10)=13.84877459508275_p
w(10)=2.804901822344321e-6_p
x(11)=16.77161247845912_p
w(11)=1.507751450033540e-7_p
x(12)=19.50527640738738_p
w(12)=8.356291963386780e-9_p
x(13)=21.46977351862072_p
w(13)=6.259339570496477e-10_p
else if(N==14)then
x(1)=-9.071372022291708e-1_p
w(1)=1.691461014872283e-1_p
x(2)=-5.182173253165950e-1_p
w(2)=3.360358613021875e-1_p
x(3)=1.550382597513640e-1_p
w(3)=3.715668216386617e-1_p
x(4)=1.086453586948228_p
w(4)=2.666168413115764e-1_p
x(5)=2.272276147977951_p
w(5)=1.231737735955065e-1_p
x(6)=3.728885864780780_p
w(6)=3.746316693082635e-2_p
x(7)=5.468039542180971_p
w(7)=7.902025263403094e-3_p
x(8)=7.487067985429968_p
w(8)=1.206625975308521e-3_p
x(9)=9.769705175140610_p
w(9)=1.374392183913193e-4_p
x(10)=12.27958865865298_p
w(10)=1.209243330064034e-5_p
x(11)=14.94075417721177_p
w(11)=8.746672589574333e-7_p
x(12)=17.59991257849308_p
w(12)=5.853957322664569e-8_p
x(13)=19.96758814137125_p
w(13)=4.428283191554106e-9_p
x(14)=21.57995280847062_p
w(14)=4.477701852897051e-10_p
else if(N==15)then
x(1)=-9.161984254926373e-1_p
w(1)=1.531105122800903e-1_p
x(2)=-5.644074079935411e-1_p
w(2)=3.097071053380589e-1_p
x(3)=4.704823036018228e-2_p
w(3)=3.577728234651773e-1_p
x(4)=8.948100349722856e-1_p
w(4)=2.789112405223190e-1_p
x(5)=1.971103351033140_p
w(5)=1.459171326512124e-1_p
x(6)=3.286457107233940_p
w(6)=5.186721807769130e-2_p
x(7)=4.851137688573323_p
w(7)=1.311128330598420e-2_p
x(8)=6.663687930555706_p
w(8)=2.464352217262388e-3_p
x(9)=8.711247789538023_p
w(9)=3.553789571329486e-4_p
x(10)=10.96767960842964_p
w(10)=4.048984350610795e-5_p
x(11)=13.3842037303336_p
w(11)=3.804104229708054e-6_p
x(12)=15.87130486853779_p
w(12)=3.170312192340647e-7_p
x(13)=18.27013900916298_p
w(13)=2.647372643344610e-8_p
x(14)=20.31963849803451_p
w(14)=2.634557267261601e-9_p
x(15)=21.65944301895004_p
w(15)=3.371084885939195e-10_p
else if(N==16)then
x(1)=-9.239984602677273e-1_p
w(1)=1.392228425547768e-1_p
x(2)=-6.043257811287434e-1_p
w(2)=2.859061494706703e-1_p
x(3)=-4.671691656446363e-2_p
w(3)=3.424949371868641e-1_p
x(4)=7.282980106850376e-1_p
w(4)=2.861342819259766e-1_p
x(5)=1.710720751849567_p
w(5)=1.664232598387224e-1_p
x(6)=2.906373821619375_p
w(6)=6.768846217794883e-2_p
x(7)=4.323925423293918_p
w(7)=1.999504613962571e-2_p
x(8)=5.963140344912895_p
w(8)=4.482527232176410e-3_p
x(9)=7.813888450308725_p
w(9)=7.879831437243672e-4_p
x(10)=9.856285183999763_p
w(10)=1.115596147578837e-4_p
x(11)=12.05625605047412_p
w(11)=1.313864786401163e-5_p
x(12)=14.35609026957765_p
w(12)=1.352268269211947e-6_p
x(13)=16.65966555745628_p
w(13)=1.314937936374606e-7_p
x(14)=18.81328100429204_p
w(14)=1.356994193118181e-8_p
x(15)=20.59161469898705_p
w(15)=1.710555613244367e-9_p
x(16)=21.71853350323076_p
w(16)=2.636082177587499e-10_p
else if(N==17)then
x(1)=-9.307603088897687e-1_p
w(1)=1.271212889363232e-1_p
x(2)=-6.390465757014772e-1_p
w(2)=2.644204126808095e-1_p
x(3)=-1.286212238248395e-1_p
w(3)=3.265377447956638e-1_p
x(4)=5.826328683848256e-1_p
w(4)=2.891214313686620e-1_p
x(5)=1.483710947813607_p
w(5)=1.840980427728046e-1_p
x(6)=2.576774453034155_p
w(6)=8.418912784485404e-2_p
x(7)=3.868777049051159_p
w(7)=2.848547055945118e-2_p
x(8)=5.360470630100959_p
w(8)=7.434004367785683e-3_p
x(9)=7.044019798275203_p
w(9)=1.547488324083457e-3_p
x(10)=8.903782249646929_p
w(10)=2.636213739142495e-4_p
x(11)=10.91448171359146_p
w(11)=3.773867103344781e-5_p
x(12)=13.03606011612716_p
w(12)=4.705968227284510e-6_p
x(13)=15.20550249233153_p
w(13)=5.391296608434897e-7_p
x(14)=17.32592381771539_p
w(14)=6.134612815422973e-8_p
x(15)=19.25542392150588_p
w(15)=7.700375822940195e-9_p
x(16)=20.80487034874241_p
w(16)=1.187279375619857e-9_p
x(17)=21.76358781486258_p
w(17)=2.122193677852198e-10_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;22kT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905387673772715e-1_p
w(1)=5.746631420949835e-1_p
x(2)=3.592381351323289_p
w(2)=1.184840381860151e-1_p
else if(N==3)then
x(1)=4.840415458841749e-1_p
w(1)=4.633528154740653e-1_p
x(2)=2.446683753161429_p
w(2)=2.207557291109351e-1_p
x(3)=6.424150727655007_p
w(3)=9.038635695998127e-3_p
else if(N==4)then
x(1)=3.711349022286542e-1_p
w(1)=3.824279918128327e-1_p
x(2)=1.874724585702966_p
w(2)=2.763606159052473e-1_p
x(3)=4.659446525310364_p
w(3)=3.387474976025399e-2_p
x(4)=9.501465016342054_p
w(4)=4.838228026645117e-4_p
else if(N==5)then
x(1)=2.996288258160962e-1_p
w(1)=3.230625824110218e-1_p
x(2)=1.519894205863289_p
w(2)=3.006655867401247e-1_p
x(3)=3.702322739072334_p
w(3)=6.608071853462417e-2_p
x(4)=7.163100530802825_p
w(4)=3.315840245119859e-3_p
x(5)=12.6685055410462_p
w(5)=2.245235010790056e-5_p
else if(N==6)then
x(1)=2.491982561333610e-1_p
w(1)=2.772144780774475e-1_p
x(2)=1.270136440721366_p
w(2)=3.067856784354852e-1_p
x(3)=3.066609807689195_p
w(3)=9.891332440917949e-2_p
x(4)=5.794551836445859_p
w(4)=9.958675430594347e-3_p
x(5)=9.760560298656440_p
w(5)=2.738354498385887e-4_p
x(6)=15.6280955837034_p
w(6)=1.188478453418179e-6_p
else if(N==7)then
x(1)=2.108486731999845e-1_p
w(1)=2.400828217536480e-1_p
x(2)=1.079459984994463_p
w(2)=3.020665084341038e-1_p
x(3)=2.596025495459772_p
w(3)=1.288575204369775e-1_p
x(4)=4.838892936669551_p
w(4)=2.085520146089717e-2_p
x(5)=7.967287627223744_p
w(5)=1.260619720477139e-3_p
x(6)=12.21442687380414_p
w(6)=2.440335329763115e-5_p
x(7)=17.93796815167594_p
w(7)=1.051215973228804e-7_p
else if(N==8)then
x(1)=1.806131560682794e-1_p
w(1)=2.094055030347794e-1_p
x(2)=9.282907564189438e-1_p
w(2)=2.908005372602261e-1_p
x(3)=2.229573132163511_p
w(3)=1.537363052373673e-1_p
x(4)=4.120777764951304_p
w(4)=3.539432088058316e-2_p
x(5)=6.694821004195620_p
w(5)=3.645046180014318e-3_p
x(6)=10.05968793711285_p
w(6)=1.626323303589185e-4_p
x(7)=14.34248847410482_p
w(7)=2.817085111499885e-6_p
x(8)=19.43851478253534_p
w(8)=1.827255787859142e-8_p
else if(N==9)then
x(1)=1.563628747565284e-1_p
w(1)=1.838995596415971e-1_p
x(2)=8.063515098098893e-1_p
w(2)=2.759188096797913e-1_p
x(3)=1.937018393030320_p
w(3)=1.725613134173949e-1_p
x(4)=3.561227467609372_p
w(4)=5.217662421909851e-2_p
x(5)=5.736059779726019_p
w(5)=7.946956272200800e-3_p
x(6)=8.520522778928928_p
w(6)=6.194026261689663e-4_p
x(7)=11.96741464174239_p
w(7)=2.405104034661933e-5_p
x(8)=16.06973184752102_p
w(8)=4.578861952553508e-7_p
x(9)=20.32742303542322_p
w(9)=5.498204984126382e-9_p
else if(N==10)then
x(1)=1.366502618009334e-1_p
w(1)=1.625717460207259e-1_p
x(2)=7.066965008849017e-1_p
w(2)=2.593984152252509e-1_p
x(3)=1.699239177342156_p
w(3)=1.854307662698170e-1_p
x(4)=3.114146285010722_p
w(4)=6.961103557143863e-2_p
x(5)=4.986745139878992_p
w(5)=1.433934385933137e-2_p
x(6)=7.353251288641998_p
w(6)=1.678795107530098e-3_p
x(7)=10.23781009972187_p
w(7)=1.126219727874281e-4_p
x(8)=13.63485314600855_p
w(8)=4.348624940142837e-6_p
x(9)=17.40641703426092_p
w(9)=1.052582193002975e-7_p
x(10)=20.85184986063196_p
w(10)=2.370957734148734e-9_p
else if(N==11)then
x(1)=1.204247900729827e-1_p
w(1)=1.446153772397290e-1_p
x(2)=6.242741122969845e-1_p
w(2)=2.424887125903776e-1_p
x(3)=1.503054993105321_p
w(3)=1.930642138145816e-1_p
x(4)=2.749708202583331_p
w(4)=8.633836554447083e-2_p
x(5)=4.385433553469759_p
w(5)=2.262915084227783e-2_p
x(6)=6.434198535351556_p
w(6)=3.623710698571103e-3_p
x(7)=8.907907764566442_p
w(7)=3.634387208760202e-4_p
x(8)=11.79900856705033_p
w(8)=2.319112778694775e-5_p
x(9)=15.04520779865694_p
w(9)=9.856220623208175e-7_p
x(10)=18.41157197790851_p
w(10)=3.280180995090149e-8_p
x(11)=21.17325263038942_p
w(11)=1.278455269523863e-9_p
else if(N==12)then
x(1)=1.069160272454638e-1_p
w(1)=1.293884317317529e-1_p
x(2)=5.553607402191920e-1_p
w(2)=2.259361248314213e-1_p
x(3)=1.339112165079957_p
w(3)=1.964109923832982e-1_p
x(4)=2.447736187843699_p
w(4)=1.013986894233242e-1_p
x(5)=3.892961973699762_p
w(5)=3.235700586527688e-2_p
x(6)=5.691253679221907_p
w(6)=6.653998682706600e-3_p
x(7)=7.849008336203484_p
w(7)=9.111445506250395e-4_p
x(8)=10.35804663225956_p
w(8)=8.493079891604988e-5_p
x(9)=13.18143285260942_p
w(9)=5.569152504775506e-6_p
x(10)=16.21028367972178_p
w(10)=2.790095904947719e-7_p
x(11)=19.15898398358197_p
w(11)=1.305752172026906e-8_p
x(12)=21.38005541988353_p
w(12)=7.940603208554056e-10_p
else if(N==13)then
x(1)=9.555258504991303e-2_p
w(1)=1.163844752337155e-1_p
x(2)=4.971775439342722e-1_p
w(2)=2.101589125920798e-1_p
x(3)=1.200611137005943_p
w(3)=1.964237147810956e-1_p
x(4)=2.194108654883327_p
w(4)=1.142380177942064e-1_p
x(5)=3.483002159871722_p
w(5)=4.293408427210656e-2_p
x(6)=5.078636692150329_p
w(6)=1.083950392901947e-2_p
x(7)=6.984829163416435_p
w(7)=1.905419109231392e-3_p
x(8)=9.193787248367817_p
w(8)=2.393016368365010e-4_p
x(9)=11.68002279765038_p
w(9)=2.207357873065670e-5_p
x(10)=14.38160557595241_p
w(10)=1.573944515891169e-6_p
x(11)=17.15861637648765_p
w(11)=9.659629289199207e-8_p
x(12)=19.71572461980628_p
w(12)=6.271692040510636e-9_p
x(13)=21.51943439244368_p
w(13)=5.414757857186231e-10_p
else if(N==14)then
x(1)=8.590473646267854e-2_p
w(1)=1.052037263021940e-1_p
x(2)=4.476208820411731e-1_p
w(2)=1.953678400195281e-1_p
x(3)=1.082495243872742_p
w(3)=1.939502374554495e-1_p
x(4)=1.978644753729490_p
w(4)=1.246372061249389e-1_p
x(5)=3.137119735794326_p
w(5)=5.376277394095567e-2_p
x(6)=4.565509964920225_p
w(6)=1.611472240470108e-2_p
x(7)=6.266328343800759_p
w(7)=3.479519938531311e-3_p
x(8)=8.232668964589307_p
w(8)=5.565040126959620e-4_p
x(9)=10.44540981788386_p
w(9)=6.761358708013814e-5_p
x(10)=12.86435190878511_p
w(10)=6.471773380621375e-6_p
x(11)=15.40912309141136_p
w(11)=5.211056022429291e-7_p
x(12)=17.9249934509913_p
w(12)=3.975282711672420e-8_p
x(13)=20.13446808807716_p
w(13)=3.469228866975183e-9_p
x(14)=21.61724831879556_p
w(14)=3.938849993385574e-10_p
else if(N==15)then
x(1)=7.764470784953897e-2_p
w(1)=9.552909994964506e-2_p
x(2)=4.050758692313277e-1_p
w(2)=1.816458392454587e-1_p
x(3)=9.809275879261621e-1_p
w(3)=1.896956490220506e-1_p
x(4)=1.793814781922621_p
w(4)=1.326172747978263e-1_p
x(5)=2.841987432855469_p
w(5)=6.431863273516170e-2_p
x(6)=4.130174470120263_p
w(6)=2.230391251136947e-2_p
x(7)=5.660117457379435_p
w(7)=5.724025162636016e-3_p
x(8)=7.425961804528034_p
w(8)=1.118854926395925e-3_p
x(9)=9.412696868704060_p
w(9)=1.706317706809844e-4_p
x(10)=11.59184040478924_p
w(10)=2.089199099962792e-5_p
x(11)=13.9117729378415_p
w(11)=2.147290524462267e-6_p
x(12)=16.28101420015284_p
w(12)=1.995588654094171e-7_p
x(13)=18.54349856152662_p
w(13)=1.888577600491098e-8_p
x(14)=20.45374675843119_p
w(14)=2.133396265285339e-9_p
x(15)=21.68828936599053_p
w(15)=3.002119404313492e-10_p
else if(N==16)then
x(1)=7.051915495263414e-2_p
w(1)=8.710751590644569e-2_p
x(2)=3.682867557580959e-1_p
w(2)=1.689993969145183e-1_p
x(3)=8.929460142034559e-1_p
w(3)=1.842211941139752e-1_p
x(4)=1.633926385888629_p
w(4)=1.383508331132271e-1_p
x(5)=2.587717407583893_p
w(5)=7.419227626707424e-2_p
x(6)=3.756843056641425_p
w(6)=2.916067777888757e-2_p
x(7)=5.142478220875849_p
w(7)=8.672357098901550e-3_p
x(8)=6.739793187564924_p
w(8)=2.008298367040176e-3_p
x(9)=8.536719603348592_p
w(9)=3.707306836353974e-4_p
x(10)=10.51185289663048_p
w(10)=5.588795095188857e-5_p
x(11)=12.62929148834734_p
w(11)=7.110471304067542e-6_p
x(12)=14.82972721924937_p
w(12)=8.029231609004191e-7_p
x(13)=17.01733246020768_p
w(13)=8.694690898687250e-8_p
x(14)=19.04405114543561_p
w(14)=1.008679554988114e-8_p
x(15)=20.70089165105917_p
w(15)=1.421211652403850e-9_p
x(16)=21.7414027471707_p
w(16)=2.369602308541123e-10_p
else if(N==17)then
x(1)=6.432985424393345e-2_p
w(1)=7.973558513126049e-2_p
x(2)=3.362655341494877e-1_p
w(2)=1.573911679223724e-1_p
x(3)=8.162294376806563e-1_p
w(3)=1.779599994939923e-1_p
x(4)=1.494594169219371_p
w(4)=1.420918288996572e-1_p
x(5)=2.366813964887903_p
w(5)=8.309995938272118e-2_p
x(6)=3.433722666985070_p
w(6)=3.640881860441227e-2_p
x(7)=4.696001060027101_p
w(7)=1.229888045056204e-2_p
x(8)=6.149719837981274_p
w(8)=3.293717178813028e-3_p
x(9)=7.785057154660846_p
w(9)=7.155754858473170e-4_p
x(10)=9.585276394324863_p
w(10)=1.288568274229604e-4_p
x(11)=11.52391970169199_p
w(11)=1.973834867779666e-5_p
x(12)=13.55976743867421_p
w(12)=2.667583047086385e-6_p
x(13)=15.62946375984615_p
w(13)=3.354928933225424e-7_p
x(14)=17.63821610248314_p
w(14)=4.235834909262860e-8_p
x(15)=19.45134739291856_p
w(15)=5.922260604378533e-9_p
x(16)=20.89511962157694_p
w(16)=1.006547218244059e-9_p
x(17)=21.78210007495311_p
w(17)=1.921622326034138e-10_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;22kT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631824502769557_p
w(1)=2.640324622128666e-1_p
x(2)=4.490321267941533_p
w(2)=4.922922502640938e-2_p
else if(N==3)then
x(1)=1.446108510284451_p
w(1)=2.168143830663229e-1_p
x(2)=3.359418131463209_p
w(2)=9.284460369947641e-2_p
x(3)=7.346907721011682_p
w(3)=3.602700473476768e-3_p
else if(N==4)then
x(1)=1.344185862981627_p
w(1)=1.816083954133337e-1_p
x(2)=2.800323761655480_p
w(2)=1.179415700121859e-1_p
x(3)=5.586157900569606_p
w(3)=1.352111133670050e-2_p
x(4)=10.43277323032716_p
w(4)=1.906104770559930e-4_p
else if(N==5)then
x(1)=1.279045808989672_p
w(1)=1.551128117909287e-1_p
x(2)=2.454937026462200_p
w(2)=1.302489081292998e-1_p
x(3)=4.628592216034967_p
w(3)=2.657803278776475e-2_p
x(4)=8.088086561876231_p
w(4)=1.312881213905941e-3_p
x(5)=13.56915411231702_p
w(5)=9.053317376772188e-6_p
else if(N==6)then
x(1)=1.232548622546015_p
w(1)=1.341269813700453e-1_p
x(2)=2.211647690221988_p
w(2)=1.347981935639757e-1_p
x(3)=3.989638899861475_p
w(3)=4.024047707899010e-2_p
x(4)=6.707433332446167_p
w(4)=3.983269956813572e-3_p
x(5)=10.64136297032573_p
w(5)=1.122313817023699e-4_p
x(6)=16.39422707370558_p
w(6)=5.338877490041934e-7_p
else if(N==7)then
x(1)=1.196956372825064_p
w(1)=1.168310285004221e-1_p
x(2)=2.026443535390678_p
w(2)=1.344468183174595e-1_p
x(3)=3.517434635844585_p
w(3)=5.304147082488838e-2_p
x(4)=5.743170323526181_p
w(4)=8.410199066614773e-3_p
x(5)=8.836319243856121_p
w(5)=5.212987222562525e-4_p
x(6)=13.00270415686301_p
w(6)=1.081514326936150e-5_p
x(7)=18.48102933033329_p
w(7)=5.666436558836007e-8_p
else if(N==8)then
x(1)=1.168862558015218_p
w(1)=1.023960915247952e-1_p
x(2)=1.880590583464558_p
w(2)=1.309534494855708e-1_p
x(3)=3.152330538510593_p
w(3)=6.398425409984498e-2_p
x(4)=5.022103637976021_p
w(4)=1.434630511256201e-2_p
x(5)=7.561424309312952_p
w(5)=1.508883983039231e-3_p
x(6)=10.86030267697863_p
w(6)=7.130473582916933e-5_p
x(7)=15.00963892451108_p
w(7)=1.386604413371688e-6_p
x(8)=19.78123485337923_p
w(8)=1.169322130082222e-8_p
else if(N==9)then
x(1)=1.146325502531528_p
w(1)=9.030310048927363e-2_p
x(2)=1.763662866762579_p
w(2)=1.255759192506502e-1_p
x(3)=2.863060631391317_p
w(3)=7.258798478725487e-2_p
x(4)=4.463173597184031_p
w(4)=2.123286252720281e-2_p
x(5)=6.604924148460964_p
w(5)=3.281744625487411e-3_p
x(6)=9.333129625597742_p
w(6)=2.684612612831672e-4_p
x(7)=12.68374887792773_p
w(7)=1.135828273753536e-5_p
x(8)=16.610157506217_p
w(8)=2.520461369948442e-7_p
x(9)=20.53940590353558_p
w(9)=3.969249429959035e-9_p
else if(N==10)then
x(1)=1.127995591118673_p
w(1)=8.012340450985257e-2_p
x(2)=1.668542519036468_p
w(2)=1.191944725345910e-1_p
x(3)=2.629509224930464_p
w(3)=7.882177112896764e-2_p
x(4)=4.018627582148355_p
w(4)=2.844557938227068e-2_p
x(5)=5.859797269832984_p
w(5)=5.902797858007233e-3_p
x(6)=8.177150288329621_p
w(6)=7.196253501918604e-4_p
x(7)=10.98477611716516_p
w(7)=5.174121696064767e-5_p
x(8)=14.25970907700857_p
w(8)=2.229144217886526e-6_p
x(9)=17.83175978869397_p
w(9)=6.426577636268651e-8_p
x(10)=20.98726876667929_p
w(10)=1.848440199601115e-9_p
else if(N==11)then
x(1)=1.112896440324287_p
w(1)=7.150205765157845e-2_p
x(2)=1.590136241224185_p
w(2)=1.123918199823071e-1_p
x(3)=2.437913346450273_p
w(3)=8.291269798360458e-2_p
x(4)=3.657773760670791_p
w(4)=3.545180431619379e-2_p
x(5)=5.263447344552279_p
w(5)=9.290049321002275e-3_p
x(6)=7.268490386870011_p
w(6)=1.537834336125935e-3_p
x(7)=9.677510913892512_p
w(7)=1.634791487241058e-4_p
x(8)=12.47375310970227_p
w(8)=1.137308529336293e-5_p
x(9)=15.5795990778965_p
w(9)=5.485121965587559e-7_p
x(10)=18.74208593565314_p
w(10)=2.185550623763961e-8_p
x(11)=21.2639654124295_p
w(11)=1.046743663140157e-9_p
else if(N==12)then
x(1)=1.100314526383455_p
w(1)=6.415301432648710e-2_p
x(2)=1.524745138464499_p
w(2)=1.055377660633376e-1_p
x(3)=2.278592306469557_p
w(3)=8.519503450502754e-2_p
x(4)=3.359960198299853_p
w(4)=4.186983132785795e-2_p
x(5)=4.776228718234417_p
w(5)=1.326058833136770e-2_p
x(6)=6.535051166378360_p
w(6)=2.799192069744634e-3_p
x(7)=8.636765286814287_p
w(7)=4.028175561851626e-4_p
x(8)=11.06757206869357_p
w(8)=4.034336280043851e-5_p
x(9)=13.78229732667558_p
w(9)=2.922053423120881e-6_p
x(10)=16.66136990460348_p
w(10)=1.676447462233100e-7_p
x(11)=19.41584503401325_p
w(11)=9.326827898158098e-9_p
x(12)=21.44370502237434_p
w(12)=6.714706455611258e-10_p
else if(N==13)then
x(1)=1.089721412166760_p
w(1)=5.784802385017970e-2_p
x(2)=1.469639010892921_p
w(2)=9.885742501155301e-2_p
x(3)=2.144563322442632_p
w(3)=8.602156562887535e-2_p
x(4)=3.110773983414364_p
w(4)=4.746978066172853e-2_p
x(5)=4.371592578227056_p
w(5)=1.758542980161070e-2_p
x(6)=5.931129997882854_p
w(6)=4.526327031562465e-3_p
x(7)=7.787805670827207_p
w(7)=8.302058610713773e-4_p
x(8)=9.929892321091289_p
w(8)=1.108749341423024e-4_p
x(9)=12.32704094640087_p
w(9)=1.110496385080195e-5_p
x(10)=14.91101199738057_p
w(10)=8.821787988098031e-7_p
x(11)=17.5368583170182_p
w(11)=6.212008845780281e-8_p
x(12)=19.91701901199968_p
w(12)=4.727660219125695e-9_p
x(13)=21.56593957803505_p
w(13)=4.681543036611963e-10_p
else if(N==14)then
x(1)=1.080719801243631_p
w(1)=5.240502550354880e-2_p
x(2)=1.422768457726681_p
w(2)=9.248023829340957e-2_p
x(3)=2.030671702090447_p
w(3)=8.571847889977925e-2_p
x(4)=2.899843129560798_p
w(4)=5.214726245811237e-2_p
x(5)=4.030993619947890_p
w(5)=2.203503992583221e-2_p
x(6)=5.425983337807483_p
w(6)=6.688924926817644e-3_p
x(7)=7.082409664545548_p
w(7)=1.497357700908173e-3_p
x(8)=8.990237695265206_p
w(8)=2.526366107070431e-4_p
x(9)=11.12723128716714_p
w(9)=3.293337037819809e-5_p
x(10)=13.44930230205815_p
w(10)=3.448705181045632e-6_p
x(11)=15.87230944045454_p
w(11)=3.106779243556819e-7_p
x(12)=18.2417130489812_p
w(12)=2.709518698668030e-8_p
x(13)=20.2942117245124_p
w(13)=2.725489294324291e-9_p
x(14)=21.65240536915388_p
w(14)=3.460010976655728e-10_p
else if(N==15)then
x(1)=1.073006604443198_p
w(1)=4.767829243808542e-2_p
x(2)=1.382570791793392_p
w(2)=8.647364504420868e-2_p
x(3)=1.933034329885790_p
w(3)=8.456660338743111e-2_p
x(4)=2.719509589066777_p
w(4)=5.588932266055450e-2_p
x(5)=3.741042502533191_p
w(5)=2.640866125020553e-2_p
x(6)=4.998005003862374_p
w(6)=9.215514909847691e-3_p
x(7)=6.487684750146945_p
w(7)=2.437341549202513e-3_p
x(8)=8.201485290966199_p
w(8)=4.992778675892526e-4_p
x(9)=10.12221609791582_p
w(9)=8.096959320334219e-5_p
x(10)=12.21889095203153_p
w(10)=1.070760906139613e-5_p
x(11)=14.43728605545995_p
w(11)=1.209596529602268e-6_p
x(12)=16.6847470099679_p
w(12)=1.258210360947740e-7_p
x(13)=18.80934542806181_p
w(13)=1.351526911156324e-8_p
x(14)=20.5823238784807_p
w(14)=1.730209839934096e-9_p
x(15)=21.71563530938024_p
w(15)=2.668419318808616e-10_p
else if(N==16)then
x(1)=1.066347457232299_p
w(1)=4.355057433174449e-2_p
x(2)=1.347837433186453_p
w(2)=8.086567956851295e-2_p
x(3)=1.848674215830628_p
w(3)=8.279722798364063e-2_p
x(4)=2.563995488219808_p
w(4)=5.874280088276755e-2_p
x(5)=3.491812490102452_p
w(5)=3.054844316168533e-2_p
x(6)=4.631491511668314_p
w(6)=1.200965627771565e-2_p
x(7)=5.980244509467670_p
w(7)=3.659925549020736e-3_p
x(8)=7.530699346969435_p
w(8)=8.831138382376061e-4_p
x(9)=9.269103756432925_p
w(9)=1.721323977533191e-4_p
x(10)=11.17236682376832_p
w(10)=2.775865585964524e-5_p
x(11)=13.20280168132873_p
w(11)=3.831598271646704e-6_p
x(12)=15.29989129850674_p
w(12)=4.764791114508101e-7_p
x(13)=17.36886916866557_p
w(13)=5.760496129700956e-8_p
x(14)=19.26829419397747_p
w(14)=7.516011050255048e-9_p
x(15)=20.80586788173666_p
w(15)=1.181453901963790e-9_p
x(16)=21.76318670247431_p
w(16)=2.125287721010024e-10_p
else if(N==17)then
x(1)=1.060558882354207_p
w(1)=3.992697110106507e-2_p
x(2)=1.317621660805497_p
w(2)=7.565991781740194e-2_p
x(3)=1.775273992069056_p
w(3)=8.059517259085860e-2_p
x(4)=2.428860353110981_p
w(4)=6.078905802540401e-2_p
x(5)=3.275781236043272_p
w(5)=3.434246101765801e-2_p
x(6)=4.314721101333798_p
w(6)=1.496550352856124e-2_p
x(7)=5.542917985674691_p
w(7)=5.151966873007650e-3_p
x(8)=6.954032364518395_p
w(8)=1.430133963951401e-3_p
x(9)=8.536810455518459_p
w(9)=3.261367926418079e-4_p
x(10)=10.27331580530472_p
w(10)=6.235279971965037e-5_p
x(11)=12.13585523243869_p
w(11)=1.026069818618578e-5_p
x(12)=14.08222564442018_p
w(12)=1.508295182407982e-6_p
x(13)=16.04916266945464_p
w(13)=2.088424923138579e-7_p
x(14)=17.9446081703281_p
w(14)=2.930390625052773e-8_p
x(15)=19.6417029466801_p
w(15)=4.562509978964704e-9_p
x(16)=20.98199870035536_p
w(16)=8.531548145462579e-10_p
x(17)=21.79980625090549_p
w(17)=1.735746701256563e-10_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;22kT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604165148587409_p
w(1)=1.077989108718480e-1_p
x(2)=5.444183689951430_p
w(2)=1.912909989217763e-2_p
else if(N==3)then
x(1)=2.427919263379561_p
w(1)=8.928706913223929e-2_p
x(2)=4.319766368950376_p
w(2)=3.626651623366763e-2_p
x(3)=8.311712034841426_p
w(3)=1.374425398118770e-3_p
else if(N==4)then
x(1)=2.330986036697392_p
w(1)=7.530940256954338e-2_p
x(2)=3.765669203065301_p
w(2)=4.637975577136268e-2_p
x(3)=6.551126218031085_p
w(3)=5.166162955990900e-3_p
x(4)=11.39547522027365_p
w(4)=7.268946712872089e-5_p
else if(N==5)then
x(1)=2.268556249234445_p
w(1)=6.461701440596473e-2_p
x(2)=3.422697511824253_p
w(2)=5.158513712525609e-2_p
x(3)=5.588781523293854_p
w(3)=1.021651215237316e-2_p
x(4)=9.037798066201466_p
w(4)=5.057401908853942e-4_p
x(5)=14.47673730976647_p
w(5)=3.606889546301432e-6_p
else if(N==6)then
x(1)=2.223591412403641_p
w(1)=5.600788577428632e-2_p
x(2)=3.180200264531735_p
w(2)=5.373396849833596e-2_p
x(3)=4.943079475366533_p
w(3)=1.558765943101319e-2_p
x(4)=7.641492445572824_p
w(4)=1.552773827756775e-3_p
x(5)=11.52909483933064_p
w(5)=4.547865861068921e-5_p
x(6)=17.12803342847766_p
w(6)=2.445740227550859e-7_p
else if(N==7)then
x(1)=2.189106813520480_p
w(1)=4.885415499066067e-2_p
x(2)=2.996112790279977_p
w(2)=5.388488254734902e-2_p
x(3)=4.466936948695663_p
w(3)=2.067128887065574e-2_p
x(4)=6.668178425052102_p
w(4)=3.300198030507210e-3_p
x(5)=9.714911270295834_p
w(5)=2.126494012775140e-4_p
x(6)=13.78223738559577_p
w(6)=4.805354424933665e-6_p
x(7)=18.97686421604611_p
w(7)=3.156915060535360e-8_p
else if(N==8)then
x(1)=2.161951339734738_p
w(1)=4.286729428286856e-2_p
x(2)=2.852055493371227_p
w(2)=5.272702033653088e-2_p
x(3)=4.101104584851718_p
w(3)=2.504596289143265e-2_p
x(4)=5.944323367547610_p
w(4)=5.641236483197773e-3_p
x(5)=8.439870082914091_p
w(5)=6.146783670656636e-4_p
x(6)=11.66089009452324_p
w(6)=3.112030961579890e-5_p
x(7)=15.65818831940902_p
w(7)=6.904089428969129e-7_p
x(8)=20.08750263381204_p
w(8)=7.684371472623472e-9_p
else if(N==9)then
x(1)=2.140218704907060_p
w(1)=3.784299077092278e-2_p
x(2)=2.737221191959307_p
w(2)=5.076651514629370e-2_p
x(3)=3.812990304036908_p
w(3)=2.851655699308485e-2_p
x(4)=5.385964333366218_p
w(4)=8.350203300573046e-3_p
x(5)=7.487108790557800_p
w(5)=1.330836772759071e-3_p
x(6)=10.15006341634484_p
w(6)=1.153870626929175e-4_p
x(7)=13.39259665643098_p
w(7)=5.376918439884451e-6_p
x(8)=17.12818827356485_p
w(8)=1.408858324157559e-7_p
x(9)=20.7286552775258_p
w(9)=2.913427030054164e-9_p
else if(N==10)then
x(1)=2.122573326613312_p
w(1)=3.360660809560129e-2_p
x(2)=2.644217913363838_p
w(2)=4.836034761531901e-2_p
x(3)=3.581539782495931_p
w(3)=3.106783058739026e-2_p
x(4)=4.943628987820521_p
w(4)=1.118228273168590e-2_p
x(5)=6.747143993607136_p
w(5)=2.380885635298255e-3_p
x(6)=9.007943856142367_p
w(6)=3.051512237257498e-4_p
x(7)=11.72993804197209_p
w(7)=2.371284353696729e-5_p
x(8)=14.87223225782226_p
w(8)=1.150740524659222e-6_p
x(9)=18.2355894536955_p
w(9)=3.983632172823448e-8_p
x(10)=21.10911044581263_p
w(10)=1.454621870992932e-9_p
else if(N==11)then
x(1)=2.108056594392595_p
w(1)=3.001329219432324e-2_p
x(2)=2.567826954368511_p
w(2)=4.574754632414108e-2_p
x(3)=3.392482934027705_p
w(3)=3.278410750044866e-2_p
x(4)=4.585796826272983_p
w(4)=1.393219892764259e-2_p
x(5)=6.156402975924171_p
w(5)=3.727463133898806e-3_p
x(6)=8.111380069135238_p
w(6)=6.443593173667867e-4_p
x(7)=10.44873928625848_p
w(7)=7.313150932354385e-5_p
x(8)=13.14214733945081_p
w(8)=5.588128503386950e-6_p
x(9)=16.09942335693794_p
w(9)=3.081174661692585e-7_p
x(10)=19.05429484169177_p
w(10)=1.474968251891211e-8_p
x(11)=21.34640049558655_p
w(11)=8.612289115774410e-10_p
else if(N==12)then
x(1)=2.095972132958329_p
w(1)=2.694613822944290e-2_p
x(2)=2.504299375603700_p
w(2)=4.308233150293748e-2_p
x(3)=3.235860494473594_p
w(3)=3.379121690654413e-2_p
x(4)=4.291388625723128_p
w(4)=1.645473837219075e-2_p
x(5)=5.674831637063729_p
w(5)=5.295505032094909e-3_p
x(6)=7.388660705540144_p
w(6)=1.160568085005255e-3_p
x(7)=9.428438711352662_p
w(7)=1.767274712744120e-4_p
x(8)=11.77460088846851_p
w(8)=1.913563226206272e-5_p
x(9)=14.37389400412204_p
w(9)=1.540511498563275e-6_p
x(10)=17.09767832341647_p
w(10)=1.017235336179272e-7_p
x(11)=19.65808887018663_p
w(11)=6.728178320678364e-9_p
x(12)=21.50210330388593_p
w(12)=5.690632821140740e-10_p
else if(N==13)then
x(1)=2.085806129192917_p
w(1)=2.431161940381537e-2_p
x(2)=2.450890382333140_p
w(2)=4.046072893463708e-2_p
x(3)=3.104532182567740_p
w(3)=3.422283027687482e-2_p
x(4)=4.045751199644937_p
w(4)=1.866331173758045e-2_p
x(5)=5.275698244263985_p
w(5)=6.994489691400450e-3_p
x(6)=6.794332704981787_p
w(6)=1.859363836011213e-3_p
x(7)=8.596337141984726_p
w(7)=3.583567095925618e-4_p
x(8)=10.66616090550117_p
w(8)=5.117329840019485e-5_p
x(9)=12.96857661078903_p
w(9)=5.594972282828786e-6_p
x(10)=15.42966882470836_p
w(10)=4.975936615548199e-7_p
x(11)=17.90134681792363_p
w(11)=4.031533188764321e-8_p
x(12)=20.10697348501698_p
w(12)=3.589442050254627e-9_p
x(13)=21.60897045368844_p
w(13)=4.049952288974004e-10_p
else if(N==14)then
x(1)=2.077173295856555_p
w(1)=2.203493256428968e-2_p
x(2)=2.405552935842517_p
w(2)=3.793982320787908e-2_p
x(3)=2.993254862098728_p
w(3)=3.420330552875752e-2_p
x(4)=3.838370515891206_p
w(4)=2.051887056030854e-2_p
x(5)=4.940374286480669_p
w(5)=8.735867882175074e-3_p
x(6)=6.297832765343491_p
w(6)=2.725690754002750e-3_p
x(7)=7.905274449244678_p
w(7)=6.374033268831848e-4_p
x(8)=9.749904885445341_p
w(8)=1.140401197996043e-4_p
x(9)=11.80633189570324_p
w(9)=1.602520985160010e-5_p
x(10)=14.02682924006645_p
w(10)=1.844040963353015e-6_p
x(11)=16.32436057486967_p
w(11)=1.864993260281462e-7_p
x(12)=18.54627231945581_p
w(12)=1.861412132523027e-8_p
x(13)=20.44523574573899_p
w(13)=2.151865271103649e-9_p
x(14)=21.68517310700093_p
w(14)=3.038026750377571e-10_p
else if(N==15)then
x(1)=2.069780299595003_p
w(1)=2.005605331798961e-2_p
x(2)=2.366734564144637_p
w(2)=3.555110415545412e-2_p
x(3)=2.898098045922692_p
w(3)=3.384044631649204e-2_p
x(4)=3.661503115350889_p
w(4)=2.201656786385062e-2_p
x(5)=4.655434701702948_p
w(5)=1.044362661583511e-2_p
x(6)=5.877694088928506_p
w(6)=3.729289121615204e-3_p
x(7)=7.322986131263627_p
w(7)=1.025132315672441e-3_p
x(8)=8.980572691172462_p
w(8)=2.212102498279291e-4_p
x(9)=10.83109098049436_p
w(9)=3.831128829491668e-5_p
x(10)=12.84113653569852_p
w(10)=5.493797377246209e-6_p
x(11)=14.95431177401636_p
w(11)=6.844786699596440e-7_p
x(12)=17.07768973387969_p
w(12)=7.986347325122988e-8_p
x(13)=19.06475853439365_p
w(13)=9.734762252176061e-9_p
x(14)=20.70418188985126_p
w(14)=1.407792710863724e-9_p
x(15)=21.74128122063758_p
w(15)=2.369182780559371e-10_p
else if(N==16)then
x(1)=2.063400689107897_p
w(1)=1.832657906341048e-2_p
x(2)=2.333240078765763_p
w(2)=3.330951542244394e-2_p
x(3)=2.816062181987583_p
w(3)=3.322373796811930e-2_p
x(4)=3.509320438809393_p
w(4)=2.317375661388552e-2_p
x(5)=4.410940672568255_p
w(5)=1.205890033401665e-2_p
x(6)=5.518324837538588_p
w(6)=4.831380786002276e-3_p
x(7)=6.826493284507758_p
w(7)=1.523321059481698e-3_p
x(8)=8.326314800089218_p
w(8)=3.850731293159100e-4_p
x(9)=10.00244936882249_p
w(9)=7.957075458575080e-5_p
x(10)=11.83013849596326_p
w(10)=1.377639287705216e-5_p
x(11)=13.77012357503936_p
w(11)=2.069855534477771e-6_p
x(12)=15.76117701702044_p
w(12)=2.841810180890430e-7_p
x(13)=17.71038098144678_p
w(13)=3.839988504746753e-8_p
x(14)=19.48373145398609_p
w(14)=5.629071849340879e-9_p
x(15)=20.90562572809683_p
w(15)=9.840565221530064e-10_p
x(16)=21.78372488003194_p
w(16)=1.903211143941011e-10_p
else if(N==17)then
x(1)=2.057857420865731_p
w(1)=1.680725641462659e-2_p
x(2)=2.304136912376121_p
w(2)=3.121950722143354e-2_p
x(3)=2.744822310024462_p
w(3)=3.242532403850066e-2_p
x(4)=3.377353463313467_p
w(4)=2.402058473984295e-2_p
x(5)=4.199369915332867_p
w(5)=1.354048674056238e-2_p
x(6)=5.208094218078745_p
w(6)=5.990702836604508e-3_p
x(7)=6.398908485904146_p
w(7)=2.124881694093192e-3_p
x(8)=7.763971061332256_p
w(8)=6.150119057688946e-4_p
x(9)=9.290797721295203_p
w(9)=1.478036061102658e-4_p
x(10)=10.96025790377404_p
w(10)=3.010257344437786e-5_p
x(11)=12.74352312398958_p
w(11)=5.337872203447910e-6_p
x(12)=14.59768968376723_p
w(12)=8.556679705254797e-7_p
x(13)=16.46006572231409_p
w(13)=1.306622884171915e-7_p
x(14)=18.24193424268644_p
w(14)=2.038164626501374e-8_p
x(15)=19.8246846931905_p
w(15)=3.528601709366837e-9_p
x(16)=21.0647819546902_p
w(16)=7.238327278211888e-10_p
x(17)=21.81657599709444_p
w(17)=1.564952360702198e-10_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;22kT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592772959391618_p
w(1)=4.139312802140183e-2_p
x(2)=6.425524455893250_p
w(2)=7.194223273393419e-3_p
else if(N==3)then
x(1)=3.420340084090410_p
w(1)=3.440533019464462e-2_p
x(2)=5.303534371967468_p
w(2)=1.366865693507218e-2_p
x(3)=9.296805511636231_p
w(3)=5.133641650784558e-4_p
else if(N==4)then
x(1)=3.325272224932844_p
w(1)=2.909185406801144e-2_p
x(2)=4.750409726912704_p
w(2)=1.753334820806089e-2_p
x(3)=7.533298661006949_p
w(3)=1.934771493452714e-3_p
x(4)=12.36908606135733_p
w(4)=2.737752527020520e-5_p
else if(N==5)then
x(1)=3.263550956570842_p
w(1)=2.497683341203290e-2_p
x(2)=4.406065025659209_p
w(2)=1.956501684055036e-2_p
x(3)=6.562638428248846_p
w(3)=3.850776935740193e-3_p
x(4)=9.992607638305715_p
w(4)=1.932716075750296e-4_p
x(5)=15.36634799912664_p
w(5)=1.452498896768855e-6_p
else if(N==6)then
x(1)=3.218805460551034_p
w(1)=2.162830591024798e-2_p
x(2)=4.161558116955510_p
w(2)=2.042849232876087e-2_p
x(3)=5.908301273019755_p
w(3)=5.911059375335507e-3_p
x(4)=8.579196446838823_p
w(4)=6.008358098106864e-4_p
x(5)=12.40571392853675_p
w(5)=1.854143428589651e-5_p
x(6)=17.80890140713324_p
w(6)=1.164363543102865e-7_p
else if(N==7)then
x(1)=3.184541567809380_p
w(1)=1.884071687950128e-2_p
x(2)=3.976621772177895_p
w(2)=2.051162050883434e-2_p
x(3)=5.427571234537274_p
w(3)=7.862842456534330e-3_p
x(4)=7.597887026560003_p
w(4)=1.283116010580341e-3_p
x(5)=10.58798459047504_p
w(5)=8.686551533382118e-5_p
x(6)=14.53823297110634_p
w(6)=2.171585782284567e-6_p
x(7)=19.41785840196025_p
w(7)=1.833822885115984e-8_p
else if(N==8)then
x(1)=3.157677329654101_p
w(1)=1.651204876710518e-2_p
x(2)=3.832783378499570_p
w(2)=2.008279380430140e-2_p
x(3)=5.060481703866325_p
w(3)=9.535564239221254e-3_p
x(4)=6.872323597329775_p
w(4)=2.192965746764798e-3_p
x(5)=9.316402281140906_p
w(5)=2.499273874937010e-4_p
x(6)=12.4485089615954_p
w(6)=1.369455510869447e-5_p
x(7)=16.2771005472069_p
w(7)=3.515922773286914e-7_p
x(8)=20.35612804398684_p
w(8)=5.202522896228284e-9_p
else if(N==9)then
x(1)=3.136258672165805_p
w(1)=1.456141963387832e-2_p
x(2)=3.718717471724799_p
w(2)=1.934112100375726e-2_p
x(3)=4.772889995137055_p
w(3)=1.085617820074193e-2_p
x(4)=6.315238785051314_p
w(4)=3.238805744179831e-3_p
x(5)=8.369647096830011_p
w(5)=5.373914297657368e-4_p
x(6)=10.9593872410414_p
w(6)=4.977358907996153e-5_p
x(7)=14.0832263092029_p
w(7)=2.578924119701891e-6_p
x(8)=17.61640590689538_p
w(8)=8.059162949115879e-8_p
x(9)=20.89527545906016_p
w(9)=2.177643009552334e-9_p
else if(N==10)then
x(1)=3.118919994408601_p
w(1)=1.291918355298403e-2_p
x(2)=3.626718514337687_p
w(2)=1.842601537901499e-2_p
x(3)=4.542843346170487_p
w(3)=1.182212841060138e-2_p
x(4)=5.875522144410938_p
w(4)=4.324610326444271e-3_p
x(5)=7.636383130410911_p
w(5)=9.543501539789919e-4_p
x(6)=9.834378152946732_p
w(6)=1.294813671427393e-4_p
x(7)=12.46306812235524_p
w(7)=1.095236324969065e-5_p
x(8)=15.46394570827585_p
w(8)=6.033835288346669e-7_p
x(9)=18.61326747030517_p
w(9)=2.520106391256348e-8_p
x(10)=21.21748544346833_p
w(10)=1.156786419824815e-9_p
else if(N==11)then
x(1)=3.104690611287549_p
w(1)=1.152804469011927e-2_p
x(2)=3.551410139336999_p
w(2)=1.743035236202499e-2_p
x(3)=4.355610398977107_p
w(3)=1.246818317742158e-2_p
x(4)=5.520901004302052_p
w(4)=5.371858100452789e-3_p
x(5)=7.052350478959147_p
w(5)=1.483509408393330e-3_p
x(6)=8.952111254922892_p
w(6)=2.695846672264568e-4_p
x(7)=11.21181495241572_p
w(7)=3.285742724791018e-5_p
x(8)=13.79563137832537_p
w(8)=2.774762244238342e-6_p
x(9)=16.59825440350084_p
w(9)=1.758690203305484e-7_p
x(10)=19.34533353814329_p
w(10)=1.011788357623894e-8_p
x(11)=21.42055124191213_p
w(11)=7.127607853979026e-10_p
else if(N==12)then
x(1)=3.092870127745726_p
w(1)=1.034198591430796e-2_p
x(2)=3.488963341049107_p
w(2)=1.641386187655790e-2_p
x(3)=4.200983612504051_p
w(3)=1.284401821882862e-2_p
x(4)=5.229922057243444_p
w(4)=6.326436433584234e-3_p
x(5)=6.577224698727602_p
w(5)=2.093714248933908e-3_p
x(6)=8.241703954488599_p
w(6)=4.796210184119443e-4_p
x(7)=10.21462379285756_p
w(7)=7.768348517228522e-5_p
x(8)=12.47071853660326_p
w(8)=9.140172884859307e-6_p
x(9)=14.94922474068467_p
w(9)=8.218793563008466e-7_p
x(10)=17.51445153957503_p
w(10)=6.264914206507665e-8_p
x(11)=19.88387839323125_p
w(11)=4.913860110277058e-9_p
x(12)=21.55517756866612_p
w(12)=4.837550625986738e-10_p
else if(N==13)then
x(1)=3.082944232322742_p
w(1)=9.324297425960965e-3_p
x(2)=3.436592791302429_p
w(2)=1.541364758613469e-2_p
x(3)=4.071684215634712_p
w(3)=1.300152549449714e-2_p
x(4)=4.987733651007532_p
w(4)=7.157194454484609e-3_p
x(5)=6.184167780140361_p
w(5)=2.748967153832511e-3_p
x(6)=7.658168372794989_p
w(6)=7.601474208004897e-4_p
x(7)=9.401323720947504_p
w(7)=1.546911460328478e-4_p
x(8)=11.39437687472918_p
w(8)=2.372342649868513e-5_p
x(9)=13.59748232389807_p
w(9)=2.843487836936849e-6_p
x(10)=15.93195482522452_p
w(10)=2.840916235112166e-7_p
x(11)=18.24857832176855_p
w(11)=2.650635768113011e-8_p
x(12)=20.28433720228062_p
w(12)=2.749913276176682e-9_p
x(13)=21.64843092008076_p
w(13)=3.508219067744670e-10_p
else if(N==14)then
x(1)=3.074528718789002_p
w(1)=8.445680188624743e-3_p
x(2)=3.392232163752291_p
w(2)=1.445172843183476e-2_p
x(3)=3.962391620895539_p
w(3)=1.298850257897316e-2_p
x(4)=4.783713908702210_p
w(4)=7.851100326436756e-3_p
x(5)=5.854517312608326_p
w(5)=3.415092265954136e-3_p
x(6)=7.171239273464439_p
w(6)=1.103739902569662e-3_p
x(7)=8.726072452335726_p
w(7)=2.709330691162471e-4_p
x(8)=10.50365390628284_p
w(8)=5.160466394968689e-5_p
x(9)=12.47557745974541_p
w(9)=7.846263480946712e-6_p
x(10)=14.59093299988791_p
w(10)=9.954448001731760e-7_p
x(11)=16.76080493818345_p
w(11)=1.132551174571509e-7_p
x(12)=18.83606720729708_p
w(12)=1.292728023430293e-8_p
x(13)=20.58663599224773_p
w(13)=1.709851520414225e-9_p
x(14)=21.71545361663316_p
w(14)=2.668057613713450e-10_p
else if(N==15)then
x(1)=3.067332001426224_p
w(1)=7.682664837682018e-3_p
x(2)=3.354321386200568_p
w(2)=1.354023699899368e-2_p
x(3)=3.869133318676638_p
w(3)=1.284610193936788e-2_p
x(4)=4.610061667547620_p
w(4)=8.407841330398054e-3_p
x(5)=5.574848133587682_p
w(5)=4.063504149158066e-3_p
x(6)=6.759659344495116_p
w(6)=1.497452681932947e-3_p
x(7)=8.157378515676424_p
w(7)=4.299580141253165e-4_p
x(8)=9.755390844235452_p
w(8)=9.809707375036780e-5_p
x(9)=11.53226598280322_p
w(9)=1.820414708930691e-5_p
x(10)=13.45242731504951_p
w(10)=2.839374103369700e-6_p
x(11)=15.45785596987271_p
w(11)=3.910871664504529e-7_p
x(12)=17.45629255109758_p
w(12)=5.122663718770953e-8_p
x(13)=19.30776750408514_p
w(13)=7.073661213549066e-9_p
x(14)=20.81863464616526_p
w(14)=1.150492782785759e-9_p
x(15)=21.76513637570013_p
w(15)=2.102366151747311e-10_p
else if(N==16)then
x(1)=3.061129591613011_p
w(1)=7.016355095691261e-3_p
x(2)=3.321664092930139_p
w(2)=1.268492904315327e-2_p
x(3)=3.788888733504650_p
w(3)=1.260831324129399e-2_p
x(4)=4.460919621818393_p
w(4)=8.835150086563067e-3_p
x(5)=5.335237181979415_p
w(5)=4.672634926070676e-3_p
x(6)=6.407993378221141_p
w(6)=1.925566467613922e-3_p
x(7)=7.672758409689451_p
w(7)=6.314810109292736e-4_p
x(8)=9.118969050094151_p
w(8)=1.678374950925648e-4_p
x(9)=10.72980373534844_p
w(9)=3.688030110654174e-5_p
x(10)=12.47898061244402_p
w(10)=6.874531963184355e-6_p
x(11)=14.32598860100852_p
w(11)=1.126947879605293e-6_p
x(12)=16.20944516638198_p
w(12)=1.710757682090068e-7_p
x(13)=18.03903823463955_p
w(13)=2.583414691540595e-8_p
x(14)=19.68883981974108_p
w(14)=4.245264007117528e-9_p
x(15)=20.99962537376953_p
w(15)=8.220043027344621e-10_p
x(16)=21.80293666026949_p
w(16)=1.702544658691453e-10_p
else if(N==17)then
x(1)=3.055746399572703_p
w(1)=6.431447583869820e-3_p
x(2)=3.293329984890262_p
w(2)=1.188752345361647e-2_p
x(3)=3.719324410093606_p
w(3)=1.230243634640569e-2_p
x(4)=4.331807135887643_p
w(4)=9.145241430384541e-3_p
x(5)=5.128184974701896_p
w(5)=5.227843651910738e-3_p
x(6)=6.104732600201630_p
w(6)=2.371922495508765e-3_p
x(7)=7.255664337571845_p
w(7)=8.718222490315538e-4_p
x(8)=8.572007730135102_p
w(8)=2.640669704229675e-4_p
x(9)=10.0401743184665_p
w(9)=6.707332388711189e-5_p
x(10)=11.6399350272227_p
w(10)=1.459004340812607e-5_p
x(11)=13.34151915970044_p
w(11)=2.794207527205111e-6_p
x(12)=15.10166456319127_p
w(12)=4.892929395990344e-7_p
x(13)=16.85874388677526_p
w(13)=8.245824523419803e-8_p
x(14)=18.527920074834_p
w(14)=1.428785777164453e-8_p
x(15)=19.99908978556849_p
w(15)=2.743698851935528e-9_p
x(16)=21.14303349633148_p
w(16)=6.151842237667845e-10_p
x(17)=21.8323390275336_p
w(17)=1.408965882531726e-10_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;22kT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.588381198631354_p
w(1)=1.548087399943682e-2_p
x(2)=7.418360851041498_p
w(2)=2.669053639426111e-3_p
else if(N==3)then
x(1)=4.417350753702066_p
w(1)=1.288374065117256e-2_p
x(2)=6.296947690123245_p
w(2)=5.076031017360557e-3_p
x(3)=10.28971615421857_p
w(3)=1.901559703298184e-4_p
else if(N==4)then
x(1)=4.322720149093406_p
w(1)=1.089750715217230e-2_p
x(2)=5.742566607047504_p
w(2)=6.522304599999618e-3_p
x(3)=8.520262483765187_p
w(3)=7.197962106985953e-4_p
x(4)=13.33949215460454_p
w(4)=1.031967599242146e-5_p
else if(N==5)then
x(1)=4.260741558310627_p
w(1)=9.341660944633077e-3_p
x(2)=5.394715919710734_p
w(2)=7.290195034335673e-3_p
x(3)=7.538332973370638_p
w(3)=1.443306337315977e-3_p
x(4)=10.93987374428221_p
w(4)=7.416424433317586e-5_p
x(5)=16.21882499468661_p
w(5)=6.010782450296226e-7_p
else if(N==6)then
x(1)=4.215632242207352_p
w(1)=8.067301541406805e-3_p
x(2)=5.147016656037429_p
w(2)=7.614839126942540e-3_p
x(3)=6.874716223530267_p
w(3)=2.226842577414751e-3_p
x(4)=9.510162827067944_p
w(4)=2.331991995009511e-4_p
x(5)=13.2598438851663_p
w(5)=7.686978482730498e-6_p
x(6)=18.42533908017067_p
w(6)=5.821511515263959e-8_p
else if(N==7)then
x(1)=4.181227179741427_p
w(1)=7.008550105457639e-3_p
x(2)=4.960599587362008_p
w(2)=7.639624334476585e-3_p
x(3)=6.389756680054036_p
w(3)=2.965676234147512e-3_p
x(4)=8.523122885806895_p
w(4)=4.992147198363882e-4_p
x(5)=11.44655676449442_p
w(5)=3.584466454735319e-5_p
x(6)=15.26193567574801_p
w(6)=1.006450166096078e-6_p
x(7)=19.80336093260991_p
w(7)=1.113023135804446e-8_p
else if(N==8)then
x(1)=4.154396882983080_p
w(1)=6.127724574859443e-3_p
x(2)=4.816494451640304_p
w(2)=7.469553021253615e-3_p
x(3)=6.021718374672862_p
w(3)=3.592811328955092e-3_p
x(4)=7.797592678671920_p
w(4)=8.512900705327819e-4_p
x(5)=10.18301667965092_p
w(5)=1.022397728426672e-4_p
x(6)=13.21552988525211_p
w(6)=6.121066001473459e-6_p
x(7)=16.86055264373347_p
w(7)=1.841780356097228e-7_p
x(8)=20.58931798896142_p
w(8)=3.626382248661029e-9_p
else if(N==9)then
x(1)=4.133099574035677_p
w(1)=5.392561418073922e-3_p
x(2)=4.702783347638937_p
w(2)=7.182255312180302e-3_p
x(3)=5.734798191156852_p
w(3)=4.082177458384725e-3_p
x(4)=7.242990411229639_p
w(4)=1.252193415674364e-3_p
x(5)=9.245126934901673_p
w(5)=2.177355943790380e-4_p
x(6)=11.75414888107789_p
w(6)=2.169479294254400e-5_p
x(7)=14.74955553841695_p
w(7)=1.260649987736432e-6_p
x(8)=18.07158791815332_p
w(8)=4.734090125263728e-8_p
x(9)=21.04100047161878_p
w(9)=1.656339047105785e-9_p
else if(N==10)then
x(1)=4.115920926170711_p
w(1)=4.775531966481149e-3_p
x(2)=4.611437988175528_p
w(2)=6.831304044025334e-3_p
x(3)=5.506195838400945_p
w(3)=4.434937286898370e-3_p
x(4)=6.806750011578304_p
w(4)=1.664291327294078e-3_p
x(5)=8.520526725538105_p
w(5)=3.830649038303280e-4_p
x(6)=10.64998140392014_p
w(6)=5.533082433327784e-5_p
x(7)=13.1783092303185_p
w(7)=5.127268560473841e-6_p
x(8)=16.03035431075961_p
w(8)=3.227875550433844e-7_p
x(9)=18.96328655121165_p
w(9)=1.630058046004728e-8_p
x(10)=21.31339364378865_p
w(10)=9.293044164796102e-10_p
else if(N==11)then
x(1)=4.101865588453475_p
w(1)=4.254257356582797e-3_p
x(2)=4.536916130690496_p
w(2)=6.451942232722324e-3_p
x(3)=5.320758346682393_p
w(3)=4.666006997986519e-3_p
x(4)=6.455955324872424_p
w(4)=2.057732688966119e-3_p
x(5)=7.944633110951445_p
w(5)=5.902536571445003e-4_p
x(6)=9.784570453775178_p
w(6)=1.133177060691549e-4_p
x(7)=11.96114992885106_p
w(7)=1.490816353639418e-5_p
x(8)=14.42945740276763_p
w(8)=1.398855794384362e-6_p
x(9)=17.07297013202013_p
w(9)=1.023251295170888e-7_p
x(10)=19.61457976060256_p
w(10)=7.061642481089788e-9_p
x(11)=21.48695402565835_p
w(11)=5.932887393076483e-10_p
else if(N==12)then
x(1)=4.090220295653204_p
w(1)=3.810897875483599e-3_p
x(2)=4.475300118489676_p
w(2)=6.066557870838850e-3_p
x(3)=5.168055930421813_p
w(3)=4.795404013968442e-3_p
x(4)=6.168844983237257_p
w(4)=2.412651349918689e-3_p
x(5)=7.477030982532493_p
w(5)=8.263408866643739e-4_p
x(6)=9.088344761296009_p
w(6)=1.987769907541506e-4_p
x(7)=10.98997611779174_p
w(7)=3.439315638163421e-5_p
x(8)=13.15119587908604_p
w(8)=4.416840691764641e-6_p
x(9)=15.50457321561462_p
w(9)=4.453577467887328e-7_p
x(10)=17.90960016587857_p
w(10)=3.924855864068536e-8_p
x(11)=20.09297269463123_p
w(11)=3.635352849925999e-9_p
x(12)=21.60321205085894_p
w(12)=4.125031487243252e-10_p
else if(N==13)then
x(1)=4.080464002843687_p
w(1)=3.431298681225180e-3_p
x(2)=4.423756459171570_p
w(2)=5.688867298429823e-3_p
x(3)=5.040689043939516_p
w(3)=4.843492747133626e-3_p
x(4)=5.930414112926571_p
w(4)=2.718201787701717e-3_p
x(5)=7.090877879068968_p
w(5)=1.077014276812166e-3_p
x(6)=8.517024252556151_p
w(6)=3.111857835699118e-4_p
x(7)=10.19762964322337_p
w(7)=6.712209347060682e-5_p
x(8)=12.10991022067867_p
w(8)=1.109689324567763e-5_p
x(9)=14.2098395801588_p
w(9)=1.463324930213225e-6_p
x(10)=16.41503369439427_p
w(10)=1.646397006383647e-7_p
x(11)=18.57716767365512_p
w(11)=1.768179787993226e-8_p
x(12)=20.4490102411727_p
w(12)=2.126526939689021e-9_p
x(13)=21.68447151761387_p
w(13)=3.043185526022520e-10_p
else if(N==14)then
x(1)=4.072209140566956_p
w(1)=3.104212257474181e-3_p
x(2)=4.380193087298041_p
w(2)=5.326867872112112e-3_p
x(3)=4.933271706432096_p
w(3)=4.828714384875931e-3_p
x(4)=5.729966014768898_p
w(4)=2.970432288209299e-3_p
x(5)=6.767541604716668_p
w(5)=1.329132535338944e-3_p
x(6)=8.040778412776715_p
w(6)=4.469737213347048e-4_p
x(7)=9.539844666528138_p
w(7)=1.155761151200108e-4_p
x(8)=11.24697448613798_p
w(8)=2.351333478961359e-5_p
x(9)=13.13100667765714_p
w(9)=3.880523589075717e-6_p
x(10)=15.13842324616219_p
w(10)=5.441939997073054e-7_p
x(11)=17.17950638611648_p
w(11)=6.972461449142072e-8_p
x(12)=19.11016508200644_p
w(12)=9.085358322742290e-9_p
x(13)=20.7183553783244_p
w(13)=1.367664500683417e-9_p
x(14)=21.74332588704991_p
w(14)=2.343820373597405e-10_p
else if(N==15)then
x(1)=4.065162654157230_p
w(1)=2.820663332976179e-3_p
x(2)=4.343036964025263_p
w(2)=4.984848526306197e-3_p
x(3)=4.841797438115263_p
w(3)=4.766742080955838e-3_p
x(4)=5.559666572766490_p
w(4)=3.170080846979738e-3_p
x(5)=6.493640522912045_p
w(5)=1.572037781900279e-3_p
x(6)=7.638643013067528_p
w(6)=6.006148648164281e-4_p
x(7)=8.986053495713827_p
w(7)=1.807408494701331e-4_p
x(8)=10.52154865013414_p
w(8)=4.373048398162531e-5_p
x(9)=12.22180552786668_p
w(9)=8.720042908078882e-6_p
x(10)=14.04941440392668_p
w(10)=1.483057781249538e-6_p
x(11)=15.94535153846048_p
w(11)=2.261918479634949e-7_p
x(12)=17.81894924376763_p
w(12)=3.325865868968987e-8_p
x(13)=19.53772272038914_p
w(13)=5.189277585363658e-9_p
x(14)=20.92563314155795_p
w(14)=9.445289892082245e-10_p
x(15)=21.78724078720317_p
w(15)=1.864739575421784e-10_p
else if(N==16)then
x(1)=4.059099653772606_p
w(1)=2.573449812242770e-3_p
x(2)=4.311086112660433_p
w(2)=4.664732712726482e-3_p
x(3)=4.763229871900205_p
w(3)=4.670382439729608e-3_p
x(4)=5.413648478754559_p
w(4)=3.320743882368563e-3_p
x(5)=6.259298761498851_p
w(5)=1.797953493325210e-3_p
x(6)=7.295394073251014_p
w(6)=7.657459856350716e-4_p
x(7)=8.514361961362882_p
w(7)=2.620703889437072e-4_p
x(8)=9.904382047587989_p
w(8)=7.343826964258307e-5_p
x(9)=11.44728638858726_p
w(9)=1.720412327398622e-5_p
x(10)=13.11548534547672_p
w(10)=3.460649701373622e-6_p
x(11)=14.86759180201769_p
w(11)=6.200916326878374e-7_p
x(12)=16.64264138598034_p
w(12)=1.041602826835037e-7_p
x(13)=18.35362347830544_p
w(13)=1.756273688667418e-8_p
x(14)=19.88314650238247_p
w(14)=3.225746135632707e-9_p
x(15)=21.08781613187221_p
w(15)=6.887216829501293e-10_p
x(16)=21.82084048245066_p
w(16)=1.521535001151211e-10_p
else if(N==17)then
x(1)=4.053845241081221_p
w(1)=2.356756545969359e-3_p
x(2)=4.283408850163328_p
w(2)=4.366965022050874e-3_p
x(3)=4.695230331869158_p
w(3)=4.549824475351261e-3_p
x(4)=5.287433722114078_p
w(4)=3.427523443239903e-3_p
x(5)=6.057063226576039_p
w(5)=2.001826385957010e-3_p
x(6)=6.999682496615995_p
w(6)=9.360590768369583e-4_p
x(7)=8.108623584621689_p
w(7)=3.577398038965097e-4_p
x(8)=9.373963188733342_p
w(8)=1.136929047564861e-4_p
x(9)=10.78112609272259_p
w(9)=3.059302972131980e-5_p
x(10)=12.30893258597034_p
w(10)=7.122840632729245e-6_p
x(11)=13.92691268392249_p
w(11)=1.475976742299798e-6_p
x(12)=15.59181445951647_p
w(12)=2.826585209558056e-7_p
x(13)=17.24355264851184_p
w(13)=5.257419621959425e-8_p
x(14)=18.80162912081792_p
w(14)=1.010471132647067e-8_p
x(15)=20.16455808140384_p
w(15)=2.145781270572417e-9_p
x(16)=21.2166999276722_p
w(16)=5.238186916727351e-10_p
x(17)=21.84710172933276_p
w(17)=1.266797569248951e-10_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;22kT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.586726502145379_p
w(1)=5.730312816011562e-3_p
x(2)=8.415612760405100_p
w(2)=9.850353941596973e-4_p
else if(N==3)then
x(1)=5.416112498139349_p
w(1)=4.770444443937282e-3_p
x(2)=7.293756273159907_p
w(2)=1.874626005654029e-3_p
x(3)=11.28433714642996_p
w(3)=7.027776057994807e-5_p
else if(N==4)then
x(1)=5.321220569289602_p
w(1)=4.031434306231668e-3_p
x(2)=6.736439582177582_p
w(2)=2.412194830053426e-3_p
x(3)=9.505377453312981_p
w(3)=2.677910610266375e-4_p
x(4)=14.29626340525528_p
w(4)=3.928012859527465e-6_p
else if(N==5)then
x(1)=5.258504254549301_p
w(1)=3.446003474804017e-3_p
x(2)=6.383721827543496_p
w(2)=2.698806712757758e-3_p
x(3)=8.509808886958204_p
w(3)=5.415047335186155e-4_p
x(4)=11.87184393255391_p
w(4)=2.877469808780219e-5_p
x(5)=17.01967489716412_p
w(5)=2.585910030666257e-7_p
else if(N==6)then
x(1)=5.212812388163382_p
w(1)=2.965013414815026e-3_p
x(2)=6.132483314556870_p
w(2)=2.816936204416113e-3_p
x(3)=7.837244352715921_p
w(3)=8.388484272789386e-4_p
x(4)=10.42889588489815_p
w(4)=9.125957680707284e-5_p
x(5)=14.08479358776851_p
w(5)=3.259898183766324e-6_p
x(6)=18.97306808892291_p
w(6)=3.068867034216920e-8_p
else if(N==7)then
x(1)=5.178162486245242_p
w(1)=2.567160307632386e-3_p
x(2)=5.944588339389964_p
w(2)=2.820617224700594e-3_p
x(3)=7.349005141809578_p
w(3)=1.116815795279671e-3_p
x(4)=9.439303402090630_p
w(4)=1.952597817332677e-4_p
x(5)=12.28577567692624_p
w(5)=1.500771662881018e-5_p
x(6)=15.94872653123264_p
w(6)=4.803401316707504e-7_p
x(7)=20.1368165001082_p
w(7)=7.044064859232659e-9_p
else if(N==8)then
x(1)=5.151299712711796_p
w(1)=2.237891397707484e-3_p
x(2)=5.800237366805721_p
w(2)=2.751132863393090e-3_p
x(3)=6.980761589753750_p
w(3)=1.349697283814806e-3_p
x(4)=8.716007772034541_p
w(4)=3.314939438252770e-4_p
x(5)=11.03557861286705_p
w(5)=4.224159939231340e-5_p
x(6)=13.95791295890113_p
w(6)=2.789070083202121e-6_p
x(7)=17.40620952529004_p
w(7)=9.945652784313181e-8_p
x(8)=20.79082964517702_p
w(8)=2.595427243096598e-9_p
else if(N==9)then
x(1)=5.130077278238672_p
w(1)=1.964297711638390e-3_p
x(2)=5.686890028485802_p
w(2)=2.638601456846191e-3_p
x(3)=6.695047891958304_p
w(3)=1.528556899920731e-3_p
x(4)=8.165426826639214_p
w(4)=4.848105563486542e-4_p
x(5)=10.1098466627769_p
w(5)=8.883583011622475e-5_p
x(6)=12.53075354444718_p
w(6)=9.586171231107584e-6_p
x(7)=15.38862020419389_p
w(7)=6.297311687132114e-7_p
x(8)=18.49319289712137_p
w(8)=2.857333694293073e-8_p
x(9)=21.16821477692768_p
w(9)=1.279564304276330e-9_p
else if(N==10)then
x(1)=5.113025652305917_p
w(1)=1.735548327103412e-3_p
x(2)=5.596201088034906_p
w(2)=2.503435118128418e-3_p
x(3)=6.468281775770147_p
w(3)=1.654864190090051e-3_p
x(4)=7.733791320499391_p
w(4)=6.404915967796140e-4_p
x(5)=9.396176004326932_p
w(5)=1.544982620304783e-4_p
x(6)=11.45148972244861_p
w(6)=2.388345461454856e-5_p
x(7)=13.87273516858059_p
w(7)=2.439260431683095e-6_p
x(8)=16.56958985548247_p
w(8)=1.764704215130273e-7_p
x(9)=19.28603895280028_p
w(9)=1.077731392479871e-8_p
x(10)=21.39818970143288_p
w(10)=7.532576171132932e-10_p
else if(N==11)then
x(1)=5.099120557106161_p
w(1)=1.542950004335999e-3_p
x(2)=5.522465489011473_p
w(2)=2.358842184861276e-3_p
x(3)=6.284930936066206_p
w(3)=1.735077570732573e-3_p
x(4)=7.387675966258309_p
w(4)=7.872695580925235e-4_p
x(5)=8.830079909298185_p
w(5)=2.355861492682858e-4_p
x(6)=10.60574211119871_p
w(6)=4.799111938375072e-5_p
x(7)=12.69396357052889_p
w(7)=6.847980237507557e-6_p
x(8)=15.04141212313091_p
w(8)=7.173959794823982e-7_p
x(9)=17.52258101591683_p
w(9)=6.073944097571763e-8_p
x(10)=19.8627166462068_p
w(10)=5.011528516251391e-9_p
x(11)=21.54637538935133_p
w(11)=4.963103696849540e-10_p
else if(N==12)then
x(1)=5.087632991427998_p
w(1)=1.379631171440329e-3_p
x(2)=5.461678310661412_p
w(2)=2.213069744565899e-3_p
x(3)=6.134371183833475_p
w(3)=1.777314977471060e-3_p
x(4)=7.105090384598128_p
w(4)=9.179617931841767e-4_p
x(5)=8.371262470555077_p
w(5)=3.267170896498708e-4_p
x(6)=9.925758973494924_p
w(6)=8.284295542938467e-5_p
x(7)=11.75186605275028_p
w(7)=1.537328741562853e-5_p
x(8)=13.81376141237804_p
w(8)=2.163650878974815e-6_p
x(9)=16.03838014544444_p
w(9)=2.454450211959336e-7_p
x(10)=18.28271857041708_p
w(10)=2.501982917412569e-8_p
x(11)=20.2860363654633_p
w(11)=2.722638747166371e-9_p
x(12)=21.64665280088645_p
w(12)=3.526468185641343e-10_p
else if(N==13)then
x(1)=5.078033274619458_p
w(1)=1.240175132212283e-3_p
x(2)=5.410958694557803_p
w(2)=2.071068864877186e-3_p
x(3)=6.009101706972945_p
w(3)=1.789589852164982e-3_p
x(4)=6.870928129563556_p
w(4)=1.028919617891966e-3_p
x(5)=7.992996476344359_p
w(5)=4.222211634848339e-4_p
x(6)=9.368228534875206_p
w(6)=1.279082010361966e-4_p
x(7)=10.98276045329135_p
w(7)=2.934306156246197e-5_p
x(8)=12.81052419888711_p
w(8)=5.247770924147165e-6_p
x(9)=14.80386831759376_p
w(9)=7.637222237632493e-7_p
x(10)=16.87787622032102_p
w(10)=9.693335476137215e-8_p
x(11)=18.88704099344094_p
w(11)=1.196725357529937e-8_p
x(12)=20.60153807785637_p
w(12)=1.658939163756518e-9_p
x(13)=21.71736118812976_p
w(13)=2.642459389899532e-10_p
else if(N==14)then
x(1)=5.069929198630827_p
w(1)=1.120301316038408e-3_p
x(2)=5.368189334715541_p
w(2)=1.935648228120214e-3_p
x(3)=5.903685115482609_p
w(3)=1.779013767546832e-3_p
x(4)=6.674453547383560_p
w(4)=1.119099628654664e-3_p
x(5)=7.676754741680337_p
w(5)=5.170795486039930e-4_p
x(6)=8.903903979418100_p
w(6)=1.815125297700615e-4_p
x(7)=10.34421315748768_p
w(7)=4.958993534832373e-5_p
x(8)=11.97769448492772_p
w(8)=1.080862209269268e-5_p
x(9)=13.77076709946059_p
w(9)=1.941702065575621e-6_p
x(10)=15.66795525158088_p
w(10)=3.016266487064522e-7_p
x(11)=17.57982526627154_p
w(11)=4.353818402013102e-8_p
x(12)=19.36865291594296_p
w(12)=6.460520141621214e-9_p
x(13)=20.84081107546836_p
w(13)=1.100682936647952e-9_p
x(14)=21.76895780950174_p
w(14)=2.058946912838093e-10_p
else if(N==15)then
x(1)=5.063025369734886_p
w(1)=1.016610186707158e-3_p
x(2)=5.331784533675715_p
w(2)=1.808247669705105e-3_p
x(3)=5.814091078233792_p
w(3)=1.751535730517282e-3_p
x(4)=6.507825396022577_p
w(4)=1.189165835002943e-3_p
x(5)=7.409249073311914_p
w(5)=6.073634934819974e-4_p
x(6)=8.512206380417773_p
w(6)=2.413142750050505e-4_p
x(7)=9.806732939600481_p
w(7)=7.631655100659568e-5_p
x(8)=11.27694539843439_p
w(8)=1.963380113625302e-5_p
x(9)=12.89785064183656_p
w(9)=4.217653154066628e-6_p
x(10)=14.630600736204_p
w(10)=7.838383233781467e-7_p
x(11)=16.4158124394679_p
w(11)=1.325288160124388e-7_p
x(12)=18.16528527293289_p
w(12)=2.186100824778220e-8_p
x(13)=19.75477248060536_p
w(13)=3.842369056565201e-9_p
x(14)=21.02548668031603_p
w(14)=7.786610096624837e-10_p
x(15)=21.80770260008824_p
w(15)=1.652771035766285e-10_p
else if(N==16)then
x(1)=5.057095892355019_p
w(1)=9.263853152762690e-4_p
x(2)=5.300536886161714_p
w(2)=1.689447732947403e-3_p
x(3)=5.737274806653467_p
w(3)=1.711951125198786e-3_p
x(4)=6.365185404505926_p
w(4)=1.240774562529368e-3_p
x(5)=7.180685780380935_p
w(5)=6.903211739998329e-4_p
x(6)=8.178183638742894_p
w(6)=3.047530620066235e-4_p
x(7)=9.349111943191501_p
w(7)=1.091229920114052e-4_p
x(8)=10.68052257086446_p
w(8)=3.231771218986419e-5_p
x(9)=12.15306150143587_p
w(9)=8.090202652745236e-6_p
x(10)=13.73808872913486_p
w(10)=1.759754592360331e-6_p
x(11)=15.39374753900136_p
w(11)=3.451541123243436e-7_p
x(12)=17.06005859956302_p
w(12)=6.417396809773683e-8_p
x(13)=18.65393176748271_p
w(13)=1.206548496521805e-8_p
x(14)=20.06680978574771_p
w(14)=2.468803071296996e-9_p
x(15)=21.17042449802167_p
w(15)=5.785880254244080e-10_p
x(16)=21.83750793499699_p
w(16)=1.358101190686420e-10_p
else if(N==17)then
x(1)=5.051965632345556_p
w(1)=8.474416415184813e-4_p
x(2)=5.273513425840404_p
w(2)=1.579301682378843e-3_p
x(3)=5.670897805783723_p
w(3)=1.664028482460088e-3_p
x(4)=6.242072454035250_p
w(4)=1.276064162260270e-3_p
x(5)=6.983683614432913_p
w(5)=7.642654947283202e-4_p
x(6)=7.890688198548663_p
w(6)=3.693848357217092e-4_p
x(7)=8.955669754199125_p
w(7)=1.471383630027085e-4_p
x(8)=10.16787065336198_p
w(8)=4.917323247464828e-5_p
x(9)=11.51185313904845_p
w(9)=1.404701343948632e-5_p
x(10)=12.96566520386085_p
w(10)=3.507317608599228e-6_p
x(11)=14.49840734333123_p
w(11)=7.875720399858805e-7_p
x(12)=16.06721444437522_p
w(12)=1.650789507419638e-7_p
x(13)=17.61399244616421_p
w(13)=3.387662341973323e-8_p
x(14)=19.06295926567681_p
w(14)=7.209127844488663e-9_p
x(15)=20.32123466900012_p
w(15)=1.687411570509127e-9_p
x(16)=21.28594656969535_p
w(16)=4.467085122127448e-10_p
x(17)=21.86091261323735_p
w(17)=1.137160297951744e-10_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_22
