/*
 * Copyright 2022 Google LLC
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifndef skgpu_graphite_VulkanSharedContext_DEFINED
#define skgpu_graphite_VulkanSharedContext_DEFINED

#include "src/gpu/graphite/SharedContext.h"

#include "include/gpu/vk/VulkanTypes.h"

namespace skgpu {
struct VulkanBackendContext;
struct VulkanInterface;
class VulkanMemoryAllocator;
}

namespace skgpu::graphite {

struct ContextOptions;
class VulkanCaps;

class VulkanSharedContext final : public SharedContext {
public:
    static sk_sp<SharedContext> Make(const VulkanBackendContext&, const ContextOptions&);
    ~VulkanSharedContext() override;

    const skgpu::VulkanInterface* interface() const { return fInterface.get(); }

    skgpu::VulkanMemoryAllocator* memoryAllocator() const { return fMemoryAllocator.get(); }

    VkDevice device() const { return fDevice; }
    uint32_t  queueIndex() const { return fQueueIndex; }

    std::unique_ptr<ResourceProvider> makeResourceProvider(SingleOwner*) override;

private:
    VulkanSharedContext(const VulkanBackendContext&,
                        sk_sp<const skgpu::VulkanInterface> interface,
                        sk_sp<skgpu::VulkanMemoryAllocator> memoryAllocator,
                        std::unique_ptr<const VulkanCaps> caps);

    sk_sp<const skgpu::VulkanInterface> fInterface;
    sk_sp<skgpu::VulkanMemoryAllocator> fMemoryAllocator;

    VkDevice fDevice;
    uint32_t fQueueIndex;

};

} // namespace skgpu::graphite

#endif // skgpu_graphite_VulkanSharedContext_DEFINED

