/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
/*****************************************************************************************
 ******************** This file was generated by sksllex. Do not edit. *******************
 *****************************************************************************************/
#include "src/sksl/SkSLLexer.h"

namespace SkSL {

using State = uint16_t;
static constexpr uint8_t kInvalidChar = 18;
static constexpr int8_t kMappings[118] = {
        1,  2,  3,  3,  1,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
        3,  3,  3,  1,  4,  3,  5,  6,  7,  8,  3,  9,  10, 11, 12, 13, 14, 15, 16, 17,
        18, 19, 20, 21, 22, 22, 22, 23, 23, 24, 25, 26, 27, 28, 29, 30, 31, 31, 32, 33,
        34, 31, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 36, 37, 35, 38, 35, 35, 39,
        35, 35, 40, 3,  41, 42, 43, 3,  44, 45, 46, 47, 48, 49, 50, 51, 52, 35, 53, 54,
        55, 56, 57, 58, 35, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
using IndexEntry = int16_t;
struct FullEntry {
    State data[72];
};
struct CompactEntry {
    uint32_t values;
    uint8_t data[18];
};
static constexpr FullEntry kFull[] = {
        {
                0,   2,   3,   4,   5,   7,   9,   23,  25,  28,  29,  30,  32,  35,  36,
                39,  44,  50,  69,  69,  69,  69,  69,  69,  71,  72,  73,  77,  79,  83,
                84,  93,  93,  93,  93,  93,  93,  93,  93,  93,  94,  95,  96,  93,  99,
                109, 119, 135, 155, 167, 183, 188, 196, 93,  220, 230, 237, 263, 268, 284,
                296, 350, 376, 392, 404, 93,  93,  93,  417, 418, 421, 422,
        },
        {
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  51, 0, 59, 59, 59, 59, 59, 59, 60,
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 66, 67, 0, 0,  0,  0,  0,  0,  0,  0,
                61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 66, 0,  0, 67, 0,  0,  0,  0,  0,  0,
        },
        {
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  51, 0, 59, 59, 59, 59, 59, 59, 60,
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 65, 0,  0, 0,  0,  0,  0,  0,  0,  0,
                61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 65, 0,  0, 0,  0,  0,  0,  0,  0,  0,
        },
        {
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  51, 0, 60, 60, 60, 60, 60, 60, 60,
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 64, 0,  0, 0,  0,  0,  0,  0,  0,  0,
                61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 64, 0,  0, 0,  0,  0,  0,  0,  0,  0,
        },
        {
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0,  51, 0, 70, 70, 70, 70, 70, 70, 70,
                0,  0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 66, 0,  0, 0,  0,  0,  0,  0,  0,  0,
                61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 66, 0,  0, 0,  0,  0,  0,  0,  0,  0,
        },
        {
                0,   0,  0,  0,   0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  10,
                10,  10, 10, 10,  10, 10, 0,  0,  0,   0,  0,  0,  0,  10, 10, 10, 10, 10,
                10,  10, 10, 10,  0,  0,  0,  10, 120, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                123, 10, 10, 126, 10, 10, 10, 10, 10,  10, 10, 10, 10, 10, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,   0,  0,  0,  0,  0,  0,   0,  0,  0,   0,  0,  0,  0,   10,
                10, 10, 10, 10,  10, 10, 0,  0,  0,  0,   0,  0,  0,   10, 10, 10, 10,  10,
                10, 10, 10, 10,  0,  0,  0,  10, 10, 10,  10, 10, 136, 10, 10, 10, 142, 10,
                10, 10, 10, 148, 10, 10, 10, 10, 10, 152, 10, 10, 10,  10, 0,  0,  0,   0,
        },
        {
                0,   0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  10,
                10,  10, 10,  10, 10, 10, 0,  0,  0,  0,  0,  0,   0,  10, 10, 10, 10, 10,
                10,  10, 10,  10, 0,  0,  0,  10, 10, 10, 10, 10,  10, 10, 10, 10, 10, 10,
                156, 10, 159, 10, 10, 10, 10, 10, 10, 10, 10, 161, 10, 10, 0,  0,  0,  0,
        },
        {
                0,   0,  0,  0,   0,  0,  0,  0,  0,   0,   0,  0,  0,  0,  0,  0,  0,   10,
                10,  10, 10, 10,  10, 10, 0,  0,  0,   0,   0,  0,  0,  10, 10, 10, 10,  10,
                10,  10, 10, 10,  0,  0,  0,  10, 168, 10,  10, 10, 10, 10, 10, 10, 172, 10,
                175, 10, 10, 178, 10, 10, 10, 10, 10,  180, 10, 10, 10, 10, 0,  0,  0,   0,
        },
        {
                0,   0,  0,  0,   0,   0,  0,  0,   0,  0,   0,  0,  0,  0,  0,  0,  0,  10,
                10,  10, 10, 10,  10,  10, 0,  0,   0,  0,   0,  0,  0,  10, 10, 10, 10, 10,
                10,  10, 10, 10,  0,   0,  0,  10,  10, 10,  10, 10, 10, 10, 10, 10, 10, 10,
                199, 10, 10, 203, 206, 10, 10, 208, 10, 214, 10, 10, 10, 10, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,   0,  0,  0,   0,  0,  0,  0,  0,  0,  0,  0,  10,
                10, 10, 10, 10, 10, 10,  0,  0,  0,   0,  0,  0,  0,  10, 10, 10, 10, 10,
                10, 10, 10, 10, 0,  0,   0,  10, 269, 10, 10, 10, 10, 10, 10, 10, 10, 10,
                10, 10, 10, 10, 10, 273, 10, 10, 280, 10, 10, 10, 10, 10, 0,  0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,  0,  0,   0,   0,  0,   0,  0,  0,  0,  0,  0,   10,
                10, 10, 10, 10, 10, 10, 0,  0,   0,   0,  0,   0,  0,  10, 10, 10, 10,  10,
                10, 10, 10, 10, 0,  0,  0,  10,  297, 10, 10,  10, 10, 10, 10, 10, 329, 10,
                10, 10, 10, 10, 10, 10, 10, 333, 341, 10, 345, 10, 10, 10, 0,  0,  0,   0,
        },
        {
                0,   0,   0,   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   0,  0,  10,
                303, 310, 321, 10, 10, 10, 0,  0,  0,  0,  0,  0,  0,  10, 326, 10, 10, 10,
                10,  10,  10,  10, 0,  0,  0,  10, 10, 10, 10, 10, 10, 10, 10,  10, 10, 10,
                10,  10,  10,  10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 0,   0,  0,  0,
        },
        {
                0,  0,  0,  0,  0,  0,   0,  0,  0,  0,  0,  0,  0,   0,  0,  0,   0,  10,
                10, 10, 10, 10, 10, 10,  0,  0,  0,  0,  0,  0,  0,   10, 10, 10,  10, 10,
                10, 10, 10, 10, 0,  0,   0,  10, 10, 10, 10, 10, 351, 10, 10, 357, 10, 10,
                10, 10, 10, 10, 10, 368, 10, 10, 10, 10, 10, 10, 371, 10, 0,  0,   0,  0,
        },
};
static constexpr CompactEntry kCompact[] = {
        {0,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {3,
         {
                 195,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {6,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {8,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 63,
                 0,
                 0,
                 63,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 255,
         }},
        {8,
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 63,
                 0,
                 0,
                 63,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 255,
         }},
        {19 | (11 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 169,
                 170,
                 138,
                 170,
                 170,
                 255,
         }},
        {10,
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 63,
                 0,
                 0,
                 63,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 255,
         }},
        {14 | (12 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 170,
                 170,
                 169,
                 162,
                 255,
         }},
        {13 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 84,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {15 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {16 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {17 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {18 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {20 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {21 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {22 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {24,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {27 | (26 << 9),
         {
                 255,
                 255,
                 253,
                 255,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {31,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {34 | (33 << 9),
         {
                 255,
                 255,
                 255,
                 253,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {38 | (37 << 9),
         {
                 255,
                 255,
                 255,
                 223,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {40,
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {41 | (40 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 255,
                 207,
                 255,
                 255,
                 255,
                 252,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {43 | (42 << 9),
         {
                 255,
                 255,
                 255,
                 221,
                 3,
                 0,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {43,
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {49 | (48 << 9) | (45 << 18),
         {
                 255,
                 255,
                 191,
                 255,
                 253,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {46 | (45 << 9),
         {
                 87,
                 85,
                 21,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
         }},
        {47 | (45 << 9),
         {
                 87,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
         }},
        {48,
         {
                 51,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
         }},
        {56 | (52 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 255,
                 207,
                 255,
                 255,
                 255,
                 252,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {53 | (52 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 255,
                 207,
                 255,
                 255,
                 255,
                 252,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {55 | (54 << 9),
         {
                 255,
                 255,
                 255,
                 221,
                 3,
                 0,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {55,
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {58 | (57 << 9),
         {
                 255,
                 255,
                 255,
                 221,
                 3,
                 0,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {58,
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {63 | (62 << 9),
         {
                 255,
                 255,
                 255,
                 221,
                 3,
                 0,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {63,
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {68,
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 63,
                 192,
                 255,
                 255,
                 0,
                 240,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {68 | (66 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 63,
                 192,
                 223,
                 255,
                 0,
                 240,
                 255,
                 255,
                 223,
                 255,
                 255,
         }},
        {76 | (74 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 31,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {75,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {78,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {81 | (80 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 127,
                 252,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {82,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {87 | (85 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 253,
                 255,
                 252,
                 255,
                 255,
         }},
        {86,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 243,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {88,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 252,
                 255,
         }},
        {89,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 252,
                 255,
                 255,
                 255,
                 255,
         }},
        {90,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 243,
                 255,
                 255,
         }},
        {91,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 207,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {92,
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 63,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {98 | (97 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 127,
                 255,
                 255,
                 255,
                 207,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
         }},
        {102 | (100 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 170,
                 170,
                 161,
                 170,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 21,
                 85,
                 85,
                 85,
                 255,
         }},
        {103 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {104 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {105 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {106 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 81,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {107 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {108 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {114 | (110 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 170,
                 106,
                 138,
                 170,
                 255,
         }},
        {111 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {112 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {113 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 81,
                 85,
                 85,
                 85,
                 255,
         }},
        {115 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 81,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {116 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 81,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {117 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {118 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {121 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 84,
                 85,
                 255,
         }},
        {122 | (101 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 168,
                 170,
                 170,
                 166,
                 170,
                 255,
         }},
        {124 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {125 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 84,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 84,
                 85,
                 255,
         }},
        {127 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {130 | (128 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 170,
                 170,
                 161,
                 170,
                 255,
         }},
        {129 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {131 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {132 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {133 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {134 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {137 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 81,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {138 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {139 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {140 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {141 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {143 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 84,
                 85,
                 255,
         }},
        {144 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {145 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {146 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {147 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 21,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {149 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {150 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 81,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {151 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {153 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {154 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 23,
                 80,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {157 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 84,
                 85,
                 255,
         }},
        {158 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {160 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {162 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {163 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {164 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {165 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {166 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {169 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {170 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 84,
                 85,
                 255,
         }},
        {171 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {173 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 81,
                 255,
         }},
        {174 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 21,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {176 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {177 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {179 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {181 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {182 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {186 | (184 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 154,
                 162,
                 170,
                 170,
                 255,
         }},
        {185 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 63,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {185,
         {
                 255,
                 255,
                 255,
                 255,
                 3,
                 0,
                 255,
                 63,
                 0,
                 0,
                 63,
                 0,
                 0,
                 0,
                 0,
                 0,
                 0,
                 255,
         }},
        {187 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {193 | (189 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 169,
                 170,
                 42,
                 170,
                 255,
         }},
        {190 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 69,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {191 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 21,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {192 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {194 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {195 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {198 | (197 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 166,
                 170,
                 168,
                 170,
                 170,
                 255,
         }},
        {200 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {201 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {202 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {204 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {205 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {207 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {209 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {210 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {211 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 81,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {212 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {213 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {215 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {216 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {217 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {218 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {219 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {226 | (221 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 169,
                 170,
                 170,
                 162,
                 170,
                 170,
                 255,
         }},
        {222 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 69,
                 255,
         }},
        {223 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {224 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {225 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {228 | (227 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 170,
                 169,
                 170,
                 168,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 69,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {229 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {231 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {232 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 21,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {233 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {234 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {235 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 21,
                 85,
                 85,
                 85,
                 255,
         }},
        {236 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {245 | (238 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 169,
                 170,
                 170,
                 162,
                 170,
                 170,
                 255,
         }},
        {239 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 21,
                 85,
                 85,
                 85,
                 255,
         }},
        {240 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {241 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 84,
                 85,
                 255,
         }},
        {242 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {243 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {244 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {252 | (246 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 169,
                 138,
                 170,
                 170,
                 255,
         }},
        {247 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {248 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {249 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {250 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {251 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {253 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {254 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {255 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 84,
                 85,
                 255,
         }},
        {256 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {257 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {258 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {259 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {260 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {261 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 21,
                 85,
                 255,
         }},
        {262 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {264 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {265 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {266 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {267 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {270 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {271 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 81,
                 85,
                 85,
                 85,
                 255,
         }},
        {272 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {274 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {275 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {276 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {277 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 84,
                 85,
                 255,
         }},
        {278 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {279 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {281 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 81,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {282 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {283 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {285 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {292 | (286 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 169,
                 170,
                 170,
                 170,
                 162,
                 170,
                 255,
         }},
        {287 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 21,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {288 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {289 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {290 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {291 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 69,
                 255,
         }},
        {293 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {294 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {295 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {298 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 21,
                 85,
                 85,
                 85,
                 255,
         }},
        {299 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {300 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {301 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {302 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {304 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 81,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {305 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 81,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {306 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 21,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {307 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {308 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 21,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {309 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 84,
                 255,
         }},
        {311 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 81,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {312 | (305 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 164,
                 191,
                 170,
                 170,
                 170,
                 170,
                 170,
                 170,
                 255,
         }},
        {313 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {314 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {315 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {316 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 81,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {317 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 21,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {318 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {319 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 21,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {320 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {322 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 81,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {323 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 84,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {324 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {325 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {327 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {328 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 81,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {330 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 21,
                 255,
         }},
        {331 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {332 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 81,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {337 | (334 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 169,
                 170,
                 170,
                 42,
                 170,
                 170,
                 255,
         }},
        {335 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {336 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {338 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {339 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {340 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {342 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {343 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {344 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {101 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {346 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {347 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {348 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 69,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {349 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 21,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {352 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 21,
                 85,
                 85,
                 85,
                 255,
         }},
        {353 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {354 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {355 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {356 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {359 | (358 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 169,
                 42,
                 170,
                 170,
                 255,
         }},
        {360 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {361 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {362 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 21,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {363 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 69,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {364 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {365 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {366 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {367 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {369 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 69,
                 85,
                 255,
         }},
        {370 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {372 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 69,
                 85,
                 85,
                 255,
         }},
        {373 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {374 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 21,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {375 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {389 | (377 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 170,
                 169,
                 168,
                 170,
                 255,
         }},
        {384 | (378 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 170,
                 169,
                 170,
                 168,
                 170,
                 255,
         }},
        {383 | (379 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 166,
                 170,
                 162,
                 170,
                 170,
                 255,
         }},
        {380 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {381 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {382 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 21,
                 85,
                 85,
                 85,
                 255,
         }},
        {385 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {386 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 69,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {387 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {388 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {390 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {391 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {398 | (393 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 169,
                 170,
                 170,
                 162,
                 170,
                 170,
                 255,
         }},
        {394 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 21,
                 85,
                 85,
                 255,
         }},
        {395 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 69,
                 255,
         }},
        {396 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {397 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {399 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {400 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 84,
                 85,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {401 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {402 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {403 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {409 | (405 << 9) | (10 << 18),
         {
                 255,
                 255,
                 255,
                 255,
                 171,
                 170,
                 255,
                 191,
                 170,
                 170,
                 191,
                 170,
                 106,
                 170,
                 42,
                 170,
                 170,
                 255,
         }},
        {406 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {407 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {408 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {410 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 84,
                 85,
                 85,
                 85,
                 255,
         }},
        {411 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 81,
                 85,
                 255,
         }},
        {412 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 84,
                 85,
                 85,
                 85,
                 85,
                 255,
         }},
        {413 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 81,
                 85,
                 85,
                 255,
         }},
        {414 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 84,
                 85,
                 85,
                 255,
         }},
        {415 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 69,
                 85,
                 85,
                 85,
                 255,
         }},
        {416 | (10 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 87,
                 85,
                 255,
                 127,
                 85,
                 85,
                 127,
                 85,
                 85,
                 85,
                 85,
                 85,
                 69,
                 255,
         }},
        {420 | (419 << 9),
         {
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 127,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 255,
                 243,
         }},
};
static constexpr IndexEntry kIndices[] = {
        0,   -1,  1,   1,   0,   2,   0,   3,   4,   5,   6,   7,   8,   6,   9,   10,  11,  12,
        6,   13,  14,  15,  6,   16,  0,   17,  0,   0,   0,   0,   18,  0,   19,  0,   0,   0,
        20,  0,   0,   21,  22,  23,  24,  24,  25,  26,  27,  0,   28,  0,   -2,  29,  30,  31,
        32,  32,  33,  34,  34,  -3,  -4,  35,  36,  36,  0,   0,   0,   37,  38,  -5,  -5,  0,
        0,   39,  40,  0,   0,   41,  0,   42,  0,   43,  0,   0,   44,  45,  0,   46,  47,  48,
        49,  50,  0,   6,   0,   0,   51,  0,   0,   52,  53,  6,   54,  55,  56,  57,  58,  59,
        60,  61,  62,  63,  64,  6,   65,  66,  67,  68,  6,   -6,  69,  70,  6,   71,  72,  73,
        74,  75,  76,  6,   77,  78,  79,  80,  6,   -7,  81,  82,  83,  84,  85,  6,   86,  87,
        88,  89,  90,  6,   91,  92,  93,  60,  94,  95,  96,  -8,  97,  98,  6,   99,  53,  100,
        101, 102, 103, 104, 105, -9,  106, 107, 108, 6,   109, 110, 111, 112, 113, 6,   114, 6,
        115, 116, 96,  117, 118, 119, 120, 121, 122, 123, 124, 125, 6,   126, 127, 96,  128, 6,
        -10, 129, 130, 131, 6,   132, 133, 6,   134, 135, 136, 137, 138, 139, 140, 60,  141, 142,
        143, 144, 145, 135, 146, 147, 148, 149, 150, 6,   151, 152, 153, 6,   154, 155, 156, 157,
        158, 159, 6,   160, 161, 162, 163, 164, 165, 166, 60,  167, 168, 169, 170, 171, 172, 6,
        173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 6,   183, 184, 185, 186, 135, -11, 187,
        188, 189, 111, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204,
        205, 206, 207, 6,   208, 209, 210, 6,   -12, 211, 212, 213, 214, 215, -13, 216, 217, 218,
        219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 222, 233, 234, 235,
        236, 135, 237, 238, 60,  239, 240, 241, 242, 243, 244, 245, 200, 246, 247, 248, 6,   249,
        250, 251, 252, 253, 254, 255, 256, 6,   -14, 257, 258, 259, 260, 261, 60,  262, 73,  263,
        264, 265, 266, 267, 268, 269, 270, 6,   271, 272, 6,   273, 274, 275, 276, 242, 277, 278,
        279, 280, 281, 282, 6,   196, 283, 284, 285, 286, 111, 287, 288, 152, 289, 290, 291, 292,
        293, 152, 294, 295, 296, 297, 298, 60,  299, 300, 301, 302, 6,   303, 304, 305, 306, 307,
        308, 309, 6,   0,   310, 0,   0,   0,   0,
};
State get_transition(int transition, int state) {
    IndexEntry index = kIndices[state];
    if (index < 0) {
        return kFull[~index].data[transition];
    }
    const CompactEntry& entry = kCompact[index];
    int v = entry.data[transition >> 2];
    v >>= 2 * (transition & 3);
    v &= 3;
    v *= 9;
    return (entry.values >> v) & 511;
}
static const int8_t kAccepts[423] = {
        -1, -1, 89, 89, 92, 68, 73, 92, 43, 42, 42, 42, 42, 38, 42, 42, 42, 42, 39, 42, 42, 42, 29,
        58, 82, 63, 67, 87, 44, 45, 56, 80, 54, 52, 78, 51, 55, 53, 79, 50, 1,  -1, -1, 1,  57, -1,
        -1, 91, 90, 81, 2,  1,  1,  -1, -1, 1,  -1, -1, 1,  2,  3,  -1, -1, 1,  3,  2,  2,  -1, 2,
        2,  2,  70, 88, 75, 59, 83, 77, 71, 72, 74, 76, 60, 84, 69, 92, -1, 7,  -1, -1, -1, -1, -1,
        13, 42, 48, 49, 62, 86, 66, 42, 42, 41, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 16, 42,
        42, 42, 42, 32, 42, 42, 42, 14, 42, 42, 42, 42, 42, 42, 24, 42, 42, 42, 42, 17, 42, 42, 42,
        42, 42, 42, 15, 42, 42, 42, 42, 42, 18, 11, 42, 42, 42, 42, 42, 42, 42, 42, 42, 8,  42, 42,
        42, 42, 42, 42, 41, 42, 42, 42, 42, 42, 5,  42, 42, 42, 42, 42, 25, 42, 9,  42, 42, 42, 42,
        42, 41, 42, 42, 42, 42, 42, 42, 35, 42, 42, 42, 42, 6,  20, 42, 42, 42, 27, 42, 42, 22, 42,
        42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 34, 42, 42, 42, 37,
        42, 42, 42, 42, 42, 42, 36, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 28, 42,
        42, 42, 42, 42, 42, 42, 42, 42, 42, 26, 42, 42, 21, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
        42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 30, 42, 42, 42, 19, 42, 42, 42,
        42, 42, 42, 42, 42, 41, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
        41, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 33, 42, 42, 42, 42,
        42, 42, 42, 42, 12, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 40,
        42, 42, 4,  42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 23, 42, 42, 42, 42, 42, 42, 42, 42,
        42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 10, 42, 42, 42, 42, 42,
        42, 42, 31, 46, 61, 85, 65, 47, 64,
};

Token Lexer::next() {
    // note that we cheat here: normally a lexer needs to worry about the case
    // where a token has a prefix which is not itself a valid token - for instance,
    // maybe we have a valid token 'while', but 'w', 'wh', etc. are not valid
    // tokens. Our grammar doesn't have this property, so we can simplify the logic
    // a bit.
    int32_t startOffset = fOffset;
    State state = 1;
    for (;;) {
        if (fOffset >= (int32_t)fText.length()) {
            if (startOffset == (int32_t)fText.length() || kAccepts[state] == -1) {
                return Token(Token::Kind::TK_END_OF_FILE, startOffset, 0);
            }
            break;
        }
        uint8_t c = (uint8_t)(fText[fOffset] - 9);
        if (c >= 118) {
            c = kInvalidChar;
        }
        State newState = get_transition(kMappings[c], state);
        if (!newState) {
            break;
        }
        state = newState;
        ++fOffset;
    }
    Token::Kind kind = (Token::Kind)kAccepts[state];
    return Token(kind, startOffset, fOffset - startOffset);
}

}  // namespace SkSL
