# qpdf

> 多功能 PDF 转换软件。
> 更多信息：<https://manned.org/qpdf>。

- 从一个 PDF 文件中提取第 1-3 页、第 5 页和第 6-10 页，然后另存为一个新文件：

`qpdf --empty --pages {{路径/到/输入.pdf}} {{1-3,5,6-10}} -- {{路径/到/输出.pdf}}`

- 合并（连接）多个 PDF 文件的所有页面，并将结果保存为一个新 PDF：

`qpdf --empty --pages {{路径/到/文件1.pdf 文件2.pdf ...}} -- {{路径/到/输出.pdf}}`

- 合并（连接）多个 PDF 文件中指定的页面，并将结果保存为一个新 PDF：

`qpdf --empty --pages {{路径/到/文件1.pdf}} {{1,6-8}} {{路径/到/文件2.pdf}} {{3,4,5}} -- {{路径/到/输出.pdf}}`

- 将每组 `n` 页写入一个单独的输出文件，使用给定的文件名模式：

`qpdf --split-pages={{n}} {{路径/到/输入.pdf}} {{路径/到/输出_%d.pdf}}`

- 旋转某些页面的 PDF 以给定角度：

`qpdf --rotate={{90:2,4,6}} --rotate={{180:7-8}} {{路径/到/输入.pdf}} {{路径/到/输出.pdf}}`

- 移除密码保护文件中的密码：

`qpdf --password={{密码}} --decrypt {{路径/到/输入.pdf}} {{路径/到/输出.pdf}}`
