# k6

> Open-Source Tool und SaaS für Lasttests.
> Weitere Informationen: <https://grafana.com/docs/k6/latest/using-k6/k6-options/reference/>.

- Führe einen Lasttest lokal aus:

`k6 run {{skript.js}}`

- Führe einen Lasttest lokal mit einer festgelegten Anzahl von virtuellen Benutzern und Dauer aus:

`k6 run {{[-u|--vus]}} {{10}} {{[-d|--duration]}} {{30s}} {{skript.js}}`

- Führe einen Lasttest lokal mit einer gesetzten Umgebungsvariablen aus:

`k6 run {{[-e|--env]}} {{HOSTNAME=example.com}} {{skript.js}}`

- Führe einen Lasttest lokal aus und speichere die Ergebnisse in InfluxDB:

`k6 run {{[-o|--out]}} influxdb={{http://localhost:8086/k6db}} {{skript.js}}`

- Führe einen Lasttest lokal aus und verwerfe Antworten (deutlich schneller):

`k6 run --discard-response-bodies {{skript.js}}`

- Führe einen Lasttest lokal im JavaScript-Kompatibilitätsmodus aus (deutlich schneller):

`k6 run --compatibility-mode=base {{skript.js}}`

- Melde dich bei einem Cloud-Dienst mit einem geheimen Token an:

`k6 login cloud --token {{geheim}}`

- Führe einen Lasttest auf Cloud-Infrastruktur aus:

`k6 cloud {{skript.js}}`
