# git reauthor

> Change details about an author identity. Since this command rewrites the Git history, `--force` will be needed when pushing next time.
> Part of `git-extras`.
> More information: <https://github.com/tj/git-extras/blob/main/Commands.md#git-reauthor>.

- Change an author's email and name across the whole Git repository:

`git reauthor {{[-o|--old-email]}} {{old@example.com}} {{[-e|--correct-email]}} {{new@example.com}} {{[-n|--correct-name]}} "{{name}}"`

- Change the email and name to the ones defined in the Git config:

`git reauthor {{[-o|--old-email]}} {{old@example.com}} {{[-c|--use-config]}}`

- Change the email and name of all commits, regardless of their original author:

`git reauthor {{[-a|--all]}} {{[-e|--correct-email]}} {{name@example.com}} {{[-n|--correct-name]}} {{name}}`
