# chown

> 파일과 디렉토리의 사용자 및 그룹 소유권 변경.
> 같이 보기: `chgrp`.
> 더 많은 정보: <https://www.gnu.org/software/coreutils/manual/html_node/chown-invocation.html>.

- 파일/디렉토리를 소유한 사용자를 변경:

`chown {{사용자}} {{경로/대상/파일_또는_디렉토리}}`

- 파일/디렉토리를 소유한 사용자 및 그룹을 변경:

`chown {{사용자}}:{{그룹}} {{경로/대상/파일_또는_디렉토리}}`

- 소유한 사용자 및 그룹을 모두 `사용자`로 변경:

`chown {{사용자}}: {{경로/대상/파일_또는_디렉토리}}`

- 디렉토리 및 그 내용의 소유한 사용자를 재귀적으로 변경:

`chown {{[-R|--recursive]}} {{사용자}} {{경로/대상/디렉토리}}`

- 심볼릭 링크의 소유한 사용자를 변경:

`chown {{[-h|--no-dereference]}} {{사용자}} {{심볼릭_링크}}`

- 파일/디렉토리의 소유한 사용자를 참조 파일과 일치시키기:

`chown --reference {{경로/대상/참조_파일}} {{경로/대상/파일_또는_디렉토리}}`
