# join

> 두 정렬된 파일의 공통 필드를 기준으로 줄을 결합.
> 더 많은 정보: <https://www.gnu.org/software/coreutils/manual/html_node/join-invocation.html>.

- 기본 필드(첫 번째 필드)를 기준으로 두 파일 결합:

`join {{경로/대상/파일1}} {{경로/대상/파일2}}`

- 쉼표(공백 대신)를 필드 구분자로 사용하여 두 파일 결합:

`join -t {{','}} {{경로/대상/파일1}} {{경로/대상/파일2}}`

- 파일1의 필드3과 파일2의 필드1을 기준으로 결합:

`join -1 {{3}} -2 {{1}} {{경로/대상/파일1}} {{경로/대상/파일2}}`

- 파일1에서 결합할 수 없는 각 줄에 대해 줄 생성:

`join -a {{1}} {{경로/대상/파일1}} {{경로/대상/파일2}}`

- `stdin`에서 파일 결합:

`cat {{경로/대상/파일1}} | join - {{경로/대상/파일2}}`
