// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

var { 9007199254740991n: it } = { 9007199254740991n: 1 };
assertEquals(it, 1);

var { 999999999999999999n: it } = { 999999999999999999n: 1 }; // greater than max safe integer
assertEquals(it, 1);

var obj = { 0xfffffffffffffffffffffn: 1};
assertEquals(1, obj["19342813113834066795298815"]);

var obj2 = {0o777777777777777777777777777n: 1};
assertEquals(1, obj2["2417851639229258349412351"]);

var obj3 = { 0x4n: 'hi' };

assertEquals('hi', obj3[4]);
assertEquals(undefined, obj3["0x4"]);

let obj4 =
  {12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890n: 1};
assertEquals(
  1,
  obj4["12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"]);

// 130 hex digits
let obj5 = {0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffn: 1};
assertEquals(
  1,
  obj5["3432398830065304857490950399540696608634717650071652704697231729592771591698828026061279820330727277488648155695740429018560993999858321906287014145557528575"]);
