/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_adv.h"
        #include <wx/colour.h>
        #include <wx/brush.h>
        #include <wx/pen.h>
        #include "arrayholder.h"
        #include <wx/font.h>
        #include <wx/gdicmn.h>
        #include <wx/bitmap.h>
        #include <wx/gdicmn.h>
        #include <wx/icon.h>
        #include <wx/gdicmn.h>
        #include <wx/dc.h>
        #include <wx/region.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxPseudoDC_RemoveAll, "RemoveAll()\n"
"\n"
"Removes all objects and operations from the recorded list.");

extern "C" {static PyObject *meth_wxPseudoDC_RemoveAll(PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_RemoveAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPseudoDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPseudoDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RemoveAll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_RemoveAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_GetLen, "GetLen() -> int\n"
"\n"
"Returns the number of operations in the recorded list.");

extern "C" {static PyObject *meth_wxPseudoDC_GetLen(PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_GetLen(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPseudoDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPseudoDC, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLen();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_GetLen, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetId, "SetId(id)\n"
"\n"
"Sets the id to be associated with subsequent operations.");

extern "C" {static PyObject *meth_wxPseudoDC_SetId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPseudoDC, &sipCpp, &id))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetId(id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_ClearId, "ClearId(id)\n"
"\n"
"Removes all operations associated with id so the object can be\n"
"redrawn.");

extern "C" {static PyObject *meth_wxPseudoDC_ClearId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_ClearId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPseudoDC, &sipCpp, &id))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ClearId(id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_ClearId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_RemoveId, "RemoveId(id)\n"
"\n"
"Remove the object node (and all operations) associated with an id.");

extern "C" {static PyObject *meth_wxPseudoDC_RemoveId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_RemoveId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPseudoDC, &sipCpp, &id))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RemoveId(id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_RemoveId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_TranslateId, "TranslateId(id, dx, dy)\n"
"\n"
"Translate the position of the operations of tag `id` by (`dx`, `dy`).");

extern "C" {static PyObject *meth_wxPseudoDC_TranslateId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_TranslateId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        ::wxCoord dx;
        ::wxCoord dy;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_dx,
            sipName_dy,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &id, &dx, &dy))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->TranslateId(id, dx, dy);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_TranslateId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetIdGreyedOut, "SetIdGreyedOut(id, greyout)\n"
"\n"
"Set whether the set of objects with tag `id` are drawn greyed out or\n"
"not.");

extern "C" {static PyObject *meth_wxPseudoDC_SetIdGreyedOut(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetIdGreyedOut(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        bool greyout;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_greyout,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bib", &sipSelf, sipType_wxPseudoDC, &sipCpp, &id, &greyout))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetIdGreyedOut(id, greyout);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetIdGreyedOut, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_GetIdGreyedOut, "GetIdGreyedOut(id) -> bool\n"
"\n"
"Get whether the set of objects with tag `id` are drawn greyed out or\n"
"not.");

extern "C" {static PyObject *meth_wxPseudoDC_GetIdGreyedOut(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_GetIdGreyedOut(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPseudoDC, &sipCpp, &id))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetIdGreyedOut(id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_GetIdGreyedOut, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_FindObjects, "FindObjects(x, y, radius=1, bg=wx.WHITE) -> PyObject\n"
"\n"
"Returns a list of all the id's that draw a pixel with\n"
"color not equal to bg within radius of (x,y). Returns an\n"
"empty list if nothing is found.  The list is in reverse\n"
"drawing order so list[0] is the top id.");

extern "C" {static PyObject *meth_wxPseudoDC_FindObjects(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_FindObjects(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord radius = 1;
        const ::wxColour& bgdef = *wxWHITE;
        const ::wxColour* bg = &bgdef;
        int bgState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_radius,
            sipName_bg,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|iJ1", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y, &radius, sipType_wxColour, &bg, &bgState))
        {
            PyObject * sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindObjects(x, y, radius, *bg);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxColour *>(bg), sipType_wxColour, bgState);

            if (PyErr_Occurred())
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_FindObjects, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_FindObjectsByBBox, "FindObjectsByBBox(x, y) -> PyObject\n"
"\n"
"Returns a list of all the id's whose bounding boxes include (x,y).\n"
"Returns an empty list if nothing is found.  The list is in\n"
"reverse drawing order so list[0] is the top id.");

extern "C" {static PyObject *meth_wxPseudoDC_FindObjectsByBBox(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_FindObjectsByBBox(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y))
        {
            PyObject * sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->FindObjectsByBBox(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_FindObjectsByBBox, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawIdToDC, "DrawIdToDC(id, dc)\n"
"\n"
"Draw recorded operations tagged with id to dc.");

extern "C" {static PyObject *meth_wxPseudoDC_DrawIdToDC(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawIdToDC(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        ::wxDC* dc;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_dc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiJ8", &sipSelf, sipType_wxPseudoDC, &sipCpp, &id, sipType_wxDC, &dc))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawIdToDC(id, dc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawIdToDC, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetIdBounds, "SetIdBounds(id, rect)\n"
"\n"
"Set the bounding rect of a given object.\n"
"This will create an object node if one doesn't exist.");

extern "C" {static PyObject *meth_wxPseudoDC_SetIdBounds(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetIdBounds(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        ::wxRect* rect;
        int rectState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiJ1", &sipSelf, sipType_wxPseudoDC, &sipCpp, &id, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetIdBounds(id, *rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(rect, sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetIdBounds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_GetIdBounds, "GetIdBounds(id) -> wx.Rect\n"
"\n"
"Returns the bounding rectangle previously set with `SetIdBounds`.\n"
"If no bounds have been set, it returns wx.Rect(0,0,0,0).");

extern "C" {static PyObject *meth_wxPseudoDC_GetIdBounds(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_GetIdBounds(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int id;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPseudoDC, &sipCpp, &id))
        {
            ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRect(sipCpp->GetIdBounds(id));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRect, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_GetIdBounds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawToDCClipped, "DrawToDCClipped(dc, rect)\n"
"\n"
"Draws the recorded operations to dc,\n"
"unless the operation is known to be outside of rect.");

extern "C" {static PyObject *meth_wxPseudoDC_DrawToDCClipped(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawToDCClipped(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC* dc;
        const ::wxRect* rect;
        int rectState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxDC, &dc, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawToDCClipped(dc, *rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawToDCClipped, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawToDCClippedRgn, "DrawToDCClippedRgn(dc, region)\n"
"\n"
"Draws the recorded operations to dc,\n"
"unless the operation is known to be outside the given region.");

extern "C" {static PyObject *meth_wxPseudoDC_DrawToDCClippedRgn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawToDCClippedRgn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC* dc;
        const ::wxRegion* region;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J9", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxDC, &dc, sipType_wxRegion, &region))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawToDCClippedRgn(dc, *region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawToDCClippedRgn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawToDC, "DrawToDC(dc)\n"
"\n"
"Draws the recorded operations to dc.");

extern "C" {static PyObject *meth_wxPseudoDC_DrawToDC(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawToDC(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxDC* dc;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_dc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxDC, &dc))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawToDC(dc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawToDC, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_FloodFill, "FloodFill(x, y, col, style=wx.FLOOD_SURFACE)\n"
"FloodFill(pt, col, style=wx.FLOOD_SURFACE)\n"
"\n"
"Flood fills the device context starting from the given point,\n"
"using the current brush colour, and using a style:\n"
"\n"
"    - ``wx.FLOOD_SURFACE``: the flooding occurs until a colour other\n"
"than the given colour is encountered.\n"
"\n"
"    - ``wx.FLOOD_BORDER``: the area to be flooded is bounded by the\n"
"given colour.\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_FloodFill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_FloodFill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        const ::wxColour* col;
        int colState = 0;
        ::wxFloodFillStyle style = wxFLOOD_SURFACE;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_col,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiiJ1|E", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y, sipType_wxColour, &col, &colState, sipType_wxFloodFillStyle, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->FloodFill(x, y, *col, style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxColour *>(col), sipType_wxColour, colState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxColour* col;
        int colState = 0;
        ::wxFloodFillStyle style = wxFLOOD_SURFACE;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_col,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|E", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxColour, &col, &colState, sipType_wxFloodFillStyle, &style))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->FloodFill(*pt, *col, style);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast<::wxColour *>(col), sipType_wxColour, colState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_FloodFill, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawLine, "DrawLine(x1, y1, x2, y2)\n"
"DrawLine(pt1, pt2)\n"
"\n"
"Draws a line from the first point to the second.\n"
"The current pen is used for drawing the line. Note that\n"
"the second point is *not* part of the line and is not\n"
"drawn by this function (this is consistent with the\n"
"behaviour of many other toolkits).\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawLine(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawLine(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x1;
        ::wxCoord y1;
        ::wxCoord x2;
        ::wxCoord y2;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x1, &y1, &x2, &y2))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLine(x1, y1, x2, y2);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt1;
        int pt1State = 0;
        const ::wxPoint* pt2;
        int pt2State = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt1,
            sipName_pt2,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPoint, &pt1, &pt1State, sipType_wxPoint, &pt2, &pt2State))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLine(*pt1, *pt2);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt1), sipType_wxPoint, pt1State);
            sipReleaseType(const_cast<::wxPoint *>(pt2), sipType_wxPoint, pt2State);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawLine, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_CrossHair, "CrossHair(x, y)\n"
"CrossHair(pt)\n"
"\n"
"Displays a cross hair using the current pen. This is a\n"
"vertical and horizontal line the height and width of the\n"
"window, centred on the given point.\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_CrossHair(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_CrossHair(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CrossHair(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->CrossHair(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_CrossHair, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawArc, "DrawArc(x1, y1, x2, y2, xc, yc)\n"
"\n"
"Draws an arc of a circle, centred on the *center* point\n"
"(xc, yc), from the first point to the second. The current\n"
"pen is used for the outline and the current brush for\n"
"filling the shape.\n"
"\n"
"The arc is drawn in an anticlockwise direction from the\n"
"start point to the end point.");

extern "C" {static PyObject *meth_wxPseudoDC_DrawArc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawArc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x1;
        ::wxCoord y1;
        ::wxCoord x2;
        ::wxCoord y2;
        ::wxCoord xc;
        ::wxCoord yc;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
            sipName_xc,
            sipName_yc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiiiii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x1, &y1, &x2, &y2, &xc, &yc))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawArc(x1, y1, x2, y2, xc, yc);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawArc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawCheckMark, "DrawCheckMark(x, y, width, height)\n"
"DrawCheckMark(rect)\n"
"\n"
"Draws a check mark inside the given rectangle\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawCheckMark(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawCheckMark(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCheckMark(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCheckMark(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawCheckMark, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawEllipticArc, "DrawEllipticArc(x, y, w, h, start, end)\n"
"DrawEllipticArc(pt, sz, start, end)\n"
"\n"
"Draws an arc of an ellipse, with the given rectangle\n"
"defining the bounds of the ellipse. The current pen is\n"
"used for drawing the arc and the current brush is used for\n"
"drawing the pie.\n"
"\n"
"The *start* and *end* parameters specify the start and end\n"
"of the arc relative to the three-o'clock position from the\n"
"center of the rectangle. Angles are specified in degrees\n"
"(360 is a complete circle). Positive values mean\n"
"counter-clockwise motion. If start is equal to end, a\n"
"complete ellipse will be drawn.\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawEllipticArc(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawEllipticArc(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord w;
        ::wxCoord h;
        double start;
        double end;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_w,
            sipName_h,
            sipName_start,
            sipName_end,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiiidd", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y, &w, &h, &start, &end))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipticArc(x, y, w, h, start, end);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxSize* sz;
        int szState = 0;
        double start;
        double end;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
            sipName_start,
            sipName_end,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1dd", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState, &start, &end))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipticArc(*pt, *sz, start, end);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast<::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawEllipticArc, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawPoint, "DrawPoint(x, y)\n"
"DrawPoint(pt)\n"
"\n"
"Draws a point using the current pen.\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPoint(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPoint(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawRectangle, "DrawRectangle(x, y, width, height)\n"
"DrawRectangle(rect)\n"
"DrawRectangle(pt, sz)\n"
"\n"
"Draws a rectangle with the given top left corner, and with\n"
"the given size. The current pen is used for the outline\n"
"and the current brush for filling the shape.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxSize* sz;
        int szState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRectangle(*pt, *sz);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast<::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawRectangle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawRoundedRectangle, "DrawRoundedRectangle(x, y, width, height, radius)\n"
"DrawRoundedRectangle(rect, radius)\n"
"DrawRoundedRectangle(pt, sz, radius)\n"
"\n"
"Draws a rectangle with the given top left corner, and with\n"
"the given size. The current pen is used for the outline\n"
"and the current brush for filling the shape.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawRoundedRectangle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawRoundedRectangle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        double radius;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiiid", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y, &width, &height, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(x, y, width, height, radius);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        double radius;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1d", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxRect, &rect, &rectState, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(*rect, radius);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxSize* sz;
        int szState = 0;
        double radius;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1d", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRoundedRectangle(*pt, *sz, radius);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast<::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawRoundedRectangle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawCircle, "DrawCircle(x, y, radius)\n"
"DrawCircle(pt, radius)\n"
"\n"
"Draws a circle with the given center point and radius.\n"
"The current pen is used for the outline and the current\n"
"brush for filling the shape.\n"
"\n"
":see: `DrawEllipse`\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawCircle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawCircle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord radius;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCircle(x, y, radius);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxCoord radius;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_radius,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1i", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPoint, &pt, &ptState, &radius))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawCircle(*pt, radius);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawCircle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawEllipse, "DrawEllipse(x, y, width, height)\n"
"DrawEllipse(rect)\n"
"DrawEllipse(pt, sz)\n"
"\n"
"Draws an ellipse contained in the specified rectangle. The current pen\n"
"is used for the outline and the current brush for filling the shape.\",\n"
"\"\n"
"\n"
":see: `DrawCircle`\n"
"\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawEllipse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawEllipse(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxPseudoDC, &sipCpp, &x, &y, &width, &height))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxSize* sz;
        int szState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
            sipName_sz,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPoint, &pt, &ptState, sipType_wxSize, &sz, &szState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawEllipse(*pt, *sz);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);
            sipReleaseType(const_cast<::wxSize *>(sz), sipType_wxSize, szState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawEllipse, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawIcon, "DrawIcon(icon, x, y)\n"
"DrawIcon(icon, pt)\n"
"\n"
"Draw an icon on the display at the given position.\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxIcon* icon;
        ::wxCoord x;
        ::wxCoord y;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9ii", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxIcon, &icon, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawIcon(*icon, x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxIcon* icon;
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxIcon, &icon, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawIcon(*icon, *pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawBitmap, "DrawBitmap(bmp, x, y, useMask=False)\n"
"DrawBitmap(bmp, pt, useMask=False)\n"
"\n"
"Draw a bitmap on the device context at the specified\n"
"point. If *useMask* is true and the bitmap has a\n"
"transparency mask, (or alpha channel on the platforms that\n"
"support it) then the bitmap will be drawn transparently.\n"
"\n"
"When drawing a mono-bitmap, the current text foreground\n"
"colour will be used to draw the foreground of the bitmap\n"
"(all bits set to 1), and the current text background\n"
"colour to draw the background (all bits set to 0).\n"
"\n"
":see: `SetTextForeground`, `SetTextBackground` and `wx.MemoryDC`\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawBitmap(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawBitmap(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBitmap* bmp;
        ::wxCoord x;
        ::wxCoord y;
        bool useMask = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_x,
            sipName_y,
            sipName_useMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9ii|b", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxBitmap, &bmp, &x, &y, &useMask))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawBitmap(*bmp, x, y, useMask);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxBitmap* bmp;
        const ::wxPoint* pt;
        int ptState = 0;
        bool useMask = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_pt,
            sipName_useMask,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1|b", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxBitmap, &bmp, sipType_wxPoint, &pt, &ptState, &useMask))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawBitmap(*bmp, *pt, useMask);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawText, "DrawText(text, x, y)\n"
"DrawText(text, pt)\n"
"\n"
"Draws a text string at the specified point, using the\n"
"current text font, and the current text foreground and\n"
"background colours.\n"
"\n"
"The coordinates refer to the top-left corner of the\n"
"rectangle bounding the string. See `wx.DC.GetTextExtent`\n"
"for how to get the dimensions of a text string, which can\n"
"be used to position the text more precisely, (you will\n"
"need to use a real DC with GetTextExtent as wx.PseudoDC\n"
"does not implement it.)\n"
"\n"
"**NOTE**: under wxGTK the current logical function is used\n"
"*by this function but it is ignored by wxMSW. Thus, you\n"
"*should avoid using logical functions with this function\n"
"*in portable programs.\", \"\n"
"\n"
":see: `DrawRotatedText`\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* text;
        int textState = 0;
        ::wxCoord x;
        ::wxCoord y;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1ii", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxString, &text, &textState, &x, &y))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*text, x, y);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(text), sipType_wxString, textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxString* text;
        int textState = 0;
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxString, &text, &textState, sipType_wxPoint, &pt, &ptState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawText(*text, *pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawRotatedText, "DrawRotatedText(text, x, y, angle)\n"
"DrawRotatedText(text, pt, angle)\n"
"\n"
"Draws the text rotated by *angle* degrees, if supported by the\n"
"platform.\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawRotatedText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawRotatedText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* text;
        int textState = 0;
        ::wxCoord x;
        ::wxCoord y;
        double angle;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_x,
            sipName_y,
            sipName_angle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1iid", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxString, &text, &textState, &x, &y, &angle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRotatedText(*text, x, y, angle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(text), sipType_wxString, textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxString* text;
        int textState = 0;
        const ::wxPoint* pt;
        int ptState = 0;
        double angle;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_pt,
            sipName_angle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1d", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxString, &text, &textState, sipType_wxPoint, &pt, &ptState, &angle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawRotatedText(*text, *pt, angle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast<::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawRotatedText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawLabel, "DrawLabel(text, rect, alignment=wx.ALIGN_LEFT|wx.ALIGN_TOP, indexAccel=-1)\n"
"DrawLabel(text, image, rect, alignment=wx.ALIGN_LEFT|wx.ALIGN_TOP, indexAccel=-1)\n"
"\n"
"Draw *text* within the specified rectangle, abiding by the\n"
"alignment flags.  Will additionally emphasize the\n"
"character at *indexAccel* if it is not -1.\n"
"");

extern "C" {static PyObject *meth_wxPseudoDC_DrawLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* text;
        int textState = 0;
        const ::wxRect* rect;
        int rectState = 0;
        int alignment = wxALIGN_LEFT|wxALIGN_TOP;
        int indexAccel = -1;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_rect,
            sipName_alignment,
            sipName_indexAccel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|ii", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxString, &text, &textState, sipType_wxRect, &rect, &rectState, &alignment, &indexAccel))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLabel(*text, *rect, alignment, indexAccel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast<::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxString* text;
        int textState = 0;
        const ::wxBitmap* image;
        const ::wxRect* rect;
        int rectState = 0;
        int alignment = wxALIGN_LEFT|wxALIGN_TOP;
        int indexAccel = -1;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_image,
            sipName_rect,
            sipName_alignment,
            sipName_indexAccel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J9J1|ii", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxString, &text, &textState, sipType_wxBitmap, &image, sipType_wxRect, &rect, &rectState, &alignment, &indexAccel))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLabel(*text, *image, *rect, alignment, indexAccel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast<::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_Clear, "Clear()\n"
"\n"
"Clears the device context using the current background brush.");

extern "C" {static PyObject *meth_wxPseudoDC_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPseudoDC *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPseudoDC, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetFont, "SetFont(font)\n"
"\n"
"Sets the current font for the DC. It must be a valid font, in\n"
"particular you should not pass ``wx.NullFont`` to this method.\n"
"\n"
":see: `wx.Font`");

extern "C" {static PyObject *meth_wxPseudoDC_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont* font;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetPen, "SetPen(pen)\n"
"\n"
"Sets the current pen for the DC.\n"
"\n"
"If the argument is ``wx.NullPen``, the current pen is selected out of\n"
"the\n"
"device context, and the original pen restored.\n"
"\n"
":see: `wx.Pen`");

extern "C" {static PyObject *meth_wxPseudoDC_SetPen(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetPen(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPen* pen;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pen,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPen, &pen))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPen(*pen);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetPen, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetBrush, "SetBrush(brush)\n"
"\n"
"Sets the current brush for the DC.\n"
"\n"
"If the argument is ``wx.NullBrush``, the current brush is selected out\n"
"of the device context, and the original brush restored, allowing the\n"
"current brush to be destroyed safely.\n"
"\n"
":see: `wx.Brush`");

extern "C" {static PyObject *meth_wxPseudoDC_SetBrush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetBrush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush* brush;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxBrush, &brush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBrush(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetBrush, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetBackground, "SetBackground(brush)\n"
"\n"
"Sets the current background brush for the DC.");

extern "C" {static PyObject *meth_wxPseudoDC_SetBackground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetBackground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxBrush* brush;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_brush,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxBrush, &brush))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackground(*brush);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetBackground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetBackgroundMode, "SetBackgroundMode(mode)\n"
"\n"
"The *mode* parameter may be one of ``wx.SOLID`` and\n"
"``wx.TRANSPARENT``. This setting determines whether text\n"
"will be drawn with a background colour or not.");

extern "C" {static PyObject *meth_wxPseudoDC_SetBackgroundMode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetBackgroundMode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int mode;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPseudoDC, &sipCpp, &mode))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBackgroundMode(mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetBackgroundMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetTextForeground, "SetTextForeground(colour)\n"
"\n"
"Sets the current text foreground colour for the DC.");

extern "C" {static PyObject *meth_wxPseudoDC_SetTextForeground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetTextForeground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextForeground(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetTextForeground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetTextBackground, "SetTextBackground(colour)\n"
"\n"
"Sets the current text background colour for the DC.");

extern "C" {static PyObject *meth_wxPseudoDC_SetTextBackground(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetTextBackground(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextBackground(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetTextBackground, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_SetLogicalFunction, "SetLogicalFunction(function)\n"
"\n"
"Sets the current logical function for the device context. This\n"
"determines how a source pixel (from a pen or brush colour, combines\n"
"with a destination pixel in the current device context.\n"
"\n"
"The possible values and their meaning in terms of source and\n"
"destination pixel values are defined in the\n"
":ref:`wx.RasterOperationMode`\n"
"enumeration.\n"
"\n"
"The default is wx.COPY, which simply draws with the current\n"
"colour. The others combine the current colour and the background using\n"
"a logical operation. wx.INVERT is commonly used for drawing rubber\n"
"bands or moving outlines, since drawing twice reverts to the original\n"
"colour.");

extern "C" {static PyObject *meth_wxPseudoDC_SetLogicalFunction(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_SetLogicalFunction(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRasterOperationMode function;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_function,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxRasterOperationMode, &function))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLogicalFunction(function);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_SetLogicalFunction, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawLines, "DrawLines(points, xoffset=0, yoffset=0)\n"
"\n"
"Draws lines using a sequence of `wx.Point` objects, adding the\n"
"optional offset coordinate. The current pen is used for drawing the\n"
"lines.");

extern "C" {static PyObject *meth_wxPseudoDC_DrawLines(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawLines(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPointList* points;
        int pointsState = 0;
        ::wxCoord xoffset = 0;
        ::wxCoord yoffset = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
            sipName_xoffset,
            sipName_yoffset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0|ii", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPointList, &points, &pointsState, &xoffset, &yoffset))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawLines(points, xoffset, yoffset);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPointList *>(points), sipType_wxPointList, pointsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawLines, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawPolygon, "DrawPolygon(points, xoffset=0, yoffset=0, fillStyle=wx.ODDEVEN_RULE)\n"
"\n"
"Draws a filled polygon using a sequence of `wx.Point` objects, adding\n"
"the optional offset coordinate.  The last argument specifies the fill\n"
"rule: ``wx.ODDEVEN_RULE`` (the default) or ``wx.WINDING_RULE``.\n"
"\n"
"The current pen is used for drawing the outline, and the current brush\n"
"for filling the shape. Using a transparent brush suppresses\n"
"filling. Note that wxWidgets automatically closes the first and last\n"
"points.");

extern "C" {static PyObject *meth_wxPseudoDC_DrawPolygon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawPolygon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPointList* points;
        int pointsState = 0;
        ::wxCoord xoffset = 0;
        ::wxCoord yoffset = 0;
        ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
            sipName_xoffset,
            sipName_yoffset,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0|iiE", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPointList, &points, &pointsState, &xoffset, &yoffset, sipType_wxPolygonFillMode, &fillStyle))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawPolygon(points, xoffset, yoffset, fillStyle);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPointList *>(points), sipType_wxPointList, pointsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawPolygon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPseudoDC_DrawSpline, "DrawSpline(points)\n"
"\n"
"Draws a spline between all given control points, (a list of `wx.Point`\n"
"objects) using the current pen. The spline is drawn using a series of\n"
"lines, using an algorithm taken from the X drawing program 'XFIG'.");

extern "C" {static PyObject *meth_wxPseudoDC_DrawSpline(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPseudoDC_DrawSpline(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPointList* points;
        int pointsState = 0;
        ::wxPseudoDC *sipCpp;

        static const char *sipKwdList[] = {
            sipName_points,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ0", &sipSelf, sipType_wxPseudoDC, &sipCpp, sipType_wxPointList, &points, &pointsState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DrawSpline(points);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPointList *>(points), sipType_wxPointList, pointsState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PseudoDC, sipName_DrawSpline, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxPseudoDC(void *, const sipTypeDef *);}
static void *cast_wxPseudoDC(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxPseudoDC *sipCpp = reinterpret_cast<::wxPseudoDC *>(sipCppV);

    if (targetType == sipType_wxPseudoDC)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast<::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPseudoDC(void *, int);}
static void release_wxPseudoDC(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxPseudoDC *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxPseudoDC(Py_ssize_t);}
static void *array_wxPseudoDC(Py_ssize_t sipNrElem)
{
    return new ::wxPseudoDC[sipNrElem];
}


extern "C" {static void assign_wxPseudoDC(void *, Py_ssize_t, void *);}
static void assign_wxPseudoDC(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxPseudoDC *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxPseudoDC *>(sipSrc);
}


extern "C" {static void *copy_wxPseudoDC(const void *, Py_ssize_t);}
static void *copy_wxPseudoDC(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxPseudoDC(reinterpret_cast<const ::wxPseudoDC *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPseudoDC(sipSimpleWrapper *);}
static void dealloc_wxPseudoDC(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPseudoDC(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPseudoDC(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPseudoDC(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxPseudoDC *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxPseudoDC();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxPseudoDC* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxPseudoDC, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxPseudoDC(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxPseudoDC[] = {{40, 0, 1}};


static PyMethodDef methods_wxPseudoDC[] = {
    {sipName_Clear, meth_wxPseudoDC_Clear, METH_VARARGS, doc_wxPseudoDC_Clear},
    {sipName_ClearId, SIP_MLMETH_CAST(meth_wxPseudoDC_ClearId), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_ClearId},
    {sipName_CrossHair, SIP_MLMETH_CAST(meth_wxPseudoDC_CrossHair), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_CrossHair},
    {sipName_DrawArc, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawArc), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawArc},
    {sipName_DrawBitmap, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawBitmap), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawBitmap},
    {sipName_DrawCheckMark, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawCheckMark), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawCheckMark},
    {sipName_DrawCircle, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawCircle), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawCircle},
    {sipName_DrawEllipse, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawEllipse), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawEllipse},
    {sipName_DrawEllipticArc, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawEllipticArc), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawEllipticArc},
    {sipName_DrawIcon, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawIcon), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawIcon},
    {sipName_DrawIdToDC, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawIdToDC), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawIdToDC},
    {sipName_DrawLabel, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawLabel), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawLabel},
    {sipName_DrawLine, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawLine), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawLine},
    {sipName_DrawLines, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawLines), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawLines},
    {sipName_DrawPoint, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawPoint), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawPoint},
    {sipName_DrawPolygon, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawPolygon), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawPolygon},
    {sipName_DrawRectangle, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawRectangle), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawRectangle},
    {sipName_DrawRotatedText, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawRotatedText), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawRotatedText},
    {sipName_DrawRoundedRectangle, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawRoundedRectangle), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawRoundedRectangle},
    {sipName_DrawSpline, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawSpline), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawSpline},
    {sipName_DrawText, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawText), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawText},
    {sipName_DrawToDC, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawToDC), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawToDC},
    {sipName_DrawToDCClipped, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawToDCClipped), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawToDCClipped},
    {sipName_DrawToDCClippedRgn, SIP_MLMETH_CAST(meth_wxPseudoDC_DrawToDCClippedRgn), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_DrawToDCClippedRgn},
    {sipName_FindObjects, SIP_MLMETH_CAST(meth_wxPseudoDC_FindObjects), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_FindObjects},
    {sipName_FindObjectsByBBox, SIP_MLMETH_CAST(meth_wxPseudoDC_FindObjectsByBBox), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_FindObjectsByBBox},
    {sipName_FloodFill, SIP_MLMETH_CAST(meth_wxPseudoDC_FloodFill), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_FloodFill},
    {sipName_GetIdBounds, SIP_MLMETH_CAST(meth_wxPseudoDC_GetIdBounds), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_GetIdBounds},
    {sipName_GetIdGreyedOut, SIP_MLMETH_CAST(meth_wxPseudoDC_GetIdGreyedOut), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_GetIdGreyedOut},
    {sipName_GetLen, meth_wxPseudoDC_GetLen, METH_VARARGS, doc_wxPseudoDC_GetLen},
    {sipName_RemoveAll, meth_wxPseudoDC_RemoveAll, METH_VARARGS, doc_wxPseudoDC_RemoveAll},
    {sipName_RemoveId, SIP_MLMETH_CAST(meth_wxPseudoDC_RemoveId), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_RemoveId},
    {sipName_SetBackground, SIP_MLMETH_CAST(meth_wxPseudoDC_SetBackground), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetBackground},
    {sipName_SetBackgroundMode, SIP_MLMETH_CAST(meth_wxPseudoDC_SetBackgroundMode), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetBackgroundMode},
    {sipName_SetBrush, SIP_MLMETH_CAST(meth_wxPseudoDC_SetBrush), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetBrush},
    {sipName_SetFont, SIP_MLMETH_CAST(meth_wxPseudoDC_SetFont), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetFont},
    {sipName_SetId, SIP_MLMETH_CAST(meth_wxPseudoDC_SetId), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetId},
    {sipName_SetIdBounds, SIP_MLMETH_CAST(meth_wxPseudoDC_SetIdBounds), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetIdBounds},
    {sipName_SetIdGreyedOut, SIP_MLMETH_CAST(meth_wxPseudoDC_SetIdGreyedOut), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetIdGreyedOut},
    {sipName_SetLogicalFunction, SIP_MLMETH_CAST(meth_wxPseudoDC_SetLogicalFunction), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetLogicalFunction},
    {sipName_SetPen, SIP_MLMETH_CAST(meth_wxPseudoDC_SetPen), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetPen},
    {sipName_SetTextBackground, SIP_MLMETH_CAST(meth_wxPseudoDC_SetTextBackground), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetTextBackground},
    {sipName_SetTextForeground, SIP_MLMETH_CAST(meth_wxPseudoDC_SetTextForeground), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_SetTextForeground},
    {sipName_TranslateId, SIP_MLMETH_CAST(meth_wxPseudoDC_TranslateId), METH_VARARGS|METH_KEYWORDS, doc_wxPseudoDC_TranslateId}
};

sipVariableDef variables_wxPseudoDC[] = {
    {PropertyVariable, sipName_Len, &methods_wxPseudoDC[29], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxPseudoDC, "PseudoDC()\n"
"\n"
"A PseudoDC is an object that can be used much like real\n"
":class:`wx.DC`, however it provides some additional features for\n"
"object recording and manipulation beyond what a ``wx.DC`` can\n"
"provide.\n"
"\n"
"All commands issued to the ``PseudoDC`` are stored in a list.  You\n"
"can then play these commands back to a real DC object as often as\n"
"needed, using the :meth:`DrawToDC` method or one of the similar\n"
"methods.  Commands in the command list can be tagged by an ID. You\n"
"can use this ID to clear the operations associated with a single\n"
"ID, redraw the objects associated with that ID, grey them, adjust\n"
"their position, etc.");


sipClassTypeDef sipTypeDef__adv_wxPseudoDC = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxPseudoDC,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_PseudoDC,
        {0, 0, 1},
        44, methods_wxPseudoDC,
        0, SIP_NULLPTR,
        1, variables_wxPseudoDC,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPseudoDC,
    -1,
    -1,
    supers_wxPseudoDC,
    SIP_NULLPTR,
    init_type_wxPseudoDC,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxPseudoDC,
    assign_wxPseudoDC,
    array_wxPseudoDC,
    copy_wxPseudoDC,
    release_wxPseudoDC,
    cast_wxPseudoDC,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
