/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/fontdata.h>
        #include <wx/font.h>
        #include <wx/colour.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxFontData_EnableEffects, "EnableEffects(enable)\n"
"\n"
"Enables or disables \"effects\" under Windows or generic only.");

extern "C" {static PyObject *meth_wxFontData_EnableEffects(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_EnableEffects(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool enable;
        ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxFontData, &sipCpp, &enable))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnableEffects(enable);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_EnableEffects, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_GetAllowSymbols, "GetAllowSymbols() -> bool\n"
"\n"
"Under Windows, returns a flag determining whether symbol fonts can be\n"
"selected.");

extern "C" {static PyObject *meth_wxFontData_GetAllowSymbols(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetAllowSymbols(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetAllowSymbols();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetAllowSymbols, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_GetChosenFont, "GetChosenFont() -> Font\n"
"\n"
"Gets the font chosen by the user if the user pressed OK\n"
"(wxFontDialog::ShowModal() returned wxID_OK).");

extern "C" {static PyObject *meth_wxFontData_GetChosenFont(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetChosenFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->GetChosenFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetChosenFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_GetColour, "GetColour() -> Colour\n"
"\n"
"Gets the colour associated with the font dialog.");

extern "C" {static PyObject *meth_wxFontData_GetColour(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_GetEnableEffects, "GetEnableEffects() -> bool\n"
"\n"
"Determines whether \"effects\" are enabled under Windows.");

extern "C" {static PyObject *meth_wxFontData_GetEnableEffects(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetEnableEffects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEnableEffects();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetEnableEffects, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_GetRestrictSelection, "GetRestrictSelection() -> int\n"
"\n"
"Returns the state of the flags restricting the selection.");

extern "C" {static PyObject *meth_wxFontData_GetRestrictSelection(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetRestrictSelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRestrictSelection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetRestrictSelection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_GetInitialFont, "GetInitialFont() -> Font\n"
"\n"
"Gets the font that will be initially used by the font dialog.");

extern "C" {static PyObject *meth_wxFontData_GetInitialFont(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetInitialFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxFont(sipCpp->GetInitialFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetInitialFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_GetShowHelp, "GetShowHelp() -> bool\n"
"\n"
"Returns true if the Help button will be shown (Windows only).");

extern "C" {static PyObject *meth_wxFontData_GetShowHelp(PyObject *, PyObject *);}
static PyObject *meth_wxFontData_GetShowHelp(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFontData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxFontData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetShowHelp();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_GetShowHelp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_RestrictSelection, "RestrictSelection(flags)\n"
"\n"
"Restricts the selection to a subset of the available fonts.");

extern "C" {static PyObject *meth_wxFontData_RestrictSelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_RestrictSelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags;
        ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxFontData, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RestrictSelection(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_RestrictSelection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_SetAllowSymbols, "SetAllowSymbols(allowSymbols)\n"
"\n"
"Under Windows, determines whether symbol fonts can be selected.");

extern "C" {static PyObject *meth_wxFontData_SetAllowSymbols(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetAllowSymbols(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool allowSymbols;
        ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_allowSymbols,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxFontData, &sipCpp, &allowSymbols))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAllowSymbols(allowSymbols);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetAllowSymbols, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_SetChosenFont, "SetChosenFont(font)\n"
"\n"
"Sets the font that will be returned to the user (for internal use\n"
"only).");

extern "C" {static PyObject *meth_wxFontData_SetChosenFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetChosenFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont* font;
        ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxFontData, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetChosenFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetChosenFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_SetColour, "SetColour(colour)\n"
"\n"
"Sets the colour that will be used for the font foreground colour.");

extern "C" {static PyObject *meth_wxFontData_SetColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxColour* colour;
        int colourState = 0;
        ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_colour,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxFontData, &sipCpp, sipType_wxColour, &colour, &colourState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetColour(*colour);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_SetInitialFont, "SetInitialFont(font)\n"
"\n"
"Sets the font that will be initially used by the font dialog.");

extern "C" {static PyObject *meth_wxFontData_SetInitialFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetInitialFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxFont* font;
        ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxFontData, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetInitialFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetInitialFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_SetRange, "SetRange(min, max)\n"
"\n"
"Sets the valid range for the font point size (Windows only).");

extern "C" {static PyObject *meth_wxFontData_SetRange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetRange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int min;
        int max;
        ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_min,
            sipName_max,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxFontData, &sipCpp, &min, &max))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRange(min, max);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetRange, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxFontData_SetShowHelp, "SetShowHelp(showHelp)\n"
"\n"
"Determines whether the Help button will be displayed in the font\n"
"dialog (Windows only).");

extern "C" {static PyObject *meth_wxFontData_SetShowHelp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxFontData_SetShowHelp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool showHelp;
        ::wxFontData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_showHelp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxFontData, &sipCpp, &showHelp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetShowHelp(showHelp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_FontData, sipName_SetShowHelp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxFontData(void *, const sipTypeDef *);}
static void *cast_wxFontData(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxFontData *sipCpp = reinterpret_cast<::wxFontData *>(sipCppV);

    if (targetType == sipType_wxFontData)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast<::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxFontData(void *, int);}
static void release_wxFontData(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxFontData *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxFontData(Py_ssize_t);}
static void *array_wxFontData(Py_ssize_t sipNrElem)
{
    return new ::wxFontData[sipNrElem];
}


extern "C" {static void assign_wxFontData(void *, Py_ssize_t, void *);}
static void assign_wxFontData(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxFontData *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxFontData *>(sipSrc);
}


extern "C" {static void *copy_wxFontData(const void *, Py_ssize_t);}
static void *copy_wxFontData(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxFontData(reinterpret_cast<const ::wxFontData *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxFontData(sipSimpleWrapper *);}
static void dealloc_wxFontData(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxFontData(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxFontData(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxFontData(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxFontData *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFontData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxFontData* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxFontData, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxFontData(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxFontData[] = {{392, 255, 1}};


static PyMethodDef methods_wxFontData[] = {
    {sipName_EnableEffects, SIP_MLMETH_CAST(meth_wxFontData_EnableEffects), METH_VARARGS|METH_KEYWORDS, doc_wxFontData_EnableEffects},
    {sipName_GetAllowSymbols, meth_wxFontData_GetAllowSymbols, METH_VARARGS, doc_wxFontData_GetAllowSymbols},
    {sipName_GetChosenFont, meth_wxFontData_GetChosenFont, METH_VARARGS, doc_wxFontData_GetChosenFont},
    {sipName_GetColour, meth_wxFontData_GetColour, METH_VARARGS, doc_wxFontData_GetColour},
    {sipName_GetEnableEffects, meth_wxFontData_GetEnableEffects, METH_VARARGS, doc_wxFontData_GetEnableEffects},
    {sipName_GetInitialFont, meth_wxFontData_GetInitialFont, METH_VARARGS, doc_wxFontData_GetInitialFont},
    {sipName_GetRestrictSelection, meth_wxFontData_GetRestrictSelection, METH_VARARGS, doc_wxFontData_GetRestrictSelection},
    {sipName_GetShowHelp, meth_wxFontData_GetShowHelp, METH_VARARGS, doc_wxFontData_GetShowHelp},
    {sipName_RestrictSelection, SIP_MLMETH_CAST(meth_wxFontData_RestrictSelection), METH_VARARGS|METH_KEYWORDS, doc_wxFontData_RestrictSelection},
    {sipName_SetAllowSymbols, SIP_MLMETH_CAST(meth_wxFontData_SetAllowSymbols), METH_VARARGS|METH_KEYWORDS, doc_wxFontData_SetAllowSymbols},
    {sipName_SetChosenFont, SIP_MLMETH_CAST(meth_wxFontData_SetChosenFont), METH_VARARGS|METH_KEYWORDS, doc_wxFontData_SetChosenFont},
    {sipName_SetColour, SIP_MLMETH_CAST(meth_wxFontData_SetColour), METH_VARARGS|METH_KEYWORDS, doc_wxFontData_SetColour},
    {sipName_SetInitialFont, SIP_MLMETH_CAST(meth_wxFontData_SetInitialFont), METH_VARARGS|METH_KEYWORDS, doc_wxFontData_SetInitialFont},
    {sipName_SetRange, SIP_MLMETH_CAST(meth_wxFontData_SetRange), METH_VARARGS|METH_KEYWORDS, doc_wxFontData_SetRange},
    {sipName_SetShowHelp, SIP_MLMETH_CAST(meth_wxFontData_SetShowHelp), METH_VARARGS|METH_KEYWORDS, doc_wxFontData_SetShowHelp}
};

sipVariableDef variables_wxFontData[] = {
    {PropertyVariable, sipName_ShowHelp, &methods_wxFontData[7], &methods_wxFontData[14], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_InitialFont, &methods_wxFontData[5], &methods_wxFontData[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Colour, &methods_wxFontData[3], &methods_wxFontData[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ChosenFont, &methods_wxFontData[2], &methods_wxFontData[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_AllowSymbols, &methods_wxFontData[1], &methods_wxFontData[9], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxFontData, "FontData()\n"
"\n"
"This class holds a variety of information related to font dialogs.");


sipClassTypeDef sipTypeDef__core_wxFontData = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxFontData,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_FontData,
        {0, 0, 1},
        15, methods_wxFontData,
        0, SIP_NULLPTR,
        5, variables_wxFontData,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxFontData,
    -1,
    -1,
    supers_wxFontData,
    SIP_NULLPTR,
    init_type_wxFontData,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxFontData,
    assign_wxFontData,
    array_wxFontData,
    copy_wxFontData,
    release_wxFontData,
    cast_wxFontData,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
