// Copyright (c) 2014-2020 Thomas Fussell
// Copyright (c) 2010-2015 openpyxl
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, WRISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE
//
// @license: http://www.opensource.org/licenses/mit-license.php
// @author: see AUTHORS file

#include <xlnt/styles/protection.hpp>

namespace xlnt {

protection protection::unlocked_and_visible()
{
    return protection();
}

protection protection::locked_and_visible()
{
    return protection().locked(true);
}

protection protection::unlocked_and_hidden()
{
    return protection().hidden(true);
}

protection protection::locked_and_hidden()
{
    return protection().locked(true).hidden(true);
}

protection::protection()
    : locked_(false), hidden_(false)
{
}

bool protection::locked() const
{
    return locked_;
}

protection &protection::locked(bool locked)
{
    locked_ = locked;
    return *this;
}

bool protection::hidden() const
{
    return hidden_;
}

protection &protection::hidden(bool hidden)
{
    hidden_ = hidden;
    return *this;
}

bool protection::operator==(const protection &other) const
{
    return locked_ == other.locked_ && hidden_ == other.hidden_;
}

bool protection::operator!=(const protection &other) const
{
    return !(*this == other);
}

} // namespace xlnt
