
 COIN-OR has chosen to make the [Doxygen](http://www.stack.nl/~dimitri/doxygen/) program for in-code documentation our standard documentation system. Support for generating documentation using [Doxygen](http://www.stack.nl/~dimitri/doxygen/) is provided automatically as part of the standard build harness if you follow these guidelines. Briefly, documentation is generated by scanning source files (by default, only `.h` and `.hpp` files) which have been annotated with comments and doxygen markup. As an example, here's the [doxygen documentation generated for Osi](http://www.coin-or.org/Doxygen/Osi/index.html). Complete [on-line doxygen documentation](http://www.stack.nl/~dimitri/doxygen/manual.html) is available there.

Doxygen documentation can be built and installed just as the code is built and installed. Doxygen documentation for a given project or package can be linked with doxygen documentation for other projects or packages, within the limits of doxygen's ability.

*NOTE*: This page describes procedures for generating doxygen documentation available with BuildTools >= 0.8. Most of what is written here is also valid for BuildTools >= 0.6.

To use doxygen within the COIN-OR build system, you should first document your code using doxygen markup. Doxygen markup is designed to be minimally intrusive and works well with common styles of in-code documentation. Even with zero markup, doxygen will still generate minimal documentation showing classes and structures, their members, and their interrelationships (_e.g._, [DyLP](http://www.coin-or.org/Doxygen/DyLP)). Consult the source code for any of the COIN-OR projects that have documentation [here](http://www.coin-or.org/Doxygen).

For the remainder of this page, [Osi](https://projects.coin-or.org/Osi) will be the running example.
Replace 'Osi' with the name of your project. Consult the various files referenced below for examples.


## Setting Up

These steps have already been completed for most projects that use the common build system, so if you are just attempting to generate documentation, please skip to the section on building and installing.


### Step 1: Add `doxygen.conf.in` to repository
The first step in setting things up is to add doxygen configuration files in the proper places in order to control the documentation that doxygen produces. As with many other files, these configuration files are customized and automatically generated by the `configure` script, so you're going to be adding autoconf files named `doxygen.conf.in` to your repository. You'll have either one or two of these, depending on your desired usage. The first will be at the top level of the project's package, `Osi/doxydoc/doxygen.conf.in` (this one is optional), and the second will be in the project's main directory, `Osi/Osi/doxydoc/doxygen.conf.in`. The former configuration file can be used to build a monolithic documentation package including all dependencies in a single documentation package. The second is used to build documentation just for the package itself, treating other packages as externals. If you're starting from scratch, you can get samples of the `doxygen.conf.in` files from another project that is already set up and modify them, just to ensure that you have the most current version. For convenience, however, vanilla [package](pm-doxygen/doxygen.conf.in.pkg) and [project](pm-doxygen/doxygen.conf.in.proj) configuration files are attached to this page. There are only two differences:
 * In the package file, `INPUT = `@`abs_top_srcdir`@``; in the project file, `INPUT = `@`abs_top_srcdir`@`/src`. Thus the project file will include only the project's base source code. The package file will also pick up unit tests, examples, _etc._
 * In the package file, `EXCLUDE_PATTERNS = */.svn* `@`coin_doxy_excludes`@``; in the project file, `EXCLUDE_PATTERNS = */.svn*`. This allows configuration to exclude the source code of externals, so that it is not processed a second time at the package level. (For technical reasons, the job of ensuring that the project's base source code is not processed twice is handled by `Makefile.am`. There are some other fine points; consult the macro definition in [coin.m4](../tree/master/trunk/coin.m4) if you're interested.) Be careful to put the package and project files in the correct places!

Once you've installed the `doxygen.conf.in` files, you may wish to adjust them for your project's code. In particular, look at the section titled `Configuration options related to the preprocessor' and consider whether you want to instruct doxygen to consider compilation-time macro definitions.
For example, the entire content of `OsiDylpSolverInterface.hpp` is wrapped with `#ifdef COIN_HAS_DYLP ... #endif`. The project-level `doxygen.conf.in` file includes
```
PREDEFINED = COIN_HAS_DYLP
```
Without this, doxygen would simply see an empty file.


### Step 2: Modify `configure.ac`

The `AC_COIN_DOXYGEN` macro is provided to configure doxygen processing and to automatically locate the documentation for any externals. The parameter is a space-separated list of other projects whose doxygen documentation should be linked with the documentation of the current project. For example, the Osi library depends on CoinUtils, and the project-level `configure.ac` specifies this dependency as
```
AC_COIN_DOXYGEN(CoinUtils)
```
The Osi package takes a broader view. There are many implementations of the Osi interface, and it's useful, when browsing the Osi documentation, to be aware of them. The package level `configure.ac` specifies the relevant projects so that doxygen can determine which projects reimplement a particular method:
```
AC_COIN_DOXYGEN(CoinUtils Cgl Clp DyLP Vol SYMPHONY)
```
Doxygen is quite forgiving when it comes to linking with other doxygen documentation; if it can't find a tag file that it wants for linking, you'll get a warning in the log file, but that's all. However, doxygen does not do any sort of global linking, nor does it rebuild documentation that is the target of a link. It looks in a specified tag file for a match; if it finds one, it generates a link. The net effect is that it may take a few iterations of building and installing the doxygen documentation before all links are in place.

In addition to a call to `AC_COIN_DOXYGEN`, you'll need to add a call to `AC_CONFIG_FILES` so that `configure` will process `doxygen.conf.in` into `doxygen.conf`
```
AC_CONFIG_FILES([doxydoc/doxygen.conf])
```
This will be the same in the package- and project-level `configure.ac` files.

Configuration sets a number of variables in the `doxydoc.conf.in` files so that doxygen can locate source code and the tag files that allow linking with other projects' documentation.
There's one other configuration option, `--with-dot`, which controls doxygen's generation of inheritance and collaboration graphs. This is on by default but somewhat expensive; to disable it specify `--without-dot` as a configure option. `Configure` will check for the dot tool (part of the [graphviz](http://www.graphviz.org) package) and will disable use of dot if it's not found. It will also look for LaTeX, since that can be used to build PDF documentation.


### Step 3: Add Targets to `Makefile.am` (Optional)

This optional step is to add the necessary lines to the package- and project-level `Makefile.am` to build and install the doxygen documentation. This step is optional beginning with version 0.8.4, since targets for generating doxygen documentation are now automatically added to `Makefile.am` when including `Makemain.inc`. If you want to add your own targets, the best approach is to go and look at a project that's already set up. But for convenience, here are the relevant portions from the Osi `Makefile.am` files.

In the package-level `Makefile.am`, add
```
# Generate doxygen doc'n in subdirectories (except `@`PACKAGE_NAME`@`) if a doxydoc
# directory is present, then do the base, if present.

doxydoc:
        for dir in $(subdirs) ; do \
          if test $$dir != `@`PACKAGE_NAME`@` && test -r $$dir/doxydoc ; then \
            (cd $$dir ; $(MAKE) doxydoc) \
          fi ; \
        done ; \
        if test -r doxydoc/doxygen.conf ; then \
          doxygen doxydoc/doxygen.conf ; \
        fi

clean-doxydoc:
        ( cd doxydoc ; rm -rf html *.log *.tag )

# DocInstallDir is defined in Makemain.inc and is specific to the package.
# For the short term, adopt the notion that we install only the package
# doxydoc.

install-doxydoc: doxydoc
        if test -r doxydoc/doxygen.conf ; then \
          $(mkdir_p) $(DocInstallDir) ; \
          cp -R doxydoc $(DocInstallDir) ; \
        fi

uninstall-doxydoc:
        rm -rf $(DocInstallDir)/doxydoc

clean-local: clean-doxydoc
uninstall-local: uninstall-doxydoc
```
Add `doxydoc` to the list of `.PHONY` targets.

For the project-level `Makefile.am`, add
```
# Doxygen documentation

doxydoc:
        doxygen doxydoc/doxygen.conf

clean-doxydoc:
        ( cd doxydoc ; rm -rf html *.log *.tag )
```
Add `doxydoc` to the list of `.PHONY` targets, and add `clean-doxydoc` to the list of `clean-local` targets.


## Building and Installing Documentation


### Automatically generated targets

 1. The `Makefile` in the project's subdirectory has a target `doxygen-docs` that builds the Doxygen documentation for that project only, treating other projects as externals. Making this target will also create a tags file named `doxydoc/xyz_doxy.tags` that will be used to link the Doxygen documentation of other projects. There is also a target `pdf-doxygen-docs` that will build a PDF version of the documentation if that is desired.
 1. At configure time, the `AC_COIN_DOXYGEN` macro tries to locate where the tags files for other projects should be found. If we are doing a monolithic build and the source tree is laid out according to the "classic" repository layout, then we link each project's documentation using the tags fle of other dependent projects in the build directory. If not, we look for the tags files in the the data installation directory (see below for what gets installed where). The links generated in either case, however, are relative, so the documentation should link properly both before and after installation and should be completely portable, as long as all doxydoc directories are moved together.
 1. The `Makefile` in the project root directory has targets `all-doxygen-docs` and `all-pdf-doxygen-docs` that will just recursively call the respective commands in each of the subdirectories. As long as the documentation for projects is built in the right order (so that the tags file for each project's dependencies exists when the documentation for that project is built), there is no need for any sort of "monolithic" build of documentation anymore. Everything should work with documentation just as with source---build in the right order and everything links together.


### Installing documentation

 1. For now, the documentation does not get built and installed as part of `make install`, since it is a bit of a pain to have the documentation re-built every time a change in the source is made and new binaries are installed. 
 1. The `Makefile` in the project's subdirectory has targets `install-doxygen-docs` and `install-all-doxygen-docs` that will install all existing documentation (both PDF and HTML) and the tags file in the `doxydoc/` subdirectory to the documentation install directory (`<prefix>/share/coin/doc/Xyz` by default).







---

Attachments:
 * [doxygen.conf.in.pkg](pm-doxygen/doxygen.conf.in.pkg)
 * [doxygen.conf.in.proj](pm-doxygen/doxygen.conf.in.proj)
