#ifndef GODOT_CPP_NAVIGATION2DSERVER_HPP
#define GODOT_CPP_NAVIGATION2DSERVER_HPP


#include <gdnative_api_struct.gen.h>
#include <cstdint>

#include <core/CoreTypes.hpp>
#include <core/Ref.hpp>

#include "Object.hpp"
namespace godot {

class Object;
class NavigationPolygon;

class Navigation2DServer : public Object {
	static Navigation2DServer *_singleton;

	Navigation2DServer();

	struct ___method_bindings {
		godot_method_bind *mb__emit_map_changed;
		godot_method_bind *mb_agent_create;
		godot_method_bind *mb_agent_get_map;
		godot_method_bind *mb_agent_is_map_changed;
		godot_method_bind *mb_agent_set_callback;
		godot_method_bind *mb_agent_set_map;
		godot_method_bind *mb_agent_set_max_neighbors;
		godot_method_bind *mb_agent_set_max_speed;
		godot_method_bind *mb_agent_set_neighbor_dist;
		godot_method_bind *mb_agent_set_position;
		godot_method_bind *mb_agent_set_radius;
		godot_method_bind *mb_agent_set_target_velocity;
		godot_method_bind *mb_agent_set_time_horizon;
		godot_method_bind *mb_agent_set_velocity;
		godot_method_bind *mb_free_rid;
		godot_method_bind *mb_get_maps;
		godot_method_bind *mb_map_create;
		godot_method_bind *mb_map_force_update;
		godot_method_bind *mb_map_get_agents;
		godot_method_bind *mb_map_get_cell_height;
		godot_method_bind *mb_map_get_cell_size;
		godot_method_bind *mb_map_get_closest_point;
		godot_method_bind *mb_map_get_closest_point_owner;
		godot_method_bind *mb_map_get_edge_connection_margin;
		godot_method_bind *mb_map_get_path;
		godot_method_bind *mb_map_get_regions;
		godot_method_bind *mb_map_is_active;
		godot_method_bind *mb_map_set_active;
		godot_method_bind *mb_map_set_cell_height;
		godot_method_bind *mb_map_set_cell_size;
		godot_method_bind *mb_map_set_edge_connection_margin;
		godot_method_bind *mb_region_create;
		godot_method_bind *mb_region_get_connection_pathway_end;
		godot_method_bind *mb_region_get_connection_pathway_start;
		godot_method_bind *mb_region_get_connections_count;
		godot_method_bind *mb_region_get_enter_cost;
		godot_method_bind *mb_region_get_map;
		godot_method_bind *mb_region_get_navigation_layers;
		godot_method_bind *mb_region_get_travel_cost;
		godot_method_bind *mb_region_owns_point;
		godot_method_bind *mb_region_set_enter_cost;
		godot_method_bind *mb_region_set_map;
		godot_method_bind *mb_region_set_navigation_layers;
		godot_method_bind *mb_region_set_navpoly;
		godot_method_bind *mb_region_set_transform;
		godot_method_bind *mb_region_set_travel_cost;
	};
	static ___method_bindings ___mb;
	static void *_detail_class_tag;

public:
	static void ___init_method_bindings();
	inline static size_t ___get_id() { return (size_t)_detail_class_tag; }

	static inline Navigation2DServer *get_singleton()
	{
		if (!Navigation2DServer::_singleton) {
			Navigation2DServer::_singleton = new Navigation2DServer;
		}
		return Navigation2DServer::_singleton;
	}

	static inline const char *___get_class_name() { return (const char *) "Navigation2DServer"; }
	static inline const char *___get_godot_class_name() { return (const char *) "Navigation2DServer"; }
	static inline Object *___get_from_variant(Variant a) { godot_object *o = (godot_object*) a; return (o) ? (Object *) godot::nativescript_1_1_api->godot_nativescript_get_instance_binding_data(godot::_RegisterState::language_index, o) : nullptr; }

	// enums

	// constants

	// methods
	void _emit_map_changed(const RID arg0);
	RID agent_create() const;
	RID agent_get_map(const RID agent) const;
	bool agent_is_map_changed(const RID agent) const;
	void agent_set_callback(const RID agent, const Object *receiver, const String method, const Variant userdata = Variant()) const;
	void agent_set_map(const RID agent, const RID map) const;
	void agent_set_max_neighbors(const RID agent, const int64_t count) const;
	void agent_set_max_speed(const RID agent, const real_t max_speed) const;
	void agent_set_neighbor_dist(const RID agent, const real_t dist) const;
	void agent_set_position(const RID agent, const Vector2 position) const;
	void agent_set_radius(const RID agent, const real_t radius) const;
	void agent_set_target_velocity(const RID agent, const Vector2 target_velocity) const;
	void agent_set_time_horizon(const RID agent, const real_t time) const;
	void agent_set_velocity(const RID agent, const Vector2 velocity) const;
	void free_rid(const RID rid) const;
	Array get_maps() const;
	RID map_create() const;
	void map_force_update(const RID map);
	Array map_get_agents(const RID map) const;
	real_t map_get_cell_height(const RID map) const;
	real_t map_get_cell_size(const RID map) const;
	Vector2 map_get_closest_point(const RID map, const Vector2 to_point) const;
	RID map_get_closest_point_owner(const RID map, const Vector2 to_point) const;
	real_t map_get_edge_connection_margin(const RID map) const;
	PoolVector2Array map_get_path(const RID map, const Vector2 origin, const Vector2 destination, const bool optimize, const int64_t navigation_layers = 1) const;
	Array map_get_regions(const RID map) const;
	bool map_is_active(const RID map) const;
	void map_set_active(const RID map, const bool active) const;
	void map_set_cell_height(const RID map, const real_t cell_height) const;
	void map_set_cell_size(const RID map, const real_t cell_size) const;
	void map_set_edge_connection_margin(const RID map, const real_t margin) const;
	RID region_create() const;
	Vector2 region_get_connection_pathway_end(const RID region, const int64_t connection) const;
	Vector2 region_get_connection_pathway_start(const RID region, const int64_t connection) const;
	int64_t region_get_connections_count(const RID region) const;
	real_t region_get_enter_cost(const RID region) const;
	RID region_get_map(const RID region) const;
	int64_t region_get_navigation_layers(const RID region) const;
	real_t region_get_travel_cost(const RID region) const;
	bool region_owns_point(const RID region, const Vector2 point) const;
	void region_set_enter_cost(const RID region, const real_t enter_cost) const;
	void region_set_map(const RID region, const RID map) const;
	void region_set_navigation_layers(const RID region, const int64_t navigation_layers) const;
	void region_set_navpoly(const RID region, const Ref<NavigationPolygon> nav_poly) const;
	void region_set_transform(const RID region, const Transform2D transform) const;
	void region_set_travel_cost(const RID region, const real_t travel_cost) const;

};

}

#endif