%feature("docstring") OT::PenalizedLeastSquaresAlgorithm
"Penalized least squares algorithm.

Refer to :ref:`least_squares`.

Available constructors:
    PenalizedLeastSquaresAlgorithm(*x, y, psi, indices, penalizationFactor=0, useNormal=False*)

    PenalizedLeastSquaresAlgorithm(*x, y, weight, psi, indices, penalizationFactor=0, useNormal=False*)

    PenalizedLeastSquaresAlgorithm(*x, y, weight, psi, indices, penalizationFactor=0, penalizationMatrix, useNormal=False*)

Parameters
----------
x : :class:`~openturns.Sample`
    Input sample
y : :class:`~openturns.Sample`
    Output sample
weight : sequence of float
    Output weights
psi : sequence of :class:`~openturns.Function`
    Basis
indices : sequence of int
    Indices allowed in the basis
penalizationFactor : float, optional
    Penalization factor
penalizationMatrix : 2-d sequence of float
    Penalization matrix
useNormal : bool, optional
    Solve the normal equation

See also
--------
ApproximationAlgorithm, LeastSquaresMetaModelSelection

Notes
-----
Solve the least-squares problem:

.. math::

    \\vect{a} = \\argmin_{\\vect{b} \\in \\Rset^P} ||y - \\vect{b}^{\\intercal} \\vect{\\Psi}(\\vect{U})||^2
"
