#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtaltvapply_ PETSCDTALTVAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtaltvapply_ petscdtaltvapply
#endif
PETSC_EXTERN void petscdtaltvapply_(PetscInt *a, PetscInt *b, const PetscReal *c, const PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDTAltVApply(*a, *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtaltvwedge_ PETSCDTALTVWEDGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtaltvwedge_ petscdtaltvwedge
#endif
PETSC_EXTERN void petscdtaltvwedge_(PetscInt *a, PetscInt *b, PetscInt *c, const PetscReal *d, const PetscReal *e, PetscReal *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  *ierr = PetscDTAltVWedge(*a, *b, *c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtaltvwedgematrix_ PETSCDTALTVWEDGEMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtaltvwedgematrix_ petscdtaltvwedgematrix
#endif
PETSC_EXTERN void petscdtaltvwedgematrix_(PetscInt *a, PetscInt *b, PetscInt *c, const PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDTAltVWedgeMatrix(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtaltvpullback_ PETSCDTALTVPULLBACK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtaltvpullback_ petscdtaltvpullback
#endif
PETSC_EXTERN void petscdtaltvpullback_(PetscInt *a, PetscInt *b, const PetscReal *c, PetscInt *d, const PetscReal *e, PetscReal *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  *ierr = PetscDTAltVPullback(*a, *b, c, *d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtaltvpullbackmatrix_ PETSCDTALTVPULLBACKMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtaltvpullbackmatrix_ petscdtaltvpullbackmatrix
#endif
PETSC_EXTERN void petscdtaltvpullbackmatrix_(PetscInt *a, PetscInt *b, const PetscReal *c, PetscInt *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDTAltVPullbackMatrix(*a, *b, c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtaltvinterior_ PETSCDTALTVINTERIOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtaltvinterior_ petscdtaltvinterior
#endif
PETSC_EXTERN void petscdtaltvinterior_(PetscInt *a, PetscInt *b, const PetscReal *c, const PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDTAltVInterior(*a, *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtaltvinteriormatrix_ PETSCDTALTVINTERIORMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtaltvinteriormatrix_ petscdtaltvinteriormatrix
#endif
PETSC_EXTERN void petscdtaltvinteriormatrix_(PetscInt *a, PetscInt *b, const PetscReal *c, PetscReal *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  *ierr = PetscDTAltVInteriorMatrix(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdtaltvstar_ PETSCDTALTVSTAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdtaltvstar_ petscdtaltvstar
#endif
PETSC_EXTERN void petscdtaltvstar_(PetscInt *a, PetscInt *b, PetscInt *c, const PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  *ierr = PetscDTAltVStar(*a, *b, *c, d, e);
  if (*ierr) return;
}
