#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdacreatepatchis_ DMDACREATEPATCHIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdacreatepatchis_ dmdacreatepatchis
#endif
PETSC_EXTERN void dmdacreatepatchis_(DM *a, MatStencil *b, MatStencil *c, IS *d, PetscBool *e, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMDACreatePatchIS(*a, b, c, d, *e ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
