#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateexodusfromfile_ DMPLEXCREATEEXODUSFROMFILE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateexodusfromfile_ dmplexcreateexodusfromfile
#endif
PETSC_EXTERN void dmplexcreateexodusfromfile_(MPI_Fint *a, char b[], PetscBool *c, DM *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateExodusFromFile(MPI_Comm_f2c(*(a)), c_b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiigetid_ PETSCVIEWEREXODUSIIGETID
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiigetid_ petscviewerexodusiigetid
#endif
PETSC_EXTERN void petscviewerexodusiigetid_(PetscViewer *a, int *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIIGetId(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiisetorder_ PETSCVIEWEREXODUSIISETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiisetorder_ petscviewerexodusiisetorder
#endif
PETSC_EXTERN void petscviewerexodusiisetorder_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIISetOrder(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiigetorder_ PETSCVIEWEREXODUSIIGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiigetorder_ petscviewerexodusiigetorder
#endif
PETSC_EXTERN void petscviewerexodusiigetorder_(PetscViewer *a, PetscInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscViewerExodusIIGetOrder(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiiopen_ PETSCVIEWEREXODUSIIOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiiopen_ petscviewerexodusiiopen
#endif
PETSC_EXTERN void petscviewerexodusiiopen_(MPI_Fint *a, char b[], PetscFileMode *c, PetscViewer *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscViewerExodusIIOpen(MPI_Comm_f2c(*(a)), c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
