#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsorgetsymmetric_ PCSORGETSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsorgetsymmetric_ pcsorgetsymmetric
#endif
PETSC_EXTERN void pcsorgetsymmetric_(PC *a, MatSORType *b, PetscErrorCode *ierr)
{
  *ierr = PCSORGetSymmetric(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsorgetomega_ PCSORGETOMEGA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsorgetomega_ pcsorgetomega
#endif
PETSC_EXTERN void pcsorgetomega_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PCSORGetOmega(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsorgetiterations_ PCSORGETITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsorgetiterations_ pcsorgetiterations
#endif
PETSC_EXTERN void pcsorgetiterations_(PC *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = PCSORGetIterations(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsorsetsymmetric_ PCSORSETSYMMETRIC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsorsetsymmetric_ pcsorsetsymmetric
#endif
PETSC_EXTERN void pcsorsetsymmetric_(PC *a, MatSORType *b, PetscErrorCode *ierr)
{
  *ierr = PCSORSetSymmetric(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsorsetomega_ PCSORSETOMEGA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsorsetomega_ pcsorsetomega
#endif
PETSC_EXTERN void pcsorsetomega_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCSORSetOmega(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcsorsetiterations_ PCSORSETITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcsorsetiterations_ pcsorsetiterations
#endif
PETSC_EXTERN void pcsorsetiterations_(PC *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = PCSORSetIterations(*a, *b, *c);
  if (*ierr) return;
}
