#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbyteswap_ PETSCBYTESWAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbyteswap_ petscbyteswap
#endif
PETSC_EXTERN void petscbyteswap_(void *a, PetscDataType *b, PetscCount *c, PetscErrorCode *ierr)
{
  *ierr = PetscByteSwap(a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbinaryopen_ PETSCBINARYOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbinaryopen_ petscbinaryopen
#endif
PETSC_EXTERN void petscbinaryopen_(char a[], PetscFileMode *b, int *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscBinaryOpen(c_a, *b, c);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbinaryclose_ PETSCBINARYCLOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbinaryclose_ petscbinaryclose
#endif
PETSC_EXTERN void petscbinaryclose_(int *a, PetscErrorCode *ierr)
{
  *ierr = PetscBinaryClose(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbinarysynchronizedread_ PETSCBINARYSYNCHRONIZEDREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbinarysynchronizedread_ petscbinarysynchronizedread
#endif
PETSC_EXTERN void petscbinarysynchronizedread_(MPI_Fint *a, int *b, void *c, PetscInt *d, PetscInt *e, PetscDataType *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(e);
  *ierr = PetscBinarySynchronizedRead(MPI_Comm_f2c(*(a)), *b, c, *d, e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbinarysynchronizedwrite_ PETSCBINARYSYNCHRONIZEDWRITE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbinarysynchronizedwrite_ petscbinarysynchronizedwrite
#endif
PETSC_EXTERN void petscbinarysynchronizedwrite_(MPI_Fint *a, int *b, const void *c, PetscInt *d, PetscDataType *e, PetscErrorCode *ierr)
{
  *ierr = PetscBinarySynchronizedWrite(MPI_Comm_f2c(*(a)), *b, c, *d, *e);
  if (*ierr) return;
}
