#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfmaxwellboltzmann1d_ PETSCPDFMAXWELLBOLTZMANN1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfmaxwellboltzmann1d_ petscpdfmaxwellboltzmann1d
#endif
PETSC_EXTERN void petscpdfmaxwellboltzmann1d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFMaxwellBoltzmann1D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccdfmaxwellboltzmann1d_ PETSCCDFMAXWELLBOLTZMANN1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccdfmaxwellboltzmann1d_ petsccdfmaxwellboltzmann1d
#endif
PETSC_EXTERN void petsccdfmaxwellboltzmann1d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscCDFMaxwellBoltzmann1D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfmaxwellboltzmann2d_ PETSCPDFMAXWELLBOLTZMANN2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfmaxwellboltzmann2d_ petscpdfmaxwellboltzmann2d
#endif
PETSC_EXTERN void petscpdfmaxwellboltzmann2d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFMaxwellBoltzmann2D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccdfmaxwellboltzmann2d_ PETSCCDFMAXWELLBOLTZMANN2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccdfmaxwellboltzmann2d_ petsccdfmaxwellboltzmann2d
#endif
PETSC_EXTERN void petsccdfmaxwellboltzmann2d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscCDFMaxwellBoltzmann2D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfmaxwellboltzmann3d_ PETSCPDFMAXWELLBOLTZMANN3D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfmaxwellboltzmann3d_ petscpdfmaxwellboltzmann3d
#endif
PETSC_EXTERN void petscpdfmaxwellboltzmann3d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFMaxwellBoltzmann3D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccdfmaxwellboltzmann3d_ PETSCCDFMAXWELLBOLTZMANN3D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccdfmaxwellboltzmann3d_ petsccdfmaxwellboltzmann3d
#endif
PETSC_EXTERN void petsccdfmaxwellboltzmann3d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscCDFMaxwellBoltzmann3D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfgaussian1d_ PETSCPDFGAUSSIAN1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfgaussian1d_ petscpdfgaussian1d
#endif
PETSC_EXTERN void petscpdfgaussian1d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFGaussian1D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccdfgaussian1d_ PETSCCDFGAUSSIAN1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccdfgaussian1d_ petsccdfgaussian1d
#endif
PETSC_EXTERN void petsccdfgaussian1d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscCDFGaussian1D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfsamplegaussian1d_ PETSCPDFSAMPLEGAUSSIAN1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfsamplegaussian1d_ petscpdfsamplegaussian1d
#endif
PETSC_EXTERN void petscpdfsamplegaussian1d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFSampleGaussian1D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfgaussian2d_ PETSCPDFGAUSSIAN2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfgaussian2d_ petscpdfgaussian2d
#endif
PETSC_EXTERN void petscpdfgaussian2d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFGaussian2D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfsamplegaussian2d_ PETSCPDFSAMPLEGAUSSIAN2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfsamplegaussian2d_ petscpdfsamplegaussian2d
#endif
PETSC_EXTERN void petscpdfsamplegaussian2d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFSampleGaussian2D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfgaussian3d_ PETSCPDFGAUSSIAN3D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfgaussian3d_ petscpdfgaussian3d
#endif
PETSC_EXTERN void petscpdfgaussian3d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFGaussian3D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfsamplegaussian3d_ PETSCPDFSAMPLEGAUSSIAN3D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfsamplegaussian3d_ petscpdfsamplegaussian3d
#endif
PETSC_EXTERN void petscpdfsamplegaussian3d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFSampleGaussian3D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfconstant1d_ PETSCPDFCONSTANT1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfconstant1d_ petscpdfconstant1d
#endif
PETSC_EXTERN void petscpdfconstant1d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFConstant1D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccdfconstant1d_ PETSCCDFCONSTANT1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccdfconstant1d_ petsccdfconstant1d
#endif
PETSC_EXTERN void petsccdfconstant1d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscCDFConstant1D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfsampleconstant1d_ PETSCPDFSAMPLECONSTANT1D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfsampleconstant1d_ petscpdfsampleconstant1d
#endif
PETSC_EXTERN void petscpdfsampleconstant1d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFSampleConstant1D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfconstant2d_ PETSCPDFCONSTANT2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfconstant2d_ petscpdfconstant2d
#endif
PETSC_EXTERN void petscpdfconstant2d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFConstant2D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccdfconstant2d_ PETSCCDFCONSTANT2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccdfconstant2d_ petsccdfconstant2d
#endif
PETSC_EXTERN void petsccdfconstant2d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscCDFConstant2D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfsampleconstant2d_ PETSCPDFSAMPLECONSTANT2D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfsampleconstant2d_ petscpdfsampleconstant2d
#endif
PETSC_EXTERN void petscpdfsampleconstant2d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFSampleConstant2D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfconstant3d_ PETSCPDFCONSTANT3D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfconstant3d_ petscpdfconstant3d
#endif
PETSC_EXTERN void petscpdfconstant3d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFConstant3D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsccdfconstant3d_ PETSCCDFCONSTANT3D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsccdfconstant3d_ petsccdfconstant3d
#endif
PETSC_EXTERN void petsccdfconstant3d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscCDFConstant3D(a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdt.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscpdfsampleconstant3d_ PETSCPDFSAMPLECONSTANT3D
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscpdfsampleconstant3d_ petscpdfsampleconstant3d
#endif
PETSC_EXTERN void petscpdfsampleconstant3d_(const PetscReal a[], const PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(a);
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PetscPDFSampleConstant3D(a, b, c);
  if (*ierr) return;
}
