#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmfield.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmfieldcreateda_ DMFIELDCREATEDA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmfieldcreateda_ dmfieldcreateda
#endif
PETSC_EXTERN void dmfieldcreateda_(DM *a, PetscInt *b, const PetscScalar *c, DMField *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLSCALAR(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMFieldCreateDA(*a, *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
