#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isgetpointsubrange_ ISGETPOINTSUBRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isgetpointsubrange_ isgetpointsubrange
#endif
PETSC_EXTERN void isgetpointsubrange_(IS *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  *ierr = ISGetPointSubrange(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isglobaltolocalmappingapply_ ISGLOBALTOLOCALMAPPINGAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isglobaltolocalmappingapply_ isglobaltolocalmappingapply
#endif
PETSC_EXTERN void isglobaltolocalmappingapply_(ISLocalToGlobalMapping *a, ISGlobalToLocalMappingMode *b, PetscInt *c, const PetscInt d[], PetscInt *e, PetscInt f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  *ierr = ISGlobalToLocalMappingApply(*a, *b, *c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isglobaltolocalmappingapplyis_ ISGLOBALTOLOCALMAPPINGAPPLYIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isglobaltolocalmappingapplyis_ isglobaltolocalmappingapplyis
#endif
PETSC_EXTERN void isglobaltolocalmappingapplyis_(ISLocalToGlobalMapping *a, ISGlobalToLocalMappingMode *b, IS *c, IS *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = ISGlobalToLocalMappingApplyIS(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isglobaltolocalmappingapplyblock_ ISGLOBALTOLOCALMAPPINGAPPLYBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isglobaltolocalmappingapplyblock_ isglobaltolocalmappingapplyblock
#endif
PETSC_EXTERN void isglobaltolocalmappingapplyblock_(ISLocalToGlobalMapping *a, ISGlobalToLocalMappingMode *b, PetscInt *c, const PetscInt d[], PetscInt *e, PetscInt f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  *ierr = ISGlobalToLocalMappingApplyBlock(*a, *b, *c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingduplicate_ ISLOCALTOGLOBALMAPPINGDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingduplicate_ islocaltoglobalmappingduplicate
#endif
PETSC_EXTERN void islocaltoglobalmappingduplicate_(ISLocalToGlobalMapping *a, ISLocalToGlobalMapping *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = ISLocalToGlobalMappingDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappinggetsize_ ISLOCALTOGLOBALMAPPINGGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappinggetsize_ islocaltoglobalmappinggetsize
#endif
PETSC_EXTERN void islocaltoglobalmappinggetsize_(ISLocalToGlobalMapping *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = ISLocalToGlobalMappingGetSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingviewfromoptions_ ISLOCALTOGLOBALMAPPINGVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingviewfromoptions_ islocaltoglobalmappingviewfromoptions
#endif
PETSC_EXTERN void islocaltoglobalmappingviewfromoptions_(ISLocalToGlobalMapping *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = ISLocalToGlobalMappingViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingview_ ISLOCALTOGLOBALMAPPINGVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingview_ islocaltoglobalmappingview
#endif
PETSC_EXTERN void islocaltoglobalmappingview_(ISLocalToGlobalMapping *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = ISLocalToGlobalMappingView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingload_ ISLOCALTOGLOBALMAPPINGLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingload_ islocaltoglobalmappingload
#endif
PETSC_EXTERN void islocaltoglobalmappingload_(ISLocalToGlobalMapping *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = ISLocalToGlobalMappingLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingcreateis_ ISLOCALTOGLOBALMAPPINGCREATEIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingcreateis_ islocaltoglobalmappingcreateis
#endif
PETSC_EXTERN void islocaltoglobalmappingcreateis_(IS *a, ISLocalToGlobalMapping *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = ISLocalToGlobalMappingCreateIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingcreatesf_ ISLOCALTOGLOBALMAPPINGCREATESF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingcreatesf_ islocaltoglobalmappingcreatesf
#endif
PETSC_EXTERN void islocaltoglobalmappingcreatesf_(PetscSF *a, PetscInt *b, ISLocalToGlobalMapping *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = ISLocalToGlobalMappingCreateSF(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingsetblocksize_ ISLOCALTOGLOBALMAPPINGSETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingsetblocksize_ islocaltoglobalmappingsetblocksize
#endif
PETSC_EXTERN void islocaltoglobalmappingsetblocksize_(ISLocalToGlobalMapping *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = ISLocalToGlobalMappingSetBlockSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappinggetblocksize_ ISLOCALTOGLOBALMAPPINGGETBLOCKSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappinggetblocksize_ islocaltoglobalmappinggetblocksize
#endif
PETSC_EXTERN void islocaltoglobalmappinggetblocksize_(ISLocalToGlobalMapping *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = ISLocalToGlobalMappingGetBlockSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingcreate_ ISLOCALTOGLOBALMAPPINGCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingcreate_ islocaltoglobalmappingcreate
#endif
PETSC_EXTERN void islocaltoglobalmappingcreate_(MPI_Fint *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscCopyMode *e, ISLocalToGlobalMapping *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(f);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLOBJECT(f);
  *ierr = ISLocalToGlobalMappingCreate(MPI_Comm_f2c(*(a)), *b, *c, d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingsetfromoptions_ ISLOCALTOGLOBALMAPPINGSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingsetfromoptions_ islocaltoglobalmappingsetfromoptions
#endif
PETSC_EXTERN void islocaltoglobalmappingsetfromoptions_(ISLocalToGlobalMapping *a, PetscErrorCode *ierr)
{
  *ierr = ISLocalToGlobalMappingSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingdestroy_ ISLOCALTOGLOBALMAPPINGDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingdestroy_ islocaltoglobalmappingdestroy
#endif
PETSC_EXTERN void islocaltoglobalmappingdestroy_(ISLocalToGlobalMapping *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = ISLocalToGlobalMappingDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingapplyis_ ISLOCALTOGLOBALMAPPINGAPPLYIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingapplyis_ islocaltoglobalmappingapplyis
#endif
PETSC_EXTERN void islocaltoglobalmappingapplyis_(ISLocalToGlobalMapping *a, IS *b, IS *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = ISLocalToGlobalMappingApplyIS(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingapply_ ISLOCALTOGLOBALMAPPINGAPPLY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingapply_ islocaltoglobalmappingapply
#endif
PETSC_EXTERN void islocaltoglobalmappingapply_(ISLocalToGlobalMapping *a, PetscInt *b, const PetscInt c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = ISLocalToGlobalMappingApply(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingapplyblock_ ISLOCALTOGLOBALMAPPINGAPPLYBLOCK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingapplyblock_ islocaltoglobalmappingapplyblock
#endif
PETSC_EXTERN void islocaltoglobalmappingapplyblock_(ISLocalToGlobalMapping *a, PetscInt *b, const PetscInt c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = ISLocalToGlobalMappingApplyBlock(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappinggetblockmultileavessf_ ISLOCALTOGLOBALMAPPINGGETBLOCKMULTILEAVESSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappinggetblockmultileavessf_ islocaltoglobalmappinggetblockmultileavessf
#endif
PETSC_EXTERN void islocaltoglobalmappinggetblockmultileavessf_(ISLocalToGlobalMapping *a, PetscSF *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = ISLocalToGlobalMappingGetBlockMultiLeavesSF(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingconcatenate_ ISLOCALTOGLOBALMAPPINGCONCATENATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingconcatenate_ islocaltoglobalmappingconcatenate
#endif
PETSC_EXTERN void islocaltoglobalmappingconcatenate_(MPI_Fint *a, PetscInt *b, const ISLocalToGlobalMapping c[], ISLocalToGlobalMapping *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = ISLocalToGlobalMappingConcatenate(MPI_Comm_f2c(*(a)), *b, c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingsettype_ ISLOCALTOGLOBALMAPPINGSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingsettype_ islocaltoglobalmappingsettype
#endif
PETSC_EXTERN void islocaltoglobalmappingsettype_(ISLocalToGlobalMapping *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = ISLocalToGlobalMappingSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappinggettype_ ISLOCALTOGLOBALMAPPINGGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappinggettype_ islocaltoglobalmappinggettype
#endif
PETSC_EXTERN void islocaltoglobalmappinggettype_(ISLocalToGlobalMapping *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = ISLocalToGlobalMappingGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define islocaltoglobalmappingregisterall_ ISLOCALTOGLOBALMAPPINGREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define islocaltoglobalmappingregisterall_ islocaltoglobalmappingregisterall
#endif
PETSC_EXTERN void islocaltoglobalmappingregisterall_(PetscErrorCode *ierr)
{
  *ierr = ISLocalToGlobalMappingRegisterAll();
  if (*ierr) return;
}
