#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgetrealpath_ PETSCGETREALPATH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgetrealpath_ petscgetrealpath
#endif
PETSC_EXTERN void petscgetrealpath_(char a[], char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscGetRealPath(c_a, b);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
