#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isstridegetinfo_ ISSTRIDEGETINFO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isstridegetinfo_ isstridegetinfo
#endif
PETSC_EXTERN void isstridegetinfo_(IS *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = ISStrideGetInfo(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define isstridesetstride_ ISSTRIDESETSTRIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define isstridesetstride_ isstridesetstride
#endif
PETSC_EXTERN void isstridesetstride_(IS *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  *ierr = ISStrideSetStride(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscis.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define iscreatestride_ ISCREATESTRIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define iscreatestride_ iscreatestride
#endif
PETSC_EXTERN void iscreatestride_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, IS *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = ISCreateStride(MPI_Comm_f2c(*(a)), *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
