#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreate_ MATCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreate_ matcreate
#endif
PETSC_EXTERN void matcreate_(MPI_Fint *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatefromoptions_ MATCREATEFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatefromoptions_ matcreatefromoptions
#endif
PETSC_EXTERN void matcreatefromoptions_(MPI_Fint *a, char b[], PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, Mat *h, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(h);
  *ierr = MatCreateFromOptions(MPI_Comm_f2c(*(a)), c_b, *c, *d, *e, *f, *g, h);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matseterroriffailure_ MATSETERRORIFFAILURE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matseterroriffailure_ matseterroriffailure
#endif
PETSC_EXTERN void matseterroriffailure_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatSetErrorIfFailure(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetsizes_ MATSETSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetsizes_ matsetsizes
#endif
PETSC_EXTERN void matsetsizes_(Mat *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  *ierr = MatSetSizes(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetfromoptions_ MATSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetfromoptions_ matsetfromoptions
#endif
PETSC_EXTERN void matsetfromoptions_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matxaijsetpreallocation_ MATXAIJSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matxaijsetpreallocation_ matxaijsetpreallocation
#endif
PETSC_EXTERN void matxaijsetpreallocation_(Mat *a, PetscInt *b, const PetscInt c[], const PetscInt d[], const PetscInt e[], const PetscInt f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  *ierr = MatXAIJSetPreallocation(*a, *b, c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matheadermerge_ MATHEADERMERGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matheadermerge_ matheadermerge
#endif
PETSC_EXTERN void matheadermerge_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatHeaderMerge(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matheaderreplace_ MATHEADERREPLACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matheaderreplace_ matheaderreplace
#endif
PETSC_EXTERN void matheaderreplace_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatHeaderReplace(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matbindtocpu_ MATBINDTOCPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matbindtocpu_ matbindtocpu
#endif
PETSC_EXTERN void matbindtocpu_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatBindToCPU(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matboundtocpu_ MATBOUNDTOCPU
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matboundtocpu_ matboundtocpu
#endif
PETSC_EXTERN void matboundtocpu_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatBoundToCPU(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetpreallocationcoo_ MATSETPREALLOCATIONCOO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetpreallocationcoo_ matsetpreallocationcoo
#endif
PETSC_EXTERN void matsetpreallocationcoo_(Mat *a, PetscCount *b, PetscInt c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = MatSetPreallocationCOO(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetpreallocationcoolocal_ MATSETPREALLOCATIONCOOLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetpreallocationcoolocal_ matsetpreallocationcoolocal
#endif
PETSC_EXTERN void matsetpreallocationcoolocal_(Mat *a, PetscCount *b, PetscInt c[], PetscInt d[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = MatSetPreallocationCOOLocal(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetvaluescoo_ MATSETVALUESCOO
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetvaluescoo_ matsetvaluescoo
#endif
PETSC_EXTERN void matsetvaluescoo_(Mat *a, const PetscScalar b[], InsertMode *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatSetValuesCOO(*a, b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matsetbindingpropagates_ MATSETBINDINGPROPAGATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matsetbindingpropagates_ matsetbindingpropagates
#endif
PETSC_EXTERN void matsetbindingpropagates_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = MatSetBindingPropagates(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matgetbindingpropagates_ MATGETBINDINGPROPAGATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matgetbindingpropagates_ matgetbindingpropagates
#endif
PETSC_EXTERN void matgetbindingpropagates_(Mat *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = MatGetBindingPropagates(*a, b);
  if (*ierr) return;
}
