  type tDMInterpolationInfo
    PetscFortranAddr:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type tDMInterpolationInfo
  DMInterpolationInfo, parameter :: PETSC_NULL_DMINTERPOLATIONINFO = tDMInterpolationInfo(0)
  DMInterpolationInfo, target :: PETSC_NULL_DMINTERPOLATIONINFO_ARRAY(1) = [tDMInterpolationInfo(0)]
  DMInterpolationInfo, pointer :: PETSC_NULL_DMINTERPOLATIONINFO_POINTER(:) => PETSC_NULL_DMINTERPOLATIONINFO_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMINTERPOLATIONINFO
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMINTERPOLATIONINFO_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMINTERPOLATIONINFO_POINTER
#endif

  type, extends(tPetscObject) ::  tDM
  end type tDM
  DM, parameter :: PETSC_NULL_DM = tDM(0)
  DM, target :: PETSC_NULL_DM_ARRAY(1) = [tDM(0)]
  DM, pointer :: PETSC_NULL_DM_POINTER(:) => PETSC_NULL_DM_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DM
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DM_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DM_POINTER
#endif

  type, extends(tPetscObject) ::  tDMField
  end type tDMField
  DMField, parameter :: PETSC_NULL_DMFIELD = tDMField(0)
  DMField, target :: PETSC_NULL_DMFIELD_ARRAY(1) = [tDMField(0)]
  DMField, pointer :: PETSC_NULL_DMFIELD_POINTER(:) => PETSC_NULL_DMFIELD_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMFIELD
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMFIELD_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMFIELD_POINTER
#endif

  type, extends(tPetscObject) ::  tDMUniversalLabel
  end type tDMUniversalLabel
  DMUniversalLabel, parameter :: PETSC_NULL_DMUNIVERSALLABEL = tDMUniversalLabel(0)
  DMUniversalLabel, target :: PETSC_NULL_DMUNIVERSALLABEL_ARRAY(1) = [tDMUniversalLabel(0)]
  DMUniversalLabel, pointer :: PETSC_NULL_DMUNIVERSALLABEL_POINTER(:) => PETSC_NULL_DMUNIVERSALLABEL_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMUNIVERSALLABEL
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMUNIVERSALLABEL_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMUNIVERSALLABEL_POINTER
#endif

  type tDMGeneratorFunctionList
    PetscFortranAddr:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type tDMGeneratorFunctionList
  DMGeneratorFunctionList, parameter :: PETSC_NULL_DMGENERATORFUNCTIONLIST = tDMGeneratorFunctionList(0)
  DMGeneratorFunctionList, target :: PETSC_NULL_DMGENERATORFUNCTIONLIST_ARRAY(1) = [tDMGeneratorFunctionList(0)]
  DMGeneratorFunctionList, pointer :: PETSC_NULL_DMGENERATORFUNCTIONLIST_POINTER(:) => PETSC_NULL_DMGENERATORFUNCTIONLIST_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMGENERATORFUNCTIONLIST
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMGENERATORFUNCTIONLIST_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMGENERATORFUNCTIONLIST_POINTER
#endif

  type eDMCopyLabelsMode
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMCopyLabelsMode

  DMCopyLabelsMode, parameter :: PETSC_NULL_DMCOPYLABELSMODE = eDMCopyLabelsMode(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMCOPYLABELSMODE
#endif
    DMCopyLabelsMode, parameter :: DM_COPY_LABELS_REPLACE = eDMCopyLabelsMode(0)
    DMCopyLabelsMode, parameter :: DM_COPY_LABELS_KEEP = eDMCopyLabelsMode(1)
    DMCopyLabelsMode, parameter :: DM_COPY_LABELS_FAIL = eDMCopyLabelsMode(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_COPY_LABELS_REPLACE
!DEC$ ATTRIBUTES DLLEXPORT::DM_COPY_LABELS_KEEP
!DEC$ ATTRIBUTES DLLEXPORT::DM_COPY_LABELS_FAIL
#endif

  type eDMBoundaryType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMBoundaryType

  DMBoundaryType, parameter :: PETSC_NULL_DMBOUNDARYTYPE = eDMBoundaryType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMBOUNDARYTYPE
#endif
    DMBoundaryType, parameter :: DM_BOUNDARY_NONE = eDMBoundaryType(0)
    DMBoundaryType, parameter :: DM_BOUNDARY_GHOSTED = eDMBoundaryType(1)
    DMBoundaryType, parameter :: DM_BOUNDARY_MIRROR = eDMBoundaryType(2)
    DMBoundaryType, parameter :: DM_BOUNDARY_PERIODIC = eDMBoundaryType(3)
    DMBoundaryType, parameter :: DM_BOUNDARY_TWIST = eDMBoundaryType(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_BOUNDARY_NONE
!DEC$ ATTRIBUTES DLLEXPORT::DM_BOUNDARY_GHOSTED
!DEC$ ATTRIBUTES DLLEXPORT::DM_BOUNDARY_MIRROR
!DEC$ ATTRIBUTES DLLEXPORT::DM_BOUNDARY_PERIODIC
!DEC$ ATTRIBUTES DLLEXPORT::DM_BOUNDARY_TWIST
#endif

  type eDMBoundaryConditionType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMBoundaryConditionType

  DMBoundaryConditionType, parameter :: PETSC_NULL_DMBOUNDARYCONDITIONTYPE = eDMBoundaryConditionType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMBOUNDARYCONDITIONTYPE
#endif
    DMBoundaryConditionType, parameter :: DM_BC_ESSENTIAL = eDMBoundaryConditionType(1)
    DMBoundaryConditionType, parameter :: DM_BC_ESSENTIAL_FIELD = eDMBoundaryConditionType(5)
    DMBoundaryConditionType, parameter :: DM_BC_NATURAL = eDMBoundaryConditionType(2)
    DMBoundaryConditionType, parameter :: DM_BC_NATURAL_FIELD = eDMBoundaryConditionType(6)
    DMBoundaryConditionType, parameter :: DM_BC_ESSENTIAL_BD_FIELD = eDMBoundaryConditionType(9)
    DMBoundaryConditionType, parameter :: DM_BC_NATURAL_RIEMANN = eDMBoundaryConditionType(10)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_BC_ESSENTIAL 
!DEC$ ATTRIBUTES DLLEXPORT::DM_BC_ESSENTIAL_FIELD 
!DEC$ ATTRIBUTES DLLEXPORT::DM_BC_NATURAL 
!DEC$ ATTRIBUTES DLLEXPORT::DM_BC_NATURAL_FIELD 
!DEC$ ATTRIBUTES DLLEXPORT::DM_BC_ESSENTIAL_BD_FIELD 
!DEC$ ATTRIBUTES DLLEXPORT::DM_BC_NATURAL_RIEMANN 
#endif

  type eDMPointLocationType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMPointLocationType

  DMPointLocationType, parameter :: PETSC_NULL_DMPOINTLOCATIONTYPE = eDMPointLocationType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMPOINTLOCATIONTYPE
#endif
    DMPointLocationType, parameter :: DM_POINTLOCATION_NONE = eDMPointLocationType(0)
    DMPointLocationType, parameter :: DM_POINTLOCATION_NEAREST = eDMPointLocationType(1)
    DMPointLocationType, parameter :: DM_POINTLOCATION_REMOVE = eDMPointLocationType(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_POINTLOCATION_NONE
!DEC$ ATTRIBUTES DLLEXPORT::DM_POINTLOCATION_NEAREST
!DEC$ ATTRIBUTES DLLEXPORT::DM_POINTLOCATION_REMOVE
#endif

  type eDMBlockingType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMBlockingType

  DMBlockingType, parameter :: PETSC_NULL_DMBLOCKINGTYPE = eDMBlockingType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMBLOCKINGTYPE
#endif
    DMBlockingType, parameter :: DM_BLOCKING_TOPOLOGICAL_POINT = eDMBlockingType(0)
    DMBlockingType, parameter :: DM_BLOCKING_FIELD_NODE = eDMBlockingType(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_BLOCKING_TOPOLOGICAL_POINT
!DEC$ ATTRIBUTES DLLEXPORT::DM_BLOCKING_FIELD_NODE
#endif

  type eDMAdaptationStrategy
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMAdaptationStrategy

  DMAdaptationStrategy, parameter :: PETSC_NULL_DMADAPTATIONSTRATEGY = eDMAdaptationStrategy(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMADAPTATIONSTRATEGY
#endif
    DMAdaptationStrategy, parameter :: DM_ADAPTATION_INITIAL = eDMAdaptationStrategy(0)
    DMAdaptationStrategy, parameter :: DM_ADAPTATION_SEQUENTIAL = eDMAdaptationStrategy(1)
    DMAdaptationStrategy, parameter :: DM_ADAPTATION_MULTILEVEL = eDMAdaptationStrategy(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPTATION_INITIAL
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPTATION_SEQUENTIAL
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPTATION_MULTILEVEL
#endif

  type eDMAdaptationCriterion
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMAdaptationCriterion

  DMAdaptationCriterion, parameter :: PETSC_NULL_DMADAPTATIONCRITERION = eDMAdaptationCriterion(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMADAPTATIONCRITERION
#endif
    DMAdaptationCriterion, parameter :: DM_ADAPTATION_NONE = eDMAdaptationCriterion(0)
    DMAdaptationCriterion, parameter :: DM_ADAPTATION_REFINE = eDMAdaptationCriterion(1)
    DMAdaptationCriterion, parameter :: DM_ADAPTATION_LABEL = eDMAdaptationCriterion(2)
    DMAdaptationCriterion, parameter :: DM_ADAPTATION_METRIC = eDMAdaptationCriterion(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPTATION_NONE
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPTATION_REFINE
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPTATION_LABEL
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPTATION_METRIC
#endif

  type eDMAdaptFlag
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMAdaptFlag

  DMAdaptFlag, parameter :: PETSC_NULL_DMADAPTFLAG = eDMAdaptFlag(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMADAPTFLAG
#endif
    DMAdaptFlag, parameter :: DM_ADAPT_DETERMINE = eDMAdaptFlag(PETSC_DETERMINE)
    DMAdaptFlag, parameter :: DM_ADAPT_KEEP = eDMAdaptFlag(0)
    DMAdaptFlag, parameter :: DM_ADAPT_REFINE = eDMAdaptFlag(1)
    DMAdaptFlag, parameter :: DM_ADAPT_COARSEN = eDMAdaptFlag(2)
    DMAdaptFlag, parameter :: DM_ADAPT_COARSEN_LAST = eDMAdaptFlag(3)
    DMAdaptFlag, parameter :: DM_ADAPT_RESERVED_COUNT = eDMAdaptFlag(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPT_DETERMINE 
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPT_KEEP 
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPT_REFINE 
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPT_COARSEN 
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPT_COARSEN_LAST 
!DEC$ ATTRIBUTES DLLEXPORT::DM_ADAPT_RESERVED_COUNT 
#endif

  type eDMDirection
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMDirection

  DMDirection, parameter :: PETSC_NULL_DMDIRECTION = eDMDirection(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMDIRECTION
#endif
    DMDirection, parameter :: DM_X = eDMDirection(0)
    DMDirection, parameter :: DM_Y = eDMDirection(1)
    DMDirection, parameter :: DM_Z = eDMDirection(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_X
!DEC$ ATTRIBUTES DLLEXPORT::DM_Y
!DEC$ ATTRIBUTES DLLEXPORT::DM_Z
#endif

  type eDMEnclosureType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMEnclosureType

  DMEnclosureType, parameter :: PETSC_NULL_DMENCLOSURETYPE = eDMEnclosureType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMENCLOSURETYPE
#endif
    DMEnclosureType, parameter :: DM_ENC_EQUALITY = eDMEnclosureType(0)
    DMEnclosureType, parameter :: DM_ENC_SUPERMESH = eDMEnclosureType(1)
    DMEnclosureType, parameter :: DM_ENC_SUBMESH = eDMEnclosureType(2)
    DMEnclosureType, parameter :: DM_ENC_NONE = eDMEnclosureType(3)
    DMEnclosureType, parameter :: DM_ENC_UNKNOWN = eDMEnclosureType(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_ENC_EQUALITY
!DEC$ ATTRIBUTES DLLEXPORT::DM_ENC_SUPERMESH
!DEC$ ATTRIBUTES DLLEXPORT::DM_ENC_SUBMESH
!DEC$ ATTRIBUTES DLLEXPORT::DM_ENC_NONE
!DEC$ ATTRIBUTES DLLEXPORT::DM_ENC_UNKNOWN
#endif

  type eDMPolytopeType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMPolytopeType

  DMPolytopeType, parameter :: PETSC_NULL_DMPOLYTOPETYPE = eDMPolytopeType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMPOLYTOPETYPE
#endif
    DMPolytopeType, parameter :: DM_POLYTOPE_POINT = eDMPolytopeType(0)
    DMPolytopeType, parameter :: DM_POLYTOPE_SEGMENT = eDMPolytopeType(1)
    DMPolytopeType, parameter :: DM_POLYTOPE_POINT_PRISM_TENSOR = eDMPolytopeType(2)
    DMPolytopeType, parameter :: DM_POLYTOPE_TRIANGLE = eDMPolytopeType(3)
    DMPolytopeType, parameter :: DM_POLYTOPE_QUADRILATERAL = eDMPolytopeType(4)
    DMPolytopeType, parameter :: DM_POLYTOPE_SEG_PRISM_TENSOR = eDMPolytopeType(5)
    DMPolytopeType, parameter :: DM_POLYTOPE_TETRAHEDRON = eDMPolytopeType(6)
    DMPolytopeType, parameter :: DM_POLYTOPE_HEXAHEDRON = eDMPolytopeType(7)
    DMPolytopeType, parameter :: DM_POLYTOPE_TRI_PRISM = eDMPolytopeType(8)
    DMPolytopeType, parameter :: DM_POLYTOPE_TRI_PRISM_TENSOR = eDMPolytopeType(9)
    DMPolytopeType, parameter :: DM_POLYTOPE_QUAD_PRISM_TENSOR = eDMPolytopeType(10)
    DMPolytopeType, parameter :: DM_POLYTOPE_PYRAMID = eDMPolytopeType(11)
    DMPolytopeType, parameter :: DM_POLYTOPE_FV_GHOST = eDMPolytopeType(12)
    DMPolytopeType, parameter :: DM_POLYTOPE_INTERIOR_GHOST = eDMPolytopeType(13)
    DMPolytopeType, parameter :: DM_POLYTOPE_UNKNOWN = eDMPolytopeType(14)
    DMPolytopeType, parameter :: DM_POLYTOPE_UNKNOWN_CELL = eDMPolytopeType(15)
    DMPolytopeType, parameter :: DM_POLYTOPE_UNKNOWN_FACE = eDMPolytopeType(16)
    DMPolytopeType, parameter :: DM_NUM_POLYTOPES = eDMPolytopeType(17)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_POINT
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_SEGMENT
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_POINT_PRISM_TENSOR
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_TRIANGLE
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_QUADRILATERAL
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_SEG_PRISM_TENSOR
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_TETRAHEDRON
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_HEXAHEDRON
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_TRI_PRISM
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_TRI_PRISM_TENSOR
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_QUAD_PRISM_TENSOR
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_PYRAMID
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_FV_GHOST
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_INTERIOR_GHOST
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_UNKNOWN
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_UNKNOWN_CELL
!DEC$ ATTRIBUTES DLLEXPORT::DM_POLYTOPE_UNKNOWN_FACE
!DEC$ ATTRIBUTES DLLEXPORT::DM_NUM_POLYTOPES
#endif

  type ePetscUnit
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type ePetscUnit

  PetscUnit, parameter :: PETSC_NULL_UNIT = ePetscUnit(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_UNIT
#endif
    PetscUnit, parameter :: PETSC_UNIT_LENGTH = ePetscUnit(0)
    PetscUnit, parameter :: PETSC_UNIT_MASS = ePetscUnit(1)
    PetscUnit, parameter :: PETSC_UNIT_TIME = ePetscUnit(2)
    PetscUnit, parameter :: PETSC_UNIT_CURRENT = ePetscUnit(3)
    PetscUnit, parameter :: PETSC_UNIT_TEMPERATURE = ePetscUnit(4)
    PetscUnit, parameter :: PETSC_UNIT_AMOUNT = ePetscUnit(5)
    PetscUnit, parameter :: PETSC_UNIT_LUMINOSITY = ePetscUnit(6)
    PetscUnit, parameter :: NUM_PETSC_UNITS = ePetscUnit(7)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_UNIT_LENGTH
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_UNIT_MASS
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_UNIT_TIME
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_UNIT_CURRENT
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_UNIT_TEMPERATURE
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_UNIT_AMOUNT
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_UNIT_LUMINOSITY
!DEC$ ATTRIBUTES DLLEXPORT::NUM_PETSC_UNITS
#endif

  type eDMReorderDefaultFlag
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eDMReorderDefaultFlag

  DMReorderDefaultFlag, parameter :: PETSC_NULL_DMREORDERDEFAULTFLAG = eDMReorderDefaultFlag(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_DMREORDERDEFAULTFLAG
#endif
    DMReorderDefaultFlag, parameter :: DM_REORDER_DEFAULT_NOTSET = eDMReorderDefaultFlag(-1)
    DMReorderDefaultFlag, parameter :: DM_REORDER_DEFAULT_FALSE = eDMReorderDefaultFlag(0)
    DMReorderDefaultFlag, parameter :: DM_REORDER_DEFAULT_TRUE = eDMReorderDefaultFlag(1)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DM_REORDER_DEFAULT_NOTSET 
!DEC$ ATTRIBUTES DLLEXPORT::DM_REORDER_DEFAULT_FALSE 
!DEC$ ATTRIBUTES DLLEXPORT::DM_REORDER_DEFAULT_TRUE 
#endif

  CHARACTER(LEN=*), PARAMETER :: DMDA = 'da'
  CHARACTER(LEN=*), PARAMETER :: DMCOMPOSITE = 'composite'
  CHARACTER(LEN=*), PARAMETER :: DMSLICED = 'sliced'
  CHARACTER(LEN=*), PARAMETER :: DMSHELL = 'shell'
  CHARACTER(LEN=*), PARAMETER :: DMPLEX = 'plex'
  CHARACTER(LEN=*), PARAMETER :: DMREDUNDANT = 'redundant'
  CHARACTER(LEN=*), PARAMETER :: DMPATCH = 'patch'
  CHARACTER(LEN=*), PARAMETER :: DMMOAB = 'moab'
  CHARACTER(LEN=*), PARAMETER :: DMNETWORK = 'network'
  CHARACTER(LEN=*), PARAMETER :: DMFOREST = 'forest'
  CHARACTER(LEN=*), PARAMETER :: DMP4EST = 'p4est'
  CHARACTER(LEN=*), PARAMETER :: DMP8EST = 'p8est'
  CHARACTER(LEN=*), PARAMETER :: DMSWARM = 'swarm'
  CHARACTER(LEN=*), PARAMETER :: DMPRODUCT = 'product'
  CHARACTER(LEN=*), PARAMETER :: DMSTAG = 'stag'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::DMDA
!DEC$ ATTRIBUTES DLLEXPORT::DMCOMPOSITE
!DEC$ ATTRIBUTES DLLEXPORT::DMSLICED
!DEC$ ATTRIBUTES DLLEXPORT::DMSHELL
!DEC$ ATTRIBUTES DLLEXPORT::DMPLEX
!DEC$ ATTRIBUTES DLLEXPORT::DMREDUNDANT
!DEC$ ATTRIBUTES DLLEXPORT::DMPATCH
!DEC$ ATTRIBUTES DLLEXPORT::DMMOAB
!DEC$ ATTRIBUTES DLLEXPORT::DMNETWORK
!DEC$ ATTRIBUTES DLLEXPORT::DMFOREST
!DEC$ ATTRIBUTES DLLEXPORT::DMP4EST
!DEC$ ATTRIBUTES DLLEXPORT::DMP8EST
!DEC$ ATTRIBUTES DLLEXPORT::DMSWARM
!DEC$ ATTRIBUTES DLLEXPORT::DMPRODUCT
!DEC$ ATTRIBUTES DLLEXPORT::DMSTAG
#endif

