#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetpointlocal_ DMPLEXGETPOINTLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetpointlocal_ dmplexgetpointlocal
#endif
PETSC_EXTERN void dmplexgetpointlocal_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexGetPointLocal(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointlocalread_ DMPLEXPOINTLOCALREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointlocalread_ dmplexpointlocalread
#endif
PETSC_EXTERN void dmplexpointlocalread_(DM *a, PetscInt *b, const PetscScalar *c, void *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = DMPlexPointLocalRead(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointlocalref_ DMPLEXPOINTLOCALREF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointlocalref_ dmplexpointlocalref
#endif
PETSC_EXTERN void dmplexpointlocalref_(DM *a, PetscInt *b, PetscScalar *c, void *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = DMPlexPointLocalRef(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetpointlocalfield_ DMPLEXGETPOINTLOCALFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetpointlocalfield_ dmplexgetpointlocalfield
#endif
PETSC_EXTERN void dmplexgetpointlocalfield_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMPlexGetPointLocalField(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointlocalfieldread_ DMPLEXPOINTLOCALFIELDREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointlocalfieldread_ dmplexpointlocalfieldread
#endif
PETSC_EXTERN void dmplexpointlocalfieldread_(DM *a, PetscInt *b, PetscInt *c, const PetscScalar *d, void *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = DMPlexPointLocalFieldRead(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointlocalfieldref_ DMPLEXPOINTLOCALFIELDREF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointlocalfieldref_ dmplexpointlocalfieldref
#endif
PETSC_EXTERN void dmplexpointlocalfieldref_(DM *a, PetscInt *b, PetscInt *c, PetscScalar *d, void *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = DMPlexPointLocalFieldRef(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetpointglobal_ DMPLEXGETPOINTGLOBAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetpointglobal_ dmplexgetpointglobal
#endif
PETSC_EXTERN void dmplexgetpointglobal_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMPlexGetPointGlobal(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointglobalread_ DMPLEXPOINTGLOBALREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointglobalread_ dmplexpointglobalread
#endif
PETSC_EXTERN void dmplexpointglobalread_(DM *a, PetscInt *b, const PetscScalar *c, const void *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = DMPlexPointGlobalRead(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointglobalref_ DMPLEXPOINTGLOBALREF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointglobalref_ dmplexpointglobalref
#endif
PETSC_EXTERN void dmplexpointglobalref_(DM *a, PetscInt *b, PetscScalar *c, void *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(c);
  *ierr = DMPlexPointGlobalRef(*a, *b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetpointglobalfield_ DMPLEXGETPOINTGLOBALFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetpointglobalfield_ dmplexgetpointglobalfield
#endif
PETSC_EXTERN void dmplexgetpointglobalfield_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(e);
  *ierr = DMPlexGetPointGlobalField(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointglobalfieldread_ DMPLEXPOINTGLOBALFIELDREAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointglobalfieldread_ dmplexpointglobalfieldread
#endif
PETSC_EXTERN void dmplexpointglobalfieldread_(DM *a, PetscInt *b, PetscInt *c, const PetscScalar *d, void *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = DMPlexPointGlobalFieldRead(*a, *b, *c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexpointglobalfieldref_ DMPLEXPOINTGLOBALFIELDREF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexpointglobalfieldref_ dmplexpointglobalfieldref
#endif
PETSC_EXTERN void dmplexpointglobalfieldref_(DM *a, PetscInt *b, PetscInt *c, PetscScalar *d, void *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(d);
  *ierr = DMPlexPointGlobalFieldRef(*a, *b, *c, d, e);
  if (*ierr) return;
}
