#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetvariablebounds_ TAOSETVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetvariablebounds_ taosetvariablebounds
#endif
PETSC_EXTERN void taosetvariablebounds_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoSetVariableBounds(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetvariablebounds_ TAOGETVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetvariablebounds_ taogetvariablebounds
#endif
PETSC_EXTERN void taogetvariablebounds_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TaoGetVariableBounds(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputevariablebounds_ TAOCOMPUTEVARIABLEBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputevariablebounds_ taocomputevariablebounds
#endif
PETSC_EXTERN void taocomputevariablebounds_(Tao *a, PetscErrorCode *ierr)
{
  *ierr = TaoComputeVariableBounds(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taosetinequalitybounds_ TAOSETINEQUALITYBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taosetinequalitybounds_ taosetinequalitybounds
#endif
PETSC_EXTERN void taosetinequalitybounds_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoSetInequalityBounds(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetinequalitybounds_ TAOGETINEQUALITYBOUNDS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetinequalitybounds_ taogetinequalitybounds
#endif
PETSC_EXTERN void taogetinequalitybounds_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TaoGetInequalityBounds(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputeconstraints_ TAOCOMPUTECONSTRAINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputeconstraints_ taocomputeconstraints
#endif
PETSC_EXTERN void taocomputeconstraints_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoComputeConstraints(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputedualvariables_ TAOCOMPUTEDUALVARIABLES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputedualvariables_ taocomputedualvariables
#endif
PETSC_EXTERN void taocomputedualvariables_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoComputeDualVariables(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taogetdualvariables_ TAOGETDUALVARIABLES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taogetdualvariables_ taogetdualvariables
#endif
PETSC_EXTERN void taogetdualvariables_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = TaoGetDualVariables(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputeequalityconstraints_ TAOCOMPUTEEQUALITYCONSTRAINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputeequalityconstraints_ taocomputeequalityconstraints
#endif
PETSC_EXTERN void taocomputeequalityconstraints_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoComputeEqualityConstraints(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petsctao.h>
#include <petsctao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define taocomputeinequalityconstraints_ TAOCOMPUTEINEQUALITYCONSTRAINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define taocomputeinequalityconstraints_ taocomputeinequalityconstraints
#endif
PETSC_EXTERN void taocomputeinequalityconstraints_(Tao *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = TaoComputeInequalityConstraints(*a, *b, *c);
  if (*ierr) return;
}
